/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.coroutine;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.coroutine.CoroutineBlock;
import org.jetbrains.kotlin.js.coroutine.CoroutineBodyTransformer;
import org.jetbrains.kotlin.js.coroutine.CoroutinePassesKt;
import org.jetbrains.kotlin.js.coroutine.CoroutineTransformationContext;
import org.jetbrains.kotlin.js.inline.clean.FunctionPostProcessor;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0002J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\nH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010 \u001a\u00020\nH\u0002J,\u0010\"\u001a\u00020\u00102\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\b\u0010$\u001a\u00020%H\u0002J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bJ\b\u0010'\u001a\u00020\u0010H\u0002J,\u0010(\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J\"\u0010.\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0002J\f\u0010/\u001a\u00020\u0010*\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineFunctionTransformer;", "", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "name", "", "(Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;Ljava/lang/String;)V", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "className", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "functionWithBody", "innerFunction", "localVariables", "", "generateContinuationConstructor", "", "context", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformationContext;", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "globalCatchBlockIndex", "", "survivingLocalVars", "", "generateCoroutineBody", "", "blocks", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "generateCoroutineInstantiation", "generateCoroutineMetadata", "constructorName", "generateCoroutinePrototype", "generateDoResume", "coroutineBlocks", "isTailCall", "", "transform", "transformSimple", "assignToField", "fieldName", "value", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "psiElement", "Lcom/intellij/psi/PsiElement;", "assignToPrototype", "collectAdditionalLocalVariables", "js.translator"})
public final class CoroutineFunctionTransformer {
    @NotNull
    private final JsFunction function;
    @Nullable
    private final JsFunction innerFunction;
    @NotNull
    private final JsFunction functionWithBody;
    @NotNull
    private final JsBlock body;
    @NotNull
    private final Set<JsName> localVariables;
    @NotNull
    private final JsName className;

    public CoroutineFunctionTransformer(@NotNull JsFunction function2, @Nullable String name) {
        Intrinsics.checkNotNullParameter(function2, "function");
        this.function = function2;
        HasMetadata hasMetadata = this.innerFunction = FunctionUtilsKt.getInnerFunction(this.function);
        this.functionWithBody = hasMetadata == null ? this.function : hasMetadata;
        hasMetadata = this.functionWithBody.getBody();
        Intrinsics.checkNotNullExpressionValue(hasMetadata, "functionWithBody.body");
        this.body = hasMetadata;
        Set set = SetsKt.plus(CollectUtilsKt.collectLocalVariables$default(this.function, false, 1, null), CollectUtilsKt.collectLocalVariables$default(this.functionWithBody, false, 1, null));
        Object object = this.functionWithBody.getParameters();
        Intrinsics.checkNotNullExpressionValue(object, "functionWithBody.parameters");
        hasMetadata = CollectionsKt.last(object).getName();
        Intrinsics.checkNotNullExpressionValue(hasMetadata, "functionWithBody.parameters.last().name");
        this.localVariables = CollectionsKt.toMutableSet((Iterable)SetsKt.minus(set, hasMetadata));
        object = name;
        hasMetadata = JsScope.declareTemporaryName(Intrinsics.stringPlus("Coroutine$", object == null ? "anonymous" : object));
        Intrinsics.checkNotNullExpressionValue(hasMetadata, "declareTemporaryName(\"Co\u2026$${name ?: \"anonymous\"}\")");
        this.className = hasMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JsStatement> transform() {
        Collection<JsName> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (this.isTailCall() && !MetadataProperties.getForceStateMachine(this.function)) {
            this.transformSimple();
            return CollectionsKt.emptyList();
        }
        JsFunctionScope jsFunctionScope = this.function.getScope();
        Intrinsics.checkNotNullExpressionValue(jsFunctionScope, "function.scope");
        CoroutineTransformationContext context2 = new CoroutineTransformationContext(jsFunctionScope, this.function);
        CoroutineBodyTransformer bodyTransformer = new CoroutineBodyTransformer(context2);
        bodyTransformer.preProcess(this.body);
        List<JsStatement> list2 = this.body.getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, "body.statements");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsStatement it = (JsStatement)element$iv;
            boolean bl = false;
            it.accept(bodyTransformer);
        }
        List<CoroutineBlock> coroutineBlocks = bodyTransformer.postProcess();
        int globalCatchBlockIndex = coroutineBlocks.indexOf(context2.getGlobalCatchBlock());
        Iterable $this$forEach$iv2 = coroutineBlocks;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CoroutineBlock it = (CoroutineBlock)element$iv;
            boolean bl = false;
            this.collectAdditionalLocalVariables(it.getJsBlock());
        }
        Iterable<JsParameter> $i$f$forEach22 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue($i$f$forEach22, "function.parameters");
        $i$f$forEach22 = $i$f$forEach22;
        Set<JsName> set = this.localVariables;
        List<CoroutineBlock> list3 = coroutineBlocks;
        boolean $i$f$map = false;
        void element$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsName jsName = it.getName();
            collection.add(jsName);
        }
        collection = (List)destination$iv$iv;
        Set<JsName> survivingLocalVars = CoroutinePassesKt.collectVariablesSurvivingBetweenBlocks(list3, set, CollectionsKt.toSet((Iterable)collection));
        Iterable $this$forEach$iv3 = coroutineBlocks;
        boolean $i$f$forEach3 = false;
        for (Object element$iv2 : $this$forEach$iv3) {
            CoroutineBlock it = (CoroutineBlock)element$iv2;
            boolean bl = false;
            CoroutinePassesKt.replaceLocalVariables(it.getJsBlock(), context2, survivingLocalVars);
        }
        List additionalStatements2 = new ArrayList();
        this.generateDoResume(coroutineBlocks, context2, additionalStatements2);
        this.generateContinuationConstructor(context2, additionalStatements2, globalCatchBlockIndex, survivingLocalVars);
        this.generateCoroutineInstantiation(context2);
        return additionalStatements2;
    }

    private final boolean isTailCall() {
        HashSet<JsExpression> suspendCalls = new HashSet<JsExpression>();
        this.body.accept(new RecursiveJsVisitor(suspendCalls){
            final /* synthetic */ HashSet<JsExpression> $suspendCalls;
            {
                this.$suspendCalls = $suspendCalls;
            }

            protected void visitElement(@NotNull JsNode node) {
                Intrinsics.checkNotNullParameter(node, "node");
                if (node instanceof JsExpression && MetadataProperties.isSuspend((JsExpression)node)) {
                    ((Collection)this.$suspendCalls).add(node);
                }
                super.visitElement(node);
            }
        });
        if (suspendCalls.isEmpty()) {
            return true;
        }
        this.body.accept(new RecursiveJsVisitor(this, suspendCalls){
            final /* synthetic */ CoroutineFunctionTransformer this$0;
            final /* synthetic */ HashSet<JsExpression> $suspendCalls;
            {
                this.this$0 = $receiver;
                this.$suspendCalls = $suspendCalls;
            }

            public void visitBlock(@NotNull JsBlock x) {
                Object object;
                JsReturn jsReturn;
                Intrinsics.checkNotNullParameter(x, "x");
                super.visitBlock(x);
                if (CoroutineFunctionTransformer.access$getBody$p(this.this$0).getStatements().size() < 2) {
                    return;
                }
                Pair<JsExpression, JsExpression> pair = CoroutineFunctionTransformer.access$getBody$p(this.this$0).getStatements();
                Intrinsics.checkNotNullExpressionValue(pair, "body.statements");
                JsStatement jsStatement = CollectionsKt.last(pair);
                JsReturn jsReturn2 = jsReturn = jsStatement instanceof JsReturn ? (JsReturn)jsStatement : null;
                if (jsReturn == null) {
                    return;
                }
                JsReturn lastStatement = jsReturn;
                if (!CoroutinePassesKt.isStateMachineResult(lastStatement.getExpression())) {
                    return;
                }
                Object object2 = object = CoroutineFunctionTransformer.access$getBody$p(this.this$0).getStatements();
                Intrinsics.checkNotNullExpressionValue(object, "body.statements");
                pair = object2.get(CollectionsKt.getLastIndex(object) - 1);
                JsStatement jsStatement2 = jsStatement = pair instanceof JsExpressionStatement ? (JsExpressionStatement)((Object)pair) : null;
                if (jsStatement == null) {
                    return;
                }
                JsStatement statementBeforeLast = jsStatement;
                pair = ((JsExpressionStatement)statementBeforeLast).getExpression();
                Intrinsics.checkNotNullExpressionValue(pair, "statementBeforeLast.expression");
                Pair<JsExpression, JsExpression> suspendExpression = pair;
                if (this.$suspendCalls.contains(suspendExpression)) {
                    pair = this.$suspendCalls;
                    pair.remove(suspendExpression);
                } else {
                    pair = JsAstUtils.decomposeAssignment((JsExpression)((Object)suspendExpression));
                    if (pair != null) {
                        object = pair;
                        HashSet<JsExpression> hashSet = this.$suspendCalls;
                        Object $dstr$lhs$rhs = object;
                        boolean bl = false;
                        JsExpression lhs = (JsExpression)((Pair)$dstr$lhs$rhs).component1();
                        JsExpression rhs = (JsExpression)((Pair)$dstr$lhs$rhs).component2();
                        if (hashSet.contains(rhs) && CoroutinePassesKt.isStateMachineResult(lhs)) {
                            Collection collection = hashSet;
                            collection.remove(rhs);
                        }
                    }
                }
            }
        });
        return suspendCalls.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final void transformSimple() {
        void $this$transformSimple_u24lambda_u2d4;
        List<JsParameter> list2 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "function.parameters");
        JsParameter continuationParam = CollectionsKt.last(list2);
        HasMetadata hasMetadata = JsScope.declareTemporaryName("$result");
        Intrinsics.checkNotNullExpressionValue(hasMetadata, "declareTemporaryName(\"\\$result\")");
        JsName resultVar = hasMetadata;
        Intrinsics.checkNotNullExpressionValue(continuationParam, "continuationParam");
        CoroutinePassesKt.replaceSpecialReferencesInSimpleFunction(this.body, continuationParam, resultVar);
        HasMetadata hasMetadata2 = hasMetadata = JsAstUtils.newVar(resultVar, null);
        int n = 0;
        List<JsStatement> list3 = this.body.getStatements();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue($this$transformSimple_u24lambda_u2d4, "");
        MetadataProperties.setSynthetic((HasMetadata)$this$transformSimple_u24lambda_u2d4, true);
        Unit unit2 = Unit.INSTANCE;
        list3.add(n, (JsStatement)((Object)hasMetadata));
        new JsVisitorWithContextImpl(resultVar){
            final /* synthetic */ JsName $resultVar;
            {
                this.$resultVar = $resultVar;
            }

            public void endVisit(@NotNull JsExpressionStatement x, @NotNull JsContext<? super JsStatement> ctx2) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx2, "ctx");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "x.expression");
                if (MetadataProperties.isSuspend(jsExpression)) {
                    ctx2.replaceMe((JsNode)JsAstUtils.assignment(JsAstUtils.pureFqn(this.$resultVar, null), x.getExpression()).source(x.getSource()).makeStmt());
                }
                super.endVisit(x, ctx2);
            }
        }.accept((JsNode)this.body);
        new FunctionPostProcessor(this.functionWithBody).apply();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateContinuationConstructor(CoroutineTransformationContext context2, List<JsStatement> statements2, int globalCatchBlockIndex, Set<? extends JsName> survivingLocalVars) {
        List<JsParameter> $i$f$map32;
        Object object;
        Iterable $this$mapTo$iv$iv;
        JsName jsName;
        JsName lastParameter;
        HasMetadata hasMetadata;
        Object object2;
        void $this$mapTo$iv$iv2;
        JsName $this$map$iv;
        PsiElement psiElement = context2.getMetadata().getPsiElement();
        JsFunction constructor2 = new JsFunction(this.function.getScope().getParent(), new JsBlock(), "Continuation");
        constructor2.setSource(psiElement);
        Object object3 = psiElement;
        Object object4 = object3 == null ? null : UtilsKt.getFinalElement((PsiElement)object3);
        constructor2.getBody().setSource(object4 instanceof LeafPsiElement ? (LeafPsiElement)object4 : null);
        constructor2.setName(this.className);
        if (context2.getMetadata().getHasReceiver()) {
            object4 = constructor2;
            object3 = ((JsFunction)object4).getParameters();
            Intrinsics.checkNotNullExpressionValue(object3, "constructor.parameters");
            ((Collection)object3).add(new JsParameter(context2.getReceiverFieldName()));
        }
        object3 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(object3, "function.parameters");
        Collection collection = (Collection)object3;
        object3 = this.innerFunction;
        Object object5 = object3 == null ? null : ((JsFunction)object3).getParameters();
        List parameters2 = CollectionsKt.plus(collection, (Iterable)(object5 == null ? CollectionsKt.emptyList() : object5));
        object3 = constructor2;
        object5 = ((JsFunction)object3).getParameters();
        Intrinsics.checkNotNullExpressionValue(object5, "constructor.parameters");
        Iterable iterable = parameters2;
        Collection collection2 = (Collection)object5;
        boolean $i$f$map2 = false;
        void var12_15 = $this$map$iv;
        List<JsParameter> destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo232 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            hasMetadata = new JsParameter(jsParameter.getName());
            object2.add(hasMetadata);
        }
        object2 = destination$iv$iv2;
        CollectionsKt.addAll(collection2, (Iterable)object2);
        object5 = (JsParameter)CollectionsKt.lastOrNull(parameters2);
        JsName jsName2 = lastParameter = object5 == null ? null : ((JsParameter)object5).getName();
        if (context2.getMetadata().getHasController()) {
            JsName $this$generateContinuationConstructor_u24lambda_u2d6 = $this$map$iv = JsScope.declareTemporaryName("controller");
            boolean bl = false;
            List<JsParameter> list2 = destination$iv$iv2 = constructor2.getParameters();
            Intrinsics.checkNotNullExpressionValue(destination$iv$iv2, "constructor.parameters");
            list2.add(CollectionsKt.getLastIndex(destination$iv$iv2), new JsParameter($this$generateContinuationConstructor_u24lambda_u2d6));
            jsName = $this$map$iv;
        } else {
            jsName = null;
        }
        JsName controllerName = jsName;
        JsName jsName3 = lastParameter;
        Intrinsics.checkNotNull(jsName3);
        JsNameRef $this$generateContinuationConstructor_u24lambda_u2d6 = jsName3.makeRef();
        Intrinsics.checkNotNullExpressionValue($this$generateContinuationConstructor_u24lambda_u2d6, "lastParameter!!.makeRef()");
        JsNameRef interceptorRef = $this$generateContinuationConstructor_u24lambda_u2d6;
        List<JsParameter> bl = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(bl, "function.parameters");
        Iterable $this$map$iv2 = bl;
        boolean $i$f$map32 = false;
        Iterable $i$f$mapTo232 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo32 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection2 = destination$iv$iv3;
            boolean bl2 = false;
            object2 = ((JsParameter)((Object)it)).getName();
            collection2.add(object2);
        }
        Collection collection3 = (List)destination$iv$iv3;
        Object object6 = this.innerFunction;
        if (object6 == null) {
            object = null;
        } else {
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            $i$f$map32 = object6.getParameters();
            Intrinsics.checkNotNullExpressionValue($i$f$map32, "parameters");
            $this$mapTo$iv$iv = $i$f$map32;
            collection2 = collection3;
            boolean $i$f$map4 = false;
            void $i$f$mapTo32 = $this$map$iv3;
            Collection collection4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                JsParameter jsParameter = (JsParameter)item$iv$iv;
                object2 = collection4;
                boolean bl3 = false;
                hasMetadata = it.getName();
                object2.add(hasMetadata);
            }
            object2 = (List)collection4;
            collection3 = collection2;
            object = object2;
        }
        $i$f$map32 = object;
        Set parameterNames = CollectionsKt.toSet(CollectionsKt.plus(collection3, (Iterable)($i$f$map32 == null ? CollectionsKt.emptyList() : $i$f$map32)));
        JsStatement[] $this$generateContinuationConstructor_u24lambda_u2d9 = object6 = constructor2.getBody().getStatements();
        boolean bl4 = false;
        Object object7 = context2.getMetadata().getBaseClassRef().deepCopy();
        Intrinsics.checkNotNullExpressionValue(object7, "context.metadata.baseClassRef.deepCopy()");
        JsExpression baseClass = object7;
        Intrinsics.checkNotNullExpressionValue($this$generateContinuationConstructor_u24lambda_u2d9, "this");
        JsExpression[] jsExpressionArray = new JsExpression[]{new JsThisRef(), interceptorRef};
        ((Collection)$this$generateContinuationConstructor_u24lambda_u2d9).add(((JsExpression)new JsInvocation((JsExpression)Namer.getFunctionCallRef(baseClass), jsExpressionArray).source(psiElement)).makeStmt());
        if (controllerName != null) {
            object7 = context2.getControllerFieldName();
            Intrinsics.checkNotNullExpressionValue(object7, "context.controllerFieldName");
            HasMetadata hasMetadata2 = object7;
            object7 = controllerName.makeRef();
            Intrinsics.checkNotNullExpressionValue(object7, "controllerName.makeRef()");
            this.assignToField((List<JsStatement>)$this$generateContinuationConstructor_u24lambda_u2d9, (JsName)hasMetadata2, (JsExpression)object7, psiElement);
        }
        this.assignToField((List<JsStatement>)$this$generateContinuationConstructor_u24lambda_u2d9, context2.getMetadata().getExceptionStateName(), new JsIntLiteral(globalCatchBlockIndex), psiElement);
        if (context2.getMetadata().getHasReceiver()) {
            object7 = context2.getReceiverFieldName();
            Intrinsics.checkNotNullExpressionValue(object7, "context.receiverFieldName");
            Object object8 = object7;
            object7 = context2.getReceiverFieldName().makeRef();
            Intrinsics.checkNotNullExpressionValue(object7, "context.receiverFieldName.makeRef()");
            this.assignToField((List<JsStatement>)$this$generateContinuationConstructor_u24lambda_u2d9, (JsName)object8, (JsExpression)object7, psiElement);
        }
        for (JsName jsName4 : survivingLocalVars) {
            JsExpression jsExpression = !parameterNames.contains(jsName4) ? Namer.getUndefinedExpression() : (JsExpression)jsName4.makeRef();
            Intrinsics.checkNotNullExpressionValue(jsExpression, "if (localVariable !in pa\u2026e localVariable.makeRef()");
            JsExpression value2 = jsExpression;
            this.assignToField((List<JsStatement>)$this$generateContinuationConstructor_u24lambda_u2d9, context2.getFieldName(jsName4), value2, psiElement);
        }
        object6 = new JsStatement[2];
        object6[0] = constructor2.makeStmt();
        JsName jsName4 = constructor2.getName();
        Intrinsics.checkNotNullExpressionValue(jsName4, "constructor.name");
        object6[1] = this.generateCoroutineMetadata(jsName4);
        Collection collection5 = CollectionsKt.listOf(object6);
        object6 = constructor2.getName();
        Intrinsics.checkNotNullExpressionValue(object6, "constructor.name");
        statements2.addAll(0, CollectionsKt.plus(collection5, (Iterable)this.generateCoroutinePrototype((JsName)object6)));
    }

    private final List<JsStatement> generateCoroutinePrototype(JsName constructorName) {
        JsExpression jsExpression = JsAstUtils.prototypeOf(new JsNameRef(constructorName));
        Intrinsics.checkNotNullExpressionValue(jsExpression, "prototypeOf(JsNameRef(constructorName))");
        JsExpression prototype = jsExpression;
        CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(this.function);
        Intrinsics.checkNotNull(coroutineMetadata);
        JsInvocation jsInvocation = Namer.createObjectWithPrototypeFrom(coroutineMetadata.getBaseClassRef().deepCopy());
        Intrinsics.checkNotNullExpressionValue(jsInvocation, "createObjectWithPrototyp\u2026.baseClassRef.deepCopy())");
        JsInvocation baseClass = jsInvocation;
        JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(prototype, baseClass);
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation, "assignment(prototype, baseClass)");
        JsBinaryOperation assignPrototype = jsBinaryOperation;
        JsStatement[] jsStatementArray = JsAstUtils.assignment(new JsNameRef("constructor", prototype.deepCopy()), new JsNameRef(constructorName));
        Intrinsics.checkNotNullExpressionValue(jsStatementArray, "assignment(JsNameRef(\"co\u2026NameRef(constructorName))");
        JsStatement[] assignConstructor = jsStatementArray;
        jsStatementArray = new JsStatement[2];
        JsStatement jsStatement = assignPrototype.makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "assignPrototype.makeStmt()");
        jsStatementArray[0] = jsStatement;
        jsStatement = assignConstructor.makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "assignConstructor.makeStmt()");
        jsStatementArray[1] = jsStatement;
        return CollectionsKt.listOf(jsStatementArray);
    }

    private final JsStatement generateCoroutineMetadata(JsName constructorName) {
        JsNode jsNode;
        CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(this.function);
        Intrinsics.checkNotNull(coroutineMetadata);
        JsExpression jsExpression = coroutineMetadata.getBaseClassRef().deepCopy();
        Intrinsics.checkNotNullExpressionValue(jsExpression, "function.coroutineMetada\u2026!.baseClassRef.deepCopy()");
        JsExpression baseClassRefRef = jsExpression;
        JsObjectLiteral $this$generateCoroutineMetadata_u24lambda_u2d10 = jsNode = new JsObjectLiteral(true);
        boolean bl = false;
        JsObjectLiteral jsObjectLiteral = $this$generateCoroutineMetadata_u24lambda_u2d10;
        List<JsPropertyInitializer> list2 = jsObjectLiteral.getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(list2, "propertyInitializers");
        ((Collection)list2).add(new JsPropertyInitializer(new JsNameRef("kind"), new JsNameRef("CLASS", (JsExpression)new JsNameRef("Kind", "Kotlin"))));
        jsObjectLiteral = $this$generateCoroutineMetadata_u24lambda_u2d10;
        list2 = jsObjectLiteral.getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(list2, "propertyInitializers");
        ((Collection)list2).add(new JsPropertyInitializer(new JsNameRef("simpleName"), new JsNullLiteral()));
        jsObjectLiteral = $this$generateCoroutineMetadata_u24lambda_u2d10;
        list2 = jsObjectLiteral.getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(list2, "propertyInitializers");
        ((Collection)list2).add(new JsPropertyInitializer(new JsNameRef("interfaces"), new JsArrayLiteral(CollectionsKt.listOf(baseClassRefRef))));
        JsObjectLiteral metadataObject = jsNode;
        jsNode = JsAstUtils.assignment(new JsNameRef("$metadata$", (JsExpression)constructorName.makeRef()), metadataObject).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsNode, "assignment(JsNameRef(Nam\u2026etadataObject).makeStmt()");
        return jsNode;
    }

    private final void generateDoResume(List<CoroutineBlock> coroutineBlocks, CoroutineTransformationContext context2, List<JsStatement> statements2) {
        List<JsStatement> list2;
        JsFunction resumeFunction = new JsFunction(this.function.getScope().getParent(), new JsBlock(), "resume function");
        PsiElement psi = context2.getMetadata().getPsiElement();
        resumeFunction.setSource(psi);
        Object object = psi;
        PsiElement psiElement = object == null ? null : UtilsKt.getFinalElement((PsiElement)object);
        resumeFunction.getBody().setSource(psiElement instanceof LeafPsiElement ? (LeafPsiElement)psiElement : null);
        List<JsStatement> coroutineBody = this.generateCoroutineBody(context2, coroutineBlocks);
        this.functionWithBody.getBody().getStatements().clear();
        Object $this$generateDoResume_u24lambda_u2d11 = object = resumeFunction.getBody().getStatements();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue($this$generateDoResume_u24lambda_u2d11, "this");
        Collection collection = (Collection)$this$generateDoResume_u24lambda_u2d11;
        CollectionsKt.addAll(collection, (Iterable)coroutineBody);
        JsName resumeName = context2.getMetadata().getDoResumeName();
        List<JsStatement> $this$generateDoResume_u24lambda_u2d12 = list2 = statements2;
        boolean bl2 = false;
        this.assignToPrototype($this$generateDoResume_u24lambda_u2d12, resumeName, resumeFunction);
        new FunctionPostProcessor(resumeFunction).apply();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateCoroutineInstantiation(CoroutineTransformationContext context2) {
        Collection<JsNameRef> collection;
        void $this$mapTo$iv$iv;
        Object $this$map$iv;
        PsiElement psiElement = context2.getMetadata().getPsiElement();
        JsNew jsNew = new JsNew(this.className.makeRef());
        Object $this$generateCoroutineInstantiation_u24lambda_u2d13 = jsNew;
        boolean $i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22 = false;
        ((SourceInfoAwareJsNode)$this$generateCoroutineInstantiation_u24lambda_u2d13).setSource(psiElement);
        JsNew instantiation = jsNew;
        if (context2.getMetadata().getHasReceiver()) {
            jsNew = instantiation;
            $this$generateCoroutineInstantiation_u24lambda_u2d13 = jsNew.getArguments();
            Intrinsics.checkNotNullExpressionValue($this$generateCoroutineInstantiation_u24lambda_u2d13, "instantiation.arguments");
            ((Collection)$this$generateCoroutineInstantiation_u24lambda_u2d13).add(new JsThisRef());
        }
        $this$generateCoroutineInstantiation_u24lambda_u2d13 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue($this$generateCoroutineInstantiation_u24lambda_u2d13, "function.parameters");
        Collection collection2 = (Collection)$this$generateCoroutineInstantiation_u24lambda_u2d13;
        $this$generateCoroutineInstantiation_u24lambda_u2d13 = this.innerFunction;
        Object $i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22 = $this$generateCoroutineInstantiation_u24lambda_u2d13 == null ? null : ((JsFunction)$this$generateCoroutineInstantiation_u24lambda_u2d13).getParameters();
        List parameters2 = CollectionsKt.plus(collection2, (Iterable)($i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22 == null ? CollectionsKt.emptyList() : $i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22));
        $this$generateCoroutineInstantiation_u24lambda_u2d13 = instantiation;
        $i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22 = ((JsExpression.JsExpressionHasArguments)$this$generateCoroutineInstantiation_u24lambda_u2d13).getArguments();
        Intrinsics.checkNotNullExpressionValue($i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22, "instantiation.arguments");
        Iterable iterable = CollectionsKt.dropLast(parameters2, 1);
        Collection collection3 = (Collection)$i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22;
        boolean $i$f$map = false;
        List<JsStatement> list2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsNameRef jsNameRef = it.getName().makeRef();
            collection.add(jsNameRef);
        }
        collection = (List)destination$iv$iv;
        CollectionsKt.addAll(collection3, (Iterable)collection);
        CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(this.function);
        Intrinsics.checkNotNull(coroutineMetadata);
        if (coroutineMetadata.getHasController()) {
            $this$generateCoroutineInstantiation_u24lambda_u2d13 = instantiation;
            $i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22 = ((JsExpression.JsExpressionHasArguments)$this$generateCoroutineInstantiation_u24lambda_u2d13).getArguments();
            Intrinsics.checkNotNullExpressionValue($i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22, "instantiation.arguments");
            ((Collection)$i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22).add(new JsThisRef());
        }
        $this$generateCoroutineInstantiation_u24lambda_u2d13 = instantiation;
        $i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22 = ((JsExpression.JsExpressionHasArguments)$this$generateCoroutineInstantiation_u24lambda_u2d13).getArguments();
        Intrinsics.checkNotNullExpressionValue($i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22, "instantiation.arguments");
        ((Collection)$i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22).add(((JsParameter)CollectionsKt.last(parameters2)).getName().makeRef());
        $i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22 = JsScope.declareTemporaryName("suspended");
        Intrinsics.checkNotNullExpressionValue($i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22, "declareTemporaryName(\"suspended\")");
        Object suspendedName = $i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22;
        $i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22 = this.functionWithBody;
        $this$map$iv = ((JsFunction)$i$a$-apply-CoroutineFunctionTransformer$generateCoroutineInstantiation$instantiation$22).getParameters();
        Intrinsics.checkNotNullExpressionValue($this$map$iv, "functionWithBody.parameters");
        ((Collection)$this$map$iv).add(new JsParameter((JsName)suspendedName));
        $this$map$iv = JsScope.declareTemporaryName("instance");
        Intrinsics.checkNotNullExpressionValue($this$map$iv, "declareTemporaryName(\"instance\")");
        Object instanceName = $this$map$iv;
        $this$map$iv = this.functionWithBody.getBody();
        Object object = ((JsBlock)$this$map$iv).getStatements();
        Intrinsics.checkNotNullExpressionValue(object, "functionWithBody.body.statements");
        ((Collection)object).add(JsAstUtils.newVar((JsName)instanceName, instantiation));
        object = new JsExpression[]{new JsNullLiteral()};
        JsReturn invokeResume = new JsReturn((JsExpression)new JsInvocation((JsExpression)new JsNameRef(context2.getMetadata().getDoResumeName(), (JsExpression)((JsName)instanceName).makeRef()), (JsExpression[])object).source(psiElement));
        object = this.functionWithBody.getBody();
        list2 = ((JsBlock)object).getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, "functionWithBody.body.statements");
        ((Collection)list2).add(new JsIf(((JsName)suspendedName).makeRef().source(psiElement), new JsReturn(((JsName)instanceName).makeRef().source(psiElement)), invokeResume));
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> generateCoroutineBody(CoroutineTransformationContext context2, List<CoroutineBlock> blocks) {
        void $this$mapTo$iv$iv;
        int indexOfGlobalCatch = blocks.indexOf(context2.getGlobalCatchBlock());
        JsNameRef stateRef = new JsNameRef(context2.getMetadata().getStateName(), (JsExpression)new JsThisRef());
        JsNameRef exceptionStateRef = new JsNameRef(context2.getMetadata().getExceptionStateName(), (JsExpression)new JsThisRef());
        JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(stateRef, new JsIntLiteral(indexOfGlobalCatch));
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation, "equality(stateRef, JsInt\u2026eral(indexOfGlobalCatch))");
        JsBinaryOperation isFromGlobalCatch = jsBinaryOperation;
        JsCatch jsCatch = new JsCatch(this.functionWithBody.getScope(), "e");
        JsStatement[] jsStatementArray = new JsStatement[]{JsAstUtils.assignment(stateRef.deepCopy(), exceptionStateRef.deepCopy()).makeStmt(), JsAstUtils.assignment(new JsNameRef(context2.getMetadata().getExceptionName(), (JsExpression)new JsThisRef()), jsCatch.getParameter().getName().makeRef()).makeStmt()};
        JsBlock continueWithException = new JsBlock(jsStatementArray);
        JsStatement[] jsStatementArray2 = JsAstUtils.assignment(exceptionStateRef.deepCopy(), stateRef.deepCopy()).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatementArray2, "assignment(exceptionStat\u2026ef.deepCopy()).makeStmt()");
        JsStatement[] adjustExceptionState = jsStatementArray2;
        jsStatementArray2 = new JsStatement[]{adjustExceptionState, new JsThrow(jsCatch.getParameter().getName().makeRef())};
        jsCatch.setBody(new JsBlock((JsStatement)new JsIf(isFromGlobalCatch, new JsBlock(jsStatementArray2), continueWithException)));
        JsNameRef throwResultRef = new JsNameRef(context2.getMetadata().getExceptionName(), (JsExpression)new JsThisRef());
        CoroutineBlock coroutineBlock = context2.getGlobalCatchBlock();
        ((Collection)coroutineBlock.getStatements()).add(new JsThrow(throwResultRef));
        Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)blocks);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsCase jsCase;
            void $dstr$index$block;
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int index2 = $dstr$index$block.component1();
            CoroutineBlock block = (CoroutineBlock)$dstr$index$block.component2();
            JsCase $this$generateCoroutineBody_u24lambda_u2d16_u24lambda_u2d15 = jsCase = new JsCase();
            boolean bl2 = false;
            $this$generateCoroutineBody_u24lambda_u2d16_u24lambda_u2d15.setCaseExpression(new JsIntLiteral(index2));
            JsCase jsCase2 = $this$generateCoroutineBody_u24lambda_u2d16_u24lambda_u2d15;
            List<JsStatement> list2 = jsCase2.getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "statements");
            CollectionsKt.addAll((Collection)list2, (Iterable)block.getStatements());
            JsCase jsCase3 = jsCase;
            collection.add(jsCase3);
        }
        List cases = (List)destination$iv$iv;
        JsDefault $this$generateCoroutineBody_u24lambda_u2d17 = $i$f$map = new JsDefault();
        boolean bl = false;
        Object object = new JsStatement[]{JsAstUtils.assignment(stateRef, new JsIntLiteral(indexOfGlobalCatch)).makeStmt(), new JsThrow(new JsNew(new JsNameRef("Error"), CollectionsKt.listOf(new JsStringLiteral("State Machine Unreachable execution"))))};
        JsBlock block = new JsBlock((JsStatement[])object);
        object = $this$generateCoroutineBody_u24lambda_u2d17;
        Collection<JsStatement> collection = ((JsSwitchMember)object).getStatements();
        Intrinsics.checkNotNullExpressionValue(collection, "statements");
        collection = collection;
        collection.add(block);
        JsDefault defaultCase = $i$f$map;
        JsSwitch switchStatement = new JsSwitch(stateRef.deepCopy(), CollectionsKt.plus((Collection)cases, defaultCase));
        JsDoWhile loop2 = new JsDoWhile(new JsBooleanLiteral(true), new JsTry(new JsBlock((JsStatement)switchStatement), jsCatch, null));
        return CollectionsKt.listOf(loop2);
    }

    private final void collectAdditionalLocalVariables(JsBlock $this$collectAdditionalLocalVariables) {
        $this$collectAdditionalLocalVariables.accept(new RecursiveJsVisitor(this){
            final /* synthetic */ CoroutineFunctionTransformer this$0;
            {
                this.this$0 = $receiver;
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter(x, "x");
                super.visit(x);
                CoroutineFunctionTransformer coroutineFunctionTransformer = this.this$0;
                ((Collection)CoroutineFunctionTransformer.access$getLocalVariables$p(coroutineFunctionTransformer)).add(x.getName());
            }
        });
    }

    private final void assignToField(List<JsStatement> $this$assignToField, JsName fieldName, JsExpression value2, PsiElement psiElement) {
        ((Collection)$this$assignToField).add(JsAstUtils.assignment(new JsNameRef(fieldName, (JsExpression)new JsThisRef()), value2).source(psiElement).makeStmt());
    }

    private final void assignToPrototype(List<JsStatement> $this$assignToPrototype, JsName fieldName, JsExpression value2) {
        ((Collection)$this$assignToPrototype).add(JsAstUtils.assignment(new JsNameRef(fieldName, JsAstUtils.prototypeOf(this.className.makeRef())), value2).makeStmt());
    }

    public static final /* synthetic */ JsBlock access$getBody$p(CoroutineFunctionTransformer $this) {
        return $this.body;
    }

    public static final /* synthetic */ Set access$getLocalVariables$p(CoroutineFunctionTransformer $this) {
        return $this.localVariables;
    }
}

