/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import org.jetbrains.kotlin.load.java.structure.impl.VirtualFileBoundJavaClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleResolver;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DescriptorWithContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J.\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleResolver", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleResolver;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "diagnosticFor", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "targetClassOrPackage", "Lorg/jetbrains/kotlin/descriptors/ClassOrPackageFragmentDescriptor;", "originalDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithSource;", "fileFromOurModule", "Lcom/intellij/openapi/vfs/VirtualFile;", "findVirtualFile", "descriptor", "ClassifierUsage", "frontend.java"})
public final class JvmModuleAccessibilityChecker
implements CallChecker {
    @NotNull
    private final JavaModuleResolver moduleResolver;

    public JvmModuleAccessibilityChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.moduleResolver = JavaModuleResolver.SERVICE.getInstance(project);
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        ClassOrPackageFragmentDescriptor classOrPackageFragmentDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (descriptor2 instanceof ClassConstructorDescriptor) {
            return;
        }
        Object object = DescriptorUtils.getParentOfType((DeclarationDescriptor)descriptor2, ClassOrPackageFragmentDescriptor.class);
        if (object == null) {
            return;
        }
        ClassOrPackageFragmentDescriptor targetDescriptor = classOrPackageFragmentDescriptor = object;
        object = DescriptorToSourceUtils.getContainingFile(context2.getScope().getOwnerDescriptor());
        VirtualFile fileFromOurModule = object == null ? null : ((PsiFileImpl)object).getVirtualFile();
        object = this.diagnosticFor(targetDescriptor, (DeclarationDescriptorWithSource)descriptor2, fileFromOurModule, reportOn);
        if (object != null) {
            Object object2 = object;
            BindingTrace bindingTrace = context2.getTrace();
            Object p0 = object2;
            boolean bl = false;
            bindingTrace.report((Diagnostic)p0);
        }
    }

    private final Diagnostic diagnosticFor(ClassOrPackageFragmentDescriptor targetClassOrPackage, DeclarationDescriptorWithSource originalDescriptor, VirtualFile fileFromOurModule, PsiElement reportOn) {
        Diagnostic diagnostic;
        JvmClassName jvmClassName;
        VirtualFile virtualFile2 = this.findVirtualFile(targetClassOrPackage, originalDescriptor);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile referencedFile = virtualFile2;
        Object object = originalDescriptor instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)originalDescriptor : null;
        JvmClassName jvmClassName2 = jvmClassName = object == null ? null : UtilKt.getImplClassNameForDeserialized((DescriptorWithContainerSource)object);
        FqName referencedPackageFqName = jvmClassName == null ? ((object = DescriptorUtils.getParentOfType(targetClassOrPackage, PackageFragmentDescriptor.class, false)) == null ? null : object.getFqName()) : jvmClassName.getPackageFqName();
        JavaModuleResolver.AccessError diagnostic2 = this.moduleResolver.checkAccessibility(fileFromOurModule, referencedFile, referencedPackageFqName);
        object = diagnostic2;
        if (object instanceof JavaModuleResolver.AccessError.ModuleDoesNotReadUnnamedModule) {
            diagnostic = ErrorsJvm.JAVA_MODULE_DOES_NOT_READ_UNNAMED_MODULE.on(reportOn);
        } else if (object instanceof JavaModuleResolver.AccessError.ModuleDoesNotReadModule) {
            diagnostic = ErrorsJvm.JAVA_MODULE_DOES_NOT_DEPEND_ON_MODULE.on(reportOn, ((JavaModuleResolver.AccessError.ModuleDoesNotReadModule)diagnostic2).getDependencyModuleName());
        } else if (object instanceof JavaModuleResolver.AccessError.ModuleDoesNotExportPackage) {
            String string2 = ((JavaModuleResolver.AccessError.ModuleDoesNotExportPackage)diagnostic2).getDependencyModuleName();
            FqName fqName2 = referencedPackageFqName;
            Intrinsics.checkNotNull(fqName2);
            diagnostic = ErrorsJvm.JAVA_MODULE_DOES_NOT_EXPORT_PACKAGE.on(reportOn, string2, fqName2.asString());
        } else {
            diagnostic = null;
        }
        return diagnostic;
    }

    private final VirtualFile findVirtualFile(ClassOrPackageFragmentDescriptor descriptor2, DeclarationDescriptorWithSource originalDescriptor) {
        Object object;
        Object object2;
        Object object3 = descriptor2.getSource();
        Intrinsics.checkNotNullExpressionValue(object3, "descriptor.source");
        SourceElement source = object3;
        object3 = source;
        if (object3 instanceof KotlinJvmBinarySourceElement) {
            object2 = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
            Object object4 = object = object2 instanceof VirtualFileKotlinClass ? (VirtualFileKotlinClass)object2 : null;
            if (object != null) {
                Object object5;
                Object it = object5 = (object2 = ((VirtualFileKotlinClass)object).getFile());
                boolean bl = false;
                return it;
            }
        } else if (object3 instanceof JavaSourceElement) {
            object2 = ((JavaSourceElement)source).getJavaElement();
            Object object6 = object = object2 instanceof VirtualFileBoundJavaClass ? (VirtualFileBoundJavaClass)object2 : null;
            if (object != null && (object2 = object.getVirtualFile()) != null) {
                Object object7;
                Object it = object7 = object2;
                boolean bl = false;
                return it;
            }
        } else if (object3 instanceof KotlinJvmBinaryPackageSourceElement && originalDescriptor instanceof DeserializedMemberDescriptor) {
            object2 = ((KotlinJvmBinaryPackageSourceElement)source).getContainingBinaryClass((DeserializedMemberDescriptor)originalDescriptor);
            Object object8 = object = object2 instanceof VirtualFileKotlinClass ? (VirtualFileKotlinClass)object2 : null;
            if (object != null) {
                Object object9;
                Object it = object9 = (object2 = ((VirtualFileKotlinClass)object).getFile());
                boolean bl = false;
                return it;
            }
        }
        object3 = JvmModuleAccessibilityChecker.findVirtualFile$getContainingVirtualFile(source);
        if (object3 != null) {
            Object it = object = object3;
            boolean bl = false;
            return it;
        }
        object2 = originalDescriptor;
        if (object2 == null) {
            return null;
        }
        object = object2.getSource();
        Intrinsics.checkNotNullExpressionValue(object, "originalDescriptor?.source ?: return null");
        Object originalSource = object;
        return JvmModuleAccessibilityChecker.findVirtualFile$getContainingVirtualFile((SourceElement)originalSource);
    }

    private static final VirtualFile findVirtualFile$getContainingVirtualFile(SourceElement source) {
        VirtualFile virtualFile2;
        PsiElement psiElement = PsiSourceElementKt.getPsi(source);
        if (psiElement == null) {
            virtualFile2 = null;
        } else {
            PsiElement psiElement2;
            PsiElement psiElement3;
            PsiElement it = psiElement3 = psiElement;
            boolean bl = false;
            PsiElement psiElement4 = psiElement2 = it.isValid() ? psiElement3 : null;
            if (psiElement2 == null) {
                virtualFile2 = null;
            } else {
                psiElement3 = psiElement2.getContainingFile();
                if (psiElement3 == null) {
                    virtualFile2 = null;
                } else {
                    VirtualFile virtualFile3 = psiElement3.getVirtualFile();
                    if (virtualFile3 == null) {
                        virtualFile2 = null;
                    } else {
                        VirtualFile virtualFile4;
                        VirtualFile it2 = virtualFile4 = virtualFile3;
                        boolean bl2 = false;
                        virtualFile2 = it2.isValid() ? virtualFile4 : null;
                    }
                }
            }
        }
        return virtualFile2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "(Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker;)V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend.java"})
    public final class ClassifierUsage
    implements ClassifierUsageChecker {
        public ClassifierUsage() {
            Intrinsics.checkNotNullParameter(JvmModuleAccessibilityChecker.this, "this$0");
        }

        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context2) {
            Intrinsics.checkNotNullParameter(targetDescriptor, "targetDescriptor");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(context2, "context");
            VirtualFile virtualFile2 = element.getContainingFile().getVirtualFile();
            ClassifierDescriptor classifierDescriptor = targetDescriptor;
            if (classifierDescriptor instanceof ClassDescriptor) {
                Diagnostic diagnostic = JvmModuleAccessibilityChecker.this.diagnosticFor((ClassOrPackageFragmentDescriptor)((Object)targetDescriptor), targetDescriptor, virtualFile2, element);
                if (diagnostic != null) {
                    Diagnostic diagnostic2 = diagnostic;
                    BindingTrace bindingTrace = context2.getTrace();
                    Diagnostic p0 = diagnostic2;
                    boolean bl = false;
                    bindingTrace.report(p0);
                }
            } else if (classifierDescriptor instanceof TypeAliasDescriptor) {
                ClassDescriptor expandedClass;
                Object object;
                Object object2;
                Diagnostic diagnostic;
                ClassOrPackageFragmentDescriptor containingClassOrPackage = DescriptorUtils.getParentOfType(targetDescriptor, ClassOrPackageFragmentDescriptor.class);
                if (containingClassOrPackage != null && (diagnostic = JvmModuleAccessibilityChecker.this.diagnosticFor(containingClassOrPackage, targetDescriptor, virtualFile2, element)) != null) {
                    object2 = diagnostic;
                    object = context2.getTrace();
                    Object p0 = object2;
                    boolean bl = false;
                    object.report((Diagnostic)p0);
                }
                ClassDescriptor classDescriptor = expandedClass = (object2 = ((TypeAliasDescriptor)targetDescriptor).getExpandedType().getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor ? (ClassDescriptor)object2 : null;
                if (expandedClass != null && (object2 = JvmModuleAccessibilityChecker.this.diagnosticFor(expandedClass, expandedClass, virtualFile2, element)) != null) {
                    object = object2;
                    BindingTrace bindingTrace = context2.getTrace();
                    Object p0 = object;
                    boolean bl = false;
                    bindingTrace.report((Diagnostic)p0);
                }
            }
        }
    }
}

