/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.classes;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclarationKt$shouldNotBeVisibleAsLightClass$;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0003\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\f\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0003\u00a8\u0006\u000e"}, d2={"classDeclaredInUnexpectedPosition", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getOutermostClassOrObject", "hasParseErrorsAround", "psi", "Lcom/intellij/psi/PsiElement;", "isEnumEntryWithoutBody", "defaultJavaAncestorQualifiedName", "", "isPossiblyAffectedByAllOpen", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClassForSourceDeclaration;", "shouldNotBeVisibleAsLightClass", "light-classes"})
public final class KtLightClassForSourceDeclarationKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPossiblyAffectedByAllOpen(@NotNull KtLightClassForSourceDeclaration $this$isPossiblyAffectedByAllOpen) {
        Intrinsics.checkNotNullParameter($this$isPossiblyAffectedByAllOpen, "<this>");
        if ($this$isPossiblyAffectedByAllOpen.isAnnotationType()) return false;
        if ($this$isPossiblyAffectedByAllOpen.isInterface()) return false;
        List<KtAnnotationEntry> list2 = $this$isPossiblyAffectedByAllOpen.getKotlinOrigin().getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue(list2, "kotlinOrigin.annotationEntries");
        if (((Collection)list2).isEmpty()) return false;
        return true;
    }

    @NotNull
    public static final KtClassOrObject getOutermostClassOrObject(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        KtClassOrObject ktClassOrObject = KtPsiUtil.getOutermostClassOrObject(classOrObject);
        if (ktClassOrObject == null) {
            throw new IllegalStateException(Intrinsics.stringPlus("Attempt to build a light class for a local class: ", classOrObject.getText()));
        }
        return ktClassOrObject;
    }

    @Nullable
    public static final String defaultJavaAncestorQualifiedName(@NotNull KtClassOrObject $this$defaultJavaAncestorQualifiedName) {
        Intrinsics.checkNotNullParameter($this$defaultJavaAncestorQualifiedName, "<this>");
        if (!($this$defaultJavaAncestorQualifiedName instanceof KtClass)) {
            return "java.lang.Object";
        }
        return $this$defaultJavaAncestorQualifiedName.isAnnotation() ? "java.lang.annotation.Annotation" : (((KtClass)$this$defaultJavaAncestorQualifiedName).isEnum() ? "java.lang.Enum" : (((KtClass)$this$defaultJavaAncestorQualifiedName).isInterface() ? "java.lang.Object" : "java.lang.Object"));
    }

    public static final boolean shouldNotBeVisibleAsLightClass(@NotNull KtClassOrObject $this$shouldNotBeVisibleAsLightClass) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter($this$shouldNotBeVisibleAsLightClass, "<this>");
            if ($this$shouldNotBeVisibleAsLightClass.getContainingFile() instanceof KtCodeFragment) {
                return true;
            }
            Sequence<PsiElement> $this$filterIsInstance$iv = PsiUtilsKt.getParentsWithSelf($this$shouldNotBeVisibleAsLightClass);
            boolean $i$f$filterIsInstance = false;
            Sequence<PsiElement> $this$any$iv = SequencesKt.filter($this$filterIsInstance$iv, shouldNotBeVisibleAsLightClass$$inlined$filterIsInstance$1.INSTANCE);
            boolean $i$f$any = false;
            Iterator<PsiElement> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                PsiElement element$iv = iterator2.next();
                KtClassOrObject it = (KtClassOrObject)element$iv;
                boolean bl2 = false;
                if (!PsiUtilsKt.hasExpectModifier(it)) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        if ($this$shouldNotBeVisibleAsLightClass.isLocal()) {
            if ($this$shouldNotBeVisibleAsLightClass.getContainingFile().getVirtualFile() == null) {
                return true;
            }
            if (KtLightClassForSourceDeclarationKt.hasParseErrorsAround($this$shouldNotBeVisibleAsLightClass) || PsiUtilCore.hasErrorElementChild($this$shouldNotBeVisibleAsLightClass)) {
                return true;
            }
            if (KtLightClassForSourceDeclarationKt.classDeclaredInUnexpectedPosition($this$shouldNotBeVisibleAsLightClass)) {
                return true;
            }
        }
        return KtLightClassForSourceDeclarationKt.isEnumEntryWithoutBody($this$shouldNotBeVisibleAsLightClass);
    }

    private static final boolean classDeclaredInUnexpectedPosition(KtClassOrObject classOrObject) {
        if (classOrObject instanceof KtObjectDeclaration) {
            return false;
        }
        PsiElement classParent = classOrObject.getParent();
        return !(classParent instanceof KtBlockExpression) && !(classParent instanceof KtDeclarationContainer);
    }

    private static final boolean isEnumEntryWithoutBody(KtClassOrObject classOrObject) {
        boolean bl;
        if (!(classOrObject instanceof KtEnumEntry)) {
            return false;
        }
        KtClassBody ktClassBody = classOrObject.getBody();
        if (ktClassBody == null) {
            bl = true;
        } else {
            List<KtDeclaration> list2 = ktClassBody.getDeclarations();
            bl = list2.isEmpty();
        }
        return bl;
    }

    private static final boolean hasParseErrorsAround(PsiElement psi) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        ASTNode aSTNode3 = psi.getNode();
        if (aSTNode3 == null) {
            return false;
        }
        ASTNode node = aSTNode3;
        if ((aSTNode3 = TreeUtil.nextLeaf(node)) != null) {
            ASTNode nextLeaf = aSTNode2 = aSTNode3;
            boolean bl = false;
            if (Intrinsics.areEqual(nextLeaf.getElementType(), TokenType.ERROR_ELEMENT) || Intrinsics.areEqual((aSTNode = nextLeaf.getTreePrev()) == null ? null : aSTNode.getElementType(), TokenType.ERROR_ELEMENT)) {
                return true;
            }
        }
        aSTNode3 = TreeUtil.prevLeaf(node);
        if (aSTNode3 != null) {
            ASTNode prevLeaf = aSTNode2 = aSTNode3;
            boolean bl = false;
            if (Intrinsics.areEqual(prevLeaf.getElementType(), TokenType.ERROR_ELEMENT) || Intrinsics.areEqual((aSTNode = prevLeaf.getTreeNext()) == null ? null : aSTNode.getElementType(), TokenType.ERROR_ELEMENT)) {
                return true;
            }
        }
        return false;
    }
}

