/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenOnClassExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnExpectExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cfg/WhenOnSealedExhaustivenessChecker;", "Lorg/jetbrains/kotlin/cfg/WhenOnClassExhaustivenessChecker;", "()V", "getMissingCases", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "subjectDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "nullable", "", "isApplicable", "subjectType", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
public final class WhenOnSealedExhaustivenessChecker
extends WhenOnClassExhaustivenessChecker {
    @NotNull
    public static final WhenOnSealedExhaustivenessChecker INSTANCE = new WhenOnSealedExhaustivenessChecker();

    private WhenOnSealedExhaustivenessChecker() {
    }

    @Override
    @NotNull
    public List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2, @Nullable ClassDescriptor subjectDescriptor, boolean nullable) {
        List list2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        boolean bl = DescriptorUtils.isSealedClass(subjectDescriptor);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = Intrinsics.stringPlus("isWhenOnSealedClassExhaustive should be called with a sealed class descriptor: ", subjectDescriptor);
            throw new AssertionError((Object)string2);
        }
        ClassDescriptor classDescriptor = subjectDescriptor;
        Intrinsics.checkNotNull(classDescriptor);
        Set<ClassDescriptor> allSubclasses = this.getDeepSealedSubclasses(classDescriptor);
        List $this$getMissingCases_u24lambda_u2d1 = list2 = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl3 = false;
        $this$getMissingCases_u24lambda_u2d1.addAll(INSTANCE.getMissingClassCases(expression2, kotlin.collections.CollectionsKt.toSet((Iterable)allSubclasses), context2));
        $this$getMissingCases_u24lambda_u2d1.addAll(WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context2, nullable));
        CollectionsKt.addIfNotNull($this$getMissingCases_u24lambda_u2d1, WhenOnExpectExhaustivenessChecker.INSTANCE.getMissingCase(subjectDescriptor));
        return kotlin.collections.CollectionsKt.build(list2);
    }

    @Override
    public boolean isApplicable(@NotNull KotlinType subjectType) {
        Intrinsics.checkNotNullParameter(subjectType, "subjectType");
        return DescriptorUtils.isSealedClass(TypeUtils.getClassDescriptor(subjectType));
    }
}

