/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.ArgumentsKt;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.Usage;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PlainTextMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.CompatKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.Services;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000 %*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J'\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J/\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0013J5\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0004\u00a2\u0006\u0002\u0010\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001c\u001a\u00020\u000fH&J#\u0010\u001d\u001a\u00020\b2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e2\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ'\u0010\u001f\u001a\u00020\b\"\b\b\u0001\u0010\u0001*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u0002H\u0001H\u0002\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010 J\u001d\u0010#\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010$\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/cli/common/CLITool;", "A", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;", "", "()V", "createArguments", "()Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;", "disableURLConnectionCaches", "", "exec", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "errStream", "Ljava/io/PrintStream;", "args", "", "", "(Ljava/io/PrintStream;[Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "messageRenderer", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "(Ljava/io/PrintStream;Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;[Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "services", "Lorg/jetbrains/kotlin/config/Services;", "(Ljava/io/PrintStream;Lorg/jetbrains/kotlin/config/Services;Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;[Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "arguments", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/config/Services;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "execImpl", "executableScriptFileName", "parseArguments", "([Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;)V", "printVersionIfNeeded", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;)V", "reportArgumentParseProblems", "collector", "reportUnsafeInternalArgumentsIfAny", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "Companion", "cli"})
public abstract class CLITool<A extends CommonToolArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ExitCode exec(@NotNull PrintStream errStream, String ... args) {
        Intrinsics.checkNotNullParameter(errStream, "errStream");
        Intrinsics.checkNotNullParameter(args, "args");
        return this.exec(errStream, Services.EMPTY, CLITool.Companion.defaultMessageRenderer(), args);
    }

    @NotNull
    public final ExitCode exec(@NotNull PrintStream errStream, @NotNull MessageRenderer messageRenderer, String ... args) {
        Intrinsics.checkNotNullParameter(errStream, "errStream");
        Intrinsics.checkNotNullParameter(messageRenderer, "messageRenderer");
        Intrinsics.checkNotNullParameter(args, "args");
        return this.exec(errStream, Services.EMPTY, messageRenderer, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final ExitCode exec(@NotNull PrintStream errStream, @NotNull Services services, @NotNull MessageRenderer messageRenderer, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(errStream, "errStream");
        Intrinsics.checkNotNullParameter(services, "services");
        Intrinsics.checkNotNullParameter(messageRenderer, "messageRenderer");
        Intrinsics.checkNotNullParameter(args, "args");
        A arguments2 = this.createArguments();
        ParseCommandLineArgumentsKt.parseCommandLineArguments(ArraysKt.asList(args), arguments2);
        PrintingMessageCollector collector2 = new PrintingMessageCollector(errStream, messageRenderer, ((CommonToolArguments)arguments2).getVerbose());
        try {
            if (PlainTextMessageRenderer.COLOR_ENABLED) {
                AnsiConsole.systemInstall();
            }
            errStream.print(messageRenderer.renderPreamble());
            String errorMessage2 = ParseCommandLineArgumentsKt.validateArguments(((CommonToolArguments)arguments2).getErrors());
            if (errorMessage2 != null) {
                collector2.report(CompilerMessageSeverity.ERROR, errorMessage2, null);
                collector2.report(CompilerMessageSeverity.INFO, "Use -help for more information", null);
                ExitCode exitCode = ExitCode.COMPILATION_ERROR;
                return exitCode;
            }
            if (((CommonToolArguments)arguments2).getHelp() || ((CommonToolArguments)arguments2).getExtraHelp()) {
                errStream.print(messageRenderer.renderUsage(Usage.render(this, arguments2)));
                ExitCode exitCode = ExitCode.OK;
                return exitCode;
            }
            ExitCode exitCode = this.exec(collector2, services, arguments2);
            return exitCode;
        }
        finally {
            errStream.print(messageRenderer.renderConclusion());
            if (PlainTextMessageRenderer.COLOR_ENABLED) {
                AnsiConsole.systemUninstall();
            }
        }
    }

    @NotNull
    public final ExitCode exec(@NotNull MessageCollector messageCollector, @NotNull Services services, @NotNull A arguments2) {
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        Intrinsics.checkNotNullParameter(services, "services");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        this.disableURLConnectionCaches();
        this.printVersionIfNeeded(messageCollector, arguments2);
        MessageCollector fixedMessageCollector = ((CommonToolArguments)arguments2).getSuppressWarnings() && !((CommonToolArguments)arguments2).getAllWarningsAsErrors() ? (MessageCollector)new FilteringMessageCollector(messageCollector, Predicate.isEqual((Object)CompilerMessageSeverity.WARNING)) : messageCollector;
        ArgumentsKt.reportArgumentParseProblems(fixedMessageCollector, arguments2);
        return this.execImpl(fixedMessageCollector, services, arguments2);
    }

    private final void disableURLConnectionCaches() {
        new URLConnection(new URL("file:.")){

            @NotNull
            public Void connect() {
                throw (Throwable)new UnsupportedOperationException();
            }
        }.setDefaultUseCaches(false);
    }

    @NotNull
    protected abstract ExitCode execImpl(@NotNull MessageCollector var1, @NotNull Services var2, @NotNull A var3);

    @NotNull
    public abstract A createArguments();

    public final void parseArguments(@NotNull String[] args, @NotNull A arguments2) {
        Intrinsics.checkNotNullParameter(args, "args");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        ParseCommandLineArgumentsKt.parseCommandLineArguments(ArraysKt.asList(args), arguments2);
        String message2 = ParseCommandLineArgumentsKt.validateArguments(((CommonToolArguments)arguments2).getErrors());
        if (message2 != null) {
            throw (Throwable)new IllegalArgumentException(message2);
        }
    }

    private final <A extends CommonToolArguments> void printVersionIfNeeded(MessageCollector messageCollector, A arguments2) {
        if (arguments2.getVersion()) {
            String jreVersion = System.getProperty("java.runtime.version");
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, this.executableScriptFileName() + ' ' + KotlinCompilerVersion.VERSION + " (JRE " + jreVersion + ')', null, 4, null);
        }
    }

    @NotNull
    public abstract String executableScriptFileName();

    @JvmStatic
    public static final void doMain(@NotNull CLITool<?> compiler, @NotNull String[] args) {
        Companion.doMain(compiler, args);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ExitCode doMainNoExit(@NotNull CLITool<?> compiler, @NotNull String[] args, @NotNull MessageRenderer messageRenderer) {
        return Companion.doMainNoExit(compiler, args, messageRenderer);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ExitCode doMainNoExit(@NotNull CLITool<?> compiler, @NotNull String[] args) {
        return org.jetbrains.kotlin.cli.common.CLITool$Companion.doMainNoExit$default(Companion, compiler, args, null, 4, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J'\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007\u00a2\u0006\u0002\u0010\fJ1\u0010\r\u001a\u00020\u000e2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cli/common/CLITool$Companion;", "", "()V", "defaultMessageRenderer", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "doMain", "", "compiler", "Lorg/jetbrains/kotlin/cli/common/CLITool;", "args", "", "", "(Lorg/jetbrains/kotlin/cli/common/CLITool;[Ljava/lang/String;)V", "doMainNoExit", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "messageRenderer", "(Lorg/jetbrains/kotlin/cli/common/CLITool;[Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "cli"})
    public static final class Companion {
        private final MessageRenderer defaultMessageRenderer() {
            MessageRenderer messageRenderer;
            String string2 = System.getProperty("org.jetbrains.kotlin.cliMessageRenderer");
            MessageRenderer messageRenderer2 = MessageRenderer.XML;
            Intrinsics.checkNotNullExpressionValue(messageRenderer2, "MessageRenderer.XML");
            if (Intrinsics.areEqual(string2, messageRenderer2.getName())) {
                MessageRenderer messageRenderer3 = MessageRenderer.XML;
                messageRenderer = messageRenderer3;
                Intrinsics.checkNotNullExpressionValue(messageRenderer3, "MessageRenderer.XML");
            } else {
                MessageRenderer messageRenderer4 = MessageRenderer.GRADLE_STYLE;
                Intrinsics.checkNotNullExpressionValue(messageRenderer4, "MessageRenderer.GRADLE_STYLE");
                if (Intrinsics.areEqual(string2, messageRenderer4.getName())) {
                    MessageRenderer messageRenderer5 = MessageRenderer.GRADLE_STYLE;
                    messageRenderer = messageRenderer5;
                    Intrinsics.checkNotNullExpressionValue(messageRenderer5, "MessageRenderer.GRADLE_STYLE");
                } else {
                    MessageRenderer messageRenderer6 = MessageRenderer.WITHOUT_PATHS;
                    Intrinsics.checkNotNullExpressionValue(messageRenderer6, "MessageRenderer.WITHOUT_PATHS");
                    if (Intrinsics.areEqual(string2, messageRenderer6.getName())) {
                        MessageRenderer messageRenderer7 = MessageRenderer.WITHOUT_PATHS;
                        messageRenderer = messageRenderer7;
                        Intrinsics.checkNotNullExpressionValue(messageRenderer7, "MessageRenderer.WITHOUT_PATHS");
                    } else {
                        MessageRenderer messageRenderer8 = MessageRenderer.PLAIN_FULL_PATHS;
                        Intrinsics.checkNotNullExpressionValue(messageRenderer8, "MessageRenderer.PLAIN_FULL_PATHS");
                        if (Intrinsics.areEqual(string2, messageRenderer8.getName())) {
                            MessageRenderer messageRenderer9 = MessageRenderer.PLAIN_FULL_PATHS;
                            messageRenderer = messageRenderer9;
                            Intrinsics.checkNotNullExpressionValue(messageRenderer9, "MessageRenderer.PLAIN_FULL_PATHS");
                        } else {
                            MessageRenderer messageRenderer10 = MessageRenderer.PLAIN_RELATIVE_PATHS;
                            messageRenderer = messageRenderer10;
                            Intrinsics.checkNotNullExpressionValue(messageRenderer10, "MessageRenderer.PLAIN_RELATIVE_PATHS");
                        }
                    }
                }
            }
            return messageRenderer;
        }

        @JvmStatic
        public final void doMain(@NotNull CLITool<?> compiler, @NotNull String[] args) {
            Intrinsics.checkNotNullParameter(compiler, "compiler");
            Intrinsics.checkNotNullParameter(args, "args");
            if (System.getProperty("java.awt.headless") == null) {
                System.setProperty("java.awt.headless", "true");
            }
            if (CompilerSystemProperties.KOTLIN_COLORS_ENABLED_PROPERTY.getValue() == null) {
                CompilerSystemProperties.KOTLIN_COLORS_ENABLED_PROPERTY.setValue("true");
            }
            CompatKt.setupIdeaStandaloneExecution();
            ExitCode exitCode = org.jetbrains.kotlin.cli.common.CLITool$Companion.doMainNoExit$default(this, compiler, args, null, 4, null);
            if (exitCode != ExitCode.OK) {
                int n = exitCode.getCode();
                System.exit(n);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ExitCode doMainNoExit(@NotNull CLITool<?> compiler, @NotNull String[] args, @NotNull MessageRenderer messageRenderer) {
            ExitCode exitCode;
            Intrinsics.checkNotNullParameter(compiler, "compiler");
            Intrinsics.checkNotNullParameter(args, "args");
            Intrinsics.checkNotNullParameter(messageRenderer, "messageRenderer");
            try {
                PrintStream printStream = System.err;
                Intrinsics.checkNotNullExpressionValue(printStream, "System.err");
                exitCode = compiler.exec(printStream, messageRenderer, Arrays.copyOf(args, args.length));
            }
            catch (CompileEnvironmentException e) {
                System.err.println(e.getMessage());
                exitCode = ExitCode.INTERNAL_ERROR;
            }
            return exitCode;
        }

        public static /* synthetic */ ExitCode doMainNoExit$default(Companion companion, CLITool cLITool, String[] stringArray, MessageRenderer messageRenderer, int n, Object object) {
            if ((n & 4) != 0) {
                messageRenderer = companion.defaultMessageRenderer();
            }
            return companion.doMainNoExit(cLITool, stringArray, messageRenderer);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ExitCode doMainNoExit(@NotNull CLITool<?> compiler, @NotNull String[] args) {
            return org.jetbrains.kotlin.cli.common.CLITool$Companion.doMainNoExit$default(this, compiler, args, null, 4, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

