/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r*\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u000e*\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCommonConstructorDelegationIssuesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "findCycle", "", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "knownCyclicConstructors", "getDelegated", "checkers"})
public final class FirCommonConstructorDelegationIssuesChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirCommonConstructorDelegationIssuesChecker INSTANCE = new FirCommonConstructorDelegationIssuesChecker();

    private FirCommonConstructorDelegationIssuesChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Object visited2;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Set cyclicConstructors = new LinkedHashSet();
        boolean hasPrimaryConstructor = false;
        Set otherConstructors = new LinkedHashSet();
        for (FirDeclaration it : declaration2.getDeclarations()) {
            if (!(it instanceof FirConstructor)) continue;
            if (!((FirConstructor)it).isPrimary()) {
                object3 = otherConstructors;
                object2 = it;
                object3.add(object2);
                object3 = this.findCycle((FirConstructor)it, cyclicConstructors);
                if (object3 == null) continue;
                visited2 = object2 = object3;
                boolean bl = false;
                object = cyclicConstructors;
                CollectionsKt.addAll(object, (Iterable)visited2);
                continue;
            }
            hasPrimaryConstructor = true;
        }
        Iterator iterator2 = otherConstructors;
        CollectionsKt.removeAll(iterator2, cyclicConstructors);
        if (hasPrimaryConstructor) {
            for (FirDeclaration it : otherConstructors) {
                object3 = ((FirConstructor)it).getDelegatedConstructor();
                if (object3 == null ? false : ((FirDelegatedConstructorCall)object3).isThis()) continue;
                object3 = ((FirConstructor)it).getDelegatedConstructor();
                if ((object3 == null ? null : ((FirDelegatedConstructorCall)object3).getSource()) != null) {
                    object3 = ((FirConstructor)it).getDelegatedConstructor();
                    DiagnosticReporterKt.reportOn$default(reporter, object3 == null ? null : ((FirDelegatedConstructorCall)object3).getSource(), FirErrors.INSTANCE.getPRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED(), context2, null, 8, null);
                    continue;
                }
                DiagnosticReporterKt.reportOn$default(reporter, ((FirConstructor)it).getSource(), FirErrors.INSTANCE.getPRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED(), context2, null, 8, null);
            }
        } else {
            for (FirDeclaration it : otherConstructors) {
                object2 = ((FirConstructor)it).getDelegatedConstructor();
                FirReference callee = object2 == null ? null : ((FirDelegatedConstructorCall)object2).getCalleeReference();
                if (!(callee instanceof FirErrorNamedReference) || !(((FirErrorNamedReference)callee).getDiagnostic() instanceof ConeAmbiguityError) || !(((object2 = ((FirConstructor)it).getDelegatedConstructor()) == null ? null : ((visited2 = ((FirDelegatedConstructorCall)object2).getSource()) == null ? null : ((FirSourceElement)visited2).getKind())) instanceof FirFakeSourceElementKind)) continue;
                DiagnosticReporterKt.reportOn$default(reporter, ((FirConstructor)it).getSource(), FirErrors.INSTANCE.getEXPLICIT_DELEGATION_CALL_REQUIRED(), context2, null, 8, null);
            }
        }
        Iterable $this$forEach$iv = cyclicConstructors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirConstructor it = (FirConstructor)element$iv;
            boolean bl = false;
            object = it.getDelegatedConstructor();
            DiagnosticReporterKt.reportOn$default(reporter, object == null ? null : ((FirDelegatedConstructorCall)object).getSource(), FirErrors.INSTANCE.getCYCLIC_CONSTRUCTOR_DELEGATION_CALL(), context2, null, 8, null);
        }
    }

    private final Set<FirConstructor> findCycle(FirConstructor $this$findCycle, Set<? extends FirConstructor> knownCyclicConstructors) {
        FirConstructor[] firConstructorArray = new FirConstructor[]{$this$findCycle};
        Set<FirConstructor> visitedConstructors = SetsKt.mutableSetOf(firConstructorArray);
        FirConstructor it = $this$findCycle;
        FirConstructor delegated = this.getDelegated($this$findCycle);
        while (!it.isPrimary() && delegated != null) {
            if (visitedConstructors.contains(delegated) || knownCyclicConstructors.contains(delegated)) {
                return visitedConstructors;
            }
            it = delegated;
            delegated = this.getDelegated(delegated);
            visitedConstructors.add(it);
        }
        return null;
    }

    private final FirConstructor getDelegated(FirConstructor $this$getDelegated) {
        FirResolvedNamedReference firResolvedNamedReference;
        FirPhaseManagerKt.ensureResolved($this$getDelegated.getSymbol(), FirResolvePhase.BODY_RESOLVE);
        Object object = $this$getDelegated.getDelegatedConstructor();
        FirReference $this$safeAs$iv = object == null ? null : ((FirDelegatedConstructorCall)object).getCalleeReference();
        boolean $i$f$safeAs = false;
        FirReference firReference = $this$safeAs$iv;
        if (!(firReference instanceof FirResolvedNamedReference)) {
            firReference = null;
        }
        FirBasedSymbol<?> delegatedConstructorSymbol = (firResolvedNamedReference = (FirResolvedNamedReference)firReference) == null ? null : firResolvedNamedReference.getResolvedSymbol();
        object = delegatedConstructorSymbol;
        firResolvedNamedReference = object == null ? null : ((FirBasedSymbol)object).getFir();
        return firResolvedNamedReference instanceof FirConstructor ? (FirConstructor)((Object)firResolvedNamedReference) : null;
    }
}

