/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirOptInAnnotationClassChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.resolve.checkers.Experimentality;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInAnnotationClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirOptInAnnotationClassChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirOptInAnnotationClassChecker INSTANCE = new FirOptInAnnotationClassChecker();

    private FirOptInAnnotationClassChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Set wrongTargets;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (declaration2.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        if (FirAnnotationHelpersKt.getAnnotationByClassId(declaration2, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID()) == null) {
            return;
        }
        if (FirAnnotationHelpersKt.getRetention(declaration2) == AnnotationRetention.SOURCE) {
            FirAnnotationCall target = FirAnnotationHelpersKt.getRetentionAnnotation(declaration2);
            FirAnnotationCall firAnnotationCall = target;
            DiagnosticReporterKt.reportOn$default(reporter, firAnnotationCall == null ? null : firAnnotationCall.getSource(), FirErrors.INSTANCE.getEXPERIMENTAL_ANNOTATION_WITH_WRONG_RETENTION(), context2, null, 8, null);
        }
        if (!((Collection)(wrongTargets = CollectionsKt.intersect((Iterable)FirAnnotationHelpersKt.getAllowedAnnotationTargets(declaration2), (Iterable)Experimentality.Companion.getWRONG_TARGETS_FOR_MARKER()))).isEmpty()) {
            FirAnnotationCall target = FirAnnotationHelpersKt.getTargetAnnotation(declaration2);
            FirAnnotationCall firAnnotationCall = target;
            DiagnosticReporterKt.reportOn$default(reporter, firAnnotationCall == null ? null : firAnnotationCall.getSource(), FirErrors.INSTANCE.getEXPERIMENTAL_ANNOTATION_WITH_WRONG_TARGET(), (Object)CollectionsKt.joinToString$default(wrongTargets, null, null, null, 0, null, check.1.INSTANCE, 31, null), context2, null, 16, null);
        }
    }
}

