/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirProjectionRelationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkTypeRef", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "ProjectionRelation", "checkers"})
public final class FirProjectionRelationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirProjectionRelationChecker INSTANCE = new FirProjectionRelationChecker();

    private FirProjectionRelationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (declaration2 instanceof FirPropertyAccessor) {
            return;
        }
        if (declaration2 instanceof FirTypedDeclaration) {
            this.checkTypeRef(((FirTypedDeclaration)declaration2).getReturnTypeRef(), context2, reporter);
        }
        if ((firDeclaration = declaration2) instanceof FirClass) {
            for (FirTypeRef it : ((FirClass)declaration2).getSuperTypeRefs()) {
                this.checkTypeRef(it, context2, reporter);
            }
        } else if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeRef(((FirTypeAlias)declaration2).getExpandedTypeRef(), context2, reporter);
        }
    }

    private final void checkTypeRef(FirTypeRef typeRef, CheckerContext context2, DiagnosticReporter reporter) {
        ConeClassLikeType type2;
        FirTypeRef $this$coneTypeSafe$iv = typeRef;
        boolean $i$f$coneTypeSafe = false;
        Object object = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = object == null ? null : ((FirResolvedTypeRef)object).getType();
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if (($i$f$coneTypeSafe = (type2 = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)))) == null) {
            return;
        }
        ConeClassLikeType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default($i$f$coneTypeSafe, context2.getSession(), null, 2, null);
        FirBasedSymbol<?> firBasedSymbol = TypeUtilsKt.toSymbol(fullyExpandedType2, context2.getSession());
        Object object2 = object = firBasedSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol : null;
        if (object == null) {
            return;
        }
        Object declaration2 = object;
        List<FirTypeParameterSymbol> typeParameters2 = ((FirClassSymbol)declaration2).getTypeParameterSymbols();
        ConeTypeProjection[] typeArguments2 = type2.getTypeArguments();
        int size = Math.min(typeParameters2.size(), typeArguments2.length);
        int n = 0;
        while (n < size) {
            Object object3;
            int it = n++;
            FirTypeParameterSymbol proto = typeParameters2.get(it);
            ConeTypeProjection actual = typeArguments2[it];
            ConeTypeProjection fullyExpandedProjection = fullyExpandedType2.getTypeArguments()[it];
            Variance protoVariance = proto.getVariance();
            ProjectionRelation projectionRelation = fullyExpandedProjection instanceof ConeKotlinTypeConflictingProjection || actual instanceof ConeKotlinTypeProjectionIn && protoVariance == Variance.OUT_VARIANCE || actual instanceof ConeKotlinTypeProjectionOut && protoVariance == Variance.IN_VARIANCE ? ProjectionRelation.Conflicting : (actual instanceof ConeKotlinTypeProjectionIn && protoVariance == Variance.IN_VARIANCE || actual instanceof ConeKotlinTypeProjectionOut && protoVariance == Variance.OUT_VARIANCE ? ProjectionRelation.Redundant : ProjectionRelation.None);
            Object object4 = FirHelpersKt.extractArgumentTypeRefAndSource(typeRef, it);
            if (object4 == null) continue;
            FirTypeRefSource argTypeRefSource = object4;
            if (projectionRelation != ProjectionRelation.None && !(((object4 = typeRef.getSource()) == null ? null : ((FirSourceElement)object4).getKind()) instanceof FirFakeSourceElementKind)) {
                object4 = argTypeRefSource.getSource();
                DiagnosticReporterKt.reportOn$default(reporter, (FirSourceElement)(object4 == null ? ((object3 = argTypeRefSource.getTypeRef()) == null ? null : ((FirTypeRef)object3).getSource()) : object4), projectionRelation == ProjectionRelation.Conflicting ? (!Intrinsics.areEqual(type2, fullyExpandedType2) ? FirErrors.INSTANCE.getCONFLICTING_PROJECTION_IN_TYPEALIAS_EXPANSION() : FirErrors.INSTANCE.getCONFLICTING_PROJECTION()) : FirErrors.INSTANCE.getREDUNDANT_PROJECTION(), (Object)fullyExpandedType2, context2, null, 16, null);
            }
            if ((object4 = argTypeRefSource.getTypeRef()) == null) continue;
            Object it2 = object3 = object4;
            boolean bl = false;
            INSTANCE.checkTypeRef((FirTypeRef)it2, context2, reporter);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirProjectionRelationChecker$ProjectionRelation;", "", "(Ljava/lang/String;I)V", "Conflicting", "Redundant", "None", "checkers"})
    private static final class ProjectionRelation
    extends Enum<ProjectionRelation> {
        public static final /* enum */ ProjectionRelation Conflicting = new ProjectionRelation();
        public static final /* enum */ ProjectionRelation Redundant = new ProjectionRelation();
        public static final /* enum */ ProjectionRelation None = new ProjectionRelation();
        private static final /* synthetic */ ProjectionRelation[] $VALUES;

        public static ProjectionRelation[] values() {
            return (ProjectionRelation[])$VALUES.clone();
        }

        public static ProjectionRelation valueOf(String value2) {
            return Enum.valueOf(ProjectionRelation.class, value2);
        }

        static {
            $VALUES = projectionRelationArray = new ProjectionRelation[]{ProjectionRelation.Conflicting, ProjectionRelation.Redundant, ProjectionRelation.None};
        }
    }
}

