/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.enhancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirPropertyAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaClass;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaField;
import org.jetbrains.kotlin.fir.java.enhancement.EnhancementResult;
import org.jetbrains.kotlin.fir.java.enhancement.IndexedJavaTypeQualifiers;
import org.jetbrains.kotlin.fir.java.enhancement.JavaTypeUtilsKt;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeAttribute;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeRawType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeArgumentList;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirStarProjectionBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirTypeProjectionWithVarianceBuilder;
import org.jetbrains.kotlin.fir.types.jvm.FirJavaTypeRef;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.typeEnhancement.JavaTypeQualifiers;
import org.jetbrains.kotlin.load.java.typeEnhancement.MutabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhancement.NullabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeComponentPosition;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeComponentPositionKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.AbstractStrictEqualityTypeChecker;
import org.jetbrains.kotlin.types.ConstantValueKind;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.NumbersKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\f\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u001a$\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0000\u001a$\u0010\u0016\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0003H\u0002\u001a4\u0010\u0018\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\u001c\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a2\u0010\u001f\u001a\u00020\u0011*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0003H\u0002\u001a\u001d\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\u0004\b\u0000\u0010#*\u0002H#H\u0002\u00a2\u0006\u0002\u0010$\u001a\"\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\"*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u001e\u0010&\u001a\u0004\u0018\u00010'*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)H\u0000\u001a\u000e\u0010*\u001a\u0004\u0018\u00010+*\u00020+H\u0002\u001a\u001d\u0010,\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\u0004\b\u0000\u0010#*\u0002H#H\u0002\u00a2\u0006\u0002\u0010$\u001a\u000e\u0010-\u001a\u0004\u0018\u00010+*\u00020+H\u0000\u001a\f\u0010.\u001a\u00020\u0003*\u00020\u0005H\u0002\u001a\u0012\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u000e*\u000201H\u0000\u001a\u0014\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001020\u000e*\u000202H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"KOTLIN_COLLECTIONS", "Lorg/jetbrains/kotlin/name/FqName;", "KOTLIN_COLLECTIONS_PREFIX_LENGTH", "", "coneFlexibleOrSimpleType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "lowerBound", "upperBound", "isNotNullTypeParameter", "", "computeTypeAttributesForJavaType", "Lorg/jetbrains/kotlin/fir/types/ConeAttributes;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "enhance", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/types/jvm/FirJavaTypeRef;", "qualifiers", "Lorg/jetbrains/kotlin/fir/java/enhancement/IndexedJavaTypeQualifiers;", "typeWithoutEnhancement", "enhanceConeKotlinType", "index", "enhanceInflexibleType", "position", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/TypeComponentPosition;", "isBoundOfRawType", "enhanceMutability", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassifierLookupTag;", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/JavaTypeQualifiers;", "enhancePossiblyFlexible", "annotations", "enhancedNullability", "Lorg/jetbrains/kotlin/fir/java/enhancement/EnhancementResult;", "T", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/java/enhancement/EnhancementResult;", "getEnhancedNullability", "lexicalCastFrom", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "value", "", "mutableToReadOnly", "Lorg/jetbrains/kotlin/name/ClassId;", "noChange", "readOnlyToMutable", "subtreeSize", "typeArguments", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "java"})
public final class JavaTypeUtilsKt {
    @NotNull
    private static final FqName KOTLIN_COLLECTIONS = new FqName("kotlin.collections");
    private static final int KOTLIN_COLLECTIONS_PREFIX_LENGTH = KOTLIN_COLLECTIONS.asString().length() + 1;

    @NotNull
    public static final FirResolvedTypeRef enhance(@NotNull FirJavaTypeRef $this$enhance, @NotNull FirSession session2, @NotNull IndexedJavaTypeQualifiers qualifiers, @NotNull ConeKotlinType typeWithoutEnhancement) {
        Intrinsics.checkNotNullParameter($this$enhance, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(qualifiers, "qualifiers");
        Intrinsics.checkNotNullParameter(typeWithoutEnhancement, "typeWithoutEnhancement");
        return JavaTypeUtilsKt.enhancePossiblyFlexible(typeWithoutEnhancement, session2, $this$enhance.getAnnotations(), qualifiers, 0);
    }

    private static final FirResolvedTypeRef enhancePossiblyFlexible(ConeKotlinType $this$enhancePossiblyFlexible, FirSession session2, List<? extends FirAnnotationCall> annotations2, IndexedJavaTypeQualifiers qualifiers, int index2) {
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        ConeKotlinType enhanced = JavaTypeUtilsKt.enhanceConeKotlinType($this$enhancePossiblyFlexible, session2, qualifiers, index2);
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder $this$enhancePossiblyFlexible_u24lambda_u2d0 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        boolean bl = false;
        $this$enhancePossiblyFlexible_u24lambda_u2d0.setType(enhanced);
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = $this$enhancePossiblyFlexible_u24lambda_u2d0;
        Collection collection = firResolvedTypeRefBuilder2.getAnnotations();
        CollectionsKt.addAll(collection, (Iterable)annotations2);
        return firResolvedTypeRefBuilder.build();
    }

    private static final ConeKotlinType enhanceConeKotlinType(ConeKotlinType $this$enhanceConeKotlinType, FirSession session2, IndexedJavaTypeQualifiers qualifiers, int index2) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2 = $this$enhanceConeKotlinType;
        if (coneKotlinType2 instanceof ConeFlexibleType) {
            boolean isRawType = $this$enhanceConeKotlinType instanceof ConeRawType;
            ConeKotlinType lowerResult = JavaTypeUtilsKt.enhanceInflexibleType(((ConeFlexibleType)$this$enhanceConeKotlinType).getLowerBound(), session2, TypeComponentPosition.FLEXIBLE_LOWER, qualifiers, index2, isRawType);
            ConeKotlinType upperResult = JavaTypeUtilsKt.enhanceInflexibleType(((ConeFlexibleType)$this$enhanceConeKotlinType).getUpperBound(), session2, TypeComponentPosition.FLEXIBLE_UPPER, qualifiers, index2, isRawType);
            coneKotlinType = lowerResult == ((ConeFlexibleType)$this$enhanceConeKotlinType).getLowerBound() && upperResult == ((ConeFlexibleType)$this$enhanceConeKotlinType).getUpperBound() ? $this$enhanceConeKotlinType : ($this$enhanceConeKotlinType instanceof ConeRawType ? (ConeKotlinType)new ConeRawType(lowerResult, upperResult) : JavaTypeUtilsKt.coneFlexibleOrSimpleType(session2, lowerResult, upperResult, qualifiers.invoke(index2).getDefinitelyNotNull()));
        } else {
            coneKotlinType = coneKotlinType2 instanceof ConeSimpleKotlinType ? JavaTypeUtilsKt.enhanceInflexibleType($this$enhanceConeKotlinType, session2, TypeComponentPosition.INFLEXIBLE, qualifiers, index2, false) : $this$enhanceConeKotlinType;
        }
        return coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private static final int subtreeSize(ConeKotlinType $this$subtreeSize) {
        int n;
        ConeTypeProjection[] coneTypeProjectionArray = $this$subtreeSize.getTypeArguments();
        int n2 = 1;
        int n3 = 0;
        for (ConeTypeProjection coneTypeProjection : coneTypeProjectionArray) {
            void it;
            ConeTypeProjection coneTypeProjection2 = coneTypeProjection;
            n = n3;
            boolean bl = false;
            ConeKotlinType coneKotlinType = it instanceof ConeKotlinType ? (ConeKotlinType)it : null;
            int n4 = (coneKotlinType == null ? 0 : JavaTypeUtilsKt.subtreeSize(coneKotlinType)) + 1;
            n3 = n + n4;
        }
        n = n3;
        return n2 + n;
    }

    private static final ConeKotlinType coneFlexibleOrSimpleType(FirSession session2, ConeKotlinType lowerBound, ConeKotlinType upperBound, boolean isNotNullTypeParameter) {
        if (AbstractStrictEqualityTypeChecker.INSTANCE.strictEqualTypes(SessionUtilsKt.getTypeContext(session2), lowerBound, upperBound)) {
            ConeClassifierLookupTag lookupTag;
            ConeSimpleKotlinType coneSimpleKotlinType = lowerBound instanceof ConeLookupTagBasedType ? (ConeLookupTagBasedType)lowerBound : null;
            ConeClassifierLookupTag coneClassifierLookupTag = lookupTag = coneSimpleKotlinType == null ? null : coneSimpleKotlinType.getLookupTag();
            if (isNotNullTypeParameter && lookupTag instanceof ConeTypeParameterLookupTag && !ConeTypeUtilsKt.isMarkedNullable(lowerBound)) {
                boolean bl;
                block6: {
                    Iterable $this$any$iv = ((FirTypeParameter)((ConeTypeParameterLookupTag)lookupTag).getTypeParameterSymbol().getFir()).getBounds();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirTypeRef it = (FirTypeRef)element$iv;
                            boolean bl2 = false;
                            ConeKotlinType type2 = FirTypeUtilsKt.getConeType(it);
                            if (!(type2 instanceof ConeTypeParameterType || ConeTypeUtilsKt.isNullable(type2))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    coneSimpleKotlinType = TypeUtilsKt.create(ConeDefinitelyNotNullType.Companion, lowerBound, SessionUtilsKt.getTypeContext(session2), true);
                    return coneSimpleKotlinType == null ? lowerBound : (ConeKotlinType)coneSimpleKotlinType;
                }
            }
            return lowerBound;
        }
        return new ConeFlexibleType(lowerBound, upperBound);
    }

    @Nullable
    public static final ClassId readOnlyToMutable(@NotNull ClassId $this$readOnlyToMutable) {
        ClassId classId;
        FqName mutableFqName;
        Intrinsics.checkNotNullParameter($this$readOnlyToMutable, "<this>");
        FqName fqName2 = mutableFqName = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable($this$readOnlyToMutable.asSingleFqName().toUnsafe());
        if (fqName2 == null) {
            classId = null;
        } else {
            FqName fqName3;
            FqName it = fqName3 = fqName2;
            boolean bl = false;
            String string2 = it.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "it.asString()");
            String string3 = string2.substring(KOTLIN_COLLECTIONS_PREFIX_LENGTH);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
            ClassId classId2 = new ClassId(KOTLIN_COLLECTIONS, new FqName(string3), false);
            classId = classId2;
        }
        return classId;
    }

    private static final ClassId mutableToReadOnly(ClassId $this$mutableToReadOnly) {
        ClassId classId;
        FqName readOnlyFqName = JavaToKotlinClassMap.INSTANCE.mutableToReadOnly($this$mutableToReadOnly.asSingleFqName().toUnsafe());
        FqName fqName2 = readOnlyFqName;
        if (fqName2 == null) {
            classId = null;
        } else {
            FqName fqName3;
            FqName it = fqName3 = fqName2;
            boolean bl = false;
            String string2 = it.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "it.asString()");
            String string3 = string2.substring(KOTLIN_COLLECTIONS_PREFIX_LENGTH);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
            ClassId classId2 = new ClassId(KOTLIN_COLLECTIONS, new FqName(string3), false);
            classId = classId2;
        }
        return classId;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConeKotlinType enhanceInflexibleType(ConeKotlinType $this$enhanceInflexibleType, FirSession session2, TypeComponentPosition position, IndexedJavaTypeQualifiers qualifiers, int index2, boolean isBoundOfRawType) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        boolean bl;
        boolean bl2 = bl = !($this$enhanceInflexibleType instanceof ConeFlexibleType);
        if (!bl) {
            boolean $i$a$-require-JavaTypeUtilsKt$enhanceInflexibleType$22 = false;
            String $i$a$-require-JavaTypeUtilsKt$enhanceInflexibleType$22 = $this$enhanceInflexibleType + " should not be flexible";
            throw new IllegalArgumentException($i$a$-require-JavaTypeUtilsKt$enhanceInflexibleType$22.toString());
        }
        boolean shouldEnhance = TypeComponentPositionKt.shouldEnhance(position);
        if (!shouldEnhance && $this$enhanceInflexibleType.getTypeArguments().length == 0 || !($this$enhanceInflexibleType instanceof ConeLookupTagBasedType)) {
            return $this$enhanceInflexibleType;
        }
        ConeClassifierLookupTag originalTag = ((ConeLookupTagBasedType)$this$enhanceInflexibleType).getLookupTag();
        JavaTypeQualifiers effectiveQualifiers = qualifiers.invoke(index2);
        ConeClassifierLookupTag enhancedTag = JavaTypeUtilsKt.enhanceMutability(originalTag, effectiveQualifiers, position);
        boolean wereChangesInArgs = false;
        int globalArgIndex = 0;
        globalArgIndex = index2 + 1;
        Object $this$map$iv = $this$enhanceInflexibleType.getTypeArguments();
        boolean $i$f$map = false;
        ConeTypeProjection[] coneTypeProjectionArray = $this$map$iv;
        ConeTypeProjection[] destination$iv$iv = (ConeTypeProjection[])new ArrayList(((ConeTypeProjection[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        ConeAttribute<?> coneAttribute = $this$mapTo$iv$iv;
        int n = 0;
        int n2 = ((void)coneAttribute).length;
        while (n < n2) {
            ConeTypeProjection coneTypeProjection;
            int n3;
            void arg;
            void item$iv$iv = coneAttribute[n];
            ++n;
            void var22_25 = item$iv$iv;
            ConeTypeProjection[] coneTypeProjectionArray2 = destination$iv$iv;
            boolean bl3 = false;
            if (arg.getKind() != ProjectionKind.INVARIANT) {
                n3 = globalArgIndex;
                globalArgIndex = n3 + 1;
                coneTypeProjection = arg;
            } else {
                n3 = arg instanceof ConeKotlinType;
                if (n3 == 0) {
                    boolean bl4 = false;
                    String string2 = Intrinsics.stringPlus("Should be invariant type: ", arg);
                    throw new IllegalArgumentException(string2.toString());
                }
                ConeKotlinType enhanced = JavaTypeUtilsKt.enhanceConeKotlinType((ConeKotlinType)arg, session2, qualifiers, globalArgIndex += JavaTypeUtilsKt.subtreeSize((ConeKotlinType)arg));
                wereChangesInArgs = wereChangesInArgs || enhanced != arg;
                coneTypeProjection = enhanced.getType();
            }
            void var27_30 = coneTypeProjection;
            coneTypeProjectionArray2.add(var27_30);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        destination$iv$iv = thisCollection$iv.toArray(new ConeTypeProjection[0]);
        if (destination$iv$iv == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        ConeTypeProjection[] enhancedArguments = destination$iv$iv;
        EnhancementResult<Boolean> enhancementResult = JavaTypeUtilsKt.getEnhancedNullability($this$enhanceInflexibleType, effectiveQualifiers, position);
        boolean enhancedNullability = enhancementResult.component1();
        ConeAttribute<?> enhancedNullabilityAttribute = enhancementResult.component2();
        boolean bl5 = wereChangesInArgs = wereChangesInArgs || enhancedNullabilityAttribute != null && !CompilerConeAttributesKt.getHasEnhancedNullability($this$enhanceInflexibleType);
        if (!wereChangesInArgs && Intrinsics.areEqual(originalTag, enhancedTag) && enhancedNullability == ConeTypeUtilsKt.isNullable($this$enhanceInflexibleType)) {
            return $this$enhanceInflexibleType;
        }
        ConeAttributes attributes2 = null;
        attributes2 = $this$enhanceInflexibleType.getAttributes();
        ConeAttribute<?> coneAttribute2 = enhancedNullabilityAttribute;
        if (coneAttribute2 != null) {
            ConeAttribute<?> it = coneAttribute = coneAttribute2;
            boolean bl6 = false;
            attributes2 = attributes2.plus(it);
        }
        return TypeConstructionUtilsKt.constructType(enhancedTag, enhancedArguments, enhancedNullability, attributes2);
    }

    private static final <T> EnhancementResult<T> noChange(T $this$noChange) {
        return new EnhancementResult<T>($this$noChange, null);
    }

    private static final <T> EnhancementResult<T> enhancedNullability(T $this$enhancedNullability) {
        return new EnhancementResult<T>($this$enhancedNullability, CompilerConeAttributes.EnhancedNullability.INSTANCE);
    }

    private static final EnhancementResult<Boolean> getEnhancedNullability(ConeKotlinType $this$getEnhancedNullability, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        EnhancementResult<Boolean> enhancementResult;
        if (!TypeComponentPositionKt.shouldEnhance(position)) {
            return JavaTypeUtilsKt.noChange(ConeTypeUtilsKt.isMarkedNullable($this$getEnhancedNullability));
        }
        NullabilityQualifier nullabilityQualifier = qualifiers.getNullability();
        int n = nullabilityQualifier == null ? -1 : WhenMappings.$EnumSwitchMapping$0[nullabilityQualifier.ordinal()];
        switch (n) {
            case 1: {
                enhancementResult = JavaTypeUtilsKt.noChange(true);
                break;
            }
            case 2: {
                enhancementResult = JavaTypeUtilsKt.enhancedNullability(false);
                break;
            }
            default: {
                enhancementResult = JavaTypeUtilsKt.noChange(ConeTypeUtilsKt.isMarkedNullable($this$getEnhancedNullability));
            }
        }
        return enhancementResult;
    }

    private static final ConeClassifierLookupTag enhanceMutability(ConeClassifierLookupTag $this$enhanceMutability, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        if (!TypeComponentPositionKt.shouldEnhance(position)) {
            return $this$enhanceMutability;
        }
        if (!($this$enhanceMutability instanceof ConeClassLikeLookupTag)) {
            return $this$enhanceMutability;
        }
        MutabilityQualifier mutabilityQualifier = qualifiers.getMutability();
        int n = mutabilityQualifier == null ? -1 : WhenMappings.$EnumSwitchMapping$1[mutabilityQualifier.ordinal()];
        switch (n) {
            case 1: {
                ClassId readOnlyId = JavaTypeUtilsKt.mutableToReadOnly(((ConeClassLikeLookupTag)$this$enhanceMutability).getClassId());
                if (position != TypeComponentPosition.FLEXIBLE_LOWER || readOnlyId == null) break;
                return new ConeClassLikeLookupTagImpl(readOnlyId);
            }
            case 2: {
                ClassId mutableId = JavaTypeUtilsKt.readOnlyToMutable(((ConeClassLikeLookupTag)$this$enhanceMutability).getClassId());
                if (position != TypeComponentPosition.FLEXIBLE_UPPER || mutableId == null) break;
                return new ConeClassLikeLookupTagImpl(mutableId);
            }
        }
        return $this$enhanceMutability;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirTypeProjection> typeArguments(@NotNull FirTypeRef $this$typeArguments) {
        Object object;
        Intrinsics.checkNotNullParameter($this$typeArguments, "<this>");
        FirTypeRef firTypeRef = $this$typeArguments;
        if (firTypeRef instanceof FirUserTypeRef) {
            FirTypeArgumentList firTypeArgumentList;
            Object object2;
            FirQualifierPart firQualifierPart = CollectionsKt.lastOrNull(((FirUserTypeRef)$this$typeArguments).getQualifier());
            if (firQualifierPart == null) {
                object2 = null;
            } else {
                firTypeArgumentList = firQualifierPart.getTypeArgumentList();
                object2 = firTypeArgumentList = firTypeArgumentList.getTypeArguments();
            }
            object = firTypeArgumentList == null ? CollectionsKt.emptyList() : firTypeArgumentList;
        } else if (firTypeRef instanceof FirResolvedTypeRef) {
            void $this$mapTo$iv$iv;
            ConeTypeProjection[] $this$map$iv = ((FirResolvedTypeRef)$this$typeArguments).getType().getTypeArguments();
            boolean $i$f$map = false;
            ConeTypeProjection[] coneTypeProjectionArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var7_9 = $this$mapTo$iv$iv;
            int n = 0;
            int n2 = ((void)var7_9).length;
            while (n < n2) {
                FirTypeProjection firTypeProjection;
                FirStarProjectionBuilder $this$typeArguments_u24lambda_u2d12_u24lambda_u2d9;
                void it;
                void item$iv$iv = var7_9[n];
                ++n;
                void var11_13 = item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var13_15 = it;
                if (var13_15 instanceof ConeStarProjection) {
                    FirStarProjectionBuilder firStarProjectionBuilder;
                    boolean $i$f$buildStarProjection = false;
                    $this$typeArguments_u24lambda_u2d12_u24lambda_u2d9 = firStarProjectionBuilder = new FirStarProjectionBuilder();
                    boolean bl2 = false;
                    firTypeProjection = firStarProjectionBuilder.build();
                } else {
                    void $this$typeArguments_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10;
                    FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
                    Variance variance;
                    FirTypeProjectionWithVarianceBuilder firTypeProjectionWithVarianceBuilder;
                    ConeKotlinType coneKotlinType;
                    ProjectionKind kind = it.getKind();
                    $this$typeArguments_u24lambda_u2d12_u24lambda_u2d9 = it;
                    if ($this$typeArguments_u24lambda_u2d12_u24lambda_u2d9 instanceof ConeKotlinTypeProjection) {
                        coneKotlinType = ((ConeKotlinTypeProjection)it).getType();
                    } else if ($this$typeArguments_u24lambda_u2d12_u24lambda_u2d9 instanceof ConeKotlinType) {
                        coneKotlinType = (ConeKotlinType)it;
                    } else {
                        throw new IllegalStateException("Should not be here".toString());
                    }
                    ConeKotlinType type2 = coneKotlinType;
                    boolean $i$f$buildTypeProjectionWithVariance = false;
                    FirTypeProjectionWithVarianceBuilder $this$typeArguments_u24lambda_u2d12_u24lambda_u2d11 = firTypeProjectionWithVarianceBuilder = new FirTypeProjectionWithVarianceBuilder();
                    boolean bl3 = false;
                    ProjectionKind projectionKind = kind;
                    int n3 = WhenMappings.$EnumSwitchMapping$2[projectionKind.ordinal()];
                    switch (n3) {
                        case 1: {
                            variance = Variance.IN_VARIANCE;
                            break;
                        }
                        case 2: {
                            variance = Variance.OUT_VARIANCE;
                            break;
                        }
                        case 3: {
                            variance = Variance.INVARIANT;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Should not be here".toString());
                        }
                    }
                    $this$typeArguments_u24lambda_u2d12_u24lambda_u2d11.setVariance(variance);
                    boolean $i$f$buildResolvedTypeRef = false;
                    FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
                    FirTypeProjectionWithVarianceBuilder firTypeProjectionWithVarianceBuilder2 = $this$typeArguments_u24lambda_u2d12_u24lambda_u2d11;
                    boolean bl4 = false;
                    $this$typeArguments_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10.setType(type2);
                    Unit unit2 = Unit.INSTANCE;
                    firTypeProjectionWithVarianceBuilder2.setTypeRef(firResolvedTypeRefBuilder.build());
                    firTypeProjection = firTypeProjectionWithVarianceBuilder.build();
                }
                FirTypeProjection firTypeProjection2 = firTypeProjection;
                collection.add(firTypeProjection2);
            }
            object = (List)destination$iv$iv;
        } else {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public static final List<JavaType> typeArguments(@NotNull JavaType $this$typeArguments) {
        Intrinsics.checkNotNullParameter($this$typeArguments, "<this>");
        JavaClassifierType javaClassifierType = $this$typeArguments instanceof JavaClassifierType ? (JavaClassifierType)$this$typeArguments : null;
        List<JavaType> list2 = javaClassifierType == null ? null : javaClassifierType.getTypeArguments();
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public static final FirExpression lexicalCastFrom(@NotNull ConeKotlinType $this$lexicalCastFrom, @NotNull FirSession session, @NotNull String value) {
        block51: {
            block53: {
                block54: {
                    block50: {
                        block52: {
                            block49: {
                                Intrinsics.checkNotNullParameter($this$lexicalCastFrom, "<this>");
                                Intrinsics.checkNotNullParameter(session, "session");
                                Intrinsics.checkNotNullParameter(value, "value");
                                var4_3 = $this$lexicalCastFrom;
                                if (!(var4_3 instanceof ConeLookupTagBasedType)) {
                                    if (var4_3 instanceof ConeFlexibleType) {
                                        return JavaTypeUtilsKt.lexicalCastFrom(((ConeFlexibleType)$this$lexicalCastFrom).getLowerBound(), session, value);
                                    }
                                    return null;
                                }
                                lookupTagBasedType = (ConeLookupTagBasedType)$this$lexicalCastFrom;
                                lookupTag = lookupTagBasedType.getLookupTag();
                                var6_5 = LookupTagUtilsKt.toSymbol(lookupTag, session);
                                v0 = firElement = var6_5 == null ? null : var6_5.getFir();
                                if (!(firElement instanceof FirRegularClass) || ((FirRegularClass)firElement).getClassKind() != ClassKind.ENUM_CLASS) break block51;
                                var7_7 = Name.identifier(value);
                                Intrinsics.checkNotNullExpressionValue(var7_7, "identifier(value)");
                                name = var7_7;
                                var8_9 = FirDeclarationUtilKt.collectEnumEntries(firElement);
                                var9_12 = var8_9;
                                var10_15 = var9_12.iterator();
                                while (var10_15.hasNext()) {
                                    var11_19 = var10_15.next();
                                    it = (FirEnumEntry)var11_19;
                                    $i$a$-find-JavaTypeUtilsKt$lexicalCastFrom$firEnumEntry$1 = false;
                                    if (!Intrinsics.areEqual(it.getName(), name)) continue;
                                    v1 = var11_19;
                                    break block49;
                                }
                                v1 = null;
                            }
                            firEnumEntry = v1;
                            if (firEnumEntry == null) break block52;
                            $i$f$buildPropertyAccessExpression = false;
                            $this$lexicalCastFrom_u24lambda_u2d15 = var9_12 = new FirPropertyAccessExpressionBuilder();
                            $i$a$-buildPropertyAccessExpression-JavaTypeUtilsKt$lexicalCastFrom$1 = false;
                            $i$f$buildResolvedNamedReference = false;
                            var14_35 = $i$a$-find-JavaTypeUtilsKt$lexicalCastFrom$firEnumEntry$1 = new FirResolvedNamedReferenceBuilder();
                            var15_39 = $this$lexicalCastFrom_u24lambda_u2d15;
                            $i$a$-buildResolvedNamedReference-JavaTypeUtilsKt$lexicalCastFrom$1$1 = false;
                            $this$lexicalCastFrom_u24lambda_u2d15_u24lambda_u2d14.setName(name);
                            $this$lexicalCastFrom_u24lambda_u2d15_u24lambda_u2d14.setResolvedSymbol(firEnumEntry.getSymbol());
                            var17_44 = Unit.INSTANCE;
                            var15_39.setCalleeReference($i$a$-find-JavaTypeUtilsKt$lexicalCastFrom$firEnumEntry$1.build());
                            v2 = var9_12.build();
                            break block53;
                        }
                        if (!(firElement instanceof FirJavaClass)) break block54;
                        $this$filterIsInstance$iv = ((FirJavaClass)firElement).getDeclarations();
                        $i$f$filterIsInstance = false;
                        $i$a$-buildPropertyAccessExpression-JavaTypeUtilsKt$lexicalCastFrom$1 = $this$filterIsInstance$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterIsInstanceTo = false;
                        $this$lexicalCastFrom_u24lambda_u2d15_u24lambda_u2d14 = $this$filterIsInstanceTo$iv$iv.iterator();
                        while ($this$lexicalCastFrom_u24lambda_u2d15_u24lambda_u2d14.hasNext()) {
                            element$iv$iv = $this$lexicalCastFrom_u24lambda_u2d15_u24lambda_u2d14.next();
                            if (!(element$iv$iv instanceof FirJavaField)) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        $this$filterIsInstance$iv = (List)destination$iv$iv /* !! */ ;
                        var10_17 = $this$filterIsInstance$iv;
                        $this$filterIsInstanceTo$iv$iv = var10_17.iterator();
                        while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                            destination$iv$iv /* !! */  = $this$filterIsInstanceTo$iv$iv.next();
                            it = (FirJavaField)destination$iv$iv /* !! */ ;
                            $i$a$-find-JavaTypeUtilsKt$lexicalCastFrom$firStaticProperty$1 = false;
                            $this$isStatic$iv = it;
                            $i$f$isStatic = false;
                            if (!$this$isStatic$iv.getStatus().isStatic()) ** GOTO lbl-1000
                            $this$modality$iv = it;
                            $i$f$getModality = false;
                            if ($this$modality$iv.getStatus().getModality() == Modality.FINAL && Intrinsics.areEqual(it.getName(), name)) {
                                v3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v3 = false;
                            }
                            if (!v3) continue;
                            v4 /* !! */  = destination$iv$iv /* !! */ ;
                            break block50;
                        }
                        v4 /* !! */  = null;
                    }
                    firStaticProperty = (FirJavaField)v4 /* !! */ ;
                    if (firStaticProperty != null) {
                        $i$f$buildPropertyAccessExpression = false;
                        $this$lexicalCastFrom_u24lambda_u2d18 = var10_17 = new FirPropertyAccessExpressionBuilder();
                        $i$a$-buildPropertyAccessExpression-JavaTypeUtilsKt$lexicalCastFrom$2 = false;
                        $i$f$buildResolvedNamedReference = false;
                        var14_38 = new FirResolvedNamedReferenceBuilder();
                        $this$modality$iv = var14_38;
                        var16_43 = $this$lexicalCastFrom_u24lambda_u2d18;
                        $i$a$-buildResolvedNamedReference-JavaTypeUtilsKt$lexicalCastFrom$2$1 = false;
                        $this$lexicalCastFrom_u24lambda_u2d18_u24lambda_u2d17.setName(name);
                        $this$lexicalCastFrom_u24lambda_u2d18_u24lambda_u2d17.setResolvedSymbol(firStaticProperty.getSymbol());
                        var18_46 = Unit.INSTANCE;
                        var16_43.setCalleeReference(var14_38.build());
                        v5 = var10_17.build();
                    } else {
                        v5 = null;
                    }
                    v2 = v5;
                    break block53;
                }
                v2 = null;
            }
            return v2;
        }
        if (!(lookupTag instanceof ConeClassLikeLookupTag)) {
            return null;
        }
        classId = ((ConeClassLikeLookupTag)lookupTag).getClassId();
        if (!Intrinsics.areEqual(classId.getPackageFqName(), new FqName("kotlin"))) {
            return null;
        }
        var7_8 = NumbersKt.extractRadix(value);
        number = var7_8.component1();
        radix = var7_8.component2();
        var10_18 = classId.getRelativeClassName().asString();
        tmp = -1;
        switch (var10_18.hashCode()) {
            case 67973692: {
                if (var10_18.equals("Float")) {
                    tmp = 1;
                }
                break;
            }
            case 2099062: {
                if (var10_18.equals("Char")) {
                    tmp = 2;
                }
                break;
            }
            case 2086184: {
                if (var10_18.equals("Byte")) {
                    tmp = 3;
                }
                break;
            }
            case 2374300: {
                if (var10_18.equals("Long")) {
                    tmp = 4;
                }
                break;
            }
            case -1808118735: {
                if (var10_18.equals("String")) {
                    tmp = 5;
                }
                break;
            }
            case 1729365000: {
                if (var10_18.equals("Boolean")) {
                    tmp = 6;
                }
                break;
            }
            case 2052876273: {
                if (var10_18.equals("Double")) {
                    tmp = 7;
                }
                break;
            }
            case 79860828: {
                if (var10_18.equals("Short")) {
                    tmp = 8;
                }
                break;
            }
            case 73679: {
                if (var10_18.equals("Int")) {
                    tmp = 9;
                }
                break;
            }
        }
        switch (tmp) {
            case 6: {
                v6 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Boolean.INSTANCE, Boolean.parseBoolean(value), null, false, 24, null);
                break;
            }
            case 2: {
                var11_21 = StringsKt.singleOrNull(value);
                if (var11_21 == null) {
                    return null;
                }
                v6 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Char.INSTANCE, Character.valueOf(var11_21.charValue()), null, false, 24, null);
                break;
            }
            case 3: {
                var11_22 = StringsKt.toByteOrNull(number, radix);
                if (var11_22 == null) {
                    return null;
                }
                v6 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Byte.INSTANCE, (byte)var11_22, null, false, 24, null);
                break;
            }
            case 8: {
                var11_23 = StringsKt.toShortOrNull(number, radix);
                if (var11_23 == null) {
                    return null;
                }
                v6 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Short.INSTANCE, (short)var11_23, null, false, 24, null);
                break;
            }
            case 9: {
                var11_24 = StringsKt.toIntOrNull(number, radix);
                if (var11_24 == null) {
                    return null;
                }
                v6 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Int.INSTANCE, (int)var11_24, null, false, 24, null);
                break;
            }
            case 4: {
                var11_25 = StringsKt.toLongOrNull(number, radix);
                if (var11_25 == null) {
                    return null;
                }
                v6 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Long.INSTANCE, (long)var11_25, null, false, 24, null);
                break;
            }
            case 1: {
                var11_26 = StringsKt.toFloatOrNull(value);
                if (var11_26 == null) {
                    return null;
                }
                v6 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Float.INSTANCE, Float.valueOf(var11_26.floatValue()), null, false, 24, null);
                break;
            }
            case 7: {
                var11_27 = StringsKt.toDoubleOrNull(value);
                if (var11_27 == null) {
                    return null;
                }
                v6 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Double.INSTANCE, (double)var11_27, null, false, 24, null);
                break;
            }
            case 5: {
                v6 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.String.INSTANCE, value, null, false, 24, null);
                break;
            }
            default: {
                v6 = null;
            }
        }
        return v6;
    }

    @NotNull
    public static final ConeAttributes computeTypeAttributesForJavaType(@NotNull List<? extends FirAnnotationCall> $this$computeTypeAttributesForJavaType) {
        Intrinsics.checkNotNullParameter($this$computeTypeAttributesForJavaType, "<this>");
        return FirTypeUtilsKt.computeTypeAttributes($this$computeTypeAttributesForJavaType, computeTypeAttributesForJavaType.1.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[NullabilityQualifier.values().length];
            nArray[NullabilityQualifier.NULLABLE.ordinal()] = 1;
            nArray[NullabilityQualifier.NOT_NULL.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MutabilityQualifier.values().length];
            nArray[MutabilityQualifier.READ_ONLY.ordinal()] = 1;
            nArray[MutabilityQualifier.MUTABLE.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ProjectionKind.values().length];
            nArray[ProjectionKind.IN.ordinal()] = 1;
            nArray[ProjectionKind.OUT.ordinal()] = 2;
            nArray[ProjectionKind.INVARIANT.ordinal()] = 3;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

