/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.GeneratedDeclarationValidationKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationBuildingUtilsKt;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtension;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtensionKt;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProvider;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirGlobalResolveProcessor;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.GeneratedClass;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.GeneratedClassIndex;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.GeneratedClassIndexKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirGlobalNewMemberGenerationProcessor;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirGlobalResolveProcessor;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "index", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/GeneratedClassIndex;", "provider", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProvider;", "fillGeneratedClasses", "", "extension", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "generateNewMembers", "process", "files", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "resolve"})
public final class FirGlobalNewMemberGenerationProcessor
extends FirGlobalResolveProcessor {
    @NotNull
    private final GeneratedClassIndex index;
    @NotNull
    private final FirPredicateBasedProvider provider;

    public FirGlobalNewMemberGenerationProcessor(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        super(session2, scopeSession);
        this.index = GeneratedClassIndexKt.getGeneratedClassIndex(session2);
        this.provider = FirPredicateBasedProviderKt.getPredicateBasedProvider(session2);
    }

    @Override
    public void process(@NotNull Collection<? extends FirFile> files2) {
        Intrinsics.checkNotNullParameter(files2, "files");
        List<FirDeclarationGenerationExtension> extensions = FirDeclarationGenerationExtensionKt.getDeclarationGenerators(FirExtensionServiceKt.getExtensionService(this.getSession()));
        if (extensions.isEmpty()) {
            return;
        }
        for (FirDeclarationGenerationExtension extension : extensions) {
            this.generateNewMembers(extension);
            this.fillGeneratedClasses(extension);
        }
    }

    private final void generateNewMembers(FirDeclarationGenerationExtension extension) {
        List<Pair<FirAnnotatedDeclaration, List<FirAnnotatedDeclaration>>> declarations2 = this.provider.getSymbolsWithOwnersByPredicate(extension.getPredicate());
        for (Pair<FirAnnotatedDeclaration, List<FirAnnotatedDeclaration>> pair : declarations2) {
            FirAnnotatedDeclaration declaration2 = pair.component1();
            List<FirAnnotatedDeclaration> owners = pair.component2();
            List<FirDeclarationGenerationExtension.GeneratedDeclaration<?>> newMembers = extension.generateMembers(declaration2, owners);
            for (FirDeclarationGenerationExtension.GeneratedDeclaration<?> generatedDeclaration : newMembers) {
                Object newMember = generatedDeclaration.component1();
                FirAnnotatedDeclaration owner = generatedDeclaration.component2();
                GeneratedDeclarationValidationKt.validate((FirElement)newMember);
                FirAnnotatedDeclaration firAnnotatedDeclaration = owner;
                if (firAnnotatedDeclaration instanceof FirRegularClass) {
                    FirDeclarationBuildingUtilsKt.addDeclaration((FirRegularClass)owner, newMember);
                } else if (firAnnotatedDeclaration instanceof FirFile) {
                    FirDeclarationBuildingUtilsKt.addDeclaration((FirFile)owner, newMember);
                } else {
                    throw new IllegalStateException("Should not be here".toString());
                }
                MainSessionComponentsKt.getFirProvider(this.getSession()).recordGeneratedMember(owner, (FirDeclaration)newMember);
            }
        }
    }

    private final void fillGeneratedClasses(FirDeclarationGenerationExtension extension) {
        for (GeneratedClass generatedClass : this.index.get(extension.getKey())) {
            FirRegularClass klass = generatedClass.getKlass();
            List<FirDeclaration> newMembers = extension.generateMembersForGeneratedClass(generatedClass);
            for (FirDeclaration newMember : newMembers) {
                GeneratedDeclarationValidationKt.validate(newMember);
                FirDeclarationBuildingUtilsKt.addDeclaration(klass, newMember);
                MainSessionComponentsKt.getFirProvider(this.getSession()).recordGeneratedMember(klass, newMember);
            }
        }
    }
}

