/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.types;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.FqNameEqualityChecker;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeCheckerStateKt;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012*\u00020\t\u001a\u0012\u0010\u0013\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0014"}, d2={"isBoxedArray", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "getArrayElementType", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "isNullable", "isStrictSubtypeOfClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "superClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "isSubtypeOf", "superType", "typeSystem", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "isSubtypeOfClass", "superTypes", "", "toArrayOrPrimitiveArrayType", "ir.tree"})
public final class IrTypeUtilsKt {
    @NotNull
    public static final List<IrType> superTypes(@NotNull IrClassifierSymbol $this$superTypes) {
        Intrinsics.checkNotNullParameter($this$superTypes, "<this>");
        IrClassifierSymbol irClassifierSymbol = $this$superTypes;
        return irClassifierSymbol instanceof IrClassSymbol ? ((IrClass)((IrClassSymbol)$this$superTypes).getOwner()).getSuperTypes() : (irClassifierSymbol instanceof IrTypeParameterSymbol ? ((IrTypeParameter)((IrTypeParameterSymbol)$this$superTypes).getOwner()).getSuperTypes() : CollectionsKt.emptyList());
    }

    public static final boolean isSubtypeOfClass(@NotNull IrClassifierSymbol $this$isSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        Intrinsics.checkNotNullParameter($this$isSubtypeOfClass, "<this>");
        Intrinsics.checkNotNullParameter(superClass, "superClass");
        return FqNameEqualityChecker.INSTANCE.areEqual($this$isSubtypeOfClass, superClass) || IrTypeUtilsKt.isStrictSubtypeOfClass($this$isSubtypeOfClass, superClass);
    }

    public static final boolean isStrictSubtypeOfClass(@NotNull IrClassifierSymbol $this$isStrictSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$isStrictSubtypeOfClass, "<this>");
            Intrinsics.checkNotNullParameter(superClass, "superClass");
            Iterable $this$any$iv = IrTypeUtilsKt.superTypes($this$isStrictSubtypeOfClass);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrType it = (IrType)element$iv;
                    boolean bl2 = false;
                    if (!IrTypeUtilsKt.isSubtypeOfClass(it, superClass)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isSubtypeOfClass(@NotNull IrType $this$isSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        Intrinsics.checkNotNullParameter($this$isSubtypeOfClass, "<this>");
        Intrinsics.checkNotNullParameter(superClass, "superClass");
        return $this$isSubtypeOfClass instanceof IrSimpleType && IrTypeUtilsKt.isSubtypeOfClass(((IrSimpleType)$this$isSubtypeOfClass).getClassifier(), superClass);
    }

    public static final boolean isSubtypeOf(@NotNull IrType $this$isSubtypeOf, @NotNull IrType superType2, @NotNull IrTypeSystemContext typeSystem) {
        Intrinsics.checkNotNullParameter($this$isSubtypeOf, "<this>");
        Intrinsics.checkNotNullParameter(superType2, "superType");
        Intrinsics.checkNotNullParameter(typeSystem, "typeSystem");
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, IrTypeCheckerStateKt.createIrTypeCheckerState(typeSystem), (KotlinTypeMarker)$this$isSubtypeOf, (KotlinTypeMarker)superType2, false, 8, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNullable(@NotNull IrType $this$isNullable) {
        Intrinsics.checkNotNullParameter($this$isNullable, "<this>");
        IrType irType = $this$isNullable;
        if (irType instanceof IrSimpleType) {
            IrClassifierSymbol classifier2 = ((IrSimpleType)$this$isNullable).getClassifier();
            if (!(classifier2 instanceof IrClassSymbol)) {
                IrType p0;
                if (!(classifier2 instanceof IrTypeParameterSymbol)) throw new IllegalStateException(Intrinsics.stringPlus("Unsupported classifier: ", classifier2).toString());
                if (((IrSimpleType)$this$isNullable).getHasQuestionMark()) return true;
                Iterable $this$any$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getSuperTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    Object element$iv = iterator2.next();
                    p0 = (IrType)element$iv;
                    boolean bl = false;
                } while (!IrTypeUtilsKt.isNullable(p0));
                return true;
            }
        } else {
            if (!(irType instanceof IrDynamicType)) return false;
            return true;
        }
        boolean bl = ((IrSimpleType)$this$isNullable).getHasQuestionMark();
        return bl;
    }

    public static final boolean isBoxedArray(@NotNull IrType $this$isBoxedArray) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter($this$isBoxedArray, "<this>");
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$isBoxedArray);
        if (irClassSymbol == null) {
            fqName2 = null;
        } else {
            IrClass irClass2 = (IrClass)irClassSymbol.getOwner();
            fqName2 = IrUtilsKt.getFqNameWhenAvailable(irClass2);
        }
        return Intrinsics.areEqual(fqName2, StandardNames.FqNames.array.toSafe());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final IrType getArrayElementType(@NotNull IrType $this$getArrayElementType, @NotNull IrBuiltIns irBuiltIns) {
        IrType irType;
        Intrinsics.checkNotNullParameter($this$getArrayElementType, "<this>");
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        if (IrTypeUtilsKt.isBoxedArray($this$getArrayElementType)) {
            IrTypeArgument argument2 = CollectionsKt.singleOrNull(((IrSimpleType)$this$getArrayElementType).getArguments());
            if (argument2 instanceof IrTypeProjection) {
                irType = ((IrTypeProjection)argument2).getType();
                return irType;
            } else {
                if (!(argument2 instanceof IrStarProjection)) throw new IllegalStateException(Intrinsics.stringPlus("Unexpected array argument type: ", argument2).toString());
                irType = irBuiltIns.getAnyNType();
            }
            return irType;
        } else {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$getArrayElementType);
            Intrinsics.checkNotNull(irClassSymbol);
            IrClassSymbol classifier2 = irClassSymbol;
            IrType irType2 = irBuiltIns.getPrimitiveArrayElementTypes().get(classifier2);
            if (irType2 == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus("Primitive array expected: ", classifier2));
            }
            irType = irType2;
        }
        return irType;
    }

    @NotNull
    public static final IrType toArrayOrPrimitiveArrayType(@NotNull IrType $this$toArrayOrPrimitiveArrayType, @NotNull IrBuiltIns irBuiltIns) {
        IrType irType;
        Intrinsics.checkNotNullParameter($this$toArrayOrPrimitiveArrayType, "<this>");
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        if (IrTypePredicatesKt.isPrimitiveType$default($this$toArrayOrPrimitiveArrayType, false, 1, null)) {
            IrClassSymbol irClassSymbol = irBuiltIns.getPrimitiveArrayForType().get($this$toArrayOrPrimitiveArrayType);
            if (irClassSymbol == null) {
                throw new AssertionError((Object)($this$toArrayOrPrimitiveArrayType + " not in primitiveArrayForType"));
            }
            irType = IrTypesKt.getDefaultType(irClassSymbol);
        } else {
            IrType[] irTypeArray = new IrType[]{$this$toArrayOrPrimitiveArrayType};
            irType = IrTypesKt.typeWith((IrClassifierSymbol)irBuiltIns.getArrayClass(), irTypeArray);
        }
        return irType;
    }
}

