/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "collectDiagnostics", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "diagnosticFor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "incompatibilityDiagnosticFor", "source", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "ClassifierUsage", "frontend"})
public final class MissingDependencyClassChecker
implements CallChecker {
    @NotNull
    public static final MissingDependencyClassChecker INSTANCE = new MissingDependencyClassChecker();

    private MissingDependencyClassChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object resultingDescriptor = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(resultingDescriptor, "resultingDescriptor");
        for (Diagnostic diagnostic : this.collectDiagnostics(reportOn, (CallableDescriptor)resultingDescriptor)) {
            context2.getTrace().report(diagnostic);
        }
        Object object = resultingDescriptor instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)resultingDescriptor : null;
        DeserializedContainerSource containerSource = object == null ? null : object.getContainerSource();
        if ((object = this.incompatibilityDiagnosticFor(containerSource, reportOn)) != null) {
            Object object2 = object;
            BindingTrace bindingTrace = context2.getTrace();
            Object p0 = object2;
            boolean bl = false;
            bindingTrace.report((Diagnostic)p0);
        }
    }

    private final Diagnostic diagnosticFor(ClassifierDescriptor descriptor2, PsiElement reportOn) {
        if (descriptor2 instanceof NotFoundClasses.MockClassDescriptor) {
            return Errors.MISSING_DEPENDENCY_CLASS.on(reportOn, DescriptorUtilsKt.getFqNameSafe(descriptor2));
        }
        return this.incompatibilityDiagnosticFor(descriptor2.getSource(), reportOn);
    }

    private final Diagnostic incompatibilityDiagnosticFor(SourceElement source, PsiElement reportOn) {
        if (source instanceof DeserializedContainerSource) {
            IncompatibleVersionErrorData<?> incompatibility = ((DeserializedContainerSource)source).getIncompatibility();
            if (incompatibility != null) {
                return Errors.INCOMPATIBLE_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString(), incompatibility);
            }
            if (((DeserializedContainerSource)source).isPreReleaseInvisible()) {
                return Errors.PRE_RELEASE_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString());
            }
            if (((DeserializedContainerSource)source).getAbiStability() == DeserializedContainerAbiStability.FIR_UNSTABLE) {
                return Errors.FIR_COMPILED_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString());
            }
            if (((DeserializedContainerSource)source).getAbiStability() == DeserializedContainerAbiStability.IR_UNSTABLE) {
                return Errors.IR_WITH_UNSTABLE_ABI_COMPILED_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString());
            }
        }
        return null;
    }

    private final Set<Diagnostic> collectDiagnostics(PsiElement reportOn, CallableDescriptor descriptor2) {
        Object object;
        Set result2 = CollectionsKt.newLinkedHashSetWithExpectedSize(1);
        Object object2 = descriptor2.getReturnType();
        if (object2 != null) {
            object = object2;
            KotlinType p0 = object;
            boolean bl = false;
            MissingDependencyClassChecker.collectDiagnostics$consider-2(reportOn, result2, p0);
        }
        object2 = descriptor2.getExtensionReceiverParameter();
        if (object2 != null) {
            KotlinType bl;
            object = object2.getValue();
            KotlinType kotlinType = object.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "type");
            KotlinType p0 = bl = kotlinType;
            boolean bl2 = false;
            MissingDependencyClassChecker.collectDiagnostics$consider-2(reportOn, result2, p0);
        }
        object2 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(object2, "descriptor.valueParameters");
        Iterable $this$forEach$iv = (Iterable)object2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl = false;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "it.type");
            MissingDependencyClassChecker.collectDiagnostics$consider-2(reportOn, result2, kotlinType);
        }
        return result2;
    }

    private static final void collectDiagnostics$consider(PsiElement $reportOn, Set<Diagnostic> result2, ClassDescriptor classDescriptor) {
        ClassDescriptor classDescriptor2;
        Diagnostic diagnostic = INSTANCE.diagnosticFor(classDescriptor, $reportOn);
        if (diagnostic != null) {
            result2.add(diagnostic);
            return;
        }
        DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor3 = classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor2 != null) {
            DeclarationDescriptor p0 = declarationDescriptor = classDescriptor2;
            boolean bl = false;
            MissingDependencyClassChecker.collectDiagnostics$consider($reportOn, result2, (ClassDescriptor)p0);
        }
    }

    private static final void collectDiagnostics$consider-2(PsiElement $reportOn, Set<Diagnostic> result2, KotlinType type2) {
        if (!CallCheckerKt.isComputingDeferredType(INSTANCE, type2)) {
            ClassDescriptor classDescriptor;
            ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor2 = classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor != null) {
                ClassifierDescriptor p0 = classifierDescriptor = classDescriptor;
                boolean bl = false;
                MissingDependencyClassChecker.collectDiagnostics$consider($reportOn, result2, (ClassDescriptor)p0);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        @NotNull
        public static final ClassifierUsage INSTANCE = new ClassifierUsage();

        private ClassifierUsage() {
        }

        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context2) {
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter(targetDescriptor, "targetDescriptor");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(context2, "context");
            Diagnostic diagnostic = INSTANCE.diagnosticFor(targetDescriptor, element);
            if (diagnostic != null) {
                object2 = diagnostic;
                object = context2.getTrace();
                Object p0 = object2;
                boolean bl = false;
                object.report((Diagnostic)p0);
            }
            object2 = targetDescriptor instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)((Object)targetDescriptor) : null;
            DeserializedContainerSource containerSource = object2 == null ? null : object2.getContainerSource();
            object2 = INSTANCE.incompatibilityDiagnosticFor(containerSource, element);
            if (object2 != null) {
                object = object2;
                BindingTrace bindingTrace = context2.getTrace();
                Object p0 = object;
                boolean bl = false;
                bindingTrace.report((Diagnostic)p0);
            }
        }
    }
}

