/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.IntInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\r\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u0006\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH$\u00a2\u0006\u0002\u0010\nJ'\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\r\u0010\u0011\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u0013\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u0014\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u0015\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u0016\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0019H$\u00a2\u0006\u0002\u0010\u001aJ\r\u0010\u001b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u001c\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u001d\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH$\u00a2\u0006\u0002\u0010\nJ%\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0016\u00a2\u0006\u0002\u0010!J\u0017\u0010\"\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010#J\u0019\u0010$\u001a\u0004\u0018\u00018\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ\r\u0010%\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010&\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH$\u00a2\u0006\u0002\u0010\nJ)\u0010'\u001a\u00020(2\u0006\u0010\f\u001a\u00020\r2\b\u0010)\u001a\u0004\u0018\u00018\u00002\b\u0010*\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010+J\r\u0010,\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J/\u0010-\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010.\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010/J\u0015\u00100\u001a\u00028\u00002\u0006\u00101\u001a\u00020\tH$\u00a2\u0006\u0002\u0010\nJ\u001f\u00102\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00103J\r\u00104\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/BasicTypeInterpreter;", "V", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "()V", "aaLoadValue", "arrayValue", "(Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "binaryOperation", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "value1", "value2", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "booleanValue", "()Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "byteValue", "charValue", "doubleValue", "floatValue", "handleValue", "handle", "Lorg/jetbrains/org/objectweb/asm/Handle;", "(Lorg/jetbrains/org/objectweb/asm/Handle;)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "intValue", "longValue", "methodValue", "naryOperation", "values", "", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;Ljava/util/List;)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "newOperation", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "newValue", "nullValue", "objectValue", "returnOperation", "", "value", "expected", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;)V", "shortValue", "ternaryOperation", "value3", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "typeConstValue", "typeConst", "unaryOperation", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "uninitializedValue", "backend"})
public abstract class BasicTypeInterpreter<V extends Value>
extends Interpreter<V> {
    public BasicTypeInterpreter() {
        super(589824);
    }

    @NotNull
    protected abstract V uninitializedValue();

    @NotNull
    protected abstract V booleanValue();

    @NotNull
    protected abstract V charValue();

    @NotNull
    protected abstract V byteValue();

    @NotNull
    protected abstract V shortValue();

    @NotNull
    protected abstract V intValue();

    @NotNull
    protected abstract V longValue();

    @NotNull
    protected abstract V floatValue();

    @NotNull
    protected abstract V doubleValue();

    @NotNull
    protected abstract V nullValue();

    @NotNull
    protected abstract V objectValue(@NotNull Type var1);

    @NotNull
    protected abstract V arrayValue(@NotNull Type var1);

    @NotNull
    protected abstract V methodValue(@NotNull Type var1);

    @NotNull
    protected abstract V handleValue(@NotNull Handle var1);

    @NotNull
    protected abstract V typeConstValue(@NotNull Type var1);

    @NotNull
    protected abstract V aaLoadValue(@NotNull V var1);

    @Override
    @Nullable
    public V newValue(@Nullable Type type2) {
        V v;
        if (type2 == null) {
            v = this.uninitializedValue();
        } else {
            switch (type2.getSort()) {
                case 0: {
                    v = null;
                    break;
                }
                case 1: {
                    v = this.booleanValue();
                    break;
                }
                case 2: {
                    v = this.charValue();
                    break;
                }
                case 3: {
                    v = this.byteValue();
                    break;
                }
                case 4: {
                    v = this.shortValue();
                    break;
                }
                case 5: {
                    v = this.intValue();
                    break;
                }
                case 6: {
                    v = this.floatValue();
                    break;
                }
                case 7: {
                    v = this.longValue();
                    break;
                }
                case 8: {
                    v = this.doubleValue();
                    break;
                }
                case 9: {
                    v = this.arrayValue(type2);
                    break;
                }
                case 10: {
                    v = this.objectValue(type2);
                    break;
                }
                case 11: {
                    v = this.methodValue(type2);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected type: " + type2));
                }
            }
        }
        return v;
    }

    @Override
    @Nullable
    public V newOperation(@NotNull AbstractInsnNode insn) {
        V v;
        Intrinsics.checkNotNullParameter(insn, "insn");
        switch (insn.getOpcode()) {
            case 1: {
                v = this.nullValue();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                v = this.intValue();
                break;
            }
            case 9: 
            case 10: {
                v = this.longValue();
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                v = this.floatValue();
                break;
            }
            case 14: 
            case 15: {
                v = this.doubleValue();
                break;
            }
            case 16: 
            case 17: {
                v = this.intValue();
                break;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                if (cst instanceof Integer) {
                    v = this.intValue();
                    break;
                }
                if (cst instanceof Float) {
                    v = this.floatValue();
                    break;
                }
                if (cst instanceof Long) {
                    v = this.longValue();
                    break;
                }
                if (cst instanceof Double) {
                    v = this.doubleValue();
                    break;
                }
                if (cst instanceof String) {
                    Type type2 = AsmTypes.JAVA_STRING_TYPE;
                    Intrinsics.checkNotNullExpressionValue(type2, "JAVA_STRING_TYPE");
                    v = this.objectValue(type2);
                    break;
                }
                if (cst instanceof Handle) {
                    v = this.handleValue((Handle)cst);
                    break;
                }
                if (cst instanceof Type) {
                    v = this.typeConstValue((Type)cst);
                    break;
                }
                throw new IllegalArgumentException("Illegal LDC constant " + cst);
            }
            case 178: {
                v = this.newValue(Type.getType(((FieldInsnNode)insn).desc));
                break;
            }
            case 187: {
                v = this.newValue(Type.getObjectType(((TypeInsnNode)insn).desc));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected instruction: " + InlineCodegenUtilsKt.getInsnOpcodeText(insn));
            }
        }
        return v;
    }

    @Override
    @Nullable
    public V binaryOperation(@NotNull AbstractInsnNode insn, @NotNull V value1, @NotNull V value2) {
        V v;
        Intrinsics.checkNotNullParameter(insn, "insn");
        Intrinsics.checkNotNullParameter(value1, "value1");
        Intrinsics.checkNotNullParameter(value2, "value2");
        switch (insn.getOpcode()) {
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                v = this.intValue();
                break;
            }
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                v = this.floatValue();
                break;
            }
            case 47: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                v = this.longValue();
                break;
            }
            case 49: 
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                v = this.doubleValue();
                break;
            }
            case 50: {
                v = this.aaLoadValue(value1);
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                v = this.intValue();
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                v = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected instruction: " + InlineCodegenUtilsKt.getInsnOpcodeText(insn));
            }
        }
        return v;
    }

    @Override
    @Nullable
    public V ternaryOperation(@NotNull AbstractInsnNode insn, @NotNull V value1, @NotNull V value2, @NotNull V value3) {
        Intrinsics.checkNotNullParameter(insn, "insn");
        Intrinsics.checkNotNullParameter(value1, "value1");
        Intrinsics.checkNotNullParameter(value2, "value2");
        Intrinsics.checkNotNullParameter(value3, "value3");
        return null;
    }

    @Override
    @Nullable
    public V naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends V> values2) {
        V v;
        Intrinsics.checkNotNullParameter(insn, "insn");
        Intrinsics.checkNotNullParameter(values2, "values");
        switch (insn.getOpcode()) {
            case 197: {
                v = this.newValue(Type.getType(((MultiANewArrayInsnNode)insn).desc));
                break;
            }
            case 186: {
                v = this.newValue(Type.getReturnType(((InvokeDynamicInsnNode)insn).desc));
                break;
            }
            default: {
                v = this.newValue(Type.getReturnType(((MethodInsnNode)insn).desc));
            }
        }
        return v;
    }

    @Override
    public void returnOperation(@NotNull AbstractInsnNode insn, @Nullable V value2, @Nullable V expected) {
        Intrinsics.checkNotNullParameter(insn, "insn");
    }

    @Override
    @Nullable
    public V unaryOperation(@NotNull AbstractInsnNode insn, @NotNull V value2) {
        V v;
        Intrinsics.checkNotNullParameter(insn, "insn");
        Intrinsics.checkNotNullParameter(value2, "value");
        block0 : switch (insn.getOpcode()) {
            case 116: 
            case 132: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 146: 
            case 147: {
                v = this.intValue();
                break;
            }
            case 118: 
            case 134: 
            case 137: 
            case 144: {
                v = this.floatValue();
                break;
            }
            case 117: 
            case 133: 
            case 140: 
            case 143: {
                v = this.longValue();
                break;
            }
            case 119: 
            case 135: 
            case 138: 
            case 141: {
                v = this.doubleValue();
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 179: {
                v = null;
                break;
            }
            case 180: {
                v = this.newValue(Type.getType(((FieldInsnNode)insn).desc));
                break;
            }
            case 188: {
                switch (((IntInsnNode)insn).operand) {
                    case 4: {
                        v = this.newValue(Type.getType("[Z"));
                        break block0;
                    }
                    case 5: {
                        v = this.newValue(Type.getType("[C"));
                        break block0;
                    }
                    case 8: {
                        v = this.newValue(Type.getType("[B"));
                        break block0;
                    }
                    case 9: {
                        v = this.newValue(Type.getType("[S"));
                        break block0;
                    }
                    case 10: {
                        v = this.newValue(Type.getType("[I"));
                        break block0;
                    }
                    case 6: {
                        v = this.newValue(Type.getType("[F"));
                        break block0;
                    }
                    case 7: {
                        v = this.newValue(Type.getType("[D"));
                        break block0;
                    }
                    case 11: {
                        v = this.newValue(Type.getType("[J"));
                        break block0;
                    }
                }
                throw new AnalyzerException(insn, "Invalid array type");
            }
            case 189: {
                v = this.newValue(Type.getType("" + '[' + Type.getObjectType(((TypeInsnNode)insn).desc)));
                break;
            }
            case 190: {
                v = this.intValue();
                break;
            }
            case 191: {
                v = null;
                break;
            }
            case 192: {
                v = this.newValue(Type.getObjectType(((TypeInsnNode)insn).desc));
                break;
            }
            case 193: {
                v = this.intValue();
                break;
            }
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                v = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected instruction: " + InlineCodegenUtilsKt.getInsnOpcodeText(insn));
            }
        }
        return v;
    }
}

