/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.PlatformAnnotationFeaturesSupport;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/JvmPlatformAnnotationFeaturesSupport;", "Lorg/jetbrains/kotlin/resolve/PlatformAnnotationFeaturesSupport;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "isRepeatableAnnotationClass", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "frontend.java"})
public final class JvmPlatformAnnotationFeaturesSupport
implements PlatformAnnotationFeaturesSupport {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public JvmPlatformAnnotationFeaturesSupport(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }

    @Override
    public boolean isRepeatableAnnotationClass(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!(descriptor2.getKind() == ClassKind.ANNOTATION_CLASS)) {
            boolean bl = false;
            ClassDescriptor classDescriptor = descriptor2;
            throw new IllegalStateException(classDescriptor.toString());
        }
        Annotations annotations2 = descriptor2.getAnnotations();
        FqName fqName2 = JvmAnnotationNames.REPEATABLE_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue(fqName2, "REPEATABLE_ANNOTATION");
        if (!annotations2.hasAnnotation(fqName2)) {
            return false;
        }
        return this.languageVersionSettings.supportsFeature(LanguageFeature.RepeatableAnnotations) || DescriptorUtilsKt.getAnnotationRetention(descriptor2) == KotlinRetention.SOURCE && descriptor2 instanceof JavaClassDescriptor;
    }
}

