/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.range.forLoop;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.DescriptorAsmUtil;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.range.comparison.ComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.forLoop.AbstractForInProgressionOrRangeLoopGenerator;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0016\u001a\u00020\u0010H\u0004J\b\u0010\u0017\u001a\u00020\u0010H$R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/codegen/range/forLoop/AbstractForInRangeLoopGenerator;", "Lorg/jetbrains/kotlin/codegen/range/forLoop/AbstractForInProgressionOrRangeLoopGenerator;", "codegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "forExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "step", "", "comparisonGenerator", "Lorg/jetbrains/kotlin/codegen/range/comparison/ComparisonGenerator;", "(Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;Lorg/jetbrains/kotlin/psi/KtForExpression;ILorg/jetbrains/kotlin/codegen/range/comparison/ComparisonGenerator;)V", "getComparisonGenerator", "()Lorg/jetbrains/kotlin/codegen/range/comparison/ComparisonGenerator;", "getStep", "()I", "assignToLoopParameter", "", "beforeLoop", "checkEmptyLoop", "loopExit", "Lorg/jetbrains/org/objectweb/asm/Label;", "checkPostConditionAndIncrement", "incrementLoopVariable", "storeRangeStartAndEnd", "backend"})
public abstract class AbstractForInRangeLoopGenerator
extends AbstractForInProgressionOrRangeLoopGenerator {
    private final int step;
    @NotNull
    private final ComparisonGenerator comparisonGenerator;

    public AbstractForInRangeLoopGenerator(@NotNull ExpressionCodegen codegen2, @NotNull KtForExpression forExpression, int step, @NotNull ComparisonGenerator comparisonGenerator) {
        boolean bl;
        Intrinsics.checkNotNullParameter(codegen2, "codegen");
        Intrinsics.checkNotNullParameter(forExpression, "forExpression");
        Intrinsics.checkNotNullParameter(comparisonGenerator, "comparisonGenerator");
        super(codegen2, forExpression);
        this.step = step;
        this.comparisonGenerator = comparisonGenerator;
        boolean bl2 = bl = this.step == 1 || this.step == -1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "'step' should be either 1 or -1: " + this.step;
            throw new AssertionError((Object)string2);
        }
    }

    protected final int getStep() {
        return this.step;
    }

    @NotNull
    protected final ComparisonGenerator getComparisonGenerator() {
        return this.comparisonGenerator;
    }

    @Override
    public void beforeLoop() {
        super.beforeLoop();
        this.storeRangeStartAndEnd();
    }

    protected abstract void storeRangeStartAndEnd();

    @Override
    public void checkEmptyLoop(@NotNull Label loopExit) {
        Intrinsics.checkNotNullParameter(loopExit, "loopExit");
        this.loopParameter().put(this.getAsmElementType(), this.getElementType(), this.getV());
        this.getV().load(this.getEndVar(), this.getAsmElementType());
        if (this.step > 0) {
            this.comparisonGenerator.jumpIfGreater(this.getV(), loopExit);
        } else {
            this.comparisonGenerator.jumpIfLess(this.getV(), loopExit);
        }
    }

    @Override
    protected void assignToLoopParameter() {
    }

    @Override
    protected void checkPostConditionAndIncrement(@NotNull Label loopExit) {
        Intrinsics.checkNotNullParameter(loopExit, "loopExit");
        this.checkPostCondition(loopExit);
        this.incrementLoopVariable();
    }

    protected final void incrementLoopVariable() {
        if (this.getLoopParameterType() == Type.INT_TYPE) {
            this.getV().iinc(this.getLoopParameterVar(), this.step);
        } else {
            StackValue loopParameter = this.loopParameter();
            loopParameter.put(this.getAsmElementType(), this.getElementType(), this.getV());
            DescriptorAsmUtil.genIncrement(this.getAsmElementType(), this.step, this.getV());
            loopParameter.store(StackValue.onStack(this.getAsmElementType(), this.getElementType()), this.getV());
        }
    }
}

