/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.ic.CacheAccessorsKt;
import org.jetbrains.kotlin.ir.backend.js.ic.DataKt;
import org.jetbrains.kotlin.ir.backend.js.ic.PersistentCacheProvider;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedIcDataForFile;
import org.jetbrains.kotlin.ir.util.IdSignature;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\fj\u0002`\r0\n2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0014\u0010\u0015\u001a\u00060\fj\u0002`\u00162\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0016J:\u0010\u0019\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\fj\u0002`\r0\u001b0\u001a2\u0006\u0010\u0013\u001a\u00020\u00032\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u001cH\u0016J4\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\fj\u0002`\r0\n2\u0006\u0010\u0013\u001a\u00020\u00032\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016JB\u0010\u001f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\fj\u0002`\r0\u001b0\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00032\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u001cH\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010&\u001a\u00060\fj\u0002`\u0016*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/PersistentCacheProviderImpl;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/PersistentCacheProvider;", "cachePath", "", "(Ljava/lang/String;)V", "fileDir", "Ljava/io/File;", "getFileDir", "(Ljava/lang/String;)Ljava/io/File;", "allInlineHashes", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/TransHash;", "sigResolver", "Lkotlin/Function2;", "", "binaryAst", "", "path", "dts", "fileFingerPrint", "Lorg/jetbrains/kotlin/ir/backend/js/ic/Hash;", "filePaths", "", "inlineGraphForFile", "", "Lkotlin/Pair;", "Lkotlin/Function1;", "inlineHashes", "moduleName", "parseHashList", "fileName", "readBytesFromCacheFile", "cacheName", "serializedParts", "Lorg/jetbrains/kotlin/ir/backend/js/ic/SerializedIcDataForFile;", "sourceMap", "parseHash", "ir.serialization.js"})
public final class PersistentCacheProviderImpl
implements PersistentCacheProvider {
    @NotNull
    private final String cachePath;

    public PersistentCacheProviderImpl(@NotNull String cachePath) {
        Intrinsics.checkNotNullParameter(cachePath, "cachePath");
        this.cachePath = cachePath;
    }

    private final File getFileDir(String $this$fileDir) {
        String fileId = CacheAccessorsKt.access$createFileCacheId($this$fileDir);
        return new File(new File(this.cachePath), fileId);
    }

    private final long parseHash(String $this$parseHash) {
        return Long.parseUnsignedLong($this$parseHash, 16);
    }

    @Override
    public long fileFingerPrint(@NotNull String path2) {
        long l;
        Intrinsics.checkNotNullParameter(path2, "path");
        File dataFile = new File(this.getFileDir(path2), "file.info");
        if (dataFile.exists()) {
            String hashLine = (String)FilesKt.readLines$default(dataFile, null, 1, null).get(1);
            l = this.parseHash(hashLine);
        } else {
            l = 0L;
        }
        return l;
    }

    @Override
    @NotNull
    public SerializedIcDataForFile serializedParts(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        File fileDir = this.getFileDir(path2);
        return DataKt.readIcDataBinary(fileDir);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Pair<IdSignature, Long>> parseHashList(File fileDir, String fileName, Function1<? super Integer, ? extends IdSignature> sigResolver) {
        File inlineGraphFile = new File(fileDir, fileName);
        if (inlineGraphFile.exists()) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = FilesKt.readLines$default(inlineGraphFile, null, 1, null);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Pair<IdSignature, Long> it$iv$iv;
                Pair<IdSignature, Long> pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String line = (String)element$iv$iv;
                boolean bl2 = false;
                String[] stringArray = new String[]{":"};
                List list2 = StringsKt.split$default((CharSequence)line, stringArray, false, 0, 6, null);
                String sigIdS = (String)list2.get(0);
                String hashString = (String)list2.get(1);
                int sigId = Integer.parseInt(sigIdS);
                try {
                    IdSignature idSig = sigResolver.invoke((Integer)sigId);
                    long tHash = this.parseHash(hashString);
                    pair = TuplesKt.to(idSig, tHash);
                }
                catch (IndexOutOfBoundsException ex) {
                    pair = null;
                }
                if (pair == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Collection<Pair<IdSignature, Long>> inlineGraphForFile(@NotNull String path2, @NotNull Function1<? super Integer, ? extends IdSignature> sigResolver) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(sigResolver, "sigResolver");
        return this.parseHashList(this.getFileDir(path2), "inline.graph", sigResolver);
    }

    @Override
    @NotNull
    public Map<IdSignature, Long> inlineHashes(@NotNull String path2, @NotNull Function1<? super Integer, ? extends IdSignature> sigResolver) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(sigResolver, "sigResolver");
        return MapsKt.toMap((Iterable)this.parseHashList(this.getFileDir(path2), "inline.functions", sigResolver));
    }

    @Override
    @NotNull
    public Map<IdSignature, Long> allInlineHashes(@NotNull Function2<? super String, ? super Integer, ? extends IdSignature> sigResolver) {
        Intrinsics.checkNotNullParameter(sigResolver, "sigResolver");
        Map result2 = new LinkedHashMap();
        File cachePath = new File(this.cachePath);
        File[] fileArray = cachePath.listFiles(PersistentCacheProviderImpl::allInlineHashes$lambda-1);
        Intrinsics.checkNotNull(fileArray);
        File[] $this$forEach$iv = fileArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File f = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            File fileInfo = new File(f, "file.info");
            if (!fileInfo.exists()) continue;
            String fileName = (String)FilesKt.readLines$default(fileInfo, null, 1, null).get(0);
            Intrinsics.checkNotNullExpressionValue(f, "f");
            Iterable $this$forEach$iv2 = this.parseHashList(f, "inline.functions", (Function1<? super Integer, ? extends IdSignature>)new Function1<Integer, IdSignature>(sigResolver, fileName){
                final /* synthetic */ Function2<String, Integer, IdSignature> $sigResolver;
                final /* synthetic */ String $fileName;
                {
                    this.$sigResolver = $sigResolver;
                    this.$fileName = $fileName;
                    super(1);
                }

                @NotNull
                public final IdSignature invoke(int id) {
                    return this.$sigResolver.invoke(this.$fileName, id);
                }
            });
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Pair pair = (Pair)element$iv2;
                boolean bl2 = false;
                IdSignature sig = (IdSignature)pair.component1();
                long hash = ((Number)pair.component2()).longValue();
                Long l = hash;
                result2.put(sig, l);
            }
        }
        return result2;
    }

    private final byte[] readBytesFromCacheFile(String fileName, String cacheName) {
        File cachePath = this.getFileDir(fileName);
        File cacheFile = new File(cachePath, cacheName);
        if (cacheFile.exists()) {
            return FilesKt.readBytes(cacheFile);
        }
        return null;
    }

    @Override
    @Nullable
    public byte[] binaryAst(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        return this.readBytesFromCacheFile(path2, "binary.ast");
    }

    @Override
    @Nullable
    public byte[] dts(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        return this.readBytesFromCacheFile(path2, "binary.dst");
    }

    @Override
    @Nullable
    public byte[] sourceMap(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        return this.readBytesFromCacheFile(path2, "source.map");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<String> filePaths() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        File[] files2;
        File[] fileArray = new File(this.cachePath).listFiles();
        if (fileArray == null) {
            return CollectionsKt.emptyList();
        }
        File[] $this$filter$iv = files2 = fileArray;
        boolean $i$f$filter = false;
        File[] fileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!it.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            File f = (File)element$iv$iv;
            boolean bl2 = false;
            File fileInfo = new File(f, "file.info");
            if ((fileInfo.exists() ? (String)FilesKt.readLines$default(fileInfo, null, 1, null).get(0) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String moduleName() {
        File infoFile = new File(new File(this.cachePath), "info");
        return (String)FilesKt.readLines$default(infoFile, null, 1, null).get(1);
    }

    private static final boolean allInlineHashes$lambda-1(File file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return file2.isDirectory();
    }
}

