/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.FileChannelUtil;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
class OpenChannelsCache {
    private final int myCacheSizeLimit;
    @NotNull
    private final Set<StandardOpenOption> myOpenOptions;
    @NotNull
    private final Map<Path, ChannelDescriptor> myCache;
    private final Object myLock;

    OpenChannelsCache(int cacheSizeLimit, @NotNull Set<StandardOpenOption> openOptions) {
        if (openOptions == null) {
            OpenChannelsCache.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myCacheSizeLimit = cacheSizeLimit;
        this.myOpenOptions = openOptions;
        this.myCache = new LinkedHashMap<Path, ChannelDescriptor>(cacheSizeLimit, 0.5f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T useChannel(@NotNull Path path2, @NotNull ChannelProcessor<T> processor2) throws IOException {
        ChannelDescriptor descriptor2;
        if (path2 == null) {
            OpenChannelsCache.$$$reportNull$$$0(1);
        }
        if (processor2 == null) {
            OpenChannelsCache.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            descriptor2 = this.myCache.get(path2);
            if (descriptor2 == null) {
                this.releaseOverCachedChannels();
                descriptor2 = new ChannelDescriptor(path2, this.myOpenOptions);
                this.myCache.put(path2, descriptor2);
            }
            descriptor2.lock();
        }
        try {
            object = processor2.process(descriptor2.getChannel());
            return (T)object;
        }
        finally {
            Object object2 = this.myLock;
            synchronized (object2) {
                descriptor2.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeChannel(Path path2) {
        Object object = this.myLock;
        synchronized (object) {
            ChannelDescriptor descriptor2 = this.myCache.remove(path2);
            if (descriptor2 != null) {
                assert (!descriptor2.isLocked());
                try {
                    descriptor2.getChannel().close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void releaseOverCachedChannels() {
        int dropCount = this.myCache.size() - this.myCacheSizeLimit;
        if (dropCount >= 0) {
            ArrayList<Path> keysToDrop = new ArrayList<Path>();
            for (Map.Entry<Path, ChannelDescriptor> entry : this.myCache.entrySet()) {
                if (dropCount < 0) break;
                if (entry.getValue().isLocked()) continue;
                --dropCount;
                keysToDrop.add(entry.getKey());
            }
            for (Path file2 : keysToDrop) {
                this.closeChannel(file2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openOptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/OpenChannelsCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "useChannel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ChannelDescriptor {
        private int lockCount;
        private final FileChannel myChannel;

        ChannelDescriptor(@NotNull Path file2, @NotNull Set<? extends OpenOption> accessMode) throws IOException {
            if (file2 == null) {
                ChannelDescriptor.$$$reportNull$$$0(0);
            }
            if (accessMode == null) {
                ChannelDescriptor.$$$reportNull$$$0(1);
            }
            this.lockCount = 0;
            this.myChannel = FileChannelUtil.unInterruptible(FileChannel.open(file2, accessMode, new FileAttribute[0]));
        }

        void lock() {
            ++this.lockCount;
        }

        void unlock() {
            --this.lockCount;
        }

        boolean isLocked() {
            return this.lockCount != 0;
        }

        FileChannel getChannel() {
            return this.myChannel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "accessMode";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/OpenChannelsCache$ChannelDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    static interface ChannelProcessor<T> {
        public T process(@NotNull FileChannel var1) throws IOException;
    }
}

