/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionInformation;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiOperation;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ClassLiteralChecker;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsNativeRttiChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/RttiExpressionChecker;", "Lorg/jetbrains/kotlin/types/expressions/ClassLiteralChecker;", "()V", "check", "", "expression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "rttiInformation", "Lorg/jetbrains/kotlin/resolve/calls/checkers/RttiExpressionInformation;", "reportOn", "Lcom/intellij/psi/PsiElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "js.frontend"})
public final class JsNativeRttiChecker
implements RttiExpressionChecker,
ClassLiteralChecker {
    @Override
    public void check(@NotNull RttiExpressionInformation rttiInformation, @NotNull PsiElement reportOn, @NotNull BindingTrace trace) {
        ClassifierDescriptor targetDescriptor;
        Intrinsics.checkNotNullParameter(rttiInformation, "rttiInformation");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(trace, "trace");
        KotlinType sourceType = rttiInformation.getSourceType();
        KotlinType targetType = rttiInformation.getTargetType();
        Object object = targetType;
        ClassifierDescriptor classifierDescriptor = object != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : (targetDescriptor = null);
        if (sourceType != null && targetDescriptor != null && AnnotationsUtils.isNativeInterface(targetDescriptor)) {
            switch (WhenMappings.$EnumSwitchMapping$0[rttiInformation.getOperation().ordinal()]) {
                case 1: 
                case 2: {
                    trace.report(ErrorsJs.CANNOT_CHECK_FOR_EXTERNAL_INTERFACE.on(reportOn, targetType));
                    break;
                }
                case 3: 
                case 4: {
                    trace.report(ErrorsJs.UNCHECKED_CAST_TO_EXTERNAL_INTERFACE.on(reportOn, sourceType, targetType));
                }
            }
        }
    }

    @Override
    public void check(@NotNull KtClassLiteralExpression expression2, @NotNull KotlinType type2, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(context, "context");
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor descriptor2 = classDescriptor;
        if (AnnotationsUtils.isNativeInterface(descriptor2)) {
            context.trace.report(ErrorsJs.EXTERNAL_INTERFACE_AS_CLASS_LITERAL.on(expression2));
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RttiOperation.values().length];
            nArray[RttiOperation.IS.ordinal()] = 1;
            nArray[RttiOperation.NOT_IS.ordinal()] = 2;
            nArray[RttiOperation.AS.ordinal()] = 3;
            nArray[RttiOperation.SAFE_AS.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

