/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"getUnboxedType", "Lorg/jetbrains/org/objectweb/asm/Type;", "boxedType", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "isInlineClassValue", "", "unboxedTypeOfInlineClass", "backend"})
public final class BoxedBasicValueKt {
    @NotNull
    public static final Type getUnboxedType(@NotNull Type boxedType, @NotNull GenerationState state) {
        Type primitiveType;
        Intrinsics.checkNotNullParameter(boxedType, "boxedType");
        Intrinsics.checkNotNullParameter(state, "state");
        Type type2 = primitiveType = AsmUtil.unboxPrimitiveTypeOrNull(boxedType);
        if (type2 != null) {
            return type2;
        }
        if (Intrinsics.areEqual(boxedType, AsmTypes.K_CLASS_TYPE)) {
            Type type3 = AsmTypes.JAVA_CLASS_TYPE;
            Intrinsics.checkNotNullExpressionValue(type3, "JAVA_CLASS_TYPE");
            return type3;
        }
        Type type4 = BoxedBasicValueKt.unboxedTypeOfInlineClass(boxedType, state);
        if (type4 != null) {
            Type it = type4;
            boolean bl = false;
            return it;
        }
        throw new IllegalArgumentException("Expected primitive type wrapper or KClass or inline class wrapper, got: " + boxedType);
    }

    @Nullable
    public static final Type unboxedTypeOfInlineClass(@NotNull Type boxedType, @NotNull GenerationState state) {
        ClassDescriptor classDescriptor;
        block3: {
            block2: {
                ClassDescriptor classDescriptor2;
                Intrinsics.checkNotNullParameter(boxedType, "boxedType");
                Intrinsics.checkNotNullParameter(state, "state");
                classDescriptor = CollectionsKt.singleOrNull(state.getJvmBackendClassResolver().resolveToClassDescriptors(boxedType));
                if (classDescriptor == null) break block2;
                ClassDescriptor it = classDescriptor2 = classDescriptor;
                boolean bl = false;
                classDescriptor = InlineClassesUtilsKt.isInlineClass(it) ? classDescriptor2 : null;
                if (classDescriptor != null) break block3;
            }
            return null;
        }
        ClassDescriptor descriptor2 = classDescriptor;
        return state.getMapInlineClass().invoke(descriptor2);
    }

    private static final boolean isInlineClassValue(Type boxedType) {
        return !AsmUtil.isBoxedPrimitiveType(boxedType) && !Intrinsics.areEqual(boxedType, AsmTypes.K_CLASS_TYPE);
    }

    public static final /* synthetic */ boolean access$isInlineClassValue(Type boxedType) {
        return BoxedBasicValueKt.isInlineClassValue(boxedType);
    }
}

