/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.declarations;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.MultiFieldValueClassRepresentation;
import org.jetbrains.kotlin.descriptors.ValueClassRepresentation;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.ObsoleteDescriptorBasedAPI;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.types.IrSimpleType;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0019\u001a\u00020\u001a*\u00020\u00032\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u001a\u0012\u0010\u001e\u001a\u00020\u001a*\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u001d\u001a#\u0010 \u001a\u0002H!\"\b\b\u0000\u0010!*\u00020\"*\u0002H!2\b\u0010#\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0002\u0010$\u001a\u0014\u0010%\u001a\u00020&*\u00020\n2\u0006\u0010'\u001a\u00020(H\u0007\u001a\u001c\u0010)\u001a\u00020\u001a*\u00020\n2\u0006\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020+H\u0007\"\u001d\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\"\u0015\u0010\t\u001a\u00020\u0007*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u0015\u0010\f\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\"\u0015\u0010\r\u001a\u00020\u0007*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\"\u001d\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000f*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u0013*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u0015\u0010\u0017\u001a\u00020\u0013*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006,"}, d2={"inlineClassRepresentation", "Lorg/jetbrains/kotlin/descriptors/InlineClassRepresentation;", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getInlineClassRepresentation", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/descriptors/InlineClassRepresentation;", "isMultiFieldValueClass", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "isPropertyAccessor", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "isSingleFieldValueClass", "isStaticMethodOfClass", "multiFieldValueClassRepresentation", "Lorg/jetbrains/kotlin/descriptors/MultiFieldValueClassRepresentation;", "getMultiFieldValueClassRepresentation", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/descriptors/MultiFieldValueClassRepresentation;", "name", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getName", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)Ljava/lang/String;", "path", "getPath", "addAll", "", "members", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "addMember", "member", "copyAttributes", "D", "Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "other", "(Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;)Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "getIrValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "putDefault", "expressionBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "ir.tree"})
public final class IrDeclarationsKt {
    @NotNull
    public static final <D extends IrAttributeContainer> D copyAttributes(@NotNull D $this$copyAttributes, @Nullable IrAttributeContainer other) {
        D d;
        Intrinsics.checkNotNullParameter($this$copyAttributes, "<this>");
        D $this$copyAttributes_u24lambda_u240 = d = $this$copyAttributes;
        boolean bl = false;
        if (other != null) {
            $this$copyAttributes_u24lambda_u240.setAttributeOwnerId(other.getAttributeOwnerId());
        }
        return d;
    }

    public static final boolean isSingleFieldValueClass(@NotNull IrClass $this$isSingleFieldValueClass) {
        Intrinsics.checkNotNullParameter($this$isSingleFieldValueClass, "<this>");
        return $this$isSingleFieldValueClass.getValueClassRepresentation() instanceof InlineClassRepresentation;
    }

    public static final boolean isMultiFieldValueClass(@NotNull IrClass $this$isMultiFieldValueClass) {
        Intrinsics.checkNotNullParameter($this$isMultiFieldValueClass, "<this>");
        return $this$isMultiFieldValueClass.getValueClassRepresentation() instanceof MultiFieldValueClassRepresentation;
    }

    public static final void addMember(@NotNull IrClass $this$addMember, @NotNull IrDeclaration member2) {
        Intrinsics.checkNotNullParameter($this$addMember, "<this>");
        Intrinsics.checkNotNullParameter(member2, "member");
        $this$addMember.getDeclarations().add(member2);
    }

    public static final void addAll(@NotNull IrClass $this$addAll, @NotNull List<? extends IrDeclaration> members) {
        Intrinsics.checkNotNullParameter($this$addAll, "<this>");
        Intrinsics.checkNotNullParameter(members, "members");
        $this$addAll.getDeclarations().addAll((Collection<IrDeclaration>)members);
    }

    @NotNull
    public static final String getPath(@NotNull IrFile $this$path) {
        Intrinsics.checkNotNullParameter($this$path, "<this>");
        return $this$path.getFileEntry().getName();
    }

    @NotNull
    public static final String getName(@NotNull IrFile $this$name) {
        Intrinsics.checkNotNullParameter($this$name, "<this>");
        String string2 = new File(IrDeclarationsKt.getPath($this$name)).getName();
        Intrinsics.checkNotNullExpressionValue(string2, "File(path).name");
        return string2;
    }

    @ObsoleteDescriptorBasedAPI
    @NotNull
    public static final IrValueParameter getIrValueParameter(@NotNull IrFunction $this$getIrValueParameter, @NotNull ValueParameterDescriptor parameter) {
        Intrinsics.checkNotNullParameter($this$getIrValueParameter, "<this>");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Object object = $this$getIrValueParameter.getValueParameters();
        int n = parameter.getIndex();
        if (n < 0 || n > CollectionsKt.getLastIndex(object)) {
            int it = n;
            boolean bl = false;
            throw new AssertionError((Object)("No IrValueParameter for " + parameter));
        }
        object = object.get(n);
        IrValueParameter found = (IrValueParameter)object;
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual(found.getDescriptor(), parameter);
        if (_Assertions.ENABLED && !bl2) {
            boolean bl3 = false;
            String string2 = "Parameter indices mismatch at " + $this$getIrValueParameter.getDescriptor() + ": " + parameter + " != " + found.getDescriptor();
            throw new AssertionError((Object)string2);
        }
        return (IrValueParameter)object;
    }

    @ObsoleteDescriptorBasedAPI
    public static final void putDefault(@NotNull IrFunction $this$putDefault, @NotNull ValueParameterDescriptor parameter, @NotNull IrExpressionBody expressionBody) {
        Intrinsics.checkNotNullParameter($this$putDefault, "<this>");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(expressionBody, "expressionBody");
        IrDeclarationsKt.getIrValueParameter($this$putDefault, parameter).setDefaultValue(expressionBody);
    }

    public static final boolean isStaticMethodOfClass(@NotNull IrFunction $this$isStaticMethodOfClass) {
        Intrinsics.checkNotNullParameter($this$isStaticMethodOfClass, "<this>");
        return $this$isStaticMethodOfClass instanceof IrSimpleFunction && $this$isStaticMethodOfClass.getParent() instanceof IrClass && $this$isStaticMethodOfClass.getDispatchReceiverParameter() == null;
    }

    public static final boolean isPropertyAccessor(@NotNull IrFunction $this$isPropertyAccessor) {
        Intrinsics.checkNotNullParameter($this$isPropertyAccessor, "<this>");
        return $this$isPropertyAccessor instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isPropertyAccessor).getCorrespondingPropertySymbol() != null;
    }

    @Nullable
    public static final MultiFieldValueClassRepresentation<IrSimpleType> getMultiFieldValueClassRepresentation(@NotNull IrClass $this$multiFieldValueClassRepresentation) {
        Intrinsics.checkNotNullParameter($this$multiFieldValueClassRepresentation, "<this>");
        ValueClassRepresentation<IrSimpleType> valueClassRepresentation2 = $this$multiFieldValueClassRepresentation.getValueClassRepresentation();
        return valueClassRepresentation2 instanceof MultiFieldValueClassRepresentation ? (MultiFieldValueClassRepresentation)valueClassRepresentation2 : null;
    }

    @Nullable
    public static final InlineClassRepresentation<IrSimpleType> getInlineClassRepresentation(@NotNull IrClass $this$inlineClassRepresentation) {
        Intrinsics.checkNotNullParameter($this$inlineClassRepresentation, "<this>");
        ValueClassRepresentation<IrSimpleType> valueClassRepresentation2 = $this$inlineClassRepresentation.getValueClassRepresentation();
        return valueClassRepresentation2 instanceof InlineClassRepresentation ? (InlineClassRepresentation)valueClassRepresentation2 : null;
    }
}

