/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.SourcePosition;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0086\u0002J=\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0003J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010#\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/RangeMapping;", "", "source", "", "dest", "range", "callSite", "Lorg/jetbrains/kotlin/codegen/inline/SourcePosition;", "parent", "Lorg/jetbrains/kotlin/codegen/inline/FileMapping;", "(IIILorg/jetbrains/kotlin/codegen/inline/SourcePosition;Lorg/jetbrains/kotlin/codegen/inline/FileMapping;)V", "getCallSite", "()Lorg/jetbrains/kotlin/codegen/inline/SourcePosition;", "getDest", "()I", "getParent", "()Lorg/jetbrains/kotlin/codegen/inline/FileMapping;", "getRange", "setRange", "(I)V", "getSource", "component1", "component2", "component3", "component4", "component5", "contains", "", "destLine", "copy", "equals", "other", "hasMappingForSource", "sourceLine", "hashCode", "mapDestToSource", "mapSourceToDest", "toString", "", "backend"})
public final class RangeMapping {
    private final int source;
    private final int dest;
    private int range;
    @Nullable
    private final SourcePosition callSite;
    @NotNull
    private final FileMapping parent;

    public RangeMapping(int source2, int dest, int range, @Nullable SourcePosition callSite, @NotNull FileMapping parent2) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        this.source = source2;
        this.dest = dest;
        this.range = range;
        this.callSite = callSite;
        this.parent = parent2;
    }

    public final int getSource() {
        return this.source;
    }

    public final int getDest() {
        return this.dest;
    }

    public final int getRange() {
        return this.range;
    }

    public final void setRange(int n) {
        this.range = n;
    }

    @Nullable
    public final SourcePosition getCallSite() {
        return this.callSite;
    }

    @NotNull
    public final FileMapping getParent() {
        return this.parent;
    }

    public final boolean contains(int destLine) {
        return this.dest <= destLine && destLine < this.dest + this.range;
    }

    public final boolean hasMappingForSource(int sourceLine) {
        return this.source <= sourceLine && sourceLine < this.source + this.range;
    }

    @NotNull
    public final SourcePosition mapDestToSource(int destLine) {
        return new SourcePosition(this.source + (destLine - this.dest), this.parent.getName(), this.parent.getPath());
    }

    public final int mapSourceToDest(int sourceLine) {
        return this.dest + (sourceLine - this.source);
    }

    public final int component1() {
        return this.source;
    }

    public final int component2() {
        return this.dest;
    }

    public final int component3() {
        return this.range;
    }

    @Nullable
    public final SourcePosition component4() {
        return this.callSite;
    }

    @NotNull
    public final FileMapping component5() {
        return this.parent;
    }

    @NotNull
    public final RangeMapping copy(int source2, int dest, int range, @Nullable SourcePosition callSite, @NotNull FileMapping parent2) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        return new RangeMapping(source2, dest, range, callSite, parent2);
    }

    public static /* synthetic */ RangeMapping copy$default(RangeMapping rangeMapping, int n, int n2, int n3, SourcePosition sourcePosition, FileMapping fileMapping, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = rangeMapping.source;
        }
        if ((n4 & 2) != 0) {
            n2 = rangeMapping.dest;
        }
        if ((n4 & 4) != 0) {
            n3 = rangeMapping.range;
        }
        if ((n4 & 8) != 0) {
            sourcePosition = rangeMapping.callSite;
        }
        if ((n4 & 0x10) != 0) {
            fileMapping = rangeMapping.parent;
        }
        return rangeMapping.copy(n, n2, n3, sourcePosition, fileMapping);
    }

    @NotNull
    public String toString() {
        return "RangeMapping(source=" + this.source + ", dest=" + this.dest + ", range=" + this.range + ", callSite=" + this.callSite + ", parent=" + this.parent + ')';
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.source);
        result2 = result2 * 31 + Integer.hashCode(this.dest);
        result2 = result2 * 31 + Integer.hashCode(this.range);
        result2 = result2 * 31 + (this.callSite == null ? 0 : this.callSite.hashCode());
        result2 = result2 * 31 + this.parent.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RangeMapping)) {
            return false;
        }
        RangeMapping rangeMapping = (RangeMapping)other;
        if (this.source != rangeMapping.source) {
            return false;
        }
        if (this.dest != rangeMapping.dest) {
            return false;
        }
        if (this.range != rangeMapping.range) {
            return false;
        }
        if (!Intrinsics.areEqual(this.callSite, rangeMapping.callSite)) {
            return false;
        }
        return Intrinsics.areEqual(this.parent, rangeMapping.parent);
    }
}

