/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationMemberGenerator;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformer;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformerKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.DeepCopyIrTreeWithDeclarationsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J8\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J \u0010#\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0011H\u0016J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\f\u0010(\u001a\u00020\b*\u00020\"H\u0002J\u0014\u0010)\u001a\u00020'*\u00020*2\u0006\u0010+\u001a\u00020'H\u0002J\u0014\u0010,\u001a\u00020'*\u00020*2\u0006\u0010-\u001a\u00020'H\u0002J\f\u0010.\u001a\u00020\"*\u00020\"H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmAnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer;", "jvmContext", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "inInlineFunctionScope", "", "getInInlineFunctionScope", "()Z", "getJvmContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "publicAnnotationImplementationClasses", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "chooseConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "implClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "generateFunctionBodies", "", "annotationClass", "eqFun", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "hcFun", "toStringFun", "generator", "Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationMemberGenerator;", "getArrayContentEqualsSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "implementAnnotationPropertiesAndConstructor", "generatedConstructor", "implementPlatformSpecificParts", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "isKClassArray", "kClassArrayToJClassArray", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "kClassArray", "kClassToJClass", "irExpression", "kClassToJClassIfNeeded", "backend.jvm.lower"})
public final class JvmAnnotationImplementationTransformer
extends AnnotationImplementationTransformer {
    @NotNull
    private final JvmBackendContext jvmContext;
    @NotNull
    private final Set<IrClassSymbol> publicAnnotationImplementationClasses;

    public JvmAnnotationImplementationTransformer(@NotNull JvmBackendContext jvmContext, @NotNull IrFile file2) {
        Intrinsics.checkNotNullParameter(jvmContext, "jvmContext");
        Intrinsics.checkNotNullParameter(file2, "file");
        super(jvmContext, file2);
        this.jvmContext = jvmContext;
        this.publicAnnotationImplementationClasses = new LinkedHashSet();
    }

    @NotNull
    public final JvmBackendContext getJvmContext() {
        return this.jvmContext;
    }

    private final boolean getInInlineFunctionScope() {
        boolean bl;
        block4: {
            Iterable $this$any$iv = this.getAllScopes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ScopeWithIr it = (ScopeWithIr)element$iv;
                    boolean bl2 = false;
                    IrElement $this$safeAs$iv = it.getIrElement();
                    boolean $i$f$safeAs = false;
                    IrElement irElement = $this$safeAs$iv;
                    if (!(irElement instanceof IrDeclaration)) {
                        irElement = null;
                    }
                    IrDeclaration irDeclaration2 = (IrDeclaration)irElement;
                    boolean bl3 = irDeclaration2 != null ? JvmIrInlineUtilsKt.isInPublicInlineScope(irDeclaration2) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public IrConstructor chooseConstructor(@NotNull IrClass implClass, @NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter(implClass, "implClass");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return SequencesKt.single(IrUtilsKt.getConstructors(implClass));
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrClassSymbol constructedClass = IrTypesKt.getClassOrNull(expression2.getType());
        Object object = constructedClass;
        boolean bl = object != null && (object = (IrClass)object.getOwner()) != null ? IrUtilsKt.isAnnotationClass((IrClass)object) : false;
        if (bl && this.getInInlineFunctionScope()) {
            ((Collection)this.publicAnnotationImplementationClasses).add(constructedClass);
        }
        return super.visitConstructorCall(expression2);
    }

    private final IrType kClassToJClassIfNeeded(IrType $this$kClassToJClassIfNeeded) {
        IrType irType;
        if (IrTypePredicatesKt.isKClass($this$kClassToJClassIfNeeded)) {
            irType = IrTypesKt.getStarProjectedType(this.jvmContext.getIr().getSymbols().getJavaLangClass());
        } else if (this.isKClassArray($this$kClassToJClassIfNeeded)) {
            IrType[] irTypeArray = new IrType[]{IrTypesKt.getStarProjectedType(this.jvmContext.getIr().getSymbols().getJavaLangClass())};
            irType = IrTypesKt.typeWith((IrClassifierSymbol)this.jvmContext.getIrBuiltIns().getArrayClass(), irTypeArray);
        } else {
            irType = $this$kClassToJClassIfNeeded;
        }
        return irType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKClassArray(IrType $this$isKClassArray) {
        if (!($this$isKClassArray instanceof IrSimpleType)) return false;
        if (!IrTypePredicatesKt.isArray($this$isKClassArray)) return false;
        IrType irType = IrTypesKt.getTypeOrNull(CollectionsKt.single(((IrSimpleType)$this$isKClassArray).getArguments()));
        if (irType == null) return false;
        if (!IrTypePredicatesKt.isKClass(irType)) return false;
        return true;
    }

    private final IrExpression kClassToJClass(IrBuilderWithScope $this$kClassToJClass, IrExpression irExpression) {
        IrCall irCall;
        IrCall $this$kClassToJClass_u24lambda_u241 = irCall = ExpressionHelpersKt.irGet($this$kClassToJClass, IrTypesKt.getStarProjectedType(this.jvmContext.getIr().getSymbols().getJavaLangClass()), null, this.jvmContext.getIr().getSymbols().getKClassJavaPropertyGetter().getSymbol());
        boolean bl = false;
        $this$kClassToJClass_u24lambda_u241.setExtensionReceiver(irExpression);
        return irCall;
    }

    /*
     * Unable to fully structure code
     */
    private final IrExpression kClassArrayToJClassArray(IrBuilderWithScope $this$kClassArrayToJClassArray, IrExpression kClassArray) {
        block13: {
            javaLangClass = IrTypesKt.getStarProjectedType(this.jvmContext.getIr().getSymbols().getJavaLangClass());
            var5_4 = new IrType[]{javaLangClass};
            jlcArray = IrTypesKt.typeWith((IrClassifierSymbol)this.jvmContext.getIr().getSymbols().getArray(), var5_4);
            arrayClass = (IrClass)this.jvmContext.getIr().getSymbols().getArray().getOwner();
            arrayOfNulls = this.jvmContext.getIr().getSymbols().getArrayOfNulls();
            $this$findDeclaration$iv = arrayClass;
            $i$f$findDeclaration = false;
            for (T var11_12 : (Iterable)$this$findDeclaration$iv.getDeclarations()) {
                it$iv = (IrDeclaration)var11_12;
                $i$a$-find-IrUtilsKt$findDeclaration$1$iv = false;
                if (!(it$iv instanceof IrProperty)) ** GOTO lbl-1000
                it = (IrProperty)it$iv;
                $i$a$-findDeclaration-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$arraySizeSymbol$1 = false;
                if (Intrinsics.areEqual(it.getName().asString(), "size")) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!v0) continue;
                v1 = var11_12;
                break block13;
            }
            v1 = v2 = null;
        }
        if (!(v1 instanceof IrProperty)) {
            v2 = null;
        }
        v3 = v2;
        Intrinsics.checkNotNull(v3);
        v4 = ((IrProperty)v3).getGetter();
        Intrinsics.checkNotNull(v4);
        arraySizeSymbol = v4;
        $this$irBlock_u24default$iv = $this$kClassArrayToJClassArray;
        startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        origin$iv = null;
        resultType$iv = null;
        $i$f$irBlock = false;
        $i$a$-findDeclaration-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$arraySizeSymbol$1 = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        $i$f$block = false;
        $this$kClassArrayToJClassArray_u24lambda_u2412 = this_$iv$iv;
        $i$a$-irBlock$default-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1 = false;
        sourceArray = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u2412, kClassArray, "src", false, null, null, 24, null);
        index = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u2412, (IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412, 0, null, 2, null), "i", true, null, null, 24, null);
        var22_28 = var21_27 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412, arraySizeSymbol);
        var23_29 = (IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u2412;
        $i$a$-apply-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$size$1 = false;
        $this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u243.setDispatchReceiver(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412, sourceArray));
        size = IrBuilderKt.createTmpVariable$default(var23_29, (IrExpression)var21_27, "size", false, null, null, 24, null);
        $i$a$-apply-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$size$1 = $this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u243 = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412, arrayOfNulls, jlcArray, 0, 0, null, 28, null);
        var23_29 = (IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u2412;
        $i$a$-apply-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$result$1 = false;
        CollectionsKt.listOf(javaLangClass);
        $this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u244.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412, size));
        result = IrBuilderKt.createTmpVariable$default(var23_29, (IrExpression)$this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u243, null, false, null, null, 30, null);
        v5 = $this$kClassArrayToJClassArray_u24lambda_u2412.getStartOffset();
        v6 = $this$kClassArrayToJClassArray_u24lambda_u2412.getEndOffset();
        v7 = $this$kClassArrayToJClassArray_u24lambda_u2412.getContext().getIrBuiltIns().getLessFunByOperandType().get(IrTypesKt.getClassifierOrFail($this$kClassArrayToJClassArray_u24lambda_u2412.getContext().getIrBuiltIns().getIntType()));
        Intrinsics.checkNotNull(v7);
        comparison = PrimitivesKt.primitiveOp2(v5, v6, v7, $this$kClassArrayToJClassArray_u24lambda_u2412.getContext().getIrBuiltIns().getBooleanType(), IrStatementOrigin.LT.INSTANCE, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412, index), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412, size));
        $this$single$iv = IrUtilsKt.getFunctions(arrayClass);
        $i$f$single = false;
        single$iv = null;
        found$iv = false;
        var30_44 = $this$single$iv.iterator();
        while (var30_44.hasNext()) {
            element$iv = var30_44.next();
            it = element$iv;
            $i$a$-single-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$setArraySymbol$1 = false;
            if (!Intrinsics.areEqual(it.getName(), OperatorNameConventions.SET)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        setArraySymbol = single$iv;
        $this$single$iv = IrUtilsKt.getFunctions(arrayClass);
        $i$f$single = false;
        single$iv = null;
        found$iv = false;
        element$iv = $this$single$iv.iterator();
        while (element$iv.hasNext()) {
            element$iv = element$iv.next();
            it = (IrSimpleFunction)element$iv;
            $i$a$-single-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$getArraySymbol$1 = false;
            if (!Intrinsics.areEqual(it.getName(), OperatorNameConventions.GET)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        getArraySymbol = single$iv;
        v8 = IrTypesKt.getClass($this$kClassArrayToJClassArray_u24lambda_u2412.getContext().getIrBuiltIns().getIntType());
        Intrinsics.checkNotNull(v8);
        $this$single$iv = IrUtilsKt.getFunctions(v8);
        $i$f$single = false;
        single$iv = null;
        found$iv = false;
        element$iv = $this$single$iv.iterator();
        while (element$iv.hasNext()) {
            element$iv = element$iv.next();
            it = (IrSimpleFunction)element$iv;
            $i$a$-single-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$inc$1 = false;
            if (!Intrinsics.areEqual(it.getName(), OperatorNameConventions.INC)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        inc = single$iv;
        $i$f$single = var28_39 = IrBuilderKt.irWhile$default((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412, null, 1, null);
        var23_29 = $this$kClassArrayToJClassArray_u24lambda_u2412;
        $i$a$-also-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$1 = false;
        loop.setCondition(comparison);
        $this$irBlock_u24default$iv = (IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412;
        startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        origin$iv = null;
        resultType$iv = null;
        $i$f$irBlock = false;
        var37_63 = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        $i$f$block = false;
        var39_65 = this_$iv$iv;
        var40_66 = loop;
        $i$a$-irBlock$default-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$1$1 = false;
        tempIndex = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, index), null, false, null, null, 30, null);
        $this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u248 = var43_69 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, getArraySymbol);
        $i$a$-apply-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$1$1$getArray$1 = false;
        $this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u248.setDispatchReceiver(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, sourceArray));
        $this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u248.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, tempIndex));
        getArray = var43_69;
        $this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u248 = var43_69 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, setArraySymbol);
        var47_73 = $this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
        $i$a$-apply-JvmAnnotationImplementationTransformer$kClassArrayToJClassArray$block$1$1$1$1 = false;
        $this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setDispatchReceiver(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, result));
        $this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, tempIndex));
        $this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.putValueArgument(1, this.kClassToJClass((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, getArray));
        var47_73.unaryPlus(var43_69);
        $this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.unaryPlus(ExpressionHelpersKt.irSet$default((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, index.getSymbol(), (IrExpression)ExpressionHelpersKt.irCallOp$default((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, inc.getSymbol(), index.getType(), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, index), null, null, 24, null), null, 4, null));
        var40_66.setBody(this_$iv$iv.doBuild());
        var23_29.unaryPlus(var28_39);
        $this$kClassArrayToJClassArray_u24lambda_u2412.unaryPlus(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u2412, result));
        block = this_$iv$iv.doBuild();
        return block;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public IrFunctionSymbol getArrayContentEqualsSymbol(@NotNull IrType type) {
        block5: {
            Intrinsics.checkNotNullParameter(type, "type");
            targetType = IrTypeUtilsKt.isPrimitiveArray(type) != false ? type : (IrType)this.jvmContext.getIr().getSymbols().getArrayOfAnyNType();
            $this$findDeclaration$iv = (IrDeclarationContainer)this.jvmContext.getIr().getSymbols().getArraysClass().getOwner();
            $i$f$findDeclaration = false;
            for (T var7_8 : (Iterable)$this$findDeclaration$iv.getDeclarations()) {
                it$iv = (IrDeclaration)var7_8;
                $i$a$-find-IrUtilsKt$findDeclaration$1$iv = false;
                if (!(it$iv instanceof IrFunction)) ** GOTO lbl-1000
                it = (IrFunction)it$iv;
                $i$a$-findDeclaration-JvmAnnotationImplementationTransformer$getArrayContentEqualsSymbol$requiredSymbol$1 = false;
                if (Intrinsics.areEqual(it.getName().asString(), "equals") != false && it.getValueParameters().size() == 2 && Intrinsics.areEqual(CollectionsKt.first(it.getValueParameters()).getType(), targetType) != false) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!v0) continue;
                v1 = var7_8;
                break block5;
            }
            v1 = v2 = null;
        }
        if (!(v1 instanceof IrFunction)) {
            v2 = null;
        }
        if ((requiredSymbol = (IrFunction)((IrDeclaration)v2)) == null) {
            $i$a$-requireNotNull-JvmAnnotationImplementationTransformer$getArrayContentEqualsSymbol$1 = false;
            var4_5 = "Can't find Arrays.equals method for type " + RenderIrElementKt.render(targetType);
            throw new IllegalArgumentException(var4_5.toString());
        }
        return requiredSymbol.getSymbol();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void implementPlatformSpecificParts(@NotNull IrClass annotationClass, @NotNull IrClass implClass) {
        void this_$iv$iv;
        void $this$implementPlatformSpecificParts_u24lambda_u2417_u24lambda_u2416;
        Intrinsics.checkNotNullParameter(annotationClass, "annotationClass");
        Intrinsics.checkNotNullParameter(implClass, "implClass");
        if (this.publicAnnotationImplementationClasses.contains(annotationClass.getSymbol())) {
            ((Collection)this.jvmContext.getPublicAbiSymbols()).add(implClass.getSymbol());
        }
        IrAnnotationContainer irAnnotationContainer = IrTypesKt.getStarProjectedType(this.jvmContext.getIr().getSymbols().getJavaLangClass());
        IrDeclarationOriginImpl irDeclarationOriginImpl = AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION();
        IrAnnotationContainer $this$implementPlatformSpecificParts_u24lambda_u2417 = irAnnotationContainer = DeclarationBuildersKt.addFunction$default(implClass, "annotationType", (IrType)irAnnotationContainer, null, null, false, false, false, irDeclarationOriginImpl, 0, 0, 876, null);
        boolean bl = false;
        JvmIrBuilder jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder$default(this.jvmContext, ((IrSimpleFunction)$this$implementPlatformSpecificParts_u24lambda_u2417).getSymbol(), 0, 0, 6, null);
        IrAnnotationContainer irAnnotationContainer2 = $this$implementPlatformSpecificParts_u24lambda_u2417;
        boolean bl2 = false;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)$this$implementPlatformSpecificParts_u24lambda_u2417_u24lambda_u2416;
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void $this$implementPlatformSpecificParts_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415 = this_$iv$iv;
        boolean bl3 = false;
        $this$implementPlatformSpecificParts_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$implementPlatformSpecificParts_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415, JvmIrUtilsKt.javaClassReference((JvmIrBuilder)$this$implementPlatformSpecificParts_u24lambda_u2417_u24lambda_u2416, IrUtilsKt.getDefaultType(annotationClass))));
        ((IrFunction)irAnnotationContainer2).setBody(this_$iv$iv.doBuild());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void implementAnnotationPropertiesAndConstructor(@NotNull IrClass implClass, @NotNull IrClass annotationClass, @NotNull IrConstructor generatedConstructor) {
        Intrinsics.checkNotNullParameter(implClass, "implClass");
        Intrinsics.checkNotNullParameter(annotationClass, "annotationClass");
        Intrinsics.checkNotNullParameter(generatedConstructor, "generatedConstructor");
        DeclarationIrBuilder ctorBodyBuilder = LowerUtilsKt.createIrBuilder(this.getContext(), (IrSymbol)generatedConstructor.getSymbol(), -2, -2);
        IrBlockBody ctorBody = this.getContext().getIrFactory().createBlockBody(-2, -2, CollectionsKt.listOf(new IrDelegatingConstructorCallImpl(-2, -2, this.getContext().getIrBuiltIns().getUnitType(), SequencesKt.single(IrUtilsKt.getConstructors(this.getContext().getIrBuiltIns().getAnyClass())), 0, 0)));
        generatedConstructor.setBody(ctorBody);
        Iterable $this$forEach$iv = this.getAnnotationProperties(annotationClass);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425;
            void this_$iv$iv;
            Object object;
            Object prop2;
            Object object2;
            IrExpressionBody irExpressionBody;
            IrExpression defaultExpression;
            IrProperty property2 = (IrProperty)element$iv;
            boolean bl = false;
            IrSimpleFunction irSimpleFunction = property2.getGetter();
            Intrinsics.checkNotNull(irSimpleFunction);
            IrType propType = irSimpleFunction.getReturnType();
            IrType storedFieldType = this.kClassToJClassIfNeeded(propType);
            Name propName = property2.getName();
            Object $this$buildField$iv = this.getContext().getIrFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u244$iv = new IrFieldBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildField$2$iv22 = false;
            Object $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2418 = $this$buildField_u24lambda_u244$iv;
            boolean bl22 = false;
            ((IrElementBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2418).setStartOffset(-2);
            ((IrElementBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2418).setEndOffset(-2);
            ((IrDeclarationBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2418).setName(propName);
            ((IrFieldBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2418).setType(storedFieldType);
            ((IrDeclarationBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2418).setOrigin(AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
            ((IrFieldBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2418).setFinal(true);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PRIVATE");
            ((IrDeclarationBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2418).setVisibility(descriptorVisibility);
            Object it = $this$buildField$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv, $this$buildField_u24lambda_u244$iv);
            boolean bl3 = false;
            it.setParent(implClass);
            Object field2 = $this$buildField$iv;
            IrFunction irFunction2 = generatedConstructor;
            String string2 = propName.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "propName.asString()");
            IrValueParameter parameter = DeclarationBuildersKt.addValueParameter$default(irFunction2, string2, propType, null, 4, null);
            IrElementBase irElementBase = property2.getBackingField();
            IrExpression irExpression = irElementBase != null && (irElementBase = ((IrField)irElementBase).getInitializer()) != null ? ((IrExpressionBody)irElementBase).getExpression() : (defaultExpression = null);
            if (defaultExpression instanceof IrGetValue && ((IrGetValue)defaultExpression).getSymbol().getOwner() instanceof IrValueParameter) {
                IrValueDeclaration irValueDeclaration = ((IrGetValue)defaultExpression).getSymbol().getOwner();
                Intrinsics.checkNotNull(irValueDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrValueParameter");
                irExpressionBody = ((IrValueParameter)irValueDeclaration).getDefaultValue();
            } else if (defaultExpression != null) {
                IrField irField = property2.getBackingField();
                Intrinsics.checkNotNull(irField);
                irExpressionBody = irField.getInitializer();
            } else {
                irExpressionBody = null;
            }
            IrExpressionBody newDefaultValue = irExpressionBody;
            IrValueParameter irValueParameter = parameter;
            IrExpressionBody irExpressionBody2 = newDefaultValue;
            if (irExpressionBody2 != null && (irExpressionBody2 = (IrExpressionBody)DeepCopyIrTreeWithDeclarationsKt.deepCopyWithVariables((IrElement)irExpressionBody2)) != null) {
                void it2;
                Object bl22 = $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2418 = irExpressionBody2;
                IrValueParameter irValueParameter2 = irValueParameter;
                boolean bl4 = false;
                this.transformChildrenVoid((IrElement)it2);
                irValueParameter = irValueParameter2;
                object2 = $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2418;
            } else {
                object2 = null;
            }
            irValueParameter.setDefaultValue((IrExpressionBody)object2);
            Collection $i$a$-run-DeclarationBuildersKt$buildField$2$iv22 = ctorBody.getStatements();
            Object $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2421 = ctorBodyBuilder;
            boolean bl5 = false;
            IrGetValueImpl param = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2421, parameter);
            IrExpression fieldValue = IrTypePredicatesKt.isKClass(propType) ? this.kClassToJClass((IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2421, param) : (this.isKClassArray(propType) ? this.kClassArrayToJClassArray((IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2421, param) : (IrExpression)param);
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2421;
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2421;
            IrValueParameter irValueParameter3 = implClass.getThisReceiver();
            Intrinsics.checkNotNull(irValueParameter3);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2421 = ExpressionHelpersKt.irSetField$default(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter3), (IrField)field2, fieldValue, null, 8, null);
            $i$a$-run-DeclarationBuildersKt$buildField$2$iv22.add($this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2421);
            Object $this$addProperty$iv = implClass;
            boolean $i$f$addProperty = false;
            Object $this$buildProperty$iv$iv = $this$addProperty$iv.getFactory();
            boolean $i$f$buildProperty = false;
            IrPropertyBuilder $this$buildProperty_u24lambda_u248$iv$iv = new IrPropertyBuilder();
            boolean bl6 = false;
            Object $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2422 = $this$buildProperty_u24lambda_u248$iv$iv;
            boolean bl7 = false;
            ((IrElementBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2422).setStartOffset(-2);
            ((IrElementBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2422).setEndOffset(-2);
            ((IrDeclarationBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2422).setName(propName);
            ((IrPropertyBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2422).setVar(false);
            ((IrDeclarationBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2422).setOrigin(AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
            Object property$iv = $this$buildProperty$iv$iv = DeclarationBuildersKt.buildProperty((IrFactory)$this$buildProperty$iv$iv, $this$buildProperty_u24lambda_u248$iv$iv);
            boolean bl8 = false;
            $this$addProperty$iv.getDeclarations().add((IrDeclaration)property$iv);
            property$iv.setParent((IrDeclarationParent)$this$addProperty$iv);
            Object $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2423 = $this$addProperty$iv = $this$buildProperty$iv$iv;
            boolean bl9 = false;
            ((IrField)field2).setCorrespondingPropertySymbol(((IrProperty)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2423).getSymbol());
            ((IrProperty)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2423).setBackingField((IrField)field2);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2423.setParent(implClass);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2423.setOverriddenSymbols(CollectionsKt.listOf(property2.getSymbol()));
            Object $this$addGetter$iv = prop2 = $this$addProperty$iv;
            boolean $i$f$addGetter = false;
            IrFunctionBuilder $this$addGetter_u24lambda_u2411$iv = new IrFunctionBuilder();
            boolean bl10 = false;
            Name name = Name.special("<get-" + $this$addGetter$iv.getName() + '>');
            Intrinsics.checkNotNullExpressionValue(name, "special(\"<get-${this@addGetter.name}>\")");
            $this$addGetter_u24lambda_u2411$iv.setName(name);
            IrFunctionBuilder $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2424 = $this$addGetter_u24lambda_u2411$iv;
            boolean bl11 = false;
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2424.setStartOffset(-2);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2424.setEndOffset(-2);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2424.setName(propName);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2424.setReturnType(this.kClassToJClassIfNeeded(propType));
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2424.setOrigin(AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility2, "PUBLIC");
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2424.setVisibility(descriptorVisibility2);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2424.setModality(Modality.FINAL);
            Object getter$iv = $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2422 = DeclarationBuildersKt.buildFunction($this$addGetter$iv.getFactory(), $this$addGetter_u24lambda_u2411$iv);
            boolean bl12 = false;
            ((IrProperty)$this$addGetter$iv).setGetter((IrSimpleFunction)getter$iv);
            ((IrSimpleFunction)getter$iv).setCorrespondingPropertySymbol(((IrProperty)$this$addGetter$iv).getSymbol());
            getter$iv.setParent($this$addGetter$iv.getParent());
            Object $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2426 = object = $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2422;
            boolean bl13 = false;
            ((IrSimpleFunction)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2426).setCorrespondingPropertySymbol(((IrProperty)prop2).getSymbol());
            IrValueParameter irValueParameter4 = implClass.getThisReceiver();
            Intrinsics.checkNotNull(irValueParameter4);
            ((IrFunction)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2426).setDispatchReceiverParameter(IrUtilsKt.copyTo$default(irValueParameter4, (IrFunction)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2426, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null));
            IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder(this.getContext(), (IrSymbol)((IrSimpleFunction)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2426).getSymbol(), -2, -2);
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            getter$iv = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void var30_49 = this_$iv$iv;
            Object object3 = $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2426;
            boolean bl14 = false;
            IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425;
            IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425;
            IrBuilderWithScope irBuilderWithScope5 = (IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425;
            IrValueParameter irValueParameter5 = ((IrFunction)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2426).getDispatchReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter5);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope3, ExpressionHelpersKt.irGetField(irBuilderWithScope4, ExpressionHelpersKt.irGet(irBuilderWithScope5, irValueParameter5), (IrField)field2)));
            ((IrFunction)object3).setBody(this_$iv$iv.doBuild());
            IrSimpleFunction irSimpleFunction2 = property2.getGetter();
            Intrinsics.checkNotNull(irSimpleFunction2);
            $this$implementAnnotationPropertiesAndConstructor_u24lambda_u2427_u24lambda_u2426.setOverriddenSymbols(CollectionsKt.listOf(irSimpleFunction2.getSymbol()));
        }
    }

    @Override
    public void generateFunctionBodies(@NotNull IrClass annotationClass, @NotNull IrClass implClass, @NotNull IrSimpleFunction eqFun, @NotNull IrSimpleFunction hcFun, @NotNull IrSimpleFunction toStringFun, @NotNull AnnotationImplementationMemberGenerator generator2) {
        Intrinsics.checkNotNullParameter(annotationClass, "annotationClass");
        Intrinsics.checkNotNullParameter(implClass, "implClass");
        Intrinsics.checkNotNullParameter(eqFun, "eqFun");
        Intrinsics.checkNotNullParameter(hcFun, "hcFun");
        Intrinsics.checkNotNullParameter(toStringFun, "toStringFun");
        Intrinsics.checkNotNullParameter(generator2, "generator");
        List<IrProperty> properties2 = this.getAnnotationProperties(annotationClass);
        List<IrProperty> implProperties = this.getAnnotationProperties(implClass);
        generator2.generateEqualsUsingGetters(eqFun, IrUtilsKt.getDefaultType(annotationClass), properties2);
        generator2.generateHashCodeMethod(hcFun, implProperties);
        generator2.generateToStringMethod(toStringFun, implProperties);
    }
}

