/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.symbols.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H&J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u0082\u0001\u0002\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "D", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/name/ClassId;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "deprecation", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationsPerUseSite;", "getDeprecation", "()Lorg/jetbrains/kotlin/fir/declarations/DeprecationsPerUseSite;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "rawStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "getRawStatus", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "toLookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "toString", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeAliasSymbol;", "tree"})
public abstract class FirClassLikeSymbol<D extends FirClassLikeDeclaration>
extends FirClassifierSymbol<D> {
    @NotNull
    private final ClassId classId;

    private FirClassLikeSymbol(ClassId classId) {
        super(null);
        this.classId = classId;
    }

    @NotNull
    public final ClassId getClassId() {
        return this.classId;
    }

    @Override
    @NotNull
    public abstract ConeClassLikeLookupTag toLookupTag();

    @NotNull
    public final Name getName() {
        Name name = this.classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue(name, "classId.shortClassName");
        return name;
    }

    @Nullable
    public final DeprecationsPerUseSite getDeprecation() {
        FirPhaseManagerKt.ensureResolved(this, FirResolvePhase.COMPILER_REQUIRED_ANNOTATIONS);
        return ((FirClassLikeDeclaration)this.getFir()).getDeprecation();
    }

    @NotNull
    public final FirDeclarationStatus getRawStatus() {
        return ((FirClassLikeDeclaration)this.getFir()).getStatus();
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + ' ' + this.classId.asString();
    }

    public /* synthetic */ FirClassLikeSymbol(ClassId classId, DefaultConstructorMarker $constructor_marker) {
        this(classId);
    }
}

