/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.ConstantsClassVisitor;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMemberSignature;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r`\u000eJK\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0010\u0010\u0017\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019JC\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0010\u0010\u001d\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u001eR\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/incremental/InlineFunctionsClassVisitor;", "Lorg/jetbrains/org/objectweb/asm/ClassVisitor;", "inlineFunctionSignatures", "", "", "cv", "Lorg/jetbrains/kotlin/incremental/ConstantsClassVisitor;", "(Ljava/util/Set;Lorg/jetbrains/kotlin/incremental/ConstantsClassVisitor;)V", "classVersion", "", "Ljava/lang/Integer;", "result", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "getResult", "visit", "", "version", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitMethod", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "desc", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "kotlin-build-common"})
final class InlineFunctionsClassVisitor
extends ClassVisitor {
    @NotNull
    private final Set<String> inlineFunctionSignatures;
    @NotNull
    private final LinkedHashMap<String, Long> result;
    @Nullable
    private Integer classVersion;

    public InlineFunctionsClassVisitor(@NotNull Set<String> inlineFunctionSignatures, @NotNull ConstantsClassVisitor cv) {
        Intrinsics.checkNotNullParameter(inlineFunctionSignatures, "inlineFunctionSignatures");
        Intrinsics.checkNotNullParameter(cv, "cv");
        super(589824, cv);
        this.inlineFunctionSignatures = inlineFunctionSignatures;
        this.result = new LinkedHashMap();
    }

    @Override
    public void visit(int version, int access, @NotNull String name, @Nullable String signature2, @Nullable String superName, @Nullable String[] interfaces) {
        Intrinsics.checkNotNullParameter(name, "name");
        super.visit(version, access, name, signature2, superName, interfaces);
        this.classVersion = version;
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(desc, "desc");
        if ((access & 2) == 2) {
            return null;
        }
        String functionSignature = new JvmMemberSignature.Method(name, desc).asString();
        if (!this.inlineFunctionSignatures.contains(functionSignature)) {
            return null;
        }
        ClassWriter classWriter = new ClassWriter(0);
        Integer n = this.classVersion;
        Intrinsics.checkNotNull(n);
        classWriter.visit(n, 0, "ClassWithOneMethod", null, null, null);
        MethodVisitor methodVisitor = classWriter.visitMethod(access, name, desc, signature2, exceptions);
        return new MethodVisitor(this, functionSignature, classWriter, methodVisitor){
            final /* synthetic */ InlineFunctionsClassVisitor this$0;
            final /* synthetic */ String $functionSignature;
            final /* synthetic */ ClassWriter $classWriter;
            {
                this.this$0 = $receiver;
                this.$functionSignature = $functionSignature;
                this.$classWriter = $classWriter;
                super(589824, $super_call_param$1);
            }

            public void visitEnd() {
                Map map = InlineFunctionsClassVisitor.access$getResult$p(this.this$0);
                String string2 = this.$functionSignature;
                byte[] byArray = this.$classWriter.toByteArray();
                Intrinsics.checkNotNullExpressionValue(byArray, "classWriter.toByteArray()");
                Long l = IncrementalJvmCacheKt.md5(byArray);
                map.put(string2, l);
            }
        };
    }

    @NotNull
    public final LinkedHashMap<String, Long> getResult() {
        return this.result;
    }

    public static final /* synthetic */ LinkedHashMap access$getResult$p(InlineFunctionsClassVisitor $this) {
        return $this.result;
    }
}

