/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.Closure;
import org.jetbrains.kotlin.backend.common.lower.ClosureAnnotator;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmInnerClassesSupport;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptFixLambdasTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptFixLambdasTransformerContext;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptToClassTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptToClassTransformerContext;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptsToClassesLowering;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptsToClassesSymbolRemapper;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReporterWithContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrAnonymousInitializerImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrClassImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrExternalPackageFragmentImpl;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrAnonymousInitializerSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SimpleTypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmBackendErrors;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010$\u001a\u00020\u0019*\u00020\u001bH\u0002J \u0010%\u001a\u00020\u0019*\u00020\u001b2\u0006\u0010&\u001a\u00020'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesLowering;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "innerClassesSupport", "Lorg/jetbrains/kotlin/backend/jvm/JvmInnerClassesSupport;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Lorg/jetbrains/kotlin/backend/jvm/JvmInnerClassesSupport;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "getInnerClassesSupport", "()Lorg/jetbrains/kotlin/backend/jvm/JvmInnerClassesSupport;", "scriptingJvmPackage", "Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "getScriptingJvmPackage", "()Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "scriptingJvmPackage$delegate", "Lkotlin/Lazy;", "collectCapturingClasses", "", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrClassImpl;", "irScript", "Lorg/jetbrains/kotlin/ir/declarations/IrScript;", "typeRemapper", "Lorg/jetbrains/kotlin/ir/util/SimpleTypeRemapper;", "finalizeScriptClass", "", "irScriptClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "symbolRemapper", "Lorg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesSymbolRemapper;", "lower", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "prepareScriptClass", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "addScriptMainFun", "addSimplePropertyFrom", "from", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "initializer", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "backend.jvm.lower"})
final class ScriptsToClassesLowering {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final JvmInnerClassesSupport innerClassesSupport;
    @NotNull
    private final Lazy scriptingJvmPackage$delegate;

    public ScriptsToClassesLowering(@NotNull JvmBackendContext context, @NotNull JvmInnerClassesSupport innerClassesSupport) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(innerClassesSupport, "innerClassesSupport");
        this.context = context;
        this.innerClassesSupport = innerClassesSupport;
        this.scriptingJvmPackage$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, (Function0)new Function0<IrExternalPackageFragment>(this){
            final /* synthetic */ ScriptsToClassesLowering this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrExternalPackageFragment invoke() {
                return IrExternalPackageFragmentImpl.Companion.createEmptyExternalPackageFragment(this.this$0.getContext().getState().getModule(), new FqName("kotlin.script.experimental.jvm"));
            }
        });
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final JvmInnerClassesSupport getInnerClassesSupport() {
        return this.innerClassesSupport;
    }

    public final void lower(@NotNull IrModuleFragment module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        Map scriptsToClasses = new LinkedHashMap();
        for (IrFile irFile : module2.getFiles()) {
            ListIterator<IrDeclaration> iterator2 = irFile.getDeclarations().listIterator();
            while (iterator2.hasNext()) {
                IrDeclaration declaration = iterator2.next();
                if (!(declaration instanceof IrScript)) continue;
                IrClass scriptClass = this.prepareScriptClass(irFile, (IrScript)declaration);
                scriptsToClasses.put(declaration, scriptClass);
                iterator2.set(scriptClass);
            }
        }
        ScriptsToClassesSymbolRemapper symbolRemapper2 = new ScriptsToClassesSymbolRemapper(scriptsToClasses);
        for (Map.Entry entry : scriptsToClasses.entrySet()) {
            IrScript irScript = (IrScript)entry.getKey();
            IrClass irScriptClass = (IrClass)entry.getValue();
            this.finalizeScriptClass(irScriptClass, irScript, symbolRemapper2);
            PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irScriptClass, irScript.getParent());
        }
    }

    private final IrClass prepareScriptClass(IrFile irFile, IrScript irScript) {
        IrClass irClass2;
        IrFileEntry fileEntry = irFile.getFileEntry();
        IrFactory $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$prepareScriptClass_u24lambda_u240 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$prepareScriptClass_u24lambda_u240.setStartOffset(0);
        $this$prepareScriptClass_u24lambda_u240.setEndOffset(fileEntry.getMaxOffset());
        $this$prepareScriptClass_u24lambda_u240.setOrigin(IrDeclarationOrigin.SCRIPT_CLASS.INSTANCE);
        $this$prepareScriptClass_u24lambda_u240.setName(irScript.getName());
        $this$prepareScriptClass_u24lambda_u240.setKind(ClassKind.CLASS);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PUBLIC");
        $this$prepareScriptClass_u24lambda_u240.setVisibility(descriptorVisibility);
        $this$prepareScriptClass_u24lambda_u240.setModality(Modality.FINAL);
        IrClass irScriptClass = irClass2 = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        boolean bl3 = false;
        irScriptClass.setSuperTypes(CollectionsKt.plus((Collection)irScriptClass.getSuperTypes(), irScript.getBaseClass()));
        irScriptClass.setParent(irFile);
        irScriptClass.setMetadata(irScript.getMetadata());
        irScript.setTargetClass(irScriptClass.getSymbol());
        return irClass2;
    }

    private final Set<IrClassImpl> collectCapturingClasses(IrScript irScript, SimpleTypeRemapper typeRemapper) {
        ClosureAnnotator annotator = new ClosureAnnotator(irScript, irScript);
        Set capturingClasses = new LinkedHashSet();
        IrElementVisitorVoid collector2 = new IrElementVisitorVoid(annotator, irScript, this, capturingClasses, typeRemapper){
            final /* synthetic */ ClosureAnnotator $annotator;
            final /* synthetic */ IrScript $irScript;
            final /* synthetic */ ScriptsToClassesLowering this$0;
            final /* synthetic */ Set<IrClassImpl> $capturingClasses;
            final /* synthetic */ SimpleTypeRemapper $typeRemapper;
            {
                this.$annotator = $annotator;
                this.$irScript = $irScript;
                this.this$0 = $receiver;
                this.$capturingClasses = $capturingClasses;
                this.$typeRemapper = $typeRemapper;
            }

            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            /*
             * WARNING - void declaration
             */
            public void visitClass(@NotNull IrClass declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                if (declaration instanceof IrClassImpl && !((IrClassImpl)declaration).isInner()) {
                    boolean bl;
                    Object object;
                    block23: {
                        void $this$forEach$iv;
                        Object it;
                        boolean $i$f$forEach;
                        Object $this$forEach$iv2;
                        Closure closure = this.$annotator.getClassClosure(declaration);
                        object = new IrType[]{this.$irScript.getThisReceiver().getType()};
                        Set<IrType> scriptsReceivers = SetsKt.mutableSetOf(object);
                        List<IrScriptSymbol> list2 = this.$irScript.getEarlierScripts();
                        if (list2 != null) {
                            $this$forEach$iv2 = list2;
                            $i$f$forEach = false;
                            Iterator<T> iterator2 = $this$forEach$iv2.iterator();
                            while (iterator2.hasNext()) {
                                T element$iv = iterator2.next();
                                it = (IrScriptSymbol)element$iv;
                                boolean bl2 = false;
                                scriptsReceivers.add(((IrScript)it.getOwner()).getThisReceiver().getType());
                            }
                        }
                        object = this.$irScript.getImplicitReceiversParameters();
                        $this$forEach$iv2 = this.$typeRemapper;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (IrValueParameter)element$iv;
                            boolean bl3 = false;
                            scriptsReceivers.add(it.getType());
                            scriptsReceivers.add(((SimpleTypeRemapper)$this$forEach$iv2).remapType(it.getType()));
                        }
                        Iterable $this$any$iv = closure.getCapturedValues();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                IrValueSymbol it2 = (IrValueSymbol)element$iv;
                                boolean bl4 = false;
                                if (!scriptsReceivers.contains(it2.getOwner().getType())) continue;
                                bl = true;
                                break block23;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        if (IrUtilsKt.isInterface(declaration)) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_INTERFACE(), null, 8, null);
                        } else if (IrUtilsKt.isEnumClass(declaration)) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_ENUM(), null, 8, null);
                        } else if (IrUtilsKt.isEnumEntry(declaration)) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_ENUM_ENTRY(), null, 8, null);
                        } else if (declaration.isCompanion()) {
                            collectCapturingClasses.collector.1.visitClass$reportError(this.this$0, declaration, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_OBJECT(), SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
                        } else if (declaration.getKind().isSingleton()) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_OBJECT(), null, 8, null);
                        } else if (IrUtilsKt.isClass(declaration)) {
                            if (!Intrinsics.areEqual(declaration.getParent(), this.$irScript)) {
                                IrDeclarationParent irDeclarationParent = declaration.getParent();
                                IrClass irClass2 = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                                boolean bl5 = irClass2 != null ? !irClass2.isInner() : false;
                                if (bl5) {
                                    KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = this.this$0.getContext().getKtDiagnosticReporter().at(declaration);
                                    KtDiagnosticFactory2<String, String> ktDiagnosticFactory2 = JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_NESTED_CLASS();
                                    String string2 = declaration.getName().asString();
                                    Intrinsics.checkNotNullExpressionValue(string2, "declaration.name.asString()");
                                    IrDeclarationParent irDeclarationParent2 = declaration.getParent();
                                    Object object2 = irDeclarationParent2 instanceof IrDeclarationWithName ? (IrDeclarationWithName)((Object)irDeclarationParent2) : null;
                                    if (object2 == null || (object2 = object2.getName()) == null) {
                                        object2 = SpecialNames.NO_NAME_PROVIDED;
                                    }
                                    object = ((Name)object2).asString();
                                    Intrinsics.checkNotNullExpressionValue(object, "(declaration.parent as? \u2026NAME_PROVIDED).asString()");
                                    diagnosticContextImpl.report(ktDiagnosticFactory2, string2, object);
                                }
                            } else {
                                this.$capturingClasses.add((IrClassImpl)declaration);
                            }
                        }
                    }
                }
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
            }

            public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
            }

            public void visitBody(@NotNull IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            public void visitCall(@NotNull IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
            }

            public void visitConst(@NotNull IrConst<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
            }

            public void visitConstructor(@NotNull IrConstructor declaration) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
            }

            public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
            }

            public void visitField(@NotNull IrField declaration) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
            }

            public void visitField(@NotNull IrField declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            public void visitFile(@NotNull IrFile declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
            }

            public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
            }

            public void visitFunction(@NotNull IrFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
            }

            public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            public void visitLoop(@NotNull IrLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            }

            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
            }

            public void visitProperty(@NotNull IrProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
            }

            public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
            }

            public void visitScript(@NotNull IrScript declaration) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
            }

            public void visitScript(@NotNull IrScript declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
            }

            public void visitSetValue(@NotNull IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
            }

            public void visitVariable(@NotNull IrVariable declaration) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
            }

            public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
            }

            private static final void visitClass$reportError(ScriptsToClassesLowering this$0, IrClass $declaration, KtDiagnosticFactory1<String> factory2, Name name) {
                KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = this$0.getContext().getKtDiagnosticReporter().at($declaration);
                Name name2 = name;
                if (name2 == null) {
                    name2 = $declaration.getName();
                }
                String string2 = name2.asString();
                Intrinsics.checkNotNullExpressionValue(string2, "name ?: declaration.name).asString()");
                diagnosticContextImpl.report(factory2, string2);
            }

            static /* synthetic */ void visitClass$reportError$default(ScriptsToClassesLowering scriptsToClassesLowering, IrClass irClass2, KtDiagnosticFactory1 ktDiagnosticFactory1, Name name, int n, Object object) {
                if ((n & 8) != 0) {
                    name = null;
                }
                collectCapturingClasses.collector.1.visitClass$reportError(scriptsToClassesLowering, irClass2, ktDiagnosticFactory1, name);
            }
        };
        for (IrStatement statement2 : irScript.getStatements()) {
            if (!(statement2 instanceof IrClassImpl)) continue;
            collector2.visitClass((IrClass)statement2);
        }
        return capturingClasses;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void finalizeScriptClass(IrClass irScriptClass, IrScript irScript, ScriptsToClassesSymbolRemapper symbolRemapper) {
        block20: {
            typeRemapper = new SimpleTypeRemapper(symbolRemapper);
            capturingClasses = this.collectCapturingClasses(irScript, typeRemapper);
            var7_6 = irScript.getEarlierScriptsParameter();
            if (var7_6 == null) ** GOTO lbl-1000
            earlierScriptsParameter = var7_6;
            $i$a$-let-ScriptsToClassesLowering$finalizeScriptClass$earlierScriptField$1 = false;
            v0 = irScriptClass.getFactory();
            v1 = IrDeclarationOrigin.SCRIPT_EARLIER_SCRIPTS.INSTANCE;
            v2 = new IrFieldSymbolImpl(null, 1, null);
            v3 = Name.identifier("$$earlierScripts");
            Intrinsics.checkNotNullExpressionValue(v3, "identifier(\"\\$\\$earlierScripts\")");
            v4 = earlierScriptsParameter.getType();
            v5 = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue(v5, "PRIVATE");
            var8_13 = v0.createField(-1, -1, v1, v2, v3, v4, v5, true, false, false);
            if (var8_13 != null) {
                it = var9_14 = var8_13;
                $i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$earlierScriptField$2 = false;
                it.setParent(irScriptClass);
                irScriptClass.getDeclarations().add((IrDeclaration)it);
                v6 = var9_14;
            } else lbl-1000:
            // 2 sources

            {
                v6 = null;
            }
            earlierScriptField = v6;
            var8_13 = new ArrayList<Pair<IrField, IrValueParameter>>();
            $this$finalizeScriptClass_u24lambda_u245 = var8_13;
            $i$a$-apply-ScriptsToClassesLowering$finalizeScriptClass$implicitReceiversFieldsWithParameters$1 = false;
            $this$forEach$iv = irScript.getImplicitReceiversParameters();
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                param = (IrValueParameter)element$iv;
                $i$a$-forEach-ScriptsToClassesLowering$finalizeScriptClass$implicitReceiversFieldsWithParameters$1$1 = false;
                v7 = irScriptClass.getFactory();
                v8 = IrDeclarationOrigin.SCRIPT_IMPLICIT_RECEIVER.INSTANCE;
                v9 = new IrFieldSymbolImpl(null, 1, null);
                v10 = new StringBuilder().append("$$implicitReceiver_");
                v11 = IrTypesKt.getClassFqName(param.getType());
                v12 = v11 != null && (v11 = v11.shortName()) != null ? v11.asString() : null;
                Intrinsics.checkNotNull(v12);
                v13 = Name.identifier(v10.append(v12).toString());
                Intrinsics.checkNotNullExpressionValue(v13, "identifier(\"\\$\\$implicit\u2026rtName()?.asString()!!}\")");
                v14 = typeRemapper.remapType(param.getType());
                v15 = DescriptorVisibilities.PRIVATE;
                Intrinsics.checkNotNullExpressionValue(v15, "PRIVATE");
                field = v7.createField(-1, -1, v8, v9, v13, v14, v15, true, false, false);
                field.setParent(irScriptClass);
                irScriptClass.getDeclarations().add(field);
                $this$finalizeScriptClass_u24lambda_u245.add(TuplesKt.to(field, param));
            }
            implicitReceiversFieldsWithParameters = var8_13;
            scriptTransformer = new ScriptToClassTransformer(irScript, irScriptClass, typeRemapper, this.context, (Set<? extends IrClassImpl>)capturingClasses, this.innerClassesSupport, (IrField)earlierScriptField, (Collection<? extends Pair<? extends IrField, ? extends IrValueParameter>>)implicitReceiversFieldsWithParameters);
            lambdaPatcher = new ScriptFixLambdasTransformer(irScriptClass);
            irScriptClass.setThisReceiver(scriptTransformer.getScriptClassReceiver());
            v16 = irScriptClass.getThisReceiver();
            defaultContext = new ScriptToClassTransformerContext(v16 != null ? v16.getSymbol() : null, null, null, false);
            v17 /* !! */  = irScript.getConstructor();
            if (v17 /* !! */  != null && (v17 /* !! */  = ScriptsToClassesLowering.finalizeScriptClass$patchForClass((IrElement)v17 /* !! */ , scriptTransformer, defaultContext, lambdaPatcher)) != null) {
                $this$safeAs$iv /* !! */  = v17 /* !! */ ;
                $i$f$safeAs = false;
                v18 /* !! */  = $this$safeAs$iv /* !! */ ;
                if (!(v18 /* !! */  instanceof IrConstructor)) {
                    v18 /* !! */  = null;
                }
                v19 /* !! */  = v18 /* !! */ ;
            } else {
                v19 /* !! */  = null;
            }
            Intrinsics.checkNotNull(v19 /* !! */ );
            constructor = $this$forEach$iv = v19 /* !! */ ;
            $i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$1 = false;
            explicitParamsStartIndex = irScript.getEarlierScriptsParameter() == null ? 0 : 1;
            explicitParameters = constructor.getValueParameters().subList(explicitParamsStartIndex, irScript.getExplicitCallParameters().size() + explicitParamsStartIndex);
            $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)constructor.getSymbol(), 0, 0, 6, null);
            startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            $i$f$irBlockBody = false;
            var20_34 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            $i$f$blockBody = false;
            var22_36 = this_$iv$iv;
            var23_37 = constructor;
            $i$a$-irBlockBody$default-ScriptsToClassesLowering$finalizeScriptClass$1$1 = false;
            v20 = IrTypesKt.getClassOrNull(irScript.getBaseClass());
            v21 = v20 != null && (v20 = (IrClass)v20.getOwner()) != null && (v20 = IrUtilsKt.getConstructors((IrClass)v20)) != null ? SequencesKt.firstOrNull(v20) : (baseClassCtor = null);
            if (baseClassCtor == null) {
                $this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249.unaryPlus(ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249, SequencesKt.single(IrUtilsKt.getConstructors((IrClass)$this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249.getContext().getIrBuiltIns().getAnyClass().getOwner()))));
            } else {
                var27_44 = var26_43 = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249, baseClassCtor);
                var28_47 = $this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249;
                $i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$1$1$1 = false;
                $this$forEachIndexed$iv = explicitParameters;
                $i$f$forEachIndexed = false;
                index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    if ((var35_58 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    var36_60 = (IrValueParameter)item$iv;
                    idx = var35_58;
                    $i$a$-forEachIndexed-ScriptsToClassesLowering$finalizeScriptClass$1$1$1$1 = false;
                    it.putValueArgument(idx, new IrGetValueImpl(valueParameter.getStartOffset(), valueParameter.getEndOffset(), valueParameter.getType(), valueParameter.getSymbol(), null, 16, null));
                }
                var28_47.unaryPlus(var26_43);
            }
            if (earlierScriptField != null) {
                v22 = (IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249;
                v23 = (IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249;
                v24 = irScriptClass.getThisReceiver();
                Intrinsics.checkNotNull(v24);
                v25 = ExpressionHelpersKt.irGet(v23, v24);
                v26 = (IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249;
                v27 = irScript.getEarlierScriptsParameter();
                Intrinsics.checkNotNull(v27);
                $this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249.unaryPlus(ExpressionHelpersKt.irSetField$default(v22, v25, (IrField)earlierScriptField, ExpressionHelpersKt.irGet(v26, v27), null, 8, null));
            }
            $this$forEach$iv = implicitReceiversFieldsWithParameters;
            $i$f$forEach = false;
            $i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$1$1$1 = $this$forEach$iv.iterator();
            while ($i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$1$1$1.hasNext()) {
                element$iv = $i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$1$1$1.next();
                $i$f$forEachIndexed = (Pair)element$iv;
                $i$a$-forEach-ScriptsToClassesLowering$finalizeScriptClass$1$1$2 = false;
                field = (IrField)$i$f$forEachIndexed.component1();
                correspondingParameter = (IrValueParameter)$i$f$forEachIndexed.component2();
                v28 = (IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249;
                v29 = (IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249;
                v30 = irScriptClass.getThisReceiver();
                Intrinsics.checkNotNull(v30);
                v31 = ExpressionHelpersKt.irGet(v29, v30);
                v32 = (IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249;
                $this$safeAs$iv = ScriptsToClassesLowering.finalizeScriptClass$patchForClass((IrElement)correspondingParameter, scriptTransformer, defaultContext, lambdaPatcher);
                $i$f$safeAs = false;
                v33 = $this$safeAs$iv;
                if (!(v33 instanceof IrValueParameter)) {
                    v33 = null;
                }
                v34 = (IrValueParameter)v33;
                Intrinsics.checkNotNull(v34);
                $this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249.unaryPlus(ExpressionHelpersKt.irSetField$default(v28, v31, field, ExpressionHelpersKt.irGet(v32, v34), null, 8, null));
            }
            $this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249.unaryPlus(new IrInstanceInitializerCallImpl(irScript.getStartOffset(), irScript.getEndOffset(), irScriptClass.getSymbol(), $this$finalizeScriptClass_u24lambda_u2410_u24lambda_u249.getContext().getIrBuiltIns().getUnitType()));
            var23_37.setBody(this_$iv$iv.doBuild());
            irScriptClass.getDeclarations().add((IrDeclaration)constructor);
            constructor.setParent(irScriptClass);
            hasMain = false;
            $this$forEach$iv = irScript.getStatements();
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                scriptStatement = (IrStatement)element$iv;
                $i$a$-forEach-ScriptsToClassesLowering$finalizeScriptClass$2 = false;
                var18_31 = scriptStatement;
                if (var18_31 instanceof IrVariable) {
                    v35 = ScriptsToClassesLowering.finalizeScriptClass$patchForClass((IrElement)scriptStatement, scriptTransformer, defaultContext, lambdaPatcher);
                    Intrinsics.checkNotNull(v35, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
                    copy /* !! */  = (IrVariable)v35;
                    ScriptsToClassesLowering.addSimplePropertyFrom$default(this, irScriptClass, copy /* !! */ , null, 2, null);
                    continue;
                }
                if (var18_31 instanceof IrDeclaration) {
                    v36 = ScriptsToClassesLowering.finalizeScriptClass$patchForClass((IrElement)scriptStatement, scriptTransformer, defaultContext, lambdaPatcher);
                    Intrinsics.checkNotNull(v36, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                    copy /* !! */  = (IrDeclaration)v36;
                    irScriptClass.getDeclarations().add(copy /* !! */ );
                    if (!(copy /* !! */  instanceof IrSimpleFunction) || !Intrinsics.areEqual(((IrSimpleFunction)copy /* !! */ ).getName().asString(), "main")) continue;
                    hasMain = true;
                    continue;
                }
                v37 = ScriptsToClassesLowering.finalizeScriptClass$patchForClass((IrElement)scriptStatement, scriptTransformer, defaultContext, lambdaPatcher);
                Intrinsics.checkNotNull(v37, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.IrStatement");
                transformedStatement = (IrStatement)v37;
                $this$addAnonymousInitializer_u24default$iv = irScriptClass;
                $i$f$addAnonymousInitializer = false;
                $this$addAnonymousInitializer_u24lambda_u240$iv = new IrFunctionBuilder();
                $i$a$-run-ScriptLoweringKt$addAnonymousInitializer$2$iv = false;
                $i$a$-irBlockBody$default-ScriptsToClassesLowering$finalizeScriptClass$1$1 = $this$addAnonymousInitializer_u24lambda_u240$iv;
                $i$a$-addAnonymousInitializer-ScriptLoweringKt$addAnonymousInitializer$1 = false;
                $this$null = $i$a$-irBlockBody$default-ScriptsToClassesLowering$finalizeScriptClass$1$1;
                $this$addAnonymousInitializer_u24lambda_u240$iv.setReturnType(IrUtilsKt.getDefaultType($this$addAnonymousInitializer_u24default$iv));
                anonymousInitializer$iv = $this$forEach$iv = new IrAnonymousInitializerImpl($this$addAnonymousInitializer_u24lambda_u240$iv.getStartOffset(), $this$addAnonymousInitializer_u24lambda_u240$iv.getEndOffset(), $this$addAnonymousInitializer_u24lambda_u240$iv.getOrigin(), new IrAnonymousInitializerSymbolImpl(null, 1, null), false, null, 48, null);
                $i$a$-also-ScriptLoweringKt$addAnonymousInitializer$3$iv = false;
                $this$addAnonymousInitializer_u24default$iv.getDeclarations().add((IrDeclaration)anonymousInitializer$iv);
                anonymousInitializer$iv.setParent($this$addAnonymousInitializer_u24default$iv);
                irInitializer = var20_34 = (IrAnonymousInitializer)$this$forEach$iv;
                $i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$2$1 = false;
                $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)irInitializer.getSymbol(), 0, 0, 6, null);
                startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                $i$f$irBlockBody = false;
                $this$forEach$iv = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                $i$f$blockBody = false;
                $i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$1$1$1 = this_$iv$iv;
                var30_51 = irInitializer;
                $i$a$-irBlockBody$default-ScriptsToClassesLowering$finalizeScriptClass$2$1$1 = false;
                if (transformedStatement instanceof IrComposite) {
                    for (IrStatement statement : ((IrComposite)transformedStatement).getStatements()) {
                        $this$finalizeScriptClass_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.unaryPlus(statement);
                    }
                } else {
                    $this$finalizeScriptClass_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.unaryPlus(transformedStatement);
                }
                var30_51.setBody(this_$iv$iv.doBuild());
            }
            if (!hasMain) {
                this.addScriptMainFun(irScriptClass);
            }
            v38 = irScriptClass.getAnnotations();
            v39 = irScriptClass.getParent();
            Intrinsics.checkNotNull(v39, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
            irScriptClass.setAnnotations(CollectionsKt.plus(v38, (Iterable)((IrFile)v39).getAnnotations()));
            v40 = irScript.getResultProperty();
            if (v40 == null || (v40 = (IrProperty)v40.getOwner()) == null) break block20;
            irResultProperty = v40;
            $i$a$-let-ScriptsToClassesLowering$finalizeScriptClass$3 = false;
            this.context.getState().getScriptSpecific().setResultFieldName(irResultProperty.getName().getIdentifier());
            this.context.getState().getScriptSpecific().setResultType((v41 /* !! */  = irResultProperty.getBackingField()) != null && (v41 /* !! */  = v41 /* !! */ .getType()) != null ? IrBasedDescriptorsKt.toIrBasedKotlinType((IrType)v41 /* !! */ ) : null);
        }
    }

    private final IrExternalPackageFragment getScriptingJvmPackage() {
        Lazy lazy = this.scriptingJvmPackage$delegate;
        return (IrExternalPackageFragment)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void addScriptMainFun(IrClass $this$addScriptMainFun) {
        void $this$addScriptMainFun_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422;
        void $this$addScriptMainFun_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423;
        void $this$addScriptMainFun_u24lambda_u2425_u24lambda_u2424;
        Object object;
        IrValueParameter irValueParameter;
        IrClassSymbol javaLangClass2 = this.context.getIr().getSymbols().getJavaLangClass();
        IrSimpleFunction kClassJavaPropertyGetter = this.context.getIr().getSymbols().getKClassJavaPropertyGetter();
        Object $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$addScriptMainFun_u24lambda_u2415 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        Name name = Name.identifier("RunnerKt");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(\"RunnerKt\")");
        $this$addScriptMainFun_u24lambda_u2415.setName(name);
        $this$addScriptMainFun_u24lambda_u2415.setKind(ClassKind.CLASS);
        $this$addScriptMainFun_u24lambda_u2415.setModality(Modality.FINAL);
        Object $this$addScriptMainFun_u24lambda_u2418 = $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        boolean bl3 = false;
        $this$addScriptMainFun_u24lambda_u2418.setParent(this.getScriptingJvmPackage());
        IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$addScriptMainFun_u24lambda_u2418);
        IrSimpleFunction $this$addScriptMainFun_u24lambda_u2418_u24lambda_u2417 = bl = DeclarationBuildersKt.addFunction$default((IrClass)$this$addScriptMainFun_u24lambda_u2418, "runCompiledScript", this.context.getIrBuiltIns().getUnitType(), null, null, true, false, false, null, 0, 0, 1004, null);
        boolean $i$a$-apply-ScriptsToClassesLowering$addScriptMainFun$scriptRunnerPackageClass$2$22 = false;
        DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$addScriptMainFun_u24lambda_u2418_u24lambda_u2417, "scriptClass", (IrType)IrTypesKt.getStarProjectedType(javaLangClass2), null, 4, null);
        IrFunction $this$addValueParameter$iv = $this$addScriptMainFun_u24lambda_u2418_u24lambda_u2417;
        boolean $i$f$addValueParameter = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2430$iv = new IrValueParameterBuilder();
        boolean bl4 = false;
        IrValueParameterBuilder $this$addScriptMainFun_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416 = $this$addValueParameter_u24lambda_u2430$iv;
        boolean bl5 = false;
        Name name2 = Name.identifier("args");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"args\")");
        $this$addScriptMainFun_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416.setName(name2);
        Object object2 = new IrType[]{this.context.getIrBuiltIns().getStringType()};
        $this$addScriptMainFun_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416.setType(IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass(), object2));
        $this$addScriptMainFun_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416.setOrigin(IrDeclarationOrigin.DEFINED.INSTANCE);
        $this$addScriptMainFun_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416.setVarargElementType(this.context.getIrBuiltIns().getAnyNType());
        if ($this$addValueParameter_u24lambda_u2430$iv.getIndex() == -1) {
            $this$addValueParameter_u24lambda_u2430$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
        }
        IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2430$iv, $this$addValueParameter$iv);
        boolean bl6 = false;
        $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), valueParameter$iv));
        IrClassSymbol scriptRunnerPackageClass = ((IrClass)$this$buildClass$iv).getSymbol();
        Sequence<IrSimpleFunctionSymbol> $this$single$iv = IrUtilsKt.getFunctions(scriptRunnerPackageClass);
        boolean $i$f$single = false;
        IrSimpleFunctionSymbol single$iv = null;
        boolean found$iv = false;
        Iterator<IrSimpleFunctionSymbol> $i$a$-apply-ScriptsToClassesLowering$addScriptMainFun$scriptRunnerPackageClass$2$22 = $this$single$iv.iterator();
        while ($i$a$-apply-ScriptsToClassesLowering$addScriptMainFun$scriptRunnerPackageClass$2$22.hasNext()) {
            IrSimpleFunctionSymbol element$iv;
            IrSimpleFunctionSymbol it = element$iv = $i$a$-apply-ScriptsToClassesLowering$addScriptMainFun$scriptRunnerPackageClass$2$22.next();
            boolean bl7 = false;
            if (!Intrinsics.areEqual(((IrSimpleFunction)it.getOwner()).getName().asString(), "runCompiledScript")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunctionSymbol scriptRunHelper = single$iv;
        IrClassReferenceImpl scriptClassRef = new IrClassReferenceImpl($this$addScriptMainFun.getStartOffset(), $this$addScriptMainFun.getEndOffset(), IrTypesKt.getStarProjectedType(this.context.getIrBuiltIns().getKClassClass()), this.context.getIrBuiltIns().getKClassClass(), IrUtilsKt.getDefaultType($this$addScriptMainFun));
        IrClass $this$addFunction$iv = $this$addScriptMainFun;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2418$iv$iv$iv = new IrFunctionBuilder();
        boolean bl8 = false;
        IrFunctionBuilder $this$addScriptMainFun_u24lambda_u2420 = $this$buildFun_u24lambda_u2418$iv$iv$iv;
        boolean $i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22 = false;
        Name name3 = Name.identifier("main");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(\"main\")");
        $this$addScriptMainFun_u24lambda_u2420.setName(name3);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PUBLIC");
        $this$addScriptMainFun_u24lambda_u2420.setVisibility(descriptorVisibility);
        $this$addScriptMainFun_u24lambda_u2420.setReturnType(this.context.getIrBuiltIns().getUnitType());
        $this$addScriptMainFun_u24lambda_u2420.setModality(Modality.FINAL);
        Object function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2418$iv$iv$iv);
        boolean bl9 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
        function$iv$iv.setParent($this$addFunction$iv);
        Object mainFun = object = $this$buildFun$iv$iv$iv;
        boolean bl10 = false;
        IrFunction $this$addValueParameter$iv2 = (IrFunction)mainFun;
        boolean $i$f$addValueParameter22 = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2430$iv2 = new IrValueParameterBuilder();
        $i$a$-run-DeclarationBuildersKt$addValueParameter$1$iv = false;
        Object $this$addScriptMainFun_u24lambda_u2425_u24lambda_u2421 = $this$addValueParameter_u24lambda_u2430$iv2;
        boolean bl11 = false;
        Name name4 = Name.identifier("args");
        Intrinsics.checkNotNullExpressionValue(name4, "identifier(\"args\")");
        ((IrDeclarationBuilder)$this$addScriptMainFun_u24lambda_u2425_u24lambda_u2421).setName(name4);
        IrType[] $i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22 = new IrType[]{this.context.getIrBuiltIns().getStringType()};
        ((IrValueParameterBuilder)$this$addScriptMainFun_u24lambda_u2425_u24lambda_u2421).setType(IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass(), $i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22));
        if ($this$addValueParameter_u24lambda_u2430$iv2.getIndex() == -1) {
            $this$addValueParameter_u24lambda_u2430$iv2.setIndex($this$addValueParameter$iv2.getValueParameters().size());
        }
        object2 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv2.getFactory(), $this$addValueParameter_u24lambda_u2430$iv2, $this$addValueParameter$iv2);
        IrType[] valueParameter$iv2 = object2;
        $i$a$-also-DeclarationBuildersKt$addValueParameter$1$1$iv = false;
        $this$addValueParameter$iv2.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv2.getValueParameters(), valueParameter$iv2));
        IrType[] args = object2;
        DeclarationIrBuilder $i$f$addValueParameter22 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)((IrSimpleFunction)mainFun).getSymbol(), 0, 0, 6, null);
        Object object3 = mainFun;
        boolean bl12 = false;
        IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2425_u24lambda_u2424, scriptRunHelper);
        $this$addScriptMainFun_u24lambda_u2425_u24lambda_u2421 = irCall;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2425_u24lambda_u2424;
        boolean bl13 = false;
        object2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2425_u24lambda_u2424, IrTypesKt.getStarProjectedType(javaLangClass2), null, kClassJavaPropertyGetter.getSymbol());
        valueParameter$iv2 = object2;
        int n = 0;
        void var22_49 = $this$addScriptMainFun_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423;
        boolean bl14 = false;
        $this$addScriptMainFun_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.setExtensionReceiver(scriptClassRef);
        Unit unit2 = Unit.INSTANCE;
        var22_49.putValueArgument(n, (IrExpression)object2);
        $this$addScriptMainFun_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423.putValueArgument(1, new IrGetValueImpl(-1, -1, args.getType(), args.getSymbol(), null, 16, null));
        ((IrFunction)object3).setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope, irCall));
    }

    /*
     * WARNING - void declaration
     */
    private final void addSimplePropertyFrom(IrClass $this$addSimplePropertyFrom, IrValueDeclaration from2, IrExpressionBody initializer2) {
        void field2;
        IrField irField;
        void $this$addSimplePropertyFrom_u24lambda_u2429_u24lambda_u2427;
        Object object;
        IrClass $this$addProperty$iv = $this$addSimplePropertyFrom;
        boolean $i$f$addProperty = false;
        Object $this$buildProperty$iv$iv = $this$addProperty$iv.getFactory();
        boolean $i$f$buildProperty = false;
        IrPropertyBuilder $this$buildProperty_u24lambda_u248$iv$iv = new IrPropertyBuilder();
        boolean bl = false;
        IrPropertyBuilder $this$addSimplePropertyFrom_u24lambda_u2426 = $this$buildProperty_u24lambda_u248$iv$iv;
        boolean $i$a$-addProperty-ScriptsToClassesLowering$addSimplePropertyFrom$22 = false;
        $this$addSimplePropertyFrom_u24lambda_u2426.updateFrom(from2);
        $this$addSimplePropertyFrom_u24lambda_u2426.setName(from2.getName());
        Object property$iv = $this$buildProperty$iv$iv = DeclarationBuildersKt.buildProperty((IrFactory)$this$buildProperty$iv$iv, $this$buildProperty_u24lambda_u248$iv$iv);
        boolean bl2 = false;
        $this$addProperty$iv.getDeclarations().add((IrDeclaration)property$iv);
        property$iv.setParent($this$addProperty$iv);
        Object property2 = object = $this$buildProperty$iv$iv;
        boolean bl3 = false;
        IrFactory $this$buildField$iv = this.context.getIrFactory();
        boolean $i$f$buildField22 = false;
        IrFieldBuilder $this$buildField_u24lambda_u244$iv = new IrFieldBuilder();
        boolean bl4 = false;
        IrFieldBuilder $i$a$-addProperty-ScriptsToClassesLowering$addSimplePropertyFrom$22 = $this$buildField_u24lambda_u244$iv;
        Object object2 = property2;
        boolean bl5 = false;
        $this$addSimplePropertyFrom_u24lambda_u2429_u24lambda_u2427.setName(from2.getName());
        $this$addSimplePropertyFrom_u24lambda_u2429_u24lambda_u2427.setType(from2.getType());
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PROTECTED");
        $this$addSimplePropertyFrom_u24lambda_u2429_u24lambda_u2427.setVisibility(descriptorVisibility);
        IrField $i$f$buildField22 = irField = DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u244$iv);
        boolean bl6 = false;
        field2.setParent($this$addSimplePropertyFrom);
        if (initializer2 != null) {
            field2.setInitializer(initializer2);
        }
        DeclarationBuildersKt.addDefaultGetter((IrProperty)property2, $this$addSimplePropertyFrom, this.context.getIrBuiltIns());
        ((IrProperty)object2).setBackingField(irField);
    }

    static /* synthetic */ void addSimplePropertyFrom$default(ScriptsToClassesLowering scriptsToClassesLowering, IrClass irClass2, IrValueDeclaration irValueDeclaration, IrExpressionBody irExpressionBody, int n, Object object) {
        if ((n & 2) != 0) {
            irExpressionBody = null;
        }
        scriptsToClassesLowering.addSimplePropertyFrom(irClass2, irValueDeclaration, irExpressionBody);
    }

    private static final <E extends IrElement> IrElement finalizeScriptClass$patchForClass(E $this$finalizeScriptClass_u24patchForClass, ScriptToClassTransformer scriptTransformer, ScriptToClassTransformerContext defaultContext, ScriptFixLambdasTransformer lambdaPatcher) {
        return $this$finalizeScriptClass_u24patchForClass.transform(scriptTransformer, (ScriptToClassTransformerContext)defaultContext).transform(lambdaPatcher, new ScriptFixLambdasTransformerContext(false, null, 3, null));
    }
}

