/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirFunInterfaceDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirFunInterfaceDeclarationChecker INSTANCE = new FirFunInterfaceDeclarationChecker();

    private FirFunInterfaceDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                Intrinsics.checkNotNullParameter(context, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                FirClass $this$isInterface$iv = declaration;
                boolean $i$f$isInterface = false;
                ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                boolean $i$f$isInterface2 = false;
                boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
                if (!bl) break block12;
                FirMemberDeclaration $this$isFun$iv = declaration;
                boolean $i$f$isFun = false;
                if ($this$isFun$iv.getStatus().isFun()) break block13;
            }
            return;
        }
        FirTypeScope scope2 = FirHelpersKt.unsubstitutedScope(declaration, context);
        FirRegularClassSymbol classSymbol = declaration.getSymbol();
        FirCallableSymbol abstractFunctionSymbol = null;
        for (Name name : scope2.getCallableNames()) {
            List<FirNamedFunctionSymbol> functions2 = FirScopeKt.getFunctions(scope2, name);
            List<FirVariableSymbol<?>> properties2 = FirScopeKt.getProperties(scope2, name);
            for (FirNamedFunctionSymbol firNamedFunctionSymbol : functions2) {
                FirCallableSymbol $this$isAbstract$iv = firNamedFunctionSymbol;
                boolean $i$f$isAbstract = false;
                if (!($this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT)) continue;
                if (abstractFunctionSymbol == null) {
                    abstractFunctionSymbol = firNamedFunctionSymbol;
                    continue;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getFUN_INTERFACE_WRONG_COUNT_OF_ABSTRACT_MEMBERS(), (DiagnosticContext)context, null, 8, null);
            }
            for (FirVariableSymbol firVariableSymbol : properties2) {
                FirPropertySymbol firProperty;
                if ((firVariableSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firVariableSymbol : null) == null) continue;
                firProperty = firProperty;
                FirCallableSymbol $this$isAbstract$iv = firProperty;
                boolean $i$f$isAbstract = false;
                if (!($this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT)) continue;
                KtSourceElement source2 = !Intrinsics.areEqual(FirHelpersKt.getContainingClassSymbol(firProperty, context.getSession()), classSymbol) ? declaration.getSource() : firProperty.getSource();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getFUN_INTERFACE_CANNOT_HAVE_ABSTRACT_PROPERTIES(), (DiagnosticContext)context, null, 8, null);
            }
        }
        if (abstractFunctionSymbol == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getFUN_INTERFACE_WRONG_COUNT_OF_ABSTRACT_MEMBERS(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        boolean inFunInterface = FirHelpersKt.getContainingClassSymbol(abstractFunctionSymbol, context.getSession()) == classSymbol;
        if (!((Collection)abstractFunctionSymbol.getTypeParameterSymbols()).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(inFunInterface ? abstractFunctionSymbol.getSource() : declaration.getSource()), FirErrors.INSTANCE.getFUN_INTERFACE_ABSTRACT_METHOD_WITH_TYPE_PARAMETERS(), (DiagnosticContext)context, null, 8, null);
        } else {
            FirCallableSymbol $this$isSuspend$iv = abstractFunctionSymbol;
            boolean $i$f$isSuspend = false;
            if ($this$isSuspend$iv.getRawStatus().isSuspend() && !FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.SuspendFunctionsInFunInterfaces)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(inFunInterface ? abstractFunctionSymbol.getSource() : declaration.getSource()), FirErrors.INSTANCE.getFUN_INTERFACE_WITH_SUSPEND_FUNCTION(), (DiagnosticContext)context, null, 8, null);
            }
        }
        Iterable $this$forEach$iv = ((FirFunctionSymbol)abstractFunctionSymbol).getValueParameterSymbols();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)element$iv;
            boolean bl = false;
            if (!firValueParameterSymbol.getHasDefaultValue()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(inFunInterface ? firValueParameterSymbol.getSource() : declaration.getSource()), FirErrors.INSTANCE.getFUN_INTERFACE_ABSTRACT_METHOD_WITH_DEFAULT_VALUE(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

