/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J9\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/SourceMapsInfo;", "", "sourceMapPrefix", "", "sourceRoots", "", "outputDir", "Ljava/io/File;", "sourceMapContentEmbedding", "Lorg/jetbrains/kotlin/js/config/SourceMapSourceEmbedding;", "(Ljava/lang/String;Ljava/util/List;Ljava/io/File;Lorg/jetbrains/kotlin/js/config/SourceMapSourceEmbedding;)V", "getOutputDir", "()Ljava/io/File;", "getSourceMapContentEmbedding", "()Lorg/jetbrains/kotlin/js/config/SourceMapSourceEmbedding;", "getSourceMapPrefix", "()Ljava/lang/String;", "getSourceRoots", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "backend.js"})
public final class SourceMapsInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sourceMapPrefix;
    @NotNull
    private final List<String> sourceRoots;
    @Nullable
    private final File outputDir;
    @NotNull
    private final SourceMapSourceEmbedding sourceMapContentEmbedding;

    public SourceMapsInfo(@NotNull String sourceMapPrefix, @NotNull List<String> sourceRoots, @Nullable File outputDir2, @NotNull SourceMapSourceEmbedding sourceMapContentEmbedding) {
        Intrinsics.checkNotNullParameter(sourceMapPrefix, "sourceMapPrefix");
        Intrinsics.checkNotNullParameter(sourceRoots, "sourceRoots");
        Intrinsics.checkNotNullParameter((Object)sourceMapContentEmbedding, "sourceMapContentEmbedding");
        this.sourceMapPrefix = sourceMapPrefix;
        this.sourceRoots = sourceRoots;
        this.outputDir = outputDir2;
        this.sourceMapContentEmbedding = sourceMapContentEmbedding;
    }

    @NotNull
    public final String getSourceMapPrefix() {
        return this.sourceMapPrefix;
    }

    @NotNull
    public final List<String> getSourceRoots() {
        return this.sourceRoots;
    }

    @Nullable
    public final File getOutputDir() {
        return this.outputDir;
    }

    @NotNull
    public final SourceMapSourceEmbedding getSourceMapContentEmbedding() {
        return this.sourceMapContentEmbedding;
    }

    @NotNull
    public final String component1() {
        return this.sourceMapPrefix;
    }

    @NotNull
    public final List<String> component2() {
        return this.sourceRoots;
    }

    @Nullable
    public final File component3() {
        return this.outputDir;
    }

    @NotNull
    public final SourceMapSourceEmbedding component4() {
        return this.sourceMapContentEmbedding;
    }

    @NotNull
    public final SourceMapsInfo copy(@NotNull String sourceMapPrefix, @NotNull List<String> sourceRoots, @Nullable File outputDir2, @NotNull SourceMapSourceEmbedding sourceMapContentEmbedding) {
        Intrinsics.checkNotNullParameter(sourceMapPrefix, "sourceMapPrefix");
        Intrinsics.checkNotNullParameter(sourceRoots, "sourceRoots");
        Intrinsics.checkNotNullParameter((Object)sourceMapContentEmbedding, "sourceMapContentEmbedding");
        return new SourceMapsInfo(sourceMapPrefix, sourceRoots, outputDir2, sourceMapContentEmbedding);
    }

    public static /* synthetic */ SourceMapsInfo copy$default(SourceMapsInfo sourceMapsInfo, String string2, List list2, File file2, SourceMapSourceEmbedding sourceMapSourceEmbedding, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = sourceMapsInfo.sourceMapPrefix;
        }
        if ((n & 2) != 0) {
            list2 = sourceMapsInfo.sourceRoots;
        }
        if ((n & 4) != 0) {
            file2 = sourceMapsInfo.outputDir;
        }
        if ((n & 8) != 0) {
            sourceMapSourceEmbedding = sourceMapsInfo.sourceMapContentEmbedding;
        }
        return sourceMapsInfo.copy(string2, list2, file2, sourceMapSourceEmbedding);
    }

    @NotNull
    public String toString() {
        return "SourceMapsInfo(sourceMapPrefix=" + this.sourceMapPrefix + ", sourceRoots=" + this.sourceRoots + ", outputDir=" + this.outputDir + ", sourceMapContentEmbedding=" + (Object)((Object)this.sourceMapContentEmbedding) + ')';
    }

    public int hashCode() {
        int result2 = this.sourceMapPrefix.hashCode();
        result2 = result2 * 31 + ((Object)this.sourceRoots).hashCode();
        result2 = result2 * 31 + (this.outputDir == null ? 0 : this.outputDir.hashCode());
        result2 = result2 * 31 + this.sourceMapContentEmbedding.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SourceMapsInfo)) {
            return false;
        }
        SourceMapsInfo sourceMapsInfo = (SourceMapsInfo)other;
        if (!Intrinsics.areEqual(this.sourceMapPrefix, sourceMapsInfo.sourceMapPrefix)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.sourceRoots, sourceMapsInfo.sourceRoots)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.outputDir, sourceMapsInfo.outputDir)) {
            return false;
        }
        return this.sourceMapContentEmbedding == sourceMapsInfo.sourceMapContentEmbedding;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/SourceMapsInfo$Companion;", "", "()V", "from", "Lorg/jetbrains/kotlin/ir/backend/js/SourceMapsInfo;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "backend.js"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SourceMapsInfo from(@NotNull CompilerConfiguration configuration2) {
            SourceMapsInfo sourceMapsInfo;
            Intrinsics.checkNotNullParameter(configuration2, "configuration");
            if (configuration2.getBoolean(JSConfigurationKeys.SOURCE_MAP)) {
                String string2 = configuration2.get(JSConfigurationKeys.SOURCE_MAP_PREFIX, "");
                Intrinsics.checkNotNullExpressionValue(string2, "configuration.get(JSConf\u2026ys.SOURCE_MAP_PREFIX, \"\")");
                List<String> list2 = configuration2.get(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, CollectionsKt.emptyList());
                Intrinsics.checkNotNullExpressionValue(list2, "configuration.get(JSConf\u2026OURCE_ROOTS, emptyList())");
                SourceMapSourceEmbedding sourceMapSourceEmbedding = configuration2.get(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, SourceMapSourceEmbedding.INLINING);
                Intrinsics.checkNotNullExpressionValue((Object)sourceMapSourceEmbedding, "configuration.get(JSConf\u2026SourceEmbedding.INLINING)");
                sourceMapsInfo = new SourceMapsInfo(string2, list2, configuration2.get(JSConfigurationKeys.OUTPUT_DIR), sourceMapSourceEmbedding);
            } else {
                sourceMapsInfo = null;
            }
            return sourceMapsInfo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

