/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmAnnotation;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmClass;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmClassVisitor;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.KmModuleVisitor;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.jvm.KmPackageParts;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J2\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u001cH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/jvm/KmModule;", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/jvm/KmModuleVisitor;", "()V", "annotations", "", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmAnnotation;", "getAnnotations", "()Ljava/util/List;", "optionalAnnotationClasses", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmClass;", "getOptionalAnnotationClasses", "packageParts", "", "", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/jvm/KmPackageParts;", "getPackageParts", "()Ljava/util/Map;", "accept", "", "visitor", "visitAnnotation", "annotation", "visitOptionalAnnotationClass", "visitPackageParts", "fqName", "fileFacades", "", "multiFileClassParts", "", "kotlinx-metadata-jvm"})
public final class KmModule
extends KmModuleVisitor {
    @NotNull
    private final Map<String, KmPackageParts> packageParts = new LinkedHashMap();
    @NotNull
    private final List<KmAnnotation> annotations = new ArrayList(0);
    @NotNull
    private final List<KmClass> optionalAnnotationClasses = new ArrayList(0);

    public KmModule() {
        super(null, 1, null);
    }

    @NotNull
    public final Map<String, KmPackageParts> getPackageParts() {
        return this.packageParts;
    }

    @NotNull
    public final List<KmAnnotation> getAnnotations() {
        return this.annotations;
    }

    @NotNull
    public final List<KmClass> getOptionalAnnotationClasses() {
        return this.optionalAnnotationClasses;
    }

    @Override
    public void visitPackageParts(@NotNull String fqName, @NotNull List<String> fileFacades, @NotNull Map<String, String> multiFileClassParts) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter(fileFacades, (String)"fileFacades");
        Intrinsics.checkNotNullParameter(multiFileClassParts, (String)"multiFileClassParts");
        this.packageParts.put(fqName, new KmPackageParts(CollectionsKt.toMutableList((Collection)fileFacades), MapsKt.toMutableMap(multiFileClassParts)));
    }

    @Override
    public void visitAnnotation(@NotNull KmAnnotation annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        this.annotations.add(annotation);
    }

    @Override
    @NotNull
    public KmClass visitOptionalAnnotationClass() {
        KmClass kmClass = new KmClass();
        List<KmClass> list = this.optionalAnnotationClasses;
        KmClass p0 = kmClass;
        boolean bl = false;
        list.add(p0);
        return kmClass;
    }

    public final void accept(@NotNull KmModuleVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        for (Map.Entry<String, KmPackageParts> entry : this.packageParts.entrySet()) {
            String fqName = entry.getKey();
            KmPackageParts parts = entry.getValue();
            visitor.visitPackageParts(fqName, parts.getFileFacades(), parts.getMultiFileClassParts());
        }
        Iterable $this$forEach$iv = this.annotations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KmAnnotation p0 = (KmAnnotation)element$iv;
            boolean bl = false;
            visitor.visitAnnotation(p0);
        }
        $this$forEach$iv = this.optionalAnnotationClasses;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KmClassVisitor p0;
            KmClass it = (KmClass)element$iv;
            boolean bl = false;
            if (visitor.visitOptionalAnnotationClass() == null) continue;
            boolean bl2 = false;
            it.accept(p0);
        }
    }
}

