/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.File;
import java.io.FileFilter;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u001a \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00012\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\f\u001a\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00022\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0012\u001a\u00020\u0002H\u0002\u001a\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0002\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\f2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0000\u001a\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0002H\u0002\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\f*\u00020\tH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"COMPILER_JARS", "", "", "FILE_PROTOCOL", "JAR_PROTOCOL", "JAR_SEPARATOR", "SCHEME_SEPARATOR", "extractRoot", "resourceURL", "Ljava/net/URL;", "resourcePath", "findCompilerJar", "Ljava/io/File;", "classFromJarInTheSameLocation", "Ljava/lang/Class;", "kotlinHome", "getResourceRoot", "context", "path", "splitJarUrl", "Lkotlin/Pair;", "url", "tryGetResourcePathForClass", "aClass", "matchMaybeVersionedFile", "", "baseName", "toFileOrNull", "kotlin-runner"})
public final class FindCompilerKt {
    @NotNull
    private static final List<String> COMPILER_JARS;
    @NotNull
    private static final String JAR_PROTOCOL = "jar";
    @NotNull
    private static final String FILE_PROTOCOL = "file";
    @NotNull
    private static final String JAR_SEPARATOR = "!/";
    @NotNull
    private static final String SCHEME_SEPARATOR = "://";

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final List<File> findCompilerJar(@NotNull Class<?> classFromJarInTheSameLocation, @NotNull File kotlinHome) {
        Intrinsics.checkNotNullParameter(classFromJarInTheSameLocation, "classFromJarInTheSameLocation");
        Intrinsics.checkNotNullParameter(kotlinHome, "kotlinHome");
        v0 = FindCompilerKt.tryGetResourcePathForClass(classFromJarInTheSameLocation);
        if (v0 == null) ** GOTO lbl-1000
        it = var7_2 = v0;
        $i$a$-takeUnless-FindCompilerKt$findCompilerJar$baseDir$1 = false;
        v0 = it.isDirectory() == false ? var7_2 : null;
        if (v0 != null) {
            v1 = v0.getParentFile();
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        var4_6 = v1;
        it = var4_6 = var4_6 == null ? kotlinHome : var4_6;
        $i$a$-takeIf-FindCompilerKt$findCompilerJar$baseDir$2 = false;
        v2 /* !! */  = it.isDirectory() != false ? var4_6 : null;
        if (v2 /* !! */  == null) {
            return CollectionsKt.emptyList();
        }
        baseDir = v2 /* !! */ ;
        var4_6 = baseDir.listFiles((FileFilter)LambdaMetafactory.metafactory(null, null, null, (Ljava/io/File;)Z, findCompilerJar$lambda$3(java.io.File ), (Ljava/io/File;)Z)());
        if (var4_6 == null) ** GOTO lbl-1000
        it = var6_9 = var4_6;
        $i$a$-takeIf-FindCompilerKt$findCompilerJar$compilerJars$2 = false;
        v3 /* !! */  = var5_7 = it.length >= FindCompilerKt.COMPILER_JARS.size() != false ? var6_9 : null;
        if (var5_7 != null) {
            v4 /* !! */  = ArraysKt.toList(var5_7);
        } else lbl-1000:
        // 2 sources

        {
            v4 /* !! */  = null;
        }
        if ((v5 = (compilerJars = v4 /* !! */ )) == null) {
            v5 = CollectionsKt.emptyList();
        }
        return v5;
    }

    @Nullable
    public static final File tryGetResourcePathForClass(@NotNull Class<?> aClass) {
        File file;
        Intrinsics.checkNotNullParameter(aClass, "aClass");
        StringBuilder stringBuilder = new StringBuilder().append('/');
        String string = aClass.getName();
        Intrinsics.checkNotNullExpressionValue(string, "aClass.name");
        String path = stringBuilder.append(StringsKt.replace$default(string, '.', '/', false, 4, null)).append(".class").toString();
        String string2 = FindCompilerKt.getResourceRoot(aClass, path);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            file = new File(it).getAbsoluteFile();
        } else {
            file = null;
        }
        return file;
    }

    private static final String getResourceRoot(Class<?> context, String path) {
        URL url = context.getResource(path);
        if (url == null) {
            String string = path.substring(1);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            url = ClassLoader.getSystemResource(string);
        }
        URL uRL = url;
        return uRL != null ? FindCompilerKt.extractRoot(uRL, path) : null;
    }

    private static final String extractRoot(URL resourceURL, String resourcePath) {
        String string;
        if (!StringsKt.startsWith$default((CharSequence)resourcePath, '/', false, 2, null) || StringsKt.startsWith$default((CharSequence)resourcePath, '\\', false, 2, null)) {
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if (Intrinsics.areEqual(protocol, FILE_PROTOCOL)) {
            File file = FindCompilerKt.toFileOrNull(resourceURL);
            Intrinsics.checkNotNull(file);
            String path = file.getPath();
            Intrinsics.checkNotNullExpressionValue(path, "path");
            String testPath = StringsKt.replace$default(path, '\\', '/', false, 4, null);
            String testResourcePath = StringsKt.replace$default(resourcePath, '\\', '/', false, 4, null);
            if (StringsKt.endsWith(testPath, testResourcePath, true)) {
                String string2 = path.substring(0, path.length() - resourcePath.length());
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                resultPath = string2;
            }
        } else if (Intrinsics.areEqual(protocol, JAR_PROTOCOL)) {
            Pair<String, String> paths;
            String string3 = resourceURL.getFile();
            Intrinsics.checkNotNullExpressionValue(string3, "resourceURL.file");
            Pair<String, String> pair = paths = FindCompilerKt.splitJarUrl(string3);
            if ((pair != null ? pair.getFirst() : null) != null) {
                resultPath = new File(paths.getFirst()).getCanonicalPath();
            }
        }
        String string4 = resultPath;
        if (string4 != null) {
            char[] cArray = new char[]{File.separatorChar};
            string = StringsKt.trimEnd(string4, cArray);
        } else {
            string = null;
        }
        return string;
    }

    private static final Pair<String, String> splitJarUrl(String url) {
        String jarPath;
        String resourcePath;
        block6: {
            Integer n = StringsKt.indexOf$default((CharSequence)url, JAR_SEPARATOR, 0, false, 6, null);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it >= 0 ? n : null;
            if (n2 == null) {
                return null;
            }
            int pivot = n2;
            String string = url.substring(pivot + 2);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            resourcePath = string;
            String string2 = url.substring(0, pivot);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            jarPath = string2;
            if (StringsKt.startsWith$default(jarPath, "jar:", false, 2, null)) {
                String string3 = jarPath.substring(4);
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
                jarPath = string3;
            }
            if (StringsKt.startsWith$default(jarPath, FILE_PROTOCOL, false, 2, null)) {
                try {
                    File file = FindCompilerKt.toFileOrNull(new URL(jarPath));
                    Intrinsics.checkNotNull(file);
                    String string4 = file.getPath();
                    Intrinsics.checkNotNullExpressionValue(string4, "URL(jarPath).toFileOrNull()!!.path");
                    jarPath = StringsKt.replace$default(string4, '\\', '/', false, 4, null);
                }
                catch (Exception e) {
                    String string5 = jarPath.substring(4);
                    Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).substring(startIndex)");
                    jarPath = string5;
                    if (StringsKt.startsWith$default(jarPath, SCHEME_SEPARATOR, false, 2, null)) {
                        String string6 = jarPath.substring(3);
                        Intrinsics.checkNotNullExpressionValue(string6, "this as java.lang.String).substring(startIndex)");
                        jarPath = string6;
                    }
                    if (!StringsKt.startsWith$default((CharSequence)jarPath, ':', false, 2, null)) break block6;
                    String string7 = jarPath.substring(1);
                    Intrinsics.checkNotNullExpressionValue(string7, "this as java.lang.String).substring(startIndex)");
                    jarPath = string7;
                }
            }
        }
        return new Pair<String, String>(jarPath, resourcePath);
    }

    private static final File toFileOrNull(URL $this$toFileOrNull) {
        File file;
        File file2;
        try {
            file2 = new File($this$toFileOrNull.toURI());
        }
        catch (IllegalArgumentException e) {
            file2 = null;
        }
        catch (URISyntaxException e) {
            file2 = null;
        }
        if ((file = file2) == null) {
            URL $this$toFileOrNull_u24lambda_u247 = $this$toFileOrNull;
            boolean bl = false;
            file = !Intrinsics.areEqual($this$toFileOrNull_u24lambda_u247.getProtocol(), FILE_PROTOCOL) ? null : new File($this$toFileOrNull_u24lambda_u247.getFile());
        }
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean matchMaybeVersionedFile(File $this$matchMaybeVersionedFile, String baseName) {
        if (Intrinsics.areEqual($this$matchMaybeVersionedFile.getName(), baseName)) return true;
        if (Intrinsics.areEqual($this$matchMaybeVersionedFile.getName(), StringsKt.removeSuffix(baseName, (CharSequence)".jar"))) return true;
        Regex regex = new Regex(Regex.Companion.escape(StringsKt.removeSuffix(baseName, (CharSequence)".jar")) + "(-\\d.*)?\\.jar");
        String string = $this$matchMaybeVersionedFile.getName();
        Intrinsics.checkNotNullExpressionValue(string, "name");
        if (!regex.matches(string)) return false;
        return true;
    }

    private static final boolean findCompilerJar$lambda$3(File f) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(f, "f");
            Iterable $this$any$iv = COMPILER_JARS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String expected = (String)element$iv;
                    boolean bl2 = false;
                    if (!(FindCompilerKt.matchMaybeVersionedFile(f, expected) && Intrinsics.areEqual(FilesKt.getExtension(f), JAR_PROTOCOL))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        String[] stringArray = new String[]{"kotlin-compiler", "kotlin-stdlib", "kotlin-reflect"};
        COMPILER_JARS = CollectionsKt.listOf(stringArray);
    }
}

