/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.fixStack.BasicTypeInterpreter;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackValue;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0014J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\u0002H\u0014J\b\u0010\t\u001a\u00020\u0002H\u0014J\b\u0010\n\u001a\u00020\u0002H\u0014J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\b\u0010\u000f\u001a\u00020\u0002H\u0014J\b\u0010\u0010\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0002H\u0014J\b\u0010\u0015\u001a\u00020\u0002H\u0014J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\u001a\u001a\u00020\u0002H\u0014J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\u001c\u001a\u00020\u0002H\u0014J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0007H\u0014J\b\u0010\u001f\u001a\u00020\u0002H\u0014\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/BasicTypeInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackValue;", "()V", "aaLoadValue", "arrayValue", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "booleanValue", "byteValue", "charValue", "copyOperation", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "value", "doubleValue", "floatValue", "handleValue", "handle", "Lorg/jetbrains/org/objectweb/asm/Handle;", "intValue", "longValue", "merge", "v", "w", "methodValue", "nullValue", "objectValue", "shortValue", "typeConstValue", "typeConst", "uninitializedValue", "backend"})
public final class FixStackInterpreter
extends BasicTypeInterpreter<FixStackValue> {
    @Override
    @NotNull
    protected FixStackValue uninitializedValue() {
        return FixStackValue.UNINITIALIZED;
    }

    @Override
    @NotNull
    protected FixStackValue booleanValue() {
        return FixStackValue.INT;
    }

    @Override
    @NotNull
    protected FixStackValue charValue() {
        return FixStackValue.INT;
    }

    @Override
    @NotNull
    protected FixStackValue byteValue() {
        return FixStackValue.INT;
    }

    @Override
    @NotNull
    protected FixStackValue shortValue() {
        return FixStackValue.INT;
    }

    @Override
    @NotNull
    protected FixStackValue intValue() {
        return FixStackValue.INT;
    }

    @Override
    @NotNull
    protected FixStackValue longValue() {
        return FixStackValue.LONG;
    }

    @Override
    @NotNull
    protected FixStackValue floatValue() {
        return FixStackValue.FLOAT;
    }

    @Override
    @NotNull
    protected FixStackValue doubleValue() {
        return FixStackValue.DOUBLE;
    }

    @Override
    @NotNull
    protected FixStackValue nullValue() {
        return FixStackValue.OBJECT;
    }

    @Override
    @NotNull
    protected FixStackValue objectValue(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return FixStackValue.OBJECT;
    }

    @Override
    @NotNull
    protected FixStackValue arrayValue(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return FixStackValue.OBJECT;
    }

    @Override
    @NotNull
    protected FixStackValue methodValue(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return FixStackValue.OBJECT;
    }

    @Override
    @NotNull
    protected FixStackValue handleValue(@NotNull Handle handle2) {
        Intrinsics.checkNotNullParameter(handle2, "handle");
        return FixStackValue.OBJECT;
    }

    @Override
    @NotNull
    protected FixStackValue typeConstValue(@NotNull Type typeConst) {
        Intrinsics.checkNotNullParameter(typeConst, "typeConst");
        return FixStackValue.OBJECT;
    }

    @Override
    @NotNull
    protected FixStackValue aaLoadValue(@NotNull FixStackValue arrayValue) {
        Intrinsics.checkNotNullParameter(arrayValue, "arrayValue");
        return FixStackValue.OBJECT;
    }

    @Override
    @NotNull
    public FixStackValue copyOperation(@NotNull AbstractInsnNode insn, @NotNull FixStackValue value2) {
        FixStackValue fixStackValue;
        Intrinsics.checkNotNullParameter(insn, "insn");
        Intrinsics.checkNotNullParameter(value2, "value");
        switch (insn.getOpcode()) {
            case 21: {
                fixStackValue = FixStackValue.INT;
                break;
            }
            case 22: {
                fixStackValue = FixStackValue.LONG;
                break;
            }
            case 23: {
                fixStackValue = FixStackValue.FLOAT;
                break;
            }
            case 24: {
                fixStackValue = FixStackValue.DOUBLE;
                break;
            }
            case 25: {
                fixStackValue = FixStackValue.OBJECT;
                break;
            }
            default: {
                fixStackValue = value2;
            }
        }
        return fixStackValue;
    }

    @Override
    @NotNull
    public FixStackValue merge(@NotNull FixStackValue v, @NotNull FixStackValue w) {
        Intrinsics.checkNotNullParameter(v, "v");
        Intrinsics.checkNotNullParameter(w, "w");
        if (v != w) {
            throw new AssertionError((Object)("Mismatching value kinds: " + v + " != " + w));
        }
        return v;
    }
}

