/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.converter;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ElementTypeUtils;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirExpressionRef;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirGenerationKt;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirLoopTarget;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.builder.BaseFirBuilder;
import org.jetbrains.kotlin.fir.builder.CalleeAndReceiver;
import org.jetbrains.kotlin.fir.builder.Context;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.builder.FirLabelBuilder;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.diagnostics.ConeNotAnnotationContainer;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeUnderscoreUsageWithoutBackticks;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirAbstractFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnonymousFunctionExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArrayOfCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBlockBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBreakExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallableReferenceAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCatchBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCheckNotNullCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirContinueExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirDoWhileLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirElseIfTrueConditionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirEmptyExpressionBlockBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirEqualityOperatorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirErrorExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirGetClassCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirImplicitInvokeCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLambdaArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLoopJumpBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirNamedArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirPropertyAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirQualifiedAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirQualifiedErrorAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirReturnExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSpreadArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThisReceiverExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThrowExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirTryExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirTypeOperatorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirUnitExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenBranchBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenSubjectExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhileLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.lightTree.LightTree2Fir;
import org.jetbrains.kotlin.fir.lightTree.converter.BaseConverter;
import org.jetbrains.kotlin.fir.lightTree.converter.ConverterUtilKt;
import org.jetbrains.kotlin.fir.lightTree.converter.DeclarationsConverter;
import org.jetbrains.kotlin.fir.lightTree.converter.ExpressionsConverter;
import org.jetbrains.kotlin.fir.lightTree.fir.DestructuringDeclaration;
import org.jetbrains.kotlin.fir.lightTree.fir.ValueParameter;
import org.jetbrains.kotlin.fir.lightTree.fir.WhenEntry;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.builder.FirErrorNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirExplicitSuperReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirExplicitThisReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtNameReferenceExpressionElementType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001xB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J)\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u00062\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 \u00a2\u0006\u0002\b#H\u0002J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0006H\u0002J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u0006H\u0002J \u0010(\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010*\u0012\u0004\u0012\u00020+\u0018\u00010)2\u0006\u0010,\u001a\u00020\u0006H\u0002J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u0006H\u0002J\u0010\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u0006H\u0002J\u0010\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u00020\u0006H\u0002J\u0010\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0006H\u0002J\u0016\u00105\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u00062\u0006\u00106\u001a\u00020!J\u0010\u00107\u001a\u00020+2\u0006\u00108\u001a\u00020\u0006H\u0002J\u0010\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u0006H\u0002J\u0010\u0010;\u001a\u00020\u00182\u0006\u0010<\u001a\u00020\u0006H\u0002J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00180>2\u0006\u0010?\u001a\u00020\u0006H\u0002J\u0010\u0010@\u001a\u00020\u00152\u0006\u0010A\u001a\u00020\u0006H\u0002J\u0010\u0010B\u001a\u00020\u00182\u0006\u0010C\u001a\u00020\u0006H\u0002J\u0012\u0010D\u001a\u00020+2\b\u0010E\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010F\u001a\u00020\u00182\u0006\u0010G\u001a\u00020\u0006H\u0002J\u0014\u0010H\u001a\u0004\u0018\u00010+2\b\u0010E\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010I\u001a\u00020\u00182\u0006\u0010J\u001a\u00020\u0006H\u0002J\u0010\u0010K\u001a\u00020\u00182\u0006\u0010L\u001a\u00020\u0006H\u0002J\u0010\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u0006H\u0002J\u0010\u0010P\u001a\u00020\u00182\u0006\u0010Q\u001a\u00020\u0006H\u0002J\u0010\u0010R\u001a\u00020N2\u0006\u0010S\u001a\u00020\u0006H\u0002J\u0010\u0010T\u001a\u00020N2\u0006\u0010U\u001a\u00020\u0006H\u0002J\u0010\u0010V\u001a\u00020\u00182\u0006\u0010W\u001a\u00020\u0006H\u0002J\u0010\u0010X\u001a\u00020\u00182\u0006\u0010Y\u001a\u00020\u0006H\u0002J\u0010\u0010Z\u001a\u00020\u00182\u0006\u0010[\u001a\u00020\u0006H\u0002J\u0010\u0010\\\u001a\u00020\u00182\u0006\u0010]\u001a\u00020\u0006H\u0002J\u0014\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00180>2\u0006\u0010_\u001a\u00020\u0006J \u0010`\u001a\u00020\u00182\u0006\u0010a\u001a\u00020\u00062\u000e\u0010b\u001a\n\u0012\u0004\u0012\u00020d\u0018\u00010cH\u0002J \u0010e\u001a\u00020\u00182\u0006\u0010a\u001a\u00020\u00062\u000e\u0010b\u001a\n\u0012\u0004\u0012\u00020d\u0018\u00010cH\u0002J \u0010f\u001a\u00020\u00182\u0006\u0010a\u001a\u00020\u00062\u000e\u0010b\u001a\n\u0012\u0004\u0012\u00020d\u0018\u00010cH\u0002J \u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020\u00062\u000e\u0010b\u001a\n\u0012\u0004\u0012\u00020d\u0018\u00010cH\u0002J\u0010\u0010j\u001a\u00020\u00182\u0006\u0010k\u001a\u00020\u0006H\u0002J\u0010\u0010l\u001a\u00020\u00152\u0006\u0010m\u001a\u00020\u0006H\u0002J\u0018\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020q2\u0006\u0010O\u001a\u00020\u0006H\u0002J.\u0010r\u001a\u0002Hs\"\n\b\u0000\u0010s\u0018\u0001*\u00020\u00152\b\u00100\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u00106\u001a\u00020!H\u0086\b\u00a2\u0006\u0002\u0010tJ\u0010\u0010u\u001a\u00020v2\u0006\u0010<\u001a\u00020\u0006H\u0002J\u0016\u0010w\u001a\u00020\u0018*\u0004\u0018\u00010\u00062\u0006\u00106\u001a\u00020!H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006y"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/converter/ExpressionsConverter;", "Lorg/jetbrains/kotlin/fir/lightTree/converter/BaseConverter;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "declarationsConverter", "Lorg/jetbrains/kotlin/fir/lightTree/converter/DeclarationsConverter;", "context", "Lorg/jetbrains/kotlin/fir/builder/Context;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lcom/intellij/util/diff/FlyweightCapableTreeStructure;Lorg/jetbrains/kotlin/fir/lightTree/converter/DeclarationsConverter;Lorg/jetbrains/kotlin/fir/builder/Context;)V", "offset", "", "getOffset", "()I", "usedAsExpression", "", "getUsedAsExpression", "(Lcom/intellij/lang/LighterASTNode;)Z", "convertAnnotatedExpression", "Lorg/jetbrains/kotlin/fir/FirElement;", "annotatedExpression", "convertArrayAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "arrayAccess", "convertBinaryExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "binaryExpression", "convertBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "toFirOperation", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "Lkotlin/ExtensionFunctionType;", "convertCallExpression", "callSuffix", "convertCallableReferenceExpression", "callableReferenceExpression", "convertCatchClause", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/lightTree/fir/ValueParameter;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "catchClause", "convertClassLiteralExpression", "classLiteralExpression", "convertCollectionLiteralExpression", "expression", "convertConstantExpression", "constantExpression", "convertDoWhile", "doWhileLoop", "convertExpression", "errorReason", "convertFinally", "finallyExpression", "convertFor", "forLoop", "convertIfExpression", "ifExpression", "convertIndices", "", "indices", "convertLabeledExpression", "labeledExpression", "convertLambdaExpression", "lambdaExpression", "convertLoopBody", "body", "convertLoopJump", "jump", "convertLoopOrIfBody", "convertQualifiedExpression", "dotQualifiedExpression", "convertReturn", "returnExpression", "convertSimpleNameExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "referenceExpression", "convertStringTemplate", "stringTemplate", "convertSuperExpression", "superExpression", "convertThisExpression", "thisExpression", "convertThrow", "throwExpression", "convertTryExpression", "tryExpression", "convertUnaryExpression", "unaryExpression", "convertValueArgument", "valueArgument", "convertValueArguments", "valueArguments", "convertWhenConditionExpression", "whenCondition", "whenRefWithSubject", "Lorg/jetbrains/kotlin/fir/FirExpressionRef;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "convertWhenConditionInRange", "convertWhenConditionIsPattern", "convertWhenEntry", "Lorg/jetbrains/kotlin/fir/lightTree/fir/WhenEntry;", "whenEntry", "convertWhenExpression", "whenExpression", "convertWhile", "whileLoop", "createSimpleNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirNamedReference;", "sourceElement", "Lorg/jetbrains/kotlin/KtSourceElement;", "getAsFirExpression", "R", "(Lcom/intellij/lang/LighterASTNode;Ljava/lang/String;)Lorg/jetbrains/kotlin/fir/FirElement;", "parseIfExpression", "Lorg/jetbrains/kotlin/fir/lightTree/converter/ExpressionsConverter$IfNodeComponents;", "convertShortOrLongStringTemplate", "IfNodeComponents", "light-tree2fir"})
@SourceDebugExtension(value={"SMAP\nExpressionsConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionsConverter.kt\norg/jetbrains/kotlin/fir/lightTree/converter/ExpressionsConverter\n+ 2 BaseConverter.kt\norg/jetbrains/kotlin/fir/lightTree/converter/BaseConverter\n+ 3 FirAnonymousFunctionBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirAnonymousFunctionBuilderKt\n+ 4 FirLabelBuilder.kt\norg/jetbrains/kotlin/fir/builder/FirLabelBuilderKt\n+ 5 FirValueParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirValueParameterBuilderKt\n+ 6 DeclarationsConverter.kt\norg/jetbrains/kotlin/fir/lightTree/converter/DeclarationsConverter\n+ 7 FirReturnExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirReturnExpressionBuilderKt\n+ 8 FirUnitExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirUnitExpressionBuilderKt\n+ 9 FirSingleExpressionBlock.kt\norg/jetbrains/kotlin/fir/expressions/impl/FirSingleExpressionBlockKt\n+ 10 FirAnonymousFunctionExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnonymousFunctionExpressionBuilderKt\n+ 11 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n+ 12 FirSimpleNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirSimpleNamedReferenceBuilderKt\n+ 13 FirEqualityOperatorCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirEqualityOperatorCallBuilderKt\n+ 14 FirTypeOperatorCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirTypeOperatorCallBuilderKt\n+ 15 FirCheckNotNullCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCheckNotNullCallBuilderKt\n+ 16 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 17 FirGetClassCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirGetClassCallBuilderKt\n+ 18 FirCallableReferenceAccessBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCallableReferenceAccessBuilderKt\n+ 19 FirErrorExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirErrorExpressionBuilderKt\n+ 20 FirQualifiedErrorAccessExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirQualifiedErrorAccessExpressionBuilderKt\n+ 21 FirErrorNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirErrorNamedReferenceBuilderKt\n+ 22 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 23 FirPropertyBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilderKt\n+ 24 FirWhenExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirWhenExpressionBuilderKt\n+ 25 FirWhenBranchBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirWhenBranchBuilderKt\n+ 26 FirElseIfTrueConditionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirElseIfTrueConditionBuilderKt\n+ 27 FirElseIfTrueConditionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirElseIfTrueConditionBuilderKt$buildElseIfTrueCondition$1\n+ 28 FirWhenSubjectExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirWhenSubjectExpressionBuilderKt\n+ 29 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n+ 30 FirArrayOfCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArrayOfCallBuilderKt\n+ 31 FirPropertyAccessExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirPropertyAccessExpressionBuilderKt\n+ 32 FirBlockBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirBlockBuilderKt\n+ 33 FirTryExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirTryExpressionBuilderKt\n+ 34 FirCatchBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCatchBuilderKt\n+ 35 FirThrowExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirThrowExpressionBuilderKt\n+ 36 FirThisReceiverExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirThisReceiverExpressionBuilderKt\n+ 37 FirExplicitThisReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirExplicitThisReferenceBuilderKt\n+ 38 FirExplicitSuperReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirExplicitSuperReferenceBuilderKt\n+ 39 FirLambdaArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirLambdaArgumentExpressionBuilderKt\n+ 40 FirNamedArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirNamedArgumentExpressionBuilderKt\n+ 41 FirSpreadArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSpreadArgumentExpressionBuilderKt\n*L\n1#1,1485:1\n66#1,4:1486\n66#1,4:1490\n66#1,4:1549\n66#1,4:1553\n66#1,4:1579\n65#1,5:1598\n66#1,4:1620\n66#1,4:1624\n65#1,5:1647\n66#1,4:1663\n66#1,4:1682\n66#1,4:1701\n66#1,4:1762\n66#1,4:1781\n66#1,4:1785\n66#1,4:1837\n66#1,4:1860\n66#1,4:1907\n66#1,4:1934\n66#1,4:1957\n66#1,4:1980\n66#1,4:1995\n66#1,4:2010\n65#1,5:2045\n65#1,5:2050\n65#1,5:2055\n66#1,4:2149\n66#1,4:2176\n66#1,4:2195\n65#1,5:2248\n66#1,4:2264\n66#1,4:2277\n66#1,4:2281\n176#2,12:1494\n176#2,12:1537\n176#2,10:1569\n187#2:1583\n176#2,10:1588\n187#2:1603\n176#2,12:1604\n176#2,10:1637\n187#2:1652\n176#2,10:1653\n187#2:1667\n176#2,10:1672\n187#2:1686\n176#2,10:1691\n187#2:1709\n176#2,12:1718\n176#2,10:1752\n187#2:1766\n176#2,10:1767\n187#2:1789\n176#2,12:1815\n176#2,10:1827\n187#2:1841\n176#2,10:1850\n187#2:1864\n176#2,12:1873\n176#2,10:1897\n187#2:1911\n176#2,10:1924\n187#2:1938\n176#2,10:1947\n187#2:1961\n176#2,10:1970\n187#2:1984\n176#2,10:1985\n187#2:1999\n176#2,10:2000\n187#2:2014\n176#2,10:2035\n187#2:2060\n176#2,12:2061\n176#2,12:2085\n176#2,12:2097\n176#2,12:2117\n176#2,10:2139\n187#2:2153\n176#2,12:2154\n176#2,10:2166\n187#2:2180\n176#2,10:2185\n187#2:2199\n176#2,12:2212\n190#2,12:2232\n204#2:2253\n176#2,10:2254\n187#2:2268\n118#3,4:1506\n38#4,4:1510\n96#5,4:1514\n83#6,4:1518\n88#6,2:1530\n60#7,4:1522\n47#8,4:1526\n47#8,4:2181\n71#9:1532\n47#10,4:1533\n73#11,4:1557\n73#11,4:1629\n73#11,4:1912\n73#11,4:2019\n73#11,4:2027\n41#12,4:1561\n41#12,4:1633\n41#12,4:1730\n41#12,4:1734\n41#12,4:1916\n41#12,4:1966\n41#12,4:2023\n41#12,4:2031\n57#13,4:1565\n57#13,4:1842\n61#14,4:1584\n61#14,4:1893\n53#15,4:1616\n1#16:1628\n51#17,4:1668\n67#18,4:1687\n61#19,4:1705\n61#19,4:1714\n61#19,4:1869\n61#19,4:1889\n61#20,4:1710\n40#21,4:1738\n40#21,4:1742\n1360#22:1746\n1446#22,5:1747\n1620#22,3:1790\n111#23,4:1777\n111#23,4:2081\n64#24,4:1793\n64#24,4:2109\n42#25,4:1797\n42#25,4:1801\n42#25,4:1805\n42#25,4:2113\n42#25,4:2129\n46#26,5:1809\n46#26,5:2133\n46#27:1814\n46#27:2138\n54#28,4:1846\n54#28,4:1865\n54#28,4:1885\n33#29,4:1920\n33#29,4:1943\n50#30,4:1939\n68#31,4:1962\n68#31,4:2224\n54#32,4:2015\n58#33,4:2073\n42#34,4:2077\n56#35,4:2200\n82#36,4:2204\n41#37,4:2208\n41#38,4:2228\n53#39,4:2244\n58#40,4:2269\n53#41,4:2273\n*S KotlinDebug\n*F\n+ 1 ExpressionsConverter.kt\norg/jetbrains/kotlin/fir/lightTree/converter/ExpressionsConverter\n*L\n118#1:1486,4\n121#1:1490,4\n263#1:1549,4\n267#1:1553,4\n333#1:1579,4\n369#1:1598,5\n403#1:1620,4\n417#1:1624,4\n447#1:1647,5\n465#1:1663,4\n492#1:1682,4\n527#1:1701,4\n696#1:1762,4\n734#1:1781,4\n737#1:1785,4\n822#1:1837,4\n862#1:1860,4\n940#1:1907,4\n967#1:1934,4\n984#1:1957,4\n1037#1:1980,4\n1055#1:1995,4\n1081#1:2010,4\n1173#1:2045,5\n1175#1:2050,5\n1178#1:2055,5\n1313#1:2149,4\n1370#1:2176,4\n1391#1:2195,4\n1445#1:2248,5\n1465#1:2264,4\n607#1:2277,4\n617#1:2281,4\n141#1:1494,12\n238#1:1537,12\n329#1:1569,10\n329#1:1583\n355#1:1588,10\n355#1:1603\n387#1:1604,12\n440#1:1637,10\n440#1:1652\n464#1:1653,10\n464#1:1667\n486#1:1672,10\n486#1:1686\n517#1:1691,10\n517#1:1709\n597#1:1718,12\n695#1:1752,10\n695#1:1766\n717#1:1767,10\n717#1:1789\n801#1:1815,12\n820#1:1827,10\n820#1:1841\n853#1:1850,10\n853#1:1864\n900#1:1873,12\n937#1:1897,10\n937#1:1911\n966#1:1924,10\n966#1:1938\n983#1:1947,10\n983#1:1961\n1034#1:1970,10\n1034#1:1984\n1052#1:1985,10\n1052#1:1999\n1078#1:2000,10\n1078#1:2014\n1168#1:2035,10\n1168#1:2060\n1193#1:2061,12\n1233#1:2085,12\n1249#1:2097,12\n1281#1:2117,12\n1311#1:2139,10\n1311#1:2153\n1346#1:2154,12\n1367#1:2166,10\n1367#1:2180\n1390#1:2185,10\n1390#1:2199\n1419#1:2212,12\n1438#1:2232,12\n1438#1:2253\n1459#1:2254,10\n1459#1:2268\n151#1:1506,4\n161#1:1510,4\n173#1:1514,4\n199#1:1518,4\n199#1:1530,2\n203#1:1522,4\n206#1:1526,4\n1374#1:2181,4\n216#1:1532\n222#1:1533,4\n286#1:1557,4\n419#1:1629,4\n944#1:1912,4\n1097#1:2019,4\n1109#1:2027,4\n288#1:1561,4\n421#1:1633,4\n629#1:1730,4\n637#1:1734,4\n947#1:1916,4\n1015#1:1966,4\n1099#1:2023,4\n1111#1:2031,4\n308#1:1565,4\n832#1:1842,4\n337#1:1584,4\n922#1:1893,4\n401#1:1616,4\n468#1:1668,4\n500#1:1687,4\n536#1:1705,4\n578#1:1714,4\n872#1:1869,4\n913#1:1889,4\n569#1:1710,4\n648#1:1738,4\n657#1:1742,4\n671#1:1746\n671#1:1747,5\n745#1:1790,3\n720#1:1777,4\n1207#1:2081,4\n751#1:1793,4\n1265#1:2109,4\n762#1:1797,4\n769#1:1801,4\n776#1:1805,4\n1270#1:2113,4\n1291#1:2129,4\n778#1:1809,5\n1293#1:2133,5\n778#1:1814\n1293#1:2138\n836#1:1846,4\n867#1:1865,4\n909#1:1885,4\n953#1:1920,4\n972#1:1943,4\n970#1:1939,4\n1001#1:1962,4\n1425#1:2224,4\n1091#1:2015,4\n1200#1:2073,4\n1206#1:2077,4\n1394#1:2200,4\n1406#1:2204,4\n1408#1:2208,4\n1427#1:2228,4\n1443#1:2244,4\n1471#1:2269,4\n1477#1:2273,4\n*E\n"})
public final class ExpressionsConverter
extends BaseConverter {
    @NotNull
    private final DeclarationsConverter declarationsConverter;

    public ExpressionsConverter(@NotNull FirSession session2, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull DeclarationsConverter declarationsConverter, @NotNull Context<LighterASTNode> context) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(tree, "tree");
        Intrinsics.checkNotNullParameter(declarationsConverter, "declarationsConverter");
        Intrinsics.checkNotNullParameter(context, "context");
        super(session2, tree, context);
        this.declarationsConverter = declarationsConverter;
    }

    public /* synthetic */ ExpressionsConverter(FirSession firSession, FlyweightCapableTreeStructure flyweightCapableTreeStructure, DeclarationsConverter declarationsConverter, Context context, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            context = new Context<LighterASTNode>();
        }
        this(firSession, flyweightCapableTreeStructure, declarationsConverter, context);
    }

    @Override
    public int getOffset() {
        return this.declarationsConverter.getOffset();
    }

    public final /* synthetic */ <R extends FirElement> R getAsFirExpression(LighterASTNode expression2, String errorReason) {
        FirElement firElement;
        FirElement firElement2;
        Intrinsics.checkNotNullParameter(errorReason, "errorReason");
        boolean $i$f$getAsFirExpression = false;
        LighterASTNode lighterASTNode2 = expression2;
        if (lighterASTNode2 != null) {
            LighterASTNode it = lighterASTNode2;
            boolean bl = false;
            firElement2 = this.convertExpression(it, errorReason);
        } else {
            firElement2 = null;
        }
        Intrinsics.reifiedOperationMarker(2, "R");
        FirElement firElement3 = firElement2;
        if (firElement3 != null) {
            firElement = firElement3;
        } else {
            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(expression2 != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, expression2, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionExpected));
            Intrinsics.reifiedOperationMarker(1, "R");
            firElement = firErrorExpression;
        }
        return (R)firElement;
    }

    public static /* synthetic */ FirElement getAsFirExpression$default(ExpressionsConverter $this, LighterASTNode expression2, String errorReason, int n, Object object) {
        FirElement firElement;
        FirElement firElement2;
        if ((n & 2) != 0) {
            errorReason = "";
        }
        Intrinsics.checkNotNullParameter(errorReason, "errorReason");
        boolean $i$f$getAsFirExpression = false;
        LighterASTNode lighterASTNode2 = expression2;
        if (lighterASTNode2 != null) {
            LighterASTNode it = lighterASTNode2;
            boolean bl = false;
            firElement2 = $this.convertExpression(it, errorReason);
        } else {
            firElement2 = null;
        }
        Intrinsics.reifiedOperationMarker(2, "R");
        FirElement firElement3 = firElement2;
        if (firElement3 != null) {
            firElement = firElement3;
        } else {
            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(expression2 != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default($this, expression2, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionExpected));
            Intrinsics.reifiedOperationMarker(1, "R");
            firElement = firErrorExpression;
        }
        return firElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirElement convertExpression(@NotNull LighterASTNode expression2, @NotNull String errorReason) {
        FirElement firElement;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(errorReason, "errorReason");
        IElementType iElementType = expression2.getTokenType();
        if (Intrinsics.areEqual(iElementType, KtNodeTypes.LAMBDA_EXPRESSION)) {
            FlyweightCapableTreeStructure<LighterASTNode> lambdaTree = LightTree2Fir.Companion.buildLightTreeLambdaExpression(this.getAsText(expression2));
            this.getContext().forwardLabelUsagePermission(expression2, lambdaTree.getRoot());
            DeclarationsConverter lambdaDeclarationsConverter = new DeclarationsConverter(this.getBaseSession(), this.declarationsConverter.getBaseScopeProvider$light_tree2fir(), lambdaTree, this.getOffset() + expression2.getStartOffset(), this.getContext(), null, null, 96, null);
            ExpressionsConverter expressionsConverter = new ExpressionsConverter(this.getBaseSession(), lambdaTree, lambdaDeclarationsConverter, this.getContext());
            LighterASTNode lighterASTNode2 = lambdaTree.getRoot();
            Intrinsics.checkNotNullExpressionValue(lighterASTNode2, "lambdaTree.root");
            firElement = expressionsConverter.convertLambdaExpression(lighterASTNode2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.BINARY_EXPRESSION)) {
            firElement = this.convertBinaryExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.BINARY_WITH_TYPE)) {
            firElement = this.convertBinaryWithTypeRHSExpression(expression2, convertExpression.1.INSTANCE);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.IS_EXPRESSION)) {
            firElement = this.convertBinaryWithTypeRHSExpression(expression2, convertExpression.2.INSTANCE);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.LABELED_EXPRESSION)) {
            firElement = this.convertLabeledExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.PREFIX_EXPRESSION) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.POSTFIX_EXPRESSION)) {
            firElement = this.convertUnaryExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.ANNOTATED_EXPRESSION)) {
            firElement = this.convertAnnotatedExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.CLASS_LITERAL_EXPRESSION)) {
            firElement = this.convertClassLiteralExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.CALLABLE_REFERENCE_EXPRESSION)) {
            firElement = this.convertCallableReferenceExpression(expression2);
        } else if (KtTokens.QUALIFIED_ACCESS.contains(iElementType)) {
            firElement = this.convertQualifiedExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.CALL_EXPRESSION)) {
            firElement = this.convertCallExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHEN)) {
            firElement = this.convertWhenExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.ARRAY_ACCESS_EXPRESSION)) {
            firElement = this.convertArrayAccessExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.COLLECTION_LITERAL_EXPRESSION)) {
            firElement = this.convertCollectionLiteralExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.STRING_TEMPLATE)) {
            firElement = this.convertStringTemplate(expression2);
        } else if (iElementType instanceof KtConstantExpressionElementType) {
            firElement = this.convertConstantExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.REFERENCE_EXPRESSION)) {
            firElement = this.convertSimpleNameExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.DO_WHILE)) {
            firElement = this.convertDoWhile(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHILE)) {
            firElement = this.convertWhile(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.FOR)) {
            firElement = this.convertFor(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.TRY)) {
            firElement = this.convertTryExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.IF)) {
            firElement = this.convertIfExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.BREAK) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.CONTINUE)) {
            firElement = this.convertLoopJump(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.RETURN)) {
            firElement = this.convertReturn(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.THROW)) {
            firElement = this.convertThrow(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.PARENTHESIZED)) {
            FirElement firElement2;
            FirElement firElement3;
            void this_$iv;
            LighterASTNode content2 = this.getExpressionInParentheses(expression2);
            this.getContext().forwardLabelUsagePermission(expression2, content2);
            ExpressionsConverter lambdaDeclarationsConverter = this;
            String errorReason$iv = "Empty parentheses";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode3 = content2;
            if (lighterASTNode3 != null) {
                LighterASTNode it$iv = lighterASTNode3;
                boolean bl = false;
                firElement3 = this_$iv.convertExpression(it$iv, errorReason$iv);
            } else {
                firElement3 = firElement2 = null;
            }
            if (!(firElement3 instanceof FirElement)) {
                firElement2 = firElement = null;
            }
            if (firElement2 == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(content2 != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv, content2, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                }
                firElement = firErrorExpression;
            }
        } else if (((Intrinsics.areEqual(iElementType, KtNodeTypes.PROPERTY_DELEGATE) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.INDICES)) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.CONDITION)) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.LOOP_RANGE)) {
            FirElement firElement4;
            FirElement firElement5;
            void this_$iv;
            ExpressionsConverter content2 = this;
            LighterASTNode expression$iv = this.getExpressionInParentheses(expression2);
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode4 = expression$iv;
            if (lighterASTNode4 != null) {
                LighterASTNode it$iv = lighterASTNode4;
                boolean bl = false;
                firElement5 = this_$iv.convertExpression(it$iv, errorReason);
            } else {
                firElement5 = firElement4 = null;
            }
            if (!(firElement5 instanceof FirElement)) {
                firElement4 = firElement = null;
            }
            if (firElement4 == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(expression$iv != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv, expression$iv, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                }
                firElement = firErrorExpression;
            }
        } else {
            firElement = Intrinsics.areEqual(iElementType, KtNodeTypes.THIS_EXPRESSION) ? (FirElement)this.convertThisExpression(expression2) : (Intrinsics.areEqual(iElementType, KtNodeTypes.SUPER_EXPRESSION) ? (FirElement)this.convertSuperExpression(expression2) : (Intrinsics.areEqual(iElementType, KtNodeTypes.OBJECT_LITERAL) ? this.declarationsConverter.convertObjectLiteral(expression2) : (Intrinsics.areEqual(iElementType, KtNodeTypes.FUN) ? (FirElement)this.declarationsConverter.convertFunctionDeclaration(expression2) : (FirElement)FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionExpected)))));
        }
        return firElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final FirExpression convertLambdaExpression(LighterASTNode lambdaExpression) {
        FirAnonymousFunctionExpressionBuilder firAnonymousFunctionExpressionBuilder;
        FirBlock firBlock;
        Object object;
        Object object2;
        Object kid$iv;
        void $this$forEachChildren$iv;
        void this_$iv;
        List valueParameterList = new ArrayList();
        LighterASTNode block = null;
        boolean hasArrow = false;
        FirAnonymousFunctionSymbol functionSymbol = new FirAnonymousFunctionSymbol();
        BaseConverter baseConverter = this;
        IElementType iElementType = KtNodeTypes.FUNCTION_LITERAL;
        Intrinsics.checkNotNullExpressionValue(iElementType, "FUNCTION_LITERAL");
        LighterASTNode lighterASTNode2 = CollectionsKt.first(this.getChildNodesByType(lambdaExpression, iElementType));
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        Object kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv);
        int n = ((LighterASTNode[])kidsArray$iv).length;
        for (int i = 0; i < n && (kid$iv = kidsArray$iv[i]) != null; ++i) {
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, (LighterASTNode)kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            object2 = it.getTokenType();
            if (Intrinsics.areEqual(object2, KtNodeTypes.VALUE_PARAMETER_LIST)) {
                CollectionsKt.addAll((Collection)valueParameterList, DeclarationsConverter.convertValueParameters$default(this.declarationsConverter, it, functionSymbol, BaseFirBuilder.ValueParameterDeclaration.LAMBDA, null, 8, null));
                continue;
            }
            if (Intrinsics.areEqual(object2, KtNodeTypes.BLOCK)) {
                block = it;
                continue;
            }
            if (!Intrinsics.areEqual(object2, KtTokens.ARROW)) continue;
            hasArrow = true;
        }
        KtLightSourceElement expressionSource = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, lambdaExpression, null, 1, null);
        FirFunctionTarget target = null;
        boolean $i$f$buildAnonymousFunction = false;
        Object $this$convertLambdaExpression_u24lambda_u249 = kidsArray$iv = new FirAnonymousFunctionBuilder();
        boolean bl = false;
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u249).setSource(expressionSource);
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u249).setModuleData(this.getBaseModuleData());
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u249).setOrigin(FirDeclarationOrigin.Source.INSTANCE);
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u249).setReturnTypeRef(this.getImplicitType());
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u249).setReceiverParameter(ConversionUtilsKt.asReceiverParameter(this.getImplicitType()));
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u249).setSymbol(functionSymbol);
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u249).setLambda(true);
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u249).setHasExplicitParameterList(hasArrow);
        Object object3 = $this$convertLambdaExpression_u24lambda_u249;
        FirLabel firLabel = this.getContext().getLastLabel(lambdaExpression);
        if (firLabel == null) {
            Name name = CollectionsKt.lastOrNull(this.getContext().getCalleeNamesForLambda());
            if (name != null) {
                void it;
                kid$iv = name;
                object = object3;
                boolean bl2 = false;
                boolean $i$f$buildLabel = false;
                Object $this$convertLambdaExpression_u24lambda_u249_u24lambda_u243_u24lambda_u242 = object2 = new FirLabelBuilder();
                boolean bl3 = false;
                ((FirLabelBuilder)$this$convertLambdaExpression_u24lambda_u249_u24lambda_u243_u24lambda_u242).setSource(KtSourceElementKt.fakeElement(expressionSource, KtFakeSourceElementKind.GeneratedLambdaLabel.INSTANCE));
                String string2 = it.asString();
                Intrinsics.checkNotNullExpressionValue(string2, "it.asString()");
                ((FirLabelBuilder)$this$convertLambdaExpression_u24lambda_u249_u24lambda_u243_u24lambda_u242).setName(string2);
                firLabel = ((FirLabelBuilder)object2).build();
                object3 = object;
            } else {
                firLabel = null;
            }
        }
        ((FirAnonymousFunctionBuilder)object3).setLabel(firLabel);
        FirLabel firLabel2 = ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u249).getLabel();
        target = new FirFunctionTarget(firLabel2 != null ? firLabel2.getName() : null, true);
        ((Collection)this.getContext().getFirFunctionTargets()).add(target);
        List destructuringStatements = new ArrayList();
        for (ValueParameter valueParameter2 : valueParameterList) {
            FirValueParameter firValueParameter2;
            Object name;
            DestructuringDeclaration multiDeclaration = valueParameter2.getDestructuringDeclaration();
            Collection bl2 = ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u249).getValueParameters();
            if (multiDeclaration != null) {
                FirValueParameterBuilder bl3;
                name = SpecialNames.DESTRUCT;
                boolean $i$f$buildValueParameter = false;
                FirValueParameterBuilder $this$convertLambdaExpression_u24lambda_u249_u24lambda_u244 = bl3 = new FirValueParameterBuilder();
                boolean bl4 = false;
                $this$convertLambdaExpression_u24lambda_u249_u24lambda_u244.setSource(valueParameter2.getFirValueParameter().getSource());
                $this$convertLambdaExpression_u24lambda_u249_u24lambda_u244.setContainingFunctionSymbol(functionSymbol);
                $this$convertLambdaExpression_u24lambda_u249_u24lambda_u244.setModuleData(this.getBaseModuleData());
                $this$convertLambdaExpression_u24lambda_u249_u24lambda_u244.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                $this$convertLambdaExpression_u24lambda_u249_u24lambda_u244.setReturnTypeRef(valueParameter2.getFirValueParameter().getReturnTypeRef());
                $this$convertLambdaExpression_u24lambda_u249_u24lambda_u244.setName((Name)name);
                $this$convertLambdaExpression_u24lambda_u249_u24lambda_u244.setSymbol(new FirValueParameterSymbol((Name)name));
                $this$convertLambdaExpression_u24lambda_u249_u24lambda_u244.setDefaultValue(null);
                $this$convertLambdaExpression_u24lambda_u249_u24lambda_u244.setCrossinline(false);
                $this$convertLambdaExpression_u24lambda_u249_u24lambda_u244.setNoinline(false);
                $this$convertLambdaExpression_u24lambda_u249_u24lambda_u244.setVararg(false);
                FirValueParameter multiParameter = bl3.build();
                CollectionsKt.addAll((Collection)destructuringStatements, (Iterable)ConverterUtilKt.generateDestructuringBlock(this.getBaseModuleData(), multiDeclaration, multiParameter, false).getStatements());
                firValueParameter2 = multiParameter;
            } else {
                firValueParameter2 = valueParameter2.getFirValueParameter();
            }
            name = firValueParameter2;
            bl2.add(name);
        }
        Object object4 = $this$convertLambdaExpression_u24lambda_u249;
        if (block != null) {
            FirBlock firBlock2;
            void newOffset$iv;
            void this_$iv2;
            DeclarationsConverter declarationsConverter = this.declarationsConverter;
            int valueParameter2 = expressionSource.getStartOffset();
            object = object4;
            boolean $i$f$withOffset = false;
            int oldOffset$iv = this_$iv2.getOffset();
            this_$iv2.setOffset((int)newOffset$iv);
            try {
                boolean bl5 = false;
                Object $this$convertLambdaExpression_u24lambda_u249_u24lambda_u248_u24lambda_u247 = object2 = this.declarationsConverter.convertBlockExpressionWithoutBuilding(block);
                boolean bl6 = false;
                if (((FirBlockBuilder)$this$convertLambdaExpression_u24lambda_u249_u24lambda_u248_u24lambda_u247).getStatements().isEmpty()) {
                    void $this$convertLambdaExpression_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245;
                    FirUnitExpressionBuilder firUnitExpressionBuilder;
                    void $this$convertLambdaExpression_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246;
                    FirReturnExpressionBuilder firReturnExpressionBuilder;
                    boolean $i$f$buildReturnExpression = false;
                    FirReturnExpressionBuilder firReturnExpressionBuilder2 = firReturnExpressionBuilder = new FirReturnExpressionBuilder();
                    List<FirStatement> list2 = ((FirBlockBuilder)$this$convertLambdaExpression_u24lambda_u249_u24lambda_u248_u24lambda_u247).getStatements();
                    boolean bl7 = false;
                    $this$convertLambdaExpression_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246.setSource(KtSourceElementKt.fakeElement(expressionSource, KtFakeSourceElementKind.ImplicitReturn.FromExpressionBody.INSTANCE));
                    $this$convertLambdaExpression_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246.setTarget(target);
                    boolean $i$f$buildUnitExpression = false;
                    FirUnitExpressionBuilder firUnitExpressionBuilder2 = firUnitExpressionBuilder = new FirUnitExpressionBuilder();
                    void var31_48 = $this$convertLambdaExpression_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246;
                    boolean bl8 = false;
                    $this$convertLambdaExpression_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setSource(KtSourceElementKt.fakeElement(expressionSource, KtFakeSourceElementKind.ImplicitUnit.INSTANCE));
                    var31_48.setResult(firUnitExpressionBuilder.build());
                    list2.add(firReturnExpressionBuilder.build());
                }
                ((FirBlockBuilder)$this$convertLambdaExpression_u24lambda_u249_u24lambda_u248_u24lambda_u247).getStatements().addAll(0, destructuringStatements);
                firBlock2 = ((FirBlockBuilder)object2).build();
            }
            finally {
                this_$iv2.setOffset(oldOffset$iv);
            }
            firBlock = firBlock2;
            object4 = object;
        } else {
            FirStatement statement$iv = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Lambda has no body", DiagnosticKind.Syntax));
            boolean $i$f$buildSingleExpressionBlock = false;
            firBlock = new FirSingleExpressionBlock(statement$iv);
        }
        ((FirAnonymousFunctionBuilder)object4).setBody(firBlock);
        this.removeLast(this.getContext().getFirFunctionTargets());
        FirAnonymousFunction it = $i$f$buildAnonymousFunction = ((FirAnonymousFunctionBuilder)kidsArray$iv).build();
        boolean bl9 = false;
        target.bind((FirTargetElement)it);
        FirAnonymousFunction anonymousFunction2 = $i$f$buildAnonymousFunction;
        boolean $i$f$buildAnonymousFunctionExpression = false;
        FirAnonymousFunctionExpressionBuilder $this$convertLambdaExpression_u24lambda_u2411 = firAnonymousFunctionExpressionBuilder = new FirAnonymousFunctionExpressionBuilder();
        boolean bl10 = false;
        $this$convertLambdaExpression_u24lambda_u2411.setSource(expressionSource);
        $this$convertLambdaExpression_u24lambda_u2411.setAnonymousFunction(anonymousFunction2);
        return firAnonymousFunctionExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirStatement convertBinaryExpression(LighterASTNode binaryExpression) {
        FirStatement firStatement;
        FirElement firElement;
        FirElement firElement2;
        FirElement firElement3;
        IElementType this_$iv;
        void expression$iv;
        FirExpression firExpression2;
        ExpressionsConverter expression$iv2;
        IElementType operationToken;
        void $this$forEachChildren$iv;
        void this_$iv2;
        boolean isLeftArgument = false;
        isLeftArgument = true;
        String operationTokenName = null;
        LighterASTNode leftArgNode = null;
        LighterASTNode rightArg = null;
        KtSourceElement operationReferenceSource = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = binaryExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren2 = false;
        for (LighterASTNode kid$iv : this_$iv2.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv2, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.OPERATION_REFERENCE)) {
                isLeftArgument = false;
                operationTokenName = this.getAsText(it);
                operationReferenceSource = BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            if (isLeftArgument) {
                leftArgNode = it;
                continue;
            }
            rightArg = it;
        }
        KtLightSourceElement baseSource = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null);
        String string2 = operationTokenName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("operationTokenName");
            string2 = null;
        }
        if (Intrinsics.areEqual(operationToken = ElementTypeUtils.INSTANCE.getOperationSymbol(string2), KtTokens.IDENTIFIER)) {
            ((Collection)this.getContext().getCalleeNamesForLambda()).add(ConverterUtilKt.nameAsSafeName$default(operationTokenName, null, 1, null));
        }
        if (rightArg != null) {
            FirElement firElement4;
            void this_$iv3;
            ExpressionsConverter $i$f$forEachChildren2 = this;
            LighterASTNode[] kidsArray$iv = rightArg;
            String errorReason$iv = "No right operand";
            boolean $i$f$getAsFirExpression = false;
            void it$iv = expression$iv2;
            boolean bl = false;
            FirElement firElement5 = this_$iv3.convertExpression((LighterASTNode)it$iv, errorReason$iv);
            FirElement firElement6 = firElement5;
            if (!(firElement5 instanceof FirExpression)) {
                firElement6 = null;
            }
            if ((firElement4 = (FirElement)((FirExpression)firElement6)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv3, expression$iv2, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement4 = firErrorExpression;
            }
            firExpression2 = (FirExpression)firElement4;
        } else {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No right operand", DiagnosticKind.Syntax));
        }
        FirExpression rightArgAsFir = firExpression2;
        expression$iv2 = this;
        LighterASTNode errorReason$iv = leftArgNode;
        Object errorReason$iv2 = "No left operand";
        boolean $i$f$getAsFirExpression = false;
        void v6 = expression$iv;
        if (v6 != null) {
            void it$iv = v6;
            boolean bl = false;
            firElement3 = ((ExpressionsConverter)((Object)this_$iv)).convertExpression((LighterASTNode)it$iv, (String)errorReason$iv2);
        } else {
            firElement3 = firElement2 = null;
        }
        if (!(firElement3 instanceof FirExpression)) {
            firElement2 = null;
        }
        if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(expression$iv != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)((Object)this_$iv), expression$iv, null, 1, null) : null, new ConeSimpleDiagnostic((String)errorReason$iv2, DiagnosticKind.ExpressionExpected));
            if (firErrorExpression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
            }
            firElement = firErrorExpression;
        }
        FirExpression leftArgAsFir = (FirExpression)firElement;
        if (Intrinsics.areEqual(operationToken, KtTokens.IDENTIFIER)) {
            this.removeLast(this.getContext().getCalleeNamesForLambda());
        }
        if (Intrinsics.areEqual(this_$iv = operationToken, KtTokens.ELVIS)) {
            return ConversionUtilsKt.generateNotNullOrOther(leftArgAsFir, rightArgAsFir, baseSource);
        }
        if (Intrinsics.areEqual(this_$iv, KtTokens.ANDAND) ? true : Intrinsics.areEqual(this_$iv, KtTokens.OROR)) {
            return ConversionUtilsKt.generateLazyLogicalOperation(leftArgAsFir, rightArgAsFir, Intrinsics.areEqual(operationToken, KtTokens.ANDAND), baseSource);
        }
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.IN_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, "IN_OPERATIONS");
        if (CollectionsKt.contains((Iterable)immutableSet, this_$iv)) {
            return ConversionUtilsKt.generateContainsOperation(rightArgAsFir, leftArgAsFir, Intrinsics.areEqual(operationToken, KtTokens.NOT_IN), baseSource, operationReferenceSource);
        }
        ImmutableSet<KtSingleValueToken> immutableSet2 = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet2, "COMPARISON_OPERATIONS");
        if (CollectionsKt.contains((Iterable)immutableSet2, this_$iv)) {
            return ConversionUtilsKt.generateComparisonExpression(leftArgAsFir, rightArgAsFir, operationToken, baseSource, operationReferenceSource);
        }
        Name conventionCallName = ConversionUtilsKt.toBinaryName(operationToken);
        if (conventionCallName != null || Intrinsics.areEqual(operationToken, KtTokens.IDENTIFIER)) {
            void $this$convertBinaryExpression_u24lambda_u2414_u24lambda_u2413;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
            boolean $i$f$buildFunctionCall = false;
            Object $this$convertBinaryExpression_u24lambda_u2414 = errorReason$iv2 = new FirFunctionCallBuilder();
            boolean bl = false;
            ((FirFunctionCallBuilder)$this$convertBinaryExpression_u24lambda_u2414).setSource(BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null));
            boolean $i$f$buildSimpleNamedReference = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
            Object object = $this$convertBinaryExpression_u24lambda_u2414;
            boolean bl2 = false;
            KtLightSourceElement ktLightSourceElement = (KtLightSourceElement)operationReferenceSource;
            $this$convertBinaryExpression_u24lambda_u2414_u24lambda_u2413.setSource(ktLightSourceElement != null ? (KtSourceElement)ktLightSourceElement : ((FirFunctionCallBuilder)$this$convertBinaryExpression_u24lambda_u2414).getSource());
            Name name = conventionCallName;
            if (name == null) {
                name = ConverterUtilKt.nameAsSafeName$default(operationTokenName, null, 1, null);
            }
            $this$convertBinaryExpression_u24lambda_u2414_u24lambda_u2413.setName(name);
            ((FirFunctionCallBuilder)object).setCalleeReference(firSimpleNamedReferenceBuilder.build());
            ((FirFunctionCallBuilder)$this$convertBinaryExpression_u24lambda_u2414).setExplicitReceiver(leftArgAsFir);
            ((FirFunctionCallBuilder)$this$convertBinaryExpression_u24lambda_u2414).setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(rightArgAsFir));
            ((FirFunctionCallBuilder)$this$convertBinaryExpression_u24lambda_u2414).setOrigin(conventionCallName != null ? FirFunctionCallOrigin.Operator : FirFunctionCallOrigin.Infix);
            firStatement = ((FirFunctionCallBuilder)errorReason$iv2).build();
        } else {
            FirEqualityOperatorCallBuilder firEqualityOperatorCallBuilder;
            FirOperation firOperation = ConversionUtilsKt.toFirOperation(operationToken);
            if (FirOperation.Companion.getASSIGNMENTS().contains((Object)firOperation)) {
                return this.generateAssignment(leftArgNode, BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null), (errorReason$iv2 = leftArgNode) != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, errorReason$iv2, null, 1, null) : null, rightArgAsFir, firOperation, leftArgAsFir.getAnnotations(), rightArg, (Function1)new Function1<LighterASTNode, FirExpression>(this){
                    final /* synthetic */ ExpressionsConverter this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final FirExpression invoke(@NotNull LighterASTNode $this$generateAssignment) {
                        FirElement firElement;
                        Intrinsics.checkNotNullParameter($this$generateAssignment, "$this$generateAssignment");
                        ExpressionsConverter $this$iv = this.this$0;
                        String errorReason$iv = "";
                        boolean $i$f$getAsFirExpression = false;
                        LighterASTNode it$iv = $this$generateAssignment;
                        boolean bl = false;
                        FirElement firElement2 = $this$iv.convertExpression(it$iv, errorReason$iv);
                        FirElement firElement3 = firElement2;
                        if (!(firElement2 instanceof FirExpression)) {
                            firElement3 = null;
                        }
                        if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default($this$iv, $this$generateAssignment, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                            if (firErrorExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                            }
                            firElement = firErrorExpression;
                        }
                        return (FirExpression)firElement;
                    }
                });
            }
            boolean $i$f$buildEqualityOperatorCall = false;
            FirEqualityOperatorCallBuilder $this$convertBinaryExpression_u24lambda_u2415 = firEqualityOperatorCallBuilder = new FirEqualityOperatorCallBuilder();
            boolean bl = false;
            $this$convertBinaryExpression_u24lambda_u2415.setSource(BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null));
            $this$convertBinaryExpression_u24lambda_u2415.setOperation(firOperation);
            $this$convertBinaryExpression_u24lambda_u2415.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(leftArgAsFir, rightArgAsFir));
            firStatement = firEqualityOperatorCallBuilder.build();
        }
        return firStatement;
    }

    /*
     * WARNING - void declaration
     */
    private final FirTypeOperatorCall convertBinaryWithTypeRHSExpression(LighterASTNode binaryExpression, Function1<? super String, ? extends FirOperation> toFirOperation) {
        void $this$forEachChildren$iv;
        void this_$iv;
        String operationTokenName = null;
        FirElement leftArgAsFir = null;
        FirTypeRef firType = null;
        BaseConverter baseConverter = this;
        Object object = binaryExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.OPERATION_REFERENCE)) {
                operationTokenName = this.getAsText(it);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.TYPE_REFERENCE)) {
                firType = this.declarationsConverter.convertType(it);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No left operand";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirExpression)) {
                firElement3 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            leftArgAsFir = firElement;
        }
        boolean $i$f$buildTypeOperatorCall = false;
        Object $this$convertBinaryWithTypeRHSExpression_u24lambda_u2417 = object = new FirTypeOperatorCallBuilder();
        boolean bl = false;
        ((FirTypeOperatorCallBuilder)$this$convertBinaryWithTypeRHSExpression_u24lambda_u2417).setSource(BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null));
        String string2 = operationTokenName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("operationTokenName");
            string2 = null;
        }
        ((FirTypeOperatorCallBuilder)$this$convertBinaryWithTypeRHSExpression_u24lambda_u2417).setOperation(toFirOperation.invoke(string2));
        FirTypeRef firTypeRef = firType;
        if (firTypeRef == null) {
            Intrinsics.throwUninitializedPropertyAccessException("firType");
            firTypeRef = null;
        }
        ((FirTypeOperatorCallBuilder)$this$convertBinaryWithTypeRHSExpression_u24lambda_u2417).setConversionTypeRef(firTypeRef);
        FirExpression firExpression2 = (FirExpression)leftArgAsFir;
        if (firExpression2 == null) {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No left operand", DiagnosticKind.Syntax));
        }
        ((FirTypeOperatorCallBuilder)$this$convertBinaryWithTypeRHSExpression_u24lambda_u2417).setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(firExpression2));
        return ((FirTypeOperatorCallBuilder)object).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertLabeledExpression(LighterASTNode labeledExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement firExpression2 = null;
        KtSourceElement errorLabelSource = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = labeledExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            this.getContext().setNewLabelUserNode(it);
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.LABEL_QUALIFIER)) {
                String rawName = it.toString();
                String string2 = rawName.substring(0, rawName.length() - 1);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                BaseFirBuilder baseFirBuilder = this;
                IElementType iElementType2 = KtNodeTypes.LABEL;
                Intrinsics.checkNotNullExpressionValue(iElementType2, "LABEL");
                Pair<FirLabel, KtSourceElement> pair = this.buildLabelAndErrorSource(string2, BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, CollectionsKt.single(this.getChildNodesByType(it, iElementType2)), null, 1, null));
                this.getContext().addNewLabel(pair.getFirst());
                errorLabelSource = pair.getSecond();
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) {
                firExpression2 = this.declarationsConverter.convertBlock(it);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.PROPERTY)) {
                firExpression2 = DeclarationsConverter.convertPropertyDeclaration$default(this.declarationsConverter, it, null, 2, null);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            String errorReason$iv = "";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement firElement2 = this.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirElement)) {
                firElement3 = firElement = null;
            }
            if (firElement3 == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = firElement;
        }
        this.getContext().dropLastLabel();
        return this.buildExpressionWithErrorLabel(firExpression2, errorLabelSource, BaseFirBuilder.toFirSourceElement$default(this, labeledExpression, null, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertUnaryExpression(LighterASTNode unaryExpression) {
        FirExpression firExpression2;
        FirCheckNotNullCallBuilder $this$convertUnaryExpression_u24lambda_u2420;
        void $this$forEachChildren$iv;
        void this_$iv;
        String operationTokenName = null;
        LighterASTNode argument2 = null;
        LighterASTNode operationReference = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = unaryExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren2 = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.OPERATION_REFERENCE)) {
                operationReference = it;
                operationTokenName = this.getAsText(it);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            argument2 = it;
        }
        String string2 = operationTokenName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("operationTokenName");
            string2 = null;
        }
        IElementType operationToken = ElementTypeUtils.INSTANCE.getOperationSymbol(string2);
        Name conventionCallName = ConversionUtilsKt.toUnaryName(operationToken);
        if (Intrinsics.areEqual(operationToken, KtTokens.EXCLEXCL)) {
            FirElement firElement;
            FirElement firElement2;
            FirElement firElement3;
            void this_$iv2;
            void expression$iv;
            LighterASTNode kid$iv;
            boolean $i$f$buildCheckNotNullCall = false;
            $this$convertUnaryExpression_u24lambda_u2420 = $i$f$forEachChildren2 = new FirCheckNotNullCallBuilder();
            boolean bl = false;
            $this$convertUnaryExpression_u24lambda_u2420.setSource(BaseFirBuilder.toFirSourceElement$default(this, unaryExpression, null, 1, null));
            ExpressionsConverter expressionsConverter = this;
            kid$iv = argument2;
            String errorReason$iv = "No operand";
            boolean $i$f$getAsFirExpression2 = false;
            void v1 = expression$iv;
            if (v1 != null) {
                void it$iv = v1;
                boolean bl2 = false;
                firElement3 = this_$iv2.convertExpression((LighterASTNode)it$iv, errorReason$iv);
            } else {
                firElement3 = firElement2 = null;
            }
            if (!(firElement3 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(expression$iv != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, expression$iv, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            $this$convertUnaryExpression_u24lambda_u2420.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList((FirExpression)firElement));
            firExpression2 = $i$f$forEachChildren2.build();
        } else if (conventionCallName != null) {
            KtLightSourceElement ktLightSourceElement;
            void $this$convertUnaryExpression_u24lambda_u2423_u24lambda_u2422;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
            FirFunctionCallBuilder firFunctionCallBuilder;
            FirExpression receiver;
            FirElement firElement;
            FirElement firElement4;
            FirElement firElement5;
            FirExpression this_$iv3;
            void expression$iv;
            ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.INCREMENT_OPERATIONS;
            Intrinsics.checkNotNullExpressionValue(immutableSet, "INCREMENT_OPERATIONS");
            if (CollectionsKt.contains((Iterable)immutableSet, operationToken)) {
                return this.generateIncrementOrDecrementBlock(unaryExpression, operationReference, argument2, conventionCallName, Intrinsics.areEqual(unaryExpression.getTokenType(), KtNodeTypes.PREFIX_EXPRESSION), (Function1)new Function1<LighterASTNode, FirExpression>(this){
                    final /* synthetic */ ExpressionsConverter this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final FirExpression invoke(@NotNull LighterASTNode $this$generateIncrementOrDecrementBlock) {
                        FirElement firElement;
                        Intrinsics.checkNotNullParameter($this$generateIncrementOrDecrementBlock, "$this$generateIncrementOrDecrementBlock");
                        ExpressionsConverter $this$iv = this.this$0;
                        String errorReason$iv = "";
                        boolean $i$f$getAsFirExpression = false;
                        LighterASTNode it$iv = $this$generateIncrementOrDecrementBlock;
                        boolean bl = false;
                        FirElement firElement2 = $this$iv.convertExpression(it$iv, errorReason$iv);
                        FirElement firElement3 = firElement2;
                        if (!(firElement2 instanceof FirExpression)) {
                            firElement3 = null;
                        }
                        if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default($this$iv, $this$generateIncrementOrDecrementBlock, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                            if (firErrorExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                            }
                            firElement = firErrorExpression;
                        }
                        return (FirExpression)firElement;
                    }
                });
            }
            ExpressionsConverter $i$f$forEachChildren2 = this;
            $this$convertUnaryExpression_u24lambda_u2420 = argument2;
            String errorReason$iv = "No operand";
            boolean $i$f$getAsFirExpression = false;
            void v8 = expression$iv;
            if (v8 != null) {
                void it$iv = v8;
                boolean bl = false;
                firElement5 = ((ExpressionsConverter)((Object)this_$iv3)).convertExpression((LighterASTNode)it$iv, errorReason$iv);
            } else {
                firElement5 = firElement4 = null;
            }
            if (!(firElement5 instanceof FirExpression)) {
                firElement4 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement4)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(expression$iv != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)((Object)this_$iv3), expression$iv, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            if ((this_$iv3 = this.convertUnaryPlusMinusCallOnIntegerLiteralIfNecessary(unaryExpression, receiver = (FirExpression)firElement, operationToken)) != null) {
                FirExpression it = this_$iv3;
                boolean bl = false;
                return it;
            }
            boolean $i$f$buildFunctionCall = false;
            FirFunctionCallBuilder $this$convertUnaryExpression_u24lambda_u2423 = firFunctionCallBuilder = new FirFunctionCallBuilder();
            boolean bl = false;
            $this$convertUnaryExpression_u24lambda_u2423.setSource(BaseFirBuilder.toFirSourceElement$default(this, unaryExpression, null, 1, null));
            boolean $i$f$buildSimpleNamedReference = false;
            FirSimpleNamedReferenceBuilder $i$f$getAsFirExpression2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
            FirFunctionCallBuilder firFunctionCallBuilder2 = $this$convertUnaryExpression_u24lambda_u2423;
            boolean bl3 = false;
            LighterASTNode lighterASTNode3 = operationReference;
            $this$convertUnaryExpression_u24lambda_u2423_u24lambda_u2422.setSource(lighterASTNode3 != null && (ktLightSourceElement = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, lighterASTNode3, null, 1, null)) != null ? (KtSourceElement)ktLightSourceElement : $this$convertUnaryExpression_u24lambda_u2423.getSource());
            $this$convertUnaryExpression_u24lambda_u2423_u24lambda_u2422.setName(conventionCallName);
            firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
            $this$convertUnaryExpression_u24lambda_u2423.setExplicitReceiver(receiver);
            $this$convertUnaryExpression_u24lambda_u2423.setOrigin(FirFunctionCallOrigin.Operator);
            firExpression2 = firFunctionCallBuilder.build();
        } else {
            throw new IllegalStateException("Unexpected expression: " + this.getAsText(unaryExpression));
        }
        return firExpression2;
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertAnnotatedExpression(LighterASTNode annotatedExpression) {
        FirElement result2;
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement firExpression2 = null;
        List firAnnotationList = new ArrayList();
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = annotatedExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.ANNOTATION)) {
                CollectionsKt.addAll((Collection)firAnnotationList, (Iterable)this.declarationsConverter.convertAnnotation(it));
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.ANNOTATION_ENTRY)) {
                ((Collection)firAnnotationList).add(DeclarationsConverter.convertAnnotationEntry$default(this.declarationsConverter, it, null, null, 6, null));
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) {
                firExpression2 = this.declarationsConverter.convertBlockExpression(it);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            this.getContext().forwardLabelUsagePermission(annotatedExpression, it);
            String errorReason$iv = "";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement firElement2 = this.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirElement)) {
                firElement3 = firElement = null;
            }
            if (firElement3 == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = firElement;
        }
        FirElement firElement = firExpression2;
        if (firElement == null) {
            firElement = FirExpressionUtilKt.buildErrorExpression(null, new ConeNotAnnotationContainer("???"));
        }
        if (!((result2 = firElement) instanceof FirAnnotationContainer)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ((FirAnnotationContainer)result2).replaceAnnotations(UtilsKt.smartPlus(((FirAnnotationContainer)result2).getAnnotations(), firAnnotationList));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertClassLiteralExpression(LighterASTNode classLiteralExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement firReceiverExpression = null;
        BaseConverter baseConverter = this;
        Object object = classLiteralExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No receiver in class literal";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirExpression)) {
                firElement3 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firReceiverExpression = firElement;
        }
        boolean $i$f$buildGetClassCall = false;
        Object $this$convertClassLiteralExpression_u24lambda_u2426 = object = new FirGetClassCallBuilder();
        boolean bl = false;
        ((FirGetClassCallBuilder)$this$convertClassLiteralExpression_u24lambda_u2426).setSource(BaseFirBuilder.toFirSourceElement$default(this, classLiteralExpression, null, 1, null));
        FirExpression firExpression2 = (FirExpression)firReceiverExpression;
        if (firExpression2 == null) {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No receiver in class literal", DiagnosticKind.Syntax));
        }
        ((FirGetClassCallBuilder)$this$convertClassLiteralExpression_u24lambda_u2426).setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(firExpression2));
        return ((FirGetClassCallBuilder)object).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertCallableReferenceExpression(LighterASTNode callableReferenceExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        boolean isReceiver = false;
        isReceiver = true;
        boolean hasQuestionMarkAtLHS = false;
        FirElement firReceiverExpression = null;
        FirNamedReference namedReference = null;
        BaseConverter baseConverter = this;
        Object object = callableReferenceExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtTokens.COLONCOLON)) {
                isReceiver = false;
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtTokens.QUEST)) {
                hasQuestionMarkAtLHS = true;
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            if (isReceiver) {
                FirElement firElement;
                void this_$iv2;
                ExpressionsConverter expressionsConverter = this;
                String errorReason$iv = "Incorrect receiver expression";
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode it$iv = it;
                boolean bl2 = false;
                FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
                FirElement firElement3 = firElement2;
                if (!(firElement2 instanceof FirExpression)) {
                    firElement3 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                firReceiverExpression = firElement;
                continue;
            }
            namedReference = this.createSimpleNamedReference(BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null), it);
        }
        boolean $i$f$buildCallableReferenceAccess = false;
        Object $this$convertCallableReferenceExpression_u24lambda_u2428 = object = new FirCallableReferenceAccessBuilder();
        boolean bl = false;
        ((FirCallableReferenceAccessBuilder)$this$convertCallableReferenceExpression_u24lambda_u2428).setSource(BaseFirBuilder.toFirSourceElement$default(this, callableReferenceExpression, null, 1, null));
        FirNamedReference firNamedReference = namedReference;
        if (firNamedReference == null) {
            Intrinsics.throwUninitializedPropertyAccessException("namedReference");
            firNamedReference = null;
        }
        ((FirCallableReferenceAccessBuilder)$this$convertCallableReferenceExpression_u24lambda_u2428).setCalleeReference(firNamedReference);
        ((FirCallableReferenceAccessBuilder)$this$convertCallableReferenceExpression_u24lambda_u2428).setExplicitReceiver((FirExpression)firReceiverExpression);
        ((FirCallableReferenceAccessBuilder)$this$convertCallableReferenceExpression_u24lambda_u2428).setHasQuestionMarkAtLHS(hasQuestionMarkAtLHS);
        return ((FirCallableReferenceAccessBuilder)object).build();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final FirExpression convertQualifiedExpression(LighterASTNode dotQualifiedExpression) {
        isSelector = false;
        isSafe = false;
        firSelector = new Ref.ObjectRef<T>();
        firReceiver = null;
        var6_6 = this;
        var7_7 = dotQualifiedExpression;
        skipTokens$iv = new KtToken[]{};
        $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            block15: {
                if (kid$iv == null) break;
                tokenType$iv = kid$iv.getTokenType();
                if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
                if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                    BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                    continue;
                }
                it = kid$iv;
                $i$a$-forEachChildren-ExpressionsConverter$convertQualifiedExpression$1 = false;
                tokenType = it.getTokenType();
                if (Intrinsics.areEqual(tokenType, KtTokens.DOT)) {
                    isSelector = true;
                    continue;
                }
                if (Intrinsics.areEqual(tokenType, KtTokens.SAFE_ACCESS)) {
                    isSafe = true;
                    isSelector = true;
                    continue;
                }
                isEffectiveSelector = isSelector != false && Intrinsics.areEqual(tokenType, TokenType.ERROR_ELEMENT) == false;
                var19_29 = this;
                errorReason$iv = "Incorrect " + (isEffectiveSelector != false ? "selector" : "receiver") + " expression";
                $i$f$getAsFirExpression = false;
                it$iv = it;
                $i$a$-let-ExpressionsConverter$getAsFirExpression$1$iv = false;
                v0 = this_$iv.convertExpression((LighterASTNode)it$iv, errorReason$iv);
                v1 = v0;
                if (!(v0 instanceof FirExpression)) {
                    v1 = null;
                }
                if ((v2 = (FirElement)((FirExpression)v1)) == null) {
                    v3 = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                    if (v3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    v2 = v3;
                }
                firExpression = (FirExpression)v2;
                if (!isEffectiveSelector) break block15;
                callExpressionCallee = Intrinsics.areEqual(tokenType, KtNodeTypes.CALL_EXPRESSION) != false ? this.getFirstChildExpressionUnwrapped(it) : null;
                v4 = firSelector;
                if (tokenType instanceof KtNameReferenceExpressionElementType) ** GOTO lbl-1000
                if (Intrinsics.areEqual(tokenType, KtNodeTypes.CALL_EXPRESSION)) {
                    v5 = callExpressionCallee;
                    ** if (Intrinsics.areEqual((Object)(v5 != null ? v5.getTokenType() : null), (Object)KtNodeTypes.LAMBDA_EXPRESSION)) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    v6 = firExpression;
                    ** GOTO lbl66
                }
lbl-1000:
                // 2 sources

                {
                    $i$f$buildErrorExpression = false;
                    var21_33 = new FirErrorExpressionBuilder();
                    it$iv = var21_33;
                    var25_37 = v4;
                    $i$a$-buildErrorExpression-ExpressionsConverter$convertQualifiedExpression$1$1 = false;
                    $this$convertQualifiedExpression_u24lambda_u2430_u24lambda_u2429.setSource(callExpressionCallee != null && (var26_38 = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, callExpressionCallee, null, 1, null)) != null ? (KtSourceElement)var26_38 : BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null));
                    $this$convertQualifiedExpression_u24lambda_u2430_u24lambda_u2429.setDiagnostic(new ConeSimpleDiagnostic("The expression cannot be a selector (occur after a dot)", callExpressionCallee == null ? DiagnosticKind.IllegalSelector : DiagnosticKind.NoReceiverAllowed));
                    $this$convertQualifiedExpression_u24lambda_u2430_u24lambda_u2429.setExpression(firExpression);
                    v4 = var25_37;
                    v6 = var21_33.build();
                }
lbl66:
                // 2 sources

                v4.element = v6;
                continue;
            }
            firReceiver = firExpression;
        }
        result = null;
        result = (FirExpression)firSelector.element;
        var8_8 /* !! */  = firSelector.element;
        v7 = var8_8 /* !! */  instanceof FirQualifiedAccess != false ? (FirQualifiedAccess)var8_8 /* !! */  : null;
        if (v7 != null) {
            it = v7;
            $i$a$-let-ExpressionsConverter$convertQualifiedExpression$2 = false;
            if (isSafe) {
                it.replaceSource(this.toFirSourceElement(dotQualifiedExpression, (KtFakeSourceElementKind)KtFakeSourceElementKind.DesugaredSafeCallExpression.INSTANCE));
                v8 = firReceiver;
                Intrinsics.checkNotNull(v8);
                return ConversionUtilsKt.createSafeCall(it, v8, BaseFirBuilder.toFirSourceElement$default(this, dotQualifiedExpression, null, 1, null));
            }
            v9 = BaseFirBuilder.toFirSourceElement$default(this, dotQualifiedExpression, null, 1, null);
            v10 = firReceiver;
            Intrinsics.checkNotNull(v10);
            var11_18 = this.convertFirSelector(it, v9, v10);
            result = var11_18 instanceof FirExpression != false ? (FirExpression)var11_18 : null;
        }
        receiver = firReceiver;
        if (receiver != null) {
            it = firSelector.element;
            v11 /* !! */  = var8_8 /* !! */  = it instanceof FirErrorExpression != false ? (FirErrorExpression)it : null;
            if (var8_8 /* !! */  != null) {
                errorExpression /* !! */  = var8_8 /* !! */ ;
                $i$a$-let-ExpressionsConverter$convertQualifiedExpression$3 = false;
                $i$f$buildQualifiedErrorAccessExpression = false;
                $this$convertQualifiedExpression_u24lambda_u2433_u24lambda_u2432 = var13_22 = new FirQualifiedErrorAccessExpressionBuilder();
                $i$a$-buildQualifiedErrorAccessExpression-ExpressionsConverter$convertQualifiedExpression$3$1 = false;
                $this$convertQualifiedExpression_u24lambda_u2433_u24lambda_u2432.setReceiver(receiver);
                $this$convertQualifiedExpression_u24lambda_u2433_u24lambda_u2432.setSelector((FirErrorExpression)errorExpression /* !! */ );
                $this$convertQualifiedExpression_u24lambda_u2433_u24lambda_u2432.setSource(BaseFirBuilder.toFirSourceElement$default(this, dotQualifiedExpression, null, 1, null));
                $this$convertQualifiedExpression_u24lambda_u2433_u24lambda_u2432.setDiagnostic(new ConeSimpleDiagnostic("Qualified expression with unexpected selector", DiagnosticKind.Syntax));
                return var13_22.build();
            }
        }
        if ((v12 = (FirExpression)result) == null) {
            $i$f$buildErrorExpression = false;
            $this$convertQualifiedExpression_u24lambda_u2434 = var10_16 = new FirErrorExpressionBuilder();
            $i$a$-buildErrorExpression-ExpressionsConverter$convertQualifiedExpression$4 = false;
            $this$convertQualifiedExpression_u24lambda_u2434.setSource(null);
            $this$convertQualifiedExpression_u24lambda_u2434.setDiagnostic(new ConeSimpleDiagnostic("Qualified expression without selector", DiagnosticKind.Syntax));
            $this$convertQualifiedExpression_u24lambda_u2434.setExpression(firReceiver);
            v12 = var10_16.build();
        }
        return v12;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertCallExpression(LighterASTNode callSuffix) {
        FirQualifiedAccessBuilder builder2;
        FirQualifiedAccessBuilder firQualifiedAccessBuilder;
        Object object;
        FirQualifiedAccessBuilder firQualifiedAccessBuilder2;
        boolean $i$f$buildErrorNamedReference;
        CalleeAndReceiver calleeAndReceiver;
        boolean bl;
        Object $i$f$forEachChildren22;
        boolean $i$f$buildSimpleNamedReference;
        void $this$forEachChildren$iv;
        void this_$iv;
        Ref.ObjectRef<String> name = new Ref.ObjectRef<String>();
        List firTypeArguments = new ArrayList();
        List valueArguments = new ArrayList();
        Ref.ObjectRef<FirExpression> additionalArgument = new Ref.ObjectRef<FirExpression>();
        Ref.BooleanRef hasArguments = new Ref.BooleanRef();
        Ref.ObjectRef<LighterASTNode> superNode = new Ref.ObjectRef<LighterASTNode>();
        BaseConverter baseConverter = this;
        Object object2 = callSuffix;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren22 = false;
        for (LighterASTNode firQualifiedAccessBuilder3 : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (firQualifiedAccessBuilder3 == null) break;
            IElementType tokenType$iv = firQualifiedAccessBuilder3.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, firQualifiedAccessBuilder3);
                continue;
            }
            LighterASTNode child = firQualifiedAccessBuilder3;
            boolean bl62 = false;
            ExpressionsConverter.convertCallExpression$lambda$37$process(name, this, superNode, firTypeArguments, hasArguments, valueArguments, additionalArgument, child);
        }
        KtLightSourceElement source = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, callSuffix, null, 1, null);
        if (name.element != null) {
            KtLightSourceElement ktLightSourceElement;
            $i$f$buildSimpleNamedReference = false;
            $i$f$forEachChildren22 = new FirSimpleNamedReferenceBuilder();
            FirSimpleNamedReferenceBuilder $this$convertCallExpression_u24lambda_u2438 = $i$f$forEachChildren22;
            bl = false;
            LighterASTNode lighterASTNode2 = this.getFirstChildExpressionUnwrapped(callSuffix);
            $this$convertCallExpression_u24lambda_u2438.setSource(lighterASTNode2 != null && (ktLightSourceElement = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, lighterASTNode2, null, 1, null)) != null ? (KtSourceElement)ktLightSourceElement : (KtSourceElement)source);
            $this$convertCallExpression_u24lambda_u2438.setName(ConverterUtilKt.nameAsSafeName$default((String)name.element, null, 1, null));
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 6;
            boolean bl2 = false;
            FirExpression firExpression2 = null;
            FirNamedReference firNamedReference = ((FirSimpleNamedReferenceBuilder)$i$f$forEachChildren22).build();
            calleeAndReceiver = new CalleeAndReceiver(firNamedReference, firExpression2, bl2, n, defaultConstructorMarker);
        } else if (additionalArgument.element != null) {
            $i$f$buildSimpleNamedReference = false;
            $i$f$forEachChildren22 = new FirSimpleNamedReferenceBuilder();
            FirSimpleNamedReferenceBuilder $this$convertCallExpression_u24lambda_u2439 = $i$f$forEachChildren22;
            bl = false;
            $this$convertCallExpression_u24lambda_u2439.setSource(source);
            $this$convertCallExpression_u24lambda_u2439.setName(OperatorNameConventions.INVOKE);
            FirNamedReference firNamedReference = ((FirSimpleNamedReferenceBuilder)$i$f$forEachChildren22).build();
            Object t = additionalArgument.element;
            Intrinsics.checkNotNull(t);
            boolean bl3 = true;
            FirExpression firExpression3 = (FirExpression)t;
            FirNamedReference firNamedReference2 = firNamedReference;
            calleeAndReceiver = new CalleeAndReceiver(firNamedReference2, firExpression3, bl3);
        } else if (superNode.element != null) {
            $i$f$buildErrorNamedReference = false;
            Object $this$convertCallExpression_u24lambda_u2440 = $i$f$forEachChildren22 = new FirErrorNamedReferenceBuilder();
            bl = false;
            Object t = superNode.element;
            Intrinsics.checkNotNull(t);
            LighterASTNode node = (LighterASTNode)t;
            ((FirErrorNamedReferenceBuilder)$this$convertCallExpression_u24lambda_u2440).setSource(BaseFirBuilder.toFirSourceElement$default(this, node, null, 1, null));
            ((FirErrorNamedReferenceBuilder)$this$convertCallExpression_u24lambda_u2440).setDiagnostic(new ConeSimpleDiagnostic("Super cannot be a callee", DiagnosticKind.SuperNotAllowed));
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 6;
            boolean bl4 = false;
            FirExpression firExpression4 = null;
            FirNamedReference firNamedReference = ((FirErrorNamedReferenceBuilder)$i$f$forEachChildren22).build();
            calleeAndReceiver = new CalleeAndReceiver(firNamedReference, firExpression4, bl4, n, defaultConstructorMarker);
        } else {
            $i$f$buildErrorNamedReference = false;
            Object $this$convertCallExpression_u24lambda_u2441 = $i$f$forEachChildren22 = new FirErrorNamedReferenceBuilder();
            bl = false;
            ((FirErrorNamedReferenceBuilder)$this$convertCallExpression_u24lambda_u2441).setSource(source);
            ((FirErrorNamedReferenceBuilder)$this$convertCallExpression_u24lambda_u2441).setDiagnostic(new ConeSimpleDiagnostic("Call has no callee", DiagnosticKind.Syntax));
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 6;
            boolean bl5 = false;
            FirExpression firExpression5 = null;
            FirNamedReference firNamedReference = ((FirErrorNamedReferenceBuilder)$i$f$forEachChildren22).build();
            calleeAndReceiver = new CalleeAndReceiver(firNamedReference, firExpression5, bl5, n, defaultConstructorMarker);
        }
        object2 = calleeAndReceiver;
        FirNamedReference calleeReference = ((CalleeAndReceiver)object2).component1();
        FirExpression explicitReceiver = ((CalleeAndReceiver)object2).component2();
        boolean isImplicitInvoke = ((CalleeAndReceiver)object2).component3();
        if (hasArguments.element) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            FirAnnotationContainerBuilder builder3;
            FirAnnotationContainerBuilder firAnnotationContainerBuilder;
            FirAnnotationContainerBuilder $this$convertCallExpression_u24lambda_u2443 = firAnnotationContainerBuilder = (builder3 = isImplicitInvoke ? new FirImplicitInvokeCallBuilder() : new FirFunctionCallBuilder());
            boolean bl6 = false;
            ((FirAbstractFunctionCallBuilder)((Object)$this$convertCallExpression_u24lambda_u2443)).setSource(source);
            ((FirAbstractFunctionCallBuilder)((Object)$this$convertCallExpression_u24lambda_u2443)).setCalleeReference(calleeReference);
            ((Collection)this.getContext().getCalleeNamesForLambda()).add(calleeReference.getName());
            Iterable bl62 = valueArguments;
            FirCallBuilder firCallBuilder = $this$convertCallExpression_u24lambda_u2443;
            boolean $i$f$flatMap = false;
            void var21_58 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                LighterASTNode it = (LighterASTNode)element$iv$iv;
                boolean bl7 = false;
                Iterable list$iv$iv = this.convertValueArguments(it);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            ConverterUtilKt.extractArgumentsFrom(firCallBuilder, (List)destination$iv$iv);
            this.removeLast(this.getContext().getCalleeNamesForLambda());
            firQualifiedAccessBuilder2 = firAnnotationContainerBuilder;
        } else {
            object = new FirPropertyAccessExpressionBuilder();
            FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder = object;
            boolean bl7 = false;
            firPropertyAccessExpressionBuilder.setSource(source);
            firPropertyAccessExpressionBuilder.setCalleeReference(calleeReference);
            firQualifiedAccessBuilder2 = (FirQualifiedAccessBuilder)object;
        }
        FirQualifiedAccessBuilder $this$convertCallExpression_u24lambda_u2445 = firQualifiedAccessBuilder = (builder2 = firQualifiedAccessBuilder2);
        boolean bl8 = false;
        $this$convertCallExpression_u24lambda_u2445.setExplicitReceiver(explicitReceiver);
        CollectionsKt.addAll((Collection)$this$convertCallExpression_u24lambda_u2445.getTypeArguments(), firTypeArguments);
        object = firQualifiedAccessBuilder.build();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
        return (FirExpression)object;
    }

    private final FirExpression convertStringTemplate(LighterASTNode stringTemplate) {
        return BaseFirBuilder.toInterpolatingCall$default(this, this.getChildrenAsArray(stringTemplate), stringTemplate, null, new Function2<LighterASTNode, String, FirExpression>(this){
            final /* synthetic */ ExpressionsConverter this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final FirExpression invoke(@Nullable LighterASTNode $this$toInterpolatingCall, @NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return ExpressionsConverter.access$convertShortOrLongStringTemplate(this.this$0, $this$toInterpolatingCall, it);
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertShortOrLongStringTemplate(LighterASTNode $this$convertShortOrLongStringTemplate, String errorReason) {
        FirExpression firExpression2;
        FirElement firExpression3 = null;
        if ($this$convertShortOrLongStringTemplate != null) {
            void $this$forEachChildren$iv;
            void this_$iv;
            BaseConverter baseConverter = this;
            LighterASTNode lighterASTNode2 = $this$convertShortOrLongStringTemplate;
            KtToken[] ktTokenArray = new KtToken[2];
            Intrinsics.checkNotNullExpressionValue(KtTokens.LONG_TEMPLATE_ENTRY_START, "LONG_TEMPLATE_ENTRY_START");
            Intrinsics.checkNotNullExpressionValue(KtTokens.LONG_TEMPLATE_ENTRY_END, "LONG_TEMPLATE_ENTRY_END");
            KtToken[] skipTokens$iv = ktTokenArray;
            boolean $i$f$forEachChildren = false;
            for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
                FirElement firElement;
                if (kid$iv == null) break;
                IElementType tokenType$iv = kid$iv.getTokenType();
                if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
                if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                    BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                    continue;
                }
                LighterASTNode it = kid$iv;
                boolean bl = false;
                ExpressionsConverter this_$iv2 = this;
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode it$iv = it;
                boolean bl2 = false;
                FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason);
                FirElement firElement3 = firElement2;
                if (!(firElement2 instanceof FirExpression)) {
                    firElement3 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionExpected));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                firExpression3 = firElement;
            }
        }
        if ((firExpression2 = (FirExpression)firExpression3) == null) {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.Syntax));
        }
        return firExpression2;
    }

    private final FirExpression convertConstantExpression(LighterASTNode constantExpression) {
        return this.generateConstantExpressionByLiteral(constantExpression);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenExpression(LighterASTNode whenExpression) {
        FirWhenExpression firWhenExpression;
        FirPropertyBuilder $this$convertWhenExpression_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        Object object;
        Object it;
        Object tokenType$iv;
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement subjectExpression = null;
        Ref.ObjectRef subjectVariable = new Ref.ObjectRef();
        List whenEntryNodes = new ArrayList();
        List whenEntries = new ArrayList();
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = whenExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            ExpressionsConverter this_$iv2;
            boolean $i$f$getAsFirExpression;
            String errorReason$iv;
            if (kid$iv == null) break;
            tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains((IElementType)tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            it = kid$iv;
            boolean bl = false;
            object = it.getTokenType();
            if (Intrinsics.areEqual(object, KtNodeTypes.PROPERTY)) {
                void variable2;
                FirDeclaration firDeclaration = DeclarationsConverter.convertPropertyDeclaration$default(this.declarationsConverter, (LighterASTNode)it, null, 2, null);
                Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirVariable");
                FirVariable firVariable = (FirVariable)firDeclaration;
                Ref.ObjectRef objectRef = subjectVariable;
                boolean bl2 = false;
                boolean $i$f$buildProperty = false;
                firAnnotationContainerBuilder = new FirPropertyBuilder();
                $this$convertWhenExpression_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447 = firAnnotationContainerBuilder;
                boolean bl3 = false;
                $this$convertWhenExpression_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447.setSource(BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null));
                $this$convertWhenExpression_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                $this$convertWhenExpression_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447.setModuleData(this.getBaseModuleData());
                $this$convertWhenExpression_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447.setReturnTypeRef(variable2.getReturnTypeRef());
                $this$convertWhenExpression_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447.setName(variable2.getName());
                $this$convertWhenExpression_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447.setInitializer(variable2.getInitializer());
                $this$convertWhenExpression_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447.setVar(false);
                $this$convertWhenExpression_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447.setSymbol(new FirPropertySymbol(variable2.getName()));
                $this$convertWhenExpression_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447.setLocal(true);
                $this$convertWhenExpression_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447.setStatus(new FirDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL));
                objectRef.element = ((FirPropertyBuilder)firAnnotationContainerBuilder).build();
                continue;
            }
            if (Intrinsics.areEqual(object, KtNodeTypes.DESTRUCTURING_DECLARATION)) {
                FirElement firElement2;
                ExpressionsConverter expressionsConverter = this;
                errorReason$iv = "Incorrect when subject expression: " + this.getAsText(whenExpression);
                $i$f$getAsFirExpression = false;
                Object it$iv = it;
                boolean bl4 = false;
                FirElement firElement3 = this_$iv2.convertExpression((LighterASTNode)it$iv, errorReason$iv);
                FirElement firElement4 = firElement3;
                if (!(firElement3 instanceof FirExpression)) {
                    firElement4 = null;
                }
                if ((firElement2 = (FirElement)((FirExpression)firElement4)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement2 = firErrorExpression;
                }
                subjectExpression = firElement2;
                continue;
            }
            if (Intrinsics.areEqual(object, KtNodeTypes.WHEN_ENTRY)) {
                ((Collection)whenEntryNodes).add(it);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression((LighterASTNode)it)) continue;
            this_$iv2 = this;
            errorReason$iv = "Incorrect when subject expression: " + this.getAsText(whenExpression);
            $i$f$getAsFirExpression = false;
            Object it$iv = it;
            boolean bl5 = false;
            FirElement firElement5 = this_$iv2.convertExpression((LighterASTNode)it$iv, errorReason$iv);
            FirElement firElement6 = firElement5;
            if (!(firElement5 instanceof FirExpression)) {
                firElement6 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement6)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            subjectExpression = firElement;
        }
        FirPureAbstractElement firPureAbstractElement = (FirVariable)subjectVariable.element;
        if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getInitializer()) == null) {
            firPureAbstractElement = (FirExpression)subjectExpression;
        }
        boolean hasSubject = (subjectExpression = firPureAbstractElement) != null;
        FirExpressionRef<FirExpression> subject = new FirExpressionRef<FirExpression>();
        Iterable $this$mapTo$iv = whenEntryNodes;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it2;
            LighterASTNode lighterASTNode3 = (LighterASTNode)item$iv;
            Collection collection = whenEntries;
            boolean bl = false;
            it = tokenType$iv = subject;
            void var16_26 = it2;
            object = this;
            boolean bl6 = false;
            boolean bl7 = hasSubject;
            collection.add(super.convertWhenEntry((LighterASTNode)var16_26, (FirExpressionRef<FirWhenExpression>)(bl7 ? tokenType$iv : null)));
        }
        boolean $i$f$buildWhenExpression = false;
        FirWhenExpressionBuilder $this$convertWhenExpression_u24lambda_u2455 = $i$f$mapTo = new FirWhenExpressionBuilder();
        boolean bl = false;
        $this$convertWhenExpression_u24lambda_u2455.setSource(BaseFirBuilder.toFirSourceElement$default(this, whenExpression, null, 1, null));
        $this$convertWhenExpression_u24lambda_u2455.setSubject((FirExpression)subjectExpression);
        $this$convertWhenExpression_u24lambda_u2455.setSubjectVariable((FirVariable)subjectVariable.element);
        $this$convertWhenExpression_u24lambda_u2455.setUsedAsExpression(this.getUsedAsExpression(whenExpression));
        for (WhenEntry entry : whenEntries) {
            FirWhenBranch firWhenBranch;
            FirBlock branch = entry.getFirBlock();
            KtLightSourceElement entrySource = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, entry.getNode(), null, 1, null);
            Collection collection = $this$convertWhenExpression_u24lambda_u2455.getBranches();
            if (!entry.isElse()) {
                FirWhenBranchBuilder firWhenBranchBuilder;
                FirExpression firCondition;
                if (hasSubject) {
                    firCondition = entry.toFirWhenCondition();
                    boolean $i$f$buildWhenBranch = false;
                    FirWhenBranchBuilder $this$convertWhenExpression_u24lambda_u2455_u24lambda_u2452 = firWhenBranchBuilder = new FirWhenBranchBuilder();
                    boolean bl8 = false;
                    $this$convertWhenExpression_u24lambda_u2455_u24lambda_u2452.setSource(entrySource);
                    $this$convertWhenExpression_u24lambda_u2455_u24lambda_u2452.setCondition(firCondition);
                    $this$convertWhenExpression_u24lambda_u2455_u24lambda_u2452.setResult(branch);
                    firWhenBranch = firWhenBranchBuilder.build();
                } else {
                    firCondition = entry.toFirWhenConditionWithoutSubject();
                    boolean $i$f$buildWhenBranch = false;
                    FirWhenBranchBuilder $this$convertWhenExpression_u24lambda_u2455_u24lambda_u2453 = firWhenBranchBuilder = new FirWhenBranchBuilder();
                    boolean bl9 = false;
                    $this$convertWhenExpression_u24lambda_u2455_u24lambda_u2453.setSource(entrySource);
                    $this$convertWhenExpression_u24lambda_u2455_u24lambda_u2453.setCondition(firCondition);
                    $this$convertWhenExpression_u24lambda_u2455_u24lambda_u2453.setResult(branch);
                    firWhenBranch = firWhenBranchBuilder.build();
                }
            } else {
                FirWhenBranchBuilder firWhenBranchBuilder;
                boolean $i$f$buildWhenBranch = false;
                FirWhenBranchBuilder $this$convertWhenExpression_u24lambda_u2455_u24lambda_u2454 = firWhenBranchBuilder = new FirWhenBranchBuilder();
                boolean bl10 = false;
                $this$convertWhenExpression_u24lambda_u2455_u24lambda_u2454.setSource(entrySource);
                boolean $i$f$buildElseIfTrueCondition = false;
                firAnnotationContainerBuilder = new FirElseIfTrueConditionBuilder();
                $this$convertWhenExpression_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447 = firAnnotationContainerBuilder;
                FirWhenBranchBuilder firWhenBranchBuilder2 = $this$convertWhenExpression_u24lambda_u2455_u24lambda_u2454;
                boolean bl11 = false;
                FirPropertyBuilder $this$null = $this$convertWhenExpression_u24lambda_u2449_u24lambda_u2448_u24lambda_u2447;
                firWhenBranchBuilder2.setCondition(((FirElseIfTrueConditionBuilder)firAnnotationContainerBuilder).build());
                $this$convertWhenExpression_u24lambda_u2455_u24lambda_u2454.setResult(branch);
                firWhenBranch = firWhenBranchBuilder.build();
            }
            object = firWhenBranch;
            collection.add(object);
        }
        FirWhenExpression it3 = firWhenExpression = $i$f$mapTo.build();
        boolean bl12 = false;
        if (hasSubject) {
            subject.bind(it3);
        }
        return firWhenExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final WhenEntry convertWhenEntry(LighterASTNode whenEntry, FirExpressionRef<FirWhenExpression> whenRefWithSubject) {
        void $this$forEachChildren$iv;
        void this_$iv;
        boolean isElse = false;
        FirBlock firBlock = null;
        firBlock = FirEmptyExpressionBlockBuilderKt.buildEmptyExpressionBlock();
        List conditions2 = new ArrayList();
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = whenEntry;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHEN_CONDITION_EXPRESSION)) {
                ((Collection)conditions2).add(this.convertWhenConditionExpression(it, whenRefWithSubject));
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHEN_CONDITION_IN_RANGE)) {
                ((Collection)conditions2).add(this.convertWhenConditionInRange(it, whenRefWithSubject));
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHEN_CONDITION_IS_PATTERN)) {
                ((Collection)conditions2).add(this.convertWhenConditionIsPattern(it, whenRefWithSubject));
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtTokens.ELSE_KEYWORD)) {
                isElse = true;
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) {
                firBlock = this.declarationsConverter.convertBlock(it);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            firBlock = this.declarationsConverter.convertBlock(it);
        }
        return new WhenEntry(conditions2, firBlock, whenEntry, isElse);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenConditionExpression(LighterASTNode whenCondition, FirExpressionRef<FirWhenExpression> whenRefWithSubject) {
        FirExpression firExpression2;
        FirExpression calculatedFirExpression;
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement firExpression3 = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = whenCondition;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode lighterASTNode3 : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (lighterASTNode3 == null) break;
            IElementType tokenType$iv = lighterASTNode3.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, lighterASTNode3);
                continue;
            }
            LighterASTNode it = lighterASTNode3;
            boolean bl = false;
            it.getTokenType();
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No expression in condition with expression";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirExpression)) {
                firElement3 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression3 = firElement;
        }
        FirExpression firExpression4 = (FirExpression)firExpression3;
        if (firExpression4 == null) {
            firExpression4 = calculatedFirExpression = (FirExpression)FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No expression in condition with expression", DiagnosticKind.Syntax));
        }
        if (whenRefWithSubject != null) {
            FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder;
            FirEqualityOperatorCallBuilder firEqualityOperatorCallBuilder;
            boolean $i$f$buildEqualityOperatorCall = false;
            FirEqualityOperatorCallBuilder $this$convertWhenConditionExpression_u24lambda_u2460 = firEqualityOperatorCallBuilder = new FirEqualityOperatorCallBuilder();
            boolean bl = false;
            $this$convertWhenConditionExpression_u24lambda_u2460.setSource(this.toFirSourceElement(whenCondition, (KtFakeSourceElementKind)KtFakeSourceElementKind.WhenCondition.INSTANCE));
            $this$convertWhenConditionExpression_u24lambda_u2460.setOperation(FirOperation.EQ);
            boolean $i$f$buildWhenSubjectExpression = false;
            FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder2 = firWhenSubjectExpressionBuilder = new FirWhenSubjectExpressionBuilder();
            FirEqualityOperatorCallBuilder firEqualityOperatorCallBuilder2 = $this$convertWhenConditionExpression_u24lambda_u2460;
            boolean bl3 = false;
            firWhenSubjectExpressionBuilder2.setWhenRef(whenRefWithSubject);
            firEqualityOperatorCallBuilder2.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(firWhenSubjectExpressionBuilder.build(), calculatedFirExpression));
            firExpression2 = firEqualityOperatorCallBuilder.build();
        } else {
            firExpression2 = calculatedFirExpression;
        }
        return firExpression2;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenConditionInRange(LighterASTNode whenCondition, FirExpressionRef<FirWhenExpression> whenRefWithSubject) {
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        void $this$forEachChildren$iv;
        void this_$iv;
        boolean isNegate = false;
        FirElement firExpression2 = null;
        KtSourceElement conditionSource = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = whenCondition;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.OPERATION_REFERENCE) && Intrinsics.areEqual(this.getAsText(it), KtTokens.NOT_IN.getValue())) {
                conditionSource = BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null);
                isNegate = true;
                continue;
            }
            if (Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.OPERATION_REFERENCE)) {
                conditionSource = BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No range in condition with range";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirExpression)) {
                firElement3 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = firElement;
        }
        if (whenRefWithSubject == null) {
            boolean $i$f$buildErrorExpression = false;
            FirAnnotationContainerBuilder $this$convertWhenConditionInRange_u24lambda_u2463 = firAnnotationContainerBuilder = new FirErrorExpressionBuilder();
            boolean bl = false;
            ((FirErrorExpressionBuilder)$this$convertWhenConditionInRange_u24lambda_u2463).setSource(BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null));
            ((FirErrorExpressionBuilder)$this$convertWhenConditionInRange_u24lambda_u2463).setDiagnostic(new ConeSimpleDiagnostic("No expression in condition with expression", DiagnosticKind.ExpressionExpected));
            return ((FirErrorExpressionBuilder)firAnnotationContainerBuilder).build();
        }
        boolean $i$f$buildWhenSubjectExpression = false;
        FirAnnotationContainerBuilder $this$convertWhenConditionInRange_u24lambda_u2462 = firAnnotationContainerBuilder = new FirWhenSubjectExpressionBuilder();
        boolean bl = false;
        ((FirWhenSubjectExpressionBuilder)$this$convertWhenConditionInRange_u24lambda_u2462).setWhenRef(whenRefWithSubject);
        ((FirWhenSubjectExpressionBuilder)$this$convertWhenConditionInRange_u24lambda_u2462).setSource(BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null));
        FirWhenSubjectExpression subjectExpression = ((FirWhenSubjectExpressionBuilder)firAnnotationContainerBuilder).build();
        FirExpression firExpression3 = (FirExpression)firExpression2;
        if (firExpression3 == null) {
            firExpression3 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No range in condition with range", DiagnosticKind.Syntax));
        }
        FirExpression calculatedFirExpression = firExpression3;
        return ConversionUtilsKt.generateContainsOperation(calculatedFirExpression, subjectExpression, isNegate, BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null), conditionSource);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenConditionIsPattern(LighterASTNode whenCondition, FirExpressionRef<FirWhenExpression> whenRefWithSubject) {
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        void $this$forEachChildren$iv;
        void this_$iv;
        FirOperation firOperation = null;
        FirTypeRef firType = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = whenCondition;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.TYPE_REFERENCE)) {
                firType = this.declarationsConverter.convertType(it);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtTokens.IS_KEYWORD)) {
                firOperation = FirOperation.IS;
                continue;
            }
            if (!Intrinsics.areEqual(iElementType, KtTokens.NOT_IS)) continue;
            firOperation = FirOperation.NOT_IS;
        }
        if (whenRefWithSubject == null) {
            boolean $i$f$buildErrorExpression = false;
            FirAnnotationContainerBuilder $this$convertWhenConditionIsPattern_u24lambda_u2466 = firAnnotationContainerBuilder = new FirErrorExpressionBuilder();
            boolean bl = false;
            ((FirErrorExpressionBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2466).setSource(BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null));
            ((FirErrorExpressionBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2466).setDiagnostic(new ConeSimpleDiagnostic("No expression in condition with expression", DiagnosticKind.ExpressionExpected));
            return ((FirErrorExpressionBuilder)firAnnotationContainerBuilder).build();
        }
        boolean $i$f$buildWhenSubjectExpression = false;
        FirAnnotationContainerBuilder $this$convertWhenConditionIsPattern_u24lambda_u2465 = firAnnotationContainerBuilder = new FirWhenSubjectExpressionBuilder();
        boolean bl = false;
        ((FirWhenSubjectExpressionBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2465).setWhenRef(whenRefWithSubject);
        FirWhenSubjectExpression subjectExpression = ((FirWhenSubjectExpressionBuilder)firAnnotationContainerBuilder).build();
        boolean $i$f$buildTypeOperatorCall = false;
        FirAnnotationContainerBuilder $this$convertWhenConditionIsPattern_u24lambda_u2467 = firAnnotationContainerBuilder = new FirTypeOperatorCallBuilder();
        boolean bl2 = false;
        ((FirTypeOperatorCallBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2467).setSource(BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null));
        FirOperation firOperation2 = firOperation;
        if (firOperation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("firOperation");
            firOperation2 = null;
        }
        ((FirTypeOperatorCallBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2467).setOperation(firOperation2);
        FirTypeRef firTypeRef = firType;
        if (firTypeRef == null) {
            Intrinsics.throwUninitializedPropertyAccessException("firType");
            firTypeRef = null;
        }
        ((FirTypeOperatorCallBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2467).setConversionTypeRef(firTypeRef);
        ((FirTypeOperatorCallBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2467).setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(subjectExpression));
        return ((FirTypeOperatorCallBuilder)firAnnotationContainerBuilder).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertArrayAccessExpression(LighterASTNode arrayAccess) {
        void $this$convertArrayAccessExpression_u24lambda_u2472_u24lambda_u2471;
        Object $this$convertArrayAccessExpression_u24lambda_u2472_u24lambda_u2469;
        Object object;
        LighterASTNode lighterASTNode2;
        FirFunctionCallBuilder firFunctionCallBuilder;
        Object tokenType$iv;
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement firExpression2 = null;
        List indices = new ArrayList();
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode3 = arrayAccess;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains((IElementType)tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.INDICES)) {
                CollectionsKt.addAll((Collection)indices, (Iterable)this.convertIndices(it));
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No array expression";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirExpression)) {
                firElement3 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = firElement;
        }
        FirExpression getArgument = this.getContext().getArraySetArgument().remove(arrayAccess);
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$convertArrayAccessExpression_u24lambda_u2472 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        boolean isGet = getArgument == null;
        BaseFirBuilder baseFirBuilder = this;
        if (isGet) {
            lighterASTNode2 = arrayAccess;
        } else {
            LighterASTNode lighterASTNode4 = this.getParent(arrayAccess);
            lighterASTNode2 = lighterASTNode4;
            Intrinsics.checkNotNull(lighterASTNode4);
        }
        $this$convertArrayAccessExpression_u24lambda_u2472.setSource(BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, lighterASTNode2, null, 1, null));
        boolean $i$f$buildSimpleNamedReference = false;
        tokenType$iv = object = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$convertArrayAccessExpression_u24lambda_u2472;
        boolean bl3 = false;
        ((FirSimpleNamedReferenceBuilder)$this$convertArrayAccessExpression_u24lambda_u2472_u24lambda_u2469).setSource(KtSourceElementKt.fakeElement(BaseFirBuilder.toFirSourceElement$default(this, arrayAccess, null, 1, null), KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE));
        ((FirSimpleNamedReferenceBuilder)$this$convertArrayAccessExpression_u24lambda_u2472_u24lambda_u2469).setName(isGet ? OperatorNameConventions.GET : OperatorNameConventions.SET);
        firFunctionCallBuilder2.setCalleeReference(((FirSimpleNamedReferenceBuilder)object).build());
        FirExpression firExpression3 = (FirExpression)firExpression2;
        if (firExpression3 == null) {
            firExpression3 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No array expression", DiagnosticKind.Syntax));
        }
        $this$convertArrayAccessExpression_u24lambda_u2472.setExplicitReceiver(firExpression3);
        boolean $i$f$buildArgumentList = false;
        $this$convertArrayAccessExpression_u24lambda_u2472_u24lambda_u2469 = object = new FirArgumentListBuilder();
        firFunctionCallBuilder2 = $this$convertArrayAccessExpression_u24lambda_u2472;
        boolean bl4 = false;
        CollectionsKt.addAll((Collection)$this$convertArrayAccessExpression_u24lambda_u2472_u24lambda_u2471.getArguments(), indices);
        FirExpression firExpression4 = getArgument;
        if (firExpression4 != null) {
            FirExpression it = firExpression4;
            boolean bl5 = false;
            ((Collection)$this$convertArrayAccessExpression_u24lambda_u2472_u24lambda_u2471.getArguments()).add(it);
        }
        firFunctionCallBuilder2.setArgumentList(((FirArgumentListBuilder)object).build());
        $this$convertArrayAccessExpression_u24lambda_u2472.setOrigin(FirFunctionCallOrigin.Operator);
        return ConversionUtilsKt.pullUpSafeCallIfNecessary(firFunctionCallBuilder.build());
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertCollectionLiteralExpression(LighterASTNode expression2) {
        void $this$convertCollectionLiteralExpression_u24lambda_u2475_u24lambda_u2474;
        FirArgumentListBuilder firArgumentListBuilder;
        void $this$forEachChildren$iv;
        void this_$iv;
        List firExpressionList = new ArrayList();
        BaseConverter baseConverter = this;
        Object object = expression2;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            Collection collection = firExpressionList;
            Object object2 = this;
            String errorReason$iv = "Incorrect collection literal argument";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirExpression)) {
                firElement3 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            object2 = firElement;
            collection.add(object2);
        }
        boolean $i$f$buildArrayOfCall = false;
        Object $this$convertCollectionLiteralExpression_u24lambda_u2475 = object = new FirArrayOfCallBuilder();
        boolean bl = false;
        ((FirArrayOfCallBuilder)$this$convertCollectionLiteralExpression_u24lambda_u2475).setSource(BaseFirBuilder.toFirSourceElement$default(this, expression2, null, 1, null));
        boolean $i$f$buildArgumentList = false;
        FirArgumentListBuilder firArgumentListBuilder2 = firArgumentListBuilder = new FirArgumentListBuilder();
        Object object3 = $this$convertCollectionLiteralExpression_u24lambda_u2475;
        boolean bl3 = false;
        CollectionsKt.addAll((Collection)$this$convertCollectionLiteralExpression_u24lambda_u2475_u24lambda_u2474.getArguments(), firExpressionList);
        ((FirArrayOfCallBuilder)object3).setArgumentList(firArgumentListBuilder.build());
        return ((FirArrayOfCallBuilder)object).build();
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirExpression> convertIndices(LighterASTNode indices) {
        void $this$forEachChildren$iv;
        void this_$iv;
        List firExpressionList = new ArrayList();
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = indices;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            Collection collection = firExpressionList;
            Object object = this;
            String errorReason$iv = "Incorrect index expression";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirExpression)) {
                firElement3 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            object = firElement;
            collection.add(object);
        }
        return firExpressionList;
    }

    private final FirQualifiedAccessExpression convertSimpleNameExpression(LighterASTNode referenceExpression2) {
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        KtLightSourceElement nameSource = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, referenceExpression2, null, 1, null);
        KtSourceElement referenceSourceElement = nameSource.getKind() instanceof KtFakeSourceElementKind ? (KtSourceElement)nameSource : KtSourceElementKt.fakeElement(nameSource, KtFakeSourceElementKind.ReferenceInAtomicQualifiedAccess.INSTANCE);
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$convertSimpleNameExpression_u24lambda_u2477 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        String rawText = this.getAsText(referenceExpression2);
        if (ConversionUtilsKt.isUnderscore(rawText)) {
            $this$convertSimpleNameExpression_u24lambda_u2477.getNonFatalDiagnostics().add(new ConeUnderscoreUsageWithoutBackticks(nameSource));
        }
        $this$convertSimpleNameExpression_u24lambda_u2477.setSource(nameSource);
        $this$convertSimpleNameExpression_u24lambda_u2477.setCalleeReference(this.createSimpleNamedReference(referenceSourceElement, referenceExpression2));
        return firPropertyAccessExpressionBuilder.build();
    }

    private final FirNamedReference createSimpleNamedReference(KtSourceElement sourceElement, LighterASTNode referenceExpression2) {
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder $this$createSimpleNamedReference_u24lambda_u2478 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl = false;
        $this$createSimpleNamedReference_u24lambda_u2478.setSource(sourceElement);
        $this$createSimpleNamedReference_u24lambda_u2478.setName(ConverterUtilKt.nameAsSafeName$default(this.getAsText(referenceExpression2), null, 1, null));
        return firSimpleNamedReferenceBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertDoWhile(LighterASTNode doWhileLoop) {
        void $this$forEachChildren$iv;
        void this_$iv;
        void $this$convertDoWhile_u24lambda_u2480;
        FirDoWhileLoopBuilder firDoWhileLoopBuilder;
        Ref.ObjectRef<LighterASTNode> block = new Ref.ObjectRef<LighterASTNode>();
        FirElement firCondition = null;
        FirLoopTarget target = null;
        FirDoWhileLoopBuilder firDoWhileLoopBuilder2 = firDoWhileLoopBuilder = new FirDoWhileLoopBuilder();
        ExpressionsConverter expressionsConverter = this;
        boolean bl = false;
        $this$convertDoWhile_u24lambda_u2480.setSource(BaseFirBuilder.toFirSourceElement$default(this, doWhileLoop, null, 1, null));
        target = this.prepareTarget((FirLoopBuilder)$this$convertDoWhile_u24lambda_u2480, doWhileLoop);
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = doWhileLoop;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl2 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BODY)) {
                block.element = it;
                continue;
            }
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.CONDITION)) continue;
            ExpressionsConverter expressionsConverter2 = this;
            String errorReason$iv = "No condition in do-while loop";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl3 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirExpression)) {
                firElement3 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firCondition = firElement;
        }
        FirExpression firExpression2 = (FirExpression)firCondition;
        if (firExpression2 == null) {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No condition in do-while loop", DiagnosticKind.Syntax));
        }
        $this$convertDoWhile_u24lambda_u2480.setCondition(firExpression2);
        return expressionsConverter.configure(firDoWhileLoopBuilder, target, (Function0<FirBlock>)new Function0<FirBlock>(this, block){
            final /* synthetic */ ExpressionsConverter this$0;
            final /* synthetic */ Ref.ObjectRef<LighterASTNode> $block;
            {
                this.this$0 = $receiver;
                this.$block = $block;
                super(0);
            }

            @NotNull
            public final FirBlock invoke() {
                return ExpressionsConverter.access$convertLoopBody(this.this$0, (LighterASTNode)this.$block.element);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertWhile(LighterASTNode whileLoop) {
        void $this$convertWhile_u24lambda_u2482;
        void $this$forEachChildren$iv;
        void this_$iv;
        Ref.ObjectRef<LighterASTNode> block = new Ref.ObjectRef<LighterASTNode>();
        FirElement firCondition = null;
        BaseConverter baseConverter = this;
        Object object = whileLoop;
        Object skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BODY)) {
                block.element = it;
                continue;
            }
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.CONDITION)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No condition in while loop";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirExpression)) {
                firElement3 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firCondition = firElement;
        }
        FirLoopTarget target = null;
        object = new FirWhileLoopBuilder();
        skipTokens$iv = object;
        ExpressionsConverter expressionsConverter = this;
        boolean bl = false;
        $this$convertWhile_u24lambda_u2482.setSource(BaseFirBuilder.toFirSourceElement$default(this, whileLoop, null, 1, null));
        FirExpression firExpression2 = (FirExpression)firCondition;
        if (firExpression2 == null) {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No condition in while loop", DiagnosticKind.Syntax));
        }
        $this$convertWhile_u24lambda_u2482.setCondition(firExpression2);
        target = this.prepareTarget((FirLoopBuilder)$this$convertWhile_u24lambda_u2482, whileLoop);
        return expressionsConverter.configure((FirLoopBuilder)object, target, (Function0<FirBlock>)new Function0<FirBlock>(this, block){
            final /* synthetic */ ExpressionsConverter this$0;
            final /* synthetic */ Ref.ObjectRef<LighterASTNode> $block;
            {
                this.this$0 = $receiver;
                this.$block = $block;
                super(0);
            }

            @NotNull
            public final FirBlock invoke() {
                return ExpressionsConverter.access$convertLoopBody(this.this$0, (LighterASTNode)this.$block.element);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertFor(LighterASTNode forLoop) {
        void $this$convertFor_u24lambda_u2489_u24lambda_u2488_u24lambda_u2487_u24lambda_u2486;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        void $this$convertFor_u24lambda_u2489_u24lambda_u2488_u24lambda_u2487;
        void $this$convertFor_u24lambda_u2489_u24lambda_u2488;
        Object $this$convertFor_u24lambda_u2489_u24lambda_u2485_u24lambda_u2484;
        FirAnnotationContainerBuilder $this$convertFor_u24lambda_u2489_u24lambda_u2485;
        Object object;
        FirBlockBuilder firBlockBuilder;
        Object object2;
        Object object3;
        Object it;
        void $this$forEachChildren$iv;
        void this_$iv;
        Ref.ObjectRef<ValueParameter> parameter = new Ref.ObjectRef<ValueParameter>();
        FirElement rangeExpression = null;
        Ref.ObjectRef<LighterASTNode> blockNode = new Ref.ObjectRef<LighterASTNode>();
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = forLoop;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            it = kid$iv;
            boolean bl = false;
            object3 = it.getTokenType();
            if (Intrinsics.areEqual(object3, KtNodeTypes.VALUE_PARAMETER)) {
                parameter.element = DeclarationsConverter.convertValueParameter$default(this.declarationsConverter, (LighterASTNode)it, null, BaseFirBuilder.ValueParameterDeclaration.FOR_LOOP, null, 8, null);
                continue;
            }
            if (Intrinsics.areEqual(object3, KtNodeTypes.LOOP_RANGE)) {
                FirElement firElement;
                void this_$iv2;
                object2 = this;
                String errorReason$iv = "No range in for loop";
                boolean $i$f$getAsFirExpression = false;
                Object it$iv = it;
                boolean bl2 = false;
                FirElement firElement2 = this_$iv2.convertExpression((LighterASTNode)it$iv, errorReason$iv);
                FirElement firElement3 = firElement2;
                if (!(firElement2 instanceof FirExpression)) {
                    firElement3 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                rangeExpression = firElement;
                continue;
            }
            if (!Intrinsics.areEqual(object3, KtNodeTypes.BODY)) continue;
            blockNode.element = it;
        }
        FirExpression firExpression2 = (FirExpression)rangeExpression;
        if (firExpression2 == null) {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("No range in for loop", DiagnosticKind.Syntax));
        }
        FirExpression calculatedRangeExpression = firExpression2;
        KtLightSourceElement fakeSource = this.toFirSourceElement(forLoop, (KtFakeSourceElementKind)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE);
        FirLoopTarget target = null;
        boolean $i$f$buildBlock = false;
        FirBlockBuilder $this$convertFor_u24lambda_u2489 = firBlockBuilder = new FirBlockBuilder();
        boolean bl = false;
        $this$convertFor_u24lambda_u2489.setSource(fakeSource);
        KtSourceElement ktSourceElement = calculatedRangeExpression.getSource();
        boolean $i$f$buildFunctionCall = false;
        it = object = new FirFunctionCallBuilder();
        Name name = SpecialNames.ITERATOR;
        object3 = ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.DesugaredForLoop.INSTANCE) : null;
        object2 = this.getBaseModuleData();
        boolean bl3 = false;
        $this$convertFor_u24lambda_u2489_u24lambda_u2485.setSource(fakeSource);
        boolean $i$f$buildSimpleNamedReference = false;
        Object object4 = new FirSimpleNamedReferenceBuilder();
        FirSimpleNamedReferenceBuilder bl2 = object4;
        void var22_28 = $this$convertFor_u24lambda_u2489_u24lambda_u2485;
        boolean bl4 = false;
        ((FirSimpleNamedReferenceBuilder)$this$convertFor_u24lambda_u2489_u24lambda_u2485_u24lambda_u2484).setSource(fakeSource);
        ((FirSimpleNamedReferenceBuilder)$this$convertFor_u24lambda_u2489_u24lambda_u2485_u24lambda_u2484).setName(OperatorNameConventions.ITERATOR);
        var22_28.setCalleeReference(((FirSimpleNamedReferenceBuilder)object4).build());
        $this$convertFor_u24lambda_u2489_u24lambda_u2485.setExplicitReceiver(calculatedRangeExpression);
        Unit unit2 = Unit.INSTANCE;
        FirProperty iteratorVal = FirGenerationKt.generateTemporaryVariable$default((FirModuleData)object2, (KtSourceElement)object3, name, ((FirFunctionCallBuilder)object).build(), null, null, 48, null);
        ((Collection)$this$convertFor_u24lambda_u2489.getStatements()).add(iteratorVal);
        Collection collection = $this$convertFor_u24lambda_u2489.getStatements();
        object = new FirWhileLoopBuilder();
        $this$convertFor_u24lambda_u2489_u24lambda_u2485 = object;
        object2 = this;
        boolean bl5 = false;
        $this$convertFor_u24lambda_u2489_u24lambda_u2488.setSource(fakeSource);
        boolean $i$f$buildFunctionCall2 = false;
        $this$convertFor_u24lambda_u2489_u24lambda_u2485_u24lambda_u2484 = object4 = new FirFunctionCallBuilder();
        var22_28 = $this$convertFor_u24lambda_u2489_u24lambda_u2488;
        boolean bl6 = false;
        $this$convertFor_u24lambda_u2489_u24lambda_u2488_u24lambda_u2487.setSource(fakeSource);
        boolean $i$f$buildSimpleNamedReference2 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        void var29_35 = $this$convertFor_u24lambda_u2489_u24lambda_u2488_u24lambda_u2487;
        boolean bl7 = false;
        $this$convertFor_u24lambda_u2489_u24lambda_u2488_u24lambda_u2487_u24lambda_u2486.setSource(fakeSource);
        $this$convertFor_u24lambda_u2489_u24lambda_u2488_u24lambda_u2487_u24lambda_u2486.setName(OperatorNameConventions.HAS_NEXT);
        var29_35.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$convertFor_u24lambda_u2489_u24lambda_u2488_u24lambda_u2487.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(fakeSource, iteratorVal));
        var22_28.setCondition(((FirFunctionCallBuilder)object4).build());
        target = this.prepareTarget((FirLoopBuilder)$this$convertFor_u24lambda_u2489_u24lambda_u2488, forLoop);
        object = ((BaseFirBuilder)object2).configure((FirLoopBuilder)object, target, (Function0<? extends FirBlock>)new Function0<FirBlock>(blockNode, this, parameter, fakeSource, iteratorVal){
            final /* synthetic */ Ref.ObjectRef<LighterASTNode> $blockNode;
            final /* synthetic */ ExpressionsConverter this$0;
            final /* synthetic */ Ref.ObjectRef<ValueParameter> $parameter;
            final /* synthetic */ KtLightSourceElement $fakeSource;
            final /* synthetic */ FirProperty $iteratorVal;
            {
                this.$blockNode = $blockNode;
                this.this$0 = $receiver;
                this.$parameter = $parameter;
                this.$fakeSource = $fakeSource;
                this.$iteratorVal = $iteratorVal;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FirBlock invoke() {
                FirBlockBuilder firBlockBuilder;
                Ref.ObjectRef<LighterASTNode> objectRef = this.$blockNode;
                ExpressionsConverter expressionsConverter = this.this$0;
                Ref.ObjectRef<ValueParameter> objectRef2 = this.$parameter;
                KtLightSourceElement ktLightSourceElement = this.$fakeSource;
                FirProperty firProperty = this.$iteratorVal;
                boolean $i$f$buildBlock = false;
                FirBlockBuilder $this$invoke_u24lambda_u242 = firBlockBuilder = new FirBlockBuilder();
                boolean bl = false;
                LighterASTNode lighterASTNode2 = (LighterASTNode)objectRef.element;
                $this$invoke_u24lambda_u242.setSource(lighterASTNode2 != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(expressionsConverter, lighterASTNode2, null, 1, null) : null);
                CollectionsKt.addAll((Collection)$this$invoke_u24lambda_u242.getStatements(), (Iterable)ExpressionsConverter.access$convertLoopBody(expressionsConverter, (LighterASTNode)objectRef.element).getStatements());
                ValueParameter valueParameter2 = (ValueParameter)objectRef2.element;
                if (valueParameter2 != null) {
                    void $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240;
                    FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
                    void $this$invoke_u24lambda_u242_u24lambda_u241;
                    FirFunctionCallBuilder firFunctionCallBuilder;
                    ValueParameter valueParameter3 = valueParameter2;
                    DestructuringDeclaration multiDeclaration = valueParameter3.getDestructuringDeclaration();
                    boolean $i$f$buildFunctionCall = false;
                    FirFunctionCallBuilder firFunctionCallBuilder2 = firFunctionCallBuilder = new FirFunctionCallBuilder();
                    Name name = multiDeclaration != null ? SpecialNames.DESTRUCT : valueParameter3.getName();
                    KtSourceElement ktSourceElement = valueParameter3.getSource();
                    FirModuleData firModuleData = expressionsConverter.getBaseModuleData();
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u242_u24lambda_u241.setSource(ktLightSourceElement);
                    boolean $i$f$buildSimpleNamedReference = false;
                    FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
                    void var22_23 = $this$invoke_u24lambda_u242_u24lambda_u241;
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240.setSource(ktLightSourceElement);
                    $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240.setName(OperatorNameConventions.NEXT);
                    var22_23.setCalleeReference(firSimpleNamedReferenceBuilder.build());
                    $this$invoke_u24lambda_u242_u24lambda_u241.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(ktLightSourceElement, firProperty));
                    Unit unit2 = Unit.INSTANCE;
                    FirProperty firLoopParameter = FirGenerationKt.generateTemporaryVariable$default(firModuleData, ktSourceElement, name, firFunctionCallBuilder.build(), valueParameter3.getReturnTypeRef(), null, 32, null);
                    if (multiDeclaration != null) {
                        FirBlock destructuringBlock2 = ConverterUtilKt.generateDestructuringBlock(expressionsConverter.getBaseModuleData(), multiDeclaration, firLoopParameter, true);
                        $this$invoke_u24lambda_u242.getStatements().addAll(0, (Collection<FirStatement>)destructuringBlock2.getStatements());
                    } else {
                        $this$invoke_u24lambda_u242.getStatements().add(0, firLoopParameter);
                    }
                }
                return firBlockBuilder.build();
            }
        });
        collection.add(object);
        return firBlockBuilder.build();
    }

    private final FirBlock convertLoopBody(LighterASTNode body2) {
        FirBlock firBlock = this.convertLoopOrIfBody(body2);
        if (firBlock == null) {
            firBlock = FirEmptyExpressionBlockBuilderKt.buildEmptyExpressionBlock();
        }
        return firBlock;
    }

    /*
     * WARNING - void declaration
     */
    private final FirBlock convertLoopOrIfBody(LighterASTNode body2) {
        FirBlock firBlock;
        FirElement firBlock2 = null;
        FirElement firStatement = null;
        if (body2 != null) {
            void $this$forEachChildren$iv;
            void this_$iv;
            BaseConverter baseConverter = this;
            LighterASTNode lighterASTNode2 = body2;
            KtToken[] skipTokens$iv = new KtToken[]{};
            boolean $i$f$forEachChildren = false;
            for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
                FirElement firElement;
                boolean bl;
                LighterASTNode it$iv;
                boolean $i$f$getAsFirExpression;
                String errorReason$iv;
                if (kid$iv == null) break;
                IElementType tokenType$iv = kid$iv.getTokenType();
                if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
                if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                    BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                    continue;
                }
                LighterASTNode it = kid$iv;
                boolean bl2 = false;
                IElementType iElementType = it.getTokenType();
                if (Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) {
                    firBlock2 = this.declarationsConverter.convertBlockExpression(it);
                    continue;
                }
                if (Intrinsics.areEqual(iElementType, KtNodeTypes.ANNOTATED_EXPRESSION)) {
                    FirElement firElement2;
                    IElementType iElementType2 = KtNodeTypes.BLOCK;
                    Intrinsics.checkNotNullExpressionValue(iElementType2, "BLOCK");
                    if (this.getChildNodeByType(it, iElementType2) != null) {
                        FirElement firElement3;
                        errorReason$iv = "";
                        $i$f$getAsFirExpression = false;
                        it$iv = it;
                        bl = false;
                        FirElement firElement4 = this.convertExpression(it$iv, errorReason$iv);
                        FirElement firElement5 = firElement4;
                        if (!(firElement4 instanceof FirBlock)) {
                            firElement5 = null;
                        }
                        if ((firElement3 = (FirElement)((FirBlock)firElement5)) == null) {
                            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                            if (firErrorExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirBlock");
                            }
                            firElement3 = (FirBlock)((Object)firErrorExpression);
                        }
                        firBlock2 = firElement3;
                        continue;
                    }
                    errorReason$iv = "";
                    $i$f$getAsFirExpression = false;
                    it$iv = it;
                    bl = false;
                    FirElement firElement6 = this.convertExpression(it$iv, errorReason$iv);
                    FirElement firElement7 = firElement6;
                    if (!(firElement6 instanceof FirStatement)) {
                        firElement7 = null;
                    }
                    if ((firElement2 = (FirElement)((FirStatement)firElement7)) == null) {
                        FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                        if (firErrorExpression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
                        }
                        firElement2 = firErrorExpression;
                    }
                    firStatement = firElement2;
                    continue;
                }
                if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
                errorReason$iv = "";
                $i$f$getAsFirExpression = false;
                it$iv = it;
                bl = false;
                FirElement firElement8 = this.convertExpression(it$iv, errorReason$iv);
                FirElement firElement9 = firElement8;
                if (!(firElement8 instanceof FirStatement)) {
                    firElement9 = null;
                }
                if ((firElement = (FirElement)((FirStatement)firElement9)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
                    }
                    firElement = firErrorExpression;
                }
                firStatement = firElement;
            }
        }
        FirStatement firStatement2 = (FirStatement)firStatement;
        if (firStatement2 != null) {
            FirStatement it = firStatement2;
            boolean bl = false;
            firBlock = new FirSingleExpressionBlock(it);
        } else {
            firBlock = firBlock2;
        }
        return firBlock;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertTryExpression(LighterASTNode tryExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        FirBlock tryBlock = null;
        List catchClauses = new ArrayList();
        FirBlock finallyBlock = null;
        BaseConverter baseConverter = this;
        Object object = tryExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) {
                tryBlock = this.declarationsConverter.convertBlock(it);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.CATCH)) {
                if (this.convertCatchClause(it) != null) {
                    Pair<ValueParameter, FirBlock> pair;
                    Pair<ValueParameter, FirBlock> oneClause = pair;
                    boolean bl2 = false;
                    ((Collection)catchClauses).add(oneClause);
                }
                continue;
            }
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.FINALLY)) continue;
            finallyBlock = this.convertFinally(it);
        }
        boolean $i$f$buildTryExpression = false;
        Object $this$convertTryExpression_u24lambda_u2497 = object = new FirTryExpressionBuilder();
        boolean bl = false;
        ((FirTryExpressionBuilder)$this$convertTryExpression_u24lambda_u2497).setSource(BaseFirBuilder.toFirSourceElement$default(this, tryExpression, null, 1, null));
        FirBlock firBlock = tryBlock;
        if (firBlock == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tryBlock");
            firBlock = null;
        }
        ((FirTryExpressionBuilder)$this$convertTryExpression_u24lambda_u2497).setTryBlock(firBlock);
        ((FirTryExpressionBuilder)$this$convertTryExpression_u24lambda_u2497).setFinallyBlock(finallyBlock);
        for (Pair pair : catchClauses) {
            void it;
            void $this$convertTryExpression_u24lambda_u2497_u24lambda_u2496_u24lambda_u2494;
            FirCatchBuilder firCatchBuilder;
            ValueParameter parameter = (ValueParameter)pair.component1();
            FirBlock block = (FirBlock)pair.component2();
            if (parameter == null) continue;
            Collection collection = ((FirTryExpressionBuilder)$this$convertTryExpression_u24lambda_u2497).getCatches();
            boolean $i$f$buildCatch = false;
            FirCatchBuilder $this$convertTryExpression_u24lambda_u2497_u24lambda_u2496 = firCatchBuilder = new FirCatchBuilder();
            boolean bl3 = false;
            boolean $i$f$buildProperty = false;
            Object bl2 = new FirPropertyBuilder();
            FirPropertyBuilder firPropertyBuilder = bl2;
            FirCatchBuilder firCatchBuilder2 = $this$convertTryExpression_u24lambda_u2497_u24lambda_u2496;
            boolean bl4 = false;
            $this$convertTryExpression_u24lambda_u2497_u24lambda_u2496_u24lambda_u2494.setSource(parameter.getSource());
            $this$convertTryExpression_u24lambda_u2497_u24lambda_u2496_u24lambda_u2494.setModuleData(this.getBaseModuleData());
            $this$convertTryExpression_u24lambda_u2497_u24lambda_u2496_u24lambda_u2494.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$convertTryExpression_u24lambda_u2497_u24lambda_u2496_u24lambda_u2494.setReturnTypeRef(parameter.getReturnTypeRef());
            $this$convertTryExpression_u24lambda_u2497_u24lambda_u2496_u24lambda_u2494.setVar(false);
            $this$convertTryExpression_u24lambda_u2497_u24lambda_u2496_u24lambda_u2494.setStatus(new FirResolvedDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL, EffectiveVisibility.Local.INSTANCE));
            $this$convertTryExpression_u24lambda_u2497_u24lambda_u2496_u24lambda_u2494.setLocal(true);
            $this$convertTryExpression_u24lambda_u2497_u24lambda_u2496_u24lambda_u2494.setName(parameter.getName());
            $this$convertTryExpression_u24lambda_u2497_u24lambda_u2496_u24lambda_u2494.setSymbol(new FirPropertySymbol(new CallableId($this$convertTryExpression_u24lambda_u2497_u24lambda_u2496_u24lambda_u2494.getName(), null, 2, null)));
            CollectionsKt.addAll((Collection)$this$convertTryExpression_u24lambda_u2497_u24lambda_u2496_u24lambda_u2494.getAnnotations(), (Iterable)parameter.getAnnotations());
            FirProperty firProperty = ((FirPropertyBuilder)bl2).build();
            bl2 = firProperty;
            boolean bl5 = false;
            ClassMembersKt.setCatchParameter((FirProperty)it, true);
            firCatchBuilder2.setParameter(firProperty);
            $this$convertTryExpression_u24lambda_u2497_u24lambda_u2496.setBlock(block);
            FirCatch firCatch = firCatchBuilder.build();
            collection.add(firCatch);
        }
        return ((FirTryExpressionBuilder)object).build();
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<ValueParameter, FirBlock> convertCatchClause(LighterASTNode catchClause) {
        void $this$forEachChildren$iv;
        void this_$iv;
        ValueParameter valueParameter2 = null;
        LighterASTNode blockNode = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = catchClause;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.VALUE_PARAMETER_LIST)) {
                if ((ValueParameter)CollectionsKt.firstOrNull(DeclarationsConverter.convertValueParameters$default(this.declarationsConverter, it, new FirAnonymousFunctionSymbol(), BaseFirBuilder.ValueParameterDeclaration.CATCH, null, 8, null)) != null) continue;
                return null;
            }
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) continue;
            blockNode = it;
        }
        return new Pair<Object, FirBlock>(valueParameter2, this.declarationsConverter.convertBlock(blockNode));
    }

    /*
     * WARNING - void declaration
     */
    private final FirBlock convertFinally(LighterASTNode finallyExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode blockNode = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = finallyExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.BLOCK)) continue;
            blockNode = it;
        }
        return this.declarationsConverter.convertBlock(blockNode);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertIfExpression(LighterASTNode ifExpression) {
        FirWhenExpressionBuilder $this$convertIfExpression_u24lambda_u24105;
        FirWhenExpressionBuilder firWhenExpressionBuilder;
        block5: {
            boolean cascadeIf;
            IfNodeComponents components2 = null;
            components2 = this.parseIfExpression(ifExpression);
            boolean $i$f$buildWhenExpression = false;
            $this$convertIfExpression_u24lambda_u24105 = firWhenExpressionBuilder = new FirWhenExpressionBuilder();
            boolean bl = false;
            $this$convertIfExpression_u24lambda_u24105.setSource(BaseFirBuilder.toFirSourceElement$default(this, ifExpression, null, 1, null));
            do {
                void $this$forEachChildren$iv;
                void this_$iv;
                FirWhenBranchBuilder firWhenBranchBuilder;
                IfNodeComponents $this$convertIfExpression_u24lambda_u24105_u24lambda_u24101 = components2;
                boolean $i$a$-with-ExpressionsConverter$convertIfExpression$1$22 = false;
                Object trueBranch = this.convertLoopBody($this$convertIfExpression_u24lambda_u24105_u24lambda_u24101.getThenBlock());
                Collection collection = $this$convertIfExpression_u24lambda_u24105.getBranches();
                boolean $i$f$buildWhenBranch22 = false;
                FirWhenBranchBuilder $this$convertIfExpression_u24lambda_u24105_u24lambda_u24101_u24lambda_u24100 = firWhenBranchBuilder = new FirWhenBranchBuilder();
                int n = 0;
                LighterASTNode lighterASTNode2 = $this$convertIfExpression_u24lambda_u24105_u24lambda_u24101.getThenBlock();
                $this$convertIfExpression_u24lambda_u24105_u24lambda_u24101_u24lambda_u24100.setSource(lighterASTNode2 != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, lighterASTNode2, null, 1, null) : null);
                FirExpression firExpression2 = $this$convertIfExpression_u24lambda_u24105_u24lambda_u24101.getFirCondition();
                if (firExpression2 == null) {
                    firExpression2 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("If statement should have condition", DiagnosticKind.Syntax));
                }
                $this$convertIfExpression_u24lambda_u24105_u24lambda_u24101_u24lambda_u24100.setCondition(firExpression2);
                $this$convertIfExpression_u24lambda_u24105_u24lambda_u24101_u24lambda_u24100.setResult((FirBlock)trueBranch);
                FirWhenBranch $i$f$buildWhenBranch22 = firWhenBranchBuilder.build();
                collection.add($i$f$buildWhenBranch22);
                if (components2.getElseBlock() == null) break block5;
                cascadeIf = false;
                LighterASTNode lighterASTNode3 = components2.getElseBlock();
                if (lighterASTNode3 == null) continue;
                BaseConverter $i$a$-with-ExpressionsConverter$convertIfExpression$1$22 = this;
                trueBranch = lighterASTNode3;
                KtToken[] skipTokens$iv = new KtToken[]{};
                boolean $i$f$forEachChildren = false;
                for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
                    if (kid$iv == null) break;
                    IElementType tokenType$iv = kid$iv.getTokenType();
                    if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
                    if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                        BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                        continue;
                    }
                    LighterASTNode it = kid$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.IF)) continue;
                    cascadeIf = true;
                    components2 = this.parseIfExpression(it);
                }
            } while (cascadeIf);
            IfNodeComponents $this$convertIfExpression_u24lambda_u24105_u24lambda_u24104 = components2;
            boolean bl3 = false;
            FirBlock elseBranch = this.convertLoopOrIfBody($this$convertIfExpression_u24lambda_u24105_u24lambda_u24104.getElseBlock());
            if (elseBranch != null) {
                FirElseIfTrueConditionBuilder firElseIfTrueConditionBuilder;
                FirWhenBranchBuilder firWhenBranchBuilder;
                Collection collection = $this$convertIfExpression_u24lambda_u24105.getBranches();
                boolean $i$f$buildWhenBranch = false;
                FirWhenBranchBuilder $this$convertIfExpression_u24lambda_u24105_u24lambda_u24104_u24lambda_u24103 = firWhenBranchBuilder = new FirWhenBranchBuilder();
                boolean bl4 = false;
                LighterASTNode lighterASTNode4 = $this$convertIfExpression_u24lambda_u24105_u24lambda_u24104.getElseBlock();
                $this$convertIfExpression_u24lambda_u24105_u24lambda_u24104_u24lambda_u24103.setSource(lighterASTNode4 != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, lighterASTNode4, null, 1, null) : null);
                boolean $i$f$buildElseIfTrueCondition = false;
                FirElseIfTrueConditionBuilder firElseIfTrueConditionBuilder2 = firElseIfTrueConditionBuilder = new FirElseIfTrueConditionBuilder();
                FirWhenBranchBuilder firWhenBranchBuilder2 = $this$convertIfExpression_u24lambda_u24105_u24lambda_u24104_u24lambda_u24103;
                boolean bl5 = false;
                FirElseIfTrueConditionBuilder $this$null = firElseIfTrueConditionBuilder2;
                firWhenBranchBuilder2.setCondition(firElseIfTrueConditionBuilder.build());
                $this$convertIfExpression_u24lambda_u24105_u24lambda_u24104_u24lambda_u24103.setResult(elseBranch);
                FirWhenBranch firWhenBranch = firWhenBranchBuilder.build();
                collection.add(firWhenBranch);
            }
        }
        $this$convertIfExpression_u24lambda_u24105.setUsedAsExpression(this.getUsedAsExpression(ifExpression));
        return firWhenExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final IfNodeComponents parseIfExpression(LighterASTNode ifExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement firCondition = null;
        LighterASTNode thenBlock = null;
        LighterASTNode elseBlock = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = ifExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.CONDITION)) {
                FirElement firElement;
                void this_$iv2;
                ExpressionsConverter expressionsConverter = this;
                String errorReason$iv = "If statement should have condition";
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode it$iv = it;
                boolean bl2 = false;
                FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
                FirElement firElement3 = firElement2;
                if (!(firElement2 instanceof FirExpression)) {
                    firElement3 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                firCondition = firElement;
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.THEN)) {
                thenBlock = it;
                continue;
            }
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.ELSE)) continue;
            elseBlock = it;
        }
        return new IfNodeComponents((FirExpression)firCondition, thenBlock, elseBlock);
    }

    private final boolean getUsedAsExpression(LighterASTNode $this$usedAsExpression) {
        LighterASTNode lighterASTNode2 = this.getParent($this$usedAsExpression);
        if (lighterASTNode2 == null) {
            return true;
        }
        LighterASTNode parent2 = lighterASTNode2;
        while (Intrinsics.areEqual(this.getElementType(parent2), KtNodeTypes.ANNOTATED_EXPRESSION) || Intrinsics.areEqual(this.getElementType(parent2), KtNodeTypes.LABELED_EXPRESSION)) {
            if (this.getParent(parent2) != null) continue;
            return true;
        }
        IElementType parentTokenType = parent2.getTokenType();
        if (Intrinsics.areEqual(parentTokenType, KtNodeTypes.BLOCK)) {
            return false;
        }
        if (Intrinsics.areEqual(parentTokenType, KtNodeTypes.THEN) || Intrinsics.areEqual(parentTokenType, KtNodeTypes.ELSE) || Intrinsics.areEqual(parentTokenType, KtNodeTypes.WHEN_ENTRY)) {
            LighterASTNode lighterASTNode3 = this.getParent(parent2);
            return lighterASTNode3 != null ? this.getUsedAsExpression(lighterASTNode3) : true;
        }
        if (!Intrinsics.areEqual(parentTokenType, KtNodeTypes.BODY)) {
            return true;
        }
        LighterASTNode lighterASTNode4 = this.getParent(parent2);
        IElementType iElementType = lighterASTNode4 != null ? lighterASTNode4.getTokenType() : null;
        if (iElementType == null) {
            return true;
        }
        IElementType type2 = iElementType;
        return !Intrinsics.areEqual(type2, KtNodeTypes.FOR) && !Intrinsics.areEqual(type2, KtNodeTypes.WHILE) && !Intrinsics.areEqual(type2, KtNodeTypes.DO_WHILE);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertLoopJump(LighterASTNode jump) {
        void $this$convertLoopJump_u24lambda_u24108;
        FirLoopJumpBuilder firLoopJumpBuilder;
        void $this$forEachChildren$iv;
        void this_$iv;
        boolean isBreak = false;
        isBreak = true;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = jump;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren22 = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getTokenType(), KtTokens.CONTINUE_KEYWORD)) continue;
            isBreak = false;
        }
        FirLoopJumpBuilder jumpBuilder = isBreak ? new FirBreakExpressionBuilder() : new FirContinueExpressionBuilder();
        KtLightSourceElement sourceElement = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, jump, null, 1, null);
        FirLoopJumpBuilder $i$f$forEachChildren22 = firLoopJumpBuilder = jumpBuilder;
        ExpressionsConverter expressionsConverter = this;
        boolean bl = false;
        ((FirLoopJumpBuilder)$this$convertLoopJump_u24lambda_u24108).setSource(sourceElement);
        return expressionsConverter.bindLabel(firLoopJumpBuilder, jump).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertReturn(LighterASTNode returnExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        String labelName = null;
        FirElement firExpression2 = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = returnExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.LABEL_QUALIFIER)) {
                labelName = StringsKt.replace$default(ConverterUtilKt.getAsStringWithoutBacktick(it), "@", "", false, 4, null);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "Incorrect return expression";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirExpression)) {
                firElement3 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = firElement;
        }
        FirExpression firExpression3 = (FirExpression)firExpression2;
        if (firExpression3 == null) {
            FirUnitExpressionBuilder firUnitExpressionBuilder;
            boolean $i$f$buildUnitExpression = false;
            FirUnitExpressionBuilder $this$convertReturn_u24lambda_u24110 = firUnitExpressionBuilder = new FirUnitExpressionBuilder();
            boolean bl = false;
            $this$convertReturn_u24lambda_u24110.setSource(this.toFirSourceElement(returnExpression, (KtFakeSourceElementKind)KtFakeSourceElementKind.ImplicitUnit.INSTANCE));
            firExpression3 = firUnitExpressionBuilder.build();
        }
        FirExpression calculatedFirExpression = firExpression3;
        return this.toReturn(calculatedFirExpression, BaseFirBuilder.toFirSourceElement$default(this, returnExpression, null, 1, null), labelName, true);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertThrow(LighterASTNode throwExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement firExpression2 = null;
        BaseConverter baseConverter = this;
        Object object = throwExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "Nothing to throw";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirExpression)) {
                firElement3 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = firElement;
        }
        boolean $i$f$buildThrowExpression = false;
        Object $this$convertThrow_u24lambda_u24112 = object = new FirThrowExpressionBuilder();
        boolean bl = false;
        ((FirThrowExpressionBuilder)$this$convertThrow_u24lambda_u24112).setSource(BaseFirBuilder.toFirSourceElement$default(this, throwExpression, null, 1, null));
        FirExpression firExpression3 = (FirExpression)firExpression2;
        if (firExpression3 == null) {
            firExpression3 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Nothing to throw", DiagnosticKind.Syntax));
        }
        ((FirThrowExpressionBuilder)$this$convertThrow_u24lambda_u24112).setException(firExpression3);
        return ((FirThrowExpressionBuilder)object).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirQualifiedAccessExpression convertThisExpression(LighterASTNode thisExpression) {
        void $this$convertThisExpression_u24lambda_u24114_u24lambda_u24113;
        FirExplicitThisReferenceBuilder firExplicitThisReferenceBuilder;
        FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
        String label = this.getLabelName(thisExpression);
        boolean $i$f$buildThisReceiverExpression = false;
        FirThisReceiverExpressionBuilder $this$convertThisExpression_u24lambda_u24114 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
        boolean bl = false;
        $this$convertThisExpression_u24lambda_u24114.setSource(BaseFirBuilder.toFirSourceElement$default(this, thisExpression, null, 1, null));
        boolean $i$f$buildExplicitThisReference = false;
        FirExplicitThisReferenceBuilder firExplicitThisReferenceBuilder2 = firExplicitThisReferenceBuilder = new FirExplicitThisReferenceBuilder();
        FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder2 = $this$convertThisExpression_u24lambda_u24114;
        boolean bl2 = false;
        $this$convertThisExpression_u24lambda_u24114_u24lambda_u24113.setLabelName(label);
        firThisReceiverExpressionBuilder2.setCalleeReference(firExplicitThisReferenceBuilder.build());
        return firThisReceiverExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirQualifiedAccessExpression convertSuperExpression(LighterASTNode superExpression) {
        void $this$convertSuperExpression_u24lambda_u24117_u24lambda_u24116;
        FirExplicitSuperReferenceBuilder firExplicitSuperReferenceBuilder;
        void $this$forEachChildren$iv;
        void this_$iv;
        String label = this.getLabelName(superExpression);
        FirTypeRef superTypeRef = null;
        superTypeRef = this.getImplicitType();
        BaseConverter baseConverter = this;
        Object object = superExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.TYPE_REFERENCE)) continue;
            superTypeRef = this.declarationsConverter.convertType(it);
        }
        boolean $i$f$buildPropertyAccessExpression = false;
        Object $this$convertSuperExpression_u24lambda_u24117 = object = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        ((FirPropertyAccessExpressionBuilder)$this$convertSuperExpression_u24lambda_u24117).setSource(BaseFirBuilder.toFirSourceElement$default(this, superExpression, null, 1, null));
        boolean $i$f$buildExplicitSuperReference = false;
        FirExplicitSuperReferenceBuilder firExplicitSuperReferenceBuilder2 = firExplicitSuperReferenceBuilder = new FirExplicitSuperReferenceBuilder();
        Object object2 = $this$convertSuperExpression_u24lambda_u24117;
        boolean bl2 = false;
        $this$convertSuperExpression_u24lambda_u24117_u24lambda_u24116.setLabelName(label);
        $this$convertSuperExpression_u24lambda_u24117_u24lambda_u24116.setSuperTypeRef(superTypeRef);
        ((FirPropertyAccessExpressionBuilder)object2).setCalleeReference(firExplicitSuperReferenceBuilder.build());
        return ((FirPropertyAccessExpressionBuilder)object).build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirExpression> convertValueArguments(@NotNull LighterASTNode valueArguments) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(valueArguments, "valueArguments");
        BaseConverter baseConverter = this;
        LighterASTNode $this$forEachChildrenReturnList$iv = valueArguments;
        boolean $i$f$forEachChildrenReturnList = false;
        LighterASTNode[] kidsArray$iv = this_$iv.getChildrenAsArray($this$forEachChildrenReturnList$iv);
        List container$iv = new ArrayList();
        for (LighterASTNode kid$iv : kidsArray$iv) {
            FirElement firElement;
            FirLambdaArgumentExpressionBuilder firLambdaArgumentExpressionBuilder;
            void container;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            List list2 = container$iv;
            LighterASTNode node = kid$iv;
            boolean bl = false;
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.VALUE_ARGUMENT)) {
                ((Collection)container).add(this.convertValueArgument(node));
                continue;
            }
            if (!((Intrinsics.areEqual(iElementType, KtNodeTypes.LAMBDA_EXPRESSION) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.LABELED_EXPRESSION)) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.ANNOTATED_EXPRESSION))) continue;
            Collection collection = (Collection)container;
            boolean $i$f$buildLambdaArgumentExpression = false;
            FirLambdaArgumentExpressionBuilder $this$convertValueArguments_u24lambda_u24119_u24lambda_u24118 = firLambdaArgumentExpressionBuilder = new FirLambdaArgumentExpressionBuilder();
            boolean bl2 = false;
            $this$convertValueArguments_u24lambda_u24119_u24lambda_u24118.setSource(BaseFirBuilder.toFirSourceElement$default(this, valueArguments, null, 1, null));
            String errorReason$iv = "";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = node;
            boolean bl3 = false;
            FirElement firElement2 = this.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirExpression)) {
                firElement3 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, node, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            $this$convertValueArguments_u24lambda_u24119_u24lambda_u24118.setExpression((FirExpression)firElement);
            FirLambdaArgumentExpression firLambdaArgumentExpression = firLambdaArgumentExpressionBuilder.build();
            collection.add(firLambdaArgumentExpression);
        }
        return container$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertValueArgument(LighterASTNode valueArgument) {
        FirExpression firExpression2;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        void $this$forEachChildren$iv;
        void this_$iv;
        String identifier = null;
        boolean isSpread = false;
        FirElement firExpression3 = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = valueArgument;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.VALUE_ARGUMENT_NAME)) {
                identifier = this.getAsText(it);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtTokens.MUL)) {
                isSpread = true;
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.STRING_TEMPLATE)) {
                firExpression3 = this.convertStringTemplate(it);
                continue;
            }
            if (iElementType instanceof KtConstantExpressionElementType) {
                firExpression3 = this.convertConstantExpression(it);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "Argument is absent";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement firElement2 = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement3 = firElement2;
            if (!(firElement2 instanceof FirExpression)) {
                firElement3 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement3)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression3 = firElement;
        }
        FirExpression firExpression4 = firExpression3;
        if (firExpression4 == null) {
            firExpression4 = FirExpressionUtilKt.buildErrorExpression(null, new ConeSimpleDiagnostic("Argument is absent", DiagnosticKind.Syntax));
        }
        FirExpression calculatedFirExpression = firExpression4;
        if (identifier != null) {
            boolean $i$f$buildNamedArgumentExpression = false;
            firAnnotationContainerBuilder = new FirNamedArgumentExpressionBuilder();
            FirNamedArgumentExpressionBuilder $this$convertValueArgument_u24lambda_u24121 = firAnnotationContainerBuilder;
            boolean bl = false;
            $this$convertValueArgument_u24lambda_u24121.setSource(BaseFirBuilder.toFirSourceElement$default(this, valueArgument, null, 1, null));
            $this$convertValueArgument_u24lambda_u24121.setExpression(calculatedFirExpression);
            $this$convertValueArgument_u24lambda_u24121.setSpread(isSpread);
            $this$convertValueArgument_u24lambda_u24121.setName(ConverterUtilKt.nameAsSafeName$default(identifier, null, 1, null));
            firExpression2 = ((FirNamedArgumentExpressionBuilder)firAnnotationContainerBuilder).build();
        } else if (isSpread) {
            boolean $i$f$buildSpreadArgumentExpression = false;
            FirAnnotationContainerBuilder $this$convertValueArgument_u24lambda_u24122 = firAnnotationContainerBuilder = new FirSpreadArgumentExpressionBuilder();
            boolean bl = false;
            ((FirSpreadArgumentExpressionBuilder)$this$convertValueArgument_u24lambda_u24122).setSource(BaseFirBuilder.toFirSourceElement$default(this, valueArgument, null, 1, null));
            ((FirSpreadArgumentExpressionBuilder)$this$convertValueArgument_u24lambda_u24122).setExpression(calculatedFirExpression);
            firExpression2 = ((FirSpreadArgumentExpressionBuilder)firAnnotationContainerBuilder).build();
        } else {
            firExpression2 = calculatedFirExpression;
        }
        return firExpression2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void convertCallExpression$lambda$37$process(Ref.ObjectRef<String> name, ExpressionsConverter this$0, Ref.ObjectRef<LighterASTNode> superNode, List<FirTypeProjection> firTypeArguments, Ref.BooleanRef hasArguments, List<LighterASTNode> valueArguments, Ref.ObjectRef<FirExpression> additionalArgument, LighterASTNode node) {
        IElementType iElementType = node.getTokenType();
        if (Intrinsics.areEqual(iElementType, KtNodeTypes.REFERENCE_EXPRESSION)) {
            name.element = this$0.getAsText(node);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.SUPER_EXPRESSION)) {
            superNode.element = node;
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.PARENTHESIZED)) {
            Unit unit2;
            LighterASTNode lighterASTNode2 = this$0.getExpressionInParentheses(node);
            if (lighterASTNode2 != null) {
                LighterASTNode it = lighterASTNode2;
                boolean bl2 = false;
                ExpressionsConverter.convertCallExpression$lambda$37$process(name, this$0, superNode, firTypeArguments, hasArguments, valueArguments, additionalArgument, it);
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            if (unit2 == null) {
                FirElement firElement;
                FirElement firElement2;
                FirElement firElement3;
                void this_$iv;
                ExpressionsConverter $this$convertCallExpression_u24lambda_u2437_u24process_u24lambda_u2436 = this$0;
                boolean bl = false;
                ExpressionsConverter bl2 = $this$convertCallExpression_u24lambda_u2437_u24process_u24lambda_u2436;
                String errorReason$iv = "Incorrect invoke receiver";
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode lighterASTNode3 = node;
                if (lighterASTNode3 != null) {
                    LighterASTNode it$iv = lighterASTNode3;
                    boolean bl3 = false;
                    firElement3 = this_$iv.convertExpression(it$iv, errorReason$iv);
                } else {
                    firElement3 = firElement2 = null;
                }
                if (!(firElement3 instanceof FirExpression)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(node != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv, node, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                additionalArgument.element = firElement;
            }
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.TYPE_ARGUMENT_LIST)) {
            CollectionsKt.addAll((Collection)firTypeArguments, (Iterable)this$0.declarationsConverter.convertTypeArguments(node, true));
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.VALUE_ARGUMENT_LIST) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.LAMBDA_ARGUMENT)) {
            hasArguments.element = true;
            ((Collection)valueArguments).add(node);
        } else if (!Intrinsics.areEqual(node.getTokenType(), TokenType.ERROR_ELEMENT)) {
            FirElement firElement;
            FirElement firElement4;
            FirElement firElement5;
            void this_$iv;
            ExpressionsConverter expressionsConverter = this$0;
            String errorReason$iv = "Incorrect invoke receiver";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode4 = node;
            if (lighterASTNode4 != null) {
                LighterASTNode it$iv = lighterASTNode4;
                boolean bl = false;
                firElement5 = this_$iv.convertExpression(it$iv, errorReason$iv);
            } else {
                firElement5 = firElement4 = null;
            }
            if (!(firElement5 instanceof FirExpression)) {
                firElement4 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement4)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(node != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv, node, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected));
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            additionalArgument.element = firElement;
        }
    }

    public static final /* synthetic */ FirExpression access$convertShortOrLongStringTemplate(ExpressionsConverter $this, LighterASTNode $receiver, String errorReason) {
        return $this.convertShortOrLongStringTemplate($receiver, errorReason);
    }

    public static final /* synthetic */ FirBlock access$convertLoopBody(ExpressionsConverter $this, LighterASTNode body2) {
        return $this.convertLoopBody(body2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/converter/ExpressionsConverter$IfNodeComponents;", "", "firCondition", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "thenBlock", "Lcom/intellij/lang/LighterASTNode;", "elseBlock", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lcom/intellij/lang/LighterASTNode;Lcom/intellij/lang/LighterASTNode;)V", "getElseBlock", "()Lcom/intellij/lang/LighterASTNode;", "getFirCondition", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getThenBlock", "light-tree2fir"})
    private static final class IfNodeComponents {
        @Nullable
        private final FirExpression firCondition;
        @Nullable
        private final LighterASTNode thenBlock;
        @Nullable
        private final LighterASTNode elseBlock;

        public IfNodeComponents(@Nullable FirExpression firCondition, @Nullable LighterASTNode thenBlock, @Nullable LighterASTNode elseBlock) {
            this.firCondition = firCondition;
            this.thenBlock = thenBlock;
            this.elseBlock = elseBlock;
        }

        @Nullable
        public final FirExpression getFirCondition() {
            return this.firCondition;
        }

        @Nullable
        public final LighterASTNode getThenBlock() {
            return this.thenBlock;
        }

        @Nullable
        public final LighterASTNode getElseBlock() {
            return this.elseBlock;
        }
    }
}

