/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\"\u001a\u001a\u0010!\u001a\u00020\u0004*\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a#\u0010#\u001a\u00020\u0004*\u00020\u00052\u0006\u0010$\u001a\u00020\u00022\b\u0010%\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010&\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006\"\u0015\u0010\b\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\"\u0015\u0010\t\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006\"\u0015\u0010\n\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\"\u0015\u0010\u000b\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006\"\u0015\u0010\f\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\"\u0015\u0010\r\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006\"\u0015\u0010\u000e\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006\"\u0015\u0010\u000f\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006\"\u0015\u0010\u0010\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\"\u0015\u0010\u0011\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006\"\u0015\u0010\u0012\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006\"\u0015\u0010\u0013\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006\"\u0015\u0010\u0014\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006\"\u0015\u0010\u0015\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006\"\u0015\u0010\u0016\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006\"\u0015\u0010\u0017\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0006\"\u0015\u0010\u0018\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006\"\u0015\u0010\u0019\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0006\"\u0015\u0010\u001a\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0006\"\u0015\u0010\u001b\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0006\"\u0015\u0010\u001c\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0006\"\u0015\u0010\u001d\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0006\"\u0015\u0010\u001e\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0006\"\u0015\u0010\u001f\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0006\"\u0015\u0010 \u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0006\u00a8\u0006'"}, d2={"builtinIntegerTypes", "", "Lorg/jetbrains/kotlin/name/ClassId;", "isAny", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "isArrayType", "isBoolean", "isBooleanOrNullableBoolean", "isByte", "isChar", "isDouble", "isEnum", "isFloat", "isInt", "isIntegerTypeOrNullableIntegerTypeOfAnySize", "isLong", "isNonPrimitiveArray", "isNothing", "isNullableAny", "isNullableBoolean", "isNullableNothing", "isPrimitive", "isPrimitiveArray", "isPrimitiveOrNullablePrimitive", "isShort", "isString", "isUInt", "isULong", "isUnit", "isUnsignedType", "isUnsignedTypeOrNullableUnsignedType", "isAnyOfBuiltinType", "classIds", "isBuiltinType", "classId", "isNullable", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/name/ClassId;Ljava/lang/Boolean;)Z", "cones"})
@SourceDebugExtension(value={"SMAP\nConeBuiltinTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeBuiltinTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeBuiltinTypeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1747#2,3:67\n*S KotlinDebug\n*F\n+ 1 ConeBuiltinTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeBuiltinTypeUtilsKt\n*L\n40#1:67,3\n*E\n"})
public final class ConeBuiltinTypeUtilsKt {
    @NotNull
    private static final Set<ClassId> builtinIntegerTypes;

    public static final boolean isByte(@NotNull ConeKotlinType $this$isByte) {
        Intrinsics.checkNotNullParameter($this$isByte, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isByte, StandardClassIds.INSTANCE.getByte(), false);
    }

    public static final boolean isShort(@NotNull ConeKotlinType $this$isShort) {
        Intrinsics.checkNotNullParameter($this$isShort, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isShort, StandardClassIds.INSTANCE.getShort(), false);
    }

    public static final boolean isInt(@NotNull ConeKotlinType $this$isInt) {
        Intrinsics.checkNotNullParameter($this$isInt, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isInt, StandardClassIds.INSTANCE.getInt(), false);
    }

    public static final boolean isLong(@NotNull ConeKotlinType $this$isLong) {
        Intrinsics.checkNotNullParameter($this$isLong, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isLong, StandardClassIds.INSTANCE.getLong(), false);
    }

    public static final boolean isFloat(@NotNull ConeKotlinType $this$isFloat) {
        Intrinsics.checkNotNullParameter($this$isFloat, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isFloat, StandardClassIds.INSTANCE.getFloat(), false);
    }

    public static final boolean isDouble(@NotNull ConeKotlinType $this$isDouble) {
        Intrinsics.checkNotNullParameter($this$isDouble, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isDouble, StandardClassIds.INSTANCE.getDouble(), false);
    }

    public static final boolean isAny(@NotNull ConeKotlinType $this$isAny) {
        Intrinsics.checkNotNullParameter($this$isAny, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isAny, StandardClassIds.INSTANCE.getAny(), false);
    }

    public static final boolean isNullableAny(@NotNull ConeKotlinType $this$isNullableAny) {
        Intrinsics.checkNotNullParameter($this$isNullableAny, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isNullableAny, StandardClassIds.INSTANCE.getAny(), true);
    }

    public static final boolean isNothing(@NotNull ConeKotlinType $this$isNothing) {
        Intrinsics.checkNotNullParameter($this$isNothing, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isNothing, StandardClassIds.INSTANCE.getNothing(), false);
    }

    public static final boolean isNullableNothing(@NotNull ConeKotlinType $this$isNullableNothing) {
        Intrinsics.checkNotNullParameter($this$isNullableNothing, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isNullableNothing, StandardClassIds.INSTANCE.getNothing(), true);
    }

    public static final boolean isUnit(@NotNull ConeKotlinType $this$isUnit) {
        Intrinsics.checkNotNullParameter($this$isUnit, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isUnit, StandardClassIds.INSTANCE.getUnit(), false);
    }

    public static final boolean isBoolean(@NotNull ConeKotlinType $this$isBoolean) {
        Intrinsics.checkNotNullParameter($this$isBoolean, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isBoolean, StandardClassIds.INSTANCE.getBoolean(), false);
    }

    public static final boolean isNullableBoolean(@NotNull ConeKotlinType $this$isNullableBoolean) {
        Intrinsics.checkNotNullParameter($this$isNullableBoolean, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isNullableBoolean, StandardClassIds.INSTANCE.getBoolean(), true);
    }

    public static final boolean isBooleanOrNullableBoolean(@NotNull ConeKotlinType $this$isBooleanOrNullableBoolean) {
        Intrinsics.checkNotNullParameter($this$isBooleanOrNullableBoolean, "<this>");
        return ConeBuiltinTypeUtilsKt.isAnyOfBuiltinType($this$isBooleanOrNullableBoolean, SetsKt.setOf(StandardClassIds.INSTANCE.getBoolean()));
    }

    public static final boolean isChar(@NotNull ConeKotlinType $this$isChar) {
        Intrinsics.checkNotNullParameter($this$isChar, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isChar, StandardClassIds.INSTANCE.getChar(), false);
    }

    public static final boolean isString(@NotNull ConeKotlinType $this$isString) {
        Intrinsics.checkNotNullParameter($this$isString, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isString, StandardClassIds.INSTANCE.getString(), false);
    }

    public static final boolean isEnum(@NotNull ConeKotlinType $this$isEnum) {
        Intrinsics.checkNotNullParameter($this$isEnum, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isEnum, StandardClassIds.INSTANCE.getEnum(), false);
    }

    public static final boolean isUInt(@NotNull ConeKotlinType $this$isUInt) {
        Intrinsics.checkNotNullParameter($this$isUInt, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isUInt, StandardClassIds.INSTANCE.getUInt(), false);
    }

    public static final boolean isULong(@NotNull ConeKotlinType $this$isULong) {
        Intrinsics.checkNotNullParameter($this$isULong, "<this>");
        return ConeBuiltinTypeUtilsKt.isBuiltinType($this$isULong, StandardClassIds.INSTANCE.getULong(), false);
    }

    public static final boolean isPrimitiveOrNullablePrimitive(@NotNull ConeKotlinType $this$isPrimitiveOrNullablePrimitive) {
        Intrinsics.checkNotNullParameter($this$isPrimitiveOrNullablePrimitive, "<this>");
        return ConeBuiltinTypeUtilsKt.isAnyOfBuiltinType($this$isPrimitiveOrNullablePrimitive, StandardClassIds.INSTANCE.getPrimitiveTypes());
    }

    public static final boolean isPrimitive(@NotNull ConeKotlinType $this$isPrimitive) {
        Intrinsics.checkNotNullParameter($this$isPrimitive, "<this>");
        return ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive($this$isPrimitive) && $this$isPrimitive.getNullability() == ConeNullability.NOT_NULL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isArrayType(@NotNull ConeKotlinType $this$isArrayType) {
        ClassId it;
        Intrinsics.checkNotNullParameter($this$isArrayType, "<this>");
        if (ConeBuiltinTypeUtilsKt.isBuiltinType($this$isArrayType, StandardClassIds.INSTANCE.getArray(), false)) return true;
        Iterable $this$any$iv = StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (ClassId)element$iv;
            boolean bl = false;
        } while (!ConeBuiltinTypeUtilsKt.isBuiltinType($this$isArrayType, it, false));
        return true;
    }

    public static final boolean isNonPrimitiveArray(@NotNull ConeKotlinType $this$isNonPrimitiveArray) {
        Intrinsics.checkNotNullParameter($this$isNonPrimitiveArray, "<this>");
        return $this$isNonPrimitiveArray instanceof ConeClassLikeType && Intrinsics.areEqual(((ConeClassLikeType)$this$isNonPrimitiveArray).getLookupTag().getClassId(), StandardClassIds.INSTANCE.getArray());
    }

    public static final boolean isPrimitiveArray(@NotNull ConeKotlinType $this$isPrimitiveArray) {
        Intrinsics.checkNotNullParameter($this$isPrimitiveArray, "<this>");
        return $this$isPrimitiveArray instanceof ConeClassLikeType && StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values().contains(((ConeClassLikeType)$this$isPrimitiveArray).getLookupTag().getClassId());
    }

    public static final boolean isUnsignedTypeOrNullableUnsignedType(@NotNull ConeKotlinType $this$isUnsignedTypeOrNullableUnsignedType) {
        Intrinsics.checkNotNullParameter($this$isUnsignedTypeOrNullableUnsignedType, "<this>");
        return ConeBuiltinTypeUtilsKt.isAnyOfBuiltinType($this$isUnsignedTypeOrNullableUnsignedType, StandardClassIds.INSTANCE.getUnsignedTypes());
    }

    public static final boolean isUnsignedType(@NotNull ConeKotlinType $this$isUnsignedType) {
        Intrinsics.checkNotNullParameter($this$isUnsignedType, "<this>");
        return ConeBuiltinTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType($this$isUnsignedType) && $this$isUnsignedType.getNullability() == ConeNullability.NOT_NULL;
    }

    public static final boolean isIntegerTypeOrNullableIntegerTypeOfAnySize(@NotNull ConeKotlinType $this$isIntegerTypeOrNullableIntegerTypeOfAnySize) {
        Intrinsics.checkNotNullParameter($this$isIntegerTypeOrNullableIntegerTypeOfAnySize, "<this>");
        return ConeBuiltinTypeUtilsKt.isAnyOfBuiltinType($this$isIntegerTypeOrNullableIntegerTypeOfAnySize, builtinIntegerTypes);
    }

    private static final boolean isBuiltinType(ConeKotlinType $this$isBuiltinType, ClassId classId, Boolean isNullable) {
        if (!($this$isBuiltinType instanceof ConeClassLikeType)) {
            return false;
        }
        return Intrinsics.areEqual(((ConeClassLikeType)$this$isBuiltinType).getLookupTag().getClassId(), classId) && (isNullable == null || Intrinsics.areEqual(ConeTypeUtilsKt.isNullable($this$isBuiltinType.getType()), isNullable));
    }

    private static final boolean isAnyOfBuiltinType(ConeKotlinType $this$isAnyOfBuiltinType, Set<ClassId> classIds) {
        if (!($this$isAnyOfBuiltinType instanceof ConeClassLikeType)) {
            return false;
        }
        return classIds.contains(((ConeClassLikeType)$this$isAnyOfBuiltinType).getLookupTag().getClassId());
    }

    static {
        ClassId[] classIdArray = new ClassId[]{StandardClassIds.INSTANCE.getInt(), StandardClassIds.INSTANCE.getByte(), StandardClassIds.INSTANCE.getLong(), StandardClassIds.INSTANCE.getShort()};
        builtinIntegerTypes = SetsKt.setOf(classIdArray);
    }
}

