/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmInstrWithLocation;
import org.jetbrains.kotlin.wasm.ir.WasmIrExpressionBuilderKt;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J-\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001bH\u0002\u00a2\u0006\u0002\u0010\u001dJ1\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b\"\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010 R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/WasmIrExpressionBuilder;", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "expression", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "(Ljava/util/List;)V", "eatEverythingUntilLevel", "", "Ljava/lang/Integer;", "getExpression", "()Ljava/util/List;", "lastInstr", "getLastInstr", "()Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "value", "numberOfNestedBlocks", "getNumberOfNestedBlocks", "()I", "setNumberOfNestedBlocks", "(I)V", "addInstruction", "", "op", "Lorg/jetbrains/kotlin/wasm/ir/WasmOp;", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "immediates", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;[Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;)V", "buildInstr", "getCurrentEatLevel", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;)Ljava/lang/Integer;", "wasm.ir"})
@SourceDebugExtension(value={"SMAP\nWasmIrExpressionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmIrExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmIrExpressionBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class WasmIrExpressionBuilder
extends WasmExpressionBuilder {
    @NotNull
    private final List<WasmInstr> expression;
    @Nullable
    private Integer eatEverythingUntilLevel;
    private int numberOfNestedBlocks;

    public WasmIrExpressionBuilder(@NotNull List<WasmInstr> expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.expression = expression2;
    }

    @NotNull
    public final List<WasmInstr> getExpression() {
        return this.expression;
    }

    private final WasmInstr getLastInstr() {
        return CollectionsKt.lastOrNull(this.expression);
    }

    private final void addInstruction(WasmOp op, SourceLocation location, WasmImmediate[] immediates) {
        WasmInstrWithLocation newInstruction = new WasmInstrWithLocation(op, ArraysKt.toList(immediates), location);
        this.expression.add(newInstruction);
    }

    private final Integer getCurrentEatLevel(WasmOp op) {
        Integer n = this.eatEverythingUntilLevel;
        if (n == null) {
            return null;
        }
        int eatLevel = n;
        if (this.getNumberOfNestedBlocks() == eatLevel && WasmIrExpressionBuilderKt.access$isInCfgNode(op)) {
            this.eatEverythingUntilLevel = null;
            return null;
        }
        if (this.getNumberOfNestedBlocks() < eatLevel) {
            this.eatEverythingUntilLevel = null;
            return null;
        }
        return eatLevel;
    }

    @Override
    public void buildInstr(@NotNull WasmOp op, @NotNull SourceLocation location, WasmImmediate ... immediates) {
        WasmInstr lastInstruction;
        Intrinsics.checkNotNullParameter((Object)op, "op");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(immediates, "immediates");
        Integer currentEatUntil = this.getCurrentEatLevel(op);
        if (currentEatUntil != null) {
            if (currentEatUntil <= this.getNumberOfNestedBlocks()) {
                return;
            }
        } else if (WasmIrExpressionBuilderKt.access$isOutCfgNode(op)) {
            this.eatEverythingUntilLevel = this.getNumberOfNestedBlocks();
            this.addInstruction(op, location, immediates);
            return;
        }
        if ((lastInstruction = this.getLastInstr()) == null) {
            this.addInstruction(op, location, immediates);
            return;
        }
        WasmOp lastOperator = lastInstruction.getOperator();
        if ((op == WasmOp.DROP || op == WasmOp.UNREACHABLE) && WasmIrExpressionBuilderKt.access$pureStacklessInstruction(lastOperator)) {
            CollectionsKt.removeLast(this.expression);
            return;
        }
        if (lastOperator == WasmOp.LOCAL_SET && op == WasmOp.LOCAL_GET) {
            WasmSymbol<WasmLocal> localSetNumber;
            WasmImmediate wasmImmediate = CollectionsKt.firstOrNull(lastInstruction.getImmediates());
            WasmImmediate.LocalIdx localIdx = wasmImmediate instanceof WasmImmediate.LocalIdx ? (WasmImmediate.LocalIdx)wasmImmediate : null;
            WasmSymbol<WasmLocal> wasmSymbol = localSetNumber = localIdx != null ? localIdx.getValue() : null;
            if (localSetNumber != null) {
                WasmSymbol<WasmLocal> localGetNumber;
                WasmImmediate wasmImmediate2 = ArraysKt.firstOrNull(immediates);
                WasmImmediate.LocalIdx localIdx2 = wasmImmediate2 instanceof WasmImmediate.LocalIdx ? (WasmImmediate.LocalIdx)wasmImmediate2 : null;
                WasmSymbol<WasmLocal> wasmSymbol2 = localGetNumber = localIdx2 != null ? localIdx2.getValue() : null;
                if (Intrinsics.areEqual(localGetNumber, localSetNumber)) {
                    CollectionsKt.removeLast(this.expression);
                    this.addInstruction(WasmOp.LOCAL_TEE, location, immediates);
                    return;
                }
            }
        }
        this.addInstruction(op, location, immediates);
    }

    @Override
    public int getNumberOfNestedBlocks() {
        return this.numberOfNestedBlocks;
    }

    @Override
    public void setNumberOfNestedBlocks(int value2) {
        boolean bl;
        boolean bl2 = bl = value2 >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "end without matching block";
            throw new AssertionError((Object)string2);
        }
        this.numberOfNestedBlocks = value2;
    }
}

