/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.diagnostics.TextDiagnostic;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0005R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/checkers/DiagnosedRange;", "", "start", "", "<init>", "(I)V", "getStart", "()I", "end", "getEnd", "setEnd", "diagnostics", "Lorg/jetbrains/kotlin/utils/SmartList;", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic;", "getDiagnostics", "", "addDiagnostic", "", "diagnostic", "", "frontend"})
public final class DiagnosedRange {
    private final int start;
    private int end;
    @NotNull
    private final SmartList<TextDiagnostic> diagnostics;

    public DiagnosedRange(int start) {
        this.start = start;
        this.diagnostics = new SmartList();
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public final void setEnd(int n) {
        this.end = n;
    }

    @NotNull
    public final List<TextDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public final void addDiagnostic(@NotNull String diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        this.diagnostics.add(TextDiagnostic.Companion.parseDiagnostic(diagnostic));
    }
}

