/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.RangeToIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.RangeUntilIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.jsAstUtils.AstUtilsKt;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public enum PrimitiveBinaryOperationFIF implements FunctionIntrinsicFactory
{
    INSTANCE;

    private static final BinaryOperationIntrinsicBase INT_MULTIPLICATION_INTRINSIC;
    private static final BinaryOperationIntrinsicBase NUMBER_REM_INTRINSIC;
    @NotNull
    private static final BinaryOperationIntrinsicBase BUILTINS_COMPARE_TO_INTRINSIC;
    @NotNull
    private static final BinaryOperationIntrinsicBase PRIMITIVE_NUMBER_COMPARE_TO_INTRINSIC;
    @NotNull
    private static final NamePredicate BINARY_OPERATIONS;
    private static final DescriptorPredicate INT_BINARY_OPERATIONS;
    private static final DescriptorPredicate SIMPLE_INT_MULTIPLICATION;
    private static final DescriptorPredicate INT_DIVISION;
    private static final DescriptorPredicate PRIMITIVE_NUMBERS_BINARY_OPERATIONS;
    private static final DescriptorPredicate PRIMITIVE_INTEGRAL_NUMBERS_COMPARE_TO_INTEGRAL_OPERATIONS;
    private static final DescriptorPredicate PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS;
    private static final Predicate<FunctionDescriptor> INT_WITH_BIT_OPERATIONS;
    private static final DescriptorPredicate BOOLEAN_OPERATIONS;
    private static final DescriptorPredicate STRING_PLUS;
    private static final DescriptorPredicate INT_MULTIPLICATION;
    private static final DescriptorPredicate NUMBER_REM;
    private static final DescriptorPredicate CHAR_RANGE_TO;
    private static final DescriptorPredicate CHAR_RANGE_UNTIL;
    private static final DescriptorPredicate NUMBER_RANGE_TO;
    private static final DescriptorPredicate NUMBER_RANGE_UNTIL;
    private static final ImmutableMap<String, JsBinaryOperator> BINARY_BITWISE_OPERATIONS;
    private static final Predicate<FunctionDescriptor> PREDICATE;

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor, @NotNull TranslationContext context2) {
        JsBinaryOperator op;
        if (descriptor == null) {
            PrimitiveBinaryOperationFIF.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            PrimitiveBinaryOperationFIF.$$$reportNull$$$0(1);
        }
        if (CHAR_RANGE_TO.test(descriptor)) {
            return new RangeToIntrinsic(descriptor);
        }
        if (CHAR_RANGE_UNTIL.test(descriptor)) {
            return new RangeUntilIntrinsic(descriptor);
        }
        if (PRIMITIVE_INTEGRAL_NUMBERS_COMPARE_TO_INTEGRAL_OPERATIONS.test(descriptor)) {
            return PRIMITIVE_NUMBER_COMPARE_TO_INTRINSIC;
        }
        if (PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS.test(descriptor)) {
            return BUILTINS_COMPARE_TO_INTRINSIC;
        }
        if (KotlinBuiltIns.isBuiltIn(descriptor) && descriptor.getName().equals(OperatorNameConventions.COMPARE_TO)) {
            return BUILTINS_COMPARE_TO_INTRINSIC;
        }
        if (NUMBER_RANGE_UNTIL.test(descriptor)) {
            return new RangeUntilIntrinsic(descriptor);
        }
        if (!PREDICATE.test(descriptor)) {
            return null;
        }
        if (INT_MULTIPLICATION.test(descriptor)) {
            return INT_MULTIPLICATION_INTRINSIC;
        }
        if (NUMBER_REM.test(descriptor)) {
            return NUMBER_REM_INTRINSIC;
        }
        if (NUMBER_RANGE_TO.test(descriptor)) {
            return new RangeToIntrinsic(descriptor);
        }
        if (INT_WITH_BIT_OPERATIONS.test(descriptor) && (op = BINARY_BITWISE_OPERATIONS.get(descriptor.getName().asString())) != null) {
            return new OptimizedIntBinaryOperationInstrinsic(op);
        }
        JsBinaryOperator operator = PrimitiveBinaryOperationFIF.getOperator(descriptor);
        if (INT_BINARY_OPERATIONS.test(descriptor)) {
            return new AdditiveIntBinaryOperationInstrinsic(operator);
        }
        if (SIMPLE_INT_MULTIPLICATION.test(descriptor) || INT_DIVISION.test(descriptor)) {
            return new IntBinaryOperationFunctionIntrinsic(operator);
        }
        PrimitiveBinaryOperationFunctionIntrinsic result2 = new PrimitiveBinaryOperationFunctionIntrinsic(operator);
        if (PatternBuilder.pattern("Char.plus|minus(Int)").test(descriptor)) {
            return new CharAndIntBinaryOperationFunctionIntrinsic(result2);
        }
        if (PatternBuilder.pattern("Char.minus(Char)").test(descriptor)) {
            return new CharAndCharBinaryOperationFunctionIntrinsic(result2);
        }
        if (PatternBuilder.pattern("String.plus(Any)").test(descriptor)) {
            return new StringAndCharBinaryOperationFunctionIntrinsic(result2);
        }
        return result2;
    }

    @NotNull
    private static JsBinaryOperator getOperator(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            PrimitiveBinaryOperationFIF.$$$reportNull$$$0(2);
        }
        Name descriptorName = descriptor.getName().equals(OperatorNameConventions.MOD) ? OperatorNameConventions.REM : descriptor.getName();
        switch (descriptorName.asString()) {
            case "or": {
                JsBinaryOperator jsBinaryOperator = JsBinaryOperator.BIT_OR;
                if (jsBinaryOperator == null) {
                    PrimitiveBinaryOperationFIF.$$$reportNull$$$0(3);
                }
                return jsBinaryOperator;
            }
            case "and": {
                JsBinaryOperator jsBinaryOperator = JsBinaryOperator.BIT_AND;
                if (jsBinaryOperator == null) {
                    PrimitiveBinaryOperationFIF.$$$reportNull$$$0(4);
                }
                return jsBinaryOperator;
            }
            case "xor": {
                JsBinaryOperator jsBinaryOperator = JsBinaryOperator.BIT_XOR;
                if (jsBinaryOperator == null) {
                    PrimitiveBinaryOperationFIF.$$$reportNull$$$0(5);
                }
                return jsBinaryOperator;
            }
        }
        KtToken token = (KtToken)((ImmutableMap)((Object)OperatorConventions.BINARY_OPERATION_NAMES.inverse())).get(descriptorName);
        JsBinaryOperator jsBinaryOperator = OperatorTable.getBinaryOperator(token);
        if (jsBinaryOperator == null) {
            PrimitiveBinaryOperationFIF.$$$reportNull$$$0(6);
        }
        return jsBinaryOperator;
    }

    static {
        INT_MULTIPLICATION_INTRINSIC = new BinaryOperationIntrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
                if (left == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (right == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (context2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (this.isSafeConstant(left) || this.isSafeConstant(right)) {
                    JsExpression jsExpression = JsAstUtils.toInt32(JsAstUtils.mul(left, right));
                    if (jsExpression == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return jsExpression;
                }
                return new JsInvocation((JsExpression)Namer.imul(), left, right);
            }

            private boolean isSafeConstant(@NotNull JsExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (!(expression2 instanceof JsIntLiteral)) {
                    return false;
                }
                int value2 = ((JsIntLiteral)expression2).value;
                return Math.abs(value2) < 0x100000;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "left";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "right";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doApply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doApply";
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "isSafeConstant";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        NUMBER_REM_INTRINSIC = new BinaryOperationIntrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
                if (left == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (right == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (context2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                JsExpression jsExpression = JsAstUtils.toInt32(JsAstUtils.mod(left, right));
                if (jsExpression == null) {
                    2.$$$reportNull$$$0(3);
                }
                return jsExpression;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "left";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "right";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doApply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doApply";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        BUILTINS_COMPARE_TO_INTRINSIC = new BinaryOperationIntrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
                if (left == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (right == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (context2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                JsExpression jsExpression = JsAstUtils.compareTo(left, right);
                if (jsExpression == null) {
                    3.$$$reportNull$$$0(3);
                }
                return jsExpression;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "left";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "right";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$3";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doApply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doApply";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        PRIMITIVE_NUMBER_COMPARE_TO_INTRINSIC = new BinaryOperationIntrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
                if (left == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (right == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (context2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                JsExpression jsExpression = JsAstUtils.primitiveCompareTo(left, right);
                if (jsExpression == null) {
                    4.$$$reportNull$$$0(3);
                }
                return jsExpression;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "left";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "right";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$4";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doApply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doApply";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        BINARY_OPERATIONS = new NamePredicate(OperatorNameConventions.BINARY_OPERATION_NAMES);
        INT_BINARY_OPERATIONS = PatternBuilder.pattern("Int.plus|minus(Int)");
        SIMPLE_INT_MULTIPLICATION = PatternBuilder.pattern("Byte|Short.times(Byte|Short)");
        INT_DIVISION = PatternBuilder.pattern("Byte|Short|Int.div(Byte|Short|Int)");
        PRIMITIVE_NUMBERS_BINARY_OPERATIONS = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS, BINARY_OPERATIONS);
        PRIMITIVE_INTEGRAL_NUMBERS_COMPARE_TO_INTEGRAL_OPERATIONS = PatternBuilder.pattern("Byte|Short|Int.compareTo(Byte|Short|Int)");
        PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS, "compareTo");
        INT_WITH_BIT_OPERATIONS = PatternBuilder.pattern("Int.or|and|xor|shl|shr|ushr").or(PatternBuilder.pattern("Short|Byte.or|and|xor"));
        BOOLEAN_OPERATIONS = PatternBuilder.pattern("Boolean.or|and|xor");
        STRING_PLUS = PatternBuilder.pattern("String.plus");
        INT_MULTIPLICATION = PatternBuilder.pattern("Int.times(Int)");
        NUMBER_REM = PatternBuilder.pattern("Byte|Short|Int.rem(Byte|Short|Int)");
        CHAR_RANGE_TO = PatternBuilder.pattern("Char.rangeTo(Char)");
        CHAR_RANGE_UNTIL = PatternBuilder.pattern("Char.rangeUntil(Char)");
        NUMBER_RANGE_TO = PatternBuilder.pattern("Byte|Short|Int.rangeTo(Byte|Short|Int)");
        NUMBER_RANGE_UNTIL = PatternBuilder.pattern("Byte|Short|Int|Long.rangeUntil(Byte|Short|Int|Long)");
        BINARY_BITWISE_OPERATIONS = ImmutableMap.builder().put("or", JsBinaryOperator.BIT_OR).put("and", JsBinaryOperator.BIT_AND).put("xor", JsBinaryOperator.BIT_XOR).put("shl", JsBinaryOperator.SHL).put("shr", JsBinaryOperator.SHR).put("ushr", JsBinaryOperator.SHRU).build();
        PREDICATE = PRIMITIVE_NUMBERS_BINARY_OPERATIONS.or(BOOLEAN_OPERATIONS).or(STRING_PLUS).or(INT_WITH_BIT_OPERATIONS).or(PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIntrinsic";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOperator";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StringAndCharBinaryOperationFunctionIntrinsic
    extends BinaryOperationIntrinsicBase {
        @NotNull
        private final BinaryOperationIntrinsicBase functionIntrinsic;

        private StringAndCharBinaryOperationFunctionIntrinsic(@NotNull BinaryOperationIntrinsicBase functionIntrinsic) {
            if (functionIntrinsic == null) {
                StringAndCharBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(0);
            }
            this.functionIntrinsic = functionIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
            if (left == null) {
                StringAndCharBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(1);
            }
            if (right == null) {
                StringAndCharBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                StringAndCharBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(3);
            }
            JsExpression jsExpression = this.functionIntrinsic.doApply(left, TopLevelFIF.TO_STRING.apply(right, Collections.emptyList(), context2), context2);
            if (jsExpression == null) {
                StringAndCharBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(4);
            }
            return jsExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionIntrinsic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$StringAndCharBinaryOperationFunctionIntrinsic";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$StringAndCharBinaryOperationFunctionIntrinsic";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doApply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doApply";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CharAndCharBinaryOperationFunctionIntrinsic
    extends BinaryOperationIntrinsicBase {
        @NotNull
        private final BinaryOperationIntrinsicBase functionIntrinsic;

        private CharAndCharBinaryOperationFunctionIntrinsic(@NotNull BinaryOperationIntrinsicBase functionIntrinsic) {
            if (functionIntrinsic == null) {
                CharAndCharBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(0);
            }
            this.functionIntrinsic = functionIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
            if (left == null) {
                CharAndCharBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(1);
            }
            if (right == null) {
                CharAndCharBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                CharAndCharBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(3);
            }
            JsExpression jsExpression = this.functionIntrinsic.doApply(left, right, context2);
            if (jsExpression == null) {
                CharAndCharBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(4);
            }
            return jsExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionIntrinsic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$CharAndCharBinaryOperationFunctionIntrinsic";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$CharAndCharBinaryOperationFunctionIntrinsic";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doApply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doApply";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CharAndIntBinaryOperationFunctionIntrinsic
    extends BinaryOperationIntrinsicBase {
        @NotNull
        private final BinaryOperationIntrinsicBase functionIntrinsic;

        private CharAndIntBinaryOperationFunctionIntrinsic(@NotNull BinaryOperationIntrinsicBase functionIntrinsic) {
            if (functionIntrinsic == null) {
                CharAndIntBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(0);
            }
            this.functionIntrinsic = functionIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
            if (left == null) {
                CharAndIntBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(1);
            }
            if (right == null) {
                CharAndIntBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                CharAndIntBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(3);
            }
            JsInvocation jsInvocation = AstUtilsKt.toChar(context2, this.functionIntrinsic.doApply(left, right, context2));
            if (jsInvocation == null) {
                CharAndIntBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(4);
            }
            return jsInvocation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionIntrinsic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$CharAndIntBinaryOperationFunctionIntrinsic";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$CharAndIntBinaryOperationFunctionIntrinsic";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doApply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doApply";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AdditiveIntBinaryOperationInstrinsic
    extends OptimizedIntBinaryOperationInstrinsic {
        public AdditiveIntBinaryOperationInstrinsic(@NotNull JsBinaryOperator operator) {
            if (operator == null) {
                AdditiveIntBinaryOperationInstrinsic.$$$reportNull$$$0(0);
            }
            super(operator);
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
            if (left == null) {
                AdditiveIntBinaryOperationInstrinsic.$$$reportNull$$$0(1);
            }
            if (right == null) {
                AdditiveIntBinaryOperationInstrinsic.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                AdditiveIntBinaryOperationInstrinsic.$$$reportNull$$$0(3);
            }
            JsExpression jsExpression = JsAstUtils.toInt32(super.doApply(left, right, context2));
            if (jsExpression == null) {
                AdditiveIntBinaryOperationInstrinsic.$$$reportNull$$$0(4);
            }
            return jsExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$AdditiveIntBinaryOperationInstrinsic";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$AdditiveIntBinaryOperationInstrinsic";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doApply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doApply";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OptimizedIntBinaryOperationInstrinsic
    extends PrimitiveBinaryOperationFunctionIntrinsic {
        public OptimizedIntBinaryOperationInstrinsic(@NotNull JsBinaryOperator operator) {
            if (operator == null) {
                OptimizedIntBinaryOperationInstrinsic.$$$reportNull$$$0(0);
            }
            super(operator);
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
            if (left == null) {
                OptimizedIntBinaryOperationInstrinsic.$$$reportNull$$$0(1);
            }
            if (right == null) {
                OptimizedIntBinaryOperationInstrinsic.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                OptimizedIntBinaryOperationInstrinsic.$$$reportNull$$$0(3);
            }
            left = OptimizedIntBinaryOperationInstrinsic.unwrapAdditive(left);
            right = OptimizedIntBinaryOperationInstrinsic.unwrapAdditive(right);
            JsExpression jsExpression = super.doApply(left, right, context2);
            if (jsExpression == null) {
                OptimizedIntBinaryOperationInstrinsic.$$$reportNull$$$0(4);
            }
            return jsExpression;
        }

        @NotNull
        private static JsExpression unwrapAdditive(@NotNull JsExpression expression2) {
            JsExpression toIntArgument;
            if (expression2 == null) {
                OptimizedIntBinaryOperationInstrinsic.$$$reportNull$$$0(5);
            }
            if ((toIntArgument = JsAstUtils.extractToInt32Argument(expression2)) == null) {
                JsExpression jsExpression = expression2;
                if (jsExpression == null) {
                    OptimizedIntBinaryOperationInstrinsic.$$$reportNull$$$0(6);
                }
                return jsExpression;
            }
            if (!(toIntArgument instanceof JsBinaryOperation)) {
                JsExpression jsExpression = expression2;
                if (jsExpression == null) {
                    OptimizedIntBinaryOperationInstrinsic.$$$reportNull$$$0(7);
                }
                return jsExpression;
            }
            JsBinaryOperator operator = ((JsBinaryOperation)toIntArgument).getOperator();
            switch (operator) {
                case ADD: 
                case SUB: {
                    JsExpression jsExpression = toIntArgument;
                    if (jsExpression == null) {
                        OptimizedIntBinaryOperationInstrinsic.$$$reportNull$$$0(8);
                    }
                    return jsExpression;
                }
            }
            JsExpression jsExpression = expression2;
            if (jsExpression == null) {
                OptimizedIntBinaryOperationInstrinsic.$$$reportNull$$$0(9);
            }
            return jsExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$OptimizedIntBinaryOperationInstrinsic";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$OptimizedIntBinaryOperationInstrinsic";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doApply";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unwrapAdditive";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doApply";
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "unwrapAdditive";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IntBinaryOperationFunctionIntrinsic
    extends PrimitiveBinaryOperationFunctionIntrinsic {
        private IntBinaryOperationFunctionIntrinsic(@NotNull JsBinaryOperator operator) {
            if (operator == null) {
                IntBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(0);
            }
            super(operator);
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
            if (left == null) {
                IntBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(1);
            }
            if (right == null) {
                IntBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                IntBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(3);
            }
            JsExpression jsExpression = JsAstUtils.toInt32(super.doApply(left, right, context2));
            if (jsExpression == null) {
                IntBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(4);
            }
            return jsExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$IntBinaryOperationFunctionIntrinsic";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$IntBinaryOperationFunctionIntrinsic";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doApply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doApply";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PrimitiveBinaryOperationFunctionIntrinsic
    extends BinaryOperationIntrinsicBase {
        @NotNull
        private final JsBinaryOperator operator;

        private PrimitiveBinaryOperationFunctionIntrinsic(@NotNull JsBinaryOperator operator) {
            if (operator == null) {
                PrimitiveBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(0);
            }
            this.operator = operator;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
            if (left == null) {
                PrimitiveBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(1);
            }
            if (right == null) {
                PrimitiveBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                PrimitiveBinaryOperationFunctionIntrinsic.$$$reportNull$$$0(3);
            }
            return new JsBinaryOperation(this.operator, left, right);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doApply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class BinaryOperationIntrinsicBase
    extends FunctionIntrinsicWithReceiverComputed {
        private BinaryOperationIntrinsicBase() {
        }

        @NotNull
        public abstract JsExpression doApply(@NotNull JsExpression var1, @NotNull JsExpression var2, @NotNull TranslationContext var3);

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments, @NotNull TranslationContext context2) {
            if (arguments == null) {
                BinaryOperationIntrinsicBase.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                BinaryOperationIntrinsicBase.$$$reportNull$$$0(1);
            }
            assert (receiver != null);
            assert (arguments.size() == 1);
            JsExpression jsExpression = this.doApply(receiver, arguments.get(0), context2);
            if (jsExpression == null) {
                BinaryOperationIntrinsicBase.$$$reportNull$$$0(2);
            }
            return jsExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$BinaryOperationIntrinsicBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$BinaryOperationIntrinsicBase";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

