/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/UnsupportedUntilRangeDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class UnsupportedUntilRangeDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final UnsupportedUntilRangeDeclarationChecker INSTANCE = new UnsupportedUntilRangeDeclarationChecker();

    private UnsupportedUntilRangeDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        boolean isRangeUntilOperatorSupported = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.RangeUntilOperator);
        if (!isRangeUntilOperatorSupported && descriptor instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor).isOperator() && Intrinsics.areEqual(((FunctionDescriptor)descriptor).getName(), OperatorNameConventions.RANGE_UNTIL)) {
            PsiElement psiElement = declaration.getModifierList();
            if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.OPERATOR_KEYWORD)) == null) {
                return;
            }
            PsiElement operatorKeyword = psiElement;
            context2.getTrace().report(Errors.UNSUPPORTED_FEATURE.on(operatorKeyword, TuplesKt.to(LanguageFeature.RangeUntilOperator, context2.getLanguageVersionSettings())));
        }
    }
}

