/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.dce;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.ir.backend.js.dce.UsefulDeclarationProcessor;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.TypeTranformerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u0016*\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u001c\u0010\u001a\u001a\u00020\u0016*\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\f\u0010\u001b\u001a\u00020\u0016*\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0014J\u0014\u0010\"\u001a\u00020\u0016*\u00020#2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u000eH\u0014J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0018H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00060\u0010R\u00020\u0001X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/dce/WasmUsefulDeclarationProcessor;", "Lorg/jetbrains/kotlin/ir/backend/js/dce/UsefulDeclarationProcessor;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "printReachabilityInfo", "", "dumpReachabilityInfoToFile", "", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;ZLjava/lang/String;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "kotlinClosureToJsClosureConvertFunToKotlinClosureCallFun", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "bodyVisitor", "Lorg/jetbrains/kotlin/ir/backend/js/dce/UsefulDeclarationProcessor$BodyVisitorBase;", "getBodyVisitor", "()Lorg/jetbrains/kotlin/ir/backend/js/dce/UsefulDeclarationProcessor$BodyVisitorBase;", "getInlinedValueTypeIfAny", "Lorg/jetbrains/kotlin/ir/types/IrType;", "enqueueRuntimeClassOrAny", "", "from", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "info", "enqueueType", "enqueueParentClass", "processField", "irField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "processClass", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "enqueueValueParameterType", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "processIrFunction", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "processSimpleFunction", "processConstructor", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "isExported", "declaration", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmUsefulDeclarationProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmUsefulDeclarationProcessor.kt\norg/jetbrains/kotlin/backend/wasm/dce/WasmUsefulDeclarationProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1187#2,2:225\n1261#2,4:227\n1863#2,2:234\n1863#2,2:236\n20#3,2:231\n1#4:233\n*S KotlinDebug\n*F\n+ 1 WasmUsefulDeclarationProcessor.kt\norg/jetbrains/kotlin/backend/wasm/dce/WasmUsefulDeclarationProcessor\n*L\n27#1:225,2\n27#1:227,4\n189#1:234,2\n214#1:236,2\n169#1:231,2\n*E\n"})
public final class WasmUsefulDeclarationProcessor
extends UsefulDeclarationProcessor {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final Map<IrSimpleFunction, IrSimpleFunction> kotlinClosureToJsClosureConvertFunToKotlinClosureCallFun;
    @NotNull
    private final UsefulDeclarationProcessor.BodyVisitorBase bodyVisitor;

    /*
     * WARNING - void declaration
     */
    public WasmUsefulDeclarationProcessor(@NotNull WasmBackendContext context, boolean printReachabilityInfo, @Nullable String dumpReachabilityInfoToFile) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(context, "context");
        super(printReachabilityInfo, false, dumpReachabilityInfoToFile);
        this.context = context;
        Iterable iterable = this.getContext().getKotlinClosureToJsConverters().entrySet();
        WasmUsefulDeclarationProcessor wasmUsefulDeclarationProcessor = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        void var7_8 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Object object = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String k = (String)object.getKey();
            IrSimpleFunction v = (IrSimpleFunction)object.getValue();
            object = TuplesKt.to(v, this.getContext().getClosureCallExports().get(k));
            map.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
        }
        wasmUsefulDeclarationProcessor.kotlinClosureToJsClosureConvertFunToKotlinClosureCallFun = destination$iv$iv;
        this.bodyVisitor = new UsefulDeclarationProcessor.BodyVisitorBase(this){
            final /* synthetic */ WasmUsefulDeclarationProcessor this$0;
            {
                this.this$0 = $receiver;
                super($receiver);
            }

            public void visitConst(IrConst<?> expression2, IrDeclaration data) {
                block1: {
                    IrConstKind<?> irConstKind;
                    block0: {
                        Intrinsics.checkNotNullParameter(expression2, "expression");
                        Intrinsics.checkNotNullParameter(data, "data");
                        irConstKind = expression2.getKind();
                        if (!(irConstKind instanceof IrConstKind.Null)) break block0;
                        WasmUsefulDeclarationProcessor.access$enqueueType(this.this$0, expression2.getType(), data, "expression type");
                        break block1;
                    }
                    if (!(irConstKind instanceof IrConstKind.String)) break block1;
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, (IrDeclaration)this.this$0.getContext().getWasmSymbols().getStringGetLiteral().getOwner(), data, "String literal intrinsic getter stringGetLiteral", false, 4, null);
                }
            }

            public void visitVariable(IrVariable declaration, IrDeclaration data) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                Intrinsics.checkNotNullParameter(data, "data");
                WasmUsefulDeclarationProcessor.access$enqueueType(this.this$0, declaration.getType(), data, "local variable type");
                super.visitVariable(declaration, data);
            }

            /*
             * WARNING - void declaration
             */
            public void visitVararg(IrVararg expression2, IrDeclaration data) {
                Object v1;
                block2: {
                    void $this$firstOrNull$iv;
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    Intrinsics.checkNotNullParameter(data, "data");
                    IrClass irClass = IrTypesKt.getClass(expression2.getType());
                    Intrinsics.checkNotNull(irClass);
                    Sequence<IrConstructor> sequence2 = IrUtilsKt.getConstructors(irClass);
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        IrConstructor it = (IrConstructor)element$iv;
                        boolean bl = false;
                        if (!AnnotationsKt.hasWasmPrimitiveConstructorAnnotation(it)) continue;
                        v1 = element$iv;
                        break block2;
                    }
                    v1 = null;
                }
                IrConstructor irConstructor = v1;
                if (irConstructor != null) {
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, irConstructor, data, "implicit vararg constructor", false, 4, null);
                }
                super.visitVararg(expression2, data);
            }

            public void visitSetField(IrSetField expression2, IrDeclaration data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(data, "data");
                if (!IrJsUtilsKt.isObjectInstanceField((IrField)expression2.getSymbol().getOwner())) {
                    super.visitSetField(expression2, data);
                }
            }

            public void visitGetField(IrGetField expression2, IrDeclaration data) {
                IrConstructor irConstructor;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(data, "data");
                IrField field = (IrField)expression2.getSymbol().getOwner();
                if (IrJsUtilsKt.isObjectInstanceField(field) && (irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)IrTypesKt.getClassOrFail(field.getType()).getOwner())) != null) {
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, irConstructor, field, "object lazy initialization", false, 4, null);
                }
                super.visitGetField(expression2, data);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean tryToProcessIntrinsicCall(IrDeclaration from2, IrCall call2) {
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = call2.getSymbol();
                if (Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getWasmSymbols().getUnboxIntrinsic())) {
                    IrType fromType = call2.getTypeArgument(0);
                    if (fromType == null) return true;
                    if (IrTypePredicatesKt.isNothing(fromType)) return true;
                    if (IrTypePredicatesKt.isNullableNothing(fromType)) return true;
                    IrType irType = call2.getTypeArgument(1);
                    if (irType == null) return true;
                    IrType irType2 = irType;
                    WasmUsefulDeclarationProcessor wasmUsefulDeclarationProcessor = this.this$0;
                    IrType it = irType2;
                    boolean bl = false;
                    IrClass irClass = wasmUsefulDeclarationProcessor.getContext().getInlineClassesUtils().getInlinedClass(it);
                    if (irClass == null) return true;
                    IrClass it2 = irClass;
                    boolean bl2 = false;
                    IrField irField = InlineClassesKt.getInlineClassBackingField(it2);
                    IrField backingField = irField;
                    if (backingField == null) return true;
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, backingField, from2, "backing inline class field for unboxIntrinsic", false, 4, null);
                    return true;
                }
                if (Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getWasmSymbols().getWasmTypeId()) || Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getWasmSymbols().getRefCastNull()) || Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getWasmSymbols().getRefTest()) || Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getWasmSymbols().getWasmArrayCopy())) {
                    IrType fromType = call2.getTypeArgument(0);
                    if (fromType == null) return true;
                    WasmUsefulDeclarationProcessor.access$enqueueRuntimeClassOrAny(this.this$0, fromType, from2, "intrinsic " + ((IrSimpleFunction)call2.getSymbol().getOwner()).getName());
                    return true;
                }
                if (Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getWasmSymbols().getBoxIntrinsic())) {
                    IrType irType = call2.getTypeArgument(0);
                    Intrinsics.checkNotNull(irType);
                    IrType type2 = irType;
                    if (Intrinsics.areEqual(type2, this.this$0.getContext().getIrBuiltIns().getBooleanType())) {
                        UsefulDeclarationProcessor.enqueue$default(this.this$0, (IrDeclaration)this.this$0.getContext().getWasmSymbols().getGetBoxedBoolean().getOwner(), from2, "intrinsic boxIntrinsic", false, 4, null);
                        return true;
                    } else {
                        WasmUsefulDeclarationProcessor.access$enqueueRuntimeClassOrAny(this.this$0, type2, from2, "intrinsic boxIntrinsic");
                    }
                    return true;
                }
                if (!Intrinsics.areEqual(irSimpleFunctionSymbol, this.this$0.getContext().getWasmSymbols().getBoxBoolean())) return false;
                WasmUsefulDeclarationProcessor.access$enqueueRuntimeClassOrAny(this.this$0, this.this$0.getContext().getIrBuiltIns().getBooleanType(), from2, "intrinsic boxBoolean");
                return true;
            }

            public void visitCall(IrCall expression2, IrDeclaration data) {
                boolean isSuperCall;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(data, "data");
                super.visitCall(expression2, data);
                IrFunction function2 = IrResolveUtilsKt.getRealOverrideTarget((IrSimpleFunction)expression2.getSymbol().getOwner());
                if (this.tryToProcessIntrinsicCall(data, expression2)) {
                    return;
                }
                if (AnnotationsKt.hasWasmNoOpCastAnnotation(function2)) {
                    return;
                }
                if (AnnotationsKt.getWasmOpAnnotation(function2) != null) {
                    return;
                }
                boolean bl = isSuperCall = expression2.getSuperQualifierSymbol() != null;
                if (function2 instanceof IrSimpleFunction && IrUtilsKt.isOverridable((IrSimpleFunction)function2) && !isSuperCall) {
                    IrClass klass = IrUtilsKt.getParentAsClass(function2);
                    if (IrUtilsKt.isInterface(klass)) {
                        UsefulDeclarationProcessor.enqueue$default(this.this$0, klass, data, "receiver class", false, 4, null);
                    }
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, function2, data, "method call", false, 4, null);
                }
            }
        };
    }

    @Override
    @NotNull
    public WasmBackendContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    protected UsefulDeclarationProcessor.BodyVisitorBase getBodyVisitor() {
        return this.bodyVisitor;
    }

    private final IrType getInlinedValueTypeIfAny(IrType $this$getInlinedValueTypeIfAny) {
        IrType irType;
        IrType irType2 = $this$getInlinedValueTypeIfAny;
        if (Intrinsics.areEqual(irType2, this.getContext().getIrBuiltIns().getBooleanType()) || Intrinsics.areEqual(irType2, this.getContext().getIrBuiltIns().getByteType()) || Intrinsics.areEqual(irType2, this.getContext().getIrBuiltIns().getShortType()) || Intrinsics.areEqual(irType2, this.getContext().getIrBuiltIns().getCharType()) || Intrinsics.areEqual(irType2, this.getContext().getIrBuiltIns().getIntType()) || Intrinsics.areEqual(irType2, this.getContext().getIrBuiltIns().getLongType()) || Intrinsics.areEqual(irType2, this.getContext().getIrBuiltIns().getFloatType()) || Intrinsics.areEqual(irType2, this.getContext().getIrBuiltIns().getDoubleType()) || Intrinsics.areEqual(irType2, this.getContext().getIrBuiltIns().getNothingType()) || Intrinsics.areEqual(irType2, this.getContext().getIrBuiltIns().getNothingNType()) || Intrinsics.areEqual(irType2, this.getContext().getWasmSymbols().getVoidType())) {
            irType = null;
        } else if (TypeTransformerKt.isBuiltInWasmRefType($this$getInlinedValueTypeIfAny)) {
            irType = null;
        } else {
            IrClass ic;
            IrClass irClass = TypeTranformerKt.getErasedUpperBound($this$getInlinedValueTypeIfAny);
            irType = (irClass != null ? irClass.isExternal() : false) ? null : ((ic = this.getContext().getInlineClassesUtils().getInlinedClass($this$getInlinedValueTypeIfAny)) == null ? $this$getInlinedValueTypeIfAny : this.getInlinedValueTypeIfAny(this.getContext().getInlineClassesUtils().getInlineClassUnderlyingType(ic)));
        }
        return irType;
    }

    private final void enqueueRuntimeClassOrAny(IrType $this$enqueueRuntimeClassOrAny, IrDeclaration from2, String info) {
        this.enqueue(TypeTransformerKt.getRuntimeClass($this$enqueueRuntimeClassOrAny, this.getContext().getIrBuiltIns()), from2, info, false);
    }

    private final void enqueueType(IrType $this$enqueueType, IrDeclaration from2, String info) {
        IrType irType = this.getInlinedValueTypeIfAny($this$enqueueType);
        if (irType != null) {
            this.enqueueRuntimeClassOrAny(irType, from2, info);
        }
    }

    private final void enqueueParentClass(IrDeclaration $this$enqueueParentClass) {
        block0: {
            IrClass irClass = IrUtilsKt.getParentClassOrNull($this$enqueueParentClass);
            if (irClass == null) break block0;
            this.enqueue(irClass, $this$enqueueParentClass, "parent class", false);
        }
    }

    @Override
    protected void processField(@NotNull IrField irField) {
        Intrinsics.checkNotNullParameter(irField, "irField");
        super.processField(irField);
        this.enqueueParentClass(irField);
        this.enqueueType(irField.getType(), irField, "field types");
    }

    @Override
    protected void processClass(@NotNull IrClass irClass) {
        block5: {
            Object v0;
            Object object;
            Object object2;
            block4: {
                Intrinsics.checkNotNullParameter(irClass, "irClass");
                super.processClass(irClass);
                object2 = AnnotationsKt.getWasmArrayAnnotation(irClass);
                if (object2 != null && (object = ((WasmArrayInfo)object2).getType()) != null) {
                    this.enqueueType((IrType)object, irClass, "array type for wasm array annotated");
                }
                if (!this.getContext().getInlineClassesUtils().isClassInlineLike(irClass)) break block5;
                Iterable $this$firstIsInstanceOrNull$iv = irClass.getDeclarations();
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof IrConstructor)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            object2 = v0;
            if (object2 != null) {
                Object object3;
                Object it = object3 = object2;
                boolean bl = false;
                Object object4 = object = ((IrConstructor)it).isPrimary() ? object3 : null;
                if (object != null) {
                    UsefulDeclarationProcessor.enqueue$default(this, (IrDeclaration)object, irClass, "inline class primary ctor", false, 4, null);
                }
            }
        }
    }

    private final void enqueueValueParameterType(IrValueParameter $this$enqueueValueParameterType, IrDeclaration from2) {
        if (this.getContext().getInlineClassesUtils().shouldValueParameterBeBoxed($this$enqueueValueParameterType)) {
            this.enqueueRuntimeClassOrAny($this$enqueueValueParameterType.getType(), from2, "function ValueParameterType");
        } else {
            this.enqueueType($this$enqueueValueParameterType.getType(), from2, "function ValueParameterType");
        }
    }

    private final void processIrFunction(IrFunction irFunction) {
        block3: {
            boolean isIntrinsic;
            if (IrFakeOverrideUtilsKt.isFakeOverride(irFunction)) {
                return;
            }
            boolean bl = isIntrinsic = AnnotationsKt.hasWasmNoOpCastAnnotation(irFunction) || AnnotationsKt.getWasmOpAnnotation(irFunction) != null;
            if (isIntrinsic) {
                return;
            }
            Iterable $this$forEach$iv = DeclarationGeneratorKt.getEffectiveValueParameters(irFunction);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl2 = false;
                this.enqueueValueParameterType(it, irFunction);
            }
            this.enqueueType(irFunction.getReturnType(), irFunction, "function return type");
            IrSimpleFunction irSimpleFunction = this.kotlinClosureToJsClosureConvertFunToKotlinClosureCallFun.get(irFunction);
            if (irSimpleFunction == null) break block3;
            this.enqueue(irSimpleFunction, irFunction, "kotlin closure to JS closure conversion", false);
        }
    }

    @Override
    protected void processSimpleFunction(@NotNull IrSimpleFunction irFunction) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        super.processSimpleFunction(irFunction);
        this.enqueueParentClass(irFunction);
        this.processIrFunction(irFunction);
    }

    @Override
    protected void processConstructor(@NotNull IrConstructor irConstructor) {
        Intrinsics.checkNotNullParameter(irConstructor, "irConstructor");
        super.processConstructor(irConstructor);
        IrClass constructedClass = AdditionalIrUtilsKt.getConstructedClass(irConstructor);
        if (!this.getContext().getInlineClassesUtils().isClassInlineLike(constructedClass)) {
            this.processIrFunction(irConstructor);
        }
        if (AnnotationsKt.hasWasmPrimitiveConstructorAnnotation(irConstructor)) {
            Iterable $this$forEach$iv = constructedClass.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrDeclaration declaration = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!(declaration instanceof IrField)) continue;
                UsefulDeclarationProcessor.enqueue$default(this, declaration, constructedClass, "preserve all fields for primitive constructors", false, 4, null);
            }
        }
    }

    @Override
    protected boolean isExported(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        return declaration instanceof IrFunction && DeclarationGeneratorKt.isExported((IrFunction)declaration);
    }

    public static final /* synthetic */ void access$enqueueType(WasmUsefulDeclarationProcessor $this, IrType $receiver, IrDeclaration from2, String info) {
        $this.enqueueType($receiver, from2, info);
    }

    public static final /* synthetic */ void access$enqueueRuntimeClassOrAny(WasmUsefulDeclarationProcessor $this, IrType $receiver, IrDeclaration from2, String info) {
        $this.enqueueRuntimeClassOrAny($receiver, from2, info);
    }
}

