/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirMissingDependencyClassProxy;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeDiagnosticWithSingleCandidate;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u00032\u00020\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencyClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker\n+ 2 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt\n+ 3 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt$forEachType$1\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,164:1\n25#2,8:165\n33#2:174\n35#2,9:178\n46#2:189\n26#3:173\n1755#4,3:175\n1863#4,2:190\n13409#5,2:187\n*S KotlinDebug\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker\n*L\n39#1:165,8\n39#1:174\n39#1:178,9\n39#1:189\n39#1:173\n43#1:175,3\n66#1:190,2\n39#1:187,2\n*E\n"})
public final class FirMissingDependencyClassChecker
extends FirExpressionChecker<FirQualifiedAccessExpression>
implements FirMissingDependencyClassProxy {
    @NotNull
    public static final FirMissingDependencyClassChecker INSTANCE = new FirMissingDependencyClassChecker();

    private FirMissingDependencyClassChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirReference calleeReference = expression2.getCalleeReference();
        Set missingTypes = new LinkedHashSet();
        Set missingTypesFromExpression = new LinkedHashSet();
        List<FirElement> containingElements = context.getContainingElements();
        if (!FirReferenceUtilsKt.isError(calleeReference)) {
            ConeKotlinType $this$forEachType_u24default$iv = FirTypeUtilsKt.getResolvedType(expression2);
            boolean $i$f$forEachType = false;
            ConeKotlinType[] coneKotlinTypeArray = new ConeKotlinType[]{$this$forEachType_u24default$iv};
            List<ConeKotlinType> stack$iv = CollectionsKt.mutableListOf(coneKotlinTypeArray);
            while (!((Collection)stack$iv).isEmpty()) {
                ConeKotlinType it;
                ConeKotlinType next$iv;
                ConeKotlinType coneKotlinType = AddToStdlibKt.popLast(stack$iv);
                boolean bl = false;
                it = next$iv = (it = coneKotlinType);
                boolean bl2 = false;
                if (it instanceof ConeErrorType) {
                    boolean bl3;
                    block16: {
                        Iterable $this$any$iv = containingElements;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                FirElement it2 = (FirElement)element$iv;
                                boolean bl4 = false;
                                if (!(it2 instanceof FirFunctionCall && ((FirFunctionCall)it2).getCalleeReference() instanceof FirResolvedErrorReference)) continue;
                                bl3 = true;
                                break block16;
                            }
                            bl3 = false;
                        }
                    }
                    boolean partOfErroneousOuterCall = bl3 && !FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.ForbidUsingExpressionTypesWithInaccessibleContent);
                    INSTANCE.considerType(it, partOfErroneousOuterCall ? missingTypes : missingTypesFromExpression, context);
                }
                ConeKotlinType coneKotlinType2 = next$iv;
                if (coneKotlinType2 instanceof ConeFlexibleType) {
                    stack$iv.add(((ConeFlexibleType)next$iv).getLowerBound());
                    stack$iv.add(((ConeFlexibleType)next$iv).getUpperBound());
                    continue;
                }
                if (coneKotlinType2 instanceof ConeDefinitelyNotNullType) {
                    stack$iv.add(((ConeDefinitelyNotNullType)next$iv).getOriginal());
                    continue;
                }
                if (coneKotlinType2 instanceof ConeIntersectionType) {
                    stack$iv.addAll(((ConeIntersectionType)next$iv).getIntersectedTypes());
                    continue;
                }
                ConeTypeProjection[] $this$forEach$iv$iv = next$iv.getTypeArguments();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv$iv.length;
                for (int i = 0; i < n; ++i) {
                    ConeTypeProjection element$iv$iv;
                    ConeTypeProjection it$iv = element$iv$iv = $this$forEach$iv$iv[i];
                    boolean bl5 = false;
                    if (!(it$iv instanceof ConeKotlinTypeProjection)) continue;
                    stack$iv.add(((ConeKotlinTypeProjection)it$iv).getType());
                }
            }
        }
        if (FirReferenceUtilsKt.isError(calleeReference) && !(((FirDiagnosticHolder)((Object)calleeReference)).getDiagnostic() instanceof ConeDiagnosticWithSingleCandidate) && missingTypesFromExpression.isEmpty()) {
            return;
        }
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(calleeReference, false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol symbol = firCallableSymbol;
        this.considerType(FirTypeUtilsKt.getConeType(symbol.getResolvedReturnTypeRef()), missingTypes, context);
        Object object2 = symbol.getResolvedReceiverTypeRef();
        if (object2 != null && (object2 = FirTypeUtilsKt.getConeType((FirTypeRef)object2)) != null) {
            Object it = object2;
            boolean bl = false;
            INSTANCE.considerType((ConeKotlinType)it, missingTypes, context);
        }
        if ((object = symbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)symbol : null) != null && (object = ((FirFunctionSymbol)object).getValueParameterSymbols()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                boolean bl = false;
                INSTANCE.considerType(FirTypeUtilsKt.getConeType(it.getResolvedReturnTypeRef()), missingTypes, context);
            }
        }
        this.reportMissingTypes(expression2.getSource(), missingTypes, context, reporter, FirMissingDependencyClassProxy.MissingTypeOrigin.Other.INSTANCE);
        if (missingTypes.isEmpty()) {
            this.reportMissingTypes(expression2.getSource(), missingTypesFromExpression, context, reporter, FirMissingDependencyClassProxy.MissingTypeOrigin.Expression.INSTANCE);
        }
    }
}

