/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.TransportListener;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.TransportTask;

public final class GetTask
extends TransportTask {
    private File dataFile;
    private boolean resume;
    private ByteArrayOutputStream dataBytes;
    private Map<String, String> checksums = Collections.emptyMap();

    public GetTask(URI location) {
        this.setLocation(location);
    }

    public OutputStream newOutputStream() throws IOException {
        return this.newOutputStream(false);
    }

    public OutputStream newOutputStream(boolean resume) throws IOException {
        if (this.dataFile != null) {
            if (this.resume && resume) {
                return Files.newOutputStream(this.dataFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
            }
            return Files.newOutputStream(this.dataFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        if (this.dataBytes == null) {
            this.dataBytes = new ByteArrayOutputStream(1024);
        } else if (!resume) {
            this.dataBytes.reset();
        }
        return this.dataBytes;
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public GetTask setDataFile(File dataFile) {
        return this.setDataFile(dataFile, false);
    }

    public GetTask setDataFile(File dataFile, boolean resume) {
        this.dataFile = dataFile;
        this.resume = resume;
        return this;
    }

    public long getResumeOffset() {
        if (this.resume) {
            if (this.dataFile != null) {
                return this.dataFile.length();
            }
            if (this.dataBytes != null) {
                return this.dataBytes.size();
            }
        }
        return 0L;
    }

    @Override
    public GetTask setListener(TransportListener listener) {
        super.setListener(listener);
        return this;
    }

    public Map<String, String> getChecksums() {
        return this.checksums;
    }

    public String toString() {
        return "<< " + this.getLocation();
    }
}

