/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.stubs.KotlinClassifierStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.elements.KtTokenSets;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0007J\u001e\u0010\f\u001a\u0004\u0018\u00010\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0081\u0010\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\t*\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u0004\u0018\u00010\u0012*\u00020\u0007H\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010\u001d\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0001\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\"\u001a\u0004\u0018\u00010\u00122\u0006\u0010#\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010%R\u0016\u0010&\u001a\u00020'8\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b(\u0010\u0003R\u0014\u0010)\u001a\u00020*X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b+\u0010\u0003R\u0014\u0010,\u001a\u00020'X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b-\u0010\u0003R\u000e\u0010.\u001a\u00020*X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020*X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/StubUtils;", "", "<init>", "()V", "deserializeClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "dataStream", "Lcom/intellij/psi/stubs/StubInputStream;", "serializeClassId", "", "Lcom/intellij/psi/stubs/StubOutputStream;", "classId", "createNestedClassId", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "currentDeclaration", "Lorg/jetbrains/kotlin/psi/KtClassLikeDeclaration;", "isDeclaredInsideValueArgument", "", "node", "Lcom/intellij/lang/ASTNode;", "isDeclaredInsideValueArgument$psi_impl", "writeNullableBoolean", "value", "writeNullableBoolean$psi_impl", "(Lcom/intellij/psi/stubs/StubOutputStream;Ljava/lang/Boolean;)V", "readNullableBoolean", "readNullableBoolean$psi_impl", "(Lcom/intellij/psi/stubs/StubInputStream;)Ljava/lang/Boolean;", "searchForHasBackingFieldComment", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "searchForHasBackingFieldComment$psi_impl", "(Lorg/jetbrains/kotlin/psi/KtProperty;)Ljava/lang/Boolean;", "searchForHasBackingField", "comment", "Lcom/intellij/psi/PsiComment;", "(Lcom/intellij/psi/PsiComment;)Ljava/lang/Boolean;", "HAS_BACKING_FIELD_COMMENT_PREFIX", "", "getHAS_BACKING_FIELD_COMMENT_PREFIX$annotations", "HAS_BACKING_FIELD_COMMENT_VALUE_START_INDEX", "", "getHAS_BACKING_FIELD_COMMENT_VALUE_START_INDEX$annotations", "HAS_BACKING_FIELD_COMMENT_TRUE", "getHAS_BACKING_FIELD_COMMENT_TRUE$annotations", "HAS_BACKING_FIELD_COMMENT_TRUE_LENGTH", "HAS_BACKING_FIELD_COMMENT_FALSE_LENGTH", "psi-impl"})
@SourceDebugExtension(value={"SMAP\nStubUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StubUtils.kt\norg/jetbrains/kotlin/psi/stubs/StubUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class StubUtils {
    @NotNull
    public static final StubUtils INSTANCE = new StubUtils();
    @NotNull
    public static final String HAS_BACKING_FIELD_COMMENT_PREFIX = "/* hasBackingField: ";

    private StubUtils() {
    }

    @JvmStatic
    @Nullable
    public static final ClassId deserializeClassId(@NotNull StubInputStream dataStream) {
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        StringRef stringRef = dataStream.readName();
        if (stringRef == null) {
            return null;
        }
        StringRef classId = stringRef;
        String string = classId.getString();
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        return ClassId.Companion.fromString$default(ClassId.Companion, string, false, 2, null);
    }

    @JvmStatic
    public static final void serializeClassId(@NotNull StubOutputStream dataStream, @Nullable ClassId classId) {
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        ClassId classId2 = classId;
        dataStream.writeName(classId2 != null ? classId2.asString() : null);
    }

    @JvmStatic
    @Nullable
    public static final ClassId createNestedClassId(@NotNull StubElement<?> parentStub, @NotNull KtClassLikeDeclaration currentDeclaration) {
        ClassId classId;
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        Intrinsics.checkNotNullParameter(currentDeclaration, "currentDeclaration");
        if (currentDeclaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)currentDeclaration).isObjectLiteral()) {
            return null;
        }
        StubElement<?> stubElement = parentStub;
        if (stubElement instanceof KotlinFileStub) {
            FqName fqName = ((KotlinFileStub)parentStub).getPackageFqName();
            Name name2 = currentDeclaration.getNameAsSafeName();
            Intrinsics.checkNotNullExpressionValue(name2, "getNameAsSafeName(...)");
            classId = new ClassId(fqName, name2);
        } else if (stubElement instanceof KotlinScriptStub) {
            StubElement stubElement2 = ((KotlinScriptStub)parentStub).getParentStub();
            Intrinsics.checkNotNullExpressionValue(stubElement2, "getParentStub(...)");
            classId = StubUtils.createNestedClassId(stubElement2, currentDeclaration);
        } else if (stubElement instanceof KotlinPlaceHolderStub && Intrinsics.areEqual(((KotlinPlaceHolderStub)parentStub).getStubType(), KtStubElementTypes.CLASS_BODY)) {
            KotlinClassifierStub containingClassStub;
            StubElement stubElement3 = ((KotlinPlaceHolderStub)parentStub).getParentStub();
            KotlinClassifierStub kotlinClassifierStub = containingClassStub = stubElement3 instanceof KotlinClassifierStub ? (KotlinClassifierStub)((Object)stubElement3) : null;
            if (containingClassStub != null && !(currentDeclaration instanceof KtEnumEntry)) {
                ClassId classId2 = containingClassStub.getClassId();
                if (classId2 != null) {
                    Name name3 = currentDeclaration.getNameAsSafeName();
                    Intrinsics.checkNotNullExpressionValue(name3, "getNameAsSafeName(...)");
                    classId = classId2.createNestedClassId(name3);
                } else {
                    classId = null;
                }
            } else {
                classId = null;
            }
        } else {
            classId = null;
        }
        return classId;
    }

    @JvmStatic
    public static final boolean isDeclaredInsideValueArgument$psi_impl(@Nullable ASTNode node) {
        boolean bl;
        while (true) {
            IElementType iElementType;
            ASTNode parent2;
            ASTNode aSTNode = node;
            ASTNode aSTNode2 = parent2 = aSTNode != null ? aSTNode.getTreeParent() : null;
            IElementType iElementType2 = iElementType = aSTNode2 != null ? aSTNode2.getElementType() : null;
            if (Intrinsics.areEqual(iElementType, KtStubElementTypes.VALUE_ARGUMENT)) {
                bl = true;
                break;
            }
            if (iElementType == null || KtTokenSets.DECLARATION_TYPES.contains(iElementType)) {
                bl = false;
                break;
            }
            node = parent2;
        }
        return bl;
    }

    @JvmStatic
    public static final void writeNullableBoolean$psi_impl(@NotNull StubOutputStream $this$writeNullableBoolean, @Nullable Boolean value2) {
        int n2;
        Intrinsics.checkNotNullParameter($this$writeNullableBoolean, "<this>");
        Boolean bl = value2;
        if (Intrinsics.areEqual(bl, true)) {
            n2 = 0;
        } else if (Intrinsics.areEqual(bl, false)) {
            n2 = 1;
        } else if (bl == null) {
            n2 = 2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int n3 = n2;
        $this$writeNullableBoolean.writeByte(n3);
    }

    @JvmStatic
    @Nullable
    public static final Boolean readNullableBoolean$psi_impl(@NotNull StubInputStream $this$readNullableBoolean) {
        Boolean bl;
        Intrinsics.checkNotNullParameter($this$readNullableBoolean, "<this>");
        switch ($this$readNullableBoolean.readByte()) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                bl = false;
                break;
            }
            default: {
                bl = null;
            }
        }
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final Boolean searchForHasBackingFieldComment$psi_impl(@NotNull KtProperty property2) {
        Intrinsics.checkNotNullParameter(property2, "property");
        if (!property2.getContainingKtFile().isCompiled()) {
            return null;
        }
        for (PsiElement child = property2.getFirstChild(); child != null; child = child.getNextSibling()) {
            Boolean bl;
            if (!(child instanceof PsiComment) || (bl = INSTANCE.searchForHasBackingField((PsiComment)child)) == null) continue;
            boolean it = bl;
            boolean bl2 = false;
            return it;
        }
        return null;
    }

    private final Boolean searchForHasBackingField(PsiComment comment) {
        if (!Intrinsics.areEqual(comment.getTokenType(), KtTokens.BLOCK_COMMENT)) {
            return null;
        }
        int textLength = comment.getTextLength();
        if (textLength != 27 && textLength != 28) {
            return null;
        }
        String text = comment.getText();
        Intrinsics.checkNotNull(text);
        return StringsKt.startsWith$default(text, HAS_BACKING_FIELD_COMMENT_PREFIX, false, 2, null) ? Boolean.valueOf(text.charAt(20) == 't') : null;
    }

    public static /* synthetic */ void getHAS_BACKING_FIELD_COMMENT_PREFIX$annotations() {
    }
}

