/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import net.sf.log4jdbc.ConnectionSpy;
import net.sf.log4jdbc.PreparedStatementSpy;
import net.sf.log4jdbc.SpyLogDelegator;
import net.sf.log4jdbc.SpyLogFactory;

public class CallableStatementSpy
extends PreparedStatementSpy
implements CallableStatement {
    private final SpyLogDelegator log;
    private CallableStatement realCallableStatement;

    protected void reportAllReturns(String methodCall, String msg) {
        this.log.methodReturned(this, methodCall, msg);
    }

    public CallableStatementSpy(String sql, ConnectionSpy connectionSpy, CallableStatement realCallableStatement) {
        super(sql, connectionSpy, realCallableStatement);
        this.realCallableStatement = realCallableStatement;
        this.log = SpyLogFactory.getSpyLogDelegator();
    }

    public String getClassType() {
        return "CallableStatement";
    }

    public Date getDate(int parameterIndex) throws SQLException {
        String methodCall = "getDate(" + parameterIndex + ")";
        try {
            return (Date)this.reportReturn(methodCall, this.realCallableStatement.getDate(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        String methodCall = "getDate(" + parameterIndex + ", " + cal + ")";
        try {
            return (Date)this.reportReturn(methodCall, this.realCallableStatement.getDate(parameterIndex, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Ref getRef(String parameterName) throws SQLException {
        String methodCall = "getRef(" + parameterName + ")";
        try {
            return (Ref)this.reportReturn(methodCall, this.realCallableStatement.getRef(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Time getTime(String parameterName) throws SQLException {
        String methodCall = "getTime(" + parameterName + ")";
        try {
            return (Time)this.reportReturn(methodCall, this.realCallableStatement.getTime(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        String methodCall = "setTime(" + parameterName + ", " + x + ")";
        try {
            this.realCallableStatement.setTime(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public Blob getBlob(int i) throws SQLException {
        String methodCall = "getBlob(" + i + ")";
        try {
            return (Blob)this.reportReturn(methodCall, this.realCallableStatement.getBlob(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Clob getClob(int i) throws SQLException {
        String methodCall = "getClob(" + i + ")";
        try {
            return (Clob)this.reportReturn(methodCall, this.realCallableStatement.getClob(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Array getArray(int i) throws SQLException {
        String methodCall = "getArray(" + i + ")";
        try {
            return (Array)this.reportReturn(methodCall, this.realCallableStatement.getArray(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        String methodCall = "getBytes(" + parameterIndex + ")";
        try {
            return (byte[])this.reportReturn(methodCall, this.realCallableStatement.getBytes(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public double getDouble(int parameterIndex) throws SQLException {
        String methodCall = "getDouble(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getDouble(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public int getInt(int parameterIndex) throws SQLException {
        String methodCall = "getInt(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getInt(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public boolean wasNull() throws SQLException {
        String methodCall = "wasNull()";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.wasNull());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Time getTime(int parameterIndex) throws SQLException {
        String methodCall = "getTime(" + parameterIndex + ")";
        try {
            return (Time)this.reportReturn(methodCall, this.realCallableStatement.getTime(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        String methodCall = "getTime(" + parameterIndex + ", " + cal + ")";
        try {
            return (Time)this.reportReturn(methodCall, this.realCallableStatement.getTime(parameterIndex, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        String methodCall = "getTimestamp(" + parameterName + ")";
        try {
            return (Timestamp)this.reportReturn(methodCall, this.realCallableStatement.getTimestamp(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        String methodCall = "setTimestamp(" + parameterName + ", " + x + ")";
        try {
            this.realCallableStatement.setTimestamp(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public String getString(int parameterIndex) throws SQLException {
        String methodCall = "getString(" + parameterIndex + ")";
        try {
            return (String)this.reportReturn(methodCall, this.realCallableStatement.getString(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterIndex + ", " + sqlType + ")";
        this.argTraceSet(parameterIndex, null, "<OUT>");
        try {
            this.realCallableStatement.registerOutParameter(parameterIndex, sqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterIndex + ", " + sqlType + ", " + scale + ")";
        this.argTraceSet(parameterIndex, null, "<OUT>");
        try {
            this.realCallableStatement.registerOutParameter(parameterIndex, sqlType, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        String methodCall = "registerOutParameter(" + paramIndex + ", " + sqlType + ", " + typeName + ")";
        this.argTraceSet(paramIndex, null, "<OUT>");
        try {
            this.realCallableStatement.registerOutParameter(paramIndex, sqlType, typeName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public byte getByte(String parameterName) throws SQLException {
        String methodCall = "getByte(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getByte(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public double getDouble(String parameterName) throws SQLException {
        String methodCall = "getDouble(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getDouble(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public float getFloat(String parameterName) throws SQLException {
        String methodCall = "getFloat(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getFloat(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public int getInt(String parameterName) throws SQLException {
        String methodCall = "getInt(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getInt(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public long getLong(String parameterName) throws SQLException {
        String methodCall = "getLong(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getLong(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public short getShort(String parameterName) throws SQLException {
        String methodCall = "getShort(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getShort(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        String methodCall = "getBoolean(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getBoolean(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        String methodCall = "getBytes(" + parameterName + ")";
        try {
            return (byte[])this.reportReturn(methodCall, this.realCallableStatement.getBytes(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        String methodCall = "setByte(" + parameterName + ", " + x + ")";
        try {
            this.realCallableStatement.setByte(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        String methodCall = "setDouble(" + parameterName + ", " + x + ")";
        try {
            this.realCallableStatement.setDouble(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        String methodCall = "setFloat(" + parameterName + ", " + x + ")";
        try {
            this.realCallableStatement.setFloat(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterName + ", " + sqlType + ")";
        try {
            this.realCallableStatement.registerOutParameter(parameterName, sqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        String methodCall = "setInt(" + parameterName + ", " + x + ")";
        try {
            this.realCallableStatement.setInt(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        String methodCall = "setNull(" + parameterName + ", " + sqlType + ")";
        try {
            this.realCallableStatement.setNull(parameterName, sqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterName + ", " + sqlType + ", " + scale + ")";
        try {
            this.realCallableStatement.registerOutParameter(parameterName, sqlType, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        String methodCall = "setLong(" + parameterName + ", " + x + ")";
        try {
            this.realCallableStatement.setLong(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        String methodCall = "setShort(" + parameterName + ", " + x + ")";
        try {
            this.realCallableStatement.setShort(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        String methodCall = "setBoolean(" + parameterName + ", " + x + ")";
        try {
            this.realCallableStatement.setBoolean(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        String methodCall = "setBytes(" + parameterName + ", " + x + ")";
        try {
            this.realCallableStatement.setBytes(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        String methodCall = "getBoolean(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getBoolean(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        String methodCall = "getTimestamp(" + parameterIndex + ")";
        try {
            return (Timestamp)this.reportReturn(methodCall, this.realCallableStatement.getTimestamp(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        String methodCall = "setAsciiStream(" + parameterName + ", " + x + ", " + length + ")";
        try {
            this.realCallableStatement.setAsciiStream(parameterName, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        String methodCall = "setBinaryStream(" + parameterName + ", " + x + ", " + length + ")";
        try {
            this.realCallableStatement.setBinaryStream(parameterName, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        String methodCall = "setCharacterStream(" + parameterName + ", " + reader + ", " + length + ")";
        try {
            this.realCallableStatement.setCharacterStream(parameterName, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public Object getObject(String parameterName) throws SQLException {
        String methodCall = "getObject(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getObject(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        String methodCall = "setObject(" + parameterName + ", " + x + ")";
        try {
            this.realCallableStatement.setObject(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        String methodCall = "setObject(" + parameterName + ", " + x + ", " + targetSqlType + ")";
        try {
            this.realCallableStatement.setObject(parameterName, x, targetSqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        String methodCall = "setObject(" + parameterName + ", " + x + ", " + targetSqlType + ", " + scale + ")";
        try {
            this.realCallableStatement.setObject(parameterName, x, targetSqlType, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        String methodCall = "getTimestamp(" + parameterIndex + ", " + cal + ")";
        try {
            return (Timestamp)this.reportReturn(methodCall, this.realCallableStatement.getTimestamp(parameterIndex, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        String methodCall = "getObject(" + parameterName + ", " + map + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getObject(parameterName, map));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        String methodCall = "getDate(" + parameterName + ", " + cal + ")";
        try {
            return (Date)this.reportReturn(methodCall, this.realCallableStatement.getDate(parameterName, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        String methodCall = "getTime(" + parameterName + ", " + cal + ")";
        try {
            return (Time)this.reportReturn(methodCall, this.realCallableStatement.getTime(parameterName, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        String methodCall = "getTimestamp(" + parameterName + ", " + cal + ")";
        try {
            return (Timestamp)this.reportReturn(methodCall, this.realCallableStatement.getTimestamp(parameterName, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        String methodCall = "setDate(" + parameterName + ", " + x + ", " + cal + ")";
        try {
            this.realCallableStatement.setDate(parameterName, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        String methodCall = "setTime(" + parameterName + ", " + x + ", " + cal + ")";
        try {
            this.realCallableStatement.setTime(parameterName, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        String methodCall = "setTimestamp(" + parameterName + ", " + x + ", " + cal + ")";
        try {
            this.realCallableStatement.setTimestamp(parameterName, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public short getShort(int parameterIndex) throws SQLException {
        String methodCall = "getShort(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getShort(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public long getLong(int parameterIndex) throws SQLException {
        String methodCall = "getLong(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getLong(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public float getFloat(int parameterIndex) throws SQLException {
        String methodCall = "getFloat(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getFloat(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Ref getRef(int i) throws SQLException {
        String methodCall = "getRef(" + i + ")";
        try {
            return (Ref)this.reportReturn(methodCall, this.realCallableStatement.getRef(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        String methodCall = "getBigDecimal(" + parameterIndex + ", " + scale + ")";
        try {
            return (BigDecimal)this.reportReturn(methodCall, this.realCallableStatement.getBigDecimal(parameterIndex, scale));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public URL getURL(int parameterIndex) throws SQLException {
        String methodCall = "getURL(" + parameterIndex + ")";
        try {
            return (URL)this.reportReturn(methodCall, this.realCallableStatement.getURL(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        String methodCall = "getBigDecimal(" + parameterIndex + ")";
        try {
            return (BigDecimal)this.reportReturn(methodCall, this.realCallableStatement.getBigDecimal(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public byte getByte(int parameterIndex) throws SQLException {
        String methodCall = "getByte(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getByte(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Object getObject(int parameterIndex) throws SQLException {
        String methodCall = "getObject(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getObject(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Object getObject(int i, Map map) throws SQLException {
        String methodCall = "getObject(" + i + ", " + map + ")";
        try {
            return this.reportReturn(methodCall, this.realCallableStatement.getObject(i, map));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public String getString(String parameterName) throws SQLException {
        String methodCall = "getString(" + parameterName + ")";
        try {
            return (String)this.reportReturn(methodCall, this.realCallableStatement.getString(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterName + ", " + sqlType + ", " + typeName + ")";
        try {
            this.realCallableStatement.registerOutParameter(parameterName, sqlType, typeName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        String methodCall = "setNull(" + parameterName + ", " + sqlType + ", " + typeName + ")";
        try {
            this.realCallableStatement.setNull(parameterName, sqlType, typeName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void setString(String parameterName, String x) throws SQLException {
        String methodCall = "setString(" + parameterName + ", " + x + ")";
        try {
            this.realCallableStatement.setString(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        String methodCall = "getBigDecimal(" + parameterName + ")";
        try {
            return (BigDecimal)this.reportReturn(methodCall, this.realCallableStatement.getBigDecimal(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        String methodCall = "setBigDecimal(" + parameterName + ", " + x + ")";
        try {
            this.realCallableStatement.setBigDecimal(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public URL getURL(String parameterName) throws SQLException {
        String methodCall = "getURL(" + parameterName + ")";
        try {
            return (URL)this.reportReturn(methodCall, this.realCallableStatement.getURL(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        String methodCall = "setURL(" + parameterName + ", " + val + ")";
        try {
            this.realCallableStatement.setURL(parameterName, val);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public Array getArray(String parameterName) throws SQLException {
        String methodCall = "getURL(" + parameterName + ")";
        try {
            return (Array)this.reportReturn(methodCall, this.realCallableStatement.getArray(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Blob getBlob(String parameterName) throws SQLException {
        String methodCall = "getBlob(" + parameterName + ")";
        try {
            return (Blob)this.reportReturn(methodCall, this.realCallableStatement.getBlob(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Clob getClob(String parameterName) throws SQLException {
        String methodCall = "getClob(" + parameterName + ")";
        try {
            return (Clob)this.reportReturn(methodCall, this.realCallableStatement.getClob(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Date getDate(String parameterName) throws SQLException {
        String methodCall = "getDate(" + parameterName + ")";
        try {
            return (Date)this.reportReturn(methodCall, this.realCallableStatement.getDate(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        String methodCall = "setDate(" + parameterName + ", " + x + ")";
        try {
            this.realCallableStatement.setDate(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }
}

