-- H2 2.1.214;
CREATE USER IF NOT EXISTS "" SALT '' HASH '' ADMIN;
CREATE CACHED TABLE "PUBLIC"."PERMISSIONS_REVISION" COMMENT 'Used to keep track of changes made to permissions.'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "BEFORE" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON of the permissions before the changes.' NOT NULL,
    "AFTER" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON of the permissions after the changes.' NOT NULL,
    "USER_ID" INTEGER COMMENT 'The ID of the admin who made this set of changes.' NOT NULL,
    "CREATED_AT" TIMESTAMP COMMENT 'The timestamp of when these changes were made.' NOT NULL,
    "REMARK" CHARACTER LARGE OBJECT COMMENT 'Optional remarks explaining why these changes were made.'
);
ALTER TABLE "PUBLIC"."PERMISSIONS_REVISION" ADD CONSTRAINT "PUBLIC"."PK_PERMISSIONS_REVISION" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PERMISSIONS_REVISION;
CREATE CACHED TABLE "PUBLIC"."METABASE_FIELDVALUES"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "CREATED_AT" TIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP WITH TIME ZONE NOT NULL,
    "VALUES" CHARACTER LARGE OBJECT,
    "HUMAN_READABLE_VALUES" CHARACTER LARGE OBJECT,
    "FIELD_ID" INTEGER NOT NULL,
    "HAS_MORE_VALUES" BOOLEAN DEFAULT FALSE COMMENT 'true if the stored values list is a subset of all possible values',
    "TYPE" CHARACTER VARYING(32) DEFAULT 'full' COMMENT 'Type of FieldValues' NOT NULL,
    "HASH_KEY" CHARACTER LARGE OBJECT COMMENT 'Hash key for a cached fieldvalues'
);
ALTER TABLE "PUBLIC"."METABASE_FIELDVALUES" ADD CONSTRAINT "PUBLIC"."PK_METABASE_FIELDVALUES" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.METABASE_FIELDVALUES;
CREATE INDEX "PUBLIC"."IDX_FIELDVALUES_FIELD_ID" ON "PUBLIC"."METABASE_FIELDVALUES"("FIELD_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."SETTING"(
    "KEY" CHARACTER VARYING(254) NOT NULL,
    "VALUE" CHARACTER LARGE OBJECT NOT NULL
);
ALTER TABLE "PUBLIC"."SETTING" ADD CONSTRAINT "PUBLIC"."PK_SETTING" PRIMARY KEY("KEY");
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.SETTING;
CREATE CACHED TABLE "PUBLIC"."METRIC_IMPORTANT_FIELD"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "METRIC_ID" INTEGER NOT NULL,
    "FIELD_ID" INTEGER NOT NULL
);
ALTER TABLE "PUBLIC"."METRIC_IMPORTANT_FIELD" ADD CONSTRAINT "PUBLIC"."PK_METRIC_IMPORTANT_FIELD" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.METRIC_IMPORTANT_FIELD;
CREATE INDEX "PUBLIC"."IDX_METRIC_IMPORTANT_FIELD_METRIC_ID" ON "PUBLIC"."METRIC_IMPORTANT_FIELD"("METRIC_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_METRIC_IMPORTANT_FIELD_FIELD_ID" ON "PUBLIC"."METRIC_IMPORTANT_FIELD"("FIELD_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."METABASE_FIELD"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "CREATED_AT" TIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP NOT NULL,
    "NAME" CHARACTER VARYING(254) NOT NULL,
    "BASE_TYPE" CHARACTER VARYING(255) NOT NULL,
    "SEMANTIC_TYPE" CHARACTER VARYING(255),
    "ACTIVE" BOOLEAN DEFAULT TRUE NOT NULL,
    "DESCRIPTION" CHARACTER LARGE OBJECT,
    "PREVIEW_DISPLAY" BOOLEAN DEFAULT TRUE NOT NULL,
    "POSITION" INTEGER DEFAULT 0 NOT NULL,
    "TABLE_ID" INTEGER NOT NULL,
    "PARENT_ID" INTEGER,
    "DISPLAY_NAME" CHARACTER VARYING(254),
    "VISIBILITY_TYPE" CHARACTER VARYING(32) DEFAULT 'normal' NOT NULL,
    "FK_TARGET_FIELD_ID" INTEGER,
    "LAST_ANALYZED" TIMESTAMP,
    "POINTS_OF_INTEREST" CHARACTER LARGE OBJECT,
    "CAVEATS" CHARACTER LARGE OBJECT,
    "FINGERPRINT" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON containing non-identifying information about this Field, such as min, max, and percent JSON. Used for classification.',
    "FINGERPRINT_VERSION" INTEGER DEFAULT '0' COMMENT 'The version of the fingerprint for this Field. Used so we can keep track of which Fields need to be analyzed again when new things are added to fingerprints.' NOT NULL,
    "DATABASE_TYPE" CHARACTER LARGE OBJECT NOT NULL,
    "HAS_FIELD_VALUES" CHARACTER LARGE OBJECT COMMENT 'Whether we have FieldValues ("list"), should ad-hoc search ("search"), disable entirely ("none"), or infer dynamically (null)"',
    "SETTINGS" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON FE-specific settings like formatting, etc. Scope of what is stored here may increase in future.',
    "DATABASE_POSITION" INTEGER DEFAULT 0 NOT NULL,
    "CUSTOM_POSITION" INTEGER DEFAULT 0 NOT NULL,
    "EFFECTIVE_TYPE" CHARACTER VARYING(255) COMMENT 'The effective type of the field after any coercions.',
    "COERCION_STRATEGY" CHARACTER VARYING(255) COMMENT 'A strategy to coerce the base_type into the effective_type.',
    "NFC_PATH" CHARACTER VARYING(254) COMMENT 'Nested field column paths, flattened',
    "DATABASE_REQUIRED" BOOLEAN DEFAULT FALSE COMMENT 'Indicates this field is required by the database for new records. Usually not null and without a default.' NOT NULL
);
ALTER TABLE "PUBLIC"."METABASE_FIELD" ADD CONSTRAINT "PUBLIC"."PK_METABASE_FIELD" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.METABASE_FIELD;
CREATE INDEX "PUBLIC"."IDX_FIELD_TABLE_ID" ON "PUBLIC"."METABASE_FIELD"("TABLE_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_FIELD_PARENT_ID" ON "PUBLIC"."METABASE_FIELD"("PARENT_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."TASK_HISTORY" COMMENT 'Timing and metadata info about background/quartz processes'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "TASK" CHARACTER VARYING(254) COMMENT 'Name of the task' NOT NULL,
    "DB_ID" INTEGER,
    "STARTED_AT" TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL,
    "ENDED_AT" TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP NOT NULL,
    "DURATION" INTEGER NOT NULL,
    "TASK_DETAILS" CHARACTER LARGE OBJECT COMMENT 'JSON string with additional info on the task'
);
ALTER TABLE "PUBLIC"."TASK_HISTORY" ADD CONSTRAINT "PUBLIC"."PK_TASK_HISTORY" PRIMARY KEY("ID");
-- 15 +/- SELECT COUNT(*) FROM PUBLIC.TASK_HISTORY;
CREATE INDEX "PUBLIC"."IDX_TASK_HISTORY_END_TIME" ON "PUBLIC"."TASK_HISTORY"("ENDED_AT" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_TASK_HISTORY_DB_ID" ON "PUBLIC"."TASK_HISTORY"("DB_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."DATA_MIGRATIONS"(
    "ID" CHARACTER VARYING(254) NOT NULL,
    "TIMESTAMP" TIMESTAMP NOT NULL
);
ALTER TABLE "PUBLIC"."DATA_MIGRATIONS" ADD CONSTRAINT "PUBLIC"."PK_DATA_MIGRATIONS" PRIMARY KEY("ID");
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.DATA_MIGRATIONS;
CREATE INDEX "PUBLIC"."IDX_DATA_MIGRATIONS_ID" ON "PUBLIC"."DATA_MIGRATIONS"("ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."COLLECTION_PERMISSION_GRAPH_REVISION" COMMENT 'Used to keep track of changes made to collections.'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "BEFORE" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON of the collections graph before the changes.' NOT NULL,
    "AFTER" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON of the collections graph after the changes.' NOT NULL,
    "USER_ID" INTEGER COMMENT 'The ID of the admin who made this set of changes.' NOT NULL,
    "CREATED_AT" TIMESTAMP COMMENT 'The timestamp of when these changes were made.' NOT NULL,
    "REMARK" CHARACTER LARGE OBJECT COMMENT 'Optional remarks explaining why these changes were made.'
);
ALTER TABLE "PUBLIC"."COLLECTION_PERMISSION_GRAPH_REVISION" ADD CONSTRAINT "PUBLIC"."PK_COLLECTION_REVISION" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.COLLECTION_PERMISSION_GRAPH_REVISION;
CREATE CACHED TABLE "PUBLIC"."DASHBOARD_BOOKMARK" COMMENT 'Table holding bookmarks on dashboards'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "USER_ID" INTEGER COMMENT 'ID of the User who bookmarked the Dashboard' NOT NULL,
    "DASHBOARD_ID" INTEGER COMMENT 'ID of the Dashboard bookmarked by the user' NOT NULL,
    "CREATED_AT" TIMESTAMP WITH TIME ZONE DEFAULT LOCALTIMESTAMP COMMENT 'The timestamp of when the bookmark was created' NOT NULL
);
ALTER TABLE "PUBLIC"."DASHBOARD_BOOKMARK" ADD CONSTRAINT "PUBLIC"."PK_DASHBOARD_BOOKMARK" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.DASHBOARD_BOOKMARK;
CREATE INDEX "PUBLIC"."IDX_DASHBOARD_BOOKMARK_USER_ID" ON "PUBLIC"."DASHBOARD_BOOKMARK"("USER_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_DASHBOARD_BOOKMARK_DASHBOARD_ID" ON "PUBLIC"."DASHBOARD_BOOKMARK"("DASHBOARD_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."LABEL"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "NAME" CHARACTER VARYING(254) NOT NULL,
    "SLUG" CHARACTER VARYING(254) NOT NULL,
    "ICON" CHARACTER VARYING(128)
);
ALTER TABLE "PUBLIC"."LABEL" ADD CONSTRAINT "PUBLIC"."PK_LABEL" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.LABEL;
CREATE INDEX "PUBLIC"."IDX_LABEL_SLUG" ON "PUBLIC"."LABEL"("SLUG" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."DEPENDENCY"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "MODEL" CHARACTER VARYING(32) NOT NULL,
    "MODEL_ID" INTEGER NOT NULL,
    "DEPENDENT_ON_MODEL" CHARACTER VARYING(32) NOT NULL,
    "DEPENDENT_ON_ID" INTEGER NOT NULL,
    "CREATED_AT" TIMESTAMP NOT NULL
);
ALTER TABLE "PUBLIC"."DEPENDENCY" ADD CONSTRAINT "PUBLIC"."PK_DEPENDENCY" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.DEPENDENCY;
CREATE INDEX "PUBLIC"."IDX_DEPENDENCY_MODEL" ON "PUBLIC"."DEPENDENCY"("MODEL" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_DEPENDENCY_MODEL_ID" ON "PUBLIC"."DEPENDENCY"("MODEL_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_DEPENDENCY_DEPENDENT_ON_MODEL" ON "PUBLIC"."DEPENDENCY"("DEPENDENT_ON_MODEL" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_DEPENDENCY_DEPENDENT_ON_ID" ON "PUBLIC"."DEPENDENCY"("DEPENDENT_ON_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."PERMISSIONS_GROUP_MEMBERSHIP"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "USER_ID" INTEGER NOT NULL,
    "GROUP_ID" INTEGER NOT NULL,
    "IS_GROUP_MANAGER" BOOLEAN DEFAULT 'false' COMMENT 'Boolean flag to indicate whether user is a group''s manager.' NOT NULL
);
ALTER TABLE "PUBLIC"."PERMISSIONS_GROUP_MEMBERSHIP" ADD CONSTRAINT "PUBLIC"."PK_PERMISSIONS_GROUP_MEMBERSHIP" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PERMISSIONS_GROUP_MEMBERSHIP;
CREATE INDEX "PUBLIC"."IDX_PERMISSIONS_GROUP_MEMBERSHIP_GROUP_ID" ON "PUBLIC"."PERMISSIONS_GROUP_MEMBERSHIP"("GROUP_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_PERMISSIONS_GROUP_MEMBERSHIP_USER_ID" ON "PUBLIC"."PERMISSIONS_GROUP_MEMBERSHIP"("USER_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_PERMISSIONS_GROUP_MEMBERSHIP_GROUP_ID_USER_ID" ON "PUBLIC"."PERMISSIONS_GROUP_MEMBERSHIP"("GROUP_ID" NULLS FIRST, "USER_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."DIMENSION" COMMENT 'Stores references to alternate views of existing fields, such as remapping an integer to a description, like an enum'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "FIELD_ID" INTEGER COMMENT 'ID of the field this dimension row applies to' NOT NULL,
    "NAME" CHARACTER VARYING(254) COMMENT 'Short description used as the display name of this new column' NOT NULL,
    "TYPE" CHARACTER VARYING(254) COMMENT 'Either internal for a user defined remapping or external for a foreign key based remapping' NOT NULL,
    "HUMAN_READABLE_FIELD_ID" INTEGER COMMENT 'Only used with external type remappings. Indicates which field on the FK related table to use for display',
    "CREATED_AT" TIMESTAMP COMMENT 'The timestamp of when the dimension was created.' NOT NULL,
    "UPDATED_AT" TIMESTAMP COMMENT 'The timestamp of when these dimension was last updated.' NOT NULL,
    "ENTITY_ID" CHARACTER(21) COMMENT 'Random NanoID tag for unique identity.'
);
ALTER TABLE "PUBLIC"."DIMENSION" ADD CONSTRAINT "PUBLIC"."PK_DIMENSION" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.DIMENSION;
CREATE INDEX "PUBLIC"."IDX_DIMENSION_FIELD_ID" ON "PUBLIC"."DIMENSION"("FIELD_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."QUERY" COMMENT 'Information (such as average execution time) for different queries that have been previously ran.'(
    "QUERY_HASH" BINARY(32) COMMENT 'The hash of the query dictionary. (This is a 256-bit SHA3 hash of the query dict.)' NOT NULL,
    "AVERAGE_EXECUTION_TIME" INTEGER COMMENT 'Average execution time for the query, round to nearest number of milliseconds. This is updated as a rolling average.' NOT NULL,
    "QUERY" CHARACTER LARGE OBJECT COMMENT 'The actual "query dictionary" for this query.'
);
ALTER TABLE "PUBLIC"."QUERY" ADD CONSTRAINT "PUBLIC"."PK_QUERY" PRIMARY KEY("QUERY_HASH");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QUERY;
CREATE CACHED TABLE "PUBLIC"."DASHBOARD_FAVORITE" COMMENT 'Presence of a row here indicates a given User has favorited a given Dashboard.'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "USER_ID" INTEGER COMMENT 'ID of the User who favorited the Dashboard.' NOT NULL,
    "DASHBOARD_ID" INTEGER COMMENT 'ID of the Dashboard favorited by the User.' NOT NULL
);
ALTER TABLE "PUBLIC"."DASHBOARD_FAVORITE" ADD CONSTRAINT "PUBLIC"."PK_DASHBOARD_FAVORITE" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.DASHBOARD_FAVORITE;
CREATE INDEX "PUBLIC"."IDX_DASHBOARD_FAVORITE_USER_ID" ON "PUBLIC"."DASHBOARD_FAVORITE"("USER_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_DASHBOARD_FAVORITE_DASHBOARD_ID" ON "PUBLIC"."DASHBOARD_FAVORITE"("DASHBOARD_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."PERMISSIONS_GROUP"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "NAME" CHARACTER VARYING(255) NOT NULL
);
ALTER TABLE "PUBLIC"."PERMISSIONS_GROUP" ADD CONSTRAINT "PUBLIC"."PK_PERMISSIONS_GROUP" PRIMARY KEY("ID");
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.PERMISSIONS_GROUP;
CREATE INDEX "PUBLIC"."IDX_PERMISSIONS_GROUP_NAME" ON "PUBLIC"."PERMISSIONS_GROUP"("NAME" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."DASHBOARDCARD_SERIES"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "DASHBOARDCARD_ID" INTEGER NOT NULL,
    "CARD_ID" INTEGER NOT NULL,
    "POSITION" INTEGER NOT NULL
);
ALTER TABLE "PUBLIC"."DASHBOARDCARD_SERIES" ADD CONSTRAINT "PUBLIC"."PK_DASHBOARDCARD_SERIES" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.DASHBOARDCARD_SERIES;
CREATE INDEX "PUBLIC"."IDX_DASHBOARDCARD_SERIES_DASHBOARDCARD_ID" ON "PUBLIC"."DASHBOARDCARD_SERIES"("DASHBOARDCARD_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_DASHBOARDCARD_SERIES_CARD_ID" ON "PUBLIC"."DASHBOARDCARD_SERIES"("CARD_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."QRTZ_JOB_DETAILS" COMMENT 'Used for Quartz scheduler.'(
    "SCHED_NAME" CHARACTER VARYING(120) NOT NULL,
    "JOB_NAME" CHARACTER VARYING(200) NOT NULL,
    "JOB_GROUP" CHARACTER VARYING(200) NOT NULL,
    "DESCRIPTION" CHARACTER VARYING(250),
    "JOB_CLASS_NAME" CHARACTER VARYING(250) NOT NULL,
    "IS_DURABLE" BOOLEAN NOT NULL,
    "IS_NONCONCURRENT" BOOLEAN NOT NULL,
    "IS_UPDATE_DATA" BOOLEAN NOT NULL,
    "REQUESTS_RECOVERY" BOOLEAN NOT NULL,
    "JOB_DATA" BINARY LARGE OBJECT
);
ALTER TABLE "PUBLIC"."QRTZ_JOB_DETAILS" ADD CONSTRAINT "PUBLIC"."PK_QRTZ_JOB_DETAILS" PRIMARY KEY("SCHED_NAME", "JOB_NAME", "JOB_GROUP");
-- 12 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_JOB_DETAILS;
CREATE INDEX "PUBLIC"."IDX_QRTZ_J_REQ_RECOVERY" ON "PUBLIC"."QRTZ_JOB_DETAILS"("SCHED_NAME" NULLS FIRST, "REQUESTS_RECOVERY" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_J_GRP" ON "PUBLIC"."QRTZ_JOB_DETAILS"("SCHED_NAME" NULLS FIRST, "JOB_GROUP" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."ACTIVITY"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "TOPIC" CHARACTER VARYING(32) NOT NULL,
    "TIMESTAMP" TIMESTAMP NOT NULL,
    "USER_ID" INTEGER,
    "MODEL" CHARACTER VARYING(16),
    "MODEL_ID" INTEGER,
    "DATABASE_ID" INTEGER,
    "TABLE_ID" INTEGER,
    "CUSTOM_ID" CHARACTER VARYING(48),
    "DETAILS" CHARACTER LARGE OBJECT NOT NULL
);
ALTER TABLE "PUBLIC"."ACTIVITY" ADD CONSTRAINT "PUBLIC"."PK_ACTIVITY" PRIMARY KEY("ID");
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.ACTIVITY;
CREATE INDEX "PUBLIC"."IDX_ACTIVITY_TIMESTAMP" ON "PUBLIC"."ACTIVITY"("TIMESTAMP" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_ACTIVITY_USER_ID" ON "PUBLIC"."ACTIVITY"("USER_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_ACTIVITY_CUSTOM_ID" ON "PUBLIC"."ACTIVITY"("CUSTOM_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."QUERY_CACHE" COMMENT 'Cached results of queries are stored here when using the DB-based query cache.'(
    "QUERY_HASH" BINARY(32) COMMENT 'The hash of the query dictionary. (This is a 256-bit SHA3 hash of the query dict).' NOT NULL,
    "UPDATED_AT" TIMESTAMP WITH TIME ZONE NOT NULL,
    "RESULTS" BINARY LARGE OBJECT COMMENT 'Cached, compressed results of running the query with the given hash.' NOT NULL
);
ALTER TABLE "PUBLIC"."QUERY_CACHE" ADD CONSTRAINT "PUBLIC"."PK_QUERY_CACHE" PRIMARY KEY("QUERY_HASH");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QUERY_CACHE;
CREATE INDEX "PUBLIC"."IDX_QUERY_CACHE_UPDATED_AT" ON "PUBLIC"."QUERY_CACHE"("UPDATED_AT" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."SECRET" COMMENT 'Storage for managed secrets (passwords, binary data, etc.)'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) COMMENT 'Part of composite primary key for secret; this is the uniquely generted ID column' NOT NULL,
    "VERSION" INTEGER DEFAULT 1 COMMENT 'Part of composite primary key for secret; this is the version column' NOT NULL,
    "CREATOR_ID" INTEGER COMMENT 'User ID who created this secret instance',
    "CREATED_AT" TIMESTAMP WITH TIME ZONE COMMENT 'Timestamp for when this secret instance was created' NOT NULL,
    "UPDATED_AT" TIMESTAMP WITH TIME ZONE COMMENT 'Timestamp for when this secret record was updated. Only relevant when non-value field changes since a value change will result in a new version being inserted.',
    "NAME" CHARACTER VARYING(254) COMMENT 'The name of this secret record.' NOT NULL,
    "KIND" CHARACTER VARYING(254) COMMENT 'The kind of secret this record represents; the value is interpreted as a Clojure keyword with a hierarchy. Ex: ''bytes'' means generic binary data, ''jks-keystore'' extends ''bytes'' but has a specific meaning.' NOT NULL,
    "SOURCE" CHARACTER VARYING(254) COMMENT 'The source of secret record, which controls how Metabase interprets the value (ex: ''file-path'' means the ''simple_value'' is not the real value, but a pointer to a file that contains the value).',
    "VALUE" BINARY LARGE OBJECT COMMENT 'The base64 encoded binary value of this secret record. If encryption is enabled, this will be the output of the encryption procedure on the plaintext. If not, it will be the base64 encoded plaintext.' NOT NULL
);
ALTER TABLE "PUBLIC"."SECRET" ADD CONSTRAINT "PUBLIC"."PK_SECRET" PRIMARY KEY("ID", "VERSION");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SECRET;
CREATE CACHED TABLE "PUBLIC"."QRTZ_TRIGGERS" COMMENT 'Used for Quartz scheduler.'(
    "SCHED_NAME" CHARACTER VARYING(120) NOT NULL,
    "TRIGGER_NAME" CHARACTER VARYING(200) NOT NULL,
    "TRIGGER_GROUP" CHARACTER VARYING(200) NOT NULL,
    "JOB_NAME" CHARACTER VARYING(200) NOT NULL,
    "JOB_GROUP" CHARACTER VARYING(200) NOT NULL,
    "DESCRIPTION" CHARACTER VARYING(250),
    "NEXT_FIRE_TIME" BIGINT,
    "PREV_FIRE_TIME" BIGINT,
    "PRIORITY" INTEGER,
    "TRIGGER_STATE" CHARACTER VARYING(16) NOT NULL,
    "TRIGGER_TYPE" CHARACTER VARYING(8) NOT NULL,
    "START_TIME" BIGINT NOT NULL,
    "END_TIME" BIGINT,
    "CALENDAR_NAME" CHARACTER VARYING(200),
    "MISFIRE_INSTR" SMALLINT,
    "JOB_DATA" BINARY LARGE OBJECT
);
ALTER TABLE "PUBLIC"."QRTZ_TRIGGERS" ADD CONSTRAINT "PUBLIC"."PK_QRTZ_TRIGGERS" PRIMARY KEY("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP");
-- 9 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_TRIGGERS;
CREATE INDEX "PUBLIC"."IDX_QRTZ_T_J" ON "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME" NULLS FIRST, "JOB_NAME" NULLS FIRST, "JOB_GROUP" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_T_JG" ON "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME" NULLS FIRST, "JOB_GROUP" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_T_C" ON "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME" NULLS FIRST, "CALENDAR_NAME" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_T_G" ON "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME" NULLS FIRST, "TRIGGER_GROUP" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_T_STATE" ON "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME" NULLS FIRST, "TRIGGER_STATE" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_T_N_STATE" ON "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME" NULLS FIRST, "TRIGGER_NAME" NULLS FIRST, "TRIGGER_GROUP" NULLS FIRST, "TRIGGER_STATE" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_T_N_G_STATE" ON "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME" NULLS FIRST, "TRIGGER_GROUP" NULLS FIRST, "TRIGGER_STATE" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_T_NEXT_FIRE_TIME" ON "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME" NULLS FIRST, "NEXT_FIRE_TIME" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_T_NFT_ST" ON "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME" NULLS FIRST, "TRIGGER_STATE" NULLS FIRST, "NEXT_FIRE_TIME" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_T_NFT_MISFIRE" ON "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME" NULLS FIRST, "MISFIRE_INSTR" NULLS FIRST, "NEXT_FIRE_TIME" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_T_NFT_ST_MISFIRE" ON "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME" NULLS FIRST, "MISFIRE_INSTR" NULLS FIRST, "NEXT_FIRE_TIME" NULLS FIRST, "TRIGGER_STATE" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_T_NFT_ST_MISFIRE_GRP" ON "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME" NULLS FIRST, "MISFIRE_INSTR" NULLS FIRST, "NEXT_FIRE_TIME" NULLS FIRST, "TRIGGER_GROUP" NULLS FIRST, "TRIGGER_STATE" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."BOOKMARK_ORDERING" COMMENT 'Table holding ordering information for various bookmark tables'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "USER_ID" INTEGER COMMENT 'ID of the User who ordered bookmarks' NOT NULL,
    "TYPE" CHARACTER VARYING(255) COMMENT 'type of the Bookmark' NOT NULL,
    "ITEM_ID" INTEGER COMMENT 'id of the item being bookmarked (Card, Collection, Dashboard, ...) no FK, so may no longer exist' NOT NULL,
    "ORDERING" INTEGER COMMENT 'order of bookmark for user' NOT NULL
);
ALTER TABLE "PUBLIC"."BOOKMARK_ORDERING" ADD CONSTRAINT "PUBLIC"."PK_BOOKMARK_ORDERING" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.BOOKMARK_ORDERING;
CREATE INDEX "PUBLIC"."IDX_BOOKMARK_ORDERING_USER_ID" ON "PUBLIC"."BOOKMARK_ORDERING"("USER_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."MODERATION_REVIEW" COMMENT 'Reviews (from moderators) for a given question/dashboard (BUCM)'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "UPDATED_AT" TIMESTAMP WITH TIME ZONE DEFAULT LOCALTIMESTAMP COMMENT 'most recent modification time' NOT NULL,
    "CREATED_AT" TIMESTAMP WITH TIME ZONE DEFAULT LOCALTIMESTAMP COMMENT 'creation time' NOT NULL,
    "STATUS" CHARACTER VARYING(255) COMMENT 'verified, misleading, confusing, not_misleading, pending',
    "TEXT" CHARACTER LARGE OBJECT COMMENT 'Explanation of the review',
    "MODERATED_ITEM_ID" INTEGER COMMENT 'either a document or question ID; the item that needs review' NOT NULL,
    "MODERATED_ITEM_TYPE" CHARACTER VARYING(255) COMMENT 'whether it''s a question or dashboard' NOT NULL,
    "MODERATOR_ID" INTEGER COMMENT 'ID of the user who did the review' NOT NULL,
    "MOST_RECENT" BOOLEAN COMMENT 'tag for most recent review' NOT NULL
);
ALTER TABLE "PUBLIC"."MODERATION_REVIEW" ADD CONSTRAINT "PUBLIC"."PK_MODERATION_REVIEW" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.MODERATION_REVIEW;
CREATE INDEX "PUBLIC"."IDX_MODERATION_REVIEW_ITEM_TYPE_ITEM_ID" ON "PUBLIC"."MODERATION_REVIEW"("MODERATED_ITEM_TYPE" NULLS FIRST, "MODERATED_ITEM_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."COLLECTION" COMMENT 'Collections are an optional way to organize Cards and handle permissions for them.'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "NAME" CHARACTER LARGE OBJECT COMMENT 'The user-facing name of this Collection.' NOT NULL,
    "DESCRIPTION" CHARACTER LARGE OBJECT COMMENT 'Optional description for this Collection.',
    "COLOR" CHARACTER(7) COMMENT 'Seven-character hex color for this Collection, including the preceding hash sign.' NOT NULL,
    "ARCHIVED" BOOLEAN DEFAULT FALSE COMMENT 'Whether this Collection has been archived and should be hidden from users.' NOT NULL,
    "LOCATION" CHARACTER VARYING(254) DEFAULT '/' COMMENT 'Directory-structure path of ancestor Collections. e.g. "/1/2/" means our Parent is Collection 2, and their parent is Collection 1.' NOT NULL,
    "PERSONAL_OWNER_ID" INTEGER COMMENT 'If set, this Collection is a personal Collection, for exclusive use of the User with this ID.',
    "SLUG" CHARACTER VARYING(254) COMMENT 'Sluggified version of the Collection name. Used only for display purposes in URL; not unique or indexed.' NOT NULL,
    "NAMESPACE" CHARACTER VARYING(254) COMMENT 'The namespace (hierachy) this Collection belongs to. NULL means the Collection is in the default namespace.',
    "AUTHORITY_LEVEL" CHARACTER VARYING(255) COMMENT 'Nullable column to incidate collection''s authority level. Initially values are "official" and nil.',
    "ENTITY_ID" CHARACTER(21) COMMENT 'Random NanoID tag for unique identity.'
);
ALTER TABLE "PUBLIC"."COLLECTION" ADD CONSTRAINT "PUBLIC"."PK_COLLECTION" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.COLLECTION;
CREATE INDEX "PUBLIC"."IDX_COLLECTION_LOCATION" ON "PUBLIC"."COLLECTION"("LOCATION" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_COLLECTION_PERSONAL_OWNER_ID" ON "PUBLIC"."COLLECTION"("PERSONAL_OWNER_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."PULSE_CARD"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "PULSE_ID" INTEGER NOT NULL,
    "CARD_ID" INTEGER NOT NULL,
    "POSITION" INTEGER NOT NULL,
    "INCLUDE_CSV" BOOLEAN DEFAULT FALSE COMMENT 'True if a CSV of the data should be included for this pulse card' NOT NULL,
    "INCLUDE_XLS" BOOLEAN DEFAULT FALSE COMMENT 'True if a XLS of the data should be included for this pulse card' NOT NULL,
    "DASHBOARD_CARD_ID" INTEGER COMMENT 'If this Pulse is a Dashboard subscription, the ID of the DashboardCard that corresponds to this PulseCard.',
    "ENTITY_ID" CHARACTER(21) COMMENT 'Random NanoID tag for unique identity.'
);
ALTER TABLE "PUBLIC"."PULSE_CARD" ADD CONSTRAINT "PUBLIC"."PK_PULSE_CARD" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PULSE_CARD;
CREATE INDEX "PUBLIC"."IDX_PULSE_CARD_PULSE_ID" ON "PUBLIC"."PULSE_CARD"("PULSE_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_PULSE_CARD_CARD_ID" ON "PUBLIC"."PULSE_CARD"("CARD_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."REPORT_CARDFAVORITE"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "CREATED_AT" TIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP NOT NULL,
    "CARD_ID" INTEGER NOT NULL,
    "OWNER_ID" INTEGER NOT NULL
);
ALTER TABLE "PUBLIC"."REPORT_CARDFAVORITE" ADD CONSTRAINT "PUBLIC"."PK_REPORT_CARDFAVORITE" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.REPORT_CARDFAVORITE;
CREATE INDEX "PUBLIC"."IDX_CARDFAVORITE_CARD_ID" ON "PUBLIC"."REPORT_CARDFAVORITE"("CARD_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_CARDFAVORITE_OWNER_ID" ON "PUBLIC"."REPORT_CARDFAVORITE"("OWNER_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."PULSE_CHANNEL"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "PULSE_ID" INTEGER NOT NULL,
    "CHANNEL_TYPE" CHARACTER VARYING(32) NOT NULL,
    "DETAILS" CHARACTER LARGE OBJECT NOT NULL,
    "SCHEDULE_TYPE" CHARACTER VARYING(32) NOT NULL,
    "SCHEDULE_HOUR" INTEGER,
    "SCHEDULE_DAY" CHARACTER VARYING(64),
    "CREATED_AT" TIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP NOT NULL,
    "SCHEDULE_FRAME" CHARACTER VARYING(32),
    "ENABLED" BOOLEAN DEFAULT TRUE NOT NULL,
    "ENTITY_ID" CHARACTER(21) COMMENT 'Random NanoID tag for unique identity.'
);
ALTER TABLE "PUBLIC"."PULSE_CHANNEL" ADD CONSTRAINT "PUBLIC"."PK_PULSE_CHANNEL" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PULSE_CHANNEL;
CREATE INDEX "PUBLIC"."IDX_PULSE_CHANNEL_PULSE_ID" ON "PUBLIC"."PULSE_CHANNEL"("PULSE_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_PULSE_CHANNEL_SCHEDULE_TYPE" ON "PUBLIC"."PULSE_CHANNEL"("SCHEDULE_TYPE" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."COMPUTATION_JOB" COMMENT 'Stores submitted async computation jobs.'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "CREATOR_ID" INTEGER,
    "CREATED_AT" TIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP NOT NULL,
    "TYPE" CHARACTER VARYING(254) NOT NULL,
    "STATUS" CHARACTER VARYING(254) NOT NULL,
    "CONTEXT" CHARACTER LARGE OBJECT,
    "ENDED_AT" TIMESTAMP
);
ALTER TABLE "PUBLIC"."COMPUTATION_JOB" ADD CONSTRAINT "PUBLIC"."PK_COMPUTATION_JOB" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.COMPUTATION_JOB;
CREATE CACHED TABLE "PUBLIC"."GROUP_TABLE_ACCESS_POLICY" COMMENT 'Records that a given Card (Question) should automatically replace a given Table as query source for a given a Perms Group.'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "GROUP_ID" INTEGER COMMENT 'ID of the Permissions Group this policy affects.' NOT NULL,
    "TABLE_ID" INTEGER COMMENT 'ID of the Table that should get automatically replaced as query source for the Permissions Group.' NOT NULL,
    "CARD_ID" INTEGER COMMENT 'ID of the Card (Question) to be used to replace the Table.',
    "ATTRIBUTE_REMAPPINGS" CHARACTER LARGE OBJECT COMMENT 'JSON-encoded map of user attribute identifier to the param name used in the Card.'
);
ALTER TABLE "PUBLIC"."GROUP_TABLE_ACCESS_POLICY" ADD CONSTRAINT "PUBLIC"."PK_GROUP_TABLE_ACCESS_POLICY" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.GROUP_TABLE_ACCESS_POLICY;
CREATE INDEX "PUBLIC"."IDX_GTAP_TABLE_ID_GROUP_ID" ON "PUBLIC"."GROUP_TABLE_ACCESS_POLICY"("TABLE_ID" NULLS FIRST, "GROUP_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."CARD_LABEL"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "CARD_ID" INTEGER NOT NULL,
    "LABEL_ID" INTEGER NOT NULL
);
ALTER TABLE "PUBLIC"."CARD_LABEL" ADD CONSTRAINT "PUBLIC"."PK_CARD_LABEL" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CARD_LABEL;
CREATE INDEX "PUBLIC"."IDX_CARD_LABEL_CARD_ID" ON "PUBLIC"."CARD_LABEL"("CARD_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_CARD_LABEL_LABEL_ID" ON "PUBLIC"."CARD_LABEL"("LABEL_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."PULSE"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "CREATOR_ID" INTEGER NOT NULL,
    "NAME" CHARACTER VARYING(254),
    "CREATED_AT" TIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP NOT NULL,
    "SKIP_IF_EMPTY" BOOLEAN DEFAULT FALSE COMMENT 'Skip a scheduled Pulse if none of its questions have any results' NOT NULL,
    "ALERT_CONDITION" CHARACTER VARYING(254) COMMENT 'Condition (i.e. "rows" or "goal") used as a guard for alerts',
    "ALERT_FIRST_ONLY" BOOLEAN COMMENT 'True if the alert should be disabled after the first notification',
    "ALERT_ABOVE_GOAL" BOOLEAN COMMENT 'For a goal condition, alert when above the goal',
    "COLLECTION_ID" INTEGER COMMENT 'Options ID of Collection this Pulse belongs to.',
    "COLLECTION_POSITION" SMALLINT COMMENT 'Optional pinned position for this item in its Collection. NULL means item is not pinned.',
    "ARCHIVED" BOOLEAN DEFAULT FALSE COMMENT 'Has this pulse been archived?',
    "DASHBOARD_ID" INTEGER COMMENT 'ID of the Dashboard if this Pulse is a Dashboard Subscription.',
    "PARAMETERS" CHARACTER LARGE OBJECT COMMENT 'Let dashboard subscriptions have their own filters' NOT NULL,
    "ENTITY_ID" CHARACTER(21) COMMENT 'Random NanoID tag for unique identity.'
);
ALTER TABLE "PUBLIC"."PULSE" ADD CONSTRAINT "PUBLIC"."PK_PULSE" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PULSE;
CREATE INDEX "PUBLIC"."IDX_PULSE_CREATOR_ID" ON "PUBLIC"."PULSE"("CREATOR_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_PULSE_COLLECTION_ID" ON "PUBLIC"."PULSE"("COLLECTION_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."CORE_SESSION"(
    "ID" CHARACTER VARYING(254) NOT NULL,
    "USER_ID" INTEGER NOT NULL,
    "CREATED_AT" TIMESTAMP NOT NULL,
    "ANTI_CSRF_TOKEN" CHARACTER LARGE OBJECT COMMENT 'Anti-CSRF token for full-app embed sessions.'
);
ALTER TABLE "PUBLIC"."CORE_SESSION" ADD CONSTRAINT "PUBLIC"."PK_CORE_SESSION" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CORE_SESSION;
CREATE CACHED TABLE "PUBLIC"."LOGIN_HISTORY" COMMENT 'Keeps track of various logins for different users and additional info such as location and device'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "TIMESTAMP" TIMESTAMP WITH TIME ZONE DEFAULT LOCALTIMESTAMP COMMENT 'When this login occurred.' NOT NULL,
    "USER_ID" INTEGER COMMENT 'ID of the User that logged in.' NOT NULL,
    "SESSION_ID" CHARACTER VARYING(254) COMMENT 'ID of the Session created by this login if one is currently active. NULL if Session is no longer active.',
    "DEVICE_ID" CHARACTER(36) COMMENT 'Cookie-based unique identifier for the device/browser the user logged in from.' NOT NULL,
    "DEVICE_DESCRIPTION" CHARACTER LARGE OBJECT COMMENT 'Description of the device that login happened from, for example a user-agent string, but this might be something different if we support alternative auth mechanisms in the future.' NOT NULL,
    "IP_ADDRESS" CHARACTER LARGE OBJECT COMMENT 'IP address of the device that login happened from, so we can geocode it and determine approximate location.' NOT NULL
);
ALTER TABLE "PUBLIC"."LOGIN_HISTORY" ADD CONSTRAINT "PUBLIC"."PK_LOGIN_HISTORY" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.LOGIN_HISTORY;
CREATE INDEX "PUBLIC"."IDX_USER_ID" ON "PUBLIC"."LOGIN_HISTORY"("USER_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_SESSION_ID" ON "PUBLIC"."LOGIN_HISTORY"("SESSION_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_TIMESTAMP" ON "PUBLIC"."LOGIN_HISTORY"("TIMESTAMP" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_USER_ID_DEVICE_ID" ON "PUBLIC"."LOGIN_HISTORY"("SESSION_ID" NULLS FIRST, "DEVICE_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_USER_ID_TIMESTAMP" ON "PUBLIC"."LOGIN_HISTORY"("USER_ID" NULLS FIRST, "TIMESTAMP" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."COMPUTATION_JOB_RESULT" COMMENT 'Stores results of async computation jobs.'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "JOB_ID" INTEGER NOT NULL,
    "CREATED_AT" TIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP NOT NULL,
    "PERMANENCE" CHARACTER VARYING(254) NOT NULL,
    "PAYLOAD" CHARACTER LARGE OBJECT NOT NULL
);
ALTER TABLE "PUBLIC"."COMPUTATION_JOB_RESULT" ADD CONSTRAINT "PUBLIC"."PK_COMPUTATION_JOB_RESULT" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.COMPUTATION_JOB_RESULT;
CREATE CACHED TABLE "PUBLIC"."TIMELINE" COMMENT 'Timeline table to organize events'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "NAME" CHARACTER VARYING(255) COMMENT 'Name of the timeline' NOT NULL,
    "DESCRIPTION" CHARACTER VARYING(255) COMMENT 'Optional description of the timeline',
    "ICON" CHARACTER VARYING(128) COMMENT 'the icon to use when displaying the event' NOT NULL,
    "COLLECTION_ID" INTEGER COMMENT 'ID of the collection containing the timeline',
    "ARCHIVED" BOOLEAN DEFAULT FALSE COMMENT 'Whether or not the timeline has been archived' NOT NULL,
    "CREATOR_ID" INTEGER COMMENT 'ID of the user who created the timeline' NOT NULL,
    "CREATED_AT" TIMESTAMP WITH TIME ZONE DEFAULT LOCALTIMESTAMP COMMENT 'The timestamp of when the timeline was created' NOT NULL,
    "UPDATED_AT" TIMESTAMP WITH TIME ZONE DEFAULT LOCALTIMESTAMP COMMENT 'The timestamp of when the timeline was updated' NOT NULL,
    "DEFAULT" BOOLEAN DEFAULT 'false' COMMENT 'Boolean value indicating if the timeline is the default one for the containing Collection' NOT NULL,
    "ENTITY_ID" CHARACTER(21) COMMENT 'Random NanoID tag for unique identity.'
);
ALTER TABLE "PUBLIC"."TIMELINE" ADD CONSTRAINT "PUBLIC"."PK_TIMELINE" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.TIMELINE;
CREATE INDEX "PUBLIC"."IDX_TIMELINE_COLLECTION_ID" ON "PUBLIC"."TIMELINE"("COLLECTION_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."REPORT_CARD"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "CREATED_AT" TIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP NOT NULL,
    "NAME" CHARACTER VARYING(254) NOT NULL,
    "DESCRIPTION" CHARACTER LARGE OBJECT,
    "DISPLAY" CHARACTER VARYING(254) NOT NULL,
    "DATASET_QUERY" CHARACTER LARGE OBJECT NOT NULL,
    "VISUALIZATION_SETTINGS" CHARACTER LARGE OBJECT NOT NULL,
    "CREATOR_ID" INTEGER NOT NULL,
    "DATABASE_ID" INTEGER NOT NULL,
    "TABLE_ID" INTEGER,
    "QUERY_TYPE" CHARACTER VARYING(16),
    "ARCHIVED" BOOLEAN DEFAULT FALSE NOT NULL,
    "COLLECTION_ID" INTEGER COMMENT 'Optional ID of Collection this Card belongs to.',
    "PUBLIC_UUID" CHARACTER(36) COMMENT 'Unique UUID used to in publically-accessible links to this Card.',
    "MADE_PUBLIC_BY_ID" INTEGER COMMENT 'The ID of the User who first publically shared this Card.',
    "ENABLE_EMBEDDING" BOOLEAN DEFAULT FALSE COMMENT 'Is this Card allowed to be embedded in different websites (using a signed JWT)?' NOT NULL,
    "EMBEDDING_PARAMS" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON containing information about required parameters that must be supplied when embedding this Card.',
    "CACHE_TTL" INTEGER COMMENT 'The maximum time, in seconds, to return cached results for this Card rather than running a new query.',
    "RESULT_METADATA" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON containing metadata about the result columns from running the query.',
    "COLLECTION_POSITION" SMALLINT COMMENT 'Optional pinned position for this item in its Collection. NULL means item is not pinned.',
    "DATASET" BOOLEAN DEFAULT 'false' COMMENT 'Indicate whether question is a dataset' NOT NULL,
    "ENTITY_ID" CHARACTER(21) COMMENT 'Random NanoID tag for unique identity.',
    "PARAMETERS" CHARACTER LARGE OBJECT COMMENT 'List of parameter associated to a card',
    "PARAMETER_MAPPINGS" CHARACTER LARGE OBJECT COMMENT 'List of parameter associated to a card',
    "COLLECTION_PREVIEW" BOOLEAN DEFAULT TRUE COMMENT 'Indicating whether the card should be visualized in the collection preview' NOT NULL
);
ALTER TABLE "PUBLIC"."REPORT_CARD" ADD CONSTRAINT "PUBLIC"."PK_REPORT_CARD" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.REPORT_CARD;
CREATE INDEX "PUBLIC"."IDX_CARD_CREATOR_ID" ON "PUBLIC"."REPORT_CARD"("CREATOR_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_CARD_COLLECTION_ID" ON "PUBLIC"."REPORT_CARD"("COLLECTION_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_CARD_PUBLIC_UUID" ON "PUBLIC"."REPORT_CARD"("PUBLIC_UUID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."APPLICATION_PERMISSIONS_REVISION" COMMENT 'Used to keep track of changes made to general permissions.'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "BEFORE" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON of the permission graph before the changes.' NOT NULL,
    "AFTER" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON of the changes in permission graph.' NOT NULL,
    "USER_ID" INTEGER COMMENT 'The ID of the admin who made this set of changes.' NOT NULL,
    "CREATED_AT" TIMESTAMP COMMENT 'The timestamp of when these changes were made.' NOT NULL,
    "REMARK" CHARACTER LARGE OBJECT COMMENT 'Optional remarks explaining why these changes were made.'
);
ALTER TABLE "PUBLIC"."APPLICATION_PERMISSIONS_REVISION" ADD CONSTRAINT "PUBLIC"."PK_GENERAL_PERMISSIONS_REVISION" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.APPLICATION_PERMISSIONS_REVISION;
CREATE CACHED TABLE "PUBLIC"."SEGMENT"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "TABLE_ID" INTEGER NOT NULL,
    "CREATOR_ID" INTEGER NOT NULL,
    "NAME" CHARACTER VARYING(254) NOT NULL,
    "DESCRIPTION" CHARACTER LARGE OBJECT,
    "ARCHIVED" BOOLEAN DEFAULT FALSE NOT NULL,
    "DEFINITION" CHARACTER LARGE OBJECT NOT NULL,
    "CREATED_AT" TIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP NOT NULL,
    "POINTS_OF_INTEREST" CHARACTER LARGE OBJECT,
    "CAVEATS" CHARACTER LARGE OBJECT,
    "SHOW_IN_GETTING_STARTED" BOOLEAN DEFAULT FALSE NOT NULL,
    "ENTITY_ID" CHARACTER(21) COMMENT 'Random NanoID tag for unique identity.'
);
ALTER TABLE "PUBLIC"."SEGMENT" ADD CONSTRAINT "PUBLIC"."PK_SEGMENT" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SEGMENT;
CREATE INDEX "PUBLIC"."IDX_SEGMENT_CREATOR_ID" ON "PUBLIC"."SEGMENT"("CREATOR_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_SEGMENT_TABLE_ID" ON "PUBLIC"."SEGMENT"("TABLE_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_SEGMENT_SHOW_IN_GETTING_STARTED" ON "PUBLIC"."SEGMENT"("SHOW_IN_GETTING_STARTED" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."PERSISTED_INFO" COMMENT 'Table holding information about persisted models'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "DATABASE_ID" INTEGER COMMENT 'ID of the database associated to the persisted card' NOT NULL,
    "CARD_ID" INTEGER COMMENT 'ID of the Card model persisted' NOT NULL,
    "QUESTION_SLUG" CHARACTER LARGE OBJECT COMMENT 'Slug of the card which will form the persisted table name' NOT NULL,
    "TABLE_NAME" CHARACTER LARGE OBJECT COMMENT 'Name of the table persisted' NOT NULL,
    "DEFINITION" CHARACTER LARGE OBJECT COMMENT 'JSON object that captures the state of the table when we persisted',
    "QUERY_HASH" CHARACTER LARGE OBJECT COMMENT 'Hash of the query persisted',
    "ACTIVE" BOOLEAN DEFAULT FALSE COMMENT 'Indicating whether the persisted table is active and can be swapped' NOT NULL,
    "STATE" CHARACTER LARGE OBJECT COMMENT 'Persisted table state (creating, persisted, refreshing, deleted)' NOT NULL,
    "REFRESH_BEGIN" TIMESTAMP WITH TIME ZONE COMMENT 'The timestamp of when the most recent refresh was started' NOT NULL,
    "REFRESH_END" TIMESTAMP WITH TIME ZONE COMMENT 'The timestamp of when the most recent refresh ended',
    "STATE_CHANGE_AT" TIMESTAMP WITH TIME ZONE COMMENT 'The timestamp of when the most recent state changed',
    "ERROR" CHARACTER LARGE OBJECT COMMENT 'Error message from persisting if applicable',
    "CREATED_AT" TIMESTAMP WITH TIME ZONE DEFAULT LOCALTIMESTAMP COMMENT 'The timestamp of when the model was first persisted' NOT NULL,
    "CREATOR_ID" INTEGER COMMENT 'The person who persisted a model'
);
ALTER TABLE "PUBLIC"."PERSISTED_INFO" ADD CONSTRAINT "PUBLIC"."PK_PERSISTED_INFO" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PERSISTED_INFO;
CREATE CACHED TABLE "PUBLIC"."QUERY_EXECUTION" COMMENT 'A log of executed queries, used for calculating historic execution times, auditing, and other purposes.'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "HASH" BINARY(32) COMMENT 'The hash of the query dictionary. This is a 256-bit SHA3 hash of the query.' NOT NULL,
    "STARTED_AT" TIMESTAMP WITH TIME ZONE NOT NULL,
    "RUNNING_TIME" INTEGER COMMENT 'The time, in milliseconds, this query took to complete.' NOT NULL,
    "RESULT_ROWS" INTEGER COMMENT 'Number of rows in the query results.' NOT NULL,
    "NATIVE" BOOLEAN COMMENT 'Whether the query was a native query, as opposed to an MBQL one (e.g., created with the GUI).' NOT NULL,
    "CONTEXT" CHARACTER VARYING(32) COMMENT 'Short string specifying how this query was executed, e.g. in a Dashboard or Pulse.',
    "ERROR" CHARACTER LARGE OBJECT COMMENT 'Error message returned by failed query, if any.',
    "EXECUTOR_ID" INTEGER COMMENT 'The ID of the User who triggered this query execution, if any.',
    "CARD_ID" INTEGER COMMENT 'The ID of the Card (Question) associated with this query execution, if any.',
    "DASHBOARD_ID" INTEGER COMMENT 'The ID of the Dashboard associated with this query execution, if any.',
    "PULSE_ID" INTEGER COMMENT 'The ID of the Pulse associated with this query execution, if any.',
    "DATABASE_ID" INTEGER COMMENT 'ID of the database this query was ran against.',
    "CACHE_HIT" BOOLEAN COMMENT 'Cache hit on query execution'
);
ALTER TABLE "PUBLIC"."QUERY_EXECUTION" ADD CONSTRAINT "PUBLIC"."PK_QUERY_EXECUTION" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QUERY_EXECUTION;
CREATE INDEX "PUBLIC"."IDX_QUERY_EXECUTION_CARD_ID" ON "PUBLIC"."QUERY_EXECUTION"("CARD_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QUERY_EXECUTION_CARD_ID_STARTED_AT" ON "PUBLIC"."QUERY_EXECUTION"("CARD_ID" NULLS FIRST, "STARTED_AT" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QUERY_EXECUTION_STARTED_AT" ON "PUBLIC"."QUERY_EXECUTION"("STARTED_AT" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QUERY_EXECUTION_QUERY_HASH_STARTED_AT" ON "PUBLIC"."QUERY_EXECUTION"("HASH" NULLS FIRST, "STARTED_AT" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."VIEW_LOG"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "USER_ID" INTEGER,
    "MODEL" CHARACTER VARYING(16) NOT NULL,
    "MODEL_ID" INTEGER NOT NULL,
    "TIMESTAMP" TIMESTAMP WITH TIME ZONE NOT NULL,
    "METADATA" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON corresponding to metadata for view.'
);
ALTER TABLE "PUBLIC"."VIEW_LOG" ADD CONSTRAINT "PUBLIC"."PK_VIEW_LOG" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.VIEW_LOG;
CREATE INDEX "PUBLIC"."IDX_VIEW_LOG_USER_ID" ON "PUBLIC"."VIEW_LOG"("USER_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_VIEW_LOG_TIMESTAMP" ON "PUBLIC"."VIEW_LOG"("MODEL_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."NATIVE_QUERY_SNIPPET" COMMENT 'Query snippets (raw text) to be substituted in native queries'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "NAME" CHARACTER VARYING(254) COMMENT 'Name of the query snippet' NOT NULL,
    "DESCRIPTION" CHARACTER LARGE OBJECT,
    "CONTENT" CHARACTER LARGE OBJECT COMMENT 'Raw query snippet' NOT NULL,
    "CREATOR_ID" INTEGER NOT NULL,
    "ARCHIVED" BOOLEAN DEFAULT FALSE NOT NULL,
    "CREATED_AT" TIMESTAMP WITH TIME ZONE DEFAULT LOCALTIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP WITH TIME ZONE DEFAULT LOCALTIMESTAMP NOT NULL,
    "COLLECTION_ID" INTEGER COMMENT 'ID of the Snippet Folder (Collection) this Snippet is in, if any',
    "ENTITY_ID" CHARACTER(21) COMMENT 'Random NanoID tag for unique identity.'
);
ALTER TABLE "PUBLIC"."NATIVE_QUERY_SNIPPET" ADD CONSTRAINT "PUBLIC"."PK_NATIVE_QUERY_SNIPPET" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.NATIVE_QUERY_SNIPPET;
CREATE INDEX "PUBLIC"."IDX_SNIPPET_NAME" ON "PUBLIC"."NATIVE_QUERY_SNIPPET"("NAME" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_SNIPPET_COLLECTION_ID" ON "PUBLIC"."NATIVE_QUERY_SNIPPET"("COLLECTION_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."PULSE_CHANNEL_RECIPIENT"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "PULSE_CHANNEL_ID" INTEGER NOT NULL,
    "USER_ID" INTEGER NOT NULL
);
ALTER TABLE "PUBLIC"."PULSE_CHANNEL_RECIPIENT" ADD CONSTRAINT "PUBLIC"."PK_PULSE_CHANNEL_RECIPIENT" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PULSE_CHANNEL_RECIPIENT;
CREATE CACHED TABLE "PUBLIC"."METABASE_DATABASE"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "CREATED_AT" TIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP NOT NULL,
    "NAME" CHARACTER VARYING(254) NOT NULL,
    "DESCRIPTION" CHARACTER LARGE OBJECT,
    "DETAILS" CHARACTER LARGE OBJECT,
    "ENGINE" CHARACTER VARYING(254) NOT NULL,
    "IS_SAMPLE" BOOLEAN DEFAULT FALSE NOT NULL,
    "IS_FULL_SYNC" BOOLEAN DEFAULT TRUE NOT NULL,
    "POINTS_OF_INTEREST" CHARACTER LARGE OBJECT,
    "CAVEATS" CHARACTER LARGE OBJECT,
    "METADATA_SYNC_SCHEDULE" CHARACTER VARYING(254) DEFAULT '0 50 * * * ? *' COMMENT 'The cron schedule string for when this database should undergo the metadata sync process (and analysis for new fields).' NOT NULL,
    "CACHE_FIELD_VALUES_SCHEDULE" CHARACTER VARYING(254) DEFAULT '0 50 0 * * ? *' COMMENT 'The cron schedule string for when FieldValues for eligible Fields should be updated.' NOT NULL,
    "TIMEZONE" CHARACTER VARYING(254) COMMENT 'Timezone identifier for the database, set by the sync process',
    "IS_ON_DEMAND" BOOLEAN DEFAULT 'false' COMMENT 'Whether we should do On-Demand caching of FieldValues for this DB. This means FieldValues are updated when their Field is used in a Dashboard or Card param.' NOT NULL,
    "OPTIONS" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON containing various options like QB behavior.',
    "AUTO_RUN_QUERIES" BOOLEAN DEFAULT TRUE COMMENT 'Whether to automatically run queries when doing simple filtering and summarizing in the Query Builder.' NOT NULL,
    "REFINGERPRINT" BOOLEAN COMMENT 'Whether or not to enable periodic refingerprinting for this Database.',
    "CACHE_TTL" INTEGER COMMENT 'Granular cache TTL for specific database.',
    "INITIAL_SYNC_STATUS" CHARACTER VARYING(32) DEFAULT 'complete' COMMENT 'String indicating whether a database has completed its initial sync and is ready to use' NOT NULL,
    "CREATOR_ID" INTEGER COMMENT 'ID of the admin who added the database',
    "SETTINGS" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON containing Database-local Settings for this Database'
);
ALTER TABLE "PUBLIC"."METABASE_DATABASE" ADD CONSTRAINT "PUBLIC"."PK_METABASE_DATABASE" PRIMARY KEY("ID");
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.METABASE_DATABASE;
CREATE CACHED TABLE "PUBLIC"."QRTZ_SIMPLE_TRIGGERS" COMMENT 'Used for Quartz scheduler.'(
    "SCHED_NAME" CHARACTER VARYING(120) NOT NULL,
    "TRIGGER_NAME" CHARACTER VARYING(200) NOT NULL,
    "TRIGGER_GROUP" CHARACTER VARYING(200) NOT NULL,
    "REPEAT_COUNT" BIGINT NOT NULL,
    "REPEAT_INTERVAL" BIGINT NOT NULL,
    "TIMES_TRIGGERED" BIGINT NOT NULL
);
ALTER TABLE "PUBLIC"."QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "PUBLIC"."PK_QRTZ_SIMPLE_TRIGGERS" PRIMARY KEY("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_SIMPLE_TRIGGERS;
CREATE CACHED TABLE "PUBLIC"."CARD_BOOKMARK" COMMENT 'Table holding bookmarks on cards'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "USER_ID" INTEGER COMMENT 'ID of the User who bookmarked the Card' NOT NULL,
    "CARD_ID" INTEGER COMMENT 'ID of the Card bookmarked by the user' NOT NULL,
    "CREATED_AT" TIMESTAMP WITH TIME ZONE DEFAULT LOCALTIMESTAMP COMMENT 'The timestamp of when the bookmark was created' NOT NULL
);
ALTER TABLE "PUBLIC"."CARD_BOOKMARK" ADD CONSTRAINT "PUBLIC"."PK_CARD_BOOKMARK" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CARD_BOOKMARK;
CREATE INDEX "PUBLIC"."IDX_CARD_BOOKMARK_USER_ID" ON "PUBLIC"."CARD_BOOKMARK"("USER_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_CARD_BOOKMARK_CARD_ID" ON "PUBLIC"."CARD_BOOKMARK"("CARD_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."REPORT_DASHBOARDCARD"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "CREATED_AT" TIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP NOT NULL,
    "SIZEX" INTEGER NOT NULL,
    "SIZEY" INTEGER NOT NULL,
    "ROW" INTEGER DEFAULT 0 NOT NULL,
    "COL" INTEGER DEFAULT 0 NOT NULL,
    "CARD_ID" INTEGER,
    "DASHBOARD_ID" INTEGER NOT NULL,
    "PARAMETER_MAPPINGS" CHARACTER LARGE OBJECT NOT NULL,
    "VISUALIZATION_SETTINGS" CHARACTER LARGE OBJECT NOT NULL,
    "ENTITY_ID" CHARACTER(21) COMMENT 'Random NanoID tag for unique identity.'
);
ALTER TABLE "PUBLIC"."REPORT_DASHBOARDCARD" ADD CONSTRAINT "PUBLIC"."PK_REPORT_DASHBOARDCARD" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.REPORT_DASHBOARDCARD;
CREATE INDEX "PUBLIC"."IDX_DASHBOARDCARD_CARD_ID" ON "PUBLIC"."REPORT_DASHBOARDCARD"("CARD_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_DASHBOARDCARD_DASHBOARD_ID" ON "PUBLIC"."REPORT_DASHBOARDCARD"("DASHBOARD_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."REPORT_DASHBOARD"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "CREATED_AT" TIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP NOT NULL,
    "NAME" CHARACTER VARYING(254) NOT NULL,
    "DESCRIPTION" CHARACTER LARGE OBJECT,
    "CREATOR_ID" INTEGER NOT NULL,
    "PARAMETERS" CHARACTER LARGE OBJECT NOT NULL,
    "POINTS_OF_INTEREST" CHARACTER LARGE OBJECT,
    "CAVEATS" CHARACTER LARGE OBJECT,
    "SHOW_IN_GETTING_STARTED" BOOLEAN DEFAULT FALSE NOT NULL,
    "PUBLIC_UUID" CHARACTER(36) COMMENT 'Unique UUID used to in publically-accessible links to this Dashboard.',
    "MADE_PUBLIC_BY_ID" INTEGER COMMENT 'The ID of the User who first publically shared this Dashboard.',
    "ENABLE_EMBEDDING" BOOLEAN DEFAULT FALSE COMMENT 'Is this Dashboard allowed to be embedded in different websites (using a signed JWT)?' NOT NULL,
    "EMBEDDING_PARAMS" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON containing information about required parameters that must be supplied when embedding this Dashboard.',
    "ARCHIVED" BOOLEAN DEFAULT FALSE COMMENT 'Is this Dashboard archived (effectively treated as deleted?)' NOT NULL,
    "POSITION" INTEGER COMMENT 'The position this Dashboard should appear in the Dashboards list, lower-numbered positions appearing before higher numbered ones.',
    "COLLECTION_ID" INTEGER COMMENT 'Optional ID of Collection this Dashboard belongs to.',
    "COLLECTION_POSITION" SMALLINT COMMENT 'Optional pinned position for this item in its Collection. NULL means item is not pinned.',
    "CACHE_TTL" INTEGER COMMENT 'Granular cache TTL for specific dashboard.',
    "ENTITY_ID" CHARACTER(21) COMMENT 'Random NanoID tag for unique identity.'
);
ALTER TABLE "PUBLIC"."REPORT_DASHBOARD" ADD CONSTRAINT "PUBLIC"."PK_REPORT_DASHBOARD" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.REPORT_DASHBOARD;
CREATE INDEX "PUBLIC"."IDX_DASHBOARD_CREATOR_ID" ON "PUBLIC"."REPORT_DASHBOARD"("CREATOR_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_REPORT_DASHBOARD_SHOW_IN_GETTING_STARTED" ON "PUBLIC"."REPORT_DASHBOARD"("SHOW_IN_GETTING_STARTED" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_DASHBOARD_PUBLIC_UUID" ON "PUBLIC"."REPORT_DASHBOARD"("PUBLIC_UUID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_DASHBOARD_COLLECTION_ID" ON "PUBLIC"."REPORT_DASHBOARD"("COLLECTION_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."PERMISSIONS"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "OBJECT" CHARACTER VARYING(254) NOT NULL,
    "GROUP_ID" INTEGER NOT NULL
);
ALTER TABLE "PUBLIC"."PERMISSIONS" ADD CONSTRAINT "PUBLIC"."PK_PERMISSIONS" PRIMARY KEY("ID");
-- 7 +/- SELECT COUNT(*) FROM PUBLIC.PERMISSIONS;
CREATE INDEX "PUBLIC"."IDX_PERMISSIONS_GROUP_ID" ON "PUBLIC"."PERMISSIONS"("GROUP_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_PERMISSIONS_OBJECT" ON "PUBLIC"."PERMISSIONS"("OBJECT" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_PERMISSIONS_GROUP_ID_OBJECT" ON "PUBLIC"."PERMISSIONS"("GROUP_ID" NULLS FIRST, "OBJECT" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."QRTZ_CRON_TRIGGERS" COMMENT 'Used for Quartz scheduler.'(
    "SCHED_NAME" CHARACTER VARYING(120) NOT NULL,
    "TRIGGER_NAME" CHARACTER VARYING(200) NOT NULL,
    "TRIGGER_GROUP" CHARACTER VARYING(200) NOT NULL,
    "CRON_EXPRESSION" CHARACTER VARYING(120) NOT NULL,
    "TIME_ZONE_ID" CHARACTER VARYING(80)
);
ALTER TABLE "PUBLIC"."QRTZ_CRON_TRIGGERS" ADD CONSTRAINT "PUBLIC"."PK_QRTZ_CRON_TRIGGERS" PRIMARY KEY("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP");
-- 9 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_CRON_TRIGGERS;
CREATE CACHED TABLE "PUBLIC"."QRTZ_SIMPROP_TRIGGERS" COMMENT 'Used for Quartz scheduler.'(
    "SCHED_NAME" CHARACTER VARYING(120) NOT NULL,
    "TRIGGER_NAME" CHARACTER VARYING(200) NOT NULL,
    "TRIGGER_GROUP" CHARACTER VARYING(200) NOT NULL,
    "STR_PROP_1" CHARACTER VARYING(512),
    "STR_PROP_2" CHARACTER VARYING(512),
    "STR_PROP_3" CHARACTER VARYING(512),
    "INT_PROP_1" INTEGER,
    "INT_PROP_2" INTEGER,
    "LONG_PROP_1" BIGINT,
    "LONG_PROP_2" BIGINT,
    "DEC_PROP_1" NUMERIC(13, 4),
    "DEC_PROP_2" NUMERIC(13, 4),
    "BOOL_PROP_1" BOOLEAN,
    "BOOL_PROP_2" BOOLEAN
);
ALTER TABLE "PUBLIC"."QRTZ_SIMPROP_TRIGGERS" ADD CONSTRAINT "PUBLIC"."PK_QRTZ_SIMPROP_TRIGGERS" PRIMARY KEY("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_SIMPROP_TRIGGERS;
CREATE CACHED TABLE "PUBLIC"."METABASE_TABLE"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "CREATED_AT" TIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP NOT NULL,
    "NAME" CHARACTER VARYING(254) NOT NULL,
    "DESCRIPTION" CHARACTER LARGE OBJECT,
    "ENTITY_TYPE" CHARACTER VARYING(254),
    "ACTIVE" BOOLEAN NOT NULL,
    "DB_ID" INTEGER NOT NULL,
    "DISPLAY_NAME" CHARACTER VARYING(254),
    "VISIBILITY_TYPE" CHARACTER VARYING(254),
    "SCHEMA" CHARACTER VARYING(254),
    "POINTS_OF_INTEREST" CHARACTER LARGE OBJECT,
    "CAVEATS" CHARACTER LARGE OBJECT,
    "SHOW_IN_GETTING_STARTED" BOOLEAN DEFAULT FALSE NOT NULL,
    "FIELD_ORDER" CHARACTER VARYING(254) DEFAULT 'database' NOT NULL,
    "INITIAL_SYNC_STATUS" CHARACTER VARYING(32) DEFAULT 'complete' COMMENT 'String indicating whether a table has completed its initial sync and is ready to use' NOT NULL
);
ALTER TABLE "PUBLIC"."METABASE_TABLE" ADD CONSTRAINT "PUBLIC"."PK_METABASE_TABLE" PRIMARY KEY("ID");
-- 8 +/- SELECT COUNT(*) FROM PUBLIC.METABASE_TABLE;
CREATE INDEX "PUBLIC"."IDX_TABLE_DB_ID" ON "PUBLIC"."METABASE_TABLE"("DB_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_METABASE_TABLE_SHOW_IN_GETTING_STARTED" ON "PUBLIC"."METABASE_TABLE"("SHOW_IN_GETTING_STARTED" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_METABASE_TABLE_DB_ID_SCHEMA" ON "PUBLIC"."METABASE_TABLE"("DB_ID" NULLS FIRST, "SCHEMA" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."QRTZ_BLOB_TRIGGERS" COMMENT 'Used for Quartz scheduler.'(
    "SCHED_NAME" CHARACTER VARYING(120) NOT NULL,
    "TRIGGER_NAME" CHARACTER VARYING(200) NOT NULL,
    "TRIGGER_GROUP" CHARACTER VARYING(200) NOT NULL,
    "BLOB_DATA" BINARY LARGE OBJECT
);
ALTER TABLE "PUBLIC"."QRTZ_BLOB_TRIGGERS" ADD CONSTRAINT "PUBLIC"."PK_QRTZ_BLOB_TRIGGERS" PRIMARY KEY("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_BLOB_TRIGGERS;
CREATE CACHED TABLE "PUBLIC"."QRTZ_CALENDARS" COMMENT 'Used for Quartz scheduler.'(
    "SCHED_NAME" CHARACTER VARYING(120) NOT NULL,
    "CALENDAR_NAME" CHARACTER VARYING(200) NOT NULL,
    "CALENDAR" BINARY LARGE OBJECT NOT NULL
);
ALTER TABLE "PUBLIC"."QRTZ_CALENDARS" ADD CONSTRAINT "PUBLIC"."PK_QRTZ_CALENDARS" PRIMARY KEY("SCHED_NAME", "CALENDAR_NAME");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_CALENDARS;
CREATE CACHED TABLE "PUBLIC"."QRTZ_PAUSED_TRIGGER_GRPS" COMMENT 'Used for Quartz scheduler.'(
    "SCHED_NAME" CHARACTER VARYING(120) NOT NULL,
    "TRIGGER_GROUP" CHARACTER VARYING(200) NOT NULL
);
ALTER TABLE "PUBLIC"."QRTZ_PAUSED_TRIGGER_GRPS" ADD CONSTRAINT "PUBLIC"."PK_SCHED_NAME" PRIMARY KEY("SCHED_NAME", "TRIGGER_GROUP");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_PAUSED_TRIGGER_GRPS;
CREATE CACHED TABLE "PUBLIC"."QRTZ_FIRED_TRIGGERS" COMMENT 'Used for Quartz scheduler.'(
    "SCHED_NAME" CHARACTER VARYING(120) NOT NULL,
    "ENTRY_ID" CHARACTER VARYING(95) NOT NULL,
    "TRIGGER_NAME" CHARACTER VARYING(200) NOT NULL,
    "TRIGGER_GROUP" CHARACTER VARYING(200) NOT NULL,
    "INSTANCE_NAME" CHARACTER VARYING(200) NOT NULL,
    "FIRED_TIME" BIGINT NOT NULL,
    "SCHED_TIME" BIGINT,
    "PRIORITY" INTEGER NOT NULL,
    "STATE" CHARACTER VARYING(16) NOT NULL,
    "JOB_NAME" CHARACTER VARYING(200),
    "JOB_GROUP" CHARACTER VARYING(200),
    "IS_NONCONCURRENT" BOOLEAN,
    "REQUESTS_RECOVERY" BOOLEAN
);
ALTER TABLE "PUBLIC"."QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "PUBLIC"."PK_QRTZ_FIRED_TRIGGERS" PRIMARY KEY("SCHED_NAME", "ENTRY_ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_FIRED_TRIGGERS;
CREATE INDEX "PUBLIC"."IDX_QRTZ_FT_TRIG_INST_NAME" ON "PUBLIC"."QRTZ_FIRED_TRIGGERS"("SCHED_NAME" NULLS FIRST, "INSTANCE_NAME" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_FT_INST_JOB_REQ_RCVRY" ON "PUBLIC"."QRTZ_FIRED_TRIGGERS"("SCHED_NAME" NULLS FIRST, "INSTANCE_NAME" NULLS FIRST, "REQUESTS_RECOVERY" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_FT_J_G" ON "PUBLIC"."QRTZ_FIRED_TRIGGERS"("SCHED_NAME" NULLS FIRST, "JOB_NAME" NULLS FIRST, "JOB_GROUP" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_FT_JG" ON "PUBLIC"."QRTZ_FIRED_TRIGGERS"("SCHED_NAME" NULLS FIRST, "JOB_GROUP" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_FT_T_G" ON "PUBLIC"."QRTZ_FIRED_TRIGGERS"("SCHED_NAME" NULLS FIRST, "TRIGGER_NAME" NULLS FIRST, "TRIGGER_GROUP" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_QRTZ_FT_TG" ON "PUBLIC"."QRTZ_FIRED_TRIGGERS"("SCHED_NAME" NULLS FIRST, "TRIGGER_GROUP" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."QRTZ_SCHEDULER_STATE" COMMENT 'Used for Quartz scheduler.'(
    "SCHED_NAME" CHARACTER VARYING(120) NOT NULL,
    "INSTANCE_NAME" CHARACTER VARYING(200) NOT NULL,
    "LAST_CHECKIN_TIME" BIGINT NOT NULL,
    "CHECKIN_INTERVAL" BIGINT NOT NULL
);
ALTER TABLE "PUBLIC"."QRTZ_SCHEDULER_STATE" ADD CONSTRAINT "PUBLIC"."PK_QRTZ_SCHEDULER_STATE" PRIMARY KEY("SCHED_NAME", "INSTANCE_NAME");
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_SCHEDULER_STATE;
CREATE CACHED TABLE "PUBLIC"."QRTZ_LOCKS" COMMENT 'Used for Quartz scheduler.'(
    "SCHED_NAME" CHARACTER VARYING(120) NOT NULL,
    "LOCK_NAME" CHARACTER VARYING(40) NOT NULL
);
ALTER TABLE "PUBLIC"."QRTZ_LOCKS" ADD CONSTRAINT "PUBLIC"."PK_QRTZ_LOCKS" PRIMARY KEY("SCHED_NAME", "LOCK_NAME");
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_LOCKS;
CREATE CACHED TABLE "PUBLIC"."TIMELINE_EVENT" COMMENT 'Events table'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "TIMELINE_ID" INTEGER COMMENT 'ID of the timeline containing the event' NOT NULL,
    "NAME" CHARACTER VARYING(255) COMMENT 'Name of the event' NOT NULL,
    "DESCRIPTION" CHARACTER VARYING(255) COMMENT 'Optional markdown description of the event',
    "TIMESTAMP" TIMESTAMP WITH TIME ZONE COMMENT 'When the event happened' NOT NULL,
    "TIME_MATTERS" BOOLEAN COMMENT 'Indicate whether the time component matters or if the timestamp should just serve to indicate the day of the event without any time associated to it.' NOT NULL,
    "TIMEZONE" CHARACTER VARYING(255) COMMENT 'Timezone to display the underlying UTC timestamp in for the client' NOT NULL,
    "ICON" CHARACTER VARYING(128) COMMENT 'the icon to use when displaying the event' NOT NULL,
    "ARCHIVED" BOOLEAN DEFAULT FALSE COMMENT 'Whether or not the event has been archived' NOT NULL,
    "CREATOR_ID" INTEGER COMMENT 'ID of the user who created the event' NOT NULL,
    "CREATED_AT" TIMESTAMP WITH TIME ZONE DEFAULT LOCALTIMESTAMP COMMENT 'The timestamp of when the event was created' NOT NULL,
    "UPDATED_AT" TIMESTAMP WITH TIME ZONE DEFAULT LOCALTIMESTAMP COMMENT 'The timestamp of when the event was modified' NOT NULL
);
ALTER TABLE "PUBLIC"."TIMELINE_EVENT" ADD CONSTRAINT "PUBLIC"."PK_TIMELINE_EVENT" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.TIMELINE_EVENT;
CREATE INDEX "PUBLIC"."IDX_TIMELINE_EVENT_TIMELINE_ID" ON "PUBLIC"."TIMELINE_EVENT"("TIMELINE_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_TIMELINE_EVENT_TIMELINE_ID_TIMESTAMP" ON "PUBLIC"."TIMELINE_EVENT"("TIMELINE_ID" NULLS FIRST, "TIMESTAMP" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."COLLECTION_BOOKMARK" COMMENT 'Table holding bookmarks on collections'(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "USER_ID" INTEGER COMMENT 'ID of the User who bookmarked the Collection' NOT NULL,
    "COLLECTION_ID" INTEGER COMMENT 'ID of the Card bookmarked by the user' NOT NULL,
    "CREATED_AT" TIMESTAMP WITH TIME ZONE DEFAULT LOCALTIMESTAMP COMMENT 'The timestamp of when the bookmark was created' NOT NULL
);
ALTER TABLE "PUBLIC"."COLLECTION_BOOKMARK" ADD CONSTRAINT "PUBLIC"."PK_COLLECTION_BOOKMARK" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.COLLECTION_BOOKMARK;
CREATE INDEX "PUBLIC"."IDX_COLLECTION_BOOKMARK_USER_ID" ON "PUBLIC"."COLLECTION_BOOKMARK"("USER_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_COLLECTION_BOOKMARK_COLLECTION_ID" ON "PUBLIC"."COLLECTION_BOOKMARK"("COLLECTION_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."CORE_USER"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "EMAIL" VARCHAR_IGNORECASE(254) NOT NULL,
    "FIRST_NAME" CHARACTER VARYING(254),
    "LAST_NAME" CHARACTER VARYING(254),
    "PASSWORD" CHARACTER VARYING(254),
    "PASSWORD_SALT" CHARACTER VARYING(254) DEFAULT 'default',
    "DATE_JOINED" TIMESTAMP NOT NULL,
    "LAST_LOGIN" TIMESTAMP,
    "IS_SUPERUSER" BOOLEAN DEFAULT FALSE NOT NULL,
    "IS_ACTIVE" BOOLEAN DEFAULT TRUE NOT NULL,
    "RESET_TOKEN" CHARACTER VARYING(254),
    "RESET_TRIGGERED" BIGINT,
    "IS_QBNEWB" BOOLEAN DEFAULT TRUE NOT NULL,
    "GOOGLE_AUTH" BOOLEAN DEFAULT FALSE NOT NULL,
    "LDAP_AUTH" BOOLEAN DEFAULT FALSE NOT NULL,
    "LOGIN_ATTRIBUTES" CHARACTER LARGE OBJECT COMMENT 'JSON serialized map with attributes used for row level permissions',
    "UPDATED_AT" TIMESTAMP COMMENT 'When was this User last updated?',
    "SSO_SOURCE" CHARACTER VARYING(254) COMMENT 'String to indicate the SSO backend the user is from',
    "LOCALE" CHARACTER VARYING(5) COMMENT 'Preferred ISO locale (language/country) code, e.g "en" or "en-US", for this User. Overrides site default.',
    "IS_DATASETNEWB" BOOLEAN DEFAULT TRUE COMMENT 'Boolean flag to indicate if the dataset info modal has been dismissed.' NOT NULL,
    "SETTINGS" CHARACTER LARGE OBJECT COMMENT 'Serialized JSON containing User-local Settings for this User'
);
ALTER TABLE "PUBLIC"."CORE_USER" ADD CONSTRAINT "PUBLIC"."PK_CORE_USER" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CORE_USER;
CREATE CACHED TABLE "PUBLIC"."REVISION"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "MODEL" CHARACTER VARYING(16) NOT NULL,
    "MODEL_ID" INTEGER NOT NULL,
    "USER_ID" INTEGER NOT NULL,
    "TIMESTAMP" TIMESTAMP WITH TIME ZONE NOT NULL,
    "OBJECT" CHARACTER LARGE OBJECT NOT NULL,
    "IS_REVERSION" BOOLEAN DEFAULT FALSE NOT NULL,
    "IS_CREATION" BOOLEAN DEFAULT FALSE NOT NULL,
    "MESSAGE" CHARACTER LARGE OBJECT
);
ALTER TABLE "PUBLIC"."REVISION" ADD CONSTRAINT "PUBLIC"."PK_REVISION" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.REVISION;
CREATE INDEX "PUBLIC"."IDX_REVISION_MODEL_MODEL_ID" ON "PUBLIC"."REVISION"("MODEL" NULLS FIRST, "MODEL_ID" NULLS FIRST);
CREATE CACHED TABLE "PUBLIC"."METRIC"(
    "ID" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
    "TABLE_ID" INTEGER NOT NULL,
    "CREATOR_ID" INTEGER NOT NULL,
    "NAME" CHARACTER VARYING(254) NOT NULL,
    "DESCRIPTION" CHARACTER LARGE OBJECT,
    "ARCHIVED" BOOLEAN DEFAULT FALSE NOT NULL,
    "DEFINITION" CHARACTER LARGE OBJECT NOT NULL,
    "CREATED_AT" TIMESTAMP NOT NULL,
    "UPDATED_AT" TIMESTAMP NOT NULL,
    "POINTS_OF_INTEREST" CHARACTER LARGE OBJECT,
    "CAVEATS" CHARACTER LARGE OBJECT,
    "HOW_IS_THIS_CALCULATED" CHARACTER LARGE OBJECT,
    "SHOW_IN_GETTING_STARTED" BOOLEAN DEFAULT FALSE NOT NULL,
    "ENTITY_ID" CHARACTER(21) COMMENT 'Random NanoID tag for unique identity.'
);
ALTER TABLE "PUBLIC"."METRIC" ADD CONSTRAINT "PUBLIC"."PK_METRIC" PRIMARY KEY("ID");
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.METRIC;
CREATE INDEX "PUBLIC"."IDX_METRIC_CREATOR_ID" ON "PUBLIC"."METRIC"("CREATOR_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_METRIC_TABLE_ID" ON "PUBLIC"."METRIC"("TABLE_ID" NULLS FIRST);
CREATE INDEX "PUBLIC"."IDX_METRIC_SHOW_IN_GETTING_STARTED" ON "PUBLIC"."METRIC"("SHOW_IN_GETTING_STARTED" NULLS FIRST);
ALTER TABLE "PUBLIC"."SEGMENT" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_A" UNIQUE("ENTITY_ID");
ALTER TABLE "PUBLIC"."DASHBOARD_BOOKMARK" ADD CONSTRAINT "PUBLIC"."UNIQUE_DASHBOARD_BOOKMARK_USER_ID_DASHBOARD_ID" UNIQUE("USER_ID", "DASHBOARD_ID");
ALTER TABLE "PUBLIC"."DIMENSION" ADD CONSTRAINT "PUBLIC"."UNIQUE_DIMENSION_FIELD_ID_NAME" UNIQUE("FIELD_ID", "NAME");
ALTER TABLE "PUBLIC"."PERSISTED_INFO" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_2" UNIQUE("CARD_ID");
ALTER TABLE "PUBLIC"."CORE_USER" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_4" UNIQUE("EMAIL");
ALTER TABLE "PUBLIC"."PULSE_CHANNEL" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_5" UNIQUE("ENTITY_ID");
ALTER TABLE "PUBLIC"."DIMENSION" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_6" UNIQUE("ENTITY_ID");
ALTER TABLE "PUBLIC"."GROUP_TABLE_ACCESS_POLICY" ADD CONSTRAINT "PUBLIC"."UNIQUE_GTAP_TABLE_ID_GROUP_ID" UNIQUE("TABLE_ID", "GROUP_ID");
ALTER TABLE "PUBLIC"."REPORT_CARD" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_7" UNIQUE("PUBLIC_UUID");
ALTER TABLE "PUBLIC"."METRIC" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_8" UNIQUE("ENTITY_ID");
ALTER TABLE "PUBLIC"."REPORT_DASHBOARD" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_9" UNIQUE("PUBLIC_UUID");
ALTER TABLE "PUBLIC"."METRIC_IMPORTANT_FIELD" ADD CONSTRAINT "PUBLIC"."UNIQUE_METRIC_IMPORTANT_FIELD_METRIC_ID_FIELD_ID" UNIQUE("METRIC_ID", "FIELD_ID");
ALTER TABLE "PUBLIC"."METABASE_FIELD" ADD CONSTRAINT "PUBLIC"."IDX_UNIQ_FIELD_TABLE_ID_PARENT_ID_NAME" UNIQUE("TABLE_ID", "PARENT_ID", "NAME");
ALTER TABLE "PUBLIC"."REPORT_DASHBOARDCARD" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_1" UNIQUE("ENTITY_ID");
ALTER TABLE "PUBLIC"."PULSE_CARD" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_A4" UNIQUE("ENTITY_ID");
ALTER TABLE "PUBLIC"."COLLECTION" ADD CONSTRAINT "PUBLIC"."UNIQUE_COLLECTION_PERSONAL_OWNER_ID" UNIQUE("PERSONAL_OWNER_ID");
ALTER TABLE "PUBLIC"."BOOKMARK_ORDERING" ADD CONSTRAINT "PUBLIC"."UNIQUE_BOOKMARK_USER_ID_ORDERING" UNIQUE("USER_ID", "ORDERING");
ALTER TABLE "PUBLIC"."BOOKMARK_ORDERING" ADD CONSTRAINT "PUBLIC"."UNIQUE_BOOKMARK_USER_ID_TYPE_ITEM_ID" UNIQUE("USER_ID", "TYPE", "ITEM_ID");
ALTER TABLE "PUBLIC"."REPORT_CARDFAVORITE" ADD CONSTRAINT "PUBLIC"."IDX_UNIQUE_CARDFAVORITE_CARD_ID_OWNER_ID" UNIQUE("CARD_ID", "OWNER_ID");
ALTER TABLE "PUBLIC"."COLLECTION" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_B" UNIQUE("ENTITY_ID");
ALTER TABLE "PUBLIC"."PERMISSIONS" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_C" UNIQUE("GROUP_ID", "OBJECT");
ALTER TABLE "PUBLIC"."METABASE_TABLE" ADD CONSTRAINT "PUBLIC"."IDX_UNIQ_TABLE_DB_ID_SCHEMA_NAME" UNIQUE("DB_ID", "SCHEMA", "NAME");
ALTER TABLE "PUBLIC"."REPORT_DASHBOARD" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_97" UNIQUE("ENTITY_ID");
ALTER TABLE "PUBLIC"."TIMELINE" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_B2" UNIQUE("ENTITY_ID");
ALTER TABLE "PUBLIC"."NATIVE_QUERY_SNIPPET" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_4B3" UNIQUE("ENTITY_ID");
ALTER TABLE "PUBLIC"."LABEL" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_44" UNIQUE("SLUG");
ALTER TABLE "PUBLIC"."PULSE" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_48" UNIQUE("ENTITY_ID");
ALTER TABLE "PUBLIC"."PERMISSIONS_GROUP_MEMBERSHIP" ADD CONSTRAINT "PUBLIC"."UNIQUE_PERMISSIONS_GROUP_MEMBERSHIP_USER_ID_GROUP_ID" UNIQUE("USER_ID", "GROUP_ID");
ALTER TABLE "PUBLIC"."NATIVE_QUERY_SNIPPET" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_4B" UNIQUE("NAME");
ALTER TABLE "PUBLIC"."CARD_BOOKMARK" ADD CONSTRAINT "PUBLIC"."UNIQUE_CARD_BOOKMARK_USER_ID_CARD_ID" UNIQUE("USER_ID", "CARD_ID");
ALTER TABLE "PUBLIC"."DASHBOARD_FAVORITE" ADD CONSTRAINT "PUBLIC"."UNIQUE_DASHBOARD_FAVORITE_USER_ID_DASHBOARD_ID" UNIQUE("USER_ID", "DASHBOARD_ID");
ALTER TABLE "PUBLIC"."PERMISSIONS_GROUP" ADD CONSTRAINT "PUBLIC"."UNIQUE_PERMISSIONS_GROUP_NAME" UNIQUE("NAME");
ALTER TABLE "PUBLIC"."REPORT_CARD" ADD CONSTRAINT "PUBLIC"."CONSTRAINT_73" UNIQUE("ENTITY_ID");
ALTER TABLE "PUBLIC"."COLLECTION_BOOKMARK" ADD CONSTRAINT "PUBLIC"."UNIQUE_COLLECTION_BOOKMARK_USER_ID_COLLECTION_ID" UNIQUE("USER_ID", "COLLECTION_ID");
ALTER TABLE "PUBLIC"."CARD_LABEL" ADD CONSTRAINT "PUBLIC"."UNIQUE_CARD_LABEL_CARD_ID_LABEL_ID" UNIQUE("CARD_ID", "LABEL_ID");
ALTER TABLE "PUBLIC"."TIMELINE" ADD CONSTRAINT "PUBLIC"."FK_TIMELINE_COLLECTION_ID" FOREIGN KEY("COLLECTION_ID") REFERENCES "PUBLIC"."COLLECTION"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."COMPUTATION_JOB_RESULT" ADD CONSTRAINT "PUBLIC"."FK_COMPUTATION_RESULT_REF_JOB_ID" FOREIGN KEY("JOB_ID") REFERENCES "PUBLIC"."COMPUTATION_JOB"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."COLLECTION_PERMISSION_GRAPH_REVISION" ADD CONSTRAINT "PUBLIC"."FK_COLLECTION_REVISION_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."METABASE_FIELD" ADD CONSTRAINT "PUBLIC"."FK_FIELD_PARENT_REF_FIELD_ID" FOREIGN KEY("PARENT_ID") REFERENCES "PUBLIC"."METABASE_FIELD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."PERSISTED_INFO" ADD CONSTRAINT "PUBLIC"."FK_PERSISTED_INFO_REF_CREATOR_ID" FOREIGN KEY("CREATOR_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") NOCHECK;
ALTER TABLE "PUBLIC"."CORE_SESSION" ADD CONSTRAINT "PUBLIC"."FK_SESSION_REF_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."REPORT_DASHBOARD" ADD CONSTRAINT "PUBLIC"."FK_DASHBOARD_MADE_PUBLIC_BY_ID" FOREIGN KEY("MADE_PUBLIC_BY_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."DASHBOARD_FAVORITE" ADD CONSTRAINT "PUBLIC"."FK_DASHBOARD_FAVORITE_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."QRTZ_CRON_TRIGGERS" ADD CONSTRAINT "PUBLIC"."FK_QRTZ_CRON_TRIGGERS_TRIGGERS" FOREIGN KEY("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") REFERENCES "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") NOCHECK;
ALTER TABLE "PUBLIC"."REPORT_CARD" ADD CONSTRAINT "PUBLIC"."FK_REPORT_CARD_REF_DATABASE_ID" FOREIGN KEY("DATABASE_ID") REFERENCES "PUBLIC"."METABASE_DATABASE"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."TIMELINE_EVENT" ADD CONSTRAINT "PUBLIC"."FK_EVENT_CREATOR_ID" FOREIGN KEY("CREATOR_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."REVISION" ADD CONSTRAINT "PUBLIC"."FK_REVISION_REF_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."SEGMENT" ADD CONSTRAINT "PUBLIC"."FK_SEGMENT_REF_TABLE_ID" FOREIGN KEY("TABLE_ID") REFERENCES "PUBLIC"."METABASE_TABLE"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."QRTZ_SIMPROP_TRIGGERS" ADD CONSTRAINT "PUBLIC"."FK_QRTZ_SIMPROP_TRIGGERS_TRIGGERS" FOREIGN KEY("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") REFERENCES "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") NOCHECK;
ALTER TABLE "PUBLIC"."METABASE_DATABASE" ADD CONSTRAINT "PUBLIC"."FK_DATABASE_CREATOR_ID" FOREIGN KEY("CREATOR_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE SET NULL NOCHECK;
ALTER TABLE "PUBLIC"."DASHBOARDCARD_SERIES" ADD CONSTRAINT "PUBLIC"."FK_DASHBOARDCARD_SERIES_REF_CARD_ID" FOREIGN KEY("CARD_ID") REFERENCES "PUBLIC"."REPORT_CARD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."METRIC" ADD CONSTRAINT "PUBLIC"."FK_METRIC_REF_CREATOR_ID" FOREIGN KEY("CREATOR_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."PULSE_CHANNEL" ADD CONSTRAINT "PUBLIC"."FK_PULSE_CHANNEL_REF_PULSE_ID" FOREIGN KEY("PULSE_ID") REFERENCES "PUBLIC"."PULSE"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."REPORT_CARD" ADD CONSTRAINT "PUBLIC"."FK_REPORT_CARD_REF_TABLE_ID" FOREIGN KEY("TABLE_ID") REFERENCES "PUBLIC"."METABASE_TABLE"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."COLLECTION_BOOKMARK" ADD CONSTRAINT "PUBLIC"."FK_COLLECTION_BOOKMARK_COLLECTION_ID" FOREIGN KEY("COLLECTION_ID") REFERENCES "PUBLIC"."COLLECTION"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."PERMISSIONS_GROUP_MEMBERSHIP" ADD CONSTRAINT "PUBLIC"."FK_PERMISSIONS_GROUP_MEMBERSHIP_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."GROUP_TABLE_ACCESS_POLICY" ADD CONSTRAINT "PUBLIC"."FK_GTAP_GROUP_ID" FOREIGN KEY("GROUP_ID") REFERENCES "PUBLIC"."PERMISSIONS_GROUP"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."QRTZ_BLOB_TRIGGERS" ADD CONSTRAINT "PUBLIC"."FK_QRTZ_BLOB_TRIGGERS_TRIGGERS" FOREIGN KEY("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") REFERENCES "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") NOCHECK;
ALTER TABLE "PUBLIC"."REPORT_DASHBOARDCARD" ADD CONSTRAINT "PUBLIC"."FK_DASHBOARDCARD_REF_CARD_ID" FOREIGN KEY("CARD_ID") REFERENCES "PUBLIC"."REPORT_CARD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."METRIC_IMPORTANT_FIELD" ADD CONSTRAINT "PUBLIC"."FK_METRIC_IMPORTANT_FIELD_METRIC_ID" FOREIGN KEY("METRIC_ID") REFERENCES "PUBLIC"."METRIC"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."DASHBOARD_BOOKMARK" ADD CONSTRAINT "PUBLIC"."FK_DASHBOARD_BOOKMARK_DASHBOARD_ID" FOREIGN KEY("DASHBOARD_ID") REFERENCES "PUBLIC"."REPORT_DASHBOARD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."PERSISTED_INFO" ADD CONSTRAINT "PUBLIC"."FK_PERSISTED_INFO_CARD_ID" FOREIGN KEY("CARD_ID") REFERENCES "PUBLIC"."REPORT_CARD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."PULSE_CARD" ADD CONSTRAINT "PUBLIC"."FK_PULSE_CARD_REF_PULSE_ID" FOREIGN KEY("PULSE_ID") REFERENCES "PUBLIC"."PULSE"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."DIMENSION" ADD CONSTRAINT "PUBLIC"."FK_DIMENSION_DISPLAYFK_REF_FIELD_ID" FOREIGN KEY("HUMAN_READABLE_FIELD_ID") REFERENCES "PUBLIC"."METABASE_FIELD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."DASHBOARDCARD_SERIES" ADD CONSTRAINT "PUBLIC"."FK_DASHBOARDCARD_SERIES_REF_DASHBOARDCARD_ID" FOREIGN KEY("DASHBOARDCARD_ID") REFERENCES "PUBLIC"."REPORT_DASHBOARDCARD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."METABASE_FIELD" ADD CONSTRAINT "PUBLIC"."FK_FIELD_REF_TABLE_ID" FOREIGN KEY("TABLE_ID") REFERENCES "PUBLIC"."METABASE_TABLE"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."CARD_LABEL" ADD CONSTRAINT "PUBLIC"."FK_CARD_LABEL_REF_LABEL_ID" FOREIGN KEY("LABEL_ID") REFERENCES "PUBLIC"."LABEL"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."NATIVE_QUERY_SNIPPET" ADD CONSTRAINT "PUBLIC"."FK_SNIPPET_COLLECTION_ID" FOREIGN KEY("COLLECTION_ID") REFERENCES "PUBLIC"."COLLECTION"("ID") ON DELETE SET NULL NOCHECK;
ALTER TABLE "PUBLIC"."PULSE" ADD CONSTRAINT "PUBLIC"."FK_PULSE_REF_CREATOR_ID" FOREIGN KEY("CREATOR_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "PUBLIC"."FK_QRTZ_SIMPLE_TRIGGERS_TRIGGERS" FOREIGN KEY("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") REFERENCES "PUBLIC"."QRTZ_TRIGGERS"("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") NOCHECK;
ALTER TABLE "PUBLIC"."PULSE" ADD CONSTRAINT "PUBLIC"."FK_PULSE_COLLECTION_ID" FOREIGN KEY("COLLECTION_ID") REFERENCES "PUBLIC"."COLLECTION"("ID") ON DELETE SET NULL NOCHECK;
ALTER TABLE "PUBLIC"."REPORT_CARD" ADD CONSTRAINT "PUBLIC"."FK_CARD_REF_USER_ID" FOREIGN KEY("CREATOR_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."BOOKMARK_ORDERING" ADD CONSTRAINT "PUBLIC"."FK_BOOKMARK_ORDERING_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."PULSE_CHANNEL_RECIPIENT" ADD CONSTRAINT "PUBLIC"."FK_PULSE_CHANNEL_RECIPIENT_REF_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."LOGIN_HISTORY" ADD CONSTRAINT "PUBLIC"."FK_LOGIN_HISTORY_SESSION_ID" FOREIGN KEY("SESSION_ID") REFERENCES "PUBLIC"."CORE_SESSION"("ID") ON DELETE SET NULL NOCHECK;
ALTER TABLE "PUBLIC"."VIEW_LOG" ADD CONSTRAINT "PUBLIC"."FK_VIEW_LOG_REF_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."GROUP_TABLE_ACCESS_POLICY" ADD CONSTRAINT "PUBLIC"."FK_GTAP_TABLE_ID" FOREIGN KEY("TABLE_ID") REFERENCES "PUBLIC"."METABASE_TABLE"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."REPORT_CARDFAVORITE" ADD CONSTRAINT "PUBLIC"."FK_CARDFAVORITE_REF_CARD_ID" FOREIGN KEY("CARD_ID") REFERENCES "PUBLIC"."REPORT_CARD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."COMPUTATION_JOB" ADD CONSTRAINT "PUBLIC"."FK_COMPUTATION_JOB_REF_USER_ID" FOREIGN KEY("CREATOR_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."TIMELINE_EVENT" ADD CONSTRAINT "PUBLIC"."FK_EVENTS_TIMELINE_ID" FOREIGN KEY("TIMELINE_ID") REFERENCES "PUBLIC"."TIMELINE"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."DASHBOARD_BOOKMARK" ADD CONSTRAINT "PUBLIC"."FK_DASHBOARD_BOOKMARK_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."REPORT_DASHBOARDCARD" ADD CONSTRAINT "PUBLIC"."FK_DASHBOARDCARD_REF_DASHBOARD_ID" FOREIGN KEY("DASHBOARD_ID") REFERENCES "PUBLIC"."REPORT_DASHBOARD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."METRIC" ADD CONSTRAINT "PUBLIC"."FK_METRIC_REF_TABLE_ID" FOREIGN KEY("TABLE_ID") REFERENCES "PUBLIC"."METABASE_TABLE"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."COLLECTION" ADD CONSTRAINT "PUBLIC"."FK_COLLECTION_PERSONAL_OWNER_ID" FOREIGN KEY("PERSONAL_OWNER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."CARD_BOOKMARK" ADD CONSTRAINT "PUBLIC"."FK_CARD_BOOKMARK_DASHBOARD_ID" FOREIGN KEY("CARD_ID") REFERENCES "PUBLIC"."REPORT_CARD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."QRTZ_TRIGGERS" ADD CONSTRAINT "PUBLIC"."FK_QRTZ_TRIGGERS_JOB_DETAILS" FOREIGN KEY("SCHED_NAME", "JOB_NAME", "JOB_GROUP") REFERENCES "PUBLIC"."QRTZ_JOB_DETAILS"("SCHED_NAME", "JOB_NAME", "JOB_GROUP") NOCHECK;
ALTER TABLE "PUBLIC"."LOGIN_HISTORY" ADD CONSTRAINT "PUBLIC"."FK_LOGIN_HISTORY_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."PULSE" ADD CONSTRAINT "PUBLIC"."FK_PULSE_REF_DASHBOARD_ID" FOREIGN KEY("DASHBOARD_ID") REFERENCES "PUBLIC"."REPORT_DASHBOARD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."DASHBOARD_FAVORITE" ADD CONSTRAINT "PUBLIC"."FK_DASHBOARD_FAVORITE_DASHBOARD_ID" FOREIGN KEY("DASHBOARD_ID") REFERENCES "PUBLIC"."REPORT_DASHBOARD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."REPORT_CARDFAVORITE" ADD CONSTRAINT "PUBLIC"."FK_CARDFAVORITE_REF_USER_ID" FOREIGN KEY("OWNER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."CARD_BOOKMARK" ADD CONSTRAINT "PUBLIC"."FK_CARD_BOOKMARK_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."METRIC_IMPORTANT_FIELD" ADD CONSTRAINT "PUBLIC"."FK_METRIC_IMPORTANT_FIELD_METABASE_FIELD_ID" FOREIGN KEY("FIELD_ID") REFERENCES "PUBLIC"."METABASE_FIELD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."PULSE_CARD" ADD CONSTRAINT "PUBLIC"."FK_PULSE_CARD_REF_PULSE_CARD_ID" FOREIGN KEY("DASHBOARD_CARD_ID") REFERENCES "PUBLIC"."REPORT_DASHBOARDCARD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."REPORT_DASHBOARD" ADD CONSTRAINT "PUBLIC"."FK_DASHBOARD_COLLECTION_ID" FOREIGN KEY("COLLECTION_ID") REFERENCES "PUBLIC"."COLLECTION"("ID") ON DELETE SET NULL NOCHECK;
ALTER TABLE "PUBLIC"."REPORT_CARD" ADD CONSTRAINT "PUBLIC"."FK_CARD_COLLECTION_ID" FOREIGN KEY("COLLECTION_ID") REFERENCES "PUBLIC"."COLLECTION"("ID") ON DELETE SET NULL NOCHECK;
ALTER TABLE "PUBLIC"."REPORT_DASHBOARD" ADD CONSTRAINT "PUBLIC"."FK_DASHBOARD_REF_USER_ID" FOREIGN KEY("CREATOR_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."GROUP_TABLE_ACCESS_POLICY" ADD CONSTRAINT "PUBLIC"."FK_GTAP_CARD_ID" FOREIGN KEY("CARD_ID") REFERENCES "PUBLIC"."REPORT_CARD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."APPLICATION_PERMISSIONS_REVISION" ADD CONSTRAINT "PUBLIC"."FK_GENERAL_PERMISSIONS_REVISION_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") NOCHECK;
ALTER TABLE "PUBLIC"."COLLECTION_BOOKMARK" ADD CONSTRAINT "PUBLIC"."FK_COLLECTION_BOOKMARK_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."CARD_LABEL" ADD CONSTRAINT "PUBLIC"."FK_CARD_LABEL_REF_CARD_ID" FOREIGN KEY("CARD_ID") REFERENCES "PUBLIC"."REPORT_CARD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."METABASE_TABLE" ADD CONSTRAINT "PUBLIC"."FK_TABLE_REF_DATABASE_ID" FOREIGN KEY("DB_ID") REFERENCES "PUBLIC"."METABASE_DATABASE"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."PERSISTED_INFO" ADD CONSTRAINT "PUBLIC"."FK_PERSISTED_INFO_DATABASE_ID" FOREIGN KEY("DATABASE_ID") REFERENCES "PUBLIC"."METABASE_DATABASE"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."DIMENSION" ADD CONSTRAINT "PUBLIC"."FK_DIMENSION_REF_FIELD_ID" FOREIGN KEY("FIELD_ID") REFERENCES "PUBLIC"."METABASE_FIELD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."SECRET" ADD CONSTRAINT "PUBLIC"."FK_SECRET_REF_USER_ID" FOREIGN KEY("CREATOR_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") NOCHECK;
ALTER TABLE "PUBLIC"."ACTIVITY" ADD CONSTRAINT "PUBLIC"."FK_ACTIVITY_REF_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."PERMISSIONS_GROUP_MEMBERSHIP" ADD CONSTRAINT "PUBLIC"."FK_PERMISSIONS_GROUP_GROUP_ID" FOREIGN KEY("GROUP_ID") REFERENCES "PUBLIC"."PERMISSIONS_GROUP"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."REPORT_CARD" ADD CONSTRAINT "PUBLIC"."FK_CARD_MADE_PUBLIC_BY_ID" FOREIGN KEY("MADE_PUBLIC_BY_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."PERMISSIONS_REVISION" ADD CONSTRAINT "PUBLIC"."FK_PERMISSIONS_REVISION_USER_ID" FOREIGN KEY("USER_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."METABASE_FIELDVALUES" ADD CONSTRAINT "PUBLIC"."FK_FIELDVALUES_REF_FIELD_ID" FOREIGN KEY("FIELD_ID") REFERENCES "PUBLIC"."METABASE_FIELD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."PERMISSIONS" ADD CONSTRAINT "PUBLIC"."FK_PERMISSIONS_GROUP_ID" FOREIGN KEY("GROUP_ID") REFERENCES "PUBLIC"."PERMISSIONS_GROUP"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."NATIVE_QUERY_SNIPPET" ADD CONSTRAINT "PUBLIC"."FK_SNIPPET_CREATOR_ID" FOREIGN KEY("CREATOR_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."PULSE_CHANNEL_RECIPIENT" ADD CONSTRAINT "PUBLIC"."FK_PULSE_CHANNEL_RECIPIENT_REF_PULSE_CHANNEL_ID" FOREIGN KEY("PULSE_CHANNEL_ID") REFERENCES "PUBLIC"."PULSE_CHANNEL"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."SEGMENT" ADD CONSTRAINT "PUBLIC"."FK_SEGMENT_REF_CREATOR_ID" FOREIGN KEY("CREATOR_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."PULSE_CARD" ADD CONSTRAINT "PUBLIC"."FK_PULSE_CARD_REF_CARD_ID" FOREIGN KEY("CARD_ID") REFERENCES "PUBLIC"."REPORT_CARD"("ID") ON DELETE CASCADE NOCHECK;
ALTER TABLE "PUBLIC"."TIMELINE" ADD CONSTRAINT "PUBLIC"."FK_TIMELINE_CREATOR_ID" FOREIGN KEY("CREATOR_ID") REFERENCES "PUBLIC"."CORE_USER"("ID") ON DELETE CASCADE NOCHECK;

--
-- Metabase initialization data
--

-- v43.00-002 and v43.00-003;
INSERT INTO permissions_group (name) VALUES ('All Users'), ('Administrators');

-- v43.00-006;
INSERT INTO permissions (group_id, object) SELECT
  admin_group.id AS group_id,
  '/' AS object
FROM (
  SELECT id
  FROM permissions_group
  WHERE name = 'Administrators'
) admin_group;

-- v43.00-020;
INSERT INTO permissions (group_id, object) SELECT
  all_users_group.id AS group_id,
  '/collection/root/' AS object
FROM (
  SELECT id
  FROM permissions_group
  WHERE name = 'All Users'
) all_users_group;

-- v43.00-047 but change general => application because we renamed in v43.00-058;
INSERT INTO permissions (group_id, object) SELECT
  all_users_group.id AS group_id,
  '/application/subscription/' AS object
FROM (
  SELECT id
  FROM permissions_group
  WHERE name = 'All Users'
) all_users_group;

-- v44.00-033;
INSERT INTO permissions (group_id, object) SELECT
  all_users_group.id AS group_id,
  '/collection/namespace/snippets/root/' AS object
FROM (
  SELECT id
  FROM permissions_group
  WHERE name = 'All Users'
) all_users_group;
