/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cli.profile.repository;

import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.util.XmlSlurper;
import io.micronaut.cli.MicronautCli;
import io.micronaut.cli.boot.DependencyVersions;
import io.micronaut.cli.console.logging.MicronautConsole;
import io.micronaut.cli.profile.Profile;
import io.micronaut.cli.profile.repository.AbstractJarProfileRepository;
import io.micronaut.cli.profile.repository.AetherGrapeEngineFactory;
import io.micronaut.cli.profile.repository.RepositoryConfiguration;
import io.micronaut.cli.util.VersionInfo;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.springframework.boot.cli.compiler.grape.AetherGrapeEngine;
import org.springframework.boot.cli.compiler.grape.DependencyResolutionContext;
import org.springframework.boot.cli.compiler.grape.DependencyResolutionFailedException;

public class MavenProfileRepository
extends AbstractJarProfileRepository {
    public static final RepositoryConfiguration DEFAULT_REPO;
    private List<RepositoryConfiguration> repositoryConfigurations;
    private AetherGrapeEngine grapeEngine;
    private GroovyClassLoader classLoader;
    private DependencyResolutionContext resolutionContext;
    private DependencyVersions profileDependencyVersions;
    private boolean resolved;
    private String mavenLocalLocation;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public MavenProfileRepository(List<RepositoryConfiguration> repositoryConfigurations) {
        DependencyVersions dependencyVersions;
        AetherGrapeEngine aetherGrapeEngine;
        DependencyResolutionContext dependencyResolutionContext;
        GroovyClassLoader groovyClassLoader;
        MetaClass metaClass;
        boolean bl;
        this.resolved = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        List<RepositoryConfiguration> list = repositoryConfigurations;
        this.repositoryConfigurations = list;
        this.classLoader = groovyClassLoader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader());
        this.resolutionContext = dependencyResolutionContext = new DependencyResolutionContext();
        this.grapeEngine = aetherGrapeEngine = AetherGrapeEngineFactory.create(this.classLoader, repositoryConfigurations, this.resolutionContext);
        this.profileDependencyVersions = dependencyVersions = new DependencyVersions(this.grapeEngine);
        this.resolutionContext.addDependencyManagement(this.profileDependencyVersions);
    }

    public MavenProfileRepository() {
        this(ScriptBytecodeAdapter.createList(new Object[]{DEFAULT_REPO}));
    }

    static {
        RepositoryConfiguration repositoryConfiguration;
        RepositoryConfiguration repositoryConfiguration2;
        String version = VersionInfo.getVersion(MicronautCli.class);
        DEFAULT_REPO = version == null || version.endsWith("-SNAPSHOT") ? (repositoryConfiguration2 = new RepositoryConfiguration("micronautSnapshots", new URI("https://oss.sonatype.org/content/repositories/snapshots"), true)) : (repositoryConfiguration = new RepositoryConfiguration("jcenter", new URI("https://jcenter.bintray.com"), true));
    }

    @Override
    public Profile getProfile(String profileName, Boolean parentProfile) {
        String profileShortName = profileName;
        if (profileName.contains(":")) {
            String string;
            DefaultArtifact art = new DefaultArtifact(profileName);
            profileShortName = string = art.getArtifactId();
        }
        if (!this.profilesByName.containsKey(profileShortName)) {
            if (DefaultTypeTransformation.booleanUnbox(parentProfile) && DefaultTypeTransformation.booleanUnbox(this.profileDependencyVersions.find(AbstractJarProfileRepository.DEFAULT_PROFILE_GROUPID, profileShortName))) {
                return this.resolveProfile(profileShortName);
            }
            return this.resolveProfile(profileName);
        }
        return super.getProfile(profileShortName);
    }

    @Override
    public Profile getProfile(String profileName) {
        return this.getProfile(profileName, false);
    }

    protected Profile resolveProfile(String profileName) {
        Artifact art;
        block9: {
            art = this.getProfileArtifact(profileName);
            try {
                Object[] objectArray = new Object[6];
                objectArray[0] = "group";
                objectArray[1] = art.getGroupId();
                objectArray[2] = "module";
                objectArray[3] = art.getArtifactId();
                objectArray[4] = "version";
                String string = art.getVersion();
                objectArray[5] = DefaultTypeTransformation.booleanUnbox(string) ? string : null;
                this.grapeEngine.grab(ScriptBytecodeAdapter.createMap(objectArray));
            }
            catch (ArtifactNotFoundException e) {
                MicronautConsole.getInstance().addStatus(ShortTypeHandling.castToString(new GStringImpl(new Object[]{art}, new String[]{"Profile ", " could not be resolved remotely. Searching maven local..."})));
                File localData = new File(this.getMavenLocal(), ShortTypeHandling.castToString(new GStringImpl(new Object[]{art.getGroupId().replace(".", "/"), art.getArtifactId()}, new String[]{"/", "/", "/maven-metadata-local.xml"})));
                if (localData.exists()) {
                    String currentVersion = this.parseCurrentVersion(localData);
                    File profileFile = new File(localData.getParentFile(), ShortTypeHandling.castToString(new GStringImpl(new Object[]{currentVersion, art.getArtifactId(), currentVersion}, new String[]{"", "/", "-", ".jar"})));
                    if (profileFile.exists()) {
                        this.classLoader.addURL(profileFile.toURI().toURL());
                        break block9;
                    }
                    MicronautConsole.getInstance().error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{profileFile, localData}, new String[]{"", " not found in ", ""})));
                    throw (Throwable)e;
                }
                MicronautConsole.getInstance().error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{localData}, new String[]{"Also: ", " not found"})));
                throw (Throwable)e;
            }
            catch (DependencyResolutionFailedException e) {
                MicronautConsole.getInstance().addStatus(ShortTypeHandling.castToString(new GStringImpl(new Object[]{art}, new String[]{"Profile ", " could not be resolved remotely. Searching maven local..."})));
                File localData = new File(this.getMavenLocal(), ShortTypeHandling.castToString(new GStringImpl(new Object[]{art.getGroupId().replace(".", "/"), art.getArtifactId()}, new String[]{"/", "/", "/maven-metadata-local.xml"})));
                if (localData.exists()) {
                    String currentVersion = this.parseCurrentVersion(localData);
                    File profileFile = new File(localData.getParentFile(), ShortTypeHandling.castToString(new GStringImpl(new Object[]{currentVersion, art.getArtifactId(), currentVersion}, new String[]{"", "/", "-", ".jar"})));
                    if (profileFile.exists()) {
                        this.classLoader.addURL(profileFile.toURI().toURL());
                        break block9;
                    }
                    MicronautConsole.getInstance().error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{profileFile, localData}, new String[]{"", " not found in ", ""})));
                    throw (Throwable)e;
                }
                MicronautConsole.getInstance().error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{localData}, new String[]{"Also: ", " not found"})));
                throw (Throwable)e;
            }
        }
        this.processUrls();
        return super.getProfile(art.getArtifactId());
    }

    protected String parseCurrentVersion(File localData) {
        CallSite[] callSiteArray = MavenProfileRepository.$getCallSiteArray();
        return ShortTypeHandling.castToString(callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(callSiteArray[5].call(callSiteArray[6].callConstructor(XmlSlurper.class), localData)))), 0)));
    }

    protected void processUrls() {
        URL[] urls = this.classLoader.getURLs();
        URL url2 = null;
        URL[] uRLArray = urls;
        if (urls != null) {
            for (URL url2 : uRLArray) {
                this.registerProfile(url2, new URLClassLoader(new URL[]{url2}, Thread.currentThread().getContextClassLoader()));
            }
        }
    }

    protected String getMavenLocal() {
        CallSite[] callSiteArray = MavenProfileRepository.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox(this.mavenLocalLocation)) {
            File settingsXml = (File)ScriptBytecodeAdapter.castToType(callSiteArray[7].callConstructor(File.class, callSiteArray[8].call(System.class, "user.home"), "/.m2/settings.xml"), File.class);
            if (DefaultTypeTransformation.booleanUnbox(callSiteArray[9].call(settingsXml))) {
                String localRepo = ShortTypeHandling.castToString(callSiteArray[10].callGetPropertySafe(callSiteArray[11].call(callSiteArray[12].callConstructor(XmlSlurper.class), callSiteArray[13].callGetProperty(settingsXml))));
                if (DefaultTypeTransformation.booleanUnbox(localRepo)) {
                    GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[14].call(localRepo, "${user.home}", callSiteArray[15].call(System.class, "user.home"))}, new String[]{"", ""});
                    this.mavenLocalLocation = ShortTypeHandling.castToString(gStringImpl);
                }
            }
            if (!DefaultTypeTransformation.booleanUnbox(this.mavenLocalLocation)) {
                GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[16].call(System.class, "user.home")}, new String[]{"", "/.m2/repository/"});
                this.mavenLocalLocation = ShortTypeHandling.castToString(gStringImpl);
            }
        }
        return this.mavenLocalLocation;
    }

    @Override
    public List<Profile> getAllProfiles() {
        if (!this.resolved) {
            public final class _getAllProfiles_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAllProfiles_closure3(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(File dir) {
                    if (!dir.getName().startsWith(".")) {
                        File profileData = new File(dir, "/maven-metadata-local.xml");
                        if (profileData.exists()) {
                            String currentVersion = ShortTypeHandling.castToString(InvokerHelper.invokeMethodSafe((MavenProfileRepository)this.getThisObject(), "parseCurrentVersion", new Object[]{profileData}));
                            File profileFile = new File(dir, ShortTypeHandling.castToString(new GStringImpl(new Object[]{currentVersion, dir.getName(), currentVersion}, new String[]{"", "/", "-", ".jar"})));
                            if (profileFile.exists()) {
                                ((MavenProfileRepository)ScriptBytecodeAdapter.castToType(this.getThisObject(), MavenProfileRepository.class)).getClassLoader().addURL(profileFile.toURI().toURL());
                                return null;
                            }
                            return null;
                        }
                        return null;
                    }
                    return null;
                }

                public Object call(File dir) {
                    return this.doCall(dir);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _getAllProfiles_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            boolean bl;
            Reference<List> profiles = new Reference<List>(ScriptBytecodeAdapter.createList(new Object[0]));
            public final class _getAllProfiles_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference profiles;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAllProfiles_closure1(Object _outerInstance, Object _thisObject, Reference profiles) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.profiles = reference = profiles;
                }

                public Object doCall(Dependency dep) {
                    if (ScriptBytecodeAdapter.compareEqual(dep.getArtifact().getGroupId(), "io.micronaut.profiles")) {
                        return ((List)this.profiles.get()).add(ScriptBytecodeAdapter.createMap(new Object[]{"group", dep.getArtifact().getGroupId(), "module", dep.getArtifact().getArtifactId()}));
                    }
                    return null;
                }

                public Object call(Dependency dep) {
                    return this.doCall(dep);
                }

                public List getProfiles() {
                    return (List)ScriptBytecodeAdapter.castToType(this.profiles.get(), List.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _getAllProfiles_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(this.resolutionContext.getManagedDependencies(), (Closure)new _getAllProfiles_closure1(this, this, profiles));
            public final class _getAllProfiles_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAllProfiles_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it.get("module");
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Override
                public Object call() {
                    return this.doCall(null);
                }

                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _getAllProfiles_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.sort(profiles.get(), (Closure)new _getAllProfiles_closure2(this, this));
            try {
                Map profile = null;
                Iterator iterator = profiles.get().iterator();
                while (iterator.hasNext()) {
                    profile = (Map)ScriptBytecodeAdapter.castToType(iterator.next(), Map.class);
                    this.grapeEngine.grab(profile);
                }
            }
            catch (ArtifactNotFoundException e) {
                if (Boolean.getBoolean("micronaut.verbose")) {
                    MicronautConsole.getInstance().warn(StringGroovyMethods.plus((CharSequence)"Ignoring error: ", (Object)e));
                }
                MicronautConsole.getInstance().addStatus("No profiles could be resolved remotely. Searching Maven local...");
                File localData = new File(this.getMavenLocal(), "/io/micronaut/profiles");
                if (localData.exists()) {
                    ResourceGroovyMethods.eachDir(localData, new _getAllProfiles_closure3(this, this));
                }
            }
            catch (DependencyResolutionFailedException e) {
                if (Boolean.getBoolean("micronaut.verbose")) {
                    MicronautConsole.getInstance().warn(StringGroovyMethods.plus((CharSequence)"Ignoring error: ", (Object)e));
                }
                MicronautConsole.getInstance().addStatus("No profiles could be resolved remotely. Searching Maven local...");
                File localData = new File(this.getMavenLocal(), "/io/micronaut/profiles");
                if (localData.exists()) {
                    ResourceGroovyMethods.eachDir(localData, new _getAllProfiles_closure3(this, this));
                }
            }
            this.processUrls();
            this.resolved = bl = true;
        }
        return super.getAllProfiles();
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MavenProfileRepository.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ GroovyClassLoader pfaccess$0(MavenProfileRepository $that) {
        return $that.getClassLoader();
    }

    public List<RepositoryConfiguration> getRepositoryConfigurations() {
        return this.repositoryConfigurations;
    }

    public void setRepositoryConfigurations(List<RepositoryConfiguration> list) {
        this.repositoryConfigurations = list;
    }

    public AetherGrapeEngine getGrapeEngine() {
        return this.grapeEngine;
    }

    public void setGrapeEngine(AetherGrapeEngine aetherGrapeEngine) {
        this.grapeEngine = aetherGrapeEngine;
    }

    public GroovyClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(GroovyClassLoader groovyClassLoader) {
        this.classLoader = groovyClassLoader;
    }

    public DependencyResolutionContext getResolutionContext() {
        return this.resolutionContext;
    }

    public void setResolutionContext(DependencyResolutionContext dependencyResolutionContext) {
        this.resolutionContext = dependencyResolutionContext;
    }

    public DependencyVersions getProfileDependencyVersions() {
        return this.profileDependencyVersions;
    }

    public void setProfileDependencyVersions(DependencyVersions dependencyVersions) {
        this.profileDependencyVersions = dependencyVersions;
    }

    public /* synthetic */ List super$2$getAllProfiles() {
        return super.getAllProfiles();
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ Profile super$2$getProfile(String string, Boolean bl) {
        return super.getProfile(string, bl);
    }

    public /* synthetic */ Profile super$2$getProfile(String string) {
        return super.getProfile(string);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "text";
        stringArray[1] = "getAt";
        stringArray[2] = "version";
        stringArray[3] = "versions";
        stringArray[4] = "versioning";
        stringArray[5] = "parse";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "getProperty";
        stringArray[9] = "exists";
        stringArray[10] = "localRepository";
        stringArray[11] = "parseText";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "text";
        stringArray[14] = "replace";
        stringArray[15] = "getProperty";
        stringArray[16] = "getProperty";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[17];
        MavenProfileRepository.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(MavenProfileRepository.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = MavenProfileRepository.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

