/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collector;
import org.mvndaemon.mvnd.client.DaemonParameters;

public class DaemonDiagnostics {
    private static final int TAIL_SIZE = 200;
    private final String id;
    private final DaemonParameters parameters;

    public DaemonDiagnostics(String id, DaemonParameters parameters) {
        this.id = id;
        this.parameters = parameters;
    }

    public String toString() {
        return "{id=" + this.id + ", parameters=" + this.parameters + "}";
    }

    public String describe() {
        StringBuilder sb = new StringBuilder();
        sb.append("Daemon id: ").append(this.id).append("\n");
        DaemonDiagnostics.tail(sb, "log file", this.parameters.daemonLog(this.id));
        DaemonDiagnostics.tail(sb, "output", this.parameters.daemonOutLog(this.id));
        return sb.toString();
    }

    static void tail(StringBuilder sb, String name, Path log) {
        try {
            String tail = DaemonDiagnostics.tail(log);
            sb.append("  ").append(name).append(": ").append(log).append("\n");
            sb.append("----- Last  200 lines from daemon ").append(name).append(" - ").append(log).append(" -----\n");
            sb.append(tail);
            sb.append("----- End of the daemon ").append(name).append(" -----\n");
        }
        catch (NoSuchFileException e) {
            sb.append("  no ").append(name).append(" at: ").append(log).append("\n");
        }
        catch (IOException e) {
            sb.append("  unable to read from the daemon ").append(name).append(": ").append(log).append(", because of: ").append(e);
        }
    }

    static String tail(Path path) throws IOException {
        try (BufferedReader r = Files.newBufferedReader(path);){
            String string = String.join((CharSequence)"\n", r.lines().collect(DaemonDiagnostics.lastN(200))) + "\n";
            return string;
        }
    }

    static <T> Collector<T, ?, List<T>> lastN(int n) {
        return Collector.of(ArrayDeque::new, (acc, t) -> {
            if (acc.size() == n) {
                acc.pollFirst();
            }
            acc.add(t);
        }, (acc1, acc2) -> {
            while (acc2.size() < n && !acc1.isEmpty()) {
                acc2.addFirst(acc1.pollLast());
            }
            return acc2;
        }, ArrayList::new, new Collector.Characteristics[0]);
    }
}

