/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;

public class Label {
    Label next;
    int position = -1;
    int spring_position;
    int[] fixups;
    int[] wide_fixups;

    public final boolean defined() {
        return this.position >= 0;
    }

    public Label(Method method) {
        this(method.code);
    }

    public Label(CodeAttr code) {
        if (code.labels != null) {
            this.next = code.labels.next;
            code.labels.next = this;
        } else {
            code.labels = this;
        }
    }

    private final void relocate_fixups(CodeAttr code, int target) {
        if (this.fixups == null) {
            return;
        }
        int i = this.fixups.length;
        while (--i >= 0) {
            int pos = this.fixups[i];
            if (pos < 0) continue;
            byte[] insns = code.getCode();
            int code_val = insns[pos] << 8 | insns[pos + 1] & 0xFF;
            if ((code_val += target) < Short.MIN_VALUE || code_val >= 32768) {
                throw new Error("overflow in label fixup");
            }
            insns[pos] = (byte)(code_val >> 8);
            insns[pos + 1] = (byte)code_val;
        }
        if (this != code.labels) {
            code.reorder_fixups();
        }
        this.fixups = null;
    }

    static final void relocate_wide(CodeAttr code, int pos, int target) {
        if (pos >= 0) {
            byte[] insns = code.getCode();
            int code_val = (insns[pos] & 0xFF) << 24 | (insns[pos + 1] & 0xFF) << 16 | (insns[pos + 2] & 0xFF) << 8 | insns[pos + 3] & 0xFF;
            insns[pos] = (byte)((code_val += target) >> 24);
            insns[pos + 1] = (byte)(code_val >> 16);
            insns[pos + 2] = (byte)(code_val >> 8);
            insns[pos + 3] = (byte)code_val;
        }
    }

    public void define(CodeAttr code) {
        int i;
        code.unreachable_here = false;
        if (this.position >= 0) {
            throw new Error("label definition more than once");
        }
        this.position = code.PC;
        int goto_pos = this.position - 3;
        if (code.readPC <= goto_pos && this.fixups != null && this.wide_fixups == null && goto_pos > 0 && code.getCode()[goto_pos] == -89) {
            ++goto_pos;
            i = this.fixups.length;
            while (--i >= 0 && this.fixups[i] != goto_pos) {
            }
            if (i >= 0) {
                this.position -= 3;
                code.PC = this.position;
                this.fixups[i] = -1;
            }
        }
        code.readPC = this.position;
        this.relocate_fixups(code, this.position);
        if (this.wide_fixups != null) {
            i = this.wide_fixups.length;
            while (--i >= 0) {
                Label.relocate_wide(code, this.wide_fixups[i], this.position);
            }
            this.wide_fixups = null;
        }
    }

    void emit_spring(CodeAttr code) {
        code.reserve(8);
        if (!code.unreachable_here) {
            code.put1(167);
            code.put2(6);
        }
        this.spring_position = code.PC;
        this.relocate_fixups(code, this.spring_position);
        code.put1(200);
        this.emit_wide(code, this.spring_position);
        code.readPC = code.PC;
    }

    private void add_fixup(CodeAttr code) {
        int PC = code.PC;
        if (this.fixups == null) {
            this.fixups = new int[2];
            this.fixups[0] = PC;
            this.fixups[1] = -1;
        } else {
            int i;
            int fixups_length = this.fixups.length;
            for (i = 0; i < fixups_length && this.fixups[i] >= 0; ++i) {
            }
            if (i == fixups_length) {
                int[] new_fixups = new int[2 * this.fixups.length];
                System.arraycopy(this.fixups, 0, new_fixups, 0, this.fixups.length);
                i = new_fixups.length;
                do {
                    new_fixups[--i] = -1;
                } while (i > fixups_length);
                this.fixups = new_fixups;
            }
            if (PC < this.fixups[0]) {
                this.fixups[i] = this.fixups[0];
                this.fixups[0] = PC;
            } else {
                this.fixups[i] = PC;
            }
        }
        if (this != code.labels && (code.labels.fixups == null || PC < code.labels.fixups[0])) {
            code.reorder_fixups();
        }
    }

    private void add_wide_fixup(int PC) {
        int i;
        if (this.wide_fixups == null) {
            this.wide_fixups = new int[2];
            this.wide_fixups[0] = PC;
            this.wide_fixups[1] = -1;
            return;
        }
        for (i = 0; i < this.wide_fixups.length; ++i) {
            if (this.wide_fixups[i] >= 0) continue;
            this.wide_fixups[i] = PC;
            return;
        }
        int[] new_fixups = new int[2 * this.wide_fixups.length];
        System.arraycopy(this.wide_fixups, 0, new_fixups, 0, this.wide_fixups.length);
        new_fixups[this.wide_fixups.length] = PC;
        i = this.wide_fixups.length;
        while (++i < new_fixups.length) {
            new_fixups[i] = -1;
        }
        this.wide_fixups = new_fixups;
    }

    public boolean hasFixups() {
        return this.fixups != null || this.wide_fixups != null;
    }

    public void emit(CodeAttr code) {
        int PC_rel;
        int delta = PC_rel = 1 - code.PC;
        if (this.defined()) {
            if ((delta += this.position) < Short.MIN_VALUE) {
                if (this.spring_position >= 0 && this.spring_position + PC_rel >= Short.MIN_VALUE) {
                    delta = this.spring_position + PC_rel;
                } else {
                    this.add_fixup(code);
                    delta = PC_rel;
                }
            }
        } else {
            this.add_fixup(code);
        }
        code.put2(delta);
    }

    public void emit_wide(CodeAttr code, int start_pc) {
        int delta = -start_pc;
        if (this.defined()) {
            delta += this.position;
        } else {
            this.add_wide_fixup(code.PC);
        }
        code.put4(delta);
    }
}

