/************************************************************************
*																		*
* 			Pandora Products - Jim Schimpf Std Support Stuff			*
*					Copyright 1998 Jim Schimpf							*
*  																		*
*						MAC FILE TOKENIZER								*
*																		*
*		Module:CTokFile.h												*
*																		*
*	Version		Date	Person  	Description							*
*-----------------------------------------------------------------------*
*	0.1		 12-Feb-88	J.Schimpf	Initial Version						*
*	0.2		29-Jul-91	J.Schimpf	Add rewind function					*
*	0.3		 3-Aug-91	J.Schimpf	Add ftell,fseek & rewind			*
*	0.4		31-Dec-92	J.Schimpf	Convert for THINK C 5.0				*
*	0.5		 1-Jan-93	J.Schimpf	Don't return file name in input		*
*	0.6		16-Feb-93	J.Schimpf	Add fprintf							*
*	0.7		16-Feb-93	J.Schimpf	Put in correction for FTELL			*
*	0.8		12-Mar-93	J.Schimpf	Accept \n as line terminator in 	*
*									FGETS								*
*	0.9		 8-Aug-95	J.Schimpf	Convert to object					*
*	1.0		10-Aug-95	J.Schimpf	Allow user control of type,signature*
*									file type lists						*
*	1.1		22-Sep-95	J.Schimpf	Convert to file tokenizer			*
*	1.2		28-Dec-95	J.Schimpf	Add QUOTE mark for tokens			*
*	1.3		18-Aug-96	J.Schimpf	Remove inherited					*
*	1.4		22-Jan-97	J.Schimpf	Fix exit of " loop that would		*
*									leave an extra char in token		*
*	1.5		27-Sep-98	J.Schimpf	Remove COMMENT rtn and return EOL	*
*																		*
*	DESCRIPTION:													    *
*		Converts file to a stream of tokens								*
*		TOKEN := [<WS chars>]<Contigious characters = TOKEN>[<WS>]		*
*				or <QUOTE><charcters with embedded spaces><QUOTE>		*
*				 Maximum # characters in token in MAX_TOK				*
*		Characters in a line following <COMMENT_CHAR> are ignored to EOL*
*		NOTE: Files are treated as lines and TOKENS cannot be extend	*
*		over line breaks												*
*																		*
*	Methods:															*
*																		*
*	Name					Description 								*
*-----------------------------------------------------------------------*
*																		*
************************************************************************/

/******* INCLUDE FILES ******/

#include "CTokFile.h"
#include <ctype.h>

/***********************************************************************
*
*  CTokFile(void)	- Initializer for token run
*
*	INPUT:	NONE
*
*	OUTPUT:	NONE
*			Initialize all internal variables to default states
*
***********************************************************************/

CTokFile::CTokFile(void)
{
	this->init();
}

/***********************************************************************
*
*  init(void)	- Initializer for token run
*
*	INPUT:	NONE
*
*	OUTPUT:	NONE
*			Initialize all internal variables to default states
*
***********************************************************************/

void CTokFile::init(void)
{
	unget_flag = false;
	lines = 0;
	psn = TOK_BUF_MT;		// MT buffer
}
	

/***********************************************************************
*		TOKEN FILE I/O OPERATIONS
************************************************************************/
/***********************************************************************
*
* bool get_token( char *val )	- Get the next token from the
*												  file
*
*	INPUT:	val	- Returned token, NOTE: Must have TOK_MAX+1 spaces
*
*	OUTPUT:	true if token found, false if EOF or no token
*			NOTE: TOKEN returned in UC only
*
***********************************************************************/

int CTokFile::get_token( char *val )
{
	int i;
	bool quote,run;
	bool quoted = false;
	
	/* (0) If UNGET then just return with current token */
	
	if( unget_flag )
	{
		unget_flag = false;
		strcpy(val,token);
		
	// If token MT then return EOL
	
		if( token[0] == 0x00 )
			return( TOK_BUF_EOL );
		else
			return( TOK_BUF_TOK );
	}
	
	/* (1) Stay in this loop till token found and exit when found */
		
	while(true)
	{
		/*  (2) If Buffer MT then fill it */
		
		if( psn == TOK_BUF_MT )	// Fill buffer ?
		{
			if( CBufFile::fgets(buf,256) == NULL )		// Check for EOF
				return( TOK_BUF_EOF );
//printf("Buffer = %s\n",buf);	
			lines++;
				
			psn = 0;
		}
		
		/* (3) Skip to start of token in buffer or comment */
		
		for( ; isspace(buf[psn]); psn++ )
		{
			if( buf[psn] == '\0' )
			{
				psn = TOK_BUF_MT;
				break;
			}
		}
		if( psn == TOK_BUF_MT )
			continue;
			
		/*  (4) Now get the token */
		
		for( i=0,quote = false,run = true ; run && i<MAX_TOK; i++,psn++ )
		{
		
			// Handle case here where the buffer is MT, get the next chunk
			
			if( buf[psn] == 0x00 )
			{
				if( CBufFile::fgets(buf,256) == NULL )		// Check for EOF
					return( TOK_BUF_EOF );
				lines++;
				
				psn = 0;
			}
		
			if( !quote && isspace(buf[psn])	)	// If not in QUOTE break on space
				break;
				
			switch( buf[psn] ) {
			
			//case COMMENT_CHAR:
			case '\0':			psn = TOK_BUF_MT;
								return( TOK_BUF_EOL );
								break;
								
			default:			//token[i] = toupper(buf[psn]);	// No case change
								token[i] = buf[psn];
								break;
								
			case QUOTE_CHAR:	if( !quote )
								{
									quote = true;	// Mark start of quote
									i--;			// Backup over " char
									quoted = true;	// permanent mark
								}
								else
								{
									quote = false;	// End of quote & quit
									run = false;
									i--;			// Backup over " char
								}
			}
			
			if( psn == TOK_BUF_MT )
				break;
		}
		
		/*  (5) If i != 0 then return the token to the user */
		
		if( i!=0 || quoted )
		{
			token[i] = '\0';
			strcpy(val,token);
			if( quoted )
				return( TOK_QUOTE_TOK );
			else
				return( TOK_BUF_TOK );
		}
	}
}

/*****************************************************************************
*
* void unget_token(void)	- Allow reuse of current token
*
*	INPUT:	NONE
*
*	OUTPUT:	NONE
*
******************************************************************************/

void CTokFile::unget_token( void )
{
	unget_flag = true;
	
	// If buffer was just MT return CR as token
	
	if( psn == TOK_BUF_MT )
	{
		token[0] = '\0';
	}
	
}

/*****************************************************************************
*
* int line_count(void)	- # Lines seen in file
*
*	INPUT:	NONE
*
*	OUTPUT:	current line count
*
******************************************************************************/

int CTokFile::line_count( void )
{
	return( lines );
}

/****************** INTERNAL PRIVATE OPERATIONS ************************/
