/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class NoWhitespaceAfterCheck
extends Check {
    private boolean mAllowLineBreaks = true;

    public int[] getDefaultTokens() {
        return new int[]{29, 129, 130, 31, 32, 131, 132, 59};
    }

    public void visitToken(DetailAST aAST) {
        String[] lines = this.getLines();
        String line = lines[aAST.getLineNo() - 1];
        int after = aAST.getColumnNo() + aAST.getText().length();
        if (after >= line.length() || Character.isWhitespace(line.charAt(after))) {
            boolean flag = !this.mAllowLineBreaks;
            for (int i = after + 1; !flag && i < line.length(); ++i) {
                if (Character.isWhitespace(line.charAt(i))) continue;
                flag = true;
            }
            if (flag) {
                this.log(aAST.getLineNo(), after, "ws.followed", (Object)aAST.getText());
            }
        }
    }

    public void setAllowLineBreaks(boolean aAllowLineBreaks) {
        this.mAllowLineBreaks = aAllowLineBreaks;
    }
}

