/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineSet;

public class MethodCallHandler
extends ExpressionHandler {
    public MethodCallHandler(IndentationCheck aIndentCheck, DetailAST aAST, ExpressionHandler aParent) {
        super(aIndentCheck, aAST.getType() == 27 ? "method call" : "ctor call", aAST, aParent);
    }

    protected IndentLevel getLevelImpl() {
        if (this.getParent() instanceof MethodCallHandler) {
            MethodCallHandler container = (MethodCallHandler)this.getParent();
            if (container != null) {
                if (MethodCallHandler.areOnSameLine(container.getMainAst(), this.getMainAst())) {
                    return container.getLevel();
                }
                DetailAST main = this.getMainAst();
                DetailAST dot = (DetailAST)main.getFirstChild();
                DetailAST target = (DetailAST)dot.getFirstChild();
                if (dot.getType() == 59 && target.getType() == 27) {
                    DetailAST dot1 = (DetailAST)target.getFirstChild();
                    DetailAST target1 = (DetailAST)dot1.getFirstChild();
                    if (dot1.getType() == 59 && target1.getType() == 27) {
                        return container.getLevel();
                    }
                }
                return new IndentLevel(container.getLevel(), this.getBasicOffset());
            }
            ExpressionHandler p = this.getParent();
            while (p instanceof MethodCallHandler) {
                p = p.getParent();
            }
            return p.suggestedChildLevel(this);
        }
        LineSet lines = new LineSet();
        this.findSubtreeLines(lines, (DetailAST)this.getMainAst().getFirstChild(), true);
        int firstCol = lines.firstLineCol();
        int lineStart = this.getLineStart(this.getFirstAst(this.getMainAst()));
        if (lineStart != firstCol) {
            return new IndentLevel(lineStart);
        }
        return super.getLevelImpl();
    }

    private DetailAST getFirstAst(DetailAST aAst) {
        DetailAST ast;
        for (ast = (DetailAST)aAst.getFirstChild(); ast != null && ast.getType() == 59; ast = (DetailAST)ast.getFirstChild()) {
        }
        if (ast == null) {
            ast = aAst;
        }
        return ast;
    }

    public IndentLevel suggestedChildLevel(ExpressionHandler aChild) {
        DetailAST first = (DetailAST)this.getMainAst().getFirstChild();
        int indentLevel = this.getLineStart(first);
        if (!MethodCallHandler.areOnSameLine((DetailAST)aChild.getMainAst().getFirstChild(), (DetailAST)this.getMainAst().getFirstChild())) {
            indentLevel += this.getBasicOffset();
        }
        return new IndentLevel(indentLevel);
    }

    public void checkIndentation() {
        DetailAST methodName = (DetailAST)this.getMainAst().getFirstChild();
        this.checkExpressionSubtree(methodName, this.getLevel(), false, false);
        DetailAST lparen = this.getMainAst();
        DetailAST rparen = this.getMainAst().findFirstToken(77);
        this.checkLParen(lparen);
        if (rparen.getLineNo() == lparen.getLineNo()) {
            return;
        }
        this.checkExpressionSubtree(this.getMainAst().findFirstToken(34), new IndentLevel(this.getLevel(), this.getBasicOffset()), false, true);
        this.checkRParen(lparen, rparen);
    }

    protected boolean shouldIncreaseIndent() {
        return false;
    }
}

