/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitCSSMatrix.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSWebKitCSSMatrix.h"
#include "KURL.h"
#include "WebKitCSSMatrix.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebKitCSSMatrix);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitCSSMatrixTableValues[24] =
{
    { "a", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixA), (intptr_t)setJSWebKitCSSMatrixA THUNK_GENERATOR(0) },
    { "b", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixB), (intptr_t)setJSWebKitCSSMatrixB THUNK_GENERATOR(0) },
    { "c", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixC), (intptr_t)setJSWebKitCSSMatrixC THUNK_GENERATOR(0) },
    { "d", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixD), (intptr_t)setJSWebKitCSSMatrixD THUNK_GENERATOR(0) },
    { "e", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixE), (intptr_t)setJSWebKitCSSMatrixE THUNK_GENERATOR(0) },
    { "f", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixF), (intptr_t)setJSWebKitCSSMatrixF THUNK_GENERATOR(0) },
    { "m11", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM11), (intptr_t)setJSWebKitCSSMatrixM11 THUNK_GENERATOR(0) },
    { "m12", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM12), (intptr_t)setJSWebKitCSSMatrixM12 THUNK_GENERATOR(0) },
    { "m13", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM13), (intptr_t)setJSWebKitCSSMatrixM13 THUNK_GENERATOR(0) },
    { "m14", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM14), (intptr_t)setJSWebKitCSSMatrixM14 THUNK_GENERATOR(0) },
    { "m21", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM21), (intptr_t)setJSWebKitCSSMatrixM21 THUNK_GENERATOR(0) },
    { "m22", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM22), (intptr_t)setJSWebKitCSSMatrixM22 THUNK_GENERATOR(0) },
    { "m23", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM23), (intptr_t)setJSWebKitCSSMatrixM23 THUNK_GENERATOR(0) },
    { "m24", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM24), (intptr_t)setJSWebKitCSSMatrixM24 THUNK_GENERATOR(0) },
    { "m31", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM31), (intptr_t)setJSWebKitCSSMatrixM31 THUNK_GENERATOR(0) },
    { "m32", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM32), (intptr_t)setJSWebKitCSSMatrixM32 THUNK_GENERATOR(0) },
    { "m33", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM33), (intptr_t)setJSWebKitCSSMatrixM33 THUNK_GENERATOR(0) },
    { "m34", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM34), (intptr_t)setJSWebKitCSSMatrixM34 THUNK_GENERATOR(0) },
    { "m41", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM41), (intptr_t)setJSWebKitCSSMatrixM41 THUNK_GENERATOR(0) },
    { "m42", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM42), (intptr_t)setJSWebKitCSSMatrixM42 THUNK_GENERATOR(0) },
    { "m43", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM43), (intptr_t)setJSWebKitCSSMatrixM43 THUNK_GENERATOR(0) },
    { "m44", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM44), (intptr_t)setJSWebKitCSSMatrixM44 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitCSSMatrixTable = { 66, 63, JSWebKitCSSMatrixTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitCSSMatrixConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitCSSMatrixConstructorTable = { 1, 0, JSWebKitCSSMatrixConstructorTableValues, 0 };
const ClassInfo JSWebKitCSSMatrixConstructor::s_info = { "WebKitCSSMatrixConstructor", &DOMConstructorObject::s_info, &JSWebKitCSSMatrixConstructorTable, 0 };

JSWebKitCSSMatrixConstructor::JSWebKitCSSMatrixConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebKitCSSMatrixPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSWebKitCSSMatrixConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitCSSMatrixConstructor, JSDOMWrapper>(exec, &JSWebKitCSSMatrixConstructorTable, this, propertyName, slot);
}

bool JSWebKitCSSMatrixConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitCSSMatrixConstructor, JSDOMWrapper>(exec, &JSWebKitCSSMatrixConstructorTable, this, propertyName, descriptor);
}

ConstructType JSWebKitCSSMatrixConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSWebKitCSSMatrix;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitCSSMatrixPrototypeTableValues[11] =
{
    { "setMatrixValue", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionSetMatrixValue), (intptr_t)1 THUNK_GENERATOR(0) },
    { "multiply", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionMultiply), (intptr_t)1 THUNK_GENERATOR(0) },
    { "inverse", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionInverse), (intptr_t)0 THUNK_GENERATOR(0) },
    { "translate", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionTranslate), (intptr_t)3 THUNK_GENERATOR(0) },
    { "scale", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionScale), (intptr_t)3 THUNK_GENERATOR(0) },
    { "rotate", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionRotate), (intptr_t)3 THUNK_GENERATOR(0) },
    { "rotateAxisAngle", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionRotateAxisAngle), (intptr_t)4 THUNK_GENERATOR(0) },
    { "skewX", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionSkewX), (intptr_t)1 THUNK_GENERATOR(0) },
    { "skewY", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionSkewY), (intptr_t)1 THUNK_GENERATOR(0) },
    { "toString", DontDelete | DontEnum | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionToString), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitCSSMatrixPrototypeTable = { 33, 31, JSWebKitCSSMatrixPrototypeTableValues, 0 };
const ClassInfo JSWebKitCSSMatrixPrototype::s_info = { "WebKitCSSMatrixPrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSWebKitCSSMatrixPrototypeTable, 0 };

JSObject* JSWebKitCSSMatrixPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitCSSMatrix>(exec, globalObject);
}

bool JSWebKitCSSMatrixPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSWebKitCSSMatrixPrototypeTable, this, propertyName, slot);
}

bool JSWebKitCSSMatrixPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSWebKitCSSMatrixPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSWebKitCSSMatrix::s_info = { "WebKitCSSMatrix", &JSDOMWrapper::s_info, &JSWebKitCSSMatrixTable, 0 };

JSWebKitCSSMatrix::JSWebKitCSSMatrix(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitCSSMatrix> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitCSSMatrix::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSWebKitCSSMatrixPrototype(exec->globalData(), globalObject, JSWebKitCSSMatrixPrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSWebKitCSSMatrix::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitCSSMatrix, Base>(exec, &JSWebKitCSSMatrixTable, this, propertyName, slot);
}

bool JSWebKitCSSMatrix::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitCSSMatrix, Base>(exec, &JSWebKitCSSMatrixTable, this, propertyName, descriptor);
}

JSValue jsWebKitCSSMatrixA(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->a());
    return result;
}


JSValue jsWebKitCSSMatrixB(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->b());
    return result;
}


JSValue jsWebKitCSSMatrixC(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->c());
    return result;
}


JSValue jsWebKitCSSMatrixD(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->d());
    return result;
}


JSValue jsWebKitCSSMatrixE(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->e());
    return result;
}


JSValue jsWebKitCSSMatrixF(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->f());
    return result;
}


JSValue jsWebKitCSSMatrixM11(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m11());
    return result;
}


JSValue jsWebKitCSSMatrixM12(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m12());
    return result;
}


JSValue jsWebKitCSSMatrixM13(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m13());
    return result;
}


JSValue jsWebKitCSSMatrixM14(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m14());
    return result;
}


JSValue jsWebKitCSSMatrixM21(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m21());
    return result;
}


JSValue jsWebKitCSSMatrixM22(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m22());
    return result;
}


JSValue jsWebKitCSSMatrixM23(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m23());
    return result;
}


JSValue jsWebKitCSSMatrixM24(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m24());
    return result;
}


JSValue jsWebKitCSSMatrixM31(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m31());
    return result;
}


JSValue jsWebKitCSSMatrixM32(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m32());
    return result;
}


JSValue jsWebKitCSSMatrixM33(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m33());
    return result;
}


JSValue jsWebKitCSSMatrixM34(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m34());
    return result;
}


JSValue jsWebKitCSSMatrixM41(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m41());
    return result;
}


JSValue jsWebKitCSSMatrixM42(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m42());
    return result;
}


JSValue jsWebKitCSSMatrixM43(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m43());
    return result;
}


JSValue jsWebKitCSSMatrixM44(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    JSValue result = jsNumber(imp->m44());
    return result;
}


JSValue jsWebKitCSSMatrixConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitCSSMatrix* domObject = static_cast<JSWebKitCSSMatrix*>(asObject(slotBase));
    return JSWebKitCSSMatrix::getConstructor(exec, domObject->globalObject());
}

void JSWebKitCSSMatrix::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSWebKitCSSMatrix, Base>(exec, propertyName, value, &JSWebKitCSSMatrixTable, this, slot);
}

void setJSWebKitCSSMatrixA(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setA(value.toNumber(exec));
}


void setJSWebKitCSSMatrixB(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setB(value.toNumber(exec));
}


void setJSWebKitCSSMatrixC(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setC(value.toNumber(exec));
}


void setJSWebKitCSSMatrixD(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setD(value.toNumber(exec));
}


void setJSWebKitCSSMatrixE(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setE(value.toNumber(exec));
}


void setJSWebKitCSSMatrixF(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setF(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM11(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM11(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM12(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM12(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM13(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM13(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM14(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM14(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM21(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM21(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM22(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM22(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM23(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM23(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM24(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM24(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM31(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM31(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM32(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM32(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM33(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM33(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM34(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM34(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM41(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM41(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM42(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM42(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM43(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM43(value.toNumber(exec));
}


void setJSWebKitCSSMatrixM44(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(thisObject);
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    imp->setM44(value.toNumber(exec));
}


JSValue JSWebKitCSSMatrix::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitCSSMatrixConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSetMatrixValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitCSSMatrix::s_info))
        return throwVMTypeError(exec);
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(thisValue));
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& string(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setMatrixValue(string, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionMultiply(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitCSSMatrix::s_info))
        return throwVMTypeError(exec);
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(thisValue));
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    WebKitCSSMatrix* secondMatrix(toWebKitCSSMatrix(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->multiply(secondMatrix)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionInverse(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitCSSMatrix::s_info))
        return throwVMTypeError(exec);
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(thisValue));
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    ExceptionCode ec = 0;


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->inverse(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionTranslate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitCSSMatrix::s_info))
        return throwVMTypeError(exec);
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(thisValue));
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    double x(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double y(exec->argument(1).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double z(exec->argument(2).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->translate(x, y, z)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionScale(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitCSSMatrix::s_info))
        return throwVMTypeError(exec);
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(thisValue));
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    double scaleX(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double scaleY(exec->argument(1).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double scaleZ(exec->argument(2).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->scale(scaleX, scaleY, scaleZ)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionRotate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitCSSMatrix::s_info))
        return throwVMTypeError(exec);
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(thisValue));
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    double rotX(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double rotY(exec->argument(1).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double rotZ(exec->argument(2).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->rotate(rotX, rotY, rotZ)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionRotateAxisAngle(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitCSSMatrix::s_info))
        return throwVMTypeError(exec);
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(thisValue));
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    double x(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double y(exec->argument(1).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double z(exec->argument(2).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double angle(exec->argument(3).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->rotateAxisAngle(x, y, z, angle)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSkewX(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitCSSMatrix::s_info))
        return throwVMTypeError(exec);
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(thisValue));
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    double angle(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->skewX(angle)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSkewY(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitCSSMatrix::s_info))
        return throwVMTypeError(exec);
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(thisValue));
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());
    double angle(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->skewY(angle)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionToString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitCSSMatrix::s_info))
        return throwVMTypeError(exec);
    JSWebKitCSSMatrix* castedThis = static_cast<JSWebKitCSSMatrix*>(asObject(thisValue));
    WebKitCSSMatrix* imp = static_cast<WebKitCSSMatrix*>(castedThis->impl());


    JSC::JSValue result = jsString(exec, imp->toString());
    return JSValue::encode(result);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebKitCSSMatrix* impl)
{
    return wrap<JSWebKitCSSMatrix>(exec, globalObject, impl);
}

WebKitCSSMatrix* toWebKitCSSMatrix(JSC::JSValue value)
{
    return value.inherits(&JSWebKitCSSMatrix::s_info) ? static_cast<JSWebKitCSSMatrix*>(asObject(value))->impl() : 0;
}

}
