/****************************************************************************
**
** Copyright (C) 2012 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QLOCALE_DATA_P_H
#define QLOCALE_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of qapplication_*.cpp, qwidget*.cpp and qfiledialog.cpp.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

QT_BEGIN_NAMESPACE

/* This part of the file isn't generated, but written by hand since
 * Unicode CLDR doesn't contain measurement system information.
 */
struct CountryLanguage
{
    quint16 languageId;
    quint16 countryId;
};
static const CountryLanguage ImperialMeasurementSystems[] = {
    { 31, 225 },
    { 31, 226 },
    { 111, 225 },
    { 163, 225 }
};
static const int ImperialMeasurementSystemsCount =
    sizeof(ImperialMeasurementSystems)/sizeof(ImperialMeasurementSystems[0]);

// GENERATED PART STARTS HERE

/*
    This part of the file was generated on 2012-11-02 from the
    Common Locale Data Repository v2.0

    http://www.unicode.org/cldr/

    Do not change it, instead edit CLDR data and regenerate this file using
    cldr2qlocalexml.py and qlocalexml2cpp.py.
*/


static const quint16 locale_index[] = {
     0, // AnyLanguage
     0, // C
     0, // Abkhazian
     1, // Afan
     3, // Afar
     6, // Afrikaans
     8, // Albanian
     9, // Amharic
    10, // Arabic
    27, // Armenian
    28, // Assamese
     0, // Aymara
    29, // Azerbaijani
     0, // Bashkir
    32, // Basque
    33, // Bengali
    35, // Bhutani
     0, // Bihari
     0, // Bislama
    36, // Breton
    37, // Bulgarian
    38, // Burmese
    39, // Byelorussian
    40, // Cambodian
    41, // Catalan
    42, // Chinese
     0, // Corsican
    54, // Croatian
    55, // Czech
    56, // Danish
    57, // Dutch
    60, // English
     0, // Esperanto
    91, // Estonian
    92, // Faroese
     0, // Fiji
    93, // Finnish
    94, // French
     0, // Frisian
     0, // Gaelic
   127, // Galician
   128, // Georgian
   129, // German
   135, // Greek
   137, // Greenlandic
     0, // Guarani
   138, // Gujarati
   139, // Hausa
   145, // Hebrew
   146, // Hindi
   147, // Hungarian
   148, // Icelandic
   149, // Indonesian
     0, // Interlingua
     0, // Interlingue
     0, // Inuktitut
     0, // Inupiak
   150, // Irish
   151, // Italian
   153, // Japanese
     0, // Javanese
   154, // Kannada
     0, // Kashmiri
   155, // Kazakh
   157, // Kinyarwanda
   158, // Kirghiz
   159, // Korean
   160, // Kurdish
   168, // Rundi
   169, // Laothian
     0, // Latin
   170, // Latvian
   171, // Lingala
   173, // Lithuanian
   174, // Macedonian
   175, // Malagasy
   176, // Malay
   178, // Malayalam
   179, // Maltese
     0, // Maori
   180, // Marathi
     0, // Moldavian
   181, // Mongolian
     0, // Nauru
   185, // Nepali
   187, // Norwegian
   188, // Occitan
   189, // Oriya
   190, // Pashto
   191, // Persian
   193, // Polish
   194, // Portuguese
   200, // Punjabi
     0, // Quechua
   204, // RhaetoRomance
   205, // Romanian
   207, // Russian
     0, // Samoan
   210, // Sangho
     0, // Sanskrit
   211, // Serbian
   226, // SerboCroatian
   229, // Sesotho
   231, // Setswana
   232, // Shona
     0, // Sindhi
   233, // Singhalese
   234, // Siswati
   236, // Slovak
   237, // Slovenian
   238, // Somali
   242, // Spanish
     0, // Sundanese
   264, // Swahili
   266, // Swedish
   268, // Tagalog
   269, // Tajik
   271, // Tamil
     0, // Tatar
   273, // Telugu
   274, // Thai
   275, // Tibetan
   277, // Tigrinya
   279, // Tonga
   280, // Tsonga
   281, // Turkish
     0, // Turkmen
     0, // Twi
     0, // Uigur
   282, // Ukrainian
   283, // Urdu
   285, // Uzbek
   290, // Vietnamese
     0, // Volapuk
   291, // Welsh
     0, // Wolof
   292, // Xhosa
     0, // Yiddish
   293, // Yoruba
     0, // Zhuang
   294, // Zulu
   295, // Nynorsk
   296, // Bosnian
     0, // Divehi
   297, // Manx
   298, // Cornish
   299, // Akan
   300, // Konkani
   301, // Ga
   302, // Igbo
   303, // Kamba
     0, // Syriac
   304, // Blin
     0, // Geez
     0, // Koro
   305, // Sidamo
   306, // Atsam
   307, // Tigre
   308, // Jju
   309, // Friulian
   310, // Venda
   311, // Ewe
   313, // Walamo
   314, // Hawaiian
   315, // Tyap
     0, // Chewa
   316, // Filipino
   317, // Swiss German
   318, // Sichuan Yi
     0, // Kpelle
   319, // Low German
   320, // South Ndebele
   321, // Northern Sotho
   322, // Northern Sami
   324, // Taroko
   325, // Gusii
   326, // Taita
   327, // Fulah
   328, // Kikuyu
   329, // Samburu
   330, // Sena
   331, // North Ndebele
   332, // Rombo
   333, // Tachelhit
   336, // Kabyle
   337, // Nyankole
   338, // Bena
   339, // Vunjo
   340, // Bambara
   341, // Embu
   342, // Cherokee
   343, // Morisyen
   344, // Makonde
   345, // Langi
   346, // Ganda
   347, // Bemba
   348, // Kabuverdianu
   349, // Meru
   350, // Kalenjin
   351, // Nama
   352, // Machame
   353, // Colognian
   354, // Masai
   356, // Soga
   357, // Luyia
   358, // Asu
   359, // Teso
   361, // Saho
   362, // Koyra Chiini
   363, // Rwa
   364, // Luo
   365, // Chiga
   366, // Central Morocco Tamazight
   368, // Koyraboro Senni
   369, // Shambala
   370, // Bodo
   371, // Aghem
   372, // Basaa
   373, // Zarma
   374, // Duala
   375, // JolaFonyi
   376, // Ewondo
   377, // Bafia
   378, // LubaKatanga
   379, // MakhuwaMeetto
   380, // Mundang
   381, // Kwasio
   382, // Nuer
   383, // Sakha
   384, // Sangu
   385, // Congo Swahili
   386, // Tasawaq
   387, // Vai
   389, // Walser
   390, // Yangben
     0 // trailing 0
};

static const QLocalePrivate locale_data[] = {
//      lang   script terr    dec  group   list  prcnt   zero  minus  plus    exp quotStart quotEnd altQuotStart altQuotEnd lpStart lpMid lpEnd lpTwo sDtFmt lDtFmt sTmFmt lTmFmt ssMonth slMonth  sMonth lMonth  sDays  lDays  am,len      pm,len
    {      1,     0,     0,    46,    44,    59,    37,    48,    45,    43,   101,    34,    34,    39,    39, 0,6 , 0,6 , 0,6 , 0,6 , 0,10 , 10,17 , 0,8 , 8,10 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 134,27 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 99,14 , 0,2 , 0,2 , {0,0,0},  0,0 , 0,7 , 0,4 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // C/AnyScript/AnyCountry
    {      3,     0,    69,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 35,18 , 18,7 , 25,12 , 158,48 , 206,111 , 134,24 , 161,48 , 209,111 , 320,24 , 113,28 , 141,55 , 85,14 , 113,28 , 141,55 , 85,14 , 2,2 , 2,2 , {69,84,66},  0,2 , 7,24 , 4,4 , 4,0 , 0,6 , 6,10 ,     2,     1,     7,     6,     7 }, // Afan/AnyScript/Ethiopia
    {      3,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 35,18 , 18,7 , 25,12 , 158,48 , 206,111 , 134,24 , 161,48 , 209,111 , 320,24 , 113,28 , 141,55 , 85,14 , 113,28 , 141,55 , 85,14 , 2,2 , 2,2 , {75,69,83},  2,3 , 0,7 , 4,4 , 4,0 , 0,6 , 16,8 ,     2,     1,     7,     6,     7 }, // Afan/AnyScript/Kenya
    {      4,     0,    59,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 53,19 , 18,7 , 25,12 , 317,48 , 365,119 , 484,24 , 344,48 , 392,119 , 511,24 , 196,28 , 224,52 , 276,14 , 196,28 , 224,52 , 276,14 , 0,2 , 0,2 , {68,74,70},  5,3 , 0,7 , 4,4 , 4,0 , 24,5 , 29,7 ,     0,     0,     6,     6,     7 }, // Afar/AnyScript/Djibouti
    {      4,     0,    67,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 53,19 , 18,7 , 25,12 , 317,48 , 508,118 , 484,24 , 344,48 , 535,118 , 511,24 , 196,28 , 224,52 , 276,14 , 196,28 , 224,52 , 276,14 , 0,2 , 0,2 , {69,82,78},  8,3 , 0,7 , 4,4 , 4,0 , 24,5 , 36,7 ,     2,     1,     1,     6,     7 }, // Afar/AnyScript/Eritrea
    {      4,     0,    69,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 53,19 , 18,7 , 25,12 , 317,48 , 508,118 , 484,24 , 344,48 , 535,118 , 511,24 , 196,28 , 224,52 , 276,14 , 196,28 , 224,52 , 276,14 , 0,2 , 0,2 , {69,84,66},  0,2 , 0,7 , 4,4 , 4,0 , 24,5 , 43,7 ,     2,     1,     7,     6,     7 }, // Afar/AnyScript/Ethiopia
    {      5,     0,   195,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8221, 0,6 , 0,6 , 6,8 , 6,8 , 72,10 , 82,17 , 18,7 , 25,12 , 626,48 , 674,92 , 134,24 , 653,48 , 701,92 , 320,24 , 290,21 , 311,58 , 369,14 , 290,21 , 311,58 , 369,14 , 4,3 , 4,3 , {90,65,82},  11,1 , 31,27 , 4,4 , 4,0 , 50,9 , 59,11 ,     2,     1,     7,     6,     7 }, // Afrikaans/AnyScript/SouthAfrica
    {      5,     0,   148,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8221, 0,6 , 0,6 , 6,8 , 6,8 , 72,10 , 99,16 , 37,5 , 8,10 , 626,48 , 674,92 , 134,24 , 653,48 , 701,92 , 320,24 , 290,21 , 311,58 , 369,14 , 290,21 , 311,58 , 369,14 , 4,3 , 4,3 , {78,65,68},  12,1 , 58,23 , 8,5 , 4,0 , 50,9 , 70,7 ,     2,     1,     1,     6,     7 }, // Afrikaans/AnyScript/Namibia
    {      6,     0,     2,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 115,8 , 123,18 , 42,7 , 49,12 , 766,48 , 814,78 , 892,24 , 793,48 , 841,78 , 919,24 , 383,28 , 411,58 , 469,14 , 383,28 , 411,58 , 469,14 , 7,2 , 7,2 , {65,76,76},  13,3 , 0,7 , 4,4 , 4,0 , 77,6 , 83,9 ,     0,     0,     1,     6,     7 }, // Albanian/AnyScript/Albania
    {      7,     0,    69,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 14,9 , 23,8 , 141,10 , 10,17 , 18,7 , 25,12 , 916,46 , 962,62 , 1024,24 , 943,46 , 989,62 , 1051,24 , 483,27 , 510,28 , 538,14 , 483,27 , 510,28 , 538,14 , 9,3 , 9,4 , {69,84,66},  16,2 , 81,16 , 4,4 , 13,6 , 92,4 , 96,5 ,     2,     1,     7,     6,     7 }, // Amharic/AnyScript/Ethiopia
    {      8,     0,   186,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 151,10 , 161,18 , 18,7 , 61,12 , 1048,75 , 1048,75 , 1123,24 , 1075,75 , 1075,75 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {83,65,82},  18,5 , 97,77 , 4,4 , 4,0 , 101,7 , 108,24 ,     2,     1,     6,     4,     5 }, // Arabic/AnyScript/SaudiArabia
    {      8,     0,     3,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 179,8 , 161,18 , 18,7 , 61,12 , 1048,75 , 1048,75 , 1123,24 , 1075,75 , 1075,75 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {68,90,68},  23,5 , 174,91 , 8,5 , 19,6 , 101,7 , 132,7 ,     2,     1,     6,     4,     5 }, // Arabic/AnyScript/Algeria
    {      8,     0,    17,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 151,10 , 161,18 , 18,7 , 61,12 , 1048,75 , 1048,75 , 1123,24 , 1075,75 , 1075,75 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {66,72,68},  28,5 , 265,91 , 8,5 , 19,6 , 101,7 , 139,7 ,     3,     0,     6,     5,     6 }, // Arabic/AnyScript/Bahrain
    {      8,     0,    64,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 151,10 , 161,18 , 18,7 , 61,12 , 1048,75 , 1048,75 , 1123,24 , 1075,75 , 1075,75 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {69,71,80},  33,5 , 356,70 , 8,5 , 19,6 , 101,7 , 146,3 ,     2,     1,     6,     5,     6 }, // Arabic/AnyScript/Egypt
    {      8,     0,   103,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 151,10 , 161,18 , 18,7 , 61,12 , 1048,75 , 1048,75 , 1123,24 , 1075,75 , 1075,75 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {73,81,68},  38,5 , 426,84 , 8,5 , 19,6 , 101,7 , 149,6 ,     0,     0,     6,     5,     6 }, // Arabic/AnyScript/Iraq
    {      8,     0,   109,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 151,10 , 161,18 , 18,7 , 61,12 , 1147,92 , 1147,92 , 1123,24 , 1174,92 , 1174,92 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {74,79,68},  43,5 , 510,84 , 8,5 , 19,6 , 101,7 , 155,6 ,     3,     0,     6,     5,     6 }, // Arabic/AnyScript/Jordan
    {      8,     0,   115,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 151,10 , 161,18 , 18,7 , 61,12 , 1048,75 , 1048,75 , 1123,24 , 1075,75 , 1075,75 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {75,87,68},  48,5 , 594,84 , 8,5 , 19,6 , 101,7 , 161,6 ,     3,     0,     6,     5,     6 }, // Arabic/AnyScript/Kuwait
    {      8,     0,   119,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 151,10 , 161,18 , 18,7 , 61,12 , 1147,92 , 1147,92 , 1123,24 , 1174,92 , 1174,92 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {76,66,80},  53,5 , 678,84 , 8,5 , 19,6 , 101,7 , 167,5 ,     0,     0,     1,     6,     7 }, // Arabic/AnyScript/Lebanon
    {      8,     0,   122,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 151,10 , 161,18 , 18,7 , 61,12 , 1048,75 , 1048,75 , 1123,24 , 1075,75 , 1075,75 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {76,89,68},  58,5 , 762,77 , 8,5 , 19,6 , 101,7 , 172,5 ,     3,     0,     6,     5,     6 }, // Arabic/AnyScript/LibyanArabJamahiriya
    {      8,     0,   145,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 179,8 , 161,18 , 18,7 , 61,12 , 1048,75 , 1048,75 , 1123,24 , 1075,75 , 1075,75 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {77,65,68},  63,5 , 839,77 , 8,5 , 19,6 , 101,7 , 177,6 ,     2,     1,     6,     5,     6 }, // Arabic/AnyScript/Morocco
    {      8,     0,   162,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 151,10 , 161,18 , 18,7 , 61,12 , 1048,75 , 1048,75 , 1123,24 , 1075,75 , 1075,75 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {79,77,82},  68,5 , 916,77 , 8,5 , 19,6 , 101,7 , 183,5 ,     3,     0,     6,     4,     5 }, // Arabic/AnyScript/Oman
    {      8,     0,   175,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 151,10 , 161,18 , 18,7 , 61,12 , 1048,75 , 1048,75 , 1123,24 , 1075,75 , 1075,75 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {81,65,82},  73,5 , 993,70 , 4,4 , 4,0 , 101,7 , 188,3 ,     2,     1,     6,     5,     6 }, // Arabic/AnyScript/Qatar
    {      8,     0,   201,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 151,10 , 161,18 , 18,7 , 61,12 , 1048,75 , 1048,75 , 1123,24 , 1075,75 , 1075,75 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {83,68,71},  0,0 , 1063,18 , 8,5 , 19,6 , 101,7 , 191,7 ,     2,     1,     6,     5,     6 }, // Arabic/AnyScript/Sudan
    {      8,     0,   207,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 151,10 , 161,18 , 18,7 , 61,12 , 1147,92 , 1147,92 , 1123,24 , 1174,92 , 1174,92 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {83,89,80},  78,5 , 1081,70 , 4,4 , 4,0 , 101,7 , 198,5 ,     0,     0,     6,     5,     6 }, // Arabic/AnyScript/SyrianArabRepublic
    {      8,     0,   216,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 179,8 , 161,18 , 18,7 , 61,12 , 1048,75 , 1048,75 , 1123,24 , 1075,75 , 1075,75 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {84,78,68},  83,5 , 1151,77 , 4,4 , 4,0 , 101,7 , 203,4 ,     3,     0,     7,     5,     6 }, // Arabic/AnyScript/Tunisia
    {      8,     0,   223,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 151,10 , 161,18 , 18,7 , 61,12 , 1048,75 , 1048,75 , 1123,24 , 1075,75 , 1075,75 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {65,69,68},  88,5 , 1228,91 , 8,5 , 19,6 , 101,7 , 207,24 ,     2,     1,     6,     5,     6 }, // Arabic/AnyScript/UnitedArabEmirates
    {      8,     0,   237,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 31,6 , 31,6 , 37,8 , 45,7 , 151,10 , 161,18 , 18,7 , 61,12 , 1048,75 , 1048,75 , 1123,24 , 1075,75 , 1075,75 , 1150,24 , 552,52 , 552,52 , 604,14 , 552,52 , 552,52 , 604,14 , 12,1 , 13,1 , {89,69,82},  93,5 , 1319,70 , 4,4 , 4,0 , 101,7 , 231,5 ,     0,     0,     6,     4,     5 }, // Arabic/AnyScript/Yemen
    {      9,     0,    11,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 187,8 , 35,18 , 37,5 , 8,10 , 1239,48 , 1287,94 , 1381,27 , 1266,48 , 1314,94 , 134,27 , 618,28 , 646,62 , 708,14 , 618,28 , 646,62 , 708,14 , 13,3 , 14,3 , {65,77,68},  98,3 , 0,7 , 25,5 , 4,0 , 236,7 , 243,24 ,     0,     0,     1,     6,     7 }, // Armenian/AnyScript/Armenia
    {     10,     0,   100,  1643,  1644,  1563,  1642,  2534,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 195,8 , 203,18 , 73,8 , 81,12 , 1408,62 , 1470,88 , 1381,27 , 1408,62 , 1470,88 , 134,27 , 722,37 , 759,58 , 708,14 , 722,37 , 759,58 , 708,14 , 16,9 , 17,7 , {73,78,82},  101,3 , 0,7 , 8,5 , 4,0 , 267,7 , 274,4 ,     2,     1,     7,     7,     7 }, // Assamese/AnyScript/India
    {     12,     0,    15,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 229,19 , 37,5 , 8,10 , 1558,48 , 1606,77 , 1381,27 , 1558,48 , 1606,77 , 134,27 , 817,26 , 843,67 , 99,14 , 817,26 , 843,67 , 99,14 , 0,2 , 0,2 , {65,90,78},  104,4 , 1389,41 , 8,5 , 4,0 , 278,12 , 290,10 ,     2,     1,     1,     6,     7 }, // Azerbaijani/AnyScript/Azerbaijan
    {     12,     2,    15,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 229,19 , 37,5 , 8,10 , 1683,77 , 1683,77 , 1381,27 , 1683,77 , 1683,77 , 134,27 , 910,67 , 910,67 , 99,14 , 910,67 , 910,67 , 99,14 , 0,2 , 0,2 , {65,90,78},  108,4 , 1430,12 , 8,5 , 4,0 , 300,10 , 300,10 ,     2,     1,     1,     6,     7 }, // Azerbaijani/Cyrillic/Azerbaijan
    {     12,     7,    15,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 229,19 , 37,5 , 8,10 , 1558,48 , 1606,77 , 1381,27 , 1558,48 , 1606,77 , 134,27 , 817,26 , 843,67 , 99,14 , 817,26 , 843,67 , 99,14 , 0,2 , 0,2 , {65,90,78},  104,4 , 1389,41 , 8,5 , 4,0 , 278,12 , 290,10 ,     2,     1,     1,     6,     7 }, // Azerbaijani/Latin/Azerbaijan
    {     14,     0,   197,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 52,9 , 52,9 , 72,10 , 248,31 , 37,5 , 8,10 , 1760,48 , 1808,93 , 1901,24 , 1760,48 , 1808,93 , 1901,24 , 977,21 , 998,68 , 1066,14 , 977,21 , 998,68 , 1080,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1442,12 , 25,5 , 4,0 , 310,7 , 317,8 ,     2,     1,     1,     6,     7 }, // Basque/AnyScript/Spain
    {     15,     0,    18,  1643,  1644,  1563,  1642,  2534,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 61,10 , 71,9 , 279,6 , 203,18 , 18,7 , 25,12 , 1925,90 , 1925,90 , 2015,33 , 1925,90 , 1925,90 , 2015,33 , 1094,37 , 1131,58 , 1189,18 , 1094,37 , 1131,58 , 1189,18 , 25,9 , 24,7 , {66,68,84},  113,1 , 1454,21 , 0,4 , 30,6 , 325,5 , 330,8 ,     2,     1,     5,     6,     7 }, // Bengali/AnyScript/Bangladesh
    {     15,     0,   100,  1643,  1644,  1563,  1642,  2534,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 61,10 , 71,9 , 279,6 , 203,18 , 18,7 , 25,12 , 1925,90 , 1925,90 , 2015,33 , 1925,90 , 1925,90 , 2015,33 , 1094,37 , 1131,58 , 1189,18 , 1094,37 , 1131,58 , 1189,18 , 25,9 , 24,7 , {73,78,82},  114,1 , 1475,19 , 0,4 , 30,6 , 325,5 , 338,4 ,     2,     1,     7,     7,     7 }, // Bengali/AnyScript/India
    {     16,     0,    25,    46,    44,    59,    37,    48,    45,    43,   101,    34,    34,    39,    39, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 285,29 , 93,22 , 115,35 , 2048,75 , 2123,205 , 1381,27 , 2048,75 , 2123,205 , 134,27 , 1207,34 , 1241,79 , 708,14 , 1207,34 , 1241,79 , 708,14 , 0,2 , 0,2 , {66,84,78},  115,3 , 1494,16 , 4,4 , 4,0 , 342,6 , 348,5 ,     2,     1,     7,     6,     7 }, // Bhutani/AnyScript/Bhutan
    {     19,     0,    74,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 2328,55 , 2383,78 , 1381,27 , 2328,55 , 2383,78 , 134,27 , 1320,33 , 1353,43 , 1396,21 , 1320,33 , 1353,43 , 1396,21 , 0,2 , 0,2 , {69,85,82},  112,1 , 1510,11 , 8,5 , 4,0 , 353,9 , 362,5 ,     2,     1,     1,     6,     7 }, // Breton/AnyScript/France
    {     20,     0,    33,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8220,  8216,  8217, 0,6 , 0,6 , 80,7 , 80,7 , 332,8 , 340,18 , 37,5 , 8,10 , 2461,59 , 2520,82 , 2602,24 , 2461,59 , 2520,82 , 2602,24 , 1417,21 , 1438,55 , 1493,14 , 1417,21 , 1438,55 , 1493,14 , 34,7 , 31,7 , {66,71,78},  118,3 , 1521,47 , 25,5 , 4,0 , 367,9 , 376,8 ,     2,     1,     1,     6,     7 }, // Bulgarian/AnyScript/Bulgaria
    {     21,     0,   147,    46,    44,  4170,  1642,  4160,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 314,18 , 37,5 , 8,10 , 2626,43 , 2669,88 , 2757,24 , 2626,43 , 2669,88 , 2757,24 , 1507,25 , 1532,54 , 1586,14 , 1507,25 , 1532,54 , 1586,14 , 41,5 , 38,3 , {77,77,75},  121,1 , 1568,18 , 8,5 , 4,0 , 384,3 , 387,6 ,     0,     0,     7,     6,     7 }, // Burmese/AnyScript/Myanmar
    {     22,     0,    20,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,   171,   187, 0,6 , 0,6 , 0,6 , 0,6 , 358,6 , 10,17 , 150,5 , 155,10 , 2781,48 , 2829,99 , 2928,24 , 2781,48 , 2829,95 , 2924,24 , 1600,21 , 1621,56 , 1677,14 , 1600,21 , 1621,56 , 1677,14 , 46,10 , 41,13 , {66,89,82},  0,0 , 1586,23 , 4,4 , 4,0 , 393,10 , 403,8 ,     0,     0,     7,     6,     7 }, // Byelorussian/AnyScript/Belarus
    {     23,     0,    36,    44,    46,    59,    37,    48,    45,    43,   101,    39,    39,    34,    34, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 372,30 , 165,4 , 169,26 , 2952,27 , 2979,71 , 1381,27 , 2948,27 , 2975,71 , 134,27 , 1691,19 , 1710,76 , 708,14 , 1691,19 , 1710,76 , 708,14 , 56,5 , 54,5 , {75,72,82},  122,1 , 1609,11 , 0,4 , 4,0 , 411,9 , 420,7 ,     2,     1,     7,     6,     7 }, // Cambodian/AnyScript/Cambodia
    {     24,     0,   197,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 87,7 , 87,7 , 27,8 , 402,21 , 165,4 , 195,9 , 3050,60 , 3110,82 , 3192,24 , 3046,93 , 3139,115 , 3254,24 , 1786,21 , 1807,60 , 1867,14 , 1881,28 , 1909,60 , 1969,14 , 61,4 , 59,4 , {69,85,82},  112,1 , 1620,20 , 25,5 , 4,0 , 427,6 , 433,7 ,     2,     1,     1,     6,     7 }, // Catalan/AnyScript/Spain
    {     25,     0,    44,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 94,5 , 94,5 , 99,5 , 99,5 , 423,6 , 429,13 , 204,6 , 210,11 , 3216,38 , 3216,38 , 3254,39 , 3278,39 , 3278,39 , 134,27 , 1983,21 , 2004,28 , 2032,14 , 1983,21 , 2004,28 , 2032,14 , 65,2 , 63,2 , {67,78,89},  123,1 , 1640,10 , 4,4 , 4,0 , 440,2 , 442,2 ,     2,     1,     7,     6,     7 }, // Chinese/AnyScript/China
    {     25,     0,    97,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 94,5 , 94,5 , 99,5 , 99,5 , 442,7 , 429,13 , 204,6 , 221,13 , 3254,39 , 3254,39 , 1381,27 , 3278,39 , 3278,39 , 134,27 , 2046,21 , 2004,28 , 2032,14 , 2046,21 , 2004,28 , 2032,14 , 65,2 , 63,2 , {72,75,68},  12,1 , 1650,9 , 4,4 , 13,6 , 440,2 , 444,14 ,     2,     1,     7,     6,     7 }, // Chinese/AnyScript/HongKong
    {     25,     0,   126,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 94,5 , 94,5 , 99,5 , 99,5 , 442,7 , 449,15 , 204,6 , 221,13 , 3254,39 , 3254,39 , 1381,27 , 3278,39 , 3278,39 , 134,27 , 2046,21 , 2004,28 , 2032,14 , 2046,21 , 2004,28 , 2032,14 , 65,2 , 63,2 , {77,79,80},  0,0 , 1659,10 , 4,4 , 4,0 , 440,2 , 458,14 ,     2,     1,     7,     6,     7 }, // Chinese/AnyScript/Macau
    {     25,     0,   190,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 94,5 , 94,5 , 99,5 , 99,5 , 27,8 , 429,13 , 234,7 , 241,10 , 3254,39 , 3216,38 , 1381,27 , 3278,39 , 3317,38 , 134,27 , 1983,21 , 2004,28 , 2032,14 , 1983,21 , 2004,28 , 2032,14 , 65,2 , 63,2 , {83,71,68},  0,0 , 1669,11 , 4,4 , 4,0 , 440,2 , 472,3 ,     2,     1,     7,     6,     7 }, // Chinese/AnyScript/Singapore
    {     25,     0,   208,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 94,5 , 94,5 , 99,5 , 99,5 , 464,6 , 429,13 , 204,6 , 251,11 , 3216,38 , 3254,39 , 1381,27 , 3278,39 , 3278,39 , 134,27 , 2046,21 , 2004,28 , 2032,14 , 2046,21 , 2004,28 , 2032,14 , 65,2 , 63,2 , {84,87,68},  124,3 , 1680,10 , 4,4 , 4,0 , 440,2 , 475,2 ,     2,     1,     7,     6,     7 }, // Chinese/AnyScript/Taiwan
    {     25,     5,    44,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 94,5 , 94,5 , 99,5 , 99,5 , 423,6 , 429,13 , 204,6 , 210,11 , 3216,38 , 3216,38 , 3254,39 , 3278,39 , 3278,39 , 134,27 , 1983,21 , 2004,28 , 2032,14 , 1983,21 , 2004,28 , 2032,14 , 65,2 , 63,2 , {67,78,89},  123,1 , 1640,10 , 4,4 , 4,0 , 477,6 , 442,2 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/China
    {     25,     5,    97,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 94,5 , 94,5 , 99,5 , 99,5 , 279,6 , 429,13 , 204,6 , 241,10 , 3254,39 , 3216,38 , 1381,27 , 3278,39 , 3317,38 , 134,27 , 1983,21 , 2004,28 , 2032,14 , 1983,21 , 2004,28 , 2032,14 , 65,2 , 63,2 , {72,75,68},  12,1 , 1650,9 , 4,4 , 4,0 , 483,4 , 487,9 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/HongKong
    {     25,     5,   126,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 94,5 , 94,5 , 99,5 , 99,5 , 279,6 , 429,13 , 204,6 , 241,10 , 3254,39 , 3216,38 , 1381,27 , 3278,39 , 3317,38 , 134,27 , 1983,21 , 2004,28 , 2032,14 , 1983,21 , 2004,28 , 2032,14 , 65,2 , 63,2 , {77,79,80},  0,0 , 1690,10 , 4,4 , 4,0 , 483,4 , 496,9 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/Macau
    {     25,     5,   190,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 94,5 , 94,5 , 99,5 , 99,5 , 27,8 , 429,13 , 234,7 , 241,10 , 3254,39 , 3216,38 , 1381,27 , 3278,39 , 3317,38 , 134,27 , 1983,21 , 2004,28 , 2032,14 , 1983,21 , 2004,28 , 2032,14 , 65,2 , 63,2 , {83,71,68},  0,0 , 1669,11 , 4,4 , 4,0 , 483,4 , 472,3 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/Singapore
    {     25,     6,    97,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 94,5 , 94,5 , 99,5 , 99,5 , 442,7 , 429,13 , 204,6 , 221,13 , 3254,39 , 3254,39 , 1381,27 , 3278,39 , 3278,39 , 134,27 , 2046,21 , 2004,28 , 2032,14 , 2046,21 , 2004,28 , 2032,14 , 65,2 , 63,2 , {72,75,68},  12,1 , 1650,9 , 4,4 , 13,6 , 505,4 , 444,14 ,     2,     1,     7,     6,     7 }, // Chinese/Traditional Han/HongKong
    {     25,     6,   126,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 94,5 , 94,5 , 99,5 , 99,5 , 442,7 , 449,15 , 204,6 , 221,13 , 3254,39 , 3254,39 , 1381,27 , 3278,39 , 3278,39 , 134,27 , 2046,21 , 2004,28 , 2032,14 , 2046,21 , 2004,28 , 2032,14 , 65,2 , 63,2 , {77,79,80},  0,0 , 1659,10 , 4,4 , 4,0 , 505,4 , 458,14 ,     2,     1,     7,     6,     7 }, // Chinese/Traditional Han/Macau
    {     25,     6,   208,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 94,5 , 94,5 , 99,5 , 99,5 , 464,6 , 429,13 , 204,6 , 251,11 , 3216,38 , 3254,39 , 1381,27 , 3278,39 , 3278,39 , 134,27 , 2046,21 , 2004,28 , 2032,14 , 2046,21 , 2004,28 , 2032,14 , 65,2 , 63,2 , {84,87,68},  124,3 , 1680,10 , 4,4 , 4,0 , 505,4 , 475,2 ,     2,     1,     7,     6,     7 }, // Chinese/Traditional Han/Taiwan
    {     27,     0,    54,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 87,7 , 87,7 , 470,9 , 479,19 , 37,5 , 8,10 , 3293,49 , 3342,94 , 3436,39 , 3355,49 , 3404,98 , 3502,39 , 2067,28 , 2095,58 , 2153,14 , 2067,28 , 2095,58 , 2167,14 , 67,11 , 0,2 , {72,82,75},  127,2 , 1700,27 , 25,5 , 4,0 , 509,8 , 517,8 ,     2,     1,     1,     6,     7 }, // Croatian/AnyScript/Croatia
    {     28,     0,    57,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 104,7 , 104,7 , 332,8 , 498,18 , 165,4 , 195,9 , 3436,39 , 3475,82 , 3557,24 , 3541,48 , 3589,84 , 134,27 , 2181,21 , 2202,49 , 2251,14 , 2181,21 , 2202,49 , 2251,14 , 78,4 , 65,4 , {67,90,75},  129,2 , 1727,56 , 25,5 , 4,0 , 525,7 , 532,15 ,     2,     1,     1,     6,     7 }, // Czech/AnyScript/CzechRepublic
    {     29,     0,    58,    44,    46,    44,    37,    48,    45,    43,   101,  8221,  8221,  8221,  8221, 0,6 , 0,6 , 111,8 , 111,8 , 27,8 , 516,23 , 150,5 , 155,10 , 3581,48 , 3629,84 , 134,24 , 3673,59 , 3732,84 , 320,24 , 2265,28 , 2293,51 , 2344,14 , 2265,28 , 2293,51 , 2344,14 , 82,4 , 69,4 , {68,75,75},  131,2 , 1783,42 , 25,5 , 4,0 , 547,5 , 552,7 ,     2,     1,     1,     6,     7 }, // Danish/AnyScript/Denmark
    {     30,     0,   151,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 6,8 , 6,8 , 539,8 , 99,16 , 37,5 , 8,10 , 3713,48 , 3761,88 , 134,24 , 3816,59 , 3875,88 , 320,24 , 2358,21 , 2379,59 , 2438,14 , 2358,21 , 2379,59 , 2438,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1825,19 , 8,5 , 19,6 , 559,10 , 569,9 ,     2,     1,     1,     6,     7 }, // Dutch/AnyScript/Netherlands
    {     30,     0,    12,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 6,8 , 6,8 , 539,8 , 99,16 , 37,5 , 8,10 , 3713,48 , 3761,88 , 134,24 , 3816,59 , 3875,88 , 320,24 , 2358,21 , 2379,59 , 2438,14 , 2358,21 , 2379,59 , 2438,14 , 0,2 , 0,2 , {65,87,71},  133,4 , 1844,23 , 8,5 , 19,6 , 559,10 , 578,5 ,     2,     1,     1,     6,     7 }, // Dutch/AnyScript/Aruba
    {     30,     0,    21,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 6,8 , 6,8 , 547,7 , 99,16 , 37,5 , 8,10 , 3713,48 , 3761,88 , 134,24 , 3816,59 , 3875,88 , 320,24 , 2358,21 , 2379,59 , 2438,14 , 2358,21 , 2379,59 , 2438,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1825,19 , 25,5 , 4,0 , 583,6 , 589,6 ,     2,     1,     1,     6,     7 }, // Dutch/AnyScript/Belgium
    {     31,     0,   225,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  12,1 , 1867,35 , 4,4 , 13,6 , 595,12 , 607,13 ,     2,     1,     7,     6,     7 }, // English/AnyScript/UnitedStates
    {     31,     0,     4,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  12,1 , 1867,35 , 4,4 , 13,6 , 620,7 , 627,14 ,     2,     1,     7,     6,     7 }, // English/AnyScript/AmericanSamoa
    {     31,     0,    13,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 547,7 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {65,85,68},  12,1 , 1902,59 , 4,4 , 4,0 , 641,18 , 659,9 ,     2,     1,     7,     6,     7 }, // English/AnyScript/Australia
    {     31,     0,    19,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {66,66,68},  12,1 , 1961,56 , 4,4 , 13,6 , 620,7 , 668,8 ,     2,     1,     1,     6,     7 }, // English/AnyScript/Barbados
    {     31,     0,    21,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 27,8 , 99,16 , 37,5 , 262,24 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 2017,20 , 25,5 , 4,0 , 620,7 , 676,7 ,     2,     1,     1,     6,     7 }, // English/AnyScript/Belgium
    {     31,     0,    22,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 27,8 , 560,12 , 37,5 , 8,10 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {66,90,68},  12,1 , 2037,47 , 4,4 , 4,0 , 620,7 , 683,6 ,     2,     1,     7,     6,     7 }, // English/AnyScript/Belize
    {     31,     0,    24,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {66,77,68},  12,1 , 2084,53 , 4,4 , 13,6 , 620,7 , 689,7 ,     2,     1,     1,     6,     7 }, // English/AnyScript/Bermuda
    {     31,     0,    28,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 27,8 , 82,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {66,87,80},  137,1 , 2137,50 , 4,4 , 4,0 , 620,7 , 696,8 ,     2,     1,     7,     6,     7 }, // English/AnyScript/Botswana
    {     31,     0,    38,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 115,8 , 203,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {67,65,68},  12,1 , 2187,53 , 4,4 , 13,6 , 704,16 , 720,6 ,     2,     1,     7,     6,     7 }, // English/AnyScript/Canada
    {     31,     0,    89,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  12,1 , 1867,35 , 4,4 , 13,6 , 620,7 , 726,4 ,     2,     1,     7,     6,     7 }, // English/AnyScript/Guam
    {     31,     0,    93,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {71,89,68},  0,0 , 2240,56 , 4,4 , 13,6 , 620,7 , 730,6 ,     0,     0,     1,     6,     7 }, // English/AnyScript/Guyana
    {     31,     0,    97,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 279,6 , 203,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {72,75,68},  12,1 , 2296,56 , 4,4 , 13,6 , 620,7 , 736,19 ,     2,     1,     7,     6,     7 }, // English/AnyScript/HongKong
    {     31,     0,   100,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 27,8 , 99,16 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {73,78,82},  114,1 , 2352,44 , 8,5 , 4,0 , 620,7 , 755,5 ,     2,     1,     7,     7,     7 }, // English/AnyScript/India
    {     31,     0,   104,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 141,10 , 99,16 , 37,5 , 8,10 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 61,4 , 59,4 , {69,85,82},  112,1 , 2017,20 , 4,4 , 4,0 , 620,7 , 760,7 ,     2,     1,     1,     6,     7 }, // English/AnyScript/Ireland
    {     31,     0,   107,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 279,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {74,77,68},  12,1 , 2396,53 , 4,4 , 4,0 , 620,7 , 767,7 ,     2,     1,     7,     6,     7 }, // English/AnyScript/Jamaica
    {     31,     0,   133,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 141,10 , 10,17 , 37,5 , 8,10 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 2017,20 , 4,4 , 4,0 , 620,7 , 774,5 ,     2,     1,     7,     6,     7 }, // English/AnyScript/Malta
    {     31,     0,   134,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  12,1 , 1867,35 , 4,4 , 13,6 , 620,7 , 779,16 ,     2,     1,     7,     6,     7 }, // English/AnyScript/MarshallIslands
    {     31,     0,   137,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {77,85,82},  0,0 , 2449,53 , 4,4 , 13,6 , 620,7 , 795,9 ,     0,     0,     1,     6,     7 }, // English/AnyScript/Mauritius
    {     31,     0,   148,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {78,65,68},  12,1 , 2502,53 , 4,4 , 4,0 , 620,7 , 804,7 ,     2,     1,     1,     6,     7 }, // English/AnyScript/Namibia
    {     31,     0,   154,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 547,7 , 10,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {78,90,68},  12,1 , 2555,62 , 4,4 , 4,0 , 620,7 , 811,11 ,     2,     1,     7,     6,     7 }, // English/AnyScript/NewZealand
    {     31,     0,   160,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  12,1 , 1867,35 , 4,4 , 13,6 , 620,7 , 822,24 ,     2,     1,     1,     6,     7 }, // English/AnyScript/NorthernMarianaIslands
    {     31,     0,   163,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 27,8 , 99,16 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {80,75,82},  138,1 , 2617,53 , 8,5 , 4,0 , 620,7 , 846,8 ,     0,     0,     7,     6,     7 }, // English/AnyScript/Pakistan
    {     31,     0,   170,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {80,72,80},  139,1 , 2670,42 , 4,4 , 13,6 , 620,7 , 854,11 ,     2,     1,     7,     6,     7 }, // English/AnyScript/Philippines
    {     31,     0,   190,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 279,6 , 203,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {83,71,68},  12,1 , 2712,56 , 4,4 , 13,6 , 620,7 , 865,9 ,     2,     1,     7,     6,     7 }, // English/AnyScript/Singapore
    {     31,     0,   195,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 572,10 , 82,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {90,65,82},  11,1 , 2768,61 , 4,4 , 13,6 , 620,7 , 874,12 ,     2,     1,     7,     6,     7 }, // English/AnyScript/SouthAfrica
    {     31,     0,   215,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {84,84,68},  12,1 , 2829,86 , 4,4 , 4,0 , 620,7 , 886,19 ,     2,     1,     7,     6,     7 }, // English/AnyScript/TrinidadAndTobago
    {     31,     0,   224,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 119,10 , 129,9 , 141,10 , 10,17 , 37,5 , 8,10 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {71,66,80},  140,1 , 2915,74 , 4,4 , 4,0 , 905,15 , 920,14 ,     2,     1,     1,     6,     7 }, // English/AnyScript/UnitedKingdom
    {     31,     0,   226,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  12,1 , 1867,35 , 4,4 , 13,6 , 620,7 , 934,27 ,     2,     1,     7,     6,     7 }, // English/AnyScript/UnitedStatesMinorOutlyingIslands
    {     31,     0,   234,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  12,1 , 1867,35 , 4,4 , 13,6 , 620,7 , 961,19 ,     2,     1,     7,     6,     7 }, // English/AnyScript/USVirginIslands
    {     31,     0,   240,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 364,8 , 82,17 , 18,7 , 25,12 , 0,48 , 48,86 , 134,24 , 0,48 , 48,86 , 320,24 , 0,28 , 28,57 , 85,14 , 0,28 , 28,57 , 85,14 , 0,2 , 0,2 , {85,83,68},  12,1 , 1867,35 , 4,4 , 4,0 , 620,7 , 980,8 ,     2,     1,     7,     6,     7 }, // English/AnyScript/Zimbabwe
    {     31,     3,   225,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 119,10 , 129,9 , 554,6 , 35,18 , 18,7 , 25,12 , 3849,80 , 3929,154 , 4083,36 , 3963,80 , 4043,154 , 4197,36 , 2452,49 , 2501,85 , 2586,21 , 2452,49 , 2501,85 , 2586,21 , 86,4 , 73,4 , {85,83,68},  12,1 , 1867,35 , 4,4 , 13,6 , 595,12 , 988,25 ,     2,     1,     7,     6,     7 }, // English/Deseret/UnitedStates
    {     33,     0,    68,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8220,  8222,  8220, 0,6 , 0,6 , 138,8 , 138,8 , 332,8 , 498,18 , 165,4 , 286,9 , 4119,59 , 4178,91 , 4269,24 , 4233,59 , 4292,91 , 4383,24 , 2607,14 , 2621,63 , 2607,14 , 2607,14 , 2621,63 , 2607,14 , 90,14 , 77,16 , {69,85,82},  112,1 , 2989,20 , 25,5 , 4,0 , 1013,5 , 1018,5 ,     2,     1,     1,     6,     7 }, // Estonian/AnyScript/Estonia
    {     34,     0,    71,    44,    46,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 111,8 , 111,8 , 539,8 , 82,17 , 37,5 , 8,10 , 4293,48 , 4341,83 , 134,24 , 4407,48 , 4455,83 , 320,24 , 2684,28 , 2712,74 , 2786,14 , 2684,28 , 2712,74 , 2786,14 , 0,2 , 0,2 , {68,75,75},  131,2 , 3009,42 , 4,4 , 36,5 , 1023,8 , 1031,7 ,     2,     1,     1,     6,     7 }, // Faroese/AnyScript/FaroeIslands
    {     36,     0,    73,    44,   160,    59,    37,    48,    45,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 138,8 , 138,8 , 582,8 , 498,18 , 295,4 , 299,9 , 4424,69 , 4493,105 , 4598,24 , 4538,129 , 4538,129 , 4667,24 , 2800,21 , 2821,67 , 2888,14 , 2800,21 , 2902,81 , 2888,14 , 104,3 , 93,3 , {69,85,82},  112,1 , 3051,20 , 25,5 , 4,0 , 1038,5 , 1043,5 ,     2,     1,     1,     6,     7 }, // Finnish/AnyScript/Finland
    {     37,     0,    74,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1620,20 , 25,5 , 4,0 , 1048,8 , 1056,6 ,     2,     1,     1,     6,     7 }, // French/AnyScript/France
    {     37,     0,    21,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 547,7 , 99,16 , 37,5 , 308,23 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1620,20 , 25,5 , 4,0 , 1048,8 , 1062,8 ,     2,     1,     1,     6,     7 }, // French/AnyScript/Belgium
    {     37,     0,    23,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {88,79,70},  141,3 , 3071,59 , 25,5 , 4,0 , 1048,8 , 1070,5 ,     0,     0,     1,     6,     7 }, // French/AnyScript/Benin
    {     37,     0,    34,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {88,79,70},  141,3 , 3071,59 , 25,5 , 4,0 , 1048,8 , 1075,12 ,     0,     0,     1,     6,     7 }, // French/AnyScript/BurkinaFaso
    {     37,     0,    35,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {66,73,70},  144,3 , 3130,53 , 25,5 , 4,0 , 1048,8 , 1087,7 ,     0,     0,     1,     6,     7 }, // French/AnyScript/Burundi
    {     37,     0,    37,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {88,65,70},  147,3 , 3183,56 , 25,5 , 4,0 , 1048,8 , 1094,8 ,     0,     0,     1,     6,     7 }, // French/AnyScript/Cameroon
    {     37,     0,    38,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 115,8 , 99,16 , 37,5 , 262,24 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {67,65,68},  12,1 , 3239,54 , 25,5 , 41,7 , 1102,17 , 720,6 ,     2,     1,     7,     6,     7 }, // French/AnyScript/Canada
    {     37,     0,    41,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {88,65,70},  147,3 , 3183,56 , 25,5 , 4,0 , 1048,8 , 1119,25 ,     0,     0,     1,     6,     7 }, // French/AnyScript/CentralAfricanRepublic
    {     37,     0,    42,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {88,65,70},  147,3 , 3183,56 , 25,5 , 4,0 , 1048,8 , 1144,5 ,     0,     0,     1,     6,     7 }, // French/AnyScript/Chad
    {     37,     0,    48,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {75,77,70},  150,2 , 3293,51 , 25,5 , 4,0 , 1048,8 , 1149,7 ,     0,     0,     1,     6,     7 }, // French/AnyScript/Comoros
    {     37,     0,    49,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {67,68,70},  152,4 , 3344,53 , 25,5 , 4,0 , 1048,8 , 1156,32 ,     2,     1,     1,     6,     7 }, // French/AnyScript/DemocraticRepublicOfCongo
    {     37,     0,    50,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {88,65,70},  147,3 , 3183,56 , 25,5 , 4,0 , 1048,8 , 1188,17 ,     0,     0,     1,     6,     7 }, // French/AnyScript/PeoplesRepublicOfCongo
    {     37,     0,    53,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {88,79,70},  141,3 , 3071,59 , 25,5 , 4,0 , 1048,8 , 1205,13 ,     0,     0,     1,     6,     7 }, // French/AnyScript/IvoryCoast
    {     37,     0,    59,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {68,74,70},  5,3 , 3397,57 , 25,5 , 4,0 , 1048,8 , 1218,8 ,     0,     0,     6,     6,     7 }, // French/AnyScript/Djibouti
    {     37,     0,    66,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {88,65,70},  147,3 , 3183,56 , 25,5 , 4,0 , 1048,8 , 1226,18 ,     0,     0,     1,     6,     7 }, // French/AnyScript/EquatorialGuinea
    {     37,     0,    76,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1620,20 , 25,5 , 4,0 , 1048,8 , 1244,16 ,     2,     1,     1,     6,     7 }, // French/AnyScript/FrenchGuiana
    {     37,     0,    79,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {88,65,70},  147,3 , 3183,56 , 25,5 , 4,0 , 1048,8 , 1260,5 ,     0,     0,     1,     6,     7 }, // French/AnyScript/Gabon
    {     37,     0,    88,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1620,20 , 25,5 , 4,0 , 1048,8 , 1265,10 ,     2,     1,     1,     6,     7 }, // French/AnyScript/Guadeloupe
    {     37,     0,    91,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {71,78,70},  156,2 , 3454,48 , 25,5 , 4,0 , 1048,8 , 1275,6 ,     0,     0,     1,     6,     7 }, // French/AnyScript/Guinea
    {     37,     0,   125,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1620,20 , 25,5 , 4,0 , 1048,8 , 1281,10 ,     2,     1,     1,     6,     7 }, // French/AnyScript/Luxembourg
    {     37,     0,   128,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {77,71,65},  158,3 , 3502,54 , 25,5 , 4,0 , 1048,8 , 1291,10 ,     0,     0,     1,     6,     7 }, // French/AnyScript/Madagascar
    {     37,     0,   132,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {88,79,70},  141,3 , 3071,59 , 25,5 , 4,0 , 1048,8 , 1301,4 ,     0,     0,     1,     6,     7 }, // French/AnyScript/Mali
    {     37,     0,   135,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1620,20 , 25,5 , 4,0 , 1048,8 , 1305,10 ,     2,     1,     1,     6,     7 }, // French/AnyScript/Martinique
    {     37,     0,   138,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1620,20 , 25,5 , 4,0 , 1048,8 , 1315,7 ,     2,     1,     1,     6,     7 }, // French/AnyScript/Mayotte
    {     37,     0,   142,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1620,20 , 25,5 , 4,0 , 1048,8 , 1322,6 ,     2,     1,     1,     6,     7 }, // French/AnyScript/Monaco
    {     37,     0,   156,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {88,79,70},  141,3 , 3071,59 , 25,5 , 4,0 , 1048,8 , 1328,5 ,     0,     0,     1,     6,     7 }, // French/AnyScript/Niger
    {     37,     0,   176,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1620,20 , 25,5 , 4,0 , 1048,8 , 1333,7 ,     2,     1,     1,     6,     7 }, // French/AnyScript/Reunion
    {     37,     0,   179,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {82,87,70},  161,2 , 3556,50 , 25,5 , 4,0 , 1048,8 , 1340,6 ,     0,     0,     1,     6,     7 }, // French/AnyScript/Rwanda
    {     37,     0,   187,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {88,79,70},  141,3 , 3071,59 , 25,5 , 4,0 , 1048,8 , 1346,7 ,     0,     0,     1,     6,     7 }, // French/AnyScript/Senegal
    {     37,     0,   206,    46,    39,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 146,8 , 146,8 , 332,8 , 10,17 , 37,5 , 331,14 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {67,72,70},  163,3 , 3606,45 , 8,5 , 48,5 , 1353,15 , 1368,6 ,     2,     5,     1,     6,     7 }, // French/AnyScript/Switzerland
    {     37,     0,   212,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {88,79,70},  141,3 , 3071,59 , 25,5 , 4,0 , 1048,8 , 1374,4 ,     0,     0,     1,     6,     7 }, // French/AnyScript/Togo
    {     37,     0,   244,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1620,20 , 25,5 , 4,0 , 1048,8 , 1378,16 ,     2,     1,     1,     6,     7 }, // French/AnyScript/Saint Barthelemy
    {     37,     0,   245,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 146,8 , 146,8 , 27,8 , 99,16 , 37,5 , 8,10 , 4622,63 , 4685,85 , 134,24 , 4691,63 , 4754,85 , 320,24 , 2983,35 , 3018,52 , 3070,14 , 2983,35 , 3018,52 , 3070,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1620,20 , 25,5 , 4,0 , 1048,8 , 1394,12 ,     2,     1,     1,     6,     7 }, // French/AnyScript/Saint Martin
    {     40,     0,   197,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 154,7 , 154,7 , 27,8 , 82,17 , 37,5 , 8,10 , 4770,48 , 4818,87 , 4905,24 , 4839,48 , 4887,87 , 4974,24 , 3084,28 , 3112,49 , 3161,14 , 3084,28 , 3112,49 , 3161,14 , 61,4 , 59,4 , {69,85,82},  112,1 , 2017,20 , 25,5 , 4,0 , 1406,6 , 1412,6 ,     2,     1,     1,     6,     7 }, // Galician/AnyScript/Spain
    {     41,     0,    81,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 161,8 , 161,8 , 221,8 , 314,18 , 37,5 , 8,10 , 4929,48 , 4977,98 , 5075,24 , 4998,48 , 5046,98 , 5144,24 , 3175,28 , 3203,62 , 3265,14 , 3175,28 , 3203,62 , 3265,14 , 0,2 , 0,2 , {71,69,76},  0,0 , 3651,19 , 25,5 , 4,0 , 1418,7 , 1425,10 ,     2,     1,     1,     6,     7 }, // Georgian/AnyScript/Georgia
    {     42,     0,    82,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 169,9 , 169,9 , 332,8 , 498,18 , 37,5 , 8,10 , 5099,48 , 5147,83 , 134,24 , 5168,48 , 5216,83 , 320,24 , 3279,21 , 3300,60 , 3360,14 , 3374,28 , 3300,60 , 3360,14 , 107,5 , 96,6 , {69,85,82},  112,1 , 3670,19 , 25,5 , 4,0 , 1435,7 , 1442,11 ,     2,     1,     1,     6,     7 }, // German/AnyScript/Germany
    {     42,     0,    14,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 169,9 , 169,9 , 332,8 , 590,19 , 37,5 , 8,10 , 5230,48 , 5278,83 , 134,24 , 5299,48 , 5347,83 , 320,24 , 3279,21 , 3300,60 , 3360,14 , 3374,28 , 3300,60 , 3360,14 , 107,5 , 96,6 , {69,85,82},  112,1 , 3670,19 , 8,5 , 4,0 , 1453,24 , 1477,10 ,     2,     1,     1,     6,     7 }, // German/AnyScript/Austria
    {     42,     0,    21,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 169,9 , 169,9 , 332,8 , 498,18 , 37,5 , 8,10 , 5099,48 , 5147,83 , 134,24 , 5168,48 , 5216,83 , 320,24 , 3279,21 , 3300,60 , 3360,14 , 3374,28 , 3300,60 , 3360,14 , 107,5 , 96,6 , {69,85,82},  112,1 , 3670,19 , 25,5 , 4,0 , 1435,7 , 1487,7 ,     2,     1,     1,     6,     7 }, // German/AnyScript/Belgium
    {     42,     0,   123,    46,    39,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 169,9 , 169,9 , 332,8 , 498,18 , 37,5 , 8,10 , 5099,48 , 5147,83 , 134,24 , 5168,48 , 5216,83 , 320,24 , 3279,21 , 3300,60 , 3360,14 , 3374,28 , 3300,60 , 3360,14 , 107,5 , 96,6 , {67,72,70},  0,0 , 3689,58 , 8,5 , 4,0 , 1435,7 , 1494,13 ,     2,     5,     1,     6,     7 }, // German/AnyScript/Liechtenstein
    {     42,     0,   125,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 169,9 , 169,9 , 332,8 , 498,18 , 37,5 , 8,10 , 5099,48 , 5147,83 , 134,24 , 5168,48 , 5216,83 , 320,24 , 3279,21 , 3300,60 , 3360,14 , 3374,28 , 3300,60 , 3360,14 , 107,5 , 96,6 , {69,85,82},  112,1 , 3670,19 , 25,5 , 4,0 , 1435,7 , 1507,9 ,     2,     1,     1,     6,     7 }, // German/AnyScript/Luxembourg
    {     42,     0,   206,    46,    39,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 169,9 , 169,9 , 332,8 , 498,18 , 37,5 , 8,10 , 5099,48 , 5147,83 , 134,24 , 5168,48 , 5216,83 , 320,24 , 3279,21 , 3300,60 , 3360,14 , 3374,28 , 3300,60 , 3360,14 , 107,5 , 96,6 , {67,72,70},  0,0 , 3689,58 , 8,5 , 48,5 , 1516,21 , 1537,7 ,     2,     5,     1,     6,     7 }, // German/AnyScript/Switzerland
    {     43,     0,    85,    44,    46,    44,    37,    48,    45,    43,   101,   171,   187,  8216,  8217, 0,6 , 0,6 , 178,9 , 178,9 , 279,6 , 10,17 , 18,7 , 25,12 , 5361,50 , 5411,115 , 5526,24 , 5430,50 , 5480,115 , 5595,24 , 3402,28 , 3430,55 , 3485,14 , 3499,28 , 3430,55 , 3485,14 , 112,4 , 102,4 , {69,85,82},  112,1 , 3747,19 , 25,5 , 4,0 , 1544,8 , 1552,6 ,     2,     1,     1,     6,     7 }, // Greek/AnyScript/Greece
    {     43,     0,    56,    44,    46,    44,    37,    48,    45,    43,   101,   171,   187,  8216,  8217, 0,6 , 0,6 , 178,9 , 178,9 , 279,6 , 10,17 , 18,7 , 25,12 , 5361,50 , 5411,115 , 5526,24 , 5430,50 , 5480,115 , 5595,24 , 3402,28 , 3430,55 , 3485,14 , 3499,28 , 3430,55 , 3485,14 , 112,4 , 102,4 , {69,85,82},  112,1 , 3747,19 , 4,4 , 4,0 , 1544,8 , 1558,6 ,     2,     1,     1,     6,     7 }, // Greek/AnyScript/Cyprus
    {     44,     0,    86,    44,    46,    59,    37,    48,  8722,    43,   101,   187,   171,  8250,  8249, 187,11 , 0,6 , 0,6 , 187,11 , 72,10 , 82,17 , 18,7 , 25,12 , 3581,48 , 5550,96 , 134,24 , 5619,48 , 5667,96 , 320,24 , 3527,28 , 3555,98 , 3653,14 , 3527,28 , 3555,98 , 3653,14 , 0,2 , 0,2 , {68,75,75},  131,2 , 3766,24 , 4,4 , 36,5 , 1564,11 , 1575,16 ,     2,     1,     1,     6,     7 }, // Greenlandic/AnyScript/Greenland
    {     46,     0,   100,  1643,  1644,  1563,  1642,  2790,    45,    43,   101,    39,    39,    34,    34, 0,6 , 0,6 , 198,9 , 198,9 , 609,7 , 203,18 , 345,8 , 353,13 , 5646,67 , 5713,87 , 5800,31 , 5763,67 , 5830,87 , 5917,31 , 3667,32 , 3699,53 , 3752,19 , 3667,32 , 3699,53 , 3752,19 , 116,14 , 106,14 , {73,78,82},  166,2 , 3790,20 , 8,5 , 4,0 , 1591,7 , 1598,4 ,     2,     1,     7,     7,     7 }, // Gujarati/AnyScript/India
    {     47,     0,    83,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 279,6 , 203,18 , 37,5 , 8,10 , 5831,48 , 5879,85 , 5964,24 , 5948,48 , 5996,85 , 6081,24 , 3771,21 , 3792,52 , 3844,14 , 3771,21 , 3792,52 , 3844,14 , 0,2 , 0,2 , {71,72,83},  0,0 , 0,7 , 8,5 , 4,0 , 1602,5 , 1607,4 ,     2,     1,     1,     6,     7 }, // Hausa/AnyScript/Ghana
    {     47,     0,   156,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 279,6 , 203,18 , 37,5 , 8,10 , 5831,48 , 5879,85 , 5964,24 , 5948,48 , 5996,85 , 6081,24 , 3771,21 , 3792,52 , 3844,14 , 3771,21 , 3792,52 , 3844,14 , 0,2 , 0,2 , {88,79,70},  168,3 , 3810,36 , 8,5 , 4,0 , 1602,5 , 1611,5 ,     0,     0,     1,     6,     7 }, // Hausa/AnyScript/Niger
    {     47,     0,   157,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 279,6 , 203,18 , 37,5 , 8,10 , 5831,48 , 5879,85 , 5964,24 , 5948,48 , 5996,85 , 6081,24 , 3771,21 , 3792,52 , 3844,14 , 3771,21 , 3792,52 , 3844,14 , 0,2 , 0,2 , {78,71,78},  171,1 , 3846,12 , 8,5 , 4,0 , 1602,5 , 1616,8 ,     2,     1,     1,     6,     7 }, // Hausa/AnyScript/Nigeria
    {     47,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 279,6 , 203,18 , 37,5 , 8,10 , 5831,48 , 5879,85 , 5964,24 , 5948,48 , 5996,85 , 6081,24 , 3771,21 , 3792,52 , 3844,14 , 3771,21 , 3792,52 , 3844,14 , 0,2 , 0,2 , {71,72,83},  0,0 , 0,7 , 8,5 , 4,0 , 1602,5 , 1607,4 ,     2,     1,     1,     6,     7 }, // Hausa/Latin/Ghana
    {     47,     7,   156,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 279,6 , 203,18 , 37,5 , 8,10 , 5831,48 , 5879,85 , 5964,24 , 5948,48 , 5996,85 , 6081,24 , 3771,21 , 3792,52 , 3844,14 , 3771,21 , 3792,52 , 3844,14 , 0,2 , 0,2 , {88,79,70},  168,3 , 3810,36 , 8,5 , 4,0 , 1602,5 , 1611,5 ,     0,     0,     1,     6,     7 }, // Hausa/Latin/Niger
    {     47,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 279,6 , 203,18 , 37,5 , 8,10 , 5831,48 , 5879,85 , 5964,24 , 5948,48 , 5996,85 , 6081,24 , 3771,21 , 3792,52 , 3844,14 , 3771,21 , 3792,52 , 3844,14 , 0,2 , 0,2 , {78,71,78},  171,1 , 3846,12 , 8,5 , 4,0 , 1602,5 , 1616,8 ,     2,     1,     1,     6,     7 }, // Hausa/Latin/Nigeria
    {     48,     0,   105,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,    34,    34, 0,6 , 0,6 , 207,7 , 207,7 , 27,8 , 616,18 , 37,5 , 8,10 , 5988,58 , 6046,72 , 1381,27 , 6105,48 , 6153,72 , 134,27 , 3858,46 , 3904,65 , 3969,14 , 3858,46 , 3904,65 , 3969,14 , 130,6 , 120,5 , {73,76,83},  172,1 , 3858,21 , 25,5 , 4,0 , 1624,5 , 1629,5 ,     2,     1,     7,     5,     6 }, // Hebrew/AnyScript/Israel
    {     49,     0,   100,    46,    44,    59,    37,  2406,    45,    43,   101,    39,    39,    34,    34, 0,6 , 0,6 , 214,9 , 223,8 , 634,6 , 10,17 , 18,7 , 25,12 , 6118,75 , 6118,75 , 6193,30 , 6225,75 , 6225,75 , 6300,30 , 3983,38 , 4021,57 , 4078,19 , 3983,38 , 4021,57 , 4078,19 , 136,9 , 125,7 , {73,78,82},  173,3 , 3879,19 , 8,5 , 4,0 , 1634,6 , 1640,4 ,     2,     1,     7,     7,     7 }, // Hindi/AnyScript/India
    {     50,     0,    98,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,  8222,  8221, 0,6 , 0,6 , 231,8 , 231,8 , 640,11 , 651,19 , 165,4 , 195,9 , 6223,64 , 6287,98 , 6385,25 , 6330,64 , 6394,98 , 6492,25 , 4097,19 , 4116,52 , 4168,17 , 4097,19 , 4116,52 , 4168,17 , 145,3 , 132,3 , {72,85,70},  176,2 , 3898,20 , 25,5 , 4,0 , 1644,6 , 1650,12 ,     0,     0,     1,     6,     7 }, // Hungarian/AnyScript/Hungary
    {     51,     0,    99,    44,    46,    59,    37,    48,  8722,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 111,8 , 111,8 , 582,8 , 498,18 , 37,5 , 8,10 , 6410,48 , 6458,82 , 6540,24 , 6517,48 , 6565,82 , 6647,24 , 4185,28 , 4213,81 , 4294,14 , 4185,28 , 4213,81 , 4308,14 , 148,4 , 135,4 , {73,83,75},  131,2 , 3918,48 , 25,5 , 4,0 , 1662,8 , 1670,6 ,     0,     0,     1,     6,     7 }, // Icelandic/AnyScript/Iceland
    {     52,     0,   101,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 239,10 , 249,9 , 27,8 , 123,18 , 37,5 , 195,9 , 6564,48 , 6612,87 , 134,24 , 6671,48 , 6719,87 , 320,24 , 4322,28 , 4350,43 , 4393,14 , 4322,28 , 4350,43 , 4393,14 , 152,4 , 139,5 , {73,68,82},  178,2 , 3966,23 , 4,4 , 4,0 , 1676,16 , 1692,9 ,     0,     0,     7,     6,     7 }, // Indonesian/AnyScript/Indonesia
    {     57,     0,   104,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 6699,33 , 6699,33 , 1381,27 , 6806,33 , 6806,33 , 134,27 , 4407,32 , 4407,32 , 708,14 , 4407,32 , 4407,32 , 708,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 0,7 , 8,5 , 4,0 , 1701,7 , 1708,4 ,     2,     1,     1,     6,     7 }, // Irish/AnyScript/Ireland
    {     58,     0,   106,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 258,8 , 154,7 , 27,8 , 99,16 , 37,5 , 8,10 , 6732,48 , 6780,94 , 6874,24 , 6839,48 , 6887,94 , 6981,24 , 4439,28 , 4467,57 , 4524,14 , 4439,28 , 4538,57 , 4524,14 , 156,2 , 144,2 , {69,85,82},  112,1 , 1825,19 , 8,5 , 4,0 , 1712,8 , 1720,6 ,     2,     1,     1,     6,     7 }, // Italian/AnyScript/Italy
    {     58,     0,   206,    46,    39,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 258,8 , 154,7 , 332,8 , 10,17 , 37,5 , 331,14 , 6732,48 , 6780,94 , 6874,24 , 6839,48 , 6887,94 , 6981,24 , 4439,28 , 4467,57 , 4524,14 , 4439,28 , 4538,57 , 4524,14 , 156,2 , 144,2 , {67,72,70},  163,3 , 3989,53 , 8,5 , 48,5 , 1712,8 , 1726,8 ,     2,     5,     1,     6,     7 }, // Italian/AnyScript/Switzerland
    {     59,     0,   108,    46,    44,    59,    37,    48,    45,    43,   101, 12300, 12301, 12302, 12303, 94,5 , 94,5 , 94,5 , 94,5 , 221,8 , 429,13 , 165,4 , 366,10 , 3254,39 , 3254,39 , 1381,27 , 3278,39 , 3278,39 , 134,27 , 4595,14 , 4609,28 , 4595,14 , 4595,14 , 4609,28 , 4595,14 , 158,2 , 146,2 , {74,80,89},  123,1 , 4042,10 , 4,4 , 4,0 , 1734,3 , 1737,2 ,     0,     0,     7,     6,     7 }, // Japanese/AnyScript/Japan
    {     61,     0,   100,  1643,  1644,  1563,  1642,  3302,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 266,12 , 278,11 , 634,6 , 99,16 , 345,8 , 353,13 , 6898,86 , 6898,86 , 6984,31 , 7005,86 , 7005,86 , 7091,31 , 4637,28 , 4665,53 , 4718,19 , 4637,28 , 4665,53 , 4718,19 , 0,2 , 0,2 , {73,78,82},  114,1 , 4052,20 , 8,5 , 4,0 , 1739,5 , 1744,4 ,     2,     1,     7,     7,     7 }, // Kannada/AnyScript/India
    {     63,     0,   110,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 332,8 , 670,22 , 37,5 , 8,10 , 7015,61 , 7076,83 , 1381,27 , 7122,61 , 7183,83 , 134,27 , 4737,28 , 4765,56 , 708,14 , 4821,28 , 4849,54 , 708,14 , 0,2 , 0,2 , {75,90,84},  180,4 , 4072,24 , 25,5 , 4,0 , 1748,10 , 1758,9 ,     2,     1,     1,     6,     7 }, // Kazakh/AnyScript/Kazakhstan
    {     63,     2,   110,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 332,8 , 670,22 , 37,5 , 8,10 , 7015,61 , 7076,83 , 1381,27 , 7122,61 , 7183,83 , 134,27 , 4737,28 , 4765,56 , 708,14 , 4821,28 , 4849,54 , 708,14 , 0,2 , 0,2 , {75,90,84},  180,4 , 4072,24 , 25,5 , 4,0 , 1748,10 , 1758,9 ,     2,     1,     1,     6,     7 }, // Kazakh/Cyrillic/Kazakhstan
    {     64,     0,   179,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,   171,   187, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 314,18 , 37,5 , 8,10 , 7159,60 , 7219,101 , 1381,27 , 7266,60 , 7326,101 , 134,27 , 4903,35 , 4938,84 , 708,14 , 4903,35 , 4938,84 , 708,14 , 0,2 , 0,2 , {82,87,70},  184,2 , 0,7 , 8,5 , 4,0 , 1767,11 , 1340,6 ,     0,     0,     1,     6,     7 }, // Kinyarwanda/AnyScript/Rwanda
    {     65,     0,   116,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 1381,27 , 1381,27 , 1381,27 , 134,27 , 134,27 , 134,27 , 708,14 , 708,14 , 708,14 , 708,14 , 708,14 , 708,14 , 0,2 , 0,2 , {75,71,83},  186,3 , 0,7 , 8,5 , 4,0 , 1778,6 , 1784,10 ,     2,     1,     1,     6,     7 }, // Kirghiz/AnyScript/Kyrgyzstan
    {     66,     0,   114,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 289,7 , 289,7 , 692,9 , 701,16 , 376,7 , 383,13 , 7320,39 , 7320,39 , 7320,39 , 7427,39 , 7427,39 , 7427,39 , 5022,14 , 5036,28 , 5022,14 , 5022,14 , 5036,28 , 5022,14 , 160,2 , 148,2 , {75,82,87},  189,1 , 4096,13 , 4,4 , 4,0 , 1794,3 , 1797,4 ,     0,     0,     7,     6,     7 }, // Korean/AnyScript/RepublicOfKorea
    {     67,     0,   102,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 7359,105 , 7359,105 , 7464,26 , 7466,105 , 7466,105 , 7571,26 , 5064,58 , 5064,58 , 5122,14 , 5064,58 , 5064,58 , 5122,14 , 0,2 , 0,2 , {73,82,82},  0,0 , 4109,19 , 8,5 , 4,0 , 1801,5 , 1806,5 ,     0,     0,     6,     4,     5 }, // Kurdish/AnyScript/Iran
    {     67,     0,   103,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 7359,105 , 7359,105 , 7464,26 , 7466,105 , 7466,105 , 7571,26 , 5064,58 , 5064,58 , 5122,14 , 5064,58 , 5064,58 , 5122,14 , 0,2 , 0,2 , {73,81,68},  0,0 , 4128,20 , 8,5 , 4,0 , 1801,5 , 1811,5 ,     0,     0,     6,     5,     6 }, // Kurdish/AnyScript/Iraq
    {     67,     0,   207,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 7490,41 , 7531,51 , 7582,27 , 7597,41 , 7638,51 , 7689,27 , 5136,20 , 5156,39 , 5195,14 , 5136,20 , 5156,39 , 5195,14 , 0,2 , 0,2 , {83,89,80},  0,0 , 0,7 , 8,5 , 4,0 , 1816,5 , 0,0 ,     0,     0,     6,     5,     6 }, // Kurdish/AnyScript/SyrianArabRepublic
    {     67,     0,   217,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 7490,41 , 7531,51 , 7582,27 , 7597,41 , 7638,51 , 7689,27 , 5136,20 , 5156,39 , 5195,14 , 5136,20 , 5156,39 , 5195,14 , 0,2 , 0,2 , {84,82,89},  190,2 , 0,7 , 8,5 , 4,0 , 1816,5 , 1821,7 ,     2,     1,     1,     6,     7 }, // Kurdish/AnyScript/Turkey
    {     67,     1,   102,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 7359,105 , 7359,105 , 7464,26 , 7466,105 , 7466,105 , 7571,26 , 5064,58 , 5064,58 , 5122,14 , 5064,58 , 5064,58 , 5122,14 , 0,2 , 0,2 , {73,82,82},  0,0 , 4109,19 , 8,5 , 4,0 , 1801,5 , 1806,5 ,     0,     0,     6,     4,     5 }, // Kurdish/Arabic/Iran
    {     67,     1,   103,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 7359,105 , 7359,105 , 7464,26 , 7466,105 , 7466,105 , 7571,26 , 5064,58 , 5064,58 , 5122,14 , 5064,58 , 5064,58 , 5122,14 , 0,2 , 0,2 , {73,81,68},  0,0 , 4128,20 , 8,5 , 4,0 , 1801,5 , 1811,5 ,     0,     0,     6,     5,     6 }, // Kurdish/Arabic/Iraq
    {     67,     7,   207,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 7490,41 , 7531,51 , 7582,27 , 7597,41 , 7638,51 , 7689,27 , 5136,20 , 5156,39 , 5195,14 , 5136,20 , 5156,39 , 5195,14 , 0,2 , 0,2 , {83,89,80},  0,0 , 0,7 , 8,5 , 4,0 , 1816,5 , 0,0 ,     0,     0,     6,     5,     6 }, // Kurdish/Latin/SyrianArabRepublic
    {     67,     7,   217,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 7490,41 , 7531,51 , 7582,27 , 7597,41 , 7638,51 , 7689,27 , 5136,20 , 5156,39 , 5195,14 , 5136,20 , 5156,39 , 5195,14 , 0,2 , 0,2 , {84,82,89},  190,2 , 0,7 , 8,5 , 4,0 , 1816,5 , 1821,7 ,     2,     1,     1,     6,     7 }, // Kurdish/Latin/Turkey
    {     68,     0,    35,    44,    46,    59,    37,    48,    45,    43,   101,    39,    39,  8221,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 7609,60 , 7669,106 , 1381,27 , 7716,60 , 7776,106 , 134,27 , 5209,34 , 5243,89 , 708,14 , 5209,34 , 5243,89 , 708,14 , 162,5 , 150,5 , {66,73,70},  144,3 , 4148,27 , 0,4 , 4,0 , 1828,8 , 1836,8 ,     0,     0,     1,     6,     7 }, // Rundi/AnyScript/Burundi
    {     69,     0,   117,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,    34,    34, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 717,18 , 165,4 , 396,21 , 7775,63 , 7838,75 , 1381,27 , 7882,63 , 7945,75 , 134,27 , 5332,24 , 5356,57 , 708,14 , 5332,24 , 5356,57 , 708,14 , 0,2 , 0,2 , {76,65,75},  192,1 , 4175,10 , 4,4 , 48,5 , 1844,3 , 1844,3 ,     0,     0,     7,     6,     7 }, // Laothian/AnyScript/Lao
    {     71,     0,   118,    44,   160,    59,    37,    48,  8722,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 296,8 , 296,8 , 332,8 , 735,26 , 37,5 , 8,10 , 7913,65 , 7978,101 , 134,24 , 8020,65 , 8085,101 , 320,24 , 5413,21 , 5434,72 , 5506,14 , 5413,21 , 5434,72 , 5506,14 , 167,14 , 155,11 , {76,86,76},  193,2 , 4185,59 , 25,5 , 4,0 , 1847,8 , 1855,7 ,     2,     1,     1,     6,     7 }, // Latvian/AnyScript/Latvia
    {     72,     0,    49,    44,    46,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 8079,48 , 8127,203 , 8330,24 , 8186,48 , 8234,203 , 8437,24 , 5520,28 , 5548,100 , 5648,14 , 5520,28 , 5548,100 , 5648,14 , 181,8 , 166,6 , {67,68,70},  0,0 , 4244,23 , 25,5 , 4,0 , 1862,7 , 1869,29 ,     2,     1,     1,     6,     7 }, // Lingala/AnyScript/DemocraticRepublicOfCongo
    {     72,     0,    50,    44,    46,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 8079,48 , 8127,203 , 8330,24 , 8186,48 , 8234,203 , 8437,24 , 5520,28 , 5548,100 , 5648,14 , 5520,28 , 5548,100 , 5648,14 , 181,8 , 166,6 , {88,65,70},  195,4 , 4267,23 , 25,5 , 4,0 , 1862,7 , 1898,5 ,     0,     0,     1,     6,     7 }, // Lingala/AnyScript/PeoplesRepublicOfCongo
    {     73,     0,   124,    46,    44,    59,    37,    48,  8722,    43,   101,  8222,  8220,  8222,  8220, 0,6 , 0,6 , 304,8 , 304,8 , 72,10 , 761,27 , 37,5 , 8,10 , 8354,69 , 8423,96 , 8519,24 , 8461,68 , 8529,96 , 8625,24 , 5662,21 , 5683,89 , 5772,14 , 5662,21 , 5683,89 , 5772,14 , 189,9 , 172,6 , {76,84,76},  199,2 , 4290,53 , 25,5 , 4,0 , 1903,8 , 1911,7 ,     2,     1,     1,     6,     7 }, // Lithuanian/AnyScript/Lithuania
    {     74,     0,   127,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 788,7 , 123,18 , 37,5 , 8,10 , 8543,63 , 8606,85 , 8691,24 , 8649,63 , 8712,85 , 8797,24 , 5786,34 , 5820,54 , 1493,14 , 5786,34 , 5820,54 , 1493,14 , 198,10 , 178,8 , {77,75,68},  0,0 , 4343,23 , 8,5 , 4,0 , 1918,10 , 1928,10 ,     2,     1,     1,     6,     7 }, // Macedonian/AnyScript/Macedonia
    {     75,     0,   128,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 8715,48 , 8763,92 , 134,24 , 8821,48 , 8869,92 , 320,24 , 5874,34 , 5908,60 , 5968,14 , 5874,34 , 5908,60 , 5968,14 , 0,2 , 0,2 , {77,71,65},  0,0 , 4366,13 , 4,4 , 4,0 , 1938,8 , 1946,12 ,     0,     0,     1,     6,     7 }, // Malagasy/AnyScript/Madagascar
    {     76,     0,   130,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 239,10 , 249,9 , 547,7 , 10,17 , 18,7 , 25,12 , 8855,49 , 8904,82 , 8986,24 , 8961,49 , 9010,82 , 9092,24 , 5982,28 , 6010,43 , 6053,14 , 5982,28 , 6010,43 , 6053,14 , 208,2 , 186,3 , {77,89,82},  201,2 , 4379,23 , 4,4 , 13,6 , 1958,13 , 1971,8 ,     2,     1,     1,     6,     7 }, // Malay/AnyScript/Malaysia
    {     76,     0,    32,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 239,10 , 249,9 , 547,7 , 560,12 , 18,7 , 25,12 , 8855,49 , 8904,82 , 8986,24 , 8961,49 , 9010,82 , 9092,24 , 5982,28 , 6010,43 , 6053,14 , 5982,28 , 6010,43 , 6053,14 , 208,2 , 186,3 , {66,78,68},  12,1 , 4402,19 , 8,5 , 4,0 , 1958,13 , 1979,6 ,     2,     1,     1,     6,     7 }, // Malay/AnyScript/BruneiDarussalam
    {     77,     0,   100,    46,    44,    59,    37,  3430,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 312,13 , 325,12 , 27,8 , 795,18 , 18,7 , 25,12 , 9010,66 , 9076,101 , 9177,31 , 9116,66 , 9182,101 , 9283,31 , 6067,47 , 6114,70 , 6184,22 , 6067,47 , 6114,70 , 6184,22 , 210,6 , 189,10 , {73,78,82},  203,2 , 4421,46 , 0,4 , 4,0 , 1985,6 , 1991,6 ,     2,     1,     7,     7,     7 }, // Malayalam/AnyScript/India
    {     78,     0,   133,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 813,23 , 37,5 , 8,10 , 9208,48 , 9256,86 , 9342,24 , 9314,48 , 9362,86 , 9448,24 , 6206,28 , 6234,63 , 6297,14 , 6206,28 , 6234,63 , 6297,14 , 216,2 , 199,2 , {69,85,82},  112,1 , 4467,11 , 4,4 , 4,0 , 1997,5 , 774,5 ,     2,     1,     7,     6,     7 }, // Maltese/AnyScript/Malta
    {     80,     0,   100,  1643,  1644,  1563,  1642,  2406,    45,    43,   101,    39,    39,    34,    34, 0,6 , 0,6 , 337,9 , 337,9 , 634,6 , 99,16 , 417,7 , 424,12 , 9366,69 , 9435,86 , 9521,32 , 9472,69 , 9541,86 , 9627,32 , 6311,32 , 6343,53 , 4078,19 , 6311,32 , 6343,53 , 4078,19 , 218,5 , 201,5 , {73,78,82},  205,2 , 4478,19 , 8,5 , 4,0 , 2002,5 , 1640,4 ,     2,     1,     7,     7,     7 }, // Marathi/AnyScript/India
    {     82,     0,   143,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 9553,48 , 9601,66 , 1381,27 , 9659,48 , 9707,66 , 134,27 , 6396,21 , 6417,43 , 708,14 , 6396,21 , 6417,43 , 708,14 , 0,2 , 0,2 , {77,78,84},  207,1 , 0,7 , 8,5 , 4,0 , 2007,6 , 2013,10 ,     0,     0,     1,     6,     7 }, // Mongolian/AnyScript/Mongolia
    {     82,     0,    44,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 1381,27 , 1381,27 , 1381,27 , 134,27 , 134,27 , 134,27 , 708,14 , 708,14 , 708,14 , 708,14 , 708,14 , 708,14 , 0,2 , 0,2 , {67,78,89},  208,3 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Mongolian/AnyScript/China
    {     82,     2,   143,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 9553,48 , 9601,66 , 1381,27 , 9659,48 , 9707,66 , 134,27 , 6396,21 , 6417,43 , 708,14 , 6396,21 , 6417,43 , 708,14 , 0,2 , 0,2 , {77,78,84},  207,1 , 0,7 , 8,5 , 4,0 , 2007,6 , 2013,10 ,     0,     0,     1,     6,     7 }, // Mongolian/Cyrillic/Mongolia
    {     82,     8,    44,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 1381,27 , 1381,27 , 1381,27 , 134,27 , 134,27 , 134,27 , 708,14 , 708,14 , 708,14 , 708,14 , 708,14 , 708,14 , 0,2 , 0,2 , {67,78,89},  208,3 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Mongolian/Mongolian/China
    {     84,     0,   150,    46,    44,    59,  1642,  2406,    45,    43,   101,    39,    39,    34,    34, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 9667,56 , 9723,85 , 9808,27 , 9773,56 , 9829,85 , 9914,27 , 6460,33 , 6493,54 , 6547,14 , 6460,33 , 6493,54 , 6547,14 , 223,14 , 206,14 , {78,80,82},  211,4 , 0,7 , 8,5 , 4,0 , 2023,6 , 2029,5 ,     2,     1,     7,     6,     7 }, // Nepali/AnyScript/Nepal
    {     84,     0,   100,    46,    44,    59,  1642,  2406,    45,    43,   101,    39,    39,    34,    34, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 9667,56 , 9835,80 , 9808,27 , 9773,56 , 9941,80 , 9914,27 , 6460,33 , 6561,54 , 6547,14 , 6460,33 , 6561,54 , 6547,14 , 136,9 , 125,7 , {73,78,82},  114,1 , 4497,49 , 8,5 , 4,0 , 2023,6 , 1640,4 ,     2,     1,     7,     7,     7 }, // Nepali/AnyScript/India
    {     85,     0,   161,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 111,8 , 111,8 , 332,8 , 836,17 , 37,5 , 436,16 , 4293,48 , 9915,83 , 134,24 , 10021,59 , 10080,83 , 320,24 , 6615,28 , 2293,51 , 2344,14 , 6643,35 , 2293,51 , 2344,14 , 0,2 , 0,2 , {78,79,75},  131,2 , 4546,44 , 8,5 , 4,0 , 2034,12 , 2046,5 ,     2,     1,     1,     6,     7 }, // Norwegian/AnyScript/Norway
    {     86,     0,    74,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 9998,83 , 9998,83 , 1381,27 , 10163,83 , 10163,83 , 134,27 , 6678,57 , 6678,57 , 708,14 , 6678,57 , 6678,57 , 708,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1510,11 , 8,5 , 4,0 , 2051,7 , 2058,6 ,     2,     1,     1,     6,     7 }, // Occitan/AnyScript/France
    {     87,     0,   100,    46,    44,  1563,  1642,  2918,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 634,6 , 10,17 , 18,7 , 25,12 , 10081,89 , 10081,89 , 10170,32 , 10246,89 , 10246,89 , 10335,32 , 6735,33 , 6768,54 , 6822,18 , 6735,33 , 6768,54 , 6822,18 , 237,2 , 220,2 , {73,78,82},  114,1 , 4590,11 , 8,5 , 4,0 , 2064,5 , 2069,4 ,     2,     1,     7,     7,     7 }, // Oriya/AnyScript/India
    {     88,     0,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 179,8 , 853,20 , 165,4 , 452,11 , 10202,68 , 10202,68 , 1381,27 , 10367,68 , 10367,68 , 134,27 , 6840,49 , 6840,49 , 708,14 , 6840,49 , 6840,49 , 708,14 , 239,4 , 222,4 , {65,70,78},  215,1 , 4601,13 , 25,5 , 4,0 , 2073,4 , 2077,9 ,     0,     0,     6,     4,     5 }, // Pashto/AnyScript/Afghanistan
    {     89,     0,   102,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,   171,   187,  8249,  8250, 346,7 , 346,7 , 37,8 , 45,7 , 179,8 , 99,16 , 165,4 , 452,11 , 10270,70 , 10270,70 , 10340,24 , 10435,74 , 10435,74 , 10509,24 , 6840,49 , 6840,49 , 6889,14 , 6840,49 , 6840,49 , 6889,14 , 243,9 , 226,8 , {73,82,82},  216,1 , 4614,17 , 25,5 , 53,6 , 2086,5 , 2091,5 ,     0,     0,     6,     4,     5 }, // Persian/AnyScript/Iran
    {     89,     0,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,   171,   187,  8249,  8250, 346,7 , 346,7 , 37,8 , 45,7 , 179,8 , 99,16 , 165,4 , 452,11 , 10270,70 , 10270,70 , 10364,24 , 10533,64 , 10597,68 , 10509,24 , 6840,49 , 6840,49 , 6889,14 , 6840,49 , 6840,49 , 6889,14 , 243,9 , 226,8 , {65,70,78},  215,1 , 4631,23 , 25,5 , 53,6 , 2096,3 , 2077,9 ,     0,     0,     6,     4,     5 }, // Persian/AnyScript/Afghanistan
    {     90,     0,   172,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8222,  8221, 353,6 , 353,6 , 87,7 , 87,7 , 873,10 , 10,17 , 37,5 , 8,10 , 10388,48 , 10436,97 , 10533,24 , 10665,48 , 10713,99 , 10812,24 , 6903,34 , 6937,59 , 6996,14 , 6903,34 , 6937,59 , 6996,14 , 0,2 , 0,2 , {80,76,78},  217,2 , 4654,77 , 25,5 , 4,0 , 2099,6 , 2105,6 ,     2,     1,     1,     6,     7 }, // Polish/AnyScript/Poland
    {     91,     0,   173,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 154,7 , 154,7 , 27,8 , 883,27 , 37,5 , 195,9 , 10557,48 , 10605,89 , 134,24 , 10836,48 , 10884,89 , 320,24 , 7010,28 , 7038,79 , 7117,14 , 7010,28 , 7038,79 , 7117,14 , 61,4 , 59,4 , {69,85,82},  112,1 , 4731,20 , 25,5 , 4,0 , 2111,17 , 2128,8 ,     2,     1,     1,     6,     7 }, // Portuguese/AnyScript/Portugal
    {     91,     0,     6,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 154,7 , 154,7 , 27,8 , 883,27 , 37,5 , 195,9 , 10557,48 , 10605,89 , 134,24 , 10836,48 , 10884,89 , 320,24 , 7010,28 , 7038,79 , 7117,14 , 7010,28 , 7038,79 , 7117,14 , 61,4 , 59,4 , {65,79,65},  219,2 , 4751,54 , 25,5 , 4,0 , 2136,9 , 2145,6 ,     2,     1,     1,     6,     7 }, // Portuguese/AnyScript/Angola
    {     91,     0,    30,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 154,7 , 154,7 , 27,8 , 883,27 , 37,5 , 463,19 , 10694,48 , 10742,89 , 134,24 , 10973,48 , 11021,89 , 320,24 , 7010,28 , 7131,79 , 7117,14 , 7010,28 , 7131,79 , 7117,14 , 0,2 , 0,2 , {66,82,76},  221,2 , 4805,54 , 4,4 , 13,6 , 2151,19 , 2170,6 ,     2,     1,     7,     6,     7 }, // Portuguese/AnyScript/Brazil
    {     91,     0,    92,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 154,7 , 154,7 , 27,8 , 883,27 , 37,5 , 195,9 , 10557,48 , 10605,89 , 134,24 , 10836,48 , 10884,89 , 320,24 , 7010,28 , 7038,79 , 7117,14 , 7010,28 , 7038,79 , 7117,14 , 61,4 , 59,4 , {88,79,70},  168,3 , 4859,62 , 25,5 , 4,0 , 2136,9 , 2176,12 ,     0,     0,     1,     6,     7 }, // Portuguese/AnyScript/GuineaBissau
    {     91,     0,   146,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 154,7 , 154,7 , 27,8 , 883,27 , 37,5 , 195,9 , 10557,48 , 10605,89 , 134,24 , 10836,48 , 10884,89 , 320,24 , 7010,28 , 7038,79 , 7117,14 , 7010,28 , 7038,79 , 7117,14 , 61,4 , 59,4 , {77,90,78},  223,3 , 4921,72 , 25,5 , 4,0 , 2136,9 , 2188,10 ,     2,     1,     7,     6,     7 }, // Portuguese/AnyScript/Mozambique
    {     91,     0,   185,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 154,7 , 154,7 , 27,8 , 883,27 , 37,5 , 195,9 , 10557,48 , 10605,89 , 134,24 , 10836,48 , 10884,89 , 320,24 , 7010,28 , 7038,79 , 7117,14 , 7010,28 , 7038,79 , 7117,14 , 61,4 , 59,4 , {83,84,68},  226,2 , 4993,92 , 25,5 , 4,0 , 2136,9 , 2198,19 ,     0,     0,     1,     6,     7 }, // Portuguese/AnyScript/SaoTomeAndPrincipe
    {     92,     0,   100,  1643,  1644,  1563,  1642,  2662,    45,    43,   101,    39,    39,    34,    34, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 123,18 , 18,7 , 25,12 , 10831,68 , 10831,68 , 10899,27 , 11110,68 , 11110,68 , 11178,27 , 7210,38 , 7248,55 , 7303,23 , 7210,38 , 7248,55 , 7303,23 , 252,11 , 234,11 , {73,78,82},  228,3 , 5085,12 , 8,5 , 4,0 , 2217,6 , 2223,4 ,     2,     1,     7,     7,     7 }, // Punjabi/AnyScript/India
    {     92,     0,   163,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 123,18 , 18,7 , 25,12 , 10926,67 , 10926,67 , 1381,27 , 11205,67 , 11205,67 , 134,27 , 7326,37 , 7326,37 , 708,14 , 7326,37 , 7326,37 , 708,14 , 0,2 , 0,2 , {80,75,82},  231,1 , 5097,13 , 8,5 , 4,0 , 2227,5 , 2232,6 ,     0,     0,     7,     6,     7 }, // Punjabi/AnyScript/Pakistan
    {     92,     1,   163,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 123,18 , 18,7 , 25,12 , 10926,67 , 10926,67 , 1381,27 , 11205,67 , 11205,67 , 134,27 , 7326,37 , 7326,37 , 708,14 , 7326,37 , 7326,37 , 708,14 , 0,2 , 0,2 , {80,75,82},  231,1 , 5097,13 , 8,5 , 4,0 , 2227,5 , 2232,6 ,     0,     0,     7,     6,     7 }, // Punjabi/Arabic/Pakistan
    {     92,     4,   100,  1643,  1644,  1563,  1642,  2662,    45,    43,   101,    39,    39,    34,    34, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 123,18 , 18,7 , 25,12 , 10831,68 , 10831,68 , 10899,27 , 11110,68 , 11110,68 , 11178,27 , 7210,38 , 7248,55 , 7303,23 , 7210,38 , 7248,55 , 7303,23 , 252,11 , 234,11 , {73,78,82},  228,3 , 5085,12 , 8,5 , 4,0 , 2217,6 , 2223,4 ,     2,     1,     7,     7,     7 }, // Punjabi/Gurmukhi/India
    {     94,     0,   206,    46,  8217,    59,    37,    48,  8722,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 0,6 , 0,6 , 332,8 , 498,18 , 37,5 , 8,10 , 10993,67 , 11060,92 , 11152,24 , 11272,67 , 11339,92 , 11431,24 , 7363,23 , 7386,56 , 7442,14 , 7363,23 , 7386,56 , 7442,14 , 237,2 , 245,2 , {67,72,70},  0,0 , 5110,20 , 25,5 , 4,0 , 2238,9 , 2247,6 ,     2,     5,     1,     6,     7 }, // RhaetoRomance/AnyScript/Switzerland
    {     95,     0,   141,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8221,   171,   187, 0,6 , 0,6 , 359,8 , 359,8 , 873,10 , 10,17 , 37,5 , 8,10 , 11176,60 , 11236,98 , 11334,24 , 11455,60 , 11515,98 , 11613,24 , 7456,21 , 7477,48 , 3070,14 , 7456,21 , 7477,48 , 3070,14 , 0,2 , 0,2 , {77,68,76},  232,3 , 5130,69 , 25,5 , 4,0 , 2253,6 , 2259,17 ,     2,     1,     1,     6,     7 }, // Romanian/AnyScript/Moldova
    {     95,     0,   177,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8221,   171,   187, 0,6 , 0,6 , 359,8 , 359,8 , 873,10 , 10,17 , 37,5 , 8,10 , 11176,60 , 11236,98 , 11334,24 , 11455,60 , 11515,98 , 11613,24 , 7456,21 , 7477,48 , 3070,14 , 7456,21 , 7477,48 , 3070,14 , 0,2 , 0,2 , {82,79,78},  0,0 , 5199,57 , 25,5 , 4,0 , 2253,6 , 2276,7 ,     2,     1,     1,     6,     7 }, // Romanian/AnyScript/Romania
    {     96,     0,   178,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 80,7 , 80,7 , 332,8 , 910,22 , 165,4 , 195,9 , 11358,62 , 11420,80 , 11500,24 , 11637,48 , 11685,82 , 11767,24 , 7525,21 , 7546,62 , 7608,14 , 7622,21 , 7643,62 , 7705,16 , 263,10 , 247,13 , {82,85,66},  235,4 , 5256,89 , 25,5 , 4,0 , 2283,7 , 2290,6 ,     2,     1,     1,     6,     7 }, // Russian/AnyScript/RussianFederation
    {     96,     0,   141,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 80,7 , 80,7 , 332,8 , 910,22 , 165,4 , 195,9 , 11358,62 , 11420,80 , 11500,24 , 11637,48 , 11685,82 , 11767,24 , 7525,21 , 7546,62 , 7608,14 , 7622,21 , 7643,62 , 7705,16 , 263,10 , 247,13 , {77,68,76},  232,3 , 5345,79 , 25,5 , 4,0 , 2283,7 , 2296,7 ,     2,     1,     1,     6,     7 }, // Russian/AnyScript/Moldova
    {     96,     0,   222,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8220, 0,6 , 0,6 , 80,7 , 80,7 , 332,8 , 910,22 , 37,5 , 8,10 , 11358,62 , 11420,80 , 11500,24 , 11637,48 , 11685,82 , 11767,24 , 7525,21 , 7546,62 , 7608,14 , 7622,21 , 7643,62 , 7705,16 , 263,10 , 247,13 , {85,65,72},  239,1 , 5424,92 , 25,5 , 4,0 , 2283,7 , 2303,7 ,     2,     1,     1,     6,     7 }, // Russian/AnyScript/Ukraine
    {     98,     0,    41,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 11524,48 , 11572,91 , 11663,24 , 11791,48 , 11839,91 , 11930,24 , 7721,28 , 7749,66 , 7815,14 , 7721,28 , 7749,66 , 7815,14 , 273,2 , 260,2 , {88,65,70},  195,4 , 5516,25 , 4,4 , 48,5 , 2310,5 , 2315,22 ,     0,     0,     1,     6,     7 }, // Sangho/AnyScript/CentralAfricanRepublic
    {    100,     0,   241,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 80,7 , 80,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11687,48 , 11735,81 , 8691,24 , 11954,48 , 12002,81 , 8797,24 , 7829,28 , 7857,52 , 7909,14 , 7829,28 , 7857,52 , 7909,14 , 275,9 , 262,7 , {0,0,0},  0,0 , 5541,0 , 25,5 , 4,0 , 2337,6 , 2343,18 ,     2,     1,     1,     6,     7 }, // Serbian/AnyScript/SerbiaAndMontenegro
    {    100,     0,    27,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 80,7 , 80,7 , 115,8 , 939,20 , 37,5 , 482,40 , 11687,48 , 11816,83 , 8691,24 , 11954,48 , 12083,83 , 8797,24 , 7923,28 , 7951,54 , 7909,14 , 7923,28 , 7951,54 , 7909,14 , 275,9 , 262,7 , {66,65,77},  240,3 , 5541,195 , 25,5 , 4,0 , 2361,6 , 2367,19 ,     2,     1,     1,     6,     7 }, // Serbian/AnyScript/BosniaAndHerzegowina
    {    100,     0,   238,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 80,7 , 80,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11687,48 , 11735,81 , 8691,24 , 11954,48 , 12002,81 , 8797,24 , 7829,28 , 7857,52 , 7909,14 , 7829,28 , 7857,52 , 7909,14 , 275,9 , 262,7 , {0,0,0},  0,0 , 5541,0 , 25,5 , 4,0 , 2337,6 , 0,0 ,     2,     1,     1,     6,     7 }, // Serbian/AnyScript/Yugoslavia
    {    100,     0,   242,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 87,7 , 87,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11899,48 , 11947,81 , 12028,24 , 12166,48 , 12214,81 , 12295,24 , 8005,28 , 8033,54 , 2153,14 , 8005,28 , 8033,54 , 2153,14 , 284,9 , 269,7 , {69,85,82},  112,1 , 5736,27 , 8,5 , 4,0 , 2386,6 , 2392,9 ,     2,     1,     1,     6,     7 }, // Serbian/AnyScript/Montenegro
    {    100,     0,   243,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 80,7 , 80,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11687,48 , 11735,81 , 8691,24 , 11954,48 , 12002,81 , 8797,24 , 7829,28 , 7857,52 , 7909,14 , 7829,28 , 7857,52 , 7909,14 , 275,9 , 262,7 , {82,83,68},  243,4 , 5763,71 , 25,5 , 4,0 , 2337,6 , 2401,6 ,     0,     0,     1,     6,     7 }, // Serbian/AnyScript/Serbia
    {    100,     2,    27,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 80,7 , 80,7 , 115,8 , 939,20 , 37,5 , 482,40 , 11687,48 , 11816,83 , 8691,24 , 11954,48 , 12083,83 , 8797,24 , 7923,28 , 7951,54 , 7909,14 , 7923,28 , 7951,54 , 7909,14 , 275,9 , 262,7 , {66,65,77},  240,3 , 5541,195 , 25,5 , 4,0 , 2361,6 , 2367,19 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/BosniaAndHerzegowina
    {    100,     2,   238,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 80,7 , 80,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11687,48 , 11735,81 , 8691,24 , 11954,48 , 12002,81 , 8797,24 , 7829,28 , 7857,52 , 7909,14 , 7829,28 , 7857,52 , 7909,14 , 275,9 , 262,7 , {0,0,0},  0,0 , 5541,0 , 25,5 , 4,0 , 2337,6 , 0,0 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/Yugoslavia
    {    100,     2,   241,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 80,7 , 80,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11687,48 , 11735,81 , 8691,24 , 11954,48 , 12002,81 , 8797,24 , 7829,28 , 7857,52 , 7909,14 , 7829,28 , 7857,52 , 7909,14 , 275,9 , 262,7 , {0,0,0},  0,0 , 5541,0 , 25,5 , 4,0 , 2337,6 , 2343,18 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/SerbiaAndMontenegro
    {    100,     2,   242,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 80,7 , 80,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11687,48 , 11735,81 , 8691,24 , 11954,48 , 12002,81 , 8797,24 , 7829,28 , 7857,52 , 7909,14 , 7829,28 , 7857,52 , 7909,14 , 275,9 , 262,7 , {69,85,82},  112,1 , 5834,27 , 25,5 , 4,0 , 2337,6 , 2407,9 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/Montenegro
    {    100,     2,   243,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 80,7 , 80,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11687,48 , 11735,81 , 8691,24 , 11954,48 , 12002,81 , 8797,24 , 7829,28 , 7857,52 , 7909,14 , 7829,28 , 7857,52 , 7909,14 , 275,9 , 262,7 , {82,83,68},  243,4 , 5763,71 , 25,5 , 4,0 , 2337,6 , 2401,6 ,     0,     0,     1,     6,     7 }, // Serbian/Cyrillic/Serbia
    {    100,     7,    27,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 87,7 , 87,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11899,48 , 11947,81 , 12028,24 , 12166,48 , 12214,81 , 12295,24 , 8005,28 , 8033,54 , 2153,14 , 8005,28 , 8033,54 , 2153,14 , 284,9 , 269,7 , {66,65,77},  247,2 , 5861,218 , 8,5 , 4,0 , 2386,6 , 2416,19 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/BosniaAndHerzegowina
    {    100,     7,   238,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 87,7 , 87,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11899,48 , 11947,81 , 12028,24 , 12166,48 , 12214,81 , 12295,24 , 8005,28 , 8033,54 , 2153,14 , 8005,28 , 8033,54 , 2153,14 , 284,9 , 269,7 , {0,0,0},  0,0 , 5541,0 , 8,5 , 4,0 , 2386,6 , 0,0 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/Yugoslavia
    {    100,     7,   241,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 87,7 , 87,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11899,48 , 11947,81 , 12028,24 , 12166,48 , 12214,81 , 12295,24 , 8005,28 , 8033,54 , 2153,14 , 8005,28 , 8033,54 , 2153,14 , 284,9 , 269,7 , {0,0,0},  0,0 , 5541,0 , 8,5 , 4,0 , 2386,6 , 2435,18 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/SerbiaAndMontenegro
    {    100,     7,   242,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 87,7 , 87,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11899,48 , 11947,81 , 12028,24 , 12166,48 , 12214,81 , 12295,24 , 8005,28 , 8033,54 , 2153,14 , 8005,28 , 8033,54 , 2153,14 , 284,9 , 269,7 , {69,85,82},  112,1 , 5736,27 , 8,5 , 4,0 , 2386,6 , 2392,9 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/Montenegro
    {    100,     7,   243,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 87,7 , 87,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11899,48 , 11947,81 , 12028,24 , 12166,48 , 12214,81 , 12295,24 , 8005,28 , 8033,54 , 2153,14 , 8005,28 , 8033,54 , 2153,14 , 284,9 , 269,7 , {82,83,68},  249,4 , 6079,71 , 8,5 , 4,0 , 2386,6 , 2453,6 ,     0,     0,     1,     6,     7 }, // Serbian/Latin/Serbia
    {    101,     0,   241,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 87,7 , 87,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11899,48 , 11947,81 , 12028,24 , 12166,48 , 12214,81 , 12295,24 , 8005,28 , 8033,54 , 2153,14 , 8005,28 , 8033,54 , 2153,14 , 284,9 , 269,7 , {0,0,0},  0,0 , 5541,0 , 8,5 , 4,0 , 2459,14 , 2435,18 ,     2,     1,     1,     6,     7 }, // SerboCroatian/AnyScript/SerbiaAndMontenegro
    {    101,     0,    27,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 87,7 , 87,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11899,48 , 11947,81 , 12028,24 , 12166,48 , 12214,81 , 12295,24 , 8005,28 , 8033,54 , 2153,14 , 8005,28 , 8033,54 , 2153,14 , 284,9 , 269,7 , {66,65,77},  247,2 , 5861,218 , 8,5 , 4,0 , 2459,14 , 2416,19 ,     2,     1,     1,     6,     7 }, // SerboCroatian/AnyScript/BosniaAndHerzegowina
    {    101,     0,   238,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 87,7 , 87,7 , 932,7 , 939,20 , 150,5 , 155,10 , 11899,48 , 11947,81 , 12028,24 , 12166,48 , 12214,81 , 12295,24 , 8005,28 , 8033,54 , 2153,14 , 8005,28 , 8033,54 , 2153,14 , 284,9 , 269,7 , {0,0,0},  0,0 , 5541,0 , 8,5 , 4,0 , 2459,14 , 0,0 ,     2,     1,     1,     6,     7 }, // SerboCroatian/AnyScript/Yugoslavia
    {    102,     0,   120,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 12052,48 , 12100,105 , 1381,27 , 12319,48 , 12367,105 , 134,27 , 8087,27 , 8114,61 , 708,14 , 8087,27 , 8114,61 , 708,14 , 0,2 , 0,2 , {90,65,82},  11,1 , 0,7 , 4,4 , 4,0 , 2473,7 , 0,0 ,     2,     1,     1,     6,     7 }, // Sesotho/AnyScript/Lesotho
    {    102,     0,   195,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 12052,48 , 12100,105 , 1381,27 , 12319,48 , 12367,105 , 134,27 , 8087,27 , 8114,61 , 708,14 , 8087,27 , 8114,61 , 708,14 , 0,2 , 0,2 , {90,65,82},  11,1 , 0,7 , 4,4 , 4,0 , 2473,7 , 0,0 ,     2,     1,     7,     6,     7 }, // Sesotho/AnyScript/SouthAfrica
    {    103,     0,   195,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 12205,48 , 12253,117 , 1381,27 , 12472,48 , 12520,117 , 134,27 , 8175,27 , 8202,64 , 708,14 , 8175,27 , 8202,64 , 708,14 , 0,2 , 0,2 , {90,65,82},  11,1 , 0,7 , 4,4 , 4,0 , 2480,8 , 0,0 ,     2,     1,     7,     6,     7 }, // Setswana/AnyScript/SouthAfrica
    {    104,     0,   240,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8221,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 12370,47 , 12417,100 , 12517,24 , 12637,47 , 12684,100 , 12784,24 , 8266,32 , 8298,55 , 8353,14 , 8266,32 , 8298,55 , 8353,14 , 0,2 , 0,2 , {85,83,68},  253,3 , 6150,22 , 4,4 , 13,6 , 2488,8 , 980,8 ,     2,     1,     7,     6,     7 }, // Shona/AnyScript/Zimbabwe
    {    106,     0,   198,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 572,10 , 959,17 , 522,7 , 25,12 , 12541,59 , 12600,96 , 12696,32 , 12808,61 , 12869,96 , 12965,32 , 8367,30 , 8397,62 , 8459,19 , 8367,30 , 8397,62 , 8459,19 , 293,5 , 276,4 , {76,75,82},  256,3 , 6172,19 , 4,4 , 13,6 , 2496,5 , 2501,11 ,     2,     1,     1,     6,     7 }, // Singhalese/AnyScript/SriLanka
    {    107,     0,   195,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 12728,48 , 12776,114 , 1381,27 , 12997,48 , 13045,114 , 134,27 , 8478,27 , 8505,68 , 708,14 , 8478,27 , 8505,68 , 708,14 , 0,2 , 0,2 , {90,65,82},  11,1 , 0,7 , 4,4 , 4,0 , 2512,7 , 0,0 ,     2,     1,     7,     6,     7 }, // Siswati/AnyScript/SouthAfrica
    {    107,     0,   204,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 12728,48 , 12776,114 , 1381,27 , 12997,48 , 13045,114 , 134,27 , 8478,27 , 8505,68 , 708,14 , 8478,27 , 8505,68 , 708,14 , 0,2 , 0,2 , {83,90,76},  259,1 , 0,7 , 4,4 , 4,0 , 2512,7 , 0,0 ,     2,     1,     1,     6,     7 }, // Siswati/AnyScript/Swaziland
    {    108,     0,   191,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,  8218,  8216,  8222,  8220, 0,6 , 0,6 , 104,7 , 104,7 , 582,8 , 498,18 , 165,4 , 195,9 , 12890,48 , 12938,82 , 12028,24 , 13159,48 , 13207,89 , 12295,24 , 8573,21 , 8594,52 , 8646,14 , 8573,21 , 8594,52 , 8646,14 , 298,10 , 280,9 , {69,85,82},  112,1 , 6191,28 , 25,5 , 4,0 , 2519,10 , 2529,19 ,     2,     1,     1,     6,     7 }, // Slovak/AnyScript/Slovakia
    {    109,     0,   192,    44,    46,    59,    37,    48,    45,    43,   101,   187,   171,  8222,  8220, 0,6 , 0,6 , 367,8 , 367,8 , 976,9 , 590,19 , 37,5 , 8,10 , 11899,48 , 13020,86 , 12028,24 , 13296,59 , 13355,86 , 12295,24 , 8660,28 , 8688,52 , 8740,14 , 8754,35 , 8688,52 , 8740,14 , 78,4 , 289,4 , {69,85,82},  112,1 , 6219,28 , 25,5 , 4,0 , 2548,11 , 2559,9 ,     2,     1,     1,     6,     7 }, // Slovenian/AnyScript/Slovenia
    {    110,     0,   194,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 53,19 , 18,7 , 25,12 , 13106,48 , 13154,189 , 13343,24 , 13441,48 , 13489,189 , 13678,24 , 8789,28 , 8817,47 , 8864,14 , 8789,28 , 8817,47 , 8864,14 , 308,3 , 293,3 , {83,79,83},  0,0 , 6247,22 , 4,4 , 4,0 , 2568,8 , 2576,10 ,     0,     0,     1,     6,     7 }, // Somali/AnyScript/Somalia
    {    110,     0,    59,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 53,19 , 18,7 , 25,12 , 13106,48 , 13154,189 , 13343,24 , 13441,48 , 13489,189 , 13678,24 , 8789,28 , 8817,47 , 8864,14 , 8789,28 , 8817,47 , 8864,14 , 308,3 , 293,3 , {68,74,70},  5,3 , 6269,21 , 4,4 , 4,0 , 2568,8 , 2586,7 ,     0,     0,     6,     6,     7 }, // Somali/AnyScript/Djibouti
    {    110,     0,    69,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 53,19 , 18,7 , 25,12 , 13106,48 , 13154,189 , 13343,24 , 13441,48 , 13489,189 , 13678,24 , 8789,28 , 8817,47 , 8864,14 , 8789,28 , 8817,47 , 8864,14 , 308,3 , 293,3 , {69,84,66},  0,2 , 6290,22 , 4,4 , 4,0 , 2568,8 , 2593,8 ,     2,     1,     7,     6,     7 }, // Somali/AnyScript/Ethiopia
    {    110,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 53,19 , 18,7 , 25,12 , 13106,48 , 13154,189 , 13343,24 , 13441,48 , 13489,189 , 13678,24 , 8789,28 , 8817,47 , 8864,14 , 8789,28 , 8817,47 , 8864,14 , 308,3 , 293,3 , {75,69,83},  2,3 , 0,7 , 4,4 , 4,0 , 2568,8 , 2601,7 ,     2,     1,     7,     6,     7 }, // Somali/AnyScript/Kenya
    {    111,     0,   197,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {69,85,82},  112,1 , 1620,20 , 8,5 , 4,0 , 2608,17 , 1412,6 ,     2,     1,     1,     6,     7 }, // Spanish/AnyScript/Spain
    {    111,     0,    10,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 985,26 , 37,5 , 529,14 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {65,82,83},  12,1 , 6312,51 , 4,4 , 4,0 , 2625,7 , 2632,9 ,     2,     1,     7,     6,     7 }, // Spanish/AnyScript/Argentina
    {    111,     0,    26,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {66,79,66},  260,2 , 6363,35 , 4,4 , 4,0 , 2625,7 , 2641,7 ,     2,     1,     1,     6,     7 }, // Spanish/AnyScript/Bolivia
    {    111,     0,    43,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 539,8 , 985,26 , 165,4 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {67,76,80},  12,1 , 6398,45 , 4,4 , 48,5 , 2625,7 , 2648,5 ,     0,     0,     1,     6,     7 }, // Spanish/AnyScript/Chile
    {    111,     0,    47,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 547,7 , 985,26 , 165,4 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {67,79,80},  12,1 , 6443,54 , 4,4 , 4,0 , 2625,7 , 2653,8 ,     0,     0,     7,     6,     7 }, // Spanish/AnyScript/Colombia
    {    111,     0,    52,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {67,82,67},  262,1 , 6497,67 , 4,4 , 4,0 , 2625,7 , 2661,10 ,     0,     0,     1,     6,     7 }, // Spanish/AnyScript/CostaRica
    {    111,     0,    61,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {68,79,80},  12,1 , 6564,54 , 4,4 , 4,0 , 2625,7 , 2671,20 ,     2,     1,     7,     6,     7 }, // Spanish/AnyScript/DominicanRepublic
    {    111,     0,    63,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 985,26 , 165,4 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {85,83,68},  12,1 , 6618,70 , 4,4 , 48,5 , 2625,7 , 2691,7 ,     2,     1,     1,     6,     7 }, // Spanish/AnyScript/Ecuador
    {    111,     0,    65,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {85,83,68},  253,3 , 6618,70 , 4,4 , 4,0 , 2625,7 , 2698,11 ,     2,     1,     7,     6,     7 }, // Spanish/AnyScript/ElSalvador
    {    111,     0,    66,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {88,65,70},  195,4 , 6688,53 , 4,4 , 4,0 , 2625,7 , 2709,17 ,     0,     0,     1,     6,     7 }, // Spanish/AnyScript/EquatorialGuinea
    {    111,     0,    90,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 547,7 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {71,84,81},  263,1 , 6741,70 , 4,4 , 4,0 , 2625,7 , 2726,9 ,     2,     1,     7,     6,     7 }, // Spanish/AnyScript/Guatemala
    {    111,     0,    96,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 1011,27 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {72,78,76},  264,1 , 6811,60 , 4,4 , 4,0 , 2625,7 , 2735,8 ,     2,     1,     7,     6,     7 }, // Spanish/AnyScript/Honduras
    {    111,     0,   139,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {77,88,78},  12,1 , 6871,48 , 4,4 , 4,0 , 2625,7 , 2743,6 ,     2,     1,     7,     6,     7 }, // Spanish/AnyScript/Mexico
    {    111,     0,   155,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {78,73,79},  265,2 , 6919,69 , 4,4 , 4,0 , 2625,7 , 2749,9 ,     2,     1,     7,     6,     7 }, // Spanish/AnyScript/Nicaragua
    {    111,     0,   166,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 187,8 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {80,65,66},  267,3 , 6988,54 , 4,4 , 4,0 , 2625,7 , 2758,6 ,     2,     1,     7,     6,     7 }, // Spanish/AnyScript/Panama
    {    111,     0,   168,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {80,89,71},  270,1 , 7042,61 , 8,5 , 59,6 , 2625,7 , 2764,8 ,     0,     0,     7,     6,     7 }, // Spanish/AnyScript/Paraguay
    {    111,     0,   169,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 547,7 , 985,26 , 37,5 , 543,15 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {80,69,78},  271,3 , 7103,62 , 4,4 , 4,0 , 2625,7 , 2772,4 ,     2,     1,     7,     6,     7 }, // Spanish/AnyScript/Peru
    {    111,     0,   174,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 187,8 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {85,83,68},  12,1 , 6618,70 , 4,4 , 4,0 , 2625,7 , 2776,11 ,     2,     1,     7,     6,     7 }, // Spanish/AnyScript/PuertoRico
    {    111,     0,   225,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 554,6 , 985,26 , 18,7 , 25,12 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {85,83,68},  12,1 , 6618,70 , 4,4 , 4,0 , 2625,7 , 2787,14 ,     2,     1,     7,     6,     7 }, // Spanish/AnyScript/UnitedStates
    {    111,     0,   227,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {85,89,85},  12,1 , 7165,48 , 8,5 , 65,7 , 2625,7 , 2801,7 ,     2,     1,     1,     6,     7 }, // Spanish/AnyScript/Uruguay
    {    111,     0,   231,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {86,69,70},  274,5 , 7213,64 , 4,4 , 48,5 , 2625,7 , 2808,9 ,     2,     1,     7,     6,     7 }, // Spanish/AnyScript/Venezuela
    {    111,     0,   246,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 375,7 , 375,7 , 27,8 , 985,26 , 37,5 , 8,10 , 13367,49 , 13416,89 , 13505,24 , 13702,48 , 13750,89 , 13839,24 , 8878,28 , 8906,53 , 3070,14 , 8878,28 , 8906,53 , 3070,14 , 61,4 , 59,4 , {0,0,0},  0,0 , 5541,0 , 4,4 , 4,0 , 2817,23 , 2840,13 ,     2,     1,     1,     6,     7 }, // Spanish/AnyScript/LatinAmericaAndTheCaribbean
    {    113,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,    39,    39, 0,6 , 0,6 , 382,9 , 391,8 , 141,10 , 10,17 , 18,7 , 25,12 , 13529,48 , 13577,84 , 134,24 , 13863,48 , 13911,84 , 320,24 , 8959,22 , 8981,60 , 9041,14 , 8959,22 , 8981,60 , 9041,14 , 311,7 , 296,7 , {75,69,83},  2,3 , 7277,24 , 4,4 , 4,0 , 2853,9 , 2862,5 ,     2,     1,     7,     6,     7 }, // Swahili/AnyScript/Kenya
    {    113,     0,   210,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,    39,    39, 0,6 , 0,6 , 382,9 , 391,8 , 141,10 , 10,17 , 18,7 , 25,12 , 13529,48 , 13577,84 , 134,24 , 13863,48 , 13911,84 , 320,24 , 8959,22 , 8981,60 , 9041,14 , 8959,22 , 8981,60 , 9041,14 , 311,7 , 296,7 , {84,90,83},  279,3 , 7301,27 , 25,5 , 4,0 , 2853,9 , 2867,8 ,     0,     0,     1,     6,     7 }, // Swahili/AnyScript/Tanzania
    {    114,     0,   205,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 399,9 , 399,9 , 72,10 , 1038,30 , 37,5 , 436,16 , 3581,48 , 13661,86 , 134,24 , 5619,48 , 13995,86 , 320,24 , 9055,28 , 9083,50 , 2344,14 , 9133,29 , 9083,50 , 2344,14 , 318,2 , 303,2 , {83,69,75},  131,2 , 7328,45 , 25,5 , 4,0 , 2875,7 , 2882,7 ,     2,     1,     1,     6,     7 }, // Swedish/AnyScript/Sweden
    {    114,     0,    73,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 399,9 , 399,9 , 72,10 , 1038,30 , 37,5 , 436,16 , 3581,48 , 13661,86 , 134,24 , 5619,48 , 13995,86 , 320,24 , 9055,28 , 9083,50 , 2344,14 , 9133,29 , 9083,50 , 2344,14 , 318,2 , 303,2 , {69,85,82},  112,1 , 7373,19 , 25,5 , 4,0 , 2875,7 , 2889,7 ,     2,     1,     1,     6,     7 }, // Swedish/AnyScript/Finland
    {    115,     0,   170,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 408,8 , 408,8 , 554,6 , 1068,18 , 37,5 , 8,10 , 13747,48 , 13795,88 , 13883,24 , 14081,48 , 14129,88 , 14217,24 , 9162,28 , 9190,55 , 9245,14 , 9259,28 , 9190,55 , 9245,14 , 0,2 , 0,2 , {80,72,80},  139,1 , 7392,22 , 8,5 , 4,0 , 2896,7 , 2903,9 ,     2,     1,     7,     6,     7 }, // Tagalog/AnyScript/Philippines
    {    116,     0,   209,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,   171,  8222, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 314,18 , 37,5 , 8,10 , 13907,48 , 13955,71 , 1381,27 , 14241,48 , 14289,71 , 134,27 , 9287,28 , 9315,55 , 708,14 , 9287,28 , 9315,55 , 708,14 , 0,2 , 0,2 , {84,74,83},  186,3 , 7414,13 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Tajik/AnyScript/Tajikistan
    {    116,     2,   209,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,   171,  8222, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 314,18 , 37,5 , 8,10 , 13907,48 , 13955,71 , 1381,27 , 14241,48 , 14289,71 , 134,27 , 9287,28 , 9315,55 , 708,14 , 9287,28 , 9315,55 , 708,14 , 0,2 , 0,2 , {84,74,83},  186,3 , 7414,13 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Tajik/Cyrillic/Tajikistan
    {    117,     0,   100,    46,    44,  1563,  1642,  3046,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 416,13 , 416,13 , 634,6 , 203,18 , 18,7 , 25,12 , 14026,58 , 14084,86 , 14170,31 , 14360,58 , 14418,86 , 14504,31 , 9370,20 , 9390,49 , 9370,20 , 9370,20 , 9390,49 , 9370,20 , 320,8 , 305,8 , {73,78,82},  114,1 , 7427,13 , 8,5 , 4,0 , 2912,5 , 2917,7 ,     2,     1,     7,     7,     7 }, // Tamil/AnyScript/India
    {    117,     0,   198,    46,    44,  1563,  1642,  3046,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 416,13 , 416,13 , 634,6 , 203,18 , 18,7 , 25,12 , 14026,58 , 14084,86 , 14170,31 , 14360,58 , 14418,86 , 14504,31 , 9370,20 , 9390,49 , 9370,20 , 9370,20 , 9390,49 , 9370,20 , 320,8 , 305,8 , {76,75,82},  282,3 , 7440,20 , 8,5 , 4,0 , 2912,5 , 2924,6 ,     2,     1,     1,     6,     7 }, // Tamil/AnyScript/SriLanka
    {    119,     0,   100,  1643,  1644,  1563,  1642,  3174,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 429,11 , 429,11 , 539,8 , 99,16 , 18,7 , 25,12 , 14201,78 , 14279,86 , 14365,30 , 14535,78 , 14613,86 , 14699,31 , 9439,32 , 9471,60 , 9531,18 , 9439,32 , 9471,60 , 9531,18 , 328,10 , 313,8 , {73,78,82},  285,3 , 7460,13 , 8,5 , 4,0 , 2930,6 , 2936,9 ,     2,     1,     7,     7,     7 }, // Telugu/AnyScript/India
    {    120,     0,   211,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 440,5 , 440,5 , 445,8 , 453,7 , 364,8 , 1086,19 , 165,4 , 558,27 , 14395,63 , 14458,98 , 14395,63 , 14730,63 , 14793,98 , 14891,62 , 9549,23 , 9572,68 , 9640,14 , 9549,23 , 9572,68 , 9640,14 , 338,10 , 321,10 , {84,72,66},  288,1 , 7473,13 , 4,4 , 48,5 , 2945,3 , 2945,3 ,     2,     1,     7,     6,     7 }, // Thai/AnyScript/Thailand
    {    121,     0,    44,    46,    44,  1563,  1642,  3872,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 14556,63 , 14619,158 , 1381,27 , 14953,63 , 15016,158 , 134,27 , 9654,51 , 9705,79 , 9784,21 , 9805,49 , 9854,77 , 9931,22 , 348,7 , 331,8 , {67,78,89},  208,3 , 7486,13 , 8,5 , 4,0 , 2948,8 , 2956,6 ,     2,     1,     7,     6,     7 }, // Tibetan/AnyScript/China
    {    121,     0,   100,    46,    44,  1563,  1642,  3872,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 14556,63 , 14619,158 , 1381,27 , 14953,63 , 15016,158 , 134,27 , 9654,51 , 9705,79 , 9784,21 , 9805,49 , 9854,77 , 9931,22 , 348,7 , 331,8 , {73,78,82},  114,1 , 7499,22 , 8,5 , 4,0 , 2948,8 , 2962,7 ,     2,     1,     7,     7,     7 }, // Tibetan/AnyScript/India
    {    122,     0,    67,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 1105,23 , 18,7 , 25,12 , 14777,46 , 14823,54 , 1024,24 , 15174,46 , 15220,54 , 1051,24 , 9953,29 , 9953,29 , 9982,14 , 9953,29 , 9953,29 , 9982,14 , 355,7 , 339,7 , {69,82,78},  8,3 , 0,7 , 4,4 , 4,0 , 2969,4 , 2973,4 ,     2,     1,     1,     6,     7 }, // Tigrinya/AnyScript/Eritrea
    {    122,     0,    69,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 1128,23 , 18,7 , 25,12 , 916,46 , 962,62 , 1024,24 , 943,46 , 989,62 , 1051,24 , 9996,29 , 9996,29 , 9982,14 , 9996,29 , 9996,29 , 9982,14 , 355,7 , 339,7 , {69,84,66},  0,2 , 81,16 , 4,4 , 4,0 , 2969,4 , 96,5 ,     2,     1,     7,     6,     7 }, // Tigrinya/AnyScript/Ethiopia
    {    123,     0,   214,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,   171,   187, 0,6 , 0,6 , 0,6 , 0,6 , 279,6 , 99,16 , 37,5 , 8,10 , 14877,51 , 14928,87 , 15015,24 , 15274,51 , 15325,87 , 15412,24 , 10025,29 , 10054,60 , 10114,14 , 10025,29 , 10054,60 , 10114,14 , 0,2 , 0,2 , {84,79,80},  289,2 , 0,7 , 8,5 , 4,0 , 2977,13 , 2990,5 ,     2,     1,     1,     6,     7 }, // Tonga/AnyScript/Tonga
    {    124,     0,   195,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 15039,48 , 15087,122 , 1381,27 , 15436,48 , 15484,122 , 134,27 , 10128,27 , 10155,72 , 708,14 , 10128,27 , 10155,72 , 708,14 , 0,2 , 0,2 , {90,65,82},  11,1 , 0,7 , 4,4 , 4,0 , 2995,8 , 0,0 ,     2,     1,     7,     6,     7 }, // Tsonga/AnyScript/SouthAfrica
    {    125,     0,   217,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 460,8 , 460,8 , 873,10 , 1151,16 , 37,5 , 8,10 , 15209,48 , 15257,75 , 15332,24 , 15606,48 , 15654,75 , 15729,24 , 10227,28 , 10255,54 , 10309,14 , 10227,28 , 10255,54 , 10309,14 , 0,2 , 0,2 , {84,82,89},  190,2 , 7521,18 , 25,5 , 4,0 , 3003,6 , 3009,7 ,     2,     1,     1,     6,     7 }, // Turkish/AnyScript/Turkey
    {    129,     0,   222,    44,   160,    59,    37,    48,    45,    43,  1077,   171,   187,  8222,  8220, 0,6 , 0,6 , 468,8 , 468,8 , 332,8 , 1167,22 , 37,5 , 8,10 , 15356,48 , 15404,95 , 15499,24 , 15753,67 , 15820,87 , 15907,24 , 10323,21 , 10344,56 , 10400,14 , 10323,21 , 10344,56 , 10400,14 , 362,2 , 346,2 , {85,65,72},  239,1 , 7539,49 , 25,5 , 4,0 , 3016,10 , 3026,7 ,     2,     1,     1,     6,     7 }, // Ukrainian/AnyScript/Ukraine
    {    130,     0,   100,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,    34,    34,    39,    39, 31,6 , 31,6 , 476,10 , 486,9 , 279,6 , 1189,18 , 18,7 , 25,12 , 15523,67 , 15523,67 , 1381,27 , 15931,67 , 15931,67 , 134,27 , 10414,36 , 10414,36 , 708,14 , 10414,36 , 10414,36 , 708,14 , 364,2 , 348,3 , {73,78,82},  114,1 , 7588,18 , 8,5 , 4,0 , 3033,4 , 3037,5 ,     2,     1,     7,     7,     7 }, // Urdu/AnyScript/India
    {    130,     0,   163,    46,    44,    59,    37,    48,    45,    43,   101,    34,    34,    39,    39, 31,6 , 31,6 , 476,10 , 486,9 , 279,6 , 1189,18 , 18,7 , 25,12 , 15523,67 , 15523,67 , 1381,27 , 15931,67 , 15931,67 , 134,27 , 10414,36 , 10414,36 , 708,14 , 10414,36 , 10414,36 , 708,14 , 364,2 , 348,3 , {80,75,82},  291,4 , 7606,21 , 4,4 , 4,0 , 3033,4 , 3042,7 ,     0,     0,     7,     6,     7 }, // Urdu/AnyScript/Pakistan
    {    131,     0,   228,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 314,18 , 37,5 , 8,10 , 13907,48 , 15590,115 , 11500,24 , 14241,48 , 15998,115 , 11767,24 , 10450,28 , 10478,53 , 10531,14 , 10450,28 , 10478,53 , 10531,14 , 0,2 , 0,2 , {85,90,83},  295,3 , 7627,21 , 8,5 , 4,0 , 3049,5 , 3054,10 ,     0,     0,     1,     6,     7 }, // Uzbek/AnyScript/Uzbekistan
    {    131,     0,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 179,8 , 1207,33 , 165,4 , 452,11 , 15705,48 , 15753,68 , 1381,27 , 16113,48 , 10597,68 , 134,27 , 10545,21 , 6840,49 , 708,14 , 10545,21 , 6840,49 , 708,14 , 0,2 , 0,2 , {65,70,78},  215,1 , 7648,13 , 25,5 , 4,0 , 3064,6 , 2077,9 ,     0,     0,     6,     4,     5 }, // Uzbek/AnyScript/Afghanistan
    {    131,     1,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 179,8 , 1207,33 , 165,4 , 452,11 , 15705,48 , 15753,68 , 1381,27 , 16113,48 , 10597,68 , 134,27 , 10545,21 , 6840,49 , 708,14 , 10545,21 , 6840,49 , 708,14 , 0,2 , 0,2 , {65,70,78},  215,1 , 7648,13 , 25,5 , 4,0 , 3064,6 , 2077,9 ,     0,     0,     6,     4,     5 }, // Uzbek/Arabic/Afghanistan
    {    131,     2,   228,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 314,18 , 37,5 , 8,10 , 13907,48 , 15590,115 , 11500,24 , 14241,48 , 15998,115 , 11767,24 , 10450,28 , 10478,53 , 10531,14 , 10450,28 , 10478,53 , 10531,14 , 0,2 , 0,2 , {85,90,83},  295,3 , 7627,21 , 8,5 , 4,0 , 3049,5 , 3054,10 ,     0,     0,     1,     6,     7 }, // Uzbek/Cyrillic/Uzbekistan
    {    131,     7,   228,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 314,18 , 37,5 , 8,10 , 15821,52 , 15873,77 , 15950,24 , 16161,52 , 16213,77 , 16290,24 , 10566,34 , 10600,61 , 10661,14 , 10566,34 , 10600,61 , 10661,14 , 0,2 , 0,2 , {85,90,83},  298,4 , 7661,23 , 8,5 , 4,0 , 3070,9 , 3079,11 ,     0,     0,     1,     6,     7 }, // Uzbek/Latin/Uzbekistan
    {    132,     0,   232,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 495,8 , 495,8 , 141,10 , 1240,31 , 37,5 , 8,10 , 15974,75 , 16049,130 , 1381,27 , 16314,75 , 16389,130 , 134,27 , 10675,33 , 10708,55 , 10763,21 , 10675,33 , 10708,55 , 10763,21 , 366,2 , 351,2 , {86,78,68},  302,1 , 7684,11 , 25,5 , 4,0 , 3090,10 , 3100,8 ,     0,     0,     1,     6,     7 }, // Vietnamese/AnyScript/VietNam
    {    134,     0,   224,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 37,5 , 8,10 , 16179,53 , 16232,87 , 16319,24 , 16519,62 , 16581,86 , 16667,24 , 10784,29 , 10813,77 , 10890,14 , 10904,30 , 10813,77 , 10890,14 , 0,2 , 0,2 , {71,66,80},  140,1 , 7695,28 , 4,4 , 4,0 , 3108,7 , 3115,12 ,     2,     1,     1,     6,     7 }, // Welsh/AnyScript/UnitedKingdom
    {    136,     0,   195,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 16343,48 , 16391,91 , 1381,27 , 16691,48 , 16739,91 , 134,27 , 10934,28 , 10962,61 , 708,14 , 10934,28 , 10962,61 , 708,14 , 0,2 , 0,2 , {90,65,82},  11,1 , 0,7 , 4,4 , 4,0 , 3127,8 , 0,0 ,     2,     1,     7,     6,     7 }, // Xhosa/AnyScript/SouthAfrica
    {    138,     0,   157,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,    39,    39, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 16482,73 , 16555,121 , 1381,27 , 16830,73 , 16903,121 , 134,27 , 11023,44 , 11067,69 , 708,14 , 11023,44 , 11067,69 , 708,14 , 368,5 , 353,5 , {78,71,78},  171,1 , 7723,34 , 4,4 , 13,6 , 3135,10 , 3145,18 ,     2,     1,     1,     6,     7 }, // Yoruba/AnyScript/Nigeria
    {    140,     0,   195,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 503,9 , 512,10 , 72,10 , 82,17 , 18,7 , 25,12 , 16676,48 , 16724,104 , 134,24 , 17024,48 , 17072,90 , 320,24 , 11136,28 , 11164,68 , 11232,14 , 11136,28 , 11164,68 , 11232,14 , 0,2 , 0,2 , {90,65,82},  11,1 , 7757,27 , 4,4 , 4,0 , 3163,7 , 3170,17 ,     2,     1,     7,     6,     7 }, // Zulu/AnyScript/SouthAfrica
    {    141,     0,   161,    44,   160,    59,    37,    48,  8722,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 111,8 , 111,8 , 332,8 , 836,17 , 37,5 , 436,16 , 4293,48 , 9915,83 , 134,24 , 10021,59 , 10080,83 , 320,24 , 11246,28 , 11274,51 , 2344,14 , 11325,28 , 11274,51 , 2344,14 , 373,9 , 358,11 , {78,79,75},  131,2 , 7784,42 , 25,5 , 4,0 , 3187,7 , 3194,5 ,     2,     1,     1,     6,     7 }, // Nynorsk/AnyScript/Norway
    {    142,     0,    27,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 1271,9 , 939,20 , 37,5 , 8,10 , 11899,48 , 16828,83 , 12028,24 , 12166,48 , 17162,83 , 12295,24 , 2067,28 , 2095,58 , 708,14 , 2067,28 , 2095,58 , 708,14 , 0,2 , 0,2 , {66,65,77},  247,2 , 5861,218 , 8,5 , 4,0 , 3199,8 , 2416,19 ,     2,     1,     1,     6,     7 }, // Bosnian/AnyScript/BosniaAndHerzegowina
    {    144,     0,   224,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 82,17 , 37,5 , 8,10 , 16911,102 , 17013,140 , 1381,27 , 17245,102 , 17347,140 , 134,27 , 11353,30 , 11383,57 , 708,14 , 11353,30 , 11383,57 , 708,14 , 61,4 , 59,4 , {71,66,80},  140,1 , 0,7 , 4,4 , 4,0 , 3207,5 , 3212,14 ,     2,     1,     1,     6,     7 }, // Manx/AnyScript/UnitedKingdom
    {    145,     0,   224,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 99,16 , 37,5 , 8,10 , 17153,46 , 17199,124 , 1381,27 , 17487,46 , 17533,124 , 134,27 , 11440,28 , 11468,60 , 708,14 , 11440,28 , 11468,60 , 708,14 , 61,4 , 59,4 , {71,66,80},  140,1 , 0,7 , 4,4 , 4,0 , 3226,8 , 3212,14 ,     2,     1,     1,     6,     7 }, // Cornish/AnyScript/UnitedKingdom
    {    146,     0,    83,    46,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 314,18 , 37,5 , 8,10 , 17323,48 , 17371,192 , 1381,27 , 17657,48 , 17705,192 , 134,27 , 11528,28 , 11556,49 , 11605,14 , 11528,28 , 11556,49 , 11605,14 , 382,2 , 369,2 , {71,72,83},  0,0 , 0,7 , 4,4 , 4,0 , 3234,4 , 3238,5 ,     2,     1,     1,     6,     7 }, // Akan/AnyScript/Ghana
    {    147,     0,   100,  1643,  1644,  1563,  1642,  2406,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 634,6 , 99,16 , 18,7 , 25,12 , 17563,87 , 17563,87 , 1381,27 , 17897,87 , 17897,87 , 134,27 , 6311,32 , 11619,55 , 708,14 , 6311,32 , 11619,55 , 708,14 , 218,5 , 201,5 , {73,78,82},  205,2 , 0,7 , 8,5 , 4,0 , 3243,6 , 1640,4 ,     2,     1,     7,     7,     7 }, // Konkani/AnyScript/India
    {    148,     0,    83,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,    34,    34, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 314,18 , 37,5 , 8,10 , 17650,48 , 17698,94 , 1381,27 , 17984,48 , 18032,94 , 134,27 , 11674,26 , 11700,34 , 708,14 , 11674,26 , 11700,34 , 708,14 , 0,2 , 0,2 , {71,72,83},  0,0 , 0,7 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Ga/AnyScript/Ghana
    {    149,     0,   157,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 17792,48 , 17840,86 , 1381,27 , 18126,48 , 18174,86 , 134,27 , 11734,29 , 11763,57 , 708,14 , 11734,29 , 11763,57 , 708,14 , 384,4 , 371,4 , {78,71,78},  171,1 , 7826,12 , 4,4 , 13,6 , 3249,4 , 3253,7 ,     2,     1,     1,     6,     7 }, // Igbo/AnyScript/Nigeria
    {    150,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 17926,48 , 17974,189 , 18163,24 , 18260,48 , 18308,189 , 18497,24 , 11820,28 , 11848,74 , 11922,14 , 11820,28 , 11848,74 , 11922,14 , 388,9 , 375,7 , {75,69,83},  2,3 , 7838,23 , 4,4 , 13,6 , 3260,7 , 2862,5 ,     2,     1,     7,     6,     7 }, // Kamba/AnyScript/Kenya
    {    152,     0,    67,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 1280,22 , 18,7 , 25,12 , 18187,47 , 18234,77 , 18311,24 , 18521,47 , 18568,77 , 18645,24 , 11936,26 , 11962,43 , 12005,14 , 11936,26 , 11962,43 , 12005,14 , 0,2 , 0,2 , {69,82,78},  8,3 , 0,7 , 4,4 , 4,0 , 3267,3 , 2973,4 ,     2,     1,     1,     6,     7 }, // Blin/AnyScript/Eritrea
    {    155,     0,    69,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 53,19 , 18,7 , 25,12 , 1381,27 , 1381,27 , 1381,27 , 134,27 , 134,27 , 134,27 , 12019,28 , 12047,51 , 12098,14 , 12019,28 , 12047,51 , 12098,14 , 0,2 , 0,2 , {69,84,66},  0,2 , 0,7 , 4,4 , 4,0 , 3270,11 , 3281,11 ,     2,     1,     7,     6,     7 }, // Sidamo/AnyScript/Ethiopia
    {    156,     0,   157,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 314,18 , 37,5 , 8,10 , 18335,59 , 18394,129 , 1381,27 , 18669,59 , 18728,129 , 134,27 , 12112,35 , 12147,87 , 708,14 , 12112,35 , 12147,87 , 708,14 , 0,2 , 0,2 , {78,71,78},  171,1 , 7861,11 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Atsam/AnyScript/Nigeria
    {    157,     0,    67,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 1302,21 , 18,7 , 25,12 , 916,46 , 962,62 , 1024,24 , 943,46 , 989,62 , 1051,24 , 12234,27 , 12261,41 , 12302,14 , 12234,27 , 12261,41 , 12302,14 , 0,2 , 0,2 , {69,82,78},  8,3 , 0,7 , 4,4 , 4,0 , 3292,3 , 2973,4 ,     2,     1,     1,     6,     7 }, // Tigre/AnyScript/Eritrea
    {    158,     0,   157,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 314,18 , 37,5 , 8,10 , 18523,57 , 18580,178 , 1381,27 , 18857,57 , 18914,178 , 134,27 , 12316,28 , 12344,44 , 708,14 , 12316,28 , 12344,44 , 708,14 , 0,2 , 0,2 , {78,71,78},  171,1 , 7872,14 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Jju/AnyScript/Nigeria
    {    159,     0,   106,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 154,7 , 154,7 , 27,8 , 1323,27 , 37,5 , 8,10 , 18758,48 , 18806,77 , 18883,24 , 19092,48 , 19140,77 , 19217,24 , 12388,28 , 12416,50 , 3070,14 , 12388,28 , 12416,50 , 3070,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 1620,20 , 8,5 , 4,0 , 3295,6 , 3301,6 ,     2,     1,     1,     6,     7 }, // Friulian/AnyScript/Italy
    {    160,     0,   195,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 18907,48 , 18955,111 , 1381,27 , 19241,48 , 19289,111 , 134,27 , 12466,27 , 12493,70 , 708,14 , 12466,27 , 12493,70 , 708,14 , 0,2 , 0,2 , {90,65,82},  11,1 , 0,7 , 4,4 , 4,0 , 3307,9 , 0,0 ,     2,     1,     7,     6,     7 }, // Venda/AnyScript/SouthAfrica
    {    161,     0,    83,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8220, 0,6 , 0,6 , 522,11 , 533,10 , 141,10 , 10,17 , 376,7 , 585,12 , 19066,48 , 19114,87 , 19201,24 , 19400,48 , 19448,87 , 19535,24 , 12563,28 , 12591,44 , 12635,14 , 12563,28 , 12591,44 , 12635,14 , 397,3 , 382,5 , {71,72,83},  0,0 , 7886,37 , 4,4 , 13,6 , 3316,6 , 3322,12 ,     2,     1,     1,     6,     7 }, // Ewe/AnyScript/Ghana
    {    161,     0,   212,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8220, 0,6 , 0,6 , 522,11 , 533,10 , 141,10 , 10,17 , 376,7 , 585,12 , 19066,48 , 19114,87 , 19201,24 , 19400,48 , 19448,87 , 19535,24 , 12563,28 , 12591,44 , 12635,14 , 12563,28 , 12591,44 , 12635,14 , 397,3 , 382,5 , {88,79,70},  168,3 , 7923,77 , 4,4 , 13,6 , 3316,6 , 3334,11 ,     0,     0,     1,     6,     7 }, // Ewe/AnyScript/Togo
    {    162,     0,    69,    46,  8217,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 1350,22 , 18,7 , 25,12 , 916,46 , 962,62 , 1024,24 , 943,46 , 989,62 , 1051,24 , 12649,27 , 12649,27 , 12676,14 , 12649,27 , 12649,27 , 12676,14 , 0,2 , 0,2 , {69,84,66},  0,2 , 81,16 , 4,4 , 4,0 , 3345,5 , 96,5 ,     2,     1,     7,     6,     7 }, // Walamo/AnyScript/Ethiopia
    {    163,     0,   225,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 279,6 , 10,17 , 18,7 , 25,12 , 19225,59 , 19284,95 , 1381,27 , 19559,59 , 19618,95 , 134,27 , 12690,21 , 12711,57 , 708,14 , 12690,21 , 12711,57 , 708,14 , 0,2 , 0,2 , {85,83,68},  253,3 , 0,7 , 4,4 , 13,6 , 3350,14 , 3364,19 ,     2,     1,     7,     6,     7 }, // Hawaiian/AnyScript/UnitedStates
    {    164,     0,   157,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 221,8 , 314,18 , 37,5 , 8,10 , 19379,48 , 19427,153 , 1381,27 , 19713,48 , 19761,153 , 134,27 , 12768,28 , 12796,42 , 708,14 , 12768,28 , 12796,42 , 708,14 , 0,2 , 0,2 , {78,71,78},  171,1 , 8000,11 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     1,     6,     7 }, // Tyap/AnyScript/Nigeria
    {    166,     0,   170,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 408,8 , 408,8 , 554,6 , 1068,18 , 37,5 , 8,10 , 13747,48 , 13795,88 , 13883,24 , 14081,48 , 14129,88 , 14217,24 , 9162,28 , 9190,55 , 9245,14 , 9259,28 , 9190,55 , 9245,14 , 0,2 , 0,2 , {80,72,80},  139,1 , 7392,22 , 8,5 , 4,0 , 3383,8 , 2903,9 ,     2,     1,     7,     6,     7 }, // Filipino/AnyScript/Philippines
    {    167,     0,   206,    46,  8217,    59,    37,    48,  8722,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 169,9 , 169,9 , 332,8 , 498,18 , 37,5 , 8,10 , 5099,48 , 19580,86 , 134,24 , 5168,48 , 19914,86 , 320,24 , 12838,28 , 12866,63 , 3360,14 , 12838,28 , 12866,63 , 3360,14 , 107,5 , 387,4 , {67,72,70},  0,0 , 8011,39 , 25,5 , 4,0 , 3391,16 , 3407,7 ,     2,     5,     1,     6,     7 }, // Swiss German/AnyScript/Switzerland
    {    168,     0,    44,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 1381,27 , 19666,38 , 1381,27 , 134,27 , 20000,38 , 134,27 , 12929,21 , 12950,28 , 12978,14 , 12929,21 , 12950,28 , 12978,14 , 400,2 , 391,2 , {67,78,89},  208,3 , 0,7 , 8,5 , 4,0 , 3414,3 , 3417,2 ,     2,     1,     7,     6,     7 }, // Sichuan Yi/AnyScript/China
    {    170,     0,    82,    44,    46,    59,    37,    48,    45,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 1381,27 , 1381,27 , 1381,27 , 134,27 , 134,27 , 134,27 , 708,14 , 708,14 , 708,14 , 708,14 , 708,14 , 708,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 0,7 , 25,5 , 4,0 , 3419,12 , 3431,11 ,     2,     1,     1,     6,     7 }, // Low German/AnyScript/Germany
    {    171,     0,   195,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 19704,48 , 19752,100 , 1381,27 , 20038,48 , 20086,100 , 134,27 , 12992,27 , 13019,66 , 708,14 , 12992,27 , 13019,66 , 708,14 , 0,2 , 0,2 , {90,65,82},  11,1 , 0,7 , 4,4 , 4,0 , 3442,10 , 0,0 ,     2,     1,     7,     6,     7 }, // South Ndebele/AnyScript/SouthAfrica
    {    172,     0,   195,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 19852,48 , 19900,94 , 1381,27 , 20186,48 , 20234,94 , 134,27 , 13085,27 , 13112,63 , 708,14 , 13085,27 , 13112,63 , 708,14 , 0,2 , 0,2 , {90,65,82},  11,1 , 0,7 , 4,4 , 4,0 , 3452,16 , 0,0 ,     2,     1,     7,     6,     7 }, // Northern Sotho/AnyScript/SouthAfrica
    {    173,     0,    73,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 138,8 , 138,8 , 72,10 , 314,18 , 37,5 , 8,10 , 19994,85 , 20079,145 , 20224,24 , 20328,85 , 20413,145 , 20558,24 , 13175,33 , 13208,65 , 13273,14 , 13175,33 , 13208,65 , 13273,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 8050,23 , 25,5 , 4,0 , 3468,15 , 3483,6 ,     2,     1,     1,     6,     7 }, // Northern Sami/AnyScript/Finland
    {    173,     0,   161,    44,   160,    59,    37,    48,  8722,    43,   101,  8221,  8221,  8217,  8217, 0,6 , 0,6 , 138,8 , 138,8 , 72,10 , 314,18 , 37,5 , 8,10 , 20248,59 , 20079,145 , 20224,24 , 20582,59 , 20413,145 , 20558,24 , 13175,33 , 13287,75 , 13362,14 , 13175,33 , 13287,75 , 13362,14 , 0,2 , 0,2 , {78,79,75},  0,0 , 8073,21 , 25,5 , 4,0 , 3468,15 , 3489,5 ,     2,     1,     1,     6,     7 }, // Northern Sami/AnyScript/Norway
    {    174,     0,   208,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 72,10 , 314,18 , 37,5 , 8,10 , 20307,48 , 20355,142 , 20497,24 , 20641,48 , 20689,142 , 20831,24 , 13376,28 , 13404,172 , 13576,14 , 13376,28 , 13404,172 , 13576,14 , 0,2 , 0,2 , {84,87,68},  124,3 , 8094,18 , 8,5 , 4,0 , 0,0 , 0,0 ,     2,     1,     7,     6,     7 }, // Taroko/AnyScript/Taiwan
    {    175,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,    39,  8216,  8220,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 20521,48 , 20569,88 , 20657,24 , 20855,48 , 20903,88 , 20991,24 , 13590,28 , 13618,62 , 13680,14 , 13590,28 , 13618,62 , 13680,14 , 402,5 , 393,10 , {75,69,83},  2,3 , 8112,24 , 4,4 , 13,6 , 3494,8 , 2862,5 ,     2,     1,     7,     6,     7 }, // Gusii/AnyScript/Kenya
    {    176,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 20681,48 , 20729,221 , 20950,24 , 21015,48 , 21063,221 , 21284,24 , 13694,28 , 13722,105 , 13827,14 , 13694,28 , 13722,105 , 13827,14 , 407,10 , 403,10 , {75,69,83},  2,3 , 8112,24 , 4,4 , 13,6 , 3502,7 , 2862,5 ,     2,     1,     7,     6,     7 }, // Taita/AnyScript/Kenya
    {    177,     0,   187,    44,   160,    59,    37,    48,    45,    43,   101,  8222,  8221,    39,    39, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 20974,48 , 21022,77 , 21099,24 , 21308,48 , 21356,77 , 21433,24 , 13841,28 , 13869,59 , 13928,14 , 13841,28 , 13869,59 , 13928,14 , 417,6 , 413,7 , {88,79,70},  168,3 , 8136,26 , 25,5 , 4,0 , 3509,6 , 3515,8 ,     0,     0,     1,     6,     7 }, // Fulah/AnyScript/Senegal
    {    178,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 21123,48 , 21171,185 , 21356,24 , 21457,48 , 21505,185 , 21690,24 , 13942,28 , 13970,63 , 14033,14 , 13942,28 , 13970,63 , 14033,14 , 423,6 , 420,8 , {75,69,83},  2,3 , 8162,23 , 4,4 , 13,6 , 3523,6 , 2862,5 ,     2,     1,     7,     6,     7 }, // Kikuyu/AnyScript/Kenya
    {    179,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 21380,48 , 21428,173 , 21601,24 , 21714,48 , 21762,173 , 21935,24 , 14047,28 , 14075,105 , 14180,14 , 14047,28 , 14075,105 , 14180,14 , 429,7 , 428,5 , {75,69,83},  2,3 , 8185,25 , 4,4 , 13,6 , 3529,8 , 2862,5 ,     2,     1,     7,     6,     7 }, // Samburu/AnyScript/Kenya
    {    180,     0,   146,    44,    46,    59,    37,    48,    45,    43,   101,    39,    39,    39,    39, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 883,27 , 37,5 , 8,10 , 21625,48 , 21673,88 , 134,24 , 21959,48 , 22007,88 , 320,24 , 14194,28 , 14222,55 , 14277,14 , 14194,28 , 14222,55 , 14277,14 , 0,2 , 0,2 , {77,90,78},  223,3 , 8210,28 , 0,4 , 4,0 , 3537,4 , 2188,10 ,     2,     1,     7,     6,     7 }, // Sena/AnyScript/Mozambique
    {    181,     0,   240,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 21761,48 , 21809,112 , 21921,24 , 22095,48 , 22143,112 , 22255,24 , 14291,28 , 14319,50 , 14369,14 , 14291,28 , 14319,50 , 14369,14 , 0,2 , 0,2 , {85,83,68},  253,3 , 8238,24 , 4,4 , 13,6 , 3442,10 , 980,8 ,     2,     1,     7,     6,     7 }, // North Ndebele/AnyScript/Zimbabwe
    {    182,     0,   210,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 21945,39 , 21984,194 , 22178,24 , 22279,39 , 22318,194 , 22512,24 , 14383,28 , 14411,65 , 14476,14 , 14383,28 , 14411,65 , 14476,14 , 436,8 , 433,7 , {84,90,83},  279,3 , 8262,25 , 4,4 , 4,0 , 3541,9 , 2867,8 ,     0,     0,     1,     6,     7 }, // Rombo/AnyScript/Tanzania
    {    183,     0,   145,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 22202,48 , 22250,81 , 22331,24 , 22536,48 , 22584,81 , 22665,24 , 14490,30 , 14520,48 , 708,14 , 14490,30 , 14520,48 , 708,14 , 444,6 , 440,8 , {77,65,68},  0,0 , 8287,21 , 0,4 , 4,0 , 3550,9 , 3559,6 ,     2,     1,     6,     5,     6 }, // Tachelhit/AnyScript/Morocco
    {    183,     7,   145,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 22202,48 , 22250,81 , 22331,24 , 22536,48 , 22584,81 , 22665,24 , 14490,30 , 14520,48 , 708,14 , 14490,30 , 14520,48 , 708,14 , 444,6 , 440,8 , {77,65,68},  0,0 , 8287,21 , 0,4 , 4,0 , 3550,9 , 3559,6 ,     2,     1,     6,     5,     6 }, // Tachelhit/Latin/Morocco
    {    183,     9,   145,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8222,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 22355,48 , 22403,81 , 22484,24 , 22689,48 , 22737,81 , 22818,24 , 14568,30 , 14598,47 , 708,14 , 14568,30 , 14598,47 , 708,14 , 450,6 , 448,8 , {77,65,68},  0,0 , 8308,21 , 0,4 , 4,0 , 3565,8 , 3573,6 ,     2,     1,     6,     5,     6 }, // Tachelhit/Tifinagh/Morocco
    {    184,     0,     3,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 22508,48 , 22556,84 , 22640,24 , 22842,48 , 22890,84 , 22974,24 , 14645,30 , 14675,51 , 14726,14 , 14645,30 , 14675,51 , 14726,14 , 456,7 , 456,9 , {68,90,68},  303,2 , 8329,21 , 0,4 , 4,0 , 3579,9 , 3588,8 ,     2,     1,     6,     4,     5 }, // Kabyle/AnyScript/Algeria
    {    185,     0,   221,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8222, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 22664,48 , 22712,152 , 134,24 , 22998,48 , 23046,152 , 320,24 , 14740,28 , 14768,74 , 14842,14 , 14740,28 , 14768,74 , 14842,14 , 0,2 , 0,2 , {85,71,88},  305,3 , 8350,26 , 4,4 , 72,5 , 3596,10 , 3606,6 ,     0,     0,     1,     6,     7 }, // Nyankole/AnyScript/Uganda
    {    186,     0,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 22864,48 , 22912,254 , 23166,24 , 23198,48 , 23246,254 , 23500,24 , 14856,28 , 14884,82 , 14966,14 , 14856,28 , 14884,82 , 14966,14 , 463,7 , 465,7 , {84,90,83},  279,3 , 8376,29 , 0,4 , 4,0 , 3612,6 , 3618,10 ,     0,     0,     1,     6,     7 }, // Bena/AnyScript/Tanzania
    {    187,     0,   210,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 13529,48 , 23190,87 , 134,24 , 13863,48 , 23524,87 , 320,24 , 14980,28 , 15008,62 , 15070,14 , 14980,28 , 15008,62 , 15070,14 , 470,5 , 472,9 , {84,90,83},  279,3 , 8405,27 , 4,4 , 4,0 , 3628,8 , 2867,8 ,     0,     0,     1,     6,     7 }, // Vunjo/AnyScript/Tanzania
    {    188,     0,   132,    46,    44,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 23277,47 , 23324,92 , 23416,24 , 23611,47 , 23658,92 , 23750,24 , 15084,28 , 15112,44 , 15156,14 , 15084,28 , 15112,44 , 15156,14 , 0,2 , 0,2 , {88,79,70},  168,3 , 8432,24 , 4,4 , 13,6 , 3636,9 , 1301,4 ,     0,     0,     1,     6,     7 }, // Bambara/AnyScript/Mali
    {    189,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 23440,48 , 23488,207 , 23695,24 , 23774,48 , 23822,207 , 24029,24 , 15170,28 , 15198,64 , 15262,14 , 15170,28 , 15198,64 , 15262,14 , 475,2 , 481,2 , {75,69,83},  2,3 , 8112,24 , 4,4 , 13,6 , 3645,6 , 2862,5 ,     2,     1,     7,     6,     7 }, // Embu/AnyScript/Kenya
    {    190,     0,   225,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 554,6 , 35,18 , 18,7 , 25,12 , 23719,36 , 23755,58 , 23813,24 , 24053,36 , 24089,58 , 24147,24 , 15276,28 , 15304,49 , 15353,14 , 15276,28 , 15304,49 , 15353,14 , 477,3 , 483,6 , {85,83,68},  12,1 , 8456,19 , 4,4 , 13,6 , 3651,3 , 3654,4 ,     2,     1,     7,     6,     7 }, // Cherokee/AnyScript/UnitedStates
    {    191,     0,   137,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 23837,47 , 23884,68 , 23952,24 , 24171,47 , 24218,68 , 24286,24 , 15367,27 , 15394,48 , 15442,14 , 15367,27 , 15394,48 , 15442,14 , 0,2 , 0,2 , {77,85,82},  0,0 , 8475,21 , 8,5 , 4,0 , 3658,14 , 3672,5 ,     0,     0,     1,     6,     7 }, // Morisyen/AnyScript/Mauritius
    {    192,     0,   210,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 13529,48 , 23976,264 , 134,24 , 13863,48 , 24310,264 , 320,24 , 15456,28 , 15484,133 , 14476,14 , 15456,28 , 15484,133 , 14476,14 , 480,4 , 489,5 , {84,90,83},  279,3 , 8405,27 , 4,4 , 13,6 , 3677,10 , 2867,8 ,     0,     0,     1,     6,     7 }, // Makonde/AnyScript/Tanzania
    {    193,     0,   210,    46,    44,    59,    37,    48,    45,    43,   101,  8221,  8221,    39,    39, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 24240,83 , 24323,111 , 24434,24 , 24574,83 , 24657,111 , 24768,24 , 15617,36 , 15653,63 , 15716,14 , 15617,36 , 15653,63 , 15716,14 , 484,3 , 494,3 , {84,90,83},  279,3 , 8496,29 , 8,5 , 4,0 , 3687,8 , 3695,9 ,     0,     0,     1,     6,     7 }, // Langi/AnyScript/Tanzania
    {    194,     0,   221,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 24458,48 , 24506,97 , 134,24 , 24792,48 , 24840,97 , 320,24 , 15730,28 , 15758,66 , 15824,14 , 15730,28 , 15758,66 , 15824,14 , 0,2 , 0,2 , {85,71,88},  305,3 , 8525,26 , 0,4 , 4,0 , 3704,7 , 3711,7 ,     0,     0,     1,     6,     7 }, // Ganda/AnyScript/Uganda
    {    195,     0,   239,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 24603,48 , 24651,83 , 24734,24 , 24937,48 , 24985,83 , 25068,24 , 15838,80 , 15838,80 , 708,14 , 15838,80 , 15838,80 , 708,14 , 487,8 , 497,7 , {90,77,75},  308,2 , 0,7 , 4,4 , 13,6 , 3718,9 , 3727,6 ,     0,     0,     1,     6,     7 }, // Bemba/AnyScript/Zambia
    {    196,     0,    39,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,   171,   187, 0,6 , 0,6 , 375,7 , 375,7 , 364,8 , 1372,27 , 37,5 , 8,10 , 24758,48 , 24806,86 , 134,24 , 25092,48 , 25140,86 , 320,24 , 15918,28 , 15946,73 , 16019,14 , 15918,28 , 15946,73 , 16019,14 , 237,2 , 220,2 , {67,86,69},  0,0 , 8551,25 , 0,4 , 4,0 , 3733,12 , 3745,10 ,     2,     1,     1,     6,     7 }, // Kabuverdianu/AnyScript/CapeVerde
    {    197,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 24892,48 , 24940,86 , 25026,24 , 25226,48 , 25274,86 , 25360,24 , 16033,28 , 16061,51 , 16112,14 , 16033,28 , 16061,51 , 16112,14 , 495,2 , 504,2 , {75,69,83},  2,3 , 8112,24 , 4,4 , 13,6 , 3755,6 , 2862,5 ,     2,     1,     7,     6,     7 }, // Meru/AnyScript/Kenya
    {    198,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 25050,48 , 25098,111 , 25209,24 , 25384,48 , 25432,111 , 25543,24 , 16126,28 , 16154,93 , 16247,14 , 16126,28 , 16154,93 , 16247,14 , 497,4 , 506,4 , {75,69,83},  2,3 , 8576,26 , 4,4 , 13,6 , 3761,8 , 3769,12 ,     2,     1,     7,     6,     7 }, // Kalenjin/AnyScript/Kenya
    {    199,     0,   148,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 0,48 , 25233,136 , 134,24 , 0,48 , 25567,136 , 320,24 , 16261,23 , 16284,92 , 16376,14 , 16261,23 , 16284,92 , 16376,14 , 501,7 , 510,5 , {78,65,68},  12,1 , 8602,22 , 4,4 , 4,0 , 3781,13 , 3794,8 ,     2,     1,     1,     6,     7 }, // Nama/AnyScript/Namibia
    {    200,     0,   210,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 13529,48 , 23190,87 , 134,24 , 13863,48 , 23524,87 , 320,24 , 14980,28 , 15008,62 , 15070,14 , 14980,28 , 15008,62 , 15070,14 , 470,5 , 472,9 , {84,90,83},  279,3 , 8405,27 , 4,4 , 4,0 , 3802,9 , 2867,8 ,     0,     0,     1,     6,     7 }, // Machame/AnyScript/Tanzania
    {    201,     0,    82,    44,   160,    59,    37,    48,  8722,    43,   101,  8222,  8220,  8218,  8216, 0,6 , 0,6 , 296,8 , 296,8 , 1399,10 , 1409,23 , 37,5 , 8,10 , 25369,59 , 25428,87 , 134,24 , 25703,59 , 25762,87 , 320,24 , 16390,28 , 16418,72 , 3360,14 , 16390,28 , 16418,72 , 3360,14 , 0,2 , 0,2 , {69,85,82},  112,1 , 8624,11 , 25,5 , 4,0 , 0,0 , 3811,11 ,     2,     1,     1,     6,     7 }, // Colognian/AnyScript/Germany
    {    202,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8221,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 25515,51 , 25566,132 , 1381,27 , 25849,51 , 25900,132 , 134,27 , 14980,28 , 16490,58 , 14476,14 , 14980,28 , 16490,58 , 14476,14 , 508,9 , 515,6 , {75,69,83},  2,3 , 8635,25 , 4,4 , 13,6 , 3822,3 , 2862,5 ,     2,     1,     7,     6,     7 }, // Masai/AnyScript/Kenya
    {    202,     0,   210,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8221,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 25515,51 , 25566,132 , 1381,27 , 25849,51 , 25900,132 , 134,27 , 14980,28 , 16490,58 , 14476,14 , 14980,28 , 16490,58 , 14476,14 , 508,9 , 515,6 , {84,90,83},  279,3 , 8660,28 , 4,4 , 13,6 , 3822,3 , 3825,8 ,     0,     0,     1,     6,     7 }, // Masai/AnyScript/Tanzania
    {    203,     0,   221,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8222, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 24458,48 , 24506,97 , 134,24 , 24792,48 , 24840,97 , 320,24 , 16548,35 , 16583,65 , 16648,14 , 16548,35 , 16583,65 , 16648,14 , 517,6 , 521,6 , {85,71,88},  305,3 , 8525,26 , 25,5 , 4,0 , 3833,7 , 3711,7 ,     0,     0,     1,     6,     7 }, // Soga/AnyScript/Uganda
    {    204,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8222,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 25698,48 , 13577,84 , 134,24 , 26032,48 , 13911,84 , 320,24 , 16662,21 , 16683,75 , 85,14 , 16662,21 , 16683,75 , 85,14 , 61,4 , 59,4 , {75,69,83},  0,0 , 8688,23 , 4,4 , 77,6 , 3840,7 , 2862,5 ,     2,     1,     7,     6,     7 }, // Luyia/AnyScript/Kenya
    {    205,     0,   210,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 25746,48 , 13577,84 , 134,24 , 26080,48 , 13911,84 , 320,24 , 16758,28 , 8981,60 , 15070,14 , 16758,28 , 8981,60 , 15070,14 , 523,9 , 527,8 , {84,90,83},  279,3 , 8711,28 , 25,5 , 4,0 , 3847,6 , 3853,8 ,     0,     0,     1,     6,     7 }, // Asu/AnyScript/Tanzania
    {    206,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,    39,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 25794,48 , 25842,94 , 25936,24 , 26128,48 , 26176,94 , 26270,24 , 16786,28 , 16814,69 , 16883,14 , 16786,28 , 16814,69 , 16883,14 , 532,9 , 535,6 , {75,69,83},  2,3 , 8739,27 , 4,4 , 13,6 , 3861,6 , 3867,5 ,     2,     1,     7,     6,     7 }, // Teso/AnyScript/Kenya
    {    206,     0,   221,    46,    44,    59,    37,    48,    45,    43,   101,    39,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 25794,48 , 25842,94 , 25936,24 , 26128,48 , 26176,94 , 26270,24 , 16786,28 , 16814,69 , 16883,14 , 16786,28 , 16814,69 , 16883,14 , 532,9 , 535,6 , {85,71,88},  305,3 , 8766,28 , 4,4 , 13,6 , 3861,6 , 3606,6 ,     0,     0,     1,     6,     7 }, // Teso/AnyScript/Uganda
    {    207,     0,    67,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 27,8 , 53,19 , 18,7 , 25,12 , 317,48 , 508,118 , 484,24 , 344,48 , 535,118 , 511,24 , 16897,28 , 16925,56 , 16981,14 , 16897,28 , 16925,56 , 16981,14 , 0,2 , 0,2 , {69,82,78},  8,3 , 0,7 , 4,4 , 4,0 , 0,0 , 36,7 ,     2,     1,     1,     6,     7 }, // Saho/AnyScript/Eritrea
    {    208,     0,   132,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,   171,   187, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 25960,46 , 26006,88 , 26094,24 , 26294,46 , 26340,88 , 26428,24 , 16995,28 , 17023,53 , 17076,14 , 16995,28 , 17023,53 , 17076,14 , 541,6 , 541,6 , {88,79,70},  168,3 , 8794,23 , 0,4 , 4,0 , 3872,11 , 3883,5 ,     0,     0,     1,     6,     7 }, // Koyra Chiini/AnyScript/Mali
    {    209,     0,   210,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 13529,48 , 23190,87 , 134,24 , 13863,48 , 23524,87 , 320,24 , 14980,28 , 15008,62 , 15070,14 , 14980,28 , 15008,62 , 15070,14 , 470,5 , 472,9 , {84,90,83},  279,3 , 8405,27 , 0,4 , 4,0 , 3888,6 , 2867,8 ,     0,     0,     1,     6,     7 }, // Rwa/AnyScript/Tanzania
    {    210,     0,   111,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 26118,48 , 26166,186 , 26352,24 , 26452,48 , 26500,186 , 26686,24 , 17090,28 , 17118,69 , 17187,14 , 17090,28 , 17118,69 , 17187,14 , 547,2 , 547,2 , {75,69,83},  0,0 , 8817,23 , 0,4 , 4,0 , 3894,6 , 2862,5 ,     2,     1,     7,     6,     7 }, // Luo/AnyScript/Kenya
    {    211,     0,   221,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8222, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 22664,48 , 22712,152 , 134,24 , 22998,48 , 23046,152 , 320,24 , 14740,28 , 14768,74 , 14842,14 , 14740,28 , 14768,74 , 14842,14 , 0,2 , 0,2 , {85,71,88},  305,3 , 8350,26 , 4,4 , 72,5 , 3900,6 , 3606,6 ,     0,     0,     1,     6,     7 }, // Chiga/AnyScript/Uganda
    {    212,     0,   145,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 26376,48 , 26424,86 , 26510,24 , 26710,48 , 26758,86 , 26844,24 , 17201,28 , 17229,48 , 17277,14 , 17201,28 , 17229,48 , 17277,14 , 549,9 , 549,10 , {77,65,68},  0,0 , 8840,22 , 25,5 , 4,0 , 3906,8 , 3914,6 ,     2,     1,     6,     5,     6 }, // Central Morocco Tamazight/AnyScript/Morocco
    {    212,     7,   145,    44,   160,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 26376,48 , 26424,86 , 26510,24 , 26710,48 , 26758,86 , 26844,24 , 17201,28 , 17229,48 , 17277,14 , 17201,28 , 17229,48 , 17277,14 , 549,9 , 549,10 , {77,65,68},  0,0 , 8840,22 , 25,5 , 4,0 , 3906,8 , 3914,6 ,     2,     1,     6,     5,     6 }, // Central Morocco Tamazight/Latin/Morocco
    {    213,     0,   132,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,   171,   187, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 25960,46 , 26006,88 , 26094,24 , 26294,46 , 26340,88 , 26428,24 , 17291,28 , 17319,54 , 17076,14 , 17291,28 , 17319,54 , 17076,14 , 541,6 , 541,6 , {88,79,70},  168,3 , 8794,23 , 0,4 , 4,0 , 3920,15 , 3883,5 ,     0,     0,     1,     6,     7 }, // Koyraboro Senni/AnyScript/Mali
    {    214,     0,   210,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 13529,48 , 26534,84 , 134,24 , 13863,48 , 26868,84 , 320,24 , 17373,28 , 17401,63 , 9041,14 , 17373,28 , 17401,63 , 9041,14 , 558,5 , 559,8 , {84,90,83},  279,3 , 7301,27 , 0,4 , 4,0 , 3935,9 , 2867,8 ,     0,     0,     1,     6,     7 }, // Shambala/AnyScript/Tanzania
    {    215,     0,   100,    46,    44,    59,    37,  2406,    45,    43,   101,    39,    39,    34,    34, 0,6 , 0,6 , 0,6 , 0,6 , 554,6 , 35,18 , 18,7 , 25,12 , 26618,88 , 26618,88 , 26706,31 , 26952,88 , 26952,88 , 27040,31 , 17464,33 , 17497,54 , 17551,19 , 17464,33 , 17497,54 , 17551,19 , 563,3 , 567,6 , {73,78,82},  114,1 , 8862,10 , 8,5 , 4,0 , 3944,4 , 1640,4 ,     2,     1,     7,     7,     7 }, // Bodo/AnyScript/India
    {    216,     0,    37,    44,   160,    59,    37,    48,    45,    43,   101,    39,    39,  8222,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 26737,48 , 26785,195 , 26980,24 , 27071,48 , 27119,195 , 27314,24 , 17570,28 , 17598,72 , 17670,14 , 17570,28 , 17598,72 , 17670,14 , 566,3 , 573,3 , {88,65,70},  195,4 , 8872,21 , 0,4 , 4,0 , 3948,5 , 3953,7 ,     0,     0,     1,     6,     7 }, // Aghem/AnyScript/Cameroon
    {    217,     0,    37,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8222, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 27004,48 , 27052,90 , 27142,24 , 27338,48 , 27386,90 , 27476,24 , 17684,28 , 17712,70 , 17782,14 , 17684,28 , 17712,70 , 17782,14 , 569,10 , 576,9 , {88,65,70},  195,4 , 8893,22 , 25,5 , 4,0 , 3960,5 , 3965,8 ,     0,     0,     1,     6,     7 }, // Basaa/AnyScript/Cameroon
    {    218,     0,   156,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,   171,   187, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 25960,46 , 26006,88 , 26094,24 , 26294,46 , 26340,88 , 26428,24 , 17796,28 , 17824,51 , 17076,14 , 17796,28 , 17824,51 , 17076,14 , 579,8 , 585,10 , {88,79,70},  168,3 , 8794,23 , 0,4 , 4,0 , 3973,10 , 3983,5 ,     0,     0,     1,     6,     7 }, // Zarma/AnyScript/Niger
    {    219,     0,    37,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,    39,    39, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 27166,49 , 27215,99 , 27314,24 , 27500,49 , 27549,99 , 27648,24 , 17875,28 , 17903,45 , 17948,14 , 17875,28 , 17903,45 , 17948,14 , 587,5 , 595,6 , {88,65,70},  195,4 , 0,7 , 25,5 , 4,0 , 3988,5 , 1094,8 ,     0,     0,     1,     6,     7 }, // Duala/AnyScript/Cameroon
    {    220,     0,   187,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 27338,36 , 27374,82 , 27456,24 , 27672,36 , 27708,82 , 27790,24 , 17962,28 , 17990,50 , 18040,14 , 17962,28 , 17990,50 , 18040,14 , 0,2 , 0,2 , {88,79,70},  168,3 , 8915,23 , 25,5 , 4,0 , 3993,5 , 3998,7 ,     0,     0,     1,     6,     7 }, // JolaFonyi/AnyScript/Senegal
    {    221,     0,    37,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 27480,48 , 27528,141 , 27669,24 , 27814,48 , 27862,141 , 28003,24 , 18054,30 , 18084,85 , 18169,14 , 18054,30 , 18084,85 , 18169,14 , 592,7 , 601,9 , {88,65,70},  195,4 , 8938,23 , 25,5 , 4,0 , 4005,6 , 4011,7 ,     0,     0,     1,     6,     7 }, // Ewondo/AnyScript/Cameroon
    {    222,     0,    37,    44,   160,    59,    37,    48,    45,    43,   101,    39,    39,   171,   187, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 27693,39 , 27732,191 , 1381,27 , 28027,39 , 28066,191 , 134,27 , 18183,29 , 18212,45 , 18257,14 , 18183,29 , 18212,45 , 18257,14 , 599,6 , 610,7 , {88,65,70},  195,4 , 8961,11 , 25,5 , 4,0 , 4018,5 , 4023,7 ,     0,     0,     1,     6,     7 }, // Bafia/AnyScript/Cameroon
    {    223,     0,    49,    44,    46,    59,    37,    48,    45,    43,   101,  8216,  8216,  8220,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 27923,48 , 27971,99 , 28070,24 , 28257,48 , 28305,99 , 28404,24 , 18271,28 , 18299,50 , 18349,14 , 18271,28 , 18299,50 , 18349,14 , 605,5 , 617,6 , {67,68,70},  0,0 , 8972,24 , 0,4 , 4,0 , 4030,8 , 4038,16 ,     2,     1,     1,     6,     7 }, // LubaKatanga/AnyScript/DemocraticRepublicOfCongo
    {    224,     0,   146,    44,    46,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 28094,48 , 28142,213 , 28355,24 , 28428,48 , 28476,213 , 28689,24 , 18363,28 , 18391,59 , 18450,14 , 18363,28 , 18391,59 , 18450,14 , 0,2 , 0,2 , {77,90,78},  223,3 , 0,7 , 8,5 , 4,0 , 4054,5 , 4059,10 ,     2,     1,     7,     6,     7 }, // MakhuwaMeetto/AnyScript/Mozambique
    {    225,     0,    37,    44,    46,    59,    37,    48,    45,    43,   101,   171,   187,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 28379,48 , 28427,139 , 28566,24 , 28713,48 , 28761,139 , 28900,24 , 18464,28 , 18492,74 , 18566,14 , 18464,28 , 18492,74 , 18566,14 , 610,5 , 623,5 , {88,65,70},  195,4 , 8996,17 , 4,4 , 13,6 , 4069,6 , 4075,7 ,     0,     0,     1,     6,     7 }, // Mundang/AnyScript/Cameroon
    {    226,     0,    37,    44,   160,    59,    37,    48,    45,    43,   101,  8220,  8222,   171,   187, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 28590,51 , 28641,143 , 1381,27 , 28924,51 , 28975,143 , 134,27 , 18580,30 , 18610,89 , 18699,14 , 18580,30 , 18610,89 , 18699,14 , 615,4 , 628,4 , {88,65,70},  195,4 , 9013,20 , 25,5 , 4,0 , 0,0 , 4082,7 ,     0,     0,     1,     6,     7 }, // Kwasio/AnyScript/Cameroon
    {    227,     0,   201,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 1432,9 , 99,16 , 18,7 , 61,12 , 28784,54 , 28838,96 , 28934,24 , 29118,54 , 29172,96 , 29268,24 , 18713,38 , 18751,79 , 18830,14 , 18713,38 , 18751,79 , 18830,14 , 619,2 , 632,2 , {83,68,71},  0,0 , 0,7 , 4,4 , 13,6 , 4089,9 , 4098,5 ,     2,     1,     6,     5,     6 }, // Nuer/AnyScript/Sudan
    {    228,     0,   178,    46,    44,    59,    37,    48,    45,    43,   101,  8220,  8221,  8216,  8217, 0,6 , 0,6 , 0,6 , 0,6 , 464,6 , 1441,30 , 37,5 , 8,10 , 28958,75 , 29033,121 , 29154,24 , 29292,75 , 29367,121 , 29488,24 , 18844,21 , 18865,73 , 18938,14 , 18844,21 , 18865,73 , 18938,14 , 0,2 , 0,2 , {82,85,66},  0,0 , 0,7 , 8,5 , 4,0 , 4103,9 , 0,0 ,     2,     1,     1,     6,     7 }, // Sakha/AnyScript/RussianFederation
    {    229,     0,   210,    46,    44,    59,    37,    48,    45,    43,   101,    39,    39,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 29178,48 , 29226,117 , 1381,27 , 29512,48 , 29560,117 , 134,27 , 18952,28 , 18980,60 , 19040,14 , 18952,28 , 18980,60 , 19040,14 , 621,9 , 634,9 , {84,90,83},  279,3 , 9033,25 , 0,4 , 4,0 , 4112,9 , 4121,9 ,     0,     0,     1,     6,     7 }, // Sangu/AnyScript/Tanzania
    {    230,     0,    49,    44,    46,    59,    37,    48,    45,    43,   101,    39,    39,  8221,  8220, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 29343,48 , 29391,188 , 29579,24 , 29677,48 , 29725,188 , 29913,24 , 19054,28 , 19082,93 , 19175,14 , 19054,28 , 19082,93 , 19175,14 , 630,10 , 643,10 , {67,68,70},  0,0 , 9058,23 , 4,4 , 4,0 , 4130,18 , 4148,32 ,     2,     1,     1,     6,     7 }, // Congo Swahili/AnyScript/DemocraticRepublicOfCongo
    {    231,     0,   156,    46,   160,    59,    37,    48,    45,    43,   101,  8220,  8221,   171,   187, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 25960,46 , 26006,88 , 26094,24 , 26294,46 , 26340,88 , 26428,24 , 17796,28 , 17824,51 , 17076,14 , 17796,28 , 17824,51 , 17076,14 , 0,2 , 0,2 , {88,79,70},  168,3 , 8794,23 , 0,4 , 4,0 , 4180,13 , 3983,5 ,     0,     0,     1,     6,     7 }, // Tasawaq/AnyScript/Niger
    {    232,     0,   121,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 29603,50 , 29603,50 , 1381,27 , 29937,50 , 29937,50 , 134,27 , 19189,30 , 19189,30 , 708,14 , 19189,30 , 19189,30 , 708,14 , 0,2 , 0,2 , {76,82,68},  12,1 , 9081,15 , 4,4 , 13,6 , 4193,2 , 4195,4 ,     2,     1,     1,     6,     7 }, // Vai/AnyScript/Liberia
    {    232,     7,   121,    46,    44,    59,    37,    48,    45,    43,   101,  8216,  8217,  8220,  8221, 0,6 , 0,6 , 0,6 , 0,6 , 141,10 , 10,17 , 18,7 , 25,12 , 29653,81 , 29653,81 , 1381,27 , 29987,81 , 29987,81 , 134,27 , 19219,48 , 19219,48 , 708,14 , 19219,48 , 19219,48 , 708,14 , 0,2 , 0,2 , {76,82,68},  12,1 , 9096,20 , 4,4 , 13,6 , 4199,3 , 4202,8 ,     2,     1,     1,     6,     7 }, // Vai/Latin/Liberia
    {    233,     0,   206,    44,  8217,    59,    37,    48,    45,    43,   101,   171,   187,  8249,  8250, 0,6 , 0,6 , 169,9 , 169,9 , 72,10 , 498,18 , 37,5 , 8,10 , 29734,48 , 29782,99 , 29881,24 , 30068,48 , 30116,99 , 30215,24 , 19267,28 , 19295,53 , 19348,14 , 19267,28 , 19295,53 , 19348,14 , 0,2 , 0,2 , {67,72,70},  0,0 , 0,7 , 8,5 , 4,0 , 4210,6 , 4216,6 ,     2,     5,     1,     6,     7 }, // Walser/AnyScript/Switzerland
    {    234,     0,    37,    44,   160,    59,    37,    48,    45,    43,   101,   171,   187,   171,   187, 0,6 , 0,6 , 0,6 , 0,6 , 364,8 , 99,16 , 37,5 , 8,10 , 29905,51 , 29956,191 , 1381,27 , 30239,51 , 30290,191 , 134,27 , 19362,21 , 19383,71 , 19454,14 , 19362,21 , 19383,71 , 19454,14 , 640,8 , 653,8 , {88,65,70},  195,4 , 0,7 , 25,5 , 41,7 , 4222,6 , 4228,7 ,     0,     0,     1,     6,     7 }, // Yangben/AnyScript/Cameroon
    {      0,      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,0,    0,0,    0,0,   0,0,     0,0,     0,0,     0,0,     0,0,     0,0,     0,0,     0,0,    0,0,    0,0,    0,0,   0,0,   0,0,   0,0,   0,0,   0,0,   0,0,   0,0,   0,0, {0,0,0}, 0,0, 0,0, 0,0, 0,0, 0, 0, 0, 0, 0, 0,0, 0,0 }  // trailing 0s
};

static const ushort list_pattern_part_data[] = {
0x25, 0x31, 0x2c, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x12a5, 0x1293,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x12a5, 0x1293, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c,
0x20, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x74, 0x61, 0x20, 0x25,
0x32, 0x25, 0x31, 0x2c, 0x20, 0x98f, 0x9ac, 0x982, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x98f, 0x9ac, 0x982, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x438, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69, 0x20, 0x25, 0x32, 0x25, 0x31, 0x3001, 0x25, 0x32, 0x25,
0x31, 0x548c, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6f, 0x67, 0x20, 0x25, 0x32, 0x25,
0x31, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x6a, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x74, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x10d3, 0x10d0, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x3ba, 0x3b1, 0x3b9, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x61, 0x6d, 0x6d, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0xa85, 0xaa8, 0xac7, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x5d5, 0x2d, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x914, 0x930,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x914, 0x930, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xe9, 0x73, 0x20, 0x25, 0x32, 0x25,
0x31, 0x2c, 0x20, 0x64, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31,
0x2c, 0x20, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0xcae, 0xca4, 0xccd, 0xca4, 0xcc1, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0xcae, 0xca4, 0xccd, 0xca4, 0xcc1, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xbc0f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75,
0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69, 0x72, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x25, 0x32, 0x20, 0xd0e,
0xd28, 0xd4d, 0xd28, 0xd3f, 0xd35, 0x25, 0x31, 0x20, 0xd15, 0xd42, 0xd1f, 0xd3e, 0xd24, 0xd46, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20,
0x906, 0x923, 0x93f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x200f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x3b, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x15f, 0x69, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x79, 0x20,
0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x6e, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6e, 0x61, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x6f, 0x63, 0x68, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x74, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xbae,
0xbb1, 0xbcd, 0xbb1, 0xbc1, 0xbae, 0xbcd, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xc2e, 0xc30, 0xc3f, 0xc2f, 0xc41, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xe41, 0xe25, 0xe30, 0x25, 0x32, 0x25, 0x31, 0xe41, 0xe25, 0xe30, 0x25, 0x32,
0x25, 0x31, 0x20, 0x76, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x442, 0x430, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20,
0x627, 0x648, 0x631, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x627, 0x648, 0x631, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x76, 0xe0,
0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x6e, 0x6f, 0x2d, 0x25, 0x32, 0x49, 0x2d, 0x25, 0x31, 0x20, 0x6e, 0x65, 0x2d,
0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x6b, 0x70, 0x6c, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6b, 0x70, 0x6c, 0x65,
0x20, 0x25, 0x32
};

static const ushort date_format_data[] = {
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2d, 0x4d, 0x4d, 0x2d,
0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x64, 0x64, 0x64, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2d, 0x4d, 0x4d,
0x2d, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79,
0x79, 0x64, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x64, 0x200f, 0x2f, 0x4d, 0x200f, 0x2f, 0x79, 0x79, 0x79,
0x79, 0x64, 0x64, 0x64, 0x64, 0x60c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x60c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79,
0x79, 0x79, 0x79, 0x2f, 0x4d, 0x2f, 0x64, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x2f, 0x79, 0x79, 0x64, 0x2d, 0x4d, 0x2d, 0x79,
0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79,
0x79, 0x79, 0x79, 0x2f, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2c, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x27, 0x65,
0x6b, 0x6f, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x27, 0x72, 0x65, 0x6e, 0x27, 0x20, 0x64, 0x64, 0x27, 0x61, 0x27, 0x64,
0x2f, 0x4d, 0x2f, 0x79, 0x79, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf63, 0xf7c, 0xf0b, 0x79, 0x79, 0x79, 0x79, 0x20, 0xf5f, 0xfb3,
0xf0b, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0xf5a, 0xf7a, 0xf66, 0xf0b, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20,
0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79,
0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2e,
0x4d, 0x2e, 0x79, 0x79, 0x64, 0x2f, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x1790, 0x17d2, 0x1784,
0x17c3, 0x20, 0x64, 0x20, 0x1781, 0x17c2, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x1786, 0x17d2, 0x1793, 0x17b6, 0x17c6, 0x20, 0x79, 0x79,
0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79,
0x79, 0x79, 0x79, 0x79, 0x79, 0x2d, 0x4d, 0x2d, 0x64, 0x79, 0x79, 0x79, 0x79, 0x5e74, 0x4d, 0x6708, 0x64, 0x65e5, 0x64, 0x64,
0x64, 0x64, 0x79, 0x79, 0x5e74, 0x4d, 0x6708, 0x64, 0x65e5, 0x79, 0x79, 0x79, 0x79, 0x5e74, 0x4d, 0x4d, 0x6708, 0x64, 0x64, 0x65e5,
0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x2f, 0x4d, 0x2f, 0x64, 0x64, 0x2e, 0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64,
0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x64,
0x64, 0x64, 0x2c, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64,
0x20, 0x27, 0x64, 0x65, 0x6e, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x64, 0x2d, 0x4d, 0x4d, 0x2d, 0x79, 0x79, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x4d, 0x2f, 0x64, 0x2f, 0x79, 0x79,
0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2f, 0x4d, 0x4d, 0x2f,
0x64, 0x64, 0x64, 0x2e, 0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x2e, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2d, 0x4d, 0x4d, 0x2d, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64,
0x2c, 0x20, 0x64, 0x20, 0x5d1, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2d, 0x4d, 0x2d, 0x79, 0x79,
0x79, 0x79, 0x79, 0x79, 0x2e, 0x4d, 0x4d, 0x2e, 0x64, 0x64, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x20, 0x64, 0x2e, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x436, 0x27, 0x2e, 0x79, 0x79, 0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x64,
0x2e, 0x79, 0x79, 0x79, 0x79, 0xb144, 0x20, 0x4d, 0xc6d4, 0x20, 0x64, 0xc77c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
0x64, 0xe97, 0xeb5, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c,
0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x27, 0x67, 0x61, 0x64, 0x61, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x6d, 0x27, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x20, 0x27, 0x64,
0x27, 0x2e, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2e, 0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2c,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64,
0x20, 0x27, 0x74, 0x61, 0x27, 0x2019, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64,
0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x62f, 0x20,
0x79, 0x79, 0x79, 0x79, 0x20, 0x62f, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79,
0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d,
0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0xa0, 0x27, 0x433, 0x27, 0x2e, 0x64, 0x2e, 0x4d, 0x2e, 0x79, 0x79, 0x2e, 0x64,
0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x79,
0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2e, 0x20, 0x4d,
0x4d, 0x2e, 0x20, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x64, 0x20, 0x27,
0x64, 0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64,
0x64, 0x64, 0x27, 0x65, 0x6e, 0x27, 0x20, 0x27, 0x64, 0x65, 0x6e, 0x27, 0x20, 0x64, 0x3a, 0x27, 0x65, 0x27, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64,
0x64, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0xe17, 0xe35, 0xe48, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d,
0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x1361, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x1218,
0x12d3, 0x120d, 0x1272, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x1363, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x20, 0x1218, 0x12d3, 0x120d, 0x1272, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79,
0x79, 0x79, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20,
0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x440, 0x27, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2c, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x646, 0x686, 0x6cc, 0x20, 0x6cc, 0x6cc, 0x644, 0x20,
0x64, 0x20, 0x646, 0x686, 0x6cc, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x64, 0x64, 0x20, 0x6a9, 0x648, 0x646, 0x6cc,
0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x27, 0x6e, 0x67, 0xe0, 0x79, 0x27, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d,
0x20, 0x27, 0x6e, 0x103, 0x6d, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x2e,
0x64, 0x64, 0x64, 0x64, 0x1361, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x130d, 0x122d, 0x130b, 0x20, 0x79, 0x79,
0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x1361, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x12ee, 0x121d, 0x20, 0x79,
0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20,
0x27, 0x64, 0x61, 0x6c, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x1365, 0x20, 0x64, 0x64, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x130b, 0x120b, 0x1233, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20,
0x27, 0x64, 0x69, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x27, 0x64, 0xe4, 0x27, 0x20,
0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x79,
0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x441, 0x44b, 0x43b, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x20, 0x27,
0x43a, 0x4af, 0x43d, 0x44d, 0x27, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64
};

static const ushort time_format_data[] = {
0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x68, 0x3a,
0x6d, 0x6d, 0x20, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x48, 0x48, 0x3a,
0x6d, 0x6d, 0x68, 0x2e, 0x6d, 0x6d, 0x2e, 0x41, 0x50, 0x68, 0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x2e, 0x41, 0x50, 0x20,
0x74, 0x74, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x68, 0x2e, 0x6d, 0x6d, 0x2e, 0x20, 0x41,
0x50, 0x68, 0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0xf46, 0xf74, 0xf0b, 0xf5a, 0xf7c, 0xf51, 0xf0b,
0x20, 0x68, 0x20, 0xf66, 0xf90, 0xf62, 0xf0b, 0xf58, 0xf0b, 0x20, 0x6d, 0x6d, 0x20, 0x41, 0x50, 0xf46, 0xf74, 0xf0b, 0xf5a, 0xf7c,
0xf51, 0xf0b, 0x20, 0x68, 0x20, 0xf66, 0xf90, 0xf62, 0xf0b, 0xf58, 0xf0b, 0x20, 0x6d, 0x6d, 0x20, 0xf66, 0xf90, 0xf62, 0xf0b, 0xf46,
0xf71, 0xf0b, 0x20, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x48, 0x48, 0x2e, 0x6d, 0x6d, 0x48, 0x48, 0x2e, 0x6d, 0x6d,
0x2e, 0x73, 0x73, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x48, 0x20, 0x1798, 0x17c9, 0x17c4, 0x1784, 0x20, 0x6d, 0x20, 0x1793, 0x17b6,
0x1791, 0x17b8, 0x20, 0x73, 0x73, 0x20, 0x179c, 0x17b7, 0x1793, 0x17b6, 0x1791, 0x17b8, 0x200b, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x3a,
0x73, 0x73, 0x20, 0x74, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x74, 0x41, 0x50, 0x68, 0x65f6, 0x6d, 0x6d, 0x5206, 0x73, 0x73,
0x79d2, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x5b, 0x74, 0x5d, 0x41, 0x50, 0x68, 0x68, 0x3a, 0x6d,
0x6d, 0x74, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x74, 0x41, 0x50, 0x68, 0x6642, 0x6d, 0x6d, 0x5206, 0x73,
0x73, 0x79d2, 0x48, 0x48, 0x20, 0x27, 0x68, 0x27, 0x20, 0x6d, 0x6d, 0x20, 0x27, 0x6d, 0x69, 0x6e, 0x27, 0x20, 0x73, 0x73,
0x20, 0x27, 0x73, 0x27, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x74, 0x48, 0x2e, 0x6d, 0x6d, 0x48,
0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x74, 0x48, 0x20, 0x27, 0x68, 0x27, 0x20, 0x6d, 0x6d, 0x20, 0x27, 0x6d, 0x69,
0x6e, 0x27, 0x20, 0x73, 0x73, 0x20, 0x27, 0x73, 0x27, 0x20, 0x74, 0x48, 0x48, 0x2e, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20,
0x27, 0x68, 0x27, 0x20, 0x74, 0x68, 0x68, 0x3a, 0x6d, 0x6d, 0x20, 0x41, 0x50, 0x68, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73,
0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x48, 0x6642, 0x6d, 0x6d, 0x5206, 0x73, 0x73, 0x79d2, 0x20, 0x74, 0x41, 0x50, 0x20, 0x68,
0x3a, 0x6d, 0x6d, 0x41, 0x50, 0x20, 0x68, 0xc2dc, 0x20, 0x6d, 0xbd84, 0x20, 0x73, 0xcd08, 0x20, 0x74, 0x48, 0xec2, 0xea1, 0xe87,
0x20, 0x6d, 0xe99, 0xeb2, 0xe97, 0xeb5, 0x20, 0x73, 0x73, 0x20, 0xea7, 0xeb4, 0xe99, 0xeb2, 0xe97, 0xeb5, 0x74, 0x68, 0x2d, 0x6d,
0x6d, 0x20, 0x41, 0x50, 0x68, 0x2d, 0x6d, 0x6d, 0x2d, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x27, 0x6b, 0x6c, 0x27,
0x2e, 0x20, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20,
0x28, 0x74, 0x29, 0x48, 0x48, 0x27, 0x68, 0x27, 0x6d, 0x6d, 0x27, 0x6d, 0x69, 0x6e, 0x27, 0x73, 0x73, 0x27, 0x73, 0x27,
0x20, 0x74, 0x48, 0x48, 0x20, 0x27, 0x447, 0x430, 0x441, 0x43e, 0x432, 0x430, 0x27, 0x2c, 0x20, 0x6d, 0x6d, 0x20, 0x27, 0x43c,
0x438, 0x43d, 0x443, 0x442, 0x430, 0x27, 0x2c, 0x20, 0x73, 0x73, 0x20, 0x27, 0x441, 0x435, 0x43a, 0x443, 0x43d, 0x434, 0x438, 0x27,
0x20, 0x74, 0x41, 0x50, 0x20, 0x68, 0x2e, 0x6d, 0x6d, 0x48, 0x48, 0x27, 0x68, 0x27, 0x27, 0x27, 0x6d, 0x6d, 0x3a, 0x73,
0x73, 0x20, 0x74, 0x48, 0x48, 0x27, 0x48, 0x27, 0x6d, 0x6d, 0x27, 0x27, 0x73, 0x73, 0x27, 0x27, 0x20, 0x74, 0x48, 0x20,
0xe19, 0xe32, 0xe2c, 0xe34, 0xe01, 0xe32, 0x20, 0x6d, 0x20, 0xe19, 0xe32, 0xe17, 0xe35, 0x20, 0x73, 0x73, 0x20, 0xe27, 0xe34, 0xe19,
0xe32, 0xe17, 0xe35, 0x20, 0x74, 0x41, 0x50, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74
};

static const ushort months_data[] = {
0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b,
0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x63, 0x74, 0x3b,
0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x79, 0x3b, 0x46, 0x65, 0x62, 0x72,
0x75, 0x61, 0x72, 0x79, 0x3b, 0x4d, 0x61, 0x72, 0x63, 0x68, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x79,
0x3b, 0x4a, 0x75, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6c, 0x79, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65,
0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b,
0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32,
0x3b, 0x41, 0x6d, 0x61, 0x3b, 0x47, 0x75, 0x72, 0x3b, 0x42, 0x69, 0x74, 0x3b, 0x45, 0x6c, 0x62, 0x3b, 0x43, 0x61, 0x6d,
0x3b, 0x57, 0x61, 0x78, 0x3b, 0x41, 0x64, 0x6f, 0x3b, 0x48, 0x61, 0x67, 0x3b, 0x46, 0x75, 0x6c, 0x3b, 0x4f, 0x6e, 0x6b,
0x3b, 0x53, 0x61, 0x64, 0x3b, 0x4d, 0x75, 0x64, 0x3b, 0x41, 0x6d, 0x61, 0x6a, 0x6a, 0x69, 0x69, 0x3b, 0x47, 0x75, 0x72,
0x61, 0x61, 0x6e, 0x64, 0x68, 0x61, 0x6c, 0x61, 0x3b, 0x42, 0x69, 0x74, 0x6f, 0x6f, 0x74, 0x65, 0x65, 0x73, 0x73, 0x61,
0x3b, 0x45, 0x6c, 0x62, 0x61, 0x3b, 0x43, 0x61, 0x61, 0x6d, 0x73, 0x61, 0x3b, 0x57, 0x61, 0x78, 0x61, 0x62, 0x61, 0x6a,
0x6a, 0x69, 0x69, 0x3b, 0x41, 0x64, 0x6f, 0x6f, 0x6c, 0x65, 0x65, 0x73, 0x73, 0x61, 0x3b, 0x48, 0x61, 0x67, 0x61, 0x79,
0x79, 0x61, 0x3b, 0x46, 0x75, 0x75, 0x6c, 0x62, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6e, 0x6b, 0x6f, 0x6c, 0x6f, 0x6c, 0x65,
0x65, 0x73, 0x73, 0x61, 0x3b, 0x53, 0x61, 0x64, 0x61, 0x61, 0x73, 0x61, 0x3b, 0x4d, 0x75, 0x64, 0x64, 0x65, 0x65, 0x3b,
0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b,
0x4e, 0x3b, 0x44, 0x3b, 0x51, 0x75, 0x6e, 0x3b, 0x4e, 0x61, 0x68, 0x3b, 0x43, 0x69, 0x67, 0x3b, 0x41, 0x67, 0x64, 0x3b,
0x43, 0x61, 0x78, 0x3b, 0x51, 0x61, 0x73, 0x3b, 0x51, 0x61, 0x64, 0x3b, 0x4c, 0x65, 0x71, 0x3b, 0x57, 0x61, 0x79, 0x3b,
0x44, 0x69, 0x74, 0x3b, 0x58, 0x69, 0x6d, 0x3b, 0x4b, 0x61, 0x78, 0x3b, 0x51, 0x75, 0x6e, 0x78, 0x61, 0x20, 0x47, 0x61,
0x72, 0x61, 0x62, 0x6c, 0x75, 0x3b, 0x4b, 0x75, 0x64, 0x6f, 0x3b, 0x43, 0x69, 0x67, 0x67, 0x69, 0x6c, 0x74, 0x61, 0x20,
0x4b, 0x75, 0x64, 0x6f, 0x3b, 0x41, 0x67, 0x64, 0x61, 0x20, 0x42, 0x61, 0x78, 0x69, 0x73, 0x3b, 0x43, 0x61, 0x78, 0x61,
0x68, 0x20, 0x41, 0x6c, 0x73, 0x61, 0x3b, 0x51, 0x61, 0x73, 0x61, 0x20, 0x44, 0x69, 0x72, 0x72, 0x69, 0x3b, 0x51, 0x61,
0x64, 0x6f, 0x20, 0x44, 0x69, 0x72, 0x72, 0x69, 0x3b, 0x4c, 0x65, 0x71, 0x65, 0x65, 0x6e, 0x69, 0x3b, 0x57, 0x61, 0x79,
0x73, 0x75, 0x3b, 0x44, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x3b, 0x58, 0x69, 0x6d, 0x6f, 0x6c, 0x69, 0x3b, 0x4b, 0x61, 0x78,
0x78, 0x61, 0x20, 0x47, 0x61, 0x72, 0x61, 0x62, 0x6c, 0x75, 0x3b, 0x51, 0x3b, 0x4e, 0x3b, 0x43, 0x3b, 0x41, 0x3b, 0x43,
0x3b, 0x51, 0x3b, 0x51, 0x3b, 0x4c, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x58, 0x3b, 0x4b, 0x3b, 0x51, 0x75, 0x6e, 0x78, 0x61,
0x20, 0x47, 0x61, 0x72, 0x61, 0x62, 0x6c, 0x75, 0x3b, 0x4b, 0x75, 0x64, 0x6f, 0x3b, 0x43, 0x69, 0x67, 0x67, 0x69, 0x6c,
0x74, 0x61, 0x20, 0x4b, 0x75, 0x64, 0x6f, 0x3b, 0x41, 0x67, 0x64, 0x61, 0x20, 0x42, 0x61, 0x78, 0x69, 0x73, 0x3b, 0x43,
0x61, 0x78, 0x61, 0x68, 0x20, 0x41, 0x6c, 0x73, 0x61, 0x3b, 0x51, 0x61, 0x73, 0x61, 0x20, 0x44, 0x69, 0x72, 0x72, 0x69,
0x3b, 0x51, 0x61, 0x64, 0x6f, 0x20, 0x44, 0x69, 0x72, 0x72, 0x69, 0x3b, 0x4c, 0x69, 0x69, 0x71, 0x65, 0x6e, 0x3b, 0x57,
0x61, 0x79, 0x73, 0x75, 0x3b, 0x44, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x3b, 0x58, 0x69, 0x6d, 0x6f, 0x6c, 0x69, 0x3b, 0x4b,
0x61, 0x78, 0x78, 0x61, 0x20, 0x47, 0x61, 0x72, 0x61, 0x62, 0x6c, 0x75, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62,
0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c,
0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73,
0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b,
0x4d, 0x61, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69,
0x65, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x65, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x53, 0x65, 0x70,
0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x53, 0x68, 0x6b,
0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x50, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x6a, 0x3b, 0x51, 0x65, 0x72, 0x3b, 0x4b, 0x6f, 0x72,
0x3b, 0x47, 0x73, 0x68, 0x3b, 0x53, 0x68, 0x74, 0x3b, 0x54, 0x65, 0x74, 0x3b, 0x4e, 0xeb, 0x6e, 0x3b, 0x44, 0x68, 0x6a,
0x3b, 0x6a, 0x61, 0x6e, 0x61, 0x72, 0x3b, 0x73, 0x68, 0x6b, 0x75, 0x72, 0x74, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x70,
0x72, 0x69, 0x6c, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x71, 0x65, 0x72, 0x73, 0x68, 0x6f, 0x72, 0x3b, 0x6b, 0x6f, 0x72,
0x72, 0x69, 0x6b, 0x3b, 0x67, 0x75, 0x73, 0x68, 0x74, 0x3b, 0x73, 0x68, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x3b, 0x74, 0x65,
0x74, 0x6f, 0x72, 0x3b, 0x6e, 0xeb, 0x6e, 0x74, 0x6f, 0x72, 0x3b, 0x64, 0x68, 0x6a, 0x65, 0x74, 0x6f, 0x72, 0x3b, 0x4a,
0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x50, 0x3b, 0x4d, 0x3b, 0x51, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x4e,
0x3b, 0x44, 0x3b, 0x1303, 0x1295, 0x12e9, 0x3b, 0x134c, 0x1265, 0x1229, 0x3b, 0x121b, 0x122d, 0x127d, 0x3b, 0x12a4, 0x1355, 0x1228, 0x3b, 0x121c,
0x12ed, 0x3b, 0x1301, 0x1295, 0x3b, 0x1301, 0x120b, 0x12ed, 0x3b, 0x12a6, 0x1308, 0x1235, 0x3b, 0x1234, 0x1355, 0x1274, 0x3b, 0x12a6, 0x12ad, 0x1270,
0x3b, 0x1296, 0x126c, 0x121d, 0x3b, 0x12f2, 0x1234, 0x121d, 0x3b, 0x1303, 0x1295, 0x12e9, 0x12c8, 0x122a, 0x3b, 0x134c, 0x1265, 0x1229, 0x12c8, 0x122a,
0x3b, 0x121b, 0x122d, 0x127d, 0x3b, 0x12a4, 0x1355, 0x1228, 0x120d, 0x3b, 0x121c, 0x12ed, 0x3b, 0x1301, 0x1295, 0x3b, 0x1301, 0x120b, 0x12ed, 0x3b,
0x12a6, 0x1308, 0x1235, 0x1275, 0x3b, 0x1234, 0x1355, 0x1274, 0x121d, 0x1260, 0x122d, 0x3b, 0x12a6, 0x12ad, 0x1270, 0x12cd, 0x1260, 0x122d, 0x3b, 0x1296,
0x126c, 0x121d, 0x1260, 0x122d, 0x3b, 0x12f2, 0x1234, 0x121d, 0x1260, 0x122d, 0x3b, 0x1303, 0x3b, 0x134c, 0x3b, 0x121b, 0x3b, 0x12a4, 0x3b, 0x121c,
0x3b, 0x1301, 0x3b, 0x1301, 0x3b, 0x12a6, 0x3b, 0x1234, 0x3b, 0x12a6, 0x3b, 0x1296, 0x3b, 0x12f2, 0x3b, 0x64a, 0x646, 0x627, 0x64a, 0x631,
0x3b, 0x641, 0x628, 0x631, 0x627, 0x64a, 0x631, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x623, 0x628, 0x631, 0x64a, 0x644, 0x3b, 0x645,
0x627, 0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x646, 0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x644, 0x64a, 0x648, 0x3b, 0x623, 0x63a, 0x633, 0x637,
0x633, 0x3b, 0x633, 0x628, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x623, 0x643, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x641, 0x645,
0x628, 0x631, 0x3b, 0x62f, 0x64a, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x64a, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x623, 0x3b, 0x648, 0x3b,
0x646, 0x3b, 0x644, 0x3b, 0x63a, 0x3b, 0x633, 0x3b, 0x643, 0x3b, 0x628, 0x3b, 0x62f, 0x3b, 0x643, 0x627, 0x646, 0x648, 0x646, 0x20,
0x627, 0x644, 0x62b, 0x627, 0x646, 0x64a, 0x3b, 0x634, 0x628, 0x627, 0x637, 0x3b, 0x622, 0x630, 0x627, 0x631, 0x3b, 0x646, 0x64a, 0x633,
0x627, 0x646, 0x3b, 0x623, 0x64a, 0x627, 0x631, 0x3b, 0x62d, 0x632, 0x64a, 0x631, 0x627, 0x646, 0x3b, 0x62a, 0x645, 0x648, 0x632, 0x3b,
0x622, 0x628, 0x3b, 0x623, 0x64a, 0x644, 0x648, 0x644, 0x3b, 0x62a, 0x634, 0x631, 0x64a, 0x646, 0x20, 0x627, 0x644, 0x623, 0x648, 0x644,
0x3b, 0x62a, 0x634, 0x631, 0x64a, 0x646, 0x20, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x64a, 0x3b, 0x643, 0x627, 0x646, 0x648, 0x646, 0x20,
0x627, 0x644, 0x623, 0x648, 0x644, 0x3b, 0x540, 0x576, 0x57e, 0x3b, 0x553, 0x57f, 0x57e, 0x3b, 0x544, 0x580, 0x57f, 0x3b, 0x531, 0x57a,
0x580, 0x3b, 0x544, 0x575, 0x57d, 0x3b, 0x540, 0x576, 0x57d, 0x3b, 0x540, 0x56c, 0x57d, 0x3b, 0x555, 0x563, 0x57d, 0x3b, 0x54d, 0x565,
0x57a, 0x3b, 0x540, 0x578, 0x56f, 0x3b, 0x546, 0x578, 0x575, 0x3b, 0x534, 0x565, 0x56f, 0x3b, 0x540, 0x578, 0x582, 0x576, 0x57e, 0x561,
0x580, 0x3b, 0x553, 0x565, 0x57f, 0x580, 0x57e, 0x561, 0x580, 0x3b, 0x544, 0x561, 0x580, 0x57f, 0x3b, 0x531, 0x57a, 0x580, 0x56b, 0x56c,
0x3b, 0x544, 0x561, 0x575, 0x56b, 0x57d, 0x3b, 0x540, 0x578, 0x582, 0x576, 0x56b, 0x57d, 0x3b, 0x540, 0x578, 0x582, 0x56c, 0x56b, 0x57d,
0x3b, 0x555, 0x563, 0x578, 0x57d, 0x57f, 0x578, 0x57d, 0x3b, 0x54d, 0x565, 0x57a, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x540,
0x578, 0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x546, 0x578, 0x575, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x534, 0x565,
0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x9cd, 0x9f0, 0x9c1, 0x3b,
0x9ae, 0x9be, 0x9f0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9f0, 0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b,
0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x3b, 0x9b8, 0x9c7, 0x9aa, 0x9cd, 0x99f, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb,
0x3b, 0x9a8, 0x9ad, 0x9c7, 0x3b, 0x9a1, 0x9bf, 0x9b8, 0x9c7, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x9f1, 0x9be, 0x9f0, 0x9c0, 0x3b, 0x9ab,
0x9c7, 0x9ac, 0x9cd, 0x9f0, 0x9c1, 0x9f1, 0x9be, 0x9f0, 0x9c0, 0x3b, 0x9ae, 0x9be, 0x9f0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9f0,
0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x9b7, 0x9cd,
0x99f, 0x3b, 0x99b, 0x9c7, 0x9aa, 0x9cd, 0x9a4, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9f0, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x9ac, 0x9f0,
0x3b, 0x9a8, 0x9f1, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9f0, 0x3b, 0x9a1, 0x9bf, 0x99a, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9f0, 0x3b, 0x79, 0x61,
0x6e, 0x3b, 0x66, 0x65, 0x76, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x69, 0x79,
0x6e, 0x3b, 0x69, 0x79, 0x6c, 0x3b, 0x61, 0x76, 0x71, 0x3b, 0x73, 0x65, 0x6e, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f,
0x79, 0x3b, 0x64, 0x65, 0x6b, 0x3b, 0x59, 0x61, 0x6e, 0x76, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x76, 0x72, 0x61, 0x6c, 0x3b,
0x4d, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x130, 0x79, 0x75, 0x6e, 0x3b,
0x130, 0x79, 0x75, 0x6c, 0x3b, 0x41, 0x76, 0x71, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x6e, 0x74, 0x79, 0x61, 0x62, 0x72,
0x3b, 0x4f, 0x6b, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x4e, 0x6f, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x44, 0x65, 0x6b, 0x61,
0x62, 0x72, 0x3b, 0x458, 0x430, 0x43d, 0x432, 0x430, 0x440, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x3b, 0x43c, 0x430, 0x440,
0x442, 0x3b, 0x430, 0x43f, 0x440, 0x435, 0x43b, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x458, 0x443, 0x43d, 0x3b, 0x438, 0x458, 0x443,
0x43b, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x43e, 0x43a,
0x442, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x43d, 0x43e, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x434, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x3b,
0x75, 0x72, 0x74, 0x3b, 0x6f, 0x74, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x69, 0x3b, 0x6d, 0x61, 0x69, 0x3b,
0x65, 0x6b, 0x61, 0x3b, 0x75, 0x7a, 0x74, 0x3b, 0x61, 0x62, 0x75, 0x3b, 0x69, 0x72, 0x61, 0x3b, 0x75, 0x72, 0x72, 0x3b,
0x61, 0x7a, 0x61, 0x3b, 0x61, 0x62, 0x65, 0x3b, 0x75, 0x72, 0x74, 0x61, 0x72, 0x72, 0x69, 0x6c, 0x61, 0x3b, 0x6f, 0x74,
0x73, 0x61, 0x69, 0x6c, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x78, 0x6f, 0x61, 0x3b, 0x61, 0x70, 0x69, 0x72, 0x69, 0x6c,
0x61, 0x3b, 0x6d, 0x61, 0x69, 0x61, 0x74, 0x7a, 0x61, 0x3b, 0x65, 0x6b, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x75, 0x7a, 0x74,
0x61, 0x69, 0x6c, 0x61, 0x3b, 0x61, 0x62, 0x75, 0x7a, 0x74, 0x75, 0x61, 0x3b, 0x69, 0x72, 0x61, 0x69, 0x6c, 0x61, 0x3b,
0x75, 0x72, 0x72, 0x69, 0x61, 0x3b, 0x61, 0x7a, 0x61, 0x72, 0x6f, 0x61, 0x3b, 0x61, 0x62, 0x65, 0x6e, 0x64, 0x75, 0x61,
0x3b, 0x55, 0x3b, 0x4f, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x55, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x55,
0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x9af, 0x9bc, 0x9be, 0x9b0, 0x9c0, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x9cd, 0x9b0,
0x9c1, 0x9af, 0x9bc, 0x9be, 0x9b0, 0x9c0, 0x3b, 0x9ae, 0x9be, 0x9b0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9b0, 0x9bf, 0x9b2, 0x3b,
0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x9b8, 0x9cd, 0x99f, 0x3b, 0x9b8,
0x9c7, 0x9aa, 0x9cd, 0x99f, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x9ac, 0x9b0, 0x3b, 0x9a8, 0x9ad,
0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x9a1, 0x9bf, 0x9b8, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x99c, 0x9be, 0x3b, 0x9ab, 0x9c7,
0x3b, 0x9ae, 0x9be, 0x3b, 0x98f, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x3b, 0x986, 0x3b, 0x9b8, 0x9c7,
0x3b, 0x985, 0x3b, 0x9a8, 0x3b, 0x9a1, 0x9bf, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf21, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf22, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0x20, 0xf23, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf24, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf25, 0x3b, 0xf5f, 0xfb3,
0xf0b, 0x20, 0xf26, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf27, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf28, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20,
0xf29, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf21, 0xf20, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf21, 0xf21, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20,
0xf21, 0xf22, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf51, 0xf44, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1,
0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f,
0xfb3, 0xf5d, 0xf0b, 0xf42, 0xf66, 0xf74, 0xf58, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b,
0xf56, 0xf5e, 0xf72, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf63, 0xf94, 0xf0b, 0xf54,
0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66,
0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf56, 0xf51, 0xf74, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72,
0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf56, 0xf62, 0xf92, 0xfb1, 0xf51, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f,
0xfb3, 0xf5d, 0xf0b, 0xf51, 0xf42, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf56,
0xf45, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42,
0xf45, 0xf72, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b,
0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0x47, 0x65, 0x6e, 0x3b, 0x43, 0x2bc, 0x68, 0x77, 0x65, 0x3b, 0x4d, 0x65,
0x75, 0x72, 0x3b, 0x45, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x65, 0x3b, 0x4d, 0x65, 0x7a, 0x68, 0x3b, 0x47, 0x6f, 0x75, 0x65,
0x3b, 0x45, 0x6f, 0x73, 0x74, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x3b, 0x48, 0x65, 0x72, 0x65, 0x3b, 0x44, 0x75, 0x3b, 0x4b,
0x65, 0x72, 0x3b, 0x47, 0x65, 0x6e, 0x76, 0x65, 0x72, 0x3b, 0x43, 0x2bc, 0x68, 0x77, 0x65, 0x76, 0x72, 0x65, 0x72, 0x3b,
0x4d, 0x65, 0x75, 0x72, 0x7a, 0x68, 0x3b, 0x45, 0x62, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x61, 0x65, 0x3b, 0x4d, 0x65, 0x7a,
0x68, 0x65, 0x76, 0x65, 0x6e, 0x3b, 0x47, 0x6f, 0x75, 0x65, 0x72, 0x65, 0x3b, 0x45, 0x6f, 0x73, 0x74, 0x3b, 0x47, 0x77,
0x65, 0x6e, 0x67, 0x6f, 0x6c, 0x6f, 0x3b, 0x48, 0x65, 0x72, 0x65, 0x3b, 0x44, 0x75, 0x3b, 0x4b, 0x65, 0x72, 0x7a, 0x75,
0x3b, 0x44f, 0x43d, 0x2e, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x2e,
0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x44e, 0x43d, 0x438, 0x3b, 0x44e, 0x43b, 0x438, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435,
0x43f, 0x442, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b,
0x44f, 0x43d, 0x443, 0x430, 0x440, 0x438, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x443, 0x430, 0x440, 0x438, 0x3b, 0x43c, 0x430, 0x440, 0x442,
0x3b, 0x430, 0x43f, 0x440, 0x438, 0x43b, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x44e, 0x43d, 0x438, 0x3b, 0x44e, 0x43b, 0x438, 0x3b, 0x430,
0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43e, 0x43a, 0x442, 0x43e,
0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x434, 0x435, 0x43a, 0x435, 0x43c, 0x432, 0x440,
0x438, 0x3b, 0x44f, 0x3b, 0x444, 0x3b, 0x43c, 0x3b, 0x430, 0x3b, 0x43c, 0x3b, 0x44e, 0x3b, 0x44e, 0x3b, 0x430, 0x3b, 0x441, 0x3b,
0x43e, 0x3b, 0x43d, 0x3b, 0x434, 0x3b, 0x1007, 0x1014, 0x103a, 0x3b, 0x1016, 0x1031, 0x3b, 0x1019, 0x1010, 0x103a, 0x3b, 0x1027, 0x3b, 0x1019,
0x1031, 0x3b, 0x1007, 0x103d, 0x1014, 0x103a, 0x3b, 0x1007, 0x1030, 0x3b, 0x1029, 0x3b, 0x1005, 0x1000, 0x103a, 0x3b, 0x1021, 0x1031, 0x102c, 0x1000,
0x103a, 0x3b, 0x1014, 0x102d, 0x102f, 0x3b, 0x1012, 0x102e, 0x3b, 0x1007, 0x1014, 0x103a, 0x1014, 0x101d, 0x102b, 0x101b, 0x102e, 0x3b, 0x1016, 0x1031,
0x1016, 0x1031, 0x102c, 0x103a, 0x101d, 0x102b, 0x101b, 0x102e, 0x3b, 0x1019, 0x1010, 0x103a, 0x3b, 0x1027, 0x1015, 0x103c, 0x102e, 0x3b, 0x1019, 0x1031,
0x3b, 0x1007, 0x103d, 0x1014, 0x103a, 0x3b, 0x1007, 0x1030, 0x101c, 0x102d, 0x102f, 0x1004, 0x103a, 0x3b, 0x1029, 0x1002, 0x102f, 0x1010, 0x103a, 0x3b,
0x1005, 0x1000, 0x103a, 0x1010, 0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1021, 0x1031, 0x102c, 0x1000, 0x103a, 0x1010, 0x102d, 0x102f, 0x1018, 0x102c, 0x3b,
0x1014, 0x102d, 0x102f, 0x101d, 0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1012, 0x102e, 0x1007, 0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1007, 0x3b, 0x1016,
0x3b, 0x1019, 0x3b, 0x1027, 0x3b, 0x1019, 0x3b, 0x1007, 0x3b, 0x1007, 0x3b, 0x1029, 0x3b, 0x1005, 0x3b, 0x1021, 0x3b, 0x1014, 0x3b, 0x1012,
0x3b, 0x441, 0x442, 0x443, 0x3b, 0x43b, 0x44e, 0x442, 0x3b, 0x441, 0x430, 0x43a, 0x3b, 0x43a, 0x440, 0x430, 0x3b, 0x43c, 0x430, 0x439,
0x3b, 0x447, 0x44d, 0x440, 0x3b, 0x43b, 0x456, 0x43f, 0x3b, 0x436, 0x43d, 0x456, 0x3b, 0x432, 0x435, 0x440, 0x3b, 0x43a, 0x430, 0x441,
0x3b, 0x43b, 0x456, 0x441, 0x3b, 0x441, 0x43d, 0x435, 0x3b, 0x441, 0x442, 0x443, 0x434, 0x437, 0x435, 0x43d, 0x44c, 0x3b, 0x43b, 0x44e,
0x442, 0x44b, 0x3b, 0x441, 0x430, 0x43a, 0x430, 0x432, 0x456, 0x43a, 0x3b, 0x43a, 0x440, 0x430, 0x441, 0x430, 0x432, 0x456, 0x43a, 0x3b,
0x43c, 0x430, 0x439, 0x3b, 0x447, 0x44d, 0x440, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x43b, 0x456, 0x43f, 0x435, 0x43d, 0x44c, 0x3b, 0x436,
0x43d, 0x456, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x432, 0x435, 0x440, 0x430, 0x441, 0x435, 0x43d, 0x44c, 0x3b, 0x43a, 0x430, 0x441, 0x442,
0x440, 0x44b, 0x447, 0x43d, 0x456, 0x43a, 0x3b, 0x43b, 0x456, 0x441, 0x442, 0x430, 0x43f, 0x430, 0x434, 0x3b, 0x441, 0x43d, 0x435, 0x436,
0x430, 0x43d, 0x44c, 0x3b, 0x441, 0x3b, 0x43b, 0x3b, 0x441, 0x3b, 0x43a, 0x3b, 0x442, 0x3b, 0x447, 0x3b, 0x43b, 0x3b, 0x436, 0x3b,
0x432, 0x3b, 0x43a, 0x3b, 0x43b, 0x3b, 0x441, 0x3b, 0x17e1, 0x3b, 0x17e2, 0x3b, 0x17e3, 0x3b, 0x17e4, 0x3b, 0x17e5, 0x3b, 0x17e6, 0x3b,
0x17e7, 0x3b, 0x17e8, 0x3b, 0x17e9, 0x3b, 0x17e1, 0x17e0, 0x3b, 0x17e1, 0x17e1, 0x3b, 0x17e1, 0x17e2, 0x3b, 0x1798, 0x1780, 0x179a, 0x17b6, 0x3b,
0x1780, 0x17bb, 0x1798, 0x17d2, 0x1797, 0x17c8, 0x3b, 0x1798, 0x17b7, 0x1793, 0x17b6, 0x3b, 0x1798, 0x17c1, 0x179f, 0x17b6, 0x3b, 0x17a7, 0x179f, 0x1797,
0x17b6, 0x3b, 0x1798, 0x17b7, 0x1790, 0x17bb, 0x1793, 0x17b6, 0x3b, 0x1780, 0x1780, 0x17d2, 0x1780, 0x178a, 0x17b6, 0x3b, 0x179f, 0x17b8, 0x17a0, 0x17b6,
0x3b, 0x1780, 0x1789, 0x17d2, 0x1789, 0x17b6, 0x3b, 0x178f, 0x17bb, 0x179b, 0x17b6, 0x3b, 0x179c, 0x17b7, 0x1785, 0x17d2, 0x1786, 0x17b7, 0x1780, 0x17b6,
0x3b, 0x1792, 0x17d2, 0x1793, 0x17bc, 0x3b, 0x64, 0x65, 0x20, 0x67, 0x65, 0x6e, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x66, 0x65, 0x62,
0x72, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x64, 0x2019, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x64, 0x65,
0x20, 0x6d, 0x61, 0x69, 0x67, 0x3b, 0x64, 0x65, 0x20, 0x6a, 0x75, 0x6e, 0x79, 0x3b, 0x64, 0x65, 0x20, 0x6a, 0x75, 0x6c,
0x2e, 0x3b, 0x64, 0x2019, 0x61, 0x67, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x73, 0x65, 0x74, 0x2e, 0x3b, 0x64, 0x2019, 0x6f, 0x63,
0x74, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x20, 0x64, 0x65, 0x73, 0x2e, 0x3b, 0x64,
0x65, 0x20, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x20, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x3b, 0x64, 0x65,
0x20, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x64, 0x2019, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x64, 0x65, 0x20, 0x6d, 0x61, 0x69,
0x67, 0x3b, 0x64, 0x65, 0x20, 0x6a, 0x75, 0x6e, 0x79, 0x3b, 0x64, 0x65, 0x20, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x6c, 0x3b,
0x64, 0x2019, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x3b, 0x64, 0x65, 0x20, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b,
0x64, 0x2019, 0x6f, 0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x20, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72,
0x65, 0x3b, 0x64, 0x65, 0x20, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x47, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x47, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x31, 0x6708,
0x3b, 0x32, 0x6708, 0x3b, 0x33, 0x6708, 0x3b, 0x34, 0x6708, 0x3b, 0x35, 0x6708, 0x3b, 0x36, 0x6708, 0x3b, 0x37, 0x6708, 0x3b, 0x38,
0x6708, 0x3b, 0x39, 0x6708, 0x3b, 0x31, 0x30, 0x6708, 0x3b, 0x31, 0x31, 0x6708, 0x3b, 0x31, 0x32, 0x6708, 0x3b, 0x4e00, 0x6708, 0x3b,
0x4e8c, 0x6708, 0x3b, 0x4e09, 0x6708, 0x3b, 0x56db, 0x6708, 0x3b, 0x4e94, 0x6708, 0x3b, 0x516d, 0x6708, 0x3b, 0x4e03, 0x6708, 0x3b, 0x516b, 0x6708,
0x3b, 0x4e5d, 0x6708, 0x3b, 0x5341, 0x6708, 0x3b, 0x5341, 0x4e00, 0x6708, 0x3b, 0x5341, 0x4e8c, 0x6708, 0x3b, 0x73, 0x69, 0x6a, 0x3b, 0x76,
0x65, 0x6c, 0x6a, 0x3b, 0x6f, 0x17e, 0x75, 0x3b, 0x74, 0x72, 0x61, 0x3b, 0x73, 0x76, 0x69, 0x3b, 0x6c, 0x69, 0x70, 0x3b,
0x73, 0x72, 0x70, 0x3b, 0x6b, 0x6f, 0x6c, 0x3b, 0x72, 0x75, 0x6a, 0x3b, 0x6c, 0x69, 0x73, 0x3b, 0x73, 0x74, 0x75, 0x3b,
0x70, 0x72, 0x6f, 0x3b, 0x73, 0x69, 0x6a, 0x65, 0x10d, 0x6e, 0x6a, 0x61, 0x3b, 0x76, 0x65, 0x6c, 0x6a, 0x61, 0x10d, 0x65,
0x3b, 0x6f, 0x17e, 0x75, 0x6a, 0x6b, 0x61, 0x3b, 0x74, 0x72, 0x61, 0x76, 0x6e, 0x6a, 0x61, 0x3b, 0x73, 0x76, 0x69, 0x62,
0x6e, 0x6a, 0x61, 0x3b, 0x6c, 0x69, 0x70, 0x6e, 0x6a, 0x61, 0x3b, 0x73, 0x72, 0x70, 0x6e, 0x6a, 0x61, 0x3b, 0x6b, 0x6f,
0x6c, 0x6f, 0x76, 0x6f, 0x7a, 0x61, 0x3b, 0x72, 0x75, 0x6a, 0x6e, 0x61, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x61,
0x64, 0x61, 0x3b, 0x73, 0x74, 0x75, 0x64, 0x65, 0x6e, 0x6f, 0x67, 0x61, 0x3b, 0x70, 0x72, 0x6f, 0x73, 0x69, 0x6e, 0x63,
0x61, 0x3b, 0x31, 0x2e, 0x3b, 0x32, 0x2e, 0x3b, 0x33, 0x2e, 0x3b, 0x34, 0x2e, 0x3b, 0x35, 0x2e, 0x3b, 0x36, 0x2e, 0x3b,
0x37, 0x2e, 0x3b, 0x38, 0x2e, 0x3b, 0x39, 0x2e, 0x3b, 0x31, 0x30, 0x2e, 0x3b, 0x31, 0x31, 0x2e, 0x3b, 0x31, 0x32, 0x2e,
0x3b, 0x4c, 0x65, 0x64, 0x3b, 0xda, 0x6e, 0x6f, 0x3b, 0x42, 0x159, 0x65, 0x3b, 0x44, 0x75, 0x62, 0x3b, 0x4b, 0x76, 0x11b,
0x3b, 0x10c, 0x65, 0x72, 0x3b, 0x10c, 0x76, 0x63, 0x3b, 0x53, 0x72, 0x70, 0x3b, 0x5a, 0xe1, 0x159, 0x3b, 0x158, 0xed, 0x6a,
0x3b, 0x4c, 0x69, 0x73, 0x3b, 0x50, 0x72, 0x6f, 0x3b, 0x6c, 0x65, 0x64, 0x6e, 0x61, 0x3b, 0xfa, 0x6e, 0x6f, 0x72, 0x61,
0x3b, 0x62, 0x159, 0x65, 0x7a, 0x6e, 0x61, 0x3b, 0x64, 0x75, 0x62, 0x6e, 0x61, 0x3b, 0x6b, 0x76, 0x11b, 0x74, 0x6e, 0x61,
0x3b, 0x10d, 0x65, 0x72, 0x76, 0x6e, 0x61, 0x3b, 0x10d, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x63, 0x65, 0x3b, 0x73, 0x72, 0x70,
0x6e, 0x61, 0x3b, 0x7a, 0xe1, 0x159, 0xed, 0x3b, 0x159, 0xed, 0x6a, 0x6e, 0x61, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70,
0x61, 0x64, 0x75, 0x3b, 0x70, 0x72, 0x6f, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65,
0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e,
0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74,
0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66,
0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d,
0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b,
0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f,
0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x2e,
0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x72, 0x74, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x65, 0x69, 0x3b,
0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b,
0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61,
0x72, 0x69, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x6d, 0x61, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70,
0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x65, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75,
0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74,
0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc30, 0xd801, 0xdc4c, 0x3b, 0xd801, 0xdc19, 0xd801, 0xdc2f, 0xd801, 0xdc3a, 0x3b, 0xd801, 0xdc23, 0xd801,
0xdc2a, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc01, 0xd801, 0xdc39, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc23, 0xd801, 0xdc29, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc2d,
0xd801, 0xdc4c, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc2d, 0xd801, 0xdc4a, 0x3b, 0xd801, 0xdc02, 0xd801, 0xdc40, 0x3b, 0xd801, 0xdc1d, 0xd801, 0xdc2f, 0xd801,
0xdc39, 0x3b, 0xd801, 0xdc09, 0xd801, 0xdc3f, 0xd801, 0xdc3b, 0x3b, 0xd801, 0xdc24, 0xd801, 0xdc2c, 0xd801, 0xdc42, 0x3b, 0xd801, 0xdc14, 0xd801, 0xdc28,
0xd801, 0xdc45, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc30, 0xd801, 0xdc4c, 0xd801, 0xdc37, 0xd801, 0xdc2d, 0xd801, 0xdc2f, 0xd801, 0xdc49, 0xd801, 0xdc28, 0x3b,
0xd801, 0xdc19, 0xd801, 0xdc2f, 0xd801, 0xdc3a, 0xd801, 0xdc49, 0xd801, 0xdc2d, 0xd801, 0xdc2f, 0xd801, 0xdc49, 0xd801, 0xdc28, 0x3b, 0xd801, 0xdc23, 0xd801,
0xdc2a, 0xd801, 0xdc49, 0xd801, 0xdc3d, 0x3b, 0xd801, 0xdc01, 0xd801, 0xdc39, 0xd801, 0xdc49, 0xd801, 0xdc2e, 0xd801, 0xdc4a, 0x3b, 0xd801, 0xdc23, 0xd801,
0xdc29, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc2d, 0xd801, 0xdc4c, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc2d, 0xd801, 0xdc4a, 0xd801, 0xdc34, 0x3b, 0xd801, 0xdc02,
0xd801, 0xdc40, 0xd801, 0xdc32, 0xd801, 0xdc45, 0xd801, 0xdc3b, 0x3b, 0xd801, 0xdc1d, 0xd801, 0xdc2f, 0xd801, 0xdc39, 0xd801, 0xdc3b, 0xd801, 0xdc2f, 0xd801,
0xdc4b, 0xd801, 0xdc3a, 0xd801, 0xdc32, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc09, 0xd801, 0xdc3f, 0xd801, 0xdc3b, 0xd801, 0xdc2c, 0xd801, 0xdc3a, 0xd801, 0xdc32,
0xd801, 0xdc49, 0x3b, 0xd801, 0xdc24, 0xd801, 0xdc2c, 0xd801, 0xdc42, 0xd801, 0xdc2f, 0xd801, 0xdc4b, 0xd801, 0xdc3a, 0xd801, 0xdc32, 0xd801, 0xdc49, 0x3b,
0xd801, 0xdc14, 0xd801, 0xdc28, 0xd801, 0xdc45, 0xd801, 0xdc2f, 0xd801, 0xdc4b, 0xd801, 0xdc3a, 0xd801, 0xdc32, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc16, 0x3b,
0xd801, 0xdc19, 0x3b, 0xd801, 0xdc23, 0x3b, 0xd801, 0xdc01, 0x3b, 0xd801, 0xdc23, 0x3b, 0xd801, 0xdc16, 0x3b, 0xd801, 0xdc16, 0x3b, 0xd801, 0xdc02,
0x3b, 0xd801, 0xdc1d, 0x3b, 0xd801, 0xdc09, 0x3b, 0xd801, 0xdc24, 0x3b, 0xd801, 0xdc14, 0x3b, 0x6a, 0x61, 0x61, 0x6e, 0x3b, 0x76, 0x65,
0x65, 0x62, 0x72, 0x3b, 0x6d, 0xe4, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75,
0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x3b, 0x6f,
0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x74, 0x73, 0x3b, 0x6a, 0x61, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b,
0x76, 0x65, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0xe4, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c,
0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75,
0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x6f,
0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x74, 0x73, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x56, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53,
0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61,
0x70, 0x72, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73,
0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x73, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61,
0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0xed, 0x6c,
0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73,
0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b,
0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x74, 0x61,
0x6d, 0x6d, 0x69, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x68, 0x65, 0x6c, 0x6d, 0x69, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b,
0x6d, 0x61, 0x61, 0x6c, 0x69, 0x73, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x68, 0x75, 0x68, 0x74, 0x69, 0x6b, 0x75, 0x75,
0x74, 0x61, 0x3b, 0x74, 0x6f, 0x75, 0x6b, 0x6f, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6b, 0x65, 0x73, 0xe4, 0x6b, 0x75,
0x75, 0x74, 0x61, 0x3b, 0x68, 0x65, 0x69, 0x6e, 0xe4, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x65, 0x6c, 0x6f, 0x6b, 0x75,
0x75, 0x74, 0x61, 0x3b, 0x73, 0x79, 0x79, 0x73, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6c, 0x6f, 0x6b, 0x61, 0x6b, 0x75,
0x75, 0x74, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x72, 0x61, 0x73, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6a, 0x6f, 0x75, 0x6c,
0x75, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x54, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x48,
0x3b, 0x45, 0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x2e, 0x3b, 0x66, 0xe9, 0x76,
0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x69,
0x6e, 0x3b, 0x6a, 0x75, 0x69, 0x6c, 0x2e, 0x3b, 0x61, 0x6f, 0xfb, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f,
0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0xe9, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x69, 0x65,
0x72, 0x3b, 0x66, 0xe9, 0x76, 0x72, 0x69, 0x65, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x69, 0x6c,
0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x69, 0x6e, 0x3b, 0x6a, 0x75, 0x69, 0x6c, 0x6c, 0x65, 0x74, 0x3b, 0x61, 0x6f,
0xfb, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x6f, 0x62, 0x72, 0x65,
0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0xe9, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x58,
0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x58,
0x75, 0xf1, 0x3b, 0x58, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x75, 0x74, 0x3b, 0x4e,
0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x58, 0x61, 0x6e, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x65,
0x69, 0x72, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x6f,
0x3b, 0x58, 0x75, 0xf1, 0x6f, 0x3b, 0x58, 0x75, 0x6c, 0x6c, 0x6f, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53,
0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x4f, 0x75, 0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x4e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x58, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x58, 0x3b, 0x58, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x10d8, 0x10d0,
0x10dc, 0x3b, 0x10d7, 0x10d4, 0x10d1, 0x3b, 0x10db, 0x10d0, 0x10e0, 0x3b, 0x10d0, 0x10de, 0x10e0, 0x3b, 0x10db, 0x10d0, 0x10d8, 0x3b, 0x10d8, 0x10d5,
0x10dc, 0x3b, 0x10d8, 0x10d5, 0x10da, 0x3b, 0x10d0, 0x10d2, 0x10d5, 0x3b, 0x10e1, 0x10d4, 0x10e5, 0x3b, 0x10dd, 0x10e5, 0x10e2, 0x3b, 0x10dc, 0x10dd,
0x10d4, 0x3b, 0x10d3, 0x10d4, 0x10d9, 0x3b, 0x10d8, 0x10d0, 0x10dc, 0x10d5, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x10d7, 0x10d4, 0x10d1, 0x10d4, 0x10e0, 0x10d5,
0x10d0, 0x10da, 0x10d8, 0x3b, 0x10db, 0x10d0, 0x10e0, 0x10e2, 0x10d8, 0x3b, 0x10d0, 0x10de, 0x10e0, 0x10d8, 0x10da, 0x10d8, 0x3b, 0x10db, 0x10d0, 0x10d8,
0x10e1, 0x10d8, 0x3b, 0x10d8, 0x10d5, 0x10dc, 0x10d8, 0x10e1, 0x10d8, 0x3b, 0x10d8, 0x10d5, 0x10da, 0x10d8, 0x10e1, 0x3b, 0x10d0, 0x10d2, 0x10d5, 0x10d8,
0x10e1, 0x10e2, 0x10dd, 0x3b, 0x10e1, 0x10d4, 0x10e5, 0x10e2, 0x10d4, 0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10dd, 0x10e5, 0x10e2, 0x10dd, 0x10db,
0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10dc, 0x10dd, 0x10d4, 0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10d3, 0x10d4, 0x10d9, 0x10d4, 0x10db, 0x10d1,
0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10d8, 0x3b, 0x10d7, 0x3b, 0x10db, 0x3b, 0x10d0, 0x3b, 0x10db, 0x3b, 0x10d8, 0x3b, 0x10d8, 0x3b, 0x10d0, 0x3b,
0x10e1, 0x3b, 0x10dd, 0x3b, 0x10dc, 0x3b, 0x10d3, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0xe4, 0x72, 0x3b,
0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b,
0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x7a, 0x3b, 0x4a, 0x61, 0x6e, 0x75,
0x61, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x69,
0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75,
0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72,
0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a,
0xe4, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0xe4, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a,
0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e,
0x6f, 0x76, 0x3b, 0x44, 0x65, 0x7a, 0x3b, 0x4a, 0xe4, 0x6e, 0x6e, 0x65, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61,
0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e,
0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x399, 0x3b1, 0x3bd, 0x3b, 0x3a6, 0x3b5, 0x3b2, 0x3b, 0x39c, 0x3b1,
0x3c1, 0x3b, 0x391, 0x3c0, 0x3c1, 0x3b, 0x39c, 0x3b1, 0x3ca, 0x3b, 0x399, 0x3bf, 0x3c5, 0x3bd, 0x3b, 0x399, 0x3bf, 0x3c5, 0x3bb, 0x3b,
0x391, 0x3c5, 0x3b3, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3b, 0x39f, 0x3ba, 0x3c4, 0x3b, 0x39d, 0x3bf, 0x3b5, 0x3b, 0x394, 0x3b5, 0x3ba, 0x3b,
0x399, 0x3b1, 0x3bd, 0x3bf, 0x3c5, 0x3b1, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x3a6, 0x3b5, 0x3b2, 0x3c1, 0x3bf, 0x3c5, 0x3b1, 0x3c1, 0x3af,
0x3bf, 0x3c5, 0x3b, 0x39c, 0x3b1, 0x3c1, 0x3c4, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x391, 0x3c0, 0x3c1, 0x3b9, 0x3bb, 0x3af, 0x3bf, 0x3c5, 0x3b,
0x39c, 0x3b1, 0x390, 0x3bf, 0x3c5, 0x3b, 0x399, 0x3bf, 0x3c5, 0x3bd, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x399, 0x3bf, 0x3c5, 0x3bb, 0x3af, 0x3bf,
0x3c5, 0x3b, 0x391, 0x3c5, 0x3b3, 0x3bf, 0x3cd, 0x3c3, 0x3c4, 0x3bf, 0x3c5, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3c4, 0x3b5, 0x3bc, 0x3b2, 0x3c1,
0x3af, 0x3bf, 0x3c5, 0x3b, 0x39f, 0x3ba, 0x3c4, 0x3c9, 0x3b2, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x39d, 0x3bf, 0x3b5, 0x3bc, 0x3b2, 0x3c1,
0x3af, 0x3bf, 0x3c5, 0x3b, 0x394, 0x3b5, 0x3ba, 0x3b5, 0x3bc, 0x3b2, 0x3c1, 0x3af, 0x3bf, 0x3c5, 0x3b, 0x399, 0x3b, 0x3a6, 0x3b, 0x39c,
0x3b, 0x391, 0x3b, 0x39c, 0x3b, 0x399, 0x3b, 0x399, 0x3b, 0x391, 0x3b, 0x3a3, 0x3b, 0x39f, 0x3b, 0x39d, 0x3b, 0x394, 0x3b, 0x6a,
0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a,
0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e,
0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75,
0x61, 0x72, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x69, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x3b, 0x6d, 0x61,
0x6a, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75,
0x73, 0x69, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x69, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65,
0x72, 0x69, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x69, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65,
0x72, 0x69, 0x3b, 0xa9c, 0xabe, 0xaa8, 0xacd, 0xaaf, 0xac1, 0x3b, 0xaab, 0xac7, 0xaac, 0xacd, 0xab0, 0xac1, 0x3b, 0xaae, 0xabe, 0xab0,
0xacd, 0xa9a, 0x3b, 0xa8f, 0xaaa, 0xacd, 0xab0, 0xabf, 0xab2, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2, 0xaa8, 0x3b, 0xa9c, 0xac1, 0xab2,
0xabe, 0xa88, 0x3b, 0xa91, 0xa97, 0xab8, 0xacd, 0xa9f, 0x3b, 0xab8, 0xaaa, 0xacd, 0xa9f, 0xac7, 0x3b, 0xa91, 0xa95, 0xacd, 0xa9f, 0xacb,
0x3b, 0xaa8, 0xab5, 0xac7, 0x3b, 0xaa1, 0xabf, 0xab8, 0xac7, 0x3b, 0xa9c, 0xabe, 0xaa8, 0xacd, 0xaaf, 0xac1, 0xa86, 0xab0, 0xac0, 0x3b,
0xaab, 0xac7, 0xaac, 0xacd, 0xab0, 0xac1, 0xa86, 0xab0, 0xac0, 0x3b, 0xaae, 0xabe, 0xab0, 0xacd, 0xa9a, 0x3b, 0xa8f, 0xaaa, 0xacd, 0xab0,
0xabf, 0xab2, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2, 0xaa8, 0x3b, 0xa9c, 0xac1, 0xab2, 0xabe, 0xa88, 0x3b, 0xa91, 0xa97, 0xab8, 0xacd,
0xa9f, 0x3b, 0xab8, 0xaaa, 0xacd, 0xa9f, 0xac7, 0xaae, 0xacd, 0xaac, 0xab0, 0x3b, 0xa91, 0xa95, 0xacd, 0xa9f, 0xacd, 0xaac, 0xab0, 0x3b,
0xaa8, 0xab5, 0xac7, 0xaae, 0xacd, 0xaac, 0xab0, 0x3b, 0xaa1, 0xabf, 0xab8, 0xac7, 0xaae, 0xacd, 0xaac, 0xab0, 0x3b, 0xa9c, 0xabe, 0x3b,
0xaab, 0xac7, 0x3b, 0xaae, 0xabe, 0x3b, 0xa8f, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2, 0x3b, 0xa9c, 0xac1, 0x3b, 0xa91, 0x3b, 0xab8,
0x3b, 0xa91, 0x3b, 0xaa8, 0x3b, 0xaa1, 0xabf, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x61, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b,
0x41, 0x66, 0x69, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x75, 0x3b,
0x53, 0x61, 0x74, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x75, 0x77, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x61,
0x69, 0x72, 0x75, 0x3b, 0x46, 0x61, 0x62, 0x75, 0x72, 0x61, 0x69, 0x72, 0x75, 0x3b, 0x4d, 0x61, 0x72, 0x69, 0x73, 0x3b,
0x41, 0x66, 0x69, 0x72, 0x69, 0x6c, 0x75, 0x3b, 0x4d, 0x61, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6e, 0x69, 0x3b, 0x59, 0x75,
0x6c, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x74, 0x75, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b,
0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x75, 0x77, 0x61, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x61, 0x6d, 0x62, 0x61,
0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f,
0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x5d9, 0x5e0, 0x5d5, 0x3b, 0x5e4, 0x5d1, 0x5e8, 0x3b, 0x5de, 0x5e8, 0x5e5, 0x3b, 0x5d0, 0x5e4, 0x5e8,
0x3b, 0x5de, 0x5d0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5e0, 0x3b, 0x5d9, 0x5d5, 0x5dc, 0x3b, 0x5d0, 0x5d5, 0x5d2, 0x3b, 0x5e1, 0x5e4, 0x5d8,
0x3b, 0x5d0, 0x5d5, 0x5e7, 0x3b, 0x5e0, 0x5d5, 0x5d1, 0x3b, 0x5d3, 0x5e6, 0x5de, 0x3b, 0x5d9, 0x5e0, 0x5d5, 0x5d0, 0x5e8, 0x3b, 0x5e4,
0x5d1, 0x5e8, 0x5d5, 0x5d0, 0x5e8, 0x3b, 0x5de, 0x5e8, 0x5e5, 0x3b, 0x5d0, 0x5e4, 0x5e8, 0x5d9, 0x5dc, 0x3b, 0x5de, 0x5d0, 0x5d9, 0x3b,
0x5d9, 0x5d5, 0x5e0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dc, 0x5d9, 0x3b, 0x5d0, 0x5d5, 0x5d2, 0x5d5, 0x5e1, 0x5d8, 0x3b, 0x5e1, 0x5e4, 0x5d8,
0x5de, 0x5d1, 0x5e8, 0x3b, 0x5d0, 0x5d5, 0x5e7, 0x5d8, 0x5d5, 0x5d1, 0x5e8, 0x3b, 0x5e0, 0x5d5, 0x5d1, 0x5de, 0x5d1, 0x5e8, 0x3b, 0x5d3,
0x5e6, 0x5de, 0x5d1, 0x5e8, 0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940, 0x3b, 0x92b, 0x930, 0x935, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930,
0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x948, 0x932, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932,
0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x924, 0x3b, 0x938, 0x93f, 0x924, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d,
0x924, 0x942, 0x92c, 0x930, 0x3b, 0x928, 0x935, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x926, 0x93f, 0x938, 0x92e, 0x94d, 0x92c, 0x930, 0x3b,
0x91c, 0x3b, 0x92b, 0x93c, 0x3b, 0x92e, 0x93e, 0x3b, 0x905, 0x3b, 0x92e, 0x3b, 0x91c, 0x942, 0x3b, 0x91c, 0x941, 0x3b, 0x905, 0x3b,
0x938, 0x93f, 0x3b, 0x905, 0x3b, 0x928, 0x3b, 0x926, 0x93f, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x2e,
0x3b, 0x6d, 0xe1, 0x72, 0x63, 0x2e, 0x3b, 0xe1, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0xe1, 0x6a, 0x2e, 0x3b, 0x6a, 0xfa, 0x6e,
0x2e, 0x3b, 0x6a, 0xfa, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x7a, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f,
0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0xe1, 0x72,
0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0xe1, 0x72, 0x3b, 0x6d, 0xe1, 0x72, 0x63, 0x69, 0x75, 0x73, 0x3b, 0xe1, 0x70, 0x72,
0x69, 0x6c, 0x69, 0x73, 0x3b, 0x6d, 0xe1, 0x6a, 0x75, 0x73, 0x3b, 0x6a, 0xfa, 0x6e, 0x69, 0x75, 0x73, 0x3b, 0x6a, 0xfa,
0x6c, 0x69, 0x75, 0x73, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x7a, 0x74, 0x75, 0x73, 0x3b, 0x73, 0x7a, 0x65, 0x70, 0x74,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0xf3, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0xc1, 0x3b,
0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0xc1, 0x3b, 0x53, 0x7a, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x6a, 0x61, 0x6e,
0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0xed, 0x3b, 0x6a, 0xfa, 0x6e,
0x3b, 0x6a, 0xfa, 0x6c, 0x3b, 0xe1, 0x67, 0xfa, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0xf3, 0x76,
0x3b, 0x64, 0x65, 0x73, 0x3b, 0x6a, 0x61, 0x6e, 0xfa, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0xfa, 0x61, 0x72, 0x3b,
0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0xed, 0x6c, 0x3b, 0x6d, 0x61, 0xed, 0x3b, 0x6a, 0xfa, 0x6e, 0xed, 0x3b,
0x6a, 0xfa, 0x6c, 0xed, 0x3b, 0xe1, 0x67, 0xfa, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x6f, 0x6b, 0x74, 0xf3, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0xf3, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65,
0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a,
0x3b, 0xc1, 0x3b, 0x4c, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d,
0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41,
0x67, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a,
0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x72, 0x65,
0x74, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c,
0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x73,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x31, 0x3b, 0x46, 0x65, 0x61, 0x62, 0x68, 0x72, 0x61, 0x3b, 0x33, 0x3b, 0x34, 0x3b,
0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0x67,
0x65, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x67, 0x3b, 0x67,
0x69, 0x75, 0x3b, 0x6c, 0x75, 0x67, 0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x3b, 0x6f, 0x74, 0x74, 0x3b, 0x6e,
0x6f, 0x76, 0x3b, 0x64, 0x69, 0x63, 0x3b, 0x67, 0x65, 0x6e, 0x6e, 0x61, 0x69, 0x6f, 0x3b, 0x66, 0x65, 0x62, 0x62, 0x72,
0x61, 0x69, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x65, 0x3b, 0x6d, 0x61, 0x67,
0x67, 0x69, 0x6f, 0x3b, 0x67, 0x69, 0x75, 0x67, 0x6e, 0x6f, 0x3b, 0x6c, 0x75, 0x67, 0x6c, 0x69, 0x6f, 0x3b, 0x61, 0x67,
0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x74, 0x74, 0x6f, 0x62,
0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x69, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x65,
0x3b, 0x47, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f,
0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0xc9c, 0xca8, 0xcb5, 0xcb0, 0xcc0, 0x3b, 0xcab, 0xcc6, 0xcac, 0xccd, 0xcb0, 0xcb5, 0xcb0, 0xcc0, 0x3b,
0xcae, 0xcbe, 0xcb0, 0xccd, 0xc9a, 0xccd, 0x3b, 0xc8e, 0xcaa, 0xccd, 0xcb0, 0xcbf, 0xcb2, 0xccd, 0x3b, 0xcae, 0xcc6, 0x3b, 0xc9c, 0xcc2,
0xca8, 0xccd, 0x3b, 0xc9c, 0xcc1, 0xcb2, 0xcc8, 0x3b, 0xc86, 0xc97, 0xcb8, 0xccd, 0xc9f, 0xccd, 0x3b, 0xcb8, 0xcaa, 0xccd, 0xc9f, 0xcc6,
0xc82, 0xcac, 0xcb0, 0xccd, 0x3b, 0xc85, 0xc95, 0xccd, 0xc9f, 0xccb, 0xcac, 0xcb0, 0xccd, 0x3b, 0xca8, 0xcb5, 0xcc6, 0xc82, 0xcac, 0xcb0,
0xccd, 0x3b, 0xca1, 0xcbf, 0xcb8, 0xcc6, 0xc82, 0xcac, 0xcb0, 0xccd, 0x3b, 0xc9c, 0x3b, 0xcab, 0xcc6, 0x3b, 0xcae, 0xcbe, 0x3b, 0xc8e,
0x3b, 0xcae, 0xcc7, 0x3b, 0xc9c, 0xcc2, 0x3b, 0xc9c, 0xcc1, 0x3b, 0xc86, 0x3b, 0xcb8, 0xcc6, 0x3b, 0xc85, 0x3b, 0xca8, 0x3b, 0xca1,
0xcbf, 0x3b, 0x49b, 0x430, 0x4a3, 0x2e, 0x3b, 0x430, 0x49b, 0x43f, 0x2e, 0x3b, 0x43d, 0x430, 0x443, 0x2e, 0x3b, 0x441, 0x4d9, 0x443,
0x2e, 0x3b, 0x43c, 0x430, 0x43c, 0x2e, 0x3b, 0x43c, 0x430, 0x443, 0x2e, 0x3b, 0x448, 0x456, 0x43b, 0x2e, 0x3b, 0x442, 0x430, 0x43c,
0x2e, 0x3b, 0x49b, 0x44b, 0x440, 0x2e, 0x3b, 0x49b, 0x430, 0x437, 0x2e, 0x3b, 0x49b, 0x430, 0x440, 0x2e, 0x3b, 0x436, 0x435, 0x43b,
0x442, 0x2e, 0x3b, 0x49b, 0x430, 0x4a3, 0x442, 0x430, 0x440, 0x3b, 0x430, 0x49b, 0x43f, 0x430, 0x43d, 0x3b, 0x43d, 0x430, 0x443, 0x440,
0x44b, 0x437, 0x3b, 0x441, 0x4d9, 0x443, 0x456, 0x440, 0x3b, 0x43c, 0x430, 0x43c, 0x44b, 0x440, 0x3b, 0x43c, 0x430, 0x443, 0x441, 0x44b,
0x43c, 0x3b, 0x448, 0x456, 0x43b, 0x434, 0x435, 0x3b, 0x442, 0x430, 0x43c, 0x44b, 0x437, 0x3b, 0x49b, 0x44b, 0x440, 0x43a, 0x4af, 0x439,
0x435, 0x43a, 0x3b, 0x49b, 0x430, 0x437, 0x430, 0x43d, 0x3b, 0x49b, 0x430, 0x440, 0x430, 0x448, 0x430, 0x3b, 0x436, 0x435, 0x43b, 0x442,
0x43e, 0x49b, 0x441, 0x430, 0x43d, 0x3b, 0x6d, 0x75, 0x74, 0x2e, 0x3b, 0x67, 0x61, 0x73, 0x2e, 0x3b, 0x77, 0x65, 0x72, 0x2e,
0x3b, 0x6d, 0x61, 0x74, 0x2e, 0x3b, 0x67, 0x69, 0x63, 0x2e, 0x3b, 0x6b, 0x61, 0x6d, 0x2e, 0x3b, 0x6e, 0x79, 0x61, 0x2e,
0x3b, 0x6b, 0x61, 0x6e, 0x2e, 0x3b, 0x6e, 0x7a, 0x65, 0x2e, 0x3b, 0x75, 0x6b, 0x77, 0x2e, 0x3b, 0x75, 0x67, 0x75, 0x2e,
0x3b, 0x75, 0x6b, 0x75, 0x2e, 0x3b, 0x4d, 0x75, 0x74, 0x61, 0x72, 0x61, 0x6d, 0x61, 0x3b, 0x47, 0x61, 0x73, 0x68, 0x79,
0x61, 0x6e, 0x74, 0x61, 0x72, 0x65, 0x3b, 0x57, 0x65, 0x72, 0x75, 0x72, 0x77, 0x65, 0x3b, 0x4d, 0x61, 0x74, 0x61, 0x3b,
0x47, 0x69, 0x63, 0x75, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x3b, 0x4b, 0x61, 0x6d, 0x65, 0x6e, 0x61, 0x3b, 0x4e, 0x79, 0x61,
0x6b, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x4b, 0x61, 0x6e, 0x61, 0x6d, 0x61, 0x3b, 0x4e, 0x7a, 0x65, 0x6c, 0x69, 0x3b, 0x55,
0x6b, 0x77, 0x61, 0x6b, 0x69, 0x72, 0x61, 0x3b, 0x55, 0x67, 0x75, 0x73, 0x68, 0x79, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x55,
0x6b, 0x75, 0x62, 0x6f, 0x7a, 0x61, 0x3b, 0x31, 0xc6d4, 0x3b, 0x32, 0xc6d4, 0x3b, 0x33, 0xc6d4, 0x3b, 0x34, 0xc6d4, 0x3b, 0x35,
0xc6d4, 0x3b, 0x36, 0xc6d4, 0x3b, 0x37, 0xc6d4, 0x3b, 0x38, 0xc6d4, 0x3b, 0x39, 0xc6d4, 0x3b, 0x31, 0x30, 0xc6d4, 0x3b, 0x31, 0x31,
0xc6d4, 0x3b, 0x31, 0x32, 0xc6d4, 0x3b, 0x6a9, 0x627, 0x646, 0x648, 0x648, 0x646, 0x6cc, 0x20, 0x62f, 0x648, 0x648, 0x6d5, 0x645, 0x3b,
0x634, 0x648, 0x628, 0x627, 0x62a, 0x3b, 0x626, 0x627, 0x632, 0x627, 0x631, 0x3b, 0x646, 0x6cc, 0x633, 0x627, 0x646, 0x3b, 0x626, 0x627,
0x6cc, 0x627, 0x631, 0x3b, 0x62d, 0x648, 0x632, 0x6d5, 0x6cc, 0x631, 0x627, 0x646, 0x3b, 0x62a, 0x6d5, 0x645, 0x648, 0x648, 0x632, 0x3b,
0x626, 0x627, 0x628, 0x3b, 0x626, 0x6d5, 0x6cc, 0x644, 0x648, 0x648, 0x644, 0x3b, 0x62a, 0x634, 0x631, 0x6cc, 0x646, 0x6cc, 0x20, 0x6cc,
0x6d5, 0x6a9, 0x6d5, 0x645, 0x3b, 0x62a, 0x634, 0x631, 0x6cc, 0x646, 0x6cc, 0x20, 0x62f, 0x648, 0x648, 0x6d5, 0x645, 0x3b, 0x6a9, 0x627,
0x646, 0x648, 0x646, 0x6cc, 0x20, 0x6cc, 0x6d5, 0x6a9, 0x6d5, 0x645, 0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35,
0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x44, 0x3b, 0xe7, 0x69, 0x6c,
0x3b, 0x73, 0x69, 0x62, 0x3b, 0x61, 0x64, 0x72, 0x3b, 0x6e, 0xee, 0x73, 0x3b, 0x67, 0x75, 0x6c, 0x3b, 0x68, 0x65, 0x7a,
0x3b, 0x74, 0xee, 0x72, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0xe7, 0x69,
0x6c, 0x65, 0x3b, 0x73, 0x69, 0x62, 0x61, 0x74, 0x3b, 0x61, 0x64, 0x61, 0x72, 0x3b, 0x6e, 0xee, 0x73, 0x61, 0x6e, 0x3b,
0x67, 0x75, 0x6c, 0x61, 0x6e, 0x3b, 0x68, 0x65, 0x7a, 0xee, 0x72, 0x61, 0x6e, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b,
0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0xe7, 0x3b, 0x73, 0x3b, 0x61, 0x3b, 0x6e, 0x3b, 0x67, 0x3b, 0x68,
0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0x4d, 0x75, 0x74, 0x2e,
0x3b, 0x47, 0x61, 0x73, 0x2e, 0x3b, 0x57, 0x65, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x74, 0x2e, 0x3b, 0x47, 0x69, 0x63, 0x2e,
0x3b, 0x4b, 0x61, 0x6d, 0x2e, 0x3b, 0x4e, 0x79, 0x61, 0x2e, 0x3b, 0x4b, 0x61, 0x6e, 0x2e, 0x3b, 0x4e, 0x7a, 0x65, 0x2e,
0x3b, 0x55, 0x6b, 0x77, 0x2e, 0x3b, 0x55, 0x67, 0x75, 0x2e, 0x3b, 0x55, 0x6b, 0x75, 0x2e, 0x3b, 0x4e, 0x7a, 0x65, 0x72,
0x6f, 0x3b, 0x52, 0x75, 0x68, 0x75, 0x68, 0x75, 0x6d, 0x61, 0x3b, 0x4e, 0x74, 0x77, 0x61, 0x72, 0x61, 0x6e, 0x74, 0x65,
0x3b, 0x4e, 0x64, 0x61, 0x6d, 0x75, 0x6b, 0x69, 0x7a, 0x61, 0x3b, 0x52, 0x75, 0x73, 0x61, 0x6d, 0x61, 0x3b, 0x52, 0x75,
0x68, 0x65, 0x73, 0x68, 0x69, 0x3b, 0x4d, 0x75, 0x6b, 0x61, 0x6b, 0x61, 0x72, 0x6f, 0x3b, 0x4e, 0x79, 0x61, 0x6e, 0x64,
0x61, 0x67, 0x61, 0x72, 0x6f, 0x3b, 0x4e, 0x79, 0x61, 0x6b, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x47, 0x69, 0x74, 0x75, 0x67,
0x75, 0x74, 0x75, 0x3b, 0x4d, 0x75, 0x6e, 0x79, 0x6f, 0x6e, 0x79, 0x6f, 0x3b, 0x4b, 0x69, 0x67, 0x61, 0x72, 0x61, 0x6d,
0x61, 0x3b, 0xea1, 0x2e, 0xe81, 0x2e, 0x3b, 0xe81, 0x2e, 0xe9e, 0x2e, 0x3b, 0xea1, 0xeb5, 0x2e, 0xe99, 0x2e, 0x3b, 0xea1, 0x2e,
0xeaa, 0x2e, 0x2e, 0x3b, 0xe9e, 0x2e, 0xe9e, 0x2e, 0x3b, 0xea1, 0xeb4, 0x2e, 0xe96, 0x2e, 0x3b, 0xe81, 0x2e, 0xea5, 0x2e, 0x3b,
0xeaa, 0x2e, 0xeab, 0x2e, 0x3b, 0xe81, 0x2e, 0xe8d, 0x2e, 0x3b, 0xe95, 0x2e, 0xea5, 0x2e, 0x3b, 0xe9e, 0x2e, 0xe88, 0x2e, 0x3b,
0xe97, 0x2e, 0xea7, 0x2e, 0x3b, 0xea1, 0xeb1, 0xe87, 0xe81, 0xead, 0xe99, 0x3b, 0xe81, 0xeb8, 0xea1, 0xe9e, 0xeb2, 0x3b, 0xea1, 0xeb5,
0xe99, 0xeb2, 0x3b, 0xec0, 0xea1, 0xeaa, 0xeb2, 0x3b, 0xe9e, 0xeb6, 0xe94, 0xeaa, 0xeb0, 0xe9e, 0xeb2, 0x3b, 0xea1, 0xeb4, 0xe96, 0xeb8,
0xe99, 0xeb2, 0x3b, 0xe81, 0xecd, 0xea5, 0xeb0, 0xe81, 0xebb, 0xe94, 0x3b, 0xeaa, 0xeb4, 0xe87, 0xeab, 0xeb2, 0x3b, 0xe81, 0xeb1, 0xe99,
0xe8d, 0xeb2, 0x3b, 0xe95, 0xeb8, 0xea5, 0xeb2, 0x3b, 0xe9e, 0xeb0, 0xe88, 0xeb4, 0xe81, 0x3b, 0xe97, 0xeb1, 0xe99, 0xea7, 0xeb2, 0x3b,
0x6a, 0x61, 0x6e, 0x76, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70,
0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x6a, 0x73, 0x3b, 0x6a, 0x16b, 0x6e, 0x2e, 0x3b, 0x6a, 0x16b, 0x6c, 0x2e, 0x3b, 0x61,
0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b,
0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x101, 0x72, 0x69, 0x73, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x101,
0x72, 0x69, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x12b, 0x6c, 0x69, 0x73, 0x3b, 0x6d, 0x61,
0x69, 0x6a, 0x73, 0x3b, 0x6a, 0x16b, 0x6e, 0x69, 0x6a, 0x73, 0x3b, 0x6a, 0x16b, 0x6c, 0x69, 0x6a, 0x73, 0x3b, 0x61, 0x75,
0x67, 0x75, 0x73, 0x74, 0x73, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x6f, 0x6b, 0x74,
0x6f, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x64, 0x65, 0x63, 0x65,
0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x79, 0x61, 0x6e, 0x3b, 0x66, 0x62, 0x6c, 0x3b, 0x6d, 0x73, 0x69, 0x3b, 0x61, 0x70,
0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x79, 0x75, 0x6e, 0x3b, 0x79, 0x75, 0x6c, 0x3b, 0x61, 0x67, 0x74, 0x3b, 0x73, 0x74,
0x62, 0x3b, 0x254, 0x74, 0x62, 0x3b, 0x6e, 0x76, 0x62, 0x3b, 0x64, 0x73, 0x62, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20,
0x79, 0x61, 0x20, 0x79, 0x61, 0x6d, 0x62, 0x6f, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed,
0x62, 0x61, 0x6c, 0xe9, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x73, 0xe1, 0x74, 0x6f,
0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x6e, 0x65, 0x69, 0x3b, 0x73, 0xe1, 0x6e, 0x7a,
0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x74, 0xe1, 0x6e, 0x6f, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61,
0x20, 0x6d, 0x6f, 0x74, 0xf3, 0x62, 0xe1, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6e, 0x73, 0x61,
0x6d, 0x62, 0x6f, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0x77, 0x61, 0x6d, 0x62, 0x65, 0x3b,
0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6c, 0x69, 0x62, 0x77, 0x61, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1,
0x20, 0x79, 0x61, 0x20, 0x7a, 0xf3, 0x6d, 0x69, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x7a, 0xf3,
0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x254, 0x30c, 0x6b, 0x254, 0x301, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79,
0x61, 0x20, 0x7a, 0xf3, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0xed, 0x62, 0x61, 0x6c, 0xe9, 0x3b, 0x79, 0x3b, 0x66,
0x3b, 0x6d, 0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x79, 0x3b, 0x79, 0x3b, 0x61, 0x3b, 0x73, 0x3b, 0x254, 0x3b, 0x6e, 0x3b, 0x64,
0x3b, 0x53, 0x61, 0x75, 0x73, 0x2e, 0x3b, 0x56, 0x61, 0x73, 0x3b, 0x4b, 0x6f, 0x76, 0x2e, 0x3b, 0x42, 0x61, 0x6c, 0x2e,
0x3b, 0x47, 0x65, 0x67, 0x2e, 0x3b, 0x42, 0x69, 0x72, 0x2e, 0x3b, 0x4c, 0x69, 0x65, 0x70, 0x2e, 0x3b, 0x52, 0x75, 0x67,
0x70, 0x2e, 0x3b, 0x52, 0x75, 0x67, 0x73, 0x2e, 0x3b, 0x53, 0x70, 0x61, 0x6c, 0x2e, 0x3b, 0x4c, 0x61, 0x70, 0x6b, 0x72,
0x2e, 0x3b, 0x47, 0x72, 0x75, 0x6f, 0x64, 0x2e, 0x3b, 0x73, 0x61, 0x75, 0x73, 0x69, 0x6f, 0x3b, 0x76, 0x61, 0x73, 0x61,
0x72, 0x69, 0x73, 0x3b, 0x6b, 0x6f, 0x76, 0x61, 0x73, 0x3b, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x69, 0x73, 0x3b, 0x67,
0x65, 0x67, 0x75, 0x17e, 0x117, 0x3b, 0x62, 0x69, 0x72, 0x17e, 0x65, 0x6c, 0x69, 0x73, 0x3b, 0x6c, 0x69, 0x65, 0x70, 0x61,
0x3b, 0x72, 0x75, 0x67, 0x70, 0x6a, 0x16b, 0x74, 0x69, 0x73, 0x3b, 0x72, 0x75, 0x67, 0x73, 0x117, 0x6a, 0x69, 0x73, 0x3b,
0x73, 0x70, 0x61, 0x6c, 0x69, 0x73, 0x3b, 0x6c, 0x61, 0x70, 0x6b, 0x72, 0x69, 0x74, 0x69, 0x73, 0x3b, 0x67, 0x72, 0x75,
0x6f, 0x64, 0x69, 0x73, 0x3b, 0x53, 0x3b, 0x56, 0x3b, 0x4b, 0x3b, 0x42, 0x3b, 0x47, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x52,
0x3b, 0x52, 0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x47, 0x3b, 0x458, 0x430, 0x43d, 0x2e, 0x3b, 0x444, 0x435, 0x432, 0x2e, 0x3b, 0x43c,
0x430, 0x440, 0x2e, 0x3b, 0x430, 0x43f, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x2e, 0x3b, 0x458, 0x443,
0x43b, 0x2e, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d,
0x43e, 0x435, 0x43c, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x435, 0x43c, 0x2e, 0x3b, 0x458, 0x430, 0x43d, 0x443, 0x430, 0x440, 0x438, 0x3b,
0x444, 0x435, 0x432, 0x440, 0x443, 0x430, 0x440, 0x438, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x438, 0x43b, 0x3b,
0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x438, 0x3b, 0x458, 0x443, 0x43b, 0x438, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442,
0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43e, 0x43a, 0x442, 0x43e, 0x43c, 0x432, 0x440, 0x438, 0x3b,
0x43d, 0x43e, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x434, 0x435, 0x43a, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x458, 0x3b, 0x444,
0x3b, 0x43c, 0x3b, 0x430, 0x3b, 0x43c, 0x3b, 0x458, 0x3b, 0x458, 0x3b, 0x430, 0x3b, 0x441, 0x3b, 0x43e, 0x3b, 0x43d, 0x3b, 0x434,
0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x79,
0x3b, 0x4a, 0x6f, 0x6e, 0x3b, 0x4a, 0x6f, 0x6c, 0x3b, 0x41, 0x6f, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74,
0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x6f, 0x61, 0x72, 0x79, 0x3b, 0x46, 0x65, 0x62,
0x72, 0x6f, 0x61, 0x72, 0x79, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x73, 0x61, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x79, 0x3b,
0x4d, 0x65, 0x79, 0x3b, 0x4a, 0x6f, 0x6e, 0x61, 0x3b, 0x4a, 0x6f, 0x6c, 0x61, 0x79, 0x3b, 0x41, 0x6f, 0x67, 0x6f, 0x73,
0x69, 0x74, 0x72, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x61, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62,
0x72, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x61, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x61, 0x6d, 0x62, 0x72, 0x61,
0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69,
0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x4f, 0x67, 0x6f, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b,
0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65,
0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x69,
0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x4f, 0x67, 0x6f, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b,
0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4f, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0xd1c, 0xd28, 0xd41, 0x3b,
0xd2b, 0xd46, 0xd2c, 0xd4d, 0xd30, 0xd41, 0x3b, 0xd2e, 0xd3e, 0xd30, 0xd4d, 0x200d, 0x3b, 0xd0f, 0xd2a, 0xd4d, 0xd30, 0xd3f, 0x3b, 0xd2e,
0xd47, 0xd2f, 0xd4d, 0x3b, 0xd1c, 0xd42, 0xd23, 0xd4d, 0x200d, 0x3b, 0xd1c, 0xd42, 0xd32, 0xd48, 0x3b, 0xd13, 0xd17, 0x3b, 0xd38, 0xd46,
0xd2a, 0xd4d, 0xd31, 0xd4d, 0xd31, 0xd02, 0x3b, 0xd12, 0xd15, 0xd4d, 0xd1f, 0xd4b, 0x3b, 0xd28, 0xd35, 0xd02, 0x3b, 0xd21, 0xd3f, 0xd38,
0xd02, 0x3b, 0xd1c, 0xd28, 0xd41, 0xd35, 0xd30, 0xd3f, 0x3b, 0xd2b, 0xd46, 0xd2c, 0xd4d, 0xd30, 0xd41, 0xd35, 0xd30, 0xd3f, 0x3b, 0xd2e,
0xd3e, 0xd30, 0xd4d, 0x200d, 0xd1a, 0xd4d, 0xd1a, 0xd4d, 0x3b, 0xd0f, 0xd2a, 0xd4d, 0xd30, 0xd3f, 0xd32, 0xd4d, 0x200d, 0x3b, 0xd2e, 0xd47,
0xd2f, 0xd4d, 0x3b, 0xd1c, 0xd42, 0xd23, 0xd4d, 0x200d, 0x3b, 0xd1c, 0xd42, 0xd32, 0xd48, 0x3b, 0xd06, 0xd17, 0xd38, 0xd4d, 0xd31, 0xd4d,
0xd31, 0xd4d, 0x3b, 0xd38, 0xd46, 0xd2a, 0xd4d, 0xd31, 0xd4d, 0xd31, 0xd02, 0xd2c, 0xd30, 0xd4d, 0x200d, 0x3b, 0xd12, 0xd15, 0xd4d, 0xd1f,
0xd4b, 0xd2c, 0xd30, 0xd4d, 0x200d, 0x3b, 0xd28, 0xd35, 0xd02, 0xd2c, 0xd30, 0xd4d, 0x200d, 0x3b, 0xd21, 0xd3f, 0xd38, 0xd02, 0xd2c, 0xd30,
0xd4d, 0x200d, 0x3b, 0xd1c, 0x3b, 0xd2b, 0xd46, 0x3b, 0xd2e, 0xd3e, 0x3b, 0xd0f, 0x3b, 0xd2e, 0xd47, 0x3b, 0xd1c, 0xd42, 0x3b, 0xd1c,
0xd42, 0x3b, 0xd13, 0x3b, 0xd38, 0xd46, 0x3b, 0xd12, 0x3b, 0xd28, 0x3b, 0xd21, 0xd3f, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x72,
0x61, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x6a, 0x3b, 0x120, 0x75, 0x6e, 0x3b, 0x4c, 0x75,
0x6c, 0x3b, 0x41, 0x77, 0x77, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x74, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69,
0x10b, 0x3b, 0x4a, 0x61, 0x6e, 0x6e, 0x61, 0x72, 0x3b, 0x46, 0x72, 0x61, 0x72, 0x3b, 0x4d, 0x61, 0x72, 0x7a, 0x75, 0x3b,
0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x6a, 0x6a, 0x75, 0x3b, 0x120, 0x75, 0x6e, 0x6a, 0x75, 0x3b, 0x4c, 0x75,
0x6c, 0x6a, 0x75, 0x3b, 0x41, 0x77, 0x77, 0x69, 0x73, 0x73, 0x75, 0x3b, 0x53, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x72,
0x75, 0x3b, 0x4f, 0x74, 0x74, 0x75, 0x62, 0x72, 0x75, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x75, 0x3b, 0x44,
0x69, 0x10b, 0x65, 0x6d, 0x62, 0x72, 0x75, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x120, 0x3b,
0x4c, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x91c, 0x93e, 0x928, 0x947, 0x3b, 0x92b, 0x947, 0x92c,
0x94d, 0x930, 0x941, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x90f, 0x92a, 0x94d, 0x930, 0x93f, 0x3b, 0x92e, 0x947, 0x3b, 0x91c,
0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x948, 0x3b, 0x911, 0x917, 0x3b, 0x938, 0x947, 0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x3b, 0x911,
0x915, 0x94d, 0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x935, 0x94d, 0x939, 0x947, 0x902, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x902,
0x3b, 0x91c, 0x93e, 0x928, 0x947, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x940,
0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x90f, 0x92a, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x928,
0x3b, 0x91c, 0x941, 0x932, 0x948, 0x3b, 0x911, 0x917, 0x938, 0x94d, 0x91f, 0x3b, 0x938, 0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x92c, 0x930,
0x3b, 0x911, 0x915, 0x94d, 0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x935, 0x94d, 0x939, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x921,
0x93f, 0x938, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x91c, 0x93e, 0x3b, 0x92b, 0x947, 0x3b, 0x92e, 0x93e, 0x3b, 0x90f, 0x3b, 0x92e, 0x947,
0x3b, 0x91c, 0x942, 0x3b, 0x91c, 0x941, 0x3b, 0x911, 0x3b, 0x938, 0x3b, 0x911, 0x3b, 0x928, 0x94b, 0x3b, 0x921, 0x93f, 0x3b, 0x445,
0x443, 0x43b, 0x3b, 0x4af, 0x445, 0x44d, 0x3b, 0x431, 0x430, 0x440, 0x3b, 0x442, 0x443, 0x443, 0x3b, 0x43b, 0x443, 0x443, 0x3b, 0x43c,
0x43e, 0x433, 0x3b, 0x43c, 0x43e, 0x440, 0x3b, 0x445, 0x43e, 0x43d, 0x3b, 0x431, 0x438, 0x447, 0x3b, 0x442, 0x430, 0x445, 0x3b, 0x43d,
0x43e, 0x445, 0x3b, 0x433, 0x430, 0x445, 0x3b, 0x425, 0x443, 0x43b, 0x433, 0x430, 0x43d, 0x430, 0x3b, 0x4ae, 0x445, 0x44d, 0x440, 0x3b,
0x411, 0x430, 0x440, 0x3b, 0x422, 0x443, 0x443, 0x43b, 0x430, 0x439, 0x3b, 0x41b, 0x443, 0x443, 0x3b, 0x41c, 0x43e, 0x433, 0x43e, 0x439,
0x3b, 0x41c, 0x43e, 0x440, 0x44c, 0x3b, 0x425, 0x43e, 0x43d, 0x44c, 0x3b, 0x411, 0x438, 0x447, 0x3b, 0x422, 0x430, 0x445, 0x438, 0x430,
0x3b, 0x41d, 0x43e, 0x445, 0x43e, 0x439, 0x3b, 0x413, 0x430, 0x445, 0x430, 0x439, 0x3b, 0x91c, 0x928, 0x3b, 0x92b, 0x947, 0x92c, 0x3b,
0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x93f, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c,
0x941, 0x932, 0x93e, 0x3b, 0x905, 0x917, 0x3b, 0x938, 0x947, 0x92a, 0x94d, 0x91f, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x94b, 0x3b, 0x928,
0x94b, 0x92d, 0x947, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930,
0x941, 0x905, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947,
0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x924, 0x3b, 0x938, 0x947, 0x92a,
0x94d, 0x91f, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x92d, 0x947,
0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x967, 0x3b, 0x968, 0x3b, 0x969, 0x3b,
0x96a, 0x3b, 0x96b, 0x3b, 0x96c, 0x3b, 0x96d, 0x3b, 0x96e, 0x3b, 0x96f, 0x3b, 0x967, 0x966, 0x3b, 0x967, 0x967, 0x3b, 0x967, 0x968,
0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940, 0x3b, 0x92b, 0x930, 0x935, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905,
0x92a, 0x94d, 0x930, 0x947, 0x932, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905,
0x917, 0x938, 0x94d, 0x924, 0x3b, 0x938, 0x947, 0x92a, 0x94d, 0x91f, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x91f,
0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x92d, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x926, 0x93f, 0x938, 0x92e, 0x94d, 0x92c, 0x930,
0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x2e,
0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b,
0x73, 0x65, 0x70, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x73, 0x2e, 0x3b,
0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b,
0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b,
0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74,
0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x67, 0x65, 0x6e, 0x69, 0xe8, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x69, 0xe8, 0x72, 0x3b, 0x6d, 0x61,
0x72, 0xe7, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x68, 0x3b, 0x6a, 0x75,
0x6c, 0x68, 0x65, 0x74, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b,
0x6f, 0x63, 0x74, 0xf2, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x7a,
0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0xb1c, 0xb3e, 0xb28, 0xb41, 0xb06, 0xb30, 0xb40, 0x3b, 0xb2b, 0xb47, 0xb2c, 0xb4d, 0xb30, 0xb41,
0xb5f, 0xb3e, 0xb30, 0xb40, 0x3b, 0xb2e, 0xb3e, 0xb30, 0xb4d, 0xb1a, 0xb4d, 0xb1a, 0x3b, 0xb05, 0xb2a, 0xb4d, 0xb30, 0xb47, 0xb32, 0x3b,
0xb2e, 0xb47, 0x3b, 0xb1c, 0xb41, 0xb28, 0x3b, 0xb1c, 0xb41, 0xb32, 0xb3e, 0xb07, 0x3b, 0xb05, 0xb17, 0xb37, 0xb4d, 0xb1f, 0x3b, 0xb38,
0xb47, 0xb2a, 0xb4d, 0xb1f, 0xb47, 0xb2e, 0xb4d, 0xb2c, 0xb30, 0x3b, 0xb05, 0xb15, 0xb4d, 0xb1f, 0xb4b, 0xb2c, 0xb30, 0x3b, 0xb28, 0xb2d,
0xb47, 0xb2e, 0xb4d, 0xb2c, 0xb30, 0x3b, 0xb21, 0xb3f, 0xb38, 0xb47, 0xb2e, 0xb4d, 0xb2c, 0xb30, 0x3b, 0xb1c, 0xb3e, 0x3b, 0xb2b, 0xb47,
0x3b, 0xb2e, 0xb3e, 0x3b, 0xb05, 0x3b, 0xb2e, 0xb47, 0x3b, 0xb1c, 0xb41, 0x3b, 0xb1c, 0xb41, 0x3b, 0xb05, 0x3b, 0xb38, 0xb47, 0x3b,
0xb05, 0x3b, 0xb28, 0x3b, 0xb21, 0xb3f, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x64a, 0x3b, 0x641, 0x628, 0x631, 0x648, 0x631, 0x64a, 0x3b,
0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648,
0x644, 0x627, 0x6cc, 0x3b, 0x627, 0x6ab, 0x633, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648,
0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x698, 0x627, 0x646, 0x648, 0x6cc,
0x647, 0x654, 0x3b, 0x641, 0x648, 0x631, 0x6cc, 0x647, 0x654, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x622, 0x648, 0x631, 0x6cc, 0x644,
0x3b, 0x645, 0x647, 0x654, 0x3b, 0x698, 0x648, 0x626, 0x646, 0x3b, 0x698, 0x648, 0x626, 0x6cc, 0x647, 0x654, 0x3b, 0x627, 0x648, 0x62a,
0x3b, 0x633, 0x67e, 0x62a, 0x627, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x627, 0x645, 0x628,
0x631, 0x3b, 0x62f, 0x633, 0x627, 0x645, 0x628, 0x631, 0x3b, 0x698, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x622, 0x3b, 0x645, 0x3b, 0x698,
0x3b, 0x698, 0x3b, 0x627, 0x3b, 0x633, 0x3b, 0x627, 0x3b, 0x646, 0x3b, 0x62f, 0x3b, 0x62c, 0x646, 0x648, 0x3b, 0x641, 0x648, 0x631,
0x6cc, 0x647, 0x654, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x622, 0x648, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x640, 0x6cc, 0x3b, 0x698,
0x648, 0x626, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x3b, 0x627, 0x648, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x627, 0x645, 0x628, 0x631, 0x3b,
0x627, 0x6a9, 0x62a, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x627, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x3b, 0x62c, 0x646, 0x648,
0x631, 0x6cc, 0x3b, 0x641, 0x628, 0x631, 0x648, 0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644,
0x3b, 0x645, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633,
0x67e, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f,
0x633, 0x645, 0x628, 0x631, 0x3b, 0x73, 0x74, 0x79, 0x3b, 0x6c, 0x75, 0x74, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6b, 0x77, 0x69,
0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x63, 0x7a, 0x65, 0x3b, 0x6c, 0x69, 0x70, 0x3b, 0x73, 0x69, 0x65, 0x3b, 0x77, 0x72, 0x7a,
0x3b, 0x70, 0x61, 0x17a, 0x3b, 0x6c, 0x69, 0x73, 0x3b, 0x67, 0x72, 0x75, 0x3b, 0x73, 0x74, 0x79, 0x63, 0x7a, 0x6e, 0x69,
0x61, 0x3b, 0x6c, 0x75, 0x74, 0x65, 0x67, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x63, 0x61, 0x3b, 0x6b, 0x77, 0x69, 0x65, 0x74,
0x6e, 0x69, 0x61, 0x3b, 0x6d, 0x61, 0x6a, 0x61, 0x3b, 0x63, 0x7a, 0x65, 0x72, 0x77, 0x63, 0x61, 0x3b, 0x6c, 0x69, 0x70,
0x63, 0x61, 0x3b, 0x73, 0x69, 0x65, 0x72, 0x70, 0x6e, 0x69, 0x61, 0x3b, 0x77, 0x72, 0x7a, 0x65, 0x15b, 0x6e, 0x69, 0x61,
0x3b, 0x70, 0x61, 0x17a, 0x64, 0x7a, 0x69, 0x65, 0x72, 0x6e, 0x69, 0x6b, 0x61, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70,
0x61, 0x64, 0x61, 0x3b, 0x67, 0x72, 0x75, 0x64, 0x6e, 0x69, 0x61, 0x3b, 0x73, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6b, 0x3b,
0x6d, 0x3b, 0x63, 0x3b, 0x6c, 0x3b, 0x73, 0x3b, 0x77, 0x3b, 0x70, 0x3b, 0x6c, 0x3b, 0x67, 0x3b, 0x4a, 0x61, 0x6e, 0x3b,
0x46, 0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b,
0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x75, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b,
0x44, 0x65, 0x7a, 0x3b, 0x4a, 0x61, 0x6e, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x46, 0x65, 0x76, 0x65, 0x72, 0x65, 0x69, 0x72,
0x6f, 0x3b, 0x4d, 0x61, 0x72, 0xe7, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x6f, 0x3b, 0x4a,
0x75, 0x6e, 0x68, 0x6f, 0x3b, 0x4a, 0x75, 0x6c, 0x68, 0x6f, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65,
0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x4f, 0x75, 0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d,
0x62, 0x72, 0x6f, 0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x76,
0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x62, 0x72, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c,
0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x3b, 0x6f, 0x75, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x7a,
0x3b, 0x6a, 0x61, 0x6e, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x66, 0x65, 0x76, 0x65, 0x72, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x6d,
0x61, 0x72, 0xe7, 0x6f, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6e, 0x68,
0x6f, 0x3b, 0x6a, 0x75, 0x6c, 0x68, 0x6f, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x65, 0x6d,
0x62, 0x72, 0x6f, 0x3b, 0x6f, 0x75, 0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f,
0x3b, 0x64, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0xa1c, 0xa28, 0xa35, 0xa30, 0xa40, 0x3b, 0xa2b, 0xa3c, 0xa30, 0xa35,
0xa30, 0xa40, 0x3b, 0xa2e, 0xa3e, 0xa30, 0xa1a, 0x3b, 0xa05, 0xa2a, 0xa4d, 0xa30, 0xa48, 0xa32, 0x3b, 0xa2e, 0xa08, 0x3b, 0xa1c, 0xa42,
0xa28, 0x3b, 0xa1c, 0xa41, 0xa32, 0xa3e, 0xa08, 0x3b, 0xa05, 0xa17, 0xa38, 0xa24, 0x3b, 0xa38, 0xa24, 0xa70, 0xa2c, 0xa30, 0x3b, 0xa05,
0xa15, 0xa24, 0xa42, 0xa2c, 0xa30, 0x3b, 0xa28, 0xa35, 0xa70, 0xa2c, 0xa30, 0x3b, 0xa26, 0xa38, 0xa70, 0xa2c, 0xa30, 0x3b, 0xa1c, 0x3b,
0xa2b, 0x3b, 0xa2e, 0xa3e, 0x3b, 0xa05, 0x3b, 0xa2e, 0x3b, 0xa1c, 0xa42, 0x3b, 0xa1c, 0xa41, 0x3b, 0xa05, 0x3b, 0xa38, 0x3b, 0xa05,
0x3b, 0xa28, 0x3b, 0xa26, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x6cc, 0x3b, 0x641, 0x631, 0x648, 0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631,
0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x626, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x626,
0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b,
0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x73, 0x63, 0x68, 0x61, 0x6e, 0x2e, 0x3b, 0x66,
0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x74, 0x67, 0x3b,
0x7a, 0x65, 0x72, 0x63, 0x6c, 0x2e, 0x3b, 0x66, 0x61, 0x6e, 0x2e, 0x3b, 0x61, 0x76, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65,
0x74, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x73,
0x63, 0x68, 0x61, 0x6e, 0x65, 0x72, 0x3b, 0x66, 0x61, 0x76, 0x72, 0x65, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61,
0x76, 0x72, 0x69, 0x67, 0x6c, 0x3b, 0x6d, 0x61, 0x74, 0x67, 0x3b, 0x7a, 0x65, 0x72, 0x63, 0x6c, 0x61, 0x64, 0x75, 0x72,
0x3b, 0x66, 0x61, 0x6e, 0x61, 0x64, 0x75, 0x72, 0x3b, 0x61, 0x76, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74, 0x74, 0x65,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65,
0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x53, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d,
0x3b, 0x5a, 0x3b, 0x46, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x69, 0x61, 0x6e, 0x2e, 0x3b,
0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x69,
0x75, 0x6e, 0x2e, 0x3b, 0x69, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e, 0x3b,
0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x69, 0x61, 0x6e, 0x75, 0x61,
0x72, 0x69, 0x65, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x69, 0x65,
0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x65, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x69, 0x75, 0x6e, 0x69, 0x65, 0x3b, 0x69,
0x75, 0x6c, 0x69, 0x65, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72,
0x69, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x6f, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x6e, 0x6f, 0x69, 0x65, 0x6d, 0x62, 0x72,
0x69, 0x65, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x49, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41,
0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x44f, 0x43d, 0x432,
0x3b, 0x444, 0x435, 0x432, 0x3b, 0x43c, 0x430, 0x440, 0x3b, 0x430, 0x43f, 0x440, 0x3b, 0x43c, 0x430, 0x44f, 0x3b, 0x438, 0x44e, 0x43d,
0x3b, 0x438, 0x44e, 0x43b, 0x3b, 0x430, 0x432, 0x433, 0x3b, 0x441, 0x435, 0x43d, 0x3b, 0x43e, 0x43a, 0x442, 0x3b, 0x43d, 0x43e, 0x44f,
0x3b, 0x434, 0x435, 0x43a, 0x3b, 0x44f, 0x43d, 0x432, 0x430, 0x440, 0x44f, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44f, 0x3b,
0x43c, 0x430, 0x440, 0x442, 0x430, 0x3b, 0x430, 0x43f, 0x440, 0x435, 0x43b, 0x44f, 0x3b, 0x43c, 0x430, 0x44f, 0x3b, 0x438, 0x44e, 0x43d,
0x44f, 0x3b, 0x438, 0x44e, 0x43b, 0x44f, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x430, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x44f,
0x431, 0x440, 0x44f, 0x3b, 0x43e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x44f, 0x3b, 0x43d, 0x43e, 0x44f, 0x431, 0x440, 0x44f, 0x3b, 0x434,
0x435, 0x43a, 0x430, 0x431, 0x440, 0x44f, 0x3b, 0x42f, 0x3b, 0x424, 0x3b, 0x41c, 0x3b, 0x410, 0x3b, 0x41c, 0x3b, 0x418, 0x3b, 0x418,
0x3b, 0x410, 0x3b, 0x421, 0x3b, 0x41e, 0x3b, 0x41d, 0x3b, 0x414, 0x3b, 0x4e, 0x79, 0x65, 0x3b, 0x46, 0x75, 0x6c, 0x3b, 0x4d,
0x62, 0xe4, 0x3b, 0x4e, 0x67, 0x75, 0x3b, 0x42, 0xea, 0x6c, 0x3b, 0x46, 0xf6, 0x6e, 0x3b, 0x4c, 0x65, 0x6e, 0x3b, 0x4b,
0xfc, 0x6b, 0x3b, 0x4d, 0x76, 0x75, 0x3b, 0x4e, 0x67, 0x62, 0x3b, 0x4e, 0x61, 0x62, 0x3b, 0x4b, 0x61, 0x6b, 0x3b, 0x4e,
0x79, 0x65, 0x6e, 0x79, 0x65, 0x3b, 0x46, 0x75, 0x6c, 0x75, 0x6e, 0x64, 0xef, 0x67, 0x69, 0x3b, 0x4d, 0x62, 0xe4, 0x6e,
0x67, 0xfc, 0x3b, 0x4e, 0x67, 0x75, 0x62, 0xf9, 0x65, 0x3b, 0x42, 0xea, 0x6c, 0xe4, 0x77, 0xfc, 0x3b, 0x46, 0xf6, 0x6e,
0x64, 0x6f, 0x3b, 0x4c, 0x65, 0x6e, 0x67, 0x75, 0x61, 0x3b, 0x4b, 0xfc, 0x6b, 0xfc, 0x72, 0xfc, 0x3b, 0x4d, 0x76, 0x75,
0x6b, 0x61, 0x3b, 0x4e, 0x67, 0x62, 0x65, 0x72, 0x65, 0x72, 0x65, 0x3b, 0x4e, 0x61, 0x62, 0xe4, 0x6e, 0x64, 0xfc, 0x72,
0x75, 0x3b, 0x4b, 0x61, 0x6b, 0x61, 0x75, 0x6b, 0x61, 0x3b, 0x4e, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x42, 0x3b,
0x46, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x458, 0x430, 0x43d, 0x3b, 0x444, 0x435,
0x431, 0x3b, 0x43c, 0x430, 0x440, 0x3b, 0x430, 0x43f, 0x440, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x3b, 0x458, 0x443,
0x43b, 0x3b, 0x430, 0x432, 0x433, 0x3b, 0x441, 0x435, 0x43f, 0x3b, 0x43e, 0x43a, 0x442, 0x3b, 0x43d, 0x43e, 0x432, 0x3b, 0x434, 0x435,
0x446, 0x3b, 0x458, 0x430, 0x43d, 0x443, 0x430, 0x440, 0x3b, 0x444, 0x435, 0x431, 0x440, 0x443, 0x430, 0x440, 0x3b, 0x43c, 0x430, 0x440,
0x442, 0x3b, 0x430, 0x43f, 0x440, 0x438, 0x43b, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x3b, 0x458, 0x443, 0x43b, 0x3b,
0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x43e, 0x43a, 0x442,
0x43e, 0x431, 0x430, 0x440, 0x3b, 0x43d, 0x43e, 0x432, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x434, 0x435, 0x446, 0x435, 0x43c, 0x431,
0x430, 0x440, 0x3b, 0x458, 0x430, 0x43d, 0x443, 0x430, 0x440, 0x3b, 0x444, 0x435, 0x431, 0x440, 0x443, 0x430, 0x440, 0x3b, 0x43c, 0x430,
0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x438, 0x43b, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x438, 0x3b, 0x458, 0x443,
0x43b, 0x438, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b,
0x43e, 0x43a, 0x442, 0x43e, 0x431, 0x430, 0x440, 0x3b, 0x43d, 0x43e, 0x432, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x434, 0x435, 0x446,
0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70,
0x72, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x3b, 0x73, 0x65,
0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72,
0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b,
0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73,
0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x6e, 0x6f, 0x76,
0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x6a, 0x3b, 0x66, 0x3b, 0x6d,
0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x6a, 0x3b, 0x61, 0x3b, 0x73, 0x3b, 0x6f, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x50,
0x68, 0x65, 0x3b, 0x4b, 0x6f, 0x6c, 0x3b, 0x55, 0x62, 0x65, 0x3b, 0x4d, 0x6d, 0x65, 0x3b, 0x4d, 0x6f, 0x74, 0x3b, 0x4a,
0x61, 0x6e, 0x3b, 0x55, 0x70, 0x75, 0x3b, 0x50, 0x68, 0x61, 0x3b, 0x4c, 0x65, 0x6f, 0x3b, 0x4d, 0x70, 0x68, 0x3b, 0x50,
0x75, 0x6e, 0x3b, 0x54, 0x73, 0x68, 0x3b, 0x50, 0x68, 0x65, 0x73, 0x65, 0x6b, 0x67, 0x6f, 0x6e, 0x67, 0x3b, 0x48, 0x6c,
0x61, 0x6b, 0x6f, 0x6c, 0x61, 0x3b, 0x48, 0x6c, 0x61, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x3b, 0x4d, 0x6d, 0x65, 0x73,
0x65, 0x3b, 0x4d, 0x6f, 0x74, 0x73, 0x68, 0x65, 0x61, 0x6e, 0x6f, 0x6e, 0x67, 0x3b, 0x50, 0x68, 0x75, 0x70, 0x6a, 0x61,
0x6e, 0x65, 0x3b, 0x50, 0x68, 0x75, 0x70, 0x75, 0x3b, 0x50, 0x68, 0x61, 0x74, 0x61, 0x3b, 0x4c, 0x65, 0x6f, 0x74, 0x73,
0x68, 0x65, 0x3b, 0x4d, 0x70, 0x68, 0x61, 0x6c, 0x61, 0x6e, 0x65, 0x3b, 0x50, 0x75, 0x6e, 0x64, 0x75, 0x6e, 0x67, 0x77,
0x61, 0x6e, 0x65, 0x3b, 0x54, 0x73, 0x68, 0x69, 0x74, 0x77, 0x65, 0x3b, 0x46, 0x65, 0x72, 0x3b, 0x54, 0x6c, 0x68, 0x3b,
0x4d, 0x6f, 0x70, 0x3b, 0x4d, 0x6f, 0x72, 0x3b, 0x4d, 0x6f, 0x74, 0x3b, 0x53, 0x65, 0x65, 0x3b, 0x50, 0x68, 0x75, 0x3b,
0x50, 0x68, 0x61, 0x3b, 0x4c, 0x77, 0x65, 0x3b, 0x44, 0x69, 0x70, 0x3b, 0x4e, 0x67, 0x77, 0x3b, 0x53, 0x65, 0x64, 0x3b,
0x46, 0x65, 0x72, 0x69, 0x6b, 0x67, 0x6f, 0x6e, 0x67, 0x3b, 0x54, 0x6c, 0x68, 0x61, 0x6b, 0x6f, 0x6c, 0x65, 0x3b, 0x4d,
0x6f, 0x70, 0x69, 0x74, 0x6c, 0x6f, 0x3b, 0x4d, 0x6f, 0x72, 0x61, 0x6e, 0x61, 0x6e, 0x67, 0x3b, 0x4d, 0x6f, 0x74, 0x73,
0x68, 0x65, 0x67, 0x61, 0x6e, 0x61, 0x6e, 0x67, 0x3b, 0x53, 0x65, 0x65, 0x74, 0x65, 0x62, 0x6f, 0x73, 0x69, 0x67, 0x6f,
0x3b, 0x50, 0x68, 0x75, 0x6b, 0x77, 0x69, 0x3b, 0x50, 0x68, 0x61, 0x74, 0x77, 0x65, 0x3b, 0x4c, 0x77, 0x65, 0x74, 0x73,
0x65, 0x3b, 0x44, 0x69, 0x70, 0x68, 0x61, 0x6c, 0x61, 0x6e, 0x65, 0x3b, 0x4e, 0x67, 0x77, 0x61, 0x6e, 0x61, 0x74, 0x73,
0x65, 0x6c, 0x65, 0x3b, 0x53, 0x65, 0x64, 0x69, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6f, 0x6c, 0x65, 0x3b, 0x4e, 0x64, 0x69,
0x3b, 0x4b, 0x75, 0x6b, 0x3b, 0x4b, 0x75, 0x72, 0x3b, 0x4b, 0x75, 0x62, 0x3b, 0x43, 0x68, 0x69, 0x3b, 0x43, 0x68, 0x69,
0x3b, 0x43, 0x68, 0x69, 0x3b, 0x4e, 0x79, 0x61, 0x3b, 0x47, 0x75, 0x6e, 0x3b, 0x47, 0x75, 0x6d, 0x3b, 0x4d, 0x62, 0x3b,
0x5a, 0x76, 0x69, 0x3b, 0x4e, 0x64, 0x69, 0x72, 0x61, 0x3b, 0x4b, 0x75, 0x6b, 0x61, 0x64, 0x7a, 0x69, 0x3b, 0x4b, 0x75,
0x72, 0x75, 0x6d, 0x65, 0x3b, 0x4b, 0x75, 0x62, 0x76, 0x75, 0x6d, 0x62, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x76, 0x61, 0x62,
0x76, 0x75, 0x3b, 0x43, 0x68, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x6b, 0x75, 0x6e, 0x67, 0x75, 0x72,
0x75, 0x3b, 0x4e, 0x79, 0x61, 0x6d, 0x61, 0x76, 0x68, 0x75, 0x76, 0x68, 0x75, 0x3b, 0x47, 0x75, 0x6e, 0x79, 0x61, 0x6e,
0x61, 0x3b, 0x47, 0x75, 0x6d, 0x69, 0x67, 0x75, 0x72, 0x75, 0x3b, 0x4d, 0x62, 0x75, 0x64, 0x7a, 0x69, 0x3b, 0x5a, 0x76,
0x69, 0x74, 0x61, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x4e, 0x3b,
0x47, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0xda2, 0xdb1, 0x3b, 0xdb4, 0xdd9, 0xdb6, 0x3b, 0xdb8, 0xdcf, 0xdbb, 0xdca, 0xdad,
0xdd4, 0x3b, 0xd85, 0xdb4, 0xdca, 0x200d, 0xdbb, 0xdda, 0xdbd, 0xdca, 0x3b, 0xdb8, 0xdd0, 0xdba, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdb1, 0xdd2,
0x3b, 0xda2, 0xdd6, 0xdbd, 0xdd2, 0x3b, 0xd85, 0xd9c, 0xddd, 0x3b, 0xdc3, 0xdd0, 0xdb4, 0xdca, 0x3b, 0xd94, 0xd9a, 0xdca, 0x3b, 0xdb1,
0xddc, 0xdc0, 0xdd0, 0x3b, 0xdaf, 0xdd9, 0xdc3, 0xdd0, 0x3b, 0xda2, 0xdb1, 0xdc0, 0xdcf, 0xdbb, 0xdd2, 0x3b, 0xdb4, 0xdd9, 0xdb6, 0xdbb,
0xdc0, 0xdcf, 0xdbb, 0xdd2, 0x3b, 0xdb8, 0xdcf, 0xdbb, 0xdca, 0xdad, 0xdd4, 0x3b, 0xd85, 0xdb4, 0xdca, 0x200d, 0xdbb, 0xdda, 0xdbd, 0xdca,
0x3b, 0xdb8, 0xdd0, 0xdba, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdb1, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdbd, 0xdd2, 0x3b, 0xd85, 0xd9c, 0xddd, 0xdc3,
0xdca, 0xdad, 0xdd4, 0x3b, 0xdc3, 0xdd0, 0xdb4, 0xdca, 0xdad, 0xdd0, 0xdb8, 0xdca, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xd94, 0xd9a, 0xdca, 0xdad,
0xddd, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xdb1, 0xddc, 0xdc0, 0xdd0, 0xdb8, 0xdca, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xdaf, 0xdd9, 0xdc3, 0xdd0, 0xdb8,
0xdca, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xda2, 0x3b, 0xdb4, 0xdd9, 0x3b, 0xdb8, 0xdcf, 0x3b, 0xd85, 0x3b, 0xdb8, 0xdd0, 0x3b, 0xda2, 0xdd6,
0x3b, 0xda2, 0xdd6, 0x3b, 0xd85, 0x3b, 0xdc3, 0xdd0, 0x3b, 0xd94, 0x3b, 0xdb1, 0xddc, 0x3b, 0xdaf, 0xdd9, 0x3b, 0x42, 0x68, 0x69,
0x3b, 0x56, 0x61, 0x6e, 0x3b, 0x56, 0x6f, 0x6c, 0x3b, 0x4d, 0x61, 0x62, 0x3b, 0x4e, 0x6b, 0x68, 0x3b, 0x4e, 0x68, 0x6c,
0x3b, 0x4b, 0x68, 0x6f, 0x3b, 0x4e, 0x67, 0x63, 0x3b, 0x4e, 0x79, 0x6f, 0x3b, 0x4d, 0x70, 0x68, 0x3b, 0x4c, 0x77, 0x65,
0x3b, 0x4e, 0x67, 0x6f, 0x3b, 0x42, 0x68, 0x69, 0x6d, 0x62, 0x69, 0x64, 0x76, 0x77, 0x61, 0x6e, 0x65, 0x3b, 0x69, 0x4e,
0x64, 0x6c, 0x6f, 0x76, 0x61, 0x6e, 0x61, 0x3b, 0x69, 0x4e, 0x64, 0x6c, 0x6f, 0x76, 0x75, 0x2d, 0x6c, 0x65, 0x6e, 0x6b,
0x68, 0x75, 0x6c, 0x75, 0x3b, 0x4d, 0x61, 0x62, 0x61, 0x73, 0x61, 0x3b, 0x69, 0x4e, 0x6b, 0x68, 0x77, 0x65, 0x6b, 0x68,
0x77, 0x65, 0x74, 0x69, 0x3b, 0x69, 0x4e, 0x68, 0x6c, 0x61, 0x62, 0x61, 0x3b, 0x4b, 0x68, 0x6f, 0x6c, 0x77, 0x61, 0x6e,
0x65, 0x3b, 0x69, 0x4e, 0x67, 0x63, 0x69, 0x3b, 0x69, 0x4e, 0x79, 0x6f, 0x6e, 0x69, 0x3b, 0x69, 0x4d, 0x70, 0x68, 0x61,
0x6c, 0x61, 0x3b, 0x4c, 0x77, 0x65, 0x74, 0x69, 0x3b, 0x69, 0x4e, 0x67, 0x6f, 0x6e, 0x67, 0x6f, 0x6e, 0x69, 0x3b, 0x6a,
0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0xe1, 0x6a, 0x3b, 0x6a,
0xfa, 0x6e, 0x3b, 0x6a, 0xfa, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e,
0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0xe1, 0x72, 0x61, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75,
0xe1, 0x72, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x63, 0x61, 0x3b, 0x61, 0x70, 0x72, 0xed, 0x6c, 0x61, 0x3b, 0x6d, 0xe1, 0x6a,
0x61, 0x3b, 0x6a, 0xfa, 0x6e, 0x61, 0x3b, 0x6a, 0xfa, 0x6c, 0x61, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x61, 0x3b,
0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x6f, 0x6b, 0x74, 0xf3, 0x62, 0x72, 0x61, 0x3b, 0x6e, 0x6f,
0x76, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x6a, 0x61, 0x6e, 0x2e,
0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x6a, 0x3b,
0x6a, 0x75, 0x6e, 0x2e, 0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x76, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x2e, 0x3b,
0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61,
0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x65, 0x63, 0x3b, 0x61, 0x70, 0x72, 0x69,
0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6a, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6a, 0x3b, 0x61, 0x76,
0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62,
0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x4b, 0x6f, 0x62, 0x3b, 0x4c, 0x61, 0x62, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x41, 0x66, 0x72, 0x3b, 0x53, 0x68, 0x61,
0x3b, 0x4c, 0x69, 0x78, 0x3b, 0x54, 0x6f, 0x64, 0x3b, 0x53, 0x69, 0x64, 0x3b, 0x53, 0x61, 0x67, 0x3b, 0x54, 0x6f, 0x62,
0x3b, 0x4b, 0x49, 0x54, 0x3b, 0x4c, 0x49, 0x54, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4b, 0x6f, 0x6f, 0x62, 0x61,
0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4c, 0x61, 0x62, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68,
0x61, 0x20, 0x53, 0x61, 0x64, 0x64, 0x65, 0x78, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x41, 0x66,
0x72, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x53, 0x68, 0x61, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x42,
0x69, 0x73, 0x68, 0x61, 0x20, 0x4c, 0x69, 0x78, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x54, 0x6f,
0x64, 0x6f, 0x62, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x53, 0x69, 0x64, 0x65, 0x65, 0x64, 0x61,
0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x53, 0x61, 0x67, 0x61, 0x61, 0x6c, 0x61, 0x61, 0x64, 0x3b, 0x42,
0x69, 0x73, 0x68, 0x61, 0x20, 0x54, 0x6f, 0x62, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4b,
0x6f, 0x77, 0x20, 0x69, 0x79, 0x6f, 0x20, 0x54, 0x6f, 0x62, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61,
0x20, 0x4c, 0x61, 0x62, 0x61, 0x20, 0x69, 0x79, 0x6f, 0x20, 0x54, 0x6f, 0x62, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x4b, 0x3b,
0x4c, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x4b, 0x3b,
0x4c, 0x3b, 0x65, 0x6e, 0x65, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x62, 0x72, 0x3b, 0x6d, 0x61,
0x79, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x63,
0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x69, 0x63, 0x3b, 0x65, 0x6e, 0x65, 0x72, 0x6f, 0x3b, 0x66, 0x65, 0x62, 0x72,
0x65, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x6f,
0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b,
0x73, 0x65, 0x70, 0x74, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x6e,
0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x69, 0x63, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x45,
0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e,
0x3b, 0x44, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d,
0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f,
0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46,
0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x69,
0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x6f, 0x73,
0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e,
0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61,
0x72, 0x69, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72,
0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67,
0x75, 0x73, 0x74, 0x69, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62,
0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x45, 0x6e, 0x65, 0x3b, 0x50, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x79,
0x3b, 0x48, 0x75, 0x6e, 0x3b, 0x48, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x6b, 0x74,
0x3b, 0x4e, 0x6f, 0x62, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x45, 0x6e, 0x65, 0x72, 0x6f, 0x3b, 0x50, 0x65, 0x62, 0x72, 0x65,
0x72, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x79, 0x6f, 0x3b,
0x48, 0x75, 0x6e, 0x79, 0x6f, 0x3b, 0x48, 0x75, 0x6c, 0x79, 0x6f, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53,
0x65, 0x74, 0x79, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x4f, 0x6b, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x4e, 0x6f, 0x62,
0x79, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x44, 0x69, 0x73, 0x79, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x45, 0x3b, 0x50,
0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x48, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44,
0x3b, 0x42f, 0x43d, 0x432, 0x3b, 0x424, 0x435, 0x432, 0x3b, 0x41c, 0x430, 0x440, 0x3b, 0x410, 0x43f, 0x440, 0x3b, 0x41c, 0x430, 0x439,
0x3b, 0x418, 0x44e, 0x43d, 0x3b, 0x418, 0x44e, 0x43b, 0x3b, 0x410, 0x432, 0x433, 0x3b, 0x421, 0x435, 0x43d, 0x3b, 0x41e, 0x43a, 0x442,
0x3b, 0x41d, 0x43e, 0x44f, 0x3b, 0x414, 0x435, 0x43a, 0x3b, 0x42f, 0x43d, 0x432, 0x430, 0x440, 0x3b, 0x424, 0x435, 0x432, 0x440, 0x430,
0x43b, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x3b, 0x410, 0x43f, 0x440, 0x435, 0x43b, 0x3b, 0x41c, 0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d,
0x3b, 0x418, 0x44e, 0x43b, 0x3b, 0x410, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x421, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x3b,
0x41e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x3b, 0x41d, 0x43e, 0x44f, 0x431, 0x440, 0x3b, 0x414, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x3b,
0xb9c, 0xba9, 0x2e, 0x3b, 0xbaa, 0xbbf, 0xbaa, 0xbcd, 0x2e, 0x3b, 0xbae, 0xbbe, 0xbb0, 0xbcd, 0x2e, 0x3b, 0xb8f, 0xbaa, 0xbcd, 0x2e,
0x3b, 0xbae, 0xbc7, 0x3b, 0xb9c, 0xbc2, 0xba9, 0xbcd, 0x3b, 0xb9c, 0xbc2, 0xbb2, 0xbc8, 0x3b, 0xb86, 0xb95, 0x2e, 0x3b, 0xb9a, 0xbc6,
0xbaa, 0xbcd, 0x2e, 0x3b, 0xb85, 0xb95, 0xbcd, 0x2e, 0x3b, 0xba8, 0xbb5, 0x2e, 0x3b, 0xb9f, 0xbbf, 0xb9a, 0x2e, 0x3b, 0xb9c, 0xba9,
0xbb5, 0xbb0, 0xbbf, 0x3b, 0xbaa, 0xbbf, 0xbaa, 0xbcd, 0xbb0, 0xbb5, 0xbb0, 0xbbf, 0x3b, 0xbae, 0xbbe, 0xbb0, 0xbcd, 0xb9a, 0xbcd, 0x3b,
0xb8f, 0xbaa, 0xbcd, 0xbb0, 0xbb2, 0xbcd, 0x3b, 0xbae, 0xbc7, 0x3b, 0xb9c, 0xbc2, 0xba9, 0xbcd, 0x3b, 0xb9c, 0xbc2, 0xbb2, 0xbc8, 0x3b,
0xb86, 0xb95, 0xbb8, 0xbcd, 0xb9f, 0xbcd, 0x3b, 0xb9a, 0xbc6, 0xbaa, 0xbcd, 0xb9f, 0xbae, 0xbcd, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb85, 0xb95,
0xbcd, 0xb9f, 0xbcb, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xba8, 0xbb5, 0xbae, 0xbcd, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb9f, 0xbbf, 0xb9a, 0xbae, 0xbcd,
0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb9c, 0x3b, 0xbaa, 0xbbf, 0x3b, 0xbae, 0xbbe, 0x3b, 0xb8f, 0x3b, 0xbae, 0xbc7, 0x3b, 0xb9c, 0xbc2, 0x3b,
0xb9c, 0xbc2, 0x3b, 0xb86, 0x3b, 0xb9a, 0xbc6, 0x3b, 0xb85, 0x3b, 0xba8, 0x3b, 0xb9f, 0xbbf, 0x3b, 0xc1c, 0xc28, 0x3b, 0xc2b, 0xc3f,
0xc2c, 0xc4d, 0xc30, 0x3b, 0xc2e, 0xc3e, 0xc30, 0xc4d, 0xc1a, 0xc3f, 0x3b, 0xc0f, 0xc2a, 0xc4d, 0xc30, 0xc3f, 0x3b, 0xc2e, 0xc47, 0x3b,
0xc1c, 0xc42, 0xc28, 0xc4d, 0x3b, 0xc1c, 0xc42, 0xc32, 0xc48, 0x3b, 0xc06, 0xc17, 0xc38, 0xc4d, 0xc1f, 0xc41, 0x3b, 0xc38, 0xc46, 0xc2a,
0xc4d, 0xc1f, 0xc46, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc05, 0xc15, 0xc4d, 0xc1f, 0xc4b, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc28, 0xc35, 0xc02,
0xc2c, 0xc30, 0xc4d, 0x3b, 0xc21, 0xc3f, 0xc38, 0xc46, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc1c, 0xc28, 0xc35, 0xc30, 0xc3f, 0x3b, 0xc2b,
0xc3f, 0xc2c, 0xc4d, 0xc30, 0xc35, 0xc30, 0xc3f, 0x3b, 0xc2e, 0xc3e, 0xc30, 0xc4d, 0xc1a, 0xc3f, 0x3b, 0xc0e, 0xc2a, 0xc4d, 0xc30, 0xc3f,
0xc32, 0xc4d, 0x3b, 0xc2e, 0xc47, 0x3b, 0xc1c, 0xc42, 0xc28, 0xc4d, 0x3b, 0xc1c, 0xc42, 0xc32, 0xc48, 0x3b, 0xc06, 0xc17, 0xc38, 0xc4d,
0xc1f, 0xc41, 0x3b, 0xc38, 0xc46, 0xc2a, 0xc4d, 0xc1f, 0xc46, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc05, 0xc15, 0xc4d, 0xc1f, 0xc4b, 0xc2c,
0xc30, 0xc4d, 0x3b, 0xc28, 0xc35, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc21, 0xc3f, 0xc38, 0xc46, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc1c,
0x3b, 0xc2b, 0xc3f, 0x3b, 0xc2e, 0xc3e, 0x3b, 0xc0f, 0x3b, 0xc2e, 0xc46, 0x3b, 0xc1c, 0xc41, 0x3b, 0xc1c, 0xc41, 0x3b, 0xc06, 0x3b,
0xc38, 0xc46, 0x3b, 0xc05, 0x3b, 0xc28, 0x3b, 0xc21, 0xc3f, 0x3b, 0xe21, 0x2e, 0xe04, 0x2e, 0x3b, 0xe01, 0x2e, 0xe1e, 0x2e, 0x3b,
0xe21, 0xe35, 0x2e, 0xe04, 0x2e, 0x3b, 0xe40, 0xe21, 0x2e, 0xe22, 0x2e, 0x3b, 0xe1e, 0x2e, 0xe04, 0x2e, 0x3b, 0xe21, 0xe34, 0x2e,
0xe22, 0x2e, 0x3b, 0xe01, 0x2e, 0xe04, 0x2e, 0x3b, 0xe2a, 0x2e, 0xe04, 0x2e, 0x3b, 0xe01, 0x2e, 0xe22, 0x2e, 0x3b, 0xe15, 0x2e,
0xe04, 0x2e, 0x3b, 0xe1e, 0x2e, 0xe22, 0x2e, 0x3b, 0xe18, 0x2e, 0xe04, 0x2e, 0x3b, 0xe21, 0xe01, 0xe23, 0xe32, 0xe04, 0xe21, 0x3b,
0xe01, 0xe38, 0xe21, 0xe20, 0xe32, 0xe1e, 0xe31, 0xe19, 0xe18, 0xe4c, 0x3b, 0xe21, 0xe35, 0xe19, 0xe32, 0xe04, 0xe21, 0x3b, 0xe40, 0xe21,
0xe29, 0xe32, 0xe22, 0xe19, 0x3b, 0xe1e, 0xe24, 0xe29, 0xe20, 0xe32, 0xe04, 0xe21, 0x3b, 0xe21, 0xe34, 0xe16, 0xe38, 0xe19, 0xe32, 0xe22,
0xe19, 0x3b, 0xe01, 0xe23, 0xe01, 0xe0e, 0xe32, 0xe04, 0xe21, 0x3b, 0xe2a, 0xe34, 0xe07, 0xe2b, 0xe32, 0xe04, 0xe21, 0x3b, 0xe01, 0xe31,
0xe19, 0xe22, 0xe32, 0xe22, 0xe19, 0x3b, 0xe15, 0xe38, 0xe25, 0xe32, 0xe04, 0xe21, 0x3b, 0xe1e, 0xe24, 0xe28, 0xe08, 0xe34, 0xe01, 0xe32,
0xe22, 0xe19, 0x3b, 0xe18, 0xe31, 0xe19, 0xe27, 0xe32, 0xe04, 0xe21, 0x3b, 0xe21, 0x2e, 0xe04, 0x2e, 0x3b, 0xe01, 0x2e, 0xe1e, 0x2e,
0x3b, 0xe21, 0xe35, 0x2e, 0xe04, 0x2e, 0x3b, 0xe40, 0xe21, 0x2e, 0xe22, 0x2e, 0x3b, 0xe1e, 0x2e, 0xe04, 0x2e, 0x3b, 0xe21, 0xe34,
0x2e, 0xe22, 0x3b, 0xe01, 0x2e, 0xe04, 0x2e, 0x3b, 0xe2a, 0x2e, 0xe04, 0x2e, 0x3b, 0xe01, 0x2e, 0xe22, 0x2e, 0x3b, 0xe15, 0x2e,
0xe04, 0x2e, 0x3b, 0xe1e, 0x2e, 0xe22, 0x2e, 0x3b, 0xe18, 0x2e, 0xe04, 0x2e, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0x3b, 0xf5f, 0xfb3,
0xf0b, 0xf22, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf23, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf24, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf25, 0x3b, 0xf5f, 0xfb3,
0xf0b, 0xf26, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf27, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf28, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf29, 0x3b, 0xf5f, 0xfb3,
0xf0b, 0xf21, 0xf20, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0xf21, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0xf22, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56,
0xf0b, 0xf51, 0xf44, 0xf0b, 0xf54, 0xf7c, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b,
0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf66, 0xf74, 0xf58, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf5e,
0xf72, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf63, 0xf94, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56,
0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf51, 0xf74, 0xf53, 0xf0b, 0xf54,
0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf62, 0xf92, 0xfb1, 0xf51, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56,
0xf0b, 0xf51, 0xf42, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf45, 0xf72, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b,
0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0x1325, 0x122a, 0x3b, 0x1208, 0x12ab, 0x1272,
0x3b, 0x1218, 0x130b, 0x1262, 0x3b, 0x121a, 0x12eb, 0x12dd, 0x3b, 0x130d, 0x1295, 0x1266, 0x3b, 0x1230, 0x1290, 0x3b, 0x1213, 0x121d, 0x1208, 0x3b,
0x1290, 0x1213, 0x1230, 0x3b, 0x1218, 0x1235, 0x12a8, 0x3b, 0x1325, 0x1245, 0x121d, 0x3b, 0x1215, 0x12f3, 0x122d, 0x3b, 0x1273, 0x1215, 0x1233, 0x3b,
0x1325, 0x122a, 0x3b, 0x1208, 0x12ab, 0x1272, 0x1275, 0x3b, 0x1218, 0x130b, 0x1262, 0x1275, 0x3b, 0x121a, 0x12eb, 0x12dd, 0x12eb, 0x3b, 0x130d, 0x1295,
0x1266, 0x1275, 0x3b, 0x1230, 0x1290, 0x3b, 0x1213, 0x121d, 0x1208, 0x3b, 0x1290, 0x1213, 0x1230, 0x3b, 0x1218, 0x1235, 0x12a8, 0x1228, 0x121d, 0x3b,
0x1325, 0x1245, 0x121d, 0x1272, 0x3b, 0x1215, 0x12f3, 0x122d, 0x3b, 0x1273, 0x1215, 0x1233, 0x1235, 0x3b, 0x53, 0x101, 0x6e, 0x3b, 0x46, 0x113,
0x70, 0x3b, 0x4d, 0x61, 0x2bb, 0x61, 0x3b, 0x2bb, 0x45, 0x70, 0x65, 0x3b, 0x4d, 0x113, 0x3b, 0x53, 0x75, 0x6e, 0x3b, 0x53,
0x69, 0x75, 0x3b, 0x2bb, 0x41, 0x6f, 0x6b, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x2bb, 0x4f, 0x6b, 0x61, 0x3b, 0x4e, 0x14d, 0x76,
0x3b, 0x54, 0x12b, 0x73, 0x3b, 0x53, 0x101, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x46, 0x113, 0x70, 0x75, 0x65, 0x6c, 0x69,
0x3b, 0x4d, 0x61, 0x2bb, 0x61, 0x73, 0x69, 0x3b, 0x2bb, 0x45, 0x70, 0x65, 0x6c, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x113, 0x3b,
0x53, 0x75, 0x6e, 0x65, 0x3b, 0x53, 0x69, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x2bb, 0x41, 0x6f, 0x6b, 0x6f, 0x73, 0x69, 0x3b,
0x53, 0x65, 0x70, 0x69, 0x74, 0x65, 0x6d, 0x61, 0x3b, 0x2bb, 0x4f, 0x6b, 0x61, 0x74, 0x6f, 0x70, 0x61, 0x3b, 0x4e, 0x14d,
0x76, 0x65, 0x6d, 0x61, 0x3b, 0x54, 0x12b, 0x73, 0x65, 0x6d, 0x61, 0x3b, 0x53, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x45, 0x3b,
0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x53, 0x75, 0x6e, 0x3b,
0x59, 0x61, 0x6e, 0x3b, 0x4b, 0x75, 0x6c, 0x3b, 0x44, 0x7a, 0x69, 0x3b, 0x4d, 0x75, 0x64, 0x3b, 0x4b, 0x68, 0x6f, 0x3b,
0x4d, 0x61, 0x77, 0x3b, 0x4d, 0x68, 0x61, 0x3b, 0x4e, 0x64, 0x7a, 0x3b, 0x4e, 0x68, 0x6c, 0x3b, 0x48, 0x75, 0x6b, 0x3b,
0x4e, 0x27, 0x77, 0x3b, 0x53, 0x75, 0x6e, 0x67, 0x75, 0x74, 0x69, 0x3b, 0x4e, 0x79, 0x65, 0x6e, 0x79, 0x65, 0x6e, 0x79,
0x61, 0x6e, 0x69, 0x3b, 0x4e, 0x79, 0x65, 0x6e, 0x79, 0x61, 0x6e, 0x6b, 0x75, 0x6c, 0x75, 0x3b, 0x44, 0x7a, 0x69, 0x76,
0x61, 0x6d, 0x69, 0x73, 0x6f, 0x6b, 0x6f, 0x3b, 0x4d, 0x75, 0x64, 0x79, 0x61, 0x78, 0x69, 0x68, 0x69, 0x3b, 0x4b, 0x68,
0x6f, 0x74, 0x61, 0x76, 0x75, 0x78, 0x69, 0x6b, 0x61, 0x3b, 0x4d, 0x61, 0x77, 0x75, 0x77, 0x61, 0x6e, 0x69, 0x3b, 0x4d,
0x68, 0x61, 0x77, 0x75, 0x72, 0x69, 0x3b, 0x4e, 0x64, 0x7a, 0x68, 0x61, 0x74, 0x69, 0x3b, 0x4e, 0x68, 0x6c, 0x61, 0x6e,
0x67, 0x75, 0x6c, 0x61, 0x3b, 0x48, 0x75, 0x6b, 0x75, 0x72, 0x69, 0x3b, 0x4e, 0x27, 0x77, 0x65, 0x6e, 0x64, 0x7a, 0x61,
0x6d, 0x68, 0x61, 0x6c, 0x61, 0x3b, 0x4f, 0x63, 0x61, 0x3b, 0x15e, 0x75, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4e, 0x69,
0x73, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x48, 0x61, 0x7a, 0x3b, 0x54, 0x65, 0x6d, 0x3b, 0x41, 0x11f, 0x75, 0x3b, 0x45, 0x79,
0x6c, 0x3b, 0x45, 0x6b, 0x69, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x41, 0x72, 0x61, 0x3b, 0x4f, 0x63, 0x61, 0x6b, 0x3b, 0x15e,
0x75, 0x62, 0x61, 0x74, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x3b, 0x4e, 0x69, 0x73, 0x61, 0x6e, 0x3b, 0x4d, 0x61, 0x79, 0x131,
0x73, 0x3b, 0x48, 0x61, 0x7a, 0x69, 0x72, 0x61, 0x6e, 0x3b, 0x54, 0x65, 0x6d, 0x6d, 0x75, 0x7a, 0x3b, 0x41, 0x11f, 0x75,
0x73, 0x74, 0x6f, 0x73, 0x3b, 0x45, 0x79, 0x6c, 0xfc, 0x6c, 0x3b, 0x45, 0x6b, 0x69, 0x6d, 0x3b, 0x4b, 0x61, 0x73, 0x131,
0x6d, 0x3b, 0x41, 0x72, 0x61, 0x6c, 0x131, 0x6b, 0x3b, 0x4f, 0x3b, 0x15e, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4d, 0x3b, 0x48,
0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x45, 0x3b, 0x45, 0x3b, 0x4b, 0x3b, 0x41, 0x3b, 0x441, 0x456, 0x447, 0x2e, 0x3b, 0x43b, 0x44e,
0x442, 0x2e, 0x3b, 0x431, 0x435, 0x440, 0x2e, 0x3b, 0x43a, 0x432, 0x456, 0x442, 0x2e, 0x3b, 0x442, 0x440, 0x430, 0x432, 0x2e, 0x3b,
0x447, 0x435, 0x440, 0x432, 0x2e, 0x3b, 0x43b, 0x438, 0x43f, 0x2e, 0x3b, 0x441, 0x435, 0x440, 0x43f, 0x2e, 0x3b, 0x432, 0x435, 0x440,
0x2e, 0x3b, 0x436, 0x43e, 0x432, 0x442, 0x2e, 0x3b, 0x43b, 0x438, 0x441, 0x442, 0x2e, 0x3b, 0x433, 0x440, 0x443, 0x434, 0x2e, 0x3b,
0x441, 0x456, 0x447, 0x43d, 0x44f, 0x3b, 0x43b, 0x44e, 0x442, 0x43e, 0x433, 0x43e, 0x3b, 0x431, 0x435, 0x440, 0x435, 0x437, 0x43d, 0x44f,
0x3b, 0x43a, 0x432, 0x456, 0x442, 0x43d, 0x44f, 0x3b, 0x442, 0x440, 0x430, 0x432, 0x43d, 0x44f, 0x3b, 0x447, 0x435, 0x440, 0x432, 0x43d,
0x44f, 0x3b, 0x43b, 0x438, 0x43f, 0x43d, 0x44f, 0x3b, 0x441, 0x435, 0x440, 0x43f, 0x43d, 0x44f, 0x3b, 0x432, 0x435, 0x440, 0x435, 0x441,
0x43d, 0x44f, 0x3b, 0x436, 0x43e, 0x432, 0x442, 0x43d, 0x44f, 0x3b, 0x43b, 0x438, 0x441, 0x442, 0x43e, 0x43f, 0x430, 0x434, 0x430, 0x3b,
0x433, 0x440, 0x443, 0x434, 0x43d, 0x44f, 0x3b, 0x421, 0x3b, 0x41b, 0x3b, 0x411, 0x3b, 0x41a, 0x3b, 0x422, 0x3b, 0x427, 0x3b, 0x41b,
0x3b, 0x421, 0x3b, 0x412, 0x3b, 0x416, 0x3b, 0x41b, 0x3b, 0x413, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x6cc, 0x3b, 0x641, 0x631, 0x648,
0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x20, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x64a, 0x644, 0x3b, 0x645, 0x626, 0x3b, 0x62c, 0x648,
0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x626, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627,
0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x41c, 0x443,
0x4b3, 0x430, 0x440, 0x440, 0x430, 0x43c, 0x3b, 0x421, 0x430, 0x444, 0x430, 0x440, 0x3b, 0x420, 0x430, 0x431, 0x438, 0x443, 0x43b, 0x2d,
0x430, 0x432, 0x432, 0x430, 0x43b, 0x3b, 0x420, 0x430, 0x431, 0x438, 0x443, 0x43b, 0x2d, 0x43e, 0x445, 0x438, 0x440, 0x3b, 0x416, 0x443,
0x43c, 0x43e, 0x434, 0x438, 0x443, 0x43b, 0x2d, 0x443, 0x43b, 0x43e, 0x3b, 0x416, 0x443, 0x43c, 0x43e, 0x434, 0x438, 0x443, 0x43b, 0x2d,
0x443, 0x445, 0x440, 0x43e, 0x3b, 0x420, 0x430, 0x436, 0x430, 0x431, 0x3b, 0x428, 0x430, 0x44a, 0x431, 0x43e, 0x43d, 0x3b, 0x420, 0x430,
0x43c, 0x430, 0x437, 0x43e, 0x43d, 0x3b, 0x428, 0x430, 0x432, 0x432, 0x43e, 0x43b, 0x3b, 0x417, 0x438, 0x43b, 0x2d, 0x49b, 0x430, 0x44a,
0x434, 0x430, 0x3b, 0x417, 0x438, 0x43b, 0x2d, 0x4b3, 0x438, 0x436, 0x436, 0x430, 0x3b, 0x62c, 0x646, 0x648, 0x3b, 0x641, 0x628, 0x631,
0x3b, 0x645, 0x627, 0x631, 0x3b, 0x627, 0x67e, 0x631, 0x3b, 0x645, 0x640, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644,
0x3b, 0x627, 0x6af, 0x633, 0x3b, 0x633, 0x67e, 0x62a, 0x3b, 0x627, 0x6a9, 0x62a, 0x3b, 0x646, 0x648, 0x645, 0x3b, 0x62f, 0x633, 0x645,
0x3b, 0x59, 0x61, 0x6e, 0x76, 0x3b, 0x46, 0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61,
0x79, 0x3b, 0x49, 0x79, 0x75, 0x6e, 0x3b, 0x49, 0x79, 0x75, 0x6c, 0x3b, 0x41, 0x76, 0x67, 0x3b, 0x53, 0x65, 0x6e, 0x3b,
0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x79, 0x61, 0x3b, 0x44, 0x65, 0x6b, 0x3b, 0x59, 0x61, 0x6e, 0x76, 0x61, 0x72, 0x3b,
0x46, 0x65, 0x76, 0x72, 0x61, 0x6c, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x61,
0x79, 0x3b, 0x49, 0x79, 0x75, 0x6e, 0x3b, 0x49, 0x79, 0x75, 0x6c, 0x3b, 0x41, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53,
0x65, 0x6e, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x4e, 0x6f, 0x79, 0x61,
0x62, 0x72, 0x3b, 0x44, 0x65, 0x6b, 0x61, 0x62, 0x72, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b,
0x49, 0x3b, 0x49, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31, 0x3b,
0x74, 0x68, 0x67, 0x20, 0x32, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x33, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x34, 0x3b, 0x74, 0x68,
0x67, 0x20, 0x35, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x36, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x37, 0x3b, 0x74, 0x68, 0x67, 0x20,
0x38, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x39, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31, 0x30, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31,
0x31, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31, 0x32, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x6d, 0x1ed9, 0x74, 0x3b, 0x74,
0x68, 0xe1, 0x6e, 0x67, 0x20, 0x68, 0x61, 0x69, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x62, 0x61, 0x3b, 0x74, 0x68,
0xe1, 0x6e, 0x67, 0x20, 0x74, 0x1b0, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x6e, 0x103, 0x6d, 0x3b, 0x74, 0x68, 0xe1,
0x6e, 0x67, 0x20, 0x73, 0xe1, 0x75, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x62, 0x1ea3, 0x79, 0x3b, 0x74, 0x68, 0xe1,
0x6e, 0x67, 0x20, 0x74, 0xe1, 0x6d, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x63, 0x68, 0xed, 0x6e, 0x3b, 0x74, 0x68,
0xe1, 0x6e, 0x67, 0x20, 0x6d, 0x1b0, 0x1edd, 0x69, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x6d, 0x1b0, 0x1edd, 0x69, 0x20,
0x6d, 0x1ed9, 0x74, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x6d, 0x1b0, 0x1edd, 0x69, 0x20, 0x68, 0x61, 0x69, 0x3b, 0x49,
0x6f, 0x6e, 0x3b, 0x43, 0x68, 0x77, 0x65, 0x66, 0x3b, 0x4d, 0x61, 0x77, 0x72, 0x74, 0x68, 0x3b, 0x45, 0x62, 0x72, 0x69,
0x6c, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4d, 0x65, 0x68, 0x3b, 0x47, 0x6f, 0x72, 0x66, 0x66, 0x3b, 0x41, 0x77, 0x73,
0x74, 0x3b, 0x4d, 0x65, 0x64, 0x69, 0x3b, 0x48, 0x79, 0x64, 0x3b, 0x54, 0x61, 0x63, 0x68, 0x3b, 0x52, 0x68, 0x61, 0x67,
0x3b, 0x49, 0x6f, 0x6e, 0x61, 0x77, 0x72, 0x3b, 0x43, 0x68, 0x77, 0x65, 0x66, 0x72, 0x6f, 0x72, 0x3b, 0x4d, 0x61, 0x77,
0x72, 0x74, 0x68, 0x3b, 0x45, 0x62, 0x72, 0x69, 0x6c, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4d, 0x65, 0x68, 0x65, 0x66,
0x69, 0x6e, 0x3b, 0x47, 0x6f, 0x72, 0x66, 0x66, 0x65, 0x6e, 0x61, 0x66, 0x3b, 0x41, 0x77, 0x73, 0x74, 0x3b, 0x4d, 0x65,
0x64, 0x69, 0x3b, 0x48, 0x79, 0x64, 0x72, 0x65, 0x66, 0x3b, 0x54, 0x61, 0x63, 0x68, 0x77, 0x65, 0x64, 0x64, 0x3b, 0x52,
0x68, 0x61, 0x67, 0x66, 0x79, 0x72, 0x3b, 0x49, 0x3b, 0x43, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47,
0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x52, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d,
0x61, 0x74, 0x3b, 0x45, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x79, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41,
0x67, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a,
0x61, 0x6e, 0x79, 0x75, 0x77, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x77, 0x61, 0x72, 0x69, 0x3b, 0x4d,
0x61, 0x74, 0x73, 0x68, 0x69, 0x3b, 0x45, 0x70, 0x72, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x65, 0x79, 0x69, 0x3b, 0x4a, 0x75,
0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x79, 0x69, 0x3b, 0x41, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70,
0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x68, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62,
0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x1e62, 0x1eb9, 0x301, 0x72, 0x1eb9, 0x301, 0x3b, 0xc8, 0x72, 0xe8,
0x6c, 0xe8, 0x3b, 0x1eb8, 0x72, 0x1eb9, 0x300, 0x6e, 0xe0, 0x3b, 0xcc, 0x67, 0x62, 0xe9, 0x3b, 0x1eb8, 0x300, 0x62, 0x69, 0x62,
0x69, 0x3b, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x41, 0x67, 0x1eb9, 0x6d, 0x1ecd, 0x3b, 0xd2, 0x67, 0xfa, 0x6e, 0x3b, 0x4f,
0x77, 0x65, 0x77, 0x65, 0x3b, 0x1ecc, 0x300, 0x77, 0xe0, 0x72, 0xe0, 0x3b, 0x42, 0xe9, 0x6c, 0xfa, 0x3b, 0x1ecc, 0x300, 0x70,
0x1eb9, 0x300, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1e62, 0x1eb9, 0x301, 0x72, 0x1eb9, 0x301, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xc8, 0x72,
0xe8, 0x6c, 0xe8, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1eb8, 0x72, 0x1eb9, 0x300, 0x6e, 0xe0, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xcc,
0x67, 0x62, 0xe9, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1eb8, 0x300, 0x62, 0x69, 0x62, 0x69, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xd2,
0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x41, 0x67, 0x1eb9, 0x6d, 0x1ecd, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xd2,
0x67, 0xfa, 0x6e, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x4f, 0x77, 0x65, 0x77, 0x65, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1ecc, 0x300,
0x77, 0xe0, 0x72, 0xe0, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x42, 0xe9, 0x6c, 0xfa, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1ecc, 0x300,
0x70, 0x1eb9, 0x300, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x73, 0x3b, 0x41, 0x70, 0x72, 0x3b,
0x4d, 0x65, 0x79, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x3b,
0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x77, 0x61, 0x72, 0x69,
0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x77, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x73, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x72,
0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x65, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x79, 0x69,
0x3b, 0x41, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x68, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b,
0x74, 0x68, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62,
0x61, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72,
0x74, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c,
0x69, 0x3b, 0x61, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x6f,
0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65,
0x6d, 0x62, 0x61, 0x72, 0x3b, 0x4a, 0x2d, 0x67, 0x75, 0x65, 0x72, 0x3b, 0x54, 0x2d, 0x61, 0x72, 0x72, 0x65, 0x65, 0x3b,
0x4d, 0x61, 0x79, 0x72, 0x6e, 0x74, 0x3b, 0x41, 0x76, 0x72, 0x72, 0x69, 0x6c, 0x3b, 0x42, 0x6f, 0x61, 0x6c, 0x64, 0x79,
0x6e, 0x3b, 0x4d, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x4a, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b,
0x4c, 0x75, 0x61, 0x6e, 0x69, 0x73, 0x74, 0x79, 0x6e, 0x3b, 0x4d, 0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4a,
0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4d, 0x2e, 0x48, 0x6f, 0x75, 0x6e, 0x65, 0x79, 0x3b, 0x4d, 0x2e, 0x4e,
0x6f, 0x6c, 0x6c, 0x69, 0x63, 0x6b, 0x3b, 0x4a, 0x65, 0x72, 0x72, 0x65, 0x79, 0x2d, 0x67, 0x65, 0x75, 0x72, 0x65, 0x65,
0x3b, 0x54, 0x6f, 0x73, 0x68, 0x69, 0x61, 0x67, 0x68, 0x74, 0x2d, 0x61, 0x72, 0x72, 0x65, 0x65, 0x3b, 0x4d, 0x61, 0x79,
0x72, 0x6e, 0x74, 0x3b, 0x41, 0x76, 0x65, 0x72, 0x69, 0x6c, 0x3b, 0x42, 0x6f, 0x61, 0x6c, 0x64, 0x79, 0x6e, 0x3b, 0x4d,
0x65, 0x61, 0x6e, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x4a, 0x65, 0x72, 0x72, 0x65, 0x79, 0x2d, 0x73, 0x6f,
0x75, 0x72, 0x65, 0x65, 0x3b, 0x4c, 0x75, 0x61, 0x6e, 0x69, 0x73, 0x74, 0x79, 0x6e, 0x3b, 0x4d, 0x65, 0x61, 0x6e, 0x2d,
0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4a, 0x65, 0x72, 0x72, 0x65, 0x79, 0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72,
0x3b, 0x4d, 0x65, 0x65, 0x20, 0x48, 0x6f, 0x75, 0x6e, 0x65, 0x79, 0x3b, 0x4d, 0x65, 0x65, 0x20, 0x6e, 0x79, 0x20, 0x4e,
0x6f, 0x6c, 0x6c, 0x69, 0x63, 0x6b, 0x3b, 0x47, 0x65, 0x6e, 0x3b, 0x57, 0x68, 0x65, 0x3b, 0x4d, 0x65, 0x72, 0x3b, 0x45,
0x62, 0x72, 0x3b, 0x4d, 0x65, 0x3b, 0x45, 0x66, 0x6e, 0x3b, 0x47, 0x6f, 0x72, 0x3b, 0x45, 0x73, 0x74, 0x3b, 0x47, 0x77,
0x6e, 0x3b, 0x48, 0x65, 0x64, 0x3b, 0x44, 0x75, 0x3b, 0x4b, 0x65, 0x76, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x47, 0x65, 0x6e,
0x76, 0x65, 0x72, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x57, 0x68, 0x65, 0x76, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x79, 0x73, 0x20,
0x4d, 0x65, 0x72, 0x74, 0x68, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x45, 0x62, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x79, 0x73, 0x20,
0x4d, 0x65, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x45, 0x66, 0x61, 0x6e, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x47, 0x6f, 0x72, 0x74,
0x68, 0x65, 0x72, 0x65, 0x6e, 0x3b, 0x4d, 0x79, 0x65, 0x20, 0x45, 0x73, 0x74, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x47, 0x77,
0x79, 0x6e, 0x67, 0x61, 0x6c, 0x61, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x48, 0x65, 0x64, 0x72, 0x61, 0x3b, 0x4d, 0x79, 0x73,
0x20, 0x44, 0x75, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x4b, 0x65, 0x76, 0x61, 0x72, 0x64, 0x68, 0x75, 0x3b, 0x53, 0x2d, 0x186,
0x3b, 0x4b, 0x2d, 0x186, 0x3b, 0x45, 0x2d, 0x186, 0x3b, 0x45, 0x2d, 0x4f, 0x3b, 0x45, 0x2d, 0x4b, 0x3b, 0x4f, 0x2d, 0x41,
0x3b, 0x41, 0x2d, 0x4b, 0x3b, 0x44, 0x2d, 0x186, 0x3b, 0x46, 0x2d, 0x190, 0x3b, 0x186, 0x2d, 0x41, 0x3b, 0x186, 0x2d, 0x4f,
0x3b, 0x4d, 0x2d, 0x186, 0x3b, 0x53, 0x61, 0x6e, 0x64, 0x61, 0x2d, 0x186, 0x70, 0x25b, 0x70, 0x254, 0x6e, 0x3b, 0x4b, 0x77,
0x61, 0x6b, 0x77, 0x61, 0x72, 0x2d, 0x186, 0x67, 0x79, 0x65, 0x66, 0x75, 0x6f, 0x3b, 0x45, 0x62, 0x254, 0x77, 0x2d, 0x186,
0x62, 0x65, 0x6e, 0x65, 0x6d, 0x3b, 0x45, 0x62, 0x254, 0x62, 0x69, 0x72, 0x61, 0x2d, 0x4f, 0x66, 0x6f, 0x72, 0x69, 0x73,
0x75, 0x6f, 0x3b, 0x45, 0x73, 0x75, 0x73, 0x6f, 0x77, 0x20, 0x41, 0x6b, 0x65, 0x74, 0x73, 0x65, 0x61, 0x62, 0x61, 0x2d,
0x4b, 0x254, 0x74, 0x254, 0x6e, 0x69, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x62, 0x69, 0x72, 0x61, 0x64, 0x65, 0x2d, 0x41, 0x79,
0x25b, 0x77, 0x6f, 0x68, 0x6f, 0x6d, 0x75, 0x6d, 0x75, 0x3b, 0x41, 0x79, 0x25b, 0x77, 0x6f, 0x68, 0x6f, 0x2d, 0x4b, 0x69,
0x74, 0x61, 0x77, 0x6f, 0x6e, 0x73, 0x61, 0x3b, 0x44, 0x69, 0x66, 0x75, 0x75, 0x2d, 0x186, 0x73, 0x61, 0x6e, 0x64, 0x61,
0x61, 0x3b, 0x46, 0x61, 0x6e, 0x6b, 0x77, 0x61, 0x2d, 0x190, 0x62, 0x254, 0x3b, 0x186, 0x62, 0x25b, 0x73, 0x25b, 0x2d, 0x41,
0x68, 0x69, 0x6e, 0x69, 0x6d, 0x65, 0x3b, 0x186, 0x62, 0x65, 0x72, 0x25b, 0x66, 0x25b, 0x77, 0x2d, 0x4f, 0x62, 0x75, 0x62,
0x75, 0x6f, 0x3b, 0x4d, 0x75, 0x6d, 0x75, 0x2d, 0x186, 0x70, 0x25b, 0x6e, 0x69, 0x6d, 0x62, 0x61, 0x3b, 0x91c, 0x93e, 0x928,
0x947, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930,
0x94d, 0x91a, 0x3b, 0x90f, 0x92a, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932,
0x948, 0x3b, 0x913, 0x917, 0x938, 0x94d, 0x91f, 0x3b, 0x938, 0x947, 0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x913, 0x915,
0x94d, 0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x935, 0x94d, 0x939, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x921, 0x93f, 0x938, 0x947,
0x902, 0x92c, 0x930, 0x3b, 0x41, 0x68, 0x61, 0x3b, 0x4f, 0x66, 0x6c, 0x3b, 0x4f, 0x63, 0x68, 0x3b, 0x41, 0x62, 0x65, 0x3b,
0x41, 0x67, 0x62, 0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4d, 0x61, 0x61, 0x3b, 0x4d, 0x61, 0x6e, 0x3b, 0x47, 0x62, 0x6f, 0x3b,
0x41, 0x6e, 0x74, 0x3b, 0x41, 0x6c, 0x65, 0x3b, 0x41, 0x66, 0x75, 0x3b, 0x41, 0x68, 0x61, 0x72, 0x61, 0x62, 0x61, 0x74,
0x61, 0x3b, 0x4f, 0x66, 0x6c, 0x6f, 0x3b, 0x4f, 0x63, 0x68, 0x6f, 0x6b, 0x72, 0x69, 0x6b, 0x72, 0x69, 0x3b, 0x41, 0x62,
0x65, 0x69, 0x62, 0x65, 0x65, 0x3b, 0x41, 0x67, 0x62, 0x65, 0x69, 0x6e, 0x61, 0x61, 0x3b, 0x4f, 0x74, 0x75, 0x6b, 0x77,
0x61, 0x64, 0x61, 0x6e, 0x3b, 0x4d, 0x61, 0x61, 0x77, 0x65, 0x3b, 0x4d, 0x61, 0x6e, 0x79, 0x61, 0x77, 0x61, 0x6c, 0x65,
0x3b, 0x47, 0x62, 0x6f, 0x3b, 0x41, 0x6e, 0x74, 0x6f, 0x6e, 0x3b, 0x41, 0x6c, 0x65, 0x6d, 0x6c, 0x65, 0x3b, 0x41, 0x66,
0x75, 0x61, 0x62, 0x65, 0x65, 0x3b, 0x4a, 0x65, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x61, 0x3b, 0x45, 0x70,
0x72, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x75, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x1ecc, 0x67, 0x1ecd, 0x3b, 0x53, 0x65,
0x70, 0x3b, 0x1ecc, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x65, 0x6e, 0x1ee5, 0x77, 0x61,
0x72, 0x1ecb, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x1ee5, 0x77, 0x61, 0x72, 0x1ecb, 0x3b, 0x4d, 0x61, 0x61, 0x63, 0x68, 0x1ecb, 0x3b,
0x45, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x1ecb,
0x3b, 0x1ecc, 0x67, 0x1ecd, 0x1ecd, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x1ecc, 0x6b, 0x74,
0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b,
0x4d, 0x62, 0x65, 0x3b, 0x4b, 0x65, 0x6c, 0x3b, 0x4b, 0x74, 0x169, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x4b, 0x74, 0x6e, 0x3b,
0x54, 0x68, 0x61, 0x3b, 0x4d, 0x6f, 0x6f, 0x3b, 0x4e, 0x79, 0x61, 0x3b, 0x4b, 0x6e, 0x64, 0x3b, 0x128, 0x6b, 0x75, 0x3b,
0x128, 0x6b, 0x6d, 0x3b, 0x128, 0x6b, 0x6c, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x65,
0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6c, 0x129, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77,
0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e,
0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x61,
0x69, 0x20, 0x77, 0x61, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x74, 0x68, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20,
0x77, 0x61, 0x20, 0x6d, 0x75, 0x6f, 0x6e, 0x7a, 0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6e, 0x79,
0x61, 0x61, 0x6e, 0x79, 0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b,
0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x129, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77,
0x61, 0x20, 0x129, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x129, 0x6d, 0x77, 0x65, 0x3b, 0x4d, 0x77, 0x61, 0x69,
0x20, 0x77, 0x61, 0x20, 0x129, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x69, 0x6c, 0x129, 0x3b, 0x4d, 0x3b, 0x4b,
0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x128, 0x3b, 0x128, 0x3b, 0x128,
0x3b, 0x120d, 0x12f0, 0x1275, 0x3b, 0x12ab, 0x1265, 0x12bd, 0x3b, 0x12ad, 0x1265, 0x120b, 0x3b, 0x134b, 0x1305, 0x12ba, 0x3b, 0x12ad, 0x1262, 0x1245,
0x3b, 0x121d, 0x2f, 0x1275, 0x3b, 0x12b0, 0x122d, 0x3b, 0x121b, 0x122d, 0x12eb, 0x3b, 0x12eb, 0x12b8, 0x1292, 0x3b, 0x1218, 0x1270, 0x1209, 0x3b,
0x121d, 0x2f, 0x121d, 0x3b, 0x1270, 0x1215, 0x1233, 0x3b, 0x120d, 0x12f0, 0x1275, 0x122a, 0x3b, 0x12ab, 0x1265, 0x12bd, 0x1265, 0x1272, 0x3b, 0x12ad,
0x1265, 0x120b, 0x3b, 0x134b, 0x1305, 0x12ba, 0x122a, 0x3b, 0x12ad, 0x1262, 0x1245, 0x122a, 0x3b, 0x121d, 0x12aa, 0x12a4, 0x120d, 0x20, 0x1275, 0x131f,
0x1292, 0x122a, 0x3b, 0x12b0, 0x122d, 0x12a9, 0x3b, 0x121b, 0x122d, 0x12eb, 0x121d, 0x20, 0x1275, 0x122a, 0x3b, 0x12eb, 0x12b8, 0x1292, 0x20, 0x1218,
0x1233, 0x1245, 0x1208, 0x122a, 0x3b, 0x1218, 0x1270, 0x1209, 0x3b, 0x121d, 0x12aa, 0x12a4, 0x120d, 0x20, 0x1218, 0x123d, 0x12c8, 0x122a, 0x3b, 0x1270,
0x1215, 0x1233, 0x1235, 0x122a, 0x3b, 0x120d, 0x3b, 0x12ab, 0x3b, 0x12ad, 0x3b, 0x134b, 0x3b, 0x12ad, 0x3b, 0x121d, 0x3b, 0x12b0, 0x3b, 0x121b,
0x3b, 0x12eb, 0x3b, 0x1218, 0x3b, 0x121d, 0x3b, 0x1270, 0x3b, 0x44, 0x79, 0x6f, 0x6e, 0x3b, 0x42, 0x61, 0x61, 0x3b, 0x41, 0x74,
0x61, 0x74, 0x3b, 0x41, 0x6e, 0x61, 0x73, 0x3b, 0x41, 0x74, 0x79, 0x6f, 0x3b, 0x41, 0x63, 0x68, 0x69, 0x3b, 0x41, 0x74,
0x61, 0x72, 0x3b, 0x41, 0x77, 0x75, 0x72, 0x3b, 0x53, 0x68, 0x61, 0x64, 0x3b, 0x53, 0x68, 0x61, 0x6b, 0x3b, 0x4e, 0x61,
0x62, 0x61, 0x3b, 0x4e, 0x61, 0x74, 0x61, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x44, 0x79, 0x6f, 0x6e, 0x3b, 0x50, 0x65, 0x6e,
0x20, 0x42, 0x61, 0x27, 0x61, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x41, 0x74, 0x61, 0x74, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x41,
0x6e, 0x61, 0x73, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x41, 0x74, 0x79, 0x6f, 0x6e, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x41, 0x63,
0x68, 0x69, 0x72, 0x69, 0x6d, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x41, 0x74, 0x61, 0x72, 0x69, 0x62, 0x61, 0x3b, 0x50, 0x65,
0x6e, 0x20, 0x41, 0x77, 0x75, 0x72, 0x72, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x53, 0x68, 0x61, 0x64, 0x6f, 0x6e, 0x3b, 0x50,
0x65, 0x6e, 0x20, 0x53, 0x68, 0x61, 0x6b, 0x75, 0x72, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x4b, 0x75, 0x72, 0x20, 0x4e, 0x61,
0x62, 0x61, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x4b, 0x75, 0x72, 0x20, 0x4e, 0x61, 0x74, 0x61, 0x74, 0x3b, 0x41, 0x331, 0x79,
0x72, 0x3b, 0x41, 0x331, 0x68, 0x77, 0x3b, 0x41, 0x331, 0x74, 0x61, 0x3b, 0x41, 0x331, 0x6e, 0x61, 0x3b, 0x41, 0x331, 0x70,
0x66, 0x3b, 0x41, 0x331, 0x6b, 0x69, 0x3b, 0x41, 0x331, 0x74, 0x79, 0x3b, 0x41, 0x331, 0x6e, 0x69, 0x3b, 0x41, 0x331, 0x6b,
0x75, 0x3b, 0x53, 0x77, 0x61, 0x3b, 0x53, 0x62, 0x79, 0x3b, 0x53, 0x62, 0x68, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20,
0x41, 0x331, 0x79, 0x72, 0x6e, 0x69, 0x67, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x68, 0x77, 0x61, 0x3b,
0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x74, 0x61, 0x74, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331,
0x6e, 0x61, 0x61, 0x69, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x70, 0x66, 0x77, 0x6f, 0x6e, 0x3b, 0x48,
0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x6b, 0x69, 0x74, 0x61, 0x74, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41,
0x331, 0x74, 0x79, 0x69, 0x72, 0x69, 0x6e, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x6e, 0x69, 0x6e, 0x61,
0x69, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x6b, 0x75, 0x6d, 0x76, 0x69, 0x72, 0x69, 0x79, 0x69, 0x6e,
0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x53, 0x77, 0x61, 0x6b, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x53, 0x77,
0x61, 0x6b, 0x20, 0x42, 0x27, 0x61, 0x331, 0x79, 0x72, 0x6e, 0x69, 0x67, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x53,
0x77, 0x61, 0x6b, 0x20, 0x42, 0x27, 0x61, 0x331, 0x68, 0x77, 0x61, 0x3b, 0x5a, 0x65, 0x6e, 0x3b, 0x46, 0x65, 0x76, 0x3b,
0x4d, 0x61, 0x72, 0x3b, 0x41, 0x76, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x67, 0x3b, 0x4c, 0x75, 0x69, 0x3b,
0x41, 0x76, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x63, 0x3b,
0x5a, 0x65, 0x6e, 0xe2, 0x72, 0x3b, 0x46, 0x65, 0x76, 0x72, 0xe2, 0x72, 0x3b, 0x4d, 0x61, 0x72, 0xe7, 0x3b, 0x41, 0x76,
0x72, 0xee, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x67, 0x6e, 0x3b, 0x4c, 0x75, 0x69, 0x3b, 0x41, 0x76, 0x6f,
0x73, 0x74, 0x3b, 0x53, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x4f, 0x74, 0x75, 0x62, 0x61, 0x72, 0x3b, 0x4e,
0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x44, 0x69, 0x63, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x5a, 0x3b, 0x46,
0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44,
0x3b, 0x50, 0x68, 0x61, 0x3b, 0x4c, 0x75, 0x68, 0x3b, 0x1e70, 0x68, 0x61, 0x3b, 0x4c, 0x61, 0x6d, 0x3b, 0x53, 0x68, 0x75,
0x3b, 0x4c, 0x77, 0x69, 0x3b, 0x4c, 0x77, 0x61, 0x3b, 0x1e70, 0x68, 0x61, 0x3b, 0x4b, 0x68, 0x75, 0x3b, 0x54, 0x73, 0x68,
0x3b, 0x1e3c, 0x61, 0x72, 0x3b, 0x4e, 0x79, 0x65, 0x3b, 0x50, 0x68, 0x61, 0x6e, 0x64, 0x6f, 0x3b, 0x4c, 0x75, 0x68, 0x75,
0x68, 0x69, 0x3b, 0x1e70, 0x68, 0x61, 0x66, 0x61, 0x6d, 0x75, 0x68, 0x77, 0x65, 0x3b, 0x4c, 0x61, 0x6d, 0x62, 0x61, 0x6d,
0x61, 0x69, 0x3b, 0x53, 0x68, 0x75, 0x6e, 0x64, 0x75, 0x6e, 0x74, 0x68, 0x75, 0x6c, 0x65, 0x3b, 0x46, 0x75, 0x6c, 0x77,
0x69, 0x3b, 0x46, 0x75, 0x6c, 0x77, 0x61, 0x6e, 0x61, 0x3b, 0x1e70, 0x68, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x65, 0x3b, 0x4b,
0x68, 0x75, 0x62, 0x76, 0x75, 0x6d, 0x65, 0x64, 0x7a, 0x69, 0x3b, 0x54, 0x73, 0x68, 0x69, 0x6d, 0x65, 0x64, 0x7a, 0x69,
0x3b, 0x1e3c, 0x61, 0x72, 0x61, 0x3b, 0x4e, 0x79, 0x65, 0x6e, 0x64, 0x61, 0x76, 0x68, 0x75, 0x73, 0x69, 0x6b, 0x75, 0x3b,
0x64, 0x7a, 0x76, 0x3b, 0x64, 0x7a, 0x64, 0x3b, 0x74, 0x65, 0x64, 0x3b, 0x61, 0x66, 0x254, 0x3b, 0x64, 0x61, 0x6d, 0x3b,
0x6d, 0x61, 0x73, 0x3b, 0x73, 0x69, 0x61, 0x3b, 0x64, 0x65, 0x61, 0x3b, 0x61, 0x6e, 0x79, 0x3b, 0x6b, 0x65, 0x6c, 0x3b,
0x61, 0x64, 0x65, 0x3b, 0x64, 0x7a, 0x6d, 0x3b, 0x64, 0x7a, 0x6f, 0x76, 0x65, 0x3b, 0x64, 0x7a, 0x6f, 0x64, 0x7a, 0x65,
0x3b, 0x74, 0x65, 0x64, 0x6f, 0x78, 0x65, 0x3b, 0x61, 0x66, 0x254, 0x66, 0x129, 0x65, 0x3b, 0x64, 0x61, 0x6d, 0x61, 0x3b,
0x6d, 0x61, 0x73, 0x61, 0x3b, 0x73, 0x69, 0x61, 0x6d, 0x6c, 0x254, 0x6d, 0x3b, 0x64, 0x65, 0x61, 0x73, 0x69, 0x61, 0x6d,
0x69, 0x6d, 0x65, 0x3b, 0x61, 0x6e, 0x79, 0x254, 0x6e, 0x79, 0x254, 0x3b, 0x6b, 0x65, 0x6c, 0x65, 0x3b, 0x61, 0x64, 0x65,
0x25b, 0x6d, 0x65, 0x6b, 0x70, 0x254, 0x78, 0x65, 0x3b, 0x64, 0x7a, 0x6f, 0x6d, 0x65, 0x3b, 0x64, 0x3b, 0x64, 0x3b, 0x74,
0x3b, 0x61, 0x3b, 0x64, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x64, 0x3b, 0x61, 0x3b, 0x6b, 0x3b, 0x61, 0x3b, 0x64, 0x3b, 0x49,
0x61, 0x6e, 0x2e, 0x3b, 0x50, 0x65, 0x70, 0x2e, 0x3b, 0x4d, 0x61, 0x6c, 0x2e, 0x3b, 0x2bb, 0x41, 0x70, 0x2e, 0x3b, 0x4d,
0x65, 0x69, 0x3b, 0x49, 0x75, 0x6e, 0x2e, 0x3b, 0x49, 0x75, 0x6c, 0x2e, 0x3b, 0x2bb, 0x41, 0x75, 0x2e, 0x3b, 0x4b, 0x65,
0x70, 0x2e, 0x3b, 0x2bb, 0x4f, 0x6b, 0x2e, 0x3b, 0x4e, 0x6f, 0x77, 0x2e, 0x3b, 0x4b, 0x65, 0x6b, 0x2e, 0x3b, 0x49, 0x61,
0x6e, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x50, 0x65, 0x70, 0x65, 0x6c, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x6c, 0x61,
0x6b, 0x69, 0x3b, 0x2bb, 0x41, 0x70, 0x65, 0x6c, 0x69, 0x6c, 0x61, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x49, 0x75, 0x6e, 0x65,
0x3b, 0x49, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x2bb, 0x41, 0x75, 0x6b, 0x61, 0x6b, 0x65, 0x3b, 0x4b, 0x65, 0x70, 0x61, 0x6b,
0x65, 0x6d, 0x61, 0x70, 0x61, 0x3b, 0x2bb, 0x4f, 0x6b, 0x61, 0x6b, 0x6f, 0x70, 0x61, 0x3b, 0x4e, 0x6f, 0x77, 0x65, 0x6d,
0x61, 0x70, 0x61, 0x3b, 0x4b, 0x65, 0x6b, 0x65, 0x6d, 0x61, 0x70, 0x61, 0x3b, 0x4a, 0x75, 0x77, 0x3b, 0x53, 0x77, 0x69,
0x3b, 0x54, 0x73, 0x61, 0x3b, 0x4e, 0x79, 0x61, 0x3b, 0x54, 0x73, 0x77, 0x3b, 0x41, 0x74, 0x61, 0x3b, 0x41, 0x6e, 0x61,
0x3b, 0x41, 0x72, 0x69, 0x3b, 0x41, 0x6b, 0x75, 0x3b, 0x53, 0x77, 0x61, 0x3b, 0x4d, 0x61, 0x6e, 0x3b, 0x4d, 0x61, 0x73,
0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x4a, 0x75, 0x77, 0x75, 0x6e, 0x67, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x53, 0x77,
0x69, 0x79, 0x61, 0x6e, 0x67, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x54, 0x73, 0x61, 0x74, 0x3b, 0x5a, 0x77, 0x61, 0x74,
0x20, 0x4e, 0x79, 0x61, 0x69, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x54, 0x73, 0x77, 0x6f, 0x6e, 0x3b, 0x5a, 0x77, 0x61,
0x74, 0x20, 0x41, 0x74, 0x61, 0x61, 0x68, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x41, 0x6e, 0x61, 0x74, 0x61, 0x74, 0x3b,
0x5a, 0x77, 0x61, 0x74, 0x20, 0x41, 0x72, 0x69, 0x6e, 0x61, 0x69, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x41, 0x6b, 0x75,
0x62, 0x75, 0x6e, 0x79, 0x75, 0x6e, 0x67, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x53, 0x77, 0x61, 0x67, 0x3b, 0x5a, 0x77,
0x61, 0x74, 0x20, 0x4d, 0x61, 0x6e, 0x67, 0x6a, 0x75, 0x77, 0x61, 0x6e, 0x67, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x53,
0x77, 0x61, 0x67, 0x2d, 0x4d, 0x61, 0x2d, 0x53, 0x75, 0x79, 0x61, 0x6e, 0x67, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72,
0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b,
0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x63,
0x68, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x65,
0x72, 0x3b, 0x4e, 0x6f, 0x76, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0xa2cd, 0xa1aa, 0x3b, 0xa44d, 0xa1aa, 0x3b, 0xa315, 0xa1aa, 0x3b, 0xa1d6, 0xa1aa, 0x3b, 0xa26c, 0xa1aa, 0x3b, 0xa0d8, 0xa1aa, 0x3b, 0xa3c3, 0xa1aa,
0x3b, 0xa246, 0xa1aa, 0x3b, 0xa22c, 0xa1aa, 0x3b, 0xa2b0, 0xa1aa, 0x3b, 0xa2b0, 0xa2aa, 0xa1aa, 0x3b, 0xa2b0, 0xa44b, 0xa1aa, 0x3b, 0x4a, 0x61,
0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x79, 0x3b, 0x4a, 0x75,
0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x72, 0x68, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x55, 0x73,
0x69, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x61, 0x62, 0x61, 0x72, 0x69, 0x3b, 0x75, 0x46, 0x65, 0x62, 0x65,
0x72, 0x62, 0x61, 0x72, 0x69, 0x3b, 0x75, 0x4d, 0x61, 0x74, 0x6a, 0x68, 0x69, 0x3b, 0x75, 0x2d, 0x41, 0x70, 0x72, 0x65,
0x6c, 0x69, 0x3b, 0x4d, 0x65, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x79, 0x69, 0x3b,
0x41, 0x72, 0x68, 0x6f, 0x73, 0x74, 0x6f, 0x73, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f,
0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x55, 0x73, 0x69, 0x6e, 0x79, 0x69, 0x6b, 0x68, 0x61, 0x62, 0x61, 0x3b, 0x44, 0x69,
0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x74, 0x3b, 0x41, 0x70,
0x6f, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65,
0x74, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x66, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x61, 0x77, 0x61,
0x72, 0x65, 0x3b, 0x46, 0x65, 0x62, 0x65, 0x72, 0x77, 0x61, 0x72, 0x65, 0x3b, 0x4d, 0x61, 0x74, 0x161, 0x68, 0x65, 0x3b,
0x41, 0x70, 0x6f, 0x72, 0x65, 0x6c, 0x65, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6c,
0x61, 0x65, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x73, 0x65, 0x3b, 0x53, 0x65, 0x74, 0x65, 0x6d, 0x65, 0x72, 0x65,
0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x6f, 0x72, 0x65, 0x3b, 0x4e, 0x6f, 0x66, 0x65, 0x6d, 0x65, 0x72, 0x65, 0x3b, 0x44,
0x69, 0x73, 0x65, 0x6d, 0x65, 0x72, 0x65, 0x3b, 0x6f, 0x111, 0x111, 0x61, 0x6a, 0x61, 0x67, 0x65, 0x3b, 0x67, 0x75, 0x6f,
0x76, 0x76, 0x61, 0x3b, 0x6e, 0x6a, 0x75, 0x6b, 0x10d, 0x61, 0x3b, 0x63, 0x75, 0x6f, 0x14b, 0x6f, 0x3b, 0x6d, 0x69, 0x65,
0x73, 0x73, 0x65, 0x3b, 0x67, 0x65, 0x61, 0x73, 0x73, 0x65, 0x3b, 0x73, 0x75, 0x6f, 0x69, 0x64, 0x6e, 0x65, 0x3b, 0x62,
0x6f, 0x72, 0x67, 0x65, 0x3b, 0x10d, 0x61, 0x6b, 0x10d, 0x61, 0x3b, 0x67, 0x6f, 0x6c, 0x67, 0x67, 0x6f, 0x74, 0x3b, 0x73,
0x6b, 0xe1, 0x62, 0x6d, 0x61, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x6c, 0x61, 0x3b, 0x6f, 0x111, 0x111, 0x61, 0x6a, 0x61, 0x67,
0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x67, 0x75, 0x6f, 0x76, 0x76, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x6e,
0x6a, 0x75, 0x6b, 0x10d, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x63, 0x75, 0x6f, 0x14b, 0x6f, 0x6d, 0xe1, 0x6e, 0x6e,
0x75, 0x3b, 0x6d, 0x69, 0x65, 0x73, 0x73, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x67, 0x65, 0x61, 0x73, 0x73, 0x65,
0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x73, 0x75, 0x6f, 0x69, 0x64, 0x6e, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x62,
0x6f, 0x72, 0x67, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x10d, 0x61, 0x6b, 0x10d, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75,
0x3b, 0x67, 0x6f, 0x6c, 0x67, 0x67, 0x6f, 0x74, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x73, 0x6b, 0xe1, 0x62, 0x6d, 0x61,
0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x6c, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x4f, 0x3b,
0x47, 0x3b, 0x4e, 0x3b, 0x43, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x42, 0x3b, 0x10c, 0x3b, 0x47, 0x3b, 0x53, 0x3b,
0x4a, 0x3b, 0x6f, 0x111, 0x111, 0x6a, 0x3b, 0x67, 0x75, 0x6f, 0x76, 0x3b, 0x6e, 0x6a, 0x75, 0x6b, 0x3b, 0x63, 0x75, 0x6f,
0x3b, 0x6d, 0x69, 0x65, 0x73, 0x3b, 0x67, 0x65, 0x61, 0x73, 0x3b, 0x73, 0x75, 0x6f, 0x69, 0x3b, 0x62, 0x6f, 0x72, 0x67,
0x3b, 0x10d, 0x61, 0x6b, 0x10d, 0x3b, 0x67, 0x6f, 0x6c, 0x67, 0x3b, 0x73, 0x6b, 0xe1, 0x62, 0x3b, 0x6a, 0x75, 0x6f, 0x76,
0x3b, 0x4b, 0x69, 0x69, 0x3b, 0x44, 0x68, 0x69, 0x3b, 0x54, 0x72, 0x69, 0x3b, 0x53, 0x70, 0x69, 0x3b, 0x52, 0x69, 0x69,
0x3b, 0x4d, 0x74, 0x69, 0x3b, 0x45, 0x6d, 0x69, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4d, 0x6e, 0x69, 0x3b, 0x4d, 0x78, 0x69,
0x3b, 0x4d, 0x78, 0x6b, 0x3b, 0x4d, 0x78, 0x64, 0x3b, 0x4b, 0x69, 0x6e, 0x67, 0x61, 0x6c, 0x20, 0x69, 0x64, 0x61, 0x73,
0x3b, 0x44, 0x68, 0x61, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x54, 0x72, 0x75, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x53,
0x70, 0x61, 0x74, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x52, 0x69, 0x6d, 0x61, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x4d,
0x61, 0x74, 0x61, 0x72, 0x75, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x45, 0x6d, 0x70, 0x69, 0x74, 0x75, 0x20, 0x69, 0x64,
0x61, 0x73, 0x3b, 0x4d, 0x61, 0x73, 0x70, 0x61, 0x74, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x4d, 0x6e, 0x67, 0x61, 0x72,
0x69, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x4d, 0x61, 0x78, 0x61, 0x6c, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x4d, 0x61,
0x78, 0x61, 0x6c, 0x20, 0x6b, 0x69, 0x6e, 0x67, 0x61, 0x6c, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x4d, 0x61, 0x78, 0x61,
0x6c, 0x20, 0x64, 0x68, 0x61, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x4b, 0x3b, 0x44, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x52,
0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x50, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x44, 0x3b, 0x43, 0x61, 0x6e, 0x3b, 0x46,
0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x43,
0x75, 0x6c, 0x3b, 0x41, 0x67, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x62, 0x3b, 0x44,
0x69, 0x73, 0x3b, 0x43, 0x68, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x75, 0x72, 0x61, 0x72, 0x69,
0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x69, 0x72, 0x69, 0x72, 0x69, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a,
0x75, 0x6e, 0x69, 0x3b, 0x43, 0x68, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65,
0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x69, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x62, 0x65, 0x6d,
0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x43, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d,
0x3b, 0x4a, 0x3b, 0x43, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x49, 0x6d, 0x62, 0x3b, 0x4b,
0x61, 0x77, 0x3b, 0x4b, 0x61, 0x64, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x4b, 0x61, 0x72, 0x3b, 0x4d,
0x66, 0x75, 0x3b, 0x57, 0x75, 0x6e, 0x3b, 0x49, 0x6b, 0x65, 0x3b, 0x49, 0x6b, 0x75, 0x3b, 0x49, 0x6d, 0x77, 0x3b, 0x49,
0x77, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6d, 0x62, 0x69, 0x72, 0x69, 0x3b,
0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x77, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20,
0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x64, 0x61, 0x64, 0x75, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77,
0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x73,
0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x72, 0x61, 0x6e, 0x64,
0x61, 0x64, 0x75, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6d, 0x66, 0x75, 0x6e, 0x67, 0x61,
0x64, 0x65, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x77, 0x75, 0x6e, 0x79, 0x61, 0x6e, 0x79,
0x61, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4d,
0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20,
0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x69, 0x6d, 0x77, 0x65, 0x72, 0x69,
0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20,
0x69, 0x77, 0x69, 0x3b, 0x49, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x57, 0x3b,
0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x73, 0x69, 0x69, 0x3b, 0x63, 0x6f, 0x6c, 0x3b, 0x6d, 0x62, 0x6f, 0x3b,
0x73, 0x65, 0x65, 0x3b, 0x64, 0x75, 0x75, 0x3b, 0x6b, 0x6f, 0x72, 0x3b, 0x6d, 0x6f, 0x72, 0x3b, 0x6a, 0x75, 0x6b, 0x3b,
0x73, 0x6c, 0x74, 0x3b, 0x79, 0x61, 0x72, 0x3b, 0x6a, 0x6f, 0x6c, 0x3b, 0x62, 0x6f, 0x77, 0x3b, 0x73, 0x69, 0x69, 0x6c,
0x6f, 0x3b, 0x63, 0x6f, 0x6c, 0x74, 0x65, 0x3b, 0x6d, 0x62, 0x6f, 0x6f, 0x79, 0x3b, 0x73, 0x65, 0x65, 0x257, 0x74, 0x6f,
0x3b, 0x64, 0x75, 0x75, 0x6a, 0x61, 0x6c, 0x3b, 0x6b, 0x6f, 0x72, 0x73, 0x65, 0x3b, 0x6d, 0x6f, 0x72, 0x73, 0x6f, 0x3b,
0x6a, 0x75, 0x6b, 0x6f, 0x3b, 0x73, 0x69, 0x69, 0x6c, 0x74, 0x6f, 0x3b, 0x79, 0x61, 0x72, 0x6b, 0x6f, 0x6d, 0x61, 0x61,
0x3b, 0x6a, 0x6f, 0x6c, 0x61, 0x6c, 0x3b, 0x62, 0x6f, 0x77, 0x74, 0x65, 0x3b, 0x73, 0x3b, 0x63, 0x3b, 0x6d, 0x3b, 0x73,
0x3b, 0x64, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x73, 0x3b, 0x79, 0x3b, 0x6a, 0x3b, 0x62, 0x3b, 0x4a, 0x45, 0x4e,
0x3b, 0x57, 0x4b, 0x52, 0x3b, 0x57, 0x47, 0x54, 0x3b, 0x57, 0x4b, 0x4e, 0x3b, 0x57, 0x54, 0x4e, 0x3b, 0x57, 0x54, 0x44,
0x3b, 0x57, 0x4d, 0x4a, 0x3b, 0x57, 0x4e, 0x4e, 0x3b, 0x57, 0x4b, 0x44, 0x3b, 0x57, 0x49, 0x4b, 0x3b, 0x57, 0x4d, 0x57,
0x3b, 0x44, 0x49, 0x54, 0x3b, 0x4e, 0x6a, 0x65, 0x6e, 0x75, 0x61, 0x72, 0x129, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20,
0x77, 0x61, 0x20, 0x6b, 0x65, 0x72, 0x129, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74,
0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20,
0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77,
0x61, 0x20, 0x6d, 0x169, 0x67, 0x77, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20,
0x6b, 0x61, 0x6e, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6e, 0x64,
0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65,
0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x169, 0x6d, 0x77, 0x65, 0x3b,
0x4e, 0x64, 0x69, 0x74, 0x68, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x4b, 0x3b, 0x47, 0x3b,
0x47, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x44, 0x3b, 0x4f, 0x62, 0x6f, 0x3b, 0x57, 0x61,
0x61, 0x3b, 0x4f, 0x6b, 0x75, 0x3b, 0x4f, 0x6e, 0x67, 0x3b, 0x49, 0x6d, 0x65, 0x3b, 0x49, 0x6c, 0x65, 0x3b, 0x53, 0x61,
0x70, 0x3b, 0x49, 0x73, 0x69, 0x3b, 0x53, 0x61, 0x61, 0x3b, 0x54, 0x6f, 0x6d, 0x3b, 0x54, 0x6f, 0x62, 0x3b, 0x54, 0x6f,
0x77, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x6f, 0x62, 0x6f, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c,
0x65, 0x20, 0x77, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x6f, 0x6b, 0x75, 0x6e,
0x69, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x6f, 0x6e, 0x67, 0x27, 0x77, 0x61, 0x6e, 0x3b, 0x4c, 0x61,
0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x69, 0x6d, 0x65, 0x74, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x69,
0x6c, 0x65, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x73, 0x61, 0x70, 0x61, 0x3b, 0x4c, 0x61, 0x70, 0x61,
0x20, 0x6c, 0x65, 0x20, 0x69, 0x73, 0x69, 0x65, 0x74, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x73, 0x61,
0x61, 0x6c, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6d, 0x6f, 0x6e, 0x3b, 0x4c, 0x61, 0x70,
0x61, 0x20, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x6f, 0x62, 0x6f, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20,
0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x77, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x4f, 0x3b, 0x57, 0x3b, 0x4f,
0x3b, 0x4f, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4a,
0x61, 0x6e, 0x3b, 0x46, 0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a,
0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4e,
0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x4a, 0x61, 0x6e, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x46, 0x65, 0x76, 0x72, 0x65,
0x69, 0x72, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x63, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x6f,
0x3b, 0x4a, 0x75, 0x6e, 0x68, 0x6f, 0x3b, 0x4a, 0x75, 0x6c, 0x68, 0x6f, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x6f,
0x3b, 0x53, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x4f, 0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x4e, 0x6f, 0x76,
0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x5a, 0x69, 0x62, 0x3b, 0x4e,
0x68, 0x6c, 0x3b, 0x4d, 0x62, 0x69, 0x3b, 0x4d, 0x61, 0x62, 0x3b, 0x4e, 0x6b, 0x77, 0x3b, 0x4e, 0x68, 0x6c, 0x3b, 0x4e,
0x74, 0x75, 0x3b, 0x4e, 0x63, 0x77, 0x3b, 0x4d, 0x70, 0x61, 0x3b, 0x4d, 0x66, 0x75, 0x3b, 0x4c, 0x77, 0x65, 0x3b, 0x4d,
0x70, 0x61, 0x3b, 0x5a, 0x69, 0x62, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x6c, 0x61, 0x3b, 0x4e, 0x68, 0x6c, 0x6f, 0x6c, 0x61,
0x6e, 0x6a, 0x61, 0x3b, 0x4d, 0x62, 0x69, 0x6d, 0x62, 0x69, 0x74, 0x68, 0x6f, 0x3b, 0x4d, 0x61, 0x62, 0x61, 0x73, 0x61,
0x3b, 0x4e, 0x6b, 0x77, 0x65, 0x6e, 0x6b, 0x77, 0x65, 0x7a, 0x69, 0x3b, 0x4e, 0x68, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x6c,
0x61, 0x3b, 0x4e, 0x74, 0x75, 0x6c, 0x69, 0x6b, 0x61, 0x7a, 0x69, 0x3b, 0x4e, 0x63, 0x77, 0x61, 0x62, 0x61, 0x6b, 0x61,
0x7a, 0x69, 0x3b, 0x4d, 0x70, 0x61, 0x6e, 0x64, 0x75, 0x6c, 0x61, 0x3b, 0x4d, 0x66, 0x75, 0x6d, 0x66, 0x75, 0x3b, 0x4c,
0x77, 0x65, 0x7a, 0x69, 0x3b, 0x4d, 0x70, 0x61, 0x6c, 0x61, 0x6b, 0x61, 0x7a, 0x69, 0x3b, 0x5a, 0x3b, 0x4e, 0x3b, 0x4d,
0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d,
0x31, 0x3b, 0x4d, 0x32, 0x3b, 0x4d, 0x33, 0x3b, 0x4d, 0x34, 0x3b, 0x4d, 0x35, 0x3b, 0x4d, 0x36, 0x3b, 0x4d, 0x37, 0x3b,
0x4d, 0x38, 0x3b, 0x4d, 0x39, 0x3b, 0x4d, 0x31, 0x30, 0x3b, 0x4d, 0x31, 0x31, 0x3b, 0x4d, 0x31, 0x32, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20,
0x77, 0x61, 0x20, 0x6b, 0x61, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61,
0x74, 0x61, 0x74, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x61, 0x6e, 0x61, 0x3b,
0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20,
0x77, 0x61, 0x20, 0x73, 0x69, 0x74, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x73, 0x61, 0x62,
0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6e, 0x61, 0x6e, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72,
0x69, 0x20, 0x77, 0x61, 0x20, 0x74, 0x69, 0x73, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69,
0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20,
0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x6a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75,
0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b,
0x54, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x69, 0x6e, 0x6e, 0x3b,
0x62, 0x1e5b, 0x61, 0x3b, 0x6d, 0x61, 0x1e5b, 0x3b, 0x69, 0x62, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x79, 0x75, 0x6e, 0x3b,
0x79, 0x75, 0x6c, 0x3b, 0x263, 0x75, 0x63, 0x3b, 0x63, 0x75, 0x74, 0x3b, 0x6b, 0x74, 0x75, 0x3b, 0x6e, 0x75, 0x77, 0x3b,
0x64, 0x75, 0x6a, 0x3b, 0x69, 0x6e, 0x6e, 0x61, 0x79, 0x72, 0x3b, 0x62, 0x1e5b, 0x61, 0x79, 0x1e5b, 0x3b, 0x6d, 0x61, 0x1e5b,
0x1e63, 0x3b, 0x69, 0x62, 0x72, 0x69, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x79, 0x75, 0x3b, 0x79, 0x75, 0x6e, 0x79, 0x75, 0x3b,
0x79, 0x75, 0x6c, 0x79, 0x75, 0x7a, 0x3b, 0x263, 0x75, 0x63, 0x74, 0x3b, 0x63, 0x75, 0x74, 0x61, 0x6e, 0x62, 0x69, 0x72,
0x3b, 0x6b, 0x74, 0x75, 0x62, 0x72, 0x3b, 0x6e, 0x75, 0x77, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x64, 0x75, 0x6a, 0x61,
0x6e, 0x62, 0x69, 0x72, 0x3b, 0x69, 0x3b, 0x62, 0x3b, 0x6d, 0x3b, 0x69, 0x3b, 0x6d, 0x3b, 0x79, 0x3b, 0x79, 0x3b, 0x263,
0x3b, 0x63, 0x3b, 0x6b, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x2d49, 0x2d4f, 0x2d4f, 0x3b, 0x2d31, 0x2d55, 0x2d30, 0x3b, 0x2d4e, 0x2d30, 0x2d55,
0x3b, 0x2d49, 0x2d31, 0x2d54, 0x3b, 0x2d4e, 0x2d30, 0x2d62, 0x3b, 0x2d62, 0x2d53, 0x2d4f, 0x3b, 0x2d62, 0x2d53, 0x2d4d, 0x3b, 0x2d56, 0x2d53, 0x2d5b,
0x3b, 0x2d5b, 0x2d53, 0x2d5c, 0x3b, 0x2d3d, 0x2d5c, 0x2d53, 0x3b, 0x2d4f, 0x2d53, 0x2d61, 0x3b, 0x2d37, 0x2d53, 0x2d4a, 0x3b, 0x2d49, 0x2d4f, 0x2d4f,
0x2d30, 0x2d62, 0x2d54, 0x3b, 0x2d31, 0x2d55, 0x2d30, 0x2d62, 0x2d55, 0x3b, 0x2d4e, 0x2d30, 0x2d55, 0x2d5a, 0x3b, 0x2d49, 0x2d31, 0x2d54, 0x2d49, 0x2d54,
0x3b, 0x2d4e, 0x2d30, 0x2d62, 0x2d62, 0x2d53, 0x3b, 0x2d62, 0x2d53, 0x2d4f, 0x2d62, 0x2d53, 0x3b, 0x2d62, 0x2d53, 0x2d4d, 0x2d62, 0x2d53, 0x2d63, 0x3b,
0x2d56, 0x2d53, 0x2d5b, 0x2d5c, 0x3b, 0x2d5b, 0x2d53, 0x2d5c, 0x2d30, 0x2d4f, 0x2d31, 0x2d49, 0x2d54, 0x3b, 0x2d3d, 0x2d5c, 0x2d53, 0x2d31, 0x2d54, 0x3b,
0x2d4f, 0x2d53, 0x2d61, 0x2d30, 0x2d4f, 0x2d31, 0x2d49, 0x2d54, 0x3b, 0x2d37, 0x2d53, 0x2d4a, 0x2d30, 0x2d4f, 0x2d31, 0x2d49, 0x2d54, 0x3b, 0x2d49, 0x3b,
0x2d31, 0x3b, 0x2d4e, 0x3b, 0x2d49, 0x3b, 0x2d4e, 0x3b, 0x2d62, 0x3b, 0x2d62, 0x3b, 0x2d56, 0x3b, 0x2d5b, 0x3b, 0x2d3d, 0x3b, 0x2d4f, 0x3b,
0x2d37, 0x3b, 0x59, 0x65, 0x6e, 0x3b, 0x46, 0x75, 0x72, 0x3b, 0x4d, 0x65, 0x263, 0x3b, 0x59, 0x65, 0x62, 0x3b, 0x4d, 0x61,
0x79, 0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59, 0x75, 0x6c, 0x3b, 0x194, 0x75, 0x63, 0x3b, 0x43, 0x74, 0x65, 0x3b, 0x54, 0x75,
0x62, 0x3b, 0x4e, 0x75, 0x6e, 0x3b, 0x44, 0x75, 0x1e7, 0x3b, 0x59, 0x65, 0x6e, 0x6e, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x46,
0x75, 0x1e5b, 0x61, 0x72, 0x3b, 0x4d, 0x65, 0x263, 0x72, 0x65, 0x73, 0x3b, 0x59, 0x65, 0x62, 0x72, 0x69, 0x72, 0x3b, 0x4d,
0x61, 0x79, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6e, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6c, 0x79, 0x75, 0x3b, 0x194, 0x75, 0x63,
0x74, 0x3b, 0x43, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x1e5b, 0x3b, 0x54, 0x75, 0x62, 0x65, 0x1e5b, 0x3b, 0x4e, 0x75, 0x6e, 0x65,
0x6d, 0x62, 0x65, 0x1e5b, 0x3b, 0x44, 0x75, 0x1e7, 0x65, 0x6d, 0x62, 0x65, 0x1e5b, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x59, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x194, 0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4b, 0x42,
0x5a, 0x3b, 0x4b, 0x42, 0x52, 0x3b, 0x4b, 0x53, 0x54, 0x3b, 0x4b, 0x4b, 0x4e, 0x3b, 0x4b, 0x54, 0x4e, 0x3b, 0x4b, 0x4d,
0x4b, 0x3b, 0x4b, 0x4d, 0x53, 0x3b, 0x4b, 0x4d, 0x4e, 0x3b, 0x4b, 0x4d, 0x4e, 0x3b, 0x4b, 0x4b, 0x4d, 0x3b, 0x4b, 0x4e,
0x4b, 0x3b, 0x4b, 0x4e, 0x42, 0x3b, 0x4f, 0x6b, 0x77, 0x6f, 0x6b, 0x75, 0x62, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4f, 0x6b,
0x77, 0x61, 0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61, 0x73, 0x68, 0x61, 0x74, 0x75,
0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61, 0x74, 0x61, 0x61, 0x6e,
0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x75,
0x73, 0x68, 0x61, 0x6e, 0x6a, 0x75, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x75, 0x6e, 0x61, 0x61, 0x6e, 0x61, 0x3b, 0x4f,
0x6b, 0x77, 0x61, 0x6d, 0x77, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b,
0x4f, 0x6b, 0x77, 0x61, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x77, 0x65, 0x3b, 0x4f,
0x6b, 0x77, 0x61, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x69, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x48, 0x75,
0x74, 0x3b, 0x56, 0x69, 0x6c, 0x3b, 0x44, 0x61, 0x74, 0x3b, 0x54, 0x61, 0x69, 0x3b, 0x48, 0x61, 0x6e, 0x3b, 0x53, 0x69,
0x74, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4e, 0x61, 0x6e, 0x3b, 0x54, 0x69, 0x73, 0x3b, 0x4b, 0x75, 0x6d, 0x3b, 0x4b, 0x6d,
0x6a, 0x3b, 0x4b, 0x6d, 0x62, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20,
0x68, 0x75, 0x74, 0x61, 0x6c, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61,
0x20, 0x77, 0x75, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77,
0x61, 0x20, 0x77, 0x75, 0x64, 0x61, 0x74, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67,
0x77, 0x61, 0x20, 0x77, 0x75, 0x74, 0x61, 0x69, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67,
0x77, 0x61, 0x20, 0x77, 0x75, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20,
0x67, 0x77, 0x61, 0x20, 0x73, 0x69, 0x74, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67,
0x77, 0x61, 0x20, 0x73, 0x61, 0x62, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77,
0x61, 0x20, 0x6e, 0x61, 0x6e, 0x65, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61,
0x20, 0x74, 0x69, 0x73, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20,
0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6b,
0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x6a, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a,
0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x62, 0x69, 0x6c, 0x69, 0x3b,
0x48, 0x3b, 0x56, 0x3b, 0x44, 0x3b, 0x54, 0x3b, 0x48, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x4b, 0x3b,
0x4b, 0x3b, 0x4b, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69,
0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x79, 0x69, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a,
0x75, 0x6e, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x79, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x74, 0x69, 0x3b, 0x53,
0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d,
0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x7a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6e,
0x61, 0x72, 0x3b, 0x61, 0x77, 0x69, 0x3b, 0x6d, 0x25b, 0x3b, 0x7a, 0x75, 0x77, 0x3b, 0x7a, 0x75, 0x6c, 0x3b, 0x75, 0x74,
0x69, 0x3b, 0x73, 0x25b, 0x74, 0x3b, 0x254, 0x6b, 0x75, 0x3b, 0x6e, 0x6f, 0x77, 0x3b, 0x64, 0x65, 0x73, 0x3b, 0x7a, 0x61,
0x6e, 0x77, 0x75, 0x79, 0x65, 0x3b, 0x66, 0x65, 0x62, 0x75, 0x72, 0x75, 0x79, 0x65, 0x3b, 0x6d, 0x61, 0x72, 0x69, 0x73,
0x69, 0x3b, 0x61, 0x77, 0x69, 0x72, 0x69, 0x6c, 0x69, 0x3b, 0x6d, 0x25b, 0x3b, 0x7a, 0x75, 0x77, 0x25b, 0x6e, 0x3b, 0x7a,
0x75, 0x6c, 0x75, 0x79, 0x65, 0x3b, 0x75, 0x74, 0x69, 0x3b, 0x73, 0x25b, 0x74, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x75, 0x3b,
0x254, 0x6b, 0x75, 0x74, 0x254, 0x62, 0x75, 0x72, 0x75, 0x3b, 0x6e, 0x6f, 0x77, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x75, 0x3b,
0x64, 0x65, 0x73, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x75, 0x3b, 0x5a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b,
0x5a, 0x3b, 0x5a, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x186, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4d, 0x62, 0x65, 0x3b, 0x4b, 0x61,
0x69, 0x3b, 0x4b, 0x61, 0x74, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x47, 0x61, 0x74, 0x3b, 0x47, 0x61, 0x6e, 0x3b, 0x4d, 0x75,
0x67, 0x3b, 0x4b, 0x6e, 0x6e, 0x3b, 0x4b, 0x65, 0x6e, 0x3b, 0x49, 0x6b, 0x75, 0x3b, 0x49, 0x6d, 0x77, 0x3b, 0x49, 0x67,
0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x72, 0x65, 0x3b, 0x4d, 0x77, 0x65,
0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x129, 0x72, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61,
0x20, 0x6b, 0x61, 0x74, 0x68, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61,
0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4d,
0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x169, 0x67, 0x77, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72,
0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61,
0x20, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d,
0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20,
0x169, 0x6d, 0x77, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x20,
0x6e, 0x61, 0x20, 0x4b, 0x61, 0x129, 0x72, 0x129, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x47,
0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x13a4, 0x13c3, 0x3b, 0x13a7, 0x13a6, 0x3b, 0x13a0,
0x13c5, 0x3b, 0x13a7, 0x13ec, 0x3b, 0x13a0, 0x13c2, 0x3b, 0x13d5, 0x13ad, 0x3b, 0x13ab, 0x13f0, 0x3b, 0x13a6, 0x13b6, 0x3b, 0x13da, 0x13b5, 0x3b,
0x13da, 0x13c2, 0x3b, 0x13c5, 0x13d3, 0x3b, 0x13a4, 0x13cd, 0x3b, 0x13a4, 0x13c3, 0x13b8, 0x13d4, 0x13c5, 0x3b, 0x13a7, 0x13a6, 0x13b5, 0x3b, 0x13a0,
0x13c5, 0x13f1, 0x3b, 0x13a7, 0x13ec, 0x13c2, 0x3b, 0x13a0, 0x13c2, 0x13cd, 0x13ac, 0x13d8, 0x3b, 0x13d5, 0x13ad, 0x13b7, 0x13f1, 0x3b, 0x13ab, 0x13f0,
0x13c9, 0x13c2, 0x3b, 0x13a6, 0x13b6, 0x13c2, 0x3b, 0x13da, 0x13b5, 0x13cd, 0x13d7, 0x3b, 0x13da, 0x13c2, 0x13c5, 0x13d7, 0x3b, 0x13c5, 0x13d3, 0x13d5,
0x13c6, 0x3b, 0x13a4, 0x13cd, 0x13a9, 0x13f1, 0x3b, 0x13a4, 0x3b, 0x13a7, 0x3b, 0x13a0, 0x3b, 0x13a7, 0x3b, 0x13a0, 0x3b, 0x13d5, 0x3b, 0x13ab,
0x3b, 0x13a6, 0x3b, 0x13da, 0x3b, 0x13da, 0x3b, 0x13c5, 0x3b, 0x13a4, 0x3b, 0x7a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x76, 0x3b, 0x6d,
0x61, 0x72, 0x3b, 0x61, 0x76, 0x72, 0x3b, 0x6d, 0x65, 0x3b, 0x7a, 0x69, 0x6e, 0x3b, 0x7a, 0x69, 0x6c, 0x3b, 0x6f, 0x75,
0x74, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x73, 0x3b, 0x7a, 0x61,
0x6e, 0x76, 0x69, 0x65, 0x3b, 0x66, 0x65, 0x76, 0x72, 0x69, 0x79, 0x65, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76,
0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x65, 0x3b, 0x7a, 0x69, 0x6e, 0x3b, 0x7a, 0x69, 0x6c, 0x79, 0x65, 0x3b, 0x6f, 0x75, 0x74,
0x3b, 0x73, 0x65, 0x70, 0x74, 0x61, 0x6d, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x3b, 0x6e, 0x6f, 0x76, 0x61, 0x6d, 0x3b,
0x64, 0x65, 0x73, 0x61, 0x6d, 0x3b, 0x7a, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x7a, 0x3b, 0x7a, 0x3b,
0x6f, 0x3b, 0x73, 0x3b, 0x6f, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x4e, 0x74, 0x61, 0x6e,
0x64, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65,
0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x54, 0x61, 0x74, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20,
0x4e, 0x63, 0x68, 0x65, 0x63, 0x68, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79,
0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20,
0x6e, 0x61, 0x20, 0x55, 0x6d, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61,
0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d, 0x69, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77,
0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4d,
0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x63,
0x68, 0x65, 0x63, 0x68, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e,
0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61,
0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61,
0x20, 0x55, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e,
0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d, 0x3b, 0x46, 0xfa, 0x6e, 0x67, 0x61, 0x74,
0x268, 0x3b, 0x4e, 0x61, 0x61, 0x6e, 0x268, 0x3b, 0x4b, 0x65, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x49, 0x6b, 0xfa, 0x6d, 0x69,
0x3b, 0x49, 0x6e, 0x79, 0x61, 0x6d, 0x62, 0x61, 0x6c, 0x61, 0x3b, 0x49, 0x64, 0x77, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x4d,
0x289, 0x289, 0x6e, 0x63, 0x68, 0x268, 0x3b, 0x56, 0x268, 0x268, 0x72, 0x268, 0x3b, 0x53, 0x61, 0x61, 0x74, 0x289, 0x3b, 0x49,
0x6e, 0x79, 0x69, 0x3b, 0x53, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x53, 0x61, 0x73, 0x61, 0x74, 0x289, 0x3b, 0x4b, 0x289, 0x66,
0xfa, 0x6e, 0x67, 0x61, 0x74, 0x268, 0x3b, 0x4b, 0x289, 0x6e, 0x61, 0x61, 0x6e, 0x268, 0x3b, 0x4b, 0x289, 0x6b, 0x65, 0x65,
0x6e, 0x64, 0x61, 0x3b, 0x4b, 0x77, 0x69, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4b, 0x77, 0x69, 0x69, 0x6e, 0x79, 0x61,
0x6d, 0x62, 0xe1, 0x6c, 0x61, 0x3b, 0x4b, 0x77, 0x69, 0x69, 0x64, 0x77, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x4b, 0x289, 0x6d,
0x289, 0x289, 0x6e, 0x63, 0x68, 0x268, 0x3b, 0x4b, 0x289, 0x76, 0x268, 0x268, 0x72, 0x268, 0x3b, 0x4b, 0x289, 0x73, 0x61, 0x61,
0x74, 0x289, 0x3b, 0x4b, 0x77, 0x69, 0x69, 0x6e, 0x79, 0x69, 0x3b, 0x4b, 0x289, 0x73, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x4b,
0x289, 0x73, 0x61, 0x73, 0x61, 0x74, 0x289, 0x3b, 0x46, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b,
0x4d, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b,
0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x75, 0x3b, 0x4d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x75, 0x3b, 0x4a, 0x75, 0x6c, 0x3b,
0x41, 0x67, 0x75, 0x3b, 0x53, 0x65, 0x62, 0x3b, 0x4f, 0x6b, 0x69, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b,
0x4a, 0x61, 0x6e, 0x77, 0x61, 0x6c, 0x69, 0x79, 0x6f, 0x3b, 0x46, 0x65, 0x62, 0x77, 0x61, 0x6c, 0x69, 0x79, 0x6f, 0x3b,
0x4d, 0x61, 0x72, 0x69, 0x73, 0x69, 0x3b, 0x41, 0x70, 0x75, 0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x61, 0x79, 0x69, 0x3b, 0x4a,
0x75, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x61, 0x79, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x69, 0x74, 0x6f,
0x3b, 0x53, 0x65, 0x62, 0x75, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x69, 0x74, 0x6f, 0x62, 0x62, 0x61,
0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x61, 0x6e,
0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x45, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e,
0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x4f, 0x67, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76,
0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72,
0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x45, 0x70, 0x72, 0x65, 0x6f, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75,
0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x4f, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74,
0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b,
0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b,
0x4a, 0x3b, 0x4f, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x76, 0x3b,
0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b,
0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4e, 0x75, 0x76, 0x3b, 0x44, 0x69, 0x7a, 0x3b,
0x4a, 0x61, 0x6e, 0x65, 0x72, 0x75, 0x3b, 0x46, 0x65, 0x76, 0x65, 0x72, 0x65, 0x72, 0x75, 0x3b, 0x4d, 0x61, 0x72, 0x73,
0x75, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x75, 0x3b, 0x4a, 0x75, 0x6e, 0x68, 0x75, 0x3b, 0x4a,
0x75, 0x6c, 0x68, 0x75, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x75, 0x3b, 0x53, 0x65, 0x74, 0x65, 0x6e, 0x62, 0x72, 0x75,
0x3b, 0x4f, 0x74, 0x75, 0x62, 0x72, 0x75, 0x3b, 0x4e, 0x75, 0x76, 0x65, 0x6e, 0x62, 0x72, 0x75, 0x3b, 0x44, 0x69, 0x7a,
0x65, 0x6e, 0x62, 0x72, 0x75, 0x3b, 0x4a, 0x41, 0x4e, 0x3b, 0x46, 0x45, 0x42, 0x3b, 0x4d, 0x41, 0x43, 0x3b, 0x128, 0x50,
0x55, 0x3b, 0x4d, 0x128, 0x128, 0x3b, 0x4e, 0x4a, 0x55, 0x3b, 0x4e, 0x4a, 0x52, 0x3b, 0x41, 0x47, 0x41, 0x3b, 0x53, 0x50,
0x54, 0x3b, 0x4f, 0x4b, 0x54, 0x3b, 0x4e, 0x4f, 0x56, 0x3b, 0x44, 0x45, 0x43, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72,
0x129, 0x3b, 0x46, 0x65, 0x62, 0x75, 0x72, 0x75, 0x61, 0x72, 0x129, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x128, 0x70,
0x75, 0x72, 0x169, 0x3b, 0x4d, 0x129, 0x129, 0x3b, 0x4e, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x72, 0x61, 0x129,
0x3b, 0x41, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74,
0x169, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x63, 0x65, 0x6d, 0x62, 0x61, 0x3b,
0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x128, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b,
0x4e, 0x3b, 0x44, 0x3b, 0x4d, 0x75, 0x6c, 0x3b, 0x4e, 0x67, 0x61, 0x3b, 0x4b, 0x69, 0x70, 0x3b, 0x49, 0x77, 0x61, 0x3b,
0x4e, 0x67, 0x65, 0x3b, 0x57, 0x61, 0x6b, 0x3b, 0x52, 0x6f, 0x70, 0x3b, 0x4b, 0x6f, 0x67, 0x3b, 0x42, 0x75, 0x72, 0x3b,
0x45, 0x70, 0x65, 0x3b, 0x54, 0x61, 0x69, 0x3b, 0x41, 0x65, 0x6e, 0x3b, 0x4d, 0x75, 0x6c, 0x67, 0x75, 0x6c, 0x3b, 0x4e,
0x67, 0x27, 0x61, 0x74, 0x79, 0x61, 0x74, 0x6f, 0x3b, 0x4b, 0x69, 0x70, 0x74, 0x61, 0x6d, 0x6f, 0x3b, 0x49, 0x77, 0x61,
0x74, 0x20, 0x6b, 0x75, 0x74, 0x3b, 0x4e, 0x67, 0x27, 0x65, 0x69, 0x79, 0x65, 0x74, 0x3b, 0x57, 0x61, 0x6b, 0x69, 0x3b,
0x52, 0x6f, 0x70, 0x74, 0x75, 0x69, 0x3b, 0x4b, 0x69, 0x70, 0x6b, 0x6f, 0x67, 0x61, 0x67, 0x61, 0x3b, 0x42, 0x75, 0x72,
0x65, 0x74, 0x3b, 0x45, 0x70, 0x65, 0x73, 0x6f, 0x3b, 0x4b, 0x69, 0x70, 0x73, 0x75, 0x6e, 0x64, 0x65, 0x20, 0x6e, 0x65,
0x74, 0x61, 0x69, 0x3b, 0x4b, 0x69, 0x70, 0x73, 0x75, 0x6e, 0x64, 0x65, 0x20, 0x6e, 0x65, 0x62, 0x6f, 0x20, 0x61, 0x65,
0x6e, 0x67, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x49, 0x3b, 0x4e, 0x3b, 0x57, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x42,
0x3b, 0x45, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x1c3, 0x4b, 0x68, 0x61, 0x6e, 0x6e, 0x69, 0x3b, 0x1c3, 0x4b, 0x68, 0x61, 0x6e,
0x1c0, 0x67, 0xf4, 0x61, 0x62, 0x3b, 0x1c0, 0x4b, 0x68, 0x75, 0x75, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x1c3, 0x48, 0xf4,
0x61, 0x1c2, 0x6b, 0x68, 0x61, 0x69, 0x62, 0x3b, 0x1c3, 0x4b, 0x68, 0x61, 0x69, 0x74, 0x73, 0xe2, 0x62, 0x3b, 0x47, 0x61,
0x6d, 0x61, 0x1c0, 0x61, 0x65, 0x62, 0x3b, 0x1c2, 0x4b, 0x68, 0x6f, 0x65, 0x73, 0x61, 0x6f, 0x62, 0x3b, 0x41, 0x6f, 0x1c1,
0x6b, 0x68, 0x75, 0x75, 0x6d, 0xfb, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x54, 0x61, 0x72, 0x61, 0x1c0, 0x6b, 0x68, 0x75,
0x75, 0x6d, 0xfb, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x1c2, 0x4e, 0xfb, 0x1c1, 0x6e, 0xe2, 0x69, 0x73, 0x65, 0x62, 0x3b,
0x1c0, 0x48, 0x6f, 0x6f, 0x1c2, 0x67, 0x61, 0x65, 0x62, 0x3b, 0x48, 0xf4, 0x61, 0x73, 0x6f, 0x72, 0x65, 0x1c1, 0x6b, 0x68,
0xe2, 0x62, 0x3b, 0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0xe4, 0x62, 0x2e, 0x3b, 0x4d, 0x61, 0x72, 0x2e, 0x3b, 0x41, 0x70,
0x72, 0x2e, 0x3b, 0x4d, 0xe4, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x2e, 0x3b, 0x4a, 0x75, 0x6c, 0x2e, 0x3b, 0x4f, 0x75, 0x67,
0x2e, 0x3b, 0x53, 0xe4, 0x70, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f, 0x76, 0x2e, 0x3b, 0x44, 0x65, 0x7a,
0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x6e, 0x65, 0x77, 0x61, 0x3b, 0x46, 0xe4, 0x62, 0x72, 0x6f, 0x77, 0x61, 0x3b, 0x4d, 0xe4,
0xe4, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x6c, 0x3b, 0x4d, 0xe4, 0x69, 0x3b, 0x4a, 0x75, 0x75, 0x6e, 0x69, 0x3b,
0x4a, 0x75, 0x75, 0x6c, 0x69, 0x3b, 0x4f, 0x75, 0x6a, 0x6f, 0xdf, 0x3b, 0x53, 0x65, 0x70, 0x74, 0xe4, 0x6d, 0x62, 0x65,
0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x44, 0x65, 0x7a, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x61, 0x6c, 0x3b, 0x41, 0x72, 0xe1, 0x3b, 0x186, 0x25b, 0x6e,
0x3b, 0x44, 0x6f, 0x79, 0x3b, 0x4c, 0xe9, 0x70, 0x3b, 0x52, 0x6f, 0x6b, 0x3b, 0x53, 0xe1, 0x73, 0x3b, 0x42, 0x254, 0x301,
0x72, 0x3b, 0x4b, 0xfa, 0x73, 0x3b, 0x47, 0xed, 0x73, 0x3b, 0x53, 0x68, 0x289, 0x301, 0x3b, 0x4e, 0x74, 0x289, 0x301, 0x3b,
0x4f, 0x6c, 0x61, 0x64, 0x61, 0x6c, 0x289, 0x301, 0x3b, 0x41, 0x72, 0xe1, 0x74, 0x3b, 0x186, 0x25b, 0x6e, 0x268, 0x301, 0x254,
0x268, 0x14b, 0x254, 0x6b, 0x3b, 0x4f, 0x6c, 0x6f, 0x64, 0x6f, 0x79, 0xed, 0xf3, 0x72, 0xed, 0xea, 0x20, 0x69, 0x6e, 0x6b,
0xf3, 0x6b, 0xfa, 0xe2, 0x3b, 0x4f, 0x6c, 0x6f, 0x69, 0x6c, 0xe9, 0x70, 0x16b, 0x6e, 0x79, 0x12b, 0x113, 0x20, 0x69, 0x6e,
0x6b, 0xf3, 0x6b, 0xfa, 0xe2, 0x3b, 0x4b, 0xfa, 0x6a, 0xfa, 0x254, 0x72, 0x254, 0x6b, 0x3b, 0x4d, 0xf3, 0x72, 0x75, 0x73,
0xe1, 0x73, 0x69, 0x6e, 0x3b, 0x186, 0x6c, 0x254, 0x301, 0x268, 0x301, 0x62, 0x254, 0x301, 0x72, 0xe1, 0x72, 0x25b, 0x3b, 0x4b,
0xfa, 0x73, 0x68, 0xee, 0x6e, 0x3b, 0x4f, 0x6c, 0x67, 0xed, 0x73, 0x61, 0x6e, 0x3b, 0x50, 0x289, 0x73, 0x68, 0x289, 0x301,
0x6b, 0x61, 0x3b, 0x4e, 0x74, 0x289, 0x301, 0x14b, 0x289, 0x301, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b,
0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b,
0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b,
0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b,
0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b,
0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x52, 0x61, 0x72, 0x3b, 0x4d, 0x75, 0x6b, 0x3b, 0x4b, 0x77, 0x61, 0x3b,
0x44, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x6f, 0x64, 0x3b, 0x4a, 0x6f, 0x6c, 0x3b, 0x50, 0x65, 0x64, 0x3b,
0x53, 0x6f, 0x6b, 0x3b, 0x54, 0x69, 0x62, 0x3b, 0x4c, 0x61, 0x62, 0x3b, 0x50, 0x6f, 0x6f, 0x3b, 0x4f, 0x72, 0x61, 0x72,
0x61, 0x3b, 0x4f, 0x6d, 0x75, 0x6b, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x67, 0x27, 0x3b, 0x4f, 0x64, 0x75, 0x6e, 0x67,
0x27, 0x65, 0x6c, 0x3b, 0x4f, 0x6d, 0x61, 0x72, 0x75, 0x6b, 0x3b, 0x4f, 0x6d, 0x6f, 0x64, 0x6f, 0x6b, 0x27, 0x6b, 0x69,
0x6e, 0x67, 0x27, 0x6f, 0x6c, 0x3b, 0x4f, 0x6a, 0x6f, 0x6c, 0x61, 0x3b, 0x4f, 0x70, 0x65, 0x64, 0x65, 0x6c, 0x3b, 0x4f,
0x73, 0x6f, 0x6b, 0x6f, 0x73, 0x6f, 0x6b, 0x6f, 0x6d, 0x61, 0x3b, 0x4f, 0x74, 0x69, 0x62, 0x61, 0x72, 0x3b, 0x4f, 0x6c,
0x61, 0x62, 0x6f, 0x72, 0x3b, 0x4f, 0x70, 0x6f, 0x6f, 0x3b, 0x52, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x44, 0x3b, 0x4d, 0x3b,
0x4d, 0x3b, 0x4a, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x50, 0x3b, 0x17d, 0x61, 0x6e, 0x3b, 0x46, 0x65,
0x65, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x77, 0x69, 0x3b, 0x4d, 0x65, 0x3b, 0x17d, 0x75, 0x77, 0x3b, 0x17d, 0x75, 0x79,
0x3b, 0x55, 0x74, 0x3b, 0x53, 0x65, 0x6b, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x6f, 0x3b, 0x44, 0x65, 0x65, 0x3b,
0x17d, 0x61, 0x6e, 0x77, 0x69, 0x79, 0x65, 0x3b, 0x46, 0x65, 0x65, 0x77, 0x69, 0x72, 0x69, 0x79, 0x65, 0x3b, 0x4d, 0x61,
0x72, 0x73, 0x69, 0x3b, 0x41, 0x77, 0x69, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x3b, 0x17d, 0x75, 0x77, 0x65, 0x14b, 0x3b,
0x17d, 0x75, 0x79, 0x79, 0x65, 0x3b, 0x55, 0x74, 0x3b, 0x53, 0x65, 0x6b, 0x74, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x3b, 0x4f,
0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x75, 0x72, 0x3b, 0x4e, 0x6f, 0x6f, 0x77, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x3b, 0x44, 0x65,
0x65, 0x73, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x3b, 0x17d, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x17d, 0x3b,
0x17d, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x44, 0x41, 0x43, 0x3b, 0x44, 0x41, 0x52, 0x3b,
0x44, 0x41, 0x44, 0x3b, 0x44, 0x41, 0x4e, 0x3b, 0x44, 0x41, 0x48, 0x3b, 0x44, 0x41, 0x55, 0x3b, 0x44, 0x41, 0x4f, 0x3b,
0x44, 0x41, 0x42, 0x3b, 0x44, 0x4f, 0x43, 0x3b, 0x44, 0x41, 0x50, 0x3b, 0x44, 0x47, 0x49, 0x3b, 0x44, 0x41, 0x47, 0x3b,
0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x63, 0x68, 0x69, 0x65, 0x6c, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d,
0x61, 0x72, 0x20, 0x41, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x64, 0x65,
0x6b, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x6e, 0x67, 0x27, 0x77, 0x65, 0x6e, 0x3b, 0x44, 0x77,
0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x62, 0x69, 0x63, 0x68, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20,
0x41, 0x75, 0x63, 0x68, 0x69, 0x65, 0x6c, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x62, 0x69, 0x72,
0x69, 0x79, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x62, 0x6f, 0x72, 0x6f, 0x3b, 0x44, 0x77,
0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x4f, 0x63, 0x68, 0x69, 0x6b, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72,
0x20, 0x41, 0x70, 0x61, 0x72, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x67, 0x69, 0x20, 0x61, 0x63, 0x68,
0x69, 0x65, 0x6c, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x70, 0x61, 0x72, 0x20, 0x67, 0x69, 0x20,
0x61, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x43, 0x3b, 0x52, 0x3b, 0x44, 0x3b, 0x4e, 0x3b, 0x42, 0x3b, 0x55, 0x3b, 0x42, 0x3b,
0x42, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x59, 0x65, 0x6e, 0x3b, 0x59, 0x65, 0x62, 0x3b, 0x4d, 0x61,
0x72, 0x3b, 0x49, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59, 0x75, 0x6c, 0x3b, 0x194, 0x75,
0x63, 0x3b, 0x43, 0x75, 0x74, 0x3b, 0x4b, 0x1e6d, 0x75, 0x3b, 0x4e, 0x77, 0x61, 0x3b, 0x44, 0x75, 0x6a, 0x3b, 0x59, 0x65,
0x6e, 0x6e, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x59, 0x65, 0x62, 0x72, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x4d, 0x61, 0x72, 0x73,
0x3b, 0x49, 0x62, 0x72, 0x69, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6e, 0x79, 0x75, 0x3b, 0x59,
0x75, 0x6c, 0x79, 0x75, 0x7a, 0x3b, 0x194, 0x75, 0x63, 0x74, 0x3b, 0x43, 0x75, 0x74, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b,
0x4b, 0x1e6d, 0x75, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x77, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x44, 0x75, 0x6a, 0x61, 0x6e,
0x62, 0x69, 0x72, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x194, 0x3b,
0x43, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x6c,
0x75, 0x61, 0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x6c, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x65,
0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x69, 0x3b,
0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x91c, 0x93e, 0x928, 0x941, 0x935, 0x93e, 0x930, 0x940,
0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x938, 0x3b, 0x90f, 0x92b,
0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x907, 0x3b, 0x906, 0x917,
0x938, 0x94d, 0x925, 0x3b, 0x938, 0x947, 0x92c, 0x925, 0x947, 0x91c, 0x94d, 0x92c, 0x93c, 0x930, 0x3b, 0x905, 0x916, 0x925, 0x92c, 0x930,
0x3b, 0x928, 0x92c, 0x947, 0x91c, 0x94d, 0x92c, 0x93c, 0x930, 0x3b, 0x926, 0x93f, 0x938, 0x947, 0x91c, 0x94d, 0x92c, 0x93c, 0x930, 0x3b,
0x91c, 0x3b, 0x92b, 0x947, 0x3b, 0x92e, 0x93e, 0x3b, 0x90f, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x3b, 0x91c, 0x941, 0x3b, 0x906,
0x3b, 0x938, 0x947, 0x3b, 0x905, 0x3b, 0x928, 0x3b, 0x926, 0x93f, 0x3b, 0x6e, 0xf9, 0x6d, 0x3b, 0x6b, 0x268, 0x7a, 0x3b, 0x74,
0x268, 0x64, 0x3b, 0x74, 0x61, 0x61, 0x3b, 0x73, 0x65, 0x65, 0x3b, 0x6e, 0x7a, 0x75, 0x3b, 0x64, 0x75, 0x6d, 0x3b, 0x66,
0x254, 0x65, 0x3b, 0x64, 0x7a, 0x75, 0x3b, 0x6c, 0x254, 0x6d, 0x3b, 0x6b, 0x61, 0x61, 0x3b, 0x66, 0x77, 0x6f, 0x3b, 0x6e,
0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x6e, 0xf9, 0x6d, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x6b,
0x197, 0x300, 0x7a, 0xf9, 0x294, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x74, 0x197, 0x300, 0x64, 0x289, 0x300,
0x67, 0x68, 0xe0, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x74, 0x1ce, 0x61, 0x66, 0x289, 0x304, 0x67, 0x68,
0x101, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0xe8, 0x73, 0xe8, 0x65, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254,
0x300, 0x6e, 0x7a, 0xf9, 0x67, 0x68, 0xf2, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x64, 0xf9, 0x6d, 0x6c,
0x6f, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x6b, 0x77, 0xee, 0x66, 0x254, 0x300, 0x65, 0x3b, 0x6e, 0x64,
0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x74, 0x197, 0x300, 0x66, 0x289, 0x300, 0x67, 0x68, 0xe0, 0x64, 0x7a, 0x75, 0x67, 0x68,
0xf9, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x67, 0x68, 0x1d4, 0x75, 0x77, 0x65, 0x6c, 0x254, 0x300, 0x6d,
0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x63, 0x68, 0x77, 0x61, 0x294, 0xe0, 0x6b, 0x61, 0x61, 0x20, 0x77,
0x6f, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0xe8, 0x66, 0x77, 0xf2, 0x6f, 0x3b, 0x6e, 0x3b, 0x6b, 0x3b, 0x74, 0x3b,
0x74, 0x3b, 0x73, 0x3b, 0x7a, 0x3b, 0x6b, 0x3b, 0x66, 0x3b, 0x64, 0x3b, 0x6c, 0x3b, 0x63, 0x3b, 0x66, 0x3b, 0x6b, 0x254,
0x6e, 0x3b, 0x6d, 0x61, 0x63, 0x3b, 0x6d, 0x61, 0x74, 0x3b, 0x6d, 0x74, 0x6f, 0x3b, 0x6d, 0x70, 0x75, 0x3b, 0x68, 0x69,
0x6c, 0x3b, 0x6e, 0x6a, 0x65, 0x3b, 0x68, 0x69, 0x6b, 0x3b, 0x64, 0x69, 0x70, 0x3b, 0x62, 0x69, 0x6f, 0x3b, 0x6d, 0x61,
0x79, 0x3b, 0x6c, 0x69, 0x253, 0x3b, 0x4b, 0x254, 0x6e, 0x64, 0x254, 0x14b, 0x3b, 0x4d, 0xe0, 0x63, 0x25b, 0x302, 0x6c, 0x3b,
0x4d, 0xe0, 0x74, 0xf9, 0x6d, 0x62, 0x3b, 0x4d, 0xe0, 0x74, 0x6f, 0x70, 0x3b, 0x4d, 0x300, 0x70, 0x75, 0x79, 0x25b, 0x3b,
0x48, 0xec, 0x6c, 0xf2, 0x6e, 0x64, 0x25b, 0x300, 0x3b, 0x4e, 0x6a, 0xe8, 0x62, 0xe0, 0x3b, 0x48, 0xec, 0x6b, 0x61, 0x14b,
0x3b, 0x44, 0xec, 0x70, 0x254, 0x300, 0x73, 0x3b, 0x42, 0xec, 0xf2, 0xf4, 0x6d, 0x3b, 0x4d, 0xe0, 0x79, 0x25b, 0x73, 0xe8,
0x70, 0x3b, 0x4c, 0xec, 0x62, 0x75, 0x79, 0x20, 0x6c, 0x69, 0x20, 0x144, 0x79, 0xe8, 0x65, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b,
0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x68, 0x3b, 0x6e, 0x3b, 0x68, 0x3b, 0x64, 0x3b, 0x62, 0x3b, 0x6d, 0x3b, 0x6c, 0x3b,
0x64, 0x69, 0x3b, 0x14b, 0x67, 0x254, 0x6e, 0x3b, 0x73, 0x254, 0x14b, 0x3b, 0x64, 0x69, 0x253, 0x3b, 0x65, 0x6d, 0x69, 0x3b,
0x65, 0x73, 0x254, 0x3b, 0x6d, 0x61, 0x64, 0x3b, 0x64, 0x69, 0x14b, 0x3b, 0x6e, 0x79, 0x25b, 0x74, 0x3b, 0x6d, 0x61, 0x79,
0x3b, 0x74, 0x69, 0x6e, 0x3b, 0x65, 0x6c, 0xe1, 0x3b, 0x64, 0x69, 0x6d, 0x254, 0x301, 0x64, 0x69, 0x3b, 0x14b, 0x67, 0x254,
0x6e, 0x64, 0x25b, 0x3b, 0x73, 0x254, 0x14b, 0x25b, 0x3b, 0x64, 0x69, 0x253, 0xe1, 0x253, 0xe1, 0x3b, 0x65, 0x6d, 0x69, 0x61,
0x73, 0x65, 0x6c, 0x65, 0x3b, 0x65, 0x73, 0x254, 0x70, 0x25b, 0x73, 0x254, 0x70, 0x25b, 0x3b, 0x6d, 0x61, 0x64, 0x69, 0x253,
0x25b, 0x301, 0x64, 0xed, 0x253, 0x25b, 0x301, 0x3b, 0x64, 0x69, 0x14b, 0x67, 0x69, 0x6e, 0x64, 0x69, 0x3b, 0x6e, 0x79, 0x25b,
0x74, 0x25b, 0x6b, 0x69, 0x3b, 0x6d, 0x61, 0x79, 0xe9, 0x73, 0x25b, 0x301, 0x3b, 0x74, 0x69, 0x6e, 0xed, 0x6e, 0xed, 0x3b,
0x65, 0x6c, 0xe1, 0x14b, 0x67, 0x25b, 0x301, 0x3b, 0x64, 0x3b, 0x14b, 0x3b, 0x73, 0x3b, 0x64, 0x3b, 0x65, 0x3b, 0x65, 0x3b,
0x6d, 0x3b, 0x64, 0x3b, 0x6e, 0x3b, 0x6d, 0x3b, 0x74, 0x3b, 0x65, 0x3b, 0x53, 0x61, 0x3b, 0x46, 0x65, 0x3b, 0x4d, 0x61,
0x3b, 0x41, 0x62, 0x3b, 0x4d, 0x65, 0x3b, 0x53, 0x75, 0x3b, 0x53, 0xfa, 0x3b, 0x55, 0x74, 0x3b, 0x53, 0x65, 0x3b, 0x4f,
0x6b, 0x3b, 0x4e, 0x6f, 0x3b, 0x44, 0x65, 0x3b, 0x53, 0x61, 0x6e, 0x76, 0x69, 0x65, 0x3b, 0x46, 0xe9, 0x62, 0x69, 0x72,
0x69, 0x65, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x3b, 0x41, 0x62, 0x75, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x53,
0x75, 0x65, 0x14b, 0x3b, 0x53, 0xfa, 0x75, 0x79, 0x65, 0x65, 0x3b, 0x55, 0x74, 0x3b, 0x53, 0x65, 0x74, 0x74, 0x65, 0x6d,
0x62, 0x61, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72,
0x3b, 0x44, 0x69, 0x73, 0x61, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x53, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b,
0x53, 0x3b, 0x53, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x6e, 0x67, 0x6f, 0x3b, 0x6e, 0x67,
0x62, 0x3b, 0x6e, 0x67, 0x6c, 0x3b, 0x6e, 0x67, 0x6e, 0x3b, 0x6e, 0x67, 0x74, 0x3b, 0x6e, 0x67, 0x73, 0x3b, 0x6e, 0x67,
0x7a, 0x3b, 0x6e, 0x67, 0x6d, 0x3b, 0x6e, 0x67, 0x65, 0x3b, 0x6e, 0x67, 0x61, 0x3b, 0x6e, 0x67, 0x64, 0x3b, 0x6e, 0x67,
0x62, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6f, 0x73, 0xfa, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x62, 0x25b, 0x30c, 0x3b,
0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6c, 0xe1, 0x6c, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6e, 0x79, 0x69, 0x6e, 0x61,
0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x74, 0xe1, 0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x73, 0x61, 0x6d, 0x1dd,
0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x7a, 0x61, 0x6d, 0x67, 0x62, 0xe1, 0x6c, 0x61, 0x3b, 0x6e, 0x67, 0x254,
0x6e, 0x20, 0x6d, 0x77, 0x6f, 0x6d, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x65, 0x62, 0x75, 0x6c, 0xfa, 0x3b, 0x6e, 0x67,
0x254, 0x6e, 0x20, 0x61, 0x77, 0xf3, 0x6d, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x61, 0x77, 0xf3, 0x6d, 0x20, 0x61, 0x69,
0x20, 0x64, 0x7a, 0x69, 0xe1, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x61, 0x77, 0xf3, 0x6d, 0x20, 0x61, 0x69, 0x20, 0x62,
0x25b, 0x30c, 0x3b, 0x6f, 0x3b, 0x62, 0x3b, 0x6c, 0x3b, 0x6e, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x7a, 0x3b, 0x6d, 0x3b, 0x65,
0x3b, 0x61, 0x3b, 0x64, 0x3b, 0x62, 0x3b, 0x14b, 0x31, 0x3b, 0x14b, 0x32, 0x3b, 0x14b, 0x33, 0x3b, 0x14b, 0x34, 0x3b, 0x14b,
0x35, 0x3b, 0x14b, 0x36, 0x3b, 0x14b, 0x37, 0x3b, 0x14b, 0x38, 0x3b, 0x14b, 0x39, 0x3b, 0x14b, 0x31, 0x30, 0x3b, 0x14b, 0x31,
0x31, 0x3b, 0x14b, 0x31, 0x32, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x20, 0x6e, 0x74, 0x254, 0x301, 0x6e, 0x74, 0x254,
0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x62, 0x25b, 0x301, 0x25b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20,
0x61, 0x6b, 0x1dd, 0x20, 0x72, 0xe1, 0xe1, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x6e, 0x69, 0x6e,
0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x6e, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20,
0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x66, 0x254, 0x6b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20,
0x74, 0xe1, 0x61, 0x62, 0x25b, 0x25b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x72,
0x61, 0x61, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x6e, 0x69, 0x6e, 0x3b, 0x14b,
0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x6e, 0x74, 0x25b, 0x6b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b,
0x1dd, 0x20, 0x6e, 0x74, 0x25b, 0x6b, 0x20, 0x64, 0x69, 0x20, 0x62, 0x254, 0x301, 0x6b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20,
0x61, 0x6b, 0x1dd, 0x20, 0x6e, 0x74, 0x25b, 0x6b, 0x20, 0x64, 0x69, 0x20, 0x62, 0x25b, 0x301, 0x25b, 0x3b, 0x43, 0x69, 0x6f,
0x3b, 0x4c, 0x75, 0x69, 0x3b, 0x4c, 0x75, 0x73, 0x3b, 0x4d, 0x75, 0x75, 0x3b, 0x4c, 0x75, 0x6d, 0x3b, 0x4c, 0x75, 0x66,
0x3b, 0x4b, 0x61, 0x62, 0x3b, 0x4c, 0x75, 0x73, 0x3b, 0x4c, 0x75, 0x74, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4b, 0x61, 0x73,
0x3b, 0x43, 0x69, 0x73, 0x3b, 0x43, 0x69, 0x6f, 0x6e, 0x67, 0x6f, 0x3b, 0x4c, 0xf9, 0x69, 0x73, 0x68, 0x69, 0x3b, 0x4c,
0x75, 0x73, 0xf2, 0x6c, 0x6f, 0x3b, 0x4d, 0xf9, 0x75, 0x79, 0xe0, 0x3b, 0x4c, 0x75, 0x6d, 0xf9, 0x6e, 0x67, 0xf9, 0x6c,
0xf9, 0x3b, 0x4c, 0x75, 0x66, 0x75, 0x69, 0x6d, 0x69, 0x3b, 0x4b, 0x61, 0x62, 0xe0, 0x6c, 0xe0, 0x73, 0x68, 0xec, 0x70,
0xf9, 0x3b, 0x4c, 0xf9, 0x73, 0x68, 0xec, 0x6b, 0xe0, 0x3b, 0x4c, 0x75, 0x74, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x6f, 0x3b,
0x4c, 0x75, 0x6e, 0x67, 0xf9, 0x64, 0x69, 0x3b, 0x4b, 0x61, 0x73, 0x77, 0xe8, 0x6b, 0xe8, 0x73, 0xe8, 0x3b, 0x43, 0x69,
0x73, 0x77, 0xe0, 0x3b, 0x43, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x4c, 0x3b,
0x4c, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x43, 0x3b, 0x4b, 0x77, 0x61, 0x3b, 0x55, 0x6e, 0x61, 0x3b, 0x52, 0x61, 0x72, 0x3b,
0x43, 0x68, 0x65, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x4d, 0x6f, 0x63, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4e, 0x61, 0x6e, 0x3b,
0x54, 0x69, 0x73, 0x3b, 0x4b, 0x75, 0x6d, 0x3b, 0x4d, 0x6f, 0x6a, 0x3b, 0x59, 0x65, 0x6c, 0x3b, 0x4d, 0x77, 0x65, 0x72,
0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f,
0x20, 0x75, 0x6e, 0x61, 0x79, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x75, 0x6e,
0x65, 0x72, 0x61, 0x72, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x75, 0x6e, 0x65, 0x63, 0x68,
0x65, 0x73, 0x68, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x75, 0x6e, 0x65, 0x74, 0x68, 0x61,
0x6e, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x75, 0x20, 0x6e, 0x61,
0x20, 0x6d, 0x6f, 0x63, 0x68, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x73, 0x61, 0x62, 0x61,
0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6e, 0x61, 0x6e, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x6f, 0x20, 0x74, 0x69, 0x73, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x75,
0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20,
0x6d, 0x6f, 0x6a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e,
0x61, 0x20, 0x79, 0x65, 0x6c, 0x27, 0x6c, 0x69, 0x3b, 0x4b, 0x3b, 0x55, 0x3b, 0x52, 0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x4d,
0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x46, 0x4c, 0x4f, 0x3b, 0x43, 0x4c, 0x41,
0x3b, 0x43, 0x4b, 0x49, 0x3b, 0x46, 0x4d, 0x46, 0x3b, 0x4d, 0x41, 0x44, 0x3b, 0x4d, 0x42, 0x49, 0x3b, 0x4d, 0x4c, 0x49,
0x3b, 0x4d, 0x41, 0x4d, 0x3b, 0x46, 0x44, 0x45, 0x3b, 0x46, 0x4d, 0x55, 0x3b, 0x46, 0x47, 0x57, 0x3b, 0x46, 0x59, 0x55,
0x3b, 0x46, 0x129, 0x69, 0x20, 0x4c, 0x6f, 0x6f, 0x3b, 0x43, 0x6f, 0x6b, 0x63, 0x77, 0x61, 0x6b, 0x6c, 0x61, 0x14b, 0x6e,
0x65, 0x3b, 0x43, 0x6f, 0x6b, 0x63, 0x77, 0x61, 0x6b, 0x6c, 0x69, 0x69, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x4d, 0x61, 0x72,
0x66, 0x6f, 0x6f, 0x3b, 0x4d, 0x61, 0x64, 0x1dd, 0x1dd, 0x75, 0x75, 0x74, 0x1dd, 0x62, 0x69, 0x6a, 0x61, 0x14b, 0x3b, 0x4d,
0x61, 0x6d, 0x1dd, 0x14b, 0x67, 0x77, 0xe3, 0x61, 0x66, 0x61, 0x68, 0x62, 0x69, 0x69, 0x3b, 0x4d, 0x61, 0x6d, 0x1dd, 0x14b,
0x67, 0x77, 0xe3, 0x61, 0x6c, 0x69, 0x69, 0x3b, 0x4d, 0x61, 0x64, 0x1dd, 0x6d, 0x62, 0x69, 0x69, 0x3b, 0x46, 0x129, 0x69,
0x20, 0x44, 0x1dd, 0x253, 0x6c, 0x69, 0x69, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x4d, 0x75, 0x6e, 0x64, 0x61, 0x14b, 0x3b, 0x46,
0x129, 0x69, 0x20, 0x47, 0x77, 0x61, 0x68, 0x6c, 0x6c, 0x65, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x59, 0x75, 0x72, 0x75, 0x3b,
0x4f, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x46, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x55, 0x3b,
0x57, 0x3b, 0x59, 0x3b, 0x6e, 0x67, 0x31, 0x3b, 0x6e, 0x67, 0x32, 0x3b, 0x6e, 0x67, 0x33, 0x3b, 0x6e, 0x67, 0x34, 0x3b,
0x6e, 0x67, 0x35, 0x3b, 0x6e, 0x67, 0x36, 0x3b, 0x6e, 0x67, 0x37, 0x3b, 0x6e, 0x67, 0x38, 0x3b, 0x6e, 0x67, 0x39, 0x3b,
0x6e, 0x67, 0x31, 0x30, 0x3b, 0x6e, 0x67, 0x31, 0x31, 0x3b, 0x6b, 0x72, 0x69, 0x73, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e,
0x20, 0x6d, 0x61, 0x74, 0xe1, 0x68, 0x72, 0x61, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x6d, 0x62, 0x61, 0x3b,
0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x6c, 0x61, 0x6c, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x6e, 0x61,
0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x74, 0x61, 0x6e, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x74,
0x75, 0xf3, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x68, 0x25b, 0x6d, 0x62, 0x75, 0x25b, 0x72, 0xed, 0x3b, 0x6e, 0x67,
0x77, 0x25b, 0x6e, 0x20, 0x6c, 0x254, 0x6d, 0x62, 0x69, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x72, 0x25b, 0x62, 0x76,
0x75, 0xe2, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x77, 0x75, 0x6d, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x77,
0x75, 0x6d, 0x20, 0x6e, 0x61, 0x76, 0x16d, 0x72, 0x3b, 0x6b, 0x72, 0xed, 0x73, 0x69, 0x6d, 0x69, 0x6e, 0x3b, 0x54, 0x69,
0x6f, 0x70, 0x3b, 0x50, 0x25b, 0x74, 0x3b, 0x44, 0x75, 0x254, 0x331, 0x254, 0x331, 0x3b, 0x44, 0x75, 0x61, 0x3b, 0x44, 0x75,
0xe4, 0x3b, 0x4b, 0x6f, 0x72, 0x3b, 0x50, 0x61, 0x79, 0x3b, 0x54, 0x68, 0x6f, 0x6f, 0x3b, 0x54, 0x25b, 0x25b, 0x3b, 0x4c,
0x61, 0x61, 0x3b, 0x4b, 0x75, 0x72, 0x3b, 0x54, 0x69, 0x6f, 0x70, 0x3b, 0x54, 0x69, 0x6f, 0x70, 0x20, 0x74, 0x68, 0x61,
0x72, 0x20, 0x70, 0x25b, 0x74, 0x3b, 0x50, 0x25b, 0x74, 0x3b, 0x44, 0x75, 0x254, 0x331, 0x254, 0x331, 0x14b, 0x3b, 0x47, 0x75,
0x61, 0x6b, 0x3b, 0x44, 0x75, 0xe4, 0x74, 0x3b, 0x4b, 0x6f, 0x72, 0x6e, 0x79, 0x6f, 0x6f, 0x74, 0x3b, 0x50, 0x61, 0x79,
0x20, 0x79, 0x69, 0x65, 0x331, 0x74, 0x6e, 0x69, 0x3b, 0x54, 0x68, 0x6f, 0x331, 0x6f, 0x331, 0x72, 0x3b, 0x54, 0x25b, 0x25b,
0x72, 0x3b, 0x4c, 0x61, 0x61, 0x74, 0x68, 0x3b, 0x4b, 0x75, 0x72, 0x3b, 0x54, 0x69, 0x6f, 0x331, 0x70, 0x20, 0x69, 0x6e,
0x20, 0x64, 0x69, 0x331, 0x69, 0x331, 0x74, 0x3b, 0x54, 0x3b, 0x50, 0x3b, 0x44, 0x3b, 0x47, 0x3b, 0x44, 0x3b, 0x4b, 0x3b,
0x50, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x422, 0x43e, 0x445, 0x441, 0x3b, 0x41e, 0x43b, 0x443,
0x43d, 0x3b, 0x41a, 0x43b, 0x43d, 0x5f, 0x442, 0x442, 0x440, 0x3b, 0x41c, 0x443, 0x441, 0x5f, 0x443, 0x441, 0x442, 0x3b, 0x42b, 0x430,
0x43c, 0x5f, 0x439, 0x43d, 0x3b, 0x411, 0x44d, 0x441, 0x5f, 0x439, 0x43d, 0x3b, 0x41e, 0x442, 0x5f, 0x439, 0x43d, 0x3b, 0x410, 0x442,
0x440, 0x434, 0x44c, 0x5f, 0x439, 0x43d, 0x3b, 0x411, 0x43b, 0x495, 0x43d, 0x5f, 0x439, 0x43d, 0x3b, 0x410, 0x43b, 0x442, 0x3b, 0x421,
0x44d, 0x442, 0x3b, 0x410, 0x445, 0x441, 0x3b, 0x422, 0x43e, 0x445, 0x441, 0x443, 0x43d, 0x43d, 0x44c, 0x443, 0x3b, 0x41e, 0x43b, 0x443,
0x43d, 0x43d, 0x44c, 0x443, 0x3b, 0x41a, 0x443, 0x43b, 0x443, 0x43d, 0x20, 0x442, 0x443, 0x442, 0x430, 0x440, 0x3b, 0x41c, 0x443, 0x443,
0x441, 0x20, 0x443, 0x441, 0x442, 0x430, 0x440, 0x3b, 0x42b, 0x430, 0x43c, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x411, 0x44d, 0x441,
0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x41e, 0x442, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x410, 0x442, 0x44b, 0x440, 0x434, 0x44c,
0x44b, 0x445, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x411, 0x430, 0x43b, 0x430, 0x495, 0x430, 0x43d, 0x20, 0x44b, 0x439, 0x44b, 0x43d,
0x3b, 0x410, 0x43b, 0x442, 0x44b, 0x43d, 0x43d, 0x44c, 0x44b, 0x3b, 0x421, 0x44d, 0x442, 0x438, 0x43d, 0x43d, 0x44c, 0x438, 0x3b, 0x410,
0x445, 0x441, 0x44b, 0x43d, 0x43d, 0x44c, 0x44b, 0x3b, 0x422, 0x3b, 0x41e, 0x3b, 0x41a, 0x3b, 0x41c, 0x3b, 0x42b, 0x3b, 0x411, 0x3b,
0x41e, 0x3b, 0x410, 0x3b, 0x411, 0x3b, 0x410, 0x3b, 0x421, 0x3b, 0x410, 0x3b, 0x4d, 0x75, 0x70, 0x3b, 0x4d, 0x77, 0x69, 0x3b,
0x4d, 0x75, 0x73, 0x3b, 0x4d, 0x75, 0x6e, 0x3b, 0x4d, 0x75, 0x73, 0x3b, 0x4d, 0x75, 0x6a, 0x3b, 0x4d, 0x75, 0x73, 0x3b,
0x4d, 0x75, 0x70, 0x3b, 0x4d, 0x75, 0x6e, 0x3b, 0x4d, 0x6f, 0x6b, 0x3b, 0x4d, 0x75, 0x73, 0x3b, 0x4d, 0x75, 0x68, 0x3b,
0x4d, 0x75, 0x70, 0x61, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x77, 0x61, 0x3b, 0x4d, 0x77, 0x69, 0x74, 0x6f, 0x70, 0x65,
0x3b, 0x4d, 0x75, 0x73, 0x68, 0x65, 0x6e, 0x64, 0x65, 0x3b, 0x4d, 0x75, 0x6e, 0x79, 0x69, 0x3b, 0x4d, 0x75, 0x73, 0x68,
0x65, 0x6e, 0x64, 0x65, 0x20, 0x4d, 0x61, 0x67, 0x61, 0x6c, 0x69, 0x3b, 0x4d, 0x75, 0x6a, 0x69, 0x6d, 0x62, 0x69, 0x3b,
0x4d, 0x75, 0x73, 0x68, 0x69, 0x70, 0x65, 0x70, 0x6f, 0x3b, 0x4d, 0x75, 0x70, 0x75, 0x67, 0x75, 0x74, 0x6f, 0x3b, 0x4d,
0x75, 0x6e, 0x79, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x4d, 0x6f, 0x6b, 0x68, 0x75, 0x3b, 0x4d, 0x75, 0x73, 0x6f, 0x6e, 0x67,
0x61, 0x6e, 0x64, 0x65, 0x6d, 0x62, 0x77, 0x65, 0x3b, 0x4d, 0x75, 0x68, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x6d, 0x6b, 0x77,
0x3b, 0x6d, 0x70, 0x69, 0x3b, 0x6d, 0x74, 0x75, 0x3b, 0x6d, 0x69, 0x6e, 0x3b, 0x6d, 0x74, 0x6e, 0x3b, 0x6d, 0x73, 0x74,
0x3b, 0x6d, 0x73, 0x62, 0x3b, 0x6d, 0x75, 0x6e, 0x3b, 0x6d, 0x74, 0x73, 0x3b, 0x6d, 0x6b, 0x75, 0x3b, 0x6d, 0x6b, 0x6d,
0x3b, 0x6d, 0x6b, 0x62, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x6b, 0x77, 0x61, 0x6e, 0x6a, 0x61,
0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x70, 0x69, 0x6c, 0x69, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69,
0x20, 0x79, 0x61, 0x20, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x69, 0x6e,
0x65, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x6d, 0x77, 0x65, 0x7a,
0x69, 0x20, 0x79, 0x61, 0x20, 0x73, 0x69, 0x74, 0x61, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x73,
0x61, 0x62, 0x61, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x6d, 0x75, 0x6e, 0x61, 0x6e, 0x65, 0x3b,
0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x74, 0x69, 0x73, 0x61, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20,
0x79, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x6b, 0x75, 0x6d,
0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x79, 0x61, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x6b,
0x75, 0x6d, 0x69, 0x20, 0x79, 0x61, 0x20, 0x6d, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x6b, 0x3b, 0x70, 0x3b, 0x74, 0x3b, 0x69,
0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x74, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0xa5a8, 0xa56a, 0xa583,
0x20, 0xa51e, 0xa56e, 0x3b, 0xa552, 0xa561, 0xa59d, 0xa595, 0x3b, 0xa57e, 0xa5ba, 0x3b, 0xa5a2, 0xa595, 0x3b, 0xa591, 0xa571, 0x3b, 0x36, 0x3b,
0x37, 0x3b, 0xa5db, 0xa515, 0x3b, 0xa562, 0xa54c, 0x3b, 0xa56d, 0xa583, 0x3b, 0xa51e, 0xa60b, 0xa554, 0xa57f, 0x20, 0xa578, 0xa583, 0xa5cf, 0x3b,
0xa5a8, 0xa56a, 0xa571, 0x20, 0xa5cf, 0xa56e, 0x3b, 0x6c, 0x75, 0x75, 0x6b, 0x61, 0x6f, 0x20, 0x6b, 0x65, 0x6d, 0xe3, 0x3b, 0x253,
0x61, 0x6e, 0x64, 0x61, 0x253, 0x75, 0x3b, 0x76, 0x254, 0x254, 0x3b, 0x66, 0x75, 0x6c, 0x75, 0x3b, 0x67, 0x6f, 0x6f, 0x3b,
0x36, 0x3b, 0x37, 0x3b, 0x6b, 0x254, 0x6e, 0x64, 0x65, 0x3b, 0x73, 0x61, 0x61, 0x68, 0x3b, 0x67, 0x61, 0x6c, 0x6f, 0x3b,
0x6b, 0x65, 0x6e, 0x70, 0x6b, 0x61, 0x74, 0x6f, 0x20, 0x253, 0x6f, 0x6c, 0x6f, 0x6c, 0x254, 0x3b, 0x6c, 0x75, 0x75, 0x6b,
0x61, 0x6f, 0x20, 0x6c, 0x254, 0x6d, 0x61, 0x3b, 0x4a, 0x65, 0x6e, 0x3b, 0x48, 0x6f, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x3b,
0x41, 0x62, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x42, 0x72, 0xe1, 0x3b, 0x48, 0x65, 0x69, 0x3b, 0xd6, 0x69, 0x67, 0x3b,
0x48, 0x65, 0x72, 0x3b, 0x57, 0xed, 0x6d, 0x3b, 0x57, 0x69, 0x6e, 0x3b, 0x43, 0x68, 0x72, 0x3b, 0x4a, 0x65, 0x6e, 0x6e,
0x65, 0x72, 0x3b, 0x48, 0x6f, 0x72, 0x6e, 0x69, 0x67, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x65, 0x3b, 0x41, 0x62, 0x72, 0x69,
0x6c, 0x6c, 0x65, 0x3b, 0x4d, 0x65, 0x69, 0x6a, 0x65, 0x3b, 0x42, 0x72, 0xe1, 0x10d, 0x65, 0x74, 0x3b, 0x48, 0x65, 0x69,
0x77, 0x65, 0x74, 0x3b, 0xd6, 0x69, 0x67, 0x161, 0x74, 0x65, 0x3b, 0x48, 0x65, 0x72, 0x62, 0x161, 0x74, 0x6d, 0xe1, 0x6e,
0x65, 0x74, 0x3b, 0x57, 0xed, 0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b, 0x57, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0xe1, 0x6e,
0x65, 0x74, 0x3b, 0x43, 0x68, 0x72, 0x69, 0x161, 0x74, 0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b, 0x4a, 0x3b, 0x48, 0x3b, 0x4d,
0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x42, 0x3b, 0x48, 0x3b, 0xd6, 0x3b, 0x48, 0x3b, 0x57, 0x3b, 0x57, 0x3b, 0x43, 0x3b, 0x6f,
0x2e, 0x31, 0x3b, 0x6f, 0x2e, 0x32, 0x3b, 0x6f, 0x2e, 0x33, 0x3b, 0x6f, 0x2e, 0x34, 0x3b, 0x6f, 0x2e, 0x35, 0x3b, 0x6f,
0x2e, 0x36, 0x3b, 0x6f, 0x2e, 0x37, 0x3b, 0x6f, 0x2e, 0x38, 0x3b, 0x6f, 0x2e, 0x39, 0x3b, 0x6f, 0x2e, 0x31, 0x30, 0x3b,
0x6f, 0x2e, 0x31, 0x31, 0x3b, 0x6f, 0x2e, 0x31, 0x32, 0x3b, 0x70, 0x69, 0x6b, 0xed, 0x74, 0xed, 0x6b, 0xed, 0x74, 0x69,
0x65, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0xed, 0x20, 0xfa, 0x20, 0x6b, 0x75, 0x74, 0xfa, 0x61, 0x6e, 0x3b, 0x73, 0x69, 0x25b,
0x79, 0x25b, 0x301, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe1, 0x6e, 0x64, 0xed, 0x25b, 0x3b, 0x254,
0x6e, 0x73, 0xfa, 0x6d, 0x62, 0x254, 0x6c, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe1, 0x74, 0xe1,
0x74, 0xfa, 0x25b, 0x3b, 0x6d, 0x65, 0x73, 0x69, 0x14b, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe9,
0x6e, 0x69, 0x65, 0x3b, 0x65, 0x6e, 0x73, 0x69, 0x6c, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe1,
0x74, 0xe1, 0x6e, 0x75, 0x25b, 0x3b, 0x254, 0x73, 0x254, 0x6e, 0x3b, 0x65, 0x66, 0x75, 0x74, 0x65, 0x3b, 0x70, 0x69, 0x73,
0x75, 0x79, 0xfa, 0x3b, 0x69, 0x6d, 0x25b, 0x14b, 0x20, 0x69, 0x20, 0x70, 0x75, 0x254, 0x73, 0x3b, 0x69, 0x6d, 0x25b, 0x14b,
0x20, 0x69, 0x20, 0x70, 0x75, 0x74, 0xfa, 0x6b, 0x2c, 0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe1, 0x74, 0xed,
0x25b, 0x3b, 0x6d, 0x61, 0x6b, 0x61, 0x6e, 0x64, 0x69, 0x6b, 0x25b, 0x3b, 0x70, 0x69, 0x6c, 0x254, 0x6e, 0x64, 0x254, 0x301,
0x3b
};

static const ushort standalone_months_data[] = {
0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b,
0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x63, 0x74, 0x3b,
0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x79, 0x3b, 0x46, 0x65, 0x62, 0x72,
0x75, 0x61, 0x72, 0x79, 0x3b, 0x4d, 0x61, 0x72, 0x63, 0x68, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x79,
0x3b, 0x4a, 0x75, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6c, 0x79, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65,
0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x41, 0x6d,
0x61, 0x3b, 0x47, 0x75, 0x72, 0x3b, 0x42, 0x69, 0x74, 0x3b, 0x45, 0x6c, 0x62, 0x3b, 0x43, 0x61, 0x6d, 0x3b, 0x57, 0x61,
0x78, 0x3b, 0x41, 0x64, 0x6f, 0x3b, 0x48, 0x61, 0x67, 0x3b, 0x46, 0x75, 0x6c, 0x3b, 0x4f, 0x6e, 0x6b, 0x3b, 0x53, 0x61,
0x64, 0x3b, 0x4d, 0x75, 0x64, 0x3b, 0x41, 0x6d, 0x61, 0x6a, 0x6a, 0x69, 0x69, 0x3b, 0x47, 0x75, 0x72, 0x61, 0x61, 0x6e,
0x64, 0x68, 0x61, 0x6c, 0x61, 0x3b, 0x42, 0x69, 0x74, 0x6f, 0x6f, 0x74, 0x65, 0x65, 0x73, 0x73, 0x61, 0x3b, 0x45, 0x6c,
0x62, 0x61, 0x3b, 0x43, 0x61, 0x61, 0x6d, 0x73, 0x61, 0x3b, 0x57, 0x61, 0x78, 0x61, 0x62, 0x61, 0x6a, 0x6a, 0x69, 0x69,
0x3b, 0x41, 0x64, 0x6f, 0x6f, 0x6c, 0x65, 0x65, 0x73, 0x73, 0x61, 0x3b, 0x48, 0x61, 0x67, 0x61, 0x79, 0x79, 0x61, 0x3b,
0x46, 0x75, 0x75, 0x6c, 0x62, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6e, 0x6b, 0x6f, 0x6c, 0x6f, 0x6c, 0x65, 0x65, 0x73, 0x73,
0x61, 0x3b, 0x53, 0x61, 0x64, 0x61, 0x61, 0x73, 0x61, 0x3b, 0x4d, 0x75, 0x64, 0x64, 0x65, 0x65, 0x3b, 0x51, 0x75, 0x6e,
0x3b, 0x4e, 0x61, 0x68, 0x3b, 0x43, 0x69, 0x67, 0x3b, 0x41, 0x67, 0x64, 0x3b, 0x43, 0x61, 0x78, 0x3b, 0x51, 0x61, 0x73,
0x3b, 0x51, 0x61, 0x64, 0x3b, 0x4c, 0x65, 0x71, 0x3b, 0x57, 0x61, 0x79, 0x3b, 0x44, 0x69, 0x74, 0x3b, 0x58, 0x69, 0x6d,
0x3b, 0x4b, 0x61, 0x78, 0x3b, 0x51, 0x75, 0x6e, 0x78, 0x61, 0x20, 0x47, 0x61, 0x72, 0x61, 0x62, 0x6c, 0x75, 0x3b, 0x4b,
0x75, 0x64, 0x6f, 0x3b, 0x43, 0x69, 0x67, 0x67, 0x69, 0x6c, 0x74, 0x61, 0x20, 0x4b, 0x75, 0x64, 0x6f, 0x3b, 0x41, 0x67,
0x64, 0x61, 0x20, 0x42, 0x61, 0x78, 0x69, 0x73, 0x3b, 0x43, 0x61, 0x78, 0x61, 0x68, 0x20, 0x41, 0x6c, 0x73, 0x61, 0x3b,
0x51, 0x61, 0x73, 0x61, 0x20, 0x44, 0x69, 0x72, 0x72, 0x69, 0x3b, 0x51, 0x61, 0x64, 0x6f, 0x20, 0x44, 0x69, 0x72, 0x72,
0x69, 0x3b, 0x4c, 0x65, 0x71, 0x65, 0x65, 0x6e, 0x69, 0x3b, 0x57, 0x61, 0x79, 0x73, 0x75, 0x3b, 0x44, 0x69, 0x74, 0x65,
0x6c, 0x69, 0x3b, 0x58, 0x69, 0x6d, 0x6f, 0x6c, 0x69, 0x3b, 0x4b, 0x61, 0x78, 0x78, 0x61, 0x20, 0x47, 0x61, 0x72, 0x61,
0x62, 0x6c, 0x75, 0x3b, 0x51, 0x3b, 0x4e, 0x3b, 0x43, 0x3b, 0x41, 0x3b, 0x43, 0x3b, 0x51, 0x3b, 0x51, 0x3b, 0x4c, 0x3b,
0x57, 0x3b, 0x44, 0x3b, 0x58, 0x3b, 0x4b, 0x3b, 0x51, 0x75, 0x6e, 0x78, 0x61, 0x20, 0x47, 0x61, 0x72, 0x61, 0x62, 0x6c,
0x75, 0x3b, 0x4b, 0x75, 0x64, 0x6f, 0x3b, 0x43, 0x69, 0x67, 0x67, 0x69, 0x6c, 0x74, 0x61, 0x20, 0x4b, 0x75, 0x64, 0x6f,
0x3b, 0x41, 0x67, 0x64, 0x61, 0x20, 0x42, 0x61, 0x78, 0x69, 0x73, 0x3b, 0x43, 0x61, 0x78, 0x61, 0x68, 0x20, 0x41, 0x6c,
0x73, 0x61, 0x3b, 0x51, 0x61, 0x73, 0x61, 0x20, 0x44, 0x69, 0x72, 0x72, 0x69, 0x3b, 0x51, 0x61, 0x64, 0x6f, 0x20, 0x44,
0x69, 0x72, 0x72, 0x69, 0x3b, 0x4c, 0x69, 0x69, 0x71, 0x65, 0x6e, 0x3b, 0x57, 0x61, 0x79, 0x73, 0x75, 0x3b, 0x44, 0x69,
0x74, 0x65, 0x6c, 0x69, 0x3b, 0x58, 0x69, 0x6d, 0x6f, 0x6c, 0x69, 0x3b, 0x4b, 0x61, 0x78, 0x78, 0x61, 0x20, 0x47, 0x61,
0x72, 0x61, 0x62, 0x6c, 0x75, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70,
0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65,
0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72,
0x69, 0x65, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b, 0x4d, 0x61, 0x61, 0x72, 0x74, 0x3b, 0x41,
0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x65, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x65,
0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x73,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x53, 0x68, 0x6b, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x50, 0x72,
0x69, 0x3b, 0x4d, 0x61, 0x6a, 0x3b, 0x51, 0x65, 0x72, 0x3b, 0x4b, 0x6f, 0x72, 0x3b, 0x47, 0x73, 0x68, 0x3b, 0x53, 0x68,
0x74, 0x3b, 0x54, 0x65, 0x74, 0x3b, 0x4e, 0xeb, 0x6e, 0x3b, 0x44, 0x68, 0x6a, 0x3b, 0x6a, 0x61, 0x6e, 0x61, 0x72, 0x3b,
0x73, 0x68, 0x6b, 0x75, 0x72, 0x74, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x70, 0x72, 0x69, 0x6c, 0x6c, 0x3b, 0x6d, 0x61,
0x6a, 0x3b, 0x71, 0x65, 0x72, 0x73, 0x68, 0x6f, 0x72, 0x3b, 0x6b, 0x6f, 0x72, 0x72, 0x69, 0x6b, 0x3b, 0x67, 0x75, 0x73,
0x68, 0x74, 0x3b, 0x73, 0x68, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x3b, 0x74, 0x65, 0x74, 0x6f, 0x72, 0x3b, 0x6e, 0xeb, 0x6e,
0x74, 0x6f, 0x72, 0x3b, 0x64, 0x68, 0x6a, 0x65, 0x74, 0x6f, 0x72, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x50, 0x3b,
0x4d, 0x3b, 0x51, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x1303, 0x1295, 0x12e9, 0x3b,
0x134c, 0x1265, 0x1229, 0x3b, 0x121b, 0x122d, 0x127d, 0x3b, 0x12a4, 0x1355, 0x1228, 0x3b, 0x121c, 0x12ed, 0x3b, 0x1301, 0x1295, 0x3b, 0x1301, 0x120b,
0x12ed, 0x3b, 0x12a6, 0x1308, 0x1235, 0x3b, 0x1234, 0x1355, 0x1274, 0x3b, 0x12a6, 0x12ad, 0x1270, 0x3b, 0x1296, 0x126c, 0x121d, 0x3b, 0x12f2, 0x1234,
0x121d, 0x3b, 0x1303, 0x1295, 0x12e9, 0x12c8, 0x122a, 0x3b, 0x134c, 0x1265, 0x1229, 0x12c8, 0x122a, 0x3b, 0x121b, 0x122d, 0x127d, 0x3b, 0x12a4, 0x1355,
0x1228, 0x120d, 0x3b, 0x121c, 0x12ed, 0x3b, 0x1301, 0x1295, 0x3b, 0x1301, 0x120b, 0x12ed, 0x3b, 0x12a6, 0x1308, 0x1235, 0x1275, 0x3b, 0x1234, 0x1355,
0x1274, 0x121d, 0x1260, 0x122d, 0x3b, 0x12a6, 0x12ad, 0x1270, 0x12cd, 0x1260, 0x122d, 0x3b, 0x1296, 0x126c, 0x121d, 0x1260, 0x122d, 0x3b, 0x12f2, 0x1234,
0x121d, 0x1260, 0x122d, 0x3b, 0x1303, 0x3b, 0x134c, 0x3b, 0x121b, 0x3b, 0x12a4, 0x3b, 0x121c, 0x3b, 0x1301, 0x3b, 0x1301, 0x3b, 0x12a6, 0x3b,
0x1234, 0x3b, 0x12a6, 0x3b, 0x1296, 0x3b, 0x12f2, 0x3b, 0x64a, 0x646, 0x627, 0x64a, 0x631, 0x3b, 0x641, 0x628, 0x631, 0x627, 0x64a, 0x631,
0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x623, 0x628, 0x631, 0x64a, 0x644, 0x3b, 0x645, 0x627, 0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x646,
0x64a, 0x648, 0x3b, 0x64a, 0x648, 0x644, 0x64a, 0x648, 0x3b, 0x623, 0x63a, 0x633, 0x637, 0x633, 0x3b, 0x633, 0x628, 0x62a, 0x645, 0x628,
0x631, 0x3b, 0x623, 0x643, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x641, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x64a, 0x633, 0x645,
0x628, 0x631, 0x3b, 0x64a, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x623, 0x3b, 0x648, 0x3b, 0x646, 0x3b, 0x644, 0x3b, 0x63a, 0x3b, 0x633,
0x3b, 0x643, 0x3b, 0x628, 0x3b, 0x62f, 0x3b, 0x643, 0x627, 0x646, 0x648, 0x646, 0x20, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x64a, 0x3b,
0x634, 0x628, 0x627, 0x637, 0x3b, 0x622, 0x630, 0x627, 0x631, 0x3b, 0x646, 0x64a, 0x633, 0x627, 0x646, 0x3b, 0x623, 0x64a, 0x627, 0x631,
0x3b, 0x62d, 0x632, 0x64a, 0x631, 0x627, 0x646, 0x3b, 0x62a, 0x645, 0x648, 0x632, 0x3b, 0x622, 0x628, 0x3b, 0x623, 0x64a, 0x644, 0x648,
0x644, 0x3b, 0x62a, 0x634, 0x631, 0x64a, 0x646, 0x20, 0x627, 0x644, 0x623, 0x648, 0x644, 0x3b, 0x62a, 0x634, 0x631, 0x64a, 0x646, 0x20,
0x627, 0x644, 0x62b, 0x627, 0x646, 0x64a, 0x3b, 0x643, 0x627, 0x646, 0x648, 0x646, 0x20, 0x627, 0x644, 0x623, 0x648, 0x644, 0x3b, 0x540,
0x576, 0x57e, 0x3b, 0x553, 0x57f, 0x57e, 0x3b, 0x544, 0x580, 0x57f, 0x3b, 0x531, 0x57a, 0x580, 0x3b, 0x544, 0x575, 0x57d, 0x3b, 0x540,
0x576, 0x57d, 0x3b, 0x540, 0x56c, 0x57d, 0x3b, 0x555, 0x563, 0x57d, 0x3b, 0x54d, 0x565, 0x57a, 0x3b, 0x540, 0x578, 0x56f, 0x3b, 0x546,
0x578, 0x575, 0x3b, 0x534, 0x565, 0x56f, 0x3b, 0x540, 0x578, 0x582, 0x576, 0x57e, 0x561, 0x580, 0x3b, 0x553, 0x565, 0x57f, 0x580, 0x57e,
0x561, 0x580, 0x3b, 0x544, 0x561, 0x580, 0x57f, 0x3b, 0x531, 0x57a, 0x580, 0x56b, 0x56c, 0x3b, 0x544, 0x561, 0x575, 0x56b, 0x57d, 0x3b,
0x540, 0x578, 0x582, 0x576, 0x56b, 0x57d, 0x3b, 0x540, 0x578, 0x582, 0x56c, 0x56b, 0x57d, 0x3b, 0x555, 0x563, 0x578, 0x57d, 0x57f, 0x578,
0x57d, 0x3b, 0x54d, 0x565, 0x57a, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x540, 0x578, 0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565,
0x580, 0x3b, 0x546, 0x578, 0x575, 0x565, 0x574, 0x562, 0x565, 0x580, 0x3b, 0x534, 0x565, 0x56f, 0x57f, 0x565, 0x574, 0x562, 0x565, 0x580,
0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x31,
0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x9cd, 0x9f0, 0x9c1, 0x3b,
0x9ae, 0x9be, 0x9f0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9f0, 0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b,
0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x3b, 0x9b8, 0x9c7, 0x9aa, 0x9cd, 0x99f, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb,
0x3b, 0x9a8, 0x9ad, 0x9c7, 0x3b, 0x9a1, 0x9bf, 0x9b8, 0x9c7, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x9f1, 0x9be, 0x9f0, 0x9c0, 0x3b, 0x9ab,
0x9c7, 0x9ac, 0x9cd, 0x9f0, 0x9c1, 0x9f1, 0x9be, 0x9f0, 0x9c0, 0x3b, 0x9ae, 0x9be, 0x9f0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9f0,
0x9bf, 0x9b2, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x9b7, 0x9cd,
0x99f, 0x3b, 0x99b, 0x9c7, 0x9aa, 0x9cd, 0x9a4, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9f0, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x9ac, 0x9f0,
0x3b, 0x9a8, 0x9f1, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9f0, 0x3b, 0x9a1, 0x9bf, 0x99a, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9f0, 0x3b, 0x79, 0x61,
0x6e, 0x3b, 0x66, 0x65, 0x76, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x69, 0x79,
0x6e, 0x3b, 0x69, 0x79, 0x6c, 0x3b, 0x61, 0x76, 0x71, 0x3b, 0x73, 0x65, 0x6e, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f,
0x79, 0x3b, 0x64, 0x65, 0x6b, 0x3b, 0x59, 0x61, 0x6e, 0x76, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x76, 0x72, 0x61, 0x6c, 0x3b,
0x4d, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x130, 0x79, 0x75, 0x6e, 0x3b,
0x130, 0x79, 0x75, 0x6c, 0x3b, 0x41, 0x76, 0x71, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x6e, 0x74, 0x79, 0x61, 0x62, 0x72,
0x3b, 0x4f, 0x6b, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x4e, 0x6f, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x44, 0x65, 0x6b, 0x61,
0x62, 0x72, 0x3b, 0x458, 0x430, 0x43d, 0x432, 0x430, 0x440, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x3b, 0x43c, 0x430, 0x440,
0x442, 0x3b, 0x430, 0x43f, 0x440, 0x435, 0x43b, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x438, 0x458, 0x443, 0x43d, 0x3b, 0x438, 0x458, 0x443,
0x43b, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43d, 0x442, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x43e, 0x43a,
0x442, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x43d, 0x43e, 0x458, 0x430, 0x431, 0x440, 0x3b, 0x434, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x3b,
0x75, 0x72, 0x74, 0x3b, 0x6f, 0x74, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x69, 0x3b, 0x6d, 0x61, 0x69, 0x3b,
0x65, 0x6b, 0x61, 0x3b, 0x75, 0x7a, 0x74, 0x3b, 0x61, 0x62, 0x75, 0x3b, 0x69, 0x72, 0x61, 0x3b, 0x75, 0x72, 0x72, 0x3b,
0x61, 0x7a, 0x61, 0x3b, 0x61, 0x62, 0x65, 0x3b, 0x75, 0x72, 0x74, 0x61, 0x72, 0x72, 0x69, 0x6c, 0x61, 0x3b, 0x6f, 0x74,
0x73, 0x61, 0x69, 0x6c, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x78, 0x6f, 0x61, 0x3b, 0x61, 0x70, 0x69, 0x72, 0x69, 0x6c,
0x61, 0x3b, 0x6d, 0x61, 0x69, 0x61, 0x74, 0x7a, 0x61, 0x3b, 0x65, 0x6b, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x75, 0x7a, 0x74,
0x61, 0x69, 0x6c, 0x61, 0x3b, 0x61, 0x62, 0x75, 0x7a, 0x74, 0x75, 0x61, 0x3b, 0x69, 0x72, 0x61, 0x69, 0x6c, 0x61, 0x3b,
0x75, 0x72, 0x72, 0x69, 0x61, 0x3b, 0x61, 0x7a, 0x61, 0x72, 0x6f, 0x61, 0x3b, 0x61, 0x62, 0x65, 0x6e, 0x64, 0x75, 0x61,
0x3b, 0x55, 0x3b, 0x4f, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x55, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x55,
0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x99c, 0x9be, 0x9a8, 0x9c1, 0x9af, 0x9bc, 0x9be, 0x9b0, 0x9c0, 0x3b, 0x9ab, 0x9c7, 0x9ac, 0x9cd, 0x9b0,
0x9c1, 0x9af, 0x9bc, 0x9be, 0x9b0, 0x9c0, 0x3b, 0x9ae, 0x9be, 0x9b0, 0x9cd, 0x99a, 0x3b, 0x98f, 0x9aa, 0x9cd, 0x9b0, 0x9bf, 0x9b2, 0x3b,
0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x9b2, 0x9be, 0x987, 0x3b, 0x986, 0x997, 0x9b8, 0x9cd, 0x99f, 0x3b, 0x9b8,
0x9c7, 0x9aa, 0x9cd, 0x99f, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x985, 0x995, 0x9cd, 0x99f, 0x9cb, 0x9ac, 0x9b0, 0x3b, 0x9a8, 0x9ad,
0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x9a1, 0x9bf, 0x9b8, 0x9c7, 0x9ae, 0x9cd, 0x9ac, 0x9b0, 0x3b, 0x99c, 0x9be, 0x3b, 0x9ab, 0x9c7,
0x3b, 0x9ae, 0x9be, 0x3b, 0x98f, 0x3b, 0x9ae, 0x9c7, 0x3b, 0x99c, 0x9c1, 0x9a8, 0x3b, 0x99c, 0x9c1, 0x3b, 0x986, 0x3b, 0x9b8, 0x9c7,
0x3b, 0x985, 0x3b, 0x9a8, 0x3b, 0x9a1, 0x9bf, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf21, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf22, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0x20, 0xf23, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf24, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf25, 0x3b, 0xf5f, 0xfb3,
0xf0b, 0x20, 0xf26, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf27, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf28, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20,
0xf29, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf21, 0xf20, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20, 0xf21, 0xf21, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x20,
0xf21, 0xf22, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf51, 0xf44, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1,
0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f,
0xfb3, 0xf5d, 0xf0b, 0xf42, 0xf66, 0xf74, 0xf58, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b,
0xf56, 0xf5e, 0xf72, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf63, 0xf94, 0xf0b, 0xf54,
0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66,
0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf56, 0xf51, 0xf74, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72,
0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf56, 0xf62, 0xf92, 0xfb1, 0xf51, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f,
0xfb3, 0xf5d, 0xf0b, 0xf51, 0xf42, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf56,
0xf45, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42,
0xf45, 0xf72, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf5f, 0xfb3, 0xf5d, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b,
0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0x47, 0x65, 0x6e, 0x3b, 0x43, 0x2bc, 0x68, 0x77, 0x65, 0x3b, 0x4d, 0x65,
0x75, 0x72, 0x3b, 0x45, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x65, 0x3b, 0x4d, 0x65, 0x7a, 0x68, 0x3b, 0x47, 0x6f, 0x75, 0x65,
0x3b, 0x45, 0x6f, 0x73, 0x74, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x3b, 0x48, 0x65, 0x72, 0x65, 0x3b, 0x44, 0x75, 0x3b, 0x4b,
0x65, 0x72, 0x3b, 0x47, 0x65, 0x6e, 0x76, 0x65, 0x72, 0x3b, 0x43, 0x2bc, 0x68, 0x77, 0x65, 0x76, 0x72, 0x65, 0x72, 0x3b,
0x4d, 0x65, 0x75, 0x72, 0x7a, 0x68, 0x3b, 0x45, 0x62, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x61, 0x65, 0x3b, 0x4d, 0x65, 0x7a,
0x68, 0x65, 0x76, 0x65, 0x6e, 0x3b, 0x47, 0x6f, 0x75, 0x65, 0x72, 0x65, 0x3b, 0x45, 0x6f, 0x73, 0x74, 0x3b, 0x47, 0x77,
0x65, 0x6e, 0x67, 0x6f, 0x6c, 0x6f, 0x3b, 0x48, 0x65, 0x72, 0x65, 0x3b, 0x44, 0x75, 0x3b, 0x4b, 0x65, 0x72, 0x7a, 0x75,
0x3b, 0x44f, 0x43d, 0x2e, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x2e,
0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x44e, 0x43d, 0x438, 0x3b, 0x44e, 0x43b, 0x438, 0x3b, 0x430, 0x432, 0x433, 0x2e, 0x3b, 0x441, 0x435,
0x43f, 0x442, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x2e, 0x3b, 0x434, 0x435, 0x43a, 0x2e, 0x3b,
0x44f, 0x43d, 0x443, 0x430, 0x440, 0x438, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x443, 0x430, 0x440, 0x438, 0x3b, 0x43c, 0x430, 0x440, 0x442,
0x3b, 0x430, 0x43f, 0x440, 0x438, 0x43b, 0x3b, 0x43c, 0x430, 0x439, 0x3b, 0x44e, 0x43d, 0x438, 0x3b, 0x44e, 0x43b, 0x438, 0x3b, 0x430,
0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43e, 0x43a, 0x442, 0x43e,
0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x434, 0x435, 0x43a, 0x435, 0x43c, 0x432, 0x440,
0x438, 0x3b, 0x44f, 0x3b, 0x444, 0x3b, 0x43c, 0x3b, 0x430, 0x3b, 0x43c, 0x3b, 0x44e, 0x3b, 0x44e, 0x3b, 0x430, 0x3b, 0x441, 0x3b,
0x43e, 0x3b, 0x43d, 0x3b, 0x434, 0x3b, 0x1007, 0x1014, 0x103a, 0x3b, 0x1016, 0x1031, 0x3b, 0x1019, 0x1010, 0x103a, 0x3b, 0x1027, 0x3b, 0x1019,
0x1031, 0x3b, 0x1007, 0x103d, 0x1014, 0x103a, 0x3b, 0x1007, 0x1030, 0x3b, 0x1029, 0x3b, 0x1005, 0x1000, 0x103a, 0x3b, 0x1021, 0x1031, 0x102c, 0x1000,
0x103a, 0x3b, 0x1014, 0x102d, 0x102f, 0x3b, 0x1012, 0x102e, 0x3b, 0x1007, 0x1014, 0x103a, 0x1014, 0x101d, 0x102b, 0x101b, 0x102e, 0x3b, 0x1016, 0x1031,
0x1016, 0x1031, 0x102c, 0x103a, 0x101d, 0x102b, 0x101b, 0x102e, 0x3b, 0x1019, 0x1010, 0x103a, 0x3b, 0x1027, 0x1015, 0x103c, 0x102e, 0x3b, 0x1019, 0x1031,
0x3b, 0x1007, 0x103d, 0x1014, 0x103a, 0x3b, 0x1007, 0x1030, 0x101c, 0x102d, 0x102f, 0x1004, 0x103a, 0x3b, 0x1029, 0x1002, 0x102f, 0x1010, 0x103a, 0x3b,
0x1005, 0x1000, 0x103a, 0x1010, 0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1021, 0x1031, 0x102c, 0x1000, 0x103a, 0x1010, 0x102d, 0x102f, 0x1018, 0x102c, 0x3b,
0x1014, 0x102d, 0x102f, 0x101d, 0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1012, 0x102e, 0x1007, 0x1004, 0x103a, 0x1018, 0x102c, 0x3b, 0x1007, 0x3b, 0x1016,
0x3b, 0x1019, 0x3b, 0x1027, 0x3b, 0x1019, 0x3b, 0x1007, 0x3b, 0x1007, 0x3b, 0x1029, 0x3b, 0x1005, 0x3b, 0x1021, 0x3b, 0x1014, 0x3b, 0x1012,
0x3b, 0x441, 0x442, 0x443, 0x3b, 0x43b, 0x44e, 0x442, 0x3b, 0x441, 0x430, 0x43a, 0x3b, 0x43a, 0x440, 0x430, 0x3b, 0x442, 0x440, 0x430,
0x3b, 0x447, 0x44d, 0x440, 0x3b, 0x43b, 0x456, 0x43f, 0x3b, 0x436, 0x43d, 0x456, 0x3b, 0x432, 0x435, 0x440, 0x3b, 0x43a, 0x430, 0x441,
0x3b, 0x43b, 0x456, 0x441, 0x3b, 0x441, 0x43d, 0x435, 0x3b, 0x441, 0x442, 0x443, 0x434, 0x437, 0x435, 0x43d, 0x44c, 0x3b, 0x43b, 0x44e,
0x442, 0x44b, 0x3b, 0x441, 0x430, 0x43a, 0x430, 0x432, 0x456, 0x43a, 0x3b, 0x43a, 0x440, 0x430, 0x441, 0x430, 0x432, 0x456, 0x43a, 0x3b,
0x442, 0x440, 0x430, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x447, 0x44d, 0x440, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x43b, 0x456, 0x43f, 0x435,
0x43d, 0x44c, 0x3b, 0x436, 0x43d, 0x456, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x432, 0x435, 0x440, 0x430, 0x441, 0x435, 0x43d, 0x44c, 0x3b,
0x43a, 0x430, 0x441, 0x442, 0x440, 0x44b, 0x447, 0x43d, 0x456, 0x43a, 0x3b, 0x43b, 0x456, 0x441, 0x442, 0x430, 0x43f, 0x430, 0x434, 0x3b,
0x441, 0x43d, 0x435, 0x436, 0x430, 0x43d, 0x44c, 0x3b, 0x441, 0x3b, 0x43b, 0x3b, 0x441, 0x3b, 0x43a, 0x3b, 0x43c, 0x3b, 0x447, 0x3b,
0x43b, 0x3b, 0x436, 0x3b, 0x432, 0x3b, 0x43a, 0x3b, 0x43b, 0x3b, 0x441, 0x3b, 0x17e1, 0x3b, 0x17e2, 0x3b, 0x17e3, 0x3b, 0x17e4, 0x3b,
0x17e5, 0x3b, 0x17e6, 0x3b, 0x17e7, 0x3b, 0x17e8, 0x3b, 0x17e9, 0x3b, 0x17e1, 0x17e0, 0x3b, 0x17e1, 0x17e1, 0x3b, 0x17e1, 0x17e2, 0x3b, 0x1798,
0x1780, 0x179a, 0x17b6, 0x3b, 0x1780, 0x17bb, 0x1798, 0x17d2, 0x1797, 0x17c8, 0x3b, 0x1798, 0x17b7, 0x1793, 0x17b6, 0x3b, 0x1798, 0x17c1, 0x179f, 0x17b6,
0x3b, 0x17a7, 0x179f, 0x1797, 0x17b6, 0x3b, 0x1798, 0x17b7, 0x1790, 0x17bb, 0x1793, 0x17b6, 0x3b, 0x1780, 0x1780, 0x17d2, 0x1780, 0x178a, 0x17b6, 0x3b,
0x179f, 0x17b8, 0x17a0, 0x17b6, 0x3b, 0x1780, 0x1789, 0x17d2, 0x1789, 0x17b6, 0x3b, 0x178f, 0x17bb, 0x179b, 0x17b6, 0x3b, 0x179c, 0x17b7, 0x1785, 0x17d2,
0x1786, 0x17b7, 0x1780, 0x17b6, 0x3b, 0x1792, 0x17d2, 0x1793, 0x17bc, 0x3b, 0x67, 0x65, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x2e,
0x3b, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x61, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x67, 0x3b, 0x6a, 0x75, 0x6e, 0x79,
0x3b, 0x6a, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b,
0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x73, 0x2e, 0x3b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72,
0x65, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x67, 0x3b, 0x6a,
0x75, 0x6e, 0x79, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x6c, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74,
0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62,
0x72, 0x65, 0x3b, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x67, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x61, 0x3b,
0x6d, 0x3b, 0x6a, 0x3b, 0x6a, 0x3b, 0x61, 0x3b, 0x73, 0x3b, 0x6f, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x4e00, 0x6708, 0x3b, 0x4e8c,
0x6708, 0x3b, 0x4e09, 0x6708, 0x3b, 0x56db, 0x6708, 0x3b, 0x4e94, 0x6708, 0x3b, 0x516d, 0x6708, 0x3b, 0x4e03, 0x6708, 0x3b, 0x516b, 0x6708, 0x3b,
0x4e5d, 0x6708, 0x3b, 0x5341, 0x6708, 0x3b, 0x5341, 0x4e00, 0x6708, 0x3b, 0x5341, 0x4e8c, 0x6708, 0x3b, 0x31, 0x6708, 0x3b, 0x32, 0x6708, 0x3b,
0x33, 0x6708, 0x3b, 0x34, 0x6708, 0x3b, 0x35, 0x6708, 0x3b, 0x36, 0x6708, 0x3b, 0x37, 0x6708, 0x3b, 0x38, 0x6708, 0x3b, 0x39, 0x6708,
0x3b, 0x31, 0x30, 0x6708, 0x3b, 0x31, 0x31, 0x6708, 0x3b, 0x31, 0x32, 0x6708, 0x3b, 0x73, 0x69, 0x6a, 0x3b, 0x76, 0x65, 0x6c,
0x6a, 0x3b, 0x6f, 0x17e, 0x75, 0x3b, 0x74, 0x72, 0x61, 0x3b, 0x73, 0x76, 0x69, 0x3b, 0x6c, 0x69, 0x70, 0x3b, 0x73, 0x72,
0x70, 0x3b, 0x6b, 0x6f, 0x6c, 0x3b, 0x72, 0x75, 0x6a, 0x3b, 0x6c, 0x69, 0x73, 0x3b, 0x73, 0x74, 0x75, 0x3b, 0x70, 0x72,
0x6f, 0x3b, 0x73, 0x69, 0x6a, 0x65, 0x10d, 0x61, 0x6e, 0x6a, 0x3b, 0x76, 0x65, 0x6c, 0x6a, 0x61, 0x10d, 0x61, 0x3b, 0x6f,
0x17e, 0x75, 0x6a, 0x61, 0x6b, 0x3b, 0x74, 0x72, 0x61, 0x76, 0x61, 0x6e, 0x6a, 0x3b, 0x73, 0x76, 0x69, 0x62, 0x61, 0x6e,
0x6a, 0x3b, 0x6c, 0x69, 0x70, 0x61, 0x6e, 0x6a, 0x3b, 0x73, 0x72, 0x70, 0x61, 0x6e, 0x6a, 0x3b, 0x6b, 0x6f, 0x6c, 0x6f,
0x76, 0x6f, 0x7a, 0x3b, 0x72, 0x75, 0x6a, 0x61, 0x6e, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x3b, 0x73,
0x74, 0x75, 0x64, 0x65, 0x6e, 0x69, 0x3b, 0x70, 0x72, 0x6f, 0x73, 0x69, 0x6e, 0x61, 0x63, 0x3b, 0x31, 0x2e, 0x3b, 0x32,
0x2e, 0x3b, 0x33, 0x2e, 0x3b, 0x34, 0x2e, 0x3b, 0x35, 0x2e, 0x3b, 0x36, 0x2e, 0x3b, 0x37, 0x2e, 0x3b, 0x38, 0x2e, 0x3b,
0x39, 0x2e, 0x3b, 0x31, 0x30, 0x2e, 0x3b, 0x31, 0x31, 0x2e, 0x3b, 0x31, 0x32, 0x2e, 0x3b, 0x6c, 0x65, 0x64, 0x65, 0x6e,
0x3b, 0xfa, 0x6e, 0x6f, 0x72, 0x3b, 0x62, 0x159, 0x65, 0x7a, 0x65, 0x6e, 0x3b, 0x64, 0x75, 0x62, 0x65, 0x6e, 0x3b, 0x6b,
0x76, 0x11b, 0x74, 0x65, 0x6e, 0x3b, 0x10d, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x3b, 0x10d, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x65,
0x63, 0x3b, 0x73, 0x72, 0x70, 0x65, 0x6e, 0x3b, 0x7a, 0xe1, 0x159, 0xed, 0x3b, 0x159, 0xed, 0x6a, 0x65, 0x6e, 0x3b, 0x6c,
0x69, 0x73, 0x74, 0x6f, 0x70, 0x61, 0x64, 0x3b, 0x70, 0x72, 0x6f, 0x73, 0x69, 0x6e, 0x65, 0x63, 0x3b, 0x6c, 0x3b, 0xfa,
0x3b, 0x62, 0x3b, 0x64, 0x3b, 0x6b, 0x3b, 0x10d, 0x3b, 0x10d, 0x3b, 0x73, 0x3b, 0x7a, 0x3b, 0x159, 0x3b, 0x6c, 0x3b, 0x70,
0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x6a,
0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74,
0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72,
0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b,
0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70,
0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62,
0x3b, 0x6d, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x65, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c,
0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63,
0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x6d, 0x61,
0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x65, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a,
0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x75, 0x73, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc30, 0xd801, 0xdc4c, 0x3b, 0xd801, 0xdc19, 0xd801, 0xdc2f,
0xd801, 0xdc3a, 0x3b, 0xd801, 0xdc23, 0xd801, 0xdc2a, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc01, 0xd801, 0xdc39, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc23, 0xd801,
0xdc29, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc2d, 0xd801, 0xdc4c, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc2d, 0xd801, 0xdc4a, 0x3b, 0xd801, 0xdc02, 0xd801, 0xdc40,
0x3b, 0xd801, 0xdc1d, 0xd801, 0xdc2f, 0xd801, 0xdc39, 0x3b, 0xd801, 0xdc09, 0xd801, 0xdc3f, 0xd801, 0xdc3b, 0x3b, 0xd801, 0xdc24, 0xd801, 0xdc2c, 0xd801,
0xdc42, 0x3b, 0xd801, 0xdc14, 0xd801, 0xdc28, 0xd801, 0xdc45, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc30, 0xd801, 0xdc4c, 0xd801, 0xdc37, 0xd801, 0xdc2d, 0xd801,
0xdc2f, 0xd801, 0xdc49, 0xd801, 0xdc28, 0x3b, 0xd801, 0xdc19, 0xd801, 0xdc2f, 0xd801, 0xdc3a, 0xd801, 0xdc49, 0xd801, 0xdc2d, 0xd801, 0xdc2f, 0xd801, 0xdc49,
0xd801, 0xdc28, 0x3b, 0xd801, 0xdc23, 0xd801, 0xdc2a, 0xd801, 0xdc49, 0xd801, 0xdc3d, 0x3b, 0xd801, 0xdc01, 0xd801, 0xdc39, 0xd801, 0xdc49, 0xd801, 0xdc2e,
0xd801, 0xdc4a, 0x3b, 0xd801, 0xdc23, 0xd801, 0xdc29, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc2d, 0xd801, 0xdc4c, 0x3b, 0xd801, 0xdc16, 0xd801, 0xdc2d, 0xd801,
0xdc4a, 0xd801, 0xdc34, 0x3b, 0xd801, 0xdc02, 0xd801, 0xdc40, 0xd801, 0xdc32, 0xd801, 0xdc45, 0xd801, 0xdc3b, 0x3b, 0xd801, 0xdc1d, 0xd801, 0xdc2f, 0xd801,
0xdc39, 0xd801, 0xdc3b, 0xd801, 0xdc2f, 0xd801, 0xdc4b, 0xd801, 0xdc3a, 0xd801, 0xdc32, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc09, 0xd801, 0xdc3f, 0xd801, 0xdc3b,
0xd801, 0xdc2c, 0xd801, 0xdc3a, 0xd801, 0xdc32, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc24, 0xd801, 0xdc2c, 0xd801, 0xdc42, 0xd801, 0xdc2f, 0xd801, 0xdc4b, 0xd801,
0xdc3a, 0xd801, 0xdc32, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc14, 0xd801, 0xdc28, 0xd801, 0xdc45, 0xd801, 0xdc2f, 0xd801, 0xdc4b, 0xd801, 0xdc3a, 0xd801, 0xdc32,
0xd801, 0xdc49, 0x3b, 0xd801, 0xdc16, 0x3b, 0xd801, 0xdc19, 0x3b, 0xd801, 0xdc23, 0x3b, 0xd801, 0xdc01, 0x3b, 0xd801, 0xdc23, 0x3b, 0xd801, 0xdc16,
0x3b, 0xd801, 0xdc16, 0x3b, 0xd801, 0xdc02, 0x3b, 0xd801, 0xdc1d, 0x3b, 0xd801, 0xdc09, 0x3b, 0xd801, 0xdc24, 0x3b, 0xd801, 0xdc14, 0x3b, 0x6a,
0x61, 0x61, 0x6e, 0x3b, 0x76, 0x65, 0x65, 0x62, 0x72, 0x3b, 0x6d, 0xe4, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x3b,
0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x3b,
0x73, 0x65, 0x70, 0x74, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x74, 0x73, 0x3b, 0x6a, 0x61,
0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x76, 0x65, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0xe4, 0x72, 0x74, 0x73,
0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75,
0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64,
0x65, 0x74, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x56, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a,
0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62,
0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c,
0x3b, 0x61, 0x75, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x73,
0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73,
0x3b, 0x61, 0x70, 0x72, 0xed, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69,
0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b,
0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x73, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x74, 0x61, 0x6d, 0x6d, 0x69, 0x3b, 0x68, 0x65, 0x6c, 0x6d, 0x69, 0x3b, 0x6d, 0x61, 0x61, 0x6c,
0x69, 0x73, 0x3b, 0x68, 0x75, 0x68, 0x74, 0x69, 0x3b, 0x74, 0x6f, 0x75, 0x6b, 0x6f, 0x3b, 0x6b, 0x65, 0x73, 0xe4, 0x3b,
0x68, 0x65, 0x69, 0x6e, 0xe4, 0x3b, 0x65, 0x6c, 0x6f, 0x3b, 0x73, 0x79, 0x79, 0x73, 0x3b, 0x6c, 0x6f, 0x6b, 0x61, 0x3b,
0x6d, 0x61, 0x72, 0x72, 0x61, 0x73, 0x3b, 0x6a, 0x6f, 0x75, 0x6c, 0x75, 0x3b, 0x74, 0x61, 0x6d, 0x6d, 0x69, 0x6b, 0x75,
0x75, 0x3b, 0x68, 0x65, 0x6c, 0x6d, 0x69, 0x6b, 0x75, 0x75, 0x3b, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x73, 0x6b, 0x75, 0x75,
0x3b, 0x68, 0x75, 0x68, 0x74, 0x69, 0x6b, 0x75, 0x75, 0x3b, 0x74, 0x6f, 0x75, 0x6b, 0x6f, 0x6b, 0x75, 0x75, 0x3b, 0x6b,
0x65, 0x73, 0xe4, 0x6b, 0x75, 0x75, 0x3b, 0x68, 0x65, 0x69, 0x6e, 0xe4, 0x6b, 0x75, 0x75, 0x3b, 0x65, 0x6c, 0x6f, 0x6b,
0x75, 0x75, 0x3b, 0x73, 0x79, 0x79, 0x73, 0x6b, 0x75, 0x75, 0x3b, 0x6c, 0x6f, 0x6b, 0x61, 0x6b, 0x75, 0x75, 0x3b, 0x6d,
0x61, 0x72, 0x72, 0x61, 0x73, 0x6b, 0x75, 0x75, 0x3b, 0x6a, 0x6f, 0x75, 0x6c, 0x75, 0x6b, 0x75, 0x75, 0x3b, 0x54, 0x3b,
0x48, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x48, 0x3b, 0x45, 0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b,
0x4a, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x2e, 0x3b, 0x66, 0xe9, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61,
0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x69, 0x6e, 0x3b, 0x6a, 0x75, 0x69, 0x6c, 0x2e, 0x3b, 0x61,
0x6f, 0xfb, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b,
0x64, 0xe9, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x69, 0x65, 0x72, 0x3b, 0x66, 0xe9, 0x76, 0x72, 0x69, 0x65, 0x72,
0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x69, 0x6e,
0x3b, 0x6a, 0x75, 0x69, 0x6c, 0x6c, 0x65, 0x74, 0x3b, 0x61, 0x6f, 0xfb, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d,
0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65,
0x3b, 0x64, 0xe9, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x58, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61,
0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x58, 0x75, 0xf1, 0x3b, 0x58, 0x75, 0x6c, 0x3b, 0x41, 0x67,
0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x75, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x58, 0x61,
0x6e, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x7a, 0x6f,
0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x6f, 0x3b, 0x58, 0x75, 0xf1, 0x6f, 0x3b, 0x58, 0x75, 0x6c,
0x6c, 0x6f, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x4f,
0x75, 0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x44, 0x65, 0x63, 0x65,
0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x58, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x58, 0x3b, 0x58, 0x3b, 0x41,
0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x10d8, 0x10d0, 0x10dc, 0x3b, 0x10d7, 0x10d4, 0x10d1, 0x3b, 0x10db, 0x10d0, 0x10e0,
0x3b, 0x10d0, 0x10de, 0x10e0, 0x3b, 0x10db, 0x10d0, 0x10d8, 0x3b, 0x10d8, 0x10d5, 0x10dc, 0x3b, 0x10d8, 0x10d5, 0x10da, 0x3b, 0x10d0, 0x10d2, 0x10d5,
0x3b, 0x10e1, 0x10d4, 0x10e5, 0x3b, 0x10dd, 0x10e5, 0x10e2, 0x3b, 0x10dc, 0x10dd, 0x10d4, 0x3b, 0x10d3, 0x10d4, 0x10d9, 0x3b, 0x10d8, 0x10d0, 0x10dc,
0x10d5, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x10d7, 0x10d4, 0x10d1, 0x10d4, 0x10e0, 0x10d5, 0x10d0, 0x10da, 0x10d8, 0x3b, 0x10db, 0x10d0, 0x10e0, 0x10e2, 0x10d8,
0x3b, 0x10d0, 0x10de, 0x10e0, 0x10d8, 0x10da, 0x10d8, 0x3b, 0x10db, 0x10d0, 0x10d8, 0x10e1, 0x10d8, 0x3b, 0x10d8, 0x10d5, 0x10dc, 0x10d8, 0x10e1, 0x10d8,
0x3b, 0x10d8, 0x10d5, 0x10da, 0x10d8, 0x10e1, 0x3b, 0x10d0, 0x10d2, 0x10d5, 0x10d8, 0x10e1, 0x10e2, 0x10dd, 0x3b, 0x10e1, 0x10d4, 0x10e5, 0x10e2, 0x10d4,
0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10dd, 0x10e5, 0x10e2, 0x10dd, 0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10dc, 0x10dd, 0x10d4, 0x10db,
0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10d3, 0x10d4, 0x10d9, 0x10d4, 0x10db, 0x10d1, 0x10d4, 0x10e0, 0x10d8, 0x3b, 0x10d8, 0x3b, 0x10d7, 0x3b, 0x10db,
0x3b, 0x10d0, 0x3b, 0x10db, 0x3b, 0x10d8, 0x3b, 0x10d8, 0x3b, 0x10d0, 0x3b, 0x10e1, 0x3b, 0x10dd, 0x3b, 0x10dc, 0x3b, 0x10d3, 0x3b, 0x4a,
0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0xe4, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a,
0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e,
0x6f, 0x76, 0x3b, 0x44, 0x65, 0x7a, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61,
0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e,
0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d,
0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0xe4, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0xe4,
0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75,
0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x7a, 0x3b, 0x4a, 0xe4,
0x6e, 0x6e, 0x65, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b, 0x41, 0x70,
0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x75,
0x67, 0x75, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62,
0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x399, 0x3b1, 0x3bd, 0x3b, 0x3a6, 0x3b5, 0x3b2, 0x3b, 0x39c, 0x3ac, 0x3c1, 0x3b, 0x391, 0x3c0, 0x3c1, 0x3b, 0x39c, 0x3ac, 0x3b9,
0x3b, 0x399, 0x3bf, 0x3cd, 0x3bd, 0x3b, 0x399, 0x3bf, 0x3cd, 0x3bb, 0x3b, 0x391, 0x3c5, 0x3b3, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3b, 0x39f,
0x3ba, 0x3c4, 0x3b, 0x39d, 0x3bf, 0x3ad, 0x3b, 0x394, 0x3b5, 0x3ba, 0x3b, 0x399, 0x3b1, 0x3bd, 0x3bf, 0x3c5, 0x3ac, 0x3c1, 0x3b9, 0x3bf,
0x3c2, 0x3b, 0x3a6, 0x3b5, 0x3b2, 0x3c1, 0x3bf, 0x3c5, 0x3ac, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x39c, 0x3ac, 0x3c1, 0x3c4, 0x3b9, 0x3bf,
0x3c2, 0x3b, 0x391, 0x3c0, 0x3c1, 0x3af, 0x3bb, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x39c, 0x3ac, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x399, 0x3bf, 0x3cd,
0x3bd, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x399, 0x3bf, 0x3cd, 0x3bb, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x391, 0x3cd, 0x3b3, 0x3bf, 0x3c5, 0x3c3, 0x3c4,
0x3bf, 0x3c2, 0x3b, 0x3a3, 0x3b5, 0x3c0, 0x3c4, 0x3ad, 0x3bc, 0x3b2, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x39f, 0x3ba, 0x3c4, 0x3ce, 0x3b2,
0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x39d, 0x3bf, 0x3ad, 0x3bc, 0x3b2, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x394, 0x3b5, 0x3ba, 0x3ad, 0x3bc,
0x3b2, 0x3c1, 0x3b9, 0x3bf, 0x3c2, 0x3b, 0x399, 0x3b, 0x3a6, 0x3b, 0x39c, 0x3b, 0x391, 0x3b, 0x39c, 0x3b, 0x399, 0x3b, 0x399, 0x3b,
0x391, 0x3b, 0x3a3, 0x3b, 0x39f, 0x3b, 0x39d, 0x3b, 0x394, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x66, 0x65,
0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x69, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x69,
0x3b, 0x6d, 0x61, 0x6a, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75,
0x73, 0x74, 0x75, 0x73, 0x69, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x69, 0x3b, 0x6f, 0x6b, 0x74,
0x6f, 0x62, 0x65, 0x72, 0x69, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x69, 0x3b, 0x64, 0x65, 0x63, 0x65,
0x6d, 0x62, 0x65, 0x72, 0x69, 0x3b, 0xa9c, 0xabe, 0xaa8, 0xacd, 0xaaf, 0xac1, 0x3b, 0xaab, 0xac7, 0xaac, 0xacd, 0xab0, 0xac1, 0x3b,
0xaae, 0xabe, 0xab0, 0xacd, 0xa9a, 0x3b, 0xa8f, 0xaaa, 0xacd, 0xab0, 0xabf, 0xab2, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2, 0xaa8, 0x3b,
0xa9c, 0xac1, 0xab2, 0xabe, 0xa88, 0x3b, 0xa91, 0xa97, 0xab8, 0xacd, 0xa9f, 0x3b, 0xab8, 0xaaa, 0xacd, 0xa9f, 0xac7, 0x3b, 0xa91, 0xa95,
0xacd, 0xa9f, 0xacb, 0x3b, 0xaa8, 0xab5, 0xac7, 0x3b, 0xaa1, 0xabf, 0xab8, 0xac7, 0x3b, 0xa9c, 0xabe, 0xaa8, 0xacd, 0xaaf, 0xac1, 0xa86,
0xab0, 0xac0, 0x3b, 0xaab, 0xac7, 0xaac, 0xacd, 0xab0, 0xac1, 0xa86, 0xab0, 0xac0, 0x3b, 0xaae, 0xabe, 0xab0, 0xacd, 0xa9a, 0x3b, 0xa8f,
0xaaa, 0xacd, 0xab0, 0xabf, 0xab2, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2, 0xaa8, 0x3b, 0xa9c, 0xac1, 0xab2, 0xabe, 0xa88, 0x3b, 0xa91,
0xa97, 0xab8, 0xacd, 0xa9f, 0x3b, 0xab8, 0xaaa, 0xacd, 0xa9f, 0xac7, 0xaae, 0xacd, 0xaac, 0xab0, 0x3b, 0xa91, 0xa95, 0xacd, 0xa9f, 0xacd,
0xaac, 0xab0, 0x3b, 0xaa8, 0xab5, 0xac7, 0xaae, 0xacd, 0xaac, 0xab0, 0x3b, 0xaa1, 0xabf, 0xab8, 0xac7, 0xaae, 0xacd, 0xaac, 0xab0, 0x3b,
0xa9c, 0xabe, 0x3b, 0xaab, 0xac7, 0x3b, 0xaae, 0xabe, 0x3b, 0xa8f, 0x3b, 0xaae, 0xac7, 0x3b, 0xa9c, 0xac2, 0x3b, 0xa9c, 0xac1, 0x3b,
0xa91, 0x3b, 0xab8, 0x3b, 0xa91, 0x3b, 0xaa8, 0x3b, 0xaa1, 0xabf, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x61, 0x62, 0x3b, 0x4d,
0x61, 0x72, 0x3b, 0x41, 0x66, 0x69, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59, 0x75, 0x6c, 0x3b, 0x41,
0x67, 0x75, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x75, 0x77, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a,
0x61, 0x6e, 0x61, 0x69, 0x72, 0x75, 0x3b, 0x46, 0x61, 0x62, 0x75, 0x72, 0x61, 0x69, 0x72, 0x75, 0x3b, 0x4d, 0x61, 0x72,
0x69, 0x73, 0x3b, 0x41, 0x66, 0x69, 0x72, 0x69, 0x6c, 0x75, 0x3b, 0x4d, 0x61, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6e, 0x69,
0x3b, 0x59, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x74, 0x75, 0x6d, 0x62, 0x61,
0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x75, 0x77, 0x61, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x61,
0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x41, 0x3b,
0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x5d9, 0x5e0, 0x5d5, 0x5f3, 0x3b, 0x5e4, 0x5d1, 0x5e8, 0x5f3, 0x3b, 0x5de, 0x5e8,
0x5e5, 0x3b, 0x5d0, 0x5e4, 0x5e8, 0x5f3, 0x3b, 0x5de, 0x5d0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5e0, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dc, 0x5f3,
0x3b, 0x5d0, 0x5d5, 0x5d2, 0x5f3, 0x3b, 0x5e1, 0x5e4, 0x5d8, 0x5f3, 0x3b, 0x5d0, 0x5d5, 0x5e7, 0x5f3, 0x3b, 0x5e0, 0x5d5, 0x5d1, 0x5f3,
0x3b, 0x5d3, 0x5e6, 0x5de, 0x5f3, 0x3b, 0x5d9, 0x5e0, 0x5d5, 0x5d0, 0x5e8, 0x3b, 0x5e4, 0x5d1, 0x5e8, 0x5d5, 0x5d0, 0x5e8, 0x3b, 0x5de,
0x5e8, 0x5e5, 0x3b, 0x5d0, 0x5e4, 0x5e8, 0x5d9, 0x5dc, 0x3b, 0x5de, 0x5d0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5e0, 0x5d9, 0x3b, 0x5d9, 0x5d5,
0x5dc, 0x5d9, 0x3b, 0x5d0, 0x5d5, 0x5d2, 0x5d5, 0x5e1, 0x5d8, 0x3b, 0x5e1, 0x5e4, 0x5d8, 0x5de, 0x5d1, 0x5e8, 0x3b, 0x5d0, 0x5d5, 0x5e7,
0x5d8, 0x5d5, 0x5d1, 0x5e8, 0x3b, 0x5e0, 0x5d5, 0x5d1, 0x5de, 0x5d1, 0x5e8, 0x3b, 0x5d3, 0x5e6, 0x5de, 0x5d1, 0x5e8, 0x3b, 0x91c, 0x928,
0x935, 0x930, 0x940, 0x3b, 0x92b, 0x930, 0x935, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930,
0x948, 0x932, 0x3b, 0x92e, 0x908, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938, 0x94d,
0x924, 0x3b, 0x938, 0x93f, 0x924, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x924, 0x942, 0x92c, 0x930, 0x3b, 0x928, 0x935,
0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x926, 0x93f, 0x938, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x91c, 0x3b, 0x92b, 0x93c, 0x3b, 0x92e, 0x93e,
0x3b, 0x905, 0x3b, 0x92e, 0x3b, 0x91c, 0x942, 0x3b, 0x91c, 0x941, 0x3b, 0x905, 0x3b, 0x938, 0x93f, 0x3b, 0x905, 0x3b, 0x928, 0x3b,
0x926, 0x93f, 0x3b, 0x6a, 0x61, 0x6e, 0x2e, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0xe1, 0x72, 0x63, 0x2e, 0x3b,
0xe1, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0xe1, 0x6a, 0x2e, 0x3b, 0x6a, 0xfa, 0x6e, 0x2e, 0x3b, 0x6a, 0xfa, 0x6c, 0x2e, 0x3b,
0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x7a, 0x65, 0x70, 0x74, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76,
0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0xe1, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0xe1,
0x72, 0x3b, 0x6d, 0xe1, 0x72, 0x63, 0x69, 0x75, 0x73, 0x3b, 0xe1, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x73, 0x3b, 0x6d, 0xe1,
0x6a, 0x75, 0x73, 0x3b, 0x6a, 0xfa, 0x6e, 0x69, 0x75, 0x73, 0x3b, 0x6a, 0xfa, 0x6c, 0x69, 0x75, 0x73, 0x3b, 0x61, 0x75,
0x67, 0x75, 0x73, 0x7a, 0x74, 0x75, 0x73, 0x3b, 0x73, 0x7a, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f,
0x6b, 0x74, 0xf3, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65,
0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0xc1, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41,
0x3b, 0x53, 0x7a, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61,
0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0xed, 0x3b, 0x6a, 0xfa, 0x6e, 0x3b, 0x6a, 0xfa, 0x6c, 0x3b, 0xe1, 0x67,
0xfa, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0xf3, 0x76, 0x3b, 0x64, 0x65, 0x73, 0x3b, 0x6a, 0x61,
0x6e, 0xfa, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0xfa, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70,
0x72, 0xed, 0x6c, 0x3b, 0x6d, 0x61, 0xed, 0x3b, 0x6a, 0xfa, 0x6e, 0xed, 0x3b, 0x6a, 0xfa, 0x6c, 0xed, 0x3b, 0xe1, 0x67,
0xfa, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0xf3, 0x62, 0x65,
0x72, 0x3b, 0x6e, 0xf3, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x6a, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x6a, 0x3b, 0xe1, 0x3b, 0x73, 0x3b, 0x6f, 0x3b,
0x6e, 0x3b, 0x64, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b,
0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x3b,
0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b,
0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x72, 0x65, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c,
0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b, 0x41, 0x67, 0x75, 0x73, 0x74,
0x75, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72,
0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x31,
0x3b, 0x46, 0x65, 0x61, 0x62, 0x68, 0x72, 0x61, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38,
0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0x67, 0x65, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b,
0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x67, 0x3b, 0x67, 0x69, 0x75, 0x3b, 0x6c, 0x75, 0x67, 0x3b,
0x61, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x3b, 0x6f, 0x74, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x69, 0x63, 0x3b,
0x47, 0x65, 0x6e, 0x6e, 0x61, 0x69, 0x6f, 0x3b, 0x46, 0x65, 0x62, 0x62, 0x72, 0x61, 0x69, 0x6f, 0x3b, 0x4d, 0x61, 0x72,
0x7a, 0x6f, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x65, 0x3b, 0x4d, 0x61, 0x67, 0x67, 0x69, 0x6f, 0x3b, 0x47, 0x69, 0x75,
0x67, 0x6e, 0x6f, 0x3b, 0x4c, 0x75, 0x67, 0x6c, 0x69, 0x6f, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65,
0x74, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x4f, 0x74, 0x74, 0x6f, 0x62, 0x72, 0x65, 0x3b, 0x4e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x72, 0x65, 0x3b, 0x44, 0x69, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x47, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0xc9c, 0xca8,
0xcb5, 0xcb0, 0xcc0, 0x3b, 0xcab, 0xcc6, 0xcac, 0xccd, 0xcb0, 0xcb5, 0xcb0, 0xcc0, 0x3b, 0xcae, 0xcbe, 0xcb0, 0xccd, 0xc9a, 0xccd, 0x3b,
0xc8e, 0xcaa, 0xccd, 0xcb0, 0xcbf, 0xcb2, 0xccd, 0x3b, 0xcae, 0xcc6, 0x3b, 0xc9c, 0xcc2, 0xca8, 0xccd, 0x3b, 0xc9c, 0xcc1, 0xcb2, 0xcc8,
0x3b, 0xc86, 0xc97, 0xcb8, 0xccd, 0xc9f, 0xccd, 0x3b, 0xcb8, 0xcaa, 0xccd, 0xc9f, 0xcc6, 0xc82, 0xcac, 0xcb0, 0xccd, 0x3b, 0xc85, 0xc95,
0xccd, 0xc9f, 0xccb, 0xcac, 0xcb0, 0xccd, 0x3b, 0xca8, 0xcb5, 0xcc6, 0xc82, 0xcac, 0xcb0, 0xccd, 0x3b, 0xca1, 0xcbf, 0xcb8, 0xcc6, 0xc82,
0xcac, 0xcb0, 0xccd, 0x3b, 0xc9c, 0x3b, 0xcab, 0xcc6, 0x3b, 0xcae, 0xcbe, 0x3b, 0xc8e, 0x3b, 0xcae, 0xcc7, 0x3b, 0xc9c, 0xcc2, 0x3b,
0xc9c, 0xcc1, 0x3b, 0xc86, 0x3b, 0xcb8, 0xcc6, 0x3b, 0xc85, 0x3b, 0xca8, 0x3b, 0xca1, 0xcbf, 0x3b, 0x49b, 0x430, 0x4a3, 0x2e, 0x3b,
0x430, 0x49b, 0x43f, 0x2e, 0x3b, 0x43d, 0x430, 0x443, 0x2e, 0x3b, 0x441, 0x4d9, 0x443, 0x2e, 0x3b, 0x43c, 0x430, 0x43c, 0x2e, 0x3b,
0x43c, 0x430, 0x443, 0x2e, 0x3b, 0x448, 0x456, 0x43b, 0x2e, 0x3b, 0x442, 0x430, 0x43c, 0x2e, 0x3b, 0x49b, 0x44b, 0x440, 0x2e, 0x3b,
0x49b, 0x430, 0x437, 0x2e, 0x3b, 0x49b, 0x430, 0x440, 0x2e, 0x3b, 0x436, 0x435, 0x43b, 0x442, 0x2e, 0x3b, 0x49b, 0x430, 0x4a3, 0x442,
0x430, 0x440, 0x3b, 0x410, 0x49b, 0x43f, 0x430, 0x43d, 0x3b, 0x43d, 0x430, 0x443, 0x440, 0x44b, 0x437, 0x3b, 0x441, 0x4d9, 0x443, 0x456,
0x440, 0x3b, 0x43c, 0x430, 0x43c, 0x44b, 0x440, 0x3b, 0x43c, 0x430, 0x443, 0x441, 0x44b, 0x43c, 0x3b, 0x448, 0x456, 0x43b, 0x434, 0x435,
0x3b, 0x442, 0x430, 0x43c, 0x44b, 0x437, 0x3b, 0x49b, 0x44b, 0x440, 0x43a, 0x4af, 0x439, 0x435, 0x43a, 0x3b, 0x49b, 0x430, 0x437, 0x430,
0x43d, 0x3b, 0x49b, 0x430, 0x440, 0x430, 0x448, 0x430, 0x3b, 0x436, 0x435, 0x43b, 0x442, 0x43e, 0x49b, 0x441, 0x430, 0x43d, 0x3b, 0x6d,
0x75, 0x74, 0x2e, 0x3b, 0x67, 0x61, 0x73, 0x2e, 0x3b, 0x77, 0x65, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x74, 0x2e, 0x3b, 0x67,
0x69, 0x63, 0x2e, 0x3b, 0x6b, 0x61, 0x6d, 0x2e, 0x3b, 0x6e, 0x79, 0x61, 0x2e, 0x3b, 0x6b, 0x61, 0x6e, 0x2e, 0x3b, 0x6e,
0x7a, 0x65, 0x2e, 0x3b, 0x75, 0x6b, 0x77, 0x2e, 0x3b, 0x75, 0x67, 0x75, 0x2e, 0x3b, 0x75, 0x6b, 0x75, 0x2e, 0x3b, 0x4d,
0x75, 0x74, 0x61, 0x72, 0x61, 0x6d, 0x61, 0x3b, 0x47, 0x61, 0x73, 0x68, 0x79, 0x61, 0x6e, 0x74, 0x61, 0x72, 0x65, 0x3b,
0x57, 0x65, 0x72, 0x75, 0x72, 0x77, 0x65, 0x3b, 0x4d, 0x61, 0x74, 0x61, 0x3b, 0x47, 0x69, 0x63, 0x75, 0x72, 0x61, 0x6e,
0x73, 0x69, 0x3b, 0x4b, 0x61, 0x6d, 0x65, 0x6e, 0x61, 0x3b, 0x4e, 0x79, 0x61, 0x6b, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x4b,
0x61, 0x6e, 0x61, 0x6d, 0x61, 0x3b, 0x4e, 0x7a, 0x65, 0x6c, 0x69, 0x3b, 0x55, 0x6b, 0x77, 0x61, 0x6b, 0x69, 0x72, 0x61,
0x3b, 0x55, 0x67, 0x75, 0x73, 0x68, 0x79, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x55, 0x6b, 0x75, 0x62, 0x6f, 0x7a, 0x61, 0x3b,
0x31, 0xc6d4, 0x3b, 0x32, 0xc6d4, 0x3b, 0x33, 0xc6d4, 0x3b, 0x34, 0xc6d4, 0x3b, 0x35, 0xc6d4, 0x3b, 0x36, 0xc6d4, 0x3b, 0x37, 0xc6d4,
0x3b, 0x38, 0xc6d4, 0x3b, 0x39, 0xc6d4, 0x3b, 0x31, 0x30, 0xc6d4, 0x3b, 0x31, 0x31, 0xc6d4, 0x3b, 0x31, 0x32, 0xc6d4, 0x3b, 0x6a9,
0x627, 0x646, 0x648, 0x648, 0x646, 0x6cc, 0x20, 0x62f, 0x648, 0x648, 0x6d5, 0x645, 0x3b, 0x634, 0x648, 0x628, 0x627, 0x62a, 0x3b, 0x626,
0x627, 0x632, 0x627, 0x631, 0x3b, 0x646, 0x6cc, 0x633, 0x627, 0x646, 0x3b, 0x626, 0x627, 0x6cc, 0x627, 0x631, 0x3b, 0x62d, 0x648, 0x632,
0x6d5, 0x6cc, 0x631, 0x627, 0x646, 0x3b, 0x62a, 0x6d5, 0x645, 0x648, 0x648, 0x632, 0x3b, 0x626, 0x627, 0x628, 0x3b, 0x626, 0x6d5, 0x6cc,
0x644, 0x648, 0x648, 0x644, 0x3b, 0x62a, 0x634, 0x631, 0x6cc, 0x646, 0x6cc, 0x20, 0x6cc, 0x6d5, 0x6a9, 0x6d5, 0x645, 0x3b, 0x62a, 0x634,
0x631, 0x6cc, 0x646, 0x6cc, 0x20, 0x62f, 0x648, 0x648, 0x6d5, 0x645, 0x3b, 0x6a9, 0x627, 0x646, 0x648, 0x646, 0x6cc, 0x20, 0x6cc, 0x6d5,
0x6a9, 0x6d5, 0x645, 0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38, 0x3b,
0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x44, 0x3b, 0xe7, 0x69, 0x6c, 0x3b, 0x73, 0x69, 0x62, 0x3b, 0x61, 0x64,
0x72, 0x3b, 0x6e, 0xee, 0x73, 0x3b, 0x67, 0x75, 0x6c, 0x3b, 0x68, 0x65, 0x7a, 0x3b, 0x74, 0xee, 0x72, 0x3b, 0x38, 0x3b,
0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0xe7, 0x69, 0x6c, 0x65, 0x3b, 0x73, 0x69, 0x62, 0x61,
0x74, 0x3b, 0x61, 0x64, 0x61, 0x72, 0x3b, 0x6e, 0xee, 0x73, 0x61, 0x6e, 0x3b, 0x67, 0x75, 0x6c, 0x61, 0x6e, 0x3b, 0x68,
0x65, 0x7a, 0xee, 0x72, 0x61, 0x6e, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31,
0x32, 0x3b, 0xe7, 0x3b, 0x73, 0x3b, 0x61, 0x3b, 0x6e, 0x3b, 0x67, 0x3b, 0x68, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b,
0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0x4d, 0x75, 0x74, 0x2e, 0x3b, 0x47, 0x61, 0x73, 0x2e, 0x3b, 0x57,
0x65, 0x72, 0x2e, 0x3b, 0x4d, 0x61, 0x74, 0x2e, 0x3b, 0x47, 0x69, 0x63, 0x2e, 0x3b, 0x4b, 0x61, 0x6d, 0x2e, 0x3b, 0x4e,
0x79, 0x61, 0x2e, 0x3b, 0x4b, 0x61, 0x6e, 0x2e, 0x3b, 0x4e, 0x7a, 0x65, 0x2e, 0x3b, 0x55, 0x6b, 0x77, 0x2e, 0x3b, 0x55,
0x67, 0x75, 0x2e, 0x3b, 0x55, 0x6b, 0x75, 0x2e, 0x3b, 0x4e, 0x7a, 0x65, 0x72, 0x6f, 0x3b, 0x52, 0x75, 0x68, 0x75, 0x68,
0x75, 0x6d, 0x61, 0x3b, 0x4e, 0x74, 0x77, 0x61, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x3b, 0x4e, 0x64, 0x61, 0x6d, 0x75, 0x6b,
0x69, 0x7a, 0x61, 0x3b, 0x52, 0x75, 0x73, 0x61, 0x6d, 0x61, 0x3b, 0x52, 0x75, 0x68, 0x65, 0x73, 0x68, 0x69, 0x3b, 0x4d,
0x75, 0x6b, 0x61, 0x6b, 0x61, 0x72, 0x6f, 0x3b, 0x4e, 0x79, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x61, 0x72, 0x6f, 0x3b, 0x4e,
0x79, 0x61, 0x6b, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x47, 0x69, 0x74, 0x75, 0x67, 0x75, 0x74, 0x75, 0x3b, 0x4d, 0x75, 0x6e,
0x79, 0x6f, 0x6e, 0x79, 0x6f, 0x3b, 0x4b, 0x69, 0x67, 0x61, 0x72, 0x61, 0x6d, 0x61, 0x3b, 0xea1, 0x2e, 0xe81, 0x2e, 0x3b,
0xe81, 0x2e, 0xe9e, 0x2e, 0x3b, 0xea1, 0xeb5, 0x2e, 0xe99, 0x2e, 0x3b, 0xea1, 0x2e, 0xeaa, 0x2e, 0x2e, 0x3b, 0xe9e, 0x2e, 0xe9e,
0x2e, 0x3b, 0xea1, 0xeb4, 0x2e, 0xe96, 0x2e, 0x3b, 0xe81, 0x2e, 0xea5, 0x2e, 0x3b, 0xeaa, 0x2e, 0xeab, 0x2e, 0x3b, 0xe81, 0x2e,
0xe8d, 0x2e, 0x3b, 0xe95, 0x2e, 0xea5, 0x2e, 0x3b, 0xe9e, 0x2e, 0xe88, 0x2e, 0x3b, 0xe97, 0x2e, 0xea7, 0x2e, 0x3b, 0xea1, 0xeb1,
0xe87, 0xe81, 0xead, 0xe99, 0x3b, 0xe81, 0xeb8, 0xea1, 0xe9e, 0xeb2, 0x3b, 0xea1, 0xeb5, 0xe99, 0xeb2, 0x3b, 0xec0, 0xea1, 0xeaa, 0xeb2,
0x3b, 0xe9e, 0xeb6, 0xe94, 0xeaa, 0xeb0, 0xe9e, 0xeb2, 0x3b, 0xea1, 0xeb4, 0xe96, 0xeb8, 0xe99, 0xeb2, 0x3b, 0xe81, 0xecd, 0xea5, 0xeb0,
0xe81, 0xebb, 0xe94, 0x3b, 0xeaa, 0xeb4, 0xe87, 0xeab, 0xeb2, 0x3b, 0xe81, 0xeb1, 0xe99, 0xe8d, 0xeb2, 0x3b, 0xe95, 0xeb8, 0xea5, 0xeb2,
0x3b, 0xe9e, 0xeb0, 0xe88, 0xeb4, 0xe81, 0x3b, 0xe97, 0xeb1, 0xe99, 0xea7, 0xeb2, 0x3b, 0x6a, 0x61, 0x6e, 0x76, 0x2e, 0x3b, 0x66,
0x65, 0x62, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x6a,
0x73, 0x3b, 0x6a, 0x16b, 0x6e, 0x2e, 0x3b, 0x6a, 0x16b, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70,
0x74, 0x2e, 0x3b, 0x6f, 0x6b, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x6a, 0x61,
0x6e, 0x76, 0x101, 0x72, 0x69, 0x73, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x101, 0x72, 0x69, 0x73, 0x3b, 0x6d, 0x61, 0x72,
0x74, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x12b, 0x6c, 0x69, 0x73, 0x3b, 0x6d, 0x61, 0x69, 0x6a, 0x73, 0x3b, 0x6a, 0x16b, 0x6e,
0x69, 0x6a, 0x73, 0x3b, 0x6a, 0x16b, 0x6c, 0x69, 0x6a, 0x73, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x73, 0x3b, 0x73,
0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x6e,
0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x73, 0x3b, 0x79,
0x61, 0x6e, 0x3b, 0x66, 0x62, 0x6c, 0x3b, 0x6d, 0x73, 0x69, 0x3b, 0x61, 0x70, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x79,
0x75, 0x6e, 0x3b, 0x79, 0x75, 0x6c, 0x3b, 0x61, 0x67, 0x74, 0x3b, 0x73, 0x74, 0x62, 0x3b, 0x254, 0x74, 0x62, 0x3b, 0x6e,
0x76, 0x62, 0x3b, 0x64, 0x73, 0x62, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x79, 0x61, 0x6d, 0x62,
0x6f, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x62, 0x61, 0x6c, 0xe9, 0x3b, 0x73, 0xe1,
0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x73, 0xe1, 0x74, 0x6f, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20,
0x79, 0x61, 0x20, 0x6d, 0xed, 0x6e, 0x65, 0x69, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed,
0x74, 0xe1, 0x6e, 0x6f, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0x6f, 0x74, 0xf3, 0x62, 0xe1,
0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6e, 0x73, 0x61, 0x6d, 0x62, 0x6f, 0x3b, 0x73, 0xe1, 0x6e,
0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x6d, 0x77, 0x61, 0x6d, 0x62, 0x65, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79,
0x61, 0x20, 0x6c, 0x69, 0x62, 0x77, 0x61, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x7a, 0xf3, 0x6d,
0x69, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x7a, 0xf3, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d,
0x254, 0x30c, 0x6b, 0x254, 0x301, 0x3b, 0x73, 0xe1, 0x6e, 0x7a, 0xe1, 0x20, 0x79, 0x61, 0x20, 0x7a, 0xf3, 0x6d, 0x69, 0x20,
0x6e, 0x61, 0x20, 0x6d, 0xed, 0x62, 0x61, 0x6c, 0xe9, 0x3b, 0x79, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x61, 0x3b, 0x6d, 0x3b,
0x79, 0x3b, 0x79, 0x3b, 0x61, 0x3b, 0x73, 0x3b, 0x254, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x53, 0x61, 0x75, 0x73, 0x2e, 0x3b,
0x56, 0x61, 0x73, 0x2e, 0x3b, 0x4b, 0x6f, 0x76, 0x2e, 0x3b, 0x42, 0x61, 0x6c, 0x2e, 0x3b, 0x47, 0x65, 0x67, 0x2e, 0x3b,
0x42, 0x69, 0x72, 0x2e, 0x3b, 0x4c, 0x69, 0x65, 0x70, 0x2e, 0x3b, 0x52, 0x75, 0x67, 0x70, 0x2e, 0x3b, 0x52, 0x75, 0x67,
0x73, 0x2e, 0x3b, 0x53, 0x70, 0x61, 0x6c, 0x2e, 0x3b, 0x4c, 0x61, 0x70, 0x6b, 0x72, 0x2e, 0x3b, 0x47, 0x72, 0x75, 0x6f,
0x64, 0x2e, 0x3b, 0x53, 0x61, 0x75, 0x73, 0x69, 0x73, 0x3b, 0x56, 0x61, 0x73, 0x61, 0x72, 0x69, 0x73, 0x3b, 0x4b, 0x6f,
0x76, 0x61, 0x73, 0x3b, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x69, 0x73, 0x3b, 0x47, 0x65, 0x67, 0x75, 0x17e, 0x117, 0x3b,
0x42, 0x69, 0x72, 0x17e, 0x65, 0x6c, 0x69, 0x73, 0x3b, 0x4c, 0x69, 0x65, 0x70, 0x61, 0x3b, 0x52, 0x75, 0x67, 0x70, 0x6a,
0x16b, 0x74, 0x69, 0x73, 0x3b, 0x52, 0x75, 0x67, 0x73, 0x117, 0x6a, 0x69, 0x73, 0x3b, 0x53, 0x70, 0x61, 0x6c, 0x69, 0x73,
0x3b, 0x4c, 0x61, 0x70, 0x6b, 0x72, 0x69, 0x74, 0x69, 0x73, 0x3b, 0x47, 0x72, 0x75, 0x6f, 0x64, 0x69, 0x73, 0x3b, 0x53,
0x3b, 0x56, 0x3b, 0x4b, 0x3b, 0x42, 0x3b, 0x47, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x52, 0x3b, 0x52, 0x3b, 0x53, 0x3b, 0x4c,
0x3b, 0x47, 0x3b, 0x458, 0x430, 0x43d, 0x2e, 0x3b, 0x444, 0x435, 0x432, 0x2e, 0x3b, 0x43c, 0x430, 0x440, 0x2e, 0x3b, 0x430, 0x43f,
0x440, 0x2e, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x2e, 0x3b, 0x458, 0x443, 0x43b, 0x2e, 0x3b, 0x430, 0x432, 0x433,
0x2e, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x2e, 0x3b, 0x43e, 0x43a, 0x442, 0x2e, 0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x2e, 0x3b, 0x434,
0x435, 0x43a, 0x435, 0x43c, 0x2e, 0x3b, 0x458, 0x430, 0x43d, 0x443, 0x430, 0x440, 0x438, 0x3b, 0x444, 0x435, 0x432, 0x440, 0x443, 0x430,
0x440, 0x438, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x438, 0x43b, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443,
0x43d, 0x438, 0x3b, 0x458, 0x443, 0x43b, 0x438, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435,
0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43e, 0x43a, 0x442, 0x43e, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x43d, 0x43e, 0x435, 0x43c, 0x432, 0x440,
0x438, 0x3b, 0x434, 0x435, 0x43a, 0x435, 0x43c, 0x432, 0x440, 0x438, 0x3b, 0x458, 0x3b, 0x444, 0x3b, 0x43c, 0x3b, 0x430, 0x3b, 0x43c,
0x3b, 0x458, 0x3b, 0x458, 0x3b, 0x430, 0x3b, 0x441, 0x3b, 0x43e, 0x3b, 0x43d, 0x3b, 0x434, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46,
0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x79, 0x3b, 0x4a, 0x6f, 0x6e, 0x3b, 0x4a,
0x6f, 0x6c, 0x3b, 0x41, 0x6f, 0x67, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44,
0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x6f, 0x61, 0x72, 0x79, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x6f, 0x61, 0x72, 0x79, 0x3b,
0x4d, 0x61, 0x72, 0x74, 0x73, 0x61, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x79, 0x3b, 0x4d, 0x65, 0x79, 0x3b, 0x4a, 0x6f,
0x6e, 0x61, 0x3b, 0x4a, 0x6f, 0x6c, 0x61, 0x79, 0x3b, 0x41, 0x6f, 0x67, 0x6f, 0x73, 0x69, 0x74, 0x72, 0x61, 0x3b, 0x53,
0x65, 0x70, 0x74, 0x61, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x72, 0x61, 0x3b, 0x4e, 0x6f, 0x76,
0x61, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x61, 0x6d, 0x62, 0x72, 0x61, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46,
0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a,
0x75, 0x6c, 0x3b, 0x4f, 0x67, 0x6f, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b,
0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69,
0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a,
0x75, 0x6c, 0x61, 0x69, 0x3b, 0x4f, 0x67, 0x6f, 0x73, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x69, 0x73,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b,
0x4f, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0xd1c, 0xd28, 0xd41, 0x3b, 0xd2b, 0xd46, 0xd2c, 0xd4d, 0xd30, 0xd41,
0x3b, 0xd2e, 0xd3e, 0xd30, 0xd4d, 0x200d, 0x3b, 0xd0f, 0xd2a, 0xd4d, 0xd30, 0xd3f, 0x3b, 0xd2e, 0xd47, 0xd2f, 0xd4d, 0x3b, 0xd1c, 0xd42,
0xd23, 0xd4d, 0x200d, 0x3b, 0xd1c, 0xd42, 0xd32, 0xd48, 0x3b, 0xd13, 0xd17, 0x3b, 0xd38, 0xd46, 0xd2a, 0xd4d, 0xd31, 0xd4d, 0xd31, 0xd02,
0x3b, 0xd12, 0xd15, 0xd4d, 0xd1f, 0xd4b, 0x3b, 0xd28, 0xd35, 0xd02, 0x3b, 0xd21, 0xd3f, 0xd38, 0xd02, 0x3b, 0xd1c, 0xd28, 0xd41, 0xd35,
0xd30, 0xd3f, 0x3b, 0xd2b, 0xd46, 0xd2c, 0xd4d, 0xd30, 0xd41, 0xd35, 0xd30, 0xd3f, 0x3b, 0xd2e, 0xd3e, 0xd30, 0xd4d, 0x200d, 0xd1a, 0xd4d,
0xd1a, 0xd4d, 0x3b, 0xd0f, 0xd2a, 0xd4d, 0xd30, 0xd3f, 0xd32, 0xd4d, 0x200d, 0x3b, 0xd2e, 0xd47, 0xd2f, 0xd4d, 0x3b, 0xd1c, 0xd42, 0xd23,
0xd4d, 0x200d, 0x3b, 0xd1c, 0xd42, 0xd32, 0xd48, 0x3b, 0xd06, 0xd17, 0xd38, 0xd4d, 0xd31, 0xd4d, 0xd31, 0xd4d, 0x3b, 0xd38, 0xd46, 0xd2a,
0xd4d, 0xd31, 0xd4d, 0xd31, 0xd02, 0xd2c, 0xd30, 0xd4d, 0x200d, 0x3b, 0xd12, 0xd15, 0xd4d, 0xd1f, 0xd4b, 0xd2c, 0xd30, 0xd4d, 0x200d, 0x3b,
0xd28, 0xd35, 0xd02, 0xd2c, 0xd30, 0xd4d, 0x200d, 0x3b, 0xd21, 0xd3f, 0xd38, 0xd02, 0xd2c, 0xd30, 0xd4d, 0x200d, 0x3b, 0xd1c, 0x3b, 0xd2b,
0xd46, 0x3b, 0xd2e, 0xd3e, 0x3b, 0xd0f, 0x3b, 0xd2e, 0xd47, 0x3b, 0xd1c, 0xd42, 0x3b, 0xd1c, 0xd42, 0x3b, 0xd13, 0x3b, 0xd38, 0xd46,
0x3b, 0xd12, 0x3b, 0xd28, 0x3b, 0xd21, 0xd3f, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x72, 0x61, 0x3b, 0x4d, 0x61, 0x72, 0x3b,
0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x6a, 0x3b, 0x120, 0x75, 0x6e, 0x3b, 0x4c, 0x75, 0x6c, 0x3b, 0x41, 0x77, 0x77, 0x3b,
0x53, 0x65, 0x74, 0x3b, 0x4f, 0x74, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x10b, 0x3b, 0x4a, 0x61, 0x6e, 0x6e,
0x61, 0x72, 0x3b, 0x46, 0x72, 0x61, 0x72, 0x3b, 0x4d, 0x61, 0x72, 0x7a, 0x75, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b,
0x4d, 0x65, 0x6a, 0x6a, 0x75, 0x3b, 0x120, 0x75, 0x6e, 0x6a, 0x75, 0x3b, 0x4c, 0x75, 0x6c, 0x6a, 0x75, 0x3b, 0x41, 0x77,
0x77, 0x69, 0x73, 0x73, 0x75, 0x3b, 0x53, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x75, 0x3b, 0x4f, 0x74, 0x74, 0x75,
0x62, 0x72, 0x75, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x75, 0x3b, 0x44, 0x69, 0x10b, 0x65, 0x6d, 0x62, 0x72,
0x75, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x120, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x53, 0x3b,
0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x91c, 0x93e, 0x928, 0x947, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x3b, 0x92e, 0x93e,
0x930, 0x94d, 0x91a, 0x3b, 0x90f, 0x92a, 0x94d, 0x930, 0x93f, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932,
0x948, 0x3b, 0x911, 0x917, 0x3b, 0x938, 0x947, 0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x3b, 0x911, 0x915, 0x94d, 0x91f, 0x94b, 0x92c, 0x930,
0x3b, 0x928, 0x94b, 0x935, 0x94d, 0x939, 0x947, 0x902, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x902, 0x3b, 0x91c, 0x93e, 0x928, 0x947, 0x935,
0x93e, 0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a,
0x3b, 0x90f, 0x92a, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x948, 0x3b,
0x911, 0x917, 0x938, 0x94d, 0x91f, 0x3b, 0x938, 0x92a, 0x94d, 0x91f, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x911, 0x915, 0x94d, 0x91f, 0x94b,
0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x935, 0x94d, 0x939, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x902, 0x92c, 0x930,
0x3b, 0x91c, 0x93e, 0x3b, 0x92b, 0x947, 0x3b, 0x92e, 0x93e, 0x3b, 0x90f, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x942, 0x3b, 0x91c, 0x941,
0x3b, 0x911, 0x3b, 0x938, 0x3b, 0x911, 0x3b, 0x928, 0x94b, 0x3b, 0x921, 0x93f, 0x3b, 0x445, 0x443, 0x43b, 0x3b, 0x4af, 0x445, 0x44d,
0x3b, 0x431, 0x430, 0x440, 0x3b, 0x442, 0x443, 0x443, 0x3b, 0x43b, 0x443, 0x443, 0x3b, 0x43c, 0x43e, 0x433, 0x3b, 0x43c, 0x43e, 0x440,
0x3b, 0x445, 0x43e, 0x43d, 0x3b, 0x431, 0x438, 0x447, 0x3b, 0x442, 0x430, 0x445, 0x3b, 0x43d, 0x43e, 0x445, 0x3b, 0x433, 0x430, 0x445,
0x3b, 0x425, 0x443, 0x43b, 0x433, 0x430, 0x43d, 0x430, 0x3b, 0x4ae, 0x445, 0x44d, 0x440, 0x3b, 0x411, 0x430, 0x440, 0x3b, 0x422, 0x443,
0x443, 0x43b, 0x430, 0x439, 0x3b, 0x41b, 0x443, 0x443, 0x3b, 0x41c, 0x43e, 0x433, 0x43e, 0x439, 0x3b, 0x41c, 0x43e, 0x440, 0x44c, 0x3b,
0x425, 0x43e, 0x43d, 0x44c, 0x3b, 0x411, 0x438, 0x447, 0x3b, 0x422, 0x430, 0x445, 0x438, 0x430, 0x3b, 0x41d, 0x43e, 0x445, 0x43e, 0x439,
0x3b, 0x413, 0x430, 0x445, 0x430, 0x439, 0x3b, 0x91c, 0x928, 0x3b, 0x92b, 0x947, 0x92c, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b,
0x905, 0x92a, 0x94d, 0x930, 0x93f, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x3b, 0x905, 0x917,
0x3b, 0x938, 0x947, 0x92a, 0x94d, 0x91f, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x94b, 0x3b, 0x928, 0x94b, 0x92d, 0x947, 0x3b, 0x921, 0x93f,
0x938, 0x947, 0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x905, 0x930, 0x940, 0x3b, 0x92e,
0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c,
0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x924, 0x3b, 0x938, 0x947, 0x92a, 0x94d, 0x91f, 0x947, 0x92e, 0x94d, 0x92c,
0x930, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x92d, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x921,
0x93f, 0x938, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x967, 0x3b, 0x968, 0x3b, 0x969, 0x3b, 0x96a, 0x3b, 0x96b, 0x3b, 0x96c, 0x3b,
0x96d, 0x3b, 0x96e, 0x3b, 0x96f, 0x3b, 0x967, 0x966, 0x3b, 0x967, 0x967, 0x3b, 0x967, 0x968, 0x3b, 0x91c, 0x928, 0x935, 0x930, 0x940,
0x3b, 0x92b, 0x930, 0x935, 0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x905, 0x92a, 0x94d, 0x930, 0x947, 0x932, 0x3b,
0x92e, 0x908, 0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x93e, 0x908, 0x3b, 0x905, 0x917, 0x938, 0x94d, 0x924, 0x3b, 0x938,
0x947, 0x92a, 0x94d, 0x91f, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x905, 0x915, 0x94d, 0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x94b,
0x92d, 0x947, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x926, 0x93f, 0x938, 0x92e, 0x94d, 0x92c, 0x930, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61,
0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c,
0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73,
0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b,
0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x67, 0x65,
0x6e, 0x69, 0xe8, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x69, 0xe8, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0xe7, 0x3b, 0x61, 0x62,
0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x68, 0x3b, 0x6a, 0x75, 0x6c, 0x68, 0x65, 0x74, 0x3b,
0x61, 0x67, 0x6f, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0xf2, 0x62,
0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x72, 0x65,
0x3b, 0xb1c, 0xb3e, 0xb28, 0xb41, 0xb06, 0xb30, 0xb40, 0x3b, 0xb2b, 0xb47, 0xb2c, 0xb4d, 0xb30, 0xb41, 0xb5f, 0xb3e, 0xb30, 0xb40, 0x3b,
0xb2e, 0xb3e, 0xb30, 0xb4d, 0xb1a, 0xb4d, 0xb1a, 0x3b, 0xb05, 0xb2a, 0xb4d, 0xb30, 0xb47, 0xb32, 0x3b, 0xb2e, 0xb47, 0x3b, 0xb1c, 0xb41,
0xb28, 0x3b, 0xb1c, 0xb41, 0xb32, 0xb3e, 0xb07, 0x3b, 0xb05, 0xb17, 0xb37, 0xb4d, 0xb1f, 0x3b, 0xb38, 0xb47, 0xb2a, 0xb4d, 0xb1f, 0xb47,
0xb2e, 0xb4d, 0xb2c, 0xb30, 0x3b, 0xb05, 0xb15, 0xb4d, 0xb1f, 0xb4b, 0xb2c, 0xb30, 0x3b, 0xb28, 0xb2d, 0xb47, 0xb2e, 0xb4d, 0xb2c, 0xb30,
0x3b, 0xb21, 0xb3f, 0xb38, 0xb47, 0xb2e, 0xb4d, 0xb2c, 0xb30, 0x3b, 0xb1c, 0xb3e, 0x3b, 0xb2b, 0xb47, 0x3b, 0xb2e, 0xb3e, 0x3b, 0xb05,
0x3b, 0xb2e, 0xb47, 0x3b, 0xb1c, 0xb41, 0x3b, 0xb1c, 0xb41, 0x3b, 0xb05, 0x3b, 0xb38, 0xb47, 0x3b, 0xb05, 0x3b, 0xb28, 0x3b, 0xb21,
0xb3f, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x64a, 0x3b, 0x641, 0x628, 0x631, 0x648, 0x631, 0x64a, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b,
0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x6cc, 0x3b, 0x627,
0x6ab, 0x633, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648,
0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x698, 0x627, 0x646, 0x648, 0x6cc, 0x647, 0x3b, 0x641, 0x648, 0x631,
0x6cc, 0x647, 0x3b, 0x645, 0x627, 0x631, 0x633, 0x3b, 0x622, 0x648, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x647, 0x3b, 0x698, 0x648, 0x626,
0x646, 0x3b, 0x698, 0x648, 0x626, 0x6cc, 0x647, 0x3b, 0x627, 0x648, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x627, 0x645, 0x628, 0x631, 0x3b,
0x627, 0x6a9, 0x62a, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x627, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x627, 0x645, 0x628, 0x631, 0x3b,
0x698, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x622, 0x3b, 0x645, 0x3b, 0x698, 0x3b, 0x698, 0x3b, 0x627, 0x3b, 0x633, 0x3b, 0x627, 0x3b,
0x646, 0x3b, 0x62f, 0x3b, 0x62c, 0x3b, 0x641, 0x3b, 0x645, 0x3b, 0x627, 0x3b, 0x645, 0x3b, 0x62c, 0x3b, 0x62c, 0x3b, 0x627, 0x3b,
0x633, 0x3b, 0x627, 0x3b, 0x646, 0x3b, 0x62f, 0x3b, 0x73, 0x74, 0x79, 0x3b, 0x6c, 0x75, 0x74, 0x3b, 0x6d, 0x61, 0x72, 0x3b,
0x6b, 0x77, 0x69, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x63, 0x7a, 0x65, 0x3b, 0x6c, 0x69, 0x70, 0x3b, 0x73, 0x69, 0x65, 0x3b,
0x77, 0x72, 0x7a, 0x3b, 0x70, 0x61, 0x17a, 0x3b, 0x6c, 0x69, 0x73, 0x3b, 0x67, 0x72, 0x75, 0x3b, 0x73, 0x74, 0x79, 0x63,
0x7a, 0x65, 0x144, 0x3b, 0x6c, 0x75, 0x74, 0x79, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x65, 0x63, 0x3b, 0x6b, 0x77, 0x69, 0x65,
0x63, 0x69, 0x65, 0x144, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x63, 0x7a, 0x65, 0x72, 0x77, 0x69, 0x65, 0x63, 0x3b, 0x6c, 0x69,
0x70, 0x69, 0x65, 0x63, 0x3b, 0x73, 0x69, 0x65, 0x72, 0x70, 0x69, 0x65, 0x144, 0x3b, 0x77, 0x72, 0x7a, 0x65, 0x73, 0x69,
0x65, 0x144, 0x3b, 0x70, 0x61, 0x17a, 0x64, 0x7a, 0x69, 0x65, 0x72, 0x6e, 0x69, 0x6b, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x6f,
0x70, 0x61, 0x64, 0x3b, 0x67, 0x72, 0x75, 0x64, 0x7a, 0x69, 0x65, 0x144, 0x3b, 0x73, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6b,
0x3b, 0x6d, 0x3b, 0x63, 0x3b, 0x6c, 0x3b, 0x73, 0x3b, 0x77, 0x3b, 0x70, 0x3b, 0x6c, 0x3b, 0x67, 0x3b, 0x4a, 0x61, 0x6e,
0x3b, 0x46, 0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e,
0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x75, 0x74, 0x3b, 0x4e, 0x6f, 0x76,
0x3b, 0x44, 0x65, 0x7a, 0x3b, 0x4a, 0x61, 0x6e, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x46, 0x65, 0x76, 0x65, 0x72, 0x65, 0x69,
0x72, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0xe7, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x6f, 0x3b,
0x4a, 0x75, 0x6e, 0x68, 0x6f, 0x3b, 0x4a, 0x75, 0x6c, 0x68, 0x6f, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53,
0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x4f, 0x75, 0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x4e, 0x6f, 0x76, 0x65,
0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x44, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65,
0x76, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x62, 0x72, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75,
0x6c, 0x3b, 0x61, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x3b, 0x6f, 0x75, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65,
0x7a, 0x3b, 0x6a, 0x61, 0x6e, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x66, 0x65, 0x76, 0x65, 0x72, 0x65, 0x69, 0x72, 0x6f, 0x3b,
0x6d, 0x61, 0x72, 0xe7, 0x6f, 0x3b, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6e,
0x68, 0x6f, 0x3b, 0x6a, 0x75, 0x6c, 0x68, 0x6f, 0x3b, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x74, 0x65,
0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x6f, 0x75, 0x74, 0x75, 0x62, 0x72, 0x6f, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72,
0x6f, 0x3b, 0x64, 0x65, 0x7a, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0xa1c, 0xa28, 0xa35, 0xa30, 0xa40, 0x3b, 0xa2b, 0xa3c, 0xa30,
0xa35, 0xa30, 0xa40, 0x3b, 0xa2e, 0xa3e, 0xa30, 0xa1a, 0x3b, 0xa05, 0xa2a, 0xa4d, 0xa30, 0xa48, 0xa32, 0x3b, 0xa2e, 0xa08, 0x3b, 0xa1c,
0xa42, 0xa28, 0x3b, 0xa1c, 0xa41, 0xa32, 0xa3e, 0xa08, 0x3b, 0xa05, 0xa17, 0xa38, 0xa24, 0x3b, 0xa38, 0xa24, 0xa70, 0xa2c, 0xa30, 0x3b,
0xa05, 0xa15, 0xa24, 0xa42, 0xa2c, 0xa30, 0x3b, 0xa28, 0xa35, 0xa70, 0xa2c, 0xa30, 0x3b, 0xa26, 0xa38, 0xa70, 0xa2c, 0xa30, 0x3b, 0xa1c,
0x3b, 0xa2b, 0x3b, 0xa2e, 0xa3e, 0x3b, 0xa05, 0x3b, 0xa2e, 0x3b, 0xa1c, 0xa42, 0x3b, 0xa1c, 0xa41, 0x3b, 0xa05, 0x3b, 0xa38, 0x3b,
0xa05, 0x3b, 0xa28, 0x3b, 0xa26, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x6cc, 0x3b, 0x641, 0x631, 0x648, 0x631, 0x6cc, 0x3b, 0x645, 0x627,
0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x626, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627,
0x626, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631,
0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x73, 0x63, 0x68, 0x61, 0x6e, 0x2e, 0x3b,
0x66, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x74, 0x67,
0x3b, 0x7a, 0x65, 0x72, 0x63, 0x6c, 0x2e, 0x3b, 0x66, 0x61, 0x6e, 0x2e, 0x3b, 0x61, 0x76, 0x75, 0x73, 0x74, 0x3b, 0x73,
0x65, 0x74, 0x74, 0x2e, 0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b,
0x73, 0x63, 0x68, 0x61, 0x6e, 0x65, 0x72, 0x3b, 0x66, 0x61, 0x76, 0x72, 0x65, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x73, 0x3b,
0x61, 0x76, 0x72, 0x69, 0x67, 0x6c, 0x3b, 0x6d, 0x61, 0x74, 0x67, 0x3b, 0x7a, 0x65, 0x72, 0x63, 0x6c, 0x61, 0x64, 0x75,
0x72, 0x3b, 0x66, 0x61, 0x6e, 0x61, 0x64, 0x75, 0x72, 0x3b, 0x61, 0x76, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x74, 0x74,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62,
0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x53, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b,
0x4d, 0x3b, 0x5a, 0x3b, 0x46, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x69, 0x61, 0x6e, 0x2e,
0x3b, 0x66, 0x65, 0x62, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x70, 0x72, 0x2e, 0x3b, 0x6d, 0x61, 0x69, 0x3b,
0x69, 0x75, 0x6e, 0x2e, 0x3b, 0x69, 0x75, 0x6c, 0x2e, 0x3b, 0x61, 0x75, 0x67, 0x2e, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x2e,
0x3b, 0x6f, 0x63, 0x74, 0x2e, 0x3b, 0x6e, 0x6f, 0x76, 0x2e, 0x3b, 0x64, 0x65, 0x63, 0x2e, 0x3b, 0x69, 0x61, 0x6e, 0x75,
0x61, 0x72, 0x69, 0x65, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x65, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x69,
0x65, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x65, 0x3b, 0x6d, 0x61, 0x69, 0x3b, 0x69, 0x75, 0x6e, 0x69, 0x65, 0x3b,
0x69, 0x75, 0x6c, 0x69, 0x65, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62,
0x72, 0x69, 0x65, 0x3b, 0x6f, 0x63, 0x74, 0x6f, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x6e, 0x6f, 0x69, 0x65, 0x6d, 0x62,
0x72, 0x69, 0x65, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x69, 0x65, 0x3b, 0x49, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x42f, 0x43d,
0x432, 0x2e, 0x3b, 0x424, 0x435, 0x432, 0x440, 0x2e, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x3b, 0x410, 0x43f, 0x440, 0x2e, 0x3b, 0x41c,
0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x44c, 0x3b, 0x418, 0x44e, 0x43b, 0x44c, 0x3b, 0x410, 0x432, 0x433, 0x2e, 0x3b, 0x421, 0x435,
0x43d, 0x442, 0x2e, 0x3b, 0x41e, 0x43a, 0x442, 0x2e, 0x3b, 0x41d, 0x43e, 0x44f, 0x431, 0x2e, 0x3b, 0x414, 0x435, 0x43a, 0x2e, 0x3b,
0x42f, 0x43d, 0x432, 0x430, 0x440, 0x44c, 0x3b, 0x424, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x44c, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x3b,
0x410, 0x43f, 0x440, 0x435, 0x43b, 0x44c, 0x3b, 0x41c, 0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x44c, 0x3b, 0x418, 0x44e, 0x43b, 0x44c,
0x3b, 0x410, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x421, 0x435, 0x43d, 0x442, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x41e, 0x43a, 0x442,
0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x41d, 0x43e, 0x44f, 0x431, 0x440, 0x44c, 0x3b, 0x414, 0x435, 0x43a, 0x430, 0x431, 0x440, 0x44c, 0x3b,
0x42f, 0x3b, 0x424, 0x3b, 0x41c, 0x3b, 0x410, 0x3b, 0x41c, 0x3b, 0x418, 0x3b, 0x418, 0x3b, 0x410, 0x3b, 0x421, 0x3b, 0x41e, 0x3b,
0x41d, 0x3b, 0x414, 0x3b, 0x4e, 0x79, 0x65, 0x3b, 0x46, 0x75, 0x6c, 0x3b, 0x4d, 0x62, 0xe4, 0x3b, 0x4e, 0x67, 0x75, 0x3b,
0x42, 0xea, 0x6c, 0x3b, 0x46, 0xf6, 0x6e, 0x3b, 0x4c, 0x65, 0x6e, 0x3b, 0x4b, 0xfc, 0x6b, 0x3b, 0x4d, 0x76, 0x75, 0x3b,
0x4e, 0x67, 0x62, 0x3b, 0x4e, 0x61, 0x62, 0x3b, 0x4b, 0x61, 0x6b, 0x3b, 0x4e, 0x79, 0x65, 0x6e, 0x79, 0x65, 0x3b, 0x46,
0x75, 0x6c, 0x75, 0x6e, 0x64, 0xef, 0x67, 0x69, 0x3b, 0x4d, 0x62, 0xe4, 0x6e, 0x67, 0xfc, 0x3b, 0x4e, 0x67, 0x75, 0x62,
0xf9, 0x65, 0x3b, 0x42, 0xea, 0x6c, 0xe4, 0x77, 0xfc, 0x3b, 0x46, 0xf6, 0x6e, 0x64, 0x6f, 0x3b, 0x4c, 0x65, 0x6e, 0x67,
0x75, 0x61, 0x3b, 0x4b, 0xfc, 0x6b, 0xfc, 0x72, 0xfc, 0x3b, 0x4d, 0x76, 0x75, 0x6b, 0x61, 0x3b, 0x4e, 0x67, 0x62, 0x65,
0x72, 0x65, 0x72, 0x65, 0x3b, 0x4e, 0x61, 0x62, 0xe4, 0x6e, 0x64, 0xfc, 0x72, 0x75, 0x3b, 0x4b, 0x61, 0x6b, 0x61, 0x75,
0x6b, 0x61, 0x3b, 0x4e, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x42, 0x3b, 0x46, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x4d,
0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x458, 0x430, 0x43d, 0x3b, 0x444, 0x435, 0x431, 0x3b, 0x43c, 0x430, 0x440, 0x3b, 0x430,
0x43f, 0x440, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x3b, 0x458, 0x443, 0x43b, 0x3b, 0x430, 0x432, 0x433, 0x3b, 0x441,
0x435, 0x43f, 0x3b, 0x43e, 0x43a, 0x442, 0x3b, 0x43d, 0x43e, 0x432, 0x3b, 0x434, 0x435, 0x446, 0x3b, 0x458, 0x430, 0x43d, 0x443, 0x430,
0x440, 0x3b, 0x444, 0x435, 0x431, 0x440, 0x443, 0x430, 0x440, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x438, 0x43b,
0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x3b, 0x458, 0x443, 0x43b, 0x3b, 0x430, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b,
0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x43e, 0x43a, 0x442, 0x43e, 0x431, 0x430, 0x440, 0x3b, 0x43d, 0x43e,
0x432, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x434, 0x435, 0x446, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x458, 0x430, 0x43d, 0x443,
0x430, 0x440, 0x3b, 0x444, 0x435, 0x431, 0x440, 0x443, 0x430, 0x440, 0x3b, 0x43c, 0x430, 0x440, 0x442, 0x3b, 0x430, 0x43f, 0x440, 0x438,
0x43b, 0x3b, 0x43c, 0x430, 0x458, 0x3b, 0x458, 0x443, 0x43d, 0x438, 0x3b, 0x458, 0x443, 0x43b, 0x438, 0x3b, 0x430, 0x432, 0x433, 0x443,
0x441, 0x442, 0x3b, 0x441, 0x435, 0x43f, 0x442, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x43e, 0x43a, 0x442, 0x43e, 0x431, 0x430, 0x440,
0x3b, 0x43d, 0x43e, 0x432, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x434, 0x435, 0x446, 0x435, 0x43c, 0x431, 0x430, 0x440, 0x3b, 0x6a,
0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a,
0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e,
0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61,
0x72, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e,
0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61,
0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x64,
0x65, 0x63, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x6a, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b,
0x6a, 0x3b, 0x61, 0x3b, 0x73, 0x3b, 0x6f, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x50, 0x68, 0x65, 0x3b, 0x4b, 0x6f, 0x6c, 0x3b,
0x55, 0x62, 0x65, 0x3b, 0x4d, 0x6d, 0x65, 0x3b, 0x4d, 0x6f, 0x74, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x55, 0x70, 0x75, 0x3b,
0x50, 0x68, 0x61, 0x3b, 0x4c, 0x65, 0x6f, 0x3b, 0x4d, 0x70, 0x68, 0x3b, 0x50, 0x75, 0x6e, 0x3b, 0x54, 0x73, 0x68, 0x3b,
0x50, 0x68, 0x65, 0x73, 0x65, 0x6b, 0x67, 0x6f, 0x6e, 0x67, 0x3b, 0x48, 0x6c, 0x61, 0x6b, 0x6f, 0x6c, 0x61, 0x3b, 0x48,
0x6c, 0x61, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x3b, 0x4d, 0x6d, 0x65, 0x73, 0x65, 0x3b, 0x4d, 0x6f, 0x74, 0x73, 0x68,
0x65, 0x61, 0x6e, 0x6f, 0x6e, 0x67, 0x3b, 0x50, 0x68, 0x75, 0x70, 0x6a, 0x61, 0x6e, 0x65, 0x3b, 0x50, 0x68, 0x75, 0x70,
0x75, 0x3b, 0x50, 0x68, 0x61, 0x74, 0x61, 0x3b, 0x4c, 0x65, 0x6f, 0x74, 0x73, 0x68, 0x65, 0x3b, 0x4d, 0x70, 0x68, 0x61,
0x6c, 0x61, 0x6e, 0x65, 0x3b, 0x50, 0x75, 0x6e, 0x64, 0x75, 0x6e, 0x67, 0x77, 0x61, 0x6e, 0x65, 0x3b, 0x54, 0x73, 0x68,
0x69, 0x74, 0x77, 0x65, 0x3b, 0x46, 0x65, 0x72, 0x3b, 0x54, 0x6c, 0x68, 0x3b, 0x4d, 0x6f, 0x70, 0x3b, 0x4d, 0x6f, 0x72,
0x3b, 0x4d, 0x6f, 0x74, 0x3b, 0x53, 0x65, 0x65, 0x3b, 0x50, 0x68, 0x75, 0x3b, 0x50, 0x68, 0x61, 0x3b, 0x4c, 0x77, 0x65,
0x3b, 0x44, 0x69, 0x70, 0x3b, 0x4e, 0x67, 0x77, 0x3b, 0x53, 0x65, 0x64, 0x3b, 0x46, 0x65, 0x72, 0x69, 0x6b, 0x67, 0x6f,
0x6e, 0x67, 0x3b, 0x54, 0x6c, 0x68, 0x61, 0x6b, 0x6f, 0x6c, 0x65, 0x3b, 0x4d, 0x6f, 0x70, 0x69, 0x74, 0x6c, 0x6f, 0x3b,
0x4d, 0x6f, 0x72, 0x61, 0x6e, 0x61, 0x6e, 0x67, 0x3b, 0x4d, 0x6f, 0x74, 0x73, 0x68, 0x65, 0x67, 0x61, 0x6e, 0x61, 0x6e,
0x67, 0x3b, 0x53, 0x65, 0x65, 0x74, 0x65, 0x62, 0x6f, 0x73, 0x69, 0x67, 0x6f, 0x3b, 0x50, 0x68, 0x75, 0x6b, 0x77, 0x69,
0x3b, 0x50, 0x68, 0x61, 0x74, 0x77, 0x65, 0x3b, 0x4c, 0x77, 0x65, 0x74, 0x73, 0x65, 0x3b, 0x44, 0x69, 0x70, 0x68, 0x61,
0x6c, 0x61, 0x6e, 0x65, 0x3b, 0x4e, 0x67, 0x77, 0x61, 0x6e, 0x61, 0x74, 0x73, 0x65, 0x6c, 0x65, 0x3b, 0x53, 0x65, 0x64,
0x69, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6f, 0x6c, 0x65, 0x3b, 0x4e, 0x64, 0x69, 0x3b, 0x4b, 0x75, 0x6b, 0x3b, 0x4b, 0x75,
0x72, 0x3b, 0x4b, 0x75, 0x62, 0x3b, 0x43, 0x68, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x3b, 0x4e, 0x79,
0x61, 0x3b, 0x47, 0x75, 0x6e, 0x3b, 0x47, 0x75, 0x6d, 0x3b, 0x4d, 0x62, 0x3b, 0x5a, 0x76, 0x69, 0x3b, 0x4e, 0x64, 0x69,
0x72, 0x61, 0x3b, 0x4b, 0x75, 0x6b, 0x61, 0x64, 0x7a, 0x69, 0x3b, 0x4b, 0x75, 0x72, 0x75, 0x6d, 0x65, 0x3b, 0x4b, 0x75,
0x62, 0x76, 0x75, 0x6d, 0x62, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x76, 0x61, 0x62, 0x76, 0x75, 0x3b, 0x43, 0x68, 0x69, 0x6b,
0x75, 0x6d, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x6b, 0x75, 0x6e, 0x67, 0x75, 0x72, 0x75, 0x3b, 0x4e, 0x79, 0x61, 0x6d, 0x61,
0x76, 0x68, 0x75, 0x76, 0x68, 0x75, 0x3b, 0x47, 0x75, 0x6e, 0x79, 0x61, 0x6e, 0x61, 0x3b, 0x47, 0x75, 0x6d, 0x69, 0x67,
0x75, 0x72, 0x75, 0x3b, 0x4d, 0x62, 0x75, 0x64, 0x7a, 0x69, 0x3b, 0x5a, 0x76, 0x69, 0x74, 0x61, 0x3b, 0x4e, 0x3b, 0x4b,
0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x4e, 0x3b, 0x47, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x5a,
0x3b, 0xda2, 0xdb1, 0x3b, 0xdb4, 0xdd9, 0xdb6, 0x3b, 0xdb8, 0xdcf, 0xdbb, 0xdca, 0x3b, 0xd85, 0xdb4, 0xdca, 0x200d, 0xdbb, 0xdda, 0xdbd,
0xdca, 0x3b, 0xdb8, 0xdd0, 0xdba, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdb1, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdbd, 0xdd2, 0x3b, 0xd85, 0xd9c, 0xddd,
0x3b, 0xdc3, 0xdd0, 0xdb4, 0xdca, 0x3b, 0xd94, 0xd9a, 0xdca, 0x3b, 0xdb1, 0xddc, 0xdc0, 0xdd0, 0x3b, 0xdaf, 0xdd9, 0xdc3, 0xdd0, 0x3b,
0xda2, 0xdb1, 0xdc0, 0xdcf, 0xdbb, 0xdd2, 0x3b, 0xdb4, 0xdd9, 0xdb6, 0xdbb, 0xdc0, 0xdcf, 0xdbb, 0xdd2, 0x3b, 0xdb8, 0xdcf, 0xdbb, 0xdca,
0xdad, 0xdd4, 0x3b, 0xd85, 0xdb4, 0xdca, 0x200d, 0xdbb, 0xdda, 0xdbd, 0xdca, 0x3b, 0xdb8, 0xdd0, 0xdba, 0xdd2, 0x3b, 0xda2, 0xdd6, 0xdb1,
0xdd2, 0x3b, 0xda2, 0xdd6, 0xdbd, 0xdd2, 0x3b, 0xd85, 0xd9c, 0xddd, 0xdc3, 0xdca, 0xdad, 0xdd4, 0x3b, 0xdc3, 0xdd0, 0xdb4, 0xdca, 0xdad,
0xdd0, 0xdb8, 0xdca, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xd94, 0xd9a, 0xdca, 0xdad, 0xddd, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xdb1, 0xddc, 0xdc0, 0xdd0,
0xdb8, 0xdca, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xdaf, 0xdd9, 0xdc3, 0xdd0, 0xdb8, 0xdca, 0xdb6, 0xdbb, 0xdca, 0x3b, 0xda2, 0x3b, 0xdb4, 0xdd9,
0x3b, 0xdb8, 0xdcf, 0x3b, 0xd85, 0x3b, 0xdb8, 0xdd0, 0x3b, 0xda2, 0xdd6, 0x3b, 0xda2, 0xdd6, 0x3b, 0xd85, 0x3b, 0xdc3, 0xdd0, 0x3b,
0xd94, 0x3b, 0xdb1, 0xddc, 0x3b, 0xdaf, 0xdd9, 0x3b, 0x42, 0x68, 0x69, 0x3b, 0x56, 0x61, 0x6e, 0x3b, 0x56, 0x6f, 0x6c, 0x3b,
0x4d, 0x61, 0x62, 0x3b, 0x4e, 0x6b, 0x68, 0x3b, 0x4e, 0x68, 0x6c, 0x3b, 0x4b, 0x68, 0x6f, 0x3b, 0x4e, 0x67, 0x63, 0x3b,
0x4e, 0x79, 0x6f, 0x3b, 0x4d, 0x70, 0x68, 0x3b, 0x4c, 0x77, 0x65, 0x3b, 0x4e, 0x67, 0x6f, 0x3b, 0x42, 0x68, 0x69, 0x6d,
0x62, 0x69, 0x64, 0x76, 0x77, 0x61, 0x6e, 0x65, 0x3b, 0x69, 0x4e, 0x64, 0x6c, 0x6f, 0x76, 0x61, 0x6e, 0x61, 0x3b, 0x69,
0x4e, 0x64, 0x6c, 0x6f, 0x76, 0x75, 0x2d, 0x6c, 0x65, 0x6e, 0x6b, 0x68, 0x75, 0x6c, 0x75, 0x3b, 0x4d, 0x61, 0x62, 0x61,
0x73, 0x61, 0x3b, 0x69, 0x4e, 0x6b, 0x68, 0x77, 0x65, 0x6b, 0x68, 0x77, 0x65, 0x74, 0x69, 0x3b, 0x69, 0x4e, 0x68, 0x6c,
0x61, 0x62, 0x61, 0x3b, 0x4b, 0x68, 0x6f, 0x6c, 0x77, 0x61, 0x6e, 0x65, 0x3b, 0x69, 0x4e, 0x67, 0x63, 0x69, 0x3b, 0x69,
0x4e, 0x79, 0x6f, 0x6e, 0x69, 0x3b, 0x69, 0x4d, 0x70, 0x68, 0x61, 0x6c, 0x61, 0x3b, 0x4c, 0x77, 0x65, 0x74, 0x69, 0x3b,
0x69, 0x4e, 0x67, 0x6f, 0x6e, 0x67, 0x6f, 0x6e, 0x69, 0x3b, 0x6a, 0x61, 0x6e, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61,
0x72, 0x3b, 0x61, 0x70, 0x72, 0x3b, 0x6d, 0xe1, 0x6a, 0x3b, 0x6a, 0xfa, 0x6e, 0x3b, 0x6a, 0xfa, 0x6c, 0x3b, 0x61, 0x75,
0x67, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x65, 0x63, 0x3b, 0x6a, 0x61,
0x6e, 0x75, 0xe1, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0xe1, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x65, 0x63, 0x3b, 0x61,
0x70, 0x72, 0xed, 0x6c, 0x3b, 0x6d, 0xe1, 0x6a, 0x3b, 0x6a, 0xfa, 0x6e, 0x3b, 0x6a, 0xfa, 0x6c, 0x3b, 0x61, 0x75, 0x67,
0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0xf3, 0x62, 0x65,
0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x65, 0x63,
0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6a, 0x3b, 0x6a, 0x75, 0x6c,
0x69, 0x6a, 0x3b, 0x61, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b,
0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65, 0x63,
0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4b, 0x6f, 0x62, 0x3b, 0x4c, 0x61, 0x62, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x41, 0x66,
0x72, 0x3b, 0x53, 0x68, 0x61, 0x3b, 0x4c, 0x69, 0x78, 0x3b, 0x54, 0x6f, 0x64, 0x3b, 0x53, 0x69, 0x64, 0x3b, 0x53, 0x61,
0x67, 0x3b, 0x54, 0x6f, 0x62, 0x3b, 0x4b, 0x49, 0x54, 0x3b, 0x4c, 0x49, 0x54, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20,
0x4b, 0x6f, 0x6f, 0x62, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4c, 0x61, 0x62, 0x61, 0x61, 0x64,
0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x53, 0x61, 0x64, 0x64, 0x65, 0x78, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73,
0x68, 0x61, 0x20, 0x41, 0x66, 0x72, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x53, 0x68, 0x61, 0x6e,
0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4c, 0x69, 0x78, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73,
0x68, 0x61, 0x20, 0x54, 0x6f, 0x64, 0x6f, 0x62, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x53, 0x69,
0x64, 0x65, 0x65, 0x64, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x53, 0x61, 0x67, 0x61, 0x61, 0x6c,
0x61, 0x61, 0x64, 0x3b, 0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x54, 0x6f, 0x62, 0x6e, 0x61, 0x61, 0x64, 0x3b, 0x42, 0x69,
0x73, 0x68, 0x61, 0x20, 0x4b, 0x6f, 0x77, 0x20, 0x69, 0x79, 0x6f, 0x20, 0x54, 0x6f, 0x62, 0x6e, 0x61, 0x61, 0x64, 0x3b,
0x42, 0x69, 0x73, 0x68, 0x61, 0x20, 0x4c, 0x61, 0x62, 0x61, 0x20, 0x69, 0x79, 0x6f, 0x20, 0x54, 0x6f, 0x62, 0x6e, 0x61,
0x61, 0x64, 0x3b, 0x4b, 0x3b, 0x4c, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x53,
0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4c, 0x3b, 0x65, 0x6e, 0x65, 0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61,
0x62, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x6f, 0x3b, 0x6a, 0x75, 0x6e, 0x3b, 0x6a, 0x75, 0x6c, 0x3b, 0x61, 0x67, 0x6f, 0x3b,
0x73, 0x65, 0x70, 0x3b, 0x6f, 0x63, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b, 0x64, 0x69, 0x63, 0x3b, 0x65, 0x6e, 0x65, 0x72,
0x6f, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x3b, 0x61, 0x62, 0x72, 0x69,
0x6c, 0x3b, 0x6d, 0x61, 0x79, 0x6f, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x6f, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x6f, 0x3b, 0x61,
0x67, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x6f, 0x63, 0x74,
0x75, 0x62, 0x72, 0x65, 0x3b, 0x6e, 0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x64, 0x69, 0x63, 0x69, 0x65,
0x6d, 0x62, 0x72, 0x65, 0x3b, 0x45, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41,
0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63,
0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f,
0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e,
0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b,
0x41, 0x70, 0x72, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61,
0x69, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b,
0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x61,
0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x6d, 0x61,
0x72, 0x73, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75, 0x6e, 0x69, 0x3b, 0x6a, 0x75,
0x6c, 0x69, 0x3b, 0x61, 0x75, 0x67, 0x75, 0x73, 0x74, 0x69, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72,
0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x64, 0x65,
0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x45, 0x6e, 0x65, 0x3b, 0x50, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41,
0x62, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x48, 0x75, 0x6e, 0x3b, 0x48, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53,
0x65, 0x74, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x62, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x45, 0x6e, 0x65, 0x72, 0x6f,
0x3b, 0x50, 0x65, 0x62, 0x72, 0x65, 0x72, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c,
0x3b, 0x4d, 0x61, 0x79, 0x6f, 0x3b, 0x48, 0x75, 0x6e, 0x79, 0x6f, 0x3b, 0x48, 0x75, 0x6c, 0x79, 0x6f, 0x3b, 0x41, 0x67,
0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x79, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x4f, 0x6b, 0x74, 0x75, 0x62,
0x72, 0x65, 0x3b, 0x4e, 0x6f, 0x62, 0x79, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x3b, 0x44, 0x69, 0x73, 0x79, 0x65, 0x6d, 0x62,
0x72, 0x65, 0x3b, 0x45, 0x3b, 0x50, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x48, 0x3b, 0x41, 0x3b, 0x53,
0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x42f, 0x43d, 0x432, 0x3b, 0x424, 0x435, 0x432, 0x3b, 0x41c, 0x430, 0x440, 0x3b, 0x410,
0x43f, 0x440, 0x3b, 0x41c, 0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x3b, 0x418, 0x44e, 0x43b, 0x3b, 0x410, 0x432, 0x433, 0x3b, 0x421,
0x435, 0x43d, 0x3b, 0x41e, 0x43a, 0x442, 0x3b, 0x41d, 0x43e, 0x44f, 0x3b, 0x414, 0x435, 0x43a, 0x3b, 0x42f, 0x43d, 0x432, 0x430, 0x440,
0x3b, 0x424, 0x435, 0x432, 0x440, 0x430, 0x43b, 0x3b, 0x41c, 0x430, 0x440, 0x442, 0x3b, 0x410, 0x43f, 0x440, 0x435, 0x43b, 0x3b, 0x41c,
0x430, 0x439, 0x3b, 0x418, 0x44e, 0x43d, 0x3b, 0x418, 0x44e, 0x43b, 0x3b, 0x410, 0x432, 0x433, 0x443, 0x441, 0x442, 0x3b, 0x421, 0x435,
0x43d, 0x442, 0x44f, 0x431, 0x440, 0x3b, 0x41e, 0x43a, 0x442, 0x44f, 0x431, 0x440, 0x3b, 0x41d, 0x43e, 0x44f, 0x431, 0x440, 0x3b, 0x414,
0x435, 0x43a, 0x430, 0x431, 0x440, 0x3b, 0xb9c, 0xba9, 0x2e, 0x3b, 0xbaa, 0xbbf, 0xbaa, 0xbcd, 0x2e, 0x3b, 0xbae, 0xbbe, 0xbb0, 0xbcd,
0x2e, 0x3b, 0xb8f, 0xbaa, 0xbcd, 0x2e, 0x3b, 0xbae, 0xbc7, 0x3b, 0xb9c, 0xbc2, 0xba9, 0xbcd, 0x3b, 0xb9c, 0xbc2, 0xbb2, 0xbc8, 0x3b,
0xb86, 0xb95, 0x2e, 0x3b, 0xb9a, 0xbc6, 0xbaa, 0xbcd, 0x2e, 0x3b, 0xb85, 0xb95, 0xbcd, 0x2e, 0x3b, 0xba8, 0xbb5, 0x2e, 0x3b, 0xb9f,
0xbbf, 0xb9a, 0x2e, 0x3b, 0xb9c, 0xba9, 0xbb5, 0xbb0, 0xbbf, 0x3b, 0xbaa, 0xbbf, 0xbaa, 0xbcd, 0xbb0, 0xbb5, 0xbb0, 0xbbf, 0x3b, 0xbae,
0xbbe, 0xbb0, 0xbcd, 0xb9a, 0xbcd, 0x3b, 0xb8f, 0xbaa, 0xbcd, 0xbb0, 0xbb2, 0xbcd, 0x3b, 0xbae, 0xbc7, 0x3b, 0xb9c, 0xbc2, 0xba9, 0xbcd,
0x3b, 0xb9c, 0xbc2, 0xbb2, 0xbc8, 0x3b, 0xb86, 0xb95, 0xbb8, 0xbcd, 0xb9f, 0xbc1, 0x3b, 0xb9a, 0xbc6, 0xbaa, 0xbcd, 0xb9f, 0xbae, 0xbcd,
0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb85, 0xb95, 0xbcd, 0xb9f, 0xbcb, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xba8, 0xbb5, 0xbae, 0xbcd, 0xbaa, 0xbb0, 0xbcd,
0x3b, 0xb9f, 0xbbf, 0xb9a, 0xbae, 0xbcd, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xb9c, 0x3b, 0xbaa, 0xbbf, 0x3b, 0xbae, 0xbbe, 0x3b, 0xb8f, 0x3b,
0xbae, 0xbc7, 0x3b, 0xb9c, 0xbc2, 0x3b, 0xb9c, 0xbc2, 0x3b, 0xb86, 0x3b, 0xb9a, 0xbc6, 0x3b, 0xb85, 0x3b, 0xba8, 0x3b, 0xb9f, 0xbbf,
0x3b, 0xc1c, 0xc28, 0x3b, 0xc2b, 0xc3f, 0xc2c, 0xc4d, 0xc30, 0x3b, 0xc2e, 0xc3e, 0xc30, 0xc4d, 0xc1a, 0xc3f, 0x3b, 0xc0f, 0xc2a, 0xc4d,
0xc30, 0xc3f, 0x3b, 0xc2e, 0xc47, 0x3b, 0xc1c, 0xc42, 0xc28, 0xc4d, 0x3b, 0xc1c, 0xc42, 0xc32, 0xc48, 0x3b, 0xc06, 0xc17, 0xc38, 0xc4d,
0xc1f, 0xc41, 0x3b, 0xc38, 0xc46, 0xc2a, 0xc4d, 0xc1f, 0xc46, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc05, 0xc15, 0xc4d, 0xc1f, 0xc4b, 0xc2c,
0xc30, 0xc4d, 0x3b, 0xc28, 0xc35, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc21, 0xc3f, 0xc38, 0xc46, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc1c,
0xc28, 0xc35, 0xc30, 0xc3f, 0x3b, 0xc2b, 0xc3f, 0xc2c, 0xc4d, 0xc30, 0xc35, 0xc30, 0xc3f, 0x3b, 0xc2e, 0xc3e, 0xc30, 0xc4d, 0xc1a, 0xc3f,
0x3b, 0xc0e, 0xc2a, 0xc4d, 0xc30, 0xc3f, 0xc32, 0xc4d, 0x3b, 0xc2e, 0xc47, 0x3b, 0xc1c, 0xc42, 0xc28, 0xc4d, 0x3b, 0xc1c, 0xc42, 0xc32,
0xc48, 0x3b, 0xc06, 0xc17, 0xc38, 0xc4d, 0xc1f, 0xc41, 0x3b, 0xc38, 0xc46, 0xc2a, 0xc4d, 0xc1f, 0xc46, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b,
0xc05, 0xc15, 0xc4d, 0xc1f, 0xc4b, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc28, 0xc35, 0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc21, 0xc3f, 0xc38, 0xc46,
0xc02, 0xc2c, 0xc30, 0xc4d, 0x3b, 0xc1c, 0x3b, 0xc2b, 0xc3f, 0x3b, 0xc2e, 0x3b, 0xc0e, 0x3b, 0xc2e, 0xc46, 0x3b, 0xc1c, 0xc41, 0x3b,
0xc1c, 0xc41, 0x3b, 0xc06, 0x3b, 0xc38, 0xc46, 0x3b, 0xc05, 0x3b, 0xc28, 0x3b, 0xc21, 0xc3f, 0x3b, 0xe21, 0x2e, 0xe04, 0x2e, 0x3b,
0xe01, 0x2e, 0xe1e, 0x2e, 0x3b, 0xe21, 0xe35, 0x2e, 0xe04, 0x2e, 0x3b, 0xe40, 0xe21, 0x2e, 0xe22, 0x2e, 0x3b, 0xe1e, 0x2e, 0xe04,
0x2e, 0x3b, 0xe21, 0xe34, 0x2e, 0xe22, 0x2e, 0x3b, 0xe01, 0x2e, 0xe04, 0x2e, 0x3b, 0xe2a, 0x2e, 0xe04, 0x2e, 0x3b, 0xe01, 0x2e,
0xe22, 0x2e, 0x3b, 0xe15, 0x2e, 0xe04, 0x2e, 0x3b, 0xe1e, 0x2e, 0xe22, 0x2e, 0x3b, 0xe18, 0x2e, 0xe04, 0x2e, 0x3b, 0xe21, 0xe01,
0xe23, 0xe32, 0xe04, 0xe21, 0x3b, 0xe01, 0xe38, 0xe21, 0xe20, 0xe32, 0xe1e, 0xe31, 0xe19, 0xe18, 0xe4c, 0x3b, 0xe21, 0xe35, 0xe19, 0xe32,
0xe04, 0xe21, 0x3b, 0xe40, 0xe21, 0xe29, 0xe32, 0xe22, 0xe19, 0x3b, 0xe1e, 0xe24, 0xe29, 0xe20, 0xe32, 0xe04, 0xe21, 0x3b, 0xe21, 0xe34,
0xe16, 0xe38, 0xe19, 0xe32, 0xe22, 0xe19, 0x3b, 0xe01, 0xe23, 0xe01, 0xe0e, 0xe32, 0xe04, 0xe21, 0x3b, 0xe2a, 0xe34, 0xe07, 0xe2b, 0xe32,
0xe04, 0xe21, 0x3b, 0xe01, 0xe31, 0xe19, 0xe22, 0xe32, 0xe22, 0xe19, 0x3b, 0xe15, 0xe38, 0xe25, 0xe32, 0xe04, 0xe21, 0x3b, 0xe1e, 0xe24,
0xe28, 0xe08, 0xe34, 0xe01, 0xe32, 0xe22, 0xe19, 0x3b, 0xe18, 0xe31, 0xe19, 0xe27, 0xe32, 0xe04, 0xe21, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21,
0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf22, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf23, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf24, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf25,
0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf26, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf27, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf28, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf29,
0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0xf20, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0xf21, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf21, 0xf22, 0x3b, 0xf5f,
0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xf44, 0xf0b, 0xf54, 0xf7c, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66,
0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf66, 0xf74, 0xf58, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56,
0xf0b, 0xf56, 0xf5e, 0xf72, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf63, 0xf94, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f,
0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xfb2, 0xf74, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf51, 0xf74,
0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf62, 0xf92, 0xfb1, 0xf51, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f,
0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf51, 0xf42, 0xf74, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b,
0xf54, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf45, 0xf72, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0xf56, 0xf45, 0xf74, 0xf0b, 0xf42, 0xf49, 0xf72, 0xf66, 0xf0b, 0xf54, 0xf0b, 0x3b, 0x1325, 0x122a, 0x3b,
0x1208, 0x12ab, 0x1272, 0x3b, 0x1218, 0x130b, 0x1262, 0x3b, 0x121a, 0x12eb, 0x12dd, 0x3b, 0x130d, 0x1295, 0x1266, 0x3b, 0x1230, 0x1290, 0x3b, 0x1213,
0x121d, 0x1208, 0x3b, 0x1290, 0x1213, 0x1230, 0x3b, 0x1218, 0x1235, 0x12a8, 0x3b, 0x1325, 0x1245, 0x121d, 0x3b, 0x1215, 0x12f3, 0x122d, 0x3b, 0x1273,
0x1215, 0x1233, 0x3b, 0x1325, 0x122a, 0x3b, 0x1208, 0x12ab, 0x1272, 0x1275, 0x3b, 0x1218, 0x130b, 0x1262, 0x1275, 0x3b, 0x121a, 0x12eb, 0x12dd, 0x12eb,
0x3b, 0x130d, 0x1295, 0x1266, 0x1275, 0x3b, 0x1230, 0x1290, 0x3b, 0x1213, 0x121d, 0x1208, 0x3b, 0x1290, 0x1213, 0x1230, 0x3b, 0x1218, 0x1235, 0x12a8,
0x1228, 0x121d, 0x3b, 0x1325, 0x1245, 0x121d, 0x1272, 0x3b, 0x1215, 0x12f3, 0x122d, 0x3b, 0x1273, 0x1215, 0x1233, 0x1235, 0x3b, 0x53, 0x101, 0x6e,
0x3b, 0x46, 0x113, 0x70, 0x3b, 0x4d, 0x61, 0x2bb, 0x61, 0x3b, 0x2bb, 0x45, 0x70, 0x65, 0x3b, 0x4d, 0x113, 0x3b, 0x53, 0x75,
0x6e, 0x3b, 0x53, 0x69, 0x75, 0x3b, 0x2bb, 0x41, 0x6f, 0x6b, 0x3b, 0x53, 0x113, 0x70, 0x3b, 0x2bb, 0x4f, 0x6b, 0x61, 0x3b,
0x4e, 0x14d, 0x76, 0x3b, 0x54, 0x12b, 0x73, 0x3b, 0x53, 0x101, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x46, 0x113, 0x70, 0x75,
0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x2bb, 0x61, 0x73, 0x69, 0x3b, 0x2bb, 0x45, 0x70, 0x65, 0x6c, 0x65, 0x6c, 0x69, 0x3b,
0x4d, 0x113, 0x3b, 0x53, 0x75, 0x6e, 0x65, 0x3b, 0x53, 0x69, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x2bb, 0x41, 0x6f, 0x6b, 0x6f,
0x73, 0x69, 0x3b, 0x53, 0x113, 0x70, 0x69, 0x74, 0x65, 0x6d, 0x61, 0x3b, 0x2bb, 0x4f, 0x6b, 0x61, 0x74, 0x6f, 0x70, 0x61,
0x3b, 0x4e, 0x14d, 0x76, 0x65, 0x6d, 0x61, 0x3b, 0x54, 0x12b, 0x73, 0x65, 0x6d, 0x61, 0x3b, 0x53, 0x3b, 0x46, 0x3b, 0x4d,
0x3b, 0x45, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x53,
0x75, 0x6e, 0x3b, 0x59, 0x61, 0x6e, 0x3b, 0x4b, 0x75, 0x6c, 0x3b, 0x44, 0x7a, 0x69, 0x3b, 0x4d, 0x75, 0x64, 0x3b, 0x4b,
0x68, 0x6f, 0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x4d, 0x68, 0x61, 0x3b, 0x4e, 0x64, 0x7a, 0x3b, 0x4e, 0x68, 0x6c, 0x3b, 0x48,
0x75, 0x6b, 0x3b, 0x4e, 0x27, 0x77, 0x3b, 0x53, 0x75, 0x6e, 0x67, 0x75, 0x74, 0x69, 0x3b, 0x4e, 0x79, 0x65, 0x6e, 0x79,
0x65, 0x6e, 0x79, 0x61, 0x6e, 0x69, 0x3b, 0x4e, 0x79, 0x65, 0x6e, 0x79, 0x61, 0x6e, 0x6b, 0x75, 0x6c, 0x75, 0x3b, 0x44,
0x7a, 0x69, 0x76, 0x61, 0x6d, 0x69, 0x73, 0x6f, 0x6b, 0x6f, 0x3b, 0x4d, 0x75, 0x64, 0x79, 0x61, 0x78, 0x69, 0x68, 0x69,
0x3b, 0x4b, 0x68, 0x6f, 0x74, 0x61, 0x76, 0x75, 0x78, 0x69, 0x6b, 0x61, 0x3b, 0x4d, 0x61, 0x77, 0x75, 0x77, 0x61, 0x6e,
0x69, 0x3b, 0x4d, 0x68, 0x61, 0x77, 0x75, 0x72, 0x69, 0x3b, 0x4e, 0x64, 0x7a, 0x68, 0x61, 0x74, 0x69, 0x3b, 0x4e, 0x68,
0x6c, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x61, 0x3b, 0x48, 0x75, 0x6b, 0x75, 0x72, 0x69, 0x3b, 0x4e, 0x27, 0x77, 0x65, 0x6e,
0x64, 0x7a, 0x61, 0x6d, 0x68, 0x61, 0x6c, 0x61, 0x3b, 0x4f, 0x63, 0x61, 0x3b, 0x15e, 0x75, 0x62, 0x3b, 0x4d, 0x61, 0x72,
0x3b, 0x4e, 0x69, 0x73, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x48, 0x61, 0x7a, 0x3b, 0x54, 0x65, 0x6d, 0x3b, 0x41, 0x11f, 0x75,
0x3b, 0x45, 0x79, 0x6c, 0x3b, 0x45, 0x6b, 0x69, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x41, 0x72, 0x61, 0x3b, 0x4f, 0x63, 0x61,
0x6b, 0x3b, 0x15e, 0x75, 0x62, 0x61, 0x74, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x3b, 0x4e, 0x69, 0x73, 0x61, 0x6e, 0x3b, 0x4d,
0x61, 0x79, 0x131, 0x73, 0x3b, 0x48, 0x61, 0x7a, 0x69, 0x72, 0x61, 0x6e, 0x3b, 0x54, 0x65, 0x6d, 0x6d, 0x75, 0x7a, 0x3b,
0x41, 0x11f, 0x75, 0x73, 0x74, 0x6f, 0x73, 0x3b, 0x45, 0x79, 0x6c, 0xfc, 0x6c, 0x3b, 0x45, 0x6b, 0x69, 0x6d, 0x3b, 0x4b,
0x61, 0x73, 0x131, 0x6d, 0x3b, 0x41, 0x72, 0x61, 0x6c, 0x131, 0x6b, 0x3b, 0x4f, 0x3b, 0x15e, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b,
0x4d, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x45, 0x3b, 0x45, 0x3b, 0x4b, 0x3b, 0x41, 0x3b, 0x421, 0x456, 0x447, 0x3b,
0x41b, 0x44e, 0x442, 0x3b, 0x411, 0x435, 0x440, 0x3b, 0x41a, 0x432, 0x456, 0x3b, 0x422, 0x440, 0x430, 0x3b, 0x427, 0x435, 0x440, 0x3b,
0x41b, 0x438, 0x43f, 0x3b, 0x421, 0x435, 0x440, 0x3b, 0x412, 0x435, 0x440, 0x3b, 0x416, 0x43e, 0x432, 0x3b, 0x41b, 0x438, 0x441, 0x3b,
0x413, 0x440, 0x443, 0x3b, 0x421, 0x456, 0x447, 0x435, 0x43d, 0x44c, 0x3b, 0x41b, 0x44e, 0x442, 0x438, 0x439, 0x3b, 0x411, 0x435, 0x440,
0x435, 0x437, 0x435, 0x43d, 0x44c, 0x3b, 0x41a, 0x432, 0x456, 0x442, 0x435, 0x43d, 0x44c, 0x3b, 0x422, 0x440, 0x430, 0x432, 0x435, 0x43d,
0x44c, 0x3b, 0x427, 0x435, 0x440, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x41b, 0x438, 0x43f, 0x435, 0x43d, 0x44c, 0x3b, 0x421, 0x435, 0x440,
0x43f, 0x435, 0x43d, 0x44c, 0x3b, 0x412, 0x435, 0x440, 0x435, 0x441, 0x435, 0x43d, 0x44c, 0x3b, 0x416, 0x43e, 0x432, 0x442, 0x435, 0x43d,
0x44c, 0x3b, 0x41b, 0x438, 0x441, 0x442, 0x43e, 0x43f, 0x430, 0x434, 0x3b, 0x413, 0x440, 0x443, 0x434, 0x435, 0x43d, 0x44c, 0x3b, 0x421,
0x3b, 0x41b, 0x3b, 0x411, 0x3b, 0x41a, 0x3b, 0x422, 0x3b, 0x427, 0x3b, 0x41b, 0x3b, 0x421, 0x3b, 0x412, 0x3b, 0x416, 0x3b, 0x41b,
0x3b, 0x413, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x6cc, 0x3b, 0x641, 0x631, 0x648, 0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x20, 0x686,
0x3b, 0x627, 0x67e, 0x631, 0x64a, 0x644, 0x3b, 0x645, 0x626, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x626, 0x3b,
0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x62a, 0x645, 0x628, 0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648,
0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631, 0x3b, 0x41c, 0x443, 0x4b3, 0x430, 0x440, 0x440, 0x430, 0x43c, 0x3b, 0x421,
0x430, 0x444, 0x430, 0x440, 0x3b, 0x420, 0x430, 0x431, 0x438, 0x443, 0x43b, 0x2d, 0x430, 0x432, 0x432, 0x430, 0x43b, 0x3b, 0x420, 0x430,
0x431, 0x438, 0x443, 0x43b, 0x2d, 0x43e, 0x445, 0x438, 0x440, 0x3b, 0x416, 0x443, 0x43c, 0x43e, 0x434, 0x438, 0x443, 0x43b, 0x2d, 0x443,
0x43b, 0x43e, 0x3b, 0x416, 0x443, 0x43c, 0x43e, 0x434, 0x438, 0x443, 0x43b, 0x2d, 0x443, 0x445, 0x440, 0x43e, 0x3b, 0x420, 0x430, 0x436,
0x430, 0x431, 0x3b, 0x428, 0x430, 0x44a, 0x431, 0x43e, 0x43d, 0x3b, 0x420, 0x430, 0x43c, 0x430, 0x437, 0x43e, 0x43d, 0x3b, 0x428, 0x430,
0x432, 0x432, 0x43e, 0x43b, 0x3b, 0x417, 0x438, 0x43b, 0x2d, 0x49b, 0x430, 0x44a, 0x434, 0x430, 0x3b, 0x417, 0x438, 0x43b, 0x2d, 0x4b3,
0x438, 0x436, 0x436, 0x430, 0x3b, 0x62c, 0x646, 0x648, 0x3b, 0x641, 0x628, 0x631, 0x3b, 0x645, 0x627, 0x631, 0x3b, 0x627, 0x67e, 0x631,
0x3b, 0x645, 0x640, 0x6cc, 0x3b, 0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x3b, 0x627, 0x6af, 0x633, 0x3b, 0x633, 0x67e, 0x62a,
0x3b, 0x627, 0x6a9, 0x62a, 0x3b, 0x646, 0x648, 0x645, 0x3b, 0x62f, 0x633, 0x645, 0x3b, 0x62c, 0x646, 0x648, 0x631, 0x6cc, 0x3b, 0x641,
0x628, 0x631, 0x648, 0x631, 0x6cc, 0x3b, 0x645, 0x627, 0x631, 0x686, 0x3b, 0x627, 0x67e, 0x631, 0x6cc, 0x644, 0x3b, 0x645, 0x6cc, 0x3b,
0x62c, 0x648, 0x646, 0x3b, 0x62c, 0x648, 0x644, 0x627, 0x6cc, 0x3b, 0x627, 0x6af, 0x633, 0x62a, 0x3b, 0x633, 0x67e, 0x62a, 0x645, 0x628,
0x631, 0x3b, 0x627, 0x6a9, 0x62a, 0x648, 0x628, 0x631, 0x3b, 0x646, 0x648, 0x645, 0x628, 0x631, 0x3b, 0x62f, 0x633, 0x645, 0x628, 0x631,
0x3b, 0x59, 0x61, 0x6e, 0x76, 0x3b, 0x46, 0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x61,
0x79, 0x3b, 0x49, 0x79, 0x75, 0x6e, 0x3b, 0x49, 0x79, 0x75, 0x6c, 0x3b, 0x41, 0x76, 0x67, 0x3b, 0x53, 0x65, 0x6e, 0x3b,
0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x79, 0x61, 0x3b, 0x44, 0x65, 0x6b, 0x3b, 0x59, 0x61, 0x6e, 0x76, 0x61, 0x72, 0x3b,
0x46, 0x65, 0x76, 0x72, 0x61, 0x6c, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x61,
0x79, 0x3b, 0x49, 0x79, 0x75, 0x6e, 0x3b, 0x49, 0x79, 0x75, 0x6c, 0x3b, 0x41, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x53,
0x65, 0x6e, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x79, 0x61, 0x62, 0x72, 0x3b, 0x4e, 0x6f, 0x79, 0x61,
0x62, 0x72, 0x3b, 0x44, 0x65, 0x6b, 0x61, 0x62, 0x72, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b,
0x49, 0x3b, 0x49, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31, 0x3b,
0x74, 0x68, 0x67, 0x20, 0x32, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x33, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x34, 0x3b, 0x74, 0x68,
0x67, 0x20, 0x35, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x36, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x37, 0x3b, 0x74, 0x68, 0x67, 0x20,
0x38, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x39, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31, 0x30, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31,
0x31, 0x3b, 0x74, 0x68, 0x67, 0x20, 0x31, 0x32, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x6d, 0x1ed9, 0x74, 0x3b, 0x74,
0x68, 0xe1, 0x6e, 0x67, 0x20, 0x68, 0x61, 0x69, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x62, 0x61, 0x3b, 0x74, 0x68,
0xe1, 0x6e, 0x67, 0x20, 0x74, 0x1b0, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x6e, 0x103, 0x6d, 0x3b, 0x74, 0x68, 0xe1,
0x6e, 0x67, 0x20, 0x73, 0xe1, 0x75, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x62, 0x1ea3, 0x79, 0x3b, 0x74, 0x68, 0xe1,
0x6e, 0x67, 0x20, 0x74, 0xe1, 0x6d, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x63, 0x68, 0xed, 0x6e, 0x3b, 0x74, 0x68,
0xe1, 0x6e, 0x67, 0x20, 0x6d, 0x1b0, 0x1edd, 0x69, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x6d, 0x1b0, 0x1edd, 0x69, 0x20,
0x6d, 0x1ed9, 0x74, 0x3b, 0x74, 0x68, 0xe1, 0x6e, 0x67, 0x20, 0x6d, 0x1b0, 0x1edd, 0x69, 0x20, 0x68, 0x61, 0x69, 0x3b, 0x49,
0x6f, 0x6e, 0x3b, 0x43, 0x68, 0x77, 0x65, 0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x45, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b,
0x4d, 0x65, 0x68, 0x3b, 0x47, 0x6f, 0x72, 0x3b, 0x41, 0x77, 0x73, 0x74, 0x3b, 0x4d, 0x65, 0x64, 0x69, 0x3b, 0x48, 0x79,
0x64, 0x3b, 0x54, 0x61, 0x63, 0x68, 0x3b, 0x52, 0x68, 0x61, 0x67, 0x3b, 0x49, 0x6f, 0x6e, 0x61, 0x77, 0x72, 0x3b, 0x43,
0x68, 0x77, 0x65, 0x66, 0x72, 0x6f, 0x72, 0x3b, 0x4d, 0x61, 0x77, 0x72, 0x74, 0x68, 0x3b, 0x45, 0x62, 0x72, 0x69, 0x6c,
0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4d, 0x65, 0x68, 0x65, 0x66, 0x69, 0x6e, 0x3b, 0x47, 0x6f, 0x72, 0x66, 0x66, 0x65,
0x6e, 0x6e, 0x61, 0x66, 0x3b, 0x41, 0x77, 0x73, 0x74, 0x3b, 0x4d, 0x65, 0x64, 0x69, 0x3b, 0x48, 0x79, 0x64, 0x72, 0x65,
0x66, 0x3b, 0x54, 0x61, 0x63, 0x68, 0x77, 0x65, 0x64, 0x64, 0x3b, 0x52, 0x68, 0x61, 0x67, 0x66, 0x79, 0x72, 0x3b, 0x49,
0x3b, 0x43, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x54,
0x3b, 0x52, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x74, 0x3b, 0x45, 0x70, 0x72, 0x3b, 0x4d,
0x65, 0x79, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f,
0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x79, 0x75, 0x77, 0x61, 0x72, 0x69,
0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x77, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x74, 0x73, 0x68, 0x69, 0x3b, 0x45, 0x70,
0x72, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x65, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x79,
0x69, 0x3b, 0x41, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b,
0x74, 0x68, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62,
0x61, 0x3b, 0x1e62, 0x1eb9, 0x301, 0x72, 0x1eb9, 0x301, 0x3b, 0xc8, 0x72, 0xe8, 0x6c, 0xe8, 0x3b, 0x1eb8, 0x72, 0x1eb9, 0x300, 0x6e,
0xe0, 0x3b, 0xcc, 0x67, 0x62, 0xe9, 0x3b, 0x1eb8, 0x300, 0x62, 0x69, 0x62, 0x69, 0x3b, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b,
0x41, 0x67, 0x1eb9, 0x6d, 0x1ecd, 0x3b, 0xd2, 0x67, 0xfa, 0x6e, 0x3b, 0x4f, 0x77, 0x65, 0x77, 0x65, 0x3b, 0x1ecc, 0x300, 0x77,
0xe0, 0x72, 0xe0, 0x3b, 0x42, 0xe9, 0x6c, 0xfa, 0x3b, 0x1ecc, 0x300, 0x70, 0x1eb9, 0x300, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1e62,
0x1eb9, 0x301, 0x72, 0x1eb9, 0x301, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xc8, 0x72, 0xe8, 0x6c, 0xe8, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20,
0x1eb8, 0x72, 0x1eb9, 0x300, 0x6e, 0xe0, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xcc, 0x67, 0x62, 0xe9, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20,
0x1eb8, 0x300, 0x62, 0x69, 0x62, 0x69, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xd2, 0x6b, 0xfa, 0x64, 0x75, 0x3b, 0x4f, 0x1e63, 0xf9,
0x20, 0x41, 0x67, 0x1eb9, 0x6d, 0x1ecd, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0xd2, 0x67, 0xfa, 0x6e, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20,
0x4f, 0x77, 0x65, 0x77, 0x65, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1ecc, 0x300, 0x77, 0xe0, 0x72, 0xe0, 0x3b, 0x4f, 0x1e63, 0xf9,
0x20, 0x42, 0xe9, 0x6c, 0xfa, 0x3b, 0x4f, 0x1e63, 0xf9, 0x20, 0x1ecc, 0x300, 0x70, 0x1eb9, 0x300, 0x3b, 0x4a, 0x61, 0x6e, 0x3b,
0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x73, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x79, 0x3b, 0x4a, 0x75, 0x6e, 0x3b,
0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b,
0x44, 0x69, 0x73, 0x3b, 0x75, 0x4a, 0x61, 0x6e, 0x75, 0x77, 0x61, 0x72, 0x69, 0x3b, 0x75, 0x46, 0x65, 0x62, 0x72, 0x75,
0x77, 0x61, 0x72, 0x69, 0x3b, 0x75, 0x4d, 0x61, 0x73, 0x68, 0x69, 0x3b, 0x75, 0x2d, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x69,
0x3b, 0x75, 0x4d, 0x65, 0x79, 0x69, 0x3b, 0x75, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x75, 0x4a, 0x75, 0x6c, 0x61, 0x79, 0x69,
0x3b, 0x75, 0x41, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x75, 0x53, 0x65, 0x70, 0x74, 0x68, 0x65, 0x6d, 0x62, 0x61, 0x3b,
0x75, 0x2d, 0x4f, 0x6b, 0x74, 0x68, 0x6f, 0x62, 0x61, 0x3b, 0x75, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x75,
0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x6a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x66, 0x65, 0x62, 0x72, 0x75,
0x61, 0x72, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x3b, 0x61, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6a, 0x75,
0x6e, 0x69, 0x3b, 0x6a, 0x75, 0x6c, 0x69, 0x3b, 0x61, 0x76, 0x67, 0x75, 0x73, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x65,
0x6d, 0x62, 0x61, 0x72, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x6e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61,
0x72, 0x3b, 0x64, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x4a, 0x2d, 0x67, 0x75, 0x65, 0x72, 0x3b, 0x54, 0x2d,
0x61, 0x72, 0x72, 0x65, 0x65, 0x3b, 0x4d, 0x61, 0x79, 0x72, 0x6e, 0x74, 0x3b, 0x41, 0x76, 0x72, 0x72, 0x69, 0x6c, 0x3b,
0x42, 0x6f, 0x61, 0x6c, 0x64, 0x79, 0x6e, 0x3b, 0x4d, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x4a, 0x2d, 0x73,
0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x4c, 0x75, 0x61, 0x6e, 0x69, 0x73, 0x74, 0x79, 0x6e, 0x3b, 0x4d, 0x2d, 0x66, 0x6f,
0x75, 0x79, 0x69, 0x72, 0x3b, 0x4a, 0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4d, 0x2e, 0x48, 0x6f, 0x75, 0x6e,
0x65, 0x79, 0x3b, 0x4d, 0x2e, 0x4e, 0x6f, 0x6c, 0x6c, 0x69, 0x63, 0x6b, 0x3b, 0x4a, 0x65, 0x72, 0x72, 0x65, 0x79, 0x2d,
0x67, 0x65, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x54, 0x6f, 0x73, 0x68, 0x69, 0x61, 0x67, 0x68, 0x74, 0x2d, 0x61, 0x72, 0x72,
0x65, 0x65, 0x3b, 0x4d, 0x61, 0x79, 0x72, 0x6e, 0x74, 0x3b, 0x41, 0x76, 0x65, 0x72, 0x69, 0x6c, 0x3b, 0x42, 0x6f, 0x61,
0x6c, 0x64, 0x79, 0x6e, 0x3b, 0x4d, 0x65, 0x61, 0x6e, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x4a, 0x65, 0x72,
0x72, 0x65, 0x79, 0x2d, 0x73, 0x6f, 0x75, 0x72, 0x65, 0x65, 0x3b, 0x4c, 0x75, 0x61, 0x6e, 0x69, 0x73, 0x74, 0x79, 0x6e,
0x3b, 0x4d, 0x65, 0x61, 0x6e, 0x2d, 0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4a, 0x65, 0x72, 0x72, 0x65, 0x79, 0x2d,
0x66, 0x6f, 0x75, 0x79, 0x69, 0x72, 0x3b, 0x4d, 0x65, 0x65, 0x20, 0x48, 0x6f, 0x75, 0x6e, 0x65, 0x79, 0x3b, 0x4d, 0x65,
0x65, 0x20, 0x6e, 0x79, 0x20, 0x4e, 0x6f, 0x6c, 0x6c, 0x69, 0x63, 0x6b, 0x3b, 0x47, 0x65, 0x6e, 0x3b, 0x57, 0x68, 0x65,
0x3b, 0x4d, 0x65, 0x72, 0x3b, 0x45, 0x62, 0x72, 0x3b, 0x4d, 0x65, 0x3b, 0x45, 0x66, 0x6e, 0x3b, 0x47, 0x6f, 0x72, 0x3b,
0x45, 0x73, 0x74, 0x3b, 0x47, 0x77, 0x6e, 0x3b, 0x48, 0x65, 0x64, 0x3b, 0x44, 0x75, 0x3b, 0x4b, 0x65, 0x76, 0x3b, 0x4d,
0x79, 0x73, 0x20, 0x47, 0x65, 0x6e, 0x76, 0x65, 0x72, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x57, 0x68, 0x65, 0x76, 0x72, 0x65,
0x6c, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x4d, 0x65, 0x72, 0x74, 0x68, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x45, 0x62, 0x72, 0x65,
0x6c, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x4d, 0x65, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x45, 0x66, 0x61, 0x6e, 0x3b, 0x4d, 0x79,
0x73, 0x20, 0x47, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x3b, 0x4d, 0x79, 0x65, 0x20, 0x45, 0x73, 0x74, 0x3b,
0x4d, 0x79, 0x73, 0x20, 0x47, 0x77, 0x79, 0x6e, 0x67, 0x61, 0x6c, 0x61, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x48, 0x65, 0x64,
0x72, 0x61, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x44, 0x75, 0x3b, 0x4d, 0x79, 0x73, 0x20, 0x4b, 0x65, 0x76, 0x61, 0x72, 0x64,
0x68, 0x75, 0x3b, 0x53, 0x2d, 0x186, 0x3b, 0x4b, 0x2d, 0x186, 0x3b, 0x45, 0x2d, 0x186, 0x3b, 0x45, 0x2d, 0x4f, 0x3b, 0x45,
0x2d, 0x4b, 0x3b, 0x4f, 0x2d, 0x41, 0x3b, 0x41, 0x2d, 0x4b, 0x3b, 0x44, 0x2d, 0x186, 0x3b, 0x46, 0x2d, 0x190, 0x3b, 0x186,
0x2d, 0x41, 0x3b, 0x186, 0x2d, 0x4f, 0x3b, 0x4d, 0x2d, 0x186, 0x3b, 0x53, 0x61, 0x6e, 0x64, 0x61, 0x2d, 0x186, 0x70, 0x25b,
0x70, 0x254, 0x6e, 0x3b, 0x4b, 0x77, 0x61, 0x6b, 0x77, 0x61, 0x72, 0x2d, 0x186, 0x67, 0x79, 0x65, 0x66, 0x75, 0x6f, 0x3b,
0x45, 0x62, 0x254, 0x77, 0x2d, 0x186, 0x62, 0x65, 0x6e, 0x65, 0x6d, 0x3b, 0x45, 0x62, 0x254, 0x62, 0x69, 0x72, 0x61, 0x2d,
0x4f, 0x66, 0x6f, 0x72, 0x69, 0x73, 0x75, 0x6f, 0x3b, 0x45, 0x73, 0x75, 0x73, 0x6f, 0x77, 0x20, 0x41, 0x6b, 0x65, 0x74,
0x73, 0x65, 0x61, 0x62, 0x61, 0x2d, 0x4b, 0x254, 0x74, 0x254, 0x6e, 0x69, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x62, 0x69, 0x72,
0x61, 0x64, 0x65, 0x2d, 0x41, 0x79, 0x25b, 0x77, 0x6f, 0x68, 0x6f, 0x6d, 0x75, 0x6d, 0x75, 0x3b, 0x41, 0x79, 0x25b, 0x77,
0x6f, 0x68, 0x6f, 0x2d, 0x4b, 0x69, 0x74, 0x61, 0x77, 0x6f, 0x6e, 0x73, 0x61, 0x3b, 0x44, 0x69, 0x66, 0x75, 0x75, 0x2d,
0x186, 0x73, 0x61, 0x6e, 0x64, 0x61, 0x61, 0x3b, 0x46, 0x61, 0x6e, 0x6b, 0x77, 0x61, 0x2d, 0x190, 0x62, 0x254, 0x3b, 0x186,
0x62, 0x25b, 0x73, 0x25b, 0x2d, 0x41, 0x68, 0x69, 0x6e, 0x69, 0x6d, 0x65, 0x3b, 0x186, 0x62, 0x65, 0x72, 0x25b, 0x66, 0x25b,
0x77, 0x2d, 0x4f, 0x62, 0x75, 0x62, 0x75, 0x6f, 0x3b, 0x4d, 0x75, 0x6d, 0x75, 0x2d, 0x186, 0x70, 0x25b, 0x6e, 0x69, 0x6d,
0x62, 0x61, 0x3b, 0x91c, 0x93e, 0x928, 0x947, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x935, 0x93e,
0x930, 0x940, 0x3b, 0x92e, 0x93e, 0x930, 0x94d, 0x91a, 0x3b, 0x90f, 0x92a, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c,
0x942, 0x928, 0x3b, 0x91c, 0x941, 0x932, 0x948, 0x3b, 0x913, 0x917, 0x938, 0x94d, 0x91f, 0x3b, 0x938, 0x947, 0x92a, 0x94d, 0x91f, 0x947,
0x902, 0x92c, 0x930, 0x3b, 0x913, 0x915, 0x94d, 0x91f, 0x94b, 0x92c, 0x930, 0x3b, 0x928, 0x94b, 0x935, 0x94d, 0x939, 0x947, 0x902, 0x92c,
0x930, 0x3b, 0x921, 0x93f, 0x938, 0x947, 0x902, 0x92c, 0x930, 0x3b, 0x41, 0x68, 0x61, 0x3b, 0x4f, 0x66, 0x6c, 0x3b, 0x4f, 0x63,
0x68, 0x3b, 0x41, 0x62, 0x65, 0x3b, 0x41, 0x67, 0x62, 0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4d, 0x61, 0x61, 0x3b, 0x4d, 0x61,
0x6e, 0x3b, 0x47, 0x62, 0x6f, 0x3b, 0x41, 0x6e, 0x74, 0x3b, 0x41, 0x6c, 0x65, 0x3b, 0x41, 0x66, 0x75, 0x3b, 0x41, 0x68,
0x61, 0x72, 0x61, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x4f, 0x66, 0x6c, 0x6f, 0x3b, 0x4f, 0x63, 0x68, 0x6f, 0x6b, 0x72, 0x69,
0x6b, 0x72, 0x69, 0x3b, 0x41, 0x62, 0x65, 0x69, 0x62, 0x65, 0x65, 0x3b, 0x41, 0x67, 0x62, 0x65, 0x69, 0x6e, 0x61, 0x61,
0x3b, 0x4f, 0x74, 0x75, 0x6b, 0x77, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x4d, 0x61, 0x61, 0x77, 0x65, 0x3b, 0x4d, 0x61, 0x6e,
0x79, 0x61, 0x77, 0x61, 0x6c, 0x65, 0x3b, 0x47, 0x62, 0x6f, 0x3b, 0x41, 0x6e, 0x74, 0x6f, 0x6e, 0x3b, 0x41, 0x6c, 0x65,
0x6d, 0x6c, 0x65, 0x3b, 0x41, 0x66, 0x75, 0x61, 0x62, 0x65, 0x65, 0x3b, 0x4a, 0x65, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b,
0x4d, 0x61, 0x61, 0x3b, 0x45, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x75, 0x3b, 0x4a, 0x75, 0x6c, 0x3b,
0x1ecc, 0x67, 0x1ecd, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x1ecc, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b,
0x4a, 0x65, 0x6e, 0x1ee5, 0x77, 0x61, 0x72, 0x1ecb, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x1ee5, 0x77, 0x61, 0x72, 0x1ecb, 0x3b, 0x4d,
0x61, 0x61, 0x63, 0x68, 0x1ecb, 0x3b, 0x45, 0x70, 0x72, 0x65, 0x6c, 0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x4a, 0x75, 0x75, 0x6e,
0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x1ecb, 0x3b, 0x1ecc, 0x67, 0x1ecd, 0x1ecd, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d,
0x62, 0x61, 0x3b, 0x1ecc, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69,
0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4d, 0x62, 0x65, 0x3b, 0x4b, 0x65, 0x6c, 0x3b, 0x4b, 0x74, 0x169, 0x3b, 0x4b, 0x61,
0x6e, 0x3b, 0x4b, 0x74, 0x6e, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x4d, 0x6f, 0x6f, 0x3b, 0x4e, 0x79, 0x61, 0x3b, 0x4b, 0x6e,
0x64, 0x3b, 0x128, 0x6b, 0x75, 0x3b, 0x128, 0x6b, 0x6d, 0x3b, 0x128, 0x6b, 0x6c, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77,
0x61, 0x20, 0x6d, 0x62, 0x65, 0x65, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6c, 0x129, 0x3b,
0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20,
0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61,
0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x74, 0x68, 0x61, 0x74, 0x169,
0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x75, 0x6f, 0x6e, 0x7a, 0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69,
0x20, 0x77, 0x61, 0x20, 0x6e, 0x79, 0x61, 0x61, 0x6e, 0x79, 0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20,
0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x129, 0x6b, 0x75, 0x6d, 0x69, 0x3b,
0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x129, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x129, 0x6d, 0x77,
0x65, 0x3b, 0x4d, 0x77, 0x61, 0x69, 0x20, 0x77, 0x61, 0x20, 0x129, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x69,
0x6c, 0x129, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4b,
0x3b, 0x128, 0x3b, 0x128, 0x3b, 0x128, 0x3b, 0x120d, 0x12f0, 0x1275, 0x3b, 0x12ab, 0x1265, 0x12bd, 0x3b, 0x12ad, 0x1265, 0x120b, 0x3b, 0x134b,
0x1305, 0x12ba, 0x3b, 0x12ad, 0x1262, 0x1245, 0x3b, 0x121d, 0x2f, 0x1275, 0x3b, 0x12b0, 0x122d, 0x3b, 0x121b, 0x122d, 0x12eb, 0x3b, 0x12eb, 0x12b8,
0x1292, 0x3b, 0x1218, 0x1270, 0x1209, 0x3b, 0x121d, 0x2f, 0x121d, 0x3b, 0x1270, 0x1215, 0x1233, 0x3b, 0x120d, 0x12f0, 0x1275, 0x122a, 0x3b, 0x12ab,
0x1265, 0x12bd, 0x1265, 0x1272, 0x3b, 0x12ad, 0x1265, 0x120b, 0x3b, 0x134b, 0x1305, 0x12ba, 0x122a, 0x3b, 0x12ad, 0x1262, 0x1245, 0x122a, 0x3b, 0x121d,
0x12aa, 0x12a4, 0x120d, 0x20, 0x1275, 0x131f, 0x1292, 0x122a, 0x3b, 0x12b0, 0x122d, 0x12a9, 0x3b, 0x121b, 0x122d, 0x12eb, 0x121d, 0x20, 0x1275, 0x122a,
0x3b, 0x12eb, 0x12b8, 0x1292, 0x20, 0x1218, 0x1233, 0x1245, 0x1208, 0x122a, 0x3b, 0x1218, 0x1270, 0x1209, 0x3b, 0x121d, 0x12aa, 0x12a4, 0x120d, 0x20,
0x1218, 0x123d, 0x12c8, 0x122a, 0x3b, 0x1270, 0x1215, 0x1233, 0x1235, 0x122a, 0x3b, 0x120d, 0x3b, 0x12ab, 0x3b, 0x12ad, 0x3b, 0x134b, 0x3b, 0x12ad,
0x3b, 0x121d, 0x3b, 0x12b0, 0x3b, 0x121b, 0x3b, 0x12eb, 0x3b, 0x1218, 0x3b, 0x121d, 0x3b, 0x1270, 0x3b, 0x44, 0x79, 0x6f, 0x6e, 0x3b,
0x42, 0x61, 0x61, 0x3b, 0x41, 0x74, 0x61, 0x74, 0x3b, 0x41, 0x6e, 0x61, 0x73, 0x3b, 0x41, 0x74, 0x79, 0x6f, 0x3b, 0x41,
0x63, 0x68, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x72, 0x3b, 0x41, 0x77, 0x75, 0x72, 0x3b, 0x53, 0x68, 0x61, 0x64, 0x3b, 0x53,
0x68, 0x61, 0x6b, 0x3b, 0x4e, 0x61, 0x62, 0x61, 0x3b, 0x4e, 0x61, 0x74, 0x61, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x44, 0x79,
0x6f, 0x6e, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x42, 0x61, 0x27, 0x61, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x41, 0x74, 0x61, 0x74,
0x3b, 0x50, 0x65, 0x6e, 0x20, 0x41, 0x6e, 0x61, 0x73, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x41, 0x74, 0x79, 0x6f, 0x6e, 0x3b,
0x50, 0x65, 0x6e, 0x20, 0x41, 0x63, 0x68, 0x69, 0x72, 0x69, 0x6d, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x41, 0x74, 0x61, 0x72,
0x69, 0x62, 0x61, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x41, 0x77, 0x75, 0x72, 0x72, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x53, 0x68,
0x61, 0x64, 0x6f, 0x6e, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x53, 0x68, 0x61, 0x6b, 0x75, 0x72, 0x3b, 0x50, 0x65, 0x6e, 0x20,
0x4b, 0x75, 0x72, 0x20, 0x4e, 0x61, 0x62, 0x61, 0x3b, 0x50, 0x65, 0x6e, 0x20, 0x4b, 0x75, 0x72, 0x20, 0x4e, 0x61, 0x74,
0x61, 0x74, 0x3b, 0x41, 0x331, 0x79, 0x72, 0x3b, 0x41, 0x331, 0x68, 0x77, 0x3b, 0x41, 0x331, 0x74, 0x61, 0x3b, 0x41, 0x331,
0x6e, 0x61, 0x3b, 0x41, 0x331, 0x70, 0x66, 0x3b, 0x41, 0x331, 0x6b, 0x69, 0x3b, 0x41, 0x331, 0x74, 0x79, 0x3b, 0x41, 0x331,
0x6e, 0x69, 0x3b, 0x41, 0x331, 0x6b, 0x75, 0x3b, 0x53, 0x77, 0x61, 0x3b, 0x53, 0x62, 0x79, 0x3b, 0x53, 0x62, 0x68, 0x3b,
0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x79, 0x72, 0x6e, 0x69, 0x67, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20,
0x41, 0x331, 0x68, 0x77, 0x61, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x74, 0x61, 0x74, 0x3b, 0x48, 0x79,
0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x6e, 0x61, 0x61, 0x69, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x70,
0x66, 0x77, 0x6f, 0x6e, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x6b, 0x69, 0x74, 0x61, 0x74, 0x3b, 0x48,
0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x74, 0x79, 0x69, 0x72, 0x69, 0x6e, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20,
0x41, 0x331, 0x6e, 0x69, 0x6e, 0x61, 0x69, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x41, 0x331, 0x6b, 0x75, 0x6d, 0x76,
0x69, 0x72, 0x69, 0x79, 0x69, 0x6e, 0x3b, 0x48, 0x79, 0x77, 0x61, 0x6e, 0x20, 0x53, 0x77, 0x61, 0x6b, 0x3b, 0x48, 0x79,
0x77, 0x61, 0x6e, 0x20, 0x53, 0x77, 0x61, 0x6b, 0x20, 0x42, 0x27, 0x61, 0x331, 0x79, 0x72, 0x6e, 0x69, 0x67, 0x3b, 0x48,
0x79, 0x77, 0x61, 0x6e, 0x20, 0x53, 0x77, 0x61, 0x6b, 0x20, 0x42, 0x27, 0x61, 0x331, 0x68, 0x77, 0x61, 0x3b, 0x5a, 0x65,
0x6e, 0x3b, 0x46, 0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x76, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75,
0x67, 0x3b, 0x4c, 0x75, 0x69, 0x3b, 0x41, 0x76, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4e, 0x6f,
0x76, 0x3b, 0x44, 0x69, 0x63, 0x3b, 0x5a, 0x65, 0x6e, 0xe2, 0x72, 0x3b, 0x46, 0x65, 0x76, 0x72, 0xe2, 0x72, 0x3b, 0x4d,
0x61, 0x72, 0xe7, 0x3b, 0x41, 0x76, 0x72, 0xee, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x67, 0x6e, 0x3b, 0x4c,
0x75, 0x69, 0x3b, 0x41, 0x76, 0x6f, 0x73, 0x74, 0x3b, 0x53, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x4f, 0x74,
0x75, 0x62, 0x61, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x44, 0x69, 0x63, 0x65, 0x6d, 0x62,
0x61, 0x72, 0x3b, 0x5a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x53,
0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x50, 0x68, 0x61, 0x3b, 0x4c, 0x75, 0x68, 0x3b, 0x1e70, 0x68, 0x61, 0x3b, 0x4c,
0x61, 0x6d, 0x3b, 0x53, 0x68, 0x75, 0x3b, 0x4c, 0x77, 0x69, 0x3b, 0x4c, 0x77, 0x61, 0x3b, 0x1e70, 0x68, 0x61, 0x3b, 0x4b,
0x68, 0x75, 0x3b, 0x54, 0x73, 0x68, 0x3b, 0x1e3c, 0x61, 0x72, 0x3b, 0x4e, 0x79, 0x65, 0x3b, 0x50, 0x68, 0x61, 0x6e, 0x64,
0x6f, 0x3b, 0x4c, 0x75, 0x68, 0x75, 0x68, 0x69, 0x3b, 0x1e70, 0x68, 0x61, 0x66, 0x61, 0x6d, 0x75, 0x68, 0x77, 0x65, 0x3b,
0x4c, 0x61, 0x6d, 0x62, 0x61, 0x6d, 0x61, 0x69, 0x3b, 0x53, 0x68, 0x75, 0x6e, 0x64, 0x75, 0x6e, 0x74, 0x68, 0x75, 0x6c,
0x65, 0x3b, 0x46, 0x75, 0x6c, 0x77, 0x69, 0x3b, 0x46, 0x75, 0x6c, 0x77, 0x61, 0x6e, 0x61, 0x3b, 0x1e70, 0x68, 0x61, 0x6e,
0x67, 0x75, 0x6c, 0x65, 0x3b, 0x4b, 0x68, 0x75, 0x62, 0x76, 0x75, 0x6d, 0x65, 0x64, 0x7a, 0x69, 0x3b, 0x54, 0x73, 0x68,
0x69, 0x6d, 0x65, 0x64, 0x7a, 0x69, 0x3b, 0x1e3c, 0x61, 0x72, 0x61, 0x3b, 0x4e, 0x79, 0x65, 0x6e, 0x64, 0x61, 0x76, 0x68,
0x75, 0x73, 0x69, 0x6b, 0x75, 0x3b, 0x64, 0x7a, 0x76, 0x3b, 0x64, 0x7a, 0x64, 0x3b, 0x74, 0x65, 0x64, 0x3b, 0x61, 0x66,
0x254, 0x3b, 0x64, 0x61, 0x6d, 0x3b, 0x6d, 0x61, 0x73, 0x3b, 0x73, 0x69, 0x61, 0x3b, 0x64, 0x65, 0x61, 0x3b, 0x61, 0x6e,
0x79, 0x3b, 0x6b, 0x65, 0x6c, 0x3b, 0x61, 0x64, 0x65, 0x3b, 0x64, 0x7a, 0x6d, 0x3b, 0x64, 0x7a, 0x6f, 0x76, 0x65, 0x3b,
0x64, 0x7a, 0x6f, 0x64, 0x7a, 0x65, 0x3b, 0x74, 0x65, 0x64, 0x6f, 0x78, 0x65, 0x3b, 0x61, 0x66, 0x254, 0x66, 0x129, 0x65,
0x3b, 0x64, 0x61, 0x6d, 0x61, 0x3b, 0x6d, 0x61, 0x73, 0x61, 0x3b, 0x73, 0x69, 0x61, 0x6d, 0x6c, 0x254, 0x6d, 0x3b, 0x64,
0x65, 0x61, 0x73, 0x69, 0x61, 0x6d, 0x69, 0x6d, 0x65, 0x3b, 0x61, 0x6e, 0x79, 0x254, 0x6e, 0x79, 0x254, 0x3b, 0x6b, 0x65,
0x6c, 0x65, 0x3b, 0x61, 0x64, 0x65, 0x25b, 0x6d, 0x65, 0x6b, 0x70, 0x254, 0x78, 0x65, 0x3b, 0x64, 0x7a, 0x6f, 0x6d, 0x65,
0x3b, 0x64, 0x3b, 0x64, 0x3b, 0x74, 0x3b, 0x61, 0x3b, 0x64, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x64, 0x3b, 0x61, 0x3b, 0x6b,
0x3b, 0x61, 0x3b, 0x64, 0x3b, 0x49, 0x61, 0x6e, 0x2e, 0x3b, 0x50, 0x65, 0x70, 0x2e, 0x3b, 0x4d, 0x61, 0x6c, 0x2e, 0x3b,
0x2bb, 0x41, 0x70, 0x2e, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x49, 0x75, 0x6e, 0x2e, 0x3b, 0x49, 0x75, 0x6c, 0x2e, 0x3b, 0x2bb,
0x41, 0x75, 0x2e, 0x3b, 0x4b, 0x65, 0x70, 0x2e, 0x3b, 0x2bb, 0x4f, 0x6b, 0x2e, 0x3b, 0x4e, 0x6f, 0x77, 0x2e, 0x3b, 0x4b,
0x65, 0x6b, 0x2e, 0x3b, 0x49, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x50, 0x65, 0x70, 0x65, 0x6c, 0x75, 0x61, 0x6c,
0x69, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x6b, 0x69, 0x3b, 0x2bb, 0x41, 0x70, 0x65, 0x6c, 0x69, 0x6c, 0x61, 0x3b, 0x4d, 0x65,
0x69, 0x3b, 0x49, 0x75, 0x6e, 0x65, 0x3b, 0x49, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x2bb, 0x41, 0x75, 0x6b, 0x61, 0x6b, 0x65,
0x3b, 0x4b, 0x65, 0x70, 0x61, 0x6b, 0x65, 0x6d, 0x61, 0x70, 0x61, 0x3b, 0x2bb, 0x4f, 0x6b, 0x61, 0x6b, 0x6f, 0x70, 0x61,
0x3b, 0x4e, 0x6f, 0x77, 0x65, 0x6d, 0x61, 0x70, 0x61, 0x3b, 0x4b, 0x65, 0x6b, 0x65, 0x6d, 0x61, 0x70, 0x61, 0x3b, 0x4a,
0x75, 0x77, 0x3b, 0x53, 0x77, 0x69, 0x3b, 0x54, 0x73, 0x61, 0x3b, 0x4e, 0x79, 0x61, 0x3b, 0x54, 0x73, 0x77, 0x3b, 0x41,
0x74, 0x61, 0x3b, 0x41, 0x6e, 0x61, 0x3b, 0x41, 0x72, 0x69, 0x3b, 0x41, 0x6b, 0x75, 0x3b, 0x53, 0x77, 0x61, 0x3b, 0x4d,
0x61, 0x6e, 0x3b, 0x4d, 0x61, 0x73, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x4a, 0x75, 0x77, 0x75, 0x6e, 0x67, 0x3b, 0x5a,
0x77, 0x61, 0x74, 0x20, 0x53, 0x77, 0x69, 0x79, 0x61, 0x6e, 0x67, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x54, 0x73, 0x61,
0x74, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x4e, 0x79, 0x61, 0x69, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x54, 0x73, 0x77,
0x6f, 0x6e, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x41, 0x74, 0x61, 0x61, 0x68, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x41,
0x6e, 0x61, 0x74, 0x61, 0x74, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x41, 0x72, 0x69, 0x6e, 0x61, 0x69, 0x3b, 0x5a, 0x77,
0x61, 0x74, 0x20, 0x41, 0x6b, 0x75, 0x62, 0x75, 0x6e, 0x79, 0x75, 0x6e, 0x67, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x53,
0x77, 0x61, 0x67, 0x3b, 0x5a, 0x77, 0x61, 0x74, 0x20, 0x4d, 0x61, 0x6e, 0x67, 0x6a, 0x75, 0x77, 0x61, 0x6e, 0x67, 0x3b,
0x5a, 0x77, 0x61, 0x74, 0x20, 0x53, 0x77, 0x61, 0x67, 0x2d, 0x4d, 0x61, 0x2d, 0x53, 0x75, 0x79, 0x61, 0x6e, 0x67, 0x3b,
0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x3b, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x7a, 0x3b,
0x41, 0x70, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x69, 0x3b,
0x41, 0x75, 0x67, 0x75, 0x73, 0x63, 0x68, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x74, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f,
0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a,
0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0xa2cd, 0xa1aa, 0x3b, 0xa44d, 0xa1aa, 0x3b, 0xa315, 0xa1aa, 0x3b, 0xa1d6, 0xa1aa, 0x3b, 0xa26c, 0xa1aa,
0x3b, 0xa0d8, 0xa1aa, 0x3b, 0xa3c3, 0xa1aa, 0x3b, 0xa246, 0xa1aa, 0x3b, 0xa22c, 0xa1aa, 0x3b, 0xa2b0, 0xa1aa, 0x3b, 0xa2b0, 0xa2aa, 0xa1aa, 0x3b,
0xa2b0, 0xa44b, 0xa1aa, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x74, 0x3b, 0x41, 0x70, 0x72, 0x3b,
0x4d, 0x65, 0x79, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x72, 0x68, 0x3b, 0x53, 0x65, 0x70, 0x3b,
0x4f, 0x6b, 0x74, 0x3b, 0x55, 0x73, 0x69, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x61, 0x62, 0x61, 0x72, 0x69,
0x3b, 0x75, 0x46, 0x65, 0x62, 0x65, 0x72, 0x62, 0x61, 0x72, 0x69, 0x3b, 0x75, 0x4d, 0x61, 0x74, 0x6a, 0x68, 0x69, 0x3b,
0x75, 0x2d, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x65, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a,
0x75, 0x6c, 0x61, 0x79, 0x69, 0x3b, 0x41, 0x72, 0x68, 0x6f, 0x73, 0x74, 0x6f, 0x73, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74,
0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x55, 0x73, 0x69, 0x6e, 0x79, 0x69, 0x6b, 0x68,
0x61, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b,
0x4d, 0x61, 0x74, 0x3b, 0x41, 0x70, 0x6f, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b,
0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x66, 0x3b, 0x44, 0x69, 0x73, 0x3b,
0x4a, 0x61, 0x6e, 0x61, 0x77, 0x61, 0x72, 0x65, 0x3b, 0x46, 0x65, 0x62, 0x65, 0x72, 0x77, 0x61, 0x72, 0x65, 0x3b, 0x4d,
0x61, 0x74, 0x161, 0x68, 0x65, 0x3b, 0x41, 0x70, 0x6f, 0x72, 0x65, 0x6c, 0x65, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75,
0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x65, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x73, 0x65, 0x3b, 0x53, 0x65,
0x74, 0x65, 0x6d, 0x65, 0x72, 0x65, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x6f, 0x72, 0x65, 0x3b, 0x4e, 0x6f, 0x66, 0x65,
0x6d, 0x65, 0x72, 0x65, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x65, 0x72, 0x65, 0x3b, 0x6f, 0x111, 0x111, 0x61, 0x6a, 0x61,
0x67, 0x65, 0x3b, 0x67, 0x75, 0x6f, 0x76, 0x76, 0x61, 0x3b, 0x6e, 0x6a, 0x75, 0x6b, 0x10d, 0x61, 0x3b, 0x63, 0x75, 0x6f,
0x14b, 0x6f, 0x3b, 0x6d, 0x69, 0x65, 0x73, 0x73, 0x65, 0x3b, 0x67, 0x65, 0x61, 0x73, 0x73, 0x65, 0x3b, 0x73, 0x75, 0x6f,
0x69, 0x64, 0x6e, 0x65, 0x3b, 0x62, 0x6f, 0x72, 0x67, 0x65, 0x3b, 0x10d, 0x61, 0x6b, 0x10d, 0x61, 0x3b, 0x67, 0x6f, 0x6c,
0x67, 0x67, 0x6f, 0x74, 0x3b, 0x73, 0x6b, 0xe1, 0x62, 0x6d, 0x61, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x6c, 0x61, 0x3b, 0x6f,
0x111, 0x111, 0x61, 0x6a, 0x61, 0x67, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x67, 0x75, 0x6f, 0x76, 0x76, 0x61, 0x6d,
0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x6e, 0x6a, 0x75, 0x6b, 0x10d, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x63, 0x75, 0x6f,
0x14b, 0x6f, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x6d, 0x69, 0x65, 0x73, 0x73, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b,
0x67, 0x65, 0x61, 0x73, 0x73, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x73, 0x75, 0x6f, 0x69, 0x64, 0x6e, 0x65, 0x6d,
0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x62, 0x6f, 0x72, 0x67, 0x65, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x10d, 0x61, 0x6b, 0x10d,
0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x67, 0x6f, 0x6c, 0x67, 0x67, 0x6f, 0x74, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b,
0x73, 0x6b, 0xe1, 0x62, 0x6d, 0x61, 0x6d, 0xe1, 0x6e, 0x6e, 0x75, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x6c, 0x61, 0x6d, 0xe1,
0x6e, 0x6e, 0x75, 0x3b, 0x4f, 0x3b, 0x47, 0x3b, 0x4e, 0x3b, 0x43, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x42, 0x3b,
0x10c, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x4a, 0x3b, 0x6f, 0x111, 0x111, 0x6a, 0x3b, 0x67, 0x75, 0x6f, 0x76, 0x3b, 0x6e, 0x6a,
0x75, 0x6b, 0x3b, 0x63, 0x75, 0x6f, 0x3b, 0x6d, 0x69, 0x65, 0x73, 0x3b, 0x67, 0x65, 0x61, 0x73, 0x3b, 0x73, 0x75, 0x6f,
0x69, 0x3b, 0x62, 0x6f, 0x72, 0x67, 0x3b, 0x10d, 0x61, 0x6b, 0x10d, 0x3b, 0x67, 0x6f, 0x6c, 0x67, 0x3b, 0x73, 0x6b, 0xe1,
0x62, 0x3b, 0x6a, 0x75, 0x6f, 0x76, 0x3b, 0x4b, 0x69, 0x69, 0x3b, 0x44, 0x68, 0x69, 0x3b, 0x54, 0x72, 0x69, 0x3b, 0x53,
0x70, 0x69, 0x3b, 0x52, 0x69, 0x69, 0x3b, 0x4d, 0x74, 0x69, 0x3b, 0x45, 0x6d, 0x69, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4d,
0x6e, 0x69, 0x3b, 0x4d, 0x78, 0x69, 0x3b, 0x4d, 0x78, 0x6b, 0x3b, 0x4d, 0x78, 0x64, 0x3b, 0x4b, 0x69, 0x6e, 0x67, 0x61,
0x6c, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x44, 0x68, 0x61, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x54, 0x72, 0x75, 0x20,
0x69, 0x64, 0x61, 0x73, 0x3b, 0x53, 0x70, 0x61, 0x74, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x52, 0x69, 0x6d, 0x61, 0x20,
0x69, 0x64, 0x61, 0x73, 0x3b, 0x4d, 0x61, 0x74, 0x61, 0x72, 0x75, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x45, 0x6d, 0x70,
0x69, 0x74, 0x75, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x4d, 0x61, 0x73, 0x70, 0x61, 0x74, 0x20, 0x69, 0x64, 0x61, 0x73,
0x3b, 0x4d, 0x6e, 0x67, 0x61, 0x72, 0x69, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x4d, 0x61, 0x78, 0x61, 0x6c, 0x20, 0x69,
0x64, 0x61, 0x73, 0x3b, 0x4d, 0x61, 0x78, 0x61, 0x6c, 0x20, 0x6b, 0x69, 0x6e, 0x67, 0x61, 0x6c, 0x20, 0x69, 0x64, 0x61,
0x73, 0x3b, 0x4d, 0x61, 0x78, 0x61, 0x6c, 0x20, 0x64, 0x68, 0x61, 0x20, 0x69, 0x64, 0x61, 0x73, 0x3b, 0x4b, 0x3b, 0x44,
0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x50, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x44,
0x3b, 0x43, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69,
0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x43, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x74, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74,
0x3b, 0x4e, 0x6f, 0x62, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x43, 0x68, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65,
0x62, 0x75, 0x72, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x69, 0x72, 0x69, 0x72, 0x69,
0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x43, 0x68, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x41, 0x67, 0x6f,
0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x69, 0x74, 0x6f, 0x62, 0x61,
0x3b, 0x4e, 0x6f, 0x62, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x43, 0x3b, 0x46,
0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x43, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44,
0x3b, 0x49, 0x6d, 0x62, 0x3b, 0x4b, 0x61, 0x77, 0x3b, 0x4b, 0x61, 0x64, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x4b, 0x61, 0x73,
0x3b, 0x4b, 0x61, 0x72, 0x3b, 0x4d, 0x66, 0x75, 0x3b, 0x57, 0x75, 0x6e, 0x3b, 0x49, 0x6b, 0x65, 0x3b, 0x49, 0x6b, 0x75,
0x3b, 0x49, 0x6d, 0x77, 0x3b, 0x49, 0x77, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69,
0x6d, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x77, 0x69,
0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x64, 0x61, 0x64, 0x75, 0x3b, 0x4d, 0x6f,
0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68,
0x77, 0x61, 0x20, 0x6b, 0x61, 0x73, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20,
0x6b, 0x61, 0x72, 0x61, 0x6e, 0x64, 0x61, 0x64, 0x75, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20,
0x6d, 0x66, 0x75, 0x6e, 0x67, 0x61, 0x64, 0x65, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x77,
0x75, 0x6e, 0x79, 0x61, 0x6e, 0x79, 0x61, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b,
0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69,
0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20,
0x69, 0x6d, 0x77, 0x65, 0x72, 0x69, 0x3b, 0x4d, 0x6f, 0x72, 0x69, 0x20, 0x67, 0x68, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75,
0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x69, 0x77, 0x69, 0x3b, 0x49, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b,
0x4b, 0x3b, 0x4d, 0x3b, 0x57, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x73, 0x69, 0x69, 0x3b, 0x63, 0x6f,
0x6c, 0x3b, 0x6d, 0x62, 0x6f, 0x3b, 0x73, 0x65, 0x65, 0x3b, 0x64, 0x75, 0x75, 0x3b, 0x6b, 0x6f, 0x72, 0x3b, 0x6d, 0x6f,
0x72, 0x3b, 0x6a, 0x75, 0x6b, 0x3b, 0x73, 0x6c, 0x74, 0x3b, 0x79, 0x61, 0x72, 0x3b, 0x6a, 0x6f, 0x6c, 0x3b, 0x62, 0x6f,
0x77, 0x3b, 0x73, 0x69, 0x69, 0x6c, 0x6f, 0x3b, 0x63, 0x6f, 0x6c, 0x74, 0x65, 0x3b, 0x6d, 0x62, 0x6f, 0x6f, 0x79, 0x3b,
0x73, 0x65, 0x65, 0x257, 0x74, 0x6f, 0x3b, 0x64, 0x75, 0x75, 0x6a, 0x61, 0x6c, 0x3b, 0x6b, 0x6f, 0x72, 0x73, 0x65, 0x3b,
0x6d, 0x6f, 0x72, 0x73, 0x6f, 0x3b, 0x6a, 0x75, 0x6b, 0x6f, 0x3b, 0x73, 0x69, 0x69, 0x6c, 0x74, 0x6f, 0x3b, 0x79, 0x61,
0x72, 0x6b, 0x6f, 0x6d, 0x61, 0x61, 0x3b, 0x6a, 0x6f, 0x6c, 0x61, 0x6c, 0x3b, 0x62, 0x6f, 0x77, 0x74, 0x65, 0x3b, 0x73,
0x3b, 0x63, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x64, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x73, 0x3b, 0x79, 0x3b, 0x6a,
0x3b, 0x62, 0x3b, 0x4a, 0x45, 0x4e, 0x3b, 0x57, 0x4b, 0x52, 0x3b, 0x57, 0x47, 0x54, 0x3b, 0x57, 0x4b, 0x4e, 0x3b, 0x57,
0x54, 0x4e, 0x3b, 0x57, 0x54, 0x44, 0x3b, 0x57, 0x4d, 0x4a, 0x3b, 0x57, 0x4e, 0x4e, 0x3b, 0x57, 0x4b, 0x44, 0x3b, 0x57,
0x49, 0x4b, 0x3b, 0x57, 0x4d, 0x57, 0x3b, 0x44, 0x49, 0x54, 0x3b, 0x4e, 0x6a, 0x65, 0x6e, 0x75, 0x61, 0x72, 0x129, 0x3b,
0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x72, 0x129, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20,
0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b,
0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b,
0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x169, 0x3b, 0x4d,
0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x169, 0x67, 0x77, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x4d, 0x77, 0x65,
0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77,
0x61, 0x20, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169,
0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x20, 0x6e, 0x61,
0x20, 0x169, 0x6d, 0x77, 0x65, 0x3b, 0x4e, 0x64, 0x69, 0x74, 0x68, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x3b, 0x4b, 0x3b,
0x47, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x44, 0x3b,
0x4f, 0x62, 0x6f, 0x3b, 0x57, 0x61, 0x61, 0x3b, 0x4f, 0x6b, 0x75, 0x3b, 0x4f, 0x6e, 0x67, 0x3b, 0x49, 0x6d, 0x65, 0x3b,
0x49, 0x6c, 0x65, 0x3b, 0x53, 0x61, 0x70, 0x3b, 0x49, 0x73, 0x69, 0x3b, 0x53, 0x61, 0x61, 0x3b, 0x54, 0x6f, 0x6d, 0x3b,
0x54, 0x6f, 0x62, 0x3b, 0x54, 0x6f, 0x77, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x6f, 0x62, 0x6f, 0x3b,
0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x77, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c,
0x65, 0x20, 0x6f, 0x6b, 0x75, 0x6e, 0x69, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x6f, 0x6e, 0x67, 0x27,
0x77, 0x61, 0x6e, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x69, 0x6d, 0x65, 0x74, 0x3b, 0x4c, 0x61, 0x70,
0x61, 0x20, 0x6c, 0x65, 0x20, 0x69, 0x6c, 0x65, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x73, 0x61, 0x70,
0x61, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x69, 0x73, 0x69, 0x65, 0x74, 0x3b, 0x4c, 0x61, 0x70, 0x61,
0x20, 0x6c, 0x65, 0x20, 0x73, 0x61, 0x61, 0x6c, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6d,
0x6f, 0x6e, 0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x6f, 0x62, 0x6f,
0x3b, 0x4c, 0x61, 0x70, 0x61, 0x20, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x77, 0x61, 0x61, 0x72, 0x65,
0x3b, 0x4f, 0x3b, 0x57, 0x3b, 0x4f, 0x3b, 0x4f, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x54,
0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72,
0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x75, 0x67, 0x3b, 0x53, 0x65, 0x74,
0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x4a, 0x61, 0x6e, 0x65, 0x69, 0x72, 0x6f,
0x3b, 0x46, 0x65, 0x76, 0x72, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x63, 0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69,
0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x6f, 0x3b, 0x4a, 0x75, 0x6e, 0x68, 0x6f, 0x3b, 0x4a, 0x75, 0x6c, 0x68, 0x6f, 0x3b, 0x41,
0x75, 0x67, 0x75, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x4f, 0x74, 0x75, 0x62,
0x72, 0x6f, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x72, 0x6f, 0x3b, 0x44, 0x65, 0x63, 0x65, 0x6d, 0x62, 0x72, 0x6f,
0x3b, 0x5a, 0x69, 0x62, 0x3b, 0x4e, 0x68, 0x6c, 0x3b, 0x4d, 0x62, 0x69, 0x3b, 0x4d, 0x61, 0x62, 0x3b, 0x4e, 0x6b, 0x77,
0x3b, 0x4e, 0x68, 0x6c, 0x3b, 0x4e, 0x74, 0x75, 0x3b, 0x4e, 0x63, 0x77, 0x3b, 0x4d, 0x70, 0x61, 0x3b, 0x4d, 0x66, 0x75,
0x3b, 0x4c, 0x77, 0x65, 0x3b, 0x4d, 0x70, 0x61, 0x3b, 0x5a, 0x69, 0x62, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x6c, 0x61, 0x3b,
0x4e, 0x68, 0x6c, 0x6f, 0x6c, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x4d, 0x62, 0x69, 0x6d, 0x62, 0x69, 0x74, 0x68, 0x6f, 0x3b,
0x4d, 0x61, 0x62, 0x61, 0x73, 0x61, 0x3b, 0x4e, 0x6b, 0x77, 0x65, 0x6e, 0x6b, 0x77, 0x65, 0x7a, 0x69, 0x3b, 0x4e, 0x68,
0x6c, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x61, 0x3b, 0x4e, 0x74, 0x75, 0x6c, 0x69, 0x6b, 0x61, 0x7a, 0x69, 0x3b, 0x4e, 0x63,
0x77, 0x61, 0x62, 0x61, 0x6b, 0x61, 0x7a, 0x69, 0x3b, 0x4d, 0x70, 0x61, 0x6e, 0x64, 0x75, 0x6c, 0x61, 0x3b, 0x4d, 0x66,
0x75, 0x6d, 0x66, 0x75, 0x3b, 0x4c, 0x77, 0x65, 0x7a, 0x69, 0x3b, 0x4d, 0x70, 0x61, 0x6c, 0x61, 0x6b, 0x61, 0x7a, 0x69,
0x3b, 0x5a, 0x3b, 0x4e, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4d, 0x3b, 0x4d,
0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x31, 0x3b, 0x4d, 0x32, 0x3b, 0x4d, 0x33, 0x3b, 0x4d, 0x34, 0x3b, 0x4d, 0x35, 0x3b,
0x4d, 0x36, 0x3b, 0x4d, 0x37, 0x3b, 0x4d, 0x38, 0x3b, 0x4d, 0x39, 0x3b, 0x4d, 0x31, 0x30, 0x3b, 0x4d, 0x31, 0x31, 0x3b,
0x4d, 0x31, 0x32, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x3b,
0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20,
0x6b, 0x61, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x74, 0x61, 0x6e, 0x75, 0x3b,
0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x73, 0x69, 0x74, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20,
0x77, 0x61, 0x20, 0x73, 0x61, 0x62, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6e, 0x61, 0x6e,
0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x74, 0x69, 0x73, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72,
0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20,
0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x6a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20,
0x77, 0x61, 0x20, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4b, 0x3b,
0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x49, 0x3b, 0x49, 0x3b,
0x49, 0x3b, 0x69, 0x6e, 0x6e, 0x3b, 0x62, 0x1e5b, 0x61, 0x3b, 0x6d, 0x61, 0x1e5b, 0x3b, 0x69, 0x62, 0x72, 0x3b, 0x6d, 0x61,
0x79, 0x3b, 0x79, 0x75, 0x6e, 0x3b, 0x79, 0x75, 0x6c, 0x3b, 0x263, 0x75, 0x63, 0x3b, 0x63, 0x75, 0x74, 0x3b, 0x6b, 0x74,
0x75, 0x3b, 0x6e, 0x75, 0x77, 0x3b, 0x64, 0x75, 0x6a, 0x3b, 0x69, 0x6e, 0x6e, 0x61, 0x79, 0x72, 0x3b, 0x62, 0x1e5b, 0x61,
0x79, 0x1e5b, 0x3b, 0x6d, 0x61, 0x1e5b, 0x1e63, 0x3b, 0x69, 0x62, 0x72, 0x69, 0x72, 0x3b, 0x6d, 0x61, 0x79, 0x79, 0x75, 0x3b,
0x79, 0x75, 0x6e, 0x79, 0x75, 0x3b, 0x79, 0x75, 0x6c, 0x79, 0x75, 0x7a, 0x3b, 0x263, 0x75, 0x63, 0x74, 0x3b, 0x63, 0x75,
0x74, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x6b, 0x74, 0x75, 0x62, 0x72, 0x3b, 0x6e, 0x75, 0x77, 0x61, 0x6e, 0x62, 0x69,
0x72, 0x3b, 0x64, 0x75, 0x6a, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x69, 0x3b, 0x62, 0x3b, 0x6d, 0x3b, 0x69, 0x3b, 0x6d,
0x3b, 0x79, 0x3b, 0x79, 0x3b, 0x263, 0x3b, 0x63, 0x3b, 0x6b, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x2d49, 0x2d4f, 0x2d4f, 0x3b, 0x2d31,
0x2d55, 0x2d30, 0x3b, 0x2d4e, 0x2d30, 0x2d55, 0x3b, 0x2d49, 0x2d31, 0x2d54, 0x3b, 0x2d4e, 0x2d30, 0x2d62, 0x3b, 0x2d62, 0x2d53, 0x2d4f, 0x3b, 0x2d62,
0x2d53, 0x2d4d, 0x3b, 0x2d56, 0x2d53, 0x2d5b, 0x3b, 0x2d5b, 0x2d53, 0x2d5c, 0x3b, 0x2d3d, 0x2d5c, 0x2d53, 0x3b, 0x2d4f, 0x2d53, 0x2d61, 0x3b, 0x2d37,
0x2d53, 0x2d4a, 0x3b, 0x2d49, 0x2d4f, 0x2d4f, 0x2d30, 0x2d62, 0x2d54, 0x3b, 0x2d31, 0x2d55, 0x2d30, 0x2d62, 0x2d55, 0x3b, 0x2d4e, 0x2d30, 0x2d55, 0x2d5a,
0x3b, 0x2d49, 0x2d31, 0x2d54, 0x2d49, 0x2d54, 0x3b, 0x2d4e, 0x2d30, 0x2d62, 0x2d62, 0x2d53, 0x3b, 0x2d62, 0x2d53, 0x2d4f, 0x2d62, 0x2d53, 0x3b, 0x2d62,
0x2d53, 0x2d4d, 0x2d62, 0x2d53, 0x2d63, 0x3b, 0x2d56, 0x2d53, 0x2d5b, 0x2d5c, 0x3b, 0x2d5b, 0x2d53, 0x2d5c, 0x2d30, 0x2d4f, 0x2d31, 0x2d49, 0x2d54, 0x3b,
0x2d3d, 0x2d5c, 0x2d53, 0x2d31, 0x2d54, 0x3b, 0x2d4f, 0x2d53, 0x2d61, 0x2d30, 0x2d4f, 0x2d31, 0x2d49, 0x2d54, 0x3b, 0x2d37, 0x2d53, 0x2d4a, 0x2d30, 0x2d4f,
0x2d31, 0x2d49, 0x2d54, 0x3b, 0x2d49, 0x3b, 0x2d31, 0x3b, 0x2d4e, 0x3b, 0x2d49, 0x3b, 0x2d4e, 0x3b, 0x2d62, 0x3b, 0x2d62, 0x3b, 0x2d56, 0x3b,
0x2d5b, 0x3b, 0x2d3d, 0x3b, 0x2d4f, 0x3b, 0x2d37, 0x3b, 0x59, 0x65, 0x6e, 0x3b, 0x46, 0x75, 0x72, 0x3b, 0x4d, 0x65, 0x263, 0x3b,
0x59, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x59, 0x75, 0x6e, 0x3b, 0x59, 0x75, 0x6c, 0x3b, 0x194, 0x75, 0x63, 0x3b,
0x43, 0x74, 0x65, 0x3b, 0x54, 0x75, 0x62, 0x3b, 0x4e, 0x75, 0x6e, 0x3b, 0x44, 0x75, 0x1e7, 0x3b, 0x59, 0x65, 0x6e, 0x6e,
0x61, 0x79, 0x65, 0x72, 0x3b, 0x46, 0x75, 0x1e5b, 0x61, 0x72, 0x3b, 0x4d, 0x65, 0x263, 0x72, 0x65, 0x73, 0x3b, 0x59, 0x65,
0x62, 0x72, 0x69, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6e, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6c,
0x79, 0x75, 0x3b, 0x194, 0x75, 0x63, 0x74, 0x3b, 0x43, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x1e5b, 0x3b, 0x54, 0x75, 0x62, 0x65,
0x1e5b, 0x3b, 0x4e, 0x75, 0x6e, 0x65, 0x6d, 0x62, 0x65, 0x1e5b, 0x3b, 0x44, 0x75, 0x1e7, 0x65, 0x6d, 0x62, 0x65, 0x1e5b, 0x3b,
0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x194, 0x3b, 0x43, 0x3b, 0x54, 0x3b,
0x4e, 0x3b, 0x44, 0x3b, 0x4b, 0x42, 0x5a, 0x3b, 0x4b, 0x42, 0x52, 0x3b, 0x4b, 0x53, 0x54, 0x3b, 0x4b, 0x4b, 0x4e, 0x3b,
0x4b, 0x54, 0x4e, 0x3b, 0x4b, 0x4d, 0x4b, 0x3b, 0x4b, 0x4d, 0x53, 0x3b, 0x4b, 0x4d, 0x4e, 0x3b, 0x4b, 0x4d, 0x4e, 0x3b,
0x4b, 0x4b, 0x4d, 0x3b, 0x4b, 0x4e, 0x4b, 0x3b, 0x4b, 0x4e, 0x42, 0x3b, 0x4f, 0x6b, 0x77, 0x6f, 0x6b, 0x75, 0x62, 0x61,
0x6e, 0x7a, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b,
0x61, 0x73, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61,
0x6b, 0x61, 0x74, 0x61, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b,
0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x75, 0x73, 0x68, 0x61, 0x6e, 0x6a, 0x75, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x75, 0x6e,
0x61, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x77, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4f, 0x6b, 0x77, 0x61,
0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6b,
0x75, 0x6d, 0x77, 0x65, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x69, 0x62,
0x69, 0x72, 0x69, 0x3b, 0x48, 0x75, 0x74, 0x3b, 0x56, 0x69, 0x6c, 0x3b, 0x44, 0x61, 0x74, 0x3b, 0x54, 0x61, 0x69, 0x3b,
0x48, 0x61, 0x6e, 0x3b, 0x53, 0x69, 0x74, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4e, 0x61, 0x6e, 0x3b, 0x54, 0x69, 0x73, 0x3b,
0x4b, 0x75, 0x6d, 0x3b, 0x4b, 0x6d, 0x6a, 0x3b, 0x4b, 0x6d, 0x62, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a,
0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x68, 0x75, 0x74, 0x61, 0x6c, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64,
0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65,
0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x64, 0x61, 0x74, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77,
0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x74, 0x61, 0x69, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77,
0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x77, 0x75, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x6d,
0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x73, 0x69, 0x74, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77,
0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x73, 0x61, 0x62, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65,
0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6e, 0x61, 0x6e, 0x65, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64,
0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x74, 0x69, 0x73, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a,
0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69,
0x20, 0x67, 0x77, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x6a, 0x61, 0x3b, 0x70, 0x61,
0x20, 0x6d, 0x77, 0x65, 0x64, 0x7a, 0x69, 0x20, 0x67, 0x77, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20,
0x6d, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x48, 0x3b, 0x56, 0x3b, 0x44, 0x3b, 0x54, 0x3b, 0x48, 0x3b, 0x53, 0x3b, 0x53, 0x3b,
0x4e, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46, 0x65,
0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x72, 0x69, 0x6c, 0x79, 0x69,
0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x79, 0x61, 0x69, 0x3b, 0x41, 0x67,
0x75, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61,
0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x7a, 0x61, 0x6e,
0x3b, 0x66, 0x65, 0x62, 0x3b, 0x6e, 0x61, 0x72, 0x3b, 0x61, 0x77, 0x69, 0x3b, 0x6d, 0x25b, 0x3b, 0x7a, 0x75, 0x77, 0x3b,
0x7a, 0x75, 0x6c, 0x3b, 0x75, 0x74, 0x69, 0x3b, 0x73, 0x25b, 0x74, 0x3b, 0x254, 0x6b, 0x75, 0x3b, 0x6e, 0x6f, 0x77, 0x3b,
0x64, 0x65, 0x73, 0x3b, 0x7a, 0x61, 0x6e, 0x77, 0x75, 0x79, 0x65, 0x3b, 0x66, 0x65, 0x62, 0x75, 0x72, 0x75, 0x79, 0x65,
0x3b, 0x6d, 0x61, 0x72, 0x69, 0x73, 0x69, 0x3b, 0x61, 0x77, 0x69, 0x72, 0x69, 0x6c, 0x69, 0x3b, 0x6d, 0x25b, 0x3b, 0x7a,
0x75, 0x77, 0x25b, 0x6e, 0x3b, 0x7a, 0x75, 0x6c, 0x75, 0x79, 0x65, 0x3b, 0x75, 0x74, 0x69, 0x3b, 0x73, 0x25b, 0x74, 0x61,
0x6e, 0x62, 0x75, 0x72, 0x75, 0x3b, 0x254, 0x6b, 0x75, 0x74, 0x254, 0x62, 0x75, 0x72, 0x75, 0x3b, 0x6e, 0x6f, 0x77, 0x61,
0x6e, 0x62, 0x75, 0x72, 0x75, 0x3b, 0x64, 0x65, 0x73, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x75, 0x3b, 0x5a, 0x3b, 0x46, 0x3b,
0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0x5a, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x186, 0x3b, 0x4e, 0x3b, 0x44, 0x3b,
0x4d, 0x62, 0x65, 0x3b, 0x4b, 0x61, 0x69, 0x3b, 0x4b, 0x61, 0x74, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x47, 0x61, 0x74, 0x3b,
0x47, 0x61, 0x6e, 0x3b, 0x4d, 0x75, 0x67, 0x3b, 0x4b, 0x6e, 0x6e, 0x3b, 0x4b, 0x65, 0x6e, 0x3b, 0x49, 0x6b, 0x75, 0x3b,
0x49, 0x6d, 0x77, 0x3b, 0x49, 0x67, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65,
0x72, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x129, 0x72, 0x69, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x68, 0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61,
0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x74,
0x61, 0x74, 0x169, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x169, 0x67, 0x77, 0x61, 0x6e, 0x6a,
0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x6e, 0x61, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77,
0x61, 0x20, 0x69, 0x6b, 0x169, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20, 0x69, 0x6b, 0x169,
0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x169, 0x6d, 0x77, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x61, 0x20,
0x69, 0x6b, 0x169, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x4b, 0x61, 0x129, 0x72, 0x129, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b,
0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x13a4,
0x13c3, 0x3b, 0x13a7, 0x13a6, 0x3b, 0x13a0, 0x13c5, 0x3b, 0x13a7, 0x13ec, 0x3b, 0x13a0, 0x13c2, 0x3b, 0x13d5, 0x13ad, 0x3b, 0x13ab, 0x13f0, 0x3b,
0x13a6, 0x13b6, 0x3b, 0x13da, 0x13b5, 0x3b, 0x13da, 0x13c2, 0x3b, 0x13c5, 0x13d3, 0x3b, 0x13a4, 0x13cd, 0x3b, 0x13a4, 0x13c3, 0x13b8, 0x13d4, 0x13c5,
0x3b, 0x13a7, 0x13a6, 0x13b5, 0x3b, 0x13a0, 0x13c5, 0x13f1, 0x3b, 0x13a7, 0x13ec, 0x13c2, 0x3b, 0x13a0, 0x13c2, 0x13cd, 0x13ac, 0x13d8, 0x3b, 0x13d5,
0x13ad, 0x13b7, 0x13f1, 0x3b, 0x13ab, 0x13f0, 0x13c9, 0x13c2, 0x3b, 0x13a6, 0x13b6, 0x13c2, 0x3b, 0x13da, 0x13b5, 0x13cd, 0x13d7, 0x3b, 0x13da, 0x13c2,
0x13c5, 0x13d7, 0x3b, 0x13c5, 0x13d3, 0x13d5, 0x13c6, 0x3b, 0x13a4, 0x13cd, 0x13a9, 0x13f1, 0x3b, 0x13a4, 0x3b, 0x13a7, 0x3b, 0x13a0, 0x3b, 0x13a7,
0x3b, 0x13a0, 0x3b, 0x13d5, 0x3b, 0x13ab, 0x3b, 0x13a6, 0x3b, 0x13da, 0x3b, 0x13da, 0x3b, 0x13c5, 0x3b, 0x13a4, 0x3b, 0x7a, 0x61, 0x6e,
0x3b, 0x66, 0x65, 0x76, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x61, 0x76, 0x72, 0x3b, 0x6d, 0x65, 0x3b, 0x7a, 0x69, 0x6e, 0x3b,
0x7a, 0x69, 0x6c, 0x3b, 0x6f, 0x75, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x3b, 0x6f, 0x6b, 0x74, 0x3b, 0x6e, 0x6f, 0x76, 0x3b,
0x64, 0x65, 0x73, 0x3b, 0x7a, 0x61, 0x6e, 0x76, 0x69, 0x65, 0x3b, 0x66, 0x65, 0x76, 0x72, 0x69, 0x79, 0x65, 0x3b, 0x6d,
0x61, 0x72, 0x73, 0x3b, 0x61, 0x76, 0x72, 0x69, 0x6c, 0x3b, 0x6d, 0x65, 0x3b, 0x7a, 0x69, 0x6e, 0x3b, 0x7a, 0x69, 0x6c,
0x79, 0x65, 0x3b, 0x6f, 0x75, 0x74, 0x3b, 0x73, 0x65, 0x70, 0x74, 0x61, 0x6d, 0x3b, 0x6f, 0x6b, 0x74, 0x6f, 0x62, 0x3b,
0x6e, 0x6f, 0x76, 0x61, 0x6d, 0x3b, 0x64, 0x65, 0x73, 0x61, 0x6d, 0x3b, 0x7a, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x61, 0x3b,
0x6d, 0x3b, 0x7a, 0x3b, 0x7a, 0x3b, 0x6f, 0x3b, 0x73, 0x3b, 0x6f, 0x3b, 0x6e, 0x3b, 0x64, 0x3b, 0x4d, 0x77, 0x65, 0x64,
0x69, 0x20, 0x4e, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x50, 0x69,
0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x54, 0x61, 0x74, 0x75, 0x3b, 0x4d, 0x77, 0x65,
0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x63, 0x68, 0x65, 0x63, 0x68, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20,
0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e,
0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x55, 0x6d, 0x6f, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77,
0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d, 0x69, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x4d,
0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d, 0x69,
0x74, 0x61, 0x74, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f,
0x20, 0x6e, 0x61, 0x20, 0x4e, 0x63, 0x68, 0x65, 0x63, 0x68, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61,
0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x77,
0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6e, 0x79,
0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x55, 0x3b, 0x4d, 0x77, 0x65, 0x64, 0x69, 0x20, 0x77, 0x61, 0x20, 0x4e, 0x6e,
0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x4d, 0x3b,
0x46, 0xfa, 0x6e, 0x67, 0x61, 0x74, 0x268, 0x3b, 0x4e, 0x61, 0x61, 0x6e, 0x268, 0x3b, 0x4b, 0x65, 0x65, 0x6e, 0x64, 0x61,
0x3b, 0x49, 0x6b, 0xfa, 0x6d, 0x69, 0x3b, 0x49, 0x6e, 0x79, 0x61, 0x6d, 0x62, 0x61, 0x6c, 0x61, 0x3b, 0x49, 0x64, 0x77,
0x61, 0x61, 0x74, 0x61, 0x3b, 0x4d, 0x289, 0x289, 0x6e, 0x63, 0x68, 0x268, 0x3b, 0x56, 0x268, 0x268, 0x72, 0x268, 0x3b, 0x53,
0x61, 0x61, 0x74, 0x289, 0x3b, 0x49, 0x6e, 0x79, 0x69, 0x3b, 0x53, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x53, 0x61, 0x73, 0x61,
0x74, 0x289, 0x3b, 0x4b, 0x289, 0x66, 0xfa, 0x6e, 0x67, 0x61, 0x74, 0x268, 0x3b, 0x4b, 0x289, 0x6e, 0x61, 0x61, 0x6e, 0x268,
0x3b, 0x4b, 0x289, 0x6b, 0x65, 0x65, 0x6e, 0x64, 0x61, 0x3b, 0x4b, 0x77, 0x69, 0x69, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4b,
0x77, 0x69, 0x69, 0x6e, 0x79, 0x61, 0x6d, 0x62, 0xe1, 0x6c, 0x61, 0x3b, 0x4b, 0x77, 0x69, 0x69, 0x64, 0x77, 0x61, 0x61,
0x74, 0x61, 0x3b, 0x4b, 0x289, 0x6d, 0x289, 0x289, 0x6e, 0x63, 0x68, 0x268, 0x3b, 0x4b, 0x289, 0x76, 0x268, 0x268, 0x72, 0x268,
0x3b, 0x4b, 0x289, 0x73, 0x61, 0x61, 0x74, 0x289, 0x3b, 0x4b, 0x77, 0x69, 0x69, 0x6e, 0x79, 0x69, 0x3b, 0x4b, 0x289, 0x73,
0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x4b, 0x289, 0x73, 0x61, 0x73, 0x61, 0x74, 0x289, 0x3b, 0x46, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b,
0x49, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x4d, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4a, 0x61,
0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x75, 0x3b, 0x4d, 0x61, 0x61, 0x3b, 0x4a, 0x75,
0x75, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x75, 0x3b, 0x53, 0x65, 0x62, 0x3b, 0x4f, 0x6b, 0x69, 0x3b, 0x4e, 0x6f,
0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x77, 0x61, 0x6c, 0x69, 0x79, 0x6f, 0x3b, 0x46, 0x65, 0x62, 0x77,
0x61, 0x6c, 0x69, 0x79, 0x6f, 0x3b, 0x4d, 0x61, 0x72, 0x69, 0x73, 0x69, 0x3b, 0x41, 0x70, 0x75, 0x6c, 0x69, 0x3b, 0x4d,
0x61, 0x61, 0x79, 0x69, 0x3b, 0x4a, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x61, 0x79, 0x69, 0x3b, 0x41,
0x67, 0x75, 0x73, 0x69, 0x74, 0x6f, 0x3b, 0x53, 0x65, 0x62, 0x75, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b,
0x69, 0x74, 0x6f, 0x62, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d,
0x62, 0x61, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x45, 0x70, 0x72, 0x3b, 0x4d,
0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x4f, 0x67, 0x61, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f,
0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x69, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x46,
0x65, 0x62, 0x72, 0x75, 0x61, 0x72, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x45, 0x70, 0x72, 0x65, 0x6f, 0x3b,
0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x4f, 0x67, 0x61, 0x73, 0x74,
0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x3b, 0x4e, 0x6f,
0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x45, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4f, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4a, 0x61,
0x6e, 0x3b, 0x46, 0x65, 0x76, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x69, 0x3b, 0x4a, 0x75,
0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x74, 0x3b, 0x4f, 0x74, 0x75, 0x3b, 0x4e, 0x75,
0x76, 0x3b, 0x44, 0x69, 0x7a, 0x3b, 0x4a, 0x61, 0x6e, 0x65, 0x72, 0x75, 0x3b, 0x46, 0x65, 0x76, 0x65, 0x72, 0x65, 0x72,
0x75, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x75, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x69, 0x75, 0x3b, 0x4a,
0x75, 0x6e, 0x68, 0x75, 0x3b, 0x4a, 0x75, 0x6c, 0x68, 0x75, 0x3b, 0x41, 0x67, 0x6f, 0x73, 0x74, 0x75, 0x3b, 0x53, 0x65,
0x74, 0x65, 0x6e, 0x62, 0x72, 0x75, 0x3b, 0x4f, 0x74, 0x75, 0x62, 0x72, 0x75, 0x3b, 0x4e, 0x75, 0x76, 0x65, 0x6e, 0x62,
0x72, 0x75, 0x3b, 0x44, 0x69, 0x7a, 0x65, 0x6e, 0x62, 0x72, 0x75, 0x3b, 0x4a, 0x41, 0x4e, 0x3b, 0x46, 0x45, 0x42, 0x3b,
0x4d, 0x41, 0x43, 0x3b, 0x128, 0x50, 0x55, 0x3b, 0x4d, 0x128, 0x128, 0x3b, 0x4e, 0x4a, 0x55, 0x3b, 0x4e, 0x4a, 0x52, 0x3b,
0x41, 0x47, 0x41, 0x3b, 0x53, 0x50, 0x54, 0x3b, 0x4f, 0x4b, 0x54, 0x3b, 0x4e, 0x4f, 0x56, 0x3b, 0x44, 0x45, 0x43, 0x3b,
0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x129, 0x3b, 0x46, 0x65, 0x62, 0x75, 0x72, 0x75, 0x61, 0x72, 0x129, 0x3b, 0x4d, 0x61,
0x63, 0x68, 0x69, 0x3b, 0x128, 0x70, 0x75, 0x72, 0x169, 0x3b, 0x4d, 0x129, 0x129, 0x3b, 0x4e, 0x6a, 0x75, 0x6e, 0x69, 0x3b,
0x4e, 0x6a, 0x75, 0x72, 0x61, 0x129, 0x3b, 0x41, 0x67, 0x61, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d,
0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x169, 0x62, 0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x69,
0x63, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4a, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x128, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b,
0x41, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4d, 0x75, 0x6c, 0x3b, 0x4e, 0x67, 0x61, 0x3b, 0x4b, 0x69,
0x70, 0x3b, 0x49, 0x77, 0x61, 0x3b, 0x4e, 0x67, 0x65, 0x3b, 0x57, 0x61, 0x6b, 0x3b, 0x52, 0x6f, 0x70, 0x3b, 0x4b, 0x6f,
0x67, 0x3b, 0x42, 0x75, 0x72, 0x3b, 0x45, 0x70, 0x65, 0x3b, 0x54, 0x61, 0x69, 0x3b, 0x41, 0x65, 0x6e, 0x3b, 0x4d, 0x75,
0x6c, 0x67, 0x75, 0x6c, 0x3b, 0x4e, 0x67, 0x27, 0x61, 0x74, 0x79, 0x61, 0x74, 0x6f, 0x3b, 0x4b, 0x69, 0x70, 0x74, 0x61,
0x6d, 0x6f, 0x3b, 0x49, 0x77, 0x61, 0x74, 0x20, 0x6b, 0x75, 0x74, 0x3b, 0x4e, 0x67, 0x27, 0x65, 0x69, 0x79, 0x65, 0x74,
0x3b, 0x57, 0x61, 0x6b, 0x69, 0x3b, 0x52, 0x6f, 0x70, 0x74, 0x75, 0x69, 0x3b, 0x4b, 0x69, 0x70, 0x6b, 0x6f, 0x67, 0x61,
0x67, 0x61, 0x3b, 0x42, 0x75, 0x72, 0x65, 0x74, 0x3b, 0x45, 0x70, 0x65, 0x73, 0x6f, 0x3b, 0x4b, 0x69, 0x70, 0x73, 0x75,
0x6e, 0x64, 0x65, 0x20, 0x6e, 0x65, 0x74, 0x61, 0x69, 0x3b, 0x4b, 0x69, 0x70, 0x73, 0x75, 0x6e, 0x64, 0x65, 0x20, 0x6e,
0x65, 0x62, 0x6f, 0x20, 0x61, 0x65, 0x6e, 0x67, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4b, 0x3b, 0x49, 0x3b, 0x4e, 0x3b, 0x57,
0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x42, 0x3b, 0x45, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x1c3, 0x4b, 0x68, 0x61, 0x6e, 0x6e, 0x69,
0x3b, 0x1c3, 0x4b, 0x68, 0x61, 0x6e, 0x1c0, 0x67, 0xf4, 0x61, 0x62, 0x3b, 0x1c0, 0x4b, 0x68, 0x75, 0x75, 0x1c1, 0x6b, 0x68,
0xe2, 0x62, 0x3b, 0x1c3, 0x48, 0xf4, 0x61, 0x1c2, 0x6b, 0x68, 0x61, 0x69, 0x62, 0x3b, 0x1c3, 0x4b, 0x68, 0x61, 0x69, 0x74,
0x73, 0xe2, 0x62, 0x3b, 0x47, 0x61, 0x6d, 0x61, 0x1c0, 0x61, 0x65, 0x62, 0x3b, 0x1c2, 0x4b, 0x68, 0x6f, 0x65, 0x73, 0x61,
0x6f, 0x62, 0x3b, 0x41, 0x6f, 0x1c1, 0x6b, 0x68, 0x75, 0x75, 0x6d, 0xfb, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x54, 0x61,
0x72, 0x61, 0x1c0, 0x6b, 0x68, 0x75, 0x75, 0x6d, 0xfb, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x1c2, 0x4e, 0xfb, 0x1c1, 0x6e,
0xe2, 0x69, 0x73, 0x65, 0x62, 0x3b, 0x1c0, 0x48, 0x6f, 0x6f, 0x1c2, 0x67, 0x61, 0x65, 0x62, 0x3b, 0x48, 0xf4, 0x61, 0x73,
0x6f, 0x72, 0x65, 0x1c1, 0x6b, 0x68, 0xe2, 0x62, 0x3b, 0x4a, 0x61, 0x6e, 0x2e, 0x3b, 0x46, 0xe4, 0x62, 0x2e, 0x3b, 0x4d,
0x61, 0x72, 0x2e, 0x3b, 0x41, 0x70, 0x72, 0x2e, 0x3b, 0x4d, 0xe4, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x2e, 0x3b, 0x4a, 0x75,
0x6c, 0x2e, 0x3b, 0x4f, 0x75, 0x67, 0x2e, 0x3b, 0x53, 0xe4, 0x70, 0x2e, 0x3b, 0x4f, 0x6b, 0x74, 0x2e, 0x3b, 0x4e, 0x6f,
0x76, 0x2e, 0x3b, 0x44, 0x65, 0x7a, 0x2e, 0x3b, 0x4a, 0x61, 0x6e, 0x6e, 0x65, 0x77, 0x61, 0x3b, 0x46, 0xe4, 0x62, 0x72,
0x6f, 0x77, 0x61, 0x3b, 0x4d, 0xe4, 0xe4, 0x7a, 0x3b, 0x41, 0x70, 0x72, 0x65, 0x6c, 0x6c, 0x3b, 0x4d, 0xe4, 0x69, 0x3b,
0x4a, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x75, 0x6c, 0x69, 0x3b, 0x4f, 0x75, 0x6a, 0x6f, 0xdf, 0x3b, 0x53, 0x65,
0x70, 0x74, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x6f, 0x76,
0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x7a, 0xe4, 0x6d, 0x62, 0x65, 0x72, 0x3b, 0x44, 0x61, 0x6c, 0x3b, 0x41,
0x72, 0xe1, 0x3b, 0x186, 0x25b, 0x6e, 0x3b, 0x44, 0x6f, 0x79, 0x3b, 0x4c, 0xe9, 0x70, 0x3b, 0x52, 0x6f, 0x6b, 0x3b, 0x53,
0xe1, 0x73, 0x3b, 0x42, 0x254, 0x301, 0x72, 0x3b, 0x4b, 0xfa, 0x73, 0x3b, 0x47, 0xed, 0x73, 0x3b, 0x53, 0x68, 0x289, 0x301,
0x3b, 0x4e, 0x74, 0x289, 0x301, 0x3b, 0x4f, 0x6c, 0x61, 0x64, 0x61, 0x6c, 0x289, 0x301, 0x3b, 0x41, 0x72, 0xe1, 0x74, 0x3b,
0x186, 0x25b, 0x6e, 0x268, 0x301, 0x254, 0x268, 0x14b, 0x254, 0x6b, 0x3b, 0x4f, 0x6c, 0x6f, 0x64, 0x6f, 0x79, 0xed, 0xf3, 0x72,
0xed, 0xea, 0x20, 0x69, 0x6e, 0x6b, 0xf3, 0x6b, 0xfa, 0xe2, 0x3b, 0x4f, 0x6c, 0x6f, 0x69, 0x6c, 0xe9, 0x70, 0x16b, 0x6e,
0x79, 0x12b, 0x113, 0x20, 0x69, 0x6e, 0x6b, 0xf3, 0x6b, 0xfa, 0xe2, 0x3b, 0x4b, 0xfa, 0x6a, 0xfa, 0x254, 0x72, 0x254, 0x6b,
0x3b, 0x4d, 0xf3, 0x72, 0x75, 0x73, 0xe1, 0x73, 0x69, 0x6e, 0x3b, 0x186, 0x6c, 0x254, 0x301, 0x268, 0x301, 0x62, 0x254, 0x301,
0x72, 0xe1, 0x72, 0x25b, 0x3b, 0x4b, 0xfa, 0x73, 0x68, 0xee, 0x6e, 0x3b, 0x4f, 0x6c, 0x67, 0xed, 0x73, 0x61, 0x6e, 0x3b,
0x50, 0x289, 0x73, 0x68, 0x289, 0x301, 0x6b, 0x61, 0x3b, 0x4e, 0x74, 0x289, 0x301, 0x14b, 0x289, 0x301, 0x73, 0x3b, 0x4a, 0x61,
0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x70, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75,
0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f,
0x76, 0x3b, 0x44, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x63, 0x3b, 0x41, 0x70,
0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x3b, 0x4a, 0x75, 0x6c, 0x3b, 0x41, 0x67, 0x6f, 0x3b, 0x53, 0x65,
0x70, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f, 0x76, 0x3b, 0x44, 0x65, 0x63, 0x3b, 0x52, 0x61, 0x72, 0x3b, 0x4d, 0x75,
0x6b, 0x3b, 0x4b, 0x77, 0x61, 0x3b, 0x44, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x6f, 0x64, 0x3b, 0x4a, 0x6f,
0x6c, 0x3b, 0x50, 0x65, 0x64, 0x3b, 0x53, 0x6f, 0x6b, 0x3b, 0x54, 0x69, 0x62, 0x3b, 0x4c, 0x61, 0x62, 0x3b, 0x50, 0x6f,
0x6f, 0x3b, 0x4f, 0x72, 0x61, 0x72, 0x61, 0x3b, 0x4f, 0x6d, 0x75, 0x6b, 0x3b, 0x4f, 0x6b, 0x77, 0x61, 0x6d, 0x67, 0x27,
0x3b, 0x4f, 0x64, 0x75, 0x6e, 0x67, 0x27, 0x65, 0x6c, 0x3b, 0x4f, 0x6d, 0x61, 0x72, 0x75, 0x6b, 0x3b, 0x4f, 0x6d, 0x6f,
0x64, 0x6f, 0x6b, 0x27, 0x6b, 0x69, 0x6e, 0x67, 0x27, 0x6f, 0x6c, 0x3b, 0x4f, 0x6a, 0x6f, 0x6c, 0x61, 0x3b, 0x4f, 0x70,
0x65, 0x64, 0x65, 0x6c, 0x3b, 0x4f, 0x73, 0x6f, 0x6b, 0x6f, 0x73, 0x6f, 0x6b, 0x6f, 0x6d, 0x61, 0x3b, 0x4f, 0x74, 0x69,
0x62, 0x61, 0x72, 0x3b, 0x4f, 0x6c, 0x61, 0x62, 0x6f, 0x72, 0x3b, 0x4f, 0x70, 0x6f, 0x6f, 0x3b, 0x52, 0x3b, 0x4d, 0x3b,
0x4b, 0x3b, 0x44, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x50, 0x3b,
0x17d, 0x61, 0x6e, 0x3b, 0x46, 0x65, 0x65, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x41, 0x77, 0x69, 0x3b, 0x4d, 0x65, 0x3b, 0x17d,
0x75, 0x77, 0x3b, 0x17d, 0x75, 0x79, 0x3b, 0x55, 0x74, 0x3b, 0x53, 0x65, 0x6b, 0x3b, 0x4f, 0x6b, 0x74, 0x3b, 0x4e, 0x6f,
0x6f, 0x3b, 0x44, 0x65, 0x65, 0x3b, 0x17d, 0x61, 0x6e, 0x77, 0x69, 0x79, 0x65, 0x3b, 0x46, 0x65, 0x65, 0x77, 0x69, 0x72,
0x69, 0x79, 0x65, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x69, 0x3b, 0x41, 0x77, 0x69, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x65, 0x3b,
0x17d, 0x75, 0x77, 0x65, 0x14b, 0x3b, 0x17d, 0x75, 0x79, 0x79, 0x65, 0x3b, 0x55, 0x74, 0x3b, 0x53, 0x65, 0x6b, 0x74, 0x61,
0x6e, 0x62, 0x75, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x75, 0x72, 0x3b, 0x4e, 0x6f, 0x6f, 0x77, 0x61, 0x6e,
0x62, 0x75, 0x72, 0x3b, 0x44, 0x65, 0x65, 0x73, 0x61, 0x6e, 0x62, 0x75, 0x72, 0x3b, 0x17d, 0x3b, 0x46, 0x3b, 0x4d, 0x3b,
0x41, 0x3b, 0x4d, 0x3b, 0x17d, 0x3b, 0x17d, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x44, 0x41,
0x43, 0x3b, 0x44, 0x41, 0x52, 0x3b, 0x44, 0x41, 0x44, 0x3b, 0x44, 0x41, 0x4e, 0x3b, 0x44, 0x41, 0x48, 0x3b, 0x44, 0x41,
0x55, 0x3b, 0x44, 0x41, 0x4f, 0x3b, 0x44, 0x41, 0x42, 0x3b, 0x44, 0x4f, 0x43, 0x3b, 0x44, 0x41, 0x50, 0x3b, 0x44, 0x47,
0x49, 0x3b, 0x44, 0x41, 0x47, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x63, 0x68, 0x69, 0x65, 0x6c,
0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d,
0x61, 0x72, 0x20, 0x41, 0x64, 0x65, 0x6b, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x6e, 0x67, 0x27,
0x77, 0x65, 0x6e, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x62, 0x69, 0x63, 0x68, 0x3b, 0x44, 0x77,
0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x75, 0x63, 0x68, 0x69, 0x65, 0x6c, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61,
0x72, 0x20, 0x41, 0x62, 0x69, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x62,
0x6f, 0x72, 0x6f, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x4f, 0x63, 0x68, 0x69, 0x6b, 0x6f, 0x3b, 0x44,
0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x70, 0x61, 0x72, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20,
0x67, 0x69, 0x20, 0x61, 0x63, 0x68, 0x69, 0x65, 0x6c, 0x3b, 0x44, 0x77, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x41, 0x70,
0x61, 0x72, 0x20, 0x67, 0x69, 0x20, 0x61, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x43, 0x3b, 0x52, 0x3b, 0x44, 0x3b, 0x4e, 0x3b,
0x42, 0x3b, 0x55, 0x3b, 0x42, 0x3b, 0x42, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x59, 0x65, 0x6e, 0x3b,
0x59, 0x65, 0x62, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x49, 0x62, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x3b, 0x59, 0x75, 0x6e, 0x3b,
0x59, 0x75, 0x6c, 0x3b, 0x194, 0x75, 0x63, 0x3b, 0x43, 0x75, 0x74, 0x3b, 0x4b, 0x1e6d, 0x75, 0x3b, 0x4e, 0x77, 0x61, 0x3b,
0x44, 0x75, 0x6a, 0x3b, 0x59, 0x65, 0x6e, 0x6e, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x59, 0x65, 0x62, 0x72, 0x61, 0x79, 0x65,
0x72, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x3b, 0x49, 0x62, 0x72, 0x69, 0x72, 0x3b, 0x4d, 0x61, 0x79, 0x79, 0x75, 0x3b, 0x59,
0x75, 0x6e, 0x79, 0x75, 0x3b, 0x59, 0x75, 0x6c, 0x79, 0x75, 0x7a, 0x3b, 0x194, 0x75, 0x63, 0x74, 0x3b, 0x43, 0x75, 0x74,
0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x4b, 0x1e6d, 0x75, 0x62, 0x65, 0x72, 0x3b, 0x4e, 0x77, 0x61, 0x6e, 0x62, 0x69, 0x72,
0x3b, 0x44, 0x75, 0x6a, 0x61, 0x6e, 0x62, 0x69, 0x72, 0x3b, 0x59, 0x3b, 0x59, 0x3b, 0x4d, 0x3b, 0x49, 0x3b, 0x4d, 0x3b,
0x59, 0x3b, 0x59, 0x3b, 0x194, 0x3b, 0x43, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x44, 0x3b, 0x4a, 0x61, 0x6e, 0x75, 0x61, 0x6c,
0x69, 0x3b, 0x46, 0x65, 0x62, 0x6c, 0x75, 0x61, 0x6c, 0x69, 0x3b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x3b, 0x41, 0x70, 0x6c,
0x69, 0x6c, 0x69, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x4a, 0x75, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6c, 0x61, 0x69, 0x3b, 0x41,
0x67, 0x6f, 0x73, 0x74, 0x69, 0x3b, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62,
0x61, 0x3b, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x44, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x61, 0x3b, 0x91c, 0x93e,
0x928, 0x941, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92b, 0x947, 0x92c, 0x94d, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x940, 0x3b, 0x92e, 0x93e,
0x930, 0x94d, 0x938, 0x3b, 0x90f, 0x92b, 0x94d, 0x930, 0x93f, 0x932, 0x3b, 0x92e, 0x947, 0x3b, 0x91c, 0x941, 0x928, 0x3b, 0x91c, 0x941,
0x932, 0x93e, 0x907, 0x3b, 0x906, 0x917, 0x938, 0x94d, 0x925, 0x3b, 0x938, 0x947, 0x92c, 0x925, 0x947, 0x91c, 0x94d, 0x92c, 0x93c, 0x930,
0x3b, 0x905, 0x916, 0x925, 0x92c, 0x930, 0x3b, 0x928, 0x92c, 0x947, 0x91c, 0x94d, 0x92c, 0x93c, 0x930, 0x3b, 0x926, 0x93f, 0x938, 0x947,
0x91c, 0x94d, 0x92c, 0x93c, 0x930, 0x3b, 0x91c, 0x3b, 0x92b, 0x947, 0x3b, 0x92e, 0x93e, 0x3b, 0x90f, 0x3b, 0x92e, 0x947, 0x3b, 0x91c,
0x941, 0x3b, 0x91c, 0x941, 0x3b, 0x906, 0x3b, 0x938, 0x947, 0x3b, 0x905, 0x3b, 0x928, 0x3b, 0x926, 0x93f, 0x3b, 0x6e, 0xf9, 0x6d,
0x3b, 0x6b, 0x268, 0x7a, 0x3b, 0x74, 0x268, 0x64, 0x3b, 0x74, 0x61, 0x61, 0x3b, 0x73, 0x65, 0x65, 0x3b, 0x6e, 0x7a, 0x75,
0x3b, 0x64, 0x75, 0x6d, 0x3b, 0x66, 0x254, 0x65, 0x3b, 0x64, 0x7a, 0x75, 0x3b, 0x6c, 0x254, 0x6d, 0x3b, 0x6b, 0x61, 0x61,
0x3b, 0x66, 0x77, 0x6f, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x6e, 0xf9, 0x6d, 0x3b, 0x6e, 0x64, 0x7a,
0x254, 0x300, 0x14b, 0x254, 0x300, 0x6b, 0x197, 0x300, 0x7a, 0xf9, 0x294, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300,
0x74, 0x197, 0x300, 0x64, 0x289, 0x300, 0x67, 0x68, 0xe0, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x74, 0x1ce,
0x61, 0x66, 0x289, 0x304, 0x67, 0x68, 0x101, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0xe8, 0x73, 0xe8, 0x65, 0x3b, 0x6e,
0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x6e, 0x7a, 0xf9, 0x67, 0x68, 0xf2, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b,
0x254, 0x300, 0x64, 0xf9, 0x6d, 0x6c, 0x6f, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x6b, 0x77, 0xee, 0x66,
0x254, 0x300, 0x65, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x74, 0x197, 0x300, 0x66, 0x289, 0x300, 0x67, 0x68,
0xe0, 0x64, 0x7a, 0x75, 0x67, 0x68, 0xf9, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x67, 0x68, 0x1d4, 0x75,
0x77, 0x65, 0x6c, 0x254, 0x300, 0x6d, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0x254, 0x300, 0x63, 0x68, 0x77, 0x61, 0x294,
0xe0, 0x6b, 0x61, 0x61, 0x20, 0x77, 0x6f, 0x3b, 0x6e, 0x64, 0x7a, 0x254, 0x300, 0x14b, 0xe8, 0x66, 0x77, 0xf2, 0x6f, 0x3b,
0x6e, 0x3b, 0x6b, 0x3b, 0x74, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x7a, 0x3b, 0x6b, 0x3b, 0x66, 0x3b, 0x64, 0x3b, 0x6c, 0x3b,
0x63, 0x3b, 0x66, 0x3b, 0x6b, 0x254, 0x6e, 0x3b, 0x6d, 0x61, 0x63, 0x3b, 0x6d, 0x61, 0x74, 0x3b, 0x6d, 0x74, 0x6f, 0x3b,
0x6d, 0x70, 0x75, 0x3b, 0x68, 0x69, 0x6c, 0x3b, 0x6e, 0x6a, 0x65, 0x3b, 0x68, 0x69, 0x6b, 0x3b, 0x64, 0x69, 0x70, 0x3b,
0x62, 0x69, 0x6f, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x6c, 0x69, 0x253, 0x3b, 0x4b, 0x254, 0x6e, 0x64, 0x254, 0x14b, 0x3b, 0x4d,
0xe0, 0x63, 0x25b, 0x302, 0x6c, 0x3b, 0x4d, 0xe0, 0x74, 0xf9, 0x6d, 0x62, 0x3b, 0x4d, 0xe0, 0x74, 0x6f, 0x70, 0x3b, 0x4d,
0x300, 0x70, 0x75, 0x79, 0x25b, 0x3b, 0x48, 0xec, 0x6c, 0xf2, 0x6e, 0x64, 0x25b, 0x300, 0x3b, 0x4e, 0x6a, 0xe8, 0x62, 0xe0,
0x3b, 0x48, 0xec, 0x6b, 0x61, 0x14b, 0x3b, 0x44, 0xec, 0x70, 0x254, 0x300, 0x73, 0x3b, 0x42, 0xec, 0xf2, 0xf4, 0x6d, 0x3b,
0x4d, 0xe0, 0x79, 0x25b, 0x73, 0xe8, 0x70, 0x3b, 0x4c, 0xec, 0x62, 0x75, 0x79, 0x20, 0x6c, 0x69, 0x20, 0x144, 0x79, 0xe8,
0x65, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x68, 0x3b, 0x6e, 0x3b, 0x68, 0x3b, 0x64, 0x3b,
0x62, 0x3b, 0x6d, 0x3b, 0x6c, 0x3b, 0x64, 0x69, 0x3b, 0x14b, 0x67, 0x254, 0x6e, 0x3b, 0x73, 0x254, 0x14b, 0x3b, 0x64, 0x69,
0x253, 0x3b, 0x65, 0x6d, 0x69, 0x3b, 0x65, 0x73, 0x254, 0x3b, 0x6d, 0x61, 0x64, 0x3b, 0x64, 0x69, 0x14b, 0x3b, 0x6e, 0x79,
0x25b, 0x74, 0x3b, 0x6d, 0x61, 0x79, 0x3b, 0x74, 0x69, 0x6e, 0x3b, 0x65, 0x6c, 0xe1, 0x3b, 0x64, 0x69, 0x6d, 0x254, 0x301,
0x64, 0x69, 0x3b, 0x14b, 0x67, 0x254, 0x6e, 0x64, 0x25b, 0x3b, 0x73, 0x254, 0x14b, 0x25b, 0x3b, 0x64, 0x69, 0x253, 0xe1, 0x253,
0xe1, 0x3b, 0x65, 0x6d, 0x69, 0x61, 0x73, 0x65, 0x6c, 0x65, 0x3b, 0x65, 0x73, 0x254, 0x70, 0x25b, 0x73, 0x254, 0x70, 0x25b,
0x3b, 0x6d, 0x61, 0x64, 0x69, 0x253, 0x25b, 0x301, 0x64, 0xed, 0x253, 0x25b, 0x301, 0x3b, 0x64, 0x69, 0x14b, 0x67, 0x69, 0x6e,
0x64, 0x69, 0x3b, 0x6e, 0x79, 0x25b, 0x74, 0x25b, 0x6b, 0x69, 0x3b, 0x6d, 0x61, 0x79, 0xe9, 0x73, 0x25b, 0x301, 0x3b, 0x74,
0x69, 0x6e, 0xed, 0x6e, 0xed, 0x3b, 0x65, 0x6c, 0xe1, 0x14b, 0x67, 0x25b, 0x301, 0x3b, 0x64, 0x3b, 0x14b, 0x3b, 0x73, 0x3b,
0x64, 0x3b, 0x65, 0x3b, 0x65, 0x3b, 0x6d, 0x3b, 0x64, 0x3b, 0x6e, 0x3b, 0x6d, 0x3b, 0x74, 0x3b, 0x65, 0x3b, 0x53, 0x61,
0x3b, 0x46, 0x65, 0x3b, 0x4d, 0x61, 0x3b, 0x41, 0x62, 0x3b, 0x4d, 0x65, 0x3b, 0x53, 0x75, 0x3b, 0x53, 0xfa, 0x3b, 0x55,
0x74, 0x3b, 0x53, 0x65, 0x3b, 0x4f, 0x6b, 0x3b, 0x4e, 0x6f, 0x3b, 0x44, 0x65, 0x3b, 0x53, 0x61, 0x6e, 0x76, 0x69, 0x65,
0x3b, 0x46, 0xe9, 0x62, 0x69, 0x72, 0x69, 0x65, 0x3b, 0x4d, 0x61, 0x72, 0x73, 0x3b, 0x41, 0x62, 0x75, 0x72, 0x69, 0x6c,
0x3b, 0x4d, 0x65, 0x65, 0x3b, 0x53, 0x75, 0x65, 0x14b, 0x3b, 0x53, 0xfa, 0x75, 0x79, 0x65, 0x65, 0x3b, 0x55, 0x74, 0x3b,
0x53, 0x65, 0x74, 0x74, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x4e, 0x6f,
0x76, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x44, 0x69, 0x73, 0x61, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x53, 0x3b, 0x46, 0x3b,
0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x4f, 0x3b, 0x4e, 0x3b, 0x44, 0x3b,
0x6e, 0x67, 0x6f, 0x3b, 0x6e, 0x67, 0x62, 0x3b, 0x6e, 0x67, 0x6c, 0x3b, 0x6e, 0x67, 0x6e, 0x3b, 0x6e, 0x67, 0x74, 0x3b,
0x6e, 0x67, 0x73, 0x3b, 0x6e, 0x67, 0x7a, 0x3b, 0x6e, 0x67, 0x6d, 0x3b, 0x6e, 0x67, 0x65, 0x3b, 0x6e, 0x67, 0x61, 0x3b,
0x6e, 0x67, 0x64, 0x3b, 0x6e, 0x67, 0x62, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6f, 0x73, 0xfa, 0x3b, 0x6e, 0x67, 0x254,
0x6e, 0x20, 0x62, 0x25b, 0x30c, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6c, 0xe1, 0x6c, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e,
0x20, 0x6e, 0x79, 0x69, 0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x74, 0xe1, 0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x254,
0x6e, 0x20, 0x73, 0x61, 0x6d, 0x1dd, 0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x7a, 0x61, 0x6d, 0x67, 0x62, 0xe1,
0x6c, 0x61, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x6d, 0x77, 0x6f, 0x6d, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x65, 0x62,
0x75, 0x6c, 0xfa, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x61, 0x77, 0xf3, 0x6d, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x61,
0x77, 0xf3, 0x6d, 0x20, 0x61, 0x69, 0x20, 0x64, 0x7a, 0x69, 0xe1, 0x3b, 0x6e, 0x67, 0x254, 0x6e, 0x20, 0x61, 0x77, 0xf3,
0x6d, 0x20, 0x61, 0x69, 0x20, 0x62, 0x25b, 0x30c, 0x3b, 0x6f, 0x3b, 0x62, 0x3b, 0x6c, 0x3b, 0x6e, 0x3b, 0x74, 0x3b, 0x73,
0x3b, 0x7a, 0x3b, 0x6d, 0x3b, 0x65, 0x3b, 0x61, 0x3b, 0x64, 0x3b, 0x62, 0x3b, 0x14b, 0x31, 0x3b, 0x14b, 0x32, 0x3b, 0x14b,
0x33, 0x3b, 0x14b, 0x34, 0x3b, 0x14b, 0x35, 0x3b, 0x14b, 0x36, 0x3b, 0x14b, 0x37, 0x3b, 0x14b, 0x38, 0x3b, 0x14b, 0x39, 0x3b,
0x14b, 0x31, 0x30, 0x3b, 0x14b, 0x31, 0x31, 0x3b, 0x14b, 0x31, 0x32, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x20, 0x6e,
0x74, 0x254, 0x301, 0x6e, 0x74, 0x254, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x62, 0x25b, 0x301, 0x25b,
0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x72, 0xe1, 0xe1, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61,
0x6b, 0x1dd, 0x20, 0x6e, 0x69, 0x6e, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x6e,
0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x66, 0x254, 0x6b, 0x3b, 0x14b, 0x77, 0xed,
0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x62, 0x25b, 0x25b, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b,
0x1dd, 0x20, 0x74, 0xe1, 0x61, 0x72, 0x61, 0x61, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x74, 0xe1,
0x61, 0x6e, 0x69, 0x6e, 0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x6e, 0x74, 0x25b, 0x6b, 0x3b, 0x14b,
0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x6e, 0x74, 0x25b, 0x6b, 0x20, 0x64, 0x69, 0x20, 0x62, 0x254, 0x301, 0x6b,
0x3b, 0x14b, 0x77, 0xed, 0xed, 0x20, 0x61, 0x6b, 0x1dd, 0x20, 0x6e, 0x74, 0x25b, 0x6b, 0x20, 0x64, 0x69, 0x20, 0x62, 0x25b,
0x301, 0x25b, 0x3b, 0x43, 0x69, 0x6f, 0x3b, 0x4c, 0x75, 0x69, 0x3b, 0x4c, 0x75, 0x73, 0x3b, 0x4d, 0x75, 0x75, 0x3b, 0x4c,
0x75, 0x6d, 0x3b, 0x4c, 0x75, 0x66, 0x3b, 0x4b, 0x61, 0x62, 0x3b, 0x4c, 0x75, 0x73, 0x3b, 0x4c, 0x75, 0x74, 0x3b, 0x4c,
0x75, 0x6e, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x43, 0x69, 0x73, 0x3b, 0x43, 0x69, 0x6f, 0x6e, 0x67, 0x6f, 0x3b, 0x4c, 0xf9,
0x69, 0x73, 0x68, 0x69, 0x3b, 0x4c, 0x75, 0x73, 0xf2, 0x6c, 0x6f, 0x3b, 0x4d, 0xf9, 0x75, 0x79, 0xe0, 0x3b, 0x4c, 0x75,
0x6d, 0xf9, 0x6e, 0x67, 0xf9, 0x6c, 0xf9, 0x3b, 0x4c, 0x75, 0x66, 0x75, 0x69, 0x6d, 0x69, 0x3b, 0x4b, 0x61, 0x62, 0xe0,
0x6c, 0xe0, 0x73, 0x68, 0xec, 0x70, 0xf9, 0x3b, 0x4c, 0xf9, 0x73, 0x68, 0xec, 0x6b, 0xe0, 0x3b, 0x4c, 0x75, 0x74, 0x6f,
0x6e, 0x67, 0x6f, 0x6c, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x67, 0xf9, 0x64, 0x69, 0x3b, 0x4b, 0x61, 0x73, 0x77, 0xe8, 0x6b,
0xe8, 0x73, 0xe8, 0x3b, 0x43, 0x69, 0x73, 0x77, 0xe0, 0x3b, 0x43, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4c, 0x3b,
0x4c, 0x3b, 0x4b, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x43, 0x3b, 0x4b, 0x77, 0x61, 0x3b, 0x55, 0x6e,
0x61, 0x3b, 0x52, 0x61, 0x72, 0x3b, 0x43, 0x68, 0x65, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x4d, 0x6f, 0x63, 0x3b, 0x53, 0x61,
0x62, 0x3b, 0x4e, 0x61, 0x6e, 0x3b, 0x54, 0x69, 0x73, 0x3b, 0x4b, 0x75, 0x6d, 0x3b, 0x4d, 0x6f, 0x6a, 0x3b, 0x59, 0x65,
0x6c, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4d, 0x77,
0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x75, 0x6e, 0x61, 0x79, 0x65, 0x6c, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x6f, 0x20, 0x75, 0x6e, 0x65, 0x72, 0x61, 0x72, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f,
0x20, 0x75, 0x6e, 0x65, 0x63, 0x68, 0x65, 0x73, 0x68, 0x65, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20,
0x75, 0x6e, 0x65, 0x74, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x74, 0x68,
0x61, 0x6e, 0x75, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x63, 0x68, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77,
0x6f, 0x20, 0x73, 0x61, 0x62, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6e, 0x61, 0x6e, 0x65,
0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x74, 0x69, 0x73, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69,
0x20, 0x77, 0x6f, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20, 0x6b, 0x75,
0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x6a, 0x61, 0x3b, 0x4d, 0x77, 0x65, 0x72, 0x69, 0x20, 0x77, 0x6f, 0x20,
0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x79, 0x65, 0x6c, 0x27, 0x6c, 0x69, 0x3b, 0x4b, 0x3b, 0x55, 0x3b, 0x52,
0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x59, 0x3b, 0x46,
0x4c, 0x4f, 0x3b, 0x43, 0x4c, 0x41, 0x3b, 0x43, 0x4b, 0x49, 0x3b, 0x46, 0x4d, 0x46, 0x3b, 0x4d, 0x41, 0x44, 0x3b, 0x4d,
0x42, 0x49, 0x3b, 0x4d, 0x4c, 0x49, 0x3b, 0x4d, 0x41, 0x4d, 0x3b, 0x46, 0x44, 0x45, 0x3b, 0x46, 0x4d, 0x55, 0x3b, 0x46,
0x47, 0x57, 0x3b, 0x46, 0x59, 0x55, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x4c, 0x6f, 0x6f, 0x3b, 0x43, 0x6f, 0x6b, 0x63, 0x77,
0x61, 0x6b, 0x6c, 0x61, 0x14b, 0x6e, 0x65, 0x3b, 0x43, 0x6f, 0x6b, 0x63, 0x77, 0x61, 0x6b, 0x6c, 0x69, 0x69, 0x3b, 0x46,
0x129, 0x69, 0x20, 0x4d, 0x61, 0x72, 0x66, 0x6f, 0x6f, 0x3b, 0x4d, 0x61, 0x64, 0x1dd, 0x1dd, 0x75, 0x75, 0x74, 0x1dd, 0x62,
0x69, 0x6a, 0x61, 0x14b, 0x3b, 0x4d, 0x61, 0x6d, 0x1dd, 0x14b, 0x67, 0x77, 0xe3, 0x61, 0x66, 0x61, 0x68, 0x62, 0x69, 0x69,
0x3b, 0x4d, 0x61, 0x6d, 0x1dd, 0x14b, 0x67, 0x77, 0xe3, 0x61, 0x6c, 0x69, 0x69, 0x3b, 0x4d, 0x61, 0x64, 0x1dd, 0x6d, 0x62,
0x69, 0x69, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x44, 0x1dd, 0x253, 0x6c, 0x69, 0x69, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x4d, 0x75,
0x6e, 0x64, 0x61, 0x14b, 0x3b, 0x46, 0x129, 0x69, 0x20, 0x47, 0x77, 0x61, 0x68, 0x6c, 0x6c, 0x65, 0x3b, 0x46, 0x129, 0x69,
0x20, 0x59, 0x75, 0x72, 0x75, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x46, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x4c, 0x3b,
0x4d, 0x3b, 0x45, 0x3b, 0x55, 0x3b, 0x57, 0x3b, 0x59, 0x3b, 0x6e, 0x67, 0x31, 0x3b, 0x6e, 0x67, 0x32, 0x3b, 0x6e, 0x67,
0x33, 0x3b, 0x6e, 0x67, 0x34, 0x3b, 0x6e, 0x67, 0x35, 0x3b, 0x6e, 0x67, 0x36, 0x3b, 0x6e, 0x67, 0x37, 0x3b, 0x6e, 0x67,
0x38, 0x3b, 0x6e, 0x67, 0x39, 0x3b, 0x6e, 0x67, 0x31, 0x30, 0x3b, 0x6e, 0x67, 0x31, 0x31, 0x3b, 0x6b, 0x72, 0x69, 0x73,
0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x6d, 0x61, 0x74, 0xe1, 0x68, 0x72, 0x61, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e,
0x20, 0x144, 0x6d, 0x62, 0x61, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x6c, 0x61, 0x6c, 0x3b, 0x6e, 0x67, 0x77,
0x25b, 0x6e, 0x20, 0x144, 0x6e, 0x61, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x144, 0x74, 0x61, 0x6e, 0x3b, 0x6e, 0x67,
0x77, 0x25b, 0x6e, 0x20, 0x144, 0x74, 0x75, 0xf3, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x68, 0x25b, 0x6d, 0x62, 0x75,
0x25b, 0x72, 0xed, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x6c, 0x254, 0x6d, 0x62, 0x69, 0x3b, 0x6e, 0x67, 0x77, 0x25b,
0x6e, 0x20, 0x72, 0x25b, 0x62, 0x76, 0x75, 0xe2, 0x3b, 0x6e, 0x67, 0x77, 0x25b, 0x6e, 0x20, 0x77, 0x75, 0x6d, 0x3b, 0x6e,
0x67, 0x77, 0x25b, 0x6e, 0x20, 0x77, 0x75, 0x6d, 0x20, 0x6e, 0x61, 0x76, 0x16d, 0x72, 0x3b, 0x6b, 0x72, 0xed, 0x73, 0x69,
0x6d, 0x69, 0x6e, 0x3b, 0x54, 0x69, 0x6f, 0x70, 0x3b, 0x50, 0x25b, 0x74, 0x3b, 0x44, 0x75, 0x254, 0x331, 0x254, 0x331, 0x3b,
0x44, 0x75, 0x61, 0x3b, 0x44, 0x75, 0xe4, 0x3b, 0x4b, 0x6f, 0x72, 0x3b, 0x50, 0x61, 0x79, 0x3b, 0x54, 0x68, 0x6f, 0x6f,
0x3b, 0x54, 0x25b, 0x25b, 0x3b, 0x4c, 0x61, 0x61, 0x3b, 0x4b, 0x75, 0x72, 0x3b, 0x54, 0x69, 0x6f, 0x70, 0x3b, 0x54, 0x69,
0x6f, 0x70, 0x20, 0x74, 0x68, 0x61, 0x72, 0x20, 0x70, 0x25b, 0x74, 0x3b, 0x50, 0x25b, 0x74, 0x3b, 0x44, 0x75, 0x254, 0x331,
0x254, 0x331, 0x14b, 0x3b, 0x47, 0x75, 0x61, 0x6b, 0x3b, 0x44, 0x75, 0xe4, 0x74, 0x3b, 0x4b, 0x6f, 0x72, 0x6e, 0x79, 0x6f,
0x6f, 0x74, 0x3b, 0x50, 0x61, 0x79, 0x20, 0x79, 0x69, 0x65, 0x331, 0x74, 0x6e, 0x69, 0x3b, 0x54, 0x68, 0x6f, 0x331, 0x6f,
0x331, 0x72, 0x3b, 0x54, 0x25b, 0x25b, 0x72, 0x3b, 0x4c, 0x61, 0x61, 0x74, 0x68, 0x3b, 0x4b, 0x75, 0x72, 0x3b, 0x54, 0x69,
0x6f, 0x331, 0x70, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x69, 0x331, 0x69, 0x331, 0x74, 0x3b, 0x54, 0x3b, 0x50, 0x3b, 0x44, 0x3b,
0x47, 0x3b, 0x44, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x422, 0x43e,
0x445, 0x441, 0x3b, 0x41e, 0x43b, 0x443, 0x43d, 0x3b, 0x41a, 0x43b, 0x43d, 0x5f, 0x442, 0x442, 0x440, 0x3b, 0x41c, 0x443, 0x441, 0x5f,
0x443, 0x441, 0x442, 0x3b, 0x42b, 0x430, 0x43c, 0x5f, 0x439, 0x43d, 0x3b, 0x411, 0x44d, 0x441, 0x5f, 0x439, 0x43d, 0x3b, 0x41e, 0x442,
0x5f, 0x439, 0x43d, 0x3b, 0x410, 0x442, 0x440, 0x434, 0x44c, 0x5f, 0x439, 0x43d, 0x3b, 0x411, 0x43b, 0x495, 0x43d, 0x5f, 0x439, 0x43d,
0x3b, 0x410, 0x43b, 0x442, 0x3b, 0x421, 0x44d, 0x442, 0x3b, 0x410, 0x445, 0x441, 0x3b, 0x422, 0x43e, 0x445, 0x441, 0x443, 0x43d, 0x43d,
0x44c, 0x443, 0x3b, 0x41e, 0x43b, 0x443, 0x43d, 0x43d, 0x44c, 0x443, 0x3b, 0x41a, 0x443, 0x43b, 0x443, 0x43d, 0x20, 0x442, 0x443, 0x442,
0x430, 0x440, 0x3b, 0x41c, 0x443, 0x443, 0x441, 0x20, 0x443, 0x441, 0x442, 0x430, 0x440, 0x3b, 0x42b, 0x430, 0x43c, 0x20, 0x44b, 0x439,
0x44b, 0x43d, 0x3b, 0x411, 0x44d, 0x441, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x41e, 0x442, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b,
0x410, 0x442, 0x44b, 0x440, 0x434, 0x44c, 0x44b, 0x445, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x411, 0x430, 0x43b, 0x430, 0x495, 0x430,
0x43d, 0x20, 0x44b, 0x439, 0x44b, 0x43d, 0x3b, 0x410, 0x43b, 0x442, 0x44b, 0x43d, 0x43d, 0x44c, 0x44b, 0x3b, 0x421, 0x44d, 0x442, 0x438,
0x43d, 0x43d, 0x44c, 0x438, 0x3b, 0x410, 0x445, 0x441, 0x44b, 0x43d, 0x43d, 0x44c, 0x44b, 0x3b, 0x422, 0x3b, 0x41e, 0x3b, 0x41a, 0x3b,
0x41c, 0x3b, 0x42b, 0x3b, 0x411, 0x3b, 0x41e, 0x3b, 0x410, 0x3b, 0x411, 0x3b, 0x410, 0x3b, 0x421, 0x3b, 0x410, 0x3b, 0x4d, 0x75,
0x70, 0x3b, 0x4d, 0x77, 0x69, 0x3b, 0x4d, 0x75, 0x73, 0x3b, 0x4d, 0x75, 0x6e, 0x3b, 0x4d, 0x75, 0x73, 0x3b, 0x4d, 0x75,
0x6a, 0x3b, 0x4d, 0x75, 0x73, 0x3b, 0x4d, 0x75, 0x70, 0x3b, 0x4d, 0x75, 0x6e, 0x3b, 0x4d, 0x6f, 0x6b, 0x3b, 0x4d, 0x75,
0x73, 0x3b, 0x4d, 0x75, 0x68, 0x3b, 0x4d, 0x75, 0x70, 0x61, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x77, 0x61, 0x3b, 0x4d,
0x77, 0x69, 0x74, 0x6f, 0x70, 0x65, 0x3b, 0x4d, 0x75, 0x73, 0x68, 0x65, 0x6e, 0x64, 0x65, 0x3b, 0x4d, 0x75, 0x6e, 0x79,
0x69, 0x3b, 0x4d, 0x75, 0x73, 0x68, 0x65, 0x6e, 0x64, 0x65, 0x20, 0x4d, 0x61, 0x67, 0x61, 0x6c, 0x69, 0x3b, 0x4d, 0x75,
0x6a, 0x69, 0x6d, 0x62, 0x69, 0x3b, 0x4d, 0x75, 0x73, 0x68, 0x69, 0x70, 0x65, 0x70, 0x6f, 0x3b, 0x4d, 0x75, 0x70, 0x75,
0x67, 0x75, 0x74, 0x6f, 0x3b, 0x4d, 0x75, 0x6e, 0x79, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x4d, 0x6f, 0x6b, 0x68, 0x75, 0x3b,
0x4d, 0x75, 0x73, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x64, 0x65, 0x6d, 0x62, 0x77, 0x65, 0x3b, 0x4d, 0x75, 0x68, 0x61, 0x61,
0x6e, 0x6f, 0x3b, 0x6d, 0x6b, 0x77, 0x3b, 0x6d, 0x70, 0x69, 0x3b, 0x6d, 0x74, 0x75, 0x3b, 0x6d, 0x69, 0x6e, 0x3b, 0x6d,
0x74, 0x6e, 0x3b, 0x6d, 0x73, 0x74, 0x3b, 0x6d, 0x73, 0x62, 0x3b, 0x6d, 0x75, 0x6e, 0x3b, 0x6d, 0x74, 0x73, 0x3b, 0x6d,
0x6b, 0x75, 0x3b, 0x6d, 0x6b, 0x6d, 0x3b, 0x6d, 0x6b, 0x62, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20,
0x6b, 0x77, 0x61, 0x6e, 0x6a, 0x61, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x70, 0x69, 0x6c, 0x69,
0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69,
0x20, 0x79, 0x61, 0x20, 0x69, 0x6e, 0x65, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x74, 0x61, 0x6e,
0x75, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x73, 0x69, 0x74, 0x61, 0x3b, 0x6d, 0x77, 0x65, 0x7a,
0x69, 0x20, 0x79, 0x61, 0x20, 0x73, 0x61, 0x62, 0x61, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x6d,
0x75, 0x6e, 0x61, 0x6e, 0x65, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x74, 0x69, 0x73, 0x61, 0x3b,
0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x3b, 0x6d, 0x77, 0x65, 0x7a, 0x69, 0x20,
0x79, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x6f, 0x79, 0x61, 0x3b, 0x6d, 0x77, 0x65, 0x7a,
0x69, 0x20, 0x79, 0x61, 0x20, 0x6b, 0x75, 0x6d, 0x69, 0x20, 0x79, 0x61, 0x20, 0x6d, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x6b,
0x3b, 0x70, 0x3b, 0x74, 0x3b, 0x69, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x74, 0x3b, 0x6b, 0x3b, 0x6d,
0x3b, 0x6d, 0x3b, 0xa5a8, 0xa56a, 0xa583, 0x20, 0xa51e, 0xa56e, 0x3b, 0xa552, 0xa561, 0xa59d, 0xa595, 0x3b, 0xa57e, 0xa5ba, 0x3b, 0xa5a2, 0xa595,
0x3b, 0xa591, 0xa571, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0xa5db, 0xa515, 0x3b, 0xa562, 0xa54c, 0x3b, 0xa56d, 0xa583, 0x3b, 0xa51e, 0xa60b, 0xa554,
0xa57f, 0x20, 0xa578, 0xa583, 0xa5cf, 0x3b, 0xa5a8, 0xa56a, 0xa571, 0x20, 0xa5cf, 0xa56e, 0x3b, 0x6c, 0x75, 0x75, 0x6b, 0x61, 0x6f, 0x20,
0x6b, 0x65, 0x6d, 0xe3, 0x3b, 0x253, 0x61, 0x6e, 0x64, 0x61, 0x253, 0x75, 0x3b, 0x76, 0x254, 0x254, 0x3b, 0x66, 0x75, 0x6c,
0x75, 0x3b, 0x67, 0x6f, 0x6f, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x6b, 0x254, 0x6e, 0x64, 0x65, 0x3b, 0x73, 0x61, 0x61, 0x68,
0x3b, 0x67, 0x61, 0x6c, 0x6f, 0x3b, 0x6b, 0x65, 0x6e, 0x70, 0x6b, 0x61, 0x74, 0x6f, 0x20, 0x253, 0x6f, 0x6c, 0x6f, 0x6c,
0x254, 0x3b, 0x6c, 0x75, 0x75, 0x6b, 0x61, 0x6f, 0x20, 0x6c, 0x254, 0x6d, 0x61, 0x3b, 0x4a, 0x65, 0x6e, 0x3b, 0x48, 0x6f,
0x72, 0x3b, 0x4d, 0xe4, 0x72, 0x3b, 0x41, 0x62, 0x72, 0x3b, 0x4d, 0x65, 0x69, 0x3b, 0x42, 0x72, 0xe1, 0x3b, 0x48, 0x65,
0x69, 0x3b, 0xd6, 0x69, 0x67, 0x3b, 0x48, 0x65, 0x72, 0x3b, 0x57, 0xed, 0x6d, 0x3b, 0x57, 0x69, 0x6e, 0x3b, 0x43, 0x68,
0x72, 0x3b, 0x4a, 0x65, 0x6e, 0x6e, 0x65, 0x72, 0x3b, 0x48, 0x6f, 0x72, 0x6e, 0x69, 0x67, 0x3b, 0x4d, 0xe4, 0x72, 0x7a,
0x65, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x6c, 0x65, 0x3b, 0x4d, 0x65, 0x69, 0x6a, 0x65, 0x3b, 0x42, 0x72, 0xe1, 0x10d,
0x65, 0x74, 0x3b, 0x48, 0x65, 0x69, 0x77, 0x65, 0x74, 0x3b, 0xd6, 0x69, 0x67, 0x161, 0x74, 0x65, 0x3b, 0x48, 0x65, 0x72,
0x62, 0x161, 0x74, 0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b, 0x57, 0xed, 0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b, 0x57, 0x69, 0x6e,
0x74, 0x65, 0x72, 0x6d, 0xe1, 0x6e, 0x65, 0x74, 0x3b, 0x43, 0x68, 0x72, 0x69, 0x161, 0x74, 0x6d, 0xe1, 0x6e, 0x65, 0x74,
0x3b, 0x4a, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x42, 0x3b, 0x48, 0x3b, 0xd6, 0x3b, 0x48, 0x3b, 0x57,
0x3b, 0x57, 0x3b, 0x43, 0x3b, 0x6f, 0x2e, 0x31, 0x3b, 0x6f, 0x2e, 0x32, 0x3b, 0x6f, 0x2e, 0x33, 0x3b, 0x6f, 0x2e, 0x34,
0x3b, 0x6f, 0x2e, 0x35, 0x3b, 0x6f, 0x2e, 0x36, 0x3b, 0x6f, 0x2e, 0x37, 0x3b, 0x6f, 0x2e, 0x38, 0x3b, 0x6f, 0x2e, 0x39,
0x3b, 0x6f, 0x2e, 0x31, 0x30, 0x3b, 0x6f, 0x2e, 0x31, 0x31, 0x3b, 0x6f, 0x2e, 0x31, 0x32, 0x3b, 0x70, 0x69, 0x6b, 0xed,
0x74, 0xed, 0x6b, 0xed, 0x74, 0x69, 0x65, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0xed, 0x20, 0xfa, 0x20, 0x6b, 0x75, 0x74, 0xfa,
0x61, 0x6e, 0x3b, 0x73, 0x69, 0x25b, 0x79, 0x25b, 0x301, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe1,
0x6e, 0x64, 0xed, 0x25b, 0x3b, 0x254, 0x6e, 0x73, 0xfa, 0x6d, 0x62, 0x254, 0x6c, 0x2c, 0x20, 0x6f, 0xf3, 0x6c, 0x69, 0x20,
0xfa, 0x20, 0x6b, 0xe1, 0x74, 0xe1, 0x74, 0xfa, 0x25b, 0x3b, 0x6d, 0x65, 0x73, 0x69, 0x14b, 0x2c, 0x20, 0x6f, 0xf3, 0x6c,
0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe9, 0x6e, 0x69, 0x65, 0x3b, 0x65, 0x6e, 0x73, 0x69, 0x6c, 0x2c, 0x20, 0x6f, 0xf3, 0x6c,
0x69, 0x20, 0xfa, 0x20, 0x6b, 0xe1, 0x74, 0xe1, 0x6e, 0x75, 0x25b, 0x3b, 0x254, 0x73, 0x254, 0x6e, 0x3b, 0x65, 0x66, 0x75,
0x74, 0x65, 0x3b, 0x70, 0x69, 0x73, 0x75, 0x79, 0xfa, 0x3b, 0x69, 0x6d, 0x25b, 0x14b, 0x20, 0x69, 0x20, 0x70, 0x75, 0x254,
0x73, 0x3b, 0x69, 0x6d, 0x25b, 0x14b, 0x20, 0x69, 0x20, 0x70, 0x75, 0x74, 0xfa, 0x6b, 0x2c, 0x6f, 0xf3, 0x6c, 0x69, 0x20,
0xfa, 0x20, 0x6b, 0xe1, 0x74, 0xed, 0x25b, 0x3b, 0x6d, 0x61, 0x6b, 0x61, 0x6e, 0x64, 0x69, 0x6b, 0x25b, 0x3b, 0x70, 0x69,
0x6c, 0x254, 0x6e, 0x64, 0x254, 0x301, 0x3b
};

static const ushort days_data[] = {
0x53, 0x75, 0x6e, 0x3b, 0x4d, 0x6f, 0x6e, 0x3b, 0x54, 0x75, 0x65, 0x3b, 0x57, 0x65, 0x64, 0x3b, 0x54, 0x68, 0x75, 0x3b,
0x46, 0x72, 0x69, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x53, 0x75, 0x6e, 0x64, 0x61, 0x79, 0x3b, 0x4d, 0x6f, 0x6e, 0x64, 0x61,
0x79, 0x3b, 0x54, 0x75, 0x65, 0x73, 0x64, 0x61, 0x79, 0x3b, 0x57, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x64, 0x61, 0x79, 0x3b,
0x54, 0x68, 0x75, 0x72, 0x73, 0x64, 0x61, 0x79, 0x3b, 0x46, 0x72, 0x69, 0x64, 0x61, 0x79, 0x3b, 0x53, 0x61, 0x74, 0x75,
0x72, 0x64, 0x61, 0x79, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x57, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x53, 0x3b, 0x37,
0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x44, 0x69, 0x6c, 0x3b, 0x57, 0x69, 0x78,
0x3b, 0x51, 0x69, 0x62, 0x3b, 0x52, 0x6f, 0x62, 0x3b, 0x4b, 0x61, 0x6d, 0x3b, 0x4a, 0x69, 0x6d, 0x3b, 0x53, 0x61, 0x6e,
0x3b, 0x44, 0x69, 0x6c, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x57, 0x69, 0x69, 0x78, 0x61, 0x74, 0x61, 0x3b, 0x51, 0x69, 0x62,
0x78, 0x61, 0x74, 0x61, 0x3b, 0x52, 0x6f, 0x6f, 0x62, 0x69, 0x69, 0x3b, 0x4b, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x61, 0x3b,
0x4a, 0x69, 0x6d, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x6e, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x63, 0x61, 0x3b,
0x45, 0x74, 0x6c, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x41, 0x72, 0x62, 0x3b, 0x4b, 0x61, 0x6d, 0x3b, 0x47, 0x75, 0x6d, 0x3b,
0x53, 0x61, 0x62, 0x3b, 0x41, 0x63, 0x61, 0x61, 0x64, 0x61, 0x3b, 0x45, 0x74, 0x6c, 0x65, 0x65, 0x6e, 0x69, 0x3b, 0x54,
0x61, 0x6c, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x72, 0x62, 0x61, 0x71, 0x61, 0x3b, 0x4b, 0x61, 0x6d, 0x69, 0x69, 0x73,
0x69, 0x3b, 0x47, 0x75, 0x6d, 0x71, 0x61, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x69, 0x3b, 0x41, 0x3b, 0x45, 0x3b,
0x54, 0x3b, 0x41, 0x3b, 0x4b, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x53, 0x6f, 0x3b, 0x4d, 0x61, 0x3b, 0x44, 0x69, 0x3b, 0x57,
0x6f, 0x3b, 0x44, 0x6f, 0x3b, 0x56, 0x72, 0x3b, 0x53, 0x61, 0x3b, 0x53, 0x6f, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x4d, 0x61,
0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x44, 0x69, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x57, 0x6f, 0x65, 0x6e, 0x73, 0x64,
0x61, 0x67, 0x3b, 0x44, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x56, 0x72, 0x79, 0x64, 0x61, 0x67, 0x3b,
0x53, 0x61, 0x74, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x56,
0x3b, 0x53, 0x3b, 0x44, 0x69, 0x65, 0x3b, 0x48, 0xeb, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0xeb, 0x72, 0x3b, 0x45,
0x6e, 0x6a, 0x3b, 0x50, 0x72, 0x65, 0x3b, 0x53, 0x68, 0x74, 0x3b, 0x65, 0x20, 0x64, 0x69, 0x65, 0x6c, 0x3b, 0x65, 0x20,
0x68, 0xeb, 0x6e, 0xeb, 0x3b, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x74, 0xeb, 0x3b, 0x65, 0x20, 0x6d, 0xeb, 0x72, 0x6b, 0x75,
0x72, 0xeb, 0x3b, 0x65, 0x20, 0x65, 0x6e, 0x6a, 0x74, 0x65, 0x3b, 0x65, 0x20, 0x70, 0x72, 0x65, 0x6d, 0x74, 0x65, 0x3b,
0x65, 0x20, 0x73, 0x68, 0x74, 0x75, 0x6e, 0xeb, 0x3b, 0x44, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x45, 0x3b, 0x50,
0x3b, 0x53, 0x3b, 0x12a5, 0x1211, 0x12f5, 0x3b, 0x1230, 0x129e, 0x3b, 0x121b, 0x12ad, 0x1230, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1210, 0x1219,
0x1235, 0x3b, 0x12d3, 0x122d, 0x1265, 0x3b, 0x1245, 0x12f3, 0x121c, 0x3b, 0x12a5, 0x1211, 0x12f5, 0x3b, 0x1230, 0x129e, 0x3b, 0x121b, 0x12ad, 0x1230,
0x129e, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1210, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1265, 0x3b, 0x1245, 0x12f3, 0x121c, 0x3b, 0x12a5, 0x3b,
0x1230, 0x3b, 0x121b, 0x3b, 0x1228, 0x3b, 0x1210, 0x3b, 0x12d3, 0x3b, 0x1245, 0x3b, 0x627, 0x644, 0x623, 0x62d, 0x62f, 0x3b, 0x627, 0x644,
0x627, 0x62b, 0x646, 0x64a, 0x646, 0x3b, 0x627, 0x644, 0x62b, 0x644, 0x627, 0x62b, 0x627, 0x621, 0x3b, 0x627, 0x644, 0x623, 0x631, 0x628,
0x639, 0x627, 0x621, 0x3b, 0x627, 0x644, 0x62e, 0x645, 0x64a, 0x633, 0x3b, 0x627, 0x644, 0x62c, 0x645, 0x639, 0x629, 0x3b, 0x627, 0x644,
0x633, 0x628, 0x62a, 0x3b, 0x62d, 0x3b, 0x646, 0x3b, 0x62b, 0x3b, 0x631, 0x3b, 0x62e, 0x3b, 0x62c, 0x3b, 0x633, 0x3b, 0x53f, 0x56b,
0x580, 0x3b, 0x535, 0x580, 0x56f, 0x3b, 0x535, 0x580, 0x584, 0x3b, 0x549, 0x578, 0x580, 0x3b, 0x540, 0x576, 0x563, 0x3b, 0x548, 0x582,
0x580, 0x3b, 0x547, 0x561, 0x562, 0x3b, 0x53f, 0x56b, 0x580, 0x561, 0x56f, 0x56b, 0x3b, 0x535, 0x580, 0x56f, 0x578, 0x582, 0x577, 0x561,
0x562, 0x569, 0x56b, 0x3b, 0x535, 0x580, 0x565, 0x584, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x549, 0x578, 0x580, 0x565, 0x584, 0x577,
0x561, 0x562, 0x569, 0x56b, 0x3b, 0x540, 0x56b, 0x576, 0x563, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x548, 0x582, 0x580, 0x562, 0x561,
0x569, 0x3b, 0x547, 0x561, 0x562, 0x561, 0x569, 0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b,
0x37, 0x3b, 0x9f0, 0x9ac, 0x9bf, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x3b,
0x9ac, 0x9c3, 0x9b9, 0x9b7, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9f0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x3b, 0x9a6,
0x9c7, 0x993, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x9ac, 0x9be,
0x9f0, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b7, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x9ac, 0x9be, 0x9f0,
0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9f0, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x42, 0x2e, 0x3b,
0x42, 0x2e, 0x45, 0x2e, 0x3b, 0xc7, 0x2e, 0x41, 0x2e, 0x3b, 0xc7, 0x2e, 0x3b, 0x43, 0x2e, 0x41, 0x2e, 0x3b, 0x43, 0x3b,
0x15e, 0x2e, 0x3b, 0x62, 0x61, 0x7a, 0x61, 0x72, 0x3b, 0x62, 0x61, 0x7a, 0x61, 0x72, 0x20, 0x65, 0x72, 0x74, 0x259, 0x73,
0x69, 0x3b, 0xe7, 0x259, 0x72, 0x15f, 0x259, 0x6e, 0x62, 0x259, 0x20, 0x61, 0x78, 0x15f, 0x61, 0x6d, 0x131, 0x3b, 0xe7, 0x259,
0x72, 0x15f, 0x259, 0x6e, 0x62, 0x259, 0x3b, 0x63, 0xfc, 0x6d, 0x259, 0x20, 0x61, 0x78, 0x15f, 0x61, 0x6d, 0x131, 0x3b, 0x63,
0xfc, 0x6d, 0x259, 0x3b, 0x15f, 0x259, 0x6e, 0x62, 0x259, 0x3b, 0x431, 0x430, 0x437, 0x430, 0x440, 0x3b, 0x431, 0x430, 0x437, 0x430,
0x440, 0x20, 0x435, 0x440, 0x442, 0x4d9, 0x441, 0x438, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9, 0x43d, 0x431, 0x4d9, 0x20, 0x430, 0x445,
0x448, 0x430, 0x43c, 0x44b, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9, 0x43d, 0x431, 0x4d9, 0x3b, 0x4b9, 0x4af, 0x43c, 0x4d9, 0x20, 0x430,
0x445, 0x448, 0x430, 0x43c, 0x44b, 0x3b, 0x4b9, 0x4af, 0x43c, 0x4d9, 0x3b, 0x448, 0x4d9, 0x43d, 0x431, 0x4d9, 0x3b, 0x69, 0x67, 0x3b,
0x61, 0x6c, 0x3b, 0x61, 0x73, 0x3b, 0x61, 0x7a, 0x3b, 0x6f, 0x67, 0x3b, 0x6f, 0x72, 0x3b, 0x6c, 0x72, 0x3b, 0x69, 0x67,
0x61, 0x6e, 0x64, 0x65, 0x61, 0x3b, 0x61, 0x73, 0x74, 0x65, 0x6c, 0x65, 0x68, 0x65, 0x6e, 0x61, 0x3b, 0x61, 0x73, 0x74,
0x65, 0x61, 0x72, 0x74, 0x65, 0x61, 0x3b, 0x61, 0x73, 0x74, 0x65, 0x61, 0x7a, 0x6b, 0x65, 0x6e, 0x61, 0x3b, 0x6f, 0x73,
0x74, 0x65, 0x67, 0x75, 0x6e, 0x61, 0x3b, 0x6f, 0x73, 0x74, 0x69, 0x72, 0x61, 0x6c, 0x61, 0x3b, 0x6c, 0x61, 0x72, 0x75,
0x6e, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x49, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x4f, 0x3b, 0x49, 0x3b,
0x49, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x4f, 0x3b, 0x49, 0x3b, 0x9b0, 0x9ac, 0x9bf, 0x3b, 0x9b8, 0x9cb,
0x9ae, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b8, 0x9cd, 0x9aa, 0x9a4, 0x9bf,
0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9b0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x3b, 0x9b0, 0x9ac, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b8, 0x9cb,
0x9ae, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x9ac, 0x9be, 0x9b0,
0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b7, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9b0, 0x9ac, 0x9be,
0x9b0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b0, 0x3b, 0x9b8, 0x9cb, 0x3b, 0x9ae, 0x3b, 0x9ac, 0x9c1, 0x3b, 0x9ac,
0x9c3, 0x3b, 0x9b6, 0x9c1, 0x3b, 0x9b6, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0x3b, 0xf58, 0xf72, 0xf62, 0xf0b, 0x3b, 0xf63, 0xfb7, 0xf42, 0xf0b,
0x3b, 0xf55, 0xf74, 0xf62, 0xf0b, 0x3b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0x3b, 0xf49, 0xf72, 0xf0b,
0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf58, 0xf72, 0xf42, 0xf0b, 0xf51,
0xf58, 0xf62, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf55,
0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf42, 0xf5f,
0xf60, 0xf0b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b,
0x73, 0x75, 0x6c, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x65, 0x75, 0x2e, 0x3b, 0x6d, 0x65, 0x72, 0x2e, 0x3b, 0x79, 0x61,
0x6f, 0x75, 0x3b, 0x67, 0x77, 0x65, 0x2e, 0x3b, 0x73, 0x61, 0x64, 0x2e, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e,
0x3b, 0x4d, 0x65, 0x75, 0x72, 0x7a, 0x68, 0x3b, 0x4d, 0x65, 0x72, 0x63, 0x2bc, 0x68, 0x65, 0x72, 0x3b, 0x59, 0x61, 0x6f,
0x75, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x53, 0x61, 0x64, 0x6f, 0x72, 0x6e, 0x3b, 0x73, 0x75, 0x3b, 0x6c,
0x75, 0x3b, 0x6d, 0x7a, 0x3b, 0x6d, 0x63, 0x3b, 0x79, 0x61, 0x3b, 0x67, 0x77, 0x3b, 0x73, 0x61, 0x3b, 0x43d, 0x434, 0x3b,
0x43f, 0x43d, 0x3b, 0x432, 0x442, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x442, 0x3b, 0x43f, 0x442, 0x3b, 0x441, 0x431, 0x3b, 0x43d, 0x435,
0x434, 0x435, 0x43b, 0x44f, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x43d, 0x438, 0x43a, 0x3b, 0x432, 0x442, 0x43e, 0x440,
0x43d, 0x438, 0x43a, 0x3b, 0x441, 0x440, 0x44f, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x44a, 0x440, 0x442, 0x44a, 0x43a, 0x3b,
0x43f, 0x435, 0x442, 0x44a, 0x43a, 0x3b, 0x441, 0x44a, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x3b, 0x43f, 0x3b, 0x432, 0x3b, 0x441,
0x3b, 0x447, 0x3b, 0x43f, 0x3b, 0x441, 0x3b, 0x1014, 0x103d, 0x1031, 0x3b, 0x101c, 0x102c, 0x3b, 0x1002, 0x102b, 0x3b, 0x101f, 0x1030, 0x1038,
0x3b, 0x1010, 0x1031, 0x1038, 0x3b, 0x1000, 0x103c, 0x102c, 0x3b, 0x1014, 0x1031, 0x3b, 0x1010, 0x1014, 0x1004, 0x103a, 0x1039, 0x1002, 0x1014, 0x103d,
0x1031, 0x3b, 0x1010, 0x1014, 0x1004, 0x103a, 0x1039, 0x101c, 0x102c, 0x3b, 0x1021, 0x1004, 0x103a, 0x1039, 0x1002, 0x102b, 0x3b, 0x1017, 0x102f, 0x1012,
0x1039, 0x1013, 0x101f, 0x1030, 0x1038, 0x3b, 0x1000, 0x103c, 0x102c, 0x101e, 0x1015, 0x1010, 0x1031, 0x1038, 0x3b, 0x101e, 0x1031, 0x102c, 0x1000, 0x103c,
0x102c, 0x3b, 0x1005, 0x1014, 0x1031, 0x3b, 0x1010, 0x3b, 0x1010, 0x3b, 0x1021, 0x3b, 0x1017, 0x3b, 0x1000, 0x3b, 0x101e, 0x3b, 0x1005, 0x3b,
0x43d, 0x434, 0x3b, 0x43f, 0x43d, 0x3b, 0x430, 0x45e, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x446, 0x3b, 0x43f, 0x442, 0x3b, 0x441, 0x431,
0x3b, 0x43d, 0x44f, 0x434, 0x437, 0x435, 0x43b, 0x44f, 0x3b, 0x43f, 0x430, 0x43d, 0x44f, 0x434, 0x437, 0x435, 0x43b, 0x430, 0x43a, 0x3b,
0x430, 0x45e, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441, 0x435, 0x440, 0x430, 0x434, 0x430, 0x3b, 0x447, 0x430, 0x446, 0x432, 0x435,
0x440, 0x3b, 0x43f, 0x44f, 0x442, 0x43d, 0x456, 0x446, 0x430, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x3b, 0x43f,
0x3b, 0x430, 0x3b, 0x441, 0x3b, 0x447, 0x3b, 0x43f, 0x3b, 0x441, 0x3b, 0x17a2, 0x17b6, 0x3b, 0x1785, 0x3b, 0x17a2, 0x3b, 0x1796, 0x17bb,
0x3b, 0x1796, 0x17d2, 0x179a, 0x3b, 0x179f, 0x17bb, 0x3b, 0x179f, 0x3b, 0x1790, 0x17d2, 0x1784, 0x17c3, 0x17a2, 0x17b6, 0x1791, 0x17b7, 0x178f, 0x17d2,
0x1799, 0x3b, 0x200b, 0x1790, 0x17d2, 0x1784, 0x17c3, 0x1785, 0x17d0, 0x1793, 0x17d2, 0x1791, 0x3b, 0x1790, 0x17d2, 0x1784, 0x17c3, 0x17a2, 0x1784, 0x17d2,
0x1782, 0x17b6, 0x179a, 0x3b, 0x1790, 0x17d2, 0x1784, 0x17c3, 0x1796, 0x17bb, 0x1792, 0x3b, 0x1790, 0x17d2, 0x1784, 0x17c3, 0x1796, 0x17d2, 0x179a, 0x17a0,
0x179f, 0x17d2, 0x1794, 0x178f, 0x17b7, 0x17cd, 0x3b, 0x1790, 0x17d2, 0x1784, 0x17c3, 0x179f, 0x17bb, 0x1780, 0x17d2, 0x179a, 0x3b, 0x1790, 0x17d2, 0x1784,
0x17c3, 0x179f, 0x17c5, 0x179a, 0x17cd, 0x3b, 0x64, 0x67, 0x3b, 0x64, 0x6c, 0x3b, 0x64, 0x74, 0x3b, 0x64, 0x63, 0x3b, 0x64, 0x6a,
0x3b, 0x64, 0x76, 0x3b, 0x64, 0x73, 0x3b, 0x44, 0x69, 0x75, 0x6d, 0x65, 0x6e, 0x67, 0x65, 0x3b, 0x44, 0x69, 0x6c, 0x6c,
0x75, 0x6e, 0x73, 0x3b, 0x44, 0x69, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x44, 0x69, 0x6d, 0x65, 0x63, 0x72, 0x65, 0x73,
0x3b, 0x44, 0x69, 0x6a, 0x6f, 0x75, 0x73, 0x3b, 0x44, 0x69, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65, 0x73, 0x3b, 0x44, 0x69,
0x73, 0x73, 0x61, 0x62, 0x74, 0x65, 0x3b, 0x67, 0x3b, 0x6c, 0x3b, 0x74, 0x3b, 0x63, 0x3b, 0x6a, 0x3b, 0x76, 0x3b, 0x73,
0x3b, 0x64, 0x67, 0x2e, 0x3b, 0x64, 0x6c, 0x2e, 0x3b, 0x64, 0x74, 0x2e, 0x3b, 0x64, 0x63, 0x2e, 0x3b, 0x64, 0x6a, 0x2e,
0x3b, 0x64, 0x76, 0x2e, 0x3b, 0x64, 0x73, 0x2e, 0x3b, 0x64, 0x69, 0x75, 0x6d, 0x65, 0x6e, 0x67, 0x65, 0x3b, 0x64, 0x69,
0x6c, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x72, 0x74, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0x65, 0x63, 0x72,
0x65, 0x73, 0x3b, 0x64, 0x69, 0x6a, 0x6f, 0x75, 0x73, 0x3b, 0x64, 0x69, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65, 0x73, 0x3b,
0x64, 0x69, 0x73, 0x73, 0x61, 0x62, 0x74, 0x65, 0x3b, 0x47, 0x3b, 0x6c, 0x3b, 0x54, 0x3b, 0x43, 0x3b, 0x4a, 0x3b, 0x56,
0x3b, 0x53, 0x3b, 0x5468, 0x65e5, 0x3b, 0x5468, 0x4e00, 0x3b, 0x5468, 0x4e8c, 0x3b, 0x5468, 0x4e09, 0x3b, 0x5468, 0x56db, 0x3b, 0x5468, 0x4e94,
0x3b, 0x5468, 0x516d, 0x3b, 0x661f, 0x671f, 0x65e5, 0x3b, 0x661f, 0x671f, 0x4e00, 0x3b, 0x661f, 0x671f, 0x4e8c, 0x3b, 0x661f, 0x671f, 0x4e09, 0x3b,
0x661f, 0x671f, 0x56db, 0x3b, 0x661f, 0x671f, 0x4e94, 0x3b, 0x661f, 0x671f, 0x516d, 0x3b, 0x65e5, 0x3b, 0x4e00, 0x3b, 0x4e8c, 0x3b, 0x4e09, 0x3b,
0x56db, 0x3b, 0x4e94, 0x3b, 0x516d, 0x3b, 0x9031, 0x65e5, 0x3b, 0x9031, 0x4e00, 0x3b, 0x9031, 0x4e8c, 0x3b, 0x9031, 0x4e09, 0x3b, 0x9031, 0x56db,
0x3b, 0x9031, 0x4e94, 0x3b, 0x9031, 0x516d, 0x3b, 0x6e, 0x65, 0x64, 0x3b, 0x70, 0x6f, 0x6e, 0x3b, 0x75, 0x74, 0x6f, 0x3b, 0x73,
0x72, 0x69, 0x3b, 0x10d, 0x65, 0x74, 0x3b, 0x70, 0x65, 0x74, 0x3b, 0x73, 0x75, 0x62, 0x3b, 0x6e, 0x65, 0x64, 0x6a, 0x65,
0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x65, 0x64, 0x6a, 0x65, 0x6c, 0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72,
0x61, 0x6b, 0x3b, 0x73, 0x72, 0x69, 0x6a, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 0x6b, 0x3b,
0x70, 0x65, 0x74, 0x61, 0x6b, 0x3b, 0x73, 0x75, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x75, 0x3b, 0x73,
0x3b, 0x10d, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x4e, 0x3b, 0x50, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x10c, 0x3b, 0x50, 0x3b, 0x53,
0x3b, 0x6e, 0x65, 0x3b, 0x70, 0x6f, 0x3b, 0xfa, 0x74, 0x3b, 0x73, 0x74, 0x3b, 0x10d, 0x74, 0x3b, 0x70, 0xe1, 0x3b, 0x73,
0x6f, 0x3b, 0x6e, 0x65, 0x64, 0x11b, 0x6c, 0x65, 0x3b, 0x70, 0x6f, 0x6e, 0x64, 0x11b, 0x6c, 0xed, 0x3b, 0xfa, 0x74, 0x65,
0x72, 0xfd, 0x3b, 0x73, 0x74, 0x159, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x74, 0x76, 0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0xe1,
0x74, 0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x4e, 0x3b, 0x50, 0x3b, 0xda, 0x3b, 0x53, 0x3b, 0x10c,
0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x73, 0xf8, 0x6e, 0x3b, 0x6d, 0x61, 0x6e, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6f, 0x6e, 0x73,
0x3b, 0x74, 0x6f, 0x72, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c, 0xf8, 0x72, 0x3b, 0x73, 0xf8, 0x6e, 0x64, 0x61, 0x67, 0x3b,
0x6d, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x69, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61,
0x67, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66, 0x72, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c, 0xf8, 0x72,
0x64, 0x61, 0x67, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4f, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x4c, 0x3b, 0x7a, 0x6f,
0x3b, 0x6d, 0x61, 0x3b, 0x64, 0x69, 0x3b, 0x77, 0x6f, 0x3b, 0x64, 0x6f, 0x3b, 0x76, 0x72, 0x3b, 0x7a, 0x61, 0x3b, 0x7a,
0x6f, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0x61, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x64, 0x69, 0x6e, 0x73, 0x64, 0x61,
0x67, 0x3b, 0x77, 0x6f, 0x65, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x64, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x61, 0x67,
0x3b, 0x76, 0x72, 0x69, 0x6a, 0x64, 0x61, 0x67, 0x3b, 0x7a, 0x61, 0x74, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x5a, 0x3b,
0x4d, 0x3b, 0x44, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x56, 0x3b, 0x5a, 0x3b, 0xd801, 0xdc1d, 0xd801, 0xdc32, 0xd801, 0xdc4c, 0x3b, 0xd801,
0xdc23, 0xd801, 0xdc32, 0xd801, 0xdc4c, 0x3b, 0xd801, 0xdc13, 0xd801, 0xdc2d, 0xd801, 0xdc46, 0x3b, 0xd801, 0xdc0e, 0xd801, 0xdc2f, 0xd801, 0xdc4c, 0x3b,
0xd801, 0xdc1b, 0xd801, 0xdc32, 0xd801, 0xdc49, 0x3b, 0xd801, 0xdc19, 0xd801, 0xdc49, 0xd801, 0xdc34, 0x3b, 0xd801, 0xdc1d, 0xd801, 0xdc30, 0xd801, 0xdc3b,
0x3b, 0xd801, 0xdc1d, 0xd801, 0xdc32, 0xd801, 0xdc4c, 0xd801, 0xdc3c, 0xd801, 0xdc29, 0x3b, 0xd801, 0xdc23, 0xd801, 0xdc32, 0xd801, 0xdc4c, 0xd801, 0xdc3c,
0xd801, 0xdc29, 0x3b, 0xd801, 0xdc13, 0xd801, 0xdc2d, 0xd801, 0xdc46, 0xd801, 0xdc3c, 0xd801, 0xdc29, 0x3b, 0xd801, 0xdc0e, 0xd801, 0xdc2f, 0xd801, 0xdc4c,
0xd801, 0xdc46, 0xd801, 0xdc3c, 0xd801, 0xdc29, 0x3b, 0xd801, 0xdc1b, 0xd801, 0xdc32, 0xd801, 0xdc49, 0xd801, 0xdc46, 0xd801, 0xdc3c, 0xd801, 0xdc29, 0x3b,
0xd801, 0xdc19, 0xd801, 0xdc49, 0xd801, 0xdc34, 0xd801, 0xdc3c, 0xd801, 0xdc29, 0x3b, 0xd801, 0xdc1d, 0xd801, 0xdc30, 0xd801, 0xdc3b, 0xd801, 0xdc32, 0xd801,
0xdc49, 0xd801, 0xdc3c, 0xd801, 0xdc29, 0x3b, 0xd801, 0xdc1d, 0x3b, 0xd801, 0xdc23, 0x3b, 0xd801, 0xdc13, 0x3b, 0xd801, 0xdc0e, 0x3b, 0xd801, 0xdc1b,
0x3b, 0xd801, 0xdc19, 0x3b, 0xd801, 0xdc1d, 0x3b, 0x50, 0x3b, 0x45, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x52, 0x3b, 0x4c,
0x3b, 0x70, 0xfc, 0x68, 0x61, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x65, 0x73, 0x6d, 0x61, 0x73, 0x70, 0xe4, 0x65, 0x76, 0x3b,
0x74, 0x65, 0x69, 0x73, 0x69, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x6b, 0x6f, 0x6c, 0x6d, 0x61, 0x70, 0xe4, 0x65, 0x76, 0x3b,
0x6e, 0x65, 0x6c, 0x6a, 0x61, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x72, 0x65, 0x65, 0x64, 0x65, 0x3b, 0x6c, 0x61, 0x75, 0x70,
0xe4, 0x65, 0x76, 0x3b, 0x73, 0x75, 0x6e, 0x3b, 0x6d, 0xe1, 0x6e, 0x3b, 0x74, 0xfd, 0x73, 0x3b, 0x6d, 0x69, 0x6b, 0x3b,
0x68, 0xf3, 0x73, 0x3b, 0x66, 0x72, 0xed, 0x3b, 0x6c, 0x65, 0x79, 0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x64, 0x61, 0x67,
0x75, 0x72, 0x3b, 0x6d, 0xe1, 0x6e, 0x61, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x74, 0xfd, 0x73, 0x64, 0x61, 0x67, 0x75,
0x72, 0x3b, 0x6d, 0x69, 0x6b, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x68, 0xf3, 0x73, 0x64, 0x61, 0x67, 0x75, 0x72,
0x3b, 0x66, 0x72, 0xed, 0x67, 0x67, 0x6a, 0x61, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6c, 0x65, 0x79, 0x67, 0x61, 0x72,
0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x46, 0x3b, 0x4c, 0x3b,
0x73, 0x75, 0x3b, 0x6d, 0x61, 0x3b, 0x74, 0x69, 0x3b, 0x6b, 0x65, 0x3b, 0x74, 0x6f, 0x3b, 0x70, 0x65, 0x3b, 0x6c, 0x61,
0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x6d, 0x61, 0x61, 0x6e, 0x61, 0x6e, 0x74, 0x61, 0x69,
0x3b, 0x74, 0x69, 0x69, 0x73, 0x74, 0x61, 0x69, 0x3b, 0x6b, 0x65, 0x73, 0x6b, 0x69, 0x76, 0x69, 0x69, 0x6b, 0x6b, 0x6f,
0x3b, 0x74, 0x6f, 0x72, 0x73, 0x74, 0x61, 0x69, 0x3b, 0x70, 0x65, 0x72, 0x6a, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x6c,
0x61, 0x75, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x50, 0x3b,
0x4c, 0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6d, 0x61, 0x61, 0x6e, 0x61, 0x6e,
0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x74, 0x69, 0x69, 0x73, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6b, 0x65, 0x73, 0x6b,
0x69, 0x76, 0x69, 0x69, 0x6b, 0x6b, 0x6f, 0x6e, 0x61, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b,
0x70, 0x65, 0x72, 0x6a, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6c, 0x61, 0x75, 0x61, 0x6e, 0x74, 0x61, 0x69,
0x6e, 0x61, 0x3b, 0x64, 0x69, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x6d, 0x65,
0x72, 0x2e, 0x3b, 0x6a, 0x65, 0x75, 0x2e, 0x3b, 0x76, 0x65, 0x6e, 0x2e, 0x3b, 0x73, 0x61, 0x6d, 0x2e, 0x3b, 0x64, 0x69,
0x6d, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x3b, 0x6c, 0x75, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d,
0x65, 0x72, 0x63, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x6a, 0x65, 0x75, 0x64, 0x69, 0x3b, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65,
0x64, 0x69, 0x3b, 0x73, 0x61, 0x6d, 0x65, 0x64, 0x69, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b,
0x56, 0x3b, 0x53, 0x3b, 0x44, 0x6f, 0x6d, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0xe9, 0x72, 0x3b,
0x58, 0x6f, 0x76, 0x3b, 0x56, 0x65, 0x6e, 0x3b, 0x53, 0xe1, 0x62, 0x3b, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b,
0x4c, 0x75, 0x6e, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0xe9, 0x72, 0x63, 0x6f, 0x72, 0x65, 0x73,
0x3b, 0x58, 0x6f, 0x76, 0x65, 0x73, 0x3b, 0x56, 0x65, 0x6e, 0x72, 0x65, 0x73, 0x3b, 0x53, 0xe1, 0x62, 0x61, 0x64, 0x6f,
0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x58, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x10d9, 0x10d5, 0x10d8, 0x3b, 0x10dd,
0x10e0, 0x10e8, 0x3b, 0x10e1, 0x10d0, 0x10db, 0x3b, 0x10dd, 0x10d7, 0x10ee, 0x3b, 0x10ee, 0x10e3, 0x10d7, 0x3b, 0x10de, 0x10d0, 0x10e0, 0x3b, 0x10e8,
0x10d0, 0x10d1, 0x3b, 0x10d9, 0x10d5, 0x10d8, 0x10e0, 0x10d0, 0x3b, 0x10dd, 0x10e0, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10e1, 0x10d0,
0x10db, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10dd, 0x10d7, 0x10ee, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10ee, 0x10e3,
0x10d7, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10de, 0x10d0, 0x10e0, 0x10d0, 0x10e1, 0x10d9, 0x10d4, 0x10d5, 0x10d8, 0x3b, 0x10e8, 0x10d0,
0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10d9, 0x3b, 0x10dd, 0x3b, 0x10e1, 0x3b, 0x10dd, 0x3b, 0x10ee, 0x3b, 0x10de, 0x3b, 0x10e8, 0x3b, 0x53,
0x6f, 0x3b, 0x4d, 0x6f, 0x3b, 0x44, 0x69, 0x3b, 0x4d, 0x69, 0x3b, 0x44, 0x6f, 0x3b, 0x46, 0x72, 0x3b, 0x53, 0x61, 0x3b,
0x53, 0x6f, 0x6e, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x4d, 0x6f, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x44, 0x69, 0x65, 0x6e, 0x73,
0x74, 0x61, 0x67, 0x3b, 0x4d, 0x69, 0x74, 0x74, 0x77, 0x6f, 0x63, 0x68, 0x3b, 0x44, 0x6f, 0x6e, 0x6e, 0x65, 0x72, 0x73,
0x74, 0x61, 0x67, 0x3b, 0x46, 0x72, 0x65, 0x69, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x74, 0x61, 0x67, 0x3b,
0x53, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x46, 0x3b, 0x53, 0x3b, 0x53, 0x6f, 0x2e, 0x3b, 0x4d, 0x6f,
0x2e, 0x3b, 0x44, 0x69, 0x2e, 0x3b, 0x4d, 0x69, 0x2e, 0x3b, 0x44, 0x6f, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61,
0x2e, 0x3b, 0x39a, 0x3c5, 0x3c1, 0x3b, 0x394, 0x3b5, 0x3c5, 0x3b, 0x3a4, 0x3c1, 0x3af, 0x3b, 0x3a4, 0x3b5, 0x3c4, 0x3b, 0x3a0, 0x3ad,
0x3bc, 0x3b, 0x3a0, 0x3b1, 0x3c1, 0x3b, 0x3a3, 0x3ac, 0x3b2, 0x3b, 0x39a, 0x3c5, 0x3c1, 0x3b9, 0x3b1, 0x3ba, 0x3ae, 0x3b, 0x394, 0x3b5,
0x3c5, 0x3c4, 0x3ad, 0x3c1, 0x3b1, 0x3b, 0x3a4, 0x3c1, 0x3af, 0x3c4, 0x3b7, 0x3b, 0x3a4, 0x3b5, 0x3c4, 0x3ac, 0x3c1, 0x3c4, 0x3b7, 0x3b,
0x3a0, 0x3ad, 0x3bc, 0x3c0, 0x3c4, 0x3b7, 0x3b, 0x3a0, 0x3b1, 0x3c1, 0x3b1, 0x3c3, 0x3ba, 0x3b5, 0x3c5, 0x3ae, 0x3b, 0x3a3, 0x3ac, 0x3b2,
0x3b2, 0x3b1, 0x3c4, 0x3bf, 0x3b, 0x39a, 0x3b, 0x394, 0x3b, 0x3a4, 0x3b, 0x3a4, 0x3b, 0x3a0, 0x3b, 0x3a0, 0x3b, 0x3a3, 0x3b, 0x39a,
0x3c5, 0x3c1, 0x3b, 0x394, 0x3b5, 0x3c5, 0x3b, 0x3a4, 0x3c1, 0x3b9, 0x3b, 0x3a4, 0x3b5, 0x3c4, 0x3b, 0x3a0, 0x3b5, 0x3bc, 0x3b, 0x3a0,
0x3b1, 0x3c1, 0x3b, 0x3a3, 0x3b1, 0x3b2, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x61, 0x74, 0x61, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x70,
0x69, 0x6e, 0x3b, 0x73, 0x69, 0x73, 0x3b, 0x74, 0x61, 0x6c, 0x3b, 0x61, 0x72, 0x66, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x61,
0x74, 0x3b, 0x61, 0x74, 0x61, 0x61, 0x73, 0x69, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x6d, 0x61, 0x72,
0x6c, 0x75, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x70, 0x69, 0x6e, 0x67, 0x61, 0x73, 0x75, 0x6e, 0x6e,
0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x73, 0x69, 0x73, 0x61, 0x6d, 0x61, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65,
0x71, 0x3b, 0x74, 0x61, 0x6c, 0x6c, 0x69, 0x6d, 0x61, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x61, 0x72,
0x66, 0x69, 0x6e, 0x69, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x50,
0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0xab0, 0xab5, 0xabf, 0x3b, 0xab8, 0xacb, 0xaae, 0x3b, 0xaae, 0xa82, 0xa97, 0xab3, 0x3b,
0xaac, 0xac1, 0xaa7, 0x3b, 0xa97, 0xac1, 0xab0, 0xac1, 0x3b, 0xab6, 0xac1, 0xa95, 0xacd, 0xab0, 0x3b, 0xab6, 0xaa8, 0xabf, 0x3b, 0xab0,
0xab5, 0xabf, 0xab5, 0xabe, 0xab0, 0x3b, 0xab8, 0xacb, 0xaae, 0xab5, 0xabe, 0xab0, 0x3b, 0xaae, 0xa82, 0xa97, 0xab3, 0xab5, 0xabe, 0xab0,
0x3b, 0xaac, 0xac1, 0xaa7, 0xab5, 0xabe, 0xab0, 0x3b, 0xa97, 0xac1, 0xab0, 0xac1, 0xab5, 0xabe, 0xab0, 0x3b, 0xab6, 0xac1, 0xa95, 0xacd,
0xab0, 0xab5, 0xabe, 0xab0, 0x3b, 0xab6, 0xaa8, 0xabf, 0xab5, 0xabe, 0xab0, 0x3b, 0xab0, 0x3b, 0xab8, 0xacb, 0x3b, 0xaae, 0xa82, 0x3b,
0xaac, 0xac1, 0x3b, 0xa97, 0xac1, 0x3b, 0xab6, 0xac1, 0x3b, 0xab6, 0x3b, 0x4c, 0x68, 0x3b, 0x4c, 0x69, 0x3b, 0x54, 0x61, 0x3b,
0x4c, 0x72, 0x3b, 0x41, 0x6c, 0x3b, 0x4a, 0x75, 0x3b, 0x41, 0x73, 0x3b, 0x4c, 0x61, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x4c,
0x69, 0x74, 0x69, 0x6e, 0x69, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x4c, 0x61, 0x72, 0x61, 0x62, 0x61,
0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x6d, 0x61, 0x27, 0x61, 0x3b, 0x41, 0x73, 0x61,
0x62, 0x61, 0x72, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x5d9, 0x5d5,
0x5dd, 0x20, 0x5d0, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d1, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d2, 0x5f3, 0x3b, 0x5d9,
0x5d5, 0x5dd, 0x20, 0x5d3, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d4, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d5, 0x5f3, 0x3b,
0x5e9, 0x5d1, 0x5ea, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e8, 0x5d0, 0x5e9, 0x5d5, 0x5df, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5e0,
0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5dc, 0x5d9, 0x5e9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e8, 0x5d1, 0x5d9, 0x5e2,
0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d7, 0x5de, 0x5d9, 0x5e9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5d9, 0x5e9, 0x5d9,
0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5d1, 0x5ea, 0x3b, 0x5d0, 0x3b, 0x5d1, 0x3b, 0x5d2, 0x3b, 0x5d3, 0x3b, 0x5d4, 0x3b, 0x5d5,
0x3b, 0x5e9, 0x3b, 0x930, 0x935, 0x93f, 0x2e, 0x3b, 0x938, 0x94b, 0x92e, 0x2e, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x2e, 0x3b, 0x92c,
0x941, 0x927, 0x2e, 0x3b, 0x92c, 0x943, 0x939, 0x2e, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x2e, 0x3b, 0x936, 0x928, 0x93f, 0x2e,
0x3b, 0x930, 0x935, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x935, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x935,
0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x943, 0x939, 0x938, 0x94d, 0x92a, 0x924, 0x93f, 0x935, 0x93e,
0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x930, 0x3b,
0x938, 0x94b, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b, 0x917, 0x941, 0x3b, 0x936, 0x941, 0x3b, 0x936, 0x3b, 0x56, 0x3b, 0x48,
0x3b, 0x4b, 0x3b, 0x53, 0x7a, 0x65, 0x3b, 0x43, 0x73, 0x3b, 0x50, 0x3b, 0x53, 0x7a, 0x6f, 0x3b, 0x76, 0x61, 0x73, 0xe1,
0x72, 0x6e, 0x61, 0x70, 0x3b, 0x68, 0xe9, 0x74, 0x66, 0x151, 0x3b, 0x6b, 0x65, 0x64, 0x64, 0x3b, 0x73, 0x7a, 0x65, 0x72,
0x64, 0x61, 0x3b, 0x63, 0x73, 0xfc, 0x74, 0xf6, 0x72, 0x74, 0xf6, 0x6b, 0x3b, 0x70, 0xe9, 0x6e, 0x74, 0x65, 0x6b, 0x3b,
0x73, 0x7a, 0x6f, 0x6d, 0x62, 0x61, 0x74, 0x3b, 0x56, 0x3b, 0x48, 0x3b, 0x4b, 0x3b, 0x53, 0x7a, 0x3b, 0x43, 0x73, 0x3b,
0x50, 0x3b, 0x53, 0x7a, 0x3b, 0x73, 0x75, 0x6e, 0x3b, 0x6d, 0xe1, 0x6e, 0x3b, 0xfe, 0x72, 0x69, 0x3b, 0x6d, 0x69, 0xf0,
0x3b, 0x66, 0x69, 0x6d, 0x3b, 0x66, 0xf6, 0x73, 0x3b, 0x6c, 0x61, 0x75, 0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x64, 0x61,
0x67, 0x75, 0x72, 0x3b, 0x6d, 0xe1, 0x6e, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0xfe, 0x72, 0x69, 0xf0, 0x6a, 0x75,
0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6d, 0x69, 0xf0, 0x76, 0x69, 0x6b, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x66,
0x69, 0x6d, 0x6d, 0x74, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x66, 0xf6, 0x73, 0x74, 0x75, 0x64, 0x61, 0x67, 0x75,
0x72, 0x3b, 0x6c, 0x61, 0x75, 0x67, 0x61, 0x72, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0xfe, 0x3b,
0x6d, 0x3b, 0x66, 0x3b, 0x66, 0x3b, 0x6c, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0xde, 0x3b, 0x4d, 0x3b, 0x46, 0x3b, 0x46, 0x3b,
0x4c, 0x3b, 0x4d, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x3b, 0x4b, 0x61,
0x6d, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4d, 0x69, 0x6e, 0x67, 0x67, 0x75, 0x3b, 0x53, 0x65, 0x6e,
0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x61, 0x73, 0x61, 0x3b, 0x52, 0x61, 0x62, 0x75, 0x3b, 0x4b, 0x61, 0x6d, 0x69, 0x73,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x75, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x52,
0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x44, 0xe9, 0x20,
0x68, 0x41, 0x6f, 0x69, 0x6e, 0x65, 0x3b, 0x44, 0xe9, 0x20, 0x53, 0x61, 0x74, 0x68, 0x61, 0x69, 0x72, 0x6e, 0x3b, 0x64,
0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x72, 0x3b, 0x67, 0x69, 0x6f, 0x3b, 0x76,
0x65, 0x6e, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x44, 0x6f, 0x6d, 0x65, 0x6e, 0x69, 0x63, 0x61, 0x3b, 0x4c, 0x75, 0x6e, 0x65,
0x64, 0xec, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65, 0x64, 0xec, 0x3b, 0x4d, 0x65, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x64, 0xec,
0x3b, 0x47, 0x69, 0x6f, 0x76, 0x65, 0x64, 0xec, 0x3b, 0x56, 0x65, 0x6e, 0x65, 0x72, 0x64, 0xec, 0x3b, 0x53, 0x61, 0x62,
0x61, 0x74, 0x6f, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x64, 0x6f,
0x6d, 0x65, 0x6e, 0x69, 0x63, 0x61, 0x3b, 0x6c, 0x75, 0x6e, 0x65, 0x64, 0xec, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x64,
0xec, 0x3b, 0x6d, 0x65, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x64, 0xec, 0x3b, 0x67, 0x69, 0x6f, 0x76, 0x65, 0x64, 0xec, 0x3b,
0x76, 0x65, 0x6e, 0x65, 0x72, 0x64, 0xec, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b, 0x65e5, 0x3b, 0x6708, 0x3b, 0x706b,
0x3b, 0x6c34, 0x3b, 0x6728, 0x3b, 0x91d1, 0x3b, 0x571f, 0x3b, 0x65e5, 0x66dc, 0x65e5, 0x3b, 0x6708, 0x66dc, 0x65e5, 0x3b, 0x706b, 0x66dc, 0x65e5,
0x3b, 0x6c34, 0x66dc, 0x65e5, 0x3b, 0x6728, 0x66dc, 0x65e5, 0x3b, 0x91d1, 0x66dc, 0x65e5, 0x3b, 0x571f, 0x66dc, 0x65e5, 0x3b, 0xcb0, 0x2e, 0x3b,
0xcb8, 0xccb, 0x2e, 0x3b, 0xcae, 0xc82, 0x2e, 0x3b, 0xcac, 0xcc1, 0x2e, 0x3b, 0xc97, 0xcc1, 0x2e, 0x3b, 0xcb6, 0xcc1, 0x2e, 0x3b,
0xcb6, 0xca8, 0xcbf, 0x2e, 0x3b, 0xcb0, 0xcb5, 0xcbf, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcb8, 0xccb, 0xcae, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcae,
0xc82, 0xc97, 0xcb3, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcac, 0xcc1, 0xca7, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xc97, 0xcc1, 0xcb0, 0xcc1, 0xcb5, 0xcbe,
0xcb0, 0x3b, 0xcb6, 0xcc1, 0xc95, 0xccd, 0xcb0, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcb6, 0xca8, 0xcbf, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcb0, 0x3b,
0xcb8, 0xccb, 0x3b, 0xcae, 0xc82, 0x3b, 0xcac, 0xcc1, 0x3b, 0xc97, 0xcc1, 0x3b, 0xcb6, 0xcc1, 0x3b, 0xcb6, 0x3b, 0x436, 0x441, 0x2e,
0x3b, 0x434, 0x441, 0x2e, 0x3b, 0x441, 0x441, 0x2e, 0x3b, 0x441, 0x440, 0x2e, 0x3b, 0x431, 0x441, 0x2e, 0x3b, 0x436, 0x43c, 0x2e,
0x3b, 0x441, 0x43d, 0x2e, 0x3b, 0x436, 0x435, 0x43a, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x434, 0x4af, 0x439, 0x441, 0x435, 0x43d,
0x431, 0x456, 0x3b, 0x441, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x441, 0x4d9, 0x440, 0x441, 0x435, 0x43d, 0x431, 0x456,
0x3b, 0x431, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x436, 0x4b1, 0x43c, 0x430, 0x3b, 0x441, 0x435, 0x43d, 0x431, 0x456,
0x3b, 0x436, 0x441, 0x2e, 0x3b, 0x434, 0x441, 0x2e, 0x3b, 0x441, 0x441, 0x2e, 0x3b, 0x441, 0x440, 0x2e, 0x3b, 0x431, 0x441, 0x2e,
0x3b, 0x436, 0x43c, 0x2e, 0x3b, 0x441, 0x4bb, 0x2e, 0x3b, 0x436, 0x435, 0x43a, 0x441, 0x435, 0x43d, 0x456, 0x3b, 0x434, 0x443, 0x439,
0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x441, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x441, 0x4d9, 0x440, 0x435, 0x43d,
0x431, 0x456, 0x3b, 0x431, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x436, 0x4b1, 0x43c, 0x430, 0x3b, 0x441, 0x435, 0x43d,
0x431, 0x456, 0x3b, 0x63, 0x79, 0x75, 0x2e, 0x3b, 0x6d, 0x62, 0x65, 0x2e, 0x3b, 0x6b, 0x61, 0x62, 0x2e, 0x3b, 0x67, 0x74,
0x75, 0x2e, 0x3b, 0x6b, 0x61, 0x6e, 0x2e, 0x3b, 0x67, 0x6e, 0x75, 0x2e, 0x3b, 0x67, 0x6e, 0x64, 0x2e, 0x3b, 0x4b, 0x75,
0x20, 0x63, 0x79, 0x75, 0x6d, 0x77, 0x65, 0x72, 0x75, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x72, 0x65,
0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x67, 0x61,
0x74, 0x61, 0x74, 0x75, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x65, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20,
0x67, 0x61, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x74,
0x75, 0x3b, 0xc77c, 0x3b, 0xc6d4, 0x3b, 0xd654, 0x3b, 0xc218, 0x3b, 0xbaa9, 0x3b, 0xae08, 0x3b, 0xd1a0, 0x3b, 0xc77c, 0xc694, 0xc77c, 0x3b,
0xc6d4, 0xc694, 0xc77c, 0x3b, 0xd654, 0xc694, 0xc77c, 0x3b, 0xc218, 0xc694, 0xc77c, 0x3b, 0xbaa9, 0xc694, 0xc77c, 0x3b, 0xae08, 0xc694, 0xc77c, 0x3b,
0xd1a0, 0xc694, 0xc77c, 0x3b, 0x6cc, 0x6d5, 0x6a9, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x62f, 0x648, 0x648, 0x634, 0x6d5, 0x645, 0x645,
0x6d5, 0x3b, 0x633, 0x6ce, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x686, 0x648, 0x627, 0x631, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b,
0x67e, 0x6ce, 0x646, 0x62c, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x6be, 0x6d5, 0x6cc, 0x646, 0x6cc, 0x3b, 0x634, 0x6d5, 0x645, 0x645,
0x6d5, 0x3b, 0x6cc, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b, 0x67e, 0x3b, 0x6be, 0x3b, 0x634, 0x3b, 0x79, 0x15f, 0x3b, 0x64,
0x15f, 0x3b, 0x73, 0x15f, 0x3b, 0xe7, 0x15f, 0x3b, 0x70, 0x15f, 0x3b, 0xee, 0x6e, 0x3b, 0x15f, 0x3b, 0x79, 0x65, 0x6b, 0x15f,
0x65, 0x6d, 0x3b, 0x64, 0x75, 0x15f, 0x65, 0x6d, 0x3b, 0x15f, 0xea, 0x3b, 0xe7, 0x61, 0x72, 0x15f, 0x65, 0x6d, 0x3b, 0x70,
0xea, 0x6e, 0x63, 0x15f, 0x65, 0x6d, 0x3b, 0xee, 0x6e, 0x3b, 0x15f, 0x65, 0x6d, 0xee, 0x3b, 0x79, 0x3b, 0x64, 0x3b, 0x73,
0x3b, 0xe7, 0x3b, 0x70, 0x3b, 0xee, 0x3b, 0x15f, 0x3b, 0x63, 0x75, 0x2e, 0x3b, 0x6d, 0x62, 0x65, 0x2e, 0x3b, 0x6b, 0x61,
0x62, 0x2e, 0x3b, 0x67, 0x74, 0x75, 0x2e, 0x3b, 0x6b, 0x61, 0x6e, 0x2e, 0x3b, 0x67, 0x6e, 0x75, 0x2e, 0x3b, 0x67, 0x6e,
0x64, 0x2e, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x27, 0x69, 0x6e, 0x64, 0x77, 0x69, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20,
0x6d, 0x62, 0x65, 0x72, 0x65, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b,
0x75, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61,
0x6e, 0x65, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x4b, 0x75, 0x20, 0x77,
0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x75, 0x3b, 0xead, 0xeb2, 0x2e, 0x3b, 0xe88, 0x2e, 0x3b, 0xead,
0x2e, 0x3b, 0xe9e, 0x2e, 0x3b, 0xe9e, 0xeab, 0x2e, 0x3b, 0xeaa, 0xe81, 0x2e, 0x3b, 0xeaa, 0x2e, 0x3b, 0xea7, 0xeb1, 0xe99, 0xead,
0xeb2, 0xe97, 0xeb4, 0xe94, 0x3b, 0xea7, 0xeb1, 0xe99, 0xe88, 0xeb1, 0xe99, 0x3b, 0xea7, 0xeb1, 0xe99, 0xead, 0xeb1, 0xe87, 0xe84, 0xeb2,
0xe99, 0x3b, 0xea7, 0xeb1, 0xe99, 0xe9e, 0xeb8, 0xe94, 0x3b, 0xea7, 0xeb1, 0xe99, 0xe9e, 0xeb0, 0xeab, 0xeb1, 0xe94, 0x3b, 0xea7, 0xeb1,
0xe99, 0xeaa, 0xeb8, 0xe81, 0x3b, 0xea7, 0xeb1, 0xe99, 0xec0, 0xeaa, 0xebb, 0xeb2, 0x3b, 0x53, 0x76, 0x3b, 0x50, 0x72, 0x3b, 0x4f,
0x74, 0x3b, 0x54, 0x72, 0x3b, 0x43, 0x65, 0x3b, 0x50, 0x6b, 0x3b, 0x53, 0x65, 0x3b, 0x73, 0x76, 0x113, 0x74, 0x64, 0x69,
0x65, 0x6e, 0x61, 0x3b, 0x70, 0x69, 0x72, 0x6d, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x6f, 0x74, 0x72, 0x64, 0x69, 0x65,
0x6e, 0x61, 0x3b, 0x74, 0x72, 0x65, 0x161, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x63, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64,
0x69, 0x65, 0x6e, 0x61, 0x3b, 0x70, 0x69, 0x65, 0x6b, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x73, 0x65, 0x73, 0x74,
0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x53, 0x3b, 0x50, 0x3b, 0x4f, 0x3b, 0x54, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x53, 0x3b,
0x65, 0x79, 0x65, 0x3b, 0x79, 0x62, 0x6f, 0x3b, 0x6d, 0x62, 0x6c, 0x3b, 0x6d, 0x73, 0x74, 0x3b, 0x6d, 0x69, 0x6e, 0x3b,
0x6d, 0x74, 0x6e, 0x3b, 0x6d, 0x70, 0x73, 0x3b, 0x65, 0x79, 0x65, 0x6e, 0x67, 0x61, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c,
0x254, 0x20, 0x6d, 0x77, 0x61, 0x20, 0x79, 0x61, 0x6d, 0x62, 0x6f, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x6d,
0x77, 0x61, 0x20, 0x6d, 0xed, 0x62, 0x61, 0x6c, 0xe9, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x6d, 0x77, 0x61,
0x20, 0x6d, 0xed, 0x73, 0xe1, 0x74, 0x6f, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed,
0x6e, 0xe9, 0x69, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x74, 0xe1, 0x6e, 0x6f,
0x3b, 0x6d, 0x70, 0x254, 0x301, 0x73, 0x254, 0x3b, 0x65, 0x3b, 0x79, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b,
0x70, 0x3b, 0x53, 0x6b, 0x3b, 0x50, 0x72, 0x3b, 0x41, 0x6e, 0x3b, 0x54, 0x72, 0x3b, 0x4b, 0x74, 0x3b, 0x50, 0x6e, 0x3b,
0x160, 0x74, 0x3b, 0x73, 0x65, 0x6b, 0x6d, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x70, 0x69, 0x72, 0x6d, 0x61,
0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x61, 0x6e, 0x74, 0x72, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x74,
0x72, 0x65, 0x10d, 0x69, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x6b, 0x65, 0x74, 0x76, 0x69, 0x72, 0x74, 0x61,
0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x70, 0x65, 0x6e, 0x6b, 0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b,
0x161, 0x65, 0x161, 0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x53, 0x3b, 0x50, 0x3b, 0x41, 0x3b, 0x54, 0x3b,
0x4b, 0x3b, 0x50, 0x3b, 0x160, 0x3b, 0x43d, 0x435, 0x434, 0x2e, 0x3b, 0x43f, 0x43e, 0x43d, 0x2e, 0x3b, 0x432, 0x442, 0x2e, 0x3b,
0x441, 0x440, 0x435, 0x2e, 0x3b, 0x447, 0x435, 0x442, 0x2e, 0x3b, 0x43f, 0x435, 0x442, 0x2e, 0x3b, 0x441, 0x430, 0x431, 0x2e, 0x3b,
0x43d, 0x435, 0x434, 0x435, 0x43b, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x43d, 0x438, 0x43a, 0x3b, 0x432, 0x442,
0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x441, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x43e, 0x43a,
0x3b, 0x43f, 0x435, 0x442, 0x43e, 0x43a, 0x3b, 0x441, 0x430, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x41, 0x6c, 0x61, 0x68, 0x3b, 0x41,
0x6c, 0x61, 0x74, 0x73, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x3b, 0x41, 0x6c, 0x61, 0x6b, 0x3b, 0x5a,
0x6f, 0x6d, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x3b, 0x41, 0x6c, 0x61, 0x68, 0x61, 0x64, 0x79, 0x3b, 0x41, 0x6c, 0x61, 0x74,
0x73, 0x69, 0x6e, 0x61, 0x69, 0x6e, 0x79, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x6f,
0x62, 0x69, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x6b, 0x61, 0x6d, 0x69, 0x73, 0x79, 0x3b, 0x5a, 0x6f, 0x6d, 0x61, 0x3b, 0x41,
0x73, 0x61, 0x62, 0x6f, 0x74, 0x73, 0x79, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x5a, 0x3b,
0x41, 0x3b, 0x41, 0x68, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x3b, 0x4b, 0x68,
0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x41, 0x68, 0x61, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x69, 0x6e,
0x3b, 0x53, 0x65, 0x6c, 0x61, 0x73, 0x61, 0x3b, 0x52, 0x61, 0x62, 0x75, 0x3b, 0x4b, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x3b,
0x4a, 0x75, 0x6d, 0x61, 0x61, 0x74, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x75, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x52,
0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0xd1e, 0xd3e, 0xd2f, 0xd30, 0xd4d, 0x200d, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd33,
0xd4d, 0x200d, 0x3b, 0xd1a, 0xd4a, 0xd35, 0xd4d, 0xd35, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd28, 0xd4d, 0x200d, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e,
0xd34, 0xd02, 0x3b, 0xd35, 0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f, 0x3b, 0xd36, 0xd28, 0xd3f, 0x3b, 0xd1e, 0xd3e, 0xd2f, 0xd31, 0xd3e, 0xd34,
0xd4d, 0xd1a, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd33, 0xd3e, 0xd34, 0xd4d, 0xd1a, 0x3b, 0xd1a, 0xd4a, 0xd35, 0xd4d, 0xd35, 0xd3e,
0xd34, 0xd4d, 0xd1a, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd28, 0xd3e, 0xd34, 0xd4d, 0xd1a, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0xd34, 0xd3e, 0xd34,
0xd4d, 0xd1a, 0x3b, 0xd35, 0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0xd1a, 0x3b, 0xd36, 0xd28, 0xd3f, 0xd2f, 0xd3e,
0xd34, 0xd4d, 0xd1a, 0x3b, 0xd1e, 0xd3e, 0x3b, 0xd24, 0xd3f, 0x3b, 0xd1a, 0xd4a, 0x3b, 0xd2c, 0xd41, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e,
0x3b, 0xd35, 0xd46, 0x3b, 0xd36, 0x3b, 0x126, 0x61, 0x64, 0x3b, 0x54, 0x6e, 0x65, 0x3b, 0x54, 0x6c, 0x69, 0x3b, 0x45, 0x72,
0x62, 0x3b, 0x126, 0x61, 0x6d, 0x3b, 0x120, 0x69, 0x6d, 0x3b, 0x53, 0x69, 0x62, 0x3b, 0x49, 0x6c, 0x2d, 0x126, 0x61, 0x64,
0x64, 0x3b, 0x49, 0x74, 0x2d, 0x54, 0x6e, 0x65, 0x6a, 0x6e, 0x3b, 0x49, 0x74, 0x2d, 0x54, 0x6c, 0x69, 0x65, 0x74, 0x61,
0x3b, 0x4c, 0x2d, 0x45, 0x72, 0x62, 0x67, 0x127, 0x61, 0x3b, 0x49, 0x6c, 0x2d, 0x126, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x49,
0x6c, 0x2d, 0x120, 0x69, 0x6d, 0x67, 0x127, 0x61, 0x3b, 0x49, 0x73, 0x2d, 0x53, 0x69, 0x62, 0x74, 0x3b, 0x126, 0x3b, 0x54,
0x3b, 0x54, 0x3b, 0x45, 0x3b, 0x126, 0x3b, 0x120, 0x3b, 0x53, 0x3b, 0x930, 0x935, 0x93f, 0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e,
0x902, 0x917, 0x933, 0x3b, 0x92c, 0x941, 0x927, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936,
0x928, 0x93f, 0x3b, 0x930, 0x935, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x935, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917,
0x933, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x3b,
0x936, 0x941, 0x915, 0x94d, 0x930, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x41d, 0x44f, 0x3b, 0x414,
0x430, 0x3b, 0x41c, 0x44f, 0x3b, 0x41b, 0x445, 0x3b, 0x41f, 0x4af, 0x3b, 0x411, 0x430, 0x3b, 0x411, 0x44f, 0x3b, 0x43d, 0x44f, 0x43c,
0x3b, 0x434, 0x430, 0x432, 0x430, 0x430, 0x3b, 0x43c, 0x44f, 0x433, 0x43c, 0x430, 0x440, 0x3b, 0x43b, 0x445, 0x430, 0x433, 0x432, 0x430,
0x3b, 0x43f, 0x4af, 0x440, 0x44d, 0x432, 0x3b, 0x431, 0x430, 0x430, 0x441, 0x430, 0x43d, 0x3b, 0x431, 0x44f, 0x43c, 0x431, 0x430, 0x3b,
0x906, 0x907, 0x924, 0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e, 0x919, 0x94d, 0x917, 0x932, 0x3b, 0x92c, 0x941, 0x927, 0x3b, 0x92c, 0x93f,
0x939, 0x940, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x3b, 0x906, 0x907, 0x924, 0x92c, 0x93e, 0x930, 0x3b,
0x938, 0x94b, 0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x919, 0x94d, 0x917, 0x932, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x92c,
0x93e, 0x930, 0x3b, 0x92c, 0x93f, 0x939, 0x940, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x92c, 0x93e, 0x930, 0x3b,
0x936, 0x928, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x967, 0x3b, 0x968, 0x3b, 0x969, 0x3b, 0x96a, 0x3b, 0x96b, 0x3b, 0x96c, 0x3b, 0x96d,
0x3b, 0x906, 0x907, 0x924, 0x935, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x935, 0x93e, 0x930, 0x3b, 0x92e, 0x919, 0x94d, 0x917, 0x932,
0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x93f, 0x939, 0x940, 0x935, 0x93e, 0x930, 0x3b, 0x936,
0x941, 0x915, 0x94d, 0x930, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x73, 0xf8, 0x2e, 0x3b, 0x6d,
0x61, 0x2e, 0x3b, 0x74, 0x69, 0x2e, 0x3b, 0x6f, 0x6e, 0x2e, 0x3b, 0x74, 0x6f, 0x2e, 0x3b, 0x66, 0x72, 0x2e, 0x3b, 0x6c,
0xf8, 0x2e, 0x3b, 0x73, 0xf8, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x6e, 0x2e, 0x3b, 0x74, 0x69, 0x72, 0x2e, 0x3b, 0x6f, 0x6e,
0x73, 0x2e, 0x3b, 0x74, 0x6f, 0x72, 0x2e, 0x3b, 0x66, 0x72, 0x65, 0x2e, 0x3b, 0x6c, 0xf8, 0x72, 0x2e, 0x3b, 0x44, 0x69,
0x6d, 0x65, 0x6e, 0x67, 0x65, 0x3b, 0x64, 0x69, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x72, 0xe7, 0x3b,
0x64, 0x69, 0x6d, 0xe8, 0x63, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x6a, 0xf2, 0x75, 0x73, 0x3b, 0x64, 0x69, 0x76, 0xe8,
0x6e, 0x64, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x73, 0x73, 0x61, 0x62, 0x74, 0x65, 0x3b, 0xb30, 0xb2c, 0xb3f, 0x3b, 0xb38,
0xb4b, 0xb2e, 0x3b, 0xb2e, 0xb19, 0xb4d, 0xb17, 0xb33, 0x3b, 0xb2c, 0xb41, 0xb27, 0x3b, 0xb17, 0xb41, 0xb30, 0xb41, 0x3b, 0xb36, 0xb41,
0xb15, 0xb4d, 0xb30, 0x3b, 0xb36, 0xb28, 0xb3f, 0x3b, 0xb30, 0xb2c, 0xb3f, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb38, 0xb4b, 0xb2e, 0xb2c, 0xb3e,
0xb30, 0x3b, 0xb2e, 0xb19, 0xb4d, 0xb17, 0xb33, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb2c, 0xb41, 0xb27, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb17, 0xb41,
0xb30, 0xb41, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb36, 0xb41, 0xb15, 0xb4d, 0xb30, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb36, 0xb28, 0xb3f, 0xb2c, 0xb3e,
0xb30, 0x3b, 0xb30, 0x3b, 0xb38, 0xb4b, 0x3b, 0xb2e, 0x3b, 0xb2c, 0xb41, 0x3b, 0xb17, 0xb41, 0x3b, 0xb36, 0xb41, 0x3b, 0xb36, 0x3b,
0x6cc, 0x6a9, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x62f, 0x648, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x633, 0x647, 0x200c, 0x634, 0x646, 0x628,
0x647, 0x3b, 0x686, 0x647, 0x627, 0x631, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x67e, 0x646, 0x62c, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x62c,
0x645, 0x639, 0x647, 0x3b, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x6cc, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b, 0x67e, 0x3b, 0x62c,
0x3b, 0x634, 0x3b, 0x6e, 0x69, 0x65, 0x64, 0x7a, 0x2e, 0x3b, 0x70, 0x6f, 0x6e, 0x2e, 0x3b, 0x77, 0x74, 0x2e, 0x3b, 0x15b,
0x72, 0x2e, 0x3b, 0x63, 0x7a, 0x77, 0x2e, 0x3b, 0x70, 0x74, 0x2e, 0x3b, 0x73, 0x6f, 0x62, 0x2e, 0x3b, 0x6e, 0x69, 0x65,
0x64, 0x7a, 0x69, 0x65, 0x6c, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x69, 0x65, 0x64, 0x7a, 0x69, 0x61, 0x142, 0x65, 0x6b, 0x3b,
0x77, 0x74, 0x6f, 0x72, 0x65, 0x6b, 0x3b, 0x15b, 0x72, 0x6f, 0x64, 0x61, 0x3b, 0x63, 0x7a, 0x77, 0x61, 0x72, 0x74, 0x65,
0x6b, 0x3b, 0x70, 0x69, 0x105, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x4e, 0x3b, 0x50, 0x3b,
0x57, 0x3b, 0x15a, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x73, 0x65, 0x67, 0x3b, 0x74, 0x65,
0x72, 0x3b, 0x71, 0x75, 0x61, 0x3b, 0x71, 0x75, 0x69, 0x3b, 0x73, 0x65, 0x78, 0x3b, 0x73, 0xe1, 0x62, 0x3b, 0x44, 0x6f,
0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x53, 0x65, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b,
0x54, 0x65, 0x72, 0xe7, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x51, 0x75, 0x61, 0x72, 0x74, 0x61, 0x2d, 0x66,
0x65, 0x69, 0x72, 0x61, 0x3b, 0x51, 0x75, 0x69, 0x6e, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x53, 0x65,
0x78, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x53, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x44, 0x3b, 0x53,
0x3b, 0x54, 0x3b, 0x51, 0x3b, 0x51, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x73,
0x65, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x74, 0x65, 0x72, 0xe7, 0x61, 0x2d, 0x66,
0x65, 0x69, 0x72, 0x61, 0x3b, 0x71, 0x75, 0x61, 0x72, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x71, 0x75,
0x69, 0x6e, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x73, 0x65, 0x78, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69,
0x72, 0x61, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0xa10, 0xa24, 0x2e, 0x3b, 0xa38, 0xa4b, 0xa2e, 0x2e, 0x3b, 0xa2e,
0xa70, 0xa17, 0xa32, 0x2e, 0x3b, 0xa2c, 0xa41, 0xa27, 0x2e, 0x3b, 0xa35, 0xa40, 0xa30, 0x2e, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa15, 0xa30,
0x2e, 0x3b, 0xa38, 0xa3c, 0xa28, 0xa40, 0x2e, 0x3b, 0xa10, 0xa24, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa4b, 0xa2e, 0xa35, 0xa3e, 0xa30,
0x3b, 0xa2e, 0xa70, 0xa17, 0xa32, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa2c, 0xa41, 0xa27, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa35, 0xa40, 0xa30, 0xa35,
0xa3e, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71, 0xa15, 0xa30, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa28, 0xa40, 0xa1a, 0xa30, 0xa35,
0xa3e, 0xa30, 0x3b, 0xa10, 0x3b, 0xa38, 0xa4b, 0x3b, 0xa2e, 0xa70, 0x3b, 0xa2c, 0xa41, 0xa71, 0x3b, 0xa35, 0xa40, 0x3b, 0xa38, 0xa3c,
0xa41, 0xa71, 0x3b, 0xa38, 0xa3c, 0x3b, 0x627, 0x62a, 0x648, 0x627, 0x631, 0x3b, 0x67e, 0x6cc, 0x631, 0x3b, 0x645, 0x646, 0x6af, 0x644,
0x3b, 0x628, 0x64f, 0x62f, 0x6be, 0x3b, 0x62c, 0x645, 0x639, 0x631, 0x627, 0x62a, 0x3b, 0x62c, 0x645, 0x639, 0x6c1, 0x3b, 0x6c1, 0x641,
0x62a, 0x6c1, 0x3b, 0x64, 0x75, 0x3b, 0x67, 0x6c, 0x69, 0x3b, 0x6d, 0x61, 0x3b, 0x6d, 0x65, 0x3b, 0x67, 0x69, 0x65, 0x3b,
0x76, 0x65, 0x3b, 0x73, 0x6f, 0x3b, 0x64, 0x75, 0x6d, 0x65, 0x6e, 0x67, 0x69, 0x61, 0x3b, 0x67, 0x6c, 0x69, 0x6e, 0x64,
0x65, 0x73, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x65, 0x73, 0x65, 0x6d, 0x6e, 0x61, 0x3b, 0x67,
0x69, 0x65, 0x76, 0x67, 0x69, 0x61, 0x3b, 0x76, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x69, 0x3b, 0x73, 0x6f, 0x6e, 0x64,
0x61, 0x3b, 0x44, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x44, 0x75, 0x3b, 0x4c,
0x75, 0x3b, 0x4d, 0x61, 0x3b, 0x4d, 0x69, 0x3b, 0x4a, 0x6f, 0x3b, 0x56, 0x69, 0x3b, 0x53, 0xe2, 0x3b, 0x64, 0x75, 0x6d,
0x69, 0x6e, 0x69, 0x63, 0x103, 0x3b, 0x6c, 0x75, 0x6e, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x21b, 0x69, 0x3b, 0x6d, 0x69, 0x65,
0x72, 0x63, 0x75, 0x72, 0x69, 0x3b, 0x6a, 0x6f, 0x69, 0x3b, 0x76, 0x69, 0x6e, 0x65, 0x72, 0x69, 0x3b, 0x73, 0xe2, 0x6d,
0x62, 0x103, 0x74, 0x103, 0x3b, 0x412, 0x441, 0x3b, 0x41f, 0x43d, 0x3b, 0x412, 0x442, 0x3b, 0x421, 0x440, 0x3b, 0x427, 0x442, 0x3b,
0x41f, 0x442, 0x3b, 0x421, 0x431, 0x3b, 0x412, 0x43e, 0x441, 0x43a, 0x440, 0x435, 0x441, 0x435, 0x43d, 0x44c, 0x435, 0x3b, 0x41f, 0x43e,
0x43d, 0x435, 0x434, 0x435, 0x43b, 0x44c, 0x43d, 0x438, 0x43a, 0x3b, 0x412, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x421, 0x440,
0x435, 0x434, 0x430, 0x3b, 0x427, 0x435, 0x442, 0x432, 0x435, 0x440, 0x433, 0x3b, 0x41f, 0x44f, 0x442, 0x43d, 0x438, 0x446, 0x430, 0x3b,
0x421, 0x443, 0x431, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x412, 0x3b, 0x41f, 0x3b, 0x412, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b,
0x421, 0x3b, 0x432, 0x441, 0x3b, 0x43f, 0x43d, 0x3b, 0x432, 0x442, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x442, 0x3b, 0x43f, 0x442, 0x3b,
0x441, 0x431, 0x3b, 0x432, 0x43e, 0x441, 0x43a, 0x440, 0x435, 0x441, 0x435, 0x43d, 0x44c, 0x435, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434,
0x435, 0x43b, 0x44c, 0x43d, 0x438, 0x43a, 0x3b, 0x432, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x441, 0x440, 0x435, 0x434, 0x430,
0x3b, 0x447, 0x435, 0x442, 0x432, 0x435, 0x440, 0x433, 0x3b, 0x43f, 0x44f, 0x442, 0x43d, 0x438, 0x446, 0x430, 0x3b, 0x441, 0x443, 0x431,
0x431, 0x43e, 0x442, 0x430, 0x3b, 0x412, 0x3b, 0x41f, 0x43d, 0x3b, 0x412, 0x442, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x421,
0x3b, 0x42, 0x6b, 0x31, 0x3b, 0x42, 0x6b, 0x32, 0x3b, 0x42, 0x6b, 0x33, 0x3b, 0x42, 0x6b, 0x34, 0x3b, 0x42, 0x6b, 0x35,
0x3b, 0x4c, 0xe2, 0x70, 0x3b, 0x4c, 0xe2, 0x79, 0x3b, 0x42, 0x69, 0x6b, 0x75, 0x61, 0x2d, 0xf4, 0x6b, 0x6f, 0x3b, 0x42,
0xef, 0x6b, 0x75, 0x61, 0x2d, 0xfb, 0x73, 0x65, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d, 0x70, 0x74, 0xe2, 0x3b, 0x42,
0xef, 0x6b, 0x75, 0x61, 0x2d, 0x75, 0x73, 0xef, 0xf6, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d, 0x6f, 0x6b, 0xfc, 0x3b,
0x4c, 0xe2, 0x70, 0xf4, 0x73, 0xf6, 0x3b, 0x4c, 0xe2, 0x79, 0x65, 0x6e, 0x67, 0x61, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x54,
0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x59, 0x3b, 0x43d, 0x435, 0x434, 0x3b, 0x43f, 0x43e, 0x43d, 0x3b, 0x443, 0x442, 0x43e,
0x3b, 0x441, 0x440, 0x435, 0x3b, 0x447, 0x435, 0x442, 0x3b, 0x43f, 0x435, 0x442, 0x3b, 0x441, 0x443, 0x431, 0x3b, 0x43d, 0x435, 0x434,
0x435, 0x459, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x459, 0x430, 0x43a, 0x3b, 0x443, 0x442, 0x43e, 0x440, 0x430, 0x43a,
0x3b, 0x441, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x430, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x430,
0x43a, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x3b, 0x43f, 0x3b, 0x443, 0x3b, 0x441, 0x3b, 0x447, 0x3b, 0x43f,
0x3b, 0x441, 0x3b, 0x43d, 0x435, 0x434, 0x3b, 0x43f, 0x43e, 0x43d, 0x3b, 0x443, 0x442, 0x43e, 0x3b, 0x441, 0x440, 0x438, 0x3b, 0x447,
0x435, 0x442, 0x3b, 0x43f, 0x435, 0x442, 0x3b, 0x441, 0x443, 0x431, 0x3b, 0x43d, 0x435, 0x434, 0x435, 0x459, 0x430, 0x3b, 0x43f, 0x43e,
0x43d, 0x435, 0x434, 0x435, 0x459, 0x430, 0x43a, 0x3b, 0x443, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441, 0x440, 0x438, 0x458, 0x435,
0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x430, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x430, 0x43a, 0x3b, 0x441, 0x443,
0x431, 0x43e, 0x442, 0x430, 0x3b, 0x6e, 0x65, 0x64, 0x3b, 0x70, 0x6f, 0x6e, 0x3b, 0x75, 0x74, 0x6f, 0x3b, 0x73, 0x72, 0x65,
0x3b, 0x10d, 0x65, 0x74, 0x3b, 0x70, 0x65, 0x74, 0x3b, 0x73, 0x75, 0x62, 0x3b, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61,
0x3b, 0x70, 0x6f, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x6b, 0x3b, 0x73,
0x72, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x61, 0x6b, 0x3b,
0x73, 0x75, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x6d, 0x61, 0x3b, 0x42, 0x65, 0x64, 0x3b, 0x52,
0x61, 0x72, 0x3b, 0x4e, 0x65, 0x3b, 0x48, 0x6c, 0x61, 0x3b, 0x4d, 0x6f, 0x71, 0x3b, 0x53, 0x6f, 0x6e, 0x74, 0x61, 0x68,
0x61, 0x3b, 0x4d, 0x6d, 0x61, 0x6e, 0x74, 0x61, 0x68, 0x61, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x62, 0x65, 0x64, 0x69, 0x3b,
0x4c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x72, 0x75, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x6e, 0x65, 0x3b, 0x4c, 0x61, 0x62, 0x6f,
0x68, 0x6c, 0x61, 0x6e, 0x65, 0x3b, 0x4d, 0x6f, 0x71, 0x65, 0x62, 0x65, 0x6c, 0x6f, 0x3b, 0x54, 0x73, 0x68, 0x3b, 0x4d,
0x6f, 0x73, 0x3b, 0x42, 0x65, 0x64, 0x3b, 0x52, 0x61, 0x72, 0x3b, 0x4e, 0x65, 0x3b, 0x54, 0x6c, 0x61, 0x3b, 0x4d, 0x61,
0x74, 0x3b, 0x54, 0x73, 0x68, 0x69, 0x70, 0x69, 0x3b, 0x4d, 0x6f, 0x73, 0x6f, 0x70, 0x75, 0x6c, 0x6f, 0x67, 0x6f, 0x3b,
0x4c, 0x61, 0x62, 0x6f, 0x62, 0x65, 0x64, 0x69, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x72, 0x6f, 0x3b, 0x4c, 0x61,
0x62, 0x6f, 0x6e, 0x65, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x74, 0x6c, 0x68, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x61, 0x74, 0x6c,
0x68, 0x61, 0x74, 0x73, 0x6f, 0x3b, 0x53, 0x76, 0x6f, 0x3b, 0x4d, 0x75, 0x76, 0x3b, 0x43, 0x68, 0x69, 0x70, 0x3b, 0x43,
0x68, 0x69, 0x74, 0x3b, 0x43, 0x68, 0x69, 0x6e, 0x3b, 0x43, 0x68, 0x69, 0x73, 0x3b, 0x4d, 0x75, 0x67, 0x3b, 0x53, 0x76,
0x6f, 0x6e, 0x64, 0x6f, 0x3b, 0x4d, 0x75, 0x76, 0x68, 0x75, 0x72, 0x6f, 0x3b, 0x43, 0x68, 0x69, 0x70, 0x69, 0x72, 0x69,
0x3b, 0x43, 0x68, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x3b, 0x43, 0x68, 0x69, 0x73, 0x68,
0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x75, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x43, 0x3b, 0x43,
0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x4d, 0x3b, 0xd89, 0xdbb, 0xdd2, 0x3b, 0xdc3, 0xdb3, 0xdd4, 0x3b, 0xd85, 0xd9f, 0x3b, 0xdb6, 0xdaf,
0xdcf, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb, 0xdc4, 0x3b, 0xdc3, 0xdd2, 0xd9a, 0xdd4, 0x3b, 0xdc3, 0xdd9, 0xdb1, 0x3b, 0xd89, 0xdbb, 0xdd2,
0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdb3, 0xdd4, 0xdaf, 0xdcf, 0x3b, 0xd85, 0xd9f, 0xdc4, 0xdbb, 0xdd4, 0xdc0, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6,
0xdaf, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb, 0xdc4, 0xdc3, 0xdca, 0xdb4, 0xdad, 0xdd2, 0xdb1, 0xdca, 0xdaf, 0xdcf, 0x3b,
0xdc3, 0xdd2, 0xd9a, 0xdd4, 0xdbb, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdd9, 0xdb1, 0xdc3, 0xdd4, 0xdbb, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xd89,
0x3b, 0xdc3, 0x3b, 0xd85, 0x3b, 0xdb6, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb, 0x3b, 0xdc3, 0xdd2, 0x3b, 0xdc3, 0xdd9, 0x3b, 0x53, 0x6f,
0x6e, 0x3b, 0x4d, 0x73, 0x6f, 0x3b, 0x42, 0x69, 0x6c, 0x3b, 0x54, 0x73, 0x61, 0x3b, 0x4e, 0x65, 0x3b, 0x48, 0x6c, 0x61,
0x3b, 0x4d, 0x67, 0x63, 0x3b, 0x4c, 0x69, 0x73, 0x6f, 0x6e, 0x74, 0x66, 0x6f, 0x3b, 0x75, 0x4d, 0x73, 0x6f, 0x6d, 0x62,
0x75, 0x6c, 0x75, 0x6b, 0x6f, 0x3b, 0x4c, 0x65, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4c, 0x65, 0x73, 0x69, 0x74,
0x73, 0x61, 0x74, 0x66, 0x75, 0x3b, 0x4c, 0x65, 0x73, 0x69, 0x6e, 0x65, 0x3b, 0x4c, 0x65, 0x73, 0x69, 0x68, 0x6c, 0x61,
0x6e, 0x75, 0x3b, 0x75, 0x4d, 0x67, 0x63, 0x69, 0x62, 0x65, 0x6c, 0x6f, 0x3b, 0x6e, 0x65, 0x3b, 0x70, 0x6f, 0x3b, 0x75,
0x74, 0x3b, 0x73, 0x74, 0x3b, 0x161, 0x74, 0x3b, 0x70, 0x69, 0x3b, 0x73, 0x6f, 0x3b, 0x6e, 0x65, 0x64, 0x65, 0x13e, 0x61,
0x3b, 0x70, 0x6f, 0x6e, 0x64, 0x65, 0x6c, 0x6f, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x6f, 0x6b, 0x3b, 0x73, 0x74, 0x72,
0x65, 0x64, 0x61, 0x3b, 0x161, 0x74, 0x76, 0x72, 0x74, 0x6f, 0x6b, 0x3b, 0x70, 0x69, 0x61, 0x74, 0x6f, 0x6b, 0x3b, 0x73,
0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x4e, 0x3b, 0x50, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x160, 0x3b, 0x50, 0x3b, 0x53, 0x3b,
0x6e, 0x65, 0x64, 0x3b, 0x70, 0x6f, 0x6e, 0x3b, 0x74, 0x6f, 0x72, 0x3b, 0x73, 0x72, 0x65, 0x3b, 0x10d, 0x65, 0x74, 0x3b,
0x70, 0x65, 0x74, 0x3b, 0x73, 0x6f, 0x62, 0x3b, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x65,
0x64, 0x65, 0x6c, 0x6a, 0x65, 0x6b, 0x3b, 0x74, 0x6f, 0x72, 0x65, 0x6b, 0x3b, 0x73, 0x72, 0x65, 0x64, 0x61, 0x3b, 0x10d,
0x65, 0x74, 0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b,
0x6e, 0x3b, 0x70, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0x10d, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x6e, 0x65, 0x64, 0x2e, 0x3b, 0x70,
0x6f, 0x6e, 0x2e, 0x3b, 0x74, 0x6f, 0x72, 0x2e, 0x3b, 0x73, 0x72, 0x65, 0x2e, 0x3b, 0x10d, 0x65, 0x74, 0x2e, 0x3b, 0x70,
0x65, 0x74, 0x2e, 0x3b, 0x73, 0x6f, 0x62, 0x2e, 0x3b, 0x41, 0x78, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x3b, 0x54, 0x61, 0x6c,
0x3b, 0x41, 0x72, 0x62, 0x3b, 0x4b, 0x68, 0x61, 0x3b, 0x4a, 0x69, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x41, 0x78, 0x61,
0x64, 0x3b, 0x49, 0x73, 0x6e, 0x69, 0x69, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x61, 0x64, 0x6f, 0x3b, 0x41, 0x72, 0x62,
0x61, 0x63, 0x6f, 0x3b, 0x4b, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x3b, 0x4a, 0x69, 0x6d, 0x63, 0x6f, 0x3b, 0x53, 0x61,
0x62, 0x74, 0x69, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x64, 0x6f,
0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x69, 0xe9, 0x3b, 0x6a, 0x75, 0x65, 0x3b, 0x76, 0x69,
0x65, 0x3b, 0x73, 0xe1, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x6c, 0x75, 0x6e, 0x65, 0x73, 0x3b,
0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x6d, 0x69, 0xe9, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b, 0x6a, 0x75, 0x65,
0x76, 0x65, 0x73, 0x3b, 0x76, 0x69, 0x65, 0x72, 0x6e, 0x65, 0x73, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x4a,
0x32, 0x3b, 0x4a, 0x33, 0x3b, 0x4a, 0x34, 0x3b, 0x4a, 0x35, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x3b, 0x4a, 0x31,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x61,
0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69,
0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x31, 0x3b, 0x73, 0xf6, 0x6e, 0x3b, 0x6d,
0xe5, 0x6e, 0x3b, 0x74, 0x69, 0x73, 0x3b, 0x6f, 0x6e, 0x73, 0x3b, 0x74, 0x6f, 0x72, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c,
0xf6, 0x72, 0x3b, 0x73, 0xf6, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0xe5, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x69, 0x73,
0x64, 0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66,
0x72, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c, 0xf6, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x73, 0xf6, 0x6e, 0x3b, 0x6d, 0xe5, 0x6e,
0x3b, 0x74, 0x69, 0x73, 0x3b, 0x6f, 0x6e, 0x73, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c, 0xf6,
0x72, 0x3b, 0x4c, 0x69, 0x6e, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x69, 0x79, 0x3b, 0x48, 0x75,
0x77, 0x3b, 0x42, 0x69, 0x79, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4c, 0x69, 0x6e, 0x67, 0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e,
0x65, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0x69, 0x79, 0x65, 0x72, 0x6b, 0x75, 0x6c, 0x65, 0x73,
0x3b, 0x48, 0x75, 0x77, 0x65, 0x62, 0x65, 0x73, 0x3b, 0x42, 0x69, 0x79, 0x65, 0x72, 0x6e, 0x65, 0x73, 0x3b, 0x53, 0x61,
0x62, 0x61, 0x64, 0x6f, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x42, 0x3b, 0x53, 0x3b, 0x4c,
0x69, 0x6e, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x79, 0x65, 0x3b, 0x48, 0x75, 0x77, 0x3b, 0x42,
0x79, 0x65, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x42f, 0x448, 0x431, 0x3b, 0x414, 0x448, 0x431, 0x3b, 0x421, 0x448, 0x431, 0x3b, 0x427,
0x448, 0x431, 0x3b, 0x41f, 0x448, 0x431, 0x3b, 0x4b6, 0x43c, 0x44a, 0x3b, 0x428, 0x43d, 0x431, 0x3b, 0x42f, 0x43a, 0x448, 0x430, 0x43d,
0x431, 0x435, 0x3b, 0x414, 0x443, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x421, 0x435, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x427,
0x43e, 0x440, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x41f, 0x430, 0x43d, 0x4b7, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x4b6, 0x443,
0x43c, 0x44a, 0x430, 0x3b, 0x428, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0xb9e, 0xbbe, 0x3b, 0xba4, 0xbbf, 0x3b, 0xb9a, 0xbc6, 0x3b, 0xbaa,
0xbc1, 0x3b, 0xbb5, 0xbbf, 0x3b, 0xbb5, 0xbc6, 0x3b, 0xb9a, 0x3b, 0xb9e, 0xbbe, 0xbaf, 0xbbf, 0xbb1, 0xbc1, 0x3b, 0xba4, 0xbbf, 0xb99,
0xbcd, 0xb95, 0xbb3, 0xbcd, 0x3b, 0xb9a, 0xbc6, 0xbb5, 0xbcd, 0xbb5, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0xbaa, 0xbc1, 0xba4, 0xba9, 0xbcd, 0x3b,
0xbb5, 0xbbf, 0xbaf, 0xbbe, 0xbb4, 0xba9, 0xbcd, 0x3b, 0xbb5, 0xbc6, 0xbb3, 0xbcd, 0xbb3, 0xbbf, 0x3b, 0xb9a, 0xba9, 0xbbf, 0x3b, 0xc06,
0xc26, 0xc3f, 0x3b, 0xc38, 0xc4b, 0xc2e, 0x3b, 0xc2e, 0xc02, 0xc17, 0xc33, 0x3b, 0xc2c, 0xc41, 0xc27, 0x3b, 0xc17, 0xc41, 0xc30, 0xc41,
0x3b, 0xc36, 0xc41, 0xc15, 0xc4d, 0xc30, 0x3b, 0xc36, 0xc28, 0xc3f, 0x3b, 0xc06, 0xc26, 0xc3f, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc38,
0xc4b, 0xc2e, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc2e, 0xc02, 0xc17, 0xc33, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc2c, 0xc41, 0xc27, 0xc35,
0xc3e, 0xc30, 0xc02, 0x3b, 0xc17, 0xc41, 0xc30, 0xc41, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc36, 0xc41, 0xc15, 0xc4d, 0xc30, 0xc35, 0xc3e,
0xc30, 0xc02, 0x3b, 0xc36, 0xc28, 0xc3f, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc06, 0x3b, 0xc38, 0xc4b, 0x3b, 0xc2e, 0x3b, 0xc2d, 0xc41,
0x3b, 0xc17, 0xc41, 0x3b, 0xc36, 0xc41, 0x3b, 0xc36, 0x3b, 0xe2d, 0xe32, 0x2e, 0x3b, 0xe08, 0x2e, 0x3b, 0xe2d, 0x2e, 0x3b, 0xe1e,
0x2e, 0x3b, 0xe1e, 0xe24, 0x2e, 0x3b, 0xe28, 0x2e, 0x3b, 0xe2a, 0x2e, 0x3b, 0xe27, 0xe31, 0xe19, 0xe2d, 0xe32, 0xe17, 0xe34, 0xe15,
0xe22, 0xe4c, 0x3b, 0xe27, 0xe31, 0xe19, 0xe08, 0xe31, 0xe19, 0xe17, 0xe23, 0xe4c, 0x3b, 0xe27, 0xe31, 0xe19, 0xe2d, 0xe31, 0xe07, 0xe04,
0xe32, 0xe23, 0x3b, 0xe27, 0xe31, 0xe19, 0xe1e, 0xe38, 0xe18, 0x3b, 0xe27, 0xe31, 0xe19, 0xe1e, 0xe24, 0xe2b, 0xe31, 0xe2a, 0xe1a, 0xe14,
0xe35, 0x3b, 0xe27, 0xe31, 0xe19, 0xe28, 0xe38, 0xe01, 0xe23, 0xe4c, 0x3b, 0xe27, 0xe31, 0xe19, 0xe40, 0xe2a, 0xe32, 0xe23, 0xe4c, 0x3b,
0xe2d, 0x3b, 0xe08, 0x3b, 0xe2d, 0x3b, 0xe1e, 0x3b, 0xe1e, 0x3b, 0xe28, 0x3b, 0xe2a, 0x3b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf58, 0xf72, 0xf42, 0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54,
0xf0b, 0x3b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xf7a,
0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf5f,
0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf58, 0xf72, 0xf42, 0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf42, 0xf5f,
0xf60, 0xf0b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b,
0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf66, 0xfa4, 0xf7a, 0xf53,
0xf0b, 0xf54, 0xf0b, 0x3b, 0xf49, 0xf72, 0x3b, 0xf5f, 0xfb3, 0x3b, 0xf58, 0xf72, 0x3b, 0xf67, 0xfb3, 0x3b, 0xf55, 0xf74, 0x3b, 0xf66,
0x3b, 0xf66, 0xfa4, 0xf7a, 0x3b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf58, 0xf72, 0xf42,
0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf67, 0xfb3, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b,
0x3b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf49, 0xf72,
0xf0b, 0xf58, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf58, 0xf72,
0xf42, 0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf67, 0xfb3, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f,
0xf60, 0xf0b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf42,
0xf5f, 0xf60, 0xf0b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf49, 0xf72, 0x3b, 0xf5f, 0xfb3, 0x3b, 0xf58, 0xf72, 0x3b,
0xf67, 0xfb3, 0xf42, 0x3b, 0xf55, 0xf74, 0x3b, 0xf66, 0x3b, 0xf66, 0xfa4, 0xf7a, 0x3b, 0x1230, 0x1295, 0x1260, 0x1275, 0x3b, 0x1230, 0x1291,
0x12ed, 0x3b, 0x1230, 0x1209, 0x1235, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1213, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1262, 0x3b, 0x1240, 0x12f3,
0x121d, 0x3b, 0x1230, 0x3b, 0x1230, 0x3b, 0x1220, 0x3b, 0x1228, 0x3b, 0x1283, 0x3b, 0x12d3, 0x3b, 0x1240, 0x3b, 0x1230, 0x1295, 0x1260, 0x1275,
0x3b, 0x1230, 0x1291, 0x12ed, 0x3b, 0x1220, 0x1209, 0x1235, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1283, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1262,
0x3b, 0x1240, 0x12f3, 0x121d, 0x3b, 0x53, 0x101, 0x70, 0x3b, 0x4d, 0x14d, 0x6e, 0x3b, 0x54, 0x16b, 0x73, 0x3b, 0x50, 0x75, 0x6c,
0x3b, 0x54, 0x75, 0x2bb, 0x61, 0x3b, 0x46, 0x61, 0x6c, 0x3b, 0x54, 0x6f, 0x6b, 0x3b, 0x53, 0x101, 0x70, 0x61, 0x74, 0x65,
0x3b, 0x4d, 0x14d, 0x6e, 0x69, 0x74, 0x65, 0x3b, 0x54, 0x16b, 0x73, 0x69, 0x74, 0x65, 0x3b, 0x50, 0x75, 0x6c, 0x65, 0x6c,
0x75, 0x6c, 0x75, 0x3b, 0x54, 0x75, 0x2bb, 0x61, 0x70, 0x75, 0x6c, 0x65, 0x6c, 0x75, 0x6c, 0x75, 0x3b, 0x46, 0x61, 0x6c,
0x61, 0x69, 0x74, 0x65, 0x3b, 0x54, 0x6f, 0x6b, 0x6f, 0x6e, 0x61, 0x6b, 0x69, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b,
0x50, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x54, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x75, 0x73, 0x3b, 0x42, 0x69, 0x72, 0x3b,
0x48, 0x61, 0x72, 0x3b, 0x4e, 0x65, 0x3b, 0x54, 0x6c, 0x68, 0x3b, 0x4d, 0x75, 0x67, 0x3b, 0x53, 0x6f, 0x6e, 0x74, 0x6f,
0x3b, 0x4d, 0x75, 0x73, 0x75, 0x6d, 0x62, 0x68, 0x75, 0x6e, 0x75, 0x6b, 0x75, 0x3b, 0x52, 0x61, 0x76, 0x75, 0x6d, 0x62,
0x69, 0x72, 0x68, 0x69, 0x3b, 0x52, 0x61, 0x76, 0x75, 0x6e, 0x68, 0x61, 0x72, 0x68, 0x75, 0x3b, 0x52, 0x61, 0x76, 0x75,
0x6d, 0x75, 0x6e, 0x65, 0x3b, 0x52, 0x61, 0x76, 0x75, 0x6e, 0x74, 0x6c, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x75, 0x67,
0x71, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x3b, 0x50, 0x61, 0x7a, 0x3b, 0x50, 0x7a, 0x74, 0x3b, 0x53, 0x61, 0x6c, 0x3b, 0xc7,
0x61, 0x72, 0x3b, 0x50, 0x65, 0x72, 0x3b, 0x43, 0x75, 0x6d, 0x3b, 0x43, 0x6d, 0x74, 0x3b, 0x50, 0x61, 0x7a, 0x61, 0x72,
0x3b, 0x50, 0x61, 0x7a, 0x61, 0x72, 0x74, 0x65, 0x73, 0x69, 0x3b, 0x53, 0x61, 0x6c, 0x131, 0x3b, 0xc7, 0x61, 0x72, 0x15f,
0x61, 0x6d, 0x62, 0x61, 0x3b, 0x50, 0x65, 0x72, 0x15f, 0x65, 0x6d, 0x62, 0x65, 0x3b, 0x43, 0x75, 0x6d, 0x61, 0x3b, 0x43,
0x75, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x69, 0x3b, 0x50, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0xc7, 0x3b, 0x50, 0x3b, 0x43,
0x3b, 0x43, 0x3b, 0x41d, 0x434, 0x3b, 0x41f, 0x43d, 0x3b, 0x412, 0x442, 0x3b, 0x421, 0x440, 0x3b, 0x427, 0x442, 0x3b, 0x41f, 0x442,
0x3b, 0x421, 0x431, 0x3b, 0x41d, 0x435, 0x434, 0x456, 0x43b, 0x44f, 0x3b, 0x41f, 0x43e, 0x43d, 0x435, 0x434, 0x456, 0x43b, 0x43e, 0x43a,
0x3b, 0x412, 0x456, 0x432, 0x442, 0x43e, 0x440, 0x43e, 0x43a, 0x3b, 0x421, 0x435, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x427, 0x435, 0x442,
0x432, 0x435, 0x440, 0x3b, 0x41f, 0x2bc, 0x44f, 0x442, 0x43d, 0x438, 0x446, 0x44f, 0x3b, 0x421, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b,
0x41d, 0x3b, 0x41f, 0x3b, 0x412, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x421, 0x3b, 0x627, 0x62a, 0x648, 0x627, 0x631, 0x3b,
0x67e, 0x64a, 0x631, 0x3b, 0x645, 0x646, 0x6af, 0x644, 0x3b, 0x628, 0x62f, 0x647, 0x3b, 0x62c, 0x645, 0x639, 0x631, 0x627, 0x62a, 0x3b,
0x62c, 0x645, 0x639, 0x6c1, 0x3b, 0x6c1, 0x641, 0x62a, 0x6c1, 0x3b, 0x42f, 0x43a, 0x448, 0x3b, 0x414, 0x443, 0x448, 0x3b, 0x421, 0x435,
0x448, 0x3b, 0x427, 0x43e, 0x440, 0x3b, 0x41f, 0x430, 0x439, 0x3b, 0x416, 0x443, 0x43c, 0x3b, 0x428, 0x430, 0x43d, 0x3b, 0x44f, 0x43a,
0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x434, 0x443, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x441, 0x435, 0x448, 0x430, 0x43d, 0x431,
0x430, 0x3b, 0x447, 0x43e, 0x440, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x43f, 0x430, 0x439, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b,
0x436, 0x443, 0x43c, 0x430, 0x3b, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x42f, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f,
0x3b, 0x416, 0x3b, 0x428, 0x3b, 0x6cc, 0x2e, 0x3b, 0x62f, 0x2e, 0x3b, 0x633, 0x2e, 0x3b, 0x686, 0x2e, 0x3b, 0x67e, 0x2e, 0x3b,
0x62c, 0x2e, 0x3b, 0x634, 0x2e, 0x3b, 0x59, 0x61, 0x6b, 0x73, 0x68, 0x3b, 0x44, 0x75, 0x73, 0x68, 0x3b, 0x53, 0x65, 0x73,
0x68, 0x3b, 0x43, 0x68, 0x6f, 0x72, 0x3b, 0x50, 0x61, 0x79, 0x3b, 0x43, 0x75, 0x6d, 0x3b, 0x53, 0x68, 0x61, 0x6e, 0x3b,
0x79, 0x61, 0x6b, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x64, 0x75, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x73,
0x65, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x63, 0x68, 0x6f, 0x72, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x70,
0x61, 0x79, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x63, 0x75, 0x6d, 0x61, 0x3b, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61,
0x3b, 0x59, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x43, 0x3b, 0x53, 0x3b, 0x43, 0x4e, 0x3b, 0x54, 0x68,
0x20, 0x32, 0x3b, 0x54, 0x68, 0x20, 0x33, 0x3b, 0x54, 0x68, 0x20, 0x34, 0x3b, 0x54, 0x68, 0x20, 0x35, 0x3b, 0x54, 0x68,
0x20, 0x36, 0x3b, 0x54, 0x68, 0x20, 0x37, 0x3b, 0x43, 0x68, 0x1ee7, 0x20, 0x6e, 0x68, 0x1ead, 0x74, 0x3b, 0x54, 0x68, 0x1ee9,
0x20, 0x68, 0x61, 0x69, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x62, 0x61, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x74, 0x1b0, 0x3b, 0x54,
0x68, 0x1ee9, 0x20, 0x6e, 0x103, 0x6d, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x73, 0xe1, 0x75, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x62,
0x1ea3, 0x79, 0x3b, 0x43, 0x4e, 0x3b, 0x54, 0x32, 0x3b, 0x54, 0x33, 0x3b, 0x54, 0x34, 0x3b, 0x54, 0x35, 0x3b, 0x54, 0x36,
0x3b, 0x54, 0x37, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x6c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x4d, 0x65, 0x72,
0x3b, 0x49, 0x61, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x53, 0x75,
0x6c, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x4c, 0x6c, 0x75, 0x6e, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x4d, 0x61, 0x77,
0x72, 0x74, 0x68, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x65, 0x72, 0x3b, 0x44, 0x79, 0x64,
0x64, 0x20, 0x49, 0x61, 0x75, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x44, 0x79,
0x64, 0x64, 0x20, 0x53, 0x61, 0x64, 0x77, 0x72, 0x6e, 0x3b, 0x53, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x49, 0x3b,
0x47, 0x3b, 0x53, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x6c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x4d, 0x65, 0x72,
0x3b, 0x49, 0x61, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x43, 0x61, 0x77, 0x3b, 0x4d, 0x76,
0x75, 0x3b, 0x42, 0x69, 0x6e, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x53, 0x69, 0x6e, 0x3b, 0x48, 0x6c, 0x61, 0x3b, 0x4d, 0x67,
0x71, 0x3b, 0x43, 0x61, 0x77, 0x65, 0x3b, 0x4d, 0x76, 0x75, 0x6c, 0x6f, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x62, 0x69,
0x6e, 0x69, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69,
0x6e, 0x65, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x67, 0x71, 0x69, 0x62, 0x65,
0x6c, 0x6f, 0x3b, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x41, 0x6a, 0xe9, 0x3b, 0xcc, 0x73, 0x1eb9, 0x301, 0x67, 0x75, 0x6e, 0x3b,
0x1ecc, 0x6a, 0x1ecd, 0x301, 0x72, 0xfa, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x62, 0x1ecd, 0x3b, 0x1eb8, 0x74, 0xec, 0x3b, 0xc0, 0x62,
0xe1, 0x6d, 0x1eb9, 0x301, 0x74, 0x61, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x1ecc, 0x6a, 0x1ecd,
0x301, 0x20, 0x41, 0x6a, 0xe9, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0xcc, 0x73, 0x1eb9, 0x301, 0x67, 0x75, 0x6e, 0x3b, 0x1ecc,
0x6a, 0x1ecd, 0x301, 0x72, 0xfa, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x62, 0x1ecd, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0x1eb8, 0x74,
0xec, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0xc0, 0x62, 0xe1, 0x6d, 0x1eb9, 0x301, 0x74, 0x61, 0x3b, 0x53, 0x6f, 0x6e, 0x3b,
0x4d, 0x73, 0x6f, 0x3b, 0x42, 0x69, 0x6c, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x53, 0x69, 0x6e, 0x3b, 0x48, 0x6c, 0x61, 0x3b,
0x4d, 0x67, 0x71, 0x3b, 0x53, 0x6f, 0x6e, 0x74, 0x6f, 0x3b, 0x4d, 0x73, 0x6f, 0x6d, 0x62, 0x75, 0x6c, 0x75, 0x6b, 0x6f,
0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x74, 0x68, 0x61, 0x74,
0x68, 0x75, 0x3b, 0x75, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x6e, 0x65, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x68, 0x6c, 0x61,
0x6e, 0x75, 0x3b, 0x4d, 0x67, 0x71, 0x69, 0x62, 0x65, 0x6c, 0x6f, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x42, 0x3b, 0x54, 0x3b,
0x53, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x73, 0xf8, 0x6e, 0x3b, 0x6d, 0xe5, 0x6e, 0x3b, 0x74, 0x79, 0x73, 0x3b, 0x6f, 0x6e,
0x73, 0x3b, 0x74, 0x6f, 0x72, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c, 0x61, 0x75, 0x3b, 0x73, 0xf8, 0x6e, 0x64, 0x61, 0x67,
0x3b, 0x6d, 0xe5, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x79, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61,
0x67, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66, 0x72, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c, 0x61, 0x75,
0x72, 0x64, 0x61, 0x67, 0x3b, 0x73, 0xf8, 0x2e, 0x3b, 0x6d, 0xe5, 0x2e, 0x3b, 0x74, 0x79, 0x2e, 0x3b, 0x6f, 0x6e, 0x2e,
0x3b, 0x74, 0x6f, 0x2e, 0x3b, 0x66, 0x72, 0x2e, 0x3b, 0x6c, 0x61, 0x2e, 0x3b, 0x4a, 0x65, 0x64, 0x3b, 0x4a, 0x65, 0x6c,
0x3b, 0x4a, 0x65, 0x6d, 0x3b, 0x4a, 0x65, 0x72, 0x63, 0x3b, 0x4a, 0x65, 0x72, 0x64, 0x3b, 0x4a, 0x65, 0x68, 0x3b, 0x4a,
0x65, 0x73, 0x3b, 0x4a, 0x65, 0x64, 0x6f, 0x6f, 0x6e, 0x65, 0x65, 0x3b, 0x4a, 0x65, 0x6c, 0x68, 0x65, 0x69, 0x6e, 0x3b,
0x4a, 0x65, 0x6d, 0x61, 0x79, 0x72, 0x74, 0x3b, 0x4a, 0x65, 0x72, 0x63, 0x65, 0x61, 0x6e, 0x3b, 0x4a, 0x65, 0x72, 0x64,
0x65, 0x69, 0x6e, 0x3b, 0x4a, 0x65, 0x68, 0x65, 0x69, 0x6e, 0x65, 0x79, 0x3b, 0x4a, 0x65, 0x73, 0x61, 0x72, 0x6e, 0x3b,
0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x74, 0x68, 0x3b, 0x4d, 0x68, 0x72, 0x3b, 0x59, 0x6f, 0x77, 0x3b,
0x47, 0x77, 0x65, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x44, 0x65, 0x20, 0x53, 0x75, 0x6c, 0x3b, 0x44, 0x65, 0x20, 0x4c, 0x75,
0x6e, 0x3b, 0x44, 0x65, 0x20, 0x4d, 0x65, 0x72, 0x74, 0x68, 0x3b, 0x44, 0x65, 0x20, 0x4d, 0x65, 0x72, 0x68, 0x65, 0x72,
0x3b, 0x44, 0x65, 0x20, 0x59, 0x6f, 0x77, 0x3b, 0x44, 0x65, 0x20, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x44, 0x65,
0x20, 0x53, 0x61, 0x64, 0x6f, 0x72, 0x6e, 0x3b, 0x4b, 0x77, 0x65, 0x3b, 0x44, 0x77, 0x6f, 0x3b, 0x42, 0x65, 0x6e, 0x3b,
0x57, 0x75, 0x6b, 0x3b, 0x59, 0x61, 0x77, 0x3b, 0x46, 0x69, 0x61, 0x3b, 0x4d, 0x65, 0x6d, 0x3b, 0x4b, 0x77, 0x65, 0x73,
0x69, 0x64, 0x61, 0x3b, 0x44, 0x77, 0x6f, 0x77, 0x64, 0x61, 0x3b, 0x42, 0x65, 0x6e, 0x61, 0x64, 0x61, 0x3b, 0x57, 0x75,
0x6b, 0x75, 0x64, 0x61, 0x3b, 0x59, 0x61, 0x77, 0x64, 0x61, 0x3b, 0x46, 0x69, 0x64, 0x61, 0x3b, 0x4d, 0x65, 0x6d, 0x65,
0x6e, 0x65, 0x64, 0x61, 0x3b, 0x4b, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x57, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x906,
0x926, 0x93f, 0x924, 0x94d, 0x92f, 0x935, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x935, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x933,
0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x941,
0x915, 0x94d, 0x930, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x48, 0x6f, 0x3b, 0x44, 0x7a, 0x75,
0x3b, 0x44, 0x7a, 0x66, 0x3b, 0x53, 0x68, 0x6f, 0x3b, 0x53, 0x6f, 0x6f, 0x3b, 0x53, 0x6f, 0x68, 0x3b, 0x48, 0x6f, 0x3b,
0x48, 0x6f, 0x67, 0x62, 0x61, 0x61, 0x3b, 0x44, 0x7a, 0x75, 0x3b, 0x44, 0x7a, 0x75, 0x66, 0x6f, 0x3b, 0x53, 0x68, 0x6f,
0x3b, 0x53, 0x6f, 0x6f, 0x3b, 0x53, 0x6f, 0x68, 0x61, 0x61, 0x3b, 0x48, 0x6f, 0x3b, 0x1ee4, 0x6b, 0x61, 0x3b, 0x4d, 0x1ecd,
0x6e, 0x3b, 0x54, 0x69, 0x75, 0x3b, 0x57, 0x65, 0x6e, 0x3b, 0x54, 0x1ecd, 0x1ecd, 0x3b, 0x46, 0x72, 0x61, 0x1ecb, 0x3b, 0x53,
0x61, 0x74, 0x3b, 0x4d, 0x62, 0x1ecd, 0x73, 0x1ecb, 0x20, 0x1ee4, 0x6b, 0x61, 0x3b, 0x4d, 0x1ecd, 0x6e, 0x64, 0x65, 0x3b, 0x54,
0x69, 0x75, 0x7a, 0x64, 0x65, 0x65, 0x3b, 0x57, 0x65, 0x6e, 0x65, 0x7a, 0x64, 0x65, 0x65, 0x3b, 0x54, 0x1ecd, 0x1ecd, 0x7a,
0x64, 0x65, 0x65, 0x3b, 0x46, 0x72, 0x61, 0x1ecb, 0x64, 0x65, 0x65, 0x3b, 0x53, 0x61, 0x74, 0x1ecd, 0x64, 0x65, 0x65, 0x3b,
0x57, 0x6b, 0x79, 0x3b, 0x57, 0x6b, 0x77, 0x3b, 0x57, 0x6b, 0x6c, 0x3b, 0x57, 0x74, 0x169, 0x3b, 0x57, 0x6b, 0x6e, 0x3b,
0x57, 0x74, 0x6e, 0x3b, 0x57, 0x74, 0x68, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x79, 0x75, 0x6d, 0x77, 0x61, 0x3b, 0x57, 0x61,
0x20, 0x6b, 0x77, 0x61, 0x6d, 0x62, 0x129, 0x6c, 0x129, 0x6c, 0x79, 0x61, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x65, 0x6c, 0x129,
0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x57,
0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x57, 0x61, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x74, 0x68, 0x61, 0x74,
0x169, 0x3b, 0x59, 0x3b, 0x57, 0x3b, 0x45, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x1230, 0x2f, 0x1245, 0x3b,
0x1230, 0x1291, 0x3b, 0x1230, 0x120a, 0x131d, 0x3b, 0x1208, 0x1313, 0x3b, 0x12a3, 0x121d, 0x12f5, 0x3b, 0x12a3, 0x122d, 0x1265, 0x3b, 0x1230, 0x2f,
0x123d, 0x3b, 0x1230, 0x1295, 0x1260, 0x122d, 0x20, 0x1245, 0x12f3, 0x12c5, 0x3b, 0x1230, 0x1291, 0x3b, 0x1230, 0x120a, 0x131d, 0x3b, 0x1208, 0x1313,
0x20, 0x12c8, 0x122a, 0x20, 0x1208, 0x1265, 0x12cb, 0x3b, 0x12a3, 0x121d, 0x12f5, 0x3b, 0x12a3, 0x122d, 0x1265, 0x3b, 0x1230, 0x1295, 0x1260, 0x122d,
0x20, 0x123d, 0x1313, 0x12c5, 0x3b, 0x1230, 0x3b, 0x1230, 0x3b, 0x1230, 0x3b, 0x1208, 0x3b, 0x12a3, 0x3b, 0x12a3, 0x3b, 0x1230, 0x3b, 0x53,
0x61, 0x6d, 0x3b, 0x53, 0x61, 0x6e, 0x3b, 0x4d, 0x61, 0x6b, 0x3b, 0x52, 0x6f, 0x77, 0x3b, 0x48, 0x61, 0x6d, 0x3b, 0x41,
0x72, 0x62, 0x3b, 0x51, 0x69, 0x64, 0x3b, 0x53, 0x61, 0x6d, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x6e, 0x79, 0x6f,
0x3b, 0x4d, 0x61, 0x61, 0x6b, 0x69, 0x73, 0x61, 0x6e, 0x79, 0x6f, 0x3b, 0x52, 0x6f, 0x6f, 0x77, 0x65, 0x3b, 0x48, 0x61,
0x6d, 0x75, 0x73, 0x65, 0x3b, 0x41, 0x72, 0x62, 0x65, 0x3b, 0x51, 0x69, 0x64, 0x61, 0x61, 0x6d, 0x65, 0x3b, 0x53, 0x3b,
0x53, 0x3b, 0x4d, 0x3b, 0x52, 0x3b, 0x48, 0x3b, 0x41, 0x3b, 0x51, 0x3b, 0x59, 0x6f, 0x6b, 0x3b, 0x54, 0x75, 0x6e, 0x67,
0x3b, 0x54, 0x2e, 0x20, 0x54, 0x75, 0x6e, 0x67, 0x3b, 0x54, 0x73, 0x61, 0x6e, 0x3b, 0x4e, 0x61, 0x73, 0x3b, 0x4e, 0x61,
0x74, 0x3b, 0x43, 0x68, 0x69, 0x72, 0x3b, 0x57, 0x61, 0x69, 0x20, 0x59, 0x6f, 0x6b, 0x61, 0x20, 0x42, 0x61, 0x77, 0x61,
0x69, 0x3b, 0x57, 0x61, 0x69, 0x20, 0x54, 0x75, 0x6e, 0x67, 0x61, 0x3b, 0x54, 0x6f, 0x6b, 0x69, 0x20, 0x47, 0x69, 0x74,
0x75, 0x6e, 0x67, 0x3b, 0x54, 0x73, 0x61, 0x6d, 0x20, 0x4b, 0x61, 0x73, 0x75, 0x77, 0x61, 0x3b, 0x57, 0x61, 0x69, 0x20,
0x4e, 0x61, 0x20, 0x4e, 0x61, 0x73, 0x3b, 0x57, 0x61, 0x69, 0x20, 0x4e, 0x61, 0x20, 0x54, 0x69, 0x79, 0x6f, 0x6e, 0x3b,
0x57, 0x61, 0x69, 0x20, 0x4e, 0x61, 0x20, 0x43, 0x68, 0x69, 0x72, 0x69, 0x6d, 0x3b, 0x1230, 0x2f, 0x12d3, 0x3b, 0x1230, 0x1296,
0x3b, 0x1273, 0x120b, 0x1238, 0x3b, 0x12a3, 0x1228, 0x122d, 0x3b, 0x12a8, 0x121a, 0x123d, 0x3b, 0x1305, 0x121d, 0x12d3, 0x3b, 0x1230, 0x2f, 0x1295,
0x3b, 0x1230, 0x1295, 0x1260, 0x1275, 0x20, 0x12d3, 0x1263, 0x12ed, 0x3b, 0x1230, 0x1296, 0x3b, 0x1273, 0x120b, 0x1238, 0x1296, 0x3b, 0x12a3, 0x1228,
0x122d, 0x1263, 0x12d3, 0x3b, 0x12a8, 0x121a, 0x123d, 0x3b, 0x1305, 0x121d, 0x12d3, 0x1275, 0x3b, 0x1230, 0x1295, 0x1260, 0x1275, 0x20, 0x1295, 0x12a2,
0x123d, 0x3b, 0x1230, 0x3b, 0x1230, 0x3b, 0x1273, 0x3b, 0x12a3, 0x3b, 0x12a8, 0x3b, 0x1305, 0x3b, 0x1230, 0x3b, 0x4c, 0x61, 0x64, 0x3b,
0x4c, 0x69, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x4c, 0x61, 0x72, 0x3b, 0x4c, 0x61, 0x6d, 0x3b, 0x4a, 0x75, 0x6d, 0x3b,
0x41, 0x73, 0x61, 0x3b, 0x4c, 0x61, 0x64, 0x69, 0x3b, 0x4c, 0x69, 0x6e, 0x74, 0x61, 0x6e, 0x69, 0x3b, 0x54, 0x61, 0x6c,
0x61, 0x74, 0x61, 0x3b, 0x4c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x4c, 0x61, 0x6d, 0x69, 0x74, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x3b, 0x41, 0x73, 0x61, 0x62, 0x61, 0x72, 0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b,
0x6d, 0x69, 0x65, 0x3b, 0x6a, 0x6f, 0x69, 0x3b, 0x76, 0x69, 0x6e, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x65,
0x6e, 0x69, 0x65, 0x3b, 0x6c, 0x75, 0x6e, 0x69, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x61, 0x72, 0x73, 0x3b, 0x6d, 0x69,
0x65, 0x72, 0x63, 0x75, 0x73, 0x3b, 0x6a, 0x6f, 0x69, 0x62, 0x65, 0x3b, 0x76, 0x69, 0x6e, 0x61, 0x72, 0x73, 0x3b, 0x73,
0x61, 0x62, 0x69, 0x64, 0x65, 0x3b, 0x53, 0x77, 0x6f, 0x3b, 0x4d, 0x75, 0x73, 0x3b, 0x56, 0x68, 0x69, 0x3b, 0x52, 0x61,
0x72, 0x3b, 0x1e4a, 0x61, 0x3b, 0x1e70, 0x61, 0x6e, 0x3b, 0x4d, 0x75, 0x67, 0x3b, 0x53, 0x77, 0x6f, 0x6e, 0x64, 0x61, 0x68,
0x61, 0x3b, 0x4d, 0x75, 0x73, 0x75, 0x6d, 0x62, 0x75, 0x6c, 0x75, 0x77, 0x6f, 0x3b, 0x1e3c, 0x61, 0x76, 0x68, 0x75, 0x76,
0x68, 0x69, 0x6c, 0x69, 0x3b, 0x1e3c, 0x61, 0x76, 0x68, 0x75, 0x72, 0x61, 0x72, 0x75, 0x3b, 0x1e3c, 0x61, 0x76, 0x68, 0x75,
0x1e4b, 0x61, 0x3b, 0x1e3c, 0x61, 0x76, 0x68, 0x75, 0x1e71, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x75, 0x67, 0x69, 0x76, 0x68, 0x65,
0x6c, 0x61, 0x3b, 0x6b, 0x254, 0x73, 0x3b, 0x64, 0x7a, 0x6f, 0x3b, 0x62, 0x6c, 0x61, 0x3b, 0x6b, 0x75, 0x256, 0x3b, 0x79,
0x61, 0x77, 0x3b, 0x66, 0x69, 0x256, 0x3b, 0x6d, 0x65, 0x6d, 0x3b, 0x6b, 0x254, 0x73, 0x69, 0x256, 0x61, 0x3b, 0x64, 0x7a,
0x6f, 0x256, 0x61, 0x3b, 0x62, 0x6c, 0x61, 0x256, 0x61, 0x3b, 0x6b, 0x75, 0x256, 0x61, 0x3b, 0x79, 0x61, 0x77, 0x6f, 0x256,
0x61, 0x3b, 0x66, 0x69, 0x256, 0x61, 0x3b, 0x6d, 0x65, 0x6d, 0x6c, 0x65, 0x256, 0x61, 0x3b, 0x6b, 0x3b, 0x64, 0x3b, 0x62,
0x3b, 0x6b, 0x3b, 0x79, 0x3b, 0x66, 0x3b, 0x6d, 0x3b, 0x12c8, 0x130b, 0x3b, 0x1233, 0x12ed, 0x1296, 0x3b, 0x121b, 0x1246, 0x1233, 0x129b,
0x3b, 0x12a0, 0x1229, 0x12cb, 0x3b, 0x1203, 0x1219, 0x1233, 0x3b, 0x12a0, 0x122d, 0x1263, 0x3b, 0x1244, 0x122b, 0x3b, 0x12c8, 0x3b, 0x1233, 0x3b,
0x121b, 0x3b, 0x12a0, 0x3b, 0x1203, 0x3b, 0x12a0, 0x3b, 0x1244, 0x3b, 0x4c, 0x50, 0x3b, 0x50, 0x31, 0x3b, 0x50, 0x32, 0x3b, 0x50,
0x33, 0x3b, 0x50, 0x34, 0x3b, 0x50, 0x35, 0x3b, 0x50, 0x36, 0x3b, 0x4c, 0x101, 0x70, 0x75, 0x6c, 0x65, 0x3b, 0x50, 0x6f,
0x2bb, 0x61, 0x6b, 0x61, 0x68, 0x69, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6c, 0x75, 0x61, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6b,
0x6f, 0x6c, 0x75, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x68, 0x101, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6c, 0x69, 0x6d, 0x61, 0x3b,
0x50, 0x6f, 0x2bb, 0x61, 0x6f, 0x6e, 0x6f, 0x3b, 0x4c, 0x61, 0x64, 0x3b, 0x54, 0x61, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x3b,
0x4c, 0x61, 0x72, 0x3b, 0x4c, 0x61, 0x6d, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x41, 0x73, 0x61, 0x3b, 0x4c, 0x61, 0x64, 0x69,
0x3b, 0x54, 0x61, 0x6e, 0x69, 0x69, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x4c, 0x61, 0x72, 0x62, 0x61, 0x3b,
0x4c, 0x61, 0x6d, 0x69, 0x74, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x61, 0x74, 0x3b, 0x53, 0x75,
0x2e, 0x3b, 0x4d, 0xe4, 0x2e, 0x3b, 0x5a, 0x69, 0x2e, 0x3b, 0x4d, 0x69, 0x2e, 0x3b, 0x44, 0x75, 0x2e, 0x3b, 0x46, 0x72,
0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x53, 0x75, 0x6e, 0x6e, 0x74, 0x69, 0x67, 0x3b, 0x4d, 0xe4, 0xe4, 0x6e, 0x74, 0x69,
0x67, 0x3b, 0x5a, 0x69, 0x69, 0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x3b, 0x4d, 0x69, 0x74, 0x74, 0x77, 0x75, 0x63, 0x68,
0x3b, 0x44, 0x75, 0x6e, 0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x3b, 0x46, 0x72, 0x69, 0x69, 0x74, 0x69, 0x67, 0x3b, 0x53,
0x61, 0x6d, 0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x3b, 0xa18f, 0xa44d, 0x3b, 0xa18f, 0xa2cd, 0x3b, 0xa18f, 0xa44d, 0x3b, 0xa18f, 0xa315,
0x3b, 0xa18f, 0xa1d6, 0x3b, 0xa18f, 0xa26c, 0x3b, 0xa18f, 0xa0d8, 0x3b, 0xa46d, 0xa18f, 0xa44d, 0x3b, 0xa18f, 0xa282, 0xa2cd, 0x3b, 0xa18f, 0xa282,
0xa44d, 0x3b, 0xa18f, 0xa282, 0xa315, 0x3b, 0xa18f, 0xa282, 0xa1d6, 0x3b, 0xa18f, 0xa282, 0xa26c, 0x3b, 0xa18f, 0xa282, 0xa0d8, 0x3b, 0xa18f, 0x3b,
0xa2cd, 0x3b, 0xa44d, 0x3b, 0xa315, 0x3b, 0xa1d6, 0x3b, 0xa26c, 0x3b, 0xa0d8, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x76, 0x75, 0x3b,
0x42, 0x69, 0x6c, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x4e, 0x65, 0x3b, 0x48, 0x6c, 0x61, 0x3b, 0x47, 0x71, 0x69, 0x3b, 0x75,
0x53, 0x6f, 0x6e, 0x74, 0x6f, 0x3b, 0x75, 0x4d, 0x76, 0x75, 0x6c, 0x6f, 0x3b, 0x75, 0x4c, 0x65, 0x73, 0x69, 0x62, 0x69,
0x6c, 0x69, 0x3b, 0x4c, 0x65, 0x73, 0x69, 0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x75, 0x4c, 0x65, 0x73, 0x69, 0x6e,
0x65, 0x3b, 0x6e, 0x67, 0x6f, 0x4c, 0x65, 0x73, 0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x75, 0x6d, 0x47, 0x71, 0x69,
0x62, 0x65, 0x6c, 0x6f, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x6f, 0x73, 0x3b, 0x42, 0x65, 0x64, 0x3b, 0x52, 0x61, 0x72,
0x3b, 0x4e, 0x65, 0x3b, 0x48, 0x6c, 0x61, 0x3b, 0x4d, 0x6f, 0x6b, 0x3b, 0x53, 0x6f, 0x6e, 0x74, 0x61, 0x67, 0x61, 0x3b,
0x4d, 0x6f, 0x73, 0x75, 0x70, 0x61, 0x6c, 0x6f, 0x67, 0x6f, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x62, 0x65, 0x64, 0x69, 0x3b,
0x4c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x72, 0x6f, 0x3b, 0x4c, 0x61, 0x62, 0x6f, 0x6e, 0x65, 0x3b, 0x4c, 0x61, 0x62, 0x6f,
0x68, 0x6c, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x6f, 0x6b, 0x69, 0x62, 0x65, 0x6c, 0x6f, 0x3b, 0x73, 0x6f, 0x74, 0x6e, 0x3b,
0x76, 0x75, 0x6f, 0x73, 0x3b, 0x6d, 0x61, 0x14b, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x3b, 0x64, 0x75, 0x6f, 0x72, 0x3b, 0x62,
0x65, 0x61, 0x72, 0x3b, 0x6c, 0xe1, 0x76, 0x3b, 0x61, 0x65, 0x6a, 0x6c, 0x65, 0x67, 0x65, 0x3b, 0x6d, 0xe5, 0x61, 0x6e,
0x74, 0x61, 0x3b, 0x64, 0xe4, 0x6a, 0x73, 0x74, 0x61, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x65, 0x76, 0x61, 0x68, 0x6b, 0x6f,
0x65, 0x3b, 0x64, 0xe5, 0x61, 0x72, 0x73, 0x74, 0x61, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x6a, 0x61, 0x64, 0x61, 0x68, 0x6b,
0x65, 0x3b, 0x6c, 0x61, 0x61, 0x76, 0x61, 0x64, 0x61, 0x68, 0x6b, 0x65, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x47,
0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x73, 0x6f, 0x74, 0x6e, 0x61, 0x62, 0x65, 0x61, 0x69, 0x76, 0x69, 0x3b, 0x76,
0x75, 0x6f, 0x73, 0x73, 0xe1, 0x72, 0x67, 0x61, 0x3b, 0x6d, 0x61, 0x14b, 0x14b, 0x65, 0x62, 0xe1, 0x72, 0x67, 0x61, 0x3b,
0x67, 0x61, 0x73, 0x6b, 0x61, 0x76, 0x61, 0x68, 0x6b, 0x6b, 0x75, 0x3b, 0x64, 0x75, 0x6f, 0x72, 0x61, 0x73, 0x64, 0x61,
0x74, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x6a, 0x61, 0x64, 0x61, 0x74, 0x3b, 0x6c, 0xe1, 0x76, 0x76, 0x61, 0x72, 0x64, 0x61,
0x74, 0x3b, 0x53, 0x3b, 0x56, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x45, 0x6d, 0x70, 0x3b,
0x4b, 0x69, 0x6e, 0x3b, 0x44, 0x68, 0x61, 0x3b, 0x54, 0x72, 0x75, 0x3b, 0x53, 0x70, 0x61, 0x3b, 0x52, 0x69, 0x6d, 0x3b,
0x4d, 0x61, 0x74, 0x3b, 0x4a, 0x69, 0x79, 0x61, 0x78, 0x20, 0x73, 0x6e, 0x67, 0x61, 0x79, 0x61, 0x6e, 0x3b, 0x74, 0x67,
0x4b, 0x69, 0x6e, 0x67, 0x61, 0x6c, 0x20, 0x6a, 0x69, 0x79, 0x61, 0x78, 0x20, 0x69, 0x79, 0x61, 0x78, 0x20, 0x73, 0x6e,
0x67, 0x61, 0x79, 0x61, 0x6e, 0x3b, 0x74, 0x67, 0x44, 0x68, 0x61, 0x20, 0x6a, 0x69, 0x79, 0x61, 0x78, 0x20, 0x69, 0x79,
0x61, 0x78, 0x20, 0x73, 0x6e, 0x67, 0x61, 0x79, 0x61, 0x6e, 0x3b, 0x74, 0x67, 0x54, 0x72, 0x75, 0x20, 0x6a, 0x69, 0x79,
0x61, 0x78, 0x20, 0x69, 0x79, 0x61, 0x78, 0x20, 0x73, 0x6e, 0x67, 0x61, 0x79, 0x61, 0x6e, 0x3b, 0x74, 0x67, 0x53, 0x70,
0x61, 0x63, 0x20, 0x6a, 0x69, 0x79, 0x61, 0x78, 0x20, 0x69, 0x79, 0x61, 0x78, 0x20, 0x73, 0x6e, 0x67, 0x61, 0x79, 0x61,
0x6e, 0x3b, 0x74, 0x67, 0x52, 0x69, 0x6d, 0x61, 0x20, 0x6a, 0x69, 0x79, 0x61, 0x78, 0x20, 0x69, 0x79, 0x61, 0x78, 0x20,
0x73, 0x6e, 0x67, 0x61, 0x79, 0x61, 0x6e, 0x3b, 0x74, 0x67, 0x4d, 0x61, 0x74, 0x61, 0x72, 0x75, 0x20, 0x6a, 0x69, 0x79,
0x61, 0x78, 0x20, 0x69, 0x79, 0x61, 0x78, 0x20, 0x73, 0x6e, 0x67, 0x61, 0x79, 0x61, 0x6e, 0x3b, 0x45, 0x3b, 0x4b, 0x3b,
0x44, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x4d, 0x3b, 0x43, 0x70, 0x72, 0x3b, 0x43, 0x74, 0x74, 0x3b, 0x43, 0x6d,
0x6e, 0x3b, 0x43, 0x6d, 0x74, 0x3b, 0x41, 0x72, 0x73, 0x3b, 0x49, 0x63, 0x6d, 0x3b, 0x45, 0x73, 0x74, 0x3b, 0x43, 0x68,
0x75, 0x6d, 0x61, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43, 0x68, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x6f, 0x3b, 0x43, 0x68,
0x75, 0x6d, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x43, 0x68, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61,
0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x63, 0x68, 0x75, 0x6d, 0x61, 0x3b, 0x45, 0x73, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b,
0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x45, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x4a, 0x69,
0x6d, 0x3b, 0x4b, 0x61, 0x77, 0x3b, 0x4b, 0x61, 0x64, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x4e, 0x67,
0x75, 0x3b, 0x49, 0x74, 0x75, 0x6b, 0x75, 0x20, 0x6a, 0x61, 0x20, 0x6a, 0x75, 0x6d, 0x77, 0x61, 0x3b, 0x4b, 0x75, 0x72,
0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6a, 0x69, 0x6d, 0x77, 0x65, 0x72, 0x69, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75,
0x6b, 0x61, 0x20, 0x6b, 0x61, 0x77, 0x69, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x64,
0x61, 0x64, 0x75, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4b, 0x75,
0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x73, 0x61, 0x6e, 0x75, 0x3b, 0x4b, 0x69, 0x66, 0x75, 0x6c, 0x61,
0x20, 0x6e, 0x67, 0x75, 0x77, 0x6f, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4e,
0x3b, 0x64, 0x65, 0x77, 0x3b, 0x61, 0x61, 0x253, 0x3b, 0x6d, 0x61, 0x77, 0x3b, 0x6e, 0x6a, 0x65, 0x3b, 0x6e, 0x61, 0x61,
0x3b, 0x6d, 0x77, 0x64, 0x3b, 0x68, 0x62, 0x69, 0x3b, 0x64, 0x65, 0x77, 0x6f, 0x3b, 0x61, 0x61, 0x253, 0x6e, 0x64, 0x65,
0x3b, 0x6d, 0x61, 0x77, 0x62, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x6e, 0x6a, 0x65, 0x73, 0x6c, 0x61, 0x61, 0x72, 0x65, 0x3b,
0x6e, 0x61, 0x61, 0x73, 0x61, 0x61, 0x6e, 0x64, 0x65, 0x3b, 0x6d, 0x61, 0x77, 0x6e, 0x64, 0x65, 0x3b, 0x68, 0x6f, 0x6f,
0x72, 0x65, 0x2d, 0x62, 0x69, 0x69, 0x72, 0x3b, 0x64, 0x3b, 0x61, 0x3b, 0x6d, 0x3b, 0x6e, 0x3b, 0x6e, 0x3b, 0x6d, 0x3b,
0x68, 0x3b, 0x4b, 0x4d, 0x41, 0x3b, 0x4e, 0x54, 0x54, 0x3b, 0x4e, 0x4d, 0x4e, 0x3b, 0x4e, 0x4d, 0x54, 0x3b, 0x41, 0x52,
0x54, 0x3b, 0x4e, 0x4d, 0x41, 0x3b, 0x4e, 0x4d, 0x4d, 0x3b, 0x4b, 0x69, 0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4e, 0x6a, 0x75,
0x6d, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x4e, 0x6a, 0x75, 0x6d,
0x61, 0x74, 0x61, 0x6e, 0x61, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69, 0x74, 0x68, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61,
0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x74, 0x68, 0x69, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e,
0x3b, 0x41, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x72, 0x65, 0x3b, 0x4b, 0x75, 0x6e, 0x3b, 0x4f, 0x6e, 0x67, 0x3b, 0x49,
0x6e, 0x65, 0x3b, 0x49, 0x6c, 0x65, 0x3b, 0x53, 0x61, 0x70, 0x3b, 0x4b, 0x77, 0x65, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f,
0x74, 0x20, 0x65, 0x65, 0x20, 0x61, 0x72, 0x65, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x6b,
0x75, 0x6e, 0x69, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x6f, 0x6e, 0x67, 0x27, 0x77, 0x61,
0x6e, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x69, 0x6e, 0x65, 0x74, 0x3b, 0x4d, 0x64, 0x65,
0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x69, 0x6c, 0x65, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65,
0x20, 0x73, 0x61, 0x70, 0x61, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x6b, 0x77, 0x65, 0x3b,
0x41, 0x3b, 0x4b, 0x3b, 0x4f, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x44, 0x69, 0x6d, 0x3b, 0x50, 0x6f,
0x73, 0x3b, 0x50, 0x69, 0x72, 0x3b, 0x54, 0x61, 0x74, 0x3b, 0x4e, 0x61, 0x69, 0x3b, 0x53, 0x68, 0x61, 0x3b, 0x53, 0x61,
0x62, 0x3b, 0x44, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x43, 0x68, 0x69, 0x70, 0x6f, 0x73, 0x69, 0x3b, 0x43, 0x68,
0x69, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x69,
0x3b, 0x43, 0x68, 0x69, 0x73, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x53, 0x61, 0x62, 0x75, 0x64, 0x75, 0x3b, 0x44, 0x3b, 0x50,
0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x4e, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x76, 0x75, 0x3b, 0x53,
0x69, 0x62, 0x3b, 0x53, 0x69, 0x74, 0x3b, 0x53, 0x69, 0x6e, 0x3b, 0x53, 0x69, 0x68, 0x3b, 0x4d, 0x67, 0x71, 0x3b, 0x53,
0x6f, 0x6e, 0x74, 0x6f, 0x3b, 0x4d, 0x76, 0x75, 0x6c, 0x6f, 0x3b, 0x53, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x53, 0x69,
0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x53, 0x69, 0x6e, 0x65, 0x3b, 0x53, 0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b,
0x4d, 0x67, 0x71, 0x69, 0x62, 0x65, 0x6c, 0x6f, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53,
0x3b, 0x4d, 0x3b, 0x49, 0x6a, 0x70, 0x3b, 0x49, 0x6a, 0x74, 0x3b, 0x49, 0x6a, 0x6e, 0x3b, 0x49, 0x6a, 0x74, 0x3b, 0x41,
0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x49, 0x6a, 0x6d, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x69,
0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b,
0x49, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49,
0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x32, 0x3b, 0x33, 0x3b,
0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x31, 0x3b, 0x61, 0x73, 0x69, 0x3b, 0x61, 0x79, 0x6e, 0x3b, 0x61, 0x73,
0x69, 0x3b, 0x61, 0x6b, 0x1e5b, 0x3b, 0x61, 0x6b, 0x77, 0x3b, 0x61, 0x73, 0x69, 0x6d, 0x3b, 0x41, 0x73, 0x69, 0x1e0d, 0x3b,
0x61, 0x73, 0x61, 0x6d, 0x61, 0x73, 0x3b, 0x61, 0x79, 0x6e, 0x61, 0x73, 0x3b, 0x61, 0x73, 0x69, 0x6e, 0x61, 0x73, 0x3b,
0x61, 0x6b, 0x1e5b, 0x61, 0x73, 0x3b, 0x61, 0x6b, 0x77, 0x61, 0x73, 0x3b, 0x61, 0x73, 0x69, 0x6d, 0x77, 0x61, 0x73, 0x3b,
0x61, 0x73, 0x69, 0x1e0d, 0x79, 0x61, 0x73, 0x3b, 0x2d30, 0x2d59, 0x2d30, 0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x3b,
0x2d30, 0x2d3d, 0x2d55, 0x3b, 0x2d30, 0x2d3d, 0x2d61, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4e, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x3b, 0x2d30, 0x2d59,
0x2d30, 0x2d4e, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d,
0x2d55, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d59, 0x2d49, 0x2d4e, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49,
0x2d39, 0x2d62, 0x2d30, 0x2d59, 0x3b, 0x59, 0x61, 0x6e, 0x3b, 0x53, 0x61, 0x6e, 0x3b, 0x4b, 0x72, 0x61, 0x1e0d, 0x3b, 0x4b, 0x75,
0x1e93, 0x3b, 0x53, 0x61, 0x6d, 0x3b, 0x53, 0x1e0d, 0x69, 0x73, 0x3b, 0x53, 0x61, 0x79, 0x3b, 0x59, 0x61, 0x6e, 0x61, 0x73,
0x73, 0x3b, 0x53, 0x61, 0x6e, 0x61, 0x73, 0x73, 0x3b, 0x4b, 0x72, 0x61, 0x1e0d, 0x61, 0x73, 0x73, 0x3b, 0x4b, 0x75, 0x1e93,
0x61, 0x73, 0x73, 0x3b, 0x53, 0x61, 0x6d, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x1e0d, 0x69, 0x73, 0x61, 0x73, 0x73, 0x3b, 0x53,
0x61, 0x79, 0x61, 0x73, 0x73, 0x3b, 0x59, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b,
0x53, 0x41, 0x4e, 0x3b, 0x4f, 0x52, 0x4b, 0x3b, 0x4f, 0x4b, 0x42, 0x3b, 0x4f, 0x4b, 0x53, 0x3b, 0x4f, 0x4b, 0x4e, 0x3b,
0x4f, 0x4b, 0x54, 0x3b, 0x4f, 0x4d, 0x4b, 0x3b, 0x53, 0x61, 0x6e, 0x64, 0x65, 0x3b, 0x4f, 0x72, 0x77, 0x6f, 0x6b, 0x75,
0x62, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4f, 0x72, 0x77,
0x61, 0x6b, 0x61, 0x73, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4f, 0x72,
0x77, 0x61, 0x6b, 0x61, 0x74, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67,
0x61, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x52, 0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x4d, 0x75, 0x6c, 0x3b,
0x56, 0x69, 0x6c, 0x3b, 0x48, 0x69, 0x76, 0x3b, 0x48, 0x69, 0x64, 0x3b, 0x48, 0x69, 0x74, 0x3b, 0x48, 0x69, 0x68, 0x3b,
0x4c, 0x65, 0x6d, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x73, 0x68,
0x61, 0x68, 0x75, 0x76, 0x69, 0x6c, 0x75, 0x68, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x76, 0x69, 0x6c, 0x69, 0x3b,
0x70, 0x61, 0x20, 0x68, 0x69, 0x64, 0x61, 0x74, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x74, 0x61, 0x79, 0x69, 0x3b,
0x70, 0x61, 0x20, 0x68, 0x69, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x73, 0x68, 0x61, 0x68, 0x75, 0x6c, 0x65,
0x6d, 0x62, 0x65, 0x6c, 0x61, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x48, 0x3b, 0x48, 0x3b, 0x48, 0x3b, 0x57, 0x3b, 0x4a, 0x3b,
0x4a, 0x70, 0x69, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b,
0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x79, 0x69, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x74, 0x61, 0x6e, 0x75, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b,
0x49, 0x3b, 0x4a, 0x3b, 0x6b, 0x61, 0x72, 0x3b, 0x6e, 0x74, 0x25b, 0x3b, 0x74, 0x61, 0x72, 0x3b, 0x61, 0x72, 0x61, 0x3b,
0x61, 0x6c, 0x61, 0x3b, 0x6a, 0x75, 0x6d, 0x3b, 0x73, 0x69, 0x62, 0x3b, 0x6b, 0x61, 0x72, 0x69, 0x3b, 0x6e, 0x74, 0x25b,
0x6e, 0x25b, 0x3b, 0x74, 0x61, 0x72, 0x61, 0x74, 0x61, 0x3b, 0x61, 0x72, 0x61, 0x62, 0x61, 0x3b, 0x61, 0x6c, 0x61, 0x6d,
0x69, 0x73, 0x61, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x73, 0x69, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b,
0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x4b, 0x6d, 0x61, 0x3b, 0x54, 0x61, 0x74, 0x3b, 0x49, 0x6e,
0x65, 0x3b, 0x54, 0x61, 0x6e, 0x3b, 0x41, 0x72, 0x6d, 0x3b, 0x4d, 0x61, 0x61, 0x3b, 0x4e, 0x4d, 0x4d, 0x3b, 0x4b, 0x69,
0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61,
0x69, 0x6e, 0x65, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69, 0x74,
0x68, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4e, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x74, 0x68, 0x69,
0x69, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x13c6, 0x13cd, 0x13ac, 0x3b,
0x13c9, 0x13c5, 0x13af, 0x3b, 0x13d4, 0x13b5, 0x13c1, 0x3b, 0x13e6, 0x13a2, 0x13c1, 0x3b, 0x13c5, 0x13a9, 0x13c1, 0x3b, 0x13e7, 0x13be, 0x13a9, 0x3b,
0x13c8, 0x13d5, 0x13be, 0x3b, 0x13a4, 0x13be, 0x13d9, 0x13d3, 0x13c6, 0x13cd, 0x13ac, 0x3b, 0x13a4, 0x13be, 0x13d9, 0x13d3, 0x13c9, 0x13c5, 0x13af, 0x3b,
0x13d4, 0x13b5, 0x13c1, 0x13a2, 0x13a6, 0x3b, 0x13e6, 0x13a2, 0x13c1, 0x13a2, 0x13a6, 0x3b, 0x13c5, 0x13a9, 0x13c1, 0x13a2, 0x13a6, 0x3b, 0x13e7, 0x13be,
0x13a9, 0x13b6, 0x13cd, 0x13d7, 0x3b, 0x13a4, 0x13be, 0x13d9, 0x13d3, 0x13c8, 0x13d5, 0x13be, 0x3b, 0x13c6, 0x3b, 0x13c9, 0x3b, 0x13d4, 0x3b, 0x13e6,
0x3b, 0x13c5, 0x3b, 0x13e7, 0x3b, 0x13a4, 0x3b, 0x64, 0x69, 0x6d, 0x3b, 0x6c, 0x69, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d,
0x65, 0x72, 0x3b, 0x7a, 0x65, 0x3b, 0x76, 0x61, 0x6e, 0x3b, 0x73, 0x61, 0x6d, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x6e, 0x73,
0x3b, 0x6c, 0x69, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x65, 0x72, 0x6b, 0x72, 0x65, 0x64,
0x69, 0x3b, 0x7a, 0x65, 0x64, 0x69, 0x3b, 0x76, 0x61, 0x6e, 0x64, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x73, 0x61, 0x6d, 0x64,
0x69, 0x3b, 0x64, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x7a, 0x3b, 0x76, 0x3b, 0x73, 0x3b, 0x4c, 0x6c, 0x32, 0x3b,
0x4c, 0x6c, 0x33, 0x3b, 0x4c, 0x6c, 0x34, 0x3b, 0x4c, 0x6c, 0x35, 0x3b, 0x4c, 0x6c, 0x36, 0x3b, 0x4c, 0x6c, 0x37, 0x3b,
0x4c, 0x6c, 0x31, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x70, 0x69, 0x6c, 0x69, 0x3b, 0x4c,
0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61,
0x20, 0x6c, 0x79, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x63, 0x68, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c,
0x79, 0x61, 0x6e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e,
0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x6c, 0x69, 0x6e, 0x6a, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76,
0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x76, 0x69, 0x6c,
0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x69, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x3b, 0x50, 0xed, 0x69,
0x6c, 0x69, 0x3b, 0x54, 0xe1, 0x61, 0x74, 0x75, 0x3b, 0xcd, 0x6e, 0x65, 0x3b, 0x54, 0xe1, 0x61, 0x6e, 0x6f, 0x3b, 0x41,
0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x6d, 0x3b, 0x4d, 0xf3, 0x6f, 0x73, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0xed, 0x69,
0x72, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0xed, 0x6e, 0x65, 0x3b,
0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x61, 0x6d, 0xed, 0x69, 0x73, 0x69, 0x3b, 0x49,
0x6a, 0x75, 0x6d, 0xe1, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0xf3, 0x6f, 0x73, 0x69, 0x3b, 0x50, 0x3b, 0x54, 0x3b,
0x45, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4d, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x42, 0x61, 0x6c, 0x3b, 0x4c, 0x77,
0x32, 0x3b, 0x4c, 0x77, 0x33, 0x3b, 0x4c, 0x77, 0x34, 0x3b, 0x4c, 0x77, 0x35, 0x3b, 0x4c, 0x77, 0x36, 0x3b, 0x53, 0x61,
0x62, 0x62, 0x69, 0x69, 0x74, 0x69, 0x3b, 0x42, 0x61, 0x6c, 0x61, 0x7a, 0x61, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x62,
0x69, 0x72, 0x69, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x73, 0x61, 0x74, 0x75, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x6e,
0x61, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x74, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x4c, 0x77, 0x61, 0x6d, 0x75, 0x6b, 0x61,
0x61, 0x67, 0x61, 0x3b, 0x53, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x50, 0x61,
0x20, 0x4d, 0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x6d, 0x6f, 0x3b, 0x50,
0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x62, 0x75, 0x6c, 0x69, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x74, 0x61,
0x74, 0x75, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69,
0x73, 0x61, 0x6e, 0x6f, 0x3b, 0x50, 0x61, 0x63, 0x68, 0x69, 0x62, 0x65, 0x6c, 0x75, 0x73, 0x68, 0x69, 0x3b, 0x64, 0x75,
0x6d, 0x3b, 0x73, 0x69, 0x67, 0x3b, 0x74, 0x65, 0x72, 0x3b, 0x6b, 0x75, 0x61, 0x3b, 0x6b, 0x69, 0x6e, 0x3b, 0x73, 0x65,
0x73, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64, 0x75, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x73, 0x69, 0x67, 0x75, 0x6e, 0x64,
0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x74, 0x65, 0x72, 0x73, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x6b, 0x75,
0x61, 0x72, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x6b, 0x69, 0x6e, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61,
0x3b, 0x73, 0x65, 0x73, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x64, 0x75, 0x3b, 0x64,
0x3b, 0x73, 0x3b, 0x74, 0x3b, 0x6b, 0x3b, 0x6b, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x4b, 0x49, 0x55, 0x3b, 0x4d, 0x52, 0x41,
0x3b, 0x57, 0x41, 0x49, 0x3b, 0x57, 0x45, 0x54, 0x3b, 0x57, 0x45, 0x4e, 0x3b, 0x57, 0x54, 0x4e, 0x3b, 0x4a, 0x55, 0x4d,
0x3b, 0x4b, 0x69, 0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4d, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x6f, 0x3b, 0x57, 0x61, 0x69,
0x72, 0x69, 0x3b, 0x57, 0x65, 0x74, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x57, 0x65, 0x6e, 0x61, 0x3b, 0x57, 0x65, 0x74, 0x61,
0x6e, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x57, 0x3b, 0x57, 0x3b,
0x57, 0x3b, 0x57, 0x3b, 0x4a, 0x3b, 0x54, 0x69, 0x73, 0x3b, 0x54, 0x61, 0x69, 0x3b, 0x41, 0x65, 0x6e, 0x3b, 0x53, 0x6f,
0x6d, 0x3b, 0x41, 0x6e, 0x67, 0x3b, 0x4d, 0x75, 0x74, 0x3b, 0x4c, 0x6f, 0x68, 0x3b, 0x42, 0x65, 0x74, 0x75, 0x74, 0x61,
0x62, 0x20, 0x74, 0x69, 0x73, 0x61, 0x70, 0x3b, 0x42, 0x65, 0x74, 0x75, 0x74, 0x20, 0x6e, 0x65, 0x74, 0x61, 0x69, 0x3b,
0x42, 0x65, 0x74, 0x75, 0x74, 0x61, 0x62, 0x20, 0x61, 0x65, 0x6e, 0x67, 0x27, 0x3b, 0x42, 0x65, 0x74, 0x75, 0x74, 0x61,
0x62, 0x20, 0x73, 0x6f, 0x6d, 0x6f, 0x6b, 0x3b, 0x42, 0x65, 0x74, 0x75, 0x74, 0x61, 0x62, 0x20, 0x61, 0x6e, 0x67, 0x27,
0x77, 0x61, 0x6e, 0x3b, 0x42, 0x65, 0x74, 0x75, 0x74, 0x61, 0x62, 0x20, 0x6d, 0x75, 0x74, 0x3b, 0x42, 0x65, 0x74, 0x75,
0x74, 0x61, 0x62, 0x20, 0x6c, 0x6f, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4c,
0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0x61, 0x3b, 0x44, 0x65, 0x3b, 0x57, 0x75, 0x3b, 0x44, 0x6f, 0x3b, 0x46, 0x72, 0x3b,
0x53, 0x61, 0x74, 0x3b, 0x53, 0x6f, 0x6e, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x6e, 0x74,
0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x44, 0x65, 0x6e, 0x73, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73,
0x3b, 0x57, 0x75, 0x6e, 0x73, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x44, 0x6f, 0x6e, 0x64, 0x65, 0x72,
0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x46, 0x72, 0x61, 0x69, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65,
0x73, 0x3b, 0x53, 0x61, 0x74, 0x65, 0x72, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x53, 0x3b, 0x4d, 0x3b,
0x45, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x46, 0x3b, 0x41, 0x3b, 0x53, 0x75, 0x2e, 0x3b, 0x4d, 0x6f, 0x2e, 0x3b, 0x44, 0x69,
0x2e, 0x3b, 0x4d, 0x65, 0x2e, 0x3b, 0x44, 0x75, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x53, 0x75,
0x6e, 0x6e, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4d, 0x6f, 0x6f, 0x6e, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x44, 0x69,
0x6e, 0x6e, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4d, 0x65, 0x74, 0x77, 0x6f, 0x63, 0x68, 0x3b, 0x44, 0x75, 0x6e,
0x6e, 0x65, 0x72, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x46, 0x72, 0x69, 0x69, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b,
0x53, 0x61, 0x6d, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0xed, 0x6c, 0xed, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x74, 0xe1, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74,
0xe1, 0x6e, 0x254, 0x3b, 0x41, 0x6c, 0x61, 0xe1, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0xe1, 0x61, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x6d, 0xf3, 0x73, 0x69, 0x3b, 0x53, 0x61, 0x62, 0x69, 0x3b, 0x42, 0x61, 0x6c, 0x61, 0x3b, 0x4b, 0x75,
0x62, 0x69, 0x3b, 0x4b, 0x75, 0x73, 0x61, 0x3b, 0x4b, 0x75, 0x6e, 0x61, 0x3b, 0x4b, 0x75, 0x74, 0x61, 0x3b, 0x4d, 0x75,
0x6b, 0x61, 0x3b, 0x53, 0x61, 0x62, 0x69, 0x69, 0x74, 0x69, 0x3b, 0x42, 0x61, 0x6c, 0x61, 0x7a, 0x61, 0x3b, 0x4f, 0x77,
0x6f, 0x6b, 0x75, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4f, 0x77, 0x6f, 0x6b, 0x75, 0x73, 0x61, 0x74, 0x75, 0x3b, 0x4f, 0x6c,
0x6f, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x4f, 0x6c, 0x6f, 0x6b, 0x75, 0x74, 0x61, 0x61, 0x6e, 0x75, 0x3b, 0x4f, 0x6c, 0x6f,
0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b, 0x53, 0x3b, 0x42, 0x3b, 0x42, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b,
0x4d, 0x3b, 0x4a, 0x32, 0x3b, 0x4a, 0x33, 0x3b, 0x4a, 0x34, 0x3b, 0x4a, 0x35, 0x3b, 0x41, 0x6c, 0x3b, 0x49, 0x6a, 0x3b,
0x4a, 0x31, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x75,
0x72, 0x77, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4d, 0x75, 0x72, 0x77, 0x61, 0x20, 0x77,
0x61, 0x20, 0x4b, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x4a, 0x70,
0x69, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a,
0x6d, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x42, 0x61, 0x72, 0x3b, 0x41, 0x61, 0x72, 0x3b, 0x55, 0x6e,
0x69, 0x3b, 0x55, 0x6e, 0x67, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x65, 0x6a,
0x75, 0x6d, 0x61, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x65, 0x62, 0x61, 0x72, 0x61, 0x73, 0x61, 0x3b, 0x4e, 0x61, 0x6b, 0x61,
0x61, 0x72, 0x65, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x75, 0x6e, 0x69, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x75, 0x6e, 0x67, 0x27,
0x6f, 0x6e, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x6b, 0x61, 0x6e, 0x79, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x73, 0x61, 0x62, 0x69,
0x74, 0x69, 0x3b, 0x4a, 0x3b, 0x42, 0x3b, 0x41, 0x3b, 0x55, 0x3b, 0x55, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x4e, 0x61, 0x62,
0x3b, 0x53, 0x61, 0x6e, 0x3b, 0x53, 0x61, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x3b, 0x43, 0x61, 0x6d, 0x3b, 0x4a, 0x75, 0x6d,
0x3b, 0x51, 0x75, 0x6e, 0x3b, 0x4e, 0x61, 0x62, 0x61, 0x20, 0x53, 0x61, 0x6d, 0x62, 0x61, 0x74, 0x3b, 0x53, 0x61, 0x6e,
0x69, 0x3b, 0x53, 0x61, 0x6c, 0x75, 0x73, 0x3b, 0x52, 0x61, 0x62, 0x75, 0x71, 0x3b, 0x43, 0x61, 0x6d, 0x75, 0x73, 0x3b,
0x4a, 0x75, 0x6d, 0x71, 0x61, 0x74, 0x61, 0x3b, 0x51, 0x75, 0x6e, 0x78, 0x61, 0x20, 0x53, 0x61, 0x6d, 0x62, 0x61, 0x74,
0x3b, 0x4e, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x43, 0x3b, 0x4a, 0x3b, 0x51, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x41,
0x74, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41,
0x73, 0x73, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x6c,
0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x61,
0x3b, 0x41, 0x6c, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x73, 0x61, 0x62, 0x64, 0x75, 0x3b, 0x48, 0x3b, 0x54, 0x3b,
0x54, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x53, 0x3b, 0x4a, 0x4d, 0x50, 0x3b, 0x57, 0x55, 0x54, 0x3b, 0x54, 0x41,
0x52, 0x3b, 0x54, 0x41, 0x44, 0x3b, 0x54, 0x41, 0x4e, 0x3b, 0x54, 0x41, 0x42, 0x3b, 0x4e, 0x47, 0x53, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x70, 0x69, 0x6c, 0x3b, 0x57, 0x75, 0x6f, 0x6b, 0x20, 0x54, 0x69, 0x63, 0x68, 0x3b, 0x54, 0x69, 0x63, 0x68,
0x20, 0x41, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20, 0x41, 0x64, 0x65, 0x6b, 0x3b, 0x54, 0x69, 0x63,
0x68, 0x20, 0x41, 0x6e, 0x67, 0x27, 0x77, 0x65, 0x6e, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20, 0x41, 0x62, 0x69, 0x63, 0x68,
0x3b, 0x4e, 0x67, 0x65, 0x73, 0x6f, 0x3b, 0x4a, 0x3b, 0x57, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4e,
0x3b, 0x41, 0x73, 0x61, 0x3b, 0x41, 0x79, 0x6e, 0x3b, 0x41, 0x73, 0x6e, 0x3b, 0x41, 0x6b, 0x72, 0x3b, 0x41, 0x6b, 0x77,
0x3b, 0x41, 0x73, 0x6d, 0x3b, 0x41, 0x73, 0x1e0d, 0x3b, 0x41, 0x73, 0x61, 0x6d, 0x61, 0x73, 0x3b, 0x41, 0x79, 0x6e, 0x61,
0x73, 0x3b, 0x41, 0x73, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x41, 0x6b, 0x72, 0x61, 0x73, 0x3b, 0x41, 0x6b, 0x77, 0x61, 0x73,
0x3b, 0x41, 0x73, 0x69, 0x6d, 0x77, 0x61, 0x73, 0x3b, 0x41, 0x73, 0x69, 0x1e0d, 0x79, 0x61, 0x73, 0x3b, 0x41, 0x3b, 0x41,
0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x41, 0x74, 0x69, 0x3b, 0x41,
0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x6d, 0x3b, 0x41, 0x6c, 0x7a, 0x3b, 0x41, 0x73, 0x69, 0x3b, 0x41,
0x6c, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x6e, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x6c, 0x61, 0x61, 0x74,
0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x61, 0x3b, 0x41,
0x6c, 0x7a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x69, 0x62, 0x74, 0x69, 0x3b, 0x4a, 0x70, 0x69, 0x3b, 0x4a, 0x74, 0x74,
0x3b, 0x4a, 0x6d, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x70, 0x69, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b,
0x4a, 0x75, 0x6d, 0x61, 0x61, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c,
0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x6d,
0x6f, 0x73, 0x69, 0x3b, 0x930, 0x92c, 0x93f, 0x3b, 0x938, 0x92e, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x3b, 0x92c, 0x941, 0x926, 0x3b,
0x92c, 0x93f, 0x938, 0x925, 0x93f, 0x3b, 0x938, 0x941, 0x916, 0x941, 0x930, 0x3b, 0x938, 0x941, 0x928, 0x93f, 0x3b, 0x930, 0x92c, 0x93f,
0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x941,
0x926, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x93f, 0x938, 0x925, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x941, 0x916, 0x941, 0x930, 0x92c,
0x93e, 0x930, 0x3b, 0x938, 0x941, 0x928, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x930, 0x3b, 0x938, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941,
0x3b, 0x92c, 0x93f, 0x3b, 0x938, 0x941, 0x3b, 0x938, 0x941, 0x3b, 0x6e, 0x74, 0x73, 0x3b, 0x6b, 0x70, 0x61, 0x3b, 0x67, 0x68,
0x254, 0x3b, 0x74, 0x254, 0x6d, 0x3b, 0x75, 0x6d, 0x65, 0x3b, 0x67, 0x68, 0x268, 0x3b, 0x64, 0x7a, 0x6b, 0x3b, 0x74, 0x73,
0x75, 0x294, 0x6e, 0x74, 0x73, 0x268, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x6b, 0x70, 0xe0, 0x3b, 0x74, 0x73, 0x75, 0x294,
0x75, 0x67, 0x68, 0x254, 0x65, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x74, 0x254, 0x300, 0x6d, 0x6c, 0xf2, 0x3b, 0x74, 0x73,
0x75, 0x294, 0x75, 0x6d, 0xe8, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x67, 0x68, 0x268, 0x302, 0x6d, 0x3b, 0x74, 0x73, 0x75,
0x294, 0x6e, 0x64, 0x7a, 0x268, 0x6b, 0x254, 0x294, 0x254, 0x3b, 0x6e, 0x3b, 0x6b, 0x3b, 0x67, 0x3b, 0x74, 0x3b, 0x75, 0x3b,
0x67, 0x3b, 0x64, 0x3b, 0x6e, 0x254, 0x79, 0x3b, 0x6e, 0x6a, 0x61, 0x3b, 0x75, 0x75, 0x6d, 0x3b, 0x14b, 0x67, 0x65, 0x3b,
0x6d, 0x62, 0x254, 0x3b, 0x6b, 0x254, 0x254, 0x3b, 0x6a, 0x6f, 0x6e, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6e, 0x254, 0x302,
0x79, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6e, 0x6a, 0x61, 0x14b, 0x67, 0x75, 0x6d, 0x62, 0x61, 0x3b, 0x14b, 0x67, 0x77,
0xe0, 0x20, 0xfb, 0x6d, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x14b, 0x67, 0xea, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6d,
0x62, 0x254, 0x6b, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6b, 0x254, 0x254, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6a, 0xf4,
0x6e, 0x3b, 0x6e, 0x3b, 0x6e, 0x3b, 0x75, 0x3b, 0x14b, 0x3b, 0x6d, 0x3b, 0x6b, 0x3b, 0x6a, 0x3b, 0x41, 0x6c, 0x68, 0x3b,
0x41, 0x74, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b,
0x41, 0x73, 0x69, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x6e, 0x69, 0x3b, 0x41, 0x74,
0x61, 0x6c, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61,
0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x73, 0x69, 0x62, 0x74, 0x69, 0x3b, 0xe9, 0x74, 0x3b, 0x6d, 0x254,
0x301, 0x73, 0x3b, 0x6b, 0x77, 0x61, 0x3b, 0x6d, 0x75, 0x6b, 0x3b, 0x14b, 0x67, 0x69, 0x3b, 0x257, 0xf3, 0x6e, 0x3b, 0x65,
0x73, 0x61, 0x3b, 0xe9, 0x74, 0x69, 0x3b, 0x6d, 0x254, 0x301, 0x73, 0xfa, 0x3b, 0x6b, 0x77, 0x61, 0x73, 0xfa, 0x3b, 0x6d,
0x75, 0x6b, 0x254, 0x301, 0x73, 0xfa, 0x3b, 0x14b, 0x67, 0x69, 0x73, 0xfa, 0x3b, 0x257, 0xf3, 0x6e, 0x25b, 0x73, 0xfa, 0x3b,
0x65, 0x73, 0x61, 0x253, 0x61, 0x73, 0xfa, 0x3b, 0x65, 0x3b, 0x6d, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x14b, 0x3b, 0x257, 0x3b,
0x65, 0x3b, 0x44, 0x69, 0x6d, 0x3b, 0x54, 0x65, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x72,
0x61, 0x3b, 0x41, 0x72, 0x6a, 0x3b, 0x53, 0x69, 0x62, 0x3b, 0x44, 0x69, 0x6d, 0x61, 0x73, 0x3b, 0x54, 0x65, 0x6e, 0x65,
0x14b, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x79, 0x3b, 0x41, 0x72, 0x61,
0x6d, 0x69, 0x73, 0x61, 0x79, 0x3b, 0x41, 0x72, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x53, 0x69, 0x62, 0x69, 0x74, 0x69, 0x3b,
0x44, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6d,
0x254, 0x301, 0x6e, 0x3b, 0x73, 0x6d, 0x62, 0x3b, 0x73, 0x6d, 0x6c, 0x3b, 0x73, 0x6d, 0x6e, 0x3b, 0x66, 0xfa, 0x6c, 0x3b,
0x73, 0xe9, 0x72, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0x73, 0x254,
0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x1dd, 0x6c, 0xfa, 0x20, 0x6d, 0x1dd, 0x301, 0x62, 0x25b, 0x30c, 0x3b, 0x73, 0x254, 0x301,
0x6e, 0x64, 0x254, 0x20, 0x6d, 0x1dd, 0x6c, 0xfa, 0x20, 0x6d, 0x1dd, 0x301, 0x6c, 0x25b, 0x301, 0x3b, 0x73, 0x254, 0x301, 0x6e,
0x64, 0x254, 0x20, 0x6d, 0x1dd, 0x6c, 0xfa, 0x20, 0x6d, 0x1dd, 0x301, 0x6e, 0x79, 0x69, 0x3b, 0x66, 0xfa, 0x6c, 0x61, 0x64,
0xe9, 0x3b, 0x73, 0xe9, 0x72, 0x61, 0x64, 0xe9, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x66,
0x3b, 0x73, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6c, 0x1dd, 0x6e, 0x3b, 0x6d, 0x61, 0x61, 0x3b, 0x6d, 0x25b, 0x6b, 0x3b,
0x6a, 0x1dd, 0x1dd, 0x3b, 0x6a, 0xfa, 0x6d, 0x3b, 0x73, 0x61, 0x6d, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x1dd, 0x3b, 0x6c,
0x1dd, 0x6e, 0x64, 0xed, 0x3b, 0x6d, 0x61, 0x61, 0x64, 0xed, 0x3b, 0x6d, 0x25b, 0x6b, 0x72, 0x25b, 0x64, 0xed, 0x3b, 0x6a,
0x1dd, 0x1dd, 0x64, 0xed, 0x3b, 0x6a, 0xfa, 0x6d, 0x62, 0xe1, 0x3b, 0x73, 0x61, 0x6d, 0x64, 0xed, 0x3b, 0x73, 0x3b, 0x6c,
0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x6a, 0x3b, 0x73, 0x3b, 0x4c, 0x75, 0x6d, 0x3b, 0x4e, 0x6b, 0x6f, 0x3b, 0x4e,
0x64, 0x79, 0x3b, 0x4e, 0x64, 0x67, 0x3b, 0x4e, 0x6a, 0x77, 0x3b, 0x4e, 0x67, 0x76, 0x3b, 0x4c, 0x75, 0x62, 0x3b, 0x4c,
0x75, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x4e, 0x6b, 0x6f, 0x64, 0x79, 0x61, 0x3b, 0x4e, 0x64, 0xe0, 0x61, 0x79, 0xe0,
0x3b, 0x4e, 0x64, 0x61, 0x6e, 0x67, 0xf9, 0x3b, 0x4e, 0x6a, 0xf2, 0x77, 0x61, 0x3b, 0x4e, 0x67, 0xf2, 0x76, 0x79, 0x61,
0x3b, 0x4c, 0x75, 0x62, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x4c, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e,
0x3b, 0x4c, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41,
0x72, 0x61, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x53, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74,
0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x53, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b,
0x49, 0x3b, 0x4a, 0x3b, 0x43, 0x79, 0x61, 0x3b, 0x43, 0x6c, 0x61, 0x3b, 0x43, 0x7a, 0x69, 0x3b, 0x43, 0x6b, 0x6f, 0x3b,
0x43, 0x6b, 0x61, 0x3b, 0x43, 0x67, 0x61, 0x3b, 0x43, 0x7a, 0x65, 0x3b, 0x43, 0x6f, 0x6d, 0x27, 0x79, 0x61, 0x6b, 0x6b,
0x65, 0x3b, 0x43, 0x6f, 0x6d, 0x6c, 0x61, 0x61, 0x257, 0x69, 0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x7a, 0x79, 0x69, 0x69, 0x257,
0x69, 0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x6b, 0x6f, 0x6c, 0x6c, 0x65, 0x3b, 0x43, 0x6f, 0x6d, 0x6b, 0x61, 0x6c, 0x64, 0x1dd,
0x253, 0x6c, 0x69, 0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x67, 0x61, 0x69, 0x73, 0x75, 0x75, 0x3b, 0x43, 0x6f, 0x6d, 0x7a, 0x79,
0x65, 0x253, 0x73, 0x75, 0x75, 0x3b, 0x59, 0x3b, 0x4c, 0x3b, 0x5a, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x47, 0x3b, 0x45, 0x3b,
0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x3b, 0x73, 0x6d, 0x62, 0x3b, 0x73, 0x6d, 0x6c, 0x3b, 0x73, 0x6d,
0x6e, 0x3b, 0x6d, 0x62, 0x73, 0x3b, 0x73, 0x61, 0x73, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x3b, 0x6d, 0x254, 0x301,
0x6e, 0x64, 0x254, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x62, 0x61,
0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x6c, 0x61, 0x6c, 0x3b, 0x73,
0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x6e, 0x61, 0x3b, 0x6d, 0x61, 0x62, 0xe1,
0x67, 0xe1, 0x20, 0x6d, 0xe1, 0x20, 0x73, 0x75, 0x6b, 0x75, 0x6c, 0x3b, 0x73, 0xe1, 0x73, 0x61, 0x64, 0x69, 0x3b, 0x73,
0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x43, 0xe4, 0x14b, 0x3b, 0x4a, 0x69, 0x65,
0x63, 0x3b, 0x52, 0x25b, 0x77, 0x3b, 0x44, 0x69, 0x254, 0x331, 0x6b, 0x3b, 0x14a, 0x75, 0x61, 0x61, 0x6e, 0x3b, 0x44, 0x68,
0x69, 0x65, 0x65, 0x63, 0x3b, 0x42, 0xe4, 0x6b, 0x25b, 0x6c, 0x3b, 0x43, 0xe4, 0x14b, 0x20, 0x6b, 0x75, 0x254, 0x74, 0x68,
0x3b, 0x4a, 0x69, 0x65, 0x63, 0x20, 0x6c, 0x61, 0x331, 0x74, 0x3b, 0x52, 0x25b, 0x77, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69,
0x3b, 0x44, 0x69, 0x254, 0x331, 0x6b, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x14a, 0x75, 0x61, 0x61, 0x6e, 0x20, 0x6c,
0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x44, 0x68, 0x69, 0x65, 0x65, 0x63, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x42, 0xe4,
0x6b, 0x25b, 0x6c, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x43, 0x3b, 0x4a, 0x3b, 0x52, 0x3b, 0x44, 0x3b, 0x14a, 0x3b,
0x44, 0x3b, 0x42, 0x3b, 0x411, 0x441, 0x3b, 0x411, 0x43d, 0x3b, 0x41e, 0x43f, 0x3b, 0x421, 0x44d, 0x3b, 0x427, 0x43f, 0x3b, 0x411,
0x44d, 0x3b, 0x421, 0x431, 0x3b, 0x411, 0x430, 0x441, 0x43a, 0x44b, 0x4bb, 0x44b, 0x430, 0x43d, 0x43d, 0x44c, 0x430, 0x3b, 0x411, 0x44d,
0x43d, 0x438, 0x434, 0x438, 0x44d, 0x43b, 0x438, 0x43d, 0x43d, 0x44c, 0x438, 0x43a, 0x3b, 0x41e, 0x43f, 0x442, 0x443, 0x43e, 0x440, 0x443,
0x43d, 0x43d, 0x44c, 0x443, 0x43a, 0x3b, 0x421, 0x44d, 0x440, 0x44d, 0x434, 0x44d, 0x3b, 0x427, 0x44d, 0x43f, 0x43f, 0x438, 0x44d, 0x440,
0x3b, 0x411, 0x44d, 0x44d, 0x442, 0x438, 0x4a5, 0x441, 0x44d, 0x3b, 0x421, 0x443, 0x431, 0x443, 0x43e, 0x442, 0x430, 0x3b, 0x411, 0x3b,
0x411, 0x3b, 0x41e, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x411, 0x3b, 0x421, 0x3b, 0x4d, 0x75, 0x6c, 0x3b, 0x4a, 0x74, 0x74, 0x3b,
0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b,
0x4d, 0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d,
0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x61, 0x68, 0x61, 0x6d,
0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b,
0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x3b, 0x79, 0x65, 0x6e, 0x3b, 0x6b, 0x77,
0x61, 0x3b, 0x70, 0x69, 0x6c, 0x3b, 0x74, 0x61, 0x74, 0x3b, 0x69, 0x6e, 0x65, 0x3b, 0x74, 0x61, 0x6e, 0x3b, 0x73, 0x69,
0x74, 0x3b, 0x73, 0x69, 0x6b, 0x75, 0x20, 0x79, 0x61, 0x20, 0x79, 0x65, 0x6e, 0x67, 0x61, 0x3b, 0x73, 0x69, 0x6b, 0x75,
0x20, 0x79, 0x61, 0x20, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x73, 0x69, 0x6b, 0x75, 0x20, 0x79, 0x61, 0x20, 0x70,
0x69, 0x6c, 0x69, 0x3b, 0x73, 0x69, 0x6b, 0x75, 0x20, 0x79, 0x61, 0x20, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x73, 0x69, 0x6b,
0x75, 0x20, 0x79, 0x61, 0x20, 0x69, 0x6e, 0x65, 0x3b, 0x73, 0x69, 0x6b, 0x75, 0x20, 0x79, 0x61, 0x20, 0x74, 0x61, 0x6e,
0x75, 0x3b, 0x73, 0x69, 0x6b, 0x75, 0x20, 0x79, 0x61, 0x20, 0x73, 0x69, 0x74, 0x61, 0x3b, 0x79, 0x3b, 0x6b, 0x3b, 0x70,
0x3b, 0x74, 0x3b, 0x69, 0x3b, 0x74, 0x3b, 0x73, 0x3b, 0xa55e, 0xa54c, 0xa535, 0x3b, 0xa5f3, 0xa5e1, 0xa609, 0x3b, 0xa55a, 0xa55e, 0xa55a,
0x3b, 0xa549, 0xa55e, 0xa552, 0x3b, 0xa549, 0xa524, 0xa546, 0xa562, 0x3b, 0xa549, 0xa524, 0xa540, 0xa56e, 0x3b, 0xa53b, 0xa52c, 0xa533, 0x3b, 0x6c,
0x61, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x74, 0x25b, 0x25b, 0x6e, 0x25b, 0x25b, 0x3b, 0x74, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b,
0x61, 0x6c, 0x61, 0x62, 0x61, 0x3b, 0x61, 0x69, 0x6d, 0x69, 0x73, 0x61, 0x3b, 0x61, 0x69, 0x6a, 0x69, 0x6d, 0x61, 0x3b,
0x73, 0x69, 0x253, 0x69, 0x74, 0x69, 0x3b, 0x53, 0x75, 0x6e, 0x3b, 0x4d, 0xe4, 0x6e, 0x3b, 0x5a, 0x69, 0x161, 0x3b, 0x4d,
0x69, 0x74, 0x3b, 0x46, 0x72, 0xf3, 0x3b, 0x46, 0x72, 0x69, 0x3b, 0x53, 0x61, 0x6d, 0x3b, 0x53, 0x75, 0x6e, 0x6e, 0x74,
0x61, 0x67, 0x3b, 0x4d, 0xe4, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x5a, 0x69, 0x161, 0x74, 0x61, 0x67, 0x3b, 0x4d, 0x69, 0x74,
0x74, 0x77, 0x75, 0x10d, 0x3b, 0x46, 0x72, 0xf3, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x46, 0x72, 0x69, 0x74, 0x61, 0x67, 0x3b,
0x53, 0x61, 0x6d, 0x161, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0x4d, 0x3b, 0x46, 0x3b, 0x46, 0x3b,
0x53, 0x3b, 0x73, 0x64, 0x3b, 0x6d, 0x64, 0x3b, 0x6d, 0x77, 0x3b, 0x65, 0x74, 0x3b, 0x6b, 0x6c, 0x3b, 0x66, 0x6c, 0x3b,
0x73, 0x73, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x25b, 0x3b, 0x6d, 0xf3, 0x6e, 0x64, 0x69, 0x65, 0x3b, 0x6d, 0x75,
0xe1, 0x6e, 0x79, 0xe1, 0x14b, 0x6d, 0xf3, 0x6e, 0x64, 0x69, 0x65, 0x3b, 0x6d, 0x65, 0x74, 0xfa, 0x6b, 0x70, 0xed, 0xe1,
0x70, 0x25b, 0x3b, 0x6b, 0xfa, 0x70, 0xe9, 0x6c, 0x69, 0x6d, 0x65, 0x74, 0xfa, 0x6b, 0x70, 0x69, 0x61, 0x70, 0x25b, 0x3b,
0x66, 0x65, 0x6c, 0xe9, 0x74, 0x65, 0x3b, 0x73, 0xe9, 0x73, 0x65, 0x6c, 0xe9, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b,
0x65, 0x3b, 0x6b, 0x3b, 0x66, 0x3b, 0x73, 0x3b
};

static const ushort am_data[] = {
0x41, 0x4d, 0x57, 0x44, 0x76, 0x6d, 0x2e, 0x50, 0x44, 0x1321, 0x12cb, 0x1275, 0x635, 0x531, 0x57c, 0x2024, 0x9aa, 0x9c2, 0x9f0, 0x9cd,
0x9ac, 0x9be, 0x9b9, 0x9cd, 0x9a3, 0x9aa, 0x9c2, 0x9b0, 0x9cd, 0x9ac, 0x9be, 0x9b9, 0x9cd, 0x9a3, 0x43f, 0x440, 0x2e, 0x20, 0x43e, 0x431,
0x2e, 0x1014, 0x1036, 0x1014, 0x1000, 0x103a, 0x434, 0x430, 0x20, 0x43f, 0x430, 0x43b, 0x443, 0x434, 0x43d, 0x44f, 0x1796, 0x17d2, 0x179a, 0x17b9,
0x1780, 0x61, 0x2e, 0x6d, 0x2e, 0x4e0a, 0x5348, 0x70, 0x72, 0x69, 0x6a, 0x65, 0x20, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x64, 0x6f,
0x70, 0x2e, 0x66, 0x2e, 0x6d, 0x2e, 0xd801, 0xdc08, 0xd801, 0xdc23, 0x65, 0x6e, 0x6e, 0x65, 0x20, 0x6b, 0x65, 0x73, 0x6b, 0x70,
0xe4, 0x65, 0x76, 0x61, 0x61, 0x70, 0x2e, 0x76, 0x6f, 0x72, 0x6d, 0x2e, 0x3c0, 0x2e, 0x3bc, 0x2e, 0xaaa, 0xac2, 0xab0, 0xacd,
0xab5, 0x20, 0xaae, 0xaa7, 0xacd, 0xaaf, 0xabe, 0xab9, 0xacd, 0xaa8, 0x5dc, 0x5e4, 0x5e0, 0x5d4, 0x5f4, 0x5e6, 0x92a, 0x942, 0x930, 0x94d,
0x935, 0x93e, 0x939, 0x94d, 0x928, 0x64, 0x65, 0x2e, 0x66, 0x2e, 0x68, 0x2e, 0x70, 0x61, 0x67, 0x69, 0x6d, 0x2e, 0x5348, 0x524d,
0xc624, 0xc804, 0x5a, 0x2e, 0x4d, 0x55, 0x2e, 0x70, 0x72, 0x69, 0x65, 0x6b, 0x161, 0x70, 0x75, 0x73, 0x64, 0x69, 0x65, 0x6e,
0x101, 0x6e, 0x74, 0x254, 0x301, 0x6e, 0x67, 0x254, 0x301, 0x70, 0x72, 0x69, 0x65, 0x161, 0x70, 0x69, 0x65, 0x74, 0x43f, 0x440,
0x435, 0x442, 0x43f, 0x43b, 0x430, 0x434, 0x43d, 0x435, 0x50, 0x47, 0xd30, 0xd3e, 0xd35, 0xd3f, 0xd32, 0xd46, 0x51, 0x4e, 0x92e, 0x2e,
0x92a, 0x942, 0x2e, 0x92a, 0x942, 0x930, 0x94d, 0x935, 0x20, 0x92e, 0x927, 0x94d, 0x92f, 0x93e, 0x928, 0x94d, 0x939, 0x61, 0x6d, 0x63a,
0x2e, 0x645, 0x2e, 0x642, 0x628, 0x644, 0x200c, 0x627, 0x632, 0x638, 0x647, 0x631, 0xa2a, 0xa42, 0xa30, 0xa35, 0x20, 0xa26, 0xa41, 0xa2a,
0xa39, 0xa3f, 0xa30, 0x434, 0x43e, 0x20, 0x43f, 0x43e, 0x43b, 0x443, 0x434, 0x43d, 0x44f, 0x4e, 0x44, 0x43f, 0x440, 0x435, 0x20, 0x43f,
0x43e, 0x434, 0x43d, 0x435, 0x70, 0x72, 0x65, 0x20, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0xdb4, 0xdd9, 0x2e, 0xdc0, 0x2e, 0x64, 0x6f,
0x70, 0x6f, 0x6c, 0x75, 0x64, 0x6e, 0x69, 0x61, 0x73, 0x6e, 0x2e, 0x61, 0x73, 0x75, 0x62, 0x75, 0x68, 0x69, 0x66, 0x6d,
0xbae, 0xbc1, 0xbb1, 0xbcd, 0xbaa, 0xb95, 0xbb2, 0xbcd, 0xc2a, 0xc42, 0xc30, 0xc4d, 0xc35, 0xc3e, 0xc39, 0xc4d, 0xc28, 0xc02, 0xe01, 0xe48,
0xe2d, 0xe19, 0xe40, 0xe17, 0xe35, 0xe48, 0xe22, 0xe07, 0xf66, 0xf94, 0xf0b, 0xf51, 0xfb2, 0xf7c, 0xf0b, 0x1295, 0x1309, 0x1206, 0x20, 0x1230,
0x12d3, 0x1270, 0x434, 0x43f, 0x62f, 0x646, 0x53, 0x41, 0xc0, 0xe1, 0x72, 0x1ecd, 0x300, 0x66, 0x6f, 0x72, 0x6d, 0x69, 0x64, 0x64,
0x61, 0x67, 0x41, 0x4e, 0x41, 0x2e, 0x4d, 0x2e, 0x128, 0x79, 0x61, 0x6b, 0x77, 0x61, 0x6b, 0x79, 0x61, 0x14b, 0x64, 0x69,
0xa3b8, 0xa111, 0x4d, 0x61, 0x2f, 0x4d, 0x6f, 0x4c, 0x75, 0x6d, 0x61, 0x20, 0x6c, 0x77, 0x61, 0x20, 0x4b, 0x73, 0x75, 0x62,
0x61, 0x6b, 0x61, 0x4b, 0x69, 0x72, 0x6f, 0x6b, 0x6f, 0x54, 0x65, 0x73, 0x69, 0x72, 0x61, 0x6e, 0x6b, 0x61, 0x6e, 0x67,
0x27, 0x61, 0x6d, 0x61, 0x74, 0x69, 0x66, 0x61, 0x77, 0x74, 0x2d5c, 0x2d49, 0x2d3c, 0x2d30, 0x2d61, 0x2d5c, 0x6e, 0x20, 0x74, 0x75,
0x66, 0x61, 0x74, 0x70, 0x61, 0x6d, 0x69, 0x6c, 0x61, 0x75, 0x75, 0x74, 0x75, 0x6b, 0x6f, 0x4b, 0x49, 0x13cc, 0x13be, 0x13b4,
0x4d, 0x75, 0x68, 0x69, 0x54, 0x4f, 0x4f, 0x75, 0x6c, 0x75, 0x63, 0x68, 0x65, 0x6c, 0x6f, 0x52, 0x168, 0x42, 0x65, 0x65,
0x74, 0x1c1, 0x67, 0x6f, 0x61, 0x67, 0x61, 0x73, 0x190, 0x6e, 0x6b, 0x61, 0x6b, 0x25b, 0x6e, 0x79, 0xe1, 0x4d, 0x75, 0x6e,
0x6b, 0x79, 0x6f, 0x69, 0x63, 0x68, 0x65, 0x68, 0x65, 0x61, 0x76, 0x6f, 0x54, 0x61, 0x70, 0x61, 0x72, 0x61, 0x63, 0x68,
0x75, 0x41, 0x64, 0x64, 0x75, 0x68, 0x61, 0x4f, 0x44, 0x5a, 0x64, 0x61, 0x74, 0x20, 0x61, 0x7a, 0x61, 0x6c, 0x6d, 0x61,
0x6b, 0x65, 0x6f, 0x92b, 0x941, 0x902, 0x61, 0x2e, 0x67, 0x49, 0x20, 0x62, 0x69, 0x6b, 0x25b, 0x302, 0x67, 0x6c, 0xe0, 0x53,
0x75, 0x62, 0x62, 0x61, 0x61, 0x68, 0x69, 0x69, 0x64, 0x69, 0x253, 0x61, 0x6b, 0xed, 0x6b, 0xed, 0x72, 0xed, 0x67, 0x73,
0xe1, 0x72, 0xfa, 0x77, 0xe1, 0x44, 0x69, 0x6e, 0x64, 0x61, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6d, 0x61, 0x6e, 0xe1, 0x52,
0x57, 0x4c, 0x77, 0x61, 0x6d, 0x69, 0x6c, 0x61, 0x77, 0x75, 0x79, 0x61, 0x20, 0x61, 0x73, 0x75, 0x62, 0x75, 0x79, 0x69,
0x6b, 0x69, 0x25b, 0x6d, 0x25b, 0x301, 0x25b, 0x6d
};

static const ushort pm_data[] = {
0x50, 0x4d, 0x57, 0x42, 0x6e, 0x6d, 0x2e, 0x4d, 0x44, 0x12a8, 0x1233, 0x12d3, 0x1275, 0x645, 0x53f, 0x565, 0x2024, 0x985, 0x9aa, 0x9f0,
0x9be, 0x9b9, 0x9cd, 0x9a3, 0x985, 0x9aa, 0x9b0, 0x9be, 0x9b9, 0x9cd, 0x9a3, 0x441, 0x43b, 0x2e, 0x20, 0x43e, 0x431, 0x2e, 0x100a, 0x1014,
0x1031, 0x43f, 0x430, 0x441, 0x43b, 0x44f, 0x20, 0x43f, 0x430, 0x43b, 0x443, 0x434, 0x43d, 0x44f, 0x179b, 0x17d2, 0x1784, 0x17b6, 0x1785, 0x70,
0x2e, 0x6d, 0x2e, 0x4e0b, 0x5348, 0x6f, 0x64, 0x70, 0x2e, 0x65, 0x2e, 0x6d, 0x2e, 0xd801, 0xdc11, 0xd801, 0xdc23, 0x70, 0xe4, 0x72,
0x61, 0x73, 0x74, 0x20, 0x6b, 0x65, 0x73, 0x6b, 0x70, 0xe4, 0x65, 0x76, 0x61, 0x69, 0x70, 0x2e, 0x6e, 0x61, 0x63, 0x68,
0x6d, 0x2e, 0x3bc, 0x2e, 0x3bc, 0x2e, 0xa89, 0xaa4, 0xacd, 0xaa4, 0xab0, 0x20, 0xaae, 0xaa7, 0xacd, 0xaaf, 0xabe, 0xab9, 0xacd, 0xaa8,
0x5d0, 0x5d7, 0x5d4, 0x5f4, 0x5e6, 0x905, 0x92a, 0x930, 0x93e, 0x939, 0x94d, 0x928, 0x64, 0x75, 0x2e, 0x65, 0x2e, 0x68, 0x2e, 0x6d,
0x61, 0x6c, 0x61, 0x6d, 0x70, 0x2e, 0x5348, 0x5f8c, 0xc624, 0xd6c4, 0x5a, 0x2e, 0x4d, 0x57, 0x2e, 0x70, 0x113, 0x63, 0x70, 0x75,
0x73, 0x64, 0x69, 0x65, 0x6e, 0x101, 0x6d, 0x70, 0xf3, 0x6b, 0x77, 0x61, 0x70, 0x6f, 0x70, 0x69, 0x65, 0x74, 0x43f, 0x43e,
0x43f, 0x43b, 0x430, 0x434, 0x43d, 0x435, 0x50, 0x54, 0x47, 0xd35, 0xd48, 0xd15, 0xd41, 0xd28, 0xd4d, 0xd28, 0xd47, 0xd30, 0xd02, 0x57,
0x4e, 0x92e, 0x2e, 0x928, 0x902, 0x2e, 0x909, 0x924, 0x94d, 0x924, 0x930, 0x20, 0x92e, 0x927, 0x94d, 0x92f, 0x93e, 0x928, 0x94d, 0x939,
0x70, 0x6d, 0x63a, 0x2e, 0x648, 0x2e, 0x628, 0x639, 0x62f, 0x627, 0x632, 0x638, 0x647, 0x631, 0xa2c, 0xa3e, 0xa05, 0xa26, 0x20, 0xa26,
0xa41, 0xa2a, 0xa39, 0xa3f, 0xa30, 0x73, 0x6d, 0x43f, 0x43e, 0x441, 0x43b, 0x435, 0x20, 0x43f, 0x43e, 0x43b, 0x443, 0x434, 0x43d, 0x44f,
0x4c, 0x4b, 0x43f, 0x43e, 0x43f, 0x43e, 0x434, 0x43d, 0x435, 0x70, 0x6f, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0xdb4, 0x2e, 0xdc0, 0x2e,
0x70, 0x6f, 0x70, 0x6f, 0x6c, 0x75, 0x64, 0x6e, 0xed, 0x70, 0x6f, 0x70, 0x2e, 0x67, 0x6e, 0x2e, 0x61, 0x6c, 0x61, 0x73,
0x69, 0x72, 0x69, 0x65, 0x6d, 0xbaa, 0xbbf, 0xbb1, 0xbcd, 0xbaa, 0xb95, 0xbb2, 0xbcd, 0xc05, 0xc2a, 0xc30, 0xc3e, 0xc39, 0xc4d, 0xc28,
0xc02, 0xe2b, 0xe25, 0xe31, 0xe07, 0xe40, 0xe17, 0xe35, 0xe48, 0xe22, 0xe07, 0xf55, 0xfb1, 0xf72, 0xf0b, 0xf51, 0xfb2, 0xf7c, 0xf0b, 0x12f5,
0x1215, 0x122d, 0x20, 0x1230, 0x12d3, 0x1275, 0x43f, 0x43f, 0x631, 0x627, 0x62a, 0x43, 0x48, 0x1ecc, 0x300, 0x73, 0xe1, 0x6e, 0x65, 0x74,
0x74, 0x65, 0x72, 0x6d, 0x69, 0x64, 0x64, 0x61, 0x67, 0x45, 0x57, 0x50, 0x2e, 0x4d, 0x2e, 0x128, 0x79, 0x61, 0x77, 0x129,
0x6f, 0x6f, 0x263, 0x65, 0x74, 0x72, 0x254, 0x6e, 0x61, 0x6d, 0x2e, 0xa06f, 0xa2d2, 0x4d, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x2f,
0x4d, 0x6f, 0x67, 0x6c, 0x75, 0x6d, 0x61, 0x20, 0x6c, 0x77, 0x61, 0x20, 0x70, 0x6b, 0x69, 0x6b, 0x69, 0x69, 0x257, 0x65,
0x48, 0x77, 0x61, 0x129, 0x2d, 0x69, 0x6e, 0x129, 0x54, 0x65, 0x69, 0x70, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x6f, 0x74, 0x6f,
0x74, 0x61, 0x64, 0x67, 0x67, 0x2b7, 0x61, 0x74, 0x2d5c, 0x2d30, 0x2d37, 0x2d33, 0x2d33, 0x2d6f, 0x2d30, 0x2d5c, 0x6e, 0x20, 0x74, 0x6d,
0x65, 0x64, 0x64, 0x69, 0x74, 0x70, 0x61, 0x6d, 0x75, 0x6e, 0x79, 0x69, 0x6b, 0x79, 0x69, 0x75, 0x6b, 0x6f, 0x6e, 0x79,
0x69, 0x55, 0x54, 0x13d2, 0x13af, 0x13f1, 0x13a2, 0x13d7, 0x13e2, 0x43, 0x68, 0x69, 0x6c, 0x6f, 0x4d, 0x55, 0x55, 0x61, 0x6b, 0x61,
0x73, 0x75, 0x62, 0x61, 0x168, 0x47, 0x4b, 0x65, 0x6d, 0x6f, 0x1c3, 0x75, 0x69, 0x61, 0x73, 0x190, 0x6e, 0x64, 0xe1, 0x6d,
0xe2, 0x45, 0x69, 0x67, 0x75, 0x6c, 0x6f, 0x69, 0x63, 0x68, 0x61, 0x6d, 0x74, 0x68, 0x69, 0x45, 0x62, 0x6f, 0x6e, 0x67,
0x69, 0x41, 0x6c, 0x75, 0x75, 0x6c, 0x61, 0x4f, 0x54, 0x1e0c, 0x65, 0x66, 0x66, 0x69, 0x72, 0x20, 0x61, 0x7a, 0x61, 0x6e,
0x79, 0x69, 0x61, 0x67, 0x68, 0x75, 0x6f, 0x92c, 0x947, 0x932, 0x93e, 0x938, 0x947, 0x61, 0x2e, 0x6b, 0x49, 0x20, 0x253, 0x75,
0x67, 0x61, 0x6a, 0x254, 0x70, 0x5a, 0x61, 0x61, 0x72, 0x69, 0x6b, 0x61, 0x79, 0x20, 0x62, 0x65, 0x62, 0x79, 0xe1, 0x6d,
0x75, 0x6e, 0x67, 0x1dd, 0x67, 0xf3, 0x67, 0x1dd, 0x6c, 0x65, 0x63, 0x25b, 0x25b, 0x301, 0x6e, 0x6b, 0x6f, 0x44, 0x69, 0x6c,
0x6f, 0x6c, 0x6f, 0x6c, 0x69, 0x6c, 0x6c, 0x69, 0x6b, 0x75, 0x67, 0xfa, 0x54, 0x14a, 0x50, 0x61, 0x73, 0x68, 0x61, 0x6d,
0x69, 0x68, 0x65, 0x79, 0x61, 0x20, 0x6d, 0x75, 0x63, 0x68, 0x61, 0x6e, 0x61, 0x6b, 0x69, 0x73, 0x25b, 0x301, 0x6e, 0x64,
0x25b
};

static const ushort currency_symbol_data[] = {
0x42, 0x72, 0x4b, 0x73, 0x68, 0x46, 0x64, 0x6a, 0x4e, 0x66, 0x6b, 0x52, 0x24, 0x4c, 0x65, 0x6b, 0x1265, 0x122d, 0x631, 0x2e,
0x633, 0x2e, 0x200f, 0x62f, 0x2e, 0x62c, 0x2e, 0x200f, 0x62f, 0x2e, 0x628, 0x2e, 0x200f, 0x62c, 0x2e, 0x645, 0x2e, 0x200f, 0x62f, 0x2e,
0x639, 0x2e, 0x200f, 0x62f, 0x2e, 0x623, 0x2e, 0x200f, 0x62f, 0x2e, 0x643, 0x2e, 0x200f, 0x644, 0x2e, 0x644, 0x2e, 0x200f, 0x62f, 0x2e,
0x644, 0x2e, 0x200f, 0x62f, 0x2e, 0x645, 0x2e, 0x200f, 0x631, 0x2e, 0x639, 0x2e, 0x200f, 0x631, 0x2e, 0x642, 0x2e, 0x200f, 0x644, 0x2e,
0x633, 0x2e, 0x200f, 0x62f, 0x2e, 0x62a, 0x2e, 0x200f, 0x62f, 0x2e, 0x625, 0x2e, 0x200f, 0x631, 0x2e, 0x64a, 0x2e, 0x200f, 0x564, 0x580,
0x2e, 0x99f, 0x995, 0x9be, 0x6d, 0x61, 0x6e, 0x2e, 0x43c, 0x430, 0x43d, 0x2e, 0x20ac, 0x9f3, 0x20b9, 0x4e, 0x75, 0x2e, 0x43b, 0x432,
0x2e, 0x4b, 0x17db, 0xffe5, 0x4e, 0x54, 0x24, 0x6b, 0x6e, 0x4b, 0x10d, 0x6b, 0x72, 0x41, 0x66, 0x6c, 0x2e, 0x50, 0x20a8, 0x20b1,
0xa3, 0x58, 0x4f, 0x46, 0x46, 0x42, 0x75, 0x58, 0x41, 0x46, 0x43, 0x46, 0x46, 0x72, 0x43, 0x44, 0x46, 0x47, 0x4d, 0x47,
0x41, 0x46, 0x52, 0x43, 0x48, 0x46, 0xab0, 0xac1, 0x43, 0x46, 0x41, 0x20a6, 0x20aa, 0x930, 0x941, 0x2e, 0x46, 0x74, 0x52, 0x70,
0x442, 0x4a3, 0x433, 0x2e, 0x52, 0x46, 0x441, 0x43e, 0x43c, 0x20a9, 0x54, 0x4c, 0x20ad, 0x4c, 0x73, 0x46, 0x43, 0x46, 0x41, 0x4c,
0x74, 0x52, 0x4d, 0xd30, 0xd42, 0x930, 0x941, 0x20ae, 0x43, 0x4e, 0xa5, 0x928, 0x947, 0x930, 0x942, 0x60b, 0xfdfc, 0x7a, 0x142, 0x4b,
0x7a, 0x52, 0x24, 0x4d, 0x54, 0x6e, 0x44, 0x62, 0xa30, 0xa41, 0x2e, 0x631, 0x4d, 0x44, 0x4c, 0x440, 0x443, 0x431, 0x2e, 0x20b4,
0x41a, 0x41c, 0x2e, 0x434, 0x438, 0x43d, 0x2e, 0x4b, 0x4d, 0x64, 0x69, 0x6e, 0x2e, 0x55, 0x53, 0x24, 0xdbb, 0xdd4, 0x2e, 0x45,
0x42, 0x73, 0x20a1, 0x51, 0x4c, 0x43, 0x24, 0x42, 0x2f, 0x2e, 0x20b2, 0x53, 0x2f, 0x2e, 0x42, 0x73, 0x2e, 0x46, 0x2e, 0x54,
0x53, 0x68, 0x52, 0x73, 0x2e, 0xc30, 0xc42, 0x2e, 0xe3f, 0x54, 0x24, 0x50, 0x4b, 0x52, 0x73, 0x441, 0x45e, 0x43c, 0x73, 0x6f,
0x2bc, 0x6d, 0x20ab, 0x44, 0x41, 0x55, 0x53, 0x68, 0x5a, 0x4b
};

static const ushort currency_display_name_data[] = {
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x74, 0x6f, 0x6f, 0x70, 0x68, 0x69, 0x79, 0x61, 0x61, 0x20, 0x42, 0x69,
0x72, 0x72, 0x69, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66, 0x72, 0x69,
0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61,
0x6d, 0x69, 0x62, 0x69, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x20, 0x1265, 0x122d, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x631, 0x64a, 0x627,
0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631,
0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a,
0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648,
0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b,
0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c,
0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f,
0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632,
0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a,
0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631,
0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646,
0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a,
0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647,
0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647,
0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647,
0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647,
0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a,
0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a,
0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a,
0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a,
0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62c, 0x646,
0x64a, 0x629, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x629, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646,
0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x629, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x629, 0x20, 0x644,
0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x629, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646,
0x64a, 0x629, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x629, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644,
0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631,
0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646,
0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f,
0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a,
0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631,
0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645,
0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644,
0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a,
0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b,
0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646,
0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637,
0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637,
0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637,
0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637,
0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x631, 0x64a,
0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x631, 0x64a,
0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x631, 0x64a,
0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x62a, 0x648, 0x646, 0x633,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x62a, 0x648,
0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631,
0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646,
0x627, 0x631, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a,
0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625,
0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b,
0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645,
0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x631,
0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631,
0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631,
0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631,
0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e, 0x20,
0x6d, 0x61, 0x6e, 0x61, 0x74, 0x131, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63,
0x61, 0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x74, 0x131, 0x3b, 0x43c, 0x430, 0x43d, 0x430, 0x442, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6,
0x9c7, 0x9b6, 0x9c0, 0x20, 0x99f, 0x9be, 0x995, 0x9be, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x9ad, 0x9be, 0x9b0, 0x9a4, 0x9c0,
0x9af, 0x9bc, 0x20, 0x9b0, 0x9c1, 0x9aa, 0x9bf, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xf51, 0xf44, 0xf74, 0xf63, 0xf0b, 0xf40,
0xfb2, 0xf58, 0xf0b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x411, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x20, 0x43b, 0x435, 0x432, 0x3b, 0x3b, 0x431, 0x44a, 0x43b, 0x433,
0x430, 0x440, 0x441, 0x43a, 0x438, 0x20, 0x43b, 0x435, 0x432, 0x3b, 0x3b, 0x3b, 0x3b, 0x431, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441,
0x43a, 0x438, 0x20, 0x43b, 0x435, 0x432, 0x430, 0x3b, 0x1019, 0x103c, 0x1014, 0x103a, 0x1019, 0x102c, 0x20, 0x1000, 0x103b, 0x1015, 0x103a, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x431, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x43a, 0x456, 0x20, 0x440, 0x443, 0x431, 0x435,
0x43b, 0x44c, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x69, 0x65, 0x6c, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x73, 0x3b,
0x4eba, 0x6c11, 0x5e01, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e2f, 0x5143, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6fb3,
0x9580, 0x5143, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65b0, 0x52a0, 0x5761, 0x5143, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x65b0, 0x81fa, 0x5e63, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6fb3, 0x95e8, 0x5143, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x6b, 0x75, 0x6e, 0x65, 0x3b, 0x6b, 0x75, 0x6e,
0x61, 0x3b, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xe1, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x61, 0x3b,
0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xe1, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xe9,
0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x79, 0x3b, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xfd, 0x63, 0x68, 0x20, 0x6b, 0x6f, 0x72,
0x75, 0x6e, 0x3b, 0x44, 0x61, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x44, 0x61, 0x6e, 0x73,
0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x61, 0x6e, 0x73, 0x6b, 0x65, 0x20, 0x6b, 0x72,
0x6f, 0x6e, 0x65, 0x72, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65,
0x75, 0x72, 0x6f, 0x3b, 0x41, 0x72, 0x75, 0x62, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x55, 0x53,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72,
0x73, 0x3b, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b,
0x3b, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b,
0x3b, 0x3b, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73,
0x3b, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x42,
0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x42,
0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x45, 0x75, 0x72,
0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x73, 0x3b, 0x42, 0x65, 0x6c,
0x69, 0x7a, 0x65, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65, 0x20, 0x64,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x73, 0x3b, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b,
0x3b, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b,
0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42, 0x6f, 0x74,
0x73, 0x77, 0x61, 0x6e, 0x61, 0x6e, 0x20, 0x50, 0x75, 0x6c, 0x61, 0x3b, 0x3b, 0x42, 0x6f, 0x74, 0x73, 0x77, 0x61, 0x6e,
0x61, 0x6e, 0x20, 0x70, 0x75, 0x6c, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x6f, 0x74, 0x73, 0x77, 0x61, 0x6e, 0x61, 0x6e,
0x20, 0x70, 0x75, 0x6c, 0x61, 0x73, 0x3b, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b,
0x3b, 0x3b, 0x3b, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b,
0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x65, 0x73, 0x65, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x47, 0x75,
0x79, 0x61, 0x6e, 0x61, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x75,
0x79, 0x61, 0x6e, 0x61, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x48, 0x6f, 0x6e, 0x67,
0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b,
0x6f, 0x6e, 0x67, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b,
0x6f, 0x6e, 0x67, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x52,
0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b,
0x3b, 0x3b, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x4a, 0x61, 0x6d, 0x61,
0x69, 0x63, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61,
0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x6e,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x52,
0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70, 0x65,
0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65,
0x73, 0x3b, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4e,
0x61, 0x6d, 0x69, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61,
0x6d, 0x69, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4e, 0x65, 0x77, 0x20, 0x5a,
0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4e, 0x65, 0x77, 0x20, 0x5a,
0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x65, 0x77,
0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x50, 0x61, 0x6b,
0x69, 0x73, 0x74, 0x61, 0x6e, 0x69, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x50, 0x61, 0x6b, 0x69, 0x73, 0x74,
0x61, 0x6e, 0x69, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x6b, 0x69, 0x73, 0x74, 0x61,
0x6e, 0x69, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x50, 0x65, 0x73, 0x6f, 0x3b, 0x3b, 0x50, 0x68, 0x69, 0x6c,
0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x70, 0x65, 0x73, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x68, 0x69, 0x6c, 0x69,
0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x3b, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x6f, 0x72,
0x65, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x6f, 0x72, 0x65, 0x20,
0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x6f, 0x72, 0x65, 0x20,
0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61,
0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61,
0x6e, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69,
0x63, 0x61, 0x6e, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x61, 0x6e,
0x64, 0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x54, 0x72, 0x69,
0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f, 0x20, 0x64, 0x6f, 0x6c,
0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x61, 0x6e, 0x64, 0x20,
0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42, 0x72, 0x69, 0x74, 0x69,
0x73, 0x68, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x53, 0x74, 0x65, 0x72, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x42,
0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x73, 0x74, 0x65, 0x72, 0x6c, 0x69, 0x6e,
0x67, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x20,
0x73, 0x74, 0x65, 0x72, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b,
0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x74, 0x3b, 0x64, 0x6f, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61,
0x3b, 0x3b, 0x64, 0x6f, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x6f, 0x6e,
0x73, 0x6b, 0x61, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x75, 0x72, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72,
0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x61, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41,
0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20,
0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x43, 0x46,
0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x62, 0x75, 0x72, 0x75,
0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x61,
0x69, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x61,
0x69, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b,
0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b,
0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x64,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x73, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63,
0x6f, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6d, 0x6f, 0x72,
0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x63, 0x6f, 0x6d, 0x6f, 0x72, 0x69,
0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x69, 0x73, 0x3b,
0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x3b, 0x3b,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x69, 0x73, 0x3b, 0x66, 0x72, 0x61,
0x6e, 0x63, 0x20, 0x64, 0x6a, 0x69, 0x62, 0x6f, 0x75, 0x74, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63,
0x20, 0x64, 0x6a, 0x69, 0x62, 0x6f, 0x75, 0x74, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63,
0x73, 0x20, 0x64, 0x6a, 0x69, 0x62, 0x6f, 0x75, 0x74, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20,
0x67, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x6e, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x67, 0x75, 0x69, 0x6e, 0xe9,
0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x67, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x6e,
0x73, 0x3b, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61, 0x63, 0x68, 0x65, 0x3b, 0x3b, 0x61,
0x72, 0x69, 0x61, 0x72, 0x79, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61, 0x63, 0x68, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x61, 0x72,
0x69, 0x61, 0x72, 0x79, 0x73, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61, 0x63, 0x68, 0x65, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x20, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x72, 0x77,
0x61, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x72, 0x77, 0x61,
0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x3b, 0x3b,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x73, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x73, 0x3b, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x20, 0x10da,
0x10d0, 0x10e0, 0x10d8, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f,
0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46,
0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e, 0x3b, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72,
0x61, 0x6e, 0x6b, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46,
0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e, 0x3b, 0x395, 0x3c5, 0x3c1, 0x3ce, 0x3b, 0x3b, 0x3b5, 0x3c5, 0x3c1, 0x3ce, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b5, 0x3c5, 0x3c1, 0x3ce, 0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x69, 0x6e, 0x75, 0x74, 0x20, 0x6b, 0x6f, 0x72, 0x75,
0x75, 0x6e, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xaad, 0xabe, 0xab0, 0xaa4, 0xac0, 0xaaf, 0x20, 0xab0, 0xac2, 0xaaa,
0xac0, 0xaaf, 0xabe, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4b, 0x75, 0x257, 0x69, 0x6e, 0x20, 0x53, 0x65, 0x66, 0x61,
0x20, 0x6e, 0x61, 0x20, 0x41, 0x66, 0x69, 0x72, 0x6b, 0x61, 0x20, 0x54, 0x61, 0x20, 0x59, 0x61, 0x6d, 0x6d, 0x61, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x69, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x5e9, 0x5f4,
0x5d7, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x5d9, 0x5dd, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x5d9, 0x5dd, 0x3b, 0x92d,
0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x942, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61,
0x67, 0x79, 0x61, 0x72, 0x20, 0x66, 0x6f, 0x72, 0x69, 0x6e, 0x74, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xcd, 0x73,
0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b, 0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b,
0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x75, 0x20, 0x6b,
0x72, 0xf3, 0x6e, 0x75, 0x72, 0x3b, 0x52, 0x75, 0x70, 0x69, 0x61, 0x68, 0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73,
0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x53, 0x76, 0x69, 0x7a,
0x7a, 0x65, 0x72, 0x6f, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72,
0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x69, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72,
0x69, 0x3b, 0x65e5, 0x672c, 0x5186, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xcad, 0xcbe, 0xcb0, 0xca4, 0xcc0, 0xcaf, 0x20, 0xcb0,
0xcc1, 0xcaa, 0xcbe, 0xcaf, 0xcbf, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49a, 0x430, 0x437, 0x430, 0x49b, 0x441, 0x442, 0x430,
0x43d, 0x20, 0x442, 0x435, 0x4a3, 0x433, 0x435, 0x441, 0x456, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xb300, 0xd55c, 0xbbfc, 0xad6d,
0x20, 0xc6d0, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x695, 0x6cc, 0x627, 0x6b5, 0x6cc, 0x20, 0x626, 0x6ce, 0x631, 0x627, 0x646,
0x6cc, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x62f, 0x6cc, 0x646, 0x627, 0x631, 0x6cc, 0x20, 0x639, 0x6ce, 0x631, 0x627, 0x642,
0x6cc, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x66, 0x61, 0x72, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x72, 0x79, 0x27,
0x55, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xe81, 0xeb5, 0xe9a, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4c, 0x61, 0x74, 0x76, 0x69, 0x6a, 0x61, 0x73, 0x20, 0x6c, 0x61, 0x74, 0x73, 0x3b, 0x4c,
0x61, 0x74, 0x76, 0x69, 0x6a, 0x61, 0x73, 0x20, 0x6c, 0x61, 0x74, 0x69, 0x3b, 0x4c, 0x61, 0x74, 0x76, 0x69, 0x6a, 0x61,
0x73, 0x20, 0x6c, 0x61, 0x74, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x4c, 0x61, 0x74, 0x76, 0x69, 0x6a, 0x61, 0x73, 0x20, 0x6c,
0x61, 0x74, 0x69, 0x3b, 0x46, 0x61, 0x6c, 0xe1, 0x6e, 0x67, 0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0xf3,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x61, 0x6c, 0xe1, 0x6e, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42,
0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4c, 0x69, 0x74, 0x61, 0x73, 0x3b, 0x3b, 0x4c, 0x69, 0x65,
0x74, 0x75, 0x76, 0x6f, 0x73, 0x20, 0x6c, 0x69, 0x74, 0x61, 0x73, 0x3b, 0x3b, 0x4c, 0x69, 0x65, 0x74, 0x75, 0x76, 0x6f,
0x73, 0x20, 0x6c, 0x69, 0x74, 0x61, 0x69, 0x3b, 0x3b, 0x4c, 0x69, 0x65, 0x74, 0x75, 0x76, 0x6f, 0x73, 0x20, 0x6c, 0x69,
0x74, 0x173, 0x3b, 0x41c, 0x430, 0x43a, 0x435, 0x434, 0x43e, 0x43d, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x435, 0x43d, 0x430, 0x440, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x72, 0x69, 0x61, 0x72, 0x79, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x52,
0x69, 0x6e, 0x67, 0x67, 0x69, 0x74, 0x20, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x44, 0x6f, 0x6c, 0x61, 0x72, 0x20, 0x42, 0x72, 0x75, 0x6e, 0x65, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0xd28, 0xd4d, 0x200d, 0x20, 0xd30, 0xd42, 0xd2a, 0x3b, 0x3b, 0xd07, 0xd28, 0xd4d, 0xd24,
0xd4d, 0xd2f, 0xd28, 0xd4d, 0x200d, 0x20, 0xd30, 0xd42, 0xd2a, 0x3b, 0x3b, 0x3b, 0x3b, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0xd28,
0xd4d, 0x200d, 0x20, 0xd30, 0xd42, 0xd2a, 0x3b, 0x45, 0x77, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e,
0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930,
0x924, 0x940, 0x92f, 0x20, 0x930, 0x942, 0x92a, 0x93f, 0x901, 0x92f, 0x93e, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20,
0x930, 0x942, 0x92a, 0x93f, 0x901, 0x92f, 0x93e, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x942,
0x92a, 0x93f, 0x901, 0x92f, 0x93e, 0x3b, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x65, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b,
0x3b, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x73,
0x6b, 0x65, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b, 0xb1f, 0xb19, 0xb15, 0xb3e, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cd, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x631, 0x6cc, 0x627, 0x644, 0x20, 0x627,
0x6cc, 0x631, 0x627, 0x646, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x20, 0x627, 0x641,
0x63a, 0x627, 0x646, 0x633, 0x62a, 0x627, 0x646, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x79, 0x20,
0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x3b, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x79, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69,
0x3b, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x65, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x65, 0x3b, 0x7a, 0x142, 0x6f, 0x74,
0x79, 0x63, 0x68, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x63, 0x68, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x65, 0x67, 0x6f,
0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x65, 0x67, 0x6f, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x45, 0x75, 0x72,
0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x73, 0x3b, 0x43, 0x75, 0x61, 0x6e, 0x7a, 0x61, 0x20, 0x61, 0x6e,
0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x4b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x20, 0x61, 0x6e, 0x67, 0x6f, 0x6c,
0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x4b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x73, 0x20, 0x61, 0x6e, 0x67, 0x6f, 0x6c,
0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x52, 0x65, 0x61, 0x6c, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0x69, 0x72, 0x6f,
0x3b, 0x3b, 0x52, 0x65, 0x61, 0x6c, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x3b, 0x3b,
0x3b, 0x52, 0x65, 0x61, 0x69, 0x73, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0x69, 0x72, 0x6f, 0x73, 0x3b, 0x46,
0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x46, 0x72, 0x61,
0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x64, 0x65, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b,
0x46, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x64, 0x65, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f,
0x3b, 0x4d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x64, 0x6f, 0x20, 0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x71,
0x75, 0x65, 0x3b, 0x3b, 0x4d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x64, 0x65, 0x20, 0x4d, 0x6f, 0xe7, 0x61, 0x6d,
0x62, 0x69, 0x71, 0x75, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x65, 0x73, 0x20, 0x64,
0x65, 0x20, 0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x71, 0x75, 0x65, 0x3b, 0x44, 0x6f, 0x62, 0x72, 0x61, 0x20, 0x64,
0x65, 0x20, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65, 0x20, 0x50, 0x72, 0xed, 0x6e, 0x63, 0x69, 0x70,
0x65, 0x3b, 0x3b, 0x44, 0x6f, 0x62, 0x72, 0x61, 0x20, 0x64, 0x65, 0x20, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9,
0x20, 0x65, 0x20, 0x50, 0x72, 0xed, 0x6e, 0x63, 0x69, 0x70, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x6f, 0x62, 0x72, 0x61,
0x73, 0x20, 0x64, 0x65, 0x20, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65, 0x20, 0x50, 0x72, 0xed, 0x6e,
0x63, 0x69, 0x70, 0x65, 0x3b, 0xa30, 0xa41, 0xa2a, 0xa3f, 0xa2f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x631, 0x648, 0x67e,
0x626, 0x6cc, 0x6c1, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x76, 0x69, 0x7a,
0x7a, 0x65, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76,
0x65, 0x6e, 0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65,
0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x219, 0x74, 0x69,
0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x6c,
0x65, 0x75, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x72, 0x6f, 0x6d,
0xe2, 0x6e, 0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x65, 0x219, 0x74, 0x69,
0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x420, 0x43e, 0x441, 0x441,
0x438, 0x439, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439,
0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a,
0x438, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x438, 0x445, 0x20,
0x440, 0x443, 0x431, 0x43b, 0x435, 0x439, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20, 0x440,
0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x41c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x43b, 0x435, 0x439, 0x3b,
0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x43b, 0x435, 0x439, 0x3b, 0x3b, 0x43c, 0x43e, 0x43b,
0x434, 0x430, 0x432, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x43b, 0x435, 0x44f, 0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a,
0x438, 0x445, 0x20, 0x43b, 0x435, 0x435, 0x432, 0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20,
0x43b, 0x435, 0x44f, 0x3b, 0x423, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x430, 0x44f, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d,
0x430, 0x3b, 0x3b, 0x443, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x430, 0x44f, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x430,
0x3b, 0x3b, 0x443, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x438, 0x435, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x44b, 0x3b,
0x443, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x433, 0x440, 0x438, 0x432, 0x435, 0x43d, 0x3b, 0x443, 0x43a,
0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x43e, 0x439, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x44b, 0x3b, 0x66, 0x61, 0x72, 0xe2,
0x6e, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x41a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20, 0x41c, 0x430, 0x440, 0x43a, 0x430,
0x3b, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430,
0x447, 0x43a, 0x430, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430,
0x440, 0x43a, 0x430, 0x3b, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433,
0x43e, 0x432, 0x430, 0x447, 0x43a, 0x435, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x435,
0x20, 0x43c, 0x430, 0x440, 0x43a, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435,
0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x438, 0x445, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x430, 0x431, 0x438, 0x43b,
0x43d, 0x438, 0x445, 0x20, 0x43c, 0x430, 0x440, 0x430, 0x43a, 0x430, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d,
0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x438, 0x445, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440,
0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x438, 0x445, 0x20, 0x43c, 0x430, 0x440, 0x430, 0x43a, 0x430, 0x3b, 0x45, 0x76, 0x72, 0x6f,
0x3b, 0x3b, 0x65, 0x76, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x76, 0x72, 0x61, 0x3b, 0x65, 0x76, 0x72, 0x61, 0x3b, 0x65, 0x76,
0x72, 0x61, 0x3b, 0x421, 0x440, 0x43f, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x438, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x441, 0x440, 0x43f,
0x441, 0x43a, 0x438, 0x20, 0x434, 0x438, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x441, 0x440, 0x43f, 0x441, 0x43a, 0x430, 0x20, 0x434, 0x438,
0x43d, 0x430, 0x440, 0x430, 0x3b, 0x441, 0x440, 0x43f, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x434, 0x438, 0x43d, 0x430, 0x440, 0x430, 0x3b,
0x441, 0x440, 0x43f, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x438, 0x43d, 0x430, 0x440, 0x438, 0x3b, 0x415, 0x432, 0x440, 0x43e, 0x3b, 0x3b,
0x435, 0x432, 0x440, 0x43e, 0x3b, 0x3b, 0x435, 0x432, 0x440, 0x430, 0x3b, 0x435, 0x432, 0x440, 0x430, 0x3b, 0x435, 0x432, 0x440, 0x430,
0x3b, 0x42, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x48, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d,
0x6b, 0x61, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72,
0x6b, 0x61, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f,
0x76, 0x61, 0x10d, 0x6b, 0x61, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20,
0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x42, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x48, 0x65, 0x72, 0x63,
0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x65, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c,
0x6e, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x3b, 0x42, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x48, 0x65,
0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x69, 0x68, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69,
0x62, 0x69, 0x6c, 0x6e, 0x69, 0x68, 0x20, 0x6d, 0x61, 0x72, 0x61, 0x6b, 0x61, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73,
0x6b, 0x6f, 0x2d, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x69, 0x68, 0x20, 0x6b, 0x6f, 0x6e,
0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x69, 0x68, 0x20, 0x6d, 0x61, 0x72, 0x61, 0x6b, 0x61, 0x3b, 0x53,
0x72, 0x70, 0x73, 0x6b, 0x69, 0x20, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x3b, 0x3b, 0x73, 0x72, 0x70, 0x73, 0x6b, 0x69, 0x20,
0x64, 0x69, 0x6e, 0x61, 0x72, 0x3b, 0x3b, 0x73, 0x72, 0x70, 0x73, 0x6b, 0x61, 0x20, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x61,
0x3b, 0x73, 0x72, 0x70, 0x73, 0x6b, 0x69, 0x68, 0x20, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x61, 0x3b, 0x73, 0x72, 0x70, 0x73,
0x6b, 0x69, 0x20, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x69, 0x3b, 0x44, 0x6f, 0x72, 0x61, 0x20, 0x72, 0x65, 0x20, 0x41, 0x6d,
0x65, 0x72, 0x69, 0x6b, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xdbd, 0xd82, 0xd9a, 0xdcf, 0x20, 0xdbb, 0xdd4, 0xdb4,
0xdd2, 0xdba, 0xdbd, 0xdca, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72,
0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0xe1, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x2c, 0x20, 0x65, 0x75, 0x72, 0x61, 0x3b, 0x65,
0x76, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x76, 0x72, 0x6f, 0x3b, 0x65, 0x76, 0x72, 0x61, 0x3b, 0x65, 0x76, 0x72, 0x69, 0x3b,
0x3b, 0x65, 0x76, 0x72, 0x6f, 0x76, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x20, 0x73, 0x6f, 0x6f, 0x6d, 0x61, 0x61,
0x6c, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x61, 0x72, 0x61, 0x6e, 0x20, 0x4a, 0x61, 0x62, 0x62, 0x75,
0x75, 0x74, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x69, 0x72, 0x74, 0x61, 0x20, 0x49, 0x74, 0x6f, 0x6f,
0x62, 0x62, 0x69, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x61, 0x72, 0x67,
0x65, 0x6e, 0x74, 0x69, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x61, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69,
0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x61, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e,
0x6f, 0x73, 0x3b, 0x62, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x62, 0x6f, 0x6c, 0x69, 0x76, 0x69,
0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x62, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x70, 0x65,
0x73, 0x6f, 0x20, 0x63, 0x68, 0x69, 0x6c, 0x65, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x68, 0x69,
0x6c, 0x65, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x63, 0x68, 0x69, 0x6c, 0x65, 0x6e,
0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b,
0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70,
0x65, 0x73, 0x6f, 0x73, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x63, 0x6f, 0x6c,
0xf3, 0x6e, 0x20, 0x63, 0x6f, 0x73, 0x74, 0x61, 0x72, 0x72, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x63, 0x6f,
0x6c, 0xf3, 0x6e, 0x20, 0x63, 0x6f, 0x73, 0x74, 0x61, 0x72, 0x72, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x3b,
0x3b, 0x63, 0x6f, 0x6c, 0x6f, 0x6e, 0x65, 0x73, 0x20, 0x63, 0x6f, 0x73, 0x74, 0x61, 0x72, 0x72, 0x69, 0x63, 0x65, 0x6e,
0x73, 0x65, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b,
0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b,
0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x64, 0xf3,
0x6c, 0x61, 0x72, 0x20, 0x65, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x75, 0x6e, 0x69, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b,
0x64, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x65, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x75, 0x6e, 0x69, 0x64, 0x65, 0x6e, 0x73, 0x65,
0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x65, 0x73, 0x20, 0x65, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x75, 0x6e,
0x69, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42,
0x45, 0x41, 0x43, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42, 0x45, 0x41, 0x43,
0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42, 0x45, 0x41, 0x43,
0x3b, 0x71, 0x75, 0x65, 0x74, 0x7a, 0x61, 0x6c, 0x20, 0x67, 0x75, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6c, 0x74, 0x65, 0x63,
0x6f, 0x3b, 0x3b, 0x71, 0x75, 0x65, 0x74, 0x7a, 0x61, 0x6c, 0x20, 0x67, 0x75, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6c, 0x74,
0x65, 0x63, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x71, 0x75, 0x65, 0x74, 0x7a, 0x61, 0x6c, 0x65, 0x73, 0x20, 0x67, 0x75, 0x61,
0x74, 0x65, 0x6d, 0x61, 0x6c, 0x74, 0x65, 0x63, 0x6f, 0x73, 0x3b, 0x6c, 0x65, 0x6d, 0x70, 0x69, 0x72, 0x61, 0x20, 0x68,
0x6f, 0x6e, 0x64, 0x75, 0x72, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x6c, 0x65, 0x6d, 0x70, 0x69, 0x72, 0x61, 0x20, 0x68, 0x6f,
0x6e, 0x64, 0x75, 0x72, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x6c, 0x65, 0x6d, 0x70, 0x69, 0x72, 0x61, 0x73, 0x20,
0x68, 0x6f, 0x6e, 0x64, 0x75, 0x72, 0x65, 0xf1, 0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x6d, 0x65, 0x78, 0x69,
0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x6d, 0x65, 0x78, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b,
0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x6d, 0x65, 0x78, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x63,
0xf3, 0x72, 0x64, 0x6f, 0x62, 0x61, 0x20, 0x6e, 0x69, 0x63, 0x61, 0x72, 0x61, 0x67, 0xfc, 0x65, 0x6e, 0x73, 0x65, 0x3b,
0x3b, 0x63, 0xf3, 0x72, 0x64, 0x6f, 0x62, 0x61, 0x20, 0x6e, 0x69, 0x63, 0x61, 0x72, 0x61, 0x67, 0xfc, 0x65, 0x6e, 0x73,
0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x63, 0xf3, 0x72, 0x64, 0x6f, 0x62, 0x61, 0x73, 0x20, 0x6e, 0x69, 0x63, 0x61, 0x72, 0x61,
0x67, 0xfc, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x3b, 0x62, 0x61, 0x6c, 0x62, 0x6f, 0x61, 0x20, 0x70, 0x61, 0x6e, 0x61, 0x6d,
0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x62, 0x61, 0x6c, 0x62, 0x6f, 0x61, 0x20, 0x70, 0x61, 0x6e, 0x61, 0x6d, 0x65, 0xf1, 0x6f,
0x3b, 0x3b, 0x3b, 0x3b, 0x62, 0x61, 0x6c, 0x62, 0x6f, 0x61, 0x73, 0x20, 0x70, 0x61, 0x6e, 0x61, 0x6d, 0x65, 0xf1, 0x6f,
0x73, 0x3b, 0x67, 0x75, 0x61, 0x72, 0x61, 0x6e, 0xed, 0x20, 0x70, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x3b,
0x3b, 0x67, 0x75, 0x61, 0x72, 0x61, 0x6e, 0xed, 0x20, 0x70, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x3b, 0x3b,
0x3b, 0x3b, 0x67, 0x75, 0x61, 0x72, 0x61, 0x6e, 0xed, 0x65, 0x73, 0x20, 0x70, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x79,
0x6f, 0x73, 0x3b, 0x6e, 0x75, 0x65, 0x76, 0x6f, 0x20, 0x73, 0x6f, 0x6c, 0x20, 0x70, 0x65, 0x72, 0x75, 0x61, 0x6e, 0x6f,
0x3b, 0x3b, 0x6e, 0x75, 0x65, 0x76, 0x6f, 0x20, 0x73, 0x6f, 0x6c, 0x20, 0x70, 0x65, 0x72, 0x75, 0x61, 0x6e, 0x6f, 0x3b,
0x3b, 0x3b, 0x3b, 0x6e, 0x75, 0x65, 0x76, 0x6f, 0x73, 0x20, 0x73, 0x6f, 0x6c, 0x65, 0x73, 0x20, 0x70, 0x65, 0x72, 0x75,
0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x75, 0x72, 0x75, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x3b, 0x3b,
0x70, 0x65, 0x73, 0x6f, 0x20, 0x75, 0x72, 0x75, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73,
0x6f, 0x73, 0x20, 0x75, 0x72, 0x75, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x73, 0x3b, 0x62, 0x6f, 0x6c, 0xed, 0x76, 0x61, 0x72,
0x20, 0x76, 0x65, 0x6e, 0x65, 0x7a, 0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x62, 0x6f, 0x6c, 0xed, 0x76, 0x61, 0x72,
0x20, 0x76, 0x65, 0x6e, 0x65, 0x7a, 0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x62, 0x6f, 0x6c, 0xed, 0x76,
0x61, 0x72, 0x65, 0x73, 0x20, 0x76, 0x65, 0x6e, 0x65, 0x7a, 0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x73, 0x68, 0x69,
0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69,
0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x61,
0x3b, 0x3b, 0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x76,
0x65, 0x6e, 0x73, 0x6b, 0x61, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x6f, 0x72, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65,
0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69,
0x6e, 0x65, 0x20, 0x50, 0x65, 0x73, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x421, 0x43e, 0x43c, 0x43e, 0x43d, 0x4e3,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0xb87, 0xbb2, 0xb99, 0xbcd, 0xb95, 0xbc8, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0xc30, 0xc42, 0xc2a, 0xc3e, 0xc2f, 0xc3f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xe1a, 0xe32, 0xe17, 0xe44, 0xe17, 0xe22, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xf61, 0xf74, 0xf0b, 0xf68, 0xf53, 0xf0b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xf62,
0xf92, 0xfb1, 0xf0b, 0xf42, 0xf62, 0xf0b, 0xf66, 0xf92, 0xf7c, 0xf62, 0xf0b, 0xf58, 0xf7c, 0xf0b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x54, 0xfc, 0x72, 0x6b, 0x20, 0x4c, 0x69, 0x72, 0x61, 0x73, 0x131, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x423,
0x43a, 0x440, 0x430, 0x457, 0x43d, 0x441, 0x44c, 0x43a, 0x430, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x44f, 0x3b, 0x3b, 0x433, 0x440,
0x438, 0x432, 0x43d, 0x44f, 0x3b, 0x3b, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x456, 0x3b, 0x433, 0x440, 0x438, 0x432, 0x435, 0x43d, 0x44c,
0x3b, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x456, 0x3b, 0x627, 0x646, 0x688, 0x6cc, 0x646, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x6c1, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x6c1,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x40e, 0x437, 0x431, 0x435, 0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d, 0x20, 0x441, 0x45e,
0x43c, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x4f, 0x2bc, 0x7a, 0x62, 0x65, 0x6b, 0x69, 0x73, 0x74, 0x6f, 0x6e, 0x20, 0x73, 0x6f, 0x2bc, 0x6d, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x110, 0x1ed3, 0x6e, 0x67, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x75, 0x6e, 0x74, 0x20,
0x53, 0x74, 0x65, 0x72, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x69, 0x72, 0x61, 0x20, 0x74, 0x69, 0x20, 0x4f, 0x72, 0xed, 0x6c, 0x1eb9, 0x301, 0xe8, 0x64,
0x65, 0x20, 0x4e, 0xe0, 0xec, 0x6a, 0xed, 0x72, 0xed, 0xe0, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x69, 0x2d, 0x53,
0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x6e, 0x6f, 0x72,
0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x65, 0x20, 0x6b,
0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b, 0x4e, 0x61, 0x1ecb, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69,
0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x41, 0x6d, 0x61, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x331, 0x6e, 0x61, 0x69, 0x72, 0x61, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x67, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x73, 0x69, 0x256, 0x69, 0x3b, 0x3b, 0x67, 0x68,
0x61, 0x6e, 0x61, 0x20, 0x73, 0x69, 0x256, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x67, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x73, 0x69,
0x256, 0x69, 0x3b, 0x53, 0x65, 0x66, 0x61, 0x3b, 0x3b, 0x263, 0x65, 0x74, 0x6f, 0x256, 0x6f, 0x66, 0x65, 0x20, 0x61, 0x66,
0x72, 0x69, 0x6b, 0x61, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x42, 0x43, 0x45,
0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x263, 0x65, 0x74, 0x6f, 0x256, 0x6f, 0x66, 0x65, 0x20, 0x61, 0x66, 0x72, 0x69, 0x6b,
0x61, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b,
0x4e, 0x65, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x69, 0x69, 0x7a, 0x65, 0x72,
0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x69, 0x69, 0x7a,
0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f,
0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61, 0x20,
0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x69, 0x6c, 0x61, 0x20, 0x54,
0x61, 0x69, 0x77, 0x61, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69,
0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x62, 0x75, 0x75,
0x257, 0x75, 0x20, 0x53, 0x65, 0x65, 0x66, 0x61, 0x61, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x43, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x6a, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x65, 0x65, 0x6c, 0x20, 0x4b, 0x65,
0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x64, 0x65,
0x20, 0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x71, 0x75, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x6f,
0x6c, 0x61, 0x20, 0x79, 0x61, 0x73, 0x65, 0x20, 0x41, 0x6d, 0x65, 0x6c, 0x69, 0x6b, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x68, 0x65, 0x6c, 0x65, 0x72, 0x69, 0x20, 0x73, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x61, 0x64, 0x72, 0x69, 0x6d, 0x20, 0x6e, 0x20, 0x6c, 0x6d, 0x263, 0x72, 0x69,
0x62, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x2d30, 0x2d37, 0x2d54, 0x2d49, 0x2d4e, 0x20, 0x2d4f, 0x20, 0x2d4d, 0x2d4e, 0x2d56, 0x2d54,
0x2d49, 0x2d31, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x41, 0x7a, 0x7a, 0x61,
0x79, 0x72, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x73, 0x68, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x69, 0x20,
0x79, 0x61, 0x20, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x68, 0x69, 0x6c,
0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x48, 0x75, 0x74, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e,
0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x65, 0x66, 0x61, 0x20, 0x46, 0x72, 0x61,
0x14b, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x13a4, 0x13c3, 0x13cd, 0x13d7,
0x3b, 0x3b, 0x13a4, 0x13c3, 0x13cd, 0x13d7, 0x3b, 0x3b, 0x3b, 0x3b, 0x13e7, 0x13c3, 0x13cd, 0x13d7, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69,
0x20, 0x6d, 0x6f, 0x72, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x68, 0x69, 0x6c,
0xed, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0xed, 0x61, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x65, 0x79, 0x61, 0x20, 0x59, 0x75, 0x67,
0x61, 0x6e, 0x64, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6b, 0x75, 0x64, 0x75, 0x20, 0x4b, 0x61, 0x62,
0x75, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x75, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6c, 0x69,
0x6e, 0x67, 0x69, 0x74, 0x61, 0x62, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x61, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x69, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x72, 0x6f, 0x70, 0x69,
0x79, 0x69, 0x61, 0x6e, 0xed, 0x20, 0x65, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x49, 0x72, 0x6f, 0x70, 0x69, 0x79, 0x69, 0x61, 0x6e, 0xed, 0x20, 0x65, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69,
0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x72, 0x69, 0x6e, 0x6a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b,
0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20,
0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x64, 0x68, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41,
0x6e, 0x67, 0x6f, 0x27, 0x6f, 0x74, 0x6f, 0x6c, 0x20, 0x6c, 0x6f, 0x6b, 0x27, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x6e, 0x67, 0x6f, 0x27, 0x6f, 0x74, 0x6f, 0x6c, 0x20, 0x6c, 0x6f, 0x6b, 0x27,
0x20, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x46, 0x41, 0x20, 0x46, 0x72,
0x61, 0x14b, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6c,
0x69, 0x6e, 0x67, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x44, 0x65, 0x72, 0x68, 0x65, 0x6d, 0x20, 0x55, 0x6d, 0x65, 0x1e5b, 0x1e5b, 0x75, 0x6b, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x930, 0x93e, 0x902, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x46, 0x41, 0x20, 0x46, 0xe0, 0x6c, 0xe2,
0x14b, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x72, 0x1ce, 0x14b, 0x20, 0x43, 0x46,
0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x65, 0x65, 0x66, 0x61,
0x20, 0x79, 0x61, 0x74, 0x69, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x1dd,
0x6c, 0xe1, 0x14b, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x66, 0x72, 0xe1, 0x14b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x66, 0x61, 0x6c, 0x61, 0x6e, 0x67, 0x61,
0x20, 0x77, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x75, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x6f, 0x6c, 0x61,
0x69, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x72, 0x61, 0x14b, 0x20, 0x43, 0x46,
0x41, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x68, 0x65, 0x6c, 0x61, 0x20, 0x79,
0x61, 0x20, 0x54, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0x69, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x61,
0x72, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0xa55e, 0xa524, 0xa52b, 0xa569, 0x20, 0xa55c, 0xa55e, 0xa54c, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4c, 0x61, 0x69, 0x62,
0x68, 0x69, 0x79, 0x61, 0x20, 0x44, 0x61, 0x6c, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b
};

static const ushort currency_format_data[] = {
0x25, 0x31, 0x25, 0x32, 0x25, 0x32, 0x25, 0x31, 0x25, 0x32, 0xa0, 0x25, 0x31, 0x28, 0x25, 0x32, 0x25, 0x31, 0x29, 0x25,
0x32, 0xa0, 0x25, 0x31, 0x2d, 0x25, 0x31, 0xa0, 0x25, 0x32, 0x28, 0x25, 0x31, 0x25, 0x32, 0x29, 0x25, 0x32, 0x2212, 0x25,
0x31, 0x28, 0x25, 0x31, 0xa0, 0x25, 0x32, 0x29, 0x25, 0x32, 0x2d, 0x25, 0x31, 0x2212, 0x25, 0x31, 0xa0, 0x25, 0x32, 0x25,
0x32, 0xa0, 0x2d, 0x25, 0x31, 0x28, 0x25, 0x32, 0xa0, 0x25, 0x31, 0x29, 0x2d, 0x25, 0x31, 0x25, 0x32, 0x25, 0x32, 0x2d,
0xa0, 0x25, 0x31
};
static const ushort endonyms_data[] = {
0x4f, 0x72, 0x6f, 0x6d, 0x6f, 0x6f, 0x49, 0x74, 0x6f, 0x6f, 0x70, 0x68, 0x69, 0x79, 0x61, 0x61, 0x4b, 0x65, 0x65, 0x6e,
0x69, 0x79, 0x61, 0x61, 0x51, 0x61, 0x66, 0x61, 0x72, 0x59, 0x61, 0x62, 0x75, 0x75, 0x74, 0x69, 0x45, 0x72, 0x65, 0x74,
0x72, 0x69, 0x61, 0x4f, 0x74, 0x6f, 0x62, 0x62, 0x69, 0x61, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x53,
0x75, 0x69, 0x64, 0x2d, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0xeb, 0x73, 0x68, 0x71,
0x69, 0x70, 0x65, 0x53, 0x68, 0x71, 0x69, 0x70, 0xeb, 0x72, 0x69, 0x61, 0x12a0, 0x121b, 0x122d, 0x129b, 0x12a2, 0x1275, 0x12ee, 0x1335,
0x12eb, 0x627, 0x644, 0x639, 0x631, 0x628, 0x64a, 0x629, 0x627, 0x644, 0x645, 0x645, 0x644, 0x643, 0x629, 0x20, 0x627, 0x644, 0x639, 0x631,
0x628, 0x64a, 0x629, 0x20, 0x627, 0x644, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x629, 0x627, 0x644, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x627,
0x644, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x645, 0x635, 0x631, 0x627, 0x644, 0x639, 0x631, 0x627, 0x642, 0x627, 0x644, 0x623, 0x631, 0x62f,
0x646, 0x627, 0x644, 0x643, 0x648, 0x64a, 0x62a, 0x644, 0x628, 0x646, 0x627, 0x646, 0x644, 0x64a, 0x628, 0x64a, 0x627, 0x627, 0x644, 0x645,
0x63a, 0x631, 0x628, 0x639, 0x64f, 0x645, 0x627, 0x646, 0x642, 0x637, 0x631, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x633, 0x648,
0x631, 0x64a, 0x627, 0x62a, 0x648, 0x646, 0x633, 0x627, 0x644, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x20, 0x627, 0x644, 0x639, 0x631,
0x628, 0x64a, 0x629, 0x20, 0x627, 0x644, 0x645, 0x62a, 0x62d, 0x62f, 0x629, 0x627, 0x644, 0x64a, 0x645, 0x646, 0x540, 0x561, 0x575, 0x565,
0x580, 0x567, 0x576, 0x540, 0x561, 0x575, 0x561, 0x57d, 0x57f, 0x561, 0x576, 0x56b, 0x20, 0x540, 0x561, 0x576, 0x580, 0x561, 0x57a, 0x565,
0x57f, 0x578, 0x582, 0x569, 0x56b, 0x582, 0x576, 0x985, 0x9b8, 0x9ae, 0x9c0, 0x9af, 0x9bc, 0x9be, 0x9ad, 0x9be, 0x9f0, 0x9a4, 0x61, 0x7a,
0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e, 0x63, 0x61, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e,
0x410, 0x437, 0x4d9, 0x440, 0x431, 0x430, 0x458, 0x4b9, 0x430, 0x43d, 0x65, 0x75, 0x73, 0x6b, 0x61, 0x72, 0x61, 0x45, 0x73, 0x70,
0x61, 0x69, 0x6e, 0x69, 0x61, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9ad, 0x9be,
0x9b0, 0x9a4, 0xf62, 0xfab, 0xf7c, 0xf44, 0xf0b, 0xf41, 0xf60, 0xf56, 0xfb2, 0xf74, 0xf42, 0x62, 0x72, 0x65, 0x7a, 0x68, 0x6f, 0x6e,
0x65, 0x67, 0x46, 0x72, 0x61, 0xf1, 0x73, 0x431, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x411, 0x44a, 0x43b, 0x433,
0x430, 0x440, 0x438, 0x44f, 0x1017, 0x1019, 0x102c, 0x1019, 0x103c, 0x1014, 0x103a, 0x1019, 0x102c, 0x431, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441,
0x43a, 0x430, 0x44f, 0x411, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x44c, 0x1797, 0x17b6, 0x179f, 0x17b6, 0x1781, 0x17d2, 0x1798, 0x17c2, 0x179a,
0x1780, 0x1798, 0x17d2, 0x1796, 0x17bb, 0x1787, 0x17b6, 0x63, 0x61, 0x74, 0x61, 0x6c, 0xe0, 0x45, 0x73, 0x70, 0x61, 0x6e, 0x79, 0x61,
0x4e2d, 0x6587, 0x4e2d, 0x56fd, 0x4e2d, 0x83ef, 0x4eba, 0x6c11, 0x5171, 0x548c, 0x570b, 0x9999, 0x6e2f, 0x7279, 0x5225, 0x884c, 0x653f, 0x5340, 0x4e2d, 0x83ef,
0x4eba, 0x6c11, 0x5171, 0x548c, 0x570b, 0x6fb3, 0x9580, 0x7279, 0x5225, 0x884c, 0x653f, 0x5340, 0x65b0, 0x52a0, 0x5761, 0x53f0, 0x7063, 0x4e2d, 0x6587, 0xff08,
0x7b80, 0x4f53, 0xff09, 0x7b80, 0x4f53, 0x4e2d, 0x6587, 0x4e2d, 0x56fd, 0x9999, 0x6e2f, 0x7279, 0x522b, 0x884c, 0x653f, 0x533a, 0x4e2d, 0x56fd, 0x6fb3, 0x95e8,
0x7279, 0x522b, 0x884c, 0x653f, 0x533a, 0x7e41, 0x9ad4, 0x4e2d, 0x6587, 0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x69, 0x48, 0x72, 0x76,
0x61, 0x74, 0x73, 0x6b, 0x61, 0x10d, 0x65, 0x161, 0x74, 0x69, 0x6e, 0x61, 0x10c, 0x65, 0x73, 0x6b, 0xe1, 0x20, 0x72, 0x65,
0x70, 0x75, 0x62, 0x6c, 0x69, 0x6b, 0x61, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x44, 0x61, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x4e,
0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x41, 0x72,
0x75, 0x62, 0x61, 0x56, 0x6c, 0x61, 0x61, 0x6d, 0x73, 0x42, 0x65, 0x6c, 0x67, 0x69, 0xeb, 0x55, 0x2e, 0x53, 0x2e, 0x20,
0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73,
0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x53, 0x61, 0x6d, 0x6f,
0x61, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x41,
0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x6f, 0x73, 0x42, 0x65, 0x6c, 0x67,
0x69, 0x75, 0x6d, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x42, 0x6f, 0x74, 0x73,
0x77, 0x61, 0x6e, 0x61, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68,
0x43, 0x61, 0x6e, 0x61, 0x64, 0x61, 0x47, 0x75, 0x61, 0x6d, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x48, 0x6f, 0x6e, 0x67,
0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x53, 0x41, 0x52, 0x20, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x49, 0x6e, 0x64, 0x69, 0x61,
0x49, 0x72, 0x65, 0x6c, 0x61, 0x6e, 0x64, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x4d, 0x61, 0x6c, 0x74, 0x61, 0x4d,
0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x6c, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x4d, 0x61, 0x75, 0x72, 0x69,
0x74, 0x69, 0x75, 0x73, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x61, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61,
0x6e, 0x64, 0x4e, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x20, 0x4d, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x61, 0x20, 0x49,
0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x50, 0x61, 0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70,
0x70, 0x69, 0x6e, 0x65, 0x73, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x6f, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20,
0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x54,
0x6f, 0x62, 0x61, 0x67, 0x6f, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68,
0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x4b, 0x69, 0x6e, 0x67, 0x64, 0x6f, 0x6d, 0x55, 0x2e, 0x53, 0x2e, 0x20, 0x4d,
0x69, 0x6e, 0x6f, 0x72, 0x20, 0x4f, 0x75, 0x74, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64,
0x73, 0x55, 0x2e, 0x53, 0x2e, 0x20, 0x56, 0x69, 0x72, 0x67, 0x69, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73,
0x5a, 0x69, 0x6d, 0x62, 0x61, 0x62, 0x77, 0x65, 0xd801, 0xdc0f, 0xd801, 0xdc2d, 0xd801, 0xdc4c, 0xd801, 0xdc34, 0xd801, 0xdc3b, 0xd801, 0xdc32,
0xd801, 0xdc3c, 0x20, 0xd801, 0xdc1d, 0xd801, 0xdc3b, 0xd801, 0xdc29, 0xd801, 0xdc3b, 0xd801, 0xdc45, 0x65, 0x65, 0x73, 0x74, 0x69, 0x45, 0x65,
0x73, 0x74, 0x69, 0x66, 0xf8, 0x72, 0x6f, 0x79, 0x73, 0x6b, 0x74, 0x46, 0xf8, 0x72, 0x6f, 0x79, 0x61, 0x72, 0x73, 0x75,
0x6f, 0x6d, 0x69, 0x53, 0x75, 0x6f, 0x6d, 0x69, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x46, 0x72, 0x61, 0x6e,
0x63, 0x65, 0x42, 0x65, 0x6c, 0x67, 0x69, 0x71, 0x75, 0x65, 0x42, 0xe9, 0x6e, 0x69, 0x6e, 0x42, 0x75, 0x72, 0x6b, 0x69,
0x6e, 0x61, 0x20, 0x46, 0x61, 0x73, 0x6f, 0x42, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x43, 0x61, 0x6d, 0x65, 0x72, 0x6f,
0x75, 0x6e, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x52,
0xe9, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x71, 0x75, 0x65, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x66, 0x72, 0x69, 0x63,
0x61, 0x69, 0x6e, 0x65, 0x54, 0x63, 0x68, 0x61, 0x64, 0x43, 0x6f, 0x6d, 0x6f, 0x72, 0x65, 0x73, 0x52, 0xe9, 0x70, 0x75,
0x62, 0x6c, 0x69, 0x71, 0x75, 0x65, 0x20, 0x64, 0xe9, 0x6d, 0x6f, 0x63, 0x72, 0x61, 0x74, 0x69, 0x71, 0x75, 0x65, 0x20,
0x64, 0x75, 0x20, 0x43, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x6f, 0x6e, 0x67, 0x6f, 0x2d, 0x42, 0x72, 0x61, 0x7a, 0x7a, 0x61,
0x76, 0x69, 0x6c, 0x6c, 0x65, 0x43, 0xf4, 0x74, 0x65, 0x20, 0x64, 0x2019, 0x49, 0x76, 0x6f, 0x69, 0x72, 0x65, 0x44, 0x6a,
0x69, 0x62, 0x6f, 0x75, 0x74, 0x69, 0x47, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x20, 0xe9, 0x71, 0x75, 0x61, 0x74, 0x6f, 0x72,
0x69, 0x61, 0x6c, 0x65, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x65, 0x20, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x65,
0x47, 0x61, 0x62, 0x6f, 0x6e, 0x47, 0x75, 0x61, 0x64, 0x65, 0x6c, 0x6f, 0x75, 0x70, 0x65, 0x47, 0x75, 0x69, 0x6e, 0xe9,
0x65, 0x4c, 0x75, 0x78, 0x65, 0x6d, 0x62, 0x6f, 0x75, 0x72, 0x67, 0x4d, 0x61, 0x64, 0x61, 0x67, 0x61, 0x73, 0x63, 0x61,
0x72, 0x4d, 0x61, 0x6c, 0x69, 0x4d, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x4d, 0x61, 0x79, 0x6f, 0x74,
0x74, 0x65, 0x4d, 0x6f, 0x6e, 0x61, 0x63, 0x6f, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x52, 0xe9, 0x75, 0x6e, 0x69, 0x6f, 0x6e,
0x52, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x53, 0xe9, 0x6e, 0xe9, 0x67, 0x61, 0x6c, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69,
0x73, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x53, 0x75, 0x69, 0x73, 0x73, 0x65, 0x54, 0x6f, 0x67, 0x6f, 0x53, 0x61,
0x69, 0x6e, 0x74, 0x2d, 0x42, 0x61, 0x72, 0x74, 0x68, 0xe9, 0x6c, 0xe9, 0x6d, 0x79, 0x53, 0x61, 0x69, 0x6e, 0x74, 0x2d,
0x4d, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x47, 0x61, 0x6c, 0x65, 0x67, 0x6f, 0x45, 0x73, 0x70, 0x61, 0xf1, 0x61, 0x10e5, 0x10d0,
0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x10e1, 0x10d0, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10d5, 0x10d4, 0x10da, 0x10dd, 0x44, 0x65, 0x75, 0x74, 0x73,
0x63, 0x68, 0x44, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x6c, 0x61, 0x6e, 0x64, 0xd6, 0x73, 0x74, 0x65, 0x72, 0x72, 0x65,
0x69, 0x63, 0x68, 0x69, 0x73, 0x63, 0x68, 0x65, 0x73, 0x20, 0x44, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0xd6, 0x73, 0x74,
0x65, 0x72, 0x72, 0x65, 0x69, 0x63, 0x68, 0x42, 0x65, 0x6c, 0x67, 0x69, 0x65, 0x6e, 0x4c, 0x69, 0x65, 0x63, 0x68, 0x74,
0x65, 0x6e, 0x73, 0x74, 0x65, 0x69, 0x6e, 0x4c, 0x75, 0x78, 0x65, 0x6d, 0x62, 0x75, 0x72, 0x67, 0x53, 0x63, 0x68, 0x77,
0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x48, 0x6f, 0x63, 0x68, 0x64, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x53, 0x63, 0x68,
0x77, 0x65, 0x69, 0x7a, 0x395, 0x3bb, 0x3bb, 0x3b7, 0x3bd, 0x3b9, 0x3ba, 0x3ac, 0x395, 0x3bb, 0x3bb, 0x3ac, 0x3b4, 0x3b1, 0x39a, 0x3cd,
0x3c0, 0x3c1, 0x3bf, 0x3c2, 0x6b, 0x61, 0x6c, 0x61, 0x61, 0x6c, 0x6c, 0x69, 0x73, 0x75, 0x74, 0x4b, 0x61, 0x6c, 0x61, 0x61,
0x6c, 0x6c, 0x69, 0x74, 0x20, 0x4e, 0x75, 0x6e, 0x61, 0x61, 0x74, 0xa97, 0xac1, 0xa9c, 0xab0, 0xabe, 0xaa4, 0xac0, 0xaad, 0xabe,
0xab0, 0xaa4, 0x48, 0x61, 0x75, 0x73, 0x61, 0x47, 0x61, 0x6e, 0x61, 0x4e, 0x69, 0x6a, 0x61, 0x72, 0x4e, 0x61, 0x6a, 0x65,
0x72, 0x69, 0x79, 0x61, 0x5e2, 0x5d1, 0x5e8, 0x5d9, 0x5ea, 0x5d9, 0x5e9, 0x5e8, 0x5d0, 0x5dc, 0x939, 0x93f, 0x928, 0x94d, 0x926, 0x940,
0x92d, 0x93e, 0x930, 0x924, 0x6d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x4d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x6f, 0x72, 0x73, 0x7a,
0xe1, 0x67, 0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x61, 0xcd, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x42, 0x61, 0x68, 0x61,
0x73, 0x61, 0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69,
0x61, 0x47, 0x61, 0x65, 0x69, 0x6c, 0x67, 0x65, 0xc9, 0x69, 0x72, 0x65, 0x69, 0x74, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x6f,
0x49, 0x74, 0x61, 0x6c, 0x69, 0x61, 0x53, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x61, 0x65e5, 0x672c, 0x8a9e, 0x65e5, 0x672c, 0xc95,
0xca8, 0xccd, 0xca8, 0xca1, 0xcad, 0xcbe, 0xcb0, 0xca4, 0x49b, 0x430, 0x437, 0x430, 0x49b, 0x20, 0x442, 0x456, 0x43b, 0x456, 0x49a, 0x430,
0x437, 0x430, 0x49b, 0x441, 0x442, 0x430, 0x43d, 0x4b, 0x69, 0x6e, 0x79, 0x61, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x41a, 0x44b,
0x440, 0x433, 0x44b, 0x437, 0x41a, 0x44b, 0x440, 0x433, 0x44b, 0x437, 0x441, 0x442, 0x430, 0x43d, 0xd55c, 0xad6d, 0xc5b4, 0xb300, 0xd55c, 0xbbfc,
0xad6d, 0x6a9, 0x648, 0x631, 0x62f, 0x6cc, 0x626, 0x6ce, 0x631, 0x627, 0x646, 0x639, 0x6ce, 0x631, 0x627, 0x642, 0x6b, 0x75, 0x72, 0x64,
0xee, 0x54, 0x69, 0x72, 0x6b, 0x69, 0x79, 0x65, 0x49, 0x6b, 0x69, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x55, 0x62, 0x75, 0x72,
0x75, 0x6e, 0x64, 0x69, 0xea5, 0xeb2, 0xea7, 0x6c, 0x61, 0x74, 0x76, 0x69, 0x65, 0x161, 0x75, 0x4c, 0x61, 0x74, 0x76, 0x69,
0x6a, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0xe1, 0x6c, 0x61, 0x52, 0x65, 0x70, 0x69, 0x62, 0x69, 0x6b, 0x69, 0x20, 0x64, 0x65,
0x6d, 0x6f, 0x6b, 0x72, 0x61, 0x74, 0x69, 0x6b, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0xf3, 0x4b, 0x6f,
0x6e, 0x67, 0x6f, 0x6c, 0x69, 0x65, 0x74, 0x75, 0x76, 0x69, 0x173, 0x4c, 0x69, 0x65, 0x74, 0x75, 0x76, 0x61, 0x43c, 0x430,
0x43a, 0x435, 0x434, 0x43e, 0x43d, 0x441, 0x43a, 0x438, 0x41c, 0x430, 0x43a, 0x435, 0x434, 0x43e, 0x43d, 0x438, 0x458, 0x430, 0x4d, 0x61,
0x6c, 0x61, 0x67, 0x61, 0x73, 0x79, 0x4d, 0x61, 0x64, 0x61, 0x67, 0x61, 0x73, 0x69, 0x6b, 0x61, 0x72, 0x61, 0x42, 0x61,
0x68, 0x61, 0x73, 0x61, 0x20, 0x4d, 0x65, 0x6c, 0x61, 0x79, 0x75, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x42,
0x72, 0x75, 0x6e, 0x65, 0x69, 0xd2e, 0xd32, 0xd2f, 0xd3e, 0xd33, 0xd02, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0x4d, 0x61, 0x6c,
0x74, 0x69, 0x92e, 0x930, 0x93e, 0x920, 0x940, 0x43c, 0x43e, 0x43d, 0x433, 0x43e, 0x43b, 0x41c, 0x43e, 0x43d, 0x433, 0x43e, 0x43b, 0x20,
0x443, 0x43b, 0x441, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x940, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20,
0x62, 0x6f, 0x6b, 0x6d, 0xe5, 0x6c, 0x4e, 0x6f, 0x72, 0x67, 0x65, 0x6f, 0x63, 0x63, 0x69, 0x74, 0x61, 0x6e, 0x46, 0x72,
0x61, 0x6e, 0xe7, 0x61, 0xb13, 0xb21, 0xb3c, 0xb3f, 0xb06, 0xb2d, 0xb3e, 0xb30, 0xb24, 0x67e, 0x69a, 0x62a, 0x648, 0x627, 0x641, 0x63a,
0x627, 0x646, 0x633, 0x62a, 0x627, 0x646, 0x641, 0x627, 0x631, 0x633, 0x6cc, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x62f, 0x631, 0x6cc, 0x70,
0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x50, 0x6f, 0x6c, 0x73, 0x6b, 0x61, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x75, 0xea, 0x73,
0x20, 0x65, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x75, 0x50, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x61, 0x6c, 0x70, 0x6f, 0x72, 0x74,
0x75, 0x67, 0x75, 0xea, 0x73, 0x41, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x75, 0xea, 0x73,
0x20, 0x64, 0x6f, 0x20, 0x42, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x42, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x47, 0x75, 0x69, 0x6e,
0xe9, 0x2d, 0x42, 0x69, 0x73, 0x73, 0x61, 0x75, 0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x71, 0x75, 0x65, 0x53, 0xe3,
0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65, 0x20, 0x50, 0x72, 0xed, 0x6e, 0x63, 0x69, 0x70, 0x65, 0xa2a, 0xa70, 0xa1c,
0xa3e, 0xa2c, 0xa40, 0xa2d, 0xa3e, 0xa30, 0xa24, 0x67e, 0x646, 0x62c, 0x627, 0x628, 0x67e, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x72, 0x75,
0x6d, 0x61, 0x6e, 0x74, 0x73, 0x63, 0x68, 0x53, 0x76, 0x69, 0x7a, 0x72, 0x61, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x103, 0x52,
0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x20, 0x4d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x61, 0x52, 0x6f, 0x6d, 0xe2,
0x6e, 0x69, 0x61, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x439, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x44f, 0x41c, 0x43e, 0x43b, 0x434,
0x43e, 0x432, 0x430, 0x423, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x430, 0x53, 0xe4, 0x6e, 0x67, 0xf6, 0x4b, 0xf6, 0x64, 0xf6, 0x72,
0xf6, 0x73, 0xea, 0x73, 0x65, 0x20, 0x74, 0xee, 0x20, 0x42, 0xea, 0x61, 0x66, 0x72, 0xee, 0x6b, 0x61, 0x421, 0x440, 0x43f,
0x441, 0x43a, 0x438, 0x421, 0x440, 0x431, 0x438, 0x458, 0x430, 0x20, 0x438, 0x20, 0x426, 0x440, 0x43d, 0x430, 0x20, 0x413, 0x43e, 0x440,
0x430, 0x441, 0x440, 0x43f, 0x441, 0x43a, 0x438, 0x411, 0x43e, 0x441, 0x43d, 0x430, 0x20, 0x438, 0x20, 0x425, 0x435, 0x440, 0x446, 0x435,
0x433, 0x43e, 0x432, 0x438, 0x43d, 0x430, 0x53, 0x72, 0x70, 0x73, 0x6b, 0x69, 0x43, 0x72, 0x6e, 0x61, 0x20, 0x47, 0x6f, 0x72,
0x61, 0x421, 0x440, 0x431, 0x438, 0x458, 0x430, 0x426, 0x440, 0x43d, 0x430, 0x20, 0x413, 0x43e, 0x440, 0x430, 0x42, 0x6f, 0x73, 0x6e,
0x61, 0x20, 0x69, 0x20, 0x48, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x69, 0x6e, 0x61, 0x53, 0x72, 0x62, 0x69, 0x6a,
0x61, 0x20, 0x69, 0x20, 0x43, 0x72, 0x6e, 0x61, 0x20, 0x47, 0x6f, 0x72, 0x61, 0x53, 0x72, 0x62, 0x69, 0x6a, 0x61, 0x53,
0x72, 0x70, 0x73, 0x6b, 0x6f, 0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x69, 0x53, 0x65, 0x73, 0x6f, 0x74, 0x68, 0x6f,
0x53, 0x65, 0x74, 0x73, 0x77, 0x61, 0x6e, 0x61, 0x63, 0x68, 0x69, 0x53, 0x68, 0x6f, 0x6e, 0x61, 0xdc3, 0xdd2, 0xd82, 0xdc4,
0xdbd, 0xdc1, 0xdca, 0x200d, 0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a, 0xdcf, 0xdc0, 0x53, 0x69, 0x73, 0x77, 0x61, 0x74, 0x69, 0x73,
0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x10d, 0x69, 0x6e, 0x61, 0x53, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0xe1, 0x20, 0x72,
0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x6b, 0x61, 0x73, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x161, 0x10d, 0x69, 0x6e, 0x61, 0x53,
0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x69, 0x6a, 0x61, 0x53, 0x6f, 0x6f, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x53, 0x6f, 0x6f, 0x6d,
0x61, 0x61, 0x6c, 0x69, 0x79, 0x61, 0x4a, 0x61, 0x62, 0x75, 0x75, 0x74, 0x69, 0x49, 0x74, 0x6f, 0x6f, 0x62, 0x69, 0x79,
0x61, 0x4b, 0x69, 0x69, 0x6e, 0x69, 0x79, 0x61, 0x65, 0x73, 0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x20, 0x64, 0x65, 0x20, 0x45,
0x73, 0x70, 0x61, 0xf1, 0x61, 0x65, 0x73, 0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x41, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e,
0x61, 0x42, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x43, 0x68, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69,
0x61, 0x43, 0x6f, 0x73, 0x74, 0x61, 0x20, 0x52, 0x69, 0x63, 0x61, 0x52, 0x65, 0x70, 0xfa, 0x62, 0x6c, 0x69, 0x63, 0x61,
0x20, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x61, 0x45, 0x63, 0x75, 0x61, 0x64, 0x6f, 0x72, 0x45, 0x6c,
0x20, 0x53, 0x61, 0x6c, 0x76, 0x61, 0x64, 0x6f, 0x72, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x20, 0x45, 0x63, 0x75, 0x61,
0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x47, 0x75, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6c, 0x61, 0x48, 0x6f, 0x6e, 0x64, 0x75,
0x72, 0x61, 0x73, 0x4d, 0xe9, 0x78, 0x69, 0x63, 0x6f, 0x4e, 0x69, 0x63, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x50, 0x61,
0x6e, 0x61, 0x6d, 0xe1, 0x50, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x79, 0x50, 0x65, 0x72, 0xfa, 0x50, 0x75, 0x65, 0x72,
0x74, 0x6f, 0x20, 0x52, 0x69, 0x63, 0x6f, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73, 0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f,
0x73, 0x55, 0x72, 0x75, 0x67, 0x75, 0x61, 0x79, 0x56, 0x65, 0x6e, 0x65, 0x7a, 0x75, 0x65, 0x6c, 0x61, 0x65, 0x73, 0x70,
0x61, 0xf1, 0x6f, 0x6c, 0x20, 0x6c, 0x61, 0x74, 0x69, 0x6e, 0x6f, 0x61, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x6f,
0x4c, 0x61, 0x74, 0x69, 0x6e, 0x6f, 0x61, 0x6d, 0xe9, 0x72, 0x69, 0x63, 0x61, 0x4b, 0x69, 0x73, 0x77, 0x61, 0x68, 0x69,
0x6c, 0x69, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x73, 0x76, 0x65, 0x6e, 0x73,
0x6b, 0x61, 0x53, 0x76, 0x65, 0x72, 0x69, 0x67, 0x65, 0x46, 0x69, 0x6e, 0x6c, 0x61, 0x6e, 0x64, 0x54, 0x61, 0x67, 0x61,
0x6c, 0x6f, 0x67, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0xba4, 0xbae, 0xbbf, 0xbb4, 0xbcd, 0xb87, 0xba8, 0xbcd,
0xba4, 0xbbf, 0xbaf, 0xbbe, 0xb87, 0xbb2, 0xb99, 0xbcd, 0xb95, 0xbc8, 0xc24, 0xc46, 0xc32, 0xc41, 0xc17, 0xc41, 0xc2d, 0xc3e, 0xc30, 0xc24,
0x20, 0xc26, 0xc47, 0xc36, 0xc02, 0xe44, 0xe17, 0xe22, 0xf54, 0xf7c, 0xf51, 0xf0b, 0xf66, 0xf90, 0xf51, 0xf0b, 0xf62, 0xf92, 0xfb1, 0xf0b,
0xf53, 0xf42, 0xf62, 0xf92, 0xfb1, 0xf0b, 0xf42, 0xf62, 0xf0b, 0x1275, 0x130d, 0x122d, 0x129b, 0x12a4, 0x122d, 0x1275, 0x122b, 0x6c, 0x65, 0x61,
0x20, 0x66, 0x61, 0x6b, 0x61, 0x74, 0x6f, 0x6e, 0x67, 0x61, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x58, 0x69, 0x74, 0x73, 0x6f,
0x6e, 0x67, 0x61, 0x54, 0xfc, 0x72, 0x6b, 0xe7, 0x65, 0x54, 0xfc, 0x72, 0x6b, 0x69, 0x79, 0x65, 0x443, 0x43a, 0x440, 0x430,
0x457, 0x43d, 0x441, 0x44c, 0x43a, 0x430, 0x423, 0x43a, 0x440, 0x430, 0x457, 0x43d, 0x430, 0x627, 0x631, 0x62f, 0x648, 0x628, 0x6be, 0x627,
0x631, 0x62a, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x40e, 0x437, 0x431, 0x435, 0x43a, 0x40e, 0x437, 0x431, 0x435, 0x43a, 0x438,
0x441, 0x442, 0x43e, 0x43d, 0x627, 0x6c9, 0x632, 0x628, 0x6d0, 0x6a9, 0x6f, 0x2bc, 0x7a, 0x62, 0x65, 0x6b, 0x63, 0x68, 0x61, 0x4f,
0x2bc, 0x7a, 0x62, 0x65, 0x6b, 0x69, 0x73, 0x74, 0x6f, 0x6e, 0x54, 0x69, 0x1ebf, 0x6e, 0x67, 0x20, 0x56, 0x69, 0x1ec7, 0x74,
0x56, 0x69, 0x1ec7, 0x74, 0x20, 0x4e, 0x61, 0x6d, 0x43, 0x79, 0x6d, 0x72, 0x61, 0x65, 0x67, 0x50, 0x72, 0x79, 0x64, 0x61,
0x69, 0x6e, 0x20, 0x46, 0x61, 0x77, 0x72, 0x69, 0x73, 0x69, 0x58, 0x68, 0x6f, 0x73, 0x61, 0xc8, 0x64, 0xe8, 0x20, 0x59,
0x6f, 0x72, 0xf9, 0x62, 0xe1, 0x4f, 0x72, 0xed, 0x6c, 0x1eb9, 0x301, 0xe8, 0x64, 0x65, 0x20, 0x4e, 0xe0, 0xec, 0x6a, 0xed,
0x72, 0xed, 0xe0, 0x69, 0x73, 0x69, 0x5a, 0x75, 0x6c, 0x75, 0x69, 0x4e, 0x69, 0x6e, 0x67, 0x69, 0x7a, 0x69, 0x6d, 0x75,
0x20, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x6e, 0x79, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x4e, 0x6f, 0x72, 0x65, 0x67, 0x62,
0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x69, 0x47, 0x61, 0x65, 0x6c, 0x67, 0x52, 0x79, 0x77, 0x76, 0x61, 0x6e, 0x65, 0x74,
0x68, 0x20, 0x55, 0x6e, 0x79, 0x73, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x77, 0x65, 0x6b, 0x41, 0x6b, 0x61, 0x6e, 0x47, 0x61,
0x61, 0x6e, 0x61, 0x915, 0x94b, 0x902, 0x915, 0x923, 0x940, 0x49, 0x67, 0x62, 0x6f, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61,
0x4b, 0x69, 0x6b, 0x61, 0x6d, 0x62, 0x61, 0x1265, 0x120a, 0x1295, 0x53, 0x69, 0x64, 0x61, 0x61, 0x6d, 0x75, 0x20, 0x41, 0x66,
0x6f, 0x49, 0x74, 0x69, 0x79, 0x6f, 0x6f, 0x70, 0x68, 0x69, 0x79, 0x61, 0x1275, 0x130d, 0x1228, 0x66, 0x75, 0x72, 0x6c, 0x61,
0x6e, 0x49, 0x74, 0x61, 0x6c, 0x69, 0x65, 0x54, 0x73, 0x68, 0x69, 0x76, 0x65, 0x6e, 0x1e13, 0x61, 0x65, 0x28b, 0x65, 0x67,
0x62, 0x65, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x6e, 0x75, 0x74, 0x6f, 0x6d, 0x65, 0x54, 0x6f, 0x67, 0x6f, 0x20, 0x6e,
0x75, 0x74, 0x6f, 0x6d, 0x65, 0x12c8, 0x120b, 0x12ed, 0x1273, 0x1271, 0x2bb, 0x14c, 0x6c, 0x65, 0x6c, 0x6f, 0x20, 0x48, 0x61, 0x77,
0x61, 0x69, 0x2bb, 0x69, 0x2bb, 0x41, 0x6d, 0x65, 0x6c, 0x69, 0x6b, 0x61, 0x20, 0x48, 0x75, 0x69, 0x20, 0x50, 0x16b, 0x20,
0x2bb, 0x49, 0x61, 0x46, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x6f, 0x53, 0x63, 0x68, 0x77, 0x69, 0x69, 0x7a, 0x65, 0x72,
0x74, 0xfc, 0xfc, 0x74, 0x73, 0x63, 0x68, 0x53, 0x63, 0x68, 0x77, 0x69, 0x69, 0x7a, 0xa188, 0xa320, 0xa259, 0xa34f, 0xa1e9, 0x50,
0x6c, 0x61, 0x74, 0x74, 0x64, 0xfc, 0xfc, 0x74, 0x73, 0x63, 0x68, 0x44, 0xfc, 0xfc, 0x74, 0x73, 0x63, 0x68, 0x6c, 0x61,
0x6e, 0x64, 0x69, 0x73, 0x69, 0x4e, 0x64, 0x65, 0x62, 0x65, 0x6c, 0x65, 0x53, 0x65, 0x73, 0x6f, 0x74, 0x68, 0x6f, 0x20,
0x73, 0x61, 0x20, 0x4c, 0x65, 0x62, 0x6f, 0x61, 0x64, 0x61, 0x76, 0x76, 0x69, 0x73, 0xe1, 0x6d, 0x65, 0x67, 0x69, 0x65,
0x6c, 0x6c, 0x61, 0x53, 0x75, 0x6f, 0x70, 0x6d, 0x61, 0x4e, 0x6f, 0x72, 0x67, 0x61, 0x45, 0x6b, 0x65, 0x67, 0x75, 0x73,
0x69, 0x69, 0x4b, 0x69, 0x74, 0x61, 0x69, 0x74, 0x61, 0x50, 0x75, 0x6c, 0x61, 0x61, 0x72, 0x53, 0x65, 0x6e, 0x65, 0x67,
0x61, 0x61, 0x6c, 0x47, 0x69, 0x6b, 0x75, 0x79, 0x75, 0x4b, 0x69, 0x73, 0x61, 0x6d, 0x70, 0x75, 0x72, 0x73, 0x65, 0x6e,
0x61, 0x4b, 0x69, 0x68, 0x6f, 0x72, 0x6f, 0x6d, 0x62, 0x6f, 0x74, 0x61, 0x6d, 0x61, 0x7a, 0x69, 0x67, 0x68, 0x74, 0x6c,
0x6d, 0x263, 0x72, 0x69, 0x62, 0x2d5c, 0x2d30, 0x2d4e, 0x2d30, 0x2d63, 0x2d49, 0x2d56, 0x2d5c, 0x2d4d, 0x2d4e, 0x2d56, 0x2d54, 0x2d49, 0x2d31, 0x54,
0x61, 0x71, 0x62, 0x61, 0x79, 0x6c, 0x69, 0x74, 0x4c, 0x65, 0x7a, 0x7a, 0x61, 0x79, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x79,
0x61, 0x6e, 0x6b, 0x6f, 0x72, 0x65, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x48, 0x69, 0x62, 0x65, 0x6e, 0x61, 0x48, 0x75,
0x74, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x4b, 0x79, 0x69, 0x76, 0x75, 0x6e, 0x6a, 0x6f, 0x62, 0x61, 0x6d, 0x61,
0x6e, 0x61, 0x6b, 0x61, 0x6e, 0x4b, 0x129, 0x65, 0x6d, 0x62, 0x75, 0x13e3, 0x13b3, 0x13a9, 0x13a0, 0x13b9, 0x13f0, 0x13df, 0x6b, 0x72,
0x65, 0x6f, 0x6c, 0x20, 0x6d, 0x6f, 0x72, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x4d, 0x6f, 0x72, 0x69, 0x73, 0x43, 0x68, 0x69,
0x6d, 0x61, 0x6b, 0x6f, 0x6e, 0x64, 0x65, 0x4b, 0x268, 0x6c, 0x61, 0x61, 0x6e, 0x67, 0x69, 0x54, 0x61, 0x61, 0x6e, 0x73,
0x61, 0x6e, 0xed, 0x61, 0x4c, 0x75, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x59, 0x75, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x49, 0x63,
0x68, 0x69, 0x62, 0x65, 0x6d, 0x62, 0x61, 0x5a, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6b, 0x61, 0x62, 0x75, 0x76, 0x65, 0x72,
0x64, 0x69, 0x61, 0x6e, 0x75, 0x4b, 0x61, 0x62, 0x75, 0x20, 0x56, 0x65, 0x72, 0x64, 0x69, 0x4b, 0x129, 0x6d, 0x129, 0x72,
0x169, 0x4b, 0x61, 0x6c, 0x65, 0x6e, 0x6a, 0x69, 0x6e, 0x45, 0x6d, 0x65, 0x74, 0x61, 0x62, 0x20, 0x4b, 0x65, 0x6e, 0x79,
0x61, 0x4b, 0x68, 0x6f, 0x65, 0x6b, 0x68, 0x6f, 0x65, 0x67, 0x6f, 0x77, 0x61, 0x62, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69,
0x61, 0x62, 0x4b, 0x69, 0x6d, 0x61, 0x63, 0x68, 0x61, 0x6d, 0x65, 0x44, 0x6f, 0xfc, 0x74, 0x73, 0x63, 0x68, 0x6c, 0x61,
0x6e, 0x64, 0x4d, 0x61, 0x61, 0x54, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0x69, 0x61, 0x4f, 0x6c, 0x75, 0x73, 0x6f, 0x67, 0x61,
0x4c, 0x75, 0x6c, 0x75, 0x68, 0x69, 0x61, 0x4b, 0x69, 0x70, 0x61, 0x72, 0x65, 0x54, 0x61, 0x64, 0x68, 0x61, 0x6e, 0x69,
0x61, 0x4b, 0x69, 0x74, 0x65, 0x73, 0x6f, 0x4b, 0x65, 0x6e, 0x69, 0x61, 0x4b, 0x6f, 0x79, 0x72, 0x61, 0x20, 0x63, 0x69,
0x69, 0x6e, 0x69, 0x4d, 0x61, 0x61, 0x6c, 0x69, 0x4b, 0x69, 0x72, 0x75, 0x77, 0x61, 0x44, 0x68, 0x6f, 0x6c, 0x75, 0x6f,
0x52, 0x75, 0x6b, 0x69, 0x67, 0x61, 0x54, 0x61, 0x6d, 0x61, 0x7a, 0x69, 0x263, 0x74, 0x4d, 0x65, 0x1e5b, 0x1e5b, 0x75, 0x6b,
0x4b, 0x6f, 0x79, 0x72, 0x61, 0x62, 0x6f, 0x72, 0x6f, 0x20, 0x73, 0x65, 0x6e, 0x6e, 0x69, 0x4b, 0x69, 0x73, 0x68, 0x61,
0x6d, 0x62, 0x61, 0x61, 0x92c, 0x921, 0x93c, 0x94b, 0x41, 0x67, 0x68, 0x65, 0x6d, 0x4b, 0xe0, 0x6d, 0xe0, 0x6c, 0xfb, 0x14b,
0x181, 0xe0, 0x73, 0xe0, 0x61, 0x4b, 0xe0, 0x6d, 0x25b, 0x300, 0x72, 0xfb, 0x6e, 0x5a, 0x61, 0x72, 0x6d, 0x61, 0x63, 0x69,
0x69, 0x6e, 0x65, 0x4e, 0x69, 0x17e, 0x65, 0x72, 0x64, 0x75, 0xe1, 0x6c, 0xe1, 0x6a, 0x6f, 0x6f, 0x6c, 0x61, 0x53, 0x65,
0x6e, 0x65, 0x67, 0x61, 0x6c, 0x65, 0x77, 0x6f, 0x6e, 0x64, 0x6f, 0x4b, 0x61, 0x6d, 0x1dd, 0x72, 0xfa, 0x6e, 0x72, 0x69,
0x6b, 0x70, 0x61, 0x6b, 0x61, 0x6d, 0x25b, 0x72, 0xfa, 0x6e, 0x54, 0x73, 0x68, 0x69, 0x6c, 0x75, 0x62, 0x61, 0x44, 0x69,
0x74, 0x75, 0x6e, 0x67, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x75, 0x4d, 0x61, 0x6b, 0x75, 0x61, 0x55,
0x6d, 0x6f, 0x7a, 0x61, 0x6d, 0x62, 0x69, 0x6b, 0x69, 0x4d, 0x55, 0x4e, 0x44, 0x41, 0x14a, 0x6b, 0x61, 0x6d, 0x65, 0x72,
0x75, 0x14b, 0x4b, 0x61, 0x6d, 0x65, 0x72, 0x75, 0x6e, 0x54, 0x68, 0x6f, 0x6b, 0x20, 0x4e, 0x61, 0x74, 0x68, 0x53, 0x75,
0x64, 0x61, 0x6e, 0x441, 0x430, 0x445, 0x430, 0x20, 0x442, 0x44b, 0x43b, 0x430, 0x49, 0x73, 0x68, 0x69, 0x73, 0x61, 0x6e, 0x67,
0x75, 0x54, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0x69, 0x79, 0x61, 0x4b, 0x69, 0x73, 0x77, 0x61, 0x68, 0x69, 0x6c, 0x69, 0x20,
0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x4a, 0x61, 0x6d, 0x68, 0x75, 0x72, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b,
0x69, 0x64, 0x65, 0x6d, 0x6f, 0x6b, 0x72, 0x61, 0x73, 0x69, 0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x6f,
0x54, 0x61, 0x73, 0x61, 0x77, 0x61, 0x71, 0x20, 0x73, 0x65, 0x6e, 0x6e, 0x69, 0xa559, 0xa524, 0xa55e, 0xa524, 0xa52b, 0xa569, 0x56,
0x61, 0x69, 0x4c, 0x61, 0x69, 0x62, 0x68, 0x69, 0x79, 0x61, 0x57, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x53, 0x63, 0x68, 0x77,
0x69, 0x7a, 0x6e, 0x75, 0x61, 0x73, 0x75, 0x65, 0x4b, 0x65, 0x6d, 0x65, 0x6c, 0xfa, 0x6e
};

static const char language_name_list[] =
"Default\0"
"C\0"
"Abkhazian\0"
"Afan\0"
"Afar\0"
"Afrikaans\0"
"Albanian\0"
"Amharic\0"
"Arabic\0"
"Armenian\0"
"Assamese\0"
"Aymara\0"
"Azerbaijani\0"
"Bashkir\0"
"Basque\0"
"Bengali\0"
"Bhutani\0"
"Bihari\0"
"Bislama\0"
"Breton\0"
"Bulgarian\0"
"Burmese\0"
"Byelorussian\0"
"Cambodian\0"
"Catalan\0"
"Chinese\0"
"Corsican\0"
"Croatian\0"
"Czech\0"
"Danish\0"
"Dutch\0"
"English\0"
"Esperanto\0"
"Estonian\0"
"Faroese\0"
"Fiji\0"
"Finnish\0"
"French\0"
"Frisian\0"
"Gaelic\0"
"Galician\0"
"Georgian\0"
"German\0"
"Greek\0"
"Greenlandic\0"
"Guarani\0"
"Gujarati\0"
"Hausa\0"
"Hebrew\0"
"Hindi\0"
"Hungarian\0"
"Icelandic\0"
"Indonesian\0"
"Interlingua\0"
"Interlingue\0"
"Inuktitut\0"
"Inupiak\0"
"Irish\0"
"Italian\0"
"Japanese\0"
"Javanese\0"
"Kannada\0"
"Kashmiri\0"
"Kazakh\0"
"Kinyarwanda\0"
"Kirghiz\0"
"Korean\0"
"Kurdish\0"
"Rundi\0"
"Laothian\0"
"Latin\0"
"Latvian\0"
"Lingala\0"
"Lithuanian\0"
"Macedonian\0"
"Malagasy\0"
"Malay\0"
"Malayalam\0"
"Maltese\0"
"Maori\0"
"Marathi\0"
"Moldavian\0"
"Mongolian\0"
"Nauru\0"
"Nepali\0"
"Norwegian\0"
"Occitan\0"
"Oriya\0"
"Pashto\0"
"Persian\0"
"Polish\0"
"Portuguese\0"
"Punjabi\0"
"Quechua\0"
"RhaetoRomance\0"
"Romanian\0"
"Russian\0"
"Samoan\0"
"Sangho\0"
"Sanskrit\0"
"Serbian\0"
"SerboCroatian\0"
"Sesotho\0"
"Setswana\0"
"Shona\0"
"Sindhi\0"
"Singhalese\0"
"Siswati\0"
"Slovak\0"
"Slovenian\0"
"Somali\0"
"Spanish\0"
"Sundanese\0"
"Swahili\0"
"Swedish\0"
"Tagalog\0"
"Tajik\0"
"Tamil\0"
"Tatar\0"
"Telugu\0"
"Thai\0"
"Tibetan\0"
"Tigrinya\0"
"Tonga\0"
"Tsonga\0"
"Turkish\0"
"Turkmen\0"
"Twi\0"
"Uigur\0"
"Ukrainian\0"
"Urdu\0"
"Uzbek\0"
"Vietnamese\0"
"Volapuk\0"
"Welsh\0"
"Wolof\0"
"Xhosa\0"
"Yiddish\0"
"Yoruba\0"
"Zhuang\0"
"Zulu\0"
"Nynorsk\0"
"Bosnian\0"
"Divehi\0"
"Manx\0"
"Cornish\0"
"Akan\0"
"Konkani\0"
"Ga\0"
"Igbo\0"
"Kamba\0"
"Syriac\0"
"Blin\0"
"Geez\0"
"Koro\0"
"Sidamo\0"
"Atsam\0"
"Tigre\0"
"Jju\0"
"Friulian\0"
"Venda\0"
"Ewe\0"
"Walamo\0"
"Hawaiian\0"
"Tyap\0"
"Chewa\0"
"Filipino\0"
"Swiss German\0"
"Sichuan Yi\0"
"Kpelle\0"
"Low German\0"
"South Ndebele\0"
"Northern Sotho\0"
"Northern Sami\0"
"Taroko\0"
"Gusii\0"
"Taita\0"
"Fulah\0"
"Kikuyu\0"
"Samburu\0"
"Sena\0"
"North Ndebele\0"
"Rombo\0"
"Tachelhit\0"
"Kabyle\0"
"Nyankole\0"
"Bena\0"
"Vunjo\0"
"Bambara\0"
"Embu\0"
"Cherokee\0"
"Morisyen\0"
"Makonde\0"
"Langi\0"
"Ganda\0"
"Bemba\0"
"Kabuverdianu\0"
"Meru\0"
"Kalenjin\0"
"Nama\0"
"Machame\0"
"Colognian\0"
"Masai\0"
"Soga\0"
"Luyia\0"
"Asu\0"
"Teso\0"
"Saho\0"
"Koyra Chiini\0"
"Rwa\0"
"Luo\0"
"Chiga\0"
"Central Morocco Tamazight\0"
"Koyraboro Senni\0"
"Shambala\0"
"Bodo\0"
"Aghem\0"
"Basaa\0"
"Zarma\0"
"Duala\0"
"JolaFonyi\0"
"Ewondo\0"
"Bafia\0"
"LubaKatanga\0"
"MakhuwaMeetto\0"
"Mundang\0"
"Kwasio\0"
"Nuer\0"
"Sakha\0"
"Sangu\0"
"Congo Swahili\0"
"Tasawaq\0"
"Vai\0"
"Walser\0"
"Yangben\0"
;

static const quint16 language_name_index[] = {
     0, // AnyLanguage
     8, // C
    10, // Abkhazian
    20, // Afan
    25, // Afar
    30, // Afrikaans
    40, // Albanian
    49, // Amharic
    57, // Arabic
    64, // Armenian
    73, // Assamese
    82, // Aymara
    89, // Azerbaijani
   101, // Bashkir
   109, // Basque
   116, // Bengali
   124, // Bhutani
   132, // Bihari
   139, // Bislama
   147, // Breton
   154, // Bulgarian
   164, // Burmese
   172, // Byelorussian
   185, // Cambodian
   195, // Catalan
   203, // Chinese
   211, // Corsican
   220, // Croatian
   229, // Czech
   235, // Danish
   242, // Dutch
   248, // English
   256, // Esperanto
   266, // Estonian
   275, // Faroese
   283, // Fiji
   288, // Finnish
   296, // French
   303, // Frisian
   311, // Gaelic
   318, // Galician
   327, // Georgian
   336, // German
   343, // Greek
   349, // Greenlandic
   361, // Guarani
   369, // Gujarati
   378, // Hausa
   384, // Hebrew
   391, // Hindi
   397, // Hungarian
   407, // Icelandic
   417, // Indonesian
   428, // Interlingua
   440, // Interlingue
   452, // Inuktitut
   462, // Inupiak
   470, // Irish
   476, // Italian
   484, // Japanese
   493, // Javanese
   502, // Kannada
   510, // Kashmiri
   519, // Kazakh
   526, // Kinyarwanda
   538, // Kirghiz
   546, // Korean
   553, // Kurdish
   561, // Rundi
   567, // Laothian
   576, // Latin
   582, // Latvian
   590, // Lingala
   598, // Lithuanian
   609, // Macedonian
   620, // Malagasy
   629, // Malay
   635, // Malayalam
   645, // Maltese
   653, // Maori
   659, // Marathi
   667, // Moldavian
   677, // Mongolian
   687, // Nauru
   693, // Nepali
   700, // Norwegian
   710, // Occitan
   718, // Oriya
   724, // Pashto
   731, // Persian
   739, // Polish
   746, // Portuguese
   757, // Punjabi
   765, // Quechua
   773, // RhaetoRomance
   787, // Romanian
   796, // Russian
   804, // Samoan
   811, // Sangho
   818, // Sanskrit
   827, // Serbian
   835, // SerboCroatian
   849, // Sesotho
   857, // Setswana
   866, // Shona
   872, // Sindhi
   879, // Singhalese
   890, // Siswati
   898, // Slovak
   905, // Slovenian
   915, // Somali
   922, // Spanish
   930, // Sundanese
   940, // Swahili
   948, // Swedish
   956, // Tagalog
   964, // Tajik
   970, // Tamil
   976, // Tatar
   982, // Telugu
   989, // Thai
   994, // Tibetan
  1002, // Tigrinya
  1011, // Tonga
  1017, // Tsonga
  1024, // Turkish
  1032, // Turkmen
  1040, // Twi
  1044, // Uigur
  1050, // Ukrainian
  1060, // Urdu
  1065, // Uzbek
  1071, // Vietnamese
  1082, // Volapuk
  1090, // Welsh
  1096, // Wolof
  1102, // Xhosa
  1108, // Yiddish
  1116, // Yoruba
  1123, // Zhuang
  1130, // Zulu
  1135, // Nynorsk
  1143, // Bosnian
  1151, // Divehi
  1158, // Manx
  1163, // Cornish
  1171, // Akan
  1176, // Konkani
  1184, // Ga
  1187, // Igbo
  1192, // Kamba
  1198, // Syriac
  1205, // Blin
  1210, // Geez
  1215, // Koro
  1220, // Sidamo
  1227, // Atsam
  1233, // Tigre
  1239, // Jju
  1243, // Friulian
  1252, // Venda
  1258, // Ewe
  1262, // Walamo
  1269, // Hawaiian
  1278, // Tyap
  1283, // Chewa
  1289, // Filipino
  1298, // Swiss German
  1311, // Sichuan Yi
  1322, // Kpelle
  1329, // Low German
  1340, // South Ndebele
  1354, // Northern Sotho
  1369, // Northern Sami
  1383, // Taroko
  1390, // Gusii
  1396, // Taita
  1402, // Fulah
  1408, // Kikuyu
  1415, // Samburu
  1423, // Sena
  1428, // North Ndebele
  1442, // Rombo
  1448, // Tachelhit
  1458, // Kabyle
  1465, // Nyankole
  1474, // Bena
  1479, // Vunjo
  1485, // Bambara
  1493, // Embu
  1498, // Cherokee
  1507, // Morisyen
  1516, // Makonde
  1524, // Langi
  1530, // Ganda
  1536, // Bemba
  1542, // Kabuverdianu
  1555, // Meru
  1560, // Kalenjin
  1569, // Nama
  1574, // Machame
  1582, // Colognian
  1592, // Masai
  1598, // Soga
  1603, // Luyia
  1609, // Asu
  1613, // Teso
  1618, // Saho
  1623, // Koyra Chiini
  1636, // Rwa
  1640, // Luo
  1644, // Chiga
  1650, // Central Morocco Tamazight
  1676, // Koyraboro Senni
  1692, // Shambala
  1701, // Bodo
  1706, // Aghem
  1712, // Basaa
  1718, // Zarma
  1724, // Duala
  1730, // JolaFonyi
  1740, // Ewondo
  1747, // Bafia
  1753, // LubaKatanga
  1765, // MakhuwaMeetto
  1779, // Mundang
  1787, // Kwasio
  1794, // Nuer
  1799, // Sakha
  1805, // Sangu
  1811, // Congo Swahili
  1825, // Tasawaq
  1833, // Vai
  1837, // Walser
  1844, // Yangben
};

static const char script_name_list[] =
"Default\0"
"Arabic\0"
"Cyrillic\0"
"Deseret\0"
"Gurmukhi\0"
"Simplified Han\0"
"Traditional Han\0"
"Latin\0"
"Mongolian\0"
"Tifinagh\0"
;

static const quint16 script_name_index[] = {
     0, // AnyScript
     8, // Arabic
    15, // Cyrillic
    24, // Deseret
    32, // Gurmukhi
    41, // Simplified Han
    56, // Traditional Han
    72, // Latin
    78, // Mongolian
    88, // Tifinagh
};

static const char country_name_list[] =
"Default\0"
"Afghanistan\0"
"Albania\0"
"Algeria\0"
"AmericanSamoa\0"
"Andorra\0"
"Angola\0"
"Anguilla\0"
"Antarctica\0"
"AntiguaAndBarbuda\0"
"Argentina\0"
"Armenia\0"
"Aruba\0"
"Australia\0"
"Austria\0"
"Azerbaijan\0"
"Bahamas\0"
"Bahrain\0"
"Bangladesh\0"
"Barbados\0"
"Belarus\0"
"Belgium\0"
"Belize\0"
"Benin\0"
"Bermuda\0"
"Bhutan\0"
"Bolivia\0"
"BosniaAndHerzegowina\0"
"Botswana\0"
"BouvetIsland\0"
"Brazil\0"
"BritishIndianOceanTerritory\0"
"BruneiDarussalam\0"
"Bulgaria\0"
"BurkinaFaso\0"
"Burundi\0"
"Cambodia\0"
"Cameroon\0"
"Canada\0"
"CapeVerde\0"
"CaymanIslands\0"
"CentralAfricanRepublic\0"
"Chad\0"
"Chile\0"
"China\0"
"ChristmasIsland\0"
"CocosIslands\0"
"Colombia\0"
"Comoros\0"
"DemocraticRepublicOfCongo\0"
"PeoplesRepublicOfCongo\0"
"CookIslands\0"
"CostaRica\0"
"IvoryCoast\0"
"Croatia\0"
"Cuba\0"
"Cyprus\0"
"CzechRepublic\0"
"Denmark\0"
"Djibouti\0"
"Dominica\0"
"DominicanRepublic\0"
"EastTimor\0"
"Ecuador\0"
"Egypt\0"
"ElSalvador\0"
"EquatorialGuinea\0"
"Eritrea\0"
"Estonia\0"
"Ethiopia\0"
"FalklandIslands\0"
"FaroeIslands\0"
"Fiji\0"
"Finland\0"
"France\0"
"MetropolitanFrance\0"
"FrenchGuiana\0"
"FrenchPolynesia\0"
"FrenchSouthernTerritories\0"
"Gabon\0"
"Gambia\0"
"Georgia\0"
"Germany\0"
"Ghana\0"
"Gibraltar\0"
"Greece\0"
"Greenland\0"
"Grenada\0"
"Guadeloupe\0"
"Guam\0"
"Guatemala\0"
"Guinea\0"
"GuineaBissau\0"
"Guyana\0"
"Haiti\0"
"HeardAndMcDonaldIslands\0"
"Honduras\0"
"HongKong\0"
"Hungary\0"
"Iceland\0"
"India\0"
"Indonesia\0"
"Iran\0"
"Iraq\0"
"Ireland\0"
"Israel\0"
"Italy\0"
"Jamaica\0"
"Japan\0"
"Jordan\0"
"Kazakhstan\0"
"Kenya\0"
"Kiribati\0"
"DemocraticRepublicOfKorea\0"
"RepublicOfKorea\0"
"Kuwait\0"
"Kyrgyzstan\0"
"Lao\0"
"Latvia\0"
"Lebanon\0"
"Lesotho\0"
"Liberia\0"
"LibyanArabJamahiriya\0"
"Liechtenstein\0"
"Lithuania\0"
"Luxembourg\0"
"Macau\0"
"Macedonia\0"
"Madagascar\0"
"Malawi\0"
"Malaysia\0"
"Maldives\0"
"Mali\0"
"Malta\0"
"MarshallIslands\0"
"Martinique\0"
"Mauritania\0"
"Mauritius\0"
"Mayotte\0"
"Mexico\0"
"Micronesia\0"
"Moldova\0"
"Monaco\0"
"Mongolia\0"
"Montserrat\0"
"Morocco\0"
"Mozambique\0"
"Myanmar\0"
"Namibia\0"
"Nauru\0"
"Nepal\0"
"Netherlands\0"
"NetherlandsAntilles\0"
"NewCaledonia\0"
"NewZealand\0"
"Nicaragua\0"
"Niger\0"
"Nigeria\0"
"Niue\0"
"NorfolkIsland\0"
"NorthernMarianaIslands\0"
"Norway\0"
"Oman\0"
"Pakistan\0"
"Palau\0"
"PalestinianTerritory\0"
"Panama\0"
"PapuaNewGuinea\0"
"Paraguay\0"
"Peru\0"
"Philippines\0"
"Pitcairn\0"
"Poland\0"
"Portugal\0"
"PuertoRico\0"
"Qatar\0"
"Reunion\0"
"Romania\0"
"RussianFederation\0"
"Rwanda\0"
"SaintKittsAndNevis\0"
"StLucia\0"
"StVincentAndTheGrenadines\0"
"Samoa\0"
"SanMarino\0"
"SaoTomeAndPrincipe\0"
"SaudiArabia\0"
"Senegal\0"
"Seychelles\0"
"SierraLeone\0"
"Singapore\0"
"Slovakia\0"
"Slovenia\0"
"SolomonIslands\0"
"Somalia\0"
"SouthAfrica\0"
"SouthGeorgiaAndTheSouthSandwichIslands\0"
"Spain\0"
"SriLanka\0"
"StHelena\0"
"StPierreAndMiquelon\0"
"Sudan\0"
"Suriname\0"
"SvalbardAndJanMayenIslands\0"
"Swaziland\0"
"Sweden\0"
"Switzerland\0"
"SyrianArabRepublic\0"
"Taiwan\0"
"Tajikistan\0"
"Tanzania\0"
"Thailand\0"
"Togo\0"
"Tokelau\0"
"Tonga\0"
"TrinidadAndTobago\0"
"Tunisia\0"
"Turkey\0"
"Turkmenistan\0"
"TurksAndCaicosIslands\0"
"Tuvalu\0"
"Uganda\0"
"Ukraine\0"
"UnitedArabEmirates\0"
"UnitedKingdom\0"
"UnitedStates\0"
"UnitedStatesMinorOutlyingIslands\0"
"Uruguay\0"
"Uzbekistan\0"
"Vanuatu\0"
"VaticanCityState\0"
"Venezuela\0"
"VietNam\0"
"BritishVirginIslands\0"
"USVirginIslands\0"
"WallisAndFutunaIslands\0"
"WesternSahara\0"
"Yemen\0"
"Yugoslavia\0"
"Zambia\0"
"Zimbabwe\0"
"SerbiaAndMontenegro\0"
"Montenegro\0"
"Serbia\0"
"Saint Barthelemy\0"
"Saint Martin\0"
"LatinAmericaAndTheCaribbean\0"
;

static const quint16 country_name_index[] = {
     0, // AnyCountry
     8, // Afghanistan
    20, // Albania
    28, // Algeria
    36, // AmericanSamoa
    50, // Andorra
    58, // Angola
    65, // Anguilla
    74, // Antarctica
    85, // AntiguaAndBarbuda
   103, // Argentina
   113, // Armenia
   121, // Aruba
   127, // Australia
   137, // Austria
   145, // Azerbaijan
   156, // Bahamas
   164, // Bahrain
   172, // Bangladesh
   183, // Barbados
   192, // Belarus
   200, // Belgium
   208, // Belize
   215, // Benin
   221, // Bermuda
   229, // Bhutan
   236, // Bolivia
   244, // BosniaAndHerzegowina
   265, // Botswana
   274, // BouvetIsland
   287, // Brazil
   294, // BritishIndianOceanTerritory
   322, // BruneiDarussalam
   339, // Bulgaria
   348, // BurkinaFaso
   360, // Burundi
   368, // Cambodia
   377, // Cameroon
   386, // Canada
   393, // CapeVerde
   403, // CaymanIslands
   417, // CentralAfricanRepublic
   440, // Chad
   445, // Chile
   451, // China
   457, // ChristmasIsland
   473, // CocosIslands
   486, // Colombia
   495, // Comoros
   503, // DemocraticRepublicOfCongo
   529, // PeoplesRepublicOfCongo
   552, // CookIslands
   564, // CostaRica
   574, // IvoryCoast
   585, // Croatia
   593, // Cuba
   598, // Cyprus
   605, // CzechRepublic
   619, // Denmark
   627, // Djibouti
   636, // Dominica
   645, // DominicanRepublic
   663, // EastTimor
   673, // Ecuador
   681, // Egypt
   687, // ElSalvador
   698, // EquatorialGuinea
   715, // Eritrea
   723, // Estonia
   731, // Ethiopia
   740, // FalklandIslands
   756, // FaroeIslands
   769, // Fiji
   774, // Finland
   782, // France
   789, // MetropolitanFrance
   808, // FrenchGuiana
   821, // FrenchPolynesia
   837, // FrenchSouthernTerritories
   863, // Gabon
   869, // Gambia
   876, // Georgia
   884, // Germany
   892, // Ghana
   898, // Gibraltar
   908, // Greece
   915, // Greenland
   925, // Grenada
   933, // Guadeloupe
   944, // Guam
   949, // Guatemala
   959, // Guinea
   966, // GuineaBissau
   979, // Guyana
   986, // Haiti
   992, // HeardAndMcDonaldIslands
  1016, // Honduras
  1025, // HongKong
  1034, // Hungary
  1042, // Iceland
  1050, // India
  1056, // Indonesia
  1066, // Iran
  1071, // Iraq
  1076, // Ireland
  1084, // Israel
  1091, // Italy
  1097, // Jamaica
  1105, // Japan
  1111, // Jordan
  1118, // Kazakhstan
  1129, // Kenya
  1135, // Kiribati
  1144, // DemocraticRepublicOfKorea
  1170, // RepublicOfKorea
  1186, // Kuwait
  1193, // Kyrgyzstan
  1204, // Lao
  1208, // Latvia
  1215, // Lebanon
  1223, // Lesotho
  1231, // Liberia
  1239, // LibyanArabJamahiriya
  1260, // Liechtenstein
  1274, // Lithuania
  1284, // Luxembourg
  1295, // Macau
  1301, // Macedonia
  1311, // Madagascar
  1322, // Malawi
  1329, // Malaysia
  1338, // Maldives
  1347, // Mali
  1352, // Malta
  1358, // MarshallIslands
  1374, // Martinique
  1385, // Mauritania
  1396, // Mauritius
  1406, // Mayotte
  1414, // Mexico
  1421, // Micronesia
  1432, // Moldova
  1440, // Monaco
  1447, // Mongolia
  1456, // Montserrat
  1467, // Morocco
  1475, // Mozambique
  1486, // Myanmar
  1494, // Namibia
  1502, // Nauru
  1508, // Nepal
  1514, // Netherlands
  1526, // NetherlandsAntilles
  1546, // NewCaledonia
  1559, // NewZealand
  1570, // Nicaragua
  1580, // Niger
  1586, // Nigeria
  1594, // Niue
  1599, // NorfolkIsland
  1613, // NorthernMarianaIslands
  1636, // Norway
  1643, // Oman
  1648, // Pakistan
  1657, // Palau
  1663, // PalestinianTerritory
  1684, // Panama
  1691, // PapuaNewGuinea
  1706, // Paraguay
  1715, // Peru
  1720, // Philippines
  1732, // Pitcairn
  1741, // Poland
  1748, // Portugal
  1757, // PuertoRico
  1768, // Qatar
  1774, // Reunion
  1782, // Romania
  1790, // RussianFederation
  1808, // Rwanda
  1815, // SaintKittsAndNevis
  1834, // StLucia
  1842, // StVincentAndTheGrenadines
  1868, // Samoa
  1874, // SanMarino
  1884, // SaoTomeAndPrincipe
  1903, // SaudiArabia
  1915, // Senegal
  1923, // Seychelles
  1934, // SierraLeone
  1946, // Singapore
  1956, // Slovakia
  1965, // Slovenia
  1974, // SolomonIslands
  1989, // Somalia
  1997, // SouthAfrica
  2009, // SouthGeorgiaAndTheSouthSandwichIslands
  2048, // Spain
  2054, // SriLanka
  2063, // StHelena
  2072, // StPierreAndMiquelon
  2092, // Sudan
  2098, // Suriname
  2107, // SvalbardAndJanMayenIslands
  2134, // Swaziland
  2144, // Sweden
  2151, // Switzerland
  2163, // SyrianArabRepublic
  2182, // Taiwan
  2189, // Tajikistan
  2200, // Tanzania
  2209, // Thailand
  2218, // Togo
  2223, // Tokelau
  2231, // Tonga
  2237, // TrinidadAndTobago
  2255, // Tunisia
  2263, // Turkey
  2270, // Turkmenistan
  2283, // TurksAndCaicosIslands
  2305, // Tuvalu
  2312, // Uganda
  2319, // Ukraine
  2327, // UnitedArabEmirates
  2346, // UnitedKingdom
  2360, // UnitedStates
  2373, // UnitedStatesMinorOutlyingIslands
  2406, // Uruguay
  2414, // Uzbekistan
  2425, // Vanuatu
  2433, // VaticanCityState
  2450, // Venezuela
  2460, // VietNam
  2468, // BritishVirginIslands
  2489, // USVirginIslands
  2505, // WallisAndFutunaIslands
  2528, // WesternSahara
  2542, // Yemen
  2548, // Yugoslavia
  2559, // Zambia
  2566, // Zimbabwe
  2575, // SerbiaAndMontenegro
  2595, // Montenegro
  2606, // Serbia
  2613, // Saint Barthelemy
  2630, // Saint Martin
  2643, // LatinAmericaAndTheCaribbean
};

static const unsigned char language_code_list[] =
"  \0" // AnyLanguage
"  \0" // C
"ab\0" // Abkhazian
"om\0" // Afan
"aa\0" // Afar
"af\0" // Afrikaans
"sq\0" // Albanian
"am\0" // Amharic
"ar\0" // Arabic
"hy\0" // Armenian
"as\0" // Assamese
"ay\0" // Aymara
"az\0" // Azerbaijani
"ba\0" // Bashkir
"eu\0" // Basque
"bn\0" // Bengali
"dz\0" // Bhutani
"bh\0" // Bihari
"bi\0" // Bislama
"br\0" // Breton
"bg\0" // Bulgarian
"my\0" // Burmese
"be\0" // Byelorussian
"km\0" // Cambodian
"ca\0" // Catalan
"zh\0" // Chinese
"co\0" // Corsican
"hr\0" // Croatian
"cs\0" // Czech
"da\0" // Danish
"nl\0" // Dutch
"en\0" // English
"eo\0" // Esperanto
"et\0" // Estonian
"fo\0" // Faroese
"fj\0" // Fiji
"fi\0" // Finnish
"fr\0" // French
"fy\0" // Frisian
"gd\0" // Gaelic
"gl\0" // Galician
"ka\0" // Georgian
"de\0" // German
"el\0" // Greek
"kl\0" // Greenlandic
"gn\0" // Guarani
"gu\0" // Gujarati
"ha\0" // Hausa
"he\0" // Hebrew
"hi\0" // Hindi
"hu\0" // Hungarian
"is\0" // Icelandic
"id\0" // Indonesian
"ia\0" // Interlingua
"ie\0" // Interlingue
"iu\0" // Inuktitut
"ik\0" // Inupiak
"ga\0" // Irish
"it\0" // Italian
"ja\0" // Japanese
"jv\0" // Javanese
"kn\0" // Kannada
"ks\0" // Kashmiri
"kk\0" // Kazakh
"rw\0" // Kinyarwanda
"ky\0" // Kirghiz
"ko\0" // Korean
"ku\0" // Kurdish
"rn\0" // Rundi
"lo\0" // Laothian
"la\0" // Latin
"lv\0" // Latvian
"ln\0" // Lingala
"lt\0" // Lithuanian
"mk\0" // Macedonian
"mg\0" // Malagasy
"ms\0" // Malay
"ml\0" // Malayalam
"mt\0" // Maltese
"mi\0" // Maori
"mr\0" // Marathi
"mo\0" // Moldavian
"mn\0" // Mongolian
"na\0" // Nauru
"ne\0" // Nepali
"nb\0" // Norwegian
"oc\0" // Occitan
"or\0" // Oriya
"ps\0" // Pashto
"fa\0" // Persian
"pl\0" // Polish
"pt\0" // Portuguese
"pa\0" // Punjabi
"qu\0" // Quechua
"rm\0" // RhaetoRomance
"ro\0" // Romanian
"ru\0" // Russian
"sm\0" // Samoan
"sg\0" // Sangho
"sa\0" // Sanskrit
"sr\0" // Serbian
"sh\0" // SerboCroatian
"st\0" // Sesotho
"tn\0" // Setswana
"sn\0" // Shona
"sd\0" // Sindhi
"si\0" // Singhalese
"ss\0" // Siswati
"sk\0" // Slovak
"sl\0" // Slovenian
"so\0" // Somali
"es\0" // Spanish
"su\0" // Sundanese
"sw\0" // Swahili
"sv\0" // Swedish
"tl\0" // Tagalog
"tg\0" // Tajik
"ta\0" // Tamil
"tt\0" // Tatar
"te\0" // Telugu
"th\0" // Thai
"bo\0" // Tibetan
"ti\0" // Tigrinya
"to\0" // Tonga
"ts\0" // Tsonga
"tr\0" // Turkish
"tk\0" // Turkmen
"tw\0" // Twi
"ug\0" // Uigur
"uk\0" // Ukrainian
"ur\0" // Urdu
"uz\0" // Uzbek
"vi\0" // Vietnamese
"vo\0" // Volapuk
"cy\0" // Welsh
"wo\0" // Wolof
"xh\0" // Xhosa
"yi\0" // Yiddish
"yo\0" // Yoruba
"za\0" // Zhuang
"zu\0" // Zulu
"nn\0" // Nynorsk
"bs\0" // Bosnian
"dv\0" // Divehi
"gv\0" // Manx
"kw\0" // Cornish
"ak\0" // Akan
"kok" // Konkani
"gaa" // Ga
"ig\0" // Igbo
"kam" // Kamba
"syr" // Syriac
"byn" // Blin
"gez" // Geez
"kfo" // Koro
"sid" // Sidamo
"cch" // Atsam
"tig" // Tigre
"kaj" // Jju
"fur" // Friulian
"ve\0" // Venda
"ee\0" // Ewe
"wal" // Walamo
"haw" // Hawaiian
"kcg" // Tyap
"ny\0" // Chewa
"fil" // Filipino
"gsw" // Swiss German
"ii\0" // Sichuan Yi
"kpe" // Kpelle
"nds" // Low German
"nr\0" // South Ndebele
"nso" // Northern Sotho
"se\0" // Northern Sami
"trv" // Taroko
"guz" // Gusii
"dav" // Taita
"ff\0" // Fulah
"ki\0" // Kikuyu
"saq" // Samburu
"seh" // Sena
"nd\0" // North Ndebele
"rof" // Rombo
"shi" // Tachelhit
"kab" // Kabyle
"nyn" // Nyankole
"bez" // Bena
"vun" // Vunjo
"bm\0" // Bambara
"ebu" // Embu
"chr" // Cherokee
"mfe" // Morisyen
"kde" // Makonde
"lag" // Langi
"lg\0" // Ganda
"bem" // Bemba
"kea" // Kabuverdianu
"mer" // Meru
"kln" // Kalenjin
"naq" // Nama
"jmc" // Machame
"ksh" // Colognian
"mas" // Masai
"xog" // Soga
"luy" // Luyia
"asa" // Asu
"teo" // Teso
"ssy" // Saho
"khq" // Koyra Chiini
"rwk" // Rwa
"luo" // Luo
"cgg" // Chiga
"tzm" // Central Morocco Tamazight
"ses" // Koyraboro Senni
"ksb" // Shambala
"brx" // Bodo
"agq" // Aghem
"bas" // Basaa
"dje" // Zarma
"dua" // Duala
"dyo" // JolaFonyi
"ewo" // Ewondo
"ksf" // Bafia
"lu\0" // LubaKatanga
"mgh" // MakhuwaMeetto
"mua" // Mundang
"nmg" // Kwasio
"nus" // Nuer
"sah" // Sakha
"sbp" // Sangu
"swc" // Congo Swahili
"twq" // Tasawaq
"vai" // Vai
"wae" // Walser
"yav" // Yangben
;

static const unsigned char script_code_list[] =
"\0\0\0\0" // AnyScript
"Arab" // Arabic
"Cyrl" // Cyrillic
"Dsrt" // Deseret
"Guru" // Gurmukhi
"Hans" // Simplified Han
"Hant" // Traditional Han
"Latn" // Latin
"Mong" // Mongolian
"Tfng" // Tifinagh
;
static const unsigned char country_code_list[] =
"  \0" // AnyCountry
"AF\0" // Afghanistan
"AL\0" // Albania
"DZ\0" // Algeria
"AS\0" // AmericanSamoa
"AD\0" // Andorra
"AO\0" // Angola
"AI\0" // Anguilla
"AQ\0" // Antarctica
"AG\0" // AntiguaAndBarbuda
"AR\0" // Argentina
"AM\0" // Armenia
"AW\0" // Aruba
"AU\0" // Australia
"AT\0" // Austria
"AZ\0" // Azerbaijan
"BS\0" // Bahamas
"BH\0" // Bahrain
"BD\0" // Bangladesh
"BB\0" // Barbados
"BY\0" // Belarus
"BE\0" // Belgium
"BZ\0" // Belize
"BJ\0" // Benin
"BM\0" // Bermuda
"BT\0" // Bhutan
"BO\0" // Bolivia
"BA\0" // BosniaAndHerzegowina
"BW\0" // Botswana
"BV\0" // BouvetIsland
"BR\0" // Brazil
"IO\0" // BritishIndianOceanTerritory
"BN\0" // BruneiDarussalam
"BG\0" // Bulgaria
"BF\0" // BurkinaFaso
"BI\0" // Burundi
"KH\0" // Cambodia
"CM\0" // Cameroon
"CA\0" // Canada
"CV\0" // CapeVerde
"KY\0" // CaymanIslands
"CF\0" // CentralAfricanRepublic
"TD\0" // Chad
"CL\0" // Chile
"CN\0" // China
"CX\0" // ChristmasIsland
"CC\0" // CocosIslands
"CO\0" // Colombia
"KM\0" // Comoros
"CD\0" // DemocraticRepublicOfCongo
"CG\0" // PeoplesRepublicOfCongo
"CK\0" // CookIslands
"CR\0" // CostaRica
"CI\0" // IvoryCoast
"HR\0" // Croatia
"CU\0" // Cuba
"CY\0" // Cyprus
"CZ\0" // CzechRepublic
"DK\0" // Denmark
"DJ\0" // Djibouti
"DM\0" // Dominica
"DO\0" // DominicanRepublic
"TL\0" // EastTimor
"EC\0" // Ecuador
"EG\0" // Egypt
"SV\0" // ElSalvador
"GQ\0" // EquatorialGuinea
"ER\0" // Eritrea
"EE\0" // Estonia
"ET\0" // Ethiopia
"FK\0" // FalklandIslands
"FO\0" // FaroeIslands
"FJ\0" // Fiji
"FI\0" // Finland
"FR\0" // France
"FX\0" // MetropolitanFrance
"GF\0" // FrenchGuiana
"PF\0" // FrenchPolynesia
"TF\0" // FrenchSouthernTerritories
"GA\0" // Gabon
"GM\0" // Gambia
"GE\0" // Georgia
"DE\0" // Germany
"GH\0" // Ghana
"GI\0" // Gibraltar
"GR\0" // Greece
"GL\0" // Greenland
"GD\0" // Grenada
"GP\0" // Guadeloupe
"GU\0" // Guam
"GT\0" // Guatemala
"GN\0" // Guinea
"GW\0" // GuineaBissau
"GY\0" // Guyana
"HT\0" // Haiti
"HM\0" // HeardAndMcDonaldIslands
"HN\0" // Honduras
"HK\0" // HongKong
"HU\0" // Hungary
"IS\0" // Iceland
"IN\0" // India
"ID\0" // Indonesia
"IR\0" // Iran
"IQ\0" // Iraq
"IE\0" // Ireland
"IL\0" // Israel
"IT\0" // Italy
"JM\0" // Jamaica
"JP\0" // Japan
"JO\0" // Jordan
"KZ\0" // Kazakhstan
"KE\0" // Kenya
"KI\0" // Kiribati
"KP\0" // DemocraticRepublicOfKorea
"KR\0" // RepublicOfKorea
"KW\0" // Kuwait
"KG\0" // Kyrgyzstan
"LA\0" // Lao
"LV\0" // Latvia
"LB\0" // Lebanon
"LS\0" // Lesotho
"LR\0" // Liberia
"LY\0" // LibyanArabJamahiriya
"LI\0" // Liechtenstein
"LT\0" // Lithuania
"LU\0" // Luxembourg
"MO\0" // Macau
"MK\0" // Macedonia
"MG\0" // Madagascar
"MW\0" // Malawi
"MY\0" // Malaysia
"MV\0" // Maldives
"ML\0" // Mali
"MT\0" // Malta
"MH\0" // MarshallIslands
"MQ\0" // Martinique
"MR\0" // Mauritania
"MU\0" // Mauritius
"YT\0" // Mayotte
"MX\0" // Mexico
"FM\0" // Micronesia
"MD\0" // Moldova
"MC\0" // Monaco
"MN\0" // Mongolia
"MS\0" // Montserrat
"MA\0" // Morocco
"MZ\0" // Mozambique
"MM\0" // Myanmar
"NA\0" // Namibia
"NR\0" // Nauru
"NP\0" // Nepal
"NL\0" // Netherlands
"AN\0" // NetherlandsAntilles
"NC\0" // NewCaledonia
"NZ\0" // NewZealand
"NI\0" // Nicaragua
"NE\0" // Niger
"NG\0" // Nigeria
"NU\0" // Niue
"NF\0" // NorfolkIsland
"MP\0" // NorthernMarianaIslands
"NO\0" // Norway
"OM\0" // Oman
"PK\0" // Pakistan
"PW\0" // Palau
"PS\0" // PalestinianTerritory
"PA\0" // Panama
"PG\0" // PapuaNewGuinea
"PY\0" // Paraguay
"PE\0" // Peru
"PH\0" // Philippines
"PN\0" // Pitcairn
"PL\0" // Poland
"PT\0" // Portugal
"PR\0" // PuertoRico
"QA\0" // Qatar
"RE\0" // Reunion
"RO\0" // Romania
"RU\0" // RussianFederation
"RW\0" // Rwanda
"KN\0" // SaintKittsAndNevis
"LC\0" // StLucia
"VC\0" // StVincentAndTheGrenadines
"WS\0" // Samoa
"SM\0" // SanMarino
"ST\0" // SaoTomeAndPrincipe
"SA\0" // SaudiArabia
"SN\0" // Senegal
"SC\0" // Seychelles
"SL\0" // SierraLeone
"SG\0" // Singapore
"SK\0" // Slovakia
"SI\0" // Slovenia
"SB\0" // SolomonIslands
"SO\0" // Somalia
"ZA\0" // SouthAfrica
"GS\0" // SouthGeorgiaAndTheSouthSandwichIslands
"ES\0" // Spain
"LK\0" // SriLanka
"SH\0" // StHelena
"PM\0" // StPierreAndMiquelon
"SD\0" // Sudan
"SR\0" // Suriname
"SJ\0" // SvalbardAndJanMayenIslands
"SZ\0" // Swaziland
"SE\0" // Sweden
"CH\0" // Switzerland
"SY\0" // SyrianArabRepublic
"TW\0" // Taiwan
"TJ\0" // Tajikistan
"TZ\0" // Tanzania
"TH\0" // Thailand
"TG\0" // Togo
"TK\0" // Tokelau
"TO\0" // Tonga
"TT\0" // TrinidadAndTobago
"TN\0" // Tunisia
"TR\0" // Turkey
"TM\0" // Turkmenistan
"TC\0" // TurksAndCaicosIslands
"TV\0" // Tuvalu
"UG\0" // Uganda
"UA\0" // Ukraine
"AE\0" // UnitedArabEmirates
"GB\0" // UnitedKingdom
"US\0" // UnitedStates
"UM\0" // UnitedStatesMinorOutlyingIslands
"UY\0" // Uruguay
"UZ\0" // Uzbekistan
"VU\0" // Vanuatu
"VA\0" // VaticanCityState
"VE\0" // Venezuela
"VN\0" // VietNam
"VG\0" // BritishVirginIslands
"VI\0" // USVirginIslands
"WF\0" // WallisAndFutunaIslands
"EH\0" // WesternSahara
"YE\0" // Yemen
"YU\0" // Yugoslavia
"ZM\0" // Zambia
"ZW\0" // Zimbabwe
"CS\0" // SerbiaAndMontenegro
"ME\0" // Montenegro
"RS\0" // Serbia
"BL\0" // Saint Barthelemy
"MF\0" // Saint Martin
"419" // LatinAmericaAndTheCaribbean
;

// GENERATED PART ENDS HERE

QT_END_NAMESPACE

#endif
